
/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 7/14/2011 IMAGE_THUMBNAIL_CHKBOX_CRASH									*
 * Sen 08/01/2011 ORG-2629-P5 NO_LAST_USED_THEME_CREATED_AFTER_USING			*
 * Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT							*
 * Sen 08/03/2011 ORG-2629-P7 TO_FIX_DO_NOT_UPDATE_COL_DESIGN                   *
 * Sen 08/03/2011 ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX						*
 * Sen 08/05/2011 ORG-2629-S7 ADD_TO_ACTIVE_BUTTON_SHOULD_BE_HIDDEN				*
 * Sen 08/05/2011 ORG-2629-S6 REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE   *
 * Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME				*
 * Sen 08/08/2011 ORG-2629-P9 TO_FIX_DO_NOT_UPDATE_COL_DESIGN_FOR_GROUP_COL		*
 * Bill 08/08/2011 ORG-3396 BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE*
 * Sen 08/11/2011 ORG-3450-S1 ADJUST_ROW_HEADER_TO_SEE_FULL_TEXT				*
 * Kyle 08/11/2011 ORG-2574-S5 ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET
 * Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT					*
 * Sen 08/024/2011 ORG-3450-S3 ONLY_SHOW_COLUMN_DESIGNATION						*
 *	Folger 11/12/2011 ORG-3273-P2 NEW_WORKSHEET_DLG_WRONG_DIALOG_THEME			*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include <Array.h>
#include <ocu.h>
#include "NewWorkBookDlg.h"
#include "WksColLabels.h"		///Kyle 08/11/2011 ORG-2574-S5 ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.



////////////////////////////////////////////////////////////////////////////////////
// Start NewWorkBookDlg class functions here.
#define STR_DLG_NAME 					"New Workbook Dlg"
enum
{
	COLUMNS_MODE_SINGLE,
	COLUMNS_MODE_GROUPED
};

#define	STR_NEW_WORKBOOK_THEME_OPTION	"NewWorkbook"

#define	MAX_COL_DESIG_NUM				14
#define CONTROL_GAP						10///	Sen 08/024/2011 ORG-3450-S3 ONLY_SHOW_COLUMN_DESIGNATION

///Kyle 08/11/2011 ORG-2574-S5 ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET
/*
/// Bill 08/08/2011 ORG-3396 BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE
static int _get_wks_row_label_index(Grid & grid, int nLabelRowType, int * pnLabelRows = NULL)
{
	vector<int> vn;
	grid.GetShowLabels(vn);
	
	vector<uint> vnFound;
	vn.Find(MATREPL_TEST_EQUAL, nLabelRowType, vnFound);
	
	int nRow;	
	if (vnFound.GetSize() > 0)
		nRow = vnFound[0];
	else
		nRow = -1;

	if (pnLabelRows != NULL)
		*pnLabelRows = vn.GetSize();

	return nRow;
}
/// End BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE
*/
///End ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
////////////////// Dialog related ///////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

BOOL NewWorkBookDlg::OnInitDialog()
{
	ResizeDialog::OnInitDialog(IDC_STATIC_BLANK_WORKBOOK, STR_DLG_NAME);
	
	initControls();
	
	moveGroupedColumnsControls();	
	
	return true;
}


BOOL NewWorkBookDlg::OnReady()
{
	return true;
}

/// Sen 08/01/2011 ORG-2629-P5 NO_LAST_USED_THEME_CREATED_AFTER_USING	
BOOL NewWorkBookDlg::OnAfterApply()
{
	Tree trSettings;
	saveSettings(trSettings);
	m_themeHelper.SaveLastUsedTheme(trSettings);
	return TRUE;
}
/// End NO_LAST_USED_THEME_CREATED_AFTER_USING

/// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
BOOL NewWorkBookDlg::OnCreateSamplePlot(Control cntrl)
{
	showHidePlotTypeDropdown();
	return TRUE;
}
/// End PROVIDE_OPTION_TO_CREATE_PLOT

BOOL NewWorkBookDlg::OnOK(Control cntrl)
{
	return doNewWorkbook() && OnAfterApply();		
}

bool NewWorkBookDlg::initColorTextControl(int nID, ColorText& ctrlColor)
{
	Control ctrlTemp = GetItem(nID);
	if( ctrlTemp )
	{
		ctrlColor.CreateControl(ctrlTemp.GetSafeHwnd());
		
		ctrlColor.SetTxtColor(RGB(0, 0, 255));	
		int nStyle = GetWindowLong(ctrlColor.GetSafeHwnd(), GWL_STYLE);
		O_SET_BIT(nStyle, WS_BORDER, false);
		SetWindowLong(ctrlColor.GetSafeHwnd(), GWL_STYLE, nStyle);
		return true;
	}
	return error_report("fail to create resource control");
}

void NewWorkBookDlg::initControls()
{	
	m_cbColDesig = GetItem(IDC_COMBO_COLUMN_DESIGATION);	
	m_cbColDesig.SetCurSel(0);
	m_cbColDesig.GetLBText(m_cbColDesig.GetCurSel(), m_strRawColDesig);
	///Sophy 7/26/2011 ORG-3333-S1 OC_EDIT_CONTROL_NEED_CONTENT_FILTER
	m_cbGroups.SetContentFilter(CF_INTEGER);
	///end OC_EDIT_CONTROL_NEED_CONTENT_FILTER
	m_cbGroups = GetItem(IDC_COMBO_NUMBER_OF_GROUPS);
	/// Sen 08/05/2011 ORG-2629-S6 REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
	//m_cbGroups.Text = 1;
	m_cbGroups.Text = 2;
	/// End REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
	///Sophy 7/26/2011 ORG-3333-S1 OC_EDIT_CONTROL_NEED_CONTENT_FILTER
	m_cbReplica.SetContentFilter(CF_INTEGER);
	///end OC_EDIT_CONTROL_NEED_CONTENT_FILTER	m_cbReplica.Text = 1;
	m_cbReplica = GetItem(IDC_COMBO_NUMBER_OF_REPLICATE);
	/// Sen 08/05/2011 ORG-2629-S6 REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
	//m_cbReplica.Text = 1;
	m_cbReplica.Text = 2;
	/// End REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
	
	/// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
	GetItem(IDC_CHECK_CREATE_RANDOM_SAMPLE_PLOT).Visible = FALSE;
	m_cbPlotType = GetItem(IDC_COMBO_PLOT_TYPE);
	m_cbPlotType.SetCurSel(1);
	/// End PROVIDE_OPTION_TO_CREATE_PLOT

	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	m_chkAddToActive = GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW);
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	
	//init hits in first tab
	initColorTextControl(IDC_STATIC_COLDESIG_HINT, m_ctHint);
	string	strText;
	ocu_load_err_msg_str(MSG_NEW_WORKBOOK_HINT, &strText);
	m_ctHint.Text = strText;

	/// Sen 08/03/2011 ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX
	Worksheet wks = Project.ActiveLayer();
	if(!wks)
		/// Sen 08/05/2011 ORG-2629-S7 ADD_TO_ACTIVE_BUTTON_SHOULD_BE_HIDDEN
		//GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW).Enable = 0;
		GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW).Visible = false;
		/// End ADD_TO_ACTIVE_BUTTON_SHOULD_BE_HIDDEN
	/// End	ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX

	initColorTextControl(IDC_STATIC_NUM_COLS, m_ctNumCols);
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	//	updateNumberColumnControl();
	///	End FAIL_TO_SAVE_AS_DEFAULT
	
	initColorTextControl(IDC_STATIC_GROUPED_COL_DESIG, m_ctColDesig);
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	//updateColDesigControl();
	//m_rdNewWithSingleCols = GetItem(IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS);
	//m_rdNewWithGroupedCols = GetItem(IDC_RADIO_NEW_WBOOK_WITH_GROUPED_COLUMNS);
	///	End FAIL_TO_SAVE_AS_DEFAULT
	
	CheckRadioButton(IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS, IDC_RADIO_NEW_WBOOK_WITH_GROUPED_COLUMNS, IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS);
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	//onColumnsModeChange();
	///	End FAIL_TO_SAVE_AS_DEFAULT	
	///Sophy 7/22/2011 ORG-2629 FILE_NEW_WORKBOOK_DLG
	Tree trSettings;
	saveSettings(trSettings);
	m_themeHelper.Init(this, IDC_COMBO_SHEET_THEME, IDC_SHEET_THEME_SAVE_AS, trSettings);
	///end FILE_NEW_WORKBOOK_DLG
	
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	loadSettings(trSettings);
	onColumnsModeChange();
	
	m_strNumGroups = m_cbGroups.Text;
	m_strNumReplica = m_cbGroups.Text;
	
	if(getColumnConstructType()  == COLUMNS_MODE_SINGLE)
	{
		ColDesigEditChanged();
		updateColDesigControl();
	}
	///	End FAIL_TO_SAVE_AS_DEFAULT	
	
	///	Sen 08/024/2011 ORG-3450-S3 ONLY_SHOW_COLUMN_DESIGNATION
	onlyShowSingleColumnsControls();
	resizeDlg();
	/// End ONLY_SHOW_COLUMN_DESIGNATION
}


///	Sen 08/024/2011 ORG-3450-S3 ONLY_SHOW_COLUMN_DESIGNATION
void NewWorkBookDlg::resizeDlg()
{
	RECT rCancel;	
	GetControlClientRect(IDCANCEL, rCancel);
	RECT rDlg;	
	m_wndDlg.GetWindowRect(&rDlg);
	m_wndDlg.ScreenToClient(&rDlg);
	rDlg.right = rCancel.right + CONTROL_GAP;
	rDlg.bottom = rCancel.bottom + CONTROL_GAP;
	m_wndDlg.ClientToScreen(&rDlg);		
	m_wndDlg.MoveWindow(&rDlg, true);
}

void NewWorkBookDlg::onlyShowSingleColumnsControls()
{
	
	vector<uint> vnIDsToHide = {
		IDC_STATIC_BLANK_WORKBOOK,
		IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS,
		IDC_RADIO_NEW_WBOOK_WITH_GROUPED_COLUMNS
	};		
	ShowControls(vnIDsToHide, false);
	
	RECT rSingleColRadioBtn, rColDesigLabel;
	GetControlClientRect(IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS, rSingleColRadioBtn);
	GetControlClientRect(IDC_STATIC_COL_DESIGATION, rColDesigLabel);
	int nYOffset = rSingleColRadioBtn.top - rColDesigLabel.top;
	vector<uint> vnIDsToMove = {
		IDC_STATIC_COL_DESIGATION,
		IDC_COMBO_COLUMN_DESIGATION,
		IDC_STATIC_NUM_COLS,
		IDC_STATIC_COLDESIG_HINT,
		0
	};
	MoveControls(vnIDsToMove, 0, nYOffset);
	
	RECT rColDesigHint, rCancel;
	GetControlClientRect(IDC_STATIC_COLDESIG_HINT, rColDesigHint);
	GetControlClientRect(IDCANCEL, rCancel);
	nYOffset = rColDesigHint.bottom - rCancel.top + CONTROL_GAP * 2;
	vector<uint> vnIDsToMove2 = {
		IDC_CHECK_ADD_TO_ACTIVE_WINDOW,
		IDOK,
		IDCANCEL,
		0
	};
	MoveControls(vnIDsToMove2, 0, nYOffset);
}
///	End ONLY_SHOW_COLUMN_DESIGNATION

void NewWorkBookDlg::moveGroupedColumnsControls()
{	
	vector<uint> vnSingleColumnsControls, vnGroupedColumnsControls;
	getControlIDsByColumnsMode(vnSingleColumnsControls, COLUMNS_MODE_SINGLE);
	getControlIDsByColumnsMode(vnGroupedColumnsControls, COLUMNS_MODE_GROUPED);
	
	RECT rrFirstInSingleColumns, rrSecondInGroupedColumns;
	GetControlClientRect(vnSingleColumnsControls[0], rrFirstInSingleColumns);
	GetControlClientRect(vnGroupedColumnsControls[0], rrSecondInGroupedColumns);
	int nX = rrFirstInSingleColumns.left - rrSecondInGroupedColumns.left;
	int nY = rrFirstInSingleColumns.top - rrSecondInGroupedColumns.top;
	MoveControls(vnGroupedColumnsControls, nX, nY);
}

BOOL NewWorkBookDlg::OnColDesigSelectChanged(Control ctrl)
{	
	int nCurSel = m_cbColDesig.GetCurSel();
	if( nCurSel >= 0 )
	{
		m_cbColDesig.GetLBText(nCurSel, m_strRawColDesig);
		updateNumberColumnControl();
	}
	
	m_themeHelper.OnDlgSettingChange();
	return TRUE;
}
///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
BOOL NewWorkBookDlg::ColDesigEditChanged()
{
	m_strRawColDesig = m_cbColDesig.Text;
	updateNumberColumnControl();
	return TRUE;
}
/// End FAIL_TO_SAVE_AS_DEFAULT

BOOL NewWorkBookDlg::OnColDesigEditChanged(Control ctrl)
{
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	/*
	m_strRawColDesig = m_cbColDesig.Text;
	updateNumberColumnControl();
	*/
	ColDesigEditChanged();
	/// End FAIL_TO_SAVE_AS_DEFAULT
	m_themeHelper.OnDlgSettingChange();
	
	return TRUE;
}

BOOL NewWorkBookDlg::OnGroupSelectChanged(Control ctrl)
{
	return onGroupOrReplicaSelectChange(m_cbGroups, m_strNumGroups, m_cbReplica, m_strNumReplica);
}

BOOL NewWorkBookDlg::OnGroupEditChanged(Control ctrl)
{
	return onGroupOrReplicaEditChange(m_cbGroups, m_strNumGroups, m_cbReplica, m_strNumReplica);	
}

BOOL NewWorkBookDlg::OnReplicaSelectChanged(Control ctrl)
{
	return onGroupOrReplicaSelectChange(m_cbReplica, m_strNumReplica, m_cbGroups, m_strNumGroups);
}

BOOL NewWorkBookDlg::OnReplicaEditChanged(Control ctrl)
{
	return onGroupOrReplicaEditChange(m_cbReplica, m_strNumReplica, m_cbGroups, m_strNumGroups);	
}

BOOL NewWorkBookDlg::onGroupOrReplicaSelectChange(ComboBox &cbSel, string &strSel, ComboBox &cbAnother, string &strAnother)
{
	int nCurSel = cbSel.GetCurSel();
	cbSel.GetLBText(nCurSel, strSel);	
	strAnother = cbAnother.Text;

	updateColDesigControl();	
	m_themeHelper.OnDlgSettingChange();
	return TRUE;	
}

BOOL NewWorkBookDlg::onGroupOrReplicaEditChange(ComboBox &cbSel, string &strSel, ComboBox &cbAnother, string &strAnother)
{
	strSel = cbSel.Text;
	strAnother = cbAnother.Text;
	updateColDesigControl();	
	m_themeHelper.OnDlgSettingChange();
	return TRUE;	
}
	
BOOL NewWorkBookDlg::OnThemeSaveButtonClick(Control ctrl)
{
	Tree trSettings;
	saveSettings(trSettings);

	bool bLoading;
	m_themeHelper.ShowPopupMenu(GetSafeHwnd(), trSettings, trSettings, bLoading);	
	if( bLoading )
	{
		m_themeHelper.SetChangeEventReady(false);
		loadSettings(trSettings);
	
		/// Sen 08/08/2011 ORG-2629-P9 TO_FIX_DO_NOT_UPDATE_COL_DESIGN_FOR_GROUP_COL
		m_strNumGroups = m_cbGroups.Text;
		m_strNumReplica = m_cbReplica.Text;
		getTargetColDesigForGroupColumns();
		/// End TO_FIX_DO_NOT_UPDATE_COL_DESIGN_FOR_GROUP_COL
		
		m_themeHelper.SetChangeEventReady(true);
		/// Sen 08/03/2011 ORG-2629-P7 TO_FIX_DO_NOT_UPDATE_COL_DESIGN
		ColDesigEditChanged();
		updateColDesigControl();
		/// End TO_FIX_DO_NOT_UPDATE_COL_DESIGN
		onColumnsModeChange();
	}
	
	return TRUE;
}

BOOL NewWorkBookDlg::OnColumnTypeRadioButtonClicked(Control cntrl)
{
	onColumnsModeChange();
	return TRUE;
}

void NewWorkBookDlg::updateNumberColumnControl()
{
	if( m_ctNumCols )
	{
		if( 0 == getTargetColDesigForIndividualColumns() ) // no err
			m_ctNumCols.Text = (string)m_strTargetColDesig.GetLength();
		else
			m_ctNumCols.Text = "--";
	}
}

/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
BOOL NewWorkBookDlg::OnAddToActiveButtonClicked(Control cntrl)
{
	m_themeHelper.OnDlgSettingChange();
	return TRUE;
}
/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME

#define	HINT_BUFFER_SIZE	(MAX_COL_DESIG_NUM + 5)
void NewWorkBookDlg::updateColDesigControl()
{
	if( m_ctColDesig )
	{
		getTargetColDesigForGroupColumns(MAX_COL_DESIG_NUM);
	
		char szText[HINT_BUFFER_SIZE];
		string strEx = "...";
		ASSERT(MAX_COL_DESIG_NUM + strEx.GetLength() < HINT_BUFFER_SIZE);
		
		if( m_strTargetColDesig.GetLength() > MAX_COL_DESIG_NUM )
		{
			strncpy(szText, m_strTargetColDesig, MAX_COL_DESIG_NUM);
			strcat(szText, strEx);
		}
		else
		{
			strcpy(szText, m_strTargetColDesig);
		}
		
		m_ctColDesig.Text = szText;	
	}
}

void NewWorkBookDlg::getControlIDsByColumnsMode(vector<uint>& vnIDs, int nColumnsMode)
{
	const vector<uint> vnSingleColumnsControls = {
		IDC_STATIC_COL_DESIGATION,
		IDC_COMBO_COLUMN_DESIGATION,
		IDC_STATIC_NUM_COLS,
		IDC_STATIC_COLDESIG_HINT,
		0
	};
	
	const vector<uint> vnGroupedColumnsControls = {
		IDC_STATIC_NUM_GROUPS,
		IDC_COMBO_NUMBER_OF_GROUPS,
		IDC_STATIC_REPLICATE_IN_GROUP,
		IDC_COMBO_NUMBER_OF_REPLICATE,
		IDC_STATIC_GROUPED_COL_DESIG,
		/// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
		//IDC_CHECK_CREATE_RANDOM_SAMPLE_PLOT,
		//IDC_COMBO_PLOT_TYPE,
		/// End PROVIDE_OPTION_TO_CREATE_PLOT
		0
	};	
	
	if( nColumnsMode == COLUMNS_MODE_SINGLE )
		vnIDs = vnSingleColumnsControls;
	else
		vnIDs = vnGroupedColumnsControls;
}

void NewWorkBookDlg::onColumnsModeChange()
{
	vector<uint> vnSingleColumnsControls, vnGroupedColumnsControls;
	getControlIDsByColumnsMode(vnSingleColumnsControls, COLUMNS_MODE_SINGLE);
	getControlIDsByColumnsMode(vnGroupedColumnsControls, COLUMNS_MODE_GROUPED);
	
	Button btnSingleColumns = GetItem(IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS);
	ShowControls(vnSingleColumnsControls, btnSingleColumns.Value == 1 );
	ShowControls(vnGroupedColumnsControls, btnSingleColumns.Value != 1);

	showHidePlotTypeDropdown(); /// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
	
	/// Sen 08/05/2011 ORG-2629-S6 REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
	reSizeColumnModeBlank();
	/// End REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
}

/// Sen 08/05/2011 ORG-2629-S6 REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
void NewWorkBookDlg::reSizeColumnModeBlank()
{
	Control cColumnModeBlank = GetItem( IDC_STATIC_BLANK_WORKBOOK );
	
	RECT rBlankWorkbook;
	GetControlClientRect(IDC_STATIC_BLANK_WORKBOOK, rBlankWorkbook);
		
	Button btnSingleColumns = GetItem(IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS);
	if(btnSingleColumns.Value == 1)
	{
		RECT rSingleModeRBItem;
		GetControlClientRect(IDC_STATIC_COLDESIG_HINT, rSingleModeRBItem);
		rBlankWorkbook.right = rSingleModeRBItem.right + GetControlGap();
		rBlankWorkbook.bottom = rSingleModeRBItem.bottom + GetControlGap();
	}
	else
	{
		RECT rGroupModeRightItem, rGroupModeBottonItem;
		GetControlClientRect(IDC_COMBO_NUMBER_OF_GROUPS, rGroupModeRightItem);
		GetControlClientRect(IDC_STATIC_GROUPED_COL_DESIG, rGroupModeBottonItem);
		rBlankWorkbook.right = rGroupModeRightItem.right + GetControlGap();
		rBlankWorkbook.bottom = rGroupModeBottonItem.bottom + GetControlGap();
	}

	MoveControl(cColumnModeBlank, rBlankWorkbook);
}
/// End REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE

bool NewWorkBookDlg::doNewWorkbook()
{
	if ( 0 == getTargetColDesig() )
	{
		return createPage();
	}
	return false;
}

int		NewWorkBookDlg::getColumnConstructType()	
{
	return GetCheckedRadioButton(IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS, IDC_RADIO_NEW_WBOOK_WITH_GROUPED_COLUMNS) - IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS;
}

/// Bill 08/08/2011 ORG-3396 BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE
void 	NewWorkBookDlg::setColumnsShortName(Worksheet & wks, vector<int> & vnXCols)
{
	int nXCols = vnXCols.GetSize();
	int nYCols = wks.GetNumCols() / nXCols - 1;
	
	for (int i = 0 ; i < nXCols ; ++i)
	{
		char cSN = 'A' + i;
		
		// X Column
		string strXSN;
		strXSN.Format("%c", cSN);
		wks.Columns(vnXCols[i]).SetName(strXSN);

		// Y Columns
		string strSN;
		for (int j = 0 ; j < nYCols ; ++j)
		{
			strSN.Format("%c%d", cSN, j + 1);
			wks.Columns(vnXCols[i] + j + 1).SetName(strSN);
		}
	}
}

void NewWorkBookDlg::setGroupIdRowColor(Grid & grid, int nReplicateRow)
{
	if (nReplicateRow == -1)
		return;
	
	DWORD dwYellow = RGB2OCOLOR(COLOR_LTYELLOW);
	for (int nCol = 0 ; nCol < grid.Cols ; ++nCol)
	{
		grid.CellBkColor(dwYellow, nReplicateRow, nCol, FALSE, TRUE);
	}
}

void	NewWorkBookDlg::mergerGroupIdRow(Grid & grid, vector<int> & vnXCols, int nReplicateRow)
{
	if (nReplicateRow == -1)
		return;
	
	ORANGE rng;
	rng.r1 = rng.r2 = nReplicateRow;
	
	int nXCols = vnXCols.GetSize();	
	for (int i = 0 ; i < nXCols - 1 ; ++i)
	{
		rng.c1 = vnXCols[i] + 1;
		rng.c2 = vnXCols[i + 1] - 1;
		grid.MergeCells(rng, true);
	}
	
	// last group
	rng.c1 = vnXCols[nXCols - 1] + 1;
	rng.c2 = grid.Cols - 1;
	grid.MergeCells(rng, true);
}

void NewWorkBookDlg::fillGroupId(Worksheet & wks, vector<int> & vnXCols, int nReplicateRow)
{
	string strGroup;
	for (int i = 0 ; i < vnXCols.GetSize() ; ++i)
	{
		strGroup.Format("G%d", i + 1);
		wks.SetCell(nReplicateRow, vnXCols[i] + 1, strGroup, FALSE);
	}
}

void	NewWorkBookDlg::addLeftBorder(Worksheet & wks, vector<int> & vnXCols)
{
	TreeNode trFormat = wks.GetFormat(FPB_ALL, FOB_ALL, true, true);
	
	TreeNode trRangeStyles = trFormat.Root.Grid.RangeStyles;
	
	for (int i = 0 ; i < vnXCols.GetSize() ; ++i)
	{
		string strTagName;
		strTagName.Format("RangeStyle%d", i + 2); // assume postfix start from RangeStyle2
		
		TreeNode trNewRangeStyle = tree_check_get_node(trRangeStyles, strTagName, trRangeStyles.RangeStyle1.ID + (i + 1) * 0x10000);
		TreeNode trStyle = tree_check_get_node(trNewRangeStyle, "Style");
		
		trStyle.Borders.Left.Color.nVal = 0;
		trStyle.Borders.Left.Style.nVal = 0;
		trStyle.Borders.Left.Width.nVal = 0.5;
		
		trNewRangeStyle.Left.nVal = trNewRangeStyle.Right.nVal = vnXCols[i] + 1;
		trNewRangeStyle.Top.nVal = trNewRangeStyle.Bottom.nVal = 0;
	}
	
	wks.UpdateThemeIDs(trFormat);
	wks.ApplyFormat(trFormat, true, true);
}

void	NewWorkBookDlg::setNewWksFormat(Worksheet & wks, Grid & grid)
{
	vector<int> vnXCols;
	for (int i = 0 ; i < m_strTargetColDesig.GetLength() ; ++i)
	{
		if (m_strTargetColDesig[i] == 'X')
			vnXCols.Add(i);
	}
	
	int nLabelRows;
	///Kyle 08/11/2011 ORG-2574-S5 ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET
	//int nReplicateRow = _get_wks_row_label_index(grid, RCLT_REPLICATES, &nLabelRows);
	int nReplicateRow = get_wks_column_label_index(wks, RCLT_REPLICATES, &nLabelRows, grid);
	///End ADD_UTILS_TO_GET_INDEX_OF_COLUMN_LABEL_IN_WORKSHEET
	
	setGroupIdRowColor(grid, nReplicateRow);
	setColumnsShortName(wks, vnXCols);
	mergerGroupIdRow(grid, vnXCols, nReplicateRow);
	fillGroupId(wks, vnXCols, nReplicateRow - nLabelRows);
	addLeftBorder(wks, vnXCols);
	
	///Sen 08/11/2011 ORG-3450-S1 ADJUST_ROW_HEADER_TO_SEE_FULL_TEXT
	Tree trTemp;
	trTemp.Root.Dimensions.Horizontal.Size.nVals = 170;
	grid.UpdateThemeIDs(trTemp.Root);
	grid.ApplyFormat(trTemp, TRUE, TRUE, TRUE);
	///End ADJUST_ROW_HEADER_TO_SEE_FULL_TEXT
}
/// End BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE

///Sophy 7/22/2011 ORG-2629 FILE_NEW_WORKBOOK_DLG
bool	NewWorkBookDlg::createPage()
{	
	/// Sen 08/03/2011 ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX
	//	WorksheetPage wp;
	//	wp.Create("Origin");
	WorksheetPage wkspage = Project.WorksheetPages(-1);
	Button btnAddToActiveWnd = GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW);
	if(btnAddToActiveWnd.Check && wkspage)
	{
			int nWksIndex = wkspage.AddLayer();
			wkspage.Layers(nWksIndex).CheckShowActivate();
	}
	else
	{
		WorksheetPage wp;
		wp.Create("Origin");
	}
	/// End ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX
	Worksheet wks = Project.ActiveLayer(); //modify the layer, then duplicate it.
	wks.SetSize(-1, m_strTargetColDesig.GetLength());
	wks.SetColDesignations(m_strTargetColDesig);
	
	if( COLUMNS_MODE_GROUPED == getColumnConstructType() )
	{
		Grid gg;
		gg.Attach(wks);
		gg.ShowLabels(RCLT_REPLICATES, true);
		
		/// Bill 08/08/2011 ORG-3396 BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE
		setNewWksFormat(wks, gg);
		/// End BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE
	}
	return true;
}

int		NewWorkBookDlg::getTargetColDesig()
{
	if( COLUMNS_MODE_SINGLE == getColumnConstructType() )
		return getTargetColDesigForIndividualColumns();
	else
		return getTargetColDesigForGroupColumns();	
}

///Sophy 7/26/2011 ORG-3333-S1 OC_EDIT_CONTROL_NEED_CONTENT_FILTER
static	bool	_is_valid_desig_char(char cc)
{
	const string strColDesigChars = "XYZENMGLS";
	return (strColDesigChars.Find(cc) >= 0);
}
///end OC_EDIT_CONTROL_NEED_CONTENT_FILTER


#define	MAX_PARENTHESES	12	//stack depth
int  	NewWorkBookDlg::getTargetColDesigForIndividualColumns()
{
	m_strTargetColDesig.Empty();
	m_strRawColDesig.MakeUpper();	///Sophy 7/26/2011 ORG-3333-S1 OC_EDIT_CONTROL_NEED_CONTENT_FILTER
	int nLength = m_strRawColDesig.GetLength();
	if ( nLength == 0 || m_strRawColDesig.Count('(') != m_strRawColDesig.Count(')') )
		return -1;
	
	int	nStack[MAX_PARENTHESES], nStackTop = 0;
	vector<string> vsColDesig(MAX_PARENTHESES);
	LPSTR lpSrc = m_strRawColDesig.GetBuffer(nLength + 1);
	lpSrc[nLength] = '\0'; //end
	bool bDone = false;
	string strRaw = "";
	int nFactor = 1;
	while ( *lpSrc != '\0' )
	{
		char cc = *lpSrc++;
		if ( cc >= '0' && cc<= '9' )
		{
			nFactor = 0;
			while ( cc >= '0' && cc <= '9' && *lpSrc != '\0')
			{
				nFactor = nFactor*10 + (int)(cc - '0');
				cc = *lpSrc++;
			}
		}
		
		if ( cc == '(' )
		{
			if ( nStackTop == MAX_PARENTHESES - 1)
				return -2; //stack overflow...
			nStack[nStackTop++] = nFactor;
			vsColDesig[nStackTop] = ""; //clear the content for deeper level in the stack.
		}
		else if ( cc == ')' )
		{
			if ( nStackTop == 0 )
				return -2; //stack empty...
			nFactor = nStack[nStackTop - 1];
			string strTemp = "";
			while ( nFactor-- )
			{
				strTemp = strTemp + vsColDesig[nStackTop];
			}
			vsColDesig[nStackTop - 1] = vsColDesig[nStackTop - 1] + strTemp;
			nStackTop--;
		}
		///Sophy 7/26/2011 ORG-3333-S1 OC_EDIT_CONTROL_NEED_CONTENT_FILTER
		else if ( !_is_valid_desig_char(cc) ) //we need to filter those that are not allow for column designation.
		{
			//do nothing, should not add to result string.
		}
		///end OC_EDIT_CONTROL_NEED_CONTENT_FILTER
		else
		{
			while ( nFactor-- )
				vsColDesig[nStackTop] = vsColDesig[nStackTop] + cc;
		}
		nFactor = 1; //need reset nFactor here.
	}
	
	m_strTargetColDesig = vsColDesig[0]; //the result will be stored in level 0;
	
	return 0;
}

int		NewWorkBookDlg::getTargetColDesigForGroupColumns(int nLengthLimit/* = -1*/)
{
	/// Sen 08/08/2011 ORG-2629-P9 TO_FIX_DO_NOT_UPDATE_COL_DESIGN_FOR_GROUP_COL
	//	m_strNumGroups = m_cbGroups.Text;
	//	m_strNumReplica = m_cbReplica.Text;
	/// End TO_FIX_DO_NOT_UPDATE_COL_DESIGN_FOR_GROUP_COL
	int nNumGroups = atoi(m_strNumGroups);
	int nNumReplicas = atoi(m_strNumReplica);
	if( nNumGroups <= 0 || nNumReplicas <= 0 )
		return -1;
	
	string strOneGroup = "X";
	for(int nn = 0; nn < nNumReplicas && nLengthLimit != 0; nn++)
	{
		strOneGroup += "Y";
		if ( nLengthLimit > 0 )
			nLengthLimit--;
	}
	
	m_strTargetColDesig = nLengthLimit == 0 ? strOneGroup : "";
	for(nn = 0; nn < nNumGroups && nLengthLimit != 0; nn++)
	{
		m_strTargetColDesig += strOneGroup;
		if ( nLengthLimit > 0 )
			nLengthLimit--;
	}	
	return 0;
}

bool	NewWorkBookDlg::saveSettings(TreeNode& trSettings)
{
	if ( !trSettings )
		return false;
	WorkbookCreateOptions st;
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	//st.nColumnsMode = m_rdNewWithSingleCols.Value == 1 ? COLUMNS_MODE_SINGLE : COLUMNS_MODE_GROUPED;
	st.nColumnsMode = getColumnConstructType();
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	st.strColDesig = m_cbColDesig.Text;
	st.nGroups = atol(m_cbGroups.Text);
	st.nReplica = atol(m_cbReplica.Text);
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	st.nAddToActive = m_chkAddToActive.Value;
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	trSettings += st;
	
	trSettings += st;
	trSettings.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, STR_NEW_WORKBOOK_THEME_OPTION);
	///------ Folger 11/12/2011 ORG-3273-P2 NEW_WORKSHEET_DLG_WRONG_DIALOG_THEME
	//trSettings.SetAttribute(STR_THEME_TYPE_ATTRIB, THTYPE_ANALYSIS);
	trSettings.SetAttribute(STR_THEME_TYPE_ATTRIB, THTYPE_DIALOG);
	///------ End NEW_WORKSHEET_DLG_WRONG_DIALOG_THEME
	return true;
}

bool	NewWorkBookDlg::loadSettings(const TreeNode& trSettings)
{
	if ( !trSettings )
		return false;
	WorkbookCreateOptions st;
	st = trSettings;
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	//m_rdNewWithSingleCols.Value = st.nColumnsMode == COLUMNS_MODE_SINGLE ? 1 : 0;
	//m_rdNewWithGroupedCols.Value = st.nColumnsMode == COLUMNS_MODE_SINGLE ? 0 : 1;
	int nFirstID = IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS;
	CheckRadioButton(nFirstID, IDC_RADIO_NEW_WBOOK_WITH_GROUPED_COLUMNS, nFirstID + st.nColumnsMode);
	///	End FAIL_TO_SAVE_AS_DEFAULT
	m_cbColDesig.Text = st.strColDesig;
	m_cbGroups.Text = st.nGroups;
	m_cbReplica.Text = st.nReplica;
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	m_chkAddToActive.Check = st.nAddToActive;
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	return true;
}
///end FILE_NEW_WORKBOOK_DLG

/// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
void NewWorkBookDlg::showHidePlotTypeDropdown()
{
	Button bnCreateSamplePlot = GetItem(IDC_CHECK_CREATE_RANDOM_SAMPLE_PLOT);
	ComboBox cbPlotType = GetItem(IDC_COMBO_PLOT_TYPE);

	cbPlotType.Visible = bnCreateSamplePlot.Visible && bnCreateSamplePlot.Check;
}
/// End PROVIDE_OPTION_TO_CREATE_PLOT

void openNewWorkBookDlg()
{
	NewWorkBookDlg myDlg;
	myDlg.DoModalEx();
}

