/*------------------------------------------------------------------------------*
 * File Name: NewMatrixDlg														*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME				*
 * Sen 08/17/2011 ORG-3451-P1 NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION				*
 *------------------------------------------------------------------------------*/
 
#ifndef NEW_MATRIX_DLG_H
#define NEW_MATRIX_DLG_H

class NewMatrixDlg;

enum
{
	ID_SHOW_THUMBNAILS = 1,
	ID_NUM_COLS,
	ID_NUM_ROWS,
	ID_X_FROM,
	ID_X_TO,
	ID_X_LN,
	ID_X_UNITS,
	ID_X_COMMENTS,
	ID_Y_FROM,
	ID_Y_TO,
	ID_Y_LN,
	ID_Y_UNITS,
	ID_Y_COMMENTS,
	ID_NUM_OBJECTS,	
	ID_Z_DATA_TYPE,
	ID_Z_LN,
	ID_Z_UNITS,
	ID_Z_COMMENTS,
	ID_Z_FORMULA,
	ID_ADD_TO_ACTIVE/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
};

typedef struct tagMatrixObjectOptions
{
	int		_id(ID_Z_DATA_TYPE)				nDataType;
	string	_id(ID_Z_LN)					strLN;
	string	_id(ID_Z_UNITS)					strUnits;
	string	_id(ID_Z_COMMENTS)				strComments;
	string	_id(ID_Z_FORMULA)				strFormula;
}MatrixObjectOptions;

typedef struct tagMatrixbookCreateOptions
{
	bool		_id(ID_SHOW_THUMBNAILS)		bShowThumbnails;
	int			_id(ID_NUM_COLS)			nNumCols;
	int			_id(ID_NUM_ROWS)			nNumRows;
	double		_id(ID_X_FROM)				dXFrom;
	double		_id(ID_X_TO)				dXTo;
	string		_id(ID_X_LN)				strXLN;
	string 		_id(ID_X_UNITS)				strXUnits;
	string		_id(ID_X_COMMENTS)			strXComments;
	double		_id(ID_Y_FROM)				dYFrom;
	double		_id(ID_Y_TO)				dYTo;
	string		_id(ID_Y_LN)				strYLN;
	string		_id(ID_Y_UNITS)				strYUnits;
	string		_id(ID_Y_COMMENTS)			strYComments;
	int			_id(ID_NUM_OBJECTS)			nNumObjects;
	bool 		_id(ID_ADD_TO_ACTIVE)		bAddToActive;/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
} MatrixbookCreateOptions;

enum
{
	ZLIST_COL_NAME = 0,
	ZLIST_COL_TYPE,
	ZLIST_COL_LN,
	ZLIST_COL_UNITS,
	ZLIST_COL_COMMENTS,
	ZLIST_COL_FORMULA
};

class MatrixObjectZList : public GridListControl
{
public:
	MatrixObjectZList() {}
	~MatrixObjectZList() {}	
	//virtual
	string	GetClassName() { return "MatrixObjectZList"; }
	
	bool Init(UINT uID, NewMatrixDlg *pBookNewDlg, LPCTSTR lpcstrHeading);
	void OnMatrixObjectNumberChanged(int nNumObjects);
	bool GetZDataTypes(vector<int>& vnTypes);
	void GetSettings(Array<MatrixObjectOptions&> &arrObjectOptions);
	void SetSettings(Array<MatrixObjectOptions&> &arrObjectOptions);
	
	bool DoApplyAll(int nRow, int nCol);

private:
	NewMatrixDlg*		m_pBookNewDlg;
};

class NewMatrixDlg : public ResizeDialog
{
public:
	NewMatrixDlg() : ResizeDialog(IDD_NEW_MATRIX_DLG, "ODlg8")
	{
	}
	~NewMatrixDlg()
	{		
	}

	int DoModalEx(HWND hWndParent = NULL)
	{		
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hWndParent);		
		return nRet;
	}
	
	int GetControlIntValue(int nID);
	double GetControlDoubleValue(int nID);
	string GetControlStrValue(int nID);
	int GetComboSelectedValue(int nID);
	
	void UpdateDataSizeControl(); // need to be called from MatrixObjectZList class on z data type changed
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	
	ON_BN_CLICKED(IDOK, OnOK)

	ON_BN_CLICKED(IDC_SHEET_THEME_SAVE_AS, OnThemeSaveButtonClick)
	ON_BN_CLICKED(IDC_CHECK_ADD_TO_ACTIVE_WINDOW, OnAddToActiveButtonClicked)/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	ON_CBN_SELCHANGE(IDC_COMBO_NUM_OBJECTS, OnMatrixObjectNumberSelChanged)
	ON_CBN_EDITCHANGE(IDC_COMBO_NUM_OBJECTS, OnMatrixObjectNumberEditChanged)
	ON_EN_CHANGE(IDC_EDIT_COLUMNS, OnMatrixColumnNumberChange)
	ON_EN_CHANGE(IDC_EDIT_ROWS, OnMatrixRowNumberChange)
	ON_GRID_COMBO_CLOSEUP(IDC_Z_LIST, OnMatrixObjectComboCloseUp )
	ON_GRID_AFTER_EDIT(IDC_Z_LIST, OnMatrixObjectListChanged)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_Z_LIST, OnGridBeforeMouseDown)
	ON_EN_CHANGE(IDC_EDIT_X_FROM, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_X_TO, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_X_LONGNAME, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_X_UNITS, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_X_COMMENTS, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_Y_FROM, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_Y_TO, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_Y_LONGNAME, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_Y_UNITS, OnMatrixSettingChange)
	ON_EN_CHANGE(IDC_EDIT_Y_COMMENTS, OnMatrixSettingChange)
	ON_BN_CLICKED(IDC_CHECK_SHOW_IMAGE_THUMB, OnMatrixSettingChange)
	 
EVENTS_END

	BOOL OnInitDialog();
	BOOL OnReady();
	
	BOOL OnOK(Control cntrl);
	

	BOOL OnThemeSaveButtonClick(Control cntrl);
	BOOL OnMatrixObjectNumberSelChanged(Control cntrl);
	BOOL OnMatrixObjectNumberEditChanged(Control cntrl);
	BOOL OnMatrixColumnNumberChange(Control cntrl);
	BOOL OnMatrixRowNumberChange(Control cntrl);	
	void OnMatrixObjectComboCloseUp( Control ctrl, int nRow, int nCol, BOOL *pFinishEdit );
	void OnMatrixObjectListChanged( Control ctrl, int nRow, int nCol );
	void OnGridBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	BOOL OnMatrixSettingChange(Control cntrl);
	
	BOOL OnAddToActiveButtonClicked(Control cntrl);/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	
private:
	void initControls();

	void getMatrixbookSettings(MatrixbookCreateOptions& st);
	void getMatrixObjectSettingTree(TreeNode& tr, bool bIncValue = true);
	void loadMatrixbookSettings(const MatrixbookCreateOptions& st, Array<MatrixObjectOptions&> &arrObjectOptions);
	void getMatrixbookDefaultSettings(MatrixbookCreateOptions& st);
	void getMatrixbookSettingTree(TreeNode& tr, int nIncludeValueOption);
	void getMatrixSettingTree(TreeNode& trSettings);

	bool loadFromSettingTree(const TreeNode& trSettings);
	
	double	EvaluateCntrlText(Control& cntrl);/// Sen 08/17/2011 ORG-3451-P1 NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION
	
	// click OK button on dialog
	bool doNewMatrixbook();	
	BOOL OnAfterApply();

	
private:
	
	ComboBox			m_cbNumObjects;
	Edit				m_edtNumCols;
	Edit				m_edtNumRows;
	Edit				m_edtXFrom;
	Edit				m_edtXTo;
	Edit				m_edtYFrom;
	Edit				m_edtYTo;
	MatrixObjectZList	m_listZ;
	ThemeControlHelper	m_themeHelper;
};


	
#endif //NEW_MATRIX_DLG_H
