
/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 7/14/2011 IMAGE_THUMBNAIL_CHKBOX_CRASH									*
 *	Sen 08/03/2011 ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX						*
 *	Sen 08/05/2011 ORG-2629-S7 ADD_TO_ACTIVE_BUTTON_SHOULD_BE_HIDDEN			*
 *  Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME				*
 *  Sen 08/17/2011 ORG-3451-P1 NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION			*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include <Array.h>
#include "MenuBase.h"
#include "NewMatrixDlg.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
#define STR_NEW_MATRIX_THEME_OPTION		"NewMatrix"

#define Z_LIST_HEADINGS					_L(" |Type|Long Name|Units|Comments|Formula")

#define STR_DLG_NAME					"NewMatrixDlg"

enum
{
	TAB_LOAD_TEMPLATE = 0,
	TAB_NEW_WORKBOOK,
	TAB_NEW_MATRIXBOOK,
	
	TAB_ITEM_COUNT
};


enum 
{
	WTYPE_WORKSHEET = 0,
	WTYPE_MATRIXSHEET
};

enum 
{
	TTYPE_WITHOUT_DATA = 0,
	TTYPE_ANALYSIS
};

enum
{
	COLUMNS_MODE_SINGLE,
	COLUMNS_MODE_GROUPED
};

enum
{
	TEMPLATE_SYSTEM_FOLDER,
	TEMPLATE_USER_FILE_FOLDER,
	TEMPLATE_CUSTOM_FOLDER
};


////////////////////////////////////////////////////////////////////////////////////
// Start MatrixCreateMenu class functions here.


////////////////////////////////////////////////////////////////////////////////////
// Start NewMatrixDlg class functions here.

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
////////////////// Dialog related ///////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

BOOL NewMatrixDlg::OnInitDialog()
{	
	ResizeDialog::OnInitDialog();
	
	initControls();
	return true;
}


BOOL NewMatrixDlg::OnReady()
{
	return true;
}

/// Sen 08/01/2011 ORG-2629-P5 NO_LAST_USED_THEME_CREATED_AFTER_USING	
BOOL NewMatrixDlg::OnAfterApply()
{
	Tree trSettings;
	getMatrixSettingTree(trSettings);
	m_themeHelper.SaveLastUsedTheme(trSettings);
	return TRUE;
}
/// End NO_LAST_USED_THEME_CREATED_AFTER_USING

BOOL NewMatrixDlg::OnOK(Control cntrl)
{
		return doNewMatrixbook() && OnAfterApply();
}

int NewMatrixDlg::GetControlIntValue(int nID)
{
	string str = GetControlStrValue(nID);
	if( !is_numeric(str) )
		return -2;
	return atoi(str);	
}

double NewMatrixDlg::GetControlDoubleValue(int nID)
{
	string str = GetControlStrValue(nID);
	if( !is_numeric(str) )
		return NANUM;
	return atof(str);		
}

string NewMatrixDlg::GetControlStrValue(int nID)
{
	Edit edCtrl = GetItem(nID);
	ASSERT(edCtrl);	
	if( !edCtrl )
		return "";
	
	return edCtrl.Text;
}

int NewMatrixDlg::GetComboSelectedValue(int nID)
{
	ComboBox cmb = GetItem(nID);
	ASSERT(cmb);	
	if( !cmb )
		return -1;
	
	string str;
	int index = cmb.GetCurSel();	
	if( index >= 0 )
	{
		cmb.GetLBText(index, str);
	}
	else
	{
		str = cmb.Text;
	}
	return atoi(str);
}

void NewMatrixDlg::OnGridBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
	if ( MK_RBUTTON != nButton || m_listZ.IsMouseOnHeader() )
		return;

	int nRow, nCol, nX, nY;
	if ( !m_listZ.GetMousePixel(X, Y, nRow, nCol, nX, nY) )
		return;
	
	if( nCol <= ZLIST_COL_NAME )
		return;
	
	MenuBase		menu;
	menu.Add(_L("Apply to All"), MenuBase::OnMenuItem);
	
	int 			nChoice = menu.DoTrackPopup(nX, nY, GetSafeHwnd());
	if ( nChoice < 0 )
		return;	
	
	m_listZ.DoApplyAll(nRow, nCol); //now only one entry in menu	
}

void NewMatrixDlg::initControls()
{
	Button btnThemeSaveAs = GetItem(IDC_SHEET_THEME_SAVE_AS);
	btnThemeSaveAs.Text = ">";

	m_cbNumObjects.SetContentFilter(CF_INTEGER);
	m_cbNumObjects = GetItem(IDC_COMBO_NUM_OBJECTS);
	for(int ii=0; ii<10; ii++)
		m_cbNumObjects.AddString((string)(ii+1));
	//init edit control	
	m_edtNumCols.SetContentFilter(CF_INTEGER);
	m_edtNumCols = GetItem(IDC_EDIT_COLUMNS);
	
	m_edtNumRows.SetContentFilter(CF_INTEGER);
	m_edtNumRows = GetItem(IDC_EDIT_ROWS);
	
	/// Sen 08/17/2011 ORG-3451-P1 NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION
	/*
	m_edtXFrom.SetContentFilter(CF_SIGNED_DOUBLE);
	m_edtXFrom = GetItem(IDC_EDIT_X_FROM);
	
	m_edtXTo.SetContentFilter(CF_SIGNED_DOUBLE);
	m_edtXTo = GetItem(IDC_EDIT_X_TO);
	
	m_edtYFrom.SetContentFilter(CF_SIGNED_DOUBLE);
	m_edtYFrom = GetItem(IDC_EDIT_Y_FROM);
	
	m_edtYTo.SetContentFilter(CF_SIGNED_DOUBLE);
	m_edtYTo = GetItem(IDC_EDIT_Y_TO);
	*/	
	/// End NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION
	
	// init control with default values
	MatrixbookCreateOptions st;
	getMatrixbookDefaultSettings(st);
	loadMatrixbookSettings(st, NULL);
	
	m_listZ.Init(IDC_Z_LIST, this, Z_LIST_HEADINGS);
	
	/// Sen 08/03/2011 ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX
	MatrixLayer ml = Project.ActiveLayer();
	if(!ml)
		/// Sen 08/05/2011 ORG-2629-S7 ADD_TO_ACTIVE_BUTTON_SHOULD_BE_HIDDEN
		//GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW).Enable = 0;
		GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW).Visible = false;
		/// End ADD_TO_ACTIVE_BUTTON_SHOULD_BE_HIDDEN
	/// End	ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX
	
	// init theme list combo
	Tree trSettings;
	getMatrixbookSettingTree(trSettings, SEETING_TREE_WITH_DEFAULT); // construct setting tree in order to get theme list
	
	m_themeHelper.Init(this, IDC_COMBO_SHEET_THEME, IDC_SHEET_THEME_SAVE_AS, trSettings, "Originlab\\NewMatrixDlg.c", "construct_matrix_objects_setting_tree");
	loadFromSettingTree(trSettings);	
} 

/// Sen 08/17/2011 ORG-3451-P1 NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION
double	NewMatrixDlg::EvaluateCntrlText(Control& cntrl)
{
	double	dVal;
	LT_evaluate(cntrl.Text, &dVal);
	return 	dVal;
}
/// End NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION

void NewMatrixDlg::getMatrixbookSettings(MatrixbookCreateOptions& st)
{
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	//	st.bShowThumbnails = GetControlIntValue(IDC_CHECK_SHOW_IMAGE_THUMB);
	Button btnShowThumbnails = GetItem(IDC_CHECK_SHOW_IMAGE_THUMB);
	st.bShowThumbnails = btnShowThumbnails.Check;
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME

	st.nNumCols = GetControlIntValue(IDC_EDIT_COLUMNS);
	st.nNumRows = GetControlIntValue(IDC_EDIT_ROWS);
	/// Sen 08/17/2011 ORG-3451-P1 NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION
	/*
	st.dXFrom = GetControlDoubleValue(IDC_EDIT_X_FROM);
	st.dXTo = GetControlDoubleValue(IDC_EDIT_X_TO);
	st.dYFrom = GetControlDoubleValue(IDC_EDIT_Y_FROM);
	st.dYTo = GetControlDoubleValue(IDC_EDIT_Y_TO);
	*/
	st.dXFrom = EvaluateCntrlText(GetItem(IDC_EDIT_X_FROM));
	st.dXTo = EvaluateCntrlText(GetItem(IDC_EDIT_X_TO));
	st.dYFrom = EvaluateCntrlText(GetItem(IDC_EDIT_Y_FROM));
	st.dYTo = EvaluateCntrlText(GetItem(IDC_EDIT_Y_TO));
	/// End NEW_MATRIX_FROM_TO_SUPPORT_EXPRESSION
	st.nNumObjects = GetControlIntValue(IDC_COMBO_NUM_OBJECTS);
	ASSERT(st.nNumObjects > 0 );
	if( st.nNumObjects <= 0 )
		st.nNumObjects = 1;
	st.strXLN = GetControlStrValue(IDC_EDIT_X_LONGNAME);
	st.strXUnits = GetControlStrValue(IDC_EDIT_X_UNITS);
	st.strXComments = GetControlStrValue(IDC_EDIT_X_COMMENTS);
	st.strYLN = GetControlStrValue(IDC_EDIT_Y_LONGNAME);
	st.strYUnits = GetControlStrValue(IDC_EDIT_Y_UNITS);
	st.strYComments = GetControlStrValue(IDC_EDIT_Y_COMMENTS);
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	Button btnAddToActive = GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW);
	st.bAddToActive = btnAddToActive.Check;
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
}

void NewMatrixDlg::loadMatrixbookSettings(const MatrixbookCreateOptions& st, Array<MatrixObjectOptions&> &arrObjectOptions)
{
	Button btnShow = GetItem(IDC_CHECK_SHOW_IMAGE_THUMB);
	btnShow.Check = st.bShowThumbnails;
	GetItem(IDC_EDIT_COLUMNS).Text = (string)st.nNumCols;
	GetItem(IDC_EDIT_ROWS).Text = (string)st.nNumRows;
	GetItem(IDC_EDIT_X_FROM).Text = ftoa(st.dXFrom);
	GetItem(IDC_EDIT_X_TO).Text = ftoa(st.dXTo);
	GetItem(IDC_EDIT_Y_FROM).Text = ftoa(st.dYFrom);
	GetItem(IDC_EDIT_Y_TO).Text = ftoa(st.dYTo);
	m_cbNumObjects.SetCurSel(st.nNumObjects-1);
	GetItem(IDC_EDIT_X_LONGNAME).Text = st.strXLN;
	GetItem(IDC_EDIT_X_UNITS).Text = st.strXUnits;
	GetItem(IDC_EDIT_X_COMMENTS).Text = st.strXComments;
	GetItem(IDC_EDIT_Y_LONGNAME).Text = st.strYLN;
	GetItem(IDC_EDIT_Y_UNITS).Text = st.strYUnits;
	GetItem(IDC_EDIT_Y_COMMENTS).Text = st.strYComments;
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	Button btnAddToActive = GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW);
	btnAddToActive.Check = st.bAddToActive;
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	
	if( NULL != arrObjectOptions )
	{
		while( arrObjectOptions.GetSize() < st.nNumObjects)
		{
			MatrixObjectOptions *pst = new MatrixObjectOptions;
			arrObjectOptions.Add(*pst);
		}
		m_listZ.SetSettings(arrObjectOptions);
	}
}

void NewMatrixDlg::getMatrixbookDefaultSettings(MatrixbookCreateOptions& st)
{
	//	st.bShowThumbnails = 0;
	st.bShowThumbnails = 1;
	st.nNumCols = 32;
	st.nNumRows = 32;
	st.dXFrom = 1;
	st.dXTo = 10;
	st.dYFrom = 1;
	st.dYTo = 10;
	st.nNumObjects = 1;
	st.strXLN = "";
	st.strXUnits = "";
	st.strXComments = "";
	st.strYLN = "";
	st.strYUnits = "";
	st.strYComments = "";
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	st.bAddToActive = 0;
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
}

void NewMatrixDlg::getMatrixbookSettingTree(TreeNode& tr, int nIncludeValueOption) 
{
	// get matrix book and layer options to setting tree
	MatrixbookCreateOptions st;
	switch(nIncludeValueOption)
	{
	case SEETING_TREE_WITHOUT_VALUE:
		break;
		
	case SEETING_TREE_WITH_VALUE:
		getMatrixbookSettings(st);
		break;
		
	case SEETING_TREE_WITH_DEFAULT:
		getMatrixbookDefaultSettings(st);		
		break;
	}	
	tr += st;
	tr.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, STR_NEW_MATRIX_THEME_OPTION);
	/// Sen 7/25/2011 ORG-3273-S1 SAVE_THEME_WITH_CORRECT_FOLDER
	tr.SetAttribute(STR_THEME_TYPE_ATTRIB, THTYPE_DIALOG);
	/// END SAVE_THEME_WITH_CORRECT_FOLDER
}

bool construct_matrix_objects_setting_tree(TreeNode& tr)
{
	int nNumObjects = tr.nNumObjects.nVal;
	
	TreeNodeCollection trColl(tr, "Z");
	if( nNumObjects == trColl.Count() )
		return false; // not changed
		
	if( nNumObjects > trColl.Count() )
	{
		for(int ii = trColl.Count(); ii < nNumObjects; ii++)
		{
			TreeNode trZ = tr.AddNode("Z" + ( ii + 1));
			trZ.SetAttribute(STR_REPEAT_ID_ATTRIB, ii + 1);		
	
			MatrixObjectOptions st;
			trZ += st;
		}
	}
	
	while( nNumObjects < trColl.Count() )
	{
		TreeNode trLastZ = tr.GetNode("Z" + (trColl.Count() - 1));
		trLastZ.Remove();
	}
	
	if( 1 == trColl.Count() )
		tr.Z1.RemoveAttribute(STR_REPEAT_ID_ATTRIB);
	return true;
}

void NewMatrixDlg::getMatrixObjectSettingTree(TreeNode& tr, bool bIncValue)
{
	construct_matrix_objects_setting_tree(tr);
	
	// get matrix object options to setting tree
	if( bIncValue )
	{
		Array<MatrixObjectOptions&> arrObjectOptions(true);	
		m_listZ.GetSettings(arrObjectOptions);
		
		int ii = 0;
		TreeNodeCollection trColl(tr, "Z");
		///Sophy 2/16/2012 ORG-5077-P1 SET_MATRIXOBJ_EXCEED_500_NEED_FOLLOW_LAST_ROW_SETTINGS
		int nMaxObjSettingIndex = arrObjectOptions.GetSize() - 1;
		///end SET_MATRIXOBJ_EXCEED_500_NEED_FOLLOW_LAST_ROW_SETTINGS
		foreach(TreeNode trZ in trColl)
		{
			MatrixObjectOptions& st = arrObjectOptions.GetAt(ii);
			trZ = st;
			///Sophy 2/16/2012 ORG-5077-P1 SET_MATRIXOBJ_EXCEED_500_NEED_FOLLOW_LAST_ROW_SETTINGS
			//ii++;
			if ( ii < nMaxObjSettingIndex )
				ii++;
			///end SET_MATRIXOBJ_EXCEED_500_NEED_FOLLOW_LAST_ROW_SETTINGS
		}
	}
}


void NewMatrixDlg::getMatrixSettingTree(TreeNode& trSettings)
{	
	getMatrixbookSettingTree(trSettings, SEETING_TREE_WITH_VALUE);
	getMatrixObjectSettingTree(trSettings, true);
}


bool NewMatrixDlg::loadFromSettingTree(const TreeNode& trSettings)
{	
	MatrixbookCreateOptions stBookOptions;
	stBookOptions = trSettings;	
	
	// each Z object settings
	Array<MatrixObjectOptions&> arrObjectOptions(true);			
	TreeNodeCollection trColl(trSettings, "Z");
	foreach(TreeNode trN in trColl)
	{		
		MatrixObjectOptions *pstObjectOptions = new MatrixObjectOptions;
		*pstObjectOptions = trN;
		arrObjectOptions.Add(*pstObjectOptions);
	}
	
	loadMatrixbookSettings(stBookOptions, arrObjectOptions); // copy values from struct to dialog			
	return true;
}


BOOL NewMatrixDlg::OnThemeSaveButtonClick(Control cntrl)
{	
	Tree trSettings;
	getMatrixSettingTree(trSettings);

	// To remove all Zn treenodes. If the number of Zn in tree > the number of Z in theme, will cause loading failed.
	// So just to load matrixbook settings with the number of Z in first time. Then reconstruct tree with construct_matrix_objects_setting_tree function to construct Zn treenodes.
	// And reload from theme file again. 
	Tree trToLoading;
	trToLoading = trSettings;
	TreeNodeCollection trColl(trToLoading, "Z");
	foreach(TreeNode trZ in trColl)
	{
		trZ.Remove();
	}
	
	bool bLoading;
	m_themeHelper.ShowPopupMenu(GetSafeHwnd(), trSettings, trToLoading, bLoading);	
	if( bLoading )
	{
		m_themeHelper.SetChangeEventReady(false);
		loadFromSettingTree(trToLoading);
		m_themeHelper.SetChangeEventReady(true);
	}
	return true;
}

/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
BOOL NewMatrixDlg::OnAddToActiveButtonClicked(Control cntrl)
{
	m_themeHelper.OnDlgSettingChange();
	
	return true;
}
/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME

BOOL NewMatrixDlg::OnMatrixObjectNumberSelChanged(Control cntrl)
{
	int nNumObject = GetComboSelectedValue(IDC_COMBO_NUM_OBJECTS);
	m_listZ.OnMatrixObjectNumberChanged(nNumObject);
	m_themeHelper.OnDlgSettingChange();
	
	return true;	
}
#define	MIN_MATRIXOBJECTS	1
#define	MAX_MATRIXOBJECTS	500
BOOL NewMatrixDlg::OnMatrixObjectNumberEditChanged(Control cntrl)
{
	int nNumObjects = atoi(m_cbNumObjects.Text);
	if ( nNumObjects < MIN_MATRIXOBJECTS )
		nNumObjects = MIN_MATRIXOBJECTS;
	if ( nNumObjects > MAX_MATRIXOBJECTS )
		nNumObjects = MAX_MATRIXOBJECTS;
	m_listZ.OnMatrixObjectNumberChanged(nNumObjects);
	m_themeHelper.OnDlgSettingChange();
	
	return true;
}

BOOL NewMatrixDlg::OnMatrixRowNumberChange(Control cntrl)
{
	UpdateDataSizeControl();
	m_themeHelper.OnDlgSettingChange();
	return true;	
}

void NewMatrixDlg::OnMatrixObjectComboCloseUp( Control ctrl, int nRow, int nCol, BOOL *pFinishEdit )
{
	*pFinishEdit = TRUE;
}

void NewMatrixDlg::OnMatrixObjectListChanged( Control ctrl, int nRow, int nCol )
{
	m_themeHelper.OnDlgSettingChange();
	if( ZLIST_COL_TYPE == nCol )
		UpdateDataSizeControl();
}

BOOL NewMatrixDlg::OnMatrixColumnNumberChange(Control cntrl)
{
	UpdateDataSizeControl();
	m_themeHelper.OnDlgSettingChange();
	return true;	
}

//--- CPY 7/14/2011 IMAGE_THUMBNAIL_CHKBOX_CRASH
BOOL NewMatrixDlg::OnMatrixSettingChange(Control cntrl)
{
	m_themeHelper.OnDlgSettingChange(); 
	return TRUE; 
}
//---
///Sophy 2/24/2012 ORG-5158-P1 WRONG_DATATYPE_IN_NEWMATRIX_DIALOG
const vector<int> vnDataTypeMap = {
	FSI_DOUBLE,
	FSI_REAL,
	FSI_SHORT,
	FSI_LONG,
	FSI_CHAR,
	FSI_BYTE,
	FSI_USHORT,
	FSI_ULONG,
	FSI_COMPLEX
};
///end WRONG_DATATYPE_IN_NEWMATRIX_DIALOG
void NewMatrixDlg::UpdateDataSizeControl()
{	
	vector<int> vnTypes;
	if( !m_listZ.GetZDataTypes(vnTypes) )
		return;
	
	vector<int> vnTypeSize = {8, 4, 2, 4, 1, 1, 2, 4, 16};
	
	int nOneCellSize;
	double dTotalSize = 0;
	double dNumRow = GetControlIntValue(IDC_EDIT_ROWS);
	double dNumCol = GetControlIntValue(IDC_EDIT_COLUMNS);	
	for(int ii = 0; ii < vnTypes.GetSize(); ii++)
	{		
		///Sophy 2/28/2012 ORG-5158-P1 WRONG_DATATYPE_IN_NEWMATRIX_DIALOG
		//if( vnTypes[ii] < vnTypeSize.GetSize() )
		//	nOneCellSize = vnTypeSize[vnTypes[ii]];
		int nTypeIndex = find_in_list(vnTypes[ii], vnDataTypeMap, true);
		if ( nTypeIndex >= 0 && nTypeIndex < vnTypeSize.GetSize() )
			nOneCellSize = vnTypeSize[nTypeIndex];
		///end WRONG_DATATYPE_IN_NEWMATRIX_DIALOG
		else
		{
			nOneCellSize = vnTypeSize[0];
			error_report("Error in UpdateDataSizeControl, please check code.");
		}
		
		dTotalSize += dNumRow * dNumCol * nOneCellSize / ( 1024.0 * 1024.0 );
	}
	
	Control ctrlDataSize = GetItem(IDC_STATIC_DATA_SIZE);
	ctrlDataSize.Text = ftoa(dTotalSize, "*3");
}	

bool NewMatrixDlg::doNewMatrixbook()
{
	MatrixbookCreateOptions st;
	getMatrixbookSettings(st);
	
	Array<MatrixObjectOptions&> arrObjectOptions(true);	
	m_listZ.GetSettings(arrObjectOptions);
	
	
	/// Sen 08/03/2011 ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX
	MatrixLayer ml;
	//string strTempalteName = GetAppPath(TRUE) + "Origin.otm";
	//matPage.Create(strTempalteName, CREATE_HIDDEN);
	//MatrixLayer ml = matPage.Layers(0);
	MatrixPage matPage = Project.MatrixPages(-1);
	Button btnAddToActiveWnd = GetItem(IDC_CHECK_ADD_TO_ACTIVE_WINDOW);
	if(btnAddToActiveWnd.Check && matPage)
	{
		int nMatIndex = matPage.AddLayer();
		matPage.Layers(nMatIndex).CheckShowActivate();
		ml = Project.ActiveLayer();
	}
	else
	{
		string strTempalteName = GetAppPath(TRUE) + "Origin.otm";
		matPage.Create(strTempalteName, CREATE_HIDDEN);
		ml = matPage.Layers(0);
	}
	/// End ORG-2629-S5 ADD_ADD_TO_ACTIVE_CHECK_BOX

	ml.SetSize(st.nNumObjects, st.nNumRows, st.nNumCols);
	ml.SetAxesLongName(st.strXLN, false);
	ml.SetAxesUnits(st.strXUnits, false);
	ml.SetAxesComments(st.strXComments, false);
	ml.SetAxesLongName(st.strYLN, true);
	ml.SetAxesUnits(st.strYUnits, true);
	ml.SetAxesComments(st.strYComments, true);
	
	MatrixObject mo = ml.MatrixObjects(0);
	mo.SetXY(st.dXFrom, st.dYFrom, st.dXTo, st.dYTo);
	///Sophy 2/16/2012 ORG-5077-P1 SET_MATRIXOBJ_EXCEED_500_NEED_FOLLOW_LAST_ROW_SETTINGS
	int nMaxObjSettingIndex = arrObjectOptions.GetSize() - 1;
	int nObjSettingIndex = 0;
	if ( st.nNumObjects > nMaxObjSettingIndex + 1 )
	{
		string strMsg;
		strMsg.Format(_L("MatrixObject with index larger than %d will follow the settings of MatrixObject with index %d."), nMaxObjSettingIndex, nMaxObjSettingIndex);
		warning_msg_box(strMsg, true, 'E');
	}
	///end SET_MATRIXOBJ_EXCEED_500_NEED_FOLLOW_LAST_ROW_SETTINGS
	for(int nObj = 0; nObj < st.nNumObjects; nObj++)
	{		
		///Sophy 2/16/2012 ORG-5077-P1 SET_MATRIXOBJ_EXCEED_500_NEED_FOLLOW_LAST_ROW_SETTINGS
		//MatrixObjectOptions& stObjectOptions = arrObjectOptions.GetAt(nObj);
		MatrixObjectOptions& stObjectOptions = arrObjectOptions.GetAt(nObjSettingIndex);
		if ( nObjSettingIndex < nMaxObjSettingIndex )
			nObjSettingIndex++;
		///end SET_MATRIXOBJ_EXCEED_500_NEED_FOLLOW_LAST_ROW_SETTINGS
		mo = ml.MatrixObjects(nObj);
		mo.SetInternalDataType(stObjectOptions.nDataType);
		mo.SetFormula(stObjectOptions.strFormula);
		mo.ExecuteFormula();		
		mo.SetLongName(stObjectOptions.strLN);
		mo.SetUnits(stObjectOptions.strUnits);
		mo.SetComments(stObjectOptions.strComments);
	}	
	matPage.SetShow();	
	
	Button btn = GetItem(IDC_CHECK_SHOW_IMAGE_THUMB);
	if( btn.Check )
		matPage.ShowImageThumbnails(true);
	return true;
}

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
//////////////// MatrixObjectZList //////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
bool MatrixObjectZList::Init(UINT uID, NewMatrixDlg *pBookNewDlg, LPCTSTR lpcstrHeading)
{
	if( pBookNewDlg == NULL )
		return false;
	m_pBookNewDlg = pBookNewDlg;
	
	SetDlgName(STR_DLG_NAME);
	GridListControl::Init( uID, *m_pBookNewDlg );
	SetAllowSelection(true);
	SetSelection(flexSelectionFree);
	SetEditable(flexEDKbdMouse);
	SetAlternateRowColors();
	
	// setup columns with header string
	vector<string> vstrListHeading;
	string strHeadings = lpcstrHeading;
	strHeadings.GetTokens( vstrListHeading, '|' );
	int nHeaders = vstrListHeading.GetSize();	
	SetupRowsCols(1, 0, -1, nHeaders);
	for( int nCol = 0; nCol < nHeaders; ++nCol )
	{
		SetColHeading( nCol, vstrListHeading[nCol] );		
	}
	
	// setup rows
	int nNumObjects = m_pBookNewDlg->GetComboSelectedValue(IDC_COMBO_NUM_OBJECTS);
	OnMatrixObjectNumberChanged(nNumObjects);

	SetColComboList(ZLIST_COL_TYPE, STR_COL_INTERNAL_DATA_LIST);
	ResizeCols();
	return true;
}

void MatrixObjectZList::OnMatrixObjectNumberChanged(int nNumObjects)
{
	ASSERT(NULL != m_pBookNewDlg);
	if( NULL == m_pBookNewDlg )
		return;	
		
	int nRows = GetNumRows();
	if( nRows == nNumObjects )
		return;
	
	if( nRows < nNumObjects )
	{
		for(int nRow = nRows; nRow < nNumObjects; nRow++)
		{
			string strDataType = STR_COL_INTERNAL_DATA_LIST;
			strDataType = strDataType.GetToken(0, '|');
			string strRow;
			strRow.Format("Z%d\t%s\t\t\t\t", nRow+1, strDataType);
			m_flx.AddItem(strRow, -1);
		}
	}
	else
	{
		SetRows(nNumObjects);
	}	
	
	m_pBookNewDlg->UpdateDataSizeControl();
}

bool MatrixObjectZList::GetZDataTypes(vector<int>& vnTypes)
{
	int nRows = GetNumRows();
	if( nRows <= 0 )
		return false; // no matrix object
	
	vector<string> vsSelTypes;
	GetColValues(ZLIST_COL_TYPE, vsSelTypes, GetRowOffset());
	
	string strTypeList = STR_COL_INTERNAL_DATA_LIST;
	vector<string> vsTypeList;
	strTypeList.GetTokens(vsTypeList, '|');
	
	vnTypes.RemoveAll();
	for(int ii=0; ii < vsSelTypes.GetSize(); ii++)
	{
		int nRet = vsTypeList.Find(vsSelTypes[ii]);
		ASSERT(nRet >= 0 && nRet < vsTypeList.GetSize());
		///Sophy 2/24/2012 ORG-5158-P1 WRONG_DATATYPE_IN_NEWMATRIX_DIALOG
		//vnTypes.Add(nRet);
		vnTypes.Add(vnDataTypeMap[nRet]);
		///end WRONG_DATATYPE_IN_NEWMATRIX_DIALOG
	}
	
	return true;
}

void MatrixObjectZList::GetSettings(Array<MatrixObjectOptions&> &arrObjectOptions)
{	
	int nNumObjects = GetNumRows();
	
	vector<int> vnTypes;
	GetZDataTypes(vnTypes);
	ASSERT(vnTypes.GetSize() == nNumObjects);
	
	for(int index = 0; index < nNumObjects; index++)
	{
		vector<string> vsOneRow;
		GetRowValues(GetRowOffset() + index, vsOneRow, GetColOffset());
			
		MatrixObjectOptions* pstOptions = new MatrixObjectOptions;
		pstOptions->nDataType = vnTypes[index];
		pstOptions->strLN = vsOneRow[ZLIST_COL_LN];
		pstOptions->strUnits = vsOneRow[ZLIST_COL_UNITS];
		pstOptions->strComments = vsOneRow[ZLIST_COL_COMMENTS];
		pstOptions->strFormula = vsOneRow[ZLIST_COL_FORMULA];		
		arrObjectOptions.Add(*pstOptions);
	}
}

void MatrixObjectZList::SetSettings(Array<MatrixObjectOptions&> &arrObjectOptions)
{	
	int nNumObjects = arrObjectOptions.GetSize();
	if( nNumObjects == 0 )
		return;
	
	if( nNumObjects != GetNumRows() )
		SetRows(nNumObjects);
	
	for(int index = 0; index < nNumObjects; index++)
	{
		MatrixObjectOptions& st = arrObjectOptions.GetAt(index);
		
		vector<string> vsOneRow;
		vsOneRow.Add("Z"+(index+1));
		
		string strDataType = STR_COL_INTERNAL_DATA_LIST;
		///Sophy 3/1/2012 ORG-5158-P1 WRONG_DATATYPE_IN_NEWMATRIX_DIALOG
		//strDataType = strDataType.GetToken(st.nDataType, '|');
		int nTypeIndex = find_in_list(st.nDataType, vnDataTypeMap, true);
		ASSERT(nTypeIndex >= 0);
		strDataType = strDataType.GetToken(nTypeIndex, '|');
		///end ///Sophy 2/28/2012 ORG-5158-P1 WRONG_DATATYPE_IN_NEWMATRIX_DIALOG
		vsOneRow.Add(strDataType);
		
		vsOneRow.Add(st.strLN);
		vsOneRow.Add(st.strUnits);
		vsOneRow.Add(st.strComments);
		vsOneRow.Add(st.strFormula);
		SetRowValues(index, vsOneRow, 0);
	}
}

bool MatrixObjectZList::DoApplyAll(int nRow, int nCol)
{
	string strCell = GetCell(nRow, nCol);
	
	vector<string> vs;	
	for(int ii = 0; ii < GetNumRows(); ii++)
	{
		vs.Add(strCell);
	}
	
	return SetColValues(nCol, vs);	
}

void openNewMatrixDlg()
{
	NewMatrixDlg myDlg;
	myDlg.DoModalEx();
}
