/*------------------------------------------------------------------------------*
 * File Name: New3DFunctionPlotDlg												*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE	*
 *	Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *  Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME						*
 *	Folger 05/10/2012 ORG-5657-S1 ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH		*
 *	Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
 *------------------------------------------------------------------------------*/

#ifndef NEW_3D_FUNCTION_PLOT_DLG_H
#define NEW_3D_FUNCTION_PLOT_DLG_H

enum THEME_ID
{
	ID_COLUMNS = 1,
	ID_ROWS,
	ID_1ST_PARAM,
	ID_1ST_FROM,
	ID_1ST_TO,
	ID_2ND_PARAM,
	ID_2ND_FROM,
	ID_2ND_TO,

	ID_1ST_FORMULA,
	ID_2ND_FORMULA,
	ID_3RD_FORMULA,

	ID_PRESCRIPT_SHOW_LT,
	ID_PRESCRIPT,

	ID_LABEL_X_LN,
	ID_LABEL_X_UNIT,
	ID_LABEL_X_COMMENT,
	ID_LABEL_Y_LN,
	ID_LABEL_Y_UNIT,
	ID_LABEL_Y_COMMENT,
	ID_LABEL_Z_LN,
	ID_LABEL_Z_UNIT,
	ID_LABEL_Z_COMMENT,

	ID_ADD_TO_GRAPH,
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	ID_AUTO_RANGE,
	ID_AUTO_RANGE2,
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
};

typedef struct tagNew3DFuncPlotOptions
{
	int		_id(ID_COLUMNS)				nCols;
	int		_id(ID_ROWS)				nRows;
	string	_id(ID_1ST_PARAM)			str1stParam;
	string	_id(ID_1ST_FROM)			str1stFrom;
	string	_id(ID_1ST_TO)				str1stTo;
	string	_id(ID_2ND_PARAM)			str2ndParam;
	string	_id(ID_2ND_FROM)			str2ndFrom;
	string	_id(ID_2ND_TO)				str2ndTo;

	string	_id(ID_1ST_FORMULA)			str1stFormula;
	string	_id(ID_2ND_FORMULA)			str2ndFormula;
	string	_id(ID_3RD_FORMULA) 		str3rdFormula;

	BOOL	_id(ID_PRESCRIPT_SHOW_LT)	bShowLT;
	string	_id(ID_PRESCRIPT)			strPrescript;

	string	_id(ID_LABEL_X_LN)			strXLN;
	string	_id(ID_LABEL_X_UNIT)		strXUnit;
	string	_id(ID_LABEL_X_COMMENT)		strXComment;
	string	_id(ID_LABEL_Y_LN)			strYLN;
	string	_id(ID_LABEL_Y_UNIT)		strYUnit;
	string	_id(ID_LABEL_Y_COMMENT)		strYComment;
	string	_id(ID_LABEL_Z_LN)			strZLN;
	string	_id(ID_LABEL_Z_UNIT)		strZUnit;
	string	_id(ID_LABEL_Z_COMMENT)		strZComment;

	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//BOOL	_id(ID_ADD_TO_GRAPH)		bAddToGraph;
	int		_id(ID_ADD_TO_GRAPH)		nAddToGraph;
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	BOOL	_id(ID_AUTO_RANGE)			bAutoRange;
	BOOL	_id(ID_AUTO_RANGE2)			bAutoRange2;
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
} New3DFuncPlotOptions;

class New3DFunctionPlotDlg : public FunctionPlotDlgBase
{
public:
	New3DFunctionPlotDlg(BOOL bParametric);
	~New3DFunctionPlotDlg();

	DECLARE_MESSAGE_MAP

	///------ Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	virtual	BOOL	CopyTheme(FunctionPlotContext& context);
	///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
	virtual BOOL PasteTheme(FunctionPlotContext& context);
	///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD

	BOOL			OnHelp(int &nHelpID, int nIdCtrlFocus);
	
protected:
	BOOL OnInitDialog();
	BOOL OnReady();

	BOOL OnTabChange(Control ctrl);

	BOOL On1stInsert(Control ctrl);
	BOOL On2ndInsert(Control ctrl);
	BOOL On3rdInsert(Control ctrl);

	BOOL OnPreInsert(Control ctrl);
///------ Sen 7/27/11 ORG-3342-P1 ADD_ERR_MSG_FOR_FORMULA_EMPTY	
//	BOOL OnOKButtonClick(Control ctrl);
	BOOL OnOKButtonClick();
///------ End ADD_ERR_MSG_FOR_FORMULA_EMP
	BOOL OnParamChange(Control cntrl);

private:
	void setCtrlTitle();
	void getShowControls(int nTabType, vector<uint> & vnCtrlIDs);
	void moveControl();
	void moveControlsInScaleGroup();
	
	/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
	int  getGap(bool bIsX);
	int	 getXGap();
	int	 getYGap();
	///End MEASURE_CONTROL_POSITION

	void init3DFuncDlgControlPosition();
	void init3DParamDlgControlPosition();

	virtual	void	GetDefaultSettings();
	virtual	void	LoadThemeSettings();
	virtual	BOOL	SaveThemeSettings();
	virtual	void	LoadSettingsTree(TreeNode& trSettings);
	virtual	void	SaveSettingsTree(TreeNode& trSettings);

	// message handle helper
	bool checkParameterLength();
	bool checkParameterName();/// Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME
	void changeLabel();
	void resizeLabelControl();
	void getParameterString(string & str);

protected:
	virtual	int	Gap()					{ return 6; }

private:
	virtual	string		DialogTitle();
	virtual	string		ClassOption();
	virtual	void		UpdateLabelCntrlsText();
	virtual	void		GetCntrlFixedFont(vector<int>& vnIDs);

	virtual	void		InitControls();
	virtual	void		ResizeDlg();
	virtual	void		GetCntrlIDs(int nTab, vector<uint>& vnIDstoShow, vector<uint>& vnIDstoHide);
	virtual	BOOL		IsShowAddToGraph();
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	virtual	void		CheckUpdateRangeFromTo();
	virtual	void		CheckShowAutoRange();
	virtual	void		CheckSetAutoRange(BOOL bOn);
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

	string				MakeOneData(LPCSTR lpcszData, LPCSTR lpcszFormula);
	MatrixLayer			CreateData();
	BOOL				UpdateLabels(MatrixLayer& ml);
	BOOL				MakePlot(MatrixLayer& ml, GraphLayer& gl);
	BOOL 				IsFormulaEmpty();

	BOOL				Is3DGLOn();  ///------ Folger 05/10/2012 ORG-5657-S1 ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH

private:
	Edit					m_edtNumCols;
	Edit					m_edtNumRows;
	New3DFuncPlotOptions	m_settings;
};

#endif // NEW_3D_FUNCTION_PLOT_DLG_H

