/*------------------------------------------------------------------------------*
 * File Name: New2DFunctionPlotDlg												*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE	*
 *	Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *	Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME						*
 *	Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
 *	Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
 *------------------------------------------------------------------------------*/

#ifndef NEW_2D_FUNCTION_PLOT_DLG_H
#define NEW_2D_FUNCTION_PLOT_DLG_H

enum
{
	ID_PARAM_NAME = 1,
	ID_POINTS,
	ID_X_FROM,
	ID_X_TO,
	ID_FORMULAR,
	ID_Y_FORMULAR,
	ID_PRESCRIPT_SHOW_LT,
	ID_DEFINITIONS,
	ID_Y_LN,
	ID_Y_UINTS,
	ID_Y_COMMENTS,
	ID_X_LN,
	ID_X_UINTS,
	ID_X_COMMENTS,
	ID_ADD_TO_GRAPH,
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	ID_AUTO_RANGE,
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
};

typedef struct tagFunctionPlotOptions
{
	string		_id(ID_PARAM_NAME)			strParamName;
	int			_id(ID_POINTS)				nPoints;
	string		_id(ID_X_FROM)				strFrom;
	string  	_id(ID_X_TO)				strTo;
	string		_id(ID_FORMULAR)			strFormular;
	string		_id(ID_Y_FORMULAR)			strYFormular;
	BOOL		_id(ID_PRESCRIPT_SHOW_LT)	bShowLT;
	string		_id(ID_DEFINITIONS)			strDefinitions;
	string		_id(ID_Y_LN)				strYLN;
	string		_id(ID_Y_UINTS)				strYUnits;
	string		_id(ID_Y_COMMENTS)			strYComments;
	string		_id(ID_X_LN)				strXLN;
	string		_id(ID_X_UINTS)				strXUnits;
	string		_id(ID_X_COMMENTS)			strXComments;	
	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//BOOL		_id(ID_ADD_TO_GRAPH)		bAddToGraph;
	int		_id(ID_ADD_TO_GRAPH)			nAddToGraph;
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	BOOL		_id(ID_AUTO_RANGE)			bAutoRange;
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
}FunctionPlotOptions;

class New2DFunctionPlotDlg : public FunctionPlotDlgBase
{
public:
	New2DFunctionPlotDlg(BOOL bParametric);
	~New2DFunctionPlotDlg();

	DECLARE_MESSAGE_MAP

	///------ Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	virtual	BOOL	CopyTheme(FunctionPlotContext& context);
	///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
	virtual BOOL PasteTheme(FunctionPlotContext& context);
	///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD

	BOOL			OnHelp(int &nHelpID, int nIdCtrlFocus);

protected:
	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnTabChange(Control ctrl);
	BOOL On1stFormulaClick(Control ctrl);
	BOOL On2ndFormulaClick(Control ctrl);
	BOOL OnPrescriptClick(Control ctrl);
	BOOL OnAfterParamNameEdit(Control cntrl);
	///------ Sen 7/27/11 ORG-3342-P1 ADD_ERR_MSG_FOR_FORMULA_EMPTY
//	BOOL OnOK(Control cntrl);
	BOOL OnOK();
	///------ End ADD_ERR_MSG_FOR_FORMULA_EMP	

private:	
	void resizeDlg();
	void resizeTab();
	bool getControlIDs(int nTab, vector<uint>& vnIDsToShow, vector<uint>* pvnIDsToHide, int* pTopMostCtrl = NULL, int* pLeftMostCtrl = NULL);
	void moveControls();
	
	void init2DFuncDlgControlPosition();
	void init2DParamDlgControlPosition();
	
	virtual	void	GetDefaultSettings();
	virtual	void	LoadThemeSettings();
	virtual	BOOL	SaveThemeSettings();
	virtual	void	LoadSettingsTree(TreeNode& trSettings);
	virtual	void	SaveSettingsTree(TreeNode& trSettings);
	
	void changeControlWidthByTextLength(Control& ctrl, int nRightSideControlID);
	void updateFormularControlLabel();	
	
	string EnumName(LPCSTR lpcszName);
	bool newFuncPlot(int nPoints, LPCSTR lpcszFrom, LPCSTR lpcszTo, LPCSTR lpcszFormular, LPCSTR lpcszDsName, LPCSTR lpcszPreScript);
	bool newParamFuncPlot(int nPoints, LPCSTR lpcszFrom, LPCSTR lpcszTo, LPCSTR lpcszXFormular, LPCSTR lpcszYFormular, LPCSTR lpcszParamName, LPCSTR lpcszDsXName, LPCSTR lpcszDsYName, LPCSTR lpcszPreScript);
	
	virtual	string		DialogTitle();
	virtual	string		ClassOption();
	virtual	void		UpdateLabelCntrlsText();
	virtual	void		GetCntrlFixedFont(vector<int>& vnIDs);

	virtual	void		InitControls();
	virtual	void		ResizeDlg();
	virtual	void		GetCntrlIDs(int nTab, vector<uint>& vnIDstoShow, vector<uint>& vnIDstoHide);
	virtual	BOOL		IsShowAddToGraph();
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	virtual	void		CheckUpdateRangeFromTo();
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

	bool 				checkParameterName();	/// Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME

	string				ValidDataName(LPCSTR lpcszData);
	string				MakeOneData(LPCSTR lpcszData, LPCSTR lpcszFormula);
	Worksheet			CreateData(Dataset& dsY);
	BOOL				UpdateLabels(Worksheet& wks, Dataset& dsY);
	BOOL				MakePlot(Worksheet& wks, Dataset& dsY, GraphLayer& gl);
	BOOL 				IsFormulaEmpty();

private:
	Edit					m_edtPoints;
	FunctionPlotOptions		m_settings;
};

#endif //NEW_2D_FUNCTION_PLOT_DLG_H
