/*------------------------------------------------------------------------------*
 * File Name:NLFitDlg.c/h	 													*
 * Creation: CPY 05-05-2008														*
 * Purpose: Main OC code for NLFit Dialog										*
 * Copyright (c) Originlab Corp. 1992-2008										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG	*
 *	Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION					*
 *	Max 06/10/08 v8.0881 CENTRALIZE_TIP_STRINGS_FOR_BUTTONS_IN_NLFIT_AND_PA		*
 *	Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE	*
 *	Sim 09-05-2008 CLEAN_DEFAULT_THEME											*
 *	Kyle 09/10/08 CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW	*
 *	Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE									*
 *	Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER*
 *	Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG				*
 *	Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN			*
 *	Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION								*
 *	Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE		*
 *	Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX					*
 *	Hong 10/09/08 v8.0953 TAKE_BACK_MECHANISM_OF_FDF_CHANGE_INDICATOR			*
 *	Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE				*
 *	Hong 10/15/08 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE			*
 *	Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE			*
 *	Sophy 10/20/2008 NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON					*
 *	Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
 *	Kyle  10/22/08  QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL					*
 *	Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA						*
 *	Folger 10/24/08 v8.0960 CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE	*
 *	Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB						*
 *  Iris 10/28/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON				*
 *	Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE							*
 *	Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
 *	Hong 11/06/08 v8.0966c FIX_FIT_STATUS_MSG_NOT_SHOW_IN_MIDDLE_PANEL			*
 *	Hong 11/06/08 v8.0966c FIX_SIMPLEX_BTN_NOT_DISABLED_WHEN_NO_DATA_SET		*
 *	Sophy 11/7/2008 QA80-12510 ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
 *	Sophy 11/11/2008 v8.968c QA80-12567 SWITCH_BETWEEN_FIT_MODE_SHOULD_NOT_ALWAYS_INIT_PARAMS
 *	Sophy 11/12/2008 SUPPORT_CONTEXT_MENU_COMMAND_TO_UPDATE_PARAM_GRID_CONTROL	*
 *	Sophy 11/22/2008 DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG							*
 *	Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
 *	Sophy 11/26/2008 v8.980 SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG			*
 *	Sophy 12/3/2008 v8.0982 IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS	*
 *	Sophy 12/4/2008 v8.0982b NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
 *	Hong 12/10/08 v8.0984d ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS				*
 *	Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL			*
 *	Hong 12/12/08 QA80-12733 ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
 *	Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
 *	CPY 12/29/08 CHK_ELAPSED_TIME_FOR_OC_DIALOG_TO_OPEN_TOO_SLOWLY				*
 *	Sophy 12/31/2008 v8.0992c QA80-12425-P2 FIX_NLFIT_PARAM_TAB_CONFIG_CANNOT_BE_LOADED_CORRECTLY
 *	Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
 *	Folger 12/31/08 QA80-12878 v8.0992b IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM	*
 *	Kyle 01/16/2009 CHECK_LAST_ITERATE_OUTCOME									*
 *	Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN		*
 *	Hong 01/22/09 ADD_SEPARATOR_AFTER_UPDATE_ASKED_MAX							*
 *	Hong 01/23/09 REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
 *	Kyle 01/23/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL				*
 *	Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU				*
 *  Iris 2/05/2009 FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY					*
 *	Folger 02/11/09 QA80-13098-S2 SHOW_CHISQR_INFO_IN_NLFIT_STATIC_MESSAGE		*
 *	Folger 02/11/09 QA80-13098-P1 NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN	*
 *	Folger 02/17/09 ADD_NLFIT_DEFAULT_HELPID									*
 *	Folger 02/18/09 BOUNDS_TAB_F1_MAPPING_NOT_WORKING							*
 *	Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING		*
 *	Hong 04/03/09 QA80-11466 FIX_NO_ASTERISK_WHEN_RESELECT_CHANGED_FDF_FUNCTION	*
 * Kenny 04/13/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG					*
 *	Folger 04/20/09 F1_HELP_MAPPING_ON_HIDE_PARAM_DIALOG_IN_NLFIT_AND_PA		*
 *	Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
 *	Hong 07/03/09 QA80-13590-P6 FUNC_FURMULA_NOT_UPDATED_WHEN_CHANGE_FUNC_IF_ACTIVE
 *	Hong 07/03/09 QA80-13590-P6 HIDE_FORMULA_CTRL_IF_USERDEFINE_FUNC_NO_FORMULA_PREIVEW
 *	Hong 07/03/09 QA80-13590 SHOULD_CHECK_SWITCH_TO_MSG_TAB_IF_FIT_FAIL_ASKED_MAX
 *	Hong 07/31/09 QA80-13590-P7 ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_ACTIVE
 *	Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS*
 *	Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING					*
 *  Iris 1/06/2009 QA81-14920 HINT_FOR_PARAM_BOUNDS_TAB							*
 *	Hong 01/12/10 QA80-13590-P7 ALWAYS_ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG		*
 *	Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN			*
 *	Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
 *	Jasmine 06/11/10 ORG-2 __NEW_FITTING_FUNCTION_WIZARD__						*
 *	Jasmine 06/23/10 ORG-2-P8 EDIT_FUNC_BTN_AVAILABLE_IF_FUNCTION_READY			*
 *	Folger 10/14/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
 *	Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE				*
 *	Kit 12/09/2010 ORG-1532-S6 ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT			*
 *	Sophy 12/16/2010 ORG-1769-P1 PROPER_INIT_PREVIEW_GRAPH_ON_FIT_PARAMETER_CHANGE
 *	Kit 12/20/2010 ORG-1756-S1 ADD_HINT_FOR_NLFIT_AND_SURFACE_FITTING_WITH_HOW_MANY_PEAKS_WILL_FITTING
 *	Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
 *	Kit 12/29/2010 ORG-1532-P7 AUTO_PARAMETER_CHECK_BOX_CAN_NOT_SHOW			*
 *	Kit 01/26/2011 ORG-2120-S1 OPEN_NLFIT_SHOULD_ACTIVE_SETTING					*
 *	Kit 01/28/2011 ORG-2120-S2 USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB
 *	Folger 04/13/2011 ORG-1871-P2 NLFIT_FAILED_TO_LOAD_HINT_IN_J				*
 *	Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE		*
 *	Folger 05/05/2011 ORG-2773-P1 CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
 *	Folger 05/19/2011 ORG-2773-P2 HIDE_PARAMS_DIALOG_FAILED_IN_NLFIT			*
 *	Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
 *	Folger 07/14/2011 ORG-3257-P1 NLFIT_SEELCT_DATA_TO_FIT_COMBO_TO_NARROW		*
 *	Sim 2011-07-25 ORG-3328 SUPPORT_DEFINE_LT_FUNC_BODY_FOR_FDF					*
 *	Folger 08/08/2011 ORG-2740-P6 PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
 *	Folger 08/11/2011 ORG-2740-S3 PROPER_HINT_TEXT_FOR_NLFIT_BUTTONS			*
 *	Folger 08/11/2011 ORG-2740-S4 HIDE_SELECT_DATA_COMBO_WHEN_NO_APPROPRIATE	*
 *	Folger 08/25/2011 ORG-2740-P1 ON_PARAM_COLUMN_CONTEXT_MENU_SHOULD_NOT_CHANGE_CURRECT_ACTIVE_DATASET
 *	Folger 10/10/2011 ORG-2740-P10 SEPERATE_FIT_DATASET_FAILED_AFTER_REDUCED_CHISQR
 *	Folger 10/14/2011 ORG-3257-P1 NLFIT_DATA_COMBO_BECOME_NARROW_AFTER_ROLL_UP	*
 *  Iris 11/28/2011 ORG-4457-P2 FIX_NLFIT_DLG_REDRAW_ISSUE						*
 *	Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN		*
 *  Iris 3/12/2012 ORG-5254-P1 FIX_STATIC_MSG_BOX_ALWAYS_HIDDEN					*
 *  Iris 3/19/2012 ORG-5293-P4 NOT_TO_ALLOW_SET_CONSTRAINTS_FOR_IMPLICT_FUNC	*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>  
#include "DialogEx.h"
#include "FitCommon.h"

/// ML 8/28/2006 MULTIPLE_DEPS_INDEPS_NLFIT
#include "nlsf_utils.h"
/// end MULTIPLE_DEPS_INDEPS_NLFIT

/// NLF_81 Iris must put before NLFitSession.h and keep this order
#include "NumFunctionOrganizer.h"
//#include "NLFitSelFunction.h" // Hong 11/06/08, no need include here, as NLFitSession.h have already include it
#include "NLFitSession.h"
///end NLF_81 Iris


//#include "FitNL.h"

#ifdef _FOR_SMART_LOADING_ONLY
#include "wksOperation.h" //---- CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER
#include "analysis_utils.h"
#include <stats_utils.h>
#include "stats_guis.h"
#include "stats_operations.h"
#endif

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
#include "curve_utils.h" ///Arvin 03/13/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said

//---- CPY 4/28/06 NLFT_MOVED_TO_USE_DYNA_CNTRL
//#include "TreeEditSplitter.h"
#include "SplitterControl.h"
#include "DynaSplitter.h"
#include "DynaCBSplitter.h" //--CPY 10/5/06
//----


#include <ocGDI.h>	///Jasmine 06/11/07 LOAD_SAMPLE_EQUATION_AND_CURVE_OF_USER_DEFINE_FUNC
#include <Profiler.h>
//--- CPY 12/29/08 CHK_ELAPSED_TIME_FOR_OC_DIALOG_TO_OPEN_TOO_SLOWLY
#ifdef NLF_DEBUG
	#define PROFILE_HRGLASS			Profiler junk;
#else
	#define PROFILE_HRGLASS			waitCursor junk;
#endif
#define _SHOW_TIME					//Profiler junk;

//--- end8 CHK_ELAPSED_TIME_FOR_OC_DIALOG_TO_OPEN_TOO_SLOWLY

#define WM_USER_NLF_ON_FIT_CURVE_OPTIONS_CHANGE	(WM_USER + 1060)  /// Iris 07/03/06 UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE
#define WM_USER_NLF_ON_DATA_CHANGE				(WM_USER + 1070)  /// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB
#define WM_USER_ON_UPDATE_RESIDUAL_CONTOUR_LEVELS	(WM_USER + 1080) /// Iris 8/08/06 IMPROVE_RESIDUAL_PREVIEW
///Joseph 12/11/06 ADD_BITMAP_BUTTON
#define	WM_USER_NLF_SHOW_ERR_MSG (WM_USER + 1090)
#define WM_USER_NLF_BUTTON_ENABLE (WM_USER + 1100)
///End ADD_BITMAP_BUTTON

/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
#define	WM_USER_NLF_NUM_REPLICA_CHANGE (WM_USER + 1110)
///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS	
#define WM_USER_NLF_UPDATE_PARAMSINIT_AND_CONSTRAINT_SHOW (WM_USER + 1120)
///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
/////Cheney 2007-5-16 UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC
//#define WM_USER_NLF_UPDATE_PARAMSINIT_ENABLE (WM_USER + 1130)
/////edn UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC
#define WM_USER_NLF_UPDATE_PARAM_INIT_LINEAR_CONSTRAINTS_ENABLE (WM_USER + 1130)
///end UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC

//---- CPY 5/24/07 FO_COMPILE_ERR_MOVED_WM_USER_EVENT_ID, I have moved this to NLFitParaControl.h
//#define WM_USER_NLF_UPDATE_FDF_FILE_VALUE  (WM_USER + 1140)///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
//----

#define WM_USER_VALUE_CHANGED_NEED_SAVE_FDF	 (WM_USER + 1150)///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
/////Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
//#define WM_USER_NLF_UPDATE_PARAM_INIT_FROM_GRID (WM_USER + 1160)
/////end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
#define WM_USER_NLF_UPDATE_ONE_LINE_MSG (WM_USER + 1170) ///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON	
#define WM_USER_NLF_ON_CHANGE_FUNC_HELP	(WM_USER + 1180)	///Jasmine 09/18/07 QA70-10393 NLFIT_HINTS

#define		WM_NLFITDLG_UPDATE			(WM_USER + 1190)

#define	WM_USER_SELECT_TOP_TAB			(WM_USER + 1300)	///Jasmine 10/29/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB

///------ Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
#define		WM_USER_ACTIVE_BOTTOM_TAB		(WM_USER + 1310)
///------ End ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS

#define STR_NLF_HINT_FILE		"NLSFHints.txt"	///Jasmine 09/18/07 QA70-10393 NLFIT_HINTS

/// end NLFITTER_OPERATION_IMPLEMENTATION
///Joseph 12/11/06 ADD__BITMAP_BUTTON
#define	NLSF_BUTTON_GAP	2	
///End	ADD__BITMAP_BUTTON
#define STR_DLG_NAME "Non-Linear Fitting"
enum {NLF_SETTING_TAB, NLF_CODE_TAB};//, NLF_PARAMETERS_TAB, NLF_PARABOUND_TAB};///Jasmine 02/09/06 ADD_PARA_BOUND_TAB ///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB

enum {NLF_FIT_CURVE_PREVIEW_TAB, NLF_RESIDUAL_PREVIEW_TAB, NLF_FORMULA_TAB, NLF_SAMPLE_CURVE_TAB, NLF_MESSAGES, NLF_FUNCTION_FILE_TAB, NLF_OPERATION_HINT_TAB};

//#include "NLFitParaControl.h"
//#include "NLFitParaColControl.h" /// Hong 01/30/08 QA80-10929 MOVE_TO_SEPARATE_FILE_FOR_DERIVED_USE
/// ML 5/14/2008
//#include "CheckMenu.h"
/// end ML 5/14/2008
#include "GridTableControl.h"
#include "NLFitParaControl.h"
#include "ParameterTabs.h"			///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
#include "NLFitPreviewCtrl.h"
#include "SurfaceFitPreviewCtrl.h"
#include "NLFitSplitter.h"
#include "FOFunctPrev.h"
#include "GraphPageControl.h"
#include "FunctionMgr.h"
#include "NLFitting.h"

/// AW 10/26/07 WRONG_LOCALIZE_MACRO
#define _SHOW_MORE_				_L("Show More")
#define _SHOW_LESS_ 			_L("Show Less")
#define _FORMULA_				_L("Formula")
#define _SAMPLE_CURVE_			_L("Sample Curve")
#define _MESSAGES_				_L("Messages")
#define _FUNCTION_FILE_			_L("Function File")
/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
#define _FIT_CURVE_PREVIEW_		_L("Fit Curve")
#define _RESIDUAL_PREVIEW_ 		_L("Residual")
#define _HINTS_					_L("Hints")
///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
/// END  WRONG_LOCALIZE_MACRO
/// Hong 04/24/08 QA80-11468 SPEED_UP_FITTING_BY_ONLY_PREVIEW_WHEN_NECESSARY
#define		NLFIT_SPEED_UP_ONLY_PREVIEW_NECESSARY
/// end SPEED_UP_FITTING_BY_ONLY_PREVIEW_WHEN_NECESSARY

static HWND s_hdlg;
#define		NUM_HEIGHT_OF_ONE_LINE_MESSSAGE		16  


void PostMsgToNLFitDlg()
{
	Window win(s_hdlg);
	if(win)
	{
		win.PostMessage(WM_USER_ON_UPDATE_RESIDUAL_CONTOUR_LEVELS);
	}
}

int 	NLFitDlg::DoModalEx(TreeNode& trOp, NLFitSession* pFitSession, HWND hWndParent, const TreeNode& trFDF) // = NULL, NULL
{
	if ( !pFitSession )
		return IDCLOSE;
	
	m_NLF.SetOpTree(trOp);		
	m_NLF.SetFitSession(pFitSession);		
	if ( trFDF )
		m_NLF.SetFDFTree(trFDF);

	InitMsgMap();
	DWORD	dwDlgOptions = DLG_NO_DEFAULT_REPOSITION;
	return DoModal(hWndParent, dwDlgOptions);
}

int 	NLFitDlg::Create(HWND hWndParent, int nOption, TreeNode& trFitInfo)
{
	m_nFuncOption = nOption;
	
	if(trFitInfo)
	{
		/// Iris 9/19/06 v8.0483 CLEANUP_SEPARATE_PFM_CODES
		//m_NLF.SetPFMTree(trPFM); 
		m_NLF.SetFitInfoTree(trFitInfo);
		///End CLEANUP_SEPARATE_PFM_CODES
	}
	
	InitMsgMap();
	
	DWORD dwDlgOptions = 0;
	//--- CPY 7/8/03 QA70-4796 v7.0620 GET_N_BOX_EVENT_FUNC_MOVE_WIN
	//if(hWndParent)
	//	dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;
	//---
	
	int nRet = MultiPaneDlg::Create(hWndParent, dwDlgOptions);
	Visible=true;
	return nRet;
}
	
BEGIN_MESSAGE_MAP(NLFitDlg)
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	
	ON_SYSCOMMAND(OnSystemCommand)	///DG 7/19/05
	
	ON_HELPINFO(OnHelp)		//------ Folger 11/13/07 GET_TAB_CHM_HELP
	
	ON_GETMINMAXINFO(OnMinMaxInfo)
	ON_INIT_SIZE(OnInitSize)
	ON_BN_CLICKED(IDC_NLF_SHOW_BOTTOM, OnShowBottomPane)
	ON_BN_CLICKED(IDC_NLF_SHOW_TOP, OnShowTopPane)
	
	ON_TAB_SEL_CHANGE(IDC_NLF_SETTING_TAB, OnTopTabChange)
	ON_TAB_SEL_CHANGE(IDC_NLF_VIEW_TABS, OnBottomTabChange)
	
	ON_CBN_SELCHANGE(IDC_THEME_COMB, OnComboChangeTheme)
	ON_BN_CLICKED(IDC_SAVE_BTN, OnSaveTheme)
	ON_BN_CLICKED(IDC_SAVE_AS_BTN, OnSaveThemeAs)

	ON_OK(OnClickOK)
	ON_CANCEL(OnClickCancel)
	ON_BN_CLICKED(IDC_NLF_DONE, OnClickDone) /// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	
	ON_CONTEXTMENU(OnShowMenu)	///Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	
	ON_BN_CLICKED(IDC_NLF_FIT, OnClickFit)
	ON_BN_CLICKED(IDC_NLF_ONE_LTER, OnClickOneIter)
	ON_BN_CLICKED(IDC_NLF_CHI_SQ, OnClickChiSQ)
	ON_BN_CLICKED(IDC_NLF_PARAM_INIT, OnClickInit)
	///Joseph 12/11/06 ADD__BITMAP_BUTTON
	ON_BN_CLICKED(IDC_NLF_OPENFO, OnClickOpenFO);  
	ON_BN_CLICKED(IDC_NLF_SAVE_FDF, OnClickSaveFDF); 
	///End ADD__BITMAP_BUTTON
	ON_BN_CLICKED(IDC_NLF_NEWFO, OnClickNewFO);	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	
	ON_BN_CLICKED(IDC_NLF_QUICK_SET, OnQuickSetParam) 		///Kyle 10/22/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	
	ON_BN_CLICKED(IDC_NLF_SORT_PEAKS, OnSortPeaks)	 		//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	ON_BN_CLICKED(IDC_NLF_REORDER_PEAKS, OnReorderPeaks)
	//------
	
	ON_BN_CLICKED(IDC_BTN_PARAM_HIDE, OnClickParamHide);  /// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
	
	/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	//ON_USER_MSG(WM_USER_NLF_NUM_REPLICA_CHANGE, OnNumReplicaChange)
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
	//ON_BN_CLICKED(IDC_CHECK_APPLY_PARAM_SETTINGS, OnClickApplyParamSettings)
	///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY
	ON_BN_CLICKED(IDC_CHECK_AUTO_INIT_PARAMS, OnClickEnableAutoInitParams)
	///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	///Cheney 2007-6-6 SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT
	ON_BN_CLICKED(IDC_CHECK_CONSTRAINTS, OnClickEnableLinearConstraints)
	///end SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT
	///Arvin 03/31/08 QA70-11322 ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	ON_BN_CLICKED(IDC_CHECK_AUTO_UPDATE, OnClickAutoUpdate)
	///END ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
	/////Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//ON_BN_CLICKED(IDC_CHECK_APPLY_BOUND_SETTINGS, OnClickApplyBoundSettings)
	/////end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY
	
	ON_BN_CLICKED(IDC_NLF_SIMPLEX, OnClickSimplex)  ///Joseph 06/22/07 v8.0647 ADD_NLF_SIMPLEX_BUTTON
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	//ON_USER_MSG(WM_USER_NLF_ON_DATA_CHANGE, OnDataChange)  /// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB
	//ON_USER_MSG(WM_USER_NLF_ON_PARAM_CHANGE, OnParamChange)
	//centralized in OnNLFitDlgUpdate
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	ON_USER_MSG(WM_USER_NLF_ON_FIT_CURVE_OPTIONS_CHANGE, OnFitCurveOptionsChange) /// Iris 07/03/06 UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE
	
	ON_USER_MSG(WM_USER_NLF_QUICK_SET_PARAMETER_VALUE_CHANGE, OnQuickSetParameterChange)	///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
	
	ON_USER_MSG(WM_USER_NLF_RESET_BOUNDS, OnResetParamBounds) /// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU

	/// EJP 2007-04-06 v8.0597 ALLOW_COPY_FROM_NLFIT_MESSAGE_LOG
	// The log should be made read-only by setting RichEdit ctrl to
	// read-only instead of handling ON_KEY events.
	///	///Frank  9/10/04 v8.0130 MOVE_OPERATION_LOG_TO_SESSION_CLASS
	///	ON_KEY(IDC_NLS_OPERATION_LOG, OnKeyDownWindow)
	///	///End MOVE_OPERATION_LOG_TO_SESSION_CLASS
	/// end ALLOW_COPY_FROM_NLFIT_MESSAGE_LOG
	ON_KEY(IDC_FUNCTION_CODE_SHOW, OnKeyDownWindow)

	//--- vsFlex realted
	ON_GRID_BEFORE_EDIT(IDC_NLF_PARACONTROL_GRID, OnBeforeEditParaControl)
	ON_GRID_AFTER_EDIT(IDC_NLF_PARACONTROL_GRID, OnAfterEditParaControl)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_NLF_PARACONTROL_GRID, OnBeforeMouseDownParaControl)
	ON_GRID_MOUSE_MOVE(IDC_NLF_PARACONTROL_GRID, OnMouseMoveParaControl)
	//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	//ON_GRID_BUTTON_CLICK(IDC_NLF_PARACONTROL_GRID, OnGridButtonClick)
	ON_GRID_DBLCLICK(IDC_NLF_PARACONTROL_GRID, OnGridDBClick)
	//------ End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	//---
	
	/// Bill ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	 ON_GRID_AFTER_MOVE_COLUMNS(IDC_NLF_PARACONTROL_GRID, OnAfterMoveColumns)
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
	
	/// YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
	//ON_BN_CLICKED(IDC_INTERACTIVE_DLG_BUTTON, OnInteractiveDataRange)
//---- CPY 4/28/06 NLFT_MOVED_TO_USE_DYNA_CNTRL
//	ON_CHANGE_SELECTION(OnSelectionChange)
//	ON_SELECTION_TRACK(OnSelectionTrack)
//----
	/// end NLFITTER_OPERATION_IMPLEMENTATION
	ON_GRID_COMBO_CLOSEUP(IDC_NLF_PARACONTROL_GRID, OnGridComboCloseUp)	///Jasmine 03/09/06 ADD_EVENT_COMBO_CLOSE_UP
	ON_USER_MSG(WM_USER_ON_UPDATE_RESIDUAL_CONTOUR_LEVELS, OnClickUpdateResidual)/// Iris 8/08/06 IMPROVE_RESIDUAL_PREVIEW
	///Joseph 12/11/06 ADD_BITMAP_BUTTON
	//ON_USER_MSG(WM_USER_NLF_SHOW_ERR_MSG , OnResizeErrMsg)///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	//ON_USER_MSG(WM_USER_NLF_BUTTON_ENABLE, OnButtonEnable)///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	///End ADD_BITMAP_BUTTON
	
	///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	ON_INIT_SIZE(OnInitSize)	
	ON_RESTORESIZE(OnRestoreSize)
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	
	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS	
	ON_USER_MSG(WM_USER_NLF_UPDATE_PARAMSINIT_AND_CONSTRAINT_SHOW, updateParamsInitAndConstrShow)
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	/////Cheney 2007-5-16 UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC
	//ON_USER_MSG(WM_USER_NLF_UPDATE_PARAMSINIT_ENABLE, updateParamsInitEnable)
	/////end UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC
	/// Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	//ON_USER_MSG(WM_USER_NLF_UPDATE_PARAM_INIT_LINEAR_CONSTRAINTS_ENABLE, updateParamsInitAndLinearConstraEnable)
	/// end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC

	///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	ON_USER_MSG(WM_USER_NLF_UPDATE_FDF_FILE_VALUE, OnChangeFDFFileValue)	
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//ON_USER_MSG(WM_USER_VALUE_CHANGED_NEED_SAVE_FDF, SaveFDFOnValueChanged)
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	///End ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	// No need, as Grid is only for display and do NOT keep setttings anymore
	/////Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//ON_USER_MSG(WM_USER_NLF_UPDATE_PARAM_INIT_FROM_GRID, UpdateFitSessionParamsFromGrid)
	/////end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	//// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	//ON_USER_MSG(WM_USER_NLF_UPDATE_ONE_LINE_MSG, UpdateOneLineMessageBox) ///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON	
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	ON_USER_MSG(WM_USER_NLF_ON_CHANGE_FUNC_HELP, OnUpdateHints)	///Jasmine 09/18/07 QA70-10393 NLFIT_HINTS	
	
	ON_USER_MSG(WM_NLFITDLG_UPDATE, OnNLFitDlgUpdate)
	ON_USER_MSG(WM_USER_SELECT_TOP_TAB, SelTopTab)	///Jasmine 10/29/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB

	///------ Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
	ON_USER_MSG(WM_USER_ACTIVE_BOTTOM_TAB, OnActiveBottomTab)
	///------ End ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
	
	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifdef THEME_CONTROL_POPUP_MENU
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	/*
	ON_USER_MSG(WM_USER_DIALOG_ON_THEME_SAVE, OnThemeSave)
	ON_USER_MSG(WM_USER_DIALOG_ON_THEME_SAVE_AS, OnThemeSaveAs)
	ON_USER_MSG(WM_USER_DIALOG_ON_THEME_COMBO_CHANGE, OnThemeChange)
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	ON_USER_MSG(WM_USER_DIALOG_ON_THEME_SETTING, OnThemeSetting)
	ON_USER_MSG(WM_USER_DIALOG_IS_THEME_SETTING, IsThemeSetting)
	///---END QA80-11371 THEME_SAVING_OPTIONS
	*/
	///---Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	//ON_USER_MSG(WM_USER_DIALOG_ON_LOAD_THEME, OnLoadTheme)
	///---END QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
#endif
	//------
	
	/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	ON_DATA_CHANGE(OnDataChangebyUserEdit)	
	/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	
	/// Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
	ON_USER_MSG(WM_USER_MODAL_CLICK_OUTSIDE, OnClickOutside)
	/// end NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS

	///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	ON_CBN_SELCHANGE(IDC_FITTING_DATA, OnDataComboChange)
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	
END_MESSAGE_MAP

///------ Folger 12/31/08 QA80-12878 v8.0992b IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
#ifdef _DEBUG
class ElapsedTimeCheckingHelper
{
public:
	ElapsedTimeCheckingHelper(LPCSTR lpcsz = "")
	{
		str = lpcsz;
		_CHK_ELAPSED_TIME("Enter " + str);
	}
	~ElapsedTimeCheckingHelper()
	{
		_CHK_ELAPSED_TIME("Exit " + str);
	}
private:
	string		str;
};
#endif
///------ End IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM

BOOL 	NLFitDlg::OnInitDialog()
{
//	PROFILE_HRGLASS
#ifdef _DEBUG
	///------ Folger 12/31/08 QA80-12878 v8.0992b IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
	//_CHK_ELAPSED_TIME("Enter OnInitDialog")
	ElapsedTimeCheckingHelper		clHelper("OnInitDialog");
	///------ End IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
#endif

	//Profiler jj;
	/// AW 10/26/07 WRONG_LOCALIZE_MACRO
	//vector<string>  vstrTipsUpDown = {"Show More", "Show Less"};
	//vector<string> vsBottomTabs = {"Formula", "Sample Curve", "Messages","Function File"};
	vector<string>  vstrTipsUpDown;
	vstrTipsUpDown.Add(_SHOW_MORE_);
	vstrTipsUpDown.Add(_SHOW_LESS_);
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	/*
	vector<string> vsBottomTabs;
	vsBottomTabs.Add(_FORMULA_);
	vsBottomTabs.Add(_SAMPLE_CURVE_);
	vsBottomTabs.Add(_MESSAGES_);
	vsBottomTabs.Add(_FUNCTION_FILE_);
	/// END WRONG_LOCALIZE_MACRO
	///------ Folger 10/14/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
	//MultiPaneDlg::OnInitDialog(IDC_NLF_SETTING_TAB, IDC_NLF_SHOW_BOTTOM, IDC_NLF_VIEW_TABS, vstrTipsUpDown, STR_DLG_NAME, IDC_NLF_SHOW_TOP, vsBottomTabs);
	MultiPaneDlg::OnInitDialog(IDC_NLF_SETTING_TAB, IDC_NLF_SHOW_BOTTOM, IDC_NLF_VIEW_TABS, vstrTipsUpDown, STR_DLG_NAME, IDC_NLF_SHOW_TOP, vsBottomTabs, 250, NULL, MULTIPANEDLGINIT_RESET_PANE_SIZE_IF_TOO_SMALL);
	///------ End MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
	*/	
	UpdateBottomPaneSubControls();
	
	MultiPaneDlg::OnInitDialog(IDC_NLF_SETTING_TAB, IDC_NLF_SHOW_BOTTOM, IDC_NLF_VIEW_TABS, vstrTipsUpDown, STR_DLG_NAME, IDC_NLF_SHOW_TOP, NULL, 250, NULL, MULTIPANEDLGINIT_RESET_PANE_SIZE_IF_TOO_SMALL);
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
	
	m_bFirstTimeResize = true;	///Jasmine 06/05/07 QA80-9852 NOT_RESIZE_IF_HIDDEN
	 ///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
	 /// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	 //m_editHint = GetItem(IDC_NLSF_OPERATION_HINT);	 
	 //m_editHint.Visible = false;
	 ///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
	 ///End ADD_HINT_TAB_TO_NLSF
	///Joseph 05/04/07 SHOW_ERR_MSG_ON_NLSF_INIT
	//move here to support init
	Control ctrl = GetItem(IDC_ERR_MESSAGE_BOX);
	ctrl.Visible = false;
	///Kenny 04/13/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG, no need to call this for initializing errmsg button, it's done by m_NLF.Init(...)
	/////Jasmine 05/22/08 EXPORT_ERRMSGBOX_SETTING_TO_DEVIRATED_CLASS
	////m_NLF.SetErrMsg(ctrl, "");
	//m_NLF.SetErrMsg(*this, "");
	///// end EXPORT_ERRMSGBOX_SETTING_TO_DEVIRATED_CLASS
	///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG

	///Joseph 01/29/07	ADD_OPERATION_ERRMSG_LINE
	m_NLF.SetNewEventFunc(m_pNewEventFunc);
	///End ADD_OPERATION_ERRMSG_LINE
	
	///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	m_TopTab = GetItem(IDC_NLF_SETTING_TAB);	
	int nCount = 0;
	/// AW 10/26/07 WRONG_LOCALIZE_MACRO
	m_TopTab.InsertItem(NLF_SETTING_TAB, RESERVED_SETTINGS_TAB); 	nCount++;
	m_TopTab.InsertItem(NLF_CODE_TAB, RESERVED_CODE_TAB);			nCount++;///Danice ADD_CODE_EDIT_TAB
	//m_TopTab.InsertItem(NLF_PARAMETERS_TAB, _L("Parameters"));	
	//m_TopTab.InsertItem(NLF_PARABOUND_TAB, _L("Bounds"));///Jasmine 02/09/06 ADD_PARA_BOUND_TAB
	///Sophy 12/31/2008 v8.0992c QA80-12425-P2 FIX_NLFIT_PARAM_TAB_CONFIG_CANNOT_BE_LOADED_CORRECTLY
	//m_paramTabs.Init(STR_DLG_NAME, &m_TopTab, m_pGridParas, nCount);//this code should be called after m_pGridParas->Init()
	///end FIX_NLFIT_PARAM_TAB_CONFIG_CANNOT_BE_LOADED_CORRECTLY
	///End CUSTOMIZATION_PARAMETER_TAB
	/// END WRONG_LOCALIZE_MACRO
	
	m_NLF.Init(IDC_NLF_BOX, *this, 0, STR_DLG_NAME);
	///End SHOW_ERR_MSG_ON_NLSF_INIT
	
	
	m_bInFitIterate = false;//CPY TD 3/16/2007 QA70-9473 NLFIT_NEEDS_FEEDBACK_TO_USER_AND_ESC_TO_ABORT_FITTING
	
	m_pGridParas->SetNLParamsMngr(m_NLF.GetNLParamsMngr());
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	m_pGridParas->Init(IDC_NLF_PARACONTROL_GRID, *this, STR_DLG_NAME);
#endif	
	///Sophy 12/31/2008 v8.0992c QA80-12425-P2 FIX_NLFIT_PARAM_TAB_CONFIG_CANNOT_BE_LOADED_CORRECTLY
	m_paramTabs.Init(STR_DLG_NAME, &m_TopTab, m_pGridParas, nCount);//m_pGridParas->Init init dialog name first for reading registry settings in m_paramTabs->Init
	///end FIX_NLFIT_PARAM_TAB_CONFIG_CANNOT_BE_LOADED_CORRECTLY

	/// YuI 10/03/06 NEED_TO_SPLIT_INIT_FIT_SESSION
	// moving down the code
	// see my comment thereotherwise selection in active page will get reset
	/*
	/// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB
	initTabFitCurvePreview(false); 
	initTabFitCurvePreview(true);
	///end ADD_FIT_CURVE_PREVIEW_TAB
	*/
	/// end NEED_TO_SPLIT_INIT_FIT_SESSION
	
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	/*
	m_NFunctionPrev.Init(IDC_NLF_PREVIEW_BOX,*this, 0, "");		///Frank 4/21/04		v8.0860 ADD_FUNCTION_PREVIEW
	
	m_NCurvePrev.Init(IDC_NLS_CURVE_PREVIEW_BOX,*this, 0, "");		///Frank 10/11/04 v8.0147  MODIFY_CODE_TO_LOAD_SAMPLE_FORMULA_PREVIEW	
	
	m_OPMsgLog.Init(IDC_NLS_OPERATION_LOG, *this);	
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	//setMessageLogShow(false);	
	ASSERT(GetItem(IDC_NLS_OPERATION_LOG));
	GetItem(IDC_NLS_OPERATION_LOG).Visible = false;		
	/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	*/
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE	
	m_NLF.LinkFitSession(&m_OPMsgLog);
	
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	/*
	m_reditFunctionFile = GetItem(IDC_FUNCTION_CODE_SHOW);	///Frank 11/12/04 v8.0162  ADD_FUNCTION_FILE_PANE	
	m_reditFunctionFile.SetReadOnly();						///Frank 11/12/04 v8.0162  ADD_FUNCTION_FILE_PANE
	m_reditFunctionFile.Visible = false;
	*/
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
	
	m_comboTheme = GetItem(IDC_THEME_COMB);
	m_btnSaveTheme = GetItem(IDC_SAVE_BTN);
	
	m_comboTheme.Enable = false;
	m_btnSaveTheme.Visible = false;
	BitmapRadioButton btnSaveAs = GetItem(IDC_SAVE_AS_BTN);
	vector<string> vsTips;
	btnSaveAs.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
	
	Tree trGUI;
	m_NLF.CopyAsOpGUITree(trGUI, false);
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//loadThemeFilesToCombo(trGUI);
	m_NLF.SPLInitThemeControls(this, trGUI, IDC_THEME_COMB, IDC_THEME_TEXT, IDC_SAVE_BTN, IDC_SAVE_AS_BTN);
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//---- 
	
	
	//---- CPY 10/4/04 ITERATION_TOLERANCE_PROPER_UPDATE
	m_btnOK = GetItem(IDOK);
	m_btnDone = GetItem(IDC_NLF_DONE); /// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	m_btnFit = GetItem(IDC_NLF_FIT);
	m_btnFit1 = GetItem(IDC_NLF_ONE_LTER);
	m_btnGetChiSQ = GetItem(IDC_NLF_CHI_SQ);
	m_btnInit = GetItem(IDC_NLF_PARAM_INIT);
	//----
	///------ Folger 08/11/2011 ORG-2740-S3 PROPER_HINT_TEXT_FOR_NLFIT_BUTTONS
	m_btnDone.SetToolTip(_L("Close dialog with current parameter values"));
	///------ End PROPER_HINT_TEXT_FOR_NLFIT_BUTTONS
	
	///Iris 10/11/06 v8.0494b ADD_ONE_LINE_MESSAGE_BAR
	m_staticMessage = GetItem(IDC_ONE_LINE_MESSAGE);
	m_staticMessage.Text = "";
	m_staticMessage.Visible = false;
	///end ADD_ONE_LINE_MESSAGE_BAR	
	
	/// Iris 1/06/2009 QA81-14920 HINT_FOR_PARAM_BOUNDS_TAB
	m_ctrlParamTabHint = GetItem(IDC_PARAM_TAB_HINT);
	m_ctrlParamTabHint.Visible = false;
	///End HINT_FOR_PARAM_BOUNDS_TAB
	
	s_hdlg = GetSafeHwnd();  /// Iris 8/08/06 IMPROVE_RESIDUAL_PREVIEW

	///Joseph 12/11/06	ADD_BITMAP_BUTTON
	/// Max 06/10/08 v8.0881 CENTRALIZE_TIP_STRINGS_FOR_BUTTONS_IN_NLFIT_AND_PA
	m_SelFuncButton = GetItem(IDC_NLF_OPENFO);
	m_SaveFDFButton	= GetItem(IDC_NLF_SAVE_FDF);
	m_NewFuncButton	= GetItem(IDC_NLF_NEWFO);	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
#ifndef __NEW_FITTING_FUNCTION_WIZARD__
	m_NewFuncButton.Visible = false;
#endif//__NEW_FITTING_FUNCTION_WIZARD__
	
	vsTips.RemoveAll();
	vsTips.Add(STR_TIP_EDIT_FITTING_FUNCTIONS);
	m_SelFuncButton.Init(1, IDB_NLF_OPEN_FO, 16, vsTips);
	
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	vsTips.RemoveAll();
	vsTips.Add(STR_TIP_NEW_FITTING_FUNCTIONS);
	m_NewFuncButton.Init(1, IDB_NLF_NEW_FO, 16, vsTips);
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	
	vsTips.RemoveAll();
	vsTips.Add(STR_TIP_SAVE_FDF_FILE);
	m_SaveFDFButton.Init(1, IDB_NLF_SAVEFDF_BTN, 16, vsTips);
	
	vsTips.RemoveAll();
	vsTips.Add(STR_TIP_FIT_UNTIL_CONVERGED);
	m_btnFit.Init(1, IDB_NLF_FIT, 16, vsTips);
	
	vsTips.RemoveAll();
	vsTips.Add(STR_TIP_INITIALIZE_PARAM);
	m_btnInit.Init(1, IDB_NLF_INIT, 16, vsTips);
	
	vsTips.RemoveAll();
	vsTips.Add(STR_TIP_ONE_ITERATION);
	m_btnFit1.Init(1, IDB_NLF_ITER, 16, vsTips);
	
	vsTips.RemoveAll();
	vsTips.Add(STR_TIP_CALCULATE_CHI_SQUARE);
	m_btnGetChiSQ.Init(1, IDB_NLF_CHISQ, 16, vsTips);	
	
	m_SimplexButton = GetItem(IDC_NLF_SIMPLEX);
	vsTips.RemoveAll();
	vsTips.Add(STR_TIP_SIMPLEX);
	m_SimplexButton.Init(1, IDB_NLF_SIMPLEX, 16, vsTips);
	/// END CENTRALIZE_TIP_STRINGS_FOR_BUTTONS_IN_NLFIT_AND_PA
	
	///Kyle  10/22/08  QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	BitmapRadioButton btnQuickSet = GetItem(IDC_NLF_QUICK_SET);
	vsTips.RemoveAll();
	///Sophy 12/3/2008 v8.0982 IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS
	//vsTips.Add("Apply to all parameters");
	vsTips.Add("Quick set all parameters");
	///end IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS
	btnQuickSet.Init(1, IDB_QUICK_SET, 16, vsTips);
	///End QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	btnQuickSet.Visible = false; /// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN

	//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
	BitmapRadioButton btnSortPeaks = GetItem(IDC_NLF_SORT_PEAKS);
	vsTips.RemoveAll();
	vsTips.Add(STR_SORT_PEAKS);
	btnSortPeaks.Init(1, IDB_SORT_PEAKS, 16, vsTips);
	//------ End SUPPORT_SORT_PEAKS_FOR_REPLICA
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	BitmapRadioButton btnReorderPeaks = GetItem(IDC_NLF_REORDER_PEAKS);
	btnReorderPeaks.Visible = true;
	vsTips.RemoveAll();
	vsTips.Add(STR_REORDER_PEAKS);
	btnReorderPeaks.Init(1, IDB_REORDER_PEAKS, 16, vsTips);
	//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

	m_staticNumReplica = GetItem(IDC_STATIC_NUM_OF_REPLICA);
	
	m_btnParamHide = GetItem(IDC_BTN_PARAM_HIDE);  /// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
	
	
	/// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	m_checkEnableAutoParamsInit = GetItem(IDC_CHECK_AUTO_INIT_PARAMS);
	m_checkEnableAutoParamsInit.Check = m_NLF.IsEnableAutoParamsInitFromOperation();
	///end ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	m_checkEnableConstraints = GetItem(IDC_CHECK_CONSTRAINTS);
	m_checkEnableConstraints.Check = m_NLF.IsEnableConstraintsFromOperation();
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS

	///Arvin 03/31/08 QA70-11322 ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	m_checkEnableAutoUpdate = GetItem(IDC_CHECK_AUTO_UPDATE);
	m_checkEnableAutoUpdate.Check = m_NLF.IsEnableAutoUpdateInit();
	///Sophy 11/12/2008 SUPPORT_CONTEXT_MENU_COMMAND_TO_UPDATE_PARAM_GRID_CONTROL
	m_checkEnableAutoUpdate.Visible = false;
	///end SUPPORT_CONTEXT_MENU_COMMAND_TO_UPDATE_PARAM_GRID_CONTROL
	///end ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	
	m_nFDFValueChange = NLF_NO_CHANGED;		///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	
	m_ctrlExplanationText = GetItem(IDC_EXPLANATION_TEXT);		//------ Folger 01/03/08 ADD_SELECTION_EXPLANATION_TO_CODE_TAB

	///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	m_comboData = GetItem(IDC_FITTING_DATA);
	m_comboData.SetToolTip(_L("Select data to iterate"));
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	
	///------ Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	calcOptimalWidth();
	///------ End DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	///------ Folger 12/31/08 QA80-12878 v8.0992b IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
//#ifdef _DEBUG
	//_CHK_ELAPSED_TIME("Exit OnInitDialog")
//#endif
	///------ End IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM

	updateDialogTitle();//---- CPY 5/28/09 EASWAR_FOUND_NLFIT_OPENS_DEFAULT_TITLE_AS_JUST_DIALOG	

	return true;
}

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
bool	NLFitDlg::getFuncListFromChangeFuncsTree(vector<string>& vsFunctions) // Hong, to do, this function need clean up
{
	bool bRet = m_NLF.GetFuncListFromChangeFuncsTree(vsFunctions);
	
	//if made change but not sel func change,
	//m_NLF.GetFuncListFromChangeFuncsTree will return false
	//so need to check m_nFDFValueChange
	if(!m_nFDFValueChange && !bRet) //no any func change
		return false;
	else if(!m_nFDFValueChange && bRet) //current func no change
		return true;
	
	TreeNode trFDF = m_NLF.GetFDFTree();
	TreeNode trFuncName = trFDF.GeneralInformation.FunctionName;
	if(!trFuncName)
		return false;
	
	if(vsFunctions.Find(trFuncName.strVal) < 0)
		vsFunctions.Add(trFuncName.strVal);
	return true;
}
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC

//------ Folger 11/13/07 GET_TAB_CHM_HELP
int		NLFitDlg::getFocusTabID()
{
	HWND hWnd = GetFocus();
	Window win(hWnd);
	RECT rect;
	win.GetWindowRect(&rect);
	m_wndDlg.ScreenToClient(&rect);
	
	RECT 	rr;
	GetClientRect(GetItem(IDC_NLF_SETTING_TAB), rr);
	if (_is_inner_rect(rect, rr))
		return IDC_NLF_SETTING_TAB;
	
	GetClientRect(GetItem(IDC_NLF_VIEW_TABS), rr);
	if (_is_inner_rect(rect, rr))
		return IDC_NLF_VIEW_TABS;
	
	return -1;
}

static bool _is_inner_rect(const RECT &rrIn, const RECT &rrOut)
{
	return (rrIn.top >= rrOut.top && rrIn.bottom <= rrOut.bottom && rrIn.left >= rrOut.left && rrIn.right <= rrOut.right);
}
//------ End GET_TAB_CHM_HELP

BOOL NLFitDlg::OnDestroy()
{
	/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	if ( m_saSrcDatasetNames.GetSize() >= 0 )
		Project.DataChangeMonitor(m_saSrcDatasetNames, NULL);
	/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	m_NLF.UnlinkFitSession();//----- CPY 11/10/06 NLFIT_NEW_CODE_RUNTIME_ERR_ON_CANCEL_BUTTON
	
	m_paramTabs.OnDestroy();///Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB, should before m_GridParas.OnDestroy()
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	m_pGridParas->OnDestroy();		///Frank 11/10/04 v8.0160  REMEMBER_HIDE_SHOW_COL_PARA_CTNL	
	if( m_pGridParas )
	{
		delete m_pGridParas;
		m_pGridParas = NULL;
	}
#endif	
	s_hdlg = NULL;  /// Iris 8/08/06 IMPROVE_RESIDUAL_PREVIEW	
	
	return MultiPaneDlg::OnDestroy();
}


///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
//if the values about FDF have been changed, and the function type is "user-defined"
//the dialog title show "*"
void	NLFitDlg::OnChangeFDFFileValue(uint wParam, uint lParam)
{
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//onChangeFDFFileValue(wParam);
	onChangeFDFFileValue(wParam, lParam);
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
}

//if values about FDF have been changed and , maybe need to save the values to FDF file in some cases.
BOOL	NLFitDlg::SaveFDFOnValueChanged(uint wParam, uint lParam)
{
	saveFDFOnValueChanged();
	
	return TRUE;
}

//only user defined function, need save fdf file
bool 	NLFitDlg::isFuncUserDefined()
{
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//TreeNode trFDF, trGeneralInfo, trFuncType;
	//string strFuncType;
	//
	//trFDF = m_NLF.GetFDFTree();
	//
	//if(! trFDF)
		//return false;
	//
	//trGeneralInfo = trFDF.GetNode("GeneralInformation");
	//
	//if(! trGeneralInfo)
		//return false;
	//trFuncType = trGeneralInfo.GetNode("FunctionType");
	//
	//if(! trFuncType)
		//return false;
	//
	//strFuncType = trFuncType.strVal;
	//
	//return (0 == strFuncType.Compare("User-Defined"));
	bool bUserDefine = false;
	nlf_is_user_define_func(m_NLF.GetFDFTree(), bUserDefine);
	return bUserDefine;
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
}

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
void	NLFitDlg::updateDlgSettingIfNoFDFValChange()
{ 
	//when user have saved fdf file,then the dialog delete the "*"
	//the fdf value changed state be set "false", and the save button set to disable
	string strDlgTitle = Text;
	strDlgTitle.TrimRight("*");
	Text = strDlgTitle;
	m_nFDFValueChange = NLF_NO_CHANGED;
	m_SaveFDFButton.Enable = false;	
	m_NLF.SetCurrentFuncChangeStats(m_nFDFValueChange);
}
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
//void 	NLFitDlg::onChangeFDFFileValue(uint wParam)
/// Hong 04/23/08 QA80-11466 THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
//void 	NLFitDlg::onChangeFDFFileValue(int nFDFValueChange, bool bChangeFunc)
void 	NLFitDlg::onChangeFDFFileValue(int nFDFValueChange, int nChangeFrom) // = 0
/// end THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
{
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	//string strDlgTitle = Text;
	
	//if change function, should reset it.	
	/// Hong 04/23/08 QA80-11466 THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
	//m_nFDFValueChange = bChangeFunc? false : m_nFDFValueChange;
	/// Hong 04/03/09 QA80-11466 FIX_NO_ASTERISK_WHEN_RESELECT_CHANGED_FDF_FUNCTION
	//m_nFDFValueChange = (nChangeFrom != 0) ? false : m_nFDFValueChange;
	m_nFDFValueChange = (NLF_FDF_CHANGE_FROM_FUNCTION == nChangeFrom) ? false : m_nFDFValueChange;
	/// end FIX_NO_ASTERISK_WHEN_RESELECT_CHANGED_FDF_FUNCTION
	/// end THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
	
	//if(! m_nFDFValueChange && isFuncUserDefined())
	if( !m_nFDFValueChange && nFDFValueChange)
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	{
		/// Hong 04/23/08 QA80-11466 THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF		
		if ( NLF_FDF_CHANGE_FROM_THEME != nChangeFrom )
		{
			///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
			//Text = Text + "*";
			string strDlgTitle = Text;
			strDlgTitle	+= "*";
			Text = strDlgTitle;
			///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
			
			m_SaveFDFButton.Enable = true;
			
			///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
			//m_nFDFValueChange = m_nFDFValueChange | wParam;
			m_nFDFValueChange = m_nFDFValueChange | nFDFValueChange;
		}
		/// end THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
		/// Hong 04/23/08 QA80-11466 THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF		
		//m_NLF.SetCurrentFuncChangeStats(m_nFDFValueChange);
		int		nFDFValChangeEx = (NLF_FDF_CHANGE_FROM_THEME == nChangeFrom) ? nFDFValueChange : 0;
		m_NLF.SetCurrentFuncChangeStats(m_nFDFValueChange | nFDFValChangeEx);
		/// end THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF		
		///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	}
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	else if(nFDFValueChange == NLF_NO_CHANGED)
	{
		updateDlgSettingIfNoFDFValChange();	
	}
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
}

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
//void	NLFitDlg::saveFDFOnValueChanged()
void	NLFitDlg::saveFDFOnValueChanged(bool bChangeTheme)
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
{
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	//if(m_nFDFValueChange && OM_RETURN_OK == OptionalMessage("SaveFDFOnNLFValueChange", MB_YESNO))
	bool bSaveFDF = (m_nFDFValueChange && OM_RETURN_OK == OptionalMessage("SaveFDFOnNLFValueChange", MB_YESNO) );
	if(bSaveFDF)
	///end 	ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
		saveFDFFile();
	 else
	 	m_nFDFValueChange = NLF_NO_CHANGED;
	 
	 ///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	 //when apply theme, even if click not save, should del Func in m_trChangeFuncs
	 if( !bSaveFDF && bChangeTheme)
	 {
		m_NLF.CheckDelFuncInChangeFuncTreeAfterThemeChange();
		updateDlgSettingIfNoFDFValChange();	
	 }
	 ///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
}

/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
/*
///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
bool	NLFitDlg::UpdateFitSessionParamsFromGrid(uint wParam, uint lParam)
{	
	//updateFitSessionParamsFromGrid();	
	updateFitSessionParamsFromGrid(wParam); /// Hong QA80-10937 FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
	
	return true;
}
*/
/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER

/// Hong QA80-10937 FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
//bool	NLFitDlg::updateFitSessionParamsFromGrid()

/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
/*
//------ Folger 03/25/08 QA80-11304 SUPPORT_SHARED_PARAMETERS_IN_REPLICA_FITTING
//bool	NLFitDlg::updateFitSessionParamsFromGrid(int nSharedMode) // SHARE_SETTING_MODE_NOT_CHANGE
bool	NLFitDlg::updateFitSessionParamsFromGrid(int nSharedMode, bool bKeepParams) // SHARE_SETTING_MODE_NOT_CHANGE, = false
//------
/// end FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
{	
	Tree 	trParams;
	/// Hong QA80-10937 FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
	//trParams = m_GridParas.GetParamTree();
	
	//------ Folger 03/25/08 QA80-11304 SUPPORT_SHARED_PARAMETERS_IN_REPLICA_FITTING
	//bool bRestoreShared = (SHARE_SETTING_MODE_BACK_UP_AND_RESET_CURRENT == nSharedMode) ? true : false;
	bool bReplica = m_NLF.GetReplicaNode().Number.nVal > 0;
	bool bRestoreShared = (SHARE_SETTING_MODE_BACK_UP_AND_RESET_CURRENT == nSharedMode) || bReplica ? true : false;
	//------
	
	// when expand vector setting which removed by sharing, need first make sure that content of m_GridParas is updated
	if ( bRestoreShared )
	{
		/// Hong 06/27/08 v8.0892 CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER
		//m_GridParas.Update(m_NLF.GetNumParameter(), m_NLF.GetNumDataset());
		m_GridParas.Update();
		/// end CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER
	}
	//trParams = m_GridParas.GetParamTree(bRestoreShared);			///Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE
	/// end FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
	///Arvin 12/14/07 CLEAN_AND_CHECK_ERROR_FOR_FUNCTION_CALLING as cp said
	//m_NLF.UpdateFitSessionParams(trParams);
	
	//------ Folger 03/25/08 QA80-11304 SUPPORT_SHARED_PARAMETERS_IN_REPLICA_FITTING
	//if(!m_NLF.UpdateFitSessionParams(trParams))
	//if(!m_NLF.UpdateFitSessionParams(trParams, bKeepParams))		///Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE
	//------
		//return error_report("UpdateFitSessionParams failed!");	///Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE
	///end CLEAN_AND_CHECK_ERROR_FOR_FUNCTION_CALLING
	return true;
}
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
*/
/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER

bool	NLFitDlg::saveFDFFile()
{
	///Cheney 2007-5-25 DO_SAVE_FDF
	//MessageBox(GetSafeHwnd(), _L("SavetoFDF is still not finished in Beta2."), STR_DLG_NAME, MB_OK|MB_OKCANCEL);///Joseph 01/18/07 NOT_FINISHED_SAVE_TO_FDF
	if(! m_nFDFValueChange)
		return true;
	
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//Tree 	trParams;
	//trParams = m_GridParas.GetParamTree();	
	//m_NLF.UpdateFitSessionParams(trParams);
	//m_NLF.UpdateFDFSetting(); 
	/// Hong 05/27/08 v8/0871 IMPROVE_CODE
	//m_NLF.SaveFDFSetting( m_NLF.GetFuncNameFromFDF() );
	m_NLF.SaveFDFSetting();
	/// end IMPROVE_CODE
	
	////when user have saved fdf file,then the dialog delete the "*"
	////the fdf value changed state be set "false", and the save button set to disable
	//string strDlgTitle = Text;
	//strDlgTitle.TrimRight("*");
	//Text = strDlgTitle;
	//
	//m_nFDFValueChange = NLF_NO_CHANGED;
	/////end DO_SAVE_FDF
	//
	//m_SaveFDFButton.Enable = false;	///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	updateDlgSettingIfNoFDFValChange();
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	return true;
}
///End ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF

//-----  CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY
BOOL NLFitDlg::OnReady()
{
	PROFILE_HRGLASS
	
#ifdef _DEBUG
	///------ Folger 12/31/08 QA80-12878 v8.0992b IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
	//_CHK_ELAPSED_TIME("Enter OnReady")
	ElapsedTimeCheckingHelper		clHelper("OnReady");
	///------ End IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
#endif
	
	UpdateDlgShow();
	SetInitReady();
	
	updateTopPaneControlShow();
	
	m_pGridParas->SetReady();	///Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB

	
	/// Hong 06/30/08 v8.0893 CLEAN_CODE
	/* move all those nlfsplitter relative functions into its member function
#ifdef	NLFIT_SPEED_UP_ONLY_PREVIEW_NECESSARY
	bool	bUpdatePreview = false;
	m_NLF.SetEnableUpdate(m_checkEnableAutoUpdate.Check, &bUpdatePreview);
#endif	//NLFIT_SPEED_UP_ONLY_PREVIEW_NECESSARY
	initTabFitCurvePreview(false); 
	initTabFitCurvePreview(true);
	/// Hong, to do, i think maybe we can clean up following code to call set function only once
	m_NLF.InitFitSession(&m_OPMsgLog);
	m_NLF.InitFitSessionData(); /// Iris 02/13/2007 v8.0561 COPY_CREATE_SOURCE_GRAPH_AS_PREVIEW, move to before initTabFitCurvePreview since in it want to know if data from graph, if so need to show source graph in preview

	/// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	m_NLF.SetAutoInitParams(m_checkEnableAutoParamsInit.Check);
	///end ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	
	m_NLF.SetLinearConstraints(m_checkEnableConstraints.Check);
	m_NLF.SetEnableUpdate(m_checkEnableAutoUpdate.Check);
	m_NLF.SelFuncChange( checkIsUpdateParamsOnTheme(),  true, true, !m_NLF.IsChangeParams(), m_NLF.IsChangeParams(), false, false); 
	m_NLF.OnReady();
	*/
	/// Hong 12/12/08 QA80-12733 ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL	
	//initTabFitCurvePreview(false); 
	//initTabFitCurvePreview(true);	
	/// end ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	///------ Folger 12/31/08 QA80-12878 v8.0992b SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	//m_NLF.OnReady(isFactoryDefaultTheme());
	bool bIsFactoryDefault = isFactoryDefaultTheme();
	m_NLF.OnReady(bIsFactoryDefault);
	///------ End SET_FUNCTION_TO_EMPTY_WHEN_OPEN_NLFIT_WITH_FACTORY_DEFAULT
	
	/// Hong 12/12/08 QA80-12733 ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	initTabFitCurvePreview(false); 
	initTabFitCurvePreview(true);	
	/// end ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	/// end CLEAN_CODE
	updateShowButtons();
	
	enablePeakSortingButton(m_NLF.IsReplicaFit());		//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
	enablePeakReorderingButton(false);	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	
	/// Hong 12/12/08 QA80-12733 ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	//UpdatePreviewPage();/// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	UpdatePreviewPage(true);
	/// end ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	
	///------ Folger 12/31/08 QA80-12878 v8.0992b IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM
//#ifdef _DEBUG	
	//_CHK_ELAPSED_TIME("Exit OnReady") //---- CPY 12/29/08 CHK_ELAPSED_TIME_FOR_OC_DIALOG_TO_OPEN_TOO_SLOWLY
//#endif
	///------ End IMPROVE_ELAPSED_TIME_CHECKING_MECHANISM

	///-----Kit 01/26/2011 ORG-2120-S1 OPEN_NLFIT_SHOULD_ACTIVE_SETTING
	/*
	///-----Kit 12/09/2010 ORG-1532-S6 ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT
	if( m_NLF.IsOpenFromMultiPeakFit() )
		setParamerTabActive();
	///-----ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT
	*/
	///-----End OPEN_NLFIT_SHOULD_ACTIVE_SETTING

	///-----Kit 01/28/2011 ORG-2120-S2 USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB
	if( m_NLF.IsOpenFromMultiPeakFit() && !O_QUERY_BOOL(NLFIT_DLG_OPEN_FROM_CHANGE_PARAMETER, m_dwOption) )
		setParamerTabActive();
	///-----End USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB

	return true;
}
//-----
BOOL 	NLFitDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
	{
		_DBSTR("OnDlgResize, not ready, skip");
		return TRUE;
	}
	MoveControlsHelper	_temp(this);		//---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW
	///Joseph	12/11/06	ADD__BITMAP_BUTTON
	////--- CPY 11/29/04 OK_CANCEL_ON_THE_LEFT
	////uint nButtonIDs[] = {IDOK, IDCANCEL, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_PARAM_INIT, 0};
	//uint nButtonIDs[] = {IDC_NLF_PARAM_INIT, IDC_NLF_CHI_SQ, IDC_NLF_ONE_LTER, IDC_NLF_FIT, IDCANCEL,IDOK, 0};
	////---
	
	//MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
	///Joseph 06/22/07 v8.0647 ADD_NLF_SIMPLEX_BUTTON
	//uint nButtonIDs[] = { IDCANCEL,IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_PARAM_INIT, IDC_GROUP_GAP, IDC_NLF_SAVE_FDF, IDC_NLF_OPENFO,  0};
	/// Iris 7/19/2007 MOVE_SIMPLEX_BTN_TO_RIGHT_OF_PARAM_INIT
	//uint nButtonIDs[] = { IDCANCEL,IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_SIMPLEX, IDC_NLF_CHI_SQ, IDC_NLF_PARAM_INIT, IDC_GROUP_GAP, IDC_NLF_SAVE_FDF, IDC_NLF_OPENFO,  0};
	///Arvin 03/31/08 QA70-11322 ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	//uint nButtonIDs[] = { IDCANCEL,IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_SIMPLEX, IDC_NLF_PARAM_INIT, IDC_GROUP_GAP, IDC_NLF_SAVE_FDF, IDC_NLF_OPENFO,  0};
	///Kyle  10/22/08  QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	//uint nButtonIDs[] = { IDCANCEL,IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_SIMPLEX, IDC_NLF_PARAM_INIT, IDC_GROUP_GAP, IDC_NLF_SAVE_FDF, IDC_NLF_OPENFO, IDC_CHECK_AUTO_UPDATE, 0};
	///------ Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	//uint nButtonIDs[] = { IDCANCEL,IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_SIMPLEX, IDC_NLF_PARAM_INIT, IDC_GROUP_GAP, IDC_NLF_QUICK_SET, IDC_NLF_SORT_PEAKS, IDC_NLF_REORDER_PEAKS, IDC_GROUP_GAP, IDC_NLF_SAVE_FDF, IDC_NLF_OPENFO, IDC_CHECK_AUTO_UPDATE, 0};
	vector<uint>	vnButtonIDs;
	getButtonIDs(vnButtonIDs);
	vnButtonIDs.Add(0);			/// must be ended with 0
	///------ End DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	///End QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	///end ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	///end MOVE_SIMPLEX_BTN_TO_RIGHT_OF_PARAM_INIT
	///End ADD_NLF_SIMPLEX_BUTTON
	
	///------ Folger 02/11/09 QA80-13098-P1 NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	if(m_bFirstTimeResize)
	{
		MakeSameSize(vnButtonIDs, true);
	}
	///------ End NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	
	///------ Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	//MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false, NLSF_BUTTON_GAP, SPACE_BETWEEN_EACH_BTN_GROUP);
	MultiPaneDlg::OnDlgResize(vnButtonIDs, cx, cy, false, NLSF_BUTTON_GAP, SPACE_BETWEEN_EACH_BTN_GROUP);
	///------ End DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	
	///End	ADD__BITMAP_BUTTON	
	//------ Folger 07/30/07 FIX_BUGS_IN_TOP_PANEL_EDGE_DISAPPEAR_WHEN_RESIZING
	//if(IsTopPaneShown())
	//{
		////-------Folger 07/23/07 FIX_BUGS_IN_RESIZE_DIALOG
		////moveShownControlToTopTab();
		//updateTopTabDisplay();
		////-------End FIX_BUGS_IN_RESIZE_DIALOG
	//}
	//------ End FIX_BUGS_IN_TOP_PANEL_EDGE_DISAPPEAR_WHEN_RESIZING
	///Jasmine 06/05/07 QA80-9852 NOT_RESIZE_IF_HIDDEN
	if(m_bFirstTimeResize)
	{
		m_bFirstTimeResize = false;
		Control ctrl;
		OnShowBottomPane(ctrl);	
	}
	///End NOT_RESIZE_IF_HIDDEN
	m_NLF.OnDlgResize(nType, cx, cy); //	CPY 3/15/06 SPLITTER_INIT_NEEDED_TO_BE_CALLED_FROM_RESIZE
	
	///Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
	//on resize, manage the control
	//while bottom tab not show, should not show one line message.
	updateOneLineMessageSize();
	
	//on top tab not show, should not show the enable param init control
	int nSelTab = m_TopTab.GetCurSel();
	
	///Joseph 06/28/07 v8.0651 CODE_TAB_SHOULD_SHOW_THE_CHECKBOX
	//we should set the argu = true if selecting the code tab.
	//arrangeParamsInitConstrControls(nSelTab == NLF_CODE_TAB? false : true);
	arrangeParamsInitConstrControls(nSelTab == NLF_CODE_TAB? true : false);
	///End CODE_TAB_SHOULD_SHOW_THE_CHECKBOX
	
	//----- Iris 07/03/2007 v8.0654 not known why add this control, seems unuseful now, so remove it. 
	/*
	//this control don't use any more, will be removed from resource.
	Control 	ctrlCodeEdit = GetItem(IDC_RICHEDIT1);
	ctrlCodeEdit.Visible = false;
	*/
	//----- 
	
	//on top tab not show, should not show the replica number control
	updateStaticNumReplica(nSelTab);
	///End FIX_BUG_ON_NLF_DLG_RESIZE
	
	OnResizeErrMsg(m_NLF.GetHasErrMsg(),0);	///Joseph 04/02/07 ADD_NLSF_ERR_MSG_EVENT
	//------ Folger 07/30/07 FIX_BUGS_IN_TOP_PANEL_EDGE_DISAPPEAR_WHEN_RESIZING
	if(IsTopPaneShown())
	{
		moveShownControlToTopTab();
	}
	//------ End FIX_BUGS_IN_TOP_PANEL_EDGE_DISAPPEAR_WHEN_RESIZING
	return TRUE;
}
BOOL NLFitDlg::OnInitSize(int &left, int &top, int &right, int  &bottom)
{
	RECT rect;
	rect.left =left;
	rect.top =top;
	rect.right =right;
	rect.bottom =bottom;
	m_wndDlg.MoveWindow(&rect);

	return FALSE;
}

BOOL 	NLFitDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	//------ Folger 11/13/07 GET_TAB_CHM_HELP
	//return false;
	nIdCtrlFocus = getFocusTabID();
	
	nHelpID = IDD_NLFIT_DEFAULT_HELPID;		///------ Folger 02/17/09 ADD_NLFIT_DEFAULT_HELPID
	
	switch (nIdCtrlFocus)
	{
	case IDC_NLF_SETTING_TAB:
		{
			int nSel = m_TopTab.GetCurSel();
			int nRowID = m_NLF.GetRowID();
			switch (nSel)
			{
			case NLF_SETTING_TAB:
			case NLF_CODE_TAB:
				{
					switch (nRowID)
					{
						case IDST_NLSF_FUNC_SEL_OPTIONS:
							nHelpID = IDD_NLFIT_SETTING_FUNCTION;
							break;
						case IDST_DATA_SELECTION:
							nHelpID = IDD_NLFIT_SETTING_DATA;
							break;
						case IDST_NLSF_FITTED_CURVE_SETTING:
							nHelpID = IDD_NLFIT_SETTING_FITTED;
							break;
						case IDST_NLSG_ADVANCED_OPERATIONS:
							nHelpID = IDD_NLFIT_SETTING_ADV;
							break;
						case IDE_NLSF_CODES_FUNC:
							nHelpID = IDD_NLFIT_CODE_FUNCTION;
							break;
						case IDE_NLSF_CODES_PARAINIT:
							nHelpID = IDD_NLFIT_CODE_PARA;
							break;
						case IDE_NLSF_CODES_CONSTRAINTS:
							nHelpID = IDD_NLFIT_CODE_CONST;
							break;
					}
				}
				break;
			///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
			/*
			case NLF_PARAMETERS_TAB:
				{
					nHelpID = IDD_NLFIT_PARA;
				}
				break;
			case NLF_PARABOUND_TAB:
				{
					nHelpID = IDD_NLFIT_BOUNDS;
				}
				break;
			*/
		
			///------ Folger 02/18/09 BOUNDS_TAB_F1_MAPPING_NOT_WORKING
			/// since tabs now can be customized, so abolute "Bounds" tab help mapping is meanless...
			/// however, there exists one page called "Bounds Settings" in Origin.chm, so, index hard coded here
			#define		PARAMETER_BOUNDS_TAB_INDEX		3
			///------ End BOUNDS_TAB_F1_MAPPING_NOT_WORKING
		
			default:
				if( m_paramTabs.IsParamTab(nSel) )
				///------ Folger 02/18/09 BOUNDS_TAB_F1_MAPPING_NOT_WORKING
					//nHelpID = IDD_NLFIT_PARA;
				{
					if ( nSel == PARAMETER_BOUNDS_TAB_INDEX )
						nHelpID = IDD_NLFIT_BOUNDS;
					else
						nHelpID = IDD_NLFIT_PARA;
				}
				///------ End BOUNDS_TAB_F1_MAPPING_NOT_WORKING
			
				break;
			///End CUSTOMIZATION_PARAMETER_TAB
			}
		}
		break;
	case IDC_NLF_VIEW_TABS:
		{
			int nSel = m_BottomTab.GetCurSel();
			/// Hong 03/21/08 v8.0829 FIX_ON_HELP_FAIL_GOTO_CORRECT_PAGE
			//switch (nSel)
			/// Hong 03/21/08 v8.0828 GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
			//int nEnumOffset = m_NLF.IsShowFitPreview() ? 0 : 1;
			//int nSelEnumTab = nSel + nEnumOffset;
			int nSelEnumTab = bottomTabSelToEnum(nSel);
			/// end GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
			switch ( nSelEnumTab )
				/// end FIX_ON_HELP_FAIL_GOTO_CORRECT_PAGE		
			{
			case NLF_FIT_CURVE_PREVIEW_TAB:
				nHelpID = IDD_NLFIT_FITCURVE;
				break;
			case NLF_FORMULA_TAB:
				nHelpID = IDD_NLFIT_FORMULA;
				break;
			case NLF_SAMPLE_CURVE_TAB:
				nHelpID = IDD_NLFIT_SAMPLECURVE;
				break;
			case NLF_MESSAGES:
				nHelpID = IDD_NLFIT_MESSAGE;
				break;
			case NLF_FUNCTION_FILE_TAB:
				nHelpID = IDD_NLFIT_FUNCTIONFILE;
				break;
			case NLF_RESIDUAL_PREVIEW_TAB:
				nHelpID = IDD_NLFIT_RESIDUAL;
				break;
			case NLF_OPERATION_HINT_TAB:
				nHelpID = IDD_NLFIT_HINTS;
				break;
			}
		}
		break;
	case IDCANCEL:
	case IDOK:
	case IDC_NLF_DONE: /// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	case IDC_NLF_FIT:
	case IDC_NLF_ONE_LTER:
	case IDC_NLF_CHI_SQ:
	case IDC_NLF_SIMPLEX:
	case IDC_NLF_PARAM_INIT:
	case IDC_GROUP_GAP:
	case IDC_NLF_SAVE_FDF:
	case IDC_NLF_OPENFO:
	case IDC_NLF_NEWFO:	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	case IDC_NLF_SHOW_TOP:
	case IDC_NLF_SHOW_BOTTOM:
		break;
	default:
		break;
	}
	return true;
	//------ End GET_TAB_CHM_HELP
}
BOOL 	NLFitDlg::OnShowTopPane(Control cntrl)
{
	MultiPaneDlg::OnShowTopPane(cntrl);
	
	///DG TABS_ON_TOP : for theme place
	//updateTopTabDisplay();
	updateTopPaneControlShow();	
	OnResizeErrMsg(m_NLF.GetHasErrMsg(),0);		//------Folger 07/23/07 FIX_BUGS_IN_SHOW_TOP_PANE
	if(IsTopPaneShown())
	{
		RECT rTab;
		GetClientRect(m_TopTab, rTab);
		int nEdge=GetControlGap(), nx=nEdge, ny=nEdge;
		///DG THEME_COMBO_RESIZABLE : resize theme group in moveShownControlToTopTab
		/*
		ny=ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny)+nEdge;
		rTab.top = ny;
		*/
		RECT rBtn;
		///Jasmine 06/01/07 QA80-9852 FIX_TOP_TAB_OVERFLOW_THEME_SAVING_GROUP_BUG
		GetClientRect(m_comboTheme, rBtn);//GetControlClientRect(m_vnThemeSaveGroup[0], rBtn);
		rTab.top = rBtn.bottom + nEdge;//rTab.top += RECT_HEIGHT(rBtn)+nEdge;
		///End FIX_TOP_TAB_OVERFLOW_THEME_SAVING_GROUP_BUG
		///end THEME_COMBO_RESIZABLE
		MoveControl(m_TopTab, rTab);		

		moveShownControlToTopTab();
	}
	else
	{
		/// Iris 1/06/2009 QA81-14920 HINT_FOR_PARAM_BOUNDS_TAB
		// set visible as false to fix the following control still show even Top Pane not show.
		m_checkEnableAutoParamsInit.Visible = false;
		m_ctrlParamTabHint.Visible = false; 
		m_ctrlExplanationText.Visible = false; 
		///End HINT_FOR_PARAM_BOUNDS_TAB
	}
	///end TABS_ON_TOP
	
	//---- CPY 1/15/05 XF_DLG_CODE_CLEANUP
	//if(IsBottomPaneShown())
	//	moveAndshowControlInBottomTab();
	//----
	return true;
}
//---- CPY 1/15/05 XF_DLG_CODE_CLEANUP
/*
BOOL 	NLFitDlg::OnShowBottomPane(Control cntrl)
{
	///Frank 10/11/04 v8.0147  MODIFY_CODE_TO_LOAD_SAMPLE_FORMULA_PREVIEW
	///Here Show buttom pane first, because in functioin  OnBottomTabChange need the rection of bottom pane.
	MultiPaneDlg::OnShowBottomPane(cntrl);
	if(IsBottomPaneShown())
	{
		updateBottomTabDisplay();
	}
	else
	{
		hideAllControlInBottomPane();
	}
	//MultiPaneDlg::OnShowBottomPane(cntrl);
	///End  MODIFY_CODE_TO_LOAD_SAMPLE_FORMULA_PREVIEW
	return true;
}
*/
BOOL	NLFitDlg::OnTopTabChange(Control cntrl)
{
	SetFocus(cntrl.GetSafeHwnd());		//------ Folger 11/13/07 GET_TAB_CHM_HELP
	updateTopTabDisplay();
	return true;
}
BOOL	NLFitDlg::OnBottomTabChange(Control cntrl)
{	
	SetFocus(cntrl.GetSafeHwnd());		//------ Folger 11/13/07 GET_TAB_CHM_HELP
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	//updateBottomTabDisplay();
	setBottomPaneActiveTab();
	/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	return true;
}
//---Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
BOOL NLFitDlg::SelTopTab(int nSel, DWORD dw)
{
	m_TopTab.SetCurSel(nSel);
	return OnTopTabChange(m_TopTab);
}

BOOL NLFitDlg::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{	
	if(IDC_NLF_SETTING_TAB == nResIDCtrl)	
	{
		int nSel = m_paramTabs.GetSelFromMousePos(nx, ny, this);
		
		if(m_TopTab.GetCurSel() != nSel)
			SelTopTab(nSel);
		
		m_paramTabs.OnShowMenu(nx, ny, this);
		return TRUE;
	}
	///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	if ( IDC_NLF_PARACONTROL_GRID == nResIDCtrl )
	{
		if( m_pGridParas->IsMouseOnHeader() )
		{
			m_pGridParas->ShowHeaderMenu(nx, ny);
			return TRUE;
		}

		int nRow, nCol;
		m_pGridParas->GetMouseCell(nRow, nCol);
		
		vector<string>	vsItem;
		vector<byte>  	vbShow;
		vector<bool>	vbDisable;
		vector<int>		vnChoiceContextMenu;
		DWORD			dwCntrl = 0;
		if ( m_NLF.GetNumDataset() < 2 )
		{
			if ( !m_NLF.IsReplicaFit() )
				O_ADD_BIT(dwCntrl, CM_CNTRL_NO_APPLT_TO_ALL);
		}
		else
		{
			O_ADD_BIT(dwCntrl, CM_CNTRL_MULTI_SETS);
		}
		m_pGridParas->GetItemContextMenu(nRow, nCol, vsItem, vbShow, vbDisable, vnChoiceContextMenu, dwCntrl);
		if ( 0 == vsItem.GetSize() )
			return FALSE;
		CheckMenu 	MyMenu( vbShow, vsItem, vbDisable );				
		int nChoice = MyMenu.DoTrackPopup( nx, ny, m_pGridParas->GetDlgSafeHwnd() );
		if( nChoice >= 0 )
		{

			if ( vnChoiceContextMenu.GetSize() > 0 )
			{
				int				nChoiceContextMenu = nChoice - (vsItem.GetSize() - vnChoiceContextMenu.GetSize());
				if ( nChoiceContextMenu >= 0 )
				{
					ASSERT( vnChoiceContextMenu.GetSize() > nChoiceContextMenu );
					OnContextMenuMore	stMore = { 0 };
					stMore.bAllowShared = m_NLF.IsAllowSharing();
					stMore.nDatasetEdited = m_NLF.DatasetEdited(nRow - m_pGridParas->GetRowOffset());
					stMore.nActiveDataset = GetCurrentFittingData();
					updateOnParameterChange(m_pGridParas->OnItemContextMenu(nRow, nCol, vnChoiceContextMenu[nChoiceContextMenu], &stMore));
				}
			}				
		}
		return TRUE;
	}
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	
	return FALSE;
}
//---end
BOOL 	NLFitDlg::OnComboChangeTheme(Control ctrl)
///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
{
	return TRUE;
}

///---Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
/*
bool 	NLFitDlg::LoadTheme()
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
{
	NLFSplitterGroupUpdateMsgMngr	grpUpdateMngr(&m_NLF);
	
	int			nUpdateCheckStatus = m_checkEnableAutoUpdate.Check;
	if ( !nUpdateCheckStatus )
		m_NLF.SetEnableUpdate(true);
	
	string		strThemeSel;
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//m_comboTheme.GetLBText(m_comboTheme.GetCurSel(), strThemeSel);
	//updateSaveButton(strThemeSel);
	strThemeSel = m_NLF.SPLGetCurThemeName();
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	//bool		bIsFactroyDefaultTheme = false; // Hong, to do, wait for Folger
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//bool		bIsFactroyDefaultTheme = isFactoryDefaultTheme();
	bool		bIsFactroyDefaultTheme = theme_is_factory_default(strThemeSel);
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	bool		bIncludeFunctionSel = !bIsFactroyDefaultTheme;
	Tree 		trOpGUI;
	m_NLF.CopyAsOpGUITree(trOpGUI, false, bIncludeFunctionSel);
	
	string 		strClassOption, strFuncName, strCate;
	theme_get_class_option(trOpGUI, strClassOption);
	m_NLF.GetSelectedFuncNameAndCategory(strFuncName, strCate);
	if ( nlsf_apply_theme(strClassOption, trOpGUI, strThemeSel, true, strFuncName) )
	{
		///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
		if( bIsFactroyDefaultTheme )
		{
			/// Iris 08/20/2007 v8.0685 QA70-10256-P2 FIX_RUNTIME_ERR_AFTER_CHANGE_LASTUSED_THEME_TO_FACTORY_DEFAULT
			m_NLF.SetFactroyDefaultOnFitType( trOpGUI );
			///end FIX_RUNTIME_ERR_AFTER_CHANGE_LASTUSED_THEME_TO_FACTORY_DEFAULT
		}
		///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
		m_NLF.UpdateOnThemeChange(trOpGUI, bIsFactroyDefaultTheme);
		/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
		// NOT reasonable, splitter should take care of this and post update message once any update is necessary
		//updateParts(NLDLGPART_FIT_FUNC_CHECKBOX);		
		//
		//bool	bParamsGrid = (NLF_PARAMETERS_TAB == m_TopTab.GetCurSel() || NLF_PARABOUND_TAB == m_TopTab.GetCurSel())? true : false;
		//bool 	bCodeTab = (NLF_CODE_TAB == m_TopTab.GetCurSel()) ? true : false;				
		//updateDisplay(bParamsGrid, true, true, bCodeTab);		
		/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	}
	
	if ( !nUpdateCheckStatus )
		m_NLF.SetEnableUpdate(nUpdateCheckStatus);
	
	return	true;// event handler always returns true
}
*/
///---END QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE

///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
/*
//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
void	NLFitDlg::UpdateSettingBeforeSaveTheme(TreeNode &tr)
{
	TreeNode	trAutoParamsInit = tr.Parameters.AutoParamsInit;
	if(trAutoParamsInit)
	{
		trAutoParamsInit.nVal = m_checkEnableAutoParamsInit.Check;
	}

	TreeNode	trLinearConstraints = tr.Parameters.LinearConstraints;
	if(trLinearConstraints)
	{
		trLinearConstraints.nVal = m_checkEnableConstraints.Check;
	}
	
	/// Iris 4/30/2008 QA80-10442 WANT_REMEMBER_X_DATA_TYPE_IN_THEME
	//TreeNode trFittedCurves = tr.FittedCurve;
	//remove_datatype_attrib_from_theme(trFittedCurves);
	///end WANT_REMEMBER_X_DATA_TYPE_IN_THEME
	
}
//------ End ADD_THEME_CONTROL_POPUP_MENU

//--- CPY 10/19/4 THEME_TREE_NEED_TO_INCLUDE_FUNCTION
bool	NLFitDlg::saveAsTheme(LPCSTR lpcszThemeFilename)
{
	/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	//updateFitSessionParamsFromGrid();
	/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	
	Tree tr;
	
	m_NLF.CopyAsOpGUITree(tr, true);
	UpdateSettingBeforeSaveTheme(tr);
	
	//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
#ifdef NEW_DEFAULT_THEME_MECHANISM
	if ( lpcszThemeFilename == NULL )
	{
		string strSel;
		m_comboTheme.GetLBText(m_comboTheme.GetCurSel(), strSel);
		//if ( theme_is_factory_default_for_new_mechanism(strSel) )
		if ( is_theme_default(strSel) )
			return theme_default_setting_management(tr, THEME_DEFAULT_SET);
	}
#endif
	//------
	
	return theme_save_settings(tr, lpcszThemeFilename, true);
	/// end NLFIT_THEME_SHOULD_SAVE_ALL_SETTINGs
	///end CORRECT_LOGIC_OF_LOADING_THEME
}
//---
BOOL	NLFitDlg::OnSaveTheme(Control ctrl)
{
	saveAsTheme(NULL);
	return true;
}
BOOL	NLFitDlg::OnSaveThemeAs(Control ctrl)
{
	Tree tr;
	
	if ( !ctrl )
	{
		m_NLF.CopyAsOpGUITree(tr, false);
		TreeNode trThemeFilter = m_NLF.GetThemeFilterTree();
		string strFullFileName = theme_ask_save_as_filename(tr, GetSafeHwnd(), trThemeFilter);
		if(strFullFileName.IsEmpty())
			return	true; // event handler, always return true

		if(	saveAsTheme(strFullFileName) )
			loadThemeFilesToCombo(tr);

		return true;
	}
	/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	//updateFitSessionParamsFromGrid();
	/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	m_NLF.CopyAsOpGUITree(tr, true);
	UpdateSettingBeforeSaveTheme(tr);
	return m_NLF.OnShowThemeMenu(ctrl, &m_comboTheme, &m_btnSaveTheme, tr, this);
}
*/
BOOL	NLFitDlg::OnSaveTheme(Control ctrl)
{
	return true;
}
BOOL	NLFitDlg::OnSaveThemeAs(Control ctrl)
{
	Tree tr;
	m_NLF.CopyAsOpGUITree(tr, true);
	/// Hong 10/15/08 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	//return m_NLF.OnShowThemeMenu(ctrl, &m_comboTheme, &m_btnSaveTheme, tr);
	bool		bRet = m_NLF.OnShowThemeMenu(ctrl, &m_comboTheme, &m_btnSaveTheme, tr);
	///---Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	//if ( bRet )
	//{
		//m_NLF.UpdateThemeFilterTree(tr);
	//}
	///---END QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
	return bRet;
	/// end FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
}
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
///// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
//BOOL NLFitDlg::OnClickApplyParamSettings(Control ctrl)
//{
	//if(!m_checkApplyParamsTheme)
		//return false;
	//
	//OptionalMessage( "LoadParamSetting", MB_OK);	///Joseph 05/04/07 v8.0613 ADD_NLSF_LOADING_THEME_REMAINDER_MESSAGE
	//
	//int 	nChecked = m_checkApplyParamsTheme.Check;	
	//
	//bool	bRet = false;
	//if(nChecked)
	//{
		//saveFDFOnValueChanged(); ///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
		/////Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
		////bRet = m_NLF.OperationGUIToParams(true);
		//bRet = m_NLF.OperationGUIToParams(true, true); //updatePreview, applyParams
		/////end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//}
	////---- Iris 02/09/2007 v8.0559 from Max's suggestion, no need to do any thing when uncheck.
	///*
	//else
	//{
		//bRet = m_NLF.RunParamsInitValues();
//
	//}
	//*/
	////----
	//
	//if(bRet)
		//updateDisplay(true, true, true);
	//
	//return true;
//}
/////end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX	
//
/////Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
//BOOL NLFitDlg::OnClickApplyBoundSettings(Control ctrl)
//{
	//if(!m_checkApplyBoundTheme)
		//return false;
	//
	//OptionalMessage( "LoadBoundarySetting", MB_OK);	///Joseph 05/04/07 v8.0613 ADD_NLSF_LOADING_THEME_REMAINDER_MESSAGE
	//
	//int 	nChecked = m_checkApplyBoundTheme.Check;
	//
	//bool	bRet = false;
	//if(nChecked)
	//{
		//saveFDFOnValueChanged(); ///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
		//bRet = m_NLF.OperationGUIToParams(true, false); //updatePreview, applyBound
	//}
	//
	//if(bRet)
		//updateDisplay(true, true, true);
	//
	//return true;
//}
/////end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY

/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
BOOL NLFitDlg::OnClickEnableAutoInitParams(Control ctrl)
{
	if(!m_checkEnableAutoParamsInit)
		return false;
	
	onThemeValueChange(); /// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	
	int 	nChecked = m_checkEnableAutoParamsInit.Check;
	m_NLF.SetAutoInitParams(nChecked);
	
	/// Hong 01/17/08 v8.0787b MORE_TIPS_OF_AUTO_INIT_STATUS_IN_PARAMS_TAB
	int nSelTab = m_TopTab.GetCurSel();
	updateStaticNumReplica(nSelTab);
	/// end MORE_TIPS_OF_AUTO_INIT_STATUS_IN_PARAMS_TAB
	
	onChangeFDFFileValue(NLF_CODE_CHANGED);	
	return true;
}
///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX

//Arvin 04/03/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
void NLFitDlg::showMsgTab()
{
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	/*
	int nSelTab = bottomTabEnumToSel(NLF_MESSAGES); 
	m_BottomTab.SetCurSel(nSelTab);
	//I don't know why I should call this method,
	//but if I don't call it, the message tab can not show correctly.
	UpdateBottomPaneSubControls();
	*/
	m_BottomTab.SetCurSel(NLF_MESSAGES);
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
}
///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP

///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
void NLFitDlg::updateButtonsState(bool bEnable)
{
	m_btnOK.Enable = bEnable;
	m_btnDone.Enable = bEnable; /// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	m_btnFit.Enable = bEnable;
	m_btnFit1.Enable = bEnable;
	m_btnGetChiSQ.Enable = bEnable;
	//m_btnInit.Enable = bEnable;	
	m_SimplexButton.Enable = bEnable;
}
///end DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS

///-----Kit 12/09/2010 ORG-1532-S6 ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT
bool NLFitDlg::setParamerTabActive()
{
	if( m_paramTabs.ActiveParameterTab() > 0 )
	{
		m_checkEnableAutoParamsInit.Visible = true;
		return true;
	}
		
	return false;
}
///-----End ACTIVE_PARAMETERS_TAB_WHEN_OPEN_NLFIT

///Arvin 03/31/08 QA70-11322 ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
BOOL NLFitDlg::OnClickAutoUpdate(Control ctrl)
{
	//------ CPY 4/1/08 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
/*
	if(!m_checkEnableAutoUpdate)
		return false;
	int 	nChecked = m_checkEnableAutoUpdate.Check;
	m_NLF.SetEnableUpdate(nChecked);
	m_NLF.DoUpdate();
	return true;
*/
	int 	nChecked = m_checkEnableAutoUpdate.Check;
	m_NLF.SetEnableUpdate(nChecked);
	if(nChecked)
	//Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	//	m_NLF.DoUpdate(true);
	{
		///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
		//bool bRet = m_NLF.DoUpdate(true);
		//if(bRet)
		int nRet = m_NLF.DoUpdate(true);
		if(nRet >= 0)
		///end DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
		{	
			/// Hong 09/11/08 v8.0937 FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE
			//int nSelTab=m_TopTab.GetCurSel();
			////m_GridParas.LinkFunctionTreeToFitFunction(m_NLF.GetParameterTree(), m_NLF.IsMixedFunction());		///Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE
			//updateDisplay(nSelTab == NLF_PARAMETERS_TAB, true);
			updateDisplayOnParamsChange();
			/// end FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE
		}
		///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
		//else
		//{
		//	//Show message tab if DoUpdate failed 
		//	showMsgTab();
		//}
		//When found < replica and update failed, should disable corresponding buttons
		//bool bEnableButtons = true;
		if(nRet != 0)
		{
			showMsgTab();
			//bEnableButtons = false;
		}
		//updateButtonsState(bEnableButtons);
		///end DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	}
	///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	//----- end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	return true;
}
///END ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	
///Cheney 2007-6-6 SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT
BOOL NLFitDlg::OnClickEnableLinearConstraints(Control ctrl)
{
	if(!m_checkEnableConstraints)
		return false;
	
	onThemeValueChange(); /// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	
	int 	nChecked = m_checkEnableConstraints.Check;
	/// Hong 08/13/08 QA80-12008 REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
	//m_NLF.SetLinearConstraints(nChecked);
	m_NLF.SetLinearConstraints(nChecked, NULL, true);
	/// end REACTIVE_FIT_RELATIVE_BTN_AFTER_CONSTRAINT_CHANGE
	onChangeFDFFileValue(NLF_CODE_CHANGED);	
	return true;
}
///end SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT


///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
/*
void NLFitDlg::updateSaveButton(const string& strSelTheme)
{
	///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
	//if ( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(strSelTheme) )
	if ( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || theme_is_factory_default(strSelTheme) )
	///---END CLEAN_DEFAULT_THEME
		m_btnSaveTheme.Enable = false;
	else
		m_btnSaveTheme.Enable = true;
}
*/
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

///Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
void NLFitDlg::hideThemeControls(int nEdge, RECT& rTab)
{
		ShowControls(m_vnThemeSaveGroup, false);
		RECT rectCombo;
		Control ctrlCombo = GetItem(IDC_THEME_COMB);
		GetClientRect(ctrlCombo, rectCombo);
		
		RECT rGridParas, rNLF;
		Control ctrlParaGrid = GetItem(IDC_NLF_PARACONTROL_GRID);
		GetClientRect(ctrlParaGrid, rGridParas);
		Control	ctrlBox = GetItem(IDC_NLF_BOX);
		GetClientRect(ctrlBox, rNLF);
		
		rGridParas.top = 0;
		rNLF.top = 0;
		rTab.top = nEdge;
		MoveControl(m_TopTab, rTab);
		MoveControl(ctrlParaGrid, rGridParas);
		MoveControl(ctrlBox, rNLF);
}
///End ADD_NLSF_NO_THEME_DLG

///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
//--- CPY 4/23/07 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS_BROKE_SETTINGS_RESIZE
// return current tab selection index
//void		NLFitDlg::arrangeTabControls(RECT& rTab)
int NLFitDlg::arrangeTabControls(RECT& rTab)
//---
{
	int nSelTab=m_TopTab.GetCurSel();
	GetClientRect(m_TopTab, rTab);
	///DG THEME_COMBO_RESIZABLE
	int nEdge=GetControlGap(), cx=rTab.right;
	
	///Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
	//ArrangeControlsLeftRight(m_vnThemeSaveGroup, nEdge, nEdge, cx, IDC_THEME_COMB);
	/// Hong 05/27/08 v8.0871 REFACTORING_RENAME
	//if(is_theme_dialog(m_NLF.GetOpTree()))
	if ( is_theme_dialog(m_NLF.GetGUITree()) )
	/// end REFACTORING_RENAME
	{
		if(IsTopPaneShown())	///Jasmine 05/21/07 check top pane show
		{
			///------ Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
			m_NLF.CheckResizeTextControl(GetItem(IDC_THEME_TEXT), GetItem(IDC_THEME_COMB));
			///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
			ShowControls(m_vnThemeSaveGroup, true);		///DG TABS_ON_TOP
			ArrangeControlsLeftRight(m_vnThemeSaveGroup, nEdge, nEdge, cx, IDC_THEME_COMB);
		}
	}
	else
	{
		hideThemeControls(nEdge, rTab);
	}
	///End ADD_NLSF_NO_THEME_DLG
	///end THEME_COMBO_RESIZABLE
	m_TopTab.AdjustRect(FALSE, &rTab);
	
	return nSelTab;//--- CPY 4/23/07 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS_BROKE_SETTINGS_RESIZE
}
///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS

/// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
void	NLFitDlg::onThemeValueChange(bool bReset/* = false*/, bool bOnlyCheckCurSel/* = true*/)
{		
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	/*
	int			nCurSel = m_comboTheme.GetCurSel();
	int			nStartIndex = bOnlyCheckCurSel ? nCurSel : 0;
	int			nCount = bOnlyCheckCurSel ? 1 : m_comboTheme.GetCount();
	
	string		strThemeText;
	for ( int ii = 0; ii < nCount; ++ii )
	{
		m_comboTheme.GetLBText(nStartIndex + ii, strThemeText);
		bool		bHasModifiedSymbol = !strThemeText.IsEmpty() && ('*' == strThemeText[strThemeText.GetLength() - 1]);
		if ( bReset && bHasModifiedSymbol || !(bReset || bHasModifiedSymbol) )
		{	
			if ( !bReset )
				strThemeText += '*';
			else
				strThemeText.TrimRight('*');
			
			int		nIndex = m_comboTheme.InsertString(nStartIndex + ii, strThemeText);			
			m_comboTheme.DeleteString(nIndex + 1);
			m_comboTheme.SetCurSel(nCurSel);
			break;
		}
	}
	*/
	m_NLF.SPLUpdateThemeUnSaveSign(!bReset);
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
}
/// end ADD_STAR_INDICATE_THEME_VALUE_CHANGE

/// Hong 09/11/08 v8.0937 FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE
/// Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
//void	NLFitDlg::updateDisplayOnParamsChange()
///------ Folger 08/08/2011 ORG-2740-P6 PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
//void	NLFitDlg::updateDisplayOnParamsChange(bool bForceShowResult/* = false*/)
void	NLFitDlg::updateDisplayOnParamsChange(bool bForceShowResult/* = false*/, BOOL bClearGrid/* = TRUE*/)
///------ End PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
/// end ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
{
	const int		nSelTab = m_TopTab.GetCurSel();
	//bool			bUpdateParamGrid = IsTopPaneShown() && (NLF_PARAMETERS_TAB == nSelTab || NLF_PARABOUND_TAB == nSelTab);	
	bool			bUpdateParamGrid = IsTopPaneShown() && m_paramTabs.IsParamTab(nSelTab);	///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	/// Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
	//updateDisplay(bUpdateParamGrid, true);	
	///------ Folger 08/08/2011 ORG-2740-P6 PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
	//updateDisplay(bUpdateParamGrid, true, false, false, bForceShowResult);
	updateDisplay(bUpdateParamGrid, true, false, false, bForceShowResult, bClearGrid);
	///------ End PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
	/// end ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
}
/// end FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE

int		NLFitDlg::moveShownControlToTopTab()
{
//-------------- CPY 4/23/07 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS_BROKE_SETTINGS_RESIZE
// since m_TopTab.GetCurSel() is called inside arrangeTabControls, might as well return it to avoid 
// calling it twice
//	int nSelTab=m_TopTab.GetCurSel();
//	RECT rTab;
//	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
//	arrangeTabControls(rTab);
	RECT rTab;
	int nSelTab = arrangeTabControls(rTab);
//--------------
	//GetClientRect(m_TopTab, rTab);
	/////DG THEME_COMBO_RESIZABLE
	//int nEdge=GetControlGap(), cx=rTab.right;
	//
	/////Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
	////ArrangeControlsLeftRight(m_vnThemeSaveGroup, nEdge, nEdge, cx, IDC_THEME_COMB);
	//if(isThemeDialog(m_NLF.GetOpTree()))
	//{
		//ShowControls(m_vnThemeSaveGroup, true);		///DG TABS_ON_TOP
		//ArrangeControlsLeftRight(m_vnThemeSaveGroup, nEdge, nEdge, cx, IDC_THEME_COMB);
	//}
	//else
	//{
		//hideThemeControls(nEdge, rTab);
	//}
	/////End ADD_NLSF_NO_THEME_DLG
	/////end THEME_COMBO_RESIZABLE
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	
	switch(nSelTab)
	{
	case NLF_SETTING_TAB:
	case NLF_CODE_TAB:	///Danice ADD_CODE_EDIT_TAB
		/*
		RECT rBox;
		rBox=rTab;
		Control cBox=GetItem(IDC_NLF_BOX);
		MoveControl(cBox, rBox);
		*/
		//-------------- CPY 4/23/07 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS_BROKE_SETTINGS_RESIZE
		// I don't understand why Cheney remove this here, he will need to find out how to change this properly
		///Cheney 2007-4-24 RESIZE_DLG_SHOULD_CONSIDER_CHECK_BOX_SHOW_OR_NOT
		//arrangeSettingsCodeControls(nSelTab, rTab);
		arrangeParamsInitConstrControls(nSelTab == NLF_SETTING_TAB? false : true);
		///end RESIZE_DLG_SHOULD_CONSIDER_CHECK_BOX_SHOW_OR_NOT
		//--------------
		///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
		//OnRowChange in NLFitSplitter will do it
		//arrangeSettingsCodeControls(nSelTab, rTab);
		///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
		m_checkEnableAutoParamsInit.Visible = false;///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
		m_ctrlParamTabHint.Visible = false; /// Iris 1/06/2009 QA81-14920 HINT_FOR_PARAM_BOUNDS_TAB		
		break;
	///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	//case NLF_PARAMETERS_TAB:
	//case NLF_PARABOUND_TAB:
	default:
		if( !m_paramTabs.IsParamTab(nSelTab) )
		{
			ASSERT(0);
			break;
		}
	///End CUSTOMIZATION_PARAMETER_TAB
		m_ctrlParamTabHint.Visible = true; /// Iris 1/06/2009 QA81-14920 HINT_FOR_PARAM_BOUNDS_TAB
		/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
		/*
		Control ctrlGrid=GetItem(IDC_NLF_PARACONTROL_GRID);
		//ctrlGrid.MoveWindow(&rTab);
		MoveControl(ctrlGrid, rTab);
		*/
		///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
		//arrangeParamsBoundControls(&rTab);
		arrangeParamsBoundControls(&rTab);//, nSelTab == NLF_PARAMETERS_TAB? true : false);	///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
		///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
		///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
		///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
		///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
		//m_checkEnableAutoParamsInit.Visible = false;
		m_checkEnableAutoParamsInit.Visible = true;
		///end SWITCH_SHOW_HINTS_AND_CHECKBOX
		m_checkEnableConstraints.Visible = false;
		m_ctrlExplanationText.Visible = false;		//------ Folger 01/03/08 ADD_SELECTION_EXPLANATION_TO_CODE_TAB
		///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
		break;
	}
	
	return nSelTab;
}
//--- CPY 4/23/07 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS_BROKE_SETTINGS_RESIZE
// I bring this back, from old code, Cheney had commented this out for no explanation
// this change lead to settings tab do not resize with dialog and startup showing wrong 
// size if dialog had been resized before
//---
/// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
void NLFitDlg::arrangeSettingsCodeControls(int nSelTab, RECT &rTab)
{
	RECT 	rBox;
	rBox = rTab;
	if(NLF_CODE_TAB == nSelTab)
	{
		int 		nEdge = GetControlGap();
		
		RECT		rBtn;
		///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
		//GetClientRect(m_staticNumReplica, rBtn);
		GetClientRect(m_checkEnableAutoParamsInit, rBtn);
		///end SWITCH_SHOW_HINTS_AND_CHECKBOX
		uint		width = rBtn.right - rBtn.left;
		uint		height = rBtn.bottom - rBtn.top;
		
		rBtn.left = rTab.left;
		rBtn.right = rTab.left + width;
		rBtn.top = rTab.top + nEdge;
		rBtn.bottom = rBtn.top + height;	
		///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
		//MoveControl(m_checkEnableAutoParamsInit, rBtn);
		MoveControl(m_staticNumReplica, rBtn);
		///end SWITCH_SHOW_HINTS_AND_CHECKBOX
		rBox = rTab;
		rBox.top = rBtn.bottom + nEdge;
		rBox.left = rTab.left;
	}
	
	Control 	cBox = GetItem(IDC_NLF_BOX);
	MoveControl(cBox, rBox);
}
///end ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT

///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
///// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
//void NLFitDlg::arrangeSettingsCodeControls(int nSelTab, RECT &rTab)
//{
	//RECT 	rBox;
	//rBox = rTab;
	////if(NLF_CODE_TAB == nSelTab)
	////{
		////int 		nEdge = GetControlGap();
		////
		////RECT		rBtn;
		////GetClientRect(m_checkEnableAutoParamsInit, rBtn);
		////uint		width = rBtn.right - rBtn.left;
		////uint		height = rBtn.bottom - rBtn.top;
		////
		////rBtn.left = rTab.left;
		////rBtn.right = rTab.left + width;
		////rBtn.top = rTab.top + nEdge;
		////rBtn.bottom = rBtn.top + height;	
		////MoveControl(m_checkEnableAutoParamsInit, rBtn);
		////
		////rBox = rTab;
		////rBox.top = rBtn.bottom + nEdge;
		////rBox.left = rTab.left;
	////}
	//
	//Control 	cBox = GetItem(IDC_NLF_BOX);
	//MoveControl(cBox, rBox);
//}
/////end ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
void NLFitDlg::arrangeParamsInitConstrControls(bool bCodeTab)
{
	RECT rTab;
	arrangeTabControls(rTab);
	
	RECT 	rBox;
	rBox = rTab;
	
	Button btn;
	///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
	//if(m_checkEnableAutoParamsInit && m_checkEnableAutoParamsInit.Visible)
		//btn = m_checkEnableAutoParamsInit;
	if(m_staticNumReplica && m_staticNumReplica.Visible)
		btn = m_staticNumReplica;
	///end SWITCH_SHOW_HINTS_AND_CHECKBOX
	else if(m_checkEnableConstraints && m_checkEnableConstraints.Visible)
		btn = m_checkEnableConstraints;
	//------ Folger 01/03/08 ADD_SELECTION_EXPLANATION_TO_CODE_TAB
	if ( bCodeTab && !btn )
	{
		btn = m_ctrlExplanationText;
		btn.Visible = true;
		/// Hong 01/18/08 b8.0788 TIP_NEED_DO_LOCALIZATION
		//vector<string> vsExplanationText = {"Fitting Function Formula", "", "", "Scripts to Execute After Fitting"};
		///Sophy 10/20/2008 QA80-12406 
		//vector<string> vsExplanationText(4);
		/// Hong 01/04/10 QA80-14907-P1 TAKE_BACK_SCRIPT_BEFORE_FITTING
		/*
		vector<string> vsExplanationText(5);
		///end ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
		vsExplanationText[0] = _L("Fitting Function Formula");
		vsExplanationText[3] = _L("Scripts to Execute After Fitting");
		vsExplanationText[4] = _L("Derived Parameters Formula");///Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
		/// end TIP_NEED_DO_LOCALIZATION
		*/
		///---Sim 2011-07-25 ORG-3328 SUPPORT_DEFINE_LT_FUNC_BODY_FOR_FDF
		/*
		int				nCount = 5;
#ifdef 		ALLOW_SCRIPT_BEFORE_AFTER_FITTING		
		++nCount;
#endif 		//ALLOW_SCRIPT_BEFORE_AFTER_FITTING
		vector<string> 	vsExplanationText(nCount);
		vsExplanationText[--nCount] = _L("Derived Parameters Formula");;
		vsExplanationText[--nCount] = _L("Scripts to Execute After Fitting");
#ifdef 		ALLOW_SCRIPT_BEFORE_AFTER_FITTING
		vsExplanationText[--nCount] = _L("Scripts to Execute Before Fitting");
#endif 		//ALLOW_SCRIPT_BEFORE_AFTER_FITTING
		--nCount;
		--nCount;
		vsExplanationText[--nCount] = _L("Fitting Function Formula");
		ASSERT( 0 == nCount );
		*/
		int				nCount = NUM_ROW_ORDER_NLSF_CODES;
		vector<string> 	vsExplanationText(nCount);
		vsExplanationText[ROW_ORDER_NLSF_CODES_FUNC] = _L("Fitting Function Formula");
		//vsExplanationText[ROW_ORDER_NLSF_CODES_LT_FUNC_INIT] = _L("");
		vsExplanationText[ROW_ORDER_NLSF_CODES_BEFOREFIT] = _L("Scripts to Execute Before Fitting");
		vsExplanationText[ROW_ORDER_NLSF_CODES_AFTERFIT] = _L("Scripts to Execute After Fitting");
		vsExplanationText[ROW_ORDER_NLSF_CODES_DERIVATIVE] = _L("Derived Parameters Formula");;
		///---END ORG-3328 SUPPORT_DEFINE_LT_FUNC_BODY_FOR_FDF
		/// end TAKE_BACK_SCRIPT_BEFORE_FITTING
		int nRow = m_NLF.GetSelectedRow();	
		/// Iris 4/17/2008 QA80-11439 FIX_RUNTIME_IF_CHOOSE_OUTPUT_IN_FIRST_TAB_THEN_SWITCH_TO_2ND_TAB
		//if ( nRow >= 0 )
		if( nRow >=0 && nRow < vsExplanationText.GetSize() )
		///end FIX_RUNTIME_IF_CHOOSE_OUTPUT_IN_FIRST_TAB_THEN_SWITCH_TO_2ND_TAB
		{
			btn.Text = vsExplanationText[nRow];
		}
	}
	else
	{
		m_ctrlExplanationText.Visible = false;
	}
	//------
	///Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
	//only top pane show, show the btn
	//if(bCodeTab)
	if(bCodeTab && btn && IsTopPaneShown())
	///End FIX_BUG_ON_NLF_DLG_RESIZE
	{
		int 		nEdge = GetControlGap();
		
		RECT		rBtn;
		GetClientRect(btn, rBtn);
		uint		width = rBtn.right - rBtn.left;
		uint		height = rBtn.bottom - rBtn.top;
		
		rBtn.left = rTab.left;
		rBtn.right = rTab.left + width;
		rBtn.top = rTab.top + nEdge;
		rBtn.bottom = rBtn.top + height;
		MoveControl(btn, rBtn);
		
		rBox = rTab;
		rBox.top = rBtn.bottom + nEdge;
		rBox.left = rTab.left;
	}
	///Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
	else if(btn)
	{
		btn.Visible = false;
	}
	///End FIX_BUG_ON_NLF_DLG_RESIZE
	
	Control 	cBox = GetItem(IDC_NLF_BOX);
	MoveControl(cBox, rBox);
	if(cBox.Visible)	///Jasmine 06/05/07 QA80-9852 NOT_RESIZE_IF_HIDDEN, resize splitter
		m_NLF.OnDlgResize(0, 0, 0);
}
///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS

/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
//void NLFitDlg::arrangeParamsBoundControls(RECT* prTab)
void NLFitDlg::arrangeParamsBoundControls(RECT* prTab, bool bParamsTab)
///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
{
	int 		nEdge = GetControlGap();	
	RECT		rBtn1, rBtnNumReplica, rGrid;
	
	RECT 		rTab;
	
	///Joseph 06/19/07 FIX_BUG_NLSF_DLG_REISZE
	//should not use tab top as the the top inside the tab.
	//if(NULL == prTab)
	//{
		//GetClientRect(m_TopTab, rTab);
	//}
	//else
	//{
		//rTab = *prTab;
	//}
	rTab = *prTab;
	///End FIX_BUG_NLSF_DLG_REISZE
	//move "Apply Parameters & Bounds Settings from theme" to right position
	///Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
	int nBottom = rTab.top;
	uint width, height;
	
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//if(m_checkApplyParamsTheme.Visible)
	//{
	/////End ADD_NLSF_NO_THEME_DLG
		//GetClientRect(m_checkApplyParamsTheme, rBtn1);
		//width = rBtn1.right - rBtn1.left;
		//height = rBtn1.bottom - rBtn1.top;
		//rBtn1.left = rTab.left;
		//rBtn1.right = rTab.left + width;
		//rBtn1.top = rTab.top + nEdge;
		//rBtn1.bottom = rBtn1.top + height;	
		//MoveControl(m_checkApplyParamsTheme, rBtn1);
	//
	/////Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
		//nBottom = rBtn1.bottom;
	//}
	///End ADD_NLSF_NO_THEME_DLG
	///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
	//Button BtnTemp = bParamsTab? m_checkApplyParamsTheme : m_checkApplyBoundTheme;
	//
	/////Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
	////if(BtnTemp.Visible)
	//if(BtnTemp && BtnTemp.Visible && IsTopPaneShown())
	/////End FIX_BUG_ON_NLF_DLG_RESIZE 
	//{
		//GetClientRect(BtnTemp, rBtn1);
		//width = rBtn1.right - rBtn1.left;
		//height = rBtn1.bottom - rBtn1.top;
		//rBtn1.left = rTab.left;
		//rBtn1.right = rTab.left + width;
		//rBtn1.top = rTab.top + nEdge;
		//rBtn1.bottom = rBtn1.top + height;	
		//MoveControl(BtnTemp, rBtn1);
		//nBottom = rBtn1.bottom;
	//}
	/////end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY
	
	//move "Number of Replica is 0" to right position
	///Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
	//if(m_staticNumReplica.Visible)
	///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
	//if(m_staticNumReplica && m_staticNumReplica.Visible && IsTopPaneShown())
	if(m_checkEnableAutoParamsInit && m_checkEnableAutoParamsInit.Visible && IsTopPaneShown())
	///end SWITCH_SHOW_HINTS_AND_CHECKBOX
	///End FIX_BUG_ON_NLF_DLG_RESIZE
	{
		///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
		//GetClientRect(m_staticNumReplica, rBtnNumReplica);
		GetClientRect(m_checkEnableAutoParamsInit, rBtnNumReplica);
		///end SWITCH_SHOW_HINTS_AND_CHECKBOX
		width = rBtnNumReplica.right - rBtnNumReplica.left;
		height = rBtnNumReplica.bottom - rBtnNumReplica.top;
		
		rBtnNumReplica.left = rTab.left;
		rBtnNumReplica.right = rBtnNumReplica.left + width;
		
		///Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
		//rBtn2.top = rBtn1.bottom + nEdge;
		///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
		//if(m_checkApplyParamsTheme.Visible)
		///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
		//if(BtnTemp.Visible)
		/////end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
			//rBtn2.top = rBtn1.bottom + nEdge;
		//else
		///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY
			rBtnNumReplica.top = rTab.top + nEdge;
		///End ADD_NLSF_NO_THEME_DLG
		
		rBtnNumReplica.bottom = rBtnNumReplica.top + height;
		///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
		//MoveControl(m_staticNumReplica, rBtnNumReplica);
		MoveControl(m_checkEnableAutoParamsInit, rBtnNumReplica);
		///end SWITCH_SHOW_HINTS_AND_CHECKBOX
		nBottom = rBtnNumReplica.bottom;		///Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
	}	
	
	/// Iris 1/06/2009 QA81-14920 HINT_FOR_PARAM_BOUNDS_TAB
	if( m_ctrlParamTabHint && m_ctrlParamTabHint.Visible && IsTopPaneShown() )
	{
		RECT rHint;
		GetClientRect(m_ctrlParamTabHint, rHint);
		
		width = rHint.right - rHint.left;
		height = rHint.bottom - rHint.top;
		
		rHint.left = rTab.left;
		rHint.right = rHint.left + width;
		
		rHint.top = nBottom + nEdge;
		rHint.bottom = rHint.top + height;
		
		MoveControl(m_ctrlParamTabHint, rHint);		
		nBottom = rHint.bottom;		
	}
	///End HINT_FOR_PARAM_BOUNDS_TAB
	
	/// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
	if( m_btnParamHide && m_btnParamHide.Visible && IsTopPaneShown())
	{
		RECT rBtnParamHide;
		GetClientRect(m_btnParamHide, rBtnParamHide);
		width = rBtnParamHide.right - rBtnParamHide.left;
		height = rBtnParamHide.bottom - rBtnParamHide.top;
		
		rBtnParamHide.right = rTab.right - nEdge;
		rBtnParamHide.left = rBtnParamHide.right - width;
		
		rBtnParamHide.top = rTab.top + nEdge;
		rBtnParamHide.bottom = rBtnParamHide.top + height;
		
		MoveControl(m_btnParamHide, rBtnParamHide);			
		
		if(nBottom < rBtnParamHide.bottom)		///Jasmine 05/23/08 USE_BOTTOMMOST_POSITION_IF_WE_HAVE_MORE_THAN_ONE_CONTROLS_IN_ONE_ROW
			nBottom = rBtnParamHide.bottom;
	}		
	///end ADD_DLG_TO_HIDE_SHOW_PARAM

	//move "Parameter Grid" to right position	
	rGrid = rTab;
	
	///Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
	//rGrid.top = rBtn2.bottom + nEdge;
	//rGrid.left = rTab.left;
	rGrid.top = nBottom + nEdge;
	///End ADD_NLSF_NO_THEME_DLG
	
	Control 	ctrlGrid = GetItem(IDC_NLF_PARACONTROL_GRID);	
	MoveControl(ctrlGrid, rGrid);
}
///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX

//----- CPY 1/15/05 XF_DLG_CODE_CLEANUP
/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
/*
//virtual 
int NLFitDlg::GetBottomPaneSubControls(vector<uint>& vnCntrls)
{
	vnCntrls.SetSize(0);
	// must be in correct order as tabs are being linked to enum NLF_FORMULA_TAB etc
	/// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB
	if( m_NLF.IsShowFitPreview() )
	{		
		vnCntrls.Add(IDC_NLF_FIT_CURVE_PREVIEW_BOX);
	}
	
	///end ADD_FIT_CURVE_PREVIEW_TAB
	///Joe  8/17/06 PUT_RESIDUAL_TAB_TO_END
	//vnCntrls.Add(IDC_NLF_RESIDUAL_PREVIEW_BOX);
	///End PUT_RESIDUAL_TAB_TO_END
	/// Hong 03/20/08 QA80-10969 MOVE_PREVIEW_TAB_RESIDUAL_CLOSE_TO_FIT_CURVE
	vnCntrls.Add(IDC_NLF_RESIDUAL_PREVIEW_BOX);  ///Joe  8/17/06 PUT_RESIDUAL_TAB_TO_END
	/// end MOVE_PREVIEW_TAB_RESIDUAL_CLOSE_TO_FIT_CURVE
	vnCntrls.Add(IDC_NLF_PREVIEW_BOX);	
	vnCntrls.Add(IDC_NLS_CURVE_PREVIEW_BOX);
	vnCntrls.Add(IDC_NLS_OPERATION_LOG);
	vnCntrls.Add(IDC_FUNCTION_CODE_SHOW);
	/// Hong 03/20/08 QA80-10969 MOVE_PREVIEW_TAB_RESIDUAL_CLOSE_TO_FIT_CURVE
	//vnCntrls.Add(IDC_NLF_RESIDUAL_PREVIEW_BOX);  ///Joe  8/17/06 PUT_RESIDUAL_TAB_TO_END
	/// end MOVE_PREVIEW_TAB_RESIDUAL_CLOSE_TO_FIT_CURVE
	vnCntrls.Add(IDC_NLSF_OPERATION_HINT);	///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
	
	return m_BottomTab.GetCurSel();
}
*/
///End FIX_NLFITDLG_TAB_FLICKER_ISSUE

bool	NLFitDlg::updateTopPaneControlShow()
{
	updateOneLineMessageSize();		///------ Folger 02/11/09 QA80-13098-P1 NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	
	/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	//bool	bApplyParamsThemeShow = false;  ///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
	bool	bStaticNumReplicaShow = false;
	///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//bool	bApplyButtonThemeShow = false;  ///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	
	/// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS	
	//bool	bEnableAutoParamsInitShow = false; 
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	///end ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	int nSelTab = NLF_SETTING_TAB;
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	
	bool bParamHideButtonShow = false;
	
	if(IsTopPaneShown())
	{
		ShowControls(m_vnThemeSaveGroup, true);		///DG TABS_ON_TOP
		///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
		//int 	nSelTab = m_TopTab.GetCurSel();
		nSelTab = m_TopTab.GetCurSel();
		///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
		Control ctrlGrid = GetItem(IDC_NLF_PARACONTROL_GRID);
		Control ctrlBox = GetItem(IDC_NLF_BOX);
		switch(nSelTab)
		{
		case NLF_SETTING_TAB:
		case NLF_CODE_TAB:	///Danice ADD_CODE_EDIT_TAB
			ctrlBox.Visible = true;
			ctrlGrid.Visible = false;
			break;
		///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
		//case NLF_PARAMETERS_TAB:
		//case NLF_PARABOUND_TAB:
		default:
			if( !m_paramTabs.IsParamTab(nSelTab) )
			{
				ASSERT(0);
				break;
			}
		///End CUSTOMIZATION_PARAMETER_TAB
			ctrlBox.Visible = false;
			ctrlGrid.Visible = true;
			/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
			///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
			/////Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
			//bApplyParamsThemeShow = nSelTab == NLF_PARAMETERS_TAB? true : false;
			//bApplyButtonThemeShow = nSelTab == NLF_PARABOUND_TAB? true : false;
			/////end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
			///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
			///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
			//bStaticNumReplicaShow = true;
			m_checkEnableAutoParamsInit.Visible = true;
			///end SWITCH_SHOW_HINTS_AND_CHECKBOX
			///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
			bParamHideButtonShow = true; /// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
			break;
		}
		/// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
		///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS	
		//if(NLF_CODE_TAB == nSelTab)
		//{
			//bEnableAutoParamsInitShow = true;
			/////Cheney 2007-4-14 IF_NO_THEME_AUTO_INIT_WILL_ACCORDING_TO_FDF
			//m_checkEnableAutoParamsInit.Check = m_NLF.IsEnableAutoParamsInitFromOperation();
			/////end IF_NO_THEME_AUTO_INIT_WILL_ACCORDING_TO_FDF
		//}
		///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
		///end ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	}
	else
	{
		vector<uint> vnTopTab;
		vnTopTab=m_vnThemeSaveGroup;
		int nSize=vnTopTab.GetSize();
		vnTopTab[nSize-1]=IDC_NLF_BOX;
		vnTopTab.Add(IDC_NLF_PARACONTROL_GRID);
		vnTopTab.Add(0); //for end
		
		ShowControls(vnTopTab, false);
		Invalidate(); /// Iris 11/28/2011 ORG-4457-P2 FIX_NLFIT_DLG_REDRAW_ISSUE
	}
	/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	
	///Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
	//m_checkApplyParamsTheme.Visible = bApplyParamsThemeShow;
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//if(isThemeDialog(m_NLF.GetOpTree()))
		//m_checkApplyParamsTheme.Visible = bApplyParamsThemeShow;
	//else
		//m_checkApplyParamsTheme.Visible = false;
	///Cheney 2007-7-23 QA80-10090 MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY	
	//if(is_theme_dialog(m_NLF.GetOpTree()))
	//{
		//m_checkApplyParamsTheme.Visible = bApplyParamsThemeShow;
		//m_checkApplyBoundTheme.Visible = bApplyButtonThemeShow;
	//}
	//else
	//{
		//m_checkApplyParamsTheme.Visible = false;
		//m_checkApplyBoundTheme.Visible = false;
	//}
	/////end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	///end MODIFY_STH_ABOUT_FDF_SAVING_AND_THEME_APPLY
	///End ADD_NLSF_NO_THEME_DLG
	
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//if(bStaticNumReplicaShow)
		//updateStaticNumReplica();
		//only NLF_PARAMETERS_TAB or NLF_PARABOUND_TAB bStaticNumReplicaShow will be true 
	///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
	//if(bStaticNumReplicaShow && nSelTab > NLF_CODE_TAB)	
	if(bStaticNumReplicaShow && nSelTab == NLF_CODE_TAB)	
	///end SWITCH_SHOW_HINTS_AND_CHECKBOX
		updateStaticNumReplica(nSelTab);
	/// Hong 01/17/08 v8.0787b MORE_TIPS_OF_AUTO_INIT_STATUS_IN_PARAMS_TAB
	else // hidden is not shown
		m_staticNumReplica.Visible = false;
	/// end MORE_TIPS_OF_AUTO_INIT_STATUS_IN_PARAMS_TAB
		///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	
	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	///// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	//m_checkEnableAutoParamsInit.Visible = bEnableAutoParamsInitShow;
	/////end ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	
	m_btnParamHide.Visible = bParamHideButtonShow;/// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
	return true;
}

///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS	
bool	NLFitDlg::updateParamsInitAndConstrShow(bool bCodeTab, DWORD dwShowCheckBox)
{
	///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
	if(m_staticNumReplica )
		m_staticNumReplica.Visible= dwShowCheckBox & NLFIT_SHOW_REPLICA_HINTS ? true : false;
	///end SWITCH_SHOW_HINTS_AND_CHECKBOX
	
	if(m_checkEnableAutoParamsInit)
		m_checkEnableAutoParamsInit.Visible = dwShowCheckBox & NLFIT_SHOW_PARAMS_INIT_CHECK_BOX? true : false;
	
	if(m_checkEnableConstraints)
		m_checkEnableConstraints.Visible = dwShowCheckBox & NLFIT_SHOW_CONSTRAINTS_CHECK_BOX? true : false;

	arrangeParamsInitConstrControls(bCodeTab);
	return true;
}
///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
/////Cheney 2007-5-16 UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC
//void	NLFitDlg::updateParamsInitEnable(uint wParam, uint lParam)
//{
	//m_checkEnableAutoParamsInit.Check = m_NLF.LoadAutoParamsInitSetting();	
//}
/////end UPDATE_AUTOINIT_PRAMS_SETTING_WHEN_CHANGE_FUNC
/// Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/*
void	NLFitDlg::updateParamsInitAndLinearConstraEnable(uint wParam, uint lParam)
{
	m_checkEnableAutoParamsInit.Check = m_NLF.LoadAutoParamsInitSetting(m_NLF.GetFDFTree());
	m_checkEnableConstraints.Check = m_NLF.LoadLinearConstraintsSetting(m_NLF.GetFDFTree());
}
*/
/// end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC


/// YuI 11/09/06 SOME_REDESIGN_OF_NLFIT_FOR_MODAL
/*
BOOL 	NLFitDlg::OnClickOK()
{
	PROFILE_HRGLASS
	
	//---- CPY 10/18/04	NLF_DOMODAL_FOR_FIT_EXP_DECAY_TYPE
	/*
	/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
	if( m_dwOperationUID != 0 )
	{
		// if operation UID is not 0 we are in ChangeParam mode
		OperationBase op;
		op = (OperationBase) Project.GetObject(m_dwOperationUID);
		TreeNode tr;
		op.GetTree(tr);
		UpdateOperationTree(tr);
		op.SetTree(tr);
	}
	else
	*/
	/* /// YuI 11/09/06
	///Jasmine 11/09/06 CHANGE_NLFIT_MODAL	
	/// Iris 8/08/06 BACK_PREVIOUS_CHANGE_WAIT_CP_TO_SEE
	///// Iris 8/07/06 3D_CLICK_OK_FAIL_CONVERG
	//TreeNode trOp;
	//if(	m_NLF.IsValidOpTree(trOp) )
	//{
		//UpdateOperationTree(trOp);
		//return true;
	//}
	///////end 3D_CLICK_OK_FAIL_CONVERG
	//else
	//{
	TreeNode tr;
	m_NLF.IsValidOpTree(tr);
	
		updateFitSessionFromDlg(); // call this incase user didn't call other things
		
		bool bOK;
		//----- CPY 5/17/06 NLFIT_CLICK_OK_FAILED_CONVERGE
		//OperationBase& op = op_create(STR_NLF_BASE_CLASS, bOK);
		FitNL & op= (FitNL &)op_create(STR_NLF_BASE_CLASS, bOK);
		//------
	//	ASSERT(bOK);
		if( op )
		{
			//TreeNode tr;
			//op.GetTree(tr);
			UpdateOperationTree(tr);
			op.SetTree(tr);
		
			/// Iris 2/06/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT
			int		nInMode = tree_get_oper_multidata_modes(tr.GUI);
			if (MDINPUT_INDEPENDENT_SEPARATE == nInMode)
			{
				DWORD		dwRules = op.GetDataRules(tr);
				Tree		trOpClone;
				trOpClone = tr;
				op_destroy_on_cancel(op);
				
				bool bRtn = separate_op_execute(STR_NLF_BASE_CLASS, trOpClone, dwRules);
				return bRtn;
			}
			///End INDEP_DATA_CONSOLID_OR_SEP_REPORT
			else //the original consolid output			
			{			
				int nAutoUpdate = AU_NONE;
				op.SetFitSession(m_NLF.GetFitSessionPtr(true));//----- CPY 5/17/06 NLFIT_CLICK_OK_FAILED_CONVERGE
				op.OnNoEdit(0, nAutoUpdate, NULL);
	
				/*
				if( !op.Execute(OEXEM_ON_CREATE) )
				{
					op_destroy_on_cancel(op);
					//---- CPY 4/23/05 OK_ON_BAD_FIT_DO_NOT_CLOSE_DIALOG
					//error_report("Err: NLFitterOperation failed on Execute");
					//return true; //to close dialog
					if(MessageBox(GetSafeHwnd(), _L("Fit didnt converge, exit anyway?"), _L("Attention"), MB_OKCANCEL) == IDCANCEL)
					{
						m_NLF.SetFitSessionPtr(op.GetFitSession(true));  /// Iris 06/16/06 SET_BACK_FIT_POINTER_FOR_BAD_FIT
						return false;
					}
					op.ReleaseFitSession();
					return true;
					//----
				}
	
				if( AU_NONE == nAutoUpdate )
					op_destroy_on_cancel(op, false);
				else
				{
					// need to clean dirtiness and untask
				}
				op.ReleaseFitSession();
				return true;
				*/
				/* /// YuI 11/09/06
				op.GetTree(tr);				
				op_destroy_on_cancel(op);
				return true;
			}
		}
		///End CHANGE_NLFIT_MODAL	
		error_report("Err: NLFitterOperation failed on Create Class");
		
		//----------
	//}
	/// end NLFITTER_OPERATION_IMPLEMENTATION
	
	return true;
}
*/

BOOL 	NLFitDlg::OnClickOK()
{
	/// Hong 04/28/08 v8.0851 AVOID_CRASH_BY_TEMP_TERMINATE_WHEN_UNCHECK_AUTO_UPDATE
	if ( !m_checkEnableAutoUpdate.Check )
	{
		PostMessage(WM_CLOSE);
		return false;
	}
	/// end AVOID_CRASH_BY_TEMP_TERMINATE_WHEN_UNCHECK_AUTO_UPDATE
	PROFILE_HRGLASS
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	//m_NLF.UpdateOperationTree();
	m_NLF.UpdateOperationTree(m_bNoFitAgain);
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN

	return true;
}

/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
BOOL 	NLFitDlg::OnClickDone(Control ctrl)
{
	m_bNoFitAgain = true;
	PostMessage(WM_COMMAND, IDOK, 0);
	return true;
}
/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
/// SOME_REDESIGN_OF_NLFIT_FOR_MODAL

/// Iris 11/13/06 DO_TWO_TIMES_SEP_REPORT_IN_NLFIT_AND_OPBASE
/*
/// Iris 2/06/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT
bool	separate_op_execute(LPCSTR lpcszClassName, TreeNode& trOp, DWORD dwRules)
{	
	int			nCountRanges = op_get_input_data_number(trOp.GUI, dwRules);
	
	for (int ii = 0; ii < nCountRanges; ii++)
	{
		TreeNode	trSeparate = trOp.Clone();
		TreeNode	trInputSeparate = trSeparate.GUI.InputData;
		// Need to remove all the children except the ii'th one:
		TreeNode	trChild = trInputSeparate.FirstNode;
		int			jj = 0;
		while( trChild.IsValid() )
		{
			if (jj == ii)
				trChild = trChild.NextNode;	// skip
			else
			{
				TreeNode	trDestroy = trChild;
				trChild = trChild.NextNode;
				trInputSeparate.RemoveChild(trDestroy);
			}
			
			jj++;
		}
		
		bool 			bOK;
		OperationBase	&opSeparate = op_create(lpcszClassName, bOK);
		
		prepare_input_data_for_operation(trSeparate.GUI.InputData, true); //to create data range object and save its UID to trInputData's Attribute DATA_RANGE_UID
		separate_multi_parameters_for_operation(trSeparate, nCountRanges, ii);
		
		opSeparate.Init(trSeparate); //Set operation tree to object
		
		if( !opSeparate.Execute(OEXEM_ON_CREATE) )
		{
			op_destroy_on_cancel(opSeparate);
			if(MessageBox(NULL, _L("Fit didnt converge, exit anyway?"), _L("Attention"), MB_OKCANCEL) == IDCANCEL)
				return false;
		}
		
	}
							
	return true;
}

bool 	separate_multi_parameters_for_operation(TreeNode &trOp, int nCountRanges, int index)
{
	TreeNode trParams = trOp.FitWorkArea.Parameters;
	if( !trParams )
		return false;
	
	int 			nSubStart, nSubEnd = 0;
	vector<string> 	vsNames;
	vsNames = trParams.Names.strVals;	
	int nParaNum = vsNames.GetSize()/nCountRanges;
	nSubStart = index * nParaNum;
	nSubEnd = nSubStart + nParaNum -1;
	
	foreach(TreeNode trN in trParams.Children)
	{
		switch(trN.TypeID)
		{
		case TNVAL_TYPE_CSTRING_VECTOR:
			vector<string> vs, vsTemp;
			vs = trN.strVals;
			get_sub_string_vector(vs, vsTemp, nSubStart, nSubEnd);
			trN.strVals = vsTemp;
			break;
		case TNVAL_TYPE_DOUBLE_VECTOR:
			vector vd, vdTemp;
			vd = trN.dVals;
			vd.GetSubVector(vdTemp, nSubStart, nSubEnd);
			trN.dVals = vdTemp;
			break;
		case TNVAL_TYPE_INT_VECTOR:
			vector<int> vn, vnTemp;
			vn = trN.nVals;			
			vn.GetSubVector(vnTemp, nSubStart, nSubEnd);
			trN.nVals = vnTemp;
		default:
			break;
		}			
	}
	
	return true;
}

//GetSubVector not support get sub string vector now, see #7026
bool get_sub_string_vector(const vector<string>& vs, vector<string>& vsDest, int nStart, int nEnd = -1)
{
	int nSize = vs.GetSize();
	if(-1 == nEnd)
		nEnd = nSize - 1;
	if(nStart >= nSize || nEnd >= nSize)
		return false;
	
	vsDest.RemoveAll();
	for(int ii=nStart; ii<=nEnd; ii++)
	{
		vsDest.Add(vs[ii]);
	}
	return true;	
}
*/
///end  DO_TWO_TIMES_SEP_REPORT_IN_NLFIT_AND_OPBASE
///End INDEP_DATA_CONSOLID_OR_SEP_REPORT

BOOL 	NLFitDlg::OnClickCancel()
{
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//saveFDFOnValueChanged();			///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	if(m_bInFitIterate)//CPY TD 3/16/2007 QA70-9473 NLFIT_NEEDS_FEEDBACK_TO_USER_AND_ESC_TO_ABORT_FITTING
		return false;

	return true;
}

/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
void	NLFitDlg::beforeFit()
{
	//---- CPY 8/22/05 PARAM_INIT_CALLED_WHENEVER_HITTING_FIT
	//m_NLF.UpdateDataSelection();  /// Iris 8/22/05 UPDATE_INPUT_DATA
	//----
	m_bInFitIterate = true;//CPY TD 3/16/2007 QA70-9473 NLFIT_NEEDS_FEEDBACK_TO_USER_AND_ESC_TO_ABORT_FITTING
}
/// end NLFITTER_OPERATION_IMPLEMENTATION

BOOL 	NLFitDlg::OnClickFit(Control ctrl)
{
	PROFILE_HRGLASS
	
	DWORD	dwNLDlgUpdate = 0;
	
	/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
	beforeFit();
	/// end NLFITTER_OPERATION_IMPLEMENTATION
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	//m_NLF.Fit(-1, FITMETH_LEVENBERG_MARQUARDT, &dwNLDlgUpdate);
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//m_NLF.Fit(-1, FITMETH_LEVENBERG_MARQUARDT);
	///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//int		nFitRet = m_NLF.Fit(-1, FITMETH_LEVENBERG_MARQUARDT);
	///------ Folger 01/09/2012 ORG-4454 REFACTOR_NLFITSESSION
	//int		nFitRet = m_NLF.Fit(-1, FITMETH_LEVENBERG_MARQUARDT, GetCurrentFittingData());
	int		nFitRet = m_NLF.Fit(-1, FITMETH_AUTO, GetCurrentFittingData());
	///------ End REFACTOR_NLFITSESSION
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//afterFit();
	/// Hong 07/03/09 QA80-13590 SHOULD_CHECK_SWITCH_TO_MSG_TAB_IF_FIT_FAIL_ASKED_MAX
	//afterFit(0 == nFitRet);
	afterFit();
	/// end SHOULD_CHECK_SWITCH_TO_MSG_TAB_IF_FIT_FAIL_ASKED_MAX
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//updateOneLineMessageBox();	
	//updateFitButtonText(m_NLF.IsFitConverged()); ///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON	
	//return true;
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	//return GetWindow().PostMessage(WM_NLFITDLG_UPDATE, dwNLDlgUpdate);
	return true;
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
}

void	NLFitDlg::afterFit(bool bUpdateDisplay)
{
	m_bInFitIterate = false;//CPY TD 3/16/2007 QA70-9473 NLFIT_NEEDS_FEEDBACK_TO_USER_AND_ESC_TO_ABORT_FITTING
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//int nSelTab=m_TopTab.GetCurSel();
	//bool bShowFitMessage = bUpdateDisplay;
	//bool bUpdateParams = bUpdateDisplay && nSelTab == NLF_PARAMETERS_TAB ? true:false;
	//if(bUpdateParams || bShowFitMessage)
		//updateDisplay(bUpdateParams, bShowFitMessage);
	/// Hong 11/06/08 v8.0966c FIX_FIT_STATUS_MSG_NOT_SHOW_IN_MIDDLE_PANEL
	updateOneLineMessageBox();
	/// end FIX_FIT_STATUS_MSG_NOT_SHOW_IN_MIDDLE_PANEL
	if ( bUpdateDisplay )
	{		
		/// Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
		//updateDisplayOnParamsChange();
		///------ Folger 08/08/2011 ORG-2740-P6 PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
		//updateDisplayOnParamsChange(true);
		updateDisplayOnParamsChange(true, FALSE);
		///------ End PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
		/// end ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
		updateParts(NLDLGPART_FIT_CONTROL_BTNS);
	}
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	
	///Kyle 01/16/2009 CHECK_LAST_ITERATE_OUTCOME
	if(FITITER_FAILED_GENERAL_LINEAR_CONSTRAINTS == m_NLF.GetLastIterateOutCome())
	{
		DWORD dwEnables = 0;
		updateShowButtons(false, dwEnables);
	}
	///End CHECK_LAST_ITERATE_OUTCOME
	
}

BOOL 	NLFitDlg::OnClickOneIter(Control ctrl)
{
	PROFILE_HRGLASS
	
	DWORD	dwNLDlgUpdate = 0;
	
	beforeFit();
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	//m_NLF.Fit(1, FITMETH_LEVENBERG_MARQUARDT, &dwNLDlgUpdate);
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//m_NLF.Fit(1, FITMETH_LEVENBERG_MARQUARDT);
	///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//int 	nFitRet = m_NLF.Fit(1, FITMETH_LEVENBERG_MARQUARDT);
	///------ Folger 01/09/2012 ORG-4454 REFACTOR_NLFITSESSION
	//int 	nFitRet = m_NLF.Fit(1, FITMETH_LEVENBERG_MARQUARDT, GetCurrentFittingData());
	int 	nFitRet = m_NLF.Fit(1, FITMETH_AUTO, GetCurrentFittingData());
	///------ End REFACTOR_NLFITSESSION
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG

	/////all of this should be done by the handler of WM_NLFITDLG_UPDATE, that's OnNLFitDlgUpdate
	/////
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//afterFit();
	/// Hong 07/03/09 QA80-13590 SHOULD_CHECK_SWITCH_TO_MSG_TAB_IF_FIT_FAIL_ASKED_MAX
	//afterFit(0 == nFitRet);
	afterFit();
	/// end SHOULD_CHECK_SWITCH_TO_MSG_TAB_IF_FIT_FAIL_ASKED_MAX
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//updateOneLineMessageBox(); /// Iris 07/03/2007 v8.0654 NEED_SHOW_FIT_RESULT_MSG_AFTER_ONE_ITERATE
	//updateFitButtonText(m_NLF.IsFitConverged()); ///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
	//return true;
	/// Hong 20/05/08 v8.0867 NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
	//return GetWindow().PostMessage(WM_NLFITDLG_UPDATE, dwNLDlgUpdate);
	return true;
	/// end NLF_SPLITTER_SUPPORT_GROUP_UPDATE_EVENT_TO_ONE_MSG
}

BOOL 	NLFitDlg::OnClickChiSQ(Control ctrl)
{
	PROFILE_HRGLASS
	
	/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
	beforeFit();
	/// Hong 09/03/08 QA80-12130 NLFIT_SESSION_SUPPORT_SEPARATE_FIT
	//double dbChiSqr = m_NLF.GetChiSqr();
	///------ Folger 10/10/2011 ORG-2740-P10 SEPERATE_FIT_DATASET_FAILED_AFTER_REDUCED_CHISQR
	//m_NLF.GetChiSqr();
	m_NLF.GetChiSqr(NULL, GetCurrentFittingData());
	///------ End SEPERATE_FIT_DATASET_FAILED_AFTER_REDUCED_CHISQR
	/// end NLFIT_SESSION_SUPPORT_SEPARATE_FIT
	//------ Folger 03/25/08 QA80-11304 SUPPORT_SHARED_PARAMETERS_IN_REPLICA_FITTING
	//afterFit(false);
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//bool bReplica = m_NLF.GetReplicaNode().Number.nVal > 0;
	///afterFit(bReplica);
	afterFit(false);
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//------
	
	m_staticMessage.Text = m_NLF.GetReducedChiSqrInfo();		///------ Folger 02/11/09 QA80-13098-S2 SHOW_CHISQR_INFO_IN_NLFIT_STATIC_MESSAGE
	updateOneLineMessageSize();
	
	return TRUE;
	/// end NLFITTER_OPERATION_IMPLEMENTATION
}
///Danice ADD_PARAM_INIT_BUTTON
BOOL	NLFitDlg::OnClickInit(Control ctrl)
{
	PROFILE_HRGLASS
	
	//--- CPY 11/1/04 PARAM_INIT_BUTTON_CODE_CLEAN_UP
	/*
	m_NLF.RunParamsInitValues();
	m_GridParas.Update();
	m_NLF.NotifyParamChange(-1, -1);
	updateShowButtons();
	m_OPMsgLog.Reset();
	*/
 	///Frank 01/12/05 NOT_NEED_UPDATE_PARAMATER_CONTRO_CURRENT_TAB_NOT_PC
	//if(	m_NLF.RunParamsInitValues())
	int nSelTab=m_TopTab.GetCurSel();
	///DG 5/20/05 CLICK_INIT_ENABLE_BUTTON : bug here, should update button status
	/*
	if(	m_NLF.RunParamsInitValues() && nSelTab == NLF_PARAMETERS_TAB)
 	///End NOT_NEED_UPDATE_PARAMATER_CONTRO_CURRENT_TAB_NOT_PC
		//updateDisplay();
	*/
	///------Frank 8/24/05 QA70-7872 v8.0292 UPDATE_PRA_DLG_TO_SESSION_BEFORE_UPDATE
	/// Iris 06/12/2007 v8.0639 NOT_ERROR_SHOW_WHEN_FAIL_TO_COMPILE_PARAM_INIT_CODES	
	/*
	///------End UPDATE_PRA_DLG_TO_SESSION_BEFORE_UPDATE
	///Cheney 2007-5-17 IF_NOT_CHECK_AOTO_INIT_SHOULD_LOAD_PARAMS_VAL_FROM_FDF
	//if(	m_NLF.RunParamsInitValues() )
	if(	m_NLF.RunParamsInitValues(m_checkEnableAutoParamsInit.Check) )
	///end IF_NOT_CHECK_AOTO_INIT_SHOULD_LOAD_PARAMS_VAL_FROM_FDF

		updateDisplay(nSelTab == NLF_PARAMETERS_TAB, true);
	///end CLICK_INIT_ENABLE_BUTTON
	//---
	*/
	///Cheney 2007-8-2 CLICK_INIT_BUTTON_MEANS_CALL_INIT_CODE
	//bool 	bRet = m_NLF.RunParamsInitValues(m_checkEnableAutoParamsInit.Check);
	//Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	//bool 	bRet = m_NLF.RunParamsInitValues(true);
	int 	nChecked = m_checkEnableAutoUpdate.Check;
	if(!nChecked)
	m_NLF.SetEnableUpdate(true);
	int 	nParamInitChecked = m_checkEnableAutoParamsInit.Check;
	if(!nParamInitChecked)
		m_NLF.SetAutoInitParams(true);
	///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	//bool bRet = m_NLF.DoUpdate(true);
	///Sophy 11/11/2008 v8.968c QA80-12567 SWITCH_BETWEEN_FIT_MODE_SHOULD_NOT_ALWAYS_INIT_PARAMS
	//int  	nRet = m_NLF.DoUpdate(true);
	///Sophy 12/16/2010 ORG-1769-P1 PROPER_INIT_PREVIEW_GRAPH_ON_FIT_PARAMETER_CHANGE
	//int  	nRet = m_NLF.DoUpdate(false);
	int	nRet = m_NLF.DoUpdate(false, true);
	///end PROPER_INIT_PREVIEW_GRAPH_ON_FIT_PARAMETER_CHANGE
	///end SWITCH_BETWEEN_FIT_MODE_SHOULD_NOT_ALWAYS_INIT_PARAMS
	///end DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	if(!nChecked)
		m_NLF.SetEnableUpdate(false); //restore to original value
	if(!nParamInitChecked)
		m_NLF.SetAutoInitParams(false); //restore to original value
	///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	///end CLICK_INIT_BUTTON_MEANS_CALL_INIT_CODE
	///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	//if(bRet)
	if(nRet >= 0)
	///end 	DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	{
		/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
		///// Hong 04/16/08 QA80-11383 FIX_OTHER_BTN_STATUS_NOT_UPDATE_CLICK_INIT_BTN
		//m_NLF.NotifyParamChange();
		///// end FIX_OTHER_BTN_STATUS_NOT_UPDATE_CLICK_INIT_BTN
		/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
		//Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
		//m_GridParas.LinkFunctionTreeToFitFunction(m_NLF.GetParameterTree(), m_NLF.IsMixedFunction());			///Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE
		///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
		/// Hong 09/11/08 v8.0937 FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE
		//updateDisplay(nSelTab == NLF_PARAMETERS_TAB, true);
		updateDisplayOnParamsChange();
		/// end FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE
	}
	//Arvin 04/03/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	//else
	//{
	//	//Show message tab if DoUpdate failed 
	//	showMsgTab();
	//}
	//When found < replica and update failed, should disable corresponding buttons
	//bool bEnableButtons = true;
	if(nRet != 0)
	{
		showMsgTab();
		//bEnableButtons = false;
	}
	//updateButtonsState(bEnableButtons);
	///end DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
	///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	if(m_NLF.GetNumDataset() == 1)	 ///Cheney 2007-8-27 IF_MULTI_DATASET_SHOULD_ALWAYS_SHOW_HITS	
	updateOneLineMessageBox(); ///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
	///Joseph 06/21/07 v8.0645 NLF_SHOULD_SUPPORT_CUSTOM_BUTTON_EVENT
	//use the cusotom button event to handle the parameter initialition error message.
	//on click init button ,invoke custom button event.
	
	//Control ctrlErrMsg = GetItem(IDC_ERR_MESSAGE_BOX);
	//if(ctrlErrMsg)
	//{
		//bool	bParamsInitSucceed = bRet;
		//string	strErr = bParamsInitSucceed? "" : STR_COMPILATION_ERR_FOR_PARAMS_INIT_CODES;
		////if( bParamsInitSucceed == m_NLF.m_bHasErrForInitParams)
		//{
			//ctrlErrMsg.Text = strErr;
			//OnResizeErrMsg(true, 0);
		//}
	//}	
	m_NLF.InvokeGlobalEventOnClickCustomButton1();
	///End NLF_SHOULD_SUPPORT_CUSTOM_BUTTON_EVENT
	
	///end NOT_ERROR_SHOW_WHEN_FAIL_TO_COMPILE_PARAM_INIT_CODES
	
	return true;
}
///end
///Jasmine 12/19/06 ADD_HPARENT_TO_MAKE_FO_MODAL
/////Joseph	12/11/06	ADD__BITMAP_BUTTON
//typedef BOOL (*_FUNC_STR) (string& strSel);

BOOL NLFitDlg::OnClickOpenFO(Control ctrl)
{	
	///Jasmine 06/12/07 CENTRALIZE_OPEN_FO_IN_NLFIT_SPLITTER
	/////Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	////saveFDFOnValueChanged();		///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	/////end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
//
	//TreeNode trGUI = m_NLF.GetCateListAndFuncListTree();
	//
	/////Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
  	/////Jasmine 05/18/06 RETURN_SEL_FUNCTION
	////BOOL_FUNC _pfn = Project.FindFunction("Foopen", "OriginLab\\FunctionOrganizerDlg.cpp", TRUE);
	////_FUNC_STR _pfn = Project.FindFunction("OpenFO", "OriginLab\\FunctionOrganizerDlg.cpp", TRUE);
	////FUNC_STR_DWORD_HWND _pfn = Project.FindFunction("OpenFO", "OriginLab\\FunctionOrganizerDlg.cpp", TRUE);
	//FUNC_STR_DWORD_HWND_TREENODE _pfn = Project.FindFunction("OpenFO", "OriginLab\\FunctionOrganizerDlg.cpp", TRUE);
	//if(_pfn)	
	//{
		//string str;
		/////Jasmine 11/24/06 SEL_FUNC_AFTER_OPEN
		//TreeNode trCate = tree_get_node_by_id(trGUI, IDE_NLSF_CATEGORY), trFunc = tree_get_node_by_id(trGUI, IDE_NLSF_FUNCTION);
		//if(!trCate.IsValid() || !trFunc.IsValid())
			//return false;
		//str = trCate.strVal +"|"+ trFunc.strVal;
		/////Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT
		//DWORD dw;
		//if(false == trCate.Enable)
			//dw = 1;//temp
		//TreeNode trChangedFDFs = m_NLF.GetChangeFuncsTree();
		////if(_pfn(str))
		//if(_pfn(str, dw, GetSafeHwnd(), trChangedFDFs))
		/////End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
		/////End ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT
/////End ADD_HPARENT_TO_MAKE_FO_MODAL
		//{
			///*
		 	//TreeNode tr;
		 	//vector<int> nIDs = {IDE_NLSF_CATEGORY, IDE_NLSF_FUNCTION};
		 	//for(int ii = 0; ii < nIDs.GetSize(); ii++)
		 	//{
		 		//tr = tree_get_node_by_id(trGUI, nIDs[ii]);
		 		//if(tr.IsValid())
		 			//tr.strVal = str.GetToken(ii,'|');
		 	//}
		 	//*/
		 	//trCate.strVal = str.GetToken(0,'|');
		 	//trFunc.strVal = str.GetToken(1,'|');
		/////End SEL_FUNC_AFTER_OPEN			 	
			////trGUI
			//NLFitSelFunction funcSel(trGUI);
			/////Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO 
   			//// trGUI also need update for category change only
		 	////string strCat, strName;
		 	////if(funcSel.GetCategoryAndFunction(strCat, strName))
		 	////{
				//funcSel.Init(trCate.strVal, trFunc.strVal);
		 		//m_NLF.UpdateFunctionSelection(true);	///Jasmine 01/27/07 LET_NLFITTING_CALL_AFTER_SELECTING_FUNC_FROM_FO 
		 		/////Jasmine 01/27/07 MAKE_FO_BUTTON_WORK_FOR_OTHER_TAB
		 		//LT_execute("sec -p 0.03");	//for GUI update
		 		//updateTopTabDisplay();
		 	////}
		 	/////End ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
		/////End RETURN_SEL_FUNCTION
		//
		//}
		//
	//}
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
#ifndef __NEW_FITTING_FUNCTION_WIZARD__
	if(m_NLF.OnOpenFO())
	{
 		m_NLF.UpdateFunctionSelection(FUNC_SEL_FUNC);//true);	///Jasmine 07/09/07 NLFITTING_NEED_CALL_UPDATE_FUNCTION_SCLECTION
 		LT_execute("sec -p 0.03");	//for GUI update
 		updateTopTabDisplay();
		return TRUE;
	}
#else//__NEW_FITTING_FUNCTION_WIZARD__
	return OpenFitFunctionWizard(false);
#endif//__NEW_FITTING_FUNCTION_WIZARD__
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	return FALSE;
	///End CENTRALIZE_OPEN_FO_IN_NLFIT_SPLITTER
}

///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
BOOL	NLFitDlg::OnClickNewFO(Control ctrl)
{
	return OpenFitFunctionWizard(true);
}
///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG

BOOL	NLFitDlg::OnResizeErrMsg(uint wParam, uint lParam)
{
	Control ctrl = GetItem(IDC_ERR_MESSAGE_BOX);
	
	RECT rButton, rTopPane, rMess;
	//GetClientRect(m_btnInit, rButton);
	Button btn = GetItem(IDC_NLF_SHOW_TOP);
	if(!btn)
		btn = GetItem(IDC_NLF_SHOW_BOTTOM);
	GetClientRect(btn, rButton);
	GetClientRect(m_TopTab, rTopPane);
	
	if(wParam)
	{
		///Joseph 05/04/07 SHOW_ERR_MSG_ON_NLSF_INIT
		//should support multi line. just about errmsg box resize.
		int  nWidth = RECT_WIDTH(rTopPane);
		int nHeight = ctrl.Measure(ctrl.Text, &nWidth, false);
		///End SHOW_ERR_MSG_ON_NLSF_INIT
		
		rMess.bottom = rButton.top - GetControlGap();
		
		///Joseph 05/04/07 SHOW_ERR_MSG_ON_NLSF_INIT
		//rMess.top = rMess.bottom - NUM_HEIGHT_OF_ONE_LINE_MESSSAGE;
		rMess.top = rMess.bottom - nHeight;
		///End SHOW_ERR_MSG_ON_NLSF_INIT
		
		rMess.left = rTopPane.left;
		rMess.right = rTopPane.right;	
		rTopPane.bottom = rMess.top - GetControlGap();
		ctrl.Visible = true;
	}
	else
	{
		rTopPane.bottom = rButton.top - GetControlGap();
		ctrl.Visible = false;
	}
	
	RECT rGridParas, rNLF;
	Control ctrlParaGrid = GetItem(IDC_NLF_PARACONTROL_GRID);
	GetClientRect(ctrlParaGrid, rGridParas);
	Control	ctrlBox = GetItem(IDC_NLF_BOX);
	GetClientRect(ctrlBox, rNLF);
	rGridParas.bottom = rTopPane.bottom;
	rNLF.bottom = rTopPane.bottom;
	MoveControl(m_TopTab, rTopPane);
	m_TopTab.AdjustRect(FALSE, &rTopPane);
	MoveControl(ctrl, rMess);
	MoveControl(ctrlParaGrid, rGridParas);
	MoveControl(ctrlBox, rNLF);
	return true;
}
///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/*
BOOL	NLFitDlg::OnButtonEnable(uint wParam, uint lParam)
{
	///Joseph 04/02/07 ADD_NLSF_ERR_MSG_EVENT
	//all buttons about fit should be enable/disable
	//uint nBtnIds[] = {IDOK, 0};
	///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	//uint nBtnIds[] = {IDOK, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_PARAM_INIT, 0};
	///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON	
	//vector<uint> vBtnIds = {IDOK, IDC_NLF_CHI_SQ, IDC_NLF_PARAM_INIT, IDC_NLF_FIT, IDC_NLF_ONE_LTER, 0};
	//
	//if(m_NLF.IsSepFit())
	//{
		//vector<uint> vecIndex;
		//vBtnIds.Find(vecIndex, IDC_NLF_FIT, IDC_NLF_FIT);
		//vBtnIds.RemoveAt( vecIndex[0],  2 ); //delete IDC_NLF_FIT, IDC_NLF_ONE_LTER, always disable if sep fit
		//vector<uint> vBtnIdSepFit = {IDC_NLF_FIT, IDC_NLF_ONE_LTER, 0};
		//EnableControls(vBtnIdSepFit, false);
	//}
	///end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	///End ADD_NLSF_ERR_MSG_EVENT	
	/////Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS
	////EnableControls(nBtnIds,wParam);
	//bool bButtonEnable = wParam & GETNGEVT_OK_ENABLE;
	/////Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	////EnableControls(nBtnIds,bButtonEnable);
	//EnableControls(vBtnIds, bButtonEnable);
	/////end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	/////End DYNABOX_DLG_NEED_MORE_BTNS
	/*
	vector<uint> vBtnIds = {IDOK, IDC_NLF_CHI_SQ, IDC_NLF_PARAM_INIT, IDC_NLF_SIMPLEX, IDC_NLF_FIT, IDC_NLF_ONE_LTER, 0};
	if(m_NLF.IsSepFit())
	{
		vector<uint> vecIndex;
		if(vBtnIds.Find(vecIndex, IDC_NLF_FIT, IDC_NLF_FIT) > -1 )
			vBtnIds.RemoveAt( vecIndex[0],  2 ); //delete IDC_NLF_FIT, IDC_NLF_ONE_LTER, always disable if sep fit
		if(vBtnIds.Find(vecIndex, IDC_NLF_SIMPLEX, IDC_NLF_SIMPLEX) > -1)
			vBtnIds.RemoveAt( vecIndex[0],  1 ); //delete IDC_NLF_SIMPLEX
		vector<uint> vBtnIdSepFit = {IDC_NLF_SIMPLEX, IDC_NLF_FIT, IDC_NLF_ONE_LTER, 0};
		EnableControls(vBtnIdSepFit, false);
	}
	else
	{
		if(m_NLF.IsFitConverged())
		{
			vector<uint> vecIndex;
			if(vBtnIds.Find(vecIndex, IDC_NLF_FIT, IDC_NLF_FIT) > -1 )
				vBtnIds.RemoveAt( vecIndex[0],  2 ); //delete IDC_NLF_FIT, IDC_NLF_ONE_LTER, always disable if converged
			vector<uint> vBtnIdSepFit = {IDC_NLF_FIT, IDC_NLF_ONE_LTER, 0};
			EnableControls(vBtnIdSepFit, false);
		}
	}
	
	bool bButtonEnable = wParam & GETNGEVT_OK_ENABLE;
	EnableControls(vBtnIds, bButtonEnable);
	*/
	/*
	
	updateShowButtons();
	
	updateFitButtonText(m_NLF.IsFitConverged());
	///end IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
	return true;
}
*/
///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/*
/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
BOOL	NLFitDlg::OnNumReplicaChange(uint wParam, uint lParam)
{
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	int nSelTab = m_TopTab.GetCurSel();
	///Arvin 03/26/08 RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
	//return updateStaticNumReplica(nSelTab);
	return updateStaticNumReplica(nSelTab, wParam&WPARAM_REPLICA_ACTIVE_MSG_TAB);
	///end RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
	//return updateStaticNumReplica();
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
}
*/
///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION

///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
//bool    NLFitDlg::updateStaticNumReplica()
///Arvin 03/26/08 RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
//bool    NLFitDlg::updateStaticNumReplica(int nSelTab)
bool    NLFitDlg::updateStaticNumReplica(int nSelTab, bool bShowMsgTab)
///end RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
{
	///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
	//TreeNode 	trNumReplica = m_NLF.GetAdvancedTreeNode().Fit.Replica.Number;
	/// Hong 05/26/08 v8.0870 CENTRALIZE_CODE
	//TreeNode 	trNumReplica = m_NLF.GetAdvancedTreeNode().Replica.Number;
	TreeNode 	trNumReplica = m_NLF.GetReplicaNode().Number;
	/// end CENTRALIZE_CODE
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	if(!trNumReplica)
		return false;
	
	/// Hong 01/17/08 v8.0787b MORE_TIPS_OF_AUTO_INIT_STATUS_IN_PARAMS_TAB
	/*
	if(0 == trNumReplica.nVal)
	{
		m_staticNumReplica.Visible = false;
	}
	else
	{
		///Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
	*/	/*
		///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
		//m_staticNumReplica.Visible = true;
		m_staticNumReplica.Visible = nSelTab > NLF_CODE_TAB? true : false;
		///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
		*/
	/*	m_staticNumReplica.Visible = nSelTab > NLF_CODE_TAB && IsTopPaneShown()? true : false;
		///End FIX_BUG_ON_NLF_DLG_RESIZE
		string 	strText = m_staticNumReplica.Text;
		strText.Format("Number of Replica is %d", trNumReplica.nVal);
		m_staticNumReplica.Text = strText;
	}
	*/
	///Sophy 10/8/2008 QA80-12343 SWITCH_SHOW_HINTS_AND_CHECKBOX
	//m_staticNumReplica.Visible = nSelTab > NLF_CODE_TAB && IsTopPaneShown()? true : false;
	m_staticNumReplica.Visible = nSelTab == NLF_CODE_TAB && IsTopPaneShown()? true : false;
	///end SWITCH_SHOW_HINTS_AND_CHECKBOX

	///-----Kit 12/20/2010 ORG-1756-S1 ADD_HINT_FOR_NLFIT_AND_SURFACE_FITTING_WITH_HOW_MANY_PEAKS_WILL_FITTING
#define GET_PEAKS_NUM_BY_REPLICA_NUM( _ReplicaNum )	((_ReplicaNum) + 1)
	updateFindPeakHint( GET_PEAKS_NUM_BY_REPLICA_NUM( trNumReplica.nVal ) );
	///-----End ADD_HINT_FOR_NLFIT_AND_SURFACE_FITTING_WITH_HOW_MANY_PEAKS_WILL_FITTING
	string strTips, strAutoInitTip, strReplicaTip;
	if ( trNumReplica.nVal > 0 )
	{
		strReplicaTip.Format(_L("Number of Replica is %d"), trNumReplica.nVal);
	}
	strAutoInitTip.Format(_L("Automatic Parameter Initialization is %s"), m_checkEnableAutoParamsInit.Check ? _L("enabled") : _L("disabled"));
	strTips.Format("%s. %s", strAutoInitTip, strReplicaTip);
	m_staticNumReplica.Text = strTips;
	/// end MORE_TIPS_OF_AUTO_INIT_STATUS_IN_PARAMS_TAB
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//arrangeParamsBoundControls();
	if(m_staticNumReplica.Visible)
	///Joseph 06/19/07 FIX_BUG_NLSF_DLG_REISZE
	//fix bug on replica num = 2, the params gird resize error(the grid move to the top) on Param Tab.
	//arrangeParamsBoundControls(NULL, nSelTab == NLF_PARAMETERS_TAB? true : false);
	{
		RECT rTab;
		arrangeTabControls(rTab);
		arrangeParamsBoundControls(&rTab);//, nSelTab == NLF_PARAMETERS_TAB? true : false);	///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	}
	///End FIX_BUG_NLSF_DLG_REISZE
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	///Arvin 03/26/08 RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
	if(bShowMsgTab)
	{
		//Arvin 04/03/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
		//nSelTab = bottomTabEnumToSel(NLF_MESSAGES); 
		//m_BottomTab.SetCurSel(nSelTab);
		////I don't know why I should call this method,
		////but if I don't call it, the message tab can not show correctly.
		//UpdateBottomPaneSubControls();
		showMsgTab();
		///end AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	}
	///end RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
	return true;
}
///end ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX

///-----Kit 12/20/2010 ORG-1756-S1 ADD_HINT_FOR_NLFIT_AND_SURFACE_FITTING_WITH_HOW_MANY_PEAKS_WILL_FITTING
bool	NLFitDlg::updateFindPeakHint( int nPeaks )
{
	TreeNode trFindNumPeaksHint = m_NLF.GetReplicaNode().NumPeaksHint;
	if( !trFindNumPeaksHint.IsValid() )
		return false;

	string strFindPeaksHint;
	strFindPeaksHint.Format( _L( "Fitting %d Peaks" ), nPeaks );

	trFindNumPeaksHint.strVal = strFindPeaksHint;

	return true;
}
///-----End ADD_HINT_FOR_NLFIT_AND_SURFACE_FITTING_WITH_HOW_MANY_PEAKS_WILL_FITTING

BOOL	NLFitDlg::OnClickSaveFDF(Control ctrl)
{
	//Move the function body to private function "saveFDFFile"(not have the argument "Control")
	//we can reuse the private function in this class
	
	///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	/*
	///Cheney 2007-5-25 DO_SAVE_FDF
	//MessageBox(GetSafeHwnd(), _L("SavetoFDF is still not finished in Beta2."), STR_DLG_NAME, MB_OK|MB_OKCANCEL);///Joseph 01/18/07 NOT_FINISHED_SAVE_TO_FDF
	if(!m_nFDFValueChange)
		return true;
	
	if(	m_NLF.GetNumDataset() > 1)
	{
		string strWarn;
		if( ocu_load_err_msg_str(CWARN_ONLY_FIRST_DATASET_SAVE_FDF, &strWarn) )
			MessageBox(GetSafeHwnd(), strWarn, STR_DLG_NAME, MB_OK);
	}
	
	Tree 	trParams;
	trParams = m_GridParas.GetParamTree();	
	m_NLF.UpdateFitSessionParams(trParams);
	m_NLF.UpdateFDFSetting();
	
	string strDlgTitle = Text;
	strDlgTitle.TrimRight("*");
	Text = strDlgTitle;
	
	m_nFDFValueChange = false;
	///end DO_SAVE_FDF
	return true;
	*/
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	//if(m_NLF.GetNumDataset() > 1 && (m_nFDFValueChange & NLF_BOUNDS_CHANGED))
	if(	m_NLF.GetNumDataset() > 1 && (m_nFDFValueChange & NLF_PARAMTERS_BOUNDS_SETTING_CHANGED))
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	{
		string strWarn;
		if( ocu_load_err_msg_str(CWARN_ONLY_FIRST_DATASET_SAVE_FDF, &strWarn) )
			MessageBox(GetSafeHwnd(), strWarn, _L("Attention!"), MB_OK);
	}
	
	return saveFDFFile();
}
///End	ADD__BITMAP_BUTTON

///Kyle 10/21/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
BOOL NLFitDlg::OnQuickSetParam(Control ctrl)
{
	///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
	////------ Folger 10/24/08 v8.0960 CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE
	////return m_GridParas.OnQuickSetParam(ctrl);
	//int		nUpdateParts = m_pGridParas->OnQuickSetParam(ctrl);
	//
	//if ( nUpdateParts > 0 )
		//updateOnParameterChange(nUpdateParts);
	//
	//return TRUE;
	////------ End CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE
	return m_pGridParas->OnQuickSetParam(ctrl);
	///End QUICK_SET_PARAMETERS_VALUE_CHANGE
}
///End QUICK_SET_ONE_PARAM_VALUE_TO_ALL

///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
BOOL	NLFitDlg::OnQuickSetParameterChange(DWORD wParam, DWORD lParam)
{
	int nUpdateParts = wParam;
	//if(nUpdateParts>0)		///------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
		updateOnParameterChange( nUpdateParts );
	return true;
}
///End QUICK_SET_PARAMETERS_VALUE_CHANGE

/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
BOOL	NLFitDlg::OnResetParamBounds(DWORD wParam, DWORD lParam)
{	
	return m_NLF.ResetParamBounds(wParam);	 
}
/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU

//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
BOOL	NLFitDlg::OnSortPeaks(Control ctrl)
{
	int		nUpdateParts = m_pGridParas->OnSortPeaks();
	
	if ( nUpdateParts > 0 )
	{
		//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
		//updateOnParameterChange(nUpdateParts, FITPREVIEW_UPDATE | FITPREVIEW_REPLOT);
		updateParts(nUpdateParts);
		//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
		enablePeakReorderingButton(true);
	}
	
	return TRUE;
}
//------ End v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA

//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
BOOL	NLFitDlg::OnReorderPeaks(Control ctrl)
{
	///Sophy 11/7/2008 QA80-12510 ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
	//int		nUpdateParts = m_pGridParas->OnReorderPeaks();
	vector<uint> vnIndices;
	int nUpdateParts = m_pGridParas->OnReorderPeaks( &vnIndices );
	m_NLF.UpdatePeaksCenter( vnIndices );
	///end ADD_LABEL_OBJECT_FOR_NLFIT_REPLICA_PEAK_ON_NLFIT_PREVIEW_GRAPH
	
	if ( nUpdateParts > 0 )
	{
		//updateOnParameterChange(nUpdateParts, FITPREVIEW_UPDATE | FITPREVIEW_REPLOT);		///------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
		enablePeakReorderingButton(false);
	}
	updateOnParameterChange(nUpdateParts, FITPREVIEW_UPDATE | FITPREVIEW_REPLOT);			///------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
	
	return TRUE;
}
//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

/// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
BOOL NLFitDlg::OnClickParamHide(Control ctrl)
{
	string strNodePre = "P";
	vector<string> vsParams;
	m_NLF.GetParamNamesInFunction(vsParams);
	
	// if size is different, may be function is change...so need to reset all items in m_vnParamsHide to 0
	if( m_vnParamsHide.GetSize() != vsParams.GetSize() )
	{
		m_vnParamsHide.SetSize(vsParams.GetSize());
		m_vnParamsHide = 0;
	}
	
	GETN_TREE(trParamHide)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	trParamHide.SetAttribute(STR_HELPID_ATTRIB, IDD_NLSF_HIDE_PARAM);		///------ Folger 04/20/09 F1_HELP_MAPPING_ON_HIDE_PARAM_DIALOG_IN_NLFIT_AND_PA
	GETN_STR(Hint, "", STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION) GETN_INFO //------ Iris 2/05/2009 FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY
	for(int nn = 0;  nn < vsParams.GetSize(); nn++)
	{
		string strTagName = strNodePre + (nn+1);
		TreeNode trN = trParamHide.AddNode(strTagName, TRGP_CHECK);
		///Kyle 09/10/08
		//trN.nVal = !m_vnParamsHide[nn];
		trN.nVal = m_vnParamsHide[nn];
		///End
		trN.SetAttribute(STR_LABEL_ATTRIB, vsParams[nn]);
	}
	//------ Iris 2/05/2009 FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY
	//if( GetNBox(trParamHide, STR_HIDE_PARAMETERS_DIALOG_TITLE, STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION, NULL, NULL, GetSafeHwnd()) )
	if( GetNBox(trParamHide, STR_HIDE_PARAMETERS_DIALOG_TITLE, NULL, NULL, NULL, GetSafeHwnd()) )
	//------
	{
		int index = 0;
		TreeNodeCollection trNs(trParamHide, strNodePre);
		foreach(TreeNode trN in trNs)
		{
			///Kyle 09/10/08
			//m_vnParamsHide[index] = !trN.nVal;
			m_vnParamsHide[index] = trN.nVal;
			///End
			index++;
		}
		return customParamRowsShow();
	}
	return true;
}

bool	NLFitDlg::customParamRowsShow(bool bUpdateGird)
{
	vector<int> vnAllParamsHides;
	vnAllParamsHides = m_vnParamsHide;
	
	int 	nNumDataset = m_NLF.GetNumDataset();
	if( nNumDataset > 1) //multiple datasets
	{
		for(int nData = 1; nData < nNumDataset; nData++)
		{
			vnAllParamsHides.Append(m_vnParamsHide);
		}
	}
	
	int nNumReplica = 0;	
	///Arvin 03/25/08 MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH as CP said
	//TreeNode 	trNumReplica = m_NLF.GetAdvancedTreeNode().Fit.Replica.Number;
	/// Hong 05/26/08 v8.0870 CENTRALIZE_CODE
	//TreeNode 	trNumReplica = m_NLF.GetAdvancedTreeNode().Replica.Number;
	TreeNode 	trNumReplica = m_NLF.GetReplicaNode().Number;
	/// end CENTRALIZE_CODE
	///end MOVE_REPLICA_BARANCH_OUT_OF_FIT_CONTROL_BRANCH
	if(trNumReplica)
		nNumReplica = trNumReplica.nVal;
	int nReplicaOffset = m_NLF.GetReplicaOffsetFromFDF();
	int nReplicaUnit = m_NLF.GetReplicaUnitFromFDF();
	
	// replica
	if(nNumReplica > 0)
	{
		vector<int> vnSub;
		int nBegin = nReplicaOffset-1; // offset is 1
		int nEnd = nBegin + nReplicaUnit - 1;
		m_vnParamsHide.GetSubVector(vnSub, nBegin, nEnd);
		for(int nn = 0; nn < nNumReplica; nn++)
			vnAllParamsHides.Append(vnSub);
	}			
	///Kyle 09/10/08 CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW
	//m_GridParas.SetParamRowsShow(vnAllParamsHides);
	//
	//if(bUpdateGird)
		//m_GridParas.HideParamRows();
	//m_vnParamsHide = vnAllParamsHides;
	if(bUpdateGird)
		/// Iris 10/24/2008 QA80-12450 v8.0960b FIX_ONLY_HIDE_ONE_XC_FOR_MULTI_DATAS_OR_REPLICA
		//m_GridParas.HideParamRows(m_vnParamsHide);	
		m_pGridParas->HideParamRows(vnAllParamsHides);
		//end FIX_ONLY_HIDE_ONE_XC_FOR_MULTI_DATAS_OR_REPLICA
	///End CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW
	
	return true;
	
}
///end ADD_DLG_TO_HIDE_SHOW_PARAM

///Joseph 06/22/07 v8.0647 ADD_NLF_SIMPLEX_BUTTON
BOOL NLFitDlg::OnClickSimplex(Control ctrl)
{
	PROFILE_HRGLASS
	int nSelTab=m_TopTab.GetCurSel();
	///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//m_NLF.Fit(-1, FITMETH_SIMPLEX);
	m_NLF.Fit(-1, FITMETH_SIMPLEX, GetCurrentFittingData());
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	m_NLF.ResetFitOutCome(); 
	updateOneLineMessageBox();
	/// Hong 09/11/08 v8.0937 FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE
	//updateDisplay(nSelTab == NLF_PARAMETERS_TAB, true);
	updateDisplayOnParamsChange();
	/// end FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE
	m_NLF.InvokeGlobalEventOnClickCustomButton1();
	
	return TRUE;
}
///End ADD_NLF_SIMPLEX_BUTTON

///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
BOOL	NLFitDlg::OnDataComboChange(Control ctrl)
{
	updateParts(NLDLGPART_FIT_CONTROL_BTNS | NLDLGPART_PARAMETERS_DISPLAY);
	return TRUE;
}
///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT

//--- CPY 11/1/04 PARAM_INIT_BUTTON_CODE_CLEAN_UP
/// Hong 03/20/08 QA80-11286 FIX_ACTIVE_CODE_TAB_FAIL_UPDATE_SWITCH_THEME
//void NLFitDlg::updateDisplay(bool bParamsGrid, bool bFitButtons, bool bNumParamsChanged)// = true, = true, = false
/// Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
//void NLFitDlg::updateDisplay(bool bParamsGrid, bool bFitButtons, bool bNumParamsChanged, bool bUpdateCodeTab)// = true, = true, = false, false
void NLFitDlg::updateDisplay(bool bParamsGrid/* = true*/, bool bFitButtons/* = true*/, bool bNumParamsChanged/* = false*/, bool bUpdateCodeTab/* = false*/, bool bForceShowResult/* = false*/
							 ///------ Folger 08/08/2011 ORG-2740-P6 PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
							 , BOOL bClearGrid/* = TRUE*/
							 ///------ End PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
							 )
/// end ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
/// end FIX_ACTIVE_CODE_TAB_FAIL_UPDATE_SWITCH_THEME
{
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	if(bParamsGrid)
	{
		/// Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
		//m_GridParas.Update(m_NLF.GetNumParameter());
		/// Hong 06/27/08 v8.0892 CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER
		//int 	nNumDataset = bNumParamsChanged? m_NLF.GetNumDataset() : -1; //if the number of params changed, need to reconstruct param grid
		//m_GridParas.Update(m_NLF.GetNumParameter(), nNumDataset);
		///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
		//m_GridParas.Update();
		///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		//m_pGridParas->Update(m_NLF.IsAllowSharing());
		///------ Folger 08/08/2011 ORG-2740-P6 PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
		//m_pGridParas->Update(m_NLF.IsAllowSharing(), true, GetCurrentFittingData());
		m_pGridParas->Update(m_NLF.IsAllowSharing(), bClearGrid, GetCurrentFittingData());
		///------ End PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		///End USE_ISALLOWSHARING_IN_NLFSESSION
		/// end CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER
		///end ADD_PARAMETER_SETTING_TO_THEME		
 		/// Hong 11/28/07 QA80-10499 FIX_SHARE_COLUMN_FAIL_CORRECT_HIDE_SHOW_BY_SWITCH_THMEM
 		/// Hong 03/20/08 v8.0828 CENTRALIZED_CODE
		//m_GridParas.ChangShowCol(COL_SHOW_NORMAL);
		//---Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
		//int nShowType = (NLF_PARABOUND_TAB ==  m_TopTab.GetCurSel()) ? GROUP_BOUNDS : GROUP_NORMAL;		
		//m_GridParas.SetShowCols(nShowType);//----- CPY 5/11/08 replace ChangeShowCol to SetShowCols
		m_paramTabs.ShowTabCols();
		//---end
		/// end CENTRALIZED_CODE
		/// end FIX_SHARE_COLUMN_FAIL_CORRECT_HIDE_SHOW_BY_SWITCH_THMEM
		customParamRowsShow(); /// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
		
		///-----Kit 12/29/2010 ORG-1532-P7 AUTO_PARAMETER_CHECK_BOX_CAN_NOT_SHOW
		if( m_NLF.IsOpenFromMultiPeakFit() )
			m_checkEnableAutoParamsInit.Visible = true;
		///-----
	}
#endif

	if(bFitButtons)
		///Sophy 11/26/2008 v8.980 SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
		//updateShowButtons(true);
		/// Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
		//updateShowButtons(true, NULL, false); //param needn't update OK button
		updateShowButtons(bForceShowResult, NULL, false); //param needn't update OK button
		/// end ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
		///end SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
	
	/// Hong 03/20/08 QA80-11286 FIX_ACTIVE_CODE_TAB_FAIL_UPDATE_SWITCH_THEME
	if ( bUpdateCodeTab )
		m_NLF.ShowCodeEdit();
	/// end FIX_ACTIVE_CODE_TAB_FAIL_UPDATE_SWITCH_THEME
}
//---

BOOL 	NLFitDlg::OnFunctionChange(uint wParam, uint lParam) // Hong, to do, function name need refactor, check whether be called by NLSPLITTERPART_FIT_FUNC_CHANGE instead of NLSPLITTERPART_PARAM
{
	//if(!isFunctionTreeInvalid())	///DG ACCESS_FUNCTION_BY_NFO
	if(!m_NLF.IsFunctionTreeValid())
	{
		//m_bIsFirstTime = false;
		return error_report("OnFunctionChange was called but Function Tree not valid");
	}
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	//---- CPY 1/6/04 v8.0183 NLFIT_NOT_WORKING_NEED_CLEAN_UP
	//m_GridParas.LinkFunctionTreeToFitFunction(m_NLF.GetParameterTree(), m_NLF.IsMixedFunction());		///Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE
	//----
	
	/// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
	vector<string> vsParams;
	int nNumParams = m_NLF.GetParamNamesInFunction(vsParams);
	m_vnParamsHide.SetSize(nNumParams);	
	m_vnParamsHide = 0;
	/// Iris 3/20/2008 v8.0828 FIX_APPLY_THEME_PARAM_SHOW_STATE_NOT_RESET
	// If theme changed, will not call NLFitParamsControl::Update(...) since not change top tab
	//customParamRowsShow(false);	//false: not update parameter grid since will call NLFitParamsControl::Update(...) later to reconstruct this grid
	customParamRowsShow(true);
	///end FIX_APPLY_THEME_PARAM_SHOW_STATE_NOT_RESET
	///end ADD_DLG_TO_HIDE_SHOW_PARAM
#endif
	updateDialogTitle();
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	// No need anymore, as this is already done by NLSPLITTERPART_FIT_FUNC_CHANGE
	//if(IsBottomPaneShown())// && !m_bIsFirstTime )
	//{
	//	updateBottomTabDisplay();
	//}
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//m_bIsFirstTime = false;
	return true;
}
void NLFitDlg::updateDialogTitle()
{
	m_wndDlg.Text = m_NLF.GetDialogTitle();
}

void 	NLFitDlg::OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
{
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	int nRet = m_pGridParas->OnAfterEdit(flxControl, nRow, nCol);
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	/////Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
	//m_NLF.ResetFitOutCome(); 
	////updateOneLineMessageBox();
	////updateFitButtonText(m_NLF.IsFitConverged());
	///////end IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
	//m_NLF.NotifyParamChange();
	//GetWindow().PostMessage(WM_NLFITDLG_UPDATE, nRet);
	
	//------ Folger 10/24/08 v8.0960 CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE
	//bool		bUpdatePreivew = nRet & NLDLGPART_FITCURVE_DATA ? true : false;
	//m_NLF.NotifyParamChange(bUpdatePreivew);
	//updateParts(nRet);	
	///// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	//onThemeValueChange(); /// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	///------ Folger 06/07/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//updateOnParameterChange(nRet);
	updateOnParameterChange(nRet, FITPREVIEW_UPDATE, nRow - m_pGridParas->GetRowOffset());
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//------ End CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE
	
#endif
}

void 	NLFitDlg::OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	///Sophy 12/4/2008 v8.0982b NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	int nColType = m_pGridParas->GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

	if( NLPARAMGRIDCOLTYPE_FUNC_NAME == nColType && NULL != pCancel )
		*pCancel = true;
	///end NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
	m_pGridParas->OnBeforeEditParaControl(flxControl, nRow, nCol,pCancel );
#endif
}

void 	NLFitDlg::OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	///Sophy 11/12/2008 SUPPORT_CONTEXT_MENU_COMMAND_TO_UPDATE_PARAM_GRID_CONTROL
	//m_pGridParas->OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
	if( m_pGridParas->IsMouseOnHeader() )
		m_pGridParas->OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
	///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//else if( nButton == MK_RBUTTON )
	//{		
		//int nRow, nCol, nX, nY;
		//m_pGridParas->GetMousePixel( X, Y, nRow, nCol, nX, nY );
		//
		//vector<string>	vsItem;
		//vector<byte>  	vbShow;
		//vector<bool>	vbDisable;
		///// Hong 01/23/09 REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
		///*
		//vsItem.Add( _L("Delay Parameter Initialization") ); // Hong, better label suggested by max
		//vbShow.Add( m_checkEnableAutoUpdate.Check );
		//vbDisable.Add(false);			
		//*/
		///// end REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
		///// Hong 12/10/08 v8.0984d ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
		///// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
		///*
		//if ( NLPARAMGRIDCOLTYPE_SD == nCol )
		//{
			//vsItem.Add( _L("Apply Digits Setting to All") );
			//vbShow.Add(false);
			//vbDisable.Add(false);
		//}
		//*/
		//vector<int>		vnChoiceContextMenu;
		///// Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
		////m_pGridParas->GetItemContextMenu(nRow, nCol, vsItem, vbShow, vbDisable, vnChoiceContextMenu);
		//DWORD			dwCntrl = 0;
		/////------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		////if ( m_NLF.GetNumDataset() < 2 && !m_NLF.IsReplicaFit() )
			////dwCntrl |= CM_CNTRL_NO_APPLT_TO_ALL;
		//if ( m_NLF.GetNumDataset() < 2 )
		//{
			//if ( !m_NLF.IsReplicaFit() )
				//O_ADD_BIT(dwCntrl, CM_CNTRL_NO_APPLT_TO_ALL);
		//}
		//else
		//{
			//O_ADD_BIT(dwCntrl, CM_CNTRL_MULTI_SETS);
		//}
		/////------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		//m_pGridParas->GetItemContextMenu(nRow, nCol, vsItem, vbShow, vbDisable, vnChoiceContextMenu, dwCntrl);
		///// end NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
		///// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
		///// end ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS				
		///// Hong 01/23/09 REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
		///*
		///// Hong 01/22/09 ADD_SEPARATOR_AFTER_UPDATE_ASKED_MAX
		//if ( vnChoiceContextMenu.GetSize() )
		//{
			//int			nIndex = vsItem.GetSize() - vnChoiceContextMenu.GetSize();
			//vsItem.InsertAt(nIndex, "");
			//vbShow.InsertAt(nIndex, false);
			//vbDisable.InsertAt(nIndex, false);
		//}
		///// end ADD_SEPARATOR_AFTER_UPDATE_ASKED_MAX
		//*/
		//if ( 0 == vsItem.GetSize() )
			//return ;
		///// end REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
		//CheckMenu 	MyMenu( vbShow, vsItem, vbDisable );				
		//int nChoice = MyMenu.DoTrackPopup( nX, nY, m_pGridParas->GetDlgSafeHwnd() );
		//if( nChoice >= 0 )
		//{
			///// Hong 01/23/09 REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
			///*
			///// Hong 12/10/08 v8.0984d ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
			//if ( 0 == nChoice )
			//{
			///// end ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
				//m_checkEnableAutoUpdate.Check = m_checkEnableAutoUpdate.Check ? 0 : 1;
				//OnClickAutoUpdate( m_checkEnableAutoUpdate );
			///// Hong 12/10/08 v8.0984d ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
			//}
			//*/
			///// end REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
			///// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
			///*
			//else if ( NLPARAMGRIDCOLTYPE_SD == nCol && 1 == nChoice )
			//{
				//m_pGridParas->ApplyToAll(nRow, nCol);
				//OnAfterEditParaControl(cntrl, nRow, nCol);
			//}
			//*/
			///// Hong 01/23/09 REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
			////else if ( vnChoiceContextMenu.GetSize() > 0 )
			//if ( vnChoiceContextMenu.GetSize() > 0 )
			///// end REMOVE_UPDATE_FROM_CONTEXT_MENU_AS_NOT_FIT_DESIGN_OF_CP_FOR_SR5
			//{
				//int				nChoiceContextMenu = nChoice - (vsItem.GetSize() - vnChoiceContextMenu.GetSize());
				//if ( nChoiceContextMenu >= 0 )
				//{
					//ASSERT( vnChoiceContextMenu.GetSize() > nChoiceContextMenu );
					/////------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
					////m_pGridParas->OnItemContextMenu(nRow, nCol, vnChoiceContextMenu[nChoiceContextMenu]);
					/////------ Folger 05/05/2011 ORG-2773-P1 CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
					////updateOnParameterChange(m_pGridParas->OnItemContextMenu(nRow, nCol, vnChoiceContextMenu[nChoiceContextMenu]));
					//OnContextMenuMore	stMore = { 0 };
					//stMore.bAllowShared = m_NLF.IsAllowSharing();
					/////------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
					//stMore.nDatasetEdited = m_NLF.DatasetEdited(nRow - m_pGridParas->GetRowOffset());
					/////------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
					/////------ Folger 08/25/2011 ORG-2740-P7 ON_PARAM_COLUMN_CONTEXT_MENU_SHOULD_NOT_CHANGE_CURRECT_ACTIVE_DATASET
					//stMore.nActiveDataset = GetCurrentFittingData();
					/////------ End ON_PARAM_COLUMN_CONTEXT_MENU_SHOULD_NOT_CHANGE_CURRECT_ACTIVE_DATASET
					//updateOnParameterChange(m_pGridParas->OnItemContextMenu(nRow, nCol, vnChoiceContextMenu[nChoiceContextMenu], &stMore));
					/////------ End CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
					/////------ End CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
				//}
			//}				
			///// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
			///// end ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
		//}
	//}
	/////end SUPPORT_CONTEXT_MENU_COMMAND_TO_UPDATE_PARAM_GRID_CONTROL
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	
#endif
}
void 	NLFitDlg::OnMouseMoveParaControl(Control cntrl, short nButton, short nShift, float X, float Y)
{
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	//m_GridParas.OnMouseMove(cntrl, nButton, nShift, X, Y);
	m_pGridParas->OnMouseMove(cntrl, nButton, nShift, X, Y);		///Kyle 01/23/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL
#endif
}

//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
/*
void	NLFitDlg::OnGridButtonClick(Control flxControl, int nRow, int nCol )
{
	m_pGridParas->OnButtonClick( flxControl, nRow, nCol );
	///Sophy 10/20/2008 NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON
	if( NLPARAMGRIDCOLTYPE_LB_CONTROL == nCol || NLPARAMGRIDCOLTYPE_UB_CONTROL == nCol )
		OnAfterEditParaControl( flxControl, nRow, nCol );
	///end NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON
}
*/
void 	NLFitDlg::OnGridDBClick(Control flxControl)
{
	int nRow = 0, nCol = 0;
	int nx = -1, ny = -1;
	m_pGridParas->GetSelCell(nx, ny, nRow, nCol);

	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	int nColType = m_pGridParas->GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

	if( NLPARAMGRIDCOLTYPE_LB_CONTROL == nColType || NLPARAMGRIDCOLTYPE_UB_CONTROL == nColType )
	{
		m_pGridParas->OnButtonClick( flxControl, nRow, nCol );
		OnAfterEditParaControl( flxControl, nRow, nCol )
	}
}
//------ End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL

//---- CPY 4/28/06 NLFT_MOVED_TO_USE_DYNA_CNTRL
/*

/// YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
BOOL	NLFitDlg::OnSelectionChange()
{
	return m_NLF.OnSelectionChange();
}

BOOL	NLFitDlg::OnSelectionTrack()
{
	return m_NLF.OnSelectionTrack();
}
/// end NLFITTER_OPERATION_IMPLEMENTATION
*/
//---- end NLFT_MOVED_TO_USE_DYNA_CNTRL

///Jasmine 03/09/06 ADD_EVENT_COMBO_CLOSE_UP
void NLFitDlg::OnGridComboCloseUp(Control ctrl, int nRow, int nCol, BOOL* pFinishEdit)
{
	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	int nColType = m_pGridParas->GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

	switch(nColType)
	{
	case NLPARAMGRIDCOLTYPE_FUNC_NAME://GRID_COL_PEAK_TYPE:
	case NLPARAMGRIDCOLTYPE_SD:
		*pFinishEdit = true;
		return;		
	}
}
///End ADD_EVENT_COMBO_CLOSE_UP

/// Iris 8/08/06 IMPROVE_RESIDUAL_PREVIEW
void	NLFitDlg::OnClickUpdateResidual(uint wParam, uint lParam)
{
	if( !m_NLF.UpdateResidualContourLevels() )
		error_report("OnClickUpdateResidual fail to work!");
}
///end IMPROVE_RESIDUAL_PREVIEW

void	NLFitDlg::updateTopTabDisplay()
{
	if(!updateTopPaneControlShow())
	{
		return;	//not shown top pane
	}
	
	int 	nSelTab=moveShownControlToTopTab();
	
	///Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
	//Control 	ctrlCodeEdit = GetItem(IDC_RICHEDIT1);
	//ctrlCodeEdit.Visible = false;
	///End FIX_BUG_ON_NLF_DLG_RESIZE
	
	switch(nSelTab)
	{
	case NLF_SETTING_TAB:
		m_NLF.ShowSettings();
		break;
	case NLF_CODE_TAB:
		/// Hong 03/20/08 QA80-11286 FIX_ACTIVE_CODE_TAB_FAIL_UPDATE_SWITCH_THEME
		//m_NLF.ShowCodeEdit();
		updateDisplay(false, false, false, true);
		/// end FIX_ACTIVE_CODE_TAB_FAIL_UPDATE_SWITCH_THEME
		///Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
		//ctrlCodeEdit.Visible = true; 
		///End FIX_BUG_ON_NLF_DLG_RESIZE
		break;
	///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	/*
	case NLF_PARAMETERS_TAB:
		//setTabParameterControl();
	case NLF_PARABOUND_TAB:
		/// Hong 03/20/08 v8.0828 CENTRALIZED_CODE
		//setTabParameterControl(nSelTab);
		updateDisplay(true, false, true);
		/// end CENTRALIZED_CODE
	
		string strSection = NLF_PARAMETERS_TAB == nSelTab? _L("Parameters"):_L("Bounds");/// AW 10/26/07 WRONG_LOCALIZE_MACRO
		OnUpdateHints((DWORD)(const void*)(LPCSTR)strSection);
		break;
	*/
	default:
		if( !m_paramTabs.IsParamTab(nSelTab) )
		{
			ASSERT(0);
			break;
		}
		updateDisplay(true, false, true);
		OnUpdateHints( (ODWP)(const void*)(LPCSTR)(_LE("Parameters")) );
		break;
	///End CUSTOMIZATION_PARAMETER_TAB
	}
	///end
}

///------ Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
BOOL	NLFitDlg::OnActiveBottomTab(uint wParam, uint lParam)
{
	setBottomPaneActiveTab(wParam);
	return TRUE;
}
///------ End ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS

/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
void	NLFitDlg::setBottomPaneActiveTab(int nTabToShow/* = -1*/)
{
	if ( nTabToShow != -1 )
		m_BottomTab.SetCurSel(nTabToShow);

	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	//updateBottomPaneSubControlsShowStatus();
	updateOneLineMessageSize();
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
	updateBottomTabDisplay();
}

/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
/*
void	NLFitDlg::updateBottomPaneSubControlsShowStatus()
{
	updateOneLineMessageSize();	
	
	int		nCurSelTab = m_BottomTab.GetCurSel();
	bool	bShowCurvePreviewBox = false, bShowResidualPreviewBox = false, bShowFuncPreviewBox = false, bShowSampleCurveBox = false, bShowMessageBox = false, bShowFuncFile = false, bShowOpHit = false;
	switch ( bottomTabSelToEnum(nCurSelTab) )
	{
	case NLF_FIT_CURVE_PREVIEW_TAB:
		bShowCurvePreviewBox = true;
		break;
	case NLF_RESIDUAL_PREVIEW_TAB:
		bShowResidualPreviewBox = true;
		break;
	case NLF_FORMULA_TAB:
		bShowFuncPreviewBox = true;
		break;
	case NLF_SAMPLE_CURVE_TAB:
		bShowSampleCurveBox = true;
		break;
	case NLF_MESSAGES:
		bShowMessageBox = true;
		break;
	case NLF_FUNCTION_FILE_TAB:
		bShowFuncFile = true;
		break;
	case NLF_OPERATION_HINT_TAB:
		bShowOpHit = true;
		break;
	default:
		ASSERT(FALSE);
		/// Hong 11/06/08 v8.0966c FIX_FIT_STATUS_MSG_NOT_SHOW_IN_MIDDLE_PANEL
		//return ;
		break;
		/// end FIX_FIT_STATUS_MSG_NOT_SHOW_IN_MIDDLE_PANEL
	}
	GetItem(IDC_NLF_FIT_CURVE_PREVIEW_BOX).Visible = bShowCurvePreviewBox;
	GetItem(IDC_NLF_RESIDUAL_PREVIEW_BOX).Visible = bShowResidualPreviewBox;
	m_NFunctionPrev.SetVisible(bShowFuncPreviewBox);
	m_NCurvePrev.SetVisible(bShowSampleCurveBox);
	GetItem(IDC_NLS_OPERATION_LOG).Visible = bShowMessageBox;
	m_reditFunctionFile.Visible = bShowFuncFile;
	m_editHint.Visible = bShowOpHit;	
	m_staticMessage.Visible = isShowOneLineMessage();		
}
/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
*/
///End FIX_NLFITDLG_TAB_FLICKER_ISSUE

void 	NLFitDlg::updateBottomTabDisplay(int nTabToUpdate) // = -1 /// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
{
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	/*
	//--- CPY 10/25/04 ADD_SHOW_MSG_LOG_WHEN_CLICK_FIT
	if(nTabToShow >= 0)
	{
		m_BottomTab.SetCurSel(nTabToShow);
	}
	//---
	/// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB
	int nSelTab = UpdateBottomPaneSubControls();
	/// Hong 03/21/08 v8.0828 GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
	//if( !m_NLF.IsShowFitPreview() )
	//	nSelTab += 1;
	nSelTab = bottomTabSelToEnum(nSelTab);
	/// end GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
	///end ADD_FIT_CURVE_PREVIEW_TAB
	/// Hong 09/13/08 v8.0938 REMOVE_AS_NOT_USED_ANYMORE
	/////Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
	//int nPreviewType = NLF_NO_PREV;
	/////end SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
	/// end REMOVE_AS_NOT_USED_ANYMORE
	switch(nSelTab)
	{
	case NLF_FIT_CURVE_PREVIEW_TAB:
		setTabFitCurvePreview(false);
		/// Hong 09/13/08 v8.0938 REMOVE_AS_NOT_USED_ANYMORE
		//nPreviewType = NLF_PREV_FIT_CURVE;  ///Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
		/// end REMOVE_AS_NOT_USED_ANYMORE
		break;
	case NLF_RESIDUAL_PREVIEW_TAB:
		setTabFitCurvePreview(true);
		/// Hong 09/13/08 v8.0938 REMOVE_AS_NOT_USED_ANYMORE
		//nPreviewType = NLF_PREV_RESIDUAL;  ///Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
		/// end REMOVE_AS_NOT_USED_ANYMORE
		break;
	case NLF_FORMULA_TAB:
		setTabFuncCurvePreview(true);
		break;
	case NLF_SAMPLE_CURVE_TAB:
		setTabFuncCurvePreview(false);
		break;
	case NLF_MESSAGES:
		setTabOperatrLog();
		break;
	///Frank 11/11/04 v8.0162 FUNCTION_FILE_INFO
	case NLF_FUNCTION_FILE_TAB:
		setTabFunctionFileShow();
		break;
	///End FUNCTION_FILE_INFO
	
	///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF

	case NLF_OPERATION_HINT_TAB:
		setTabOperationHintShow();
		break;
	///End ADD_HINT_TAB_TO_NLSF
	
	default:
		out_str("Error, nTab not a valid tab");
		break;
	}
	/// Hong 09/13/08 v8.0938 REMOVE_AS_NOT_USED_ANYMORE
	//m_NLF.SetPrevType(nPreviewType); ///Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
	/// end REMOVE_AS_NOT_USED_ANYMORE
		*/
	if ( !IsBottomPaneShown() )
		return ;
	
	int	nActiveTab = m_BottomTab.GetCurSel();
	if ( nTabToUpdate != -1 && nTabToUpdate != nActiveTab )
		return ;
	
	int	nSelTab = bottomTabSelToEnum(nActiveTab);	
	switch(nSelTab)
	{
	case NLF_FIT_CURVE_PREVIEW_TAB:		
		ASSERT(m_gpFitCurve);
		if ( !m_gpFitCurve )
			return;
		m_gpFitCurve.Refresh(TRUE);		
		break;
	case NLF_RESIDUAL_PREVIEW_TAB:		
		ASSERT(m_gpResidual);
		if ( !m_gpResidual )
			return;
		m_gpResidual.Refresh(TRUE);		
		break;
	case NLF_FORMULA_TAB:
		/// Hong 07/03/09 QA80-13590-P6 HIDE_FORMULA_CTRL_IF_USERDEFINE_FUNC_NO_FORMULA_PREIVEW
		//m_NFunctionPrev.LoadNLSFFunctionPreview(m_NLF.GetFDFTree(), true);
		m_NFunctionPrev.SetVisible(m_NFunctionPrev.LoadNLSFFunctionPreview(m_NLF.GetFDFTree(), true));
		/// end HIDE_FORMULA_CTRL_IF_USERDEFINE_FUNC_NO_FORMULA_PREIVEW
		break;
	case NLF_SAMPLE_CURVE_TAB:
		/// Hong 07/03/09 QA80-13590-P6 HIDE_FORMULA_CTRL_IF_USERDEFINE_FUNC_NO_FORMULA_PREIVEW
		//m_NCurvePrev.LoadNLSFFunctionPreview(m_NLF.GetFDFTree(), false);
		m_NCurvePrev.SetVisible(m_NCurvePrev.LoadNLSFFunctionPreview(m_NLF.GetFDFTree(), false));
		/// end HIDE_FORMULA_CTRL_IF_USERDEFINE_FUNC_NO_FORMULA_PREIVEW
		break;
	case NLF_MESSAGES:
		// Nothing to do, as it's realtime updated
		break;	
	case NLF_FUNCTION_FILE_TAB:		
		m_reditFunctionFile.Reset();
		m_reditFunctionFile.Load(m_NLF.GetFitFuncFile());
		break;
	case NLF_OPERATION_HINT_TAB:
		// No update is necessary
		break;		
	default:
		ASSERT(FALSE);
		out_str("Error, nTab not a valid tab");
		break;
	}	
	/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN		
}


/// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB
//virtual 
/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
/*
int 	NLFitDlg::UpdateBottomPaneSubControls()
{
	int 	nSelTab = m_BottomTab.GetCurSel();
	
	int 	nNumTab = 0;
	m_BottomTab.DeleteAllItems();	
	/// AW 10/26/07 WRONG_LOCALIZE_MACRO
	//m_BottomTab.InsertItem(0, "Hints");	nNumTab++;  ///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
	//m_BottomTab.InsertItem(0, "Residual"); 		nNumTab++;  ///Joe  8/17/06 PUT_RESIDUAL_TAB_TO_END
	//m_BottomTab.InsertItem(0, "Function File");	nNumTab++;
	//m_BottomTab.InsertItem(0, "Messages");		nNumTab++;
	//m_BottomTab.InsertItem(0, "Sample Curve");	nNumTab++;
	//m_BottomTab.InsertItem(0, "Formula");		nNumTab++;
	m_BottomTab.InsertItem(0, _L("Hints"));	nNumTab++;  ///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
	/// Hong 03/20/08 QA80-10969 MOVE_PREVIEW_TAB_RESIDUAL_CLOSE_TO_FIT_CURVE
	//m_BottomTab.InsertItem(0, _L("Residual")); 		nNumTab++;  ///Joe  8/17/06 PUT_RESIDUAL_TAB_TO_END
	/// end MOVE_PREVIEW_TAB_RESIDUAL_CLOSE_TO_FIT_CURVE
	m_BottomTab.InsertItem(0, _L("Function File"));	nNumTab++;
	m_BottomTab.InsertItem(0, _L("Messages"));		nNumTab++;
	m_BottomTab.InsertItem(0, _L("Sample Curve"));	nNumTab++;
	m_BottomTab.InsertItem(0, _L("Formula"));		nNumTab++;
	/// Hong 03/20/08 QA80-10969 MOVE_PREVIEW_TAB_RESIDUAL_CLOSE_TO_FIT_CURVE
	m_BottomTab.InsertItem(0, _L("Residual")); 		nNumTab++;  ///Joe  8/17/06 PUT_RESIDUAL_TAB_TO_END
	/// end MOVE_PREVIEW_TAB_RESIDUAL_CLOSE_TO_FIT_CURVE
	/// END WRONG_LOCALIZE_MACRO
	///Joe  8/17/06 PUT_RESIDUAL_TAB_TO_END
	//m_BottomTab.InsertItem(0, "Residual"); 		nNumTab++;
	///End PUT_RESIDUAL_TAB_TO_END
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	//GetItem(IDC_NLF_FIT_CURVE_PREVIEW_BOX).Visible = m_NLF.IsShowFitPreview();
	/// end 
	if( m_NLF.IsShowFitPreview() )
	{
		//---- CPY 11/3/07 MORE_LOCALIZATION_CLEANUP
		//m_BottomTab.InsertItem(0, "Fit Curve"); nNumTab++;
		m_BottomTab.InsertItem(0, _L("Fit Curve")); nNumTab++;
		//----
	}
	
	if( nSelTab < nNumTab )
		m_BottomTab.SetCurSel(nSelTab);
	
	///Iris 10/11/06 v8.0494b ADD_ONE_LINE_MESSAGE_BAR
	//return MultiPaneDlg::UpdateBottomPaneSubControls();	
	nSelTab = MultiPaneDlg::UpdateBottomPaneSubControls();
	
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	
	//m_staticMessage.Visible = isShowOneLineMessage(nSelTab);
	//updateOneLineMessageSize();
	///// Hong 03/20/08 QA80-10969 REMOVE_PREVIEW_FIT_CURVE_TAB_WHEN_PREVIEW_IN_SRC_GRAPH
	////setMessageLogShow(NLF_MESSAGES == nSelTab? true : false);	
	///// Hong 03/21/08 v8.0828 GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
	////int nHiddenTab = m_NLF.IsShowFitPreview() ? 0 : 1;
	////int nMesTabToShow = NLF_MESSAGES - nHiddenTab;
	////setMessageLogShow(nMesTabToShow == nSelTab? true : false);
	//setMessageLogShow(NLF_MESSAGES == bottomTabSelToEnum(nSelTab) ? true : false);
	///// end GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
	///// end REMOVE_PREVIEW_FIT_CURVE_TAB_WHEN_PREVIEW_IN_SRC_GRAPH
	
	updateBottomPaneSubControlsShowStatus();
	/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	return nSelTab;	
	///end ADD_ONE_LINE_MESSAGE_BAR
}
*/
int 	NLFitDlg::UpdateBottomPaneSubControls()
{	
	int nSelTab;
	if( !m_BottomTab ) // construct the tabs
	{	
		Control ctrlTab = GetItem(IDC_NLF_VIEW_TABS);
		m_BottomTab.CreateControl(ctrlTab.GetSafeHwnd());	
		RECT rrEdit;
		DWORD dwStyles, dwMoreStyle = WS_VSCROLL | WS_HSCROLL | WS_BORDER;
		
		// Function File
		RichEdit ctrlFunctionFile;
		ctrlFunctionFile = (RichEdit)GetItem(IDC_FUNCTION_CODE_SHOW);
		dwStyles = ctrlFunctionFile.GetStyle() | dwMoreStyle;			
		DestroyWindow(ctrlFunctionFile.GetSafeHwnd());		
		m_reditFunctionFile.CreateControl(m_BottomTab.GetSafeHwnd(), &rrEdit, IDC_FUNCTION_CODE_SHOW, dwStyles);	
		m_reditFunctionFile.SetReadOnly(); /// Iris 5/23/2012 ORG3378-P1 FIX_FUNCFILE_MSGLOG_IS_WRITABLE_IN_90
		m_BottomTab.AddTab(m_reditFunctionFile.GetSafeHwnd(), _FUNCTION_FILE_);
		
		// Hits
		Control ctrlHint = GetItem(IDC_NLSF_OPERATION_HINT);		
		dwStyles = ctrlHint.GetStyle() | dwMoreStyle;		
		DWORD dwStylesEx = ctrlHint.GetExStyle();
		DestroyWindow(ctrlHint.GetSafeHwnd());				
		m_editHint.CreateControl(m_BottomTab.GetSafeHwnd(), &rrEdit, IDC_NLSF_OPERATION_HINT, dwStyles);			
		m_editHint.ModifyStyleEx(0, dwStylesEx);
		m_BottomTab.AddTab(m_editHint.GetSafeHwnd(), _HINTS_);
		
		// Message Log, Sample Curve, Formula
		m_OPMsgLog.Init(IDC_NLS_OPERATION_LOG, *this, m_BottomTab, 0, _MESSAGES_, dwMoreStyle);
		m_NCurvePrev.Init(IDC_NLS_CURVE_PREVIEW_BOX, *this, m_BottomTab, 0, _SAMPLE_CURVE_, dwMoreStyle);
		m_NFunctionPrev.Init(IDC_NLF_PREVIEW_BOX, *this, m_BottomTab, 0, _FORMULA_, dwMoreStyle);		
	}
	else
	{	
		bool bIsFitCurveShow = m_BottomTab.IsTabVisible(NLF_FIT_CURVE_PREVIEW_TAB);
		if( m_NLF.IsShowFitPreview() != bIsFitCurveShow )
		{
			m_BottomTab.ShowTab( NLF_FIT_CURVE_PREVIEW_TAB, !bIsFitCurveShow );
		}
		nSelTab = m_BottomTab.GetActiveTab();
	}	
	return nSelTab;	
}
///End FIX_NLFITDLG_TAB_FLICKER_ISSUE

///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
BOOL	NLFitDlg::OpenFitFunctionWizard(bool bCreate) //if bCreate, new fit function, or else edit existing function
{
	if ( m_NLF.OnOpenFitFunctionWizard(bCreate) )
	{
 		m_NLF.UpdateFunctionSelection(FUNC_SEL_FUNC);
 		LT_execute("sec -p 0.03");
 		updateTopTabDisplay();
 		return TRUE;
	}
	return FALSE;
}
///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
///Joseph 12/11/06 ADD_BITMAP_BUTTON
void	NLFitDlg::updateOneLineMessageSize()
{
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	//vector<uint> vnControls;
	//int nSelTab = GetBottomPaneSubControls(vnControls);
	int nSelTab = m_BottomTab.GetActiveTab();
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
	
	RECT rButton;
	///------ Folger 02/11/09 QA80-13098-P1 NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	//GetClientRect(m_btnInit, rButton);
	GetClientRect(m_SelFuncButton, rButton);
	///------ End NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	/*
	if( nSelTab < vnControls.GetSize() )
	{
		Control ctrl = GetItem(vnControls[nSelTab]);
	*/
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
	
		RECT	rDlg, rBottomTab, rMess, rTopTab;
		m_wndDlg.GetClientRect(&rDlg);
		GetClientRect(m_BottomTab, rBottomTab);
		///------ Folger 02/11/09 QA80-13098-P1 NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
		///// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
		////if(isShowOneLineMessage(nSelTab))
		//if ( isShowOneLineMessage() )
		///// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
		//{
			/////Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
			////not enough
			////rMess.top = rButton.bottom + GetControlGap();
			//rMess.top = rButton.bottom + 2 * GetControlGap();
			/////End FIX_BUG_ON_NLF_DLG_RESIZE
			//rMess.bottom = rMess.top + NUM_HEIGHT_OF_ONE_LINE_MESSSAGE;		
			//rMess.left = rBottomTab.left;
			//rMess.right = rBottomTab.right;
			//rBottomTab.top = rMess.bottom + GetControlGap();
		//}
		//else
		//{
			//rBottomTab.top = rButton.bottom + GetControlGap();
		//}
		if ( !IsBottomPaneShown() )		
			rBottomTab.top = rButton.bottom + GetControlGap();
		
		rMess.left = GetControlGap();
		rMess.right = rButton.left - 2 * GetControlGap();
		int	nWidth = RECT_WIDTH(rMess);
		/// assume atmost 2 lines message, enough for now ...
		if ( m_staticMessage.Measure(m_staticMessage.Text, &nWidth) < RECT_HEIGHT(rButton) )
			rMess.top = rButton.top + GetControlGap();
		else
			rMess.top = rButton.top - GetControlGap();
		rMess.bottom = rButton.bottom;
		///------ End NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
		
		MoveControl(m_BottomTab, rBottomTab);
		m_BottomTab.AdjustRect(FALSE, &rBottomTab);
		/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
		//MoveControl(ctrl, rBottomTab);
		///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
		MoveControl(m_staticMessage, rMess);
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	//}			
	m_staticMessage.Visible = isShowOneLineMessage(); /// Iris 3/12/2012 ORG-5254-P1 FIX_STATIC_MSG_BOX_ALWAYS_HIDDEN
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
}


///Iris 10/11/06 v8.0494b ADD_ONE_LINE_MESSAGE_BAR
//void	NLFitDlg::updateOneLineMessageSize()
//{	
	//vector<uint> vnControls;
	//int nSelTab = GetBottomPaneSubControls(vnControls);
	//
	//if( nSelTab < vnControls.GetSize() )
	//{
		//Control ctrl = GetItem(vnControls[nSelTab]);
		//if( ctrl )
		//{
			//RECT	rDlg, rTab, rMess;
			//m_wndDlg.GetClientRect(&rDlg);
			//GetClientRect(m_BottomTab, rTab);
			//
			//if(isShowOneLineMessage(nSelTab))
			//{
				//rMess.bottom = rDlg.bottom - GetControlGap();
				//rMess.top = rMess.bottom - NUM_HEIGHT_OF_ONE_LINE_MESSSAGE;		
				//rMess.left = rTab.left;
				//rMess.right = rTab.right;
				//rTab.bottom = rMess.top - GetControlGap();
			//}
			//else
			//{
				//rTab.bottom = rDlg.bottom - GetControlGap();
			//}
			//MoveControl(m_BottomTab, rTab);
			//m_BottomTab.AdjustRect(FALSE, &rTab);
			//MoveControl(ctrl, rTab);
			//MoveControl(m_staticMessage, rMess);
		//}
	//}
//}
///End ADD_BITMAP_BUTTON
/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
//bool	NLFitDlg::isShowOneLineMessage(int nSelTab)
bool	NLFitDlg::isShowOneLineMessage()
/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
{
	///Joseph 06/19/07 FIX_BUG_ON_NLF_DLG_RESIZE
	/*
	///Joseph 12/11/06 ADD_BITMAP_BUTTON
	//if( m_NLF.IsShowFitPreview()&& NLF_FIT_CURVE_PREVIEW_TAB == nSelTab || NLF_RESIDUAL_PREVIEW_TAB == nSelTab)
	if( m_NLF.IsShowFitPreview())
	///End ADD_BITMAP_BUTTON
	*/
	/// Hong 03/20/08 QA80-10969 REMOVE_PREVIEW_FIT_CURVE_TAB_WHEN_PREVIEW_IN_SRC_GRAPH
	//if( m_NLF.IsShowFitPreview() && IsBottomPaneShown())
	///------ Folger 02/11/09 QA80-13098-P1 NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	//if( (m_bPreviewSrcPage || m_NLF.IsShowFitPreview()) && IsBottomPaneShown())
	if( (m_bPreviewSrcPage || m_NLF.IsShowFitPreview()))
	///------ End NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	/// end REMOVE_PREVIEW_FIT_CURVE_TAB_WHEN_PREVIEW_IN_SRC_GRAPH
	///End FIX_BUG_ON_NLF_DLG_RESIZE
	{
		return true;
	}
	return false;	
}
///end ADD_ONE_LINE_MESSAGE_BAR

bool 	NLFitDlg::initTabFitCurvePreview(bool bIsResidual)
{
	int 		nID = bIsResidual? IDC_NLF_RESIDUAL_PREVIEW_BOX : IDC_NLF_FIT_CURVE_PREVIEW_BOX;
	Control 	ctrl = GetItem(nID);
	
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	/*
	HWND 		hWnd = ctrl.GetSafeHwnd();	
	GraphControl gcCntrl;
	gcCntrl.CreateControl(hWnd);
	gcCntrl.Visible = false;		
	
	GraphPageControl 	gpCntrl; 
	///Cheney 2007-2-8 SHOULD_ONLY_PERMIT_TO_CLICK_AXES
	//DWORD 	dwNoClicks = NOCLICK_DATA_PLOT | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON | NOCLICK_AXES;
	//----- CPY 10/22/2007 QA70-10569 ALLOW_LEGEND_TO_BE_MOVED_IN_NLFIT_PREVIEW
	//DWORD 	dwNoClicks = NOCLICK_DATA_PLOT | NOCLICK_LABEL | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON;
	DWORD 	dwNoClicks = NLFIT_PREVIEW_NOCLICK_BITS;
	//-----
	///end SHOULD_ONLY_PERMIT_TO_CLICK_AXES
	string 	strTemplate = m_NLF.GetPreviewTemplate(bIsResidual);	
	gpCntrl.Create(gcCntrl, dwNoClicks, strTemplate);			
	*/
	DestroyWindow(ctrl.GetSafeHwnd());	
	
	RECT 				rrCtrl;	
	GraphPageControl 	gpCntrl; 
	DWORD 	dwNoClicks = NLFIT_PREVIEW_NOCLICK_BITS;
	string 	strTemplate = m_NLF.GetPreviewTemplate(bIsResidual);
	DWORD 	dwStyle = WS_CHILD | WS_VISIBLE | WS_BORDER;
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
	
	///Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
	//GraphPage gp = gpCntrl.GetPage();
	if(bIsResidual)
	{
		/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
		m_ctrlResidualPrev.CreateControl(m_BottomTab.GetSafeHwnd(), &rrCtrl, nID, dwStyle);						
		m_BottomTab.InsertTab(m_ctrlResidualPrev.GetSafeHwnd(), _RESIDUAL_PREVIEW_, NLF_RESIDUAL_PREVIEW_TAB);		
		gpCntrl.Create(m_ctrlResidualPrev, dwNoClicks, strTemplate);
		///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
		
		m_gpResidual = gpCntrl.GetPage();
		m_gpResidual.Rename("TempPrevResidual1");
	}
	else
	{
		/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
		m_ctrlCurvePrev.CreateControl(m_BottomTab.GetSafeHwnd(), &rrCtrl, nID, dwStyle);		
		m_BottomTab.InsertTab(m_ctrlCurvePrev.GetSafeHwnd(), _FIT_CURVE_PREVIEW_, NLF_FIT_CURVE_PREVIEW_TAB);
		gpCntrl.Create(m_ctrlCurvePrev, dwNoClicks, strTemplate);
		///End FIX_NLFITDLG_TAB_FLICKER_ISSUE		
		
		m_gpFitCurve = gpCntrl.GetPage();
		m_gpFitCurve.Rename("TempPrevFitCurve1");		
		/// END WRONG_LOCALIZE_MACRO
	}
	
	/// Iris 02/13/2007 v8.0561 COPY_CREATE_SOURCE_GRAPH_AS_PREVIEW
	///Arvin 04/10/07 v8.0597 PREVIEW_COPY_SOURCE_PLOTS_TO_ONE_LAYER by easwar's suggestion
	/*
	GraphPage 	gpSource;
	if(m_NLF.GetSourceGraph(gpSource) && !bIsResidual)
	{
		gpSource.CreateCopy(m_gpFitCurve, DCTRL_COPY_DATA);		
		string str;
		str.Format("page.noClick=%d", dwNoClicks);
		m_gpFitCurve.LT_execute(str);
		//---- CPY 2/19/2007 SNOW_FOUND_FIT_2ND_TIME_PREVIEW_HAS_INSERTED_TABLE_BLOCKING_VIEW_OF_DATA
		m_gpFitCurve.LT_execute("label -r table*");
		//----
	}
	*/
	///end PREVIEW_COPY_SOURCE_PLOTS_TO_ONE_LAYER
	///end COPY_CREATE_SOURCE_GRAPH_AS_PREVIEW
	
	GraphPage gp = bIsResidual ? m_gpResidual : m_gpFitCurve;
	///end SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
	/// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	//m_NLF.SetFitPreviewGraph(gp, bIsResidual);	
	int nType = bIsResidual ? PREVIEW_RESIDUAL : PREVIEW_DATA_FIT;
	/// Iris 12/09/2010 ORG-1620-P2 FIX_PAFIT_NO_FITCURVE_IN_PREVIEW_GRAPH_AFTER_SUBTRACT_BASELINE
	// nLayer default value is 0, here should put -1 to not specify layer index since the layer index should refer to source dataplot when dataplot come from multi layers.
	//m_NLF.SetPreviewGraph(gp, nType);	
	m_NLF.SetPreviewGraph(gp, nType, -1);	
	///End FIX_PAFIT_NO_FITCURVE_IN_PREVIEW_GRAPH_AFTER_SUBTRACT_BASELINE
	/// end FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	
	return true;	
}
///end ADD_FIT_CURVE_PREVIEW_TAB

/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
//void 	NLFitDlg::setMessageLogShow(bool bShow)
//{
	//Control ctrl = GetItem(IDC_NLS_OPERATION_LOG);
	//if(ctrl)
		//ctrl.Visible = bShow;
//}
//
//bool 	NLFitDlg::setTabOperatrLog()
//{
	////string	strShow = "hello ab2";
	////OutputOperationLog(strShow);
	//return true;
//}
/////Frank 11/12/04 v8.0162  ADD_FUNCTION_FILE_PANE
//bool NLFitDlg::setTabFunctionFileShow()
//{
	//string strFDFFile ;///= GetAppPath(true) + "FitFunc\\sine.fdf";///Temp.
	//
	/////DG ACCESS_FUNCTION_BY_NFO
	///*
	//TreeNode trFunc = m_NLF.GetSessionTree();
	//if(!trFunc )//|| !trFunc.GetAttribute(STR_LABEL_ATTRIB,strFDFFile))
		//return false;
	//string strFunName, strFdf;
	//if(!nlf_get_func_names(trFunc, strFunName, strFdf, &strFDFFile))
		//return false;
	//if(!strFDFFile.IsFile())
		//return false;
	//*/
	//strFDFFile=m_NLF.GetFitFuncFile();
	/////end ACCESS_FUNCTION_BY_NFO
	//
	//m_reditFunctionFile.Reset();
	//m_reditFunctionFile.Load(strFDFFile);
	//m_reditFunctionFile.Visible = true;
//
	//return true;
//}
/////End ADD_FUNCTION_FILE_PANE
//
/////Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
//bool 	NLFitDlg::setTabOperationHintShow()
//{
	//if(! m_editHint)
		//return false;
	/////Jasmine 09/18/07 QA70-10393 NLFIT_HINTS, don't put hints here	
	///*
	//string strHelp;
	//m_editHint.Text = "";
	//
	/////Joseph 06/21/07 v8.0645 NLF_SHOULD_SUPPORT_CUSTOM_BUTTON_EVENT
	////function name is not so good
	////string strHint;
	////m_NLF.GetOperationMessage(strHint);
	//string strHint = m_NLF.GetHintMessageSectionName();
	/////End NLF_SHOULD_SUPPORT_CUSTOM_BUTTON_EVENT
	//
	/////Cheney 2007-9-11 LARRY_CHANGE_INDEPDENT_TO_MULTIDATA_MODE_IN_HINT_TXT
	////int nRet = okutil_read_file_section(STR_NLSF_HINT_FILE, strHint, &strHelp, NULL);
	//string strVer = "E";
	//char chCurrentLang = okutil_get_current_lang();
	//if(chCurrentLang == 'J')
		//strVer = "J";
	//else if(chCurrentLang == 'G')
		//strVer = "G";
	//
	//string strHintsFilePath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM)+ "Localization\\" + strVer + "\\NLSFHints.txt";	
	//int nRet = okutil_read_file_section(strHintsFilePath, strHint, &strHelp, NULL);
	/////end LARRY_CHANGE_INDEPDENT_TO_MULTIDATA_MODE_IN_HINT_TXT
	//m_editHint.Text = strHelp;
	//*/
	/////End NLFIT_HINTS	
	//m_editHint.Visible = true;
	//return true;
//}
/////End ADD_HINT_TAB_TO_NLSF
//
///// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB	
//bool 	NLFitDlg::setTabFitCurvePreview(bool bIsResidual)
//{
	//int 		nID = bIsResidual? IDC_NLF_RESIDUAL_PREVIEW_BOX : IDC_NLF_FIT_CURVE_PREVIEW_BOX;
	//Control 	ctrl = GetItem(nID);
	//if( ctrl )
	//{
		//ctrl.Visible = true;
		/////Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
		//bIsResidual ? m_gpResidual.Refresh(TRUE) : m_gpFitCurve.Refresh(TRUE);	
		/////end SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
		//return true;
	//}
	//
	//return false;
//}
/////end ADD_FIT_CURVE_PREVIEW_TAB
//
//// if bFormula = false, then show Curve
//bool 	NLFitDlg::setTabFuncCurvePreview(bool bFormular)
//{
	//return setFunctionFormulaPreview(bFormular);
//}
///// Hong 03/20/08 v8.0828 CENTRALIZED_CODE
///*
/////Jasmine 02/09/06 ADD_PARA_BOUND_TAB
////bool 	NLFitDlg::setTabParameterControl()
//bool 	NLFitDlg::setTabParameterControl(int nSelTab)
//{
//#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID	
	//int		nNumParaInFunc = m_NLF.GetNumParameter();
	//int		nNumDataset =  m_NLF.GetNumDataset();
	//if( !m_GridParas.Update(nNumParaInFunc, nNumDataset) )
		//return false;
	/////Jasmine 10/10/07 SHIFT_PARA_VECTORS_WHEN_THEME_CHANGE
	//if(m_bParamChangedByTheme)
	//{
		//m_GridParas.CheckAndUpdateForParamSharing();
		//m_bParamChangedByTheme = false;
	//}
	/////End SHIFT_PARA_VECTORS_WHEN_THEME_CHANGE
	//int 	nShowColType;
	//switch(nSelTab)
	//{
	//case NLF_PARAMETERS_TAB:
		//nShowColType = COL_SHOW_NORMAL;
		//break;
	//case NLF_PARABOUND_TAB:
		//nShowColType = COL_SHOW_BOUND;
		//break;
	//default:
		//return false;
	//}
	//m_GridParas.ChangShowCol(nShowColType);
//#endif
	//return true;
//}
/////End 	ADD_PARA_BOUND_TAB
//*/
///// end CENTRALIZED_CODE
////Change the function preview visible and changer the metafile
//
////---- CPY 5/26/04 v7.5878 FO_FUNC_PREVIEW_IMPROVEMENT
//
//bool	NLFitDlg::setFunctionFormulaPreview( bool bFormular )
//{
	//TreeNode	trFunction;
	//int			nNumDataset;
	////if(m_NLF.GetFunctionAndNumDataset(trFunction, nNumDataset))
	///// Hong 05/27/08 v8.0871 CLEAN_UP_DUPLICATED_FUNCTION
	////trFunction = m_NLF.GetFunctionTree();
	//trFunction = m_NLF.GetFDFTree();
	///// end CLEAN_UP_DUPLICATED_FUNCTION
	////return m_NFPrev.LoadFunctionPreview(trFunction,bFormular);
//
	/////Frank 10/11/04 v8.0147  MODIFY_CODE_TO_LOAD_SAMPLE_FORMULA_PREVIEW
	////return m_NFunctionPrev.LoadNLSFFunctionPreview(trFunction, bFormular);
	//bool	bLoadPreviewSecc = false;
	//if(bFormular)
	//{
		//bLoadPreviewSecc = m_NFunctionPrev.LoadNLSFFunctionPreview(trFunction, bFormular);
		//m_NFunctionPrev.SetVisible(bLoadPreviewSecc);
	//}
	//else
	//{
		//bLoadPreviewSecc = m_NCurvePrev.LoadNLSFFunctionPreview(trFunction, bFormular);
		//m_NCurvePrev.SetVisible(bLoadPreviewSecc);
	//}
	//return bLoadPreviewSecc;
	/////End  MODIFY_CODE_TO_LOAD_SAMPLE_FORMULA_PREVIEW
//}
///// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN

///DG ACCESS_FUNCTION_BY_NFO
/*
bool 	NLFitDlg::isFunctionTreeInvalid()
{
	TreeNode	trFunction;
	int			nNumDataset;
	//if(!m_NLF.GetFunctionAndNumDataset(trFunction, nNumDataset))
		//return false;
	trFunction = m_NLF.GetSessionTree();
	if(!trFunction)
		return false;
	TreeNode trFunct = trFunction.GeneralInformation;
	if(!trFunct)
		return false;
	return true;
}
*/
///end ACCESS_FUNCTION_BY_NFO

//---- CPY 10/4/04 ITERATION_TOLERANCE_PROPER_UPDATE
///Sophy 11/26/2008 v8.980 SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
//void NLFitDlg::updateShowButtons(bool bForceShowResults)// = false)
void NLFitDlg::updateShowButtons(bool bForceShowResults, DWORD& dwEnables, bool bUpdateOKButton)// = false, NULL, true)
///end SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
{
	bool bChisqr = true;
	///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//bool bEnable = m_NLF.IsEnableFitButtons(bChisqr);
	bool bEnable = m_NLF.IsEnableFitButtons(bChisqr, true, GetCurrentFittingData(TRUE));
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	///Sophy 11/26/2008 v8.980 SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
	//m_btnOK.Enable = bChisqr;
	bool bOKEnable = bChisqr;
	if( NULL != dwEnables )
	{
		bOKEnable &= (dwEnables & GETNGEVT_OK_ENABLE);
	}
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	//if( bUpdateOKButton && m_btnOK )
	//	m_btnOK.Enable = bOKEnable;
	if ( bUpdateOKButton )
	{
		if ( m_btnOK )
			m_btnOK.Enable = bOKEnable;
		if ( m_btnDone )
			m_btnDone.Enable = bOKEnable;
	}
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	
	bEnable &= bOKEnable;
	bChisqr &= bOKEnable; ///Sophy 12/2/2008 v8.981b UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR as Max suggested
	///end SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
	
	///Cheney 2007-4-10 IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	//m_btnFit.Enable = bEnable;
	//m_btnFit1.Enable = bEnable;
	bool bSepFit = m_NLF.IsSepFit();
	///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//m_btnFit.Enable = bSepFit? false : bEnable;
	//m_btnFit1.Enable = bSepFit? false : bEnable;
	/////end IF_SEP_FIT_SHOULD_DISABLE_FIT_AND_ITER_BUTTON
	m_btnFit.Enable = bEnable;
	m_btnFit1.Enable = bEnable;
	///------ Folger 08/11/2011 ORG-2740-S4 HIDE_SELECT_DATA_COMBO_WHEN_NO_APPROPRIATE
	//m_comboData.Enable = bSepFit;
	m_comboData.Visible = bSepFit;
	///------ End HIDE_SELECT_DATA_COMBO_WHEN_NO_APPROPRIATE
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	///Arvin 07/24/07 USE_SIMPLEX_FIT_TO_UPDATE_PARAMS
	//m_SimplexButton.Enable = bSepFit? false : bEnable;///Joseph 06/22/07 v8.0647 ADD_NLF_SIMPLEX_BUTTON
	/// Hong 11/06/08 v8.0966c FIX_SIMPLEX_BTN_NOT_DISABLED_WHEN_NO_DATA_SET
	//m_SimplexButton.Enable = bSepFit? false : true;
	///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//m_SimplexButton.Enable = bSepFit? false : bChisqr;
	/// Iris 5/22/2012 ORG-5762-P1 DISABLE_SIMPLEX_FIT_BUTTON_FOR_IMPLICIT_FUNCTION
	//m_SimplexButton.Enable = bChisqr;
	m_SimplexButton.Enable = bChisqr && !m_NLF.IsODRFit();
	///End DISABLE_SIMPLEX_FIT_BUTTON_FOR_IMPLICIT_FUNCTION
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	/// end FIX_SIMPLEX_BTN_NOT_DISABLED_WHEN_NO_DATA_SET
	///end USE_SIMPLEX_FIT_TO_UPDATE_PARAMS
	m_btnGetChiSQ.Enable = bChisqr;
	//m_btnInit.Enable = bChisqr;///Jasmine 03/09/06 DISABLE_INIT_BUTTON, disable when selected function is mixtype
	m_btnInit.Enable = bChisqr && !m_NLF.IsMixedFunction();
	
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
#ifdef __NEW_FITTING_FUNCTION_WIZARD__
	m_SelFuncButton.Enable = m_NLF.IsFunctionTreeValid();//bEnable	///Jasmine 06/23/10 ORG-2-P8 EDIT_FUNC_BTN_AVAILABLE_IF_FUNCTION_READY
	//m_NewFuncButton.Enable = bOKEnable; //maybe always enabled is better.
#endif//__NEW_FITTING_FUNCTION_WIZARD__
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	
	///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	if(! m_nFDFValueChange)
		m_SaveFDFButton.Enable = false;
	///End ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	
	if(bForceShowResults)
	{
		/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
		//if(IsBottomPaneShown())
		/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
		{
			 /// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB
			//updateBottomTabDisplay(NLF_MESSAGES);
			///Joe  8/18/06 NOT_ALL_BUTTON_ONCLICK_SHOW_MESSAGE_TAB
			/// Hong 03/21/08 v8.0828 GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
			/*
			int nSelTab = m_BottomTab.GetCurSel();
			int nTab = nSelTab;
			int 	nShowFitPreview = 0;         //If Showing the FitPreview, then nShowFitPreview = 1 ;else nShowFitPreview = 0
			if(! m_NLF.IsShowFitPreview())
				nShowFitPreview = 1;	
		
			nSelTab = nSelTab + nShowFitPreview; //If not Showing the FitPreview, then the nSelTab = nSelTab + 1.
			if(nSelTab == NLF_FORMULA_TAB || nSelTab == NLF_SAMPLE_CURVE_TAB || nSelTab == NLF_FUNCTION_FILE_TAB)
				nTab = NLF_MESSAGES - nShowFitPreview;  //If not Showing the FitPreview, then the nTab = NLF_MESSAGES -1,just to show the message tab.
			//int nTab = m_NLF.IsShowFitPreview()? NLF_MESSAGES : NLF_MESSAGES - 1;
			///End NOT_ALL_BUTTON_ONCLICK_SHOW_MESSAGE_TAB
			updateBottomTabDisplay(nTab);
			*/
			int nSelTab =  m_BottomTab.GetCurSel();
			int nSelTabEnum = bottomTabSelToEnum(nSelTab);
			
			/// Hong 07/31/09 QA80-13590-P7 ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_ACTIVE
		#ifdef		__ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_TAB_ACTIVE__
			/// Hong 01/12/10 QA80-13590-P7 ALWAYS_ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG
			//if( NLF_FIT_CURVE_PREVIEW_TAB != nSelTabEnum )
			if( NLF_FIT_CURVE_PREVIEW_TAB != nSelTabEnum || m_NLF.IsIterateFailed(m_NLF.GetLastIterateOutCome()) )
			/// end ALWAYS_ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG
		#else		//__ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_TAB_ACTIVE__
			/// end ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_ACTIVE
			if( NLF_FORMULA_TAB == nSelTabEnum || NLF_SAMPLE_CURVE_TAB == nSelTabEnum || NLF_FUNCTION_FILE_TAB == nSelTabEnum )
		#endif		//__ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_TAB_ACTIVE__ /// Hong 07/31/09 QA80-13590-P7 ACTIVE_MSG_TAB_IF_SIGNIFICANT_MSG_EXCEPT_FITTED_CURVE_ACTIVE
				nSelTab = bottomTabEnumToSel(NLF_MESSAGES); 
			/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
			//updateBottomTabDisplay(nSelTab);
			setBottomPaneActiveTab(nSelTab);
			/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
			/// end GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
			///end ADD_FIT_CURVE_PREVIEW_TAB
		}
	}
}
//---- end
/*
/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
void	NLFitDlg::SetOperationUID(DWORD dwUID)
{
	m_dwOperationUID = dwUID;
}
/// end NLFITTER_OPERATION_IMPLEMENTATION
*/
BOOL	NLFitDlg::OnParamChange(uint wParam, uint lParam)
{
	bool bFunctionChange = (wParam & WPARAM_PARAM_CHANGE_BY_FUNC_CHANGE)? true:false;
	if(bFunctionChange)
		OnFunctionChange(bFunctionChange, lParam);
	
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	////--- CPY 10/26/04 NLF_PARAS_EDIT_CLEANUP
	//if( WPARAM_PARAM_CHANGE_BY_USER & wParam) // user change param from GUI, then need to tell FittingSession
		//m_NLF.NotifyParamChange(LOWORD(lParam), HIWORD(lParam));
	////---	
		//
	////---- end		
	/////Cheney 2006-11-15 SHOULD_HIDE_SHARE_COL_WHEN_SEPARATE_REPORT
	//TreeNode trInput = m_NLF.GetDataSelection().InputData;
	//if(!trInput)
		//return false;
	//
	//int nDataMode;
	//trInput.GetAttribute(STR_USE_ATTRIB, nDataMode);
	//m_GridParas.SetDataMode(nDataMode);	
	/////end SHOULD_HIDE_SHARE_COL_WHEN_SEPARATE_REPORT
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG

	/////Danice 10/10/04 REFRESH_PARAMETER_CONTROL_WHEN_VIEW
	///*
	//else
	//{
		//int nSelTab=m_TopTab.GetCurSel();
		//setTabParameterControl(NLF_PARAMETERS_TAB == nSelTab);
	//}
	//*/
	/////end
	//updateShowButtons();	
	updateDisplayOnParamsChange();
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	return true;
}

/// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
/// Hong 12/12/08 QA80-12733 ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
//BOOL	NLFitDlg::UpdatePreviewPage()
BOOL	NLFitDlg::UpdatePreviewPage(bool bForceUpdate/* = false*/)
/// end ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
{
	bool bPreviewSrcPage = m_NLF.IsSourcePreviewPage();
	bool bChangePreviewPage = bPreviewSrcPage != m_bPreviewSrcPage;
	m_bPreviewSrcPage = bPreviewSrcPage;
	/// Hong 12/12/08 QA80-12733 ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	//if ( bChangePreviewPage )
	if ( bChangePreviewPage || bForceUpdate )
	/// end ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	{				
		GraphPage 	gp;
		int			nLayer = 0;
		if ( m_bPreviewSrcPage )
		{
			/// Iris NLF_81, FIX_SHOW_FIT_PLOT_NOT_ON_CORRECT_SOURCE_LAYER_IF_DATA_NOT_FROM_ACTIVE_LAYER
			//gp = m_NLF.GetSrcGraphPage();
			int 		nDatasetIndex = 0; // set the first data source graph as preview
			GraphLayer 	gl;
			if( m_NLF.GetSourceGraphLayer(gl, nDatasetIndex) )
			{
				gp = gl.GetPage();
				/// Iris 12/09/2010 ORG-1620-P2 FIX_PAFIT_NO_FITCURVE_IN_PREVIEW_GRAPH_AFTER_SUBTRACT_BASELINE
				//nLayer = gl.GetIndex();
				nLayer = -1;
				///End FIX_PAFIT_NO_FITCURVE_IN_PREVIEW_GRAPH_AFTER_SUBTRACT_BASELINE
			}
			///end FIX_SHOW_FIT_PLOT_NOT_ON_CORRECT_SOURCE_LAYER_IF_DATA_NOT_FROM_ACTIVE_LAYER
		}
		
		if ( !m_bPreviewSrcPage || !gp )
		{
			gp = m_gpFitCurve;
			
			/// Hong 03/21/08 QA80-10969 FIX_FIT_CURVE_PREVIEW_NOT_SHOW_EMPTY_INPUT_FROM_WORKSHEET
			//m_bPreviewSrcPage = false;
			if ( m_bPreviewSrcPage )
			{
				m_NLF.DisableSourcePreviewPage();
				m_bPreviewSrcPage = false;
			}
			/// end FIX_FIT_CURVE_PREVIEW_NOT_SHOW_EMPTY_INPUT_FROM_WORKSHEET
		}
		
		int nType = m_bPreviewSrcPage ? PREVIEW_EXTERNAL_DATA_FIT : PREVIEW_DATA_FIT;
		/// Hong 03/06/08 QA80-10969 FIX_SRC_PREVIEW_PLOT_NOT_REMOVED_WHEN_UNCHECKED
		//m_NLF.SetFitPreviewGraph(gp, nType, true);
		m_NLF.SetPreviewGraph(gp, nType, nLayer, true, true);
		//// end FIX_SRC_PREVIEW_PLOT_NOT_REMOVED_WHEN_UNCHECKED
		/// end FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
		/// Hong 01/23/08 QA80-10969 DEFAULT_PREVIEW_IN_SOURCE_GRAPHPAGE
		// active Message tab when currect active tab is curve preview
		/// Hong 03/20/08 QA80-10969 REMOVE_PREVIEW_FIT_CURVE_TAB_WHEN_PREVIEW_IN_SRC_GRAPH
		//if ( m_bPreviewSrcPage && m_NLF.IsShowFitPreview() && NLF_FIT_CURVE_PREVIEW_TAB == m_BottomTab.GetCurSel() )
		//{			
		//	updateBottomTabDisplay(NLF_MESSAGES);
		//}
		/// Hong 03/21/08 v8.0828 GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
		/*
		int nOffsetCurTab = m_NLF.IsShowFitPreview() ? 1 : -1;
		int nTabToShow = m_BottomTab.GetCurSel() + nOffsetCurTab;	
		
		if ( m_NLF.IsShowFitPreview() )
			nTabToShow = NLF_FIT_CURVE_PREVIEW_TAB;
		else if ( NLF_FIT_CURVE_PREVIEW_TAB == m_BottomTab.GetCurSel() )
			nTabToShow = NLF_MESSAGES + nOffsetCurTab;
		
		updateBottomTabDisplay(nTabToShow);
		*/
		int nTabToShow = m_BottomTab.GetCurSel();
					 
		if ( m_NLF.IsShowFitPreview() )
		{	// switch from remove(hide) to add(show), to select index is consistent with enum value			
			nTabToShow = NLF_FIT_CURVE_PREVIEW_TAB;
		}		
		else
		{	// switch from add(show) to remove(hide), fit curve tab NOT removed yet, so selected index is consistent with enum value
			if ( NLF_FIT_CURVE_PREVIEW_TAB == m_BottomTab.GetCurSel() )
				nTabToShow = NLF_MESSAGES;
			nTabToShow = bottomTabEnumToSel(nTabToShow);
		}
		/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
		//updateBottomTabDisplay(nTabToShow);
		UpdateBottomPaneSubControls();
		setBottomPaneActiveTab(nTabToShow);
		/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
		/// end GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
		/// end REMOVE_PREVIEW_FIT_CURVE_TAB_WHEN_PREVIEW_IN_SRC_GRAPH
		/// end DEFAULT_PREVIEW_IN_SOURCE_GRAPHPAGE
	}

	return true;
}
/// end FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/*
/// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB

///End UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE
BOOL NLFitDlg::OnDataChange(uint wParam, uint lParam)
{
	if(IsBottomPaneShown())
		updateBottomTabDisplay();
	/// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	UpdatePreviewPage();
	/// end FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE	
	return true;
}
///end ADD_FIT_CURVE_PREVIEW_TAB
*/
///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/// Iris 07/03/06 UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE
BOOL	NLFitDlg::OnFitCurveOptionsChange(uint wParam, uint lParam)
{
	/// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	UpdatePreviewPage();
	/// end FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	updateShowButtons();
	return true;
}
///End UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE
	
///Frank  9/10/04 v8.0130 MOVE_OPERATION_LOG_TO_SESSION_CLASS
BOOL NLFitDlg::OnKeyDownWindow(Control oCntrl, UINT msg, UINT wParam, UINT lParam)
{	
	
	if(msg == WM_CHAR)
		return FALSE;
	
	if(msg != WM_KEYDOWN)
		return TRUE;
	
	switch(wParam)
	{
	case VK_RETURN:
		return true;
	case VK_LEFT:
		return false;
	case VK_RIGHT:
		return false;
	case VK_UP:
		return false;
	case VK_DOWN:
		return false;
		
	case VK_BACK:
		return true;
		
	case VK_DELETE:
		return true;
		
	case VK_CONTROL:
		return false;
		
	case VK_SHIFT:
		return false;
	}
	return TRUE; 
}
/// MOVE_OPERATION_LOG_TO_SESSION_CLASS

///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
/*
void NLFitDlg::loadThemeFilesToCombo(TreeNode& trGUI)
{
	m_comboTheme.ResetContent();
	vector<string> vsThemeList;
	int nSel = theme_get_list(trGUI, vsThemeList);
	
	if(vsThemeList.GetSize() == 0)
		return;
	
	for(int ii = 0; ii < vsThemeList.GetSize(); ii++)
		m_comboTheme.AddString(vsThemeList[ii]);
	
	m_comboTheme.SetCurSel(nSel);
	updateSaveButton(vsThemeList[nSel]);
}
*/
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/*
///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON	
void NLFitDlg::UpdateOneLineMessageBox(uint wParam, uint lParam) 
{
	updateOneLineMessageBox();
}
///end IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON
*/
///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
///Jasmine 09/18/07 QA70-10393 NLFIT_HINTS
void NLFitDlg::OnUpdateHints(WPARAM wParam, bool bUpdate)
{
	m_editHint.Text = "";
	string strSection, strHelp, strText;
	strSection = ((LPCSTR)wParam);
	string strHintFile;
	BOOL bRet = okutil_find_sys_path_with_file(&strHintFile, STR_NLF_HINT_FILE, GLOBAL_LOCALIZED_PATH, TRUE);
	if(!strSection.IsEmpty())
	{
		okutil_read_file_section(strHintFile + STR_NLF_HINT_FILE, strSection, &strHelp, NULL); 
		/// AW 10/26/07 WRONG_LOCALIZE_MACRO
		//strText.Format("[%s]\r\n%s\r\n", _L(strSection), strHelp);
		///------ Folger 04/13/2011 ORG-1871-P2 NLFIT_FAILED_TO_LOAD_HINT_IN_J
		//strText.Format("[%s]\r\n%s\r\n", strSection, strHelp);
		strText.Format("[%s]\r\n%s\r\n", GetLocalized(strSection), strHelp);
		///------ End NLFIT_FAILED_TO_LOAD_HINT_IN_J
		/// END WRONG_LOCALIZE_MACRO
		m_editHint.Text = strText;
	}
	//other hints
	string strOther, strOtherHelp;
	strOther = m_NLF.GetHintMessageSectionName();
	if(!strOther.IsEmpty())
	{
		okutil_read_file_section(strHintFile + STR_NLF_HINT_FILE, strOther, &strOtherHelp, NULL); 
		if(!strText.IsEmpty())
			m_editHint.Text += "\r\n";
		/// AW 10/26/07 WRONG_LOCALIZE_MACRO
		//strText.Format("[%s]\r\n%s\r\n", _L(strOther), strOtherHelp);
		strText.Format("[%s]\r\n%s\r\n", GetLocalized(strOther), strOtherHelp);
		/// END WRONG_LOCALIZE_MACRO
		m_editHint.Text += strText;
	}
}
///End NLFIT_HINTS

BOOL	NLFitDlg::OnNLFitDlgUpdate(DWORD wParam, DWORD lParam)
{
	//maybe we have something need to be suspended later
	/*
	if ( bSuspended && (NLDLGPART_FITCURVE_DATA & wParam) )
	{
		m_dwDelayedUpdate |= ;NLDLGPART_FITCURVE_DATA;
		wParam &= ~NLDLGPART_FITCURVE_DATA;
	}
	*/
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	// Grid is called by Dialog, so no event message is necessage
	//BOOL		bRet = !updateParts(wParam);
	//m_dwDelayedUpdate &= ~wParam;		//later
	//bRet = bRet & !updateObjects( wParam, lParam );///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	BOOL		bRet = !updateObjects( wParam, lParam );///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	return bRet;
}

/// Bill ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
void NLFitDlg::OnAfterMoveColumns(Control ctrl, long lCol, long *pnPosition)
{
	m_pGridParas->OnAfterMoveColumns(ctrl, lCol, pnPosition);
}
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
int		NLFitDlg::updateObjects( DWORD dwObject, DWORD dwParam )
{
	if( dwObject & NLSPLITTERPART_DATA_UPDATE )
	{
		/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
		//if(IsBottomPaneShown())
		//	updateBottomTabDisplay();
		//UpdatePreviewPage();
		UpdatePreviewPage();
		updateBottomTabDisplay(bottomTabEnumToSel(NLF_FIT_CURVE_PREVIEW_TAB));
		updateBottomTabDisplay(bottomTabEnumToSel(NLF_RESIDUAL_PREVIEW_TAB));
		/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
		/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
		updateMonitorDatasetNames();
		/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
		///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		UpdateDataCombo();
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	}
	if( dwObject & NLSPLITTERPART_ONE_LINE_MSG )
	{
		m_staticMessage.Text = m_NLF.GetFitOutCome();
	}
	if( dwObject & NLSPLITTERPART_REPLICA )
	{
		updateStaticNumReplica( m_TopTab.GetCurSel(), dwParam&WPARAM_REPLICA_ACTIVE_MSG_TAB );
		enablePeakSortingButton(m_NLF.IsReplicaFit());		//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
		//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
		if ( !m_NLF.IsReplicaFit() )
			enablePeakReorderingButton(false);
		//------
	}
	if( dwObject & NLSPLITTERPART_PARAM )
	{
		OnParamChange( dwParam, 0 );
	}
	if( dwObject & NLSPLITTERPART_ERROR_MSG )
	{
		OnResizeErrMsg( dwParam, 0 );
	}
	if( dwObject & NLSPLITTERPART_BUTTON )
	{
		///Sophy 11/26/2008 v8.980 SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
		//updateShowButtons();
		updateShowButtons(false, dwParam);
		///end SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
		///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		//updateFitButtonText(m_NLF.IsFitConverged());
		updateFitButtonText(IsAllDataFitConverge());
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	}
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	if ( dwObject & NLSPLITTERPART_FIT_FUNC_CHANGE )
	{		
		m_checkEnableAutoParamsInit.Check = m_NLF.IsEnableAutoParamsInit();
		/// Iris 3/19/2012 ORG-5293-P4 NOT_TO_ALLOW_SET_CONSTRAINTS_FOR_IMPLICT_FUNC		
		//m_checkEnableConstraints.Check = m_NLF.IsEnableLinearConstraints();
		/// Iris 5/23/2012 ORG-3378-S4 NEED_DISABLE_ODR_FIT_FOR_EXPLICIT_FUNC
		/*
		bool bButtonEnable;
		m_checkEnableConstraints.Check = m_NLF.IsEnableLinearConstraints(bButtonEnable);		
		m_checkEnableConstraints.Enable = bButtonEnable;
		*/
		m_checkEnableConstraints.Check = m_NLF.IsEnableLinearConstraints();
		///End NEED_DISABLE_ODR_FIT_FOR_EXPLICIT_FUNC
		///End NOT_TO_ALLOW_SET_CONSTRAINTS_FOR_IMPLICT_FUNC
		
		updateBottomTabDisplay(bottomTabEnumToSel(NLF_FORMULA_TAB)); /// Hong 07/03/09 QA80-13590-P6 FUNC_FURMULA_NOT_UPDATED_WHEN_CHANGE_FUNC_IF_ACTIVE
		updateBottomTabDisplay(bottomTabEnumToSel(NLF_SAMPLE_CURVE_TAB));
		updateBottomTabDisplay(bottomTabEnumToSel(NLF_FUNCTION_FILE_TAB));
	}
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	
	/// Iris 5/23/2012 ORG-3378-S4 NEED_DISABLE_ODR_FIT_FOR_EXPLICIT_FUNC
	if ( dwObject & NLSPLITTERPART_FIT_MODE_CHANGE )
	{
		bool bButtonEnable;
		m_NLF.IsEnableLinearConstraints(&bButtonEnable);		
		m_checkEnableConstraints.Enable = bButtonEnable;
	}
	///End NEED_DISABLE_ODR_FIT_FOR_EXPLICIT_FUNC
	
	/// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	if ( dwObject & NLSPLITTERPART_THEME_VALUE_CHANGE )
	{
		onThemeValueChange();
	}
	/// end ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	return 0;
}
///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
int		NLFitDlg::updateParts(DWORD dwParts)
{
	if ( dwParts & NLDLGPART_PARAMETERS_GRID )
	{
		/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
		//int		nSelTab = m_TopTab.GetCurSel();
		//if ( nSelTab == NLF_PARAMETERS_TAB )
		//{
			///// Hong 06/27/08 v8.0892 CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER
			////m_GridParas.Update(m_GridParas.Update(m_NLF.GetNumParameter()));			
			//m_GridParas.Update();
			///// end CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER
		//}
		updateDisplayOnParamsChange();
		/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
				
	}
	///------ Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
	if ( O_QUERY_BOOL(dwParts, NLDLGPART_PARAMETERS_DISPLAY) )
	{
		///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		//m_pGridParas->Update(m_NLF.IsAllowSharing());
		///------ Folger 08/08/2011 ORG-2740-P6 PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
		//m_pGridParas->Update(m_NLF.IsAllowSharing(), true, GetCurrentFittingData());
		m_pGridParas->Update(m_NLF.IsAllowSharing(), false, GetCurrentFittingData());
		///------ End PARAM_GRID_SHOULD_NOT_SCROLL_UP_AFTER_INTERATION
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	}
	///------ End PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
	
	///------ Folger 05/19/2011 ORG-2773-P2 HIDE_PARAMS_DIALOG_FAILED_IN_NLFIT
	if ( O_QUERY_BOOL(dwParts, NLDLGPART_PARAM_ROW_SHOW) )
	{
		customParamRowsShow();
	}
	///------ End HIDE_PARAMS_DIALOG_FAILED_IN_NLFIT
	
	if ( dwParts & NLDLGPART_FIT_CONTROL_BTNS )
	{
		/// Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
		//updateShowButtons(true);
		updateShowButtons(false);
		/// end ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
		///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		//updateFitButtonText(m_NLF.IsFitConverged());
		updateFitButtonText(IsAllDataFitConverge());
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	}
	/// Hong 10/09/08 v8.0953 TAKE_BACK_MECHANISM_OF_FDF_CHANGE_INDICATOR
	if ( dwParts & NLDLGPART_FDF_SETTINGS )
	{
		onChangeFDFFileValue(NLF_CODE_CHANGED);
	}
	/// end TAKE_BACK_MECHANISM_OF_FDF_CHANGE_INDICATOR
	/// Hong 09/11/08 v8.0937 CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	/*
	if( dwParts & NLDLGPART_FIT_FUNC_DISPLAY )
	{
		int		nSelTab = m_BottomTab.GetCurSel();
		if( IsBottomPaneShown() )
		{
			updateBottomTabDisplay( nSelTab );
		}
	}
	
	/// Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	if ( dwParts & NLDLGPART_FIT_FUNC_CHECKBOX )
	{
		m_checkEnableAutoParamsInit.Check = m_NLF.IsEnableAutoParamsInit();
		m_checkEnableConstraints.Check = m_NLF.IsEnableLinearConstraints();
	}
	/// end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	*/
	/// end CLEAN_NLFIT_DLG_MSG_TRY_AVOIDING_POST_MSG
	return 0;
}

//------ Folger 10/24/08 v8.0960 CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE
///------ Folger 06/07/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
//void	NLFitDlg::updateOnParameterChange(int nUpdateParts, DWORD dwUpdateBits/* = FITPREVIEW_UPDATE*/)
void	NLFitDlg::updateOnParameterChange(int nUpdateParts, DWORD dwUpdateBits/* = FITPREVIEW_UPDATE*/, int nRow/* = -1*/)
///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
{
	///------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
	if ( nUpdateParts > 0 )
	{
	///------ End CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
		///------ Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
		if ( !O_QUERY_BOOL(nUpdateParts, NLDLGPART_PARAMETERS_DISPLAY) )
		///------ End PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
			///------ Folger 06/07/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
			//m_NLF.NotifyParamChange(nUpdateParts & NLDLGPART_FITCURVE_DATA ? true : false, dwUpdateBits);
			m_NLF.NotifyParamChange(nUpdateParts & NLDLGPART_FITCURVE_DATA ? true : false, dwUpdateBits, nRow);
			///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		updateParts(nUpdateParts);
	}		///------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
	onThemeValueChange();
}
//------ End CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE

//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
void	NLFitDlg::enablePeakSortingButton(bool bEnable)
{
	Button btn = GetItem(IDC_NLF_SORT_PEAKS);
	btn.Enable = bEnable;
}
//------ End SUPPORT_SORT_PEAKS_FOR_REPLICA

//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
void	NLFitDlg::enablePeakReorderingButton(bool bEnable)
{
	Button btn = GetItem(IDC_NLF_REORDER_PEAKS);
	btn.Enable = bEnable;
}
//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
BOOL	NLFitDlg::OnDataChangebyUserEdit(string str)
{
	return m_NLF.OnDataChangebyUserEdit(str);	
}

void	NLFitDlg::updateMonitorDatasetNames()
{	
	if ( m_saSrcDatasetNames.GetSize() > 0 )
	{
		Project.DataChangeMonitor(m_saSrcDatasetNames, NULL);
		m_saSrcDatasetNames.RemoveAll();
	}
	
	DataRange		dr;
	dr = m_NLF.GetSrcDataRange();
	if ( dr )
	{
		if ( dr.GetNamesOfDatasets(m_saSrcDatasetNames, TRUE) > 0 );
			Project.DataChangeMonitor(m_saSrcDatasetNames, GetSafeHwnd());
	}
}
/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG

/// Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
BOOL	NLFitDlg::OnClickOutside(DWORD wParam, DWORD lParam)
{
	if ( 0 != wParam ) // UID not ZERO, user click on page
	{
		OptionalMessage("NLFitMinimizeToModalless", MB_OK);
	}
	return FALSE;
}
/// end NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
	
//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifdef THEME_CONTROL_POPUP_MENU
///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
/*
void	NLFitDlg::OnThemeSave(uint wParam, uint lParam)
{
	onThemeValueChange(true); /// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	OnSaveTheme(m_btnSaveTheme);
}

void	NLFitDlg::OnThemeSaveAs(uint wParam, uint lParam)
{
	onThemeValueChange(true); /// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	Control ctrl;
	OnSaveThemeAs(ctrl);
}

void	NLFitDlg::OnThemeChange(uint wParam, uint lParam)
{
	onThemeValueChange(true, false); /// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	OnComboChangeTheme(m_comboTheme);
}
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
void	NLFitDlg::OnThemeSetting(uint wParam, uint lParam)
{
	m_NLF.OnThemeSetting();
}
BOOL	NLFitDlg::IsThemeSetting(uint wParam, uint lParam)
{
	return true;
}
*/
///---Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
/*
BOOL	NLFitDlg::OnLoadTheme(uint wParam, uint lParam)
{
	return LoadTheme();
}
*/
///---END QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
///---END QA80-11371 THEME_SAVING_OPTIONS
#endif
	//------



void NLFitDlg::updateOneLineMessageBox()
{
	/// Iris 12/25/2006 CORRECT_ONE_LINE_FIT_MESSAGE
	/*
	string strMessage;
	if(m_btnFit.Enable)
	{
		strMessage = "Fit did not converge";
	}
	else
	{
		strMessage = "Fit converged";
	}		
	*/
	string strMessage = m_NLF.GetFitOutCome();
	///end CORRECT_ONE_LINE_FIT_MESSAGE
	m_staticMessage.Text = strMessage;	
}

///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON	
void	NLFitDlg::updateFitButtonText(bool bOK)
{
	Button btn = GetItem(IDOK);
	string strBtnText = bOK? _L("OK") : _L("Fit");
	btn.Text = strBtnText;
	///------ Folger 08/11/2011 ORG-2740-S3 PROPER_HINT_TEXT_FOR_NLFIT_BUTTONS
	btn.SetToolTip(bOK ? _L("Close dialog") : _L("Fit all data and close dialog"));
	///------ End PROPER_HINT_TEXT_FOR_NLFIT_BUTTONS
}
///end IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON

/// Hong 03/21/08 v8.0828 GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE	
int 	NLFitDlg::bottomTabSelToEnum(int nSel)
{
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	/*
	int		nOffset = m_NLF.IsShowFitPreview() ? 0 : 1;
	
	if ( NLF_FIT_CURVE_PREVIEW_TAB >= (nSel + nOffset) )
		return nSel;
	
	return nSel + nOffset;
	*/
	return nSel;
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
}
int 	NLFitDlg::bottomTabEnumToSel(int nEnum)
{
	/// Iris 2/28/2012 ORG-5146-P1 FIX_NLFITDLG_TAB_FLICKER_ISSUE
	/*
	if ( NLF_FIT_CURVE_PREVIEW_TAB >= nEnum )
		return nEnum;
	
	int nOffset = m_NLF.IsShowFitPreview() ? 0 : -1;
	return nEnum + nOffset;
	*/
	return nEnum;
	///End FIX_NLFITDLG_TAB_FLICKER_ISSUE
}
	/// end GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE

/// Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
bool NLFitDlg::isFactoryDefaultTheme()
{
	string	strTheme;
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//m_comboTheme.GetLBText(m_comboTheme.GetCurSel(), strTheme);
	strTheme = m_NLF.SPLGetCurThemeName();
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	
	return theme_is_factory_default(strTheme);
}

///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
BOOL	NLFitDlg::OnInitSize()
{
	return FALSE;
}
BOOL NLFitDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;

	lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
		
	SIZE sz;
	GetDlgOptimalSize(sz);
	//---- CPY 2/14/2007 NLFIT_OPENS_TO_TOP_LEFT_OUTSIDE_SCREEN
	// -1 is to indicate frame work to position to center of app frame
	//pSz->top = -sz.cy/2;
	//pSz->left = -sz.cx/2;
	pSz->top = -1;
	pSz->left = - 1;
	//----
	pSz->width = sz.cx;
	pSz->height = sz.cy;
	return TRUE;
}

bool	NLFitDlg::GetDlgOptimalSize(SIZE& sz)
{
	///------ Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	//sz.cx = 650;//500	///Jasmine 05/23/08 WIDTH_580_IS_NOT_ENOUGH_FOR_GERMAN_VERSION
	sz.cx = m_nOptimalWidth;
	///------ End DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	sz.cy = 600;
	return true;
}
///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS

///------ Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
int		NLFitDlg::getButtonIDs(vector<uint>& vnButtonIDs)
{
	/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	//vector<uint>	vnButtonIDs__ = { IDCANCEL,IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_SIMPLEX, IDC_NLF_PARAM_INIT, IDC_GROUP_GAP, IDC_NLF_QUICK_SET, IDC_NLF_SORT_PEAKS, IDC_NLF_REORDER_PEAKS, IDC_GROUP_GAP, IDC_NLF_SAVE_FDF, IDC_NLF_OPENFO, IDC_CHECK_AUTO_UPDATE};
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN	
	//vector<uint>	vnButtonIDs__ = { IDCANCEL,IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_SIMPLEX, IDC_NLF_PARAM_INIT, IDC_GROUP_GAP, IDC_NLF_SORT_PEAKS, IDC_NLF_REORDER_PEAKS, IDC_GROUP_GAP, IDC_NLF_SAVE_FDF, IDC_NLF_OPENFO, IDC_CHECK_AUTO_UPDATE};
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	//vector<uint>	vnButtonIDs__ = { IDCANCEL, IDC_NLF_DONE, IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_SIMPLEX, IDC_NLF_PARAM_INIT, IDC_GROUP_GAP, IDC_NLF_SORT_PEAKS, IDC_NLF_REORDER_PEAKS, IDC_GROUP_GAP, IDC_NLF_SAVE_FDF, IDC_NLF_OPENFO, IDC_CHECK_AUTO_UPDATE};
	vector<uint>	vnButtonIDs__ = { IDCANCEL, IDC_NLF_DONE, IDOK, 
									IDC_GROUP_GAP, IDC_GROUP_GAP,
									///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
									IDC_FITTING_DATA, IDC_GROUP_GAP,
									///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
									IDC_NLF_FIT, IDC_NLF_ONE_LTER, IDC_NLF_CHI_SQ, IDC_NLF_SIMPLEX, IDC_NLF_PARAM_INIT, 
									IDC_GROUP_GAP, 
									IDC_NLF_SORT_PEAKS, IDC_NLF_REORDER_PEAKS, 
									IDC_GROUP_GAP, 
									IDC_NLF_SAVE_FDF, 
#ifdef __NEW_FITTING_FUNCTION_WIZARD__
									IDC_NLF_NEWFO, 
#endif//__NEW_FITTING_FUNCTION_WIZARD__
									IDC_NLF_OPENFO, 
									IDC_CHECK_AUTO_UPDATE};
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	vnButtonIDs = vnButtonIDs__;
	return vnButtonIDs.GetSize();
}

void	NLFitDlg::calcOptimalWidth()
{
	vector<uint>		vnButtonIDs;
	int		nSize = getButtonIDs(vnButtonIDs);
	if ( nSize == 0 )
		return;
	
	RECT	rrRight;
	GetClientRect(GetItem(vnButtonIDs[0]), rrRight);
		
	ArrangeControlsRightLeft(vnButtonIDs, rrRight.right, rrRight.top);
	
	GetClientRect(GetItem(vnButtonIDs[0]), rrRight);
	RECT	rrLeft;
	Control	ctrl;
	do
	{
		ctrl = GetItem(vnButtonIDs[nSize-1]);
		--nSize;
	} while ( nSize >= 0 && !ctrl.Visible );
	GetClientRect(ctrl, rrLeft);
	
	/// Folger, 12/16/08, the optimal width is calculated by grouped buttons laid in the middle of dialog,
	/// later when add new buttons, need to adjust this formular for a better width
	m_nOptimalWidth = (rrRight.right - rrLeft.left) * (get_current_language() == ORESLANG_ENGLISH ? 1.6 : 1.75);
}
///------ End DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG

///------ Folger 06/03/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
void	NLFitDlg::UpdateDataCombo()
{
	int		nNumData = m_NLF.GetNumDataset();
	int		nOldSelected = m_comboData.GetCurSel();
	m_comboData.ResetContent();
	if ( nNumData > 1 )
	{
		for ( int ii=1; ii<=nNumData; ++ii )
		{
			m_comboData.AddString((string)ii);
		}
		if ( nOldSelected < 0 || nOldSelected >= nNumData )
			nOldSelected = 0;
		m_comboData.SetCurSel(nOldSelected);
	}
	///------ Folger 07/14/2011 ORG-3257-P1 NLFIT_SEELCT_DATA_TO_FIT_COMBO_TO_NARROW
	m_comboData.SetDroppedVisibleItemCount();
	///------ End NLFIT_SEELCT_DATA_TO_FIT_COMBO_TO_NARROW
}

int		NLFitDlg::GetCurrentFittingData(BOOL bZeroIfNoSepFit/* = FALSE*/)
{
	if ( !m_NLF.IsSepFit() )
		return bZeroIfNoSepFit ? 0 : -1;

	return m_comboData.GetCurSel();
}

BOOL	NLFitDlg::IsAllDataFitConverge()
{
	return m_NLF.IsAllDataFitConverged();
}
///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT

///------ Folger 10/14/2011 ORG-3257-P1 NLFIT_DATA_COMBO_BECOME_NARROW_AFTER_ROLL_UP
/// virtual
void	NLFitDlg::OnAfterRollup(BOOL bClose)
{
	if ( !bClose )
		m_comboData.SetDroppedVisibleItemCount();
}
///------ End NLFIT_DATA_COMBO_BECOME_NARROW_AFTER_ROLL_UP

static NLFitDlg s_NLFitDlg;

//typedef int (*FUNC_INT_DWORD) (int nMsg, DWORD dwCntrl);
int NLFitting(int nMsg, DWORD nOption = 0, LPVOID lpData = NULL)
{
	Window winDlg = s_NLFitDlg.GetWindow();
	if(OMSG_CLOSE == nMsg)
	{
		if(winDlg)
			DestroyWindow(winDlg.GetSafeHwnd());
		
		return 0;
	}
	
	if(winDlg)
	{
		out_str("Dialog already open");
		return -1;
	}
	
	return s_NLFitDlg.Create(GetWindow(), nOption);
}

///-----Kit 01/28/2011 ORG-2120-S2 USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB
//bool NLFitBox(TreeNode& trNode, TreeNode& trFDF, NLFitSession* pFitSession, HWND hWndParent, LPCSTR lpcszTitle, PEVENT_GETN pfn)// = NULL =NULL
bool NLFitBox(TreeNode& trNode, TreeNode& trFDF, NLFitSession* pFitSession, HWND hWndParent, LPCSTR lpcszTitle, PEVENT_GETN pfn, DWORD dwOption)// = NULL =NULL, =0
///-----
{	
	///-----Kit 01/28/2011 ORG-2120-S2 USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB
	//NLFitDlg	myDlg(pfn);
	NLFitDlg myDlg(pfn, dwOption);
	///-----
	int 		nRet = myDlg.DoModalEx(trNode, pFitSession, hWndParent, trFDF);
	
	return IDOK == nRet ? true : false;
}
