/*------------------------------------------------------------------------------*
 * File Name:NLFitParaControl.h													*
 * Creation: CPY 5/9/2008														*
 * Purpose: GridTableControl for NLFit Parameters								*
 * Copyright (c) Originlab Corp. 1992-1008										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 06/27/08 v8.0892 CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER		*
 *	Kyle 09/09/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL			*
 *	Kyle 09/10/08 CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW	*
 *	Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE									*
 *	Kyle 09/11/08 HIDE_SHARED_COL_WHEN_THERE_IS_SINGLE_DATE_SET					*
 *	Kyle 09/11/08 PARAMS_WITH_THE_SAME_NAME_ONLY_SHOW_THE_FIRST_ROW_WHEN_SHARED_COL_CHECKED
 *	Kyle 09/12/08 CHECK_BOUNDS_AND_CHANGE_COLOR_OF_LB_AND_UB					*
 *	Kyle 09/12/08 ADD_FUNCTION_TO_UPDATE_GRID_SHOW_AFTER_EDIT					*
 *	Kyle 09/19/08 SET_DISPLAY_SIGNIFICANT_DIGITS_COLUMN_AS_COMBO_BOX			*
 *	Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION								*
 *	Kyle 09/27/08 SET_BASE_LINE_PARAM_INDICES_TO_CONTROL						*
 *	Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
 *	Sophy 10/20/2008 NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON					*
 *	Folger 10/20/08 SHOW_PROPER_BOUNDS_VALUE_COLOR_WHEN_EDIT_BOUNDS_CONTROL		*
 *	Kyle 10/22/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL					*
 *	Folger 10/23/08 NEED_TO_RESIZE_ALL_COLUMNS_AFTER_UPDATE_GRID				*
 *	Iris 10/24/2008 QA80-12401-P1 FIX_SHOW_HIDDEN_ROWS_AFTER_QUICK_SET			*
 *	Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_FOR_REPLICA_AND_PA		*
 *	Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB						*
 *  Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON				*
 *  Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT					*
 *  Iris 10/29/2008 QA80-12401-P6 SET_USE_CHECK_DEFAULT_TO_FALSE				*
 *	Kyle 10/30/2008 QA80-12401-P9 QUICK_SET_DLG_GET_PARAMETER_NAEM				*
 *  Iris 10/30/2008 QA80-12401-P10 FIX_QUICK_SET_DLG_CLICK_OK_FAIL_WORK			*
 *	Kyle 11/01/2008 INIT_BOUND_VALUE_ONLY_WHEN_BOUND_OPTION_IS_CONSTANT			*
 *	Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE							*
 *	Kyle 11/04/2008 UPDATE_GRID_SETTING_TO_MANAGER								*
 *	Kyle 11/05/2008 GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU						*
 *	Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
 *	Kyle 11/14/2008 QUICK_SET_EXCEPT_P0_ALL_PARAMETERS_NAME_NEED_TO_TRIM_INDEX
 *	Kyle 11/22/2008 NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
 *	Sophy 12/3/2008 v8.0982 IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS	*
 *	Hong 12/10/08 v8.0984d IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO			*
 *	Hong 12/10/08 v8.0984d ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS				*
 *	Hong 12/11/08 QA80-12744-P1 v8.0985 KEEP_SELECTION_AFTER_GRID_UPDATE		*
 *	Folger 12/11/08 v8.0985 ADD_HELP_FOR_QUICK_SET_GETN_DIALOG					*
 *	Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL			*
 *  Iris 12/24/2008 FIX_QUICK_SET_CHANGED_BASELINE_PARAMS_SHARE_STATUS			*
 *	Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN		*
 *	Sophy 1/21/2009 v8.0962b SHOULD_CHECK_ROW_AND_COL_OFFSET					*
 *	Hong 01/22/09 FIX_FAIL_KEEP_SCROLL_POS_AFTER_OPERATE_APPLY_TO_ALL			*
 *	Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT				*
 *	Kyle 01/23/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL				*
 *	Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU				*
 *  Iris 2/05/2009 FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY					*
 *	Folger 02/18/09 QA80-13139 FITTING_DIALOG_GRID_NAVIGATE_TO_NEXT_CELL_AFTER_EDIT
 *	Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
 *	Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING		*
 *	Hong 03/05/09 FIX_APPLY_TO_ALL_LOST_VALUE_PRECISION							*
 *	Folger 03/06/09 FREE_LABEL_IN_SIGNIFICANT_DIGITS_COMBO_NOT_LOCALIZED		*
 *	Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
 *	Folger 04/02/08 PROPER_CHECKING_BEFORE_POPUP_COPYPASTE_ALL_MENU				*
 *	Hong 04/16/09 FIX_RESET_ALL_BOUNDS_NOT_UPDATE_BTN_STATUS_AND_FDF_CHANGED_STATUS
 *	Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS					*
 *	Folger 07/12/10 ORG-515-P1 COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
 *	Jasmine 07/15/10 ORG-486-S1 ADD_PEAK_ATTRIB_TO_NLFIT						*
 *  Bill 07/15/2010 ORG-576-P2 GET_THE_RIGHT_BOUNDS_CONTROL_STRING              *
 *  Jacky 07/16/10 ORG-589-P1 CENTRALIZE_CODE_MAKE_GRID_HEADERS_FOR_BOUNDS      *
 *  Jacky 7/19/2010 ORG-589-P2 REMOVE_THE_TOOLTIP_WHEN_BROWSING_OVER_CONTROLS   *
 *	Jasmine 07/22/10 ORG-589-P3 CHANGED_COLUMN_NAME_NEED_CONVERT				*
 *	Hong 09/03/10 ORG-576-S1 FIX_AMBIGUOUS_OVERLOAD								*
 *	Folger 11/08/2010 ORG-1169-S1 ADD_INPUT_DATA_RANGE_IN_NLFIT_PARAMETER_TABLE	*
 *	Folger 12/10/2010 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS			*
 *	Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
 *	Folger 12/29/2010 ORG-938-S1 SUPPORT_APPLY_FORMAT_TO_ALL_SAME_PREFIX		*
 *	Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE		*
 *	Folger 05/05/2011 ORG-2773-P1 CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
 *	Folger 05/19/2011 ORG-2773-P2 HIDE_PARAMS_DIALOG_FAILED_IN_NLFIT			*
 *	Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
 *	Folger 08/11/2011 ORG-2740-S5 PROPER_SEPARATOR_FOR_COPY_PARAM_VALUE_CONTEXT_MENU
 *	Folger 08/25/2011 ORG-2740-P7 ON_PARAM_COLUMN_CONTEXT_MENU_SHOULD_NOT_CHANGE_CURRECT_ACTIVE_DATASET
 *	Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN		*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#ifndef _NLF_PARAMS_CONTROL_H_
#define _NLF_PARAMS_CONTROL_H_

#ifndef _DBINT
#define _DBINT(_STR, _INT)	//out_int(_STR, _INT);
#define _DBSTR(_STR)		//out_str(_STR);
#define _DBPRINTF(_FMT, _ARG)	//printf(_FMT, _ARG);
#endif

/// Hong 12/10/08 v8.0984d IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO
//#define STR_NLFIT_PARACONTRO_GRID_COLS _L("NO.|Peak Type|Param|Meaning|Share|Fixed|Value|Error|Dependency|Lower Conf Limits|Upper Conf Limits|Significant Digits|LB Value|LB Control|Param|UB Control|UB Value") /// AW 10/26/07 WRONG_LOCALIZE_MACRO
///------ Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
//#define STR_NLFIT_PARACONTRO_GRID_COLS _L("NO.|Peak Type|Param|Meaning|Share|Fixed|Value|Error|Dependency|Lower Conf Limits|Upper Conf Limits|Significant Digits|LB Value|LB|Param|UB|UB Value") /// AW 10/26/07 WRONG_LOCALIZE_MACRO
///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
//#define STR_NLFIT_PARACONTRO_GRID_COLS_E	"NO.|Peak Type|Param|Meaning|Share|Fixed|Value|Error|Dependency|Lower Conf Limits|Upper Conf Limits|Significant Digits|LB Value|LB|Param|UB|UB Value" /// AW 10/26/07 WRONG_LOCALIZE_MACRO
///Jasmine 07/15/10 ORG-486-S1 ADD_PEAK_ATTRIB_TO_NLFIT
//#define STR_NLFIT_PARACONTRO_GRID_COLS_E	"NO.|Peak Type|Param|Unit|Meaning|Share|Fixed|Value|Error|Dependency|Lower Conf Limits|Upper Conf Limits|Significant Digits|LB Value|LB|Param|UB|UB Value" /// AW 10/26/07 WRONG_LOCALIZE_MACRO
//--- Jacky 07/16/10 ORG-589-P1 CENTRALIZE_CODE_MAKE_GRID_HEADERS_FOR_BOUNDS
//#define STR_NLFIT_PARACONTRO_GRID_COLS_E	"NO.|Peak Type|Param|Unit|Meaning|Share|Fixed|Value|Error|Dependency|Lower Conf Limits|Upper Conf Limits|Significant Digits|LB Value|LB|Param|UB|UB Value|Peak Attribute"
///------ Folger 11/08/2010 ORG-1169-S1 ADD_INPUT_DATA_RANGE_IN_NLFIT_PARAMETER_TABLE
//#define STR_NLFIT_PARACONTRO_GRID_COLS_E	"NO.|Peak Type|Param|Unit|Meaning|Share|Fixed|Value|Error|Dependency|Lower Conf Limits|Upper Conf Limits|Significant Digits|Lower Bounds|< or <=|Param|< or <=|Upper Bounds|Peak Attribute"
#define STR_NLFIT_PARACONTRO_GRID_COLS_E	"NO.|Peak Type|Param|Unit|Meaning|Share|Fixed|Value|Error|Dependency|Lower Conf Limits|Upper Conf Limits|Significant Digits|Lower Bounds|< or <=|Param|< or <=|Upper Bounds|Peak Attribute|Data Range"
///------ End ADD_INPUT_DATA_RANGE_IN_NLFIT_PARAMETER_TABLE
//--- end CENTRALIZE_CODE_MAKE_GRID_HEADERS_FOR_BOUNDS
///End ADD_PEAK_ATTRIB_TO_NLFIT
///End ADD_UNIT_FOR_PARAMETER_SETTINGS
#define STR_NLFIT_PARACONTRO_GRID_COLS		_L(STR_NLFIT_PARACONTRO_GRID_COLS_E)
///------ End PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
/// end IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO

enum 
{
	GROUP_ALL = -1,
	GROUP_NORMAL,
	GROUP_BOUNDS
};

#define	RESERVED_SETTINGS_TAB		_L("Settings")
#define	RESERVED_CODE_TAB			_L("Code")

#define STR_BOUND_VALUE_TOOLTIP _L("Double click to set LB, UB settings")		///Kyle 01/23/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL

///------ Folger 03/06/09 FREE_LABEL_IN_SIGNIFICANT_DIGITS_COMBO_NOT_LOCALIZED
//#define 	STR_SIGN_DIGITES_LIST	"#0;Free|#1;1|#2;2|#3;3|#4;4|#5;5|#6;6|#7;7|#8;8|#9;9|#10;10|#11;11|#12;12|#13;13|#14;14|#15;15"
#define 	STR_SIGN_DIGITES_LIST_WITHOUT_FREE	"#1;1|#2;2|#3;3|#4;4|#5;5|#6;6|#7;7|#8;8|#9;9|#10;10|#11;11|#12;12|#13;13|#14;14|#15;15"
///------ End FREE_LABEL_IN_SIGNIFICANT_DIGITS_COMBO_NOT_LOCALIZED

#define 	STR_BOUNDS_CONTROL_LIST	"#0;<=|#1;<|#2;Disable"

/// Hong 12/10/08 v8.0984d IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO
//#define		STR_BUTTON_CONTROL_COMBOLIST "<=|<|NA" ///Sophy 5/20/2008 GRID_SUPPORT_BUTTON_TYPE_COL
//
//#define		STR_BOUNDS_CONTROL_DISABLE		"NA"
#define		STR_BUTTON_CONTROL_COMBOLIST "<=|<| " ///Sophy 5/20/2008 GRID_SUPPORT_BUTTON_TYPE_COL

#define		STR_BOUNDS_CONTROL_DISABLE		" "
/// end IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO

#define WM_USER_TREEEDITOR_FO_CHANGE	(WM_USER + 1004)
#define WM_USER_NLF_HIDE_DLG		(WM_USER + 1005)
//--- CPY 10/26/04 NLF_PARAS_EDIT_CLEANUP
#define WM_USER_NLF_ON_PARAM_CHANGE	(WM_USER + 1010)
#define WPARAM_PARAM_CHANGE_BY_USER			0x1000
#define WPARAM_PARAM_CHANGE_BY_FUNC_CHANGE	0x2000
//----

///Arvin 03/26/08 RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
#define		WPARAM_REPLICA_ACTIVE_MSG_TAB	0x1000
///end RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK

#define WM_USER_NLF_UPDATE_FDF_FILE_VALUE  (WM_USER + 1140) //---- CPY 5/24/07 FO_COMPILE_ERR_MOVED_WM_USER_EVENT_ID, I have moved this from NLFitting.c

#define WM_USER_NLF_QUICK_SET_PARAMETER_VALUE_CHANGE (WM_USER + 1141)		///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE

#define WM_USER_NLF_RESET_BOUNDS			(WM_USER + 1142) /// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU

/// Iris 2/05/2009 FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY
/*
//------ Folger 04/30/08 QA80-11479 CENTRALIZE_HIDE_PARAMETER_DIALOG_TITLE_AND_DESCRIPTION
///Sophy 12/3/2008 v8.0982 IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS
//#define STR_HIDE_PARAMETERS_DIALOG_TITLE		_L("Hide")
#define STR_HIDE_PARAMETERS_DIALOG_TITLE		_L("Hide Parameters with Following Prefixs:")
///end IMPROVE_PARAM_SETTING_DIALOG_GIVE_REASONAL_HINTS
#define STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION	_L("To hide parameters")
//------
*/
#define STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION		_L("Hide Parameters with Following Prefixes")
#define STR_HIDE_PARAMETERS_DIALOG_TITLE			_L("Hide Parameters")
///end FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY

///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF 
enum{
	NLF_NO_CHANGED = 0x000,
	NLF_CODE_CHANGED = 0x001,
	NLF_PARAMTERS_BOUNDS_SETTING_CHANGED = 0x002,
};
///End ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF

/// Hong 04/23/08 QA80-11466 THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
enum
{
	NLF_FDF_CHANGE_FROM_FUNCTION	= 0x001,
	NLF_FDF_CHANGE_FROM_THEME		= 0x002,
};
/// end THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF


///Cheney 2006-10-30 CHANGE_INCORRECT_BOUND_TO_RED_COLOR
#define STR_DASH_DASH 	"--"
#define COLOR_RED 		250
#define COLOR_BLACK 	0
#define GRID_COLUMNS	5
///end CHANGE_INCORRECT_BOUND_TO_RED_COLOR
#define COLOR_GRAY		RGB(200,200,200)	///Jasmine 05/26/06 SET_CELL_DISABLE_AND_GRAY

#define		STR_SORT_PEAKS		_L("Sort Peaks")		//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_FOR_REPLICA_AND_PA

//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
#define		STR_REORDER_PEAKS	_L("Reorder Peaks")
//------

#define STR_TAG_GRID_CONTROL_OBJ		"GridControlObj" /// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON

//---Jasmine 10/30/08 QA80-12425 THE_NAMEDUP_COL_NEED_A_UNIQUE_NAME_IN_CONFIGURATION
static string _get_alias(LPCSTR lpcszName)
{
	string strAlias = lpcszName;
	strAlias += "2";
	return strAlias;
}
//---

///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
typedef struct tagOnContextMenuMore 
{
	BOOL	bAllowShared;
	int		nDatasetEdited;
	///------ Folger 08/25/2011 ORG-2740-P7 ON_PARAM_COLUMN_CONTEXT_MENU_SHOULD_NOT_CHANGE_CURRECT_ACTIVE_DATASET
	int		nActiveDataset;
	///------ End ON_PARAM_COLUMN_CONTEXT_MENU_SHOULD_NOT_CHANGE_CURRECT_ACTIVE_DATASET

}OnContextMenuMore, *POnContextMenuMore;
///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT

class NLFParamsControl : public GridTableControl
{

public:
	NLFParamsControl()
	{		
	}
	
	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	~NLFParamsControl()
	{
		if (isParameterTabDraggable())
		{
			SaveColsOrder();
			delete m_colMap;
		}
	}
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
	
	//virtual void Init(int nID, Dialog& dlg,LPCSTR lpcszDlgName)///Jasmine 05/18/10 ORG-2 CHANGE_DLG_TYPE_FOR_PROPERTY_PAGE
	virtual void Init(int nID, WndContainer& dlg,LPCSTR lpcszDlgName)
	{
		GridTableControl::Init(nID, dlg, lpcszDlgName);
		
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		if (isParameterTabDraggable())
		{
			SetExplorerBar(flexExMove);
			InitMoveColHelper();
		}
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		/// Hong 12/10/08 v8.0984d IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO
		m_flx.ExtendLastCol = false;
		// end IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO
		SetCols(NLPARAMGRIDCOLTYPE_TOTAL);
		
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		SetColHeaders(STR_NLFIT_PARACONTRO_GRID_COLS);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		SetColHeaderString(STR_NLFIT_PARACONTRO_GRID_COLS);
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		
		//--- Jacky 07/16/10 ORG-589-P1 CENTRALIZE_CODE_MAKE_GRID_HEADERS_FOR_BOUNDS
		string strOperaters;
		strOperaters.Format("< %s <=", _L("or")); //since localization will trim the white space prefix this token, while vsFlex NOT allow '<' as leading character when parsing tokens for column headers
												  //we have to make this workaround by separately set one column header, this is reasonable since "< or <=" doesn't need to be localized.
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		SetColHeading(GetColPos(NLPARAMGRIDCOLTYPE_LB_CONTROL), strOperaters);
		SetColHeading(GetColPos(NLPARAMGRIDCOLTYPE_UB_CONTROL), strOperaters);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		SetColHeading(NLPARAMGRIDCOLTYPE_LB_CONTROL, strOperaters);
		SetColHeading(NLPARAMGRIDCOLTYPE_UB_CONTROL, strOperaters);
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		//--- end CENTRALIZE_CODE_MAKE_GRID_HEADERS_FOR_BOUNDS
		
		//---Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
		//vector<int> vnParamValsColList, vnBoundsColList;
		//initGroupColList(GROUP_NORMAL, vnParamValsColList);
		//initGroupColList(GROUP_BOUNDS, vnBoundsColList);
			//
		//AddGroup(vnParamValsColList);
		//AddGroup(vnBoundsColList);
		//---end
		
		SetupColTypes();
		
		///------ Folger 03/06/09 FREE_LABEL_IN_SIGNIFICANT_DIGITS_COMBO_NOT_LOCALIZED
		//m_flx.ColComboList(NLPARAMGRIDCOLTYPE_SD) = STR_SIGN_DIGITES_LIST;			///Kyle 09/19/08 SET_DISPLAY_SIGNIFICANT_DIGITS_COLUMN_AS_COMBO_BOX
		string		strFree;
		/// Hong 01/23/10, see http://wiki.originlab.com/~originla/internal/index.php?title=Sales_Talk:Vertical_Cursor#Noho_1.2F20.2F10, Point 5.
		//strFree.Format("#0;%s|", _L("Free"));
		strFree.Format("#0;%s|", E_SYSTEM);
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__		
		SetColComboList(GetColPos(NLPARAMGRIDCOLTYPE_SD), strFree + STR_SIGN_DIGITES_LIST_WITHOUT_FREE);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		SetColComboList(NLPARAMGRIDCOLTYPE_SD, strFree + STR_SIGN_DIGITES_LIST_WITHOUT_FREE);
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		///------ End FREE_LABEL_IN_SIGNIFICANT_DIGITS_COMBO_NOT_LOCALIZED
	}	
	
	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	virtual bool isParameterTabDraggable()
	{
		return true;
	}
	
	void InitMoveColHelper()
	{
		m_colMap = new MoveColHelper();

		InitColsOrder();
	}
	
	int GetColPos(int nType)
	{
		if (isParameterTabDraggable())
			return m_colMap->GetColPos(nType); 
		else
			return nType + GetColOffset();
	}
	
	int GetColType(int nPosition)
	{ 
		if (isParameterTabDraggable())
			return m_colMap->GetColType(nPosition);
		else
			return nPosition - GetColOffset();
	}
	
	void OnAfterMoveColumns(Control ctrl, long lCol, long *pnPosition) 
	{ 
		if (isParameterTabDraggable())		
		{		
			/// Bill 08/23/2011 ORG-2473-P3 NO_NEED_CHANGE_THE_SAVED_SHOW_HIDE_BIT
			//for (int nGroup = 0 ; nGroup < GetNumGroups() ; ++nGroup)
			//{
			//	vector<int>  vnGroupIndices;
			//	vector<byte> vbGroupShows;
			//	
			//	GetGroupColShows(nGroup, vnGroupIndices, vbGroupShows);
			//	
			//	int nShow = vbGroupShows[lCol];
			//	vbGroupShows.RemoveAt(lCol);
			//	vbGroupShows.InsertAt(*pnPosition, nShow);
			//	
			//	SetGroupColShows(nGroup, vnGroupIndices, vbGroupShows);
			//}
			/// End NO_NEED_CHANGE_THE_SAVED_SHOW_HIDE_BIT
			
			m_colMap->OnAfterMoveColumns(lCol, pnPosition);
		}
	}
	
	void InitColsOrder()
	{
		m_colMap->m_vnColMap.Data(0 , NLPARAMGRIDCOLTYPE_TOTAL - 1);
			
		string strVal;
		if( dlg_load_registry(GetDlgNameForRegistry(), "ColOrder", strVal) && !strVal.IsEmpty() )
		{
			vector<string> vsTemp;
			strVal.GetTokens(vsTemp, '|');
			convert_string_vector_to_uint_vector(vsTemp, m_colMap->m_vnColMap);
		}
	}
	
	void SaveColsOrder()
	{	
		vector<string> vsTemp;
		convert_uint_vector_to_string_vector(m_colMap->m_vnColMap, vsTemp);
	
		string strVal;
		strVal.SetTokens(vsTemp, '|');
	
		dlg_save_to_registry(GetDlgNameForRegistry(), "ColOrder", strVal);		
	}
	
	void SetColHeaders(LPCSTR lpczHeading)
	{
		if (isParameterTabDraggable())
		{
			vector<string> vstrListHeading;
			str_separate(lpczHeading, "|", vstrListHeading);
			vstrListHeading.Reorder(m_colMap->m_vnColMap);
			
			SetColHeader( str_combine(vstrListHeading, "|") );
		}
		else
		{
			SetColHeaderString(lpczHeading);
		}
	}
	
	virtual void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel )
	{
		if (!isParameterTabDraggable())
		{
			GridTableControl::OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
		}
		///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
		//else
		//{
		//	if(nButton == MK_RBUTTON && nShift == 0)
		//	{
		//		int    nx = XTwipsToPixels(X);
	 //       	int    ny = YTwipsToPixels(Y);
	 //       	ClientToScreen(nx, ny);
	 //       	doDraggableShowHideColMenu(nx, ny);
	 //    	}
		//}
		///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	}

	///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	void		ShowHeaderMenu(int nx, int ny)
	{
		doDraggableShowHideColMenu(nx, ny);
	}
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	
	/// Bill 08/11/2011 ORG-2473-P2 SHOW_DEFAULT_COLS_ERROR
	virtual void SetHiddenCols(const vector<byte>& vbCols, bool bDefault = true)
	{
		if (isParameterTabDraggable())
		{
			for(int nColType = 0 ; nColType < m_flx.Cols ; ++nColType)
			{
				bool bHide = bDefault;
				if(nColType < vbCols.GetSize())
					bHide = vbCols[nColType];
				
				int nColPos = GetColPos(nColType);
				HideCol(nColPos, bHide);
			}
		}
		else
		{
			GridControl::SetHiddenCols(vbCols, bDefault);
		}		
	}
	/// End SHOW_DEFAULT_COLS_ERROR
	
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

	/// Iris 10/30/2008 v8.0963b DISABLE_BASELINE_PARAMETER_SHARE_CELL
	/////Kyle 09/27/08 SET_BASE_LINE_PARAM_INDICES_TO_CONTROL
	//void SetBaselineParamIndices(vector<int> &vnIndices)
	//{
		//m_vnBaseLineParamIndices = vnIndices;
	//}
	/////End SET_BASE_LINE_PARAM_INDICES_TO_CONTROL
	///end DISABLE_BASELINE_PARAMETER_SHARE_CELL
	
	bool	ConvertIndexToValue( vector<string>& vsValues, LPCSTR lpcszList )
	{
		string	strList(lpcszList);
		int		ii;
		
		for( ii = 0; ii < vsValues.GetSize(); ii++)
		{
			vsValues[ii] = strList.GetToken( atoi(vsValues[ii] ), '|');
		}
		
		return true;
	}

	///Sophy 10/20/2008 NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON
	bool	ConvertValueToIndex( LPCSTR lpcszList, LPCSTR lpcszValue, int& nValue )
	{
		string	strList( lpcszList );
		nValue = strList.FindToken( lpcszValue, '|' );
		
		return ( nValue >= 0 );
	}
	///end NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON
	
	bool	SetupColumnValues()
	{
		vector<string>	vsValues;
		int				ii;
		bool			bSetRows = false;
		
		for( ii = 0; ii < NLPARAMGRIDCOLTYPE_TOTAL; ii++)
		{
			/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			int nColPos = GetColPos(ii);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			int nColPos = ii;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
			
			///------ Folger 12/14/2010 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
			if ( NLPARAMGRIDCOLTYPE_VALUE == ii
				|| NLPARAMGRIDCOLTYPE_UB == ii
				|| NLPARAMGRIDCOLTYPE_LB == ii
				|| NLPARAMGRIDCOLTYPE_ERROR == ii
				|| NLPARAMGRIDCOLTYPE_LCL == ii
				|| NLPARAMGRIDCOLTYPE_UCL == ii
				)
			{
				GetColumnEx(vsValues, ii);
				SetCells(vsValues, nColPos);
				continue;
			}
			///------ End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS

			if( m_pNLParamsMngr->GetColumn(ii, vsValues) < 0 )
			{
				ASSERT( 0 );
				continue;
			}
			
			if(!bSetRows)
			{
				CheckExpandRows(vsValues.GetSize() - 1);
				bSetRows = true;
			}
			
			if( NLPARAMGRIDCOLTYPE_LB_CONTROL == ii || NLPARAMGRIDCOLTYPE_UB_CONTROL == ii )
			{
				ConvertIndexToValue(vsValues, STR_BUTTON_CONTROL_COMBOLIST);
			}
			
			SetCells(vsValues, nColPos);
		}
		return true;
	}
	
	/// Hong 06/27/08 v8.0892 CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER
	//virtual bool Update(int nNumParaInFunc, int nNumDataSets = -1)
	///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
	//virtual bool Update()
	/// Hong 01/22/09 FIX_FAIL_KEEP_SCROLL_POS_AFTER_OPERATE_APPLY_TO_ALL
	//virtual bool Update(bool bIsAllowSharing)
	// Hong, no one overwrite this function, so remove virutal 
	///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	//bool Update(bool bIsAllowSharing, bool bClearAll = true)
	bool Update(bool bIsAllowSharing, bool bClearAll = true, int nActiveDataset = -1)
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	/// end FIX_FAIL_KEEP_SCROLL_POS_AFTER_OPERATE_APPLY_TO_ALL
	///End USE_ISALLOWSHARING_IN_NLFSESSION
	/// end CLEAN_GRID_CONTROL_DEPENDENT_ON_PARAMETER_MANAGER
	{
		/// Iris 10/24/2008 QA80-12401-P1 FIX_SHOW_HIDDEN_ROWS_AFTER_QUICK_SET
		// save row hide status and then apply back below after clear 
		vector<int> vnRowsHide;
		GetRowsHide(vnRowsHide);
		///end FIX_SHOW_HIDDEN_ROWS_AFTER_QUICK_SET

		/// Hong 12/11/08 QA80-12744-P1 v8.0985 KEEP_SELECTION_AFTER_GRID_UPDATE
		int			nX, nY, nRow, nCol;
		bool		bHasSelection = GetSelCell(nX, nY, nRow, nCol);

		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nPeakNOCol = GetColPos(NLPARAMGRIDCOLTYPE_PEAK_NO);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nPeakNOCol = NLPARAMGRIDCOLTYPE_PEAK_NO + GetColOffset();
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		string		strPeakNO = GetCell(nRow, nPeakNOCol);
		/// end KEEP_SELECTION_AFTER_GRID_UPDATE
		if ( bClearAll ) /// Hong 01/22/09 FIX_FAIL_KEEP_SCROLL_POS_AFTER_OPERATE_APPLY_TO_ALL
			ClearAll();
		
		// update param values to grid
		SetupColumnValues();
		
		vector<int> 	vnBegins;
		if( m_pNLParamsMngr->GetGroupingRowsBegin(vnBegins) > 0 )
		{
			ShowAlternateGroups(vnBegins);
		}

		///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		UpdateActiveDatasetBKColor(nActiveDataset);
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT

		m_bIsAllowSharing = bIsAllowSharing;		///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
		
		updateSharedRowsShow();		///Kyle 09/11/08 PARAMS_WITH_THE_SAME_NAME_ONLY_SHOW_THE_FIRST_ROW_WHEN_SHARED_COL_CHECKED
		/// Iris 10/30/2008 v8.0963b DISABLE_BASELINE_PARAMETER_SHARE_CELL, just same as SR4
		//updateBoundCellsColor();		///Kyle 09/12/08 CHECK_BOUNDS_AND_CHANGE_COLOR_OF_LB_AND_UB
		updateCellsColor();
		///end DISABLE_BASELINE_PARAMETER_SHARE_CELL
		
		ResizeCols();					//------ Folger 10/23/08 NEED_TO_RESIZE_ALL_COLUMNS_AFTER_UPDATE_GRID
		
		/// Iris 10/24/2008 QA80-12401-P1 FIX_SHOW_HIDDEN_ROWS_AFTER_QUICK_SET
		if( vnRowsHide.GetSize() > 0 )
			HideParamRows(vnRowsHide);
		///end FIX_SHOW_HIDDEN_ROWS_AFTER_QUICK_SET
		
		/// Hong 12/11/08 QA80-12744-P1 v8.0985 KEEP_SELECTION_AFTER_GRID_UPDATE		
		if ( bHasSelection && nRow < GetRows() )
		{		
			/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			int nPeakNoCol = GetColPos(NLPARAMGRIDCOLTYPE_PEAK_NO);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			int nPeakNoCol = NLPARAMGRIDCOLTYPE_PEAK_NO + GetColOffset();
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

			if ( 0 != strPeakNO.Compare(GetCell(nRow, nPeakNoCol)) )
			{
				vector<string>			vsColVals;
				GetColValues(nPeakNoCol, vsColVals, GetRowOffset());
				nRow = vsColVals.Find(strPeakNO);
				if ( nRow >= 0 )
					nRow += GetRowOffset();
			}
			if ( nRow >= GetRowOffset() )
				m_flx.Select(nRow, nCol);
		}
		/// end KEEP_SELECTION_AFTER_GRID_UPDATE
		
		return true;
	}	
	
	/// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
	int OnQuickSetApply(TreeNode& trParam)
	{
		int		nUpdateParts = 0;
		
		string strParamName = trParam.name.strVal;
		if(strParamName.IsEmpty())
			return 0;

		/// Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT
		//if(m_bIsAllowSharing && !is_optional_by_dyna_use_checkbox(trParam.share))
		if(QuickSetIsShowShareCol() && !is_optional_by_dyna_use_checkbox(trParam.share))
		///end NOT_SHOW_SHARE_COL_FOR_NLFIT
		{
			/// Iris 12/24/2008 FIX_QUICK_SET_CHANGED_BASELINE_PARAMS_SHARE_STATUS			
			vector<int> vnBaselineParamIndices;
			vnBaselineParamIndices.Data(0, getNumberBaselineParams()-1, 1);
			///end FIX_QUICK_SET_CHANGED_BASELINE_PARAMS_SHARE_STATUS
			
			string strList = STR_SHARE_GROUP_LIST;
			vector<string> vsList;
			strList.GetTokens(vsList, '|');
			ASSERT(vsList.GetSize()>0);
			int nShare = trParam.share.nVal;
			if(nShare>=0 && nShare<vsList.GetSize())	
			{
				/// Iris 12/24/2008 FIX_QUICK_SET_CHANGED_BASELINE_PARAMS_SHARE_STATUS			
				// to skip the index saved in vnBaselineParamIndices
				//nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_SHARE, strParamName, nShare);
				nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_SHARE, strParamName, nShare, NLPARAMETER_BOUNDS_SET_BY_CONSTANT, &vnBaselineParamIndices);
				///end FIX_QUICK_SET_CHANGED_BASELINE_PARAMS_SHARE_STATUS
			}		
		}
	
		if(!is_optional_by_dyna_use_checkbox(trParam.fix))
		{
			nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_FIXED, strParamName, trParam.fix.nVal);
		}

		if(!is_optional_by_dyna_use_checkbox(trParam.value))
		{
			nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_VALUE, strParamName, trParam.value.dVal);
		}

		if(!is_optional_by_dyna_use_checkbox(trParam.lowerbound))
		{
			if(trParam.lowerbound.boundoption.nVal==NLPARAMETER_BOUNDS_SET_BY_RELATIVE_OFFSET && trParam.lowerbound.boundvalue.dVal<0)
				error_report("lower bound value error");
			else
				nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_LB, strParamName, trParam.lowerbound.boundvalue.dVal, trParam.lowerbound.boundoption.nVal);
		}

		if(!is_optional_by_dyna_use_checkbox(trParam.upperbound))
		{
			if(trParam.upperbound.boundoption.nVal==NLPARAMETER_BOUNDS_SET_BY_RELATIVE_OFFSET && trParam.upperbound.boundvalue.dVal<0)
				error_report("lower bound value error");
			else
				nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_UB, strParamName, trParam.upperbound.boundvalue.dVal, trParam.upperbound.boundoption.nVal);
		}

		if(!is_optional_by_dyna_use_checkbox(trParam.lowerboundctrl))
		{
			nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_LB_CONTROL, strParamName, trParam.lowerboundctrl.nVal);
		}
		
		if(!is_optional_by_dyna_use_checkbox(trParam.upperboundctrl))
		{
			nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_UB_CONTROL, strParamName, trParam.upperboundctrl.nVal);
		}
		/// Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT
		//Update(m_bIsAllowSharing);	
		/// Hong 01/22/09 FIX_FAIL_KEEP_SCROLL_POS_AFTER_OPERATE_APPLY_TO_ALL
		//Update(QuickSetIsShowShareCol());
		Update(QuickSetIsShowShareCol(), false);
		/// end FIX_FAIL_KEEP_SCROLL_POS_AFTER_OPERATE_APPLY_TO_ALL
		///end NOT_SHOW_SHARE_COL_FOR_NLFIT
		
		///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
		if(nUpdateParts>0)
		{
			Window wnd( GetDlgSafeHwnd() );
			wnd.SendMessage(WM_USER_NLF_QUICK_SET_PARAMETER_VALUE_CHANGE, nUpdateParts);
		}
		///End QUICK_SET_PARAMETERS_VALUE_CHANGE

		return nUpdateParts;
	}
	
	bool OnQuickSetChanged(TreeNode& tr, int nRow)
	{
		TreeNode trChangedNode = tree_get_node(tr, nRow);
		if( trChangedNode && 0 == trChangedNode.tagName.Compare("name") )
		{
			QuickSetParamInitValue(tr, trChangedNode.strVal);
			return true;
		}
			
		TreeNode trRoot = m_trQuickSet.FirstNode;
		trRoot.Replace(tr.Clone());
		
		return true;
	}
	///end QUICK_SET_DLG_ADD_APPLY_BUUTON
	
	#define STR_BOUND_OPTIONS _L("Constant|Relative Percentage (%)|Relative Value")	
	///Kyle  10/22/08  QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	int		OnQuickSetParam(Control ctrl)
	{
		if( m_trQuickSet.IsEmpty() )
		{
			TreeNode trParam = m_trQuickSet.AddNode();
			//------ Folger 12/11/08 v8.0985 ADD_HELP_FOR_QUICK_SET_GETN_DIALOG
			trParam.SetAttribute(STR_HELPID_ATTRIB, IDD_NLSF_QUICK_SET);
			//------
			GETN_USE(trParam)
			GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
			GETN_STR(name, _L("Param Name"), "")
			/// Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT
			//if(m_bIsAllowSharing)
			if(QuickSetIsShowShareCol())
			///end NOT_SHOW_SHARE_COL_FOR_NLFIT
			{
				GETN_COMBO(share, _L("Share"), 0, STR_SHARE_GROUP_LIST)
			}
			GETN_CHECK(fix, _L("Fixed"), false)						
			GETN_NUM(value, _L("Value"), 100.0)						
			
			/// Hong 12/10/08 v8.0984d IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO
			//GETN_LIST(lowerboundctrl, _L("LB Control"), 0, STR_BUTTON_CONTROL_COMBOLIST)
			GETN_LIST(lowerboundctrl, _L("LB"), 0, STR_BUTTON_CONTROL_COMBOLIST)
			/// end IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO
			GETN_BEGIN_BRANCH(lowerbound, _L("LB Value")) 
				/// Iris 10/24/2008 v8.0960 CHANGE_LABELS_FOLLOW_Easwar_SUGGESTION, Change options label and keep value lable for all option cases
				//GETN_RADIO_INDEX(boundoption, 0, _L("Constant|By percentage of current value(%)|By fixed amount below current value")) 
				//	GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT) GETN_OPTION_EVENT_EX(_bound_option_event)
				///end CHANGE_LABELS_FOLLOW_Easwar_SUGGESTION
				GETN_RADIO_INDEX(boundoption, 0, STR_BOUND_OPTIONS)
				GETN_NUM(boundvalue, _L("Value"), 0.0)
			GETN_END_BRANCH(lowerbound)
			
			/// Hong 12/10/08 v8.0984d IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO
			//GETN_LIST(upperboundctrl, _L("UB Control"), 0, STR_BUTTON_CONTROL_COMBOLIST)
			GETN_LIST(upperboundctrl, _L("UB"), 0, STR_BUTTON_CONTROL_COMBOLIST)
			/// end IMPROVE_PARAMS_GRID_GUI_SUGGESTED_BY_US_DEMO
			GETN_BEGIN_BRANCH(upperbound, _L("UB Value")) 
				/// Iris 10/24/2008 v8.0960 CHANGE_LABELS_FOLLOW_Easwar_SUGGESTION
				//GETN_RADIO_INDEX(boundoption, 0, _L("Constant|By percentage of current value(%)|By fixed amount above current value")) //a bit diff from str above
				//	GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT) GETN_OPTION_EVENT_EX(_bound_option_event) 
				///end CHANGE_LABELS_FOLLOW_Easwar_SUGGESTION
				GETN_RADIO_INDEX(boundoption, 0, STR_BOUND_OPTIONS)
				GETN_NUM(boundvalue, _L("Value"), 0.0)
			GETN_END_BRANCH(upperbound)
			
			for(TreeNode trNode = trParam.FirstNode; ; )
			{
				trNode = trNode.NextNode;
				if( !trNode.IsValid() )
					break;
				/// Iris 10/29/2008 QA80-12401-P6 SET_USE_CHECK_DEFAULT_TO_FALSE
				//trNode.SetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, true);
				trNode.SetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, false);
				///end SET_USE_CHECK_DEFAULT_TO_FALSE
			}
		}
		
		TreeNode trParam = m_trQuickSet.FirstNode;
		QuickSetParamInitValue(trParam);
	
		/// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
		ODWP dwPtr = (ODWP)this;		
		NLFParamsControl* pControl = (NLFParamsControl*)dwPtr;
		TreeNode trControlObj = tree_check_get_node(trParam, STR_TAG_GRID_CONTROL_OBJ);
		trControlObj.oipVal = dwPtr;
		trControlObj.Show = false;
		///end QUICK_SET_DLG_ADD_APPLY_BUUTON
		
		/// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
		//if( GetNBox(trParam, "Quick Set", "Apply to all parameters with same base name") )
		if( GetNBox(trParam, quick_set_event_func, _L("Quick Set"), _L("Apply to all parameters with same base name"), GetDlgSafeHwnd(), true) )
 		///end QUICK_SET_DLG_ADD_APPLY_BUUTON
		{
			/// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
			/*
			int		nUpdateParts = 0;
			
			string strParamName = trParam.name.strVal;
			if(strParamName.IsEmpty())
				return 0;

			if(m_bIsAllowSharing && !is_optional_by_dyna_use_checkbox(trParam.share))
			{
				string strList = STR_SHARE_GROUP_LIST;
				vector<string> vsList;
				strList.GetTokens(vsList, '|');
				ASSERT(vsList.GetSize()>0);
				int nShare = trParam.share.nVal;
				if(nShare>=0 && nShare<vsList.GetSize())			
					nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_SHARE, strParamName, nShare);
			}
	
			if(!is_optional_by_dyna_use_checkbox(trParam.fix))
			{
				nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_FIXED, strParamName, trParam.fix.nVal);
			}
	
			if(!is_optional_by_dyna_use_checkbox(trParam.value))
			{
				nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_VALUE, strParamName, trParam.value.dVal);
			}
	
			if(!is_optional_by_dyna_use_checkbox(trParam.lowerbound))
			{
				if(trParam.lowerbound.boundoption.nVal==NLPARAMETER_BOUNDS_SET_BY_RELATIVE_OFFSET && trParam.lowerbound.boundvalue.dVal<0)
					error_report("lower bound value error");
				else
					nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_LB, strParamName, trParam.lowerbound.boundvalue.dVal, trParam.lowerbound.boundoption.nVal);
			}
	
			if(!is_optional_by_dyna_use_checkbox(trParam.upperbound))
			{
				if(trParam.upperbound.boundoption.nVal==NLPARAMETER_BOUNDS_SET_BY_RELATIVE_OFFSET && trParam.upperbound.boundvalue.dVal<0)
					error_report("lower bound value error");
				else
					nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_UB, strParamName, trParam.upperbound.boundvalue.dVal, trParam.upperbound.boundoption.nVal);
			}
	
			if(!is_optional_by_dyna_use_checkbox(trParam.lowerboundctrl))
			{
				nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_LB_CONTROL, strParamName, trParam.lowerboundctrl.nVal);
			}
			
			if(!is_optional_by_dyna_use_checkbox(trParam.upperboundctrl))
			{
				nUpdateParts |= m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_UB_CONTROL, strParamName, trParam.upperboundctrl.nVal);
			}
			Update(m_bIsAllowSharing);		
	
			return nUpdateParts;
			*/
			/// Iris 10/30/2008 QA80-12401-P10 FIX_QUICK_SET_DLG_CLICK_OK_FAIL_WORK
			trParam = m_trQuickSet.FirstNode;
			///end FIX_QUICK_SET_DLG_CLICK_OK_FAIL_WORK
			return OnQuickSetApply(trParam);
			///end QUICK_SET_DLG_ADD_APPLY_BUUTON
		}
		return 0;
	}

	/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	enum
	{
		CM_APPLY_TO_ALL,
		CM_CLEAR_COLUMN,
		/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		CM_CLEAR_BOUNDS,
		CM_RESET_ALL_BOUNDS,
		/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		
		///------ Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
		CM_COPY_ALL_VALUES_WITH_BASE,
		CM_PASTE_ALL_VALUES_WITH_BASE,
		CM_COPY_WHOLE_COLUMN,
		CM_PASTE_WHOLE_COLUMN,
		
		CM_SEPARATOR,
		///------ End PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
		///------ Folger 12/29/2010 ORG-938-S1 SUPPORT_APPLY_FORMAT_TO_ALL_SAME_PREFIX
		CM_APPLY_FORMAT_TO_ALL,
		///------ End SUPPORT_APPLY_FORMAT_TO_ALL_SAME_PREFIX

		///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		CM_APPLY_SETTINGS_TO_ALL_DATASETS,
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	};
	/// Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
	//int		GetItemContextMenu(int nRow, int nCol, vector<string>& vsItem, vector<byte>& vbShow, vector<bool>& vbDisable, vector<int>& vnChoice)
	enum
	{
		CM_CNTRL_NO_APPLT_TO_ALL 		= 0x00000001,
		CM_CNTRL_MULTI_SETS		 		= 0x00000002,		///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	};
	int		GetItemContextMenu(int nRow, int nCol, vector<string>& vsItem, vector<byte>& vbChecked, vector<bool>& vbDisable, vector<int>& vnChoice, DWORD dwCtrl = 0)
	/// end NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
	{	
		///------ Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
		//int			nRowZeroOffset, nColZeroOffset;
		//nRowZeroOffset = nRow - GetRowOffset();
		//nColZeroOffset = nCol - GetColOffset();
		//if ( nRowZeroOffset < 0 || nColZeroOffset < 0 )
			//return 0;
		//
		//if ( 0 != m_flx.EditWindow ) // Hong, cell in edit mode should not popup context menu
			//return 0;
		//
		//if ( nRowZeroOffset < getNumberBaselineParams() && NLPARAMGRIDCOLTYPE_SD != nColZeroOffset ) // Hong, baseline no context menu except digit
			//return 0;
		//
		//Control		cntrl;
		//BOOL		bCancel = FALSE;		
		//OnBeforeEditParaControl(cntrl, nRow, nCol, &bCancel);
		//vector<int>		vnCanEditByContextMenu = {NLPARAMGRIDCOLTYPE_LB_CONTROL, NLPARAMGRIDCOLTYPE_UB_CONTROL};
		//if ( bCancel && -1 == find_in_list(nColZeroOffset, vnCanEditByContextMenu, false) )
			//return 0;
		//
		//vector<int>		vnNoContextNemu = {NLPARAMGRIDCOLTYPE_FUNC_NAME};
		//if ( -1 != find_in_list(nColZeroOffset, vnNoContextNemu, false) )
			//return 0;
		//
		//ASSERT( GetRowOffset() > 0 );
		//string		strColHeader = GetCell(0, nCol);
		//IsGroupCol(nColZeroOffset, &strColHeader);
		//string		strMenuItem;
		///// Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT		
		//if ( !( CM_CNTRL_NO_APPLT_TO_ALL & dwCtrl ) || NLPARAMGRIDCOLTYPE_SD == nColZeroOffset ) // Hong, if Digit column, should always show menu Apply To All
		//{
		///// end NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
			//if ( NLPARAMGRIDCOLTYPE_SD == nColZeroOffset )
				//strMenuItem.Format(_L("Apply Same \"%s\" to All Parameters"), strColHeader);
			//else		
				//strMenuItem.Format(_L("Apply Same \"%s\" to All %s"), strColHeader, getParamNamePrefix(nRow));
			//if ( NLPARAMGRIDCOLTYPE_SHARE != nColZeroOffset || QuickSetIsShowShareCol() )
			//{
				//vsItem.Add(strMenuItem);
				//vbShow.Add(false);
				//vbDisable.Add(false);
				//vnChoice.Add(CM_APPLY_TO_ALL);
			//}
		//} /// Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
		//
		///// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		////vector<int>		vnColAlloClear = {NLPARAMGRIDCOLTYPE_SHARE, NLPARAMGRIDCOLTYPE_FIXED, NLPARAMGRIDCOLTYPE_LB, NLPARAMGRIDCOLTYPE_UB, NLPARAMGRIDCOLTYPE_LB_CONTROL, NLPARAMGRIDCOLTYPE_UB_CONTROL};
		////if ( -1 != find_in_list(nColZeroOffset, vnColAlloClear, false) )
		//vector<int>		vnColBoundGroup = {NLPARAMGRIDCOLTYPE_LB, NLPARAMGRIDCOLTYPE_UB, NLPARAMGRIDCOLTYPE_LB_CONTROL, NLPARAMGRIDCOLTYPE_UB_CONTROL};
		//if ( NLPARAMGRIDCOLTYPE_SHARE == nColZeroOffset || NLPARAMGRIDCOLTYPE_FIXED == nColZeroOffset )
		///// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		//{
			//strMenuItem.Format(_L("Clear \"%s\""), strColHeader);
			//vsItem.Add(strMenuItem);
			//vbShow.Add(false);
			//vbDisable.Add(false);
			//vnChoice.Add(CM_CLEAR_COLUMN);
		//}
		///// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		//else if (  -1 != find_in_list(nColZeroOffset, vnColBoundGroup, false) )
		//{
			//strMenuItem.Format(_L("Clear Bounds for All %s"), getParamNamePrefix(nRow));
			//vsItem.Add(strMenuItem);
			//vbShow.Add(false);
			//vbDisable.Add(false);
			//vnChoice.Add(CM_CLEAR_BOUNDS);
			//
			//strMenuItem = _L("Reset Bounds to Default");
			//vsItem.Add(strMenuItem);
			//vbShow.Add(false);
			//vbDisable.Add(false);
			//vnChoice.Add(CM_RESET_ALL_BOUNDS);
		//}
		///// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		
		///------ Folger 04/02/08 PROPER_CHECKING_BEFORE_POPUP_COPYPASTE_ALL_MENU
		int			nColZeroOffset = nCol - GetColOffset();
		int			nRowZeroOffset = nRow - GetRowOffset();
		if ( nRowZeroOffset < 0 || nColZeroOffset < 0 )
			return 0;
		
		if ( 0 != m_flx.EditWindow )
			return 0;
		///------ End PROPER_CHECKING_BEFORE_POPUP_COPYPASTE_ALL_MENU

		///------ Folger 12/10/2010 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		if ( IsSupportFormatMenu(nColType) )
		{
			GetDisplayFormatMenuItem(vsItem, vbChecked, vbDisable, vnChoice);
		}
		///------ End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		
		addCopySameToAllToMenu(nRow, nCol, vsItem, vbChecked, vbDisable, vnChoice, dwCtrl);
		addCopyPasteAllValuesToMenu(nRow, nCol, vsItem, vbChecked, vbDisable, vnChoice, dwCtrl);
		///------ End PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
		///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		addApplySettingsToAllDatasetsMenu(nRow, nCol, vsItem, vbChecked, vbDisable, vnChoice, dwCtrl);
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		
		ASSERT(vsItem.GetSize() == vbChecked.GetSize() && vsItem.GetSize() == vbDisable.GetSize());
		return vsItem.GetSize();		
	}
	
private:
	
	#define		ADD_SEPARATOR		ADD_ONE_MENU_ITEM("", 0, 0, CM_SEPARATOR)
	///------ Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME				
	int		addCopySameToAllToMenu(int nRow, int nCol, vector<string>& vsItem, vector<byte>& vbChecked, vector<bool>& vbDisable, vector<int>& vnChoice, DWORD dwCtrl = 0)
	{
		int			nRowZeroOffset, nColZeroOffset;
		nRowZeroOffset = nRow - GetRowOffset();
		nColZeroOffset = nCol - GetColOffset();
		///------ Folger 04/02/08 PROPER_CHECKING_BEFORE_POPUP_COPYPASTE_ALL_MENU
		/// alreay check in GetItemContextMenu()
		//if ( nRowZeroOffset < 0 || nColZeroOffset < 0 )
			//return 0;
		//
		//if ( 0 != m_flx.EditWindow ) // Hong, cell in edit mode should not popup context menu
			//return 0;
		///------ End PROPER_CHECKING_BEFORE_POPUP_COPYPASTE_ALL_MENU

		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol - GetColOffset();
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		
		if ( nRowZeroOffset < getNumberBaselineParams() && NLPARAMGRIDCOLTYPE_SD != nColType )
			return 0;
		
		Control		cntrl;
		BOOL		bCancel = FALSE;		
		OnBeforeEditParaControl(cntrl, nRow, nCol, &bCancel);
		vector<int>		vnCanEditByContextMenu = {NLPARAMGRIDCOLTYPE_LB_CONTROL, NLPARAMGRIDCOLTYPE_UB_CONTROL};
		if ( bCancel && -1 == find_in_list(nColType, vnCanEditByContextMenu, false) )
			return 0;
		
		vector<int>		vnNoContextNemu = {NLPARAMGRIDCOLTYPE_FUNC_NAME};
		if ( -1 != find_in_list(nColType, vnNoContextNemu, false) )
			return 0;
		
		///------ Folger 12/10/2010 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		if ( vnChoice.GetSize() > 0 && vnChoice[vnChoice.GetSize()-1] != CM_SEPARATOR )
			ADD_SEPARATOR;
		///------ End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		
		ASSERT( GetRowOffset() > 0 );
		string		strColHeader = GetCell(0, nCol);
		IsGroupCol(nColType, &strColHeader);
		string		strMenuItem;
		/// Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT		
		if ( !( CM_CNTRL_NO_APPLT_TO_ALL & dwCtrl ) || NLPARAMGRIDCOLTYPE_SD == nColType) // Hong, if Digit column, should always show menu Apply To All
		{
		/// end NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
			if ( NLPARAMGRIDCOLTYPE_SD == nColType )
				strMenuItem.Format(_L("Apply Same \"%s\" to All Parameters"), strColHeader);
			else		
				strMenuItem.Format(_L("Apply Same \"%s\" to All %s"), strColHeader, getParamNamePrefix(nRow));

			if ( NLPARAMGRIDCOLTYPE_SHARE != nColType || QuickSetIsShowShareCol() )
			{
				//vsItem.Add(strMenuItem);
				//vbShow.Add(false);
				//vbDisable.Add(false);
				//vnChoice.Add(CM_APPLY_TO_ALL);
				ADD_ONE_MENU_ITEM(strMenuItem, false, false, CM_APPLY_TO_ALL);
			}

			///------ Folger 12/29/2010 ORG-938-S1 SUPPORT_APPLY_FORMAT_TO_ALL_SAME_PREFIX
			if ( IsSupportFormatMenu(nColType) )
			{
				strMenuItem.Format(_L("Apply Format to All %s"), getParamNamePrefix(nRow));
				ADD_ONE_MENU_ITEM(strMenuItem, false, false, CM_APPLY_FORMAT_TO_ALL);
			}
			///------ End SUPPORT_APPLY_FORMAT_TO_ALL_SAME_PREFIX
		} /// Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
		
		/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		//vector<int>		vnColAlloClear = {NLPARAMGRIDCOLTYPE_SHARE, NLPARAMGRIDCOLTYPE_FIXED, NLPARAMGRIDCOLTYPE_LB, NLPARAMGRIDCOLTYPE_UB, NLPARAMGRIDCOLTYPE_LB_CONTROL, NLPARAMGRIDCOLTYPE_UB_CONTROL};
		//if ( -1 != find_in_list(nColZeroOffset, vnColAlloClear, false) )
		vector<int>		vnColBoundGroup = {NLPARAMGRIDCOLTYPE_LB, NLPARAMGRIDCOLTYPE_UB, NLPARAMGRIDCOLTYPE_LB_CONTROL, NLPARAMGRIDCOLTYPE_UB_CONTROL};

		if ( NLPARAMGRIDCOLTYPE_SHARE == nColType || NLPARAMGRIDCOLTYPE_FIXED == nColType )
		/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		{
			strMenuItem.Format(_L("Clear \"%s\""), strColHeader);
			//vsItem.Add(strMenuItem);
			//vbShow.Add(false);
			//vbDisable.Add(false);
			//vnChoice.Add(CM_CLEAR_COLUMN);
			ADD_ONE_MENU_ITEM(strMenuItem, false, false, CM_CLEAR_COLUMN);
		}
		/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		else if (  -1 != find_in_list(nColType, vnColBoundGroup, false) )
		{
			strMenuItem.Format(_L("Clear Bounds for All %s"), getParamNamePrefix(nRow));
			//vsItem.Add(strMenuItem);
			//vbShow.Add(false);
			//vbDisable.Add(false);
			//vnChoice.Add(CM_CLEAR_BOUNDS);
			ADD_ONE_MENU_ITEM(strMenuItem, false, false, CM_CLEAR_BOUNDS);
			
			strMenuItem = _L("Reset Bounds to Default");
			//vsItem.Add(strMenuItem);
			//vbShow.Add(false);
			//vbDisable.Add(false);
			//vnChoice.Add(CM_RESET_ALL_BOUNDS);
			ADD_ONE_MENU_ITEM(strMenuItem, false, false, CM_RESET_ALL_BOUNDS);
		}
		/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		
		return vsItem.GetSize();
	}
	
	int		addCopyPasteAllValuesToMenu(int nRow, int nCol, vector<string>& vsItem, vector<byte>& vbChecked, vector<bool>& vbDisable, vector<int>& vnChoice, DWORD dwCtrl = 0)	/// dwCtrl for later use
	{
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol - GetColOffset();
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		if ( NLPARAMGRIDCOLTYPE_VALUE != nColType
			&& NLPARAMGRIDCOLTYPE_LB != nColType
			&& NLPARAMGRIDCOLTYPE_UB != nColType
			)		
			return vsItem.GetSize();
		
		string		strData;
		bool		bIsDisablePaste = !GetClipboardText(strData);
		
		if ( vnChoice.GetSize() > 0 && vnChoice[vnChoice.GetSize()-1] != CM_SEPARATOR )
			ADD_SEPARATOR;
		
		string		str;
		
		string		strParamName = getParamNamePrefix(nRow);
		string		strColHeader = GetCell(0, nCol);
		str.Format(_L("Copy \"%s\" of all %s"), strColHeader, strParamName);
		ADD_ONE_MENU_ITEM(str, 0, 0, CM_COPY_ALL_VALUES_WITH_BASE);
		str.Format(_L("Paste \"%s\" to all %s"), strColHeader, strParamName);
		ADD_ONE_MENU_ITEM(str, 0, bIsDisablePaste, CM_PASTE_ALL_VALUES_WITH_BASE);
		
		///------ Folger 08/11/2011 ORG-2740-S5 PROPER_SEPARATOR_FOR_COPY_PARAM_VALUE_CONTEXT_MENU
		ADD_SEPARATOR;
		///------ End PROPER_SEPARATOR_FOR_COPY_PARAM_VALUE_CONTEXT_MENU
		
		ADD_ONE_MENU_ITEM(_L("Copy Whole Column"), 0, 0, CM_COPY_WHOLE_COLUMN);
		ADD_ONE_MENU_ITEM(_L("Paste Whole Column"), 0, bIsDisablePaste, CM_PASTE_WHOLE_COLUMN);
		
		return vsItem.GetSize();
	}
	///------ End PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME

	///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	int		addApplySettingsToAllDatasetsMenu(int nRow, int nCol, vector<string>& vsItem, vector<byte>& vbChecked, vector<bool>& vbDisable, vector<int>& vnChoice, DWORD dwCtrl = 0)
	{
		#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
		#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol - GetColOffset();
		#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		
		if ( NLPARAMGRIDCOLTYPE_VALUE != nColType
			&& NLPARAMGRIDCOLTYPE_LB != nColType
			&& NLPARAMGRIDCOLTYPE_UB != nColType
			)
			return vsItem.GetSize();

		if ( vnChoice.GetSize() > 0 && vnChoice[vnChoice.GetSize()-1] != CM_SEPARATOR )
			ADD_SEPARATOR;

		string		str;
		string		strColHeader = GetCell(0, nCol);
		str.Format(_L("Apply Whole Set of \"%s\" to All Datasets"), strColHeader);
		ADD_ONE_MENU_ITEM(str, 0, !O_QUERY_BOOL(dwCtrl, CM_CNTRL_MULTI_SETS), CM_APPLY_SETTINGS_TO_ALL_DATASETS);
		
		return vsItem.GetSize();
	}
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	
	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	void doDraggableShowHideColMenu(int nx, int ny)
	{
		vector<int> 	vnGroupIndices;
		vector<string> 	vsGroupColHeaders;
		vector<byte> 	vbGroupShows;
		vector<bool>	vbItemsDisable;
		
		GetGroupColIndices(GetActiveGroup(), vnGroupIndices);

		vbGroupShows.SetSize(vnGroupIndices.GetSize());
		for (int i = 0 ; i < vnGroupIndices.GetSize() ; ++i)
		{
			int nCol = GetColPos(vnGroupIndices[i]);
			vbGroupShows[i] = !IsColHidden(nCol);
		}
		int nNumShowCols = 0;
	    vbGroupShows.Sum(nNumShowCols);
		
		string strHeaders(STR_NLFIT_PARACONTRO_GRID_COLS);
		strHeaders.GetTokens(vsGroupColHeaders, '|');
				
		GetColMenuDisableItems(vnGroupIndices, vbItemsDisable);
		
		vsGroupColHeaders.Add("");		//separator
  		vbGroupShows.Add(false);
  		vbItemsDisable.Add(false);

  		vsGroupColHeaders.Add(_L("Show All Columns"));
  		vbGroupShows.Add(false);
  		vbItemsDisable.Add(false);
		
		CheckMenu MyMenu(vbGroupShows, vsGroupColHeaders, vbItemsDisable);
		
		int nChoice = MyMenu.DoTrackPopup(nx, ny, GetDlgSafeHwnd() );
		
		if(nChoice >= 0)
		{
			vbGroupShows.SetSize(vnGroupIndices.GetSize()); // remove the last two items (separator and "Show All Columns")
			
			bool bSuccess = true;			
			if(nChoice < vnGroupIndices.GetSize())
			{
				int nCol = GetColPos(vnGroupIndices[nChoice]);
				HideCol(nCol, IsColHidden(nCol) ? false : true);
				
				vbGroupShows[nChoice] = !IsColHidden(nCol);
			}
			else
			{
				for(i = vnGroupIndices.GetSize() - 1; i >= 0; --i)
		    	{
		    		if(vbItemsDisable[i])
		    			continue;
		    		int nCol = GetColPos(vnGroupIndices[i]);
		    		HideCol(nCol, false);
		    		
		    		vbGroupShows[i] = !IsColHidden(nCol);
		    	}
			}
			
			
			SetGroupColShows(GetActiveGroup(), vnGroupIndices, vbGroupShows);
		}
	}
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
	
public:
	
	///------ Folger 05/05/2011 ORG-2773-P1 CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
	//int		OnItemContextMenu(int nRow, int nCol, int nChoice)
	int		OnItemContextMenu(int nRow, int nCol, int nChoice, POnContextMenuMore pMore = NULL)
	///------ End CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
	{
		int			nRowZeroOffset, nColZeroOffset;
		nRowZeroOffset = nRow - GetRowOffset();
		nColZeroOffset = nCol - GetColOffset();
		if ( nRowZeroOffset < 0 && nColZeroOffset < 0 )
			return 0;

		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nValueCol = GetColPos(NLPARAMGRIDCOLTYPE_VALUE);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nValueCol = NLPARAMGRIDCOLTYPE_VALUE;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		///------ Folger 12/10/2010 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		if ( OnDisplayFormatMenuItem(nChoice, nRowZeroOffset, nValueCol) )
		{
			string	strFormat, strCustomDisplay;
			GetFormat(strFormat, strCustomDisplay, nValueCol, nRowZeroOffset);
			///Jasmine 12/15/10 ORG-938-P1 PARAM_FORMAT_FROM_GUI_TO_FDF
			//return NLDLGPART_PARAMETERS_GRID;
			vector<string> vsFormats;
			m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_FORMAT, vsFormats);
			ASSERT(vsFormats.GetSize() > nRowZeroOffset);
			if( lstrcmp(vsFormats[nRowZeroOffset], strFormat) == 0 )
			{
				vector<string> vsCustonDisplay;
				m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_CUSTOMDISPLAY, vsCustonDisplay);
				ASSERT(vsCustonDisplay.GetSize() > nRowZeroOffset);
				if( lstrcmp(vsCustonDisplay[nRowZeroOffset], strCustomDisplay) == 0 )
					return 0;
			}
			m_pNLParamsMngr->OnEdit(NLPARAMGRIDCOLTYPE_FORMAT, nRowZeroOffset, strFormat);
			m_pNLParamsMngr->OnEdit(NLPARAMGRIDCOLTYPE_CUSTOMDISPLAY, nRowZeroOffset, strCustomDisplay);
			
			///------ Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
			//return (NLDLGPART_PARAMETERS_GRID | NLDLGPART_FDF_SETTINGS);
			return (NLDLGPART_PARAMETERS_DISPLAY | NLDLGPART_FDF_SETTINGS);
			///------ End PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
			///End PARAM_FORMAT_FROM_GUI_TO_FDF
		}
		///------ End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		
		/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		/// Hong 04/16/09 FIX_RESET_ALL_BOUNDS_NOT_UPDATE_BTN_STATUS_AND_FDF_CHANGED_STATUS
		int			nUpdateParts = 0;
		/// end FIX_RESET_ALL_BOUNDS_NOT_UPDATE_BTN_STATUS_AND_FDF_CHANGED_STATUS
		bool		bHandled = false;
		if ( CM_RESET_ALL_BOUNDS == nChoice )
		{
			Window 			wnd( GetDlgSafeHwnd() );
			ASSERT(wnd);
			wnd.SendMessage(WM_USER_NLF_RESET_BOUNDS, TRUE);
			bHandled = true;
			/// Hong 04/16/09 FIX_RESET_ALL_BOUNDS_NOT_UPDATE_BTN_STATUS_AND_FDF_CHANGED_STATUS
			nUpdateParts |= NLDLGPART_FIT_CONTROL_BTNS | NLDLGPART_FDF_SETTINGS;
			/// end FIX_RESET_ALL_BOUNDS_NOT_UPDATE_BTN_STATUS_AND_FDF_CHANGED_STATUS
		}
		
		/// Hong 04/16/09 FIX_RESET_ALL_BOUNDS_NOT_UPDATE_BTN_STATUS_AND_FDF_CHANGED_STATUS
		//int			nUpdateParts = 0;
		/// end FIX_RESET_ALL_BOUNDS_NOT_UPDATE_BTN_STATUS_AND_FDF_CHANGED_STATUS
		if ( !bHandled )
		{
		/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
			//--- Hong, copy from /// Iris 12/24/2008 FIX_QUICK_SET_CHANGED_BASELINE_PARAMS_SHARE_STATUS
			vector<int> vnBaselineParamIndices;

			/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			int nColType = nCol - GetColOffset();
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

			if ( getNumberBaselineParams() > 0 && NLPARAMGRIDCOLTYPE_SD != nColType )
				vnBaselineParamIndices.Data(0, getNumberBaselineParams()-1, 1);
			//---			
			string		strParamNamePrefix = getParamNamePrefix(nRow);
			LPCSTR		lpcszNamePrefix = strParamNamePrefix;
			double		dVal;
			vector<int>	vnCols;
			vnCols.Add(nColType);
			
			///------ Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
			//bool		bGroup = IsGroupCol(nColZeroOffset, NULL, vnCols);
			bool		bNoNeedGrouped = (
					CM_COPY_ALL_VALUES_WITH_BASE == nChoice
					|| CM_PASTE_ALL_VALUES_WITH_BASE == nChoice
					|| CM_COPY_WHOLE_COLUMN == nChoice
					|| CM_PASTE_WHOLE_COLUMN == nChoice
					///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
					|| CM_APPLY_SETTINGS_TO_ALL_DATASETS == nChoice
					///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
					);
			bool		bGroup = !bNoNeedGrouped && IsGroupCol(nColType, NULL, vnCols);
			///------ End PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
			
			for ( int ii = 0; ii < vnCols.GetSize(); ii++ )
			{
				int nColType = vnCols[ii];

				switch ( nChoice )
				{
				case CM_APPLY_TO_ALL:
					if ( NLPARAMGRIDCOLTYPE_SD == nColType )
						lpcszNamePrefix = NULL;
					/// Hong 03/05/09 FIX_APPLY_TO_ALL_LOST_VALUE_PRECISION
					/*
					string		strVal = GetCell(nRow, nCol + vnCols[ii] - nColZeroOffset, true);
					if ( 0 == strVal.CompareNoCase("--") )
						dVal = NANUM;
					else
						dVal = atof(strVal);				
					*/
					dVal = GetCellFullPrecisionValue(nRow, nCol + nColType - nColZeroOffset);
					/// end FIX_APPLY_TO_ALL_LOST_VALUE_PRECISION
					break;

				///------ Folger 12/29/2010 ORG-938-S1 SUPPORT_APPLY_FORMAT_TO_ALL_SAME_PREFIX
				case CM_APPLY_FORMAT_TO_ALL:
					{
						ASSERT(vnCols.GetSize() == 1);
						ParameterRow 	paramRow;
						m_pNLParamsMngr->GetRow(paramRow, nRowZeroOffset);
						
						m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_FORMAT, lpcszNamePrefix, NANUM, NLPARAMETER_BOUNDS_SET_BY_CONSTANT, &vnBaselineParamIndices, paramRow.strFormat);
						m_pNLParamsMngr->SetParameters(NLPARAMGRIDCOLTYPE_CUSTOMDISPLAY, lpcszNamePrefix, NANUM, NLPARAMETER_BOUNDS_SET_BY_CONSTANT, &vnBaselineParamIndices, paramRow.strCustomDisplay);
						bHandled = TRUE;
					}
					break;
				///------ End SUPPORT_APPLY_FORMAT_TO_ALL_SAME_PREFIX

				case CM_CLEAR_COLUMN:
					lpcszNamePrefix = NULL;
					dVal = 0.0;
					/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
					/*
					if ( NLPARAMGRIDCOLTYPE_LB_CONTROL == vnCols[ii] || NLPARAMGRIDCOLTYPE_UB_CONTROL == vnCols[ii] )
					{
						vector<string>		strTokens;
						string				strLBUBCntl(STR_BUTTON_CONTROL_COMBOLIST);
						strLBUBCntl.GetTokens(strTokens, '|');
						int			nPos = strTokens.Find(STR_BOUNDS_CONTROL_DISABLE);
						if ( -1 != nPos )
							dVal = nPos;
					}
					else if ( NLPARAMGRIDCOLTYPE_VALUE == vnCols[ii] || NLPARAMGRIDCOLTYPE_LB == vnCols[ii] || NLPARAMGRIDCOLTYPE_UB == vnCols[ii] )
						dVal = NANUM;
					*/
					ASSERT( !bGroup );
					if ( NLPARAMGRIDCOLTYPE_VALUE == nColType )
						dVal = NANUM;
					/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
					///------ Folger 05/19/2011 ORG-2773-P2 HIDE_PARAMS_DIALOG_FAILED_IN_NLFIT
					else if ( NLPARAMGRIDCOLTYPE_SHARE == nColType )
					{
						O_ADD_BIT(nUpdateParts, NLDLGPART_PARAM_ROW_SHOW);
					}
					///------ End HIDE_PARAMS_DIALOG_FAILED_IN_NLFIT
					break;
				/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
				case CM_CLEAR_BOUNDS:
					ASSERT(bGroup);
					dVal = 0.0;
					if ( NLPARAMGRIDCOLTYPE_LB_CONTROL == nColType || NLPARAMGRIDCOLTYPE_UB_CONTROL == nColType )
					{
						vector<string>		strTokens;
						string				strLBUBCntl(STR_BUTTON_CONTROL_COMBOLIST);
						strLBUBCntl.GetTokens(strTokens, '|');
						int			nPos = strTokens.Find(STR_BOUNDS_CONTROL_DISABLE);
						if ( -1 != nPos )
							dVal = nPos;
					}
					else if ( NLPARAMGRIDCOLTYPE_LB == nColType || NLPARAMGRIDCOLTYPE_UB == nColType )
						dVal = NANUM;
					break;			
				/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
				
				///------ Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
				case CM_COPY_ALL_VALUES_WITH_BASE:
					m_pNLParamsMngr->CopyToClipboard(nColType, strParamNamePrefix);
					bHandled = true;
					break;
					
				case CM_PASTE_ALL_VALUES_WITH_BASE:
					nUpdateParts = m_pNLParamsMngr->PasteFromClipboard(nColType, strParamNamePrefix);
					bHandled = true;
					break;
					
				///------ Folger 07/12/10 ORG-515-P1 COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
				//case CM_COPY_WHOLE_COLUMN:
					//m_pNLParamsMngr->CopyToClipboard(vnCols[ii], NULL);
					//bHandled = true;
					//break;
		
				//case CM_PASTE_WHOLE_COLUMN:
					//nUpdateParts = m_pNLParamsMngr->PasteFromClipboard(vnCols[ii], NULL);
					//bHandled = true;
					//break;
				case CM_COPY_WHOLE_COLUMN:
				case CM_PASTE_WHOLE_COLUMN:
					{
						vector<int>		vnRowsShow;
						GetRowsShow(vnRowsShow);
						
						if ( CM_COPY_WHOLE_COLUMN == nChoice )
							m_pNLParamsMngr->CopyToClipboard(nColType, NULL, &vnRowsShow);
						else
							nUpdateParts = m_pNLParamsMngr->PasteFromClipboard(nColType, NULL, &vnRowsShow);
						bHandled = true;
					}
					break;
				///------ End COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
				///------ End PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME

				///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
				case CM_APPLY_SETTINGS_TO_ALL_DATASETS:
					if ( pMore )
					{
						O_A(pMore->nDatasetEdited >= 0);

						vector<int>		vnColTypes;
						if ( NLPARAMGRIDCOLTYPE_LB == nColType )
						{
							vnColTypes.Add(NLPARAMGRIDCOLTYPE_LB);
							vnColTypes.Add(NLPARAMGRIDCOLTYPE_LB_CONTROL);
						}
						else if ( NLPARAMGRIDCOLTYPE_UB == nColType )
						{
							vnColTypes.Add(NLPARAMGRIDCOLTYPE_UB);
							vnColTypes.Add(NLPARAMGRIDCOLTYPE_UB_CONTROL);
						}
						else
						{
							vnColTypes.Add(nColType);
						}

						for ( int nn=0; nn<vnColTypes.GetSize(); ++nn )
						{
							m_pNLParamsMngr->DuplicateDatasetOneParameterSettingToAll(pMore->nDatasetEdited, vnColTypes[nn]);
						}
						bHandled = true;
					}
					break;
				///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
				
				default:
					ASSERT(FALSE);
					return 0;
				}
				
				///------ Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
				if ( !bHandled )
				{
				///------ End PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
					int 	nRet = m_pNLParamsMngr->SetParameters(nColType, lpcszNamePrefix, dVal, NLPARAMETER_BOUNDS_SET_BY_CONSTANT, &vnBaselineParamIndices);
					ASSERT( nRet > 0 );
					nUpdateParts |= nRet;
				}		///------ Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
			}
		} /// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
		
		/// Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT
		//Update(m_bIsAllowSharing);		
		/// Hong 01/22/09 FIX_FAIL_KEEP_SCROLL_POS_AFTER_OPERATE_APPLY_TO_ALL
		//Update(QuickSetIsShowShareCol());
		///------ Folger 05/05/2011 ORG-2773-P1 CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
		//Update(QuickSetIsShowShareCol(), false);
		///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		//Update(QuickSetIsShowShareCol() | (pMore ? pMore->bAllowShared : FALSE), false);
		///------ Folger 08/25/2011 ORG-2740-P7 ON_PARAM_COLUMN_CONTEXT_MENU_SHOULD_NOT_CHANGE_CURRECT_ACTIVE_DATASET
		//Update(QuickSetIsShowShareCol() | (pMore ? pMore->bAllowShared : FALSE), false, pMore ? pMore->nDatasetEdited : -1);
		Update(QuickSetIsShowShareCol() | (pMore ? pMore->bAllowShared : FALSE), false, pMore ? pMore->nActiveDataset : -1);
		///------ End ON_PARAM_COLUMN_CONTEXT_MENU_SHOULD_NOT_CHANGE_CURRECT_ACTIVE_DATASET
		///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
		///------ End CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
		/// end FIX_FAIL_KEEP_SCROLL_POS_AFTER_OPERATE_APPLY_TO_ALL
		///end NOT_SHOW_SHARE_COL_FOR_NLFIT

		///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
		if(nUpdateParts>0)
		{
			//Window wnd( GetDlgSafeHwnd() );			///------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING		
			/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
			nUpdateParts &= ~(NLDLGPART_PARAMETERS_GRID | NLDLGPART_FIT_FUNC_DISPLAY); // Hong, grid is already update above, so no need post this bit.
			/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
			//wnd.SendMessage(WM_USER_NLF_QUICK_SET_PARAMETER_VALUE_CHANGE, nUpdateParts);		///------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING				
		}
		///End QUICK_SET_PARAMETERS_VALUE_CHANGE
		
		return nUpdateParts;
	}
	/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	
	/// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
	//virtual BOOL QuickSetParamInitValue(TreeNode &trParam)
	virtual BOOL QuickSetParamInitValue(TreeNode &trParam, LPCSTR lpcszParamName = NULL)
	///end QUICK_SET_DLG_ADD_APPLY_BUUTON
	{
		if(!trParam)
			return false;
		int nRow = GetSelectedRow() - GetRowOffset();

		///Kyle 10/30/2008 QA80-12401-P9 QUICK_SET_DLG_GET_PARAMETER_NAEM
		///// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
		//if( lpcszParamName )
		//{
			////vector<string> vsNames;
			////m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsNames);
			//nRow = vsNames.Find(lpcszParamName, 0, false, false);
		//}
		/////end QUICK_SET_DLG_ADD_APPLY_BUUTON
		/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
		/*
		string strParamName;
		vector<string> vsNames;
		m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsNames);
		if( lpcszParamName )
		{
			nRow = vsNames.Find(lpcszParamName);
			if(nRow < 0)
				nRow = vsNames.Find(lpcszParamName, 0, false, false);
			strParamName = lpcszParamName;
		}
		else if(nRow>=0 && nRow < vsNames.GetSize() )
		{
			strParamName = vsNames[nRow];
			///Kyle 11/14/2008 QUICK_SET_EXCEPT_P0_ALL_PARAMETERS_NAME_NEED_TO_TRIM_INDEX, all parameters only except y0 formatted as name__n or name_n
			//vector<int> vnBegin;
			//if(m_pNLParamsMngr->GetGroupingRowsBegin(vnBegin)>0 && nRow>=vnBegin[0])			// trim
			//{
			///End QUICK_SET_EXCEPT_P0_ALL_PARAMETERS_NAME_NEED_TO_TRIM_INDEX
			if(!IsBaselineParameter(nRow))			///Kyle 11/22/2008 NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
			{
				int nIndex = strParamName.ReverseFind('_');
				if( nIndex>0 && nIndex<strParamName.GetLength()-1)	// skip the first and the last '_'
				{
					if( nIndex>0 && NLPMGRTYPE_MULTIPLE_SETS != m_pNLParamsMngr->GetType())			// two '_'
					{
						nIndex--;
						if(strParamName[nIndex] != '_')
							nIndex = -1;
					}
					if(nIndex > 0)
						strParamName = strParamName.Left(nIndex);
				}
			}			
		}
		*/
		string strParamName;
		if ( NULL == lpcszParamName )
			strParamName = getParamNamePrefix(nRow);
		else
		{
			vector<string> vsNames;
			m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsNames);
			nRow = vsNames.Find(lpcszParamName);
			if(nRow < 0)
				nRow = vsNames.Find(lpcszParamName, 0, false, false);
			strParamName = lpcszParamName;
		}
		/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
		///End QUICK_SET_DLG_GET_PARAMETER_NAEM

		if( nRow >= 0 )
		{
			///Kyle 10/30/2008 QA80-12401-P9 QUICK_SET_DLG_GET_PARAMETER_NAEM
			//string	strParamName = GetCell( nRow + GetRowOffset(), NLPARAMGRIDCOLTYPE_NAME);
			//vector<string> vsWords;
			//strParamName.GetTokens(vsWords, '_');
			//if(vsWords.GetSize()>1)
				//strParamName = vsWords[0];
			//End QUICK_SET_DLG_GET_PARAMETER_NAEM
	
			ParameterRow paramRow;
			m_pNLParamsMngr->GetRow(paramRow, nRow);
	
			trParam.name.strVal = strParamName;
			/// Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT
			//if(m_bIsAllowSharing)
			if(QuickSetIsShowShareCol())
			///end NOT_SHOW_SHARE_COL_FOR_NLFIT
			{
				trParam.share.nVal = paramRow.nShared;
			}
			trParam.fix.nVal = paramRow.bFixed;
			trParam.value.dVal = paramRow.rValue;
			///Kyle 11/01/2008 INIT_BOUND_VALUE_ONLY_WHEN_BOUND_OPTION_IS_CONSTANT
			if( NLPARAMETER_BOUNDS_SET_BY_CONSTANT == trParam.lowerbound.boundoption.nVal)
			///End INIT_BOUND_VALUE_ONLY_WHEN_BOUND_OPTION_IS_CONSTANT
				trParam.lowerbound.boundvalue.dVal = paramRow.rLBValue;

			///Kyle 11/01/2008 INIT_BOUND_VALUE_ONLY_WHEN_BOUND_OPTION_IS_CONSTANT
			if( NLPARAMETER_BOUNDS_SET_BY_CONSTANT == trParam.upperbound.boundoption.nVal)
			///End INIT_BOUND_VALUE_ONLY_WHEN_BOUND_OPTION_IS_CONSTANT
				trParam.upperbound.boundvalue.dVal = paramRow.rUBValue;

			trParam.lowerboundctrl.nVal = paramRow.nLBControl;
			trParam.upperboundctrl.nVal = paramRow.nUBControl;
			return true;
		}
		return false;
	}
	///End QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	
	//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_FOR_REPLICA_AND_PA
	int		OnSortPeaks(bool bCurveFit = true/*, vector<uint> *pvnIndices = NULL*/)
	{
		GETN_TREE(tr)
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		
		GETN_STR(hint, _L("Sort all peaks' parameters"), "")		GETN_READ_ONLY_COLOR GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_USE_LABEL | DISPLAY_EDITOR_BOLD_FONT)
		
		GETN_BEGIN_BRANCH(sortby, _L("Sort By"))		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_RADIO_INDEX(sortbyoption, 0, bCurveFit ? _L("Center|Width|Amplitude") : _L("X Center|Y Center|X Width|Y Width|Amplitude"))
		GETN_END_BRANCH(sortby)
		
		GETN_BEGIN_BRANCH(order, _L("Sort Order"))		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_RADIO_INDEX(orderoption, 0, _L("Ascending|Descending"))
		GETN_END_BRANCH(order)
		
		int		nUpdateParts = 0;
		if ( GetNBox(tr, STR_SORT_PEAKS, NULL, NULL, NULL, GetControl().GetParent().GetSafeHwnd()) )
		{
			int		nSortBy = tr.sortby.sortbyoption.nVal;
			if ( bCurveFit )
			{
				switch ( nSortBy )
				{
				case 0:
					nSortBy = NLPARAMETERSORTING_BY_CENTER;
					break;
				case 1:
					nSortBy = NLPARAMETERSORTING_BY_WIDTH;
					break;
				case 2:
					nSortBy = NLPARAMETERSORTING_BY_AMPLITUDE;
					break;
				default:
					break;
				}
			}
					
			if ( (nUpdateParts = m_pNLParamsMngr->MultiplePeaksSortingByParameter(nSortBy, tr.order.orderoption.nVal == 0 ? TRUE : FALSE/*, pvnIndices*/)) > 0 )
			{
				Update(m_bIsAllowSharing);
			}
		}
		return nUpdateParts;
	}
	//------ End SUPPORT_SORT_MULTIPLE_PEAKS_FOR_REPLICA_AND_PA
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	int		OnReorderPeaks(vector<uint> *pvnIndices = NULL)
	{
		int		nUpdateParts = 0;
		if ( (nUpdateParts = m_pNLParamsMngr->MultiplePeaksReordering(pvnIndices)) > 0 )
		{
			Update(m_bIsAllowSharing);
		}
		return nUpdateParts;
	}
	//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
		
	Control GetControl()
	{
		return *(ResizeControl::GetControl()) ;
	}
	
	void	SetupColTypes()
	{
		//m_flx.FormatString = STR_NLFIT_PARACONTRO_GRID_COLS;
		m_flx.Cols = NLPARAMGRIDCOLTYPE_TOTAL;
		
		int nCol;
		for(nCol = 0; nCol < m_flx.Cols; nCol++)
		{
			/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
			/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

			switch(nColType)
			{
			case NLPARAMGRIDCOLTYPE_PEAK_NO:
				SetColDataType(nCol, flexDTLong);
				break;
			case NLPARAMGRIDCOLTYPE_SHARE:
			case NLPARAMGRIDCOLTYPE_FIXED:
				SetColDataType(nCol, flexDTBoolean);
				break;
			///Sophy 5/20/2008 GRID_SUPPORT_BUTTON_TYPE_COL
			case NLPARAMGRIDCOLTYPE_LB_CONTROL:
			case NLPARAMGRIDCOLTYPE_UB_CONTROL:
				SetButtonType( nCol, STR_BUTTON_CONTROL_COMBOLIST);
				break;
			///end GRID_SUPPORT_BUTTON_TYPE_COL

			default:
				SetColDataType(nCol, flexDTString);
				break;
			}
			SetColAlignment(nCol, flexAlignCenterCenter);
		}		
	}
	
	/**$
		Return:
			combination of NLDLGPART
	*/
	int OnAfterEdit(Control flxControl, int nRow, int nCol)
	{
		return OnAfterEdit(nRow, nCol);
	}
	
	/**$
		Return:
			combination of NLDLGPART
	*/
	int OnAfterEdit( int nRow, int nCol)
	{
		GridTableControl::OnAfterEdit(nRow, nCol);
		
		/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
		/*
		string	strRet = GetCell(nRow, nCol);
		///Sophy 10/20/2008 NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON
		if( NLPARAMGRIDCOLTYPE_LB_CONTROL == nCol || NLPARAMGRIDCOLTYPE_UB_CONTROL == nCol )
		{
			int nValueIndex;
			if( ConvertValueToIndex( STR_BUTTON_CONTROL_COMBOLIST, strRet, nValueIndex ) )
				strRet.Format("%d", nValueIndex );
			ASSERT( nValueIndex >= 0 );
		}
		///end NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON
		*/
		/// Hong 09/03/10 ORG-576-S1 FIX_AMBIGUOUS_OVERLOAD
		//string	strRet = GetCell(nRow, nCol, true);
		string	strRet = GetCell(nRow, nCol, "");
		/// end FIX_AMBIGUOUS_OVERLOAD
		/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
		int			nRowOffset = GetRowOffset();
		///------ Folger 12/14/2010 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
		int nValueCol = GetColPos(NLPARAMGRIDCOLTYPE_VALUE);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol - GetColOffset();
		int nValueCol = NLPARAMGRIDCOLTYPE_VALUE;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		if ( IsSupportFormatMenu(nColType) )
			GetCellFromFormatted(strRet, nRow - nRowOffset, nValueCol);
		///------ End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		
		NLDLGPART	dwParts = m_pNLParamsMngr->OnEdit(nColType, nRow - nRowOffset, strRet);
		
		updateGridShowAfterEdit(nRow, nCol);				///Kyle 09/12/08 ADD_FUNCTION_TO_UPDATE_GRID_SHOW_AFTER_EDIT
		
		///------ Folger 02/18/09 QA80-13139 FITTING_DIALOG_GRID_NAVIGATE_TO_NEXT_CELL_AFTER_EDIT
		/// SetCell only when Enter key down
		if ( GetKeyState(VK_RETURN) < 0 && nRow + 1 < GetRows() )
			SelCell(nRow + 1, nCol);
		///------ End FITTING_DIALOG_GRID_NAVIGATE_TO_NEXT_CELL_AFTER_EDIT

		return dwParts;
	}	
	
	///Kyle 01/23/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL
	void OnMouseMove(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		//---Jacky 7/19/2010 ORG-589-P2 REMOVE_THE_TOOLTIP_WHEN_BROWSING_OVER_CONTROLS
		//int nRow, nCol;
		//if(!GetMouseCell(nRow, nCol))
			//return;
		//
		//string strTooltips;
		//nCol -= GetColOffset();
		//if(nRow >= GetRowOffset() && (nCol == NLPARAMGRIDCOLTYPE_LB_CONTROL || nCol == NLPARAMGRIDCOLTYPE_UB_CONTROL))
			//strTooltips = STR_BOUND_VALUE_TOOLTIP;
				//SetToolTipsText(strTooltips);
		//---end  REMOVE_THE_TOOLTIP_WHEN_BROWSING_OVER_CONTROLS
	}
	///End SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL
	
	virtual void OnBeforeEditParaControl(Control cntrl, long nRow, long nCol, BOOL* pCancel)
	{	
		///NLF_81 Sophy
		bool	bEditable = true;
		///Sophy 1/21/2009 v8.0962b SHOULD_CHECK_ROW_AND_COL_OFFSET
		//switch(nCol)
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol - GetColOffset();
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		switch(nColType)
		///end SHOULD_CHECK_ROW_AND_COL_OFFSET
		{
		case NLPARAMGRIDCOLTYPE_NAME:
		case NLPARAMGRIDCOLTYPE_PEAK_NO:
		case NLPARAMGRIDCOLTYPE_UNIT:			///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
		case NLPARAMGRIDCOLTYPE_MEANING:
		case NLPARAMGRIDCOLTYPE_ERROR:
		case NLPARAMGRIDCOLTYPE_DEPENDENCY:
		case NLPARAMGRIDCOLTYPE_LCL:
		case NLPARAMGRIDCOLTYPE_UCL:
		case NLPARAMGRIDCOLTYPE_NAME_DUP:
		//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
		case NLPARAMGRIDCOLTYPE_LB_CONTROL:
		case NLPARAMGRIDCOLTYPE_UB_CONTROL:
		//------ End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
		case NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE:///Jasmine 07/15/10 ORG-486-S1 ADD_PEAK_ATTRIB_TO_NLFIT
		///------ Folger 11/11/2010 ORG-1169-S1 ADD_INPUT_DATA_RANGE_IN_NLFIT_PARAMETER_TABLE
		case NLPARAMGRIDCOLTYPE_DATARANGE:
		///------ End ADD_INPUT_DATA_RANGE_IN_NLFIT_PARAMETER_TABLE
		
			bEditable = false;
			break;
		//disable editing if bound setting is disabled
		case NLPARAMGRIDCOLTYPE_LB:
			///Sophy 1/21/2009 v8.0962b SHOULD_CHECK_ROW_AND_COL_OFFSET
			//string str = m_flx.Cell(flexcpTextDisplay, nRow, NLPARAMGRIDCOLTYPE_LB_CONTROL);//GRID_COL_LB_ON);
			string str = GetCell(flexcpTextDisplay, nRow, NLPARAMGRIDCOLTYPE_LB_CONTROL + GetColOffset());//GRID_COL_LB_ON);
			///end SHOULD_CHECK_ROW_AND_COL_OFFSET
			if(!str.CompareNoCase(STR_BOUNDS_CONTROL_DISABLE))
				bEditable = false;
			break;
		case NLPARAMGRIDCOLTYPE_UB:
			///Sophy 1/21/2009 v8.0962b SHOULD_CHECK_ROW_AND_COL_OFFSET
			//string str = m_flx.Cell(flexcpTextDisplay, nRow, NLPARAMGRIDCOLTYPE_UB_CONTROL);//GRID_COL_UB_ON);
			string str = GetCell(flexcpTextDisplay, nRow, NLPARAMGRIDCOLTYPE_UB_CONTROL + GetColOffset());//GRID_COL_UB_ON);
			///end SHOULD_CHECK_ROW_AND_COL_OFFSET
			if(!str.CompareNoCase(STR_BOUNDS_CONTROL_DISABLE))
				bEditable = false;
			break;
		case NLPARAMGRIDCOLTYPE_SHARE:
			break;
		case NLPARAMGRIDCOLTYPE_FUNC_NAME:		
			break;
		default:
			string strRet = GetCell(flexcpText, nRow, nCol);
			if(!is_numeric(strRet) && strRet.CompareNoCase("--"))//it isn't missing value, either
			{
				return;
			}
			m_strOldValue = strRet;
			break;
		}
		if(!bEditable)
			*pCancel = true;
		///end NLF_81 Sophy
		return;
	}

	///Jasmine 07/19/10 ORG-486 NOT_ALLOW_USER_EDIT_TO_PREVENT_WRONG_STRING
	string ConstructPeakAttributeString(bool bOffsetParam, bool bMultiIndepVar)
	{
		vector<string> vsPeakInfo;
		
		if(bOffsetParam)
		{
			vsPeakInfo.SetSize(1);
			vsPeakInfo[0] = STR_OFFSET_PEAK_INFO;
		}
		else
		{
			vsPeakInfo.Add(STR_X_CENTER_PEAK_INFO);
			vsPeakInfo.Add(STR_X_WIDTH_PEAK_INFO);
			
			if(bMultiIndepVar)
			{
				vsPeakInfo.Add(STR_Y_CENTER_PEAK_INFO);
				vsPeakInfo.Add(STR_Y_WIDTH_PEAK_INFO);
			}
	
			vsPeakInfo.Add(STR_AMPLITUDE_PEAK_INFO);	///Kyle 11/07/2008 QA80-12509-P1 ADD_PEAK_AMPLITUDE_INTO_CONTROL_SESSION_OF_FO
		}
		
		string strPeakInfoLilst;
		strPeakInfoLilst.SetTokens(vsPeakInfo, '|');
		return strPeakInfoLilst;
	}
	///End NOT_ALLOW_USER_EDIT_TO_PREVENT_WRONG_STRING
	
	/// Hong 12/10/08 v8.0984d ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
	bool	ApplyToAll(int nRow, int nCol)
	{
		if( nRow >= 0 && nRow < GetRowOffset() || nCol >= 0 && nCol < GetColOffset() )
			return false;
		
		string			strCell = GetCell(nRow, nCol);
		vector<string>		vstrCells;
		vstrCells.SetSize(GetNumRows());
		for ( int ii = 0; ii < vstrCells.GetSize(); ii++ )		
			vstrCells[ii] = strCell;
		
		if ( !SetCells(vstrCells, nCol) )
			return false;
		
		for ( int nn = GetRowOffset(); nn < GetRows(); nn++ )
			OnAfterEdit(nn, nCol);

		return true;		
	}
	/// end ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
	
public:
	bool	SetNLParamsMngr(NLParametersManager *pNLParamsMngr)
	{
		m_pNLParamsMngr = pNLParamsMngr;
		return true;
	}
 	
public:	
	///Kyle 09/12/08 CHECK_BOUNDS_AND_CHANGE_COLOR_OF_LB_AND_UB
	//virtual
	void	OnButtonClick(Control cntrl, int nRow, int nCol)
	{
		GridTableControl::OnButtonClick(cntrl, nRow, nCol);
		updateBoundCellsColor(nRow);
	}
	///End CHECK_BOUNDS_AND_CHANGE_COLOR_OF_LB_AND_UB

	void SetShowCols(int nOption)
	{
		ShowGroup(nOption);
		//doing, how to show/hide share column in customized tabs
		switch(nOption)
		{
		case GROUP_NORMAL:
			updateHideSharedCol(false);				///Kyle 09/11/08 HIDE_SHARED_COL_WHEN_THERE_IS_SINGLE_DATE_SET
			break;
		case GROUP_BOUNDS:
			break;
		default:
			break;
		}		
	}
	///Jasmine 10/30/08 QA80-12425 THE_NAMEDUP_COL_NEED_A_UNIQUE_NAME_IN_CONFIGURATION
	///------ Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
	//void ConvertColNameToIndex(const vector<string>& vsNames, vector<int>& vnIndexes)
	void ConvertColNameToIndex(const vector<string>& vsNames, vector<int>& vnIndexes, bool bUseEnglish = false)
	///------ End PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
	{
		vnIndexes.RemoveAll();
		
		int nSize = vsNames.GetSize();
		if(nSize > 0)
		{
			///------ Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
			//string 			strHeaders = STR_NLFIT_PARACONTRO_GRID_COLS;
			string 			strHeaders = bUseEnglish ? STR_NLFIT_PARACONTRO_GRID_COLS_E : STR_NLFIT_PARACONTRO_GRID_COLS;
			///------ End PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
			vector<string> 	vsHeaders;
			///Jasmine 07/22/10 ORG-589-P3 CHANGED_COLUMN_NAME_NEED_CONVERT
			//if(strHeaders.GetTokens(vsHeaders, '|') > NLPARAMGRIDCOLTYPE_NAME_DUP)
				//vsHeaders[NLPARAMGRIDCOLTYPE_NAME_DUP] = _get_alias( vsHeaders[NLPARAMGRIDCOLTYPE_NAME_DUP] );
			strHeaders.GetTokens(vsHeaders, '|');
			convertColumnNameGUIToINI(vsHeaders, bUseEnglish);
			///End CHANGED_COLUMN_NAME_NEED_CONVERT
			
			for(int ii = 0; ii < nSize; ii++)
			{
				int nIndex = vsHeaders.Find( vsNames[ii] );
				vnIndexes.Add(nIndex);//nIndex may be -1, but not care here
			}
		}
		
		ASSERT( vsNames.GetSize() == vnIndexes.GetSize() );
	}
	///------ Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
	//void ConvertColIndexToName(const vector<int>& vnIndexes, vector<string>& vsNames)
	void ConvertColIndexToName(const vector<int>& vnIndexes, vector<string>& vsNames, bool bUseEnglish = false)
	///------ End PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
	{
		vsNames.RemoveAll();
		
		int nSize = vnIndexes.GetSize();
		if(nSize > 0)
		{
			///------ Folger 03/03/09 PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
			//string 			strHeaders = STR_NLFIT_PARACONTRO_GRID_COLS;
			string 			strHeaders = bUseEnglish ? STR_NLFIT_PARACONTRO_GRID_COLS_E : STR_NLFIT_PARACONTRO_GRID_COLS;
			///------ End PARAMETER_TABS_LOADING_AND_SAVING_FAILS_IN_NON_ENGLISH_ORIGIN
			vector<string> 	vsHeaders;
			int nCount = strHeaders.GetTokens(vsHeaders, '|');
			///Jasmine 07/22/10 ORG-589-P3 CHANGED_COLUMN_NAME_NEED_CONVERT
			convertColumnNameGUIToINI(vsHeaders, bUseEnglish);
			///End CHANGED_COLUMN_NAME_NEED_CONVERT
			for(int ii = 0; ii < nSize; ii++)
			{
				int		nIndex = vnIndexes[ii];
				string 	strName = nIndex < nCount? vsHeaders[nIndex] : "";
				///Jasmine 07/22/10 ORG-589-P3 CHANGED_COLUMN_NAME_NEED_CONVERT
				//if(NLPARAMGRIDCOLTYPE_NAME_DUP == nIndex)
					//strName = _get_alias(strName);
				///End CHANGED_COLUMN_NAME_NEED_CONVERT
				vsNames.Add(strName);
			}
		}
		
		ASSERT( vsNames.GetSize() == vnIndexes.GetSize() );
	}
	///End THE_NAMEDUP_COL_NEED_A_UNIQUE_NAME_IN_CONFIGURATION
	
	bool HideParamRows(const vector<int> & vnParamRowHide)
	{
		vector<bool> vbShows;
		vbShows = 1 - vnParamRowHide;
		ShowRows(vbShows);
		return updateSharedRowsShow();
	}
	
	virtual void UpdateShowCols(vector<uint>& vn, int nOption){;}	///Jasmine 07/03/07 v8.0654 NLSF_PARAM_GRID_FAIL_TO_SHOW_SHARE_COL_EVEN_DATA_MODE_IS_GLOBAL
	virtual string GetClassName(){return "NLFParamsControl";}
	virtual string GetFunctionList() { return ""; }/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	
protected:
	virtual bool IsBaselineParameter(int ii){return false;}			///Kyle 11/22/2008 NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
	virtual bool loadShowCol(vector<uint> &vn, int nOption = 0){return false;}

	/// Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT
	virtual bool QuickSetIsShowShareCol()
	{
		return false;
	}
	///end NOT_SHOW_SHARE_COL_FOR_NLFIT

	/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	string		getParamNamePrefix(int nRow)
	{
		nRow -= GetRowOffset();
		if ( nRow < 0 )
		{
			ASSERT(FALSE);
			return "";
		}
		
		vector<string> 		vsNames;
		m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsNames);
		if ( nRow >= vsNames.GetSize() )
		{
			ASSERT(FALSE);
			return "";
		}
		
		string 				strParamName = vsNames[nRow];
		if ( !IsBaselineParameter(nRow) )			///Kyle 11/22/2008 NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
		{
			int 		nIndex = strParamName.ReverseFind('_');
			if ( nIndex > 0 && nIndex < strParamName.GetLength() - 1 )	// skip the first and the last '_'
			{
				if ( NLPMGRTYPE_MULTIPLE_SETS != m_pNLParamsMngr->GetType() )			// two '_'
				{
					nIndex--;
					if(strParamName[nIndex] != '_')
						nIndex = -1;
				}
				if ( nIndex > 0 )
					strParamName = strParamName.Left(nIndex);
			}
		}			
		return strParamName;
	}
	
	/// Hong 03/05/09 FIX_APPLY_TO_ALL_LOST_VALUE_PRECISION
	double		GetCellFullPrecisionValue(int nRow, int nCol)
	{
		int			nRowZeroOffset, nColZeroOffset;
		nRowZeroOffset = nRow - GetRowOffset();
		nColZeroOffset = nCol - GetColOffset();
		
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nColZeroOffset;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		ParameterRow 	paramRow;
		if ( 0 != m_pNLParamsMngr->GetRow(paramRow, nRowZeroOffset) )
			return NANUM;
		switch ( nColType )
		{
		case NLPARAMGRIDCOLTYPE_SHARE:
			return paramRow.nShared;
			break;
		case NLPARAMGRIDCOLTYPE_FIXED:
			return paramRow.bFixed;
			break;
		case NLPARAMGRIDCOLTYPE_VALUE:
			return paramRow.rValue;
			break;
		case NLPARAMGRIDCOLTYPE_SD:
			return paramRow.nSignDigits;
			break;
		case NLPARAMGRIDCOLTYPE_LB:
			return paramRow.rLBValue;
			break;
		case NLPARAMGRIDCOLTYPE_LB_CONTROL:
			return paramRow.nLBControl;
			break;
		case NLPARAMGRIDCOLTYPE_UB_CONTROL:
			return paramRow.nUBControl;
			break;
		case NLPARAMGRIDCOLTYPE_UB:
			return paramRow.rUBValue;
			break;
		}
		return NANUM;
	}
	/// end FIX_APPLY_TO_ALL_LOST_VALUE_PRECISION
	/// Hong 09/03/10 ORG-576-S1 FIX_AMBIGUOUS_OVERLOAD
	// Hong, parameter lpcszUnused is just used to avoid ambiguous overload, see GridControl::GetCell(CellPropertySettings settings, int nRow, int nCol)
	//string		GetCell(int nRow, int nCol, bool bMatchParamMngr)
	string		GetCell(int nRow, int nCol, LPCSTR lpcszUnused)
	/// end FIX_AMBIGUOUS_OVERLOAD
	{
		string	strRet = GetCell(nRow, nCol);
		///Sophy 10/20/2008 NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		
		if( NLPARAMGRIDCOLTYPE_LB_CONTROL == nColType || NLPARAMGRIDCOLTYPE_UB_CONTROL == nColType )
		{
			int nValueIndex;
			if( ConvertValueToIndex( STR_BUTTON_CONTROL_COMBOLIST, strRet, nValueIndex ) )
				strRet.Format("%d", nValueIndex );
			ASSERT( nValueIndex >= 0 );
		}
		///end NOTIFY_VALUE_CHANGED_ON_CLICK_GRID_BUTTON
		return strRet;
	}
		
	bool		IsGroupCol(int nColType, string* pstrGroupName = NULL, vector<int>& vnCols = NULL)
	{
		bool			bIsGroupCol = false;
		vector<int>		vnBands = {NLPARAMGRIDCOLTYPE_LB, NLPARAMGRIDCOLTYPE_LB_CONTROL, NLPARAMGRIDCOLTYPE_UB, NLPARAMGRIDCOLTYPE_UB_CONTROL};
		if ( -1 != find_in_list(nColType, vnBands, false) )
		{
			bIsGroupCol = true;
			if ( NULL != pstrGroupName )
				*pstrGroupName = _L("Bounds");
			if ( NULL != vnCols )
				vnCols = vnBands;		
		}
		
		return bIsGroupCol;
	}
	/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	
private:
	///------ Folger 12/14/2010 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
	void	GetColumnEx(vector<string>& vsValues, int nColType)
	{
		vector<string>		vsFormat, vsCustomDisplay;
		m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_FORMAT, vsFormat);
		m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_CUSTOMDISPLAY, vsCustomDisplay);

		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nValueCol = GetColPos(NLPARAMGRIDCOLTYPE_VALUE);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nValueCol = NLPARAMGRIDCOLTYPE_VALUE;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		SetFormats(nValueCol, vsFormat, vsCustomDisplay);

		m_pNLParamsMngr->GetColumn(nColType, vsValues);
		FormatCells(vsValues, nValueCol);
	}

	BOOL	IsSupportFormatMenu(int nColType)
	{
		return NLPARAMGRIDCOLTYPE_VALUE == nColType
			|| NLPARAMGRIDCOLTYPE_UB == nColType
			|| NLPARAMGRIDCOLTYPE_LB == nColType;
	}
	///------ End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS

	virtual int getNumberBaselineParams() { return 0;}  /// Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT
	
	///Kyle 09/12/08 ADD_FUNCTION_TO_UPDATE_GRID_SHOW_AFTER_EDIT
	void updateGridShowAfterEdit(int nRow, int nCol)
	{
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		switch(nColType)
		{
		case NLPARAMGRIDCOLTYPE_LB:
		case NLPARAMGRIDCOLTYPE_UB:
			updateBoundCellsColor(nRow);
			break;
		case NLPARAMGRIDCOLTYPE_SD:
			updateParamValueShow(nRow);
			break;
		}
	}

	void updateParamValueShow(int nRow)
	{
		if(nRow<GetRowOffset() || nRow>=GetRows())
			return;

		vector<string> vsParamValues;
		///------ Folger 12/14/2010 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		//m_pNLParamsMngr->GetColumn( NLPARAMGRIDCOLTYPE_VALUE, vsParamValues );
		GetColumnEx(vsParamValues, NLPARAMGRIDCOLTYPE_VALUE);
		///------ End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nValueCol = GetColPos(NLPARAMGRIDCOLTYPE_VALUE);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nValueCol = NLPARAMGRIDCOLTYPE_VALUE;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		SetCell(nRow, nValueCol, vsParamValues[ nRow - GetRowOffset() ]);
	}
	///End ADD_FUNCTION_TO_UPDATE_GRID_SHOW_AFTER_EDIT
	
	
	///Kyle 09/11/08 HIDE_SHARED_COL_WHEN_THERE_IS_SINGLE_DATE_SET
	virtual void 	updateHideSharedCol(bool bHide = true)
	{
		if( !m_bIsAllowSharing )		// single set, always hide
			bHide = true;

		/// Bill 08/22/2011 ORG-2473 HIDE_SHARED_COL_SHOULD_USE_COL_POS
		//HideCol(NLPARAMGRIDCOLTYPE_SHARE, bHide);
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColPos = GetColPos(NLPARAMGRIDCOLTYPE_SHARE);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColPos = NLPARAMGRIDCOLTYPE_SHARE;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__	
		HideCol(nColPos, bHide);	
		/// End HIDE_SHARED_COL_SHOULD_USE_COL_POS
	}
	///End HIDE_SHARED_COL_WHEN_THERE_IS_SINGLE_DATE_SET
	
	///Kyle 09/11/08 PARAMS_WITH_THE_SAME_NAME_ONLY_SHOW_THE_FIRST_ROW_WHEN_SHARED_COL_CHECKED
	virtual bool  	updateSharedRowsShow()
	{
#ifndef _DEBUG_SHOW_HIDDEN_ROWS

		if( !m_bIsAllowSharing )		// single set
			return true;
		
		vector<int> 	vnBegin;
		if(0 >= m_pNLParamsMngr->GetGroupingRowsBegin(vnBegin))
			return true;

		vector<string> 	vsShared;
		m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_SHARE, vsShared);
		
		for(int nRow = vnBegin[0]; nRow<vsShared.GetSize(); nRow++)
		{
			///------ Folger 05/19/2011 ORG-2773-P2 HIDE_PARAMS_DIALOG_FAILED_IN_NLFIT
			/////------ Folger 05/05/2011 ORG-2773-P1 CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
			////if("1" == vsShared[nRow])
				////HideRow( nRow + GetRowOffset() );
			//HideRow( nRow + GetRowOffset(), "1" == vsShared[nRow] );
			/////------ End CLEAR_SHARED_IN_NLFIT_FAILED_TO_SHOW_HIDDEN_ROWS
			if ( "1" == vsShared[nRow] )
				HideRow( nRow + GetRowOffset() );
			///------ End HIDE_PARAMS_DIALOG_FAILED_IN_NLFIT
		}
		
#endif
		return true;
	}
	///End PARAMS_WITH_THE_SAME_NAME_ONLY_SHOW_THE_FIRST_ROW_WHEN_SHARED_COL_CHECKED
	
	/// Iris 9/05/2008 SUPPORT_MULTI_FUNC_FIT_PARAM_CONTROL
	virtual void initGroupColList(int nGroup, vector<int>& vnColLists)
	{
		vector<int> vnNormal = {NLPARAMGRIDCOLTYPE_PEAK_NO, NLPARAMGRIDCOLTYPE_NAME, NLPARAMGRIDCOLTYPE_MEANING, 
				NLPARAMGRIDCOLTYPE_FIXED, NLPARAMGRIDCOLTYPE_SHARE, NLPARAMGRIDCOLTYPE_VALUE, NLPARAMGRIDCOLTYPE_ERROR, NLPARAMGRIDCOLTYPE_DEPENDENCY,
				NLPARAMGRIDCOLTYPE_LCL, NLPARAMGRIDCOLTYPE_UCL, NLPARAMGRIDCOLTYPE_SD};
				
		vector<int> vnBounds = {	NLPARAMGRIDCOLTYPE_PEAK_NO, NLPARAMGRIDCOLTYPE_MEANING,	NLPARAMGRIDCOLTYPE_VALUE,
				NLPARAMGRIDCOLTYPE_LB,			// bound, lower limit
				NLPARAMGRIDCOLTYPE_LB_CONTROL,	// operator for lower bound
				NLPARAMGRIDCOLTYPE_NAME_DUP,NLPARAMGRIDCOLTYPE_UB_CONTROL,	NLPARAMGRIDCOLTYPE_UB};
		switch(nGroup)
		{
		case GROUP_NORMAL:	
			vnColLists = vnNormal;
			break;
		case GROUP_BOUNDS:
			vnColLists = vnBounds;
			break;
		case GROUP_ALL:
		default:
			///Jasmine 07/15/10 ORG-486-S1 ADD_PEAK_ATTRIB_TO_NLFIT
			//vnColLists.Data(NLPARAMGRIDCOLTYPE_PEAK_NO, NLPARAMGRIDCOLTYPE_UB, 1);
			vnColLists.Data(NLPARAMGRIDCOLTYPE_PEAK_NO, NLPARAMGRIDCOLTYPE_TOTAL-1, 1);
			///End ADD_PEAK_ATTRIB_TO_NLFIT
			break;
		}		
	}
	///end SUPPORT_MULTI_FUNC_FIT_PARAM_CONTROL
	
	///Jasmine 07/22/10 ORG-589-P3 CHANGED_COLUMN_NAME_NEED_CONVERT
#define STR_INI_NLFIT_PARACONTRO_GRID_COLS_E	"LB Value|LB|Param2|UB|UB Value"
#define STR_INI_NLFIT_PARACONTRO_GRID_COLS		_L(STR_INI_NLFIT_PARACONTRO_GRID_COLS_E)
	void 	convertColumnNameGUIToINI(vector<string>& vsColNames, bool bUseEnglish)
	{
		ASSERT(vsColNames.GetSize() == NLPARAMGRIDCOLTYPE_TOTAL);
		
		vector<string> vsININames;
		int nRet = str_separate(bUseEnglish? STR_INI_NLFIT_PARACONTRO_GRID_COLS_E : STR_INI_NLFIT_PARACONTRO_GRID_COLS, "|", vsININames);
		
		vector<int> vnIndexs = {NLPARAMGRIDCOLTYPE_LB, 
								NLPARAMGRIDCOLTYPE_LB_CONTROL, 
								NLPARAMGRIDCOLTYPE_NAME_DUP,
								NLPARAMGRIDCOLTYPE_UB_CONTROL, 
								NLPARAMGRIDCOLTYPE_UB};
		ASSERT(vnIndexs.GetSize() == nRet);
		
		for(int ii = 0; ii < nRet; ii++)
		{			
			int 	nIndex 		= vnIndexs[ii];
			string 	strININame 	= vsININames[ii];
			vsColNames[nIndex]	= strININame; 
		}
		
		return;
	}
	///End CHANGED_COLUMN_NAME_NEED_CONVERT
	
	//---Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	//virtual 
	int getGroupDefaultShows(vector<uint>& vnDefaultShows, int nGroup = -1)
	{
		vnDefaultShows.SetSize(NLPARAMGRIDCOLTYPE_TOTAL);
		
		switch(nGroup)
		{
		case GROUP_NORMAL:
		case GROUP_BOUNDS:	
			vector<int> vnColLists;
			initGroupColList(nGroup, vnColLists);
			vnDefaultShows = 0;
			for(int nSize = vnColLists.GetSize(), ii = 0; ii < nSize; ii++) 
				vnDefaultShows[ vnColLists[ii] ] = 1;
			break;
			
		default:
			GridTableControl::getGroupDefaultShows(vnDefaultShows, nGroup);
			break;
		}
		
		return vnDefaultShows.GetSize();
	}
	//---end
	
	/// Hong QA80-10937 FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
	bool expandSettingsRemoveBySharing(bool bShared = true, bool bUpdateLocalShared = true)
	{
		bool bUpdate = true;	
		_NLF_81(expandSettingsRemoveBySharing);		
		return bUpdate;
	}
	/// end FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
	
	bool	isNumericCol(int nCol)
	{
		/// NLF_81 Iris
		/*
		if( nCol == GRID_COL_MEANING ||  nCol == GRID_COL_PEAK_TYPE)
			return false;
		*/
		_NLF_81(isNumericCol);
		///end NLF_81
		
		return true;
	}
	
	virtual int 	rowToParamIndex(int nRow1) {return nRow1 - GetRowOffset();}


public:
	bool SetVisible( bool bSetVisible  = false)
	{
		return ResizeControl::SetVisible( bSetVisible );
	}
	
protected:	
	///Jasmine 05/26/06 SET_CELL_DISABLE_AND_GRAY
	void SetCellFontGray(int nRow, int nCol, bool bGray = true)		///Jasmine 04/10/08 CANNOT_SHARE_BASELINE_PARAMETER, MultiFuncFitParamsControl wants it
	{
		if(nRow < GetRowOffset() || nRow > GetRows() || nCol < GetColOffset() || nCol > GetCols())
			return;
		uint nColor = bGray? COLOR_GRAY: COLOR_BLACK;
		SetCellProperty(flexcpForeColor, nColor, nRow, nCol);		
	}
	///End SET_CELL_DISABLE_AND_GRAY
	
	///Kyle 11/05/2008 GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
	////------ Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
	///// virtual
	//void	GetColMenuDisableItems(vector<bool>& vbItemsDisable)
	//{
		//GridTableControl::GetColMenuDisableItems(vbItemsDisable);
		//if ( !m_bIsAllowSharing )
		//{
			//ASSERT(NLPARAMGRIDCOLTYPE_SHARE < vbItemsDisable.GetSize());
			//vbItemsDisable[NLPARAMGRIDCOLTYPE_SHARE] = true;
		//}
	//}	
	////------ End SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
	// virtual
	void GetColDisable(vector<int>& vnColDisable)
	{
		GridTableControl::GetColDisable(vnColDisable);

		if ( !m_bIsAllowSharing )
		{
			vnColDisable.Add(NLPARAMGRIDCOLTYPE_SHARE);
		}
	}	
	///End GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
	
private: 
	//---- Iris to do , need move to util files as global funciton
	void vb_to_vs(const vector<bool>& vb, vector<string>& vs)
	{
		vs.SetSize(vb.GetSize());
		for(int ii = 0; ii < vb.GetSize(); ii++)
			vs[ii] = vb[ii]? "1":"0";
	}
	void vs_to_vb(const vector<string>& vs, vector<bool>& vb)
	{
		vb.SetSize(vs.GetSize());
		for(int ii = 0; ii < vb.GetSize(); ii++)
			vb[ii] = atoi(vs[ii]) > 0? true:false;		
	}
	//---- 
	
	/// Iris 10/30/2008 v8.0963b DISABLE_BASELINE_PARAMETER_SHARE_CELL
	virtual void updateCellsColor(int nRow = -1)
	{
		updateBoundCellsColor(nRow);
	}
	///end DISABLE_BASELINE_PARAMETER_SHARE_CELL

	///Kyle 09/12/08 CHECK_BOUNDS_AND_CHANGE_COLOR_OF_LB_AND_UB
	void updateBoundCellsColor(int nRow = -1)
	{
		int nRowEnd;
		if(nRow<GetRowOffset() || nRow>=GetRows() )
		{
			nRow = GetRowOffset();
			nRowEnd = GetRows();
		}
		else
			nRowEnd = nRow + 1;
		
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nLBCol = GetColPos(NLPARAMGRIDCOLTYPE_LB);
		int nUBCol = GetColPos(NLPARAMGRIDCOLTYPE_UB);
		int nLBCtrlCol = GetColPos(NLPARAMGRIDCOLTYPE_LB_CONTROL);
		int nUBCtrlCol = GetColPos(NLPARAMGRIDCOLTYPE_UB_CONTROL);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nLBCol = NLPARAMGRIDCOLTYPE_LB;
		int nUBCol = NLPARAMGRIDCOLTYPE_UB;
		int nLBCtrlCol = NLPARAMGRIDCOLTYPE_LB_CONTROL;
		int nUBCtrlCol = NLPARAMGRIDCOLTYPE_UB_CONTROL;		
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		for(; nRow < nRowEnd; nRow++)
		{
			string strLB, strUB, strLBCtrl, strUBCtrl;
			strLB = 	GetCell(nRow, nLBCol);
			strUB = 	GetCell(nRow, nUBCol);
			strLBCtrl = GetCell(nRow, nLBCtrlCol);
			strUBCtrl = GetCell(nRow, nUBCtrlCol);
			double dLB, dUB;
			dLB = atof( strLB );
			dUB = atof( strUB );
			
			//------ Folger 10/20/08 SHOW_PROPER_BOUNDS_VALUE_COLOR_WHEN_EDIT_BOUNDS_CONTROL
			//if(strLB.Compare("--")==0 || strUB.Compare("--")==0 || strLBCtrl.Compare("NA")==0 || strUBCtrl.Compare("NA")==0 || dUB > dLB)
			//{
				//SetCellColor( nRow, NLPARAMGRIDCOLTYPE_LB, COLOR_BLACK);
				//SetCellColor( nRow, NLPARAMGRIDCOLTYPE_UB, COLOR_BLACK);
				//continue;
			//}
			
			bool	bLBDisable = strLBCtrl.Compare(STR_BOUNDS_CONTROL_DISABLE)==0;
			bool	bUBDisable = strUBCtrl.Compare(STR_BOUNDS_CONTROL_DISABLE)==0;
			if ( bLBDisable || bUBDisable )
			{
				if ( bLBDisable )
					SetCellColor( nRow, nLBCol, COLOR_GRAY);
				else
					SetCellColor( nRow, nLBCol, COLOR_BLACK);
				
				if ( bUBDisable )
					SetCellColor( nRow, nUBCol, COLOR_GRAY);
				else
					SetCellColor( nRow, nUBCol, COLOR_BLACK);
				
				continue;
			}
			//------ End SHOW_PROPER_BOUNDS_VALUE_COLOR_WHEN_EDIT_BOUNDS_CONTROL
	
			//------ Folger 10/20/08 SHOW_PROPER_BOUNDS_VALUE_COLOR_WHEN_EDIT_BOUNDS_CONTROL
			//if(dUB < dLB || strLBCtrl=="<" || strUBCtrl=="<")
			if ( dUB < dLB )
			//------
			{
				SetCellColor( nRow, nLBCol, COLOR_RED);
				SetCellColor( nRow, nUBCol, COLOR_RED);
			}
			else
			{
				SetCellColor( nRow, nLBCol, COLOR_BLACK);
				SetCellColor( nRow, nUBCol, COLOR_BLACK);
			}
		}
	}
	///End CHECK_BOUNDS_AND_CHANGE_COLOR_OF_LB_AND_UB

	///------ Folger 06/08/2011 ORG-2740 SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT
	void	UpdateActiveDatasetBKColor(int nActiveDataset)
	{
		if ( nActiveDataset < 0 )
			return;

		int			nOffset = m_pNLParamsMngr->GetNumParamsInFunc();
		int			nR1 = GetRowOffset() + nOffset * nActiveDataset, nR2 = nR1 + nOffset - 1;
		int			nC1 = 0, nC2 = nC1 + GetNumCols() - 1;
		SetCellProperty(flexcpBackColor, color_index_to_rgb(SYSCOLOR_ORANGE), nR1, nC1, &nR2, &nC2);
	}
	///------ End SUPPORT_FIT_SINGLE_SET_FOR_MULTIPLE_SETS_INDEPENDENT_FIT

protected:
	Tree 			m_trQuickSet;		///Kyle 10/22/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL

	NLParametersManager		*m_pNLParamsMngr;
	string 					m_strOldValue; ///NLF_81 Sophy
	
	bool 					m_bIsAllowSharing;			///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
	
	/// Iris 10/30/2008 v8.0963b DISABLE_BASELINE_PARAMETER_SHARE_CELL
	//vector<int> 		m_vnBaseLineParamIndices;			///Kyle 09/27/08 SET_BASE_LINE_PARAM_INDICES_TO_CONTROL
	///end DISABLE_BASELINE_PARAMETER_SHARE_CELL

	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	MoveColHelper			*m_colMap;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
};

///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL, Kyle moved it from ParameterDlg.h
static bool _bound_option_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	if(ONODETYPE_RADIOS_BY_INDEX == nType && nRow > 0 && trNode)
	{
		string strLabel = "Value";
		
		int option = trNode.nVal;
		switch(option)
		{
		case NLPARAMETER_BOUNDS_SET_BY_RELATIVE_OFFSET:	
			strLabel = "Percentage of current value(%)";
			break;
		case NLPARAMETER_BOUNDS_SET_BY_ABSOLUTE_OFFSET:	
			strLabel = "Fixed amount";
			break;
		default:
			trNode.nVal = NLPARAMETER_BOUNDS_SET_BY_CONSTANT;
		}
		
		TreeNode trParent = trNode.Parent();
		trParent.boundvalue.SetAttribute(STR_LABEL_ATTRIB, strLabel);
		return true;
	}
	
	return false;
}
///End QUICK_SET_ONE_PARAM_VALUE_TO_ALL

/// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
static	int quick_set_event_func(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{	
	TreeNode trControlObj = tr.GetNode(STR_TAG_GRID_CONTROL_OBJ);
	if( !trControlObj )
		return 0;
	
	NLFParamsControl* pControl = NULL;
	ODWP dw = (ODWP)trControlObj.oipVal;
	pControl = (NLFParamsControl*)dw;	

			
	if( GETNE_ON_APPLY == nEvent && pControl)
	{
		int nUpdateParts = pControl->OnQuickSetApply(tr); // doing, need go on after parameter changed, like update preview
	}
	
	if( nRow >= 0 && pControl )// change event 
	{		
		pControl->OnQuickSetChanged(tr, nRow);			
	}
		
	return 0;	
}
///end QUICK_SET_DLG_ADD_APPLY_BUUTON

#endif //_NLF_PARAMS_CONTROL_H_
