/*------------------------------------------------------------------------------*
 * File Name:NLFitParasColControl.h												*
 * Creation: Hong 01/30/08														*
 * Purpose: OriginC Header file for general vsFlexGrid control					*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////

#ifndef _NLFIT_PARAS_COL_CONTROL_H_
#define _NLFIT_PARAS_COL_CONTROL_H_

// move from NLFitting.h
class NLFitParamsColControl : public NLFitParamsControl
{
public:
	NLFitParamsColControl() : NLFitParamsControl()
	{		
		loadShowCol(m_vnNormalSettingsShow, COL_SHOW_NORMAL);
		loadShowCol(m_vnParaBoundsShow, COL_SHOW_BOUND);
	}
	~NLFitParamsColControl()
	{
	}
	
public:
	void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	void UpdateShowCols(vector<uint>& vn, int nOption);
	string GetClassName(){return "NLFitParamsColControl";}
	
private:
	bool loadShowCol(vector<uint> &vn, int nOption = 0);
};

////////////////////////////////////////////////////////////////////////////////////
/////////////// Implemetation of class NLFitParamsColControl ///////////////////////
////////////////////////////////////////////////////////////////////////////////////
void NLFitParamsColControl::UpdateShowCols(vector<uint>& vn, int nOption)
{
	switch(nOption)
	{
	case COL_SHOW_NORMAL:
		vn[GRID_COL_SHARE] = !IsAllowedShared();
		vn[GRID_COL_NO] = !IsShowPeakCols();
		vn[GRID_COL_PEAK_TYPE] = !IsShowPeakCols();
		break;
	default:
		break;
	}
}

void NLFitParamsColControl::OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
	int nRow = m_flx.MouseRow;
	int nCol = m_flx.MouseCol;
	if(MK_RBUTTON != nButton || 0 != nShift)
		return;
	int nx = XTwipsToPixels(X);
	int ny = YTwipsToPixels(Y);
	ClientToScreen(nx, ny);
	//printf("nx = %d, ny = %d\n", nx, ny);
	NLFParametersControlMenu	myMenu( IsInGrid(nRow, nCol));
	myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd());
	int nCmd;
	if(myMenu.GetCommand(nCmd))
	{
		switch(nCmd)
		{
		case NLFPCMENU_HIDE:
			switch(m_nCurShow)
			{
			case COL_SHOW_ALL:
				break;
			case COL_SHOW_NORMAL:
				m_vnNormalSettingsShow[nCol] = COL_HIDE;
				break;
			case COL_SHOW_BOUND:
				m_vnParaBoundsShow[nCol] = COL_HIDE;
				break;
			case COL_SHOW_NONE:
			default:
				return;
			}						
			HideCol(nCol);
			break;
		case NLFPCMENU_SHOW_ALL:
			switch(m_nCurShow)
			{
			case COL_SHOW_NORMAL:
				loadShowCol(m_vnNormalSettingsShow, m_nCurShow);
				ShowCols(m_vnNormalSettingsShow);
				break;
			case COL_SHOW_BOUND:
				loadShowCol(m_vnParaBoundsShow, m_nCurShow);
				ShowCols(m_vnParaBoundsShow);
				break;
			case COL_SHOW_NONE:
			case COL_SHOW_ALL:
			default:
				m_nCurShow = COL_SHOW_ALL;
				vector<uint> vn;
				loadShowCol(vn, m_nCurShow);
				ShowCols(vn);
				break;
			}
			break;
		}
	}
}

bool NLFitParamsColControl::loadShowCol(vector<uint> &vn, int nOption)
{
	vector<uint> vnIndex;
	m_nCurShow = nOption;
	switch(nOption)
	{
	case COL_SHOW_NONE:
		break;
	case COL_SHOW_NORMAL:	
		vector<uint> vnSettingIndex = { GRID_COL_NO,
										GRID_COL_PEAK_TYPE,
										GRID_COL_NAME,
										GRID_COL_MEANING,
										GRID_COL_SHARE,
										GRID_COL_FIXED,
										GRID_COL_VALUE,
										GRID_COL_ERR,
										GRID_COL_DEPENDENCY,
										GRID_COL_SIGN_DIGITES,
										GRID_COL_LCONF,
										GRID_COL_UCONF};
		vnIndex = vnSettingIndex;
		break;
	case COL_SHOW_BOUND:
		vector<uint> vnBoundIndex = { 	///Jasmine 05/08/06 REORDER_COLUMNS
										//GRID_COL_NAME, 
										//GRID_COL_CONSTRAINTS,
										//GRID_COL_LB_ON,//GRID_COL_L_EXCLUSIVE,//change to GRID_COL_LB_ON later//changed	///Jasmine 05/23/06 MOVE_DISABLE_IN_CONTROL
										GRID_COL_LB, 
										GRID_COL_LB_CONTROL,
										GRID_COL_NAME_DUP,
										GRID_COL_UB_CONTROL,
										///End REORDER_COLUMNS
										GRID_COL_UB};
										//GRID_COL_UB_ON };//GRID_COL_U_EXCLUSIVE };//change to GRID_COL_UB_ON later	///Jasmine 05/23/06 MOVE_DISABLE_IN_CONTROL
		vnIndex = vnBoundIndex;
		break;
	default:
		m_nCurShow = COL_SHOW_ALL;
		vnIndex.SetSize(GRID_COL_TOTAL);
		for(int ii = 0; ii < GRID_COL_TOTAL; ii++)
			vnIndex[ii] = ii;
		break;
	}
	vn.RemoveAll();
	vn.SetSize(GRID_COL_TOTAL);
	vn = COL_HIDE;
	for(int n=0; n< vnIndex.GetSize(); n++)
		vn[vnIndex[n]] = COL_SHOW;
	
	UpdateShowCols(vn, nOption);
	return true;
}

#endif // _NLFIT_PARAS_COL_CONTROL_H_