/*------------------------------------------------------------------------------*
 * File Name:MultiFuncFParaControl.h											*
 * Creation: Hong 01/30/08														*
 * Purpose: OriginC Header file for general vsFlexGrid control					*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 03/31/08 ALLOW_CHANGE_FUNCTION_IN_PARAM_DLG							*
 *	Jasmine 04/10/08 CANNOT_SHARE_BASELINE_PARAMETER							*
 *  Iris 5/08/2008 ADD_PEAK_NO_COL_TO_BOUND_TAB									*
 *	Kyle 09/09/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL			*
 *	Kyle 09/11/08 HIDE_SHARED_COL_WHEN_THERE_IS_SINGLE_DATE_SET					*
 *	Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION								*
 *	Kyle 10/23/08 PEAK_FIT_DO_NOTHING_IN_UPDATESHAREDROWSSTATE					*
 *	Kyle 11/22/2008 NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
 *	Sophy 12/3/2008 v8.0982 ALLOW_EDIT_ANY_CELL_VALUE_OF_ONE_GROUP				*
 *	Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT								*
 *	Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS					*
 *	Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE		*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////

#ifndef _MULTI_FUNC_FIT_PARAS_CONTROL_H_
#define _MULTI_FUNC_FIT_PARAS_CONTROL_H_

////move from PFMParameterDlg.h

//------ Folger 03/25/08 QA80-11304 CLEAN_UP_CODE_ABOUT_FIT_PARAMETERS_CONTROL
#define 	STR_SHARE_GROUP_LIST		"|0|1|2|3|4|5|6|7|8|9"

#define 	STR_BASELINE_FUNCS_ATTRIB	"BaselineFunctions"		///Jasmine 03/31/08 ALLOW_CHANGE_FUNCTION_IN_PARAM_DLG

class MultiFuncFParamsControl : public NLFParamsControl
{
public:
	///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
	//MultiFuncFParamsControl(bool bMulFunc = true) : NLFParamsControl()
	MultiFuncFParamsControl(LPCSTR lpcszPeakFunc, LPCSTR lpcszBaselineFunc, bool bMulFunc = true) : NLFParamsControl()
	///------ End NANOSIZER_FITTING_BASED_SUPPORT
	{		
		m_bMulFunc = bMulFunc;
		///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
		m_strPeakFunc = lpcszPeakFunc;
		m_strBaselineFunc = lpcszBaselineFunc;
		///------ End NANOSIZER_FITTING_BASED_SUPPORT
	}
	~MultiFuncFParamsControl()
	{
	}	
	//virtual
	//void Init(int nID, Dialog& dlg,LPCSTR lpcszDlgName)///---Jasmine 05/26/10 ORG-2 CHANGE_DLG_TYPE_FOR_PROPERTY_PAGE
	void Init(int nID, WndContainer& dlg,LPCSTR lpcszDlgName)
	{
		NLFParamsControl::Init(nID, dlg, lpcszDlgName);
		
		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColPos = GetColPos(NLPARAMGRIDCOLTYPE_SHARE);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColPos = NLPARAMGRIDCOLTYPE_SHARE;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
		
		SetColDataType(nColPos, flexDTString);
		SetColComboList(nColPos, STR_SHARE_GROUP_LIST);
		SetVisible(true);
	}
	//virtual
	///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
	//bool Update(int nNumParaInFunc, int nNumDataSets = -1)
	//bool Update(bool bAllowSharing)
	/////End USE_ISALLOWSHARING_IN_NLFSESSION
	//{	
		/////Kyle 09/08/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
		////if(NLFParamsControl::Update(nNumParaInFunc, nNumDataSets))
		////{
			////TreeNode trParameter = GetParamTree();
			////TreeNode trPeakType = trParameter.PeakType;
			////string strBaselineFunc;
			////if(trPeakType && trPeakType.GetAttribute(STR_NAME_ATTRIB, strBaselineFunc))
			////{
				////string 	strNO = m_flx.Cell(flexcpText, GetRowOffset(), GRID_COL_NO);
				////for(int nRow = GetRowOffset(); nRow < m_flx.Rows; nRow++)
				////{
					////string str = m_flx.Cell(flexcpText, nRow, GRID_COL_NO);
					////if(str.Compare(strNO))
						////break;
					////SetCell(nRow, GRID_COL_PEAK_TYPE, strBaselineFunc);
				////}
			////}
			////return true;
		////}
		//if(NLFParamsControl::Update(bAllowSharing))			///Kyle 09/26/08 USE_ISALLOWSHARING_IN_NLFSESSION
		//{
			//string strBaselineFunc = get_function_list(STR_PA_NLSF_CAT_BASELINE);
			//if( !strBaselineFunc.IsEmpty() )
			//{
				//string 	strNO = m_flx.Cell(flexcpText, GetRowOffset(), NLPARAMGRIDCOLTYPE_PEAK_NO);
				//for(int nRow = GetRowOffset(); nRow < m_flx.Rows; nRow++)
				//{
					//string str = m_flx.Cell(flexcpText, nRow, NLPARAMGRIDCOLTYPE_PEAK_NO);
					//if(str.Compare(strNO))
						//break;
					//SetCell(nRow, NLPARAMGRIDCOLTYPE_FUNC_NAME, strBaselineFunc);
				//}
			//}
			//return true;
		//}
		/////End USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
		//return false;
	//}

	//virtual
	void OnBeforeEditParaControl(Control cntrl, long nRow, long nCol, BOOL* pCancel)
	{
		BOOL bCancel = false;

		/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
		/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

		///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
		//if(NLPARAMGRIDCOLTYPE_PEAK_NO == nCol || NLPARAMGRIDCOLTYPE_NAME == nCol || NLPARAMGRIDCOLTYPE_MEANING == nCol || NLPARAMGRIDCOLTYPE_NAME_DUP == nCol)
		if(NLPARAMGRIDCOLTYPE_PEAK_NO == nColType || NLPARAMGRIDCOLTYPE_NAME == nColType || NLPARAMGRIDCOLTYPE_UNIT == nColType || NLPARAMGRIDCOLTYPE_MEANING == nColType || NLPARAMGRIDCOLTYPE_NAME_DUP == nColType)
		///End ADD_UNIT_FOR_PARAMETER_SETTINGS
			bCancel = true;
		
		//if(!bCancel && GRID_COL_SHARE != nCol)
		if(!bCancel)
		{	
			if( NLPARAMGRIDCOLTYPE_SHARE == nColType )
			{
				int ii = rowToParamIndex(nRow);
				///Kyle 11/22/2008 NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
				//if( isBaselineParameter(ii) )
				if( IsBaselineParameter(ii) )
				///End NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
					bCancel = true;
			}
			///Sophy 12/3/2008 v8.0982 ALLOW_EDIT_ANY_CELL_VALUE_OF_ONE_GROUP
			//else
			//{
				////if share the bigger index parameter will use the same value as the smaller index parameter, so cannot edit the bigger index parameter 
				//int nIndex = rowToParamIndex(nRow);
				//vector<string> vsShared;
				//m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_SHARE, vsShared);
				//if(nIndex >= vsShared.GetSize())
				//{
					//error_report("out of vector index");
					//return;
				//}
				//string strShareGroup = vsShared[nIndex];
				//if("0" != strShareGroup && nIndex > vsShared.Find(strShareGroup))
				//{
					//bCancel = true;
				//}
			//}
			///end ALLOW_EDIT_ANY_CELL_VALUE_OF_ONE_GROUP
		}
		
		if(bCancel)
		{
			*pCancel = bCancel;
			return;
		}		
		
		if(NLPARAMGRIDCOLTYPE_FUNC_NAME == nColType)
		{
			string strFunctions;
			///Kyle 11/22/2008 NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
			//if( m_pNLParamsMngr->GetBaselineFittingWithPeaks() && isBaselineParameter( nRow - GetRowOffset() ) )
			if( m_pNLParamsMngr->GetBaselineFittingWithPeaks() && IsBaselineParameter( nRow - GetRowOffset() ) )
			///End NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
				///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
				//strFunctions = get_function_list( STR_PA_NLSF_CAT_BASELINE );
				strFunctions = get_function_list( m_strBaselineFunc );
				///------ End NANOSIZER_FITTING_BASED_SUPPORT
			else
				///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
				//strFunctions = get_function_list( STR_PA_NLSF_CAT_PEAK );
				strFunctions = get_function_list( m_strPeakFunc );
				///------ End NANOSIZER_FITTING_BASED_SUPPORT
			if( !strFunctions.IsEmpty() )
			{
				SetColComboList(NLPARAMGRIDCOLTYPE_FUNC_NAME, strFunctions);
			}
		}
		
		NLFParamsControl::OnBeforeEditParaControl(cntrl, nRow, nCol, pCancel);
	}
	///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
	//string GetClassName(){return "MultiFuncFParamsControl";}
	string GetClassName(){return m_bMulFunc ? "MultiFuncFParamsControl" : "NanoFuncFParamsControl";}
	///------ End NANOSIZER_FITTING_BASED_SUPPORT
private:
	//virtual
	void 	updateHideSharedCol(bool bHide = true){}		///Kyle 09/11/08 HIDE_SHARED_COL_WHEN_THERE_IS_SINGLE_DATE_SET
	
	/// Iris 10/30/2008 v8.0963b DISABLE_BASELINE_PARAMETER_SHARE_CELL
	//virtual 
	void updateCellsColor(int nRow = -1)
	{
		NLFParamsControl::updateCellsColor(nRow);
		
		for(int nParam = 0; nParam < getNumberBaselineParams(); nParam++)
		{
			int nRow = nParam + GetRowOffset();
			if ( nRow >= GetRows() )		/// Folger, 06/24/09, if no peak, then no need to SetCellColor
				break;
			SetCellFontGray(nRow, NLPARAMGRIDCOLTYPE_SHARE);
		}		
	}
	///end DISABLE_BASELINE_PARAMETER_SHARE_CELL

	//virtual
	bool  	updateSharedRowsShow(){return false;}			///Kyle 10/23/08 PEAK_FIT_DO_NOTHING_IN_UPDATESHAREDROWSSTATE
	
	///Kyle 09/08/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
	//virtual
	void initGroupColList(int nGroup, vector<int>& vnColLists)
	{
		vector<int> vnNormal = {NLPARAMGRIDCOLTYPE_PEAK_NO, NLPARAMGRIDCOLTYPE_FUNC_NAME, NLPARAMGRIDCOLTYPE_NAME, NLPARAMGRIDCOLTYPE_MEANING, 
				NLPARAMGRIDCOLTYPE_FIXED, NLPARAMGRIDCOLTYPE_SHARE, NLPARAMGRIDCOLTYPE_VALUE, NLPARAMGRIDCOLTYPE_ERROR, NLPARAMGRIDCOLTYPE_DEPENDENCY,
				NLPARAMGRIDCOLTYPE_LCL, NLPARAMGRIDCOLTYPE_UCL, NLPARAMGRIDCOLTYPE_SD};

		///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
		///!!! If modify vnNormal, needs to update nFuncCol to specify the correct function column
		const	int		nFuncCol = 1;
		if ( !m_bMulFunc )
			vnNormal.RemoveAt(nFuncCol);
		///------ End NANOSIZER_FITTING_BASED_SUPPORT
		
		if( GROUP_NORMAL == nGroup )
			vnColLists = vnNormal;
		else
			NLFParamsControl::initGroupColList(nGroup, vnColLists);		
	}
	///End USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL

	///Jasmine 04/10/08 CANNOT_SHARE_BASELINE_PARAMETER
	///Kyle 11/22/2008 NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
	//bool isBaselineParameter(int ii)
	// virtual
	bool IsBaselineParameter(int ii)
	///End NOFITPARACONTROL_NEED_TO_JUDGE_IF_ONE_ROW_IS_BASELINE_PARAMETER
	{
		/// Iris 10/30/2008 v8.0963b DISABLE_BASELINE_PARAMETER_SHARE_CELL
		/*
		///Kyle 09/08/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
		//if( ii >= m_vnPeakNOs.GetSize())
			//return false;
		//return 0 == ii || 0 == m_vnPeakNOs[ii];
		//vector<string> vsPeakNOs;
		//m_pNLParamsMngr->GetColumn(NLPARAMGRIDCOLTYPE_PEAK_NO, vsPeakNOs);
		//if(ii >= vsPeakNOs.GetSize())
			//return false;
		//return 0 == ii || "0" == vsPeakNOs[ii];			
		vector<uint> vnIndex;
		if(m_vnBaseLineParamIndices.Find(vnIndex, ii)>0)
			return true;
		else
			return false;
		//End USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
		*/
		if( m_pNLParamsMngr->GetBaselineFittingWithPeaks() )
		{
			return ii < getNumberBaselineParams();
		}	
		return 0 == ii;	
		///end DISABLE_BASELINE_PARAMETER_SHARE_CELL
	}
	///End CANNOT_SHARE_BASELINE_PARAMETER
	
	/// Iris 10/30/2008 v8.0963b DISABLE_BASELINE_PARAMETER_SHARE_CELL
	//virtual
	int getNumberBaselineParams()
	{
		if( m_pNLParamsMngr->GetBaselineFittingWithPeaks() )
		{
			const int nBaselinePeakIndex = 0;
			return m_pNLParamsMngr->GetNumParamsInFunc(nBaselinePeakIndex) - m_pNLParamsMngr->GetFunctionParameterOffset(nBaselinePeakIndex)
		}
		return 1;
	}
	///end DISABLE_BASELINE_PARAMETER_SHARE_CELL
	
	//virtual 
	int rowToParamIndex(int nRow1){return nRow1 - GetRowOffset();}
	///Kyle 09/09/08 USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL move from NLFParamsControl
	int paramIndexToRow(int index)
	{
		int nRow = index + GetRowOffset();
		if(nRow >= GetRows())
			return 0;
		return nRow;
	}
	///End USE_NEW_NLFPARAMSCONTROL_IN_MULTIFUNCFPARAMSCONTROL
protected:
	/// Iris 10/29/2008 QA80-12401-P5 NOT_SHOW_SHARE_COL_FOR_NLFIT
	virtual bool QuickSetIsShowShareCol()
	{
		return true;
	}
	///end NOT_SHOW_SHARE_COL_FOR_NLFIT

private:
	//Tree 				m_trParameter;
	bool				m_bMulFunc;
	///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
	string				m_strPeakFunc;
	string				m_strBaselineFunc;
	///------ End NANOSIZER_FITTING_BASED_SUPPORT
};
//------ End CLEAN_UP_CODE_ABOUT_FIT_PARAMETERS_CONTROL

#endif	//_MULTI_FUNC_FIT_PARAS_CONTROL_H_
