/*------------------------------------------------------------------------------*
 * File Name:MenuBase.h															*
 * Creation: CPY 6/14/2004														*
 * Purpose: OriginC Header for base menu class 									*
 * Copyright (c) Originlab Corp. 		2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 3/30/05 v8.0212 CLEAN_DUPLICATE_MORE										*
 *	ML 3/9/2006 STRANGE_MENU_BUILDING_BUG										*
 *	Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU						*
 *	CPY 5/13/08 MOVE_TRACK_MENU_POPUP_TO_BASE_CLASS								*
 *	Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
 *	Kyle 12/05/2008 ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU			*
 *	Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *------------------------------------------------------------------------------*/

#ifndef _MENUBASE_H_ 
#define _MENUBASE_H_

#include "theme_utils.h" /// Iris 7/11/2011 ORG-2629 CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS  

class	MenuBase	:	public	Menu
{
public:
	MenuBase()
	{
		m_nChoice = -1;
	}
	//----- CPY 5/13/08 MOVE_TRACK_MENU_POPUP_TO_BASE_CLASS
	/*
	virtual int DoTrackPopup(int nx, int ny, HWND hWndParent)
	{
		error_report("calling base class DoTrackPopup, implementation missing in derived class");
		return 0;
	}
	*/
	virtual int DoTrackPopup(int nx, int ny, HWND hWndParent)
	{
		TrackPopupMenu(0,  nx, ny, hWndParent);
		int nCmd;
		if(!GetCommand(nCmd))
			return -1;
		
		return nCmd;
	}
	//----- end MOVE_TRACK_MENU_POPUP_TO_BASE_CLASS
protected:
	void OnMenuItem(UINT nPos)
	{
		//out_int("OnMenuItem ",nPos);
		m_nChoice = nPos;
	}

	bool GetCommand(int& nChoice)
	{
		if(m_nChoice < 0)
			return false; // menu index must be 0,1,2,3 etc
		nChoice = m_nChoice;
		return true;
	}
private:
	int				m_nChoice;
};


class MenuTree : public Menu
{
	
public:
	
	MenuTree()
	{
	}
	MenuTree(TreeNode &tree)
	{
		m_trMenu = tree;
	}
	
	
	int		TrackPopupMenu(UINT nFlags,  int x, int y, HWND hwnd)
	{
		int nCmd = Menu::TrackPopupResMenu(nFlags,  x, y, hwnd);
		Handler(nCmd);
		return nCmd;
	}
	
	
	virtual void Handler(uint nCmd)
	{
		ASSERT(FALSE);
	}
protected:
	
	
	void createMenuFromTree()
	{
		BOOL bAddSeperator = FALSE;
		TreeNode tn = m_trMenu.FirstNode;
		for(; tn; tn = tn.NextNode)
		{
			if(TRGP_BRANCH == tn.ID)
			{
				if(bAddSeperator)
				{
					Add(NULL, 0, MF_SEPARATOR);
				}
				else
				{
					bAddSeperator = TRUE;
				}
				
				TreeNode tnMenuItem = tn.FirstNode;
				for(; tnMenuItem; tnMenuItem = tnMenuItem.NextNode)
				{
					if(TRGP_CHECK == tnMenuItem.ID)	
						addCheck(tnMenuItem);

				}
			}
		}
	}
	
	
	void addCheck(TreeNode &node)
	{
		int nID = 0;
		string strName;
		if(node.GetAttribute(STR_DATAID_ATTRIB, nID )  && (nID > 0)  && node.GetAttribute(STR_LABEL_ATTRIB, strName))
			AddChecked(strName, node.nVal, nID);
		else
			ASSERT(FALSE);
	}
	
	
	BOOL AddChecked(LPCSTR lpcszText, bool bChecked, int nID)
	{
		UINT nFlags = MF_STRING | (bChecked ? MF_CHECKED: 0);
		return Add(lpcszText, nID, nFlags);
	}

	
	
	
protected:	
	
	Tree	m_trMenu;
	
};



/////////////////////////////////////////////////////////////////////
// class ActionBase
/////////////////////////////////////////////////////////////////////
class ActionBase
{
public:
	virtual	bool	BuildMenuTree(TreeNode &tr)
					{ return false; }
					
					
	// Retuurns true if handled.	
	virtual	bool	HandleCommand(int nCmdId)
					{ return false; }
					
	// Retuurns true if handled.	
	virtual	bool	HandleCommand(int nCmdId, TreeNode &trCmd)
					{ return false; }
	
};


//#define		GETN_AMENU_GET_CMDID(_nId, _trNode)			_trNode.GetAttribute(STR_DATAID_ATTRIB, _nId)
#define		GETN_AMENU_GET_CMDID(_trNode)				_trNode.DataID
#define		GETN_AMENU_GET_TEXT(_strVal, _trNode)		_trNode.GetAttribute(STR_LABEL_ATTRIB, _strVal)


/////////////////////////////////////////////////////////////////////
// class MenuAction
/////////////////////////////////////////////////////////////////////
class	MenuAction : public MenuTree
{
public:
	MenuAction(ActionBase &actbase)
	{
		m_pactbase = &actbase;
	}
	
	
public:	
	int				DoMenu(UINT nFlags, int x, int y, HWND hwnd)
	{
		// Init the menu tree:
		if ( !InitMenuTree() )
			return -1;
		
		// Create the menu from the tree:
		if ( !CreateFromTree() )
			return -1;

		// Display the menu:
		int			nCmdId = Menu::TrackPopupResMenu(nFlags,  x, y, hwnd);
		if (nCmdId <= 0)
			return nCmdId;

		// First try to handle without the node:
		bool		bHandled = HandleCommand(nCmdId);
		if (bHandled)
			return nCmdId;
		
		TreeNode	trCmd;
		// Find the node:
		if ( !FindCmdNode(trCmd, nCmdId) )
		{
			error_report("FindCmdNode() failed!");	// should not happen
			return -1;
		}

		// Handle with the node:
		if ( !HandleCommand(nCmdId, trCmd) )
			error_report("Command not handled.");
		
		return nCmdId;

	}
	
protected:
	bool			InitMenuTree()
	{
		if ( !m_pactbase )
			return false;
		
		return m_pactbase->BuildMenuTree(m_trMenu);
	}
	
	bool			CreateFromTree()
	{
		TreeNode		tr = m_trMenu;
		if (!tr)
			return false;
		
		Create(TRUE);	// if this is not done and the first thing added is sub-popup, no menu appears
		
		return AddFromTreeNode(tr, *this);
	}
	
	bool			HandleCommand(int nCmdId)
	{
		return m_pactbase->HandleCommand(nCmdId);
	}

	bool			HandleCommand(int nCmdId, TreeNode &trCmd)
	{
		return m_pactbase->HandleCommand(nCmdId, trCmd);
	}

	
private:
	bool			FindCmdNode(TreeNode &trCmd, int nCmdId)
	{
		return FindCmdNode(trCmd, m_trMenu, nCmdId);
	}

	bool			FindCmdNode(TreeNode &trCmd, TreeNode &trNode, int nCmdId)
	{
		for (TreeNode tn = trNode.FirstNode; tn; tn = tn.NextNode)
		{
			if(TRGP_BRANCH == tn.ID)
			{
				if (FindCmdNode(trCmd, tn, nCmdId))
					return true;
			}
			else
			{
				int			nId = GETN_AMENU_GET_CMDID(tn);
				//GETN_AMENU_GET_CMDID(nId, tn);
				if (nId == nCmdId)
				{
					trCmd = tn;
					return true;
				}
			}
		}
		
		return false;
	}

	
	bool			AddFromTreeNode(TreeNode &trNode, Menu &menu)
	{
		for (TreeNode tn = trNode.FirstNode; tn; tn = tn.NextNode)
		{
			string		strText;
			GETN_AMENU_GET_TEXT(strText, tn);
			if (strText.IsEmpty())
				strText = tn.tagName;					// Eric Parent wants to use just the node name if no label
														// (say if it is some preexisting tree wihout labels).
			
			//if(TRGP_BRANCH == tn.ID)
			bool		bSubPopup = TRGP_BRANCH == tn.ID;
			if (!bSubPopup)								// again per Eric P's request.
				bSubPopup = 0 < tn.GetNodeCount();
			
			if(bSubPopup)
			{
				Menu		menuSub;
				/// ML 3/9/2006 STRANGE_MENU_BUILDING_BUG
				menuSub.Create(TRUE);
				/// end STRANGE_MENU_BUILDING_BUG				
				bool		bOK = AddFromTreeNode(tn, menuSub);
				
				if ( !bOK )
					return false;

				//GETN_AMENU_GET_TEXT(strText, tn);
				//if ( !menu.AddPopup(strText, menuSub) )
				//	error_report("menu.AddPopup() failed!");
				//
				
				// It appears that Menu::AddPopup() incorrectly returns BOOL. It actually may return 0 even if it succeeds,
				// so I am not testing the return value here.
				menu.AddPopup(strText, menuSub);
			}
			else
			{
				int			nId = GETN_AMENU_GET_CMDID(tn);
				//if ( 0 < nId && GETN_AMENU_GET_TEXT(strText, tn) && !strText.IsEmpty() )
				
				if ( 0 < nId )
				{
					menu.Add(strText, nId);
				}
			}
		}
		
		return true;
	}
	
private:
	ActionBase			*m_pactbase;
};

/// YuI 03/31/05 moved here from GetNBox.c
#ifdef _XV_ACTION_BASE_
class	TreeEditInputData;
class XVarActionBase : public ActionBase 
{
public:
	void		SetTreeCtrl(TreeEditInputData *pctrl)
		{ m_pctrl = pctrl; }
	void		SetTreeVarNode(TreeNode &trVar)
		{ m_tr = trVar; }
		
	TreeNode		GetTreeVarNode()
		{ return m_tr; }
		
protected:
	/// YuI 07/22/05 INTERACTIVE_CONTROL_SHOULD_BE_EDITABLE_IN_GRAPH
	virtual	bool	BuildMenuTree(TreeNode &tr);
	virtual	bool	HandleCommand(int nCmdId);
	/// end INTERACTIVE_CONTROL_SHOULD_BE_EDITABLE_IN_GRAPH
					
					
	virtual	bool	SupportsDataPopupNew(TreeNode &trVar)
		{ return false; }
	virtual	bool	SupportsDataPopupActive(TreeNode &trVar)
		{ return false; }
	/// YuI 07/22/05 INTERACTIVE_CONTROL_SHOULD_BE_EDITABLE_IN_GRAPH
	virtual	bool	SupportsDataPopupUnassigned(TreeNode &trVar)
		{ return true; } //support for all variables for now
	/// end INTERACTIVE_CONTROL_SHOULD_BE_EDITABLE_IN_GRAPH

	/// YuI 09/19/05 QA70-8119 SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT
	virtual	bool	SupportsDataPopupInput(TreeNode &trVar);
	/// end SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT

	bool			GetActiveDataplot(DataPlot &dpl);
	int				GetActiveLayer(GraphLayer &gl, Worksheet &wks, MatrixLayer &matlay);

	virtual	bool	SupportsPlotType(int nPlotId)
		{ return false; }
	
	virtual	bool	SupportsColumnType(int nColType)
		{ return false; }
		
		
		
protected:
	TreeEditInputData 	*m_pctrl;
	TreeNode			m_tr;
};
#endif //#ifdef _XV_ACTION_BASE_
/// end YuI

///DG 4/1/05 CLEAN_DUPLICATE_MORE : move from TreeEditInputData.h
//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
//enum { XF_MENU_ADD, XF_MENU_INSERT,XF_MENU_SEPARATOR, XF_MENU_DEL, XF_MENU_SEPARATOR1, XF_MENU_ENLARGE, XF_MENU_SHRINK };
enum { XF_MENU_ADD, XF_MENU_INSERT,XF_MENU_SEPARATOR, XF_MENU_DEL, XF_MENU_SEPARATOR1, XF_MENU_ENLARGE, XF_MENU_SHRINK
, XF_MENU_CLEAR_THEMEID
, XF_MENU_SEPARATOR2, XF_MENU_COLUMN };
//------
class XFControlMenu : public MenuBase
{
public:
	//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
	//XFControlMenu(bool bAllowDel=true, bool bIsXFunctionDialog = false) : MenuBase()
	XFControlMenu(bool bAllowDel=true, bool bIsXFunctionDialog = false,
	const vector<string> &vsColHeading = NULL, const vector<byte> &vbCols = NULL, const vector<int> &vnRemove = NULL, int nDisable = 1) : MenuBase()
	//------
	{
		Add(_L("Add variable"), OnMenuItem);

		if(bAllowDel)
		{
			Add(_L("Insert variable"), OnMenuItem);
			Add(NULL, OnMenuItem);
			Add(_L("Delete"), OnMenuItem);
		}
		if(bIsXFunctionDialog)
		{
			Add(NULL, OnMenuItem);
			Add(_L("Enlarge Pane"), OnMenuItem);
			Add(_L("Shrink Pane"), OnMenuItem);
			Add(_L("Clear Theme ID"), OnMenuItem);
			//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
			if ( !bAllowDel && vsColHeading != NULL && vbCols != NULL )
			{				
				Add(NULL, OnMenuItem);
				int nSize = vsColHeading.GetSize();
				for (int ii=0; ii<nSize; ++ii )
				{
					vector<uint> vnIndeces;
					if ( vnRemove == NULL || vnRemove.Find(vnIndeces, ii) < 1 )
					{
						int nCntrl = !vbCols[ii] ? MF_CHECKED : MF_UNCHECKED;
						if ( nDisable == ii )
							nCntrl |= MF_GRAYED;
						Add(vsColHeading[ii], OnMenuItem, nCntrl);
					}
				}
			}
			//------
		}
		
	}

	int DoTrackPopup(int nx, int ny, HWND hWndParent, bool bAllowDel = true)
	{
		TrackPopupMenu(0,  nx, ny, hWndParent);
		int nCmd;
		if(!GetCommand(nCmd))
			return -1;
		
		if(!bAllowDel && nCmd > XF_MENU_ADD)
		{
			nCmd = nCmd + 3;	///because have three offset ....
		}
		return nCmd;
	}

};

/// Vinde 5/13/2008 GRID_TABLE_CONTROL
class CheckMenu: public MenuBase
{
public:
	//------ Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
	//CheckMenu(const vector<byte> &vnStates, const vector<string> &vsColHeaders)
	CheckMenu(const vector<byte> &vnStates, const vector<string> &vsColHeaders, const vector<bool>& vbItemsDisable = NULL)
	//------
	{
		ASSERT(vnStates.GetSize() == vsColHeaders.GetSize() );
		//------ Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
		if ( vbItemsDisable )
			ASSERT(vbItemsDisable.GetSize() == vsColHeaders.GetSize());
		//------
		int nCmd=0;
		for(int ii = 0;ii < vnStates.GetSize();ii ++)
		{
			///Kyle 12/05/2008 ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU
			if(vsColHeaders[ii].IsEmpty())
			{
				Add(NULL, OnMenuItem, MF_SEPARATOR);
				nCmd ++;
				continue;
			}
			///End ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU
			int nFlags = vnStates[ii]?  MF_CHECKED : MF_UNCHECKED;
			//------ Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
			if ( vbItemsDisable && vbItemsDisable[ii] )
				nFlags |= MF_GRAYED;
			//------
		    Add(vsColHeaders[ii], OnMenuItem, nFlags, nCmd++);
		}
	}
};
///End GRID_TABLE_CONTROL
///end CLEAN_DUPLICATE_MORE

/// Iris 7/11/2011 ORG-2629 CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS
//---------moved from DynaDlg.h file ---------
enum
{
	THEME_MENU_INVALID = -1,
	THEME_MENU_SAVE_AS_DEFAULT,
	THEME_MENU_SAVE_TO_SHEET,
	THEME_MENU_SAVE_TO_BOOK,
	THEME_MENU_SAVE,
	THEME_MENU_SAVE_AS,
	THEME_MENU_RESET,
	//------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
	THEME_MENU_DELETE,
	//------
	/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	THEME_MENU_COMPARE,
	/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	THEME_MENU_DUMPING,
	///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	
	THEME_MENU_SETTING, ///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	//add more items before THEME_MENU_LOADING_START

	///------ Folger 06/12/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	THEME_MENU_SAVE_TO_GRAPH,
	THEME_MENU_SAVE_TO_LAYER,
	THEME_MENU_SAVE_TO_PLOT,
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

	///------ Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	THEME_MENU_COPY,
	THEME_MENU_PASTE,
	///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	
	THEME_MENU_LOADING_START,
};

/*****
add new menu item steps:
1. add new enumerator before THEME_MENU_LOADING_START
2. do both (1) [add new menu item] and (2) [add emumerator defined in Step1 into m_vnIndecesMap] in order

see THEME_MENU_SAVE_AS_DEFAULT for example
*/

///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
#define		THEME_MENU_ADD_SEPARATOR \
			Add(NULL, OnMenuItem, MF_SEPARATOR); \
			m_vnIndecesMap.Add(THEME_MENU_INVALID)
///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG

///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
#define		AddThemeItems(_bLoad, _nSel) \
			int nSize = vsThemes.GetSize(); \
			if ( nSize > 0 ) \
			{ \
				m_nCount += nSize + 1; \
				THEME_MENU_ADD_SEPARATOR; \
				\
				vector<string>	vsThemesTmp; \
				vsThemesTmp = vsThemes; \
				vector<int>		vnCategories; \
				okutil_prepare_theme_display_names(&vsThemesTmp, &vnCategories, TRUE); \
				int				nLastCategories = vnCategories[0]; \
				\
				for ( int ii=0; ii<nSize; ++ii ) \
				{ \
					int nFlag = _nSel == ii  ? MF_CHECKED : MF_UNCHECKED; \
					if ( !_bLoad ) \
						nFlag |= MF_GRAYED; \
					\
					if ( nLastCategories != vnCategories[ii] ) \
					{ \
						++m_nCount; \
						THEME_MENU_ADD_SEPARATOR; \
						nLastCategories = vnCategories[ii]; \
					} \
					Add(vsThemesTmp[ii], OnMenuItem, nFlag); \
					m_vnIndecesMap.Add(THEME_MENU_LOADING_START + ii); \
				} \
			}
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

///------ Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS
#define		STR_SAVE_AS_DEFAULT			_L("Save as <default>")
///------ End SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS

///------ Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
enum
{
	THEMEMENUCNTRL_COPY					= 0x00010000,
	THEMEMENUCNTRL_PASTE				= 0x00020000,
	THEMEMENUCNTRL_PASTABLE				= 0x00040000,
};
///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT

class ThemeControlMenu : public Menu
{
public:
    //------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
	/////---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	////ThemeControlMenu(bool bSave = true, bool bSheetTheme = false, bool bBookTheme = false, const vector<string> &vsThemes = NULL, int nSel = 0, bool bLoadEnable = true/*, bool bResetable = true*/)
	//ThemeControlMenu(bool bSave = true, bool bThemeSetting = false, bool bSheetTheme = false, bool bBookTheme = false, const vector<string> &vsThemes = NULL, int nSel = 0, bool bLoadEnable = true)
	/////---END QA80-11371 THEME_SAVING_OPTIONS
	/// Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
	//ThemeControlMenu(bool bSave = true, bool bThemeSetting = false, bool bSheetTheme = false, bool bBookTheme = false, const vector<string> &vsThemes = NULL, int nSel = 0, bool bLoadEnable = true, bool bDeletable = true)
	///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	//ThemeControlMenu(bool bSave = true, bool bThemeSetting = false, bool bSheetTheme = false, bool bBookTheme = false, const vector<string> &vsThemes = NULL, int nSel = 0, bool bLoadEnable = true, bool bDeletable = true, bool bComparable = true)
	ThemeControlMenu(bool bSave
		, bool bThemeSetting = false
		, bool bSheetTheme = false
		, bool bBookTheme = false
		, const vector<string> &vsThemes = NULL
		, int nSel = 0
		, bool bLoadEnable = true
		, bool bDeletable = true
		, bool bComparable = true
		, bool bLTCallable = true
		///------ Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
		, DWORD dwCntrls = 0
		///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	)
	///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	/// end PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
	//------ End SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
	{
		//m_nCount = 5;
		m_nChoice = -1;
		
		///------ Folger 12/17/08 v8.0987d MOVE_BOOK_SHEET_THEME_RIGHT_BEFORE_DEFAULT_THEME
		if ( bBookTheme )
		{
			//++m_nCount;
			Add(_L("Save to <Book>"), OnMenuItem);
			m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_BOOK);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		}		
		if ( bSheetTheme )
		{
			//++m_nCount;
			Add(_L("Save to <Sheet>"), OnMenuItem);
			m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_SHEET);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		}
		///------ End MOVE_BOOK_SHEET_THEME_RIGHT_BEFORE_DEFAULT_THEME
		
		Add(STR_SAVE_AS_DEFAULT, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_AS_DEFAULT);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		
		
		Add(_L("Save"), OnMenuItem, bSave ? MF_ENABLED : MF_GRAYED);
		m_vnIndecesMap.Add(THEME_MENU_SAVE);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		
		Add(_L("Save As") + STR_THREE_DOTS, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_AS);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		
		///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
		if ( bThemeSetting )
		{
			Add(STR_LABEL_THEME_FILTER_SETTING + STR_THREE_DOTS, OnMenuItem);
			m_vnIndecesMap.Add(THEME_MENU_SETTING);
			
			//Add(NULL, OnMenuItem, MF_SEPARATOR);
			//m_vnIndecesMap.Add(THEME_MENU_INVALID);
		}
		///---END QA80-11371 THEME_SAVING_OPTIONS
		
		THEME_MENU_ADD_SEPARATOR;
		
		///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
		//Add(_L("Reset"), OnMenuItem, /*bResetable && */bLoadEnable ? MF_ENABLED : MF_GRAYED);
		Add(_L("System Default"), OnMenuItem, /*bResetable && */bLoadEnable ? MF_ENABLED : MF_GRAYED);
		///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
		m_vnIndecesMap.Add(THEME_MENU_RESET);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU

        //------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
        Add(_L("Delete") + STR_THREE_DOTS, OnMenuItem, bDeletable? MF_ENABLED : MF_GRAYED);
		m_vnIndecesMap.Add(THEME_MENU_DELETE);
        //------

	#ifdef		_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
        /// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES        
        if ( bComparable ) /// Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
        {
        	/// Hong 11/09/09 QA80-12798 ALWAYS_ANABLE_COMPARE_TO_BEABLE_COMPARE_WITH_SYSTEM_DEFAULT
        	// Hong, there will at least one item in combo of theme comparing dlg--empty for System Default
        	//Add(_L("Compare") + STR_THREE_DOTS, OnMenuItem, (vsThemes.GetSize() > 0) ? MF_ENABLED : MF_GRAYED);
        	Add(_L("Compare") + STR_THREE_DOTS, OnMenuItem, MF_ENABLED);
        	/// end ALWAYS_ANABLE_COMPARE_TO_BEABLE_COMPARE_WITH_SYSTEM_DEFAULT
			m_vnIndecesMap.Add(THEME_MENU_COMPARE);
        }
        /// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	#endif		//_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5

		///------ Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
		BOOL	bCopy = O_QUERY_BOOL(dwCntrls, THEMEMENUCNTRL_COPY);
		BOOL	bPaste = O_QUERY_BOOL(dwCntrls, THEMEMENUCNTRL_PASTE);
		if ( bCopy || bPaste )
		{
			THEME_MENU_ADD_SEPARATOR;
			if ( bCopy )
			{
				Add(_L("Copy"), OnMenuItem, MF_ENABLED);
				m_vnIndecesMap.Add(THEME_MENU_COPY);
			}
			if ( bPaste )
			{
				Add(_L("Paste"), OnMenuItem, O_QUERY_BOOL(dwCntrls, THEMEMENUCNTRL_PASTABLE) ? MF_ENABLED : MF_GRAYED);
				m_vnIndecesMap.Add(THEME_MENU_PASTE);
			}
		}
		///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT

		///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
		if ( bLTCallable )
		{
			THEME_MENU_ADD_SEPARATOR;
			Add(_L("Generate Script"), OnMenuItem, MF_ENABLED);
			m_vnIndecesMap.Add(THEME_MENU_DUMPING);
		}
		///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
        
		m_nCount = m_vnIndecesMap.GetSize();
		
		if ( vsThemes )
		{
			///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
			/*
			int nSize = vsThemes.GetSize();
			if ( nSize > 0 )
			{
				m_nCount += nSize + 1;
				THEME_MENU_ADD_SEPARATOR;
				
				///------ Folger 01/25/10 QA81-15036 SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
				vector<string>	vsThemesTmp;
				vsThemesTmp = vsThemes;
				vector<int>		vnCategories;
				okutil_prepare_theme_display_names(&vsThemesTmp, &vnCategories);
				int				nLastCategories = vnCategories[0];
				///------ End SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
				
				for ( int ii=0; ii<nSize; ++ii )
				{
					int nFlag = nSel == ii  ? MF_CHECKED : MF_UNCHECKED;
					if ( !bLoadEnable )
						nFlag |= MF_GRAYED;
					
					///------ Folger 01/25/10 QA81-15036 SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
					//Add(vsThemes[ii], OnMenuItem, nFlag);
					if ( nLastCategories != vnCategories[ii] )
					{
						++m_nCount;
						THEME_MENU_ADD_SEPARATOR;
						nLastCategories = vnCategories[ii];
					}
					Add(vsThemesTmp[ii], OnMenuItem, nFlag);
					m_vnIndecesMap.Add(THEME_MENU_LOADING_START + ii);
					///------ End SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
				}
			}
			*/
			AddThemeItems(bLoadEnable, nSel);
			///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
		}
		
	}	
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= 0 && m_nChoice < m_nCount)
		{
			//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
			//nChoice = m_nChoice;
			nChoice = m_nChoice < m_vnIndecesMap.GetSize() ? m_vnIndecesMap[m_nChoice] : m_nChoice - m_vnIndecesMap.GetSize() + THEME_MENU_LOADING_START;
			//------
			return true;
		}
		return false;
	}

protected:
	int	m_nChoice;
	int m_nCount;
	vector<int>		m_vnIndecesMap;		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
};
///End CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS

#endif //_MENUBASE_H_

