/*------------------------------------------------------------------------------*
 * File Name:	LightingControlDlg.cpp											*
 * Creation: 	Sophy 5/25/2011													*
 * Purpose: For changeing lighting settings of OpenGL Layer						*
 * Copyright (c) OriginLab Corp.	2000 - 2010									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Kyle 10/16/2012 ORG-7145-P1 OC_NEED_CONVERT_OCOLOR_TO_LABTALK				*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "oDlg8.h"
#include <..\OriginLab\DialogEx.h>


///Kyle 10/16/2012 ORG-7145-P1 OC_NEED_CONVERT_OCOLOR_TO_LABTALK, copied from Series.c, need centralized later
int ocolor_to_labtalk(OCOLOR oc)
{
	long lTemp = oc;
	if(lTemp < 0)
		return lTemp;

	if(OCOLOR_IS_RGB(lTemp) || OCOLOR_IS_TRANSPARENT_RGB(lTemp))
		return lTemp;

	lTemp &= ~COLUMN_COLOR_COLORMAP;
	lTemp &= ~COLUMN_COLOR_DERICTRGB;

	return lTemp + 1;
}

OCOLOR labtalk_to_ocolor(long nLabTalkIndex)
{
	if(nLabTalkIndex <= 0)
		return nLabTalkIndex;

	if(OCOLOR_IS_RGB(nLabTalkIndex) || OCOLOR_IS_TRANSPARENT_RGB(nLabTalkIndex))
		return nLabTalkIndex;

	return nLabTalkIndex - 1;
}
///End OC_NEED_CONVERT_OCOLOR_TO_LABTALK

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

class LockHelper
{
public:
	LockHelper(bool& bLock)
	{
		m_bLock = bLock;
		m_pbLock = &bLock;
		bLock = true;
	}
	~LockHelper()
	{
		*m_pbLock = m_bLock;
	}
private:
	bool	m_bLock;
	bool	*m_pbLock;
};

enum {
	TAB_THUMBPAD	= 0,
	TAB_COLOR,
};
#define	STR_DLG_NAME	"LightingControlDlg"
#define	ANGLE_TO_POSITION_H(dPer) ((dPer)/360.0 * 100.0)
#define	POSITION_TO_ANGLE_H(dPos) ((dPos)/100.0 * 360.0)
///Sophy 7/13/2012 ORG-2950-P2 VERTICAL_LIGHTING_POS_SHOULD_BE_MINUS_90_TO_90
//#define	ANGLE_TO_POSITION_VD(dPer) (100 - (dPer)/90.0 * 100.0) //for dynamic
//#define	POSITION_TO_ANGLE_VD(dPos) (90 - (dPos)/100.0 * 90.0) //for dynamic
///end VERTICAL_LIGHTING_POS_SHOULD_BE_MINUS_90_TO_90
#define	ANGLE_TO_POSITION_V(dPer) (100 - (dPer + 90.0)/180.0 * 100.0) //for not dynamic
#define	POSITION_TO_ANGLE_V(dPos) ((100.0 - dPos)/100.0 * 180.0 - 90.0) //for not dynamic

///Sophy 7/13/2012 ORG-2950-P2 VERTICAL_LIGHTING_POS_SHOULD_BE_MINUS_90_TO_90
#define	ANGLE_TO_POSITION_VD(dPer)	ANGLE_TO_POSITION_V(dPer)
#define	POSITION_TO_ANGLE_VD(dPos)	POSITION_TO_ANGLE_V(dPos)
//end VERTICAL_LIGHTING_POS_SHOULD_BE_MINUS_90_TO_90
class LightingControlDlg : public Dialog
{
public:
	LightingControlDlg() : Dialog(IDD_3D_LIGHTING_CONTROL, "ODlg8")
	{
		m_bLocked = false;
		InitMsgMap();
	}
	
	BOOL	IsShowDialog(){ return m_nMode != 0; }
public:
	///Sophy 6/14/2012 ORG-5994-P1 ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
	void	SetNeedAskModeChange(bool bNeeded){ m_bNeedAskModeChange = bNeeded; }
	void	CheckUpdateDataFromLayer()
	{
		OnActiveLayerChange();
	}
	///end ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_CHANGE_LAYER(OnActiveLayerChange)
	ON_USER_MSG(WM_USER_THUMBPAD_NOTIFY, OnThumbNotify)
	ON_BN_CLICKED(IDC_ENABLE_LIGHT, OnEnableLighting)
	
	ON_TAB_SEL_CHANGE(IDC_LIGHTING_DLG_TAB, OnTabChange)

	ON_EN_CHANGE(IDC_EDIT_HORI, OnThumbPosChange)
	ON_EN_CHANGE(IDC_EDIT_VERT, OnThumbPosChange)
	
	ON_CBN_SELCHANGE(IDC_LIGHT_DIFFUSE, OnDiffuseColorChange)
	ON_SLIDE(IDC_SLIDER_DIFFUSE, OnDiffuseIntensityChange)
	ON_EN_CHANGE(IDC_EDIT_DIFFUSE, OnDiffuseIntensityEdit)
	
	ON_CBN_SELCHANGE(IDC_LIGHT_SPECULAR, OnSpecularColorChange)
	ON_SLIDE(IDC_SLIDER_SPECULAR, OnSpecularIntensityChange)
	ON_EN_CHANGE(IDC_EDIT_SPECULAR, OnSpecularIntensityEdit)
	
	ON_EN_CHANGE(IDC_EDIT_SHININESS, OnShininessEdit)
	ON_SLIDE(IDC_SLIDER_SHININESS, OnShininessChange)
EVENTS_END

protected:
	BOOL	OnInitDialog()
	{
		m_bLocked = true;
		
		InitControls();
		
		///Sophy 6/14/2012 ORG-5994-P1 ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
		//UpdateData(true); //from layer call within CheckUpdateDataFromLayer
		///end ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
		
		LoadSettings();
		
		
		InitControlValues();
		
		UpdateControls();

		ShowHideControls();
				
		Text = _L("Lighting"); //dialog title
		
		m_bLocked = false;
		return TRUE;
	}
	BOOL	OnDestroy()
	{
		SaveSettings();
		return TRUE;
	}
	void	InitControls()
	{
		//mode
		m_btnMode = GetItem(IDC_ENABLE_LIGHT);
		
		//tab
		m_tab = GetItem(IDC_LIGHTING_DLG_TAB);
		m_tab.InsertItem(TAB_THUMBPAD, _L("Source Direction"));
		m_tab.InsertItem(TAB_COLOR, _L("Properties"));
		Control ctrl = GetItem(IDC_THUMBPAD);
		m_ThumbPad.CreateControl(ctrl.GetSafeHwnd(), WS_BORDER);
		m_ThumbPad.SetNotifyWnd(GetSafeHwnd());
		
		m_editHorizontal = GetItem(IDC_EDIT_HORI);
		m_editVertical = GetItem(IDC_EDIT_VERT);
		
		m_sbHorizontal = GetItem(IDC_SPIN_HORI);
		m_sbHorizontal.SetBuddy(m_editHorizontal.GetSafeHwnd());
		m_sbHorizontal.SetRange(0, 360);
		
		m_sbVertical = GetItem(IDC_SPIN_VERT);
		m_sbVertical.SetBuddy(m_editVertical.GetSafeHwnd());
		
		//Diffuse begin
		m_sldDiffuseIntensity = GetItem(IDC_SLIDER_DIFFUSE);
		m_sldDiffuseIntensity.RangeMin = 0;
		m_sldDiffuseIntensity.RangeMax = 100;
		m_sldDiffuseIntensity.SetTicFreq(100);
		
		m_editDiffuseIntensity = GetItem(IDC_EDIT_DIFFUSE);
		m_editDiffuseIntensity.Text = m_nDiffuseIntensity;
		
		m_sbDiffuseIntensity = GetItem(IDC_SPIN_DIFFUSE);
		m_sbDiffuseIntensity.SetBuddy(m_editDiffuseIntensity.GetSafeHwnd());
		m_sbDiffuseIntensity.SetRange(0, 100);
		//Diffuse end
		
		//Specular begin
		m_sldSpecularIntensity = GetItem(IDC_SLIDER_SPECULAR);
		m_sldSpecularIntensity.RangeMin = 0;
		m_sldSpecularIntensity.RangeMax = 100;
		m_sldSpecularIntensity.SetTicFreq(100);
		
		m_editSpecularIntensity = GetItem(IDC_EDIT_SPECULAR);
		m_editSpecularIntensity.Text = m_nSpecularIntensity;
		
		m_sbSpecularIntensity = GetItem(IDC_SPIN_SPECULAR);
		m_sbSpecularIntensity.SetBuddy(m_editSpecularIntensity.GetSafeHwnd());
		m_sbSpecularIntensity.SetRange(0, 100);
		//Specular end
		
		//Shininess begin
		m_sldShininess = GetItem(IDC_SLIDER_SHININESS);
		m_sldShininess.RangeMin = 0;
		m_sldShininess.RangeMax = 128;
		m_sldShininess.SetTicFreq(128);
		
		m_editShininess = GetItem(IDC_EDIT_SHININESS);
		m_editShininess.Text = m_nShininess;
		
		m_sbShininess = GetItem(IDC_SPIN_SHININESS);
		m_sbShininess.SetBuddy(m_editShininess.GetSafeHwnd());
		m_sbShininess.SetRange(0, 128);
		//Shininess end
		
		//lighting color
		InitLightColorControls();
	}
	
	void	InitControlValues()
	{
		if ( m_bLocked )
			return;
		{
			LockHelper lock(m_bLocked);
			
			//mode
			m_btnMode.Check = m_nMode;

			//thumbpad settings
			///Sophy 7/13/2012 ORG-2950-P2 VERTICAL_LIGHTING_POS_SHOULD_BE_MINUS_90_TO_90
			//if ( IsDynamicLighting() )
			//{
				//m_sbVertical.SetRange(0, 90);
			//}
			//else
			//{
				//m_sbVertical.SetRange(-90, 90);
			//}
			m_sbVertical.SetRange(-90, 90);
			///end VERTICAL_LIGHTING_POS_SHOULD_BE_MINUS_90_TO_90
			
			//diffuse color
			m_sldDiffuseIntensity.Position = m_nDiffuseIntensity;
			m_sbDiffuseIntensity.SetPos(m_nDiffuseIntensity);
			
			//specular color
			m_sldSpecularIntensity.Position = m_nSpecularIntensity;
			m_sbSpecularIntensity.SetPos(m_nSpecularIntensity);
			
			//shininess
			m_sldShininess.Position = m_nShininess;
			m_sbShininess.SetPos(m_nShininess);
			
			//color
			m_clrDiffuse.colorCurrent = m_nDiffuseColor;
			m_clrDiffuseColor.colorCurrent = m_nDiffuseColor;
			
			m_clrSpecular.colorCurrent = m_nSpeculorColor;
			m_clrSpecularColor.colorCurrent = m_nSpeculorColor;
		}
		//trigger event to update controls
		m_ThumbPad.ThumbPos = m_stPos;
		OnThumbNotify(0, 0);
		OnDiffuseIntensityChange(m_sldDiffuseIntensity, 0, 0);
		OnSpecularIntensityChange(m_sldSpecularIntensity, 0, 0);

	}
#define	STR_ACTIVE_TAB	"ActiveTab"
	BOOL	LoadSettings()
	{
		BOOL bRet = TRUE;
		bRet &= dlg_load_registry(STR_DLG_NAME, STR_ACTIVE_TAB, m_nActiveTab, TAB_THUMBPAD);
		m_tab.SetCurSel(m_nActiveTab);
		return bRet;
	}
	BOOL	SaveSettings()
	{
		BOOL bRet = TRUE;
		bRet &= dlg_save_to_registry(STR_DLG_NAME, STR_ACTIVE_TAB, m_nActiveTab);
		return bRet;
	}

	BOOL	OnActiveLayerChange()
	{
		GraphLayer gl = Project.ActiveLayer();
		if ( gl )
		{
			double dMode = 0;
			BOOL bLightSupported = LT_get_var("layer.light.mode", &dMode);
			if ( bLightSupported )
			{
				{
					LockHelper lock(m_bLocked);	///Sophy 7/29/2011 ORG-2950-P3 PROPER_UPDATE_CONTROL_VALUE_WHEN_SWITCH_LAYER
					UpdateData(true); //from layer;
				}
				UpdateControls();
				InitControlValues();
				ShowHideControls();
			}
			Visible = bLightSupported && (0 != m_nMode);
		}
		else
		{
			Visible = FALSE;
		}
		return TRUE;
	}
	
	BOOL	OnTabChange(Control ctrl)
	{
		m_nActiveTab = m_tab.GetCurSel();
		ShowHideControls();
		return TRUE;
	}
	
	void	ShowHideControls()
	{
		int nSel = m_tab.GetCurSel();
		m_ThumbPad.Visible = (TAB_THUMBPAD == nSel);
		m_editHorizontal.Visible = m_sbHorizontal.Visible = (TAB_THUMBPAD == nSel);
		m_editVertical.Visible = m_sbVertical.Visible = (TAB_THUMBPAD == nSel);
		GetItem(IDC_STATIC_HORIZ_LABEL).Visible = GetItem(IDC_STATIC_VERTI_LABEL).Visible = (TAB_THUMBPAD == nSel);
		
		m_clrDiffuse.Visible = m_clrDiffuseColor.Visible = m_sldDiffuseIntensity.Visible = m_editDiffuseIntensity.Visible = m_sbDiffuseIntensity.Visible = (TAB_COLOR == nSel);
		m_clrSpecular.Visible = m_clrSpecularColor.Visible = m_sldSpecularIntensity.Visible = m_editSpecularIntensity.Visible = m_sbSpecularIntensity.Visible = (TAB_COLOR == nSel);
		m_sldShininess.Visible = m_editShininess.Visible = m_sbShininess.Visible = (TAB_COLOR == nSel);
		
		//hide Enable Directional Lighting Mode
		m_btnMode.Visible = FALSE;
	}
	
	BOOL	OnEnableLighting(Control ctrl)
	{
		m_nMode = m_btnMode.Check ? 1 : 0;;
		UpdateControls();
		UpdateData(false);
		return TRUE;
	}
	
	void	UpdateControls()
	{
		BOOL bEnable = m_nMode == 1;
		m_ThumbPad.Enable = bEnable;
		
		m_editHorizontal.Enable = bEnable;
		m_sbHorizontal.Enable = bEnable;
		
		m_editVertical.Enable = bEnable;
		m_sbVertical.Enable = bEnable;
		
		m_clrDiffuse.Enable = bEnable;
		m_sldDiffuseIntensity.Enable = bEnable;
		m_editDiffuseIntensity.Enable = bEnable;
		m_sbDiffuseIntensity.Enable = bEnable;
		
		m_clrSpecular.Enable = bEnable;
		m_sldSpecularIntensity.Enable = bEnable;
		m_editSpecularIntensity.Enable = bEnable;
		m_sbSpecularIntensity.Enable = bEnable;
		
		m_sldShininess.Enable = bEnable;
		m_editShininess.Enable = bEnable;
		m_sbShininess.Enable = bEnable;
	}
	int		CheckUpdateUserInput(Control& ctrl, int nStart, int nEnd)
	{
		///Sophy 7/20/2011 ORG-2950-P2 PROPER_CHECK_UPDATE_USER_INPUT_DATA
		//int nVal  = atol(ctrl.Text);
		//if ( nVal < nStart )
		//	nVal = nStart;
		//if ( nVal > nEnd )
		//	nVal = nEnd;
		//ctrl.Text = nVal;
		string strVal = ctrl.Text;
		int nVal = atol(strVal);
		if ( !strVal.IsEmpty() )
		{
			bool bUpdate = true;
			double dVal = atof(strVal);
			if ( is_missing_value(dVal) )
				nVal = 0;
			else if ( dVal < nStart )
				nVal = nStart;
			else if ( dVal > nEnd )
				nVal = nEnd;
			else //user's input is proper
			{
				bUpdate = false;
			}
			
			if ( bUpdate )
				ctrl.Text = nVal;
		}
		///end PROPER_CHECK_UPDATE_USER_INPUT_DATA
		return nVal;
	}
	BOOL	IsDynamicLighting()
	{
		double dDyna = 0;
		LT_get_var("layer.light.direction.dynamic", &dDyna);
		return ((int)dDyna != 0);
	}
	BOOL	OnThumbPosChange(Control ctrl)
	{
		if ( m_bLocked )
			return TRUE;
		LockHelper lock(m_bLocked);
		
		int nStart = 0, nEnd = 90;
		if ( ctrl.GetSafeHwnd() == m_editHorizontal.GetSafeHwnd() )
			nEnd = 360;
		///Sophy 7/13/2012 ORG-2950-P2 VERTICAL_LIGHTING_POS_SHOULD_BE_MINUS_90_TO_90
		//else if ( ctrl.GetSafeHwnd() == m_editVertical.GetSafeHwnd() && IsDynamicLighting() )
		else if ( ctrl.GetSafeHwnd() == m_editVertical.GetSafeHwnd() )
		///end VERTICAL_LIGHTING_POS_SHOULD_BE_MINUS_90_TO_90
			nStart = -90;

		CheckUpdateUserInput(ctrl, nStart, nEnd);
		
		m_stPos.x = ANGLE_TO_POSITION_H(atof(m_editHorizontal.Text));
		m_stPos.y = IsDynamicLighting() ? ANGLE_TO_POSITION_VD(atof(m_editVertical.Text)) : ANGLE_TO_POSITION_V(atof(m_editVertical.Text));
		if ( m_stPos.x < 0 )
			m_stPos.x = 0;
		if ( m_stPos.y < 0 )
			m_stPos.y = 0;
		m_ThumbPad.ThumbPos = m_stPos;
		
		m_sbHorizontal.SetPos(atof(m_editHorizontal.Text));
		m_sbVertical.SetPos(atof(m_editVertical.Text));
		UpdateData(false); //to layer
		return TRUE;
	}
	
	BOOL	OnDiffuseIntensityEdit(Control ctrl)
	{
		if ( m_bLocked )
			return TRUE;
		{
			LockHelper lock(m_bLocked);
	
			m_nDiffuseIntensity = CheckUpdateUserInput(ctrl, 0, 100);
			m_sbDiffuseIntensity.SetPos(m_nDiffuseIntensity);
			m_sldDiffuseIntensity.Position = m_nDiffuseIntensity;
		}
		OnDiffuseIntensityChange(m_sldDiffuseIntensity, 0, 0);
		return TRUE;
	}
	
	BOOL	OnSpecularIntensityEdit(Control ctrl)
	{
		if ( m_bLocked )
			return TRUE;
		{
			LockHelper lock(m_bLocked);
	
			m_nSpecularIntensity = CheckUpdateUserInput(ctrl, 0, 100);
			m_sbSpecularIntensity.SetPos(m_nSpecularIntensity);
			m_sldSpecularIntensity.Position = m_nSpecularIntensity;
		}
		OnSpecularIntensityChange(m_sldSpecularIntensity, 0, 0);
		return TRUE;
	}
	BOOL	OnShininessEdit(Control ctrl)
	{
		if ( m_bLocked )
			return TRUE;
		{
			LockHelper lock(m_bLocked);
		
			m_nShininess = CheckUpdateUserInput(ctrl, 0, 128);
			m_sbShininess.SetPos(m_nShininess);
			m_sldShininess.Position = m_nShininess;
		}
		UpdateData(false);
		return TRUE;
	}
	
	
	BOOL	OnDiffuseColorChange(Control ctrl)
	{
		m_nDiffuseColor = m_clrDiffuse.colorCurrent;
		//UpdateDiffuseIntensity(); //should not update intensity when color change.
		OnDiffuseIntensityChange(m_sldDiffuseIntensity, 0, 0); //update preview color
		UpdateData(false);
		return TRUE;
	}
	
	BOOL	OnSpecularColorChange(Control ctrl)
	{
		m_nSpeculorColor = m_clrSpecular.colorCurrent;
		//UpdateSpecularIntensity(); //should not update intensity when color change
		OnSpecularIntensityChange(m_sldSpecularIntensity, 0, 0); //update preview color
		UpdateData(false);
		return TRUE;
	}
	
	BOOL	OnDiffuseIntensityChange(Control ctrl, WPARAM wParam, LPARAM lParam)
	{
		return UpdateOnIntensityChange(m_nDiffuseIntensity, m_sldDiffuseIntensity, m_nDiffuseColor, m_clrDiffuse, m_clrDiffuseColor, m_editDiffuseIntensity, m_sbDiffuseIntensity);
	}
	
	BOOL	OnSpecularIntensityChange(Control ctrl, WPARAM wParam, LPARAM lParam)
	{
		return UpdateOnIntensityChange(m_nSpecularIntensity, m_sldSpecularIntensity, m_nSpeculorColor, m_clrSpecular, m_clrSpecularColor, m_editSpecularIntensity, m_sbSpecularIntensity);
	}
	
	BOOL	UpdateOnIntensityChange(int& nIntensity, Slider& sldIntensity, int& nColor, ColorChooser& clrColor, ColorChooser& clrPreview, Edit& editIntensity, SpinButton& sbIntensity)
	{
		if ( m_bLocked )
			return TRUE;
		LockHelper lock(m_bLocked);
		
		nIntensity = sldIntensity.Position;
		nColor = clrColor.colorCurrent;
		DWORD dwRGB = okutil_convert_ocolor_to_RGB(nColor);
		int clrR = GetRValue(dwRGB), clrG = GetGValue(dwRGB), clrB = GetBValue(dwRGB);
		clrR = (double)nIntensity/100.0 * clrR;
		clrG = (double)nIntensity/100.0 * clrG;
		clrB = (double)nIntensity/100.0 * clrB;
		dwRGB = RGB(clrR, clrG, clrB);
		int nPreviewColor = RGB2OCOLOR(dwRGB);
		
		clrPreview.colorCurrent = nPreviewColor;
	
		sbIntensity.SetPos(nIntensity);
		UpdateData(false);
		return TRUE;
	}
	
	BOOL	OnShininessChange(Control ctrl, WPARAM wParam, LPARAM lParam)
	{
		if ( m_bLocked )
			return TRUE;
		LockHelper lock(m_bLocked);
		
		m_nShininess = m_sldShininess.Position;
		m_editShininess.Text = m_nShininess;
		m_sbShininess.SetPos(m_nShininess);
		UpdateData(false);
		return TRUE;
	}
	
	LRESULT	OnThumbNotify(WPARAM wParam, LPARAM lParam)
	{
		if ( m_bLocked )
			return TRUE;
		LockHelper lock(m_bLocked);
		
		m_stPos = m_ThumbPad.ThumbPos;
		m_editHorizontal.Text = round(POSITION_TO_ANGLE_H(m_stPos.x), 0);
		m_editVertical.Text = round(IsDynamicLighting() ? POSITION_TO_ANGLE_VD(m_stPos.y) : POSITION_TO_ANGLE_V(m_stPos.y), 0);
		m_sbHorizontal.SetPos(atof(m_editHorizontal.Text));
		m_sbVertical.SetPos(atof(m_editVertical.Text));
		UpdateData(false); //to layer
		return 0;
	}
	void	UpdateDiffuseIntensity()
	{
		UpdateColorIntensity(m_nDiffuseColor, m_clrDiffuseColor, m_nDiffuseIntensity, m_sldDiffuseIntensity, m_editDiffuseIntensity, m_sbDiffuseIntensity);		
	}
	void	UpdateSpecularIntensity()
	{
		UpdateColorIntensity(m_nSpeculorColor, m_clrSpecularColor, m_nSpecularIntensity, m_sldSpecularIntensity, m_editSpecularIntensity, m_sbSpecularIntensity);
	}
	
	void	UpdateColorIntensity(int& nColor, ColorChooser& clrColor, int& nIntensity, Slider& sldIntensity, Edit& editIntensity, SpinButton& sbIntensity)
	{
		if ( OCOLOR_IS_RGB(nColor) )
		{
			DWORD dwRGB = GET_CRF_FROM_RGBOCOLOR(nColor);
			int nR = GetRValue(dwRGB), nG = GetGValue(dwRGB), nB = GetBValue(dwRGB);
			double dMax = max(nR, nG);
			dMax = max(dMax, nB);
			nIntensity = dMax/255.0 * 100.0;			
		}
		else
		{
			nIntensity = 100;
		}
		clrColor.colorCurrent = nColor;
		sldIntensity.Position = nIntensity;
		editIntensity.Text = nIntensity;
		sbIntensity.SetPos(nIntensity);
	}
	
	void	UpdateData(bool bFromLayer = true)	
	{
		m_stPos = m_ThumbPad.ThumbPos;
		double dH, dV, dDiffColor, dSpecColor, dShininess, dMode, dKd, dKs;
		if ( bFromLayer )
		{
			LT_get_var("layer.light.direction.h", &dH);
			LT_get_var("layer.light.direction.v", &dV);
			LT_get_var("layer.light.diffuse", &dDiffColor);
			LT_get_var("layer.light.kd", &dKd);
			LT_get_var("layer.light.specular", &dSpecColor);
			LT_get_var("layer.light.ks", &dKs);	
			LT_get_var("layer.light.shininess", &dShininess);
			LT_get_var("layer.light.mode", &dMode);
			///Kyle 10/16/2012 ORG-7145-P1 OC_NEED_CONVERT_OCOLOR_TO_LABTALK
			//m_nDiffuseColor = (int)dDiffColor;
			m_nDiffuseColor = (int)labtalk_to_ocolor(dDiffColor);
			///End OC_NEED_CONVERT_OCOLOR_TO_LABTALK
 			m_nDiffuseIntensity = (int)(dKd * 100);
			///Kyle 10/16/2012 ORG-7145-P1 OC_NEED_CONVERT_OCOLOR_TO_LABTALK
			//m_nSpeculorColor = (int)dSpecColor;
			m_nSpeculorColor = (int)labtalk_to_ocolor(dSpecColor);
			///End OC_NEED_CONVERT_OCOLOR_TO_LABTALK
			m_nSpecularIntensity = (int)(dKs * 100);
			m_nShininess = (int)dShininess;
			m_nMode = (int)dMode;
			m_stPos.x = ANGLE_TO_POSITION_H(dH);
			m_stPos.y = IsDynamicLighting() ? ANGLE_TO_POSITION_VD(dV) : ANGLE_TO_POSITION_V(dV);
			///Sophy 6/14/2012 ORG-5994-P1 ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
			//if ( m_nMode == 0 )
			if ( m_bNeedAskModeChange && 0 == m_nMode )
			///end ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
			{
				int nRet = warning_msg_box(_L("Directional lighting mode is off now, would you like to turn it on?\n\nNote: You can turn on/off the lighting control from Plot Details dialog, lighting tab on layer level."), true, 'W', MB_YESNO);
				if ( nRet == IDYES )
				{
					m_nMode = 1;
					LT_set_var("layer.light.mode", m_nMode);
					LT_execute("doc -uw"); ///Sophy 8/1/2011 ORG-2950-P0 LIGHTING_ISSUES_WHEN_NORMAL_NOT_READY_FOR_DRAWING
				}
				else
				{
					PostMessage(WM_CLOSE);
				}
			}
			m_bNeedAskModeChange = false;	///Sophy 6/14/2012 ORG-5994-P1 ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
		}
		else
		{
			dH = POSITION_TO_ANGLE_H(m_stPos.x);
			dV = IsDynamicLighting() ? POSITION_TO_ANGLE_VD(m_stPos.y) : POSITION_TO_ANGLE_V(m_stPos.y);
			LT_set_var("layer.light.direction.h", dH);
			LT_set_var("layer.light.direction.v", dV);
			///Kyle 10/16/2012 ORG-7145-P1 OC_NEED_CONVERT_OCOLOR_TO_LABTALK
			//LT_set_var("layer.light.diffuse", m_nDiffuseColor);
			LT_set_var("layer.light.diffuse", ocolor_to_labtalk(m_nDiffuseColor));
			///End OC_NEED_CONVERT_OCOLOR_TO_LABTALK
			LT_set_var("layer.light.kd", m_nDiffuseIntensity/100.0);
			///Kyle 10/16/2012 ORG-7145-P1 OC_NEED_CONVERT_OCOLOR_TO_LABTALK
			//LT_set_var("layer.light.specular", m_nSpeculorColor);
			LT_set_var("layer.light.specular", ocolor_to_labtalk(m_nSpeculorColor));
			///End OC_NEED_CONVERT_OCOLOR_TO_LABTALK
			LT_set_var("layer.light.ks", m_nSpecularIntensity/100.0);
			LT_set_var("layer.light.shininess", m_nShininess);
			LT_execute("doc -uwfp;");
		}
	}
	
	void	InitLightColorControls()
	{
		Control ctrl = GetItem(IDC_LIGHT_DIFFUSE);
		m_clrDiffuse.CreateControl(ctrl.GetSafeHwnd());
		m_clrDiffuse.AddColorNames();
		m_clrDiffuse.SetBmp(COLORTYPE_BMPOFFSET_FILL);
		
		ctrl = GetItem(IDC_LIGHT_DIFFUSECOLOR);
		m_clrDiffuseColor.CreateControl(ctrl.GetSafeHwnd());
		m_clrDiffuseColor.AddColorNames();
		m_clrDiffuseColor.SetBmp(COLORTYPE_BMPOFFSET_FILL);
		m_clrDiffuseColor.SetReadOnly();

		ctrl = GetItem(IDC_LIGHT_SPECULAR);
		m_clrSpecular.CreateControl(ctrl.GetSafeHwnd());
		m_clrSpecular.AddColorNames();
		m_clrSpecular.SetBmp(COLORTYPE_BMPOFFSET_FILL);
		
		ctrl = GetItem(IDC_LIGHT_SPECULARCOLOR);
		m_clrSpecularColor.CreateControl(ctrl.GetSafeHwnd());
		m_clrSpecularColor.AddColorNames();
		m_clrSpecularColor.SetBmp(COLORTYPE_BMPOFFSET_FILL);
		m_clrSpecularColor.SetReadOnly();
		
	}
private:
	
	TabControl		m_tab;
	DWORD			m_nActiveTab;

	ThumbPadControl	m_ThumbPad;
	fpoint			m_stPos;
	Button			m_btnMode;
	int				m_nMode;
	
	Edit			m_editHorizontal;
	SpinButton		m_sbHorizontal;
	
	Edit			m_editVertical;
	SpinButton		m_sbVertical;
	
	
	ColorChooser	m_clrDiffuse;
	ColorChooser	m_clrDiffuseColor;
	Slider			m_sldDiffuseIntensity;
	Edit			m_editDiffuseIntensity;
	SpinButton		m_sbDiffuseIntensity;
	int				m_nDiffuseColor;
	int				m_nDiffuseIntensity;
	
	ColorChooser	m_clrSpecular;
	ColorChooser	m_clrSpecularColor;
	Slider			m_sldSpecularIntensity;
	Edit			m_editSpecularIntensity;
	SpinButton		m_sbSpecularIntensity;
	int				m_nSpeculorColor;
	int				m_nSpecularIntensity;
	
	
	Slider			m_sldShininess;
	Edit			m_editShininess;
	SpinButton		m_sbShininess;
	int				m_nShininess;
	
	bool			m_bLocked; //prevent dead loop between OnThumbNotify OnThumbPosChange etc.
	bool			m_bNeedAskModeChange;	///Sophy 6/14/2012 ORG-5994-P1 ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
};


LightingControlDlg *g_pLightControlDlg = NULL;
BOOL	OpenLightingControlDlg()
{
	if ( NULL == g_pLightControlDlg || !g_pLightControlDlg->GetWindow() )
	{
		g_pLightControlDlg = new LightingControlDlg;
		g_pLightControlDlg->Create(GetWindow());
	}
	Window win = g_pLightControlDlg->GetWindow();
	///Sophy 6/14/2012 ORG-5994-P1 ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
	//if ( win && g_pLightControlDlg->IsShowDialog() )
	//{
	//	win.ShowWindow(SW_NORMAL);
	//}
	if ( win )
	{
		g_pLightControlDlg->SetNeedAskModeChange(true);
		g_pLightControlDlg->CheckUpdateDataFromLayer();
	}
	///end ACTIVELAYER_CHANGE_SHOULD_NEVER_ASK_TURN_ON_LIGHTING
	else
	{
		delete g_pLightControlDlg;
		g_pLightControlDlg = NULL;
	}
	return TRUE;

}
