/*------------------------------------------------------------------------------*
 * File Name: LayerManagement.c				 									*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 03/22/07 ADD_GET_AXIS_SHOW											*
 *	Jasmine 03/23/07 ADD_AUTO_CHECK_BOX											*
 *	Jasmine 03/29/07 REMEMBER_BRANCH_SETTING									*
 *	Jasmine 03/31/07 SUPPORT_MULTI_STEP_UNDO									*
 *	Jasmine 04/09/07 ADD_USE_CHECK												*
 *	Jasmine 04/17/17 DLG_RESIZE_PAINT_MESS										*
 *	Jasmine 04/17/07 MOVE_ADD_TAB_ACTIVE										*
 *	Jasmine 05/09/07 REARRANGE_TAB_CONTENT										*
 *	Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY							*
 *	Jasmine 05/25/07 REDRAW_GUI_SMOOTHER										*
 *	Jasmine 05/31/07 QA80-9845 COLORWELL_OPTIONS_ATTRIBUTE						*
 *	Jasmine 05/31/07 #0858 CALL_XF_LAYADD_LEAD_TO_CRASH							*
 *	Jasmine 06/15/07 MODIFICATION_SET_COLOR_FUNCTION							*
 *	Jasmine 06/18/07 QA70-9929 COLOR_1_OFFSET_FROM_DYNA_CNTRL					*
 *	Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING					*
 *	Jasmine 08/01/07 APPLY_FORMAT_AFTER_ADD_GRAPH								*
 *	Jasmine 08/13/07 MAKE_APPLY_UNDOABLE										*
 *	ML 11/7/2007 ALREADY_IN_RESOURCE											*
 *	Jasmine 11/09/07 QA70-10621 USE_REAL_LAYER_NAME_NOT_INDEX					*
 *	Fisher 11/15/07 ADD_MAP_ID_TO_CHM											*
 *	Jasmine 11/25/08 v8.0979 QA80-12464 COPY_SOURCE_PAGE_SIZE_TO_PREVIEW		*
 *	Jasmine 12/03/08 v8.0982 PAGE_CLONE_CAN_APPLY_TO_EXISTING_PAGE				*
 *	Jasmine 12/08/08 v8.0983 QA80-12464 KEEP_PREVIEW_RESULT_SOURCE_GRAPHS_CONSISTENT*
 *	Jasmine 12/08/08 v8.0983 SWAP_LAYERS_SHOULD_HAVE_TWO_DIFF_INIT_VALUE		*
 *	Jasmine 12/11/2008 v8.0985 QA80-12464-P3 KYLE_CHANGE_VC_CODE_AND_PAGE_ICON_SHOW*
 *	Jasmine 12/16/08 v8.0987b MINUS_1_CANNOT_SEL_LAST_ROW						*
 *	Jasmine 12/24/08 v8.0990c QA80-12812  ADD_INFO_FOR_USER_FRIENDLY				*
 *	Jasmine 12/24/08 v8.0990c QA80-12850 REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
 *	Jasmine 12/24/08 v8.0990c QA80-12812  ADD_DISPLAY_TAB_FOR_COLOR_AND_DRAW_ORDER*
 *	Jasmine 12/24/08 v8.0990c QA80-12812  ADD_DISPLAY_TAB_FOR_COLOR_AND_DRAW_ORDER*
 *	Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT		*
 *	Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH	*
 *	Jasmine 12/29/08 v8.0991b QA80-12812  SET_SCALE_TYPE_IN_ADDING_NEW_LAYER	*
 *	Jasmine 12/30/08 v8.0992 QA80-12812  TOP_TEXT_TOO_BIG						*
 *	Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON	*
 *	Jasmine 12/31/08 v8.0992c QA80-12883 SET_BRANCH_NO_CLOSEABLE				*
 *	Jasmine 12/31/08 v8.0992c QA80-12812 REMOVE_NO_NAME_TO_KEEP_LAYER_DISPLAY_NAME_CONSISTENT_WITH_PLOT_DETAIL
 *	Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
 *	Jasmine 01/04/09 v8.0993c QA80-12812 WHEN_CHANGE_SEL_LAYER_SHOW_ITS_SCALE	*
 *	Jasmine 01/07/09 v8.0994b GET_OPTIMAL_SIZE_FROM_DYNA_TREE					*
 *	Jasmine 01/07/09 v8.0994b QA80-12812 CP_SAY_MODIFY_AXIS_SHOULD_NOT_WITH_ADD_LAYER
 *	Jasmine 01/07/09 v8.0994b QA80-12812 CENTRAILIZE_ALL_BUTTON_NAME_TO_APPLY_TP_SIMPLIFY_DOCUMENTATION
 *	Jasmine 01/07/09 v8.0994d QA80-10257 REWRTIE_WITH_APPLY_FORMAT_TO_UNDO		*
 *  Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS							*
 *	Kyle 01/08/2009 v8.0994d QA80-12812 SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
 *	Jasmine 01/09/09 v8.0995 QA80-12812 ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL	*
 *  Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS							*
 *  Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE							*
 *  Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON					*
 *	Jasmine 01/09/09 v8.0995 QA80-12812 KEEP_ACTIVE_TAB_AND_EACH_OPTION_VALUE	*
 *	Kyle 01/12/2009  v8.0995c QA80-12812 ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE	*
 *	Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
 *	Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
 *	Folger 01/13/09 v8.0995d OPTION_GETN_EVENT_FOR_AXIS_TICK_ENABLE_STATUS		*
 *	Folger 01/13/09 v8.0995d RUNTIME_ERROR_WHEN_CANCEL_LAYER_SELECTION			*
 *	Kyle 01/13/2009 v8.0995d OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
 *	Jasmine 01/13/09 v8.0995d IF_NEW_NAME_EMPTY_THEN_SET_OLD_NAME_BACK			*
 *	Jasmine 01/13/09 v8.0995d UNDO_SET_LAYER_NAME								*
 *	Jasmine 01/14/09 NEED_CHECK_IF_REQUIRE_UPDATE								*
 *  Iris 01/15/2009 LINK_TO_FIRST_LAYER_WHEN_ARRANGE							*
 *	Jasmine 01/15/09 MAX_ASK_NOT_CHANGE_OLD_LINK_RELATIONSHIP_EVEN_UNIT_NOT_PECENT_OF_LINK_LAYER
 *	Jasmine 01/15/09 SET_DEFAULT_UNIT_TO_PECENT_OF_LINK_LAYER					*
 *	Jasmine 01/16/09 CHANGE_UNIT_ONLY_ON_LINKTO_NODE_CHANGE						*
 *	Kyle 01/16/2009 UPDATE_GUI_SETTING_AFTER_APPLY_DISPLAY						*
 *	Kyle 01/19/2009 SAVE_SETTING_OF_ARRANGE_SELECTION_AND_LINK_ARRANGE			*
 *	Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE					*
 *	Kyle 01/21/2009 ON_LAYER_LINK_CHANGE										*
 *	Kyle 01/22/2009 SHOW_LAYER_LIST_ON_M_LINK_SELECTED							*
 *  Iris 01/22/2009 IMPROVE_COLOR_OF_SELECTED_LAYER_ICON						*
 *	Kyle 01/22/2009 SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY						*								*
 *	Kyle 01/23/2009 CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES	*
 *	Jasmine 01/23/09 ADD_LOCALIZED_CATEGORY										*
 *	Jasmine 02/01/09 CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE					*
 *	Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH			*
 *  Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED				*
 *	Jasmine 02/11/09 SHARE_ERR_MSG_WITH_MERGE_GRAPH								*
 *	Jasmine 02/13/09 AUTO_SIZE_BY_COLUMN_CONTENT								*
 *	Jasmine 03/20/09 CENTRAILIZE_ADD_LAYER_CODE_IN_LAYADD_XF_AND_LAYERMANAGEMENT*
 *	Jasmine 03/23/09 SET_LAYER_NAME_WITH_ADDING_TYPE							*
 *	Jasmine 03/24/09 KEEP_CURRENT_LAYER_SELECTED_AFTER_NEW_LAYER_ADD			*
 *	Jasmine 03/24/09 SWITCH_LINKTO_NVAL_ON_LEFT_LAYER_SELECT_CHANGE				*
 *	Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH						*
 *	Jasmine 04/03/09 AUTO_FIND_PARENT_LAYER_FROM_SELECTED_LAYER					*
 *	Jasmine 04/08/09 AUTO_FIND_IS_REJECTED_BY_USER_SINCE_IT_CHANGE_USER_SETTING	*
 * Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG					*
 *	Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB			*
 *	Kenny 08/07/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES	*
 *	Kenny 08/11/2009 QA81-14122 LINK_TO_SHOW_WRONG_ITEM_WHEN_LAYER_IS_NOT_LINKED*
 *	Jasmine 08/19/09 GETROWS_IS_WRONG_IN_DELETE_MULTI_LAYER						*
 *	Jasmine 08/18/09 GUI_TO_ADD_2ND_NONLINEAR_AXIS								*
 *	Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB*
 *	Jasmine 09/04/09 SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME				*
 *	Jasmine 09/15/09 QA81-14321 SAVE_SPACING_SETTING_FOR_ARRANGEMENT			*
 *	Kenny 10/20/2009 QA80-14100 MORE_WORK_ON_ADDING_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB*
 *  Iris 10/22/2009 QA80-14515 KEEP_LINK_LAYERS_UNCHECK							*
 *	Kyle 08/10/2010 ORG-172-S1 OC_DISABLE_ZOOM_FOR_PREVIEW						*
 *	Jasmine 08/13/2010 ORG-172-S2 CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL	*
 *	Jasmine 02/12/11 ORG-695 ARRANGE_OUTSIDE_CHILD_LAYER						*
 *	Folger 04/11/2011 ORG-2177-P1 LT_ARG_COPY_WRONG_ACTIVE_PAGE_ON_EXPORT_GRAPH	*
 *	Jasmine 10/11/2011 ORG-4052-P1 NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART		*
 *	Jasmine 10/25/2011 ORG-4217-S1 SEL_NEWLY_CREATED_LAYER_FOR_FURTHER_EDIT		*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <event_utils.h>
#include <o8dlg.h>
#include "DialogEx.h"
#include "GraphPageControl.h"
#include "graph_utils.h"

#define BASE_WINDOW						MultiPaneDlg
#include "DynaDlg.h"

#include <Profiler.h>
#define SHOW_TIME(_str)		//Profiler junk; string strjunk(_str); out_str(strjunk);

///Jasmine 02/01/09 CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
//#define REMOVE_AXES_TAB
///End CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE

#define STR_DLG_NAME 					_L("Layer Management")
#define STR_LAYER_UNIT_LIST				_L("% of Page|inch|cm|mm|pixel|point")
//#define STR_LAYER_TYPE_LIST				_L("(Normal): Bottom X + Left Y|(Linked): Top X|(Linked): Right Y|(Linked): Top X + Right Y|(Linked): Inset|(Linked): Inset With Data")///Jasmine 03/20/09 CENTRAILIZE_ADD_LAYER_CODE_IN_LAYADD_XF_AND_LAYERMANAGEMENT
///Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
//#define STR_BORDER_STYLE_LIST			_L("None|Black Line|Shadow|Dark Marble|White Out|Black Out")		///Kyle 01/12/2009  v8.0995c QA80-12812 ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE
///End BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE

/// Iris 01/22/2009 ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH, move to graph_utils.h
/*
///Kyle 01/22/2009 SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY
#define STR_X_DEFAULT_TITLE "%(?X)"
#define STR_Y_DEFAULT_TITLE "%(?Y)"
///End SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY
*/
///end ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH

#define STR_TICK_LIST					_L("In & Out|In|Out|None")											///Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
//#define STR_LAYER_LIST_TOOL_TIPS		_L("Right-click to Delete or Reorder")     
//#define STR_LAYER_LIST_TOOL_TIPS		_L("Right-click to Delete. Drag on the ExplorerBar to Reorder.")    ///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
///End REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
#define STR_OPTION						_L("Option")	///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
#define STR_APPLY_BTN					_L("Apply")		///Jasmine 01/07/09 v8.0994b QA80-12812 CENTRAILIZE_ALL_BUTTON_NAME_TO_APPLY_TP_SIMPLIFY_DOCUMENTATION
/// ML 11/7/2007 ALREADY_IN_RESOURCE
//#define STR_LINK_LAYER_HINTS			_L("All linked layer(s) with % of Linked Layer as Units will keep its spatial relationship in arrangement. \nPress F1 for more info.")
/// end ALREADY_IN_RESOURCE

#define STR_CHECK_BOX_VALUES			"CheckBoxValues"
///Jasmine 01/09/09 v8.0995 QA80-12812 KEEP_ACTIVE_TAB_AND_EACH_OPTION_VALUE
#define STR_TAB_VALUE					"SelTabValue"		
#define STR_SIZE_TAB_OPTION				"SizeTabOption"
///End KEEP_ACTIVE_TAB_AND_EACH_OPTION_VALUE
#define STR_ARRANGE_ORDER_VALUE			"ArrangeOrder"	///Jasmine 01/13/11 ORG-1084 KEEP_POSITION_ORDER_IN_ARRANGEMENT

#define _CAT 							"laymanage"		///Jasmine 01/23/09 ADD_LOCALIZED_CATEGORY
//#define STR_SEL_LAYER_ATTRIB			"SelectedLayers"
//#define WM_USER_ON_GRAPH_LAYERS_CHANGE			(WM_USER + 1024)
//#define WM_USER_ON_REFERENCE_LAYERS_CHANGE		(WM_USER + 1026)	///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
//#define WM_USER_ON_GRAPH_CHANGE					(WM_USER + 1028)

///Jasmine 03/15/07 ADD_UNDO_BUTTON
#define BEFORE_UNDO_BLOCK				int idBefore = Project.UndoBlockId(); { UndoBlock block; 
#define AFTER_UNDO_BLOCK				} int idAfter = Project.UndoBlockId(); undo_enabled(true, 1); enable_apply(); 	//GetItem(IDC_LAYERTOOL_UNDO).Enable = true;	///Jasmine 03/31/07 SUPPORT_MULTI_STEP_UNDO
///End ADD_UNDO_BUTTON

//#define AUTO_CHECK_BOX_READY	///Jasmine 03/23/07 ADD_AUTO_CHECK_BOX

///Jasmine 05/31/07 #0858 CALL_XF_LAYADD_LEAD_TO_CRASH
#define		INSET_LAYER_LEFT	75
#define		INSET_LAYER_TOP		0
#define		INSET_LAYER_WIDTH	25
#define		INSET_LAYER_HEIGHT	25
///End CALL_XF_LAYADD_LEAD_TO_CRASH

enum{SEL_ROW_UNASSIGNED = -2, SEL_LAST_ROW};

enum{
	LAYERTOOL_ADD_TAB, 
	LAYERTOOL_EDIT_TAB, 
	LAYERTOOL_SIZE_TAB, 
	LAYERTOOL_LINK_TAB,
///Jasmine 02/01/09 CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
#ifndef REMOVE_AXES_TAB 
	LAYERTOOL_AXES_TAB,		///Jasmine 01/09/09 v8.0995 QA80-12812 ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL
#endif//REMOVE_AXES_TAB
///End CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
	LAYERTOOL_DISPLAY_TAB, 	///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_DISPLAY_TAB_FOR_COLOR_AND_DRAW_ORDER
	
	LAYERTOOL_TAB_COUNT
};	///Jasmine 04/17/07 MOVE_ADD_TAB_ACTIVE

///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
enum{
	SIZE_TAB_RESIZE,
	SIZE_TAB_MOVE,
	SIZE_TAB_SWAP,
	SIZE_TAB_ALIGN
};
///End USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
			
///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
enum{
	DISPLAY_TAB_COLOR, 
	DISPLAY_TAB_BORDER,
	DISPLAY_TAB_SCALE_FACTOR,	///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
};	
///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH

enum{LAYER_LIST_INDEX_COL, LAYER_LIST_NAME_COL};

///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
//enum{LAYER_LIST_MENU_DELETE_LAYER, LAYER_LIST_MENU_REORDER_LAYER, LAYER_LIST_MENU_LAST_ITEM};
enum{LAYER_LIST_MENU_DELETE_LAYER, LAYER_LIST_MENU_LAST_ITEM};
///End REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
enum{
	LM_MODIFY_BTN_ID = 1,
	///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
	LM_DISPLAY_TAB_RADIO_ID,
	LM_SET_BORDER_BTN_ID,
	///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
	LM_FILL_BG_COLOR_BTN_ID, 
	LM_LAYER_TYPE_ID,
	LM_LINK_TO_ID,				///Jasmine 12/29/08 v8.0991b QA80-12812  SET_SCALE_TYPE_IN_ADDING_NEW_LAYER	
	LM_ADD_BTN_ID,
	LM_ARRANGE_BTN_ID,
	LM_ARRANGE_SELECTION_ID, /// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS
	LM_POSITION_ORDER_ID, 		///Jasmine 01/13/11 ORG-1084 KEEP_POSITION_ORDER_IN_ARRANGEMENT
	LM_SCALE_ELEMENT_ID,
	LM_SET_SCALE_FACTOR_BTN_ID,
	LM_DRAW_ORDER_ID,
	LM_SIZR_TAB_RADIO_ID,		///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
	///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
	//LM_REF_LAYER_ID,
	LM_SIZE_REF_LAYER_ID,
	//LM_CUSTOM_ID,
	//LM_UNITS_BTN_ID,
	LM_SIZE_UNITS_BTN_ID,
	LM_MOVE_REF_LAYER_ID,
	LM_MOVE_UNITS_BTN_ID,
	///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
	LM_RESIZE_BTN_ID,
	LM_MOVE_BTN_ID,
	/// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS
	LM_SWAP_LAYERA_ID, 
	LM_SWAP_LAYERB_ID,
	///end SET_ICON_COLOR_FOR_SELECTED_LAYERS
	LM_SWAP_BTN_ID,
	LM_ALIGN_BTN_ID,
	LM_LINK_PARENT_ID, /// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
	LM_X_AXIS_ID,
	LM_Y_AXIS_ID,
	LM_LINK_BTN_ID,	
	//LM_DISLINK_BTN_ID, /// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
};

//---Jasmine 12/08/08 v8.0983 QA80-12464 KEEP_PREVIEW_RESULT_SOURCE_GRAPHS_CONSISTENT
typedef struct
{
	DWORD			dwNoClick;
	bool			bAxisIcon;
	bool			bPageIcon;
}stPageSetting;
//---

/// Iris 01/22/2009 ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
/*
///Kyle 01/08/2009 v8.0994d QA80-12812 SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
#define 	SA_MIN_GAP						2
enum{
	SA_HIDE_OUTER_TITLE			= 0x0001,		// show outer (only left & bottom) titles, always be hide inner titles
	SA_SHOW_INNER_AXIS			= 0x0002,		// show inner axis, if overlap will only show one, otherwise will hide all inner axis if there is no gap,
												// always show outer axis
	SA_SHOW_INNER_TICK_LABEL	= 0x0004,		// show inner tick label if inner axis is shown
												// only one X label and one Y label will be shown
};
///End SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
*/
///end ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH

///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
//use in UpdateLayerSetting and involved functions
#define UPDATE_LAYER_SETTING_EDITLAYER		"EditLayer"
#define UPDATE_LAYER_SETTING_RESIZE			"Resize"
#define UPDATE_LAYER_SETTING_MOVE			"Move"
#define UPDATE_LAYER_SETTING_COLOR			"Color"
#define UPDATE_LAYER_SETTING_BORDERWIDTH	"BorderWidth"
#define UPDATE_LAYER_SETTING_SCALEFACTOR	"ScaleFactor"	///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
#define UPDATE_LAYER_SETTING_LINK			"Link"
///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH

///Jasmine 09/04/09 SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME
#define FORCE_GUI_UPDATE_BIT		-100
///End SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME

///Jasmine 01/09/09 v8.0995 QA80-12812 KEEP_ACTIVE_TAB_AND_EACH_OPTION_VALUE
//no delete item in this list, always append at the end
enum{
	LM_REG_ADD_EXTRACT_CHECK = 0,
	LM_REG_KEEP_RATIO_CHECK,
	LM_REG_SMART_ARRANGE_CHECK,
	///Kyle 01/19/2009 SAVE_SETTING_OF_ARRANGE_SELECTION_AND_LINK_ARRANGE
	LM_REG_ARRANGE_SELECTION_CHECK,
	LM_REG_LINK_ARRANGE_CHECK,
	///End SAVE_SETTING_OF_ARRANGE_SELECTION_AND_LINK_ARRANGE
	LM_REG_TOTAL
};
///End KEEP_ACTIVE_TAB_AND_EACH_OPTION_VALUE

class LayerListMenu : public Menu
{
public:	
	LayerListMenu()
	{
		m_nChoice = -1;
		Add(_L("Delete Layer"), OnMenuItem);
		//Add(_L("Reorder"), OnMenuItem);		///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= LAYER_LIST_MENU_DELETE_LAYER && m_nChoice <= LAYER_LIST_MENU_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};

class LayerTool : public DynaDlg
{
public:
	LayerTool(GraphPage gp) : DynaDlg(IDD_LAYER_TOOL, NULL, "ODlg8", true)
	{
		if(gp)
			m_strGraph = gp.GetName();
		
		m_nCurrentInfo = 0;		///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		
		/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
		m_vnCurrentErrMsg.SetSize(LAYERTOOL_TAB_COUNT);
		m_vnCurrentErrMsg = CER_NO_ERROR;
		///end LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED

		m_bUpdateLinkTo = true;				///Jasmine 10/25/2011 ORG-4217-S1 SEL_NEWLY_CREATED_LAYER_FOR_FURTHER_EDIT
		
		SetContainerTitle(STR_DLG_NAME);	///Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG

		///------ Folger 04/11/2011 ORG-2177-P1 LT_ARG_COPY_WRONG_ACTIVE_PAGE_ON_EXPORT_GRAPH
		EnableCopyGraphPageMngr(TRUE);
		///------ End LT_ARG_COPY_WRONG_ACTIVE_PAGE_ON_EXPORT_GRAPH
	}
	~LayerTool()
	{
		///------ Folger 04/11/2011 ORG-2177-P1 LT_ARG_COPY_WRONG_ACTIVE_PAGE_ON_EXPORT_GRAPH
		EnableCopyGraphPageMngr(FALSE);
		///------ End LT_ARG_COPY_WRONG_ACTIVE_PAGE_ON_EXPORT_GRAPH
	}
	int  DoModalEx(HWND hParent = NULL) 
	{
		InitMsgMap();
		int nRet = DynaDlg::DoModal(hParent);
		return nRet;
	}
protected :	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	ON_CONTEXTMENU(OnShowMenu)
	ON_GETMINMAXINFO(OnMinMaxInfo)	///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_INFO_FOR_USER_FRIENDLY
	
	ON_GRID_SEL_CHANGE(IDC_LAYERTOOL_GRID, OnSelectionChange)
	ON_GRID_BEFORE_EDIT(IDC_LAYERTOOL_GRID, OnBeforeEdit)
	ON_GRID_AFTER_EDIT(IDC_LAYERTOOL_GRID, OnAfterEdit)
	ON_GRID_AFTER_MOVE_ROWS(IDC_LAYERTOOL_GRID, OnAfterMoveRows)	///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
	
	///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	ON_GRID_CLICK(IDC_LAYERTOOL_GRID, OnGridClicked)	
	ON_GRID_ROW_COL_CHANGE(IDC_LAYERTOOL_FRAME, OnRowColChange)
	///End SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	
	ON_BN_CLICKED(IDC_LAYERTOOL_UNDO, OnUndo)	///Jasmine 03/15/07 ADD_UNDO_BUTTON
	ON_BN_CLICKED(IDC_LAYERTOOL_APPLY, OnApply)
	//ON_BN_CLICKED(IDC_LAYERTOOL_REORDER, OnReorder)				///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
	ON_BN_CLICKED(IDOK, OnOK)
	ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
	//ON_BN_CLICKED(IDC_LAYERTOOL_ADD, OnAdd)	//COMBINE_LAYER_LIST_AND_SEL_LIST
	//ON_BN_CLICKED(IDC_LAYERTOOL_REMOVE, OnRemove)	//COMBINE_LAYER_LIST_AND_SEL_LIST
	ON_TAB_SEL_CHANGE(IDC_LAYERTOOL_TAB, OnTabChange)
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	//ON_USER_MSG(WM_USER_ON_GRAPH_LAYERS_CHANGE, OnLayersNumberChange)
	//ON_USER_MSG(WM_USER_ON_REFERENCE_LAYERS_CHANGE, OnRefLayerChange)	///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
	//ON_USER_MSG(WM_USER_ON_GRAPH_CHANGE, enable_apply)
	ON_HELPINFO(OnHelp)
EVENTS_END

	//------ fisher 11/15/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		TabControl tab = GetItem(IDC_LAYERTOOL_TAB);
		nHelpID = IDD_LM_TAB+tab.GetCurSel();
		return true;
	}

	BOOL OnInitDialog()
	{
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.Add(_L("Show Previews"));
		vstrTipsUpDown.Add(_L("Hide Previews"));
		///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_INFO_FOR_USER_FRIENDLY
		//DynaDlg::OnInitDialog(IDC_LAYERTOOL_GRID, IDC_SHOW_BOTTOM, IDC_LAYERTOOL_PREVIEW, vstrTipsUpDown, STR_DLG_NAME);
		DynaDlg::OnInitDialog(IDC_LAYERTOOL_GRID, IDC_SHOW_BOTTOM, IDC_LAYERTOOL_PREVIEW, vstrTipsUpDown, STR_DLG_NAME, 0, NULL, max(GetMinBottomPaneHeight(), 300));
		///End ADD_INFO_FOR_USER_FRIENDLY
		GetItem(IDC_LAYERTOOL_APPLY).Visible = false;///Jasmine 03/09/07 HIDE_APPLY_BUTTON
		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		//GetItem(IDC_LAYERTOOL_APPLY).Enable = false;
		GetItem(IDC_LAYERTOOL_APPLY).Enable = GetItem(IDOK).Enable = false;	
		///End INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		
		///Jasmine 03/15/07 ADD_UNDO_BUTTON
		GetItem(IDC_LAYERTOOL_UNDO).Visible = true;
		///Jasmine 03/31/07 SUPPORT_MULTI_STEP_UNDO
		//GetItem(IDC_LAYERTOOL_UNDO).Enable = false;
		undo_enabled(true, 0);
		///End SUPPORT_MULTI_STEP_UNDO
		///End ADD_UNDO_BUTTON
		
		GetItem(IDC_LAYERTOOL_REORDER).Visible = false;	///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
		
		
		InitPreview();
				
		Tree trLayers;
		InitLayerList(trLayers);
		//InitSelectedList();
		
		///Jasmine 05/09/07 REARRANGE_TAB_CONTENT
		//vector<string>  vsTabs = {"Add", "Edit", "Arrange", "Link"};///Jasmine 04/17/07 MOVE_ADD_TAB_ACTIVE
		//vector<string>  vsTabs = {"Add", "Arrange", "Size/Position", "Link"};///Jasmine 04/17/07 MOVE_ADD_TAB_ACTIVE
		vector<string>  vsTabs;
		vsTabs.SetSize(LAYERTOOL_TAB_COUNT);
		vsTabs[LAYERTOOL_ADD_TAB] 	= _LC("Add", _CAT);			///Jasmine 01/23/09 ADD_LOCALIZED_CATEGORY
		vsTabs[LAYERTOOL_EDIT_TAB] 	= _L("Arrange");
		vsTabs[LAYERTOOL_SIZE_TAB] 	= _L("Size/Position");
		vsTabs[LAYERTOOL_LINK_TAB] 	= _L("Link");
///Jasmine 02/01/09 CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
#ifndef REMOVE_AXES_TAB 
		vsTabs[LAYERTOOL_AXES_TAB] 	= _L("Axes");				///Jasmine 01/09/09 v8.0995 QA80-12812 ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL
#endif//REMOVE_AXES_TAB
///End CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
		vsTabs[LAYERTOOL_DISPLAY_TAB] = _L("Display");			///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_DISPLAY_TAB_FOR_COLOR_AND_DRAW_ORDER
		///End REARRANGE_TAB_CONTENT
		m_tab = GetItem(IDC_LAYERTOOL_TAB);
		for(int ii = 0; ii < vsTabs.GetSize(); ii++)
			m_tab.InsertItem(ii, vsTabs[ii]);
		
		///Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		//InitDynaControl(IDC_LAYERTOOL_FRAME);
		InitDynaControl(IDC_LAYERTOOL_FRAME, *this);
		///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		ConstructTree();		
		///Jasmine 01/07/09 v8.0994b GET_OPTIMAL_SIZE_FROM_DYNA_TREE
		//must after tab and dyna init done
		InitTopTextPosition();							///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_INFO_FOR_USER_FRIENDLY
		///End GET_OPTIMAL_SIZE_FROM_DYNA_TREE
		
		OnLayersNumberChange(true, m_nActive + 1);
		
		LoadBranchSetting(STR_DLG_NAME);	///Jasmine 03/29/07 REMEMBER_BRANCH_SETTING	
		loadSettingsFromRegister();		
		///Jasmine 09/15/09 QA81-14321 SAVE_SPACING_SETTING_FOR_ARRANGEMENT
		loadSpacingSettings();
		///End SAVE_SPACING_SETTING_FOR_ARRANGEMENT
		//---call after loadSettingsFromRegister
		OnTabChange(m_tab);//onTabChange();						///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		//---
		
		//GetItem(IDC_LAYERTOOL_TEXT).Visible = true;				///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		/// ML 11/7/2007 ALREADY_IN_RESOURCE
		//GetItem(IDC_LAYERTOOL_TEXT).Text = STR_LINK_LAYER_HINTS;
		/// end ALREADY_IN_RESOURCE
		
		return true;
	} 
	BOOL OnDestroy()
	{
		SaveBranchSetting(STR_DLG_NAME);	///Jasmine 03/29/07 REMEMBER_BRANCH_SETTING		
		saveSettingsToRegister();
		return DynaDlg::OnDestroy();
	}
	BOOL OnReady()
	{
		//UpdateDlgSize();
		UpdateDlgShow();
		SetInitReady();
		return TRUE;
	}
	///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	//BOOL OnDlgResize(int nType, int cx, int cy) 
	BOOL OnDlgResize(int nType = 0, int cx = 0, int cy = 0) 
	///End SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	{	
		if(!IsInitReady())
			return TRUE;
		
		///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		RECT rrWnd;
		GetClientRect(&rrWnd);
		
		if (cx == 0)
			cx = rrWnd.right - rrWnd.left;
		if (cy == 0)
			cy = rrWnd.bottom - rrWnd.top;
		///End SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		
		///Jasmine 04/17/17 DLG_RESIZE_PAINT_MESS
		MoveControlsHelper	_temp(this);		
		_temp.Exclude(IDC_LAYERTOOL_TAB);
		//GetItem(IDCANCEL).Visible = false;
		vector<uint> nButtonIDs = {IDCANCEL, 0};
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
		
		
		nButtonIDs.InsertAt(0, IDOK);
		//nButtonIDs.InsertAt(0, IDC_LAYERTOOL_APPLY);///Jasmine 03/09/07 HIDE_APPLY_BUTTON
		nButtonIDs.InsertAt(0, IDC_LAYERTOOL_UNDO);///Jasmine 03/15/07 ADD_UNDO_BUTTON
		RECT rGrid1, rGrid2, rTab, rAdd, rShowBottom, rText;
		GetClientRect(GetItem(IDC_LAYERTOOL_GRID), rGrid1);
		GetClientRect(GetItem(IDC_SHOW_BOTTOM), rShowBottom);
		//GetItem(IDCANCEL).Visible = true;
		///End DLG_RESIZE_PAINT_MESS
		ArrangeControlsLeftRight(nButtonIDs, rGrid1.left, rShowBottom.top);
		
		int nGap = GetControlGap();	
		
		///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		/*
		GetClientRect(GetItem(IDC_LAYERTOOL_TEXT), rText);		
		int nHeight = RECT_HEIGHT(rText);
		rText.right = rShowBottom.right;
		rText.bottom = rGrid1.bottom;
		rText.top = rText.bottom - nHeight;
		MoveControl(GetItem(IDC_LAYERTOOL_TEXT), rText); 	
		*/
		int nErrMessageHeight = GetDlgStatusMsgBoxHeight(rShowBottom.right - nGap);
		
		GetClientRect(m_btnErrMessage, rText);
		rText.bottom = rGrid1.bottom;
		rText.top = rText.bottom - nErrMessageHeight;
		rText.left = nGap;
		rText.right = rShowBottom.right;
		MoveControl(m_btnErrMessage, rText);
		///End SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		
			
		vector<uint> vnTopPaneIDs = {IDC_LAYERTOOL_TAB, 0};//IDC_LAYERTOOL_DESTINATION
		for(int ii = 0; vnTopPaneIDs[ii] != 0; ii++)
		{
			GetClientRect(GetItem(vnTopPaneIDs[ii]), rGrid2);
			rGrid2.bottom = rText.top - nGap;//rGrid1.bottom;
			MoveControl(GetItem(vnTopPaneIDs[ii]), rGrid2); 			
		}
		//GetClientRect(GetItem(IDC_LAYERTOOL_ADD), rAdd);
		//rGrid1.right = rAdd.left - nGap;
		//MoveControl(GetItem(IDC_LAYERTOOL_GRID), rGrid1); 
		
		GetClientRect(m_tab, rTab);
		rTab.right = rShowBottom.right;
		MoveControl(m_tab, rTab); 	
		
		///Jasmine 01/07/09 v8.0994b GET_OPTIMAL_SIZE_FROM_DYNA_TREE
		//before rTab.AdjustRect
		rGrid1.right = rTab.left - nGap;
		rGrid1.bottom = rText.top - nGap;
		MoveControl(GetItem(IDC_LAYERTOOL_GRID), rGrid1); 
		///End GET_OPTIMAL_SIZE_FROM_DYNA_TREE
		
		m_tab.GetWindowRect(&rTab);	
		ScreenToClient(&rTab);		
		m_tab.AdjustRect(FALSE, &rTab);
		GetItem(IDC_LAYERTOOL_FRAME).MoveWindow(&rTab);
		
		
		return TRUE;
	}	
	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
	{
		return FALSE;
	}
	BOOL OnRestoreSize(ODWP dwSizeInfo)
	{	
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		
		string strDlgName = STR_DLG_NAME;
		lstrcpyn(pSz->szDialogName, strDlgName, MAXLINE);
		pSz->top = -1;
		pSz->left = -1;
		pSz->width = max(m_nMinWidth + max(GetMinBottomPaneHeight(), 300) + 4*GetControlGap(), 755);	///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_INFO_FOR_USER_FRIENDLY
		pSz->height = 610;  //hard code, will change later
		return TRUE;
	}
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if(IDC_LAYERTOOL_GRID == nResIDCtrl)
			return showLayerListMenu(nx, ny);
		return FALSE;
	}
	//----COMBINE_LAYER_LIST_AND_SEL_LIST
	BOOL OnSelectionChange(Control cntrl)
	{	
		SHOW_TIME("OnSelectionChange")
		
		vector<uint> vnRows;
		if(!m_Layerlist.IsReady())
			return FALSE;
		m_Layerlist.GetSelRows(vnRows);
		int nSize = vnRows.GetSize();
		TreeNode tr = GetTree();	
		//vector<string> vsButtons = {"ModifyButton", "ResizeButton", "MoveButton", "AlignButton", "LinkButton", "DislinkButton"};
		vector<string> vsButtons = {"ModifyButton", "ResizeButton", "MoveButton", "AlignButton", "LinkButton"}; /// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
		for(int ii = 0; ii < vsButtons.GetSize(); ii++)
		{
			TreeNode trNode = tree_get_node_by_tagname(tr, vsButtons[ii], true);
			if(trNode.IsValid())
				trNode.Enable = nSize > 0;//disable buttons if no selection
		}
		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		bool bNeedUpdate = EnableButtonOnChange(tr, nSize > 1);//multi sel		
		///End INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		
		///Jasmine 10/11/2011 ORG-4052-P1 NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
		if(tr.RadarChartHint)tr.RadarChartHint.Show = false;
		if(m_tab.GetCurSel() == LAYERTOOL_AXES_TAB)
		{
			bool bAxes = isSelLayerAxesEditable();	
			if(tr.EditLayer.IsValid())
				tr.EditLayer.Show = bAxes;
			if(!bAxes && tr.RadarChartHint)
				tr.RadarChartHint.Show = true;
		}
		///End NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
		
		constructLinkToList();
		highlightSelectLayerIcon(); 	 /// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS	
		/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		if ( 1 == nSize )
		{
			ClearAllUndefinedAttributes();
		}
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		if(1 == nSize && m_nSelRow !=vnRows[0])
		{
			int nIndex = get_layer_index( vnRows[0] );
			
			///Jasmine 03/24/09 SWITCH_LINKTO_NVAL_ON_LEFT_LAYER_SELECT_CHANGE
			if(	tr.Add && tr.Add.LinkTo && tr.Add.LinkTo.nVal != nIndex 
				&& m_bUpdateLinkTo)			///Jasmine 10/25/2011 ORG-4217-S1 SEL_NEWLY_CREATED_LAYER_FOR_FURTHER_EDIT, no set current layer index to LinkTo if it's a linked one so that user can quickly add another linked layer to the same parent 
			{
				if(tr.Add.LinkTo.Enable == -1 || tr.Add.LinkTo.Enable == ENABLE)
				{
					tr.Add.LinkTo.nVal = nIndex;
					OnShowLinkLayerScale(tr);
				}
			}
			///End SWITCH_LINKTO_NVAL_ON_LEFT_LAYER_SELECT_CHANGE
			
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			UpdateLayerSetting(gl, tr, bNeedUpdate);
		}
		else if(bNeedUpdate)
		{
			SetConflictItemsToUndefined();	/// Kenny 08/07/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
		}
		
		///------ Folger 01/13/09 v8.0995d RUNTIME_ERROR_WHEN_CANCEL_LAYER_SELECTION
		if ( vnRows.GetSize() <= 0 )
			m_nSelRow = -1;
		else
		///------ End v8.0995d RUNTIME_ERROR_WHEN_CANCEL_LAYER_SELECTION
			m_nSelRow = vnRows[0];
		//UpdateDynaControl(false, GETNEVENT_ON_INIT);

		return TRUE;
	}
	//----end
	
	///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH 
	//void UpdateLayerSetting(const GraphLayer& gl, TreeNode& tr, bool bUpdate)
	void UpdateLayerSetting(const GraphLayer& gl, TreeNode& tr, bool bUpdate, const vector<string>& vsUpdate = NULL)
	///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
	{
		if(!gl || !tr)
			return;	
			
		///------ Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
		Tree 		trFmt;
		/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES, use correct object filter bits instead
		//trFmt = gl.GetFormat(FPB_ALL, FPB_ALL, true, true);
		trFmt = gl.GetFormat(FPB_ALL, FOB_ALL, true, true);
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		TreeNode	trRoot = trFmt.Root;
		///------ End AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
		
		///Jasmine 03/22/07 ADD_GET_AXIS_SHOW
		//update edit tab
		///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		TreeNode trEdit = tree_get_node_by_tagname(tr, UPDATE_LAYER_SETTING_EDITLAYER, true);
		//if(trEdit.IsValid())
		if(	trEdit.IsValid() 
			&& ( !vsUpdate || vsUpdate.Find(UPDATE_LAYER_SETTING_EDITLAYER) >= 0 )
			&& isAxesEditable(gl) )						///Jasmine 10/11/2011 ORG-4052-P1 NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
		///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		{	
 			//bool bottom, left, top, right;	/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			int xscale, yscale;
			axis_get_scale_type(gl, &xscale, &yscale);
			trEdit.XScale.nVal = xscale;
			trEdit.YScale.nVal = yscale;

			/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
// 			///------ Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
// 			TreeNode	trAxesX = trRoot.Axes.X;
// 			TreeNode	trAxesY = trRoot.Axes.Y;
// 			
// 			/// bottom
// 			TreeNode	trBottomTicks = trAxesX.Ticks.BottomTicks;
// 			if ( trBottomTicks )
// 			{
// 				TreeNode	trBottomTicksShow = trBottomTicks.GetNode("Show");
// 				trEdit.BottomAxes.AxisShow.nVal = trBottomTicksShow.nVal > 0;
// 				trEdit.BottomAxes.Tick.nVal = trBottomTicks.Major.nVal;
// 			}
// 			else
// 			{
// 				trEdit.BottomAxes.AxisShow.nVal = trEdit.BottomAxes.Tick.nVal = 0;
// 			}
// 			_check_enable_axes_major_tick(trEdit.BottomAxes.AxisShow);
// 			
// 			TreeNode	trBottomLabels = trAxesX.Labels.BottomLabels;
// 			if ( trBottomLabels )
// 			{
// 				TreeNode	trBottomLabelsShow = trBottomLabels.GetNode("Show");
// 				trEdit.BottomAxes.TickLabel.nVal = trBottomLabelsShow.nVal > 0;
// 			}
// 			else
// 			{
// 				trEdit.BottomAxes.TickLabel.nVal = 0;
// 			}
// 			TreeNode	trBottomTitle = trAxesX.Titles.BottomTitle;
// 			if ( trBottomTitle )
// 			{
// 				TreeNode	trBottomTitleShow = trBottomTitle.GetNode("Show");
// 				///Kyle 01/23/2009 CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES
// 				//trEdit.BottomAxes.Title.nVal = trBottomTitleShow.nVal > 0;
// 				TreeNode trText = trBottomTitle.GetNode("Text");
// 				string strTitle = trText.strVal;
// 				strTitle.TrimLeft();strTitle.TrimRight();
// 				trEdit.BottomAxes.Title.nVal = trBottomTitleShow.nVal > 0 && !strTitle.IsEmpty();
// 				///End CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES
// 			}
// 			else
// 			{
// 				trEdit.BottomAxes.Title.nVal = 0;
// 			}
// 			
// 			///left
// 			TreeNode	trLeftTicks = trAxesY.Ticks.LeftTicks;
// 			if ( trLeftTicks )
// 			{
// 				TreeNode	trLeftTicksShow = trLeftTicks.GetNode("Show");
// 				trEdit.LeftAxes.AxisShow.nVal = trLeftTicksShow.nVal > 0;
// 				trEdit.LeftAxes.Tick.nVal = trLeftTicks.Major.nVal;
// 			}
// 			else
// 			{
// 				trEdit.LeftAxes.AxisShow.nVal = trEdit.LeftAxes.Tick.nVal = 0;
// 			}
// 			_check_enable_axes_major_tick(trEdit.LeftAxes.AxisShow);
// 			
// 			TreeNode	trLeftLabels = trAxesY.Labels.LeftLabels;
// 			if ( trLeftLabels )
// 			{
// 				TreeNode	trLeftLabelsShow = trLeftLabels.GetNode("Show");
// 				trEdit.LeftAxes.TickLabel.nVal = trLeftLabelsShow.nVal > 0;
// 			}
// 			else
// 			{
// 				trEdit.LeftAxes.TickLabel.nVal = 0;
// 			}
// 			TreeNode	trLeftTitle = trAxesY.Titles.LeftTitle;
// 			if ( trLeftTitle )
// 			{
// 				TreeNode	trLeftTitleShow = trLeftTitle.GetNode("Show");
// 				///Kyle 01/23/2009 CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES
// 				//trEdit.LeftAxes.Title.nVal = trLeftTitleShow.nVal > 0;
// 				TreeNode trText = trLeftTitle.GetNode("Text");
// 				string strTitle = trText.strVal;
// 				strTitle.TrimLeft();strTitle.TrimRight();
// 				trEdit.LeftAxes.Title.nVal = trLeftTitleShow.nVal > 0 && !strTitle.IsEmpty();
// 				///End CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES
// 			}
// 			else
// 			{
// 				trEdit.LeftAxes.Title.nVal = 0;
// 			}
// 			
// 			///top
// 			TreeNode	trTopTicks = trAxesX.Ticks.TopTicks;
// 			if ( trTopTicks )
// 			{
// 				TreeNode	trTopTicksShow = trTopTicks.GetNode("Show");
// 				trEdit.TopAxes.AxisShow.nVal = trTopTicksShow.nVal > 0;
// 				trEdit.TopAxes.Tick.nVal = trTopTicks.Major.nVal;
// 			}
// 			else
// 			{
// 				trEdit.TopAxes.AxisShow.nVal = trEdit.TopAxes.Tick.nVal = 0;
// 			}
// 			_check_enable_axes_major_tick(trEdit.TopAxes.AxisShow);
// 			
// 			TreeNode	trTopLabels = trAxesX.Labels.TopLabels;
// 			if ( trTopLabels )
// 			{
// 				TreeNode	trTopLabelsShow = trTopLabels.GetNode("Show");
// 				trEdit.TopAxes.TickLabel.nVal = trTopLabelsShow.nVal > 0;
// 			}
// 			else
// 			{
// 				trEdit.TopAxes.TickLabel.nVal = 0;
// 			}
// 			TreeNode	trTopTitle = trAxesX.Titles.TopTitle;
// 			if ( trTopTitle )
// 			{
// 				TreeNode	trTopTitleShow = trTopTitle.GetNode("Show");
// 				///Kyle 01/23/2009 CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES
// 				//trEdit.TopAxes.Title.nVal = trTopTitleShow.nVal > 0;
// 				TreeNode trText = trTopTitle.GetNode("Text");
// 				string strTitle = trText.strVal;
// 				strTitle.TrimLeft();strTitle.TrimRight();
// 				trEdit.TopAxes.Title.nVal = trTopTitleShow.nVal > 0 && !strTitle.IsEmpty();
// 				///End CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES
// 			}
// 			else
// 			{
// 				trEdit.TopAxes.Title.nVal = 0;
// 			
// 			}
// 			///right
// 			TreeNode	trRightTicks = trAxesY.Ticks.RightTicks;
// 			if ( trRightTicks )
// 			{
// 				TreeNode	trRightTicksShow = trRightTicks.GetNode("Show");
// 				trEdit.RightAxes.AxisShow.nVal = trRightTicksShow.nVal > 0;
// 				trEdit.RightAxes.Tick.nVal = trRightTicks.Major.nVal;
// 			}
// 			else
// 			{
// 				trEdit.RightAxes.AxisShow.nVal = trEdit.RightAxes.Tick.nVal = 0;
// 			}
// 			_check_enable_axes_major_tick(trEdit.RightAxes.AxisShow);
// 			
// 			TreeNode	trRightLabels = trAxesY.Labels.RightLabels;
// 			if ( trRightLabels )
// 			{
// 				TreeNode	trRightLabelsShow = trRightLabels.GetNode("Show");
// 				trEdit.RightAxes.TickLabel.nVal = trRightLabelsShow.nVal > 0;
// 			}
// 			else
// 			{
// 				trEdit.RightAxes.TickLabel.nVal = 0;
// 			}
// 			TreeNode	trRightTitle = trAxesY.Titles.RightTitle;
// 			if ( trRightTitle )
// 			{
// 				TreeNode	trRightTitleShow = trRightTitle.GetNode("Show");
// 				///Kyle 01/23/2009 CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES
// 				//trEdit.RightAxes.Title.nVal = trRightTitleShow.nVal > 0;
// 				TreeNode trText = trRightTitle.GetNode("Text");
// 				string strTitle = trText.strVal;
// 				strTitle.TrimLeft();strTitle.TrimRight();
// 				trEdit.RightAxes.Title.nVal = trRightTitleShow.nVal > 0 && !strTitle.IsEmpty();
// 				///End CONSIDER_TITLE_NOT_SHOWN_IF_THE_TEXT_CONTAINS_ONLY_SPACES
// 			}
// 			else
// 			{
// 				trEdit.RightAxes.Title.nVal = 0;
// 			}
// 			///------ End AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
			vector<int> vnAxes, vnLabels, vnTitles, vnMajorTicks, vnMinorTicks;
			BOOL bRet = layer_get_axes_object_properties(gl, vnAxes, vnLabels, vnTitles, vnMajorTicks, vnMinorTicks, trFmt);
			ASSERT(bRet);
			///Jasmine 08/18/09 GUI_TO_ADD_2ND_NONLINEAR_AXIS
			vector<string> 	vsFormula;
			vector<int>		vnAxisType;		vnAxisType.Data(0, AXIS_TOTAL-1);
			/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
			//bRet = _get_set_axis_label_formula(gl, vnAxes, vsFormula, true);
			bRet = _get_set_axis_label_formula(gl, vnAxisType, vsFormula, true, trFmt);
			/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
			ASSERT(bRet);
			///End GUI_TO_ADD_2ND_NONLINEAR_AXIS
			vector<string> vsNodePrefix = {"Bottom", "Left", "Top", "Right"};

			for(int nAxisType = 0; nAxisType < AXIS_TOTAL; ++nAxisType)
			{
				string strAxesNodeName = vsNodePrefix[nAxisType] + "Axes";
				TreeNode trAxes = trEdit.GetNode(strAxesNodeName);
				trAxes.AxisShow.nVal = vnAxes[nAxisType];
				trAxes.TickLabel.nVal = vnLabels[nAxisType];
				trAxes.Title.nVal = vnTitles[nAxisType];
				trAxes.Tick.nVal = vnMajorTicks[nAxisType];
				
				///Jasmine 08/18/09 GUI_TO_ADD_2ND_NONLINEAR_AXIS
				trAxes.Formula.strVal =	vsFormula[nAxisType];
				_check_enable_tick_label_formula(tr, 0, 0, trAxes.TickLabel);
				///End GUI_TO_ADD_2ND_NONLINEAR_AXIS
			}

			_check_enable_axes_major_tick(trEdit.BottomAxes.AxisShow);
			_check_enable_axes_major_tick(trEdit.LeftAxes.AxisShow);
			_check_enable_axes_major_tick(trEdit.TopAxes.AxisShow);
			_check_enable_axes_major_tick(trEdit.RightAxes.AxisShow);
			/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		}
		///End ADD_GET_AXIS_SHOW
		
		///Jasmine 01/04/09 v8.0993c QA80-12812 WHEN_CHANGE_SEL_LAYER_SHOW_ITS_SCALE
		///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		//if(tr.Resize)
		if(tr.GetNode(UPDATE_LAYER_SETTING_RESIZE) && ( !vsUpdate || vsUpdate.Find(UPDATE_LAYER_SETTING_RESIZE) >= 0 ))
		{
			OnShowLayerScale(gl, tr, LM_SIZE_REF_LAYER_ID);
			bUpdate = true;	///------ Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
		}
		//if(tr.Move)
		if(tr.GetNode(UPDATE_LAYER_SETTING_MOVE) && ( !vsUpdate || vsUpdate.Find(UPDATE_LAYER_SETTING_MOVE) >= 0 ))
		{
			OnShowLayerScale(gl, tr, LM_MOVE_REF_LAYER_ID);
			bUpdate = true;	///------ Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
		}
		///End WHEN_CHANGE_SEL_LAYER_SHOW_ITS_SCALE
		
		///Jasmine 06/15/07 MODIFICATION_SET_COLOR_FUNCTION
		//update color setting
		TreeNode trColor = tree_get_node_by_tagname(tr, UPDATE_LAYER_SETTING_COLOR, true);
		//if(trColor.IsValid())
		if(trColor.IsValid() && ( !vsUpdate || vsUpdate.Find(UPDATE_LAYER_SETTING_COLOR) >= 0 ))
		///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		{
			int nColor, nFillColor, nBorderColor;
			get_layer_background_color(gl, nColor, &nFillColor, &nBorderColor);
			///Jasmine 06/18/07 QA70-9929 COLOR_1_OFFSET_FROM_DYNA_CNTRL
			trColor.bgColor.nVal = okutil_ocolor_LT_color_convert(nColor, true);
			trColor.FillColor.nVal = okutil_ocolor_LT_color_convert(nFillColor, true);
			trColor.BorderColor.nVal = okutil_ocolor_LT_color_convert(nBorderColor, true);
			///End COLOR_1_OFFSET_FROM_DYNA_CNTRL
			
			///Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
			/////Kyle 01/12/2009  v8.0995c QA80-12812 ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE
			//int nBorderStyle;
			//if(gl.GetBorderStyle(nBorderStyle, 1))
				//trColor.BorderStyle.nVal = nBorderStyle;
			//else
				//trColor.BorderStyle.nVal = 0;
			/////End ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE
			///End BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE

			//_check_enable_display_border_color_width(trColor.BorderStyle);		///Kyle 01/13/2009 v8.0995d OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS

		}
		///MODIFICATION_SET_COLOR_FUNCTION
		
		///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		TreeNode trBorder = tree_get_node_by_tagname(tr, UPDATE_LAYER_SETTING_BORDERWIDTH, true);
		//if(trBorder.IsValid())
		if(trBorder.IsValid() && ( !vsUpdate || vsUpdate.Find(UPDATE_LAYER_SETTING_BORDERWIDTH) >= 0 ))
		{
			///------ Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
			TreeNode	trBGDimension = trRoot.Background.Dimension;
			trBorder.LeftBorder.dVal 	= trBGDimension.Left.dVal;
			trBorder.TopBorder.dVal 	= trBGDimension.Top.dVal;
			trBorder.RightBorder.dVal	= trBGDimension.Right.dVal;
			trBorder.BottomBorder.dVal	= trBGDimension.Bottom.dVal;
			///------ End AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE			
		}
		///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		
		///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		TreeNode trScaleFactor = tree_get_node_by_tagname(tr, UPDATE_LAYER_SETTING_SCALEFACTOR, true);
		if(trScaleFactor.IsValid() && ( !vsUpdate || vsUpdate.Find(UPDATE_LAYER_SETTING_SCALEFACTOR) >= 0 ))
		{
			trScaleFactor.scalemode.nVal = trRoot.Display.Scale? trRoot.Display.Scale.nVal : 0;
			trScaleFactor.fixfactor.dVal = trRoot.Display.FixedFactor? trRoot.Display.FixedFactor.dVal : 1.0;
			_enable_scale_factor(trScaleFactor.fixfactor, trScaleFactor.scalemode);
		}
		///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		
		//update link tab
		TreeNode trLink = tree_get_node_by_tagname(tr, UPDATE_LAYER_SETTING_LINK, true);
		//if(trLink.IsValid())
		if(trLink.IsValid() && ( !vsUpdate || vsUpdate.Find(UPDATE_LAYER_SETTING_LINK) >= 0 ))
		///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		{
			int nParentLayer, nXAxis, nYAxis, nUnit;
			string strX1, strX2, strY1, strY2;
			///------ Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
			//layer_get_link(gl, nParentLayer, &nXAxis, &nYAxis, &nUnit, &strX1, &strX2 , &strY1, &strY2);
			layer_get_link(gl, nParentLayer, &nXAxis, &nYAxis, &nUnit, &strX1, &strX2 , &strY1, &strY2, trFmt);
			///------ End AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
			trLink.Parent.nVal = nParentLayer;
			trLink.XAxes.Use = nXAxis;
			trLink.YAxes.Use = nYAxis;
			trLink.Unit.nVal = nUnit;
			trLink.XAxes.X1.strVal = strX1;
			trLink.XAxes.X2.strVal = strX2;
			trLink.YAxes.Y1.strVal = strY1;
			trLink.YAxes.Y2.strVal = strY2;
			
			_on_change_link_to(tr);
			///end CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
		}
		int nSelTab = m_tab.GetCurSel();	///Jasmine 05/25/07 REDRAW_GUI_SMOOTHER
		///------ Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
		if ( bUpdate || LAYERTOOL_LINK_TAB == nSelTab || LAYERTOOL_ADD_TAB == nSelTab || LAYERTOOL_DISPLAY_TAB == nSelTab )
			UpdateDynaControl(false, GETNEVENT_ON_INIT, false);//update color control
		///------ End AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE
	}
	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{	
		if(nCol == LAYER_LIST_NAME_COL)
		{
			m_strOldValue = m_Layerlist.GetCell(nRow, nCol);
		}
		else
		{
			*pCancel = true;
		}
	}
	void OnAfterEdit(Control flxControl, int nRow, int nCol)
	{
		if(nCol != LAYER_LIST_NAME_COL)
			return;
		string strNewValue = m_Layerlist.GetCell(nRow, nCol);
		///Jasmine 11/09/07 QA70-10621 USE_REAL_LAYER_NAME_NOT_INDEX
		string strRealName;
		strNewValue.TrimLeft();
		strNewValue.TrimRight();
		if(strNewValue.IsEmpty())
		{
			///Jasmine 01/13/09 v8.0995d IF_NEW_NAME_EMPTY_THEN_SET_OLD_NAME_BACK
			///Jasmine 12/31/08 v8.0992c QA80-12812 REMOVE_NO_NAME_TO_KEEP_LAYER_DISPLAY_NAME_CONSISTENT_WITH_PLOT_DETAIL
			//strNewValue = STR_NO_NAME;
			strNewValue = m_strOldValue;
			///End REMOVE_NO_NAME_TO_KEEP_LAYER_DISPLAY_NAME_CONSISTENT_WITH_PLOT_DETAIL
			m_Layerlist.SetCell(nRow, nCol, m_strOldValue);	
			return;
			///End IF_NEW_NAME_EMPTY_THEN_SET_OLD_NAME_BACK
		}
			
		///Jasmine 12/31/08 v8.0992c QA80-12812 REMOVE_NO_NAME_TO_KEEP_LAYER_DISPLAY_NAME_CONSISTENT_WITH_PLOT_DETAIL
		//if(compare_string_localization(strNewValue, STR_NO_NAME_E))
		//{
			//strRealName = "";
		//}
		//else
		///End REMOVE_NO_NAME_TO_KEEP_LAYER_DISPLAY_NAME_CONSISTENT_WITH_PLOT_DETAIL
		{
			if(!strNewValue.CompareNoCase(m_strOldValue))
				return;
			if(-1 < m_vsLayerNames.Find(strNewValue))
			{
				MessageBox(GetSafeHwnd(), _L("The name you specified already exists. Please specify a different layer name."), NULL, MB_OK);
				m_Layerlist.SetCell(nRow, nCol, m_strOldValue);	
				return;
			}
			strRealName = strNewValue;
		}
		//int nIndex = m_vsLayerNames.Find(m_strOldValue);
		int nIndex = get_layer_index( nRow );
		///End USE_REAL_LAYER_NAME_NOT_INDEX
		//---
		//if(m_gpTemp.Layers(nIndex).SetName(strRealName))
		
		///Jasmine 01/13/09 v8.0995d UNDO_SET_LAYER_NAME
		BEFORE_UNDO_BLOCK
		
		//if( m_gpTemp.Layers(nIndex).SetName(strRealName, OCD_UNDO) )
		//{		
		m_gpTemp.Layers(nIndex).SetName(strRealName, OCD_UNDO);
		strNewValue = m_gpTemp.Layers(nIndex).GetName();
			m_Layerlist.SetCell(nRow, nCol, strNewValue);	
			m_vsLayerNames[nIndex] = strNewValue;
		//}
		//else
			//m_Layerlist.SetCell(nRow, nCol, m_strOldValue);	
		
		AFTER_UNDO_BLOCK
		///End UNDO_SET_LAYER_NAME
		///---
	}
	
	///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
	void OnAfterMoveRows(Control ctrl, long nRow, long *pnPosition) 
	{
		if( reorderLayers() )
			UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
	}
	///End REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
	
	///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	BOOL OnGridClicked(Control cntrl)
	{
		ShowInfoMsg(LAYER_MANAGE_LAYERLIST_INFO);		
		return TRUE;
	}
	
	/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	void showInfoMsg()
	{
		int 	nInfo;
		int 	nSel = m_tab.GetCurSel();
		
		if( CER_NO_ERROR != ( nInfo = checkShowErrMsg(nSel)) )
		{
			ShowInfoMsg(nInfo, true);
			return;
		}
		
		switch(nSel)
		{
		case LAYERTOOL_EDIT_TAB:
			nInfo = LAYER_MANAGE_LINK_INFO;
			break;
			
		case LAYERTOOL_SIZE_TAB:
			nInfo = LAYER_MANAGE_SIZE_INFO;
			break;
			
		default:
			nInfo = LAYER_MANAGE_INFO;
			break;
		}
		
		ShowInfoMsg(nInfo);		
	}
	///end LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	
	void OnRowColChange(Control cntrl)
	{		
		int 	nInfo;
		int 	nSel = m_tab.GetCurSel();
		
		/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
		/*
		switch(nSel)
		{
		case LAYERTOOL_EDIT_TAB:
			nInfo = LAYER_MANAGE_LINK_INFO;
			break;
			
		case LAYERTOOL_SIZE_TAB:
			nInfo = LAYER_MANAGE_SIZE_INFO;
			break;
			
		default:
			nInfo = LAYER_MANAGE_INFO;
			break;
		}
		
		ShowInfoMsg(nInfo);
		*/
		showInfoMsg();
		///end LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED		
		
	}
	///End SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	
	///Jasmine 03/15/07 ADD_UNDO_BUTTON
	BOOL OnUndo(Control cntrl)
	{
		///Jasmine 03/31/07 SUPPORT_MULTI_STEP_UNDO
		if(!undo_enabled())
			return FALSE;
		//Project.Undo();
		m_gpTemp.LT_execute("undo");
		m_gpTemp.Refresh();
		OnLayersNumberChange(true, SEL_ROW_UNASSIGNED);
		
		//---selected layer may change
		vector<uint> vnRows;
		m_Layerlist.GetSelRows(vnRows);
		if(vnRows.GetSize() > 0)
		{
			constructLinkToList();
			highlightSelectLayerIcon(); 	 /// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS	
			
			int nIndex = get_layer_index( vnRows[0] );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			TreeNode trGUI = GetTree();
			UpdateLayerSetting(gl, trGUI, false);
		}
		//---
		
		//GetItem(IDC_LAYERTOOL_UNDO).Enable = false;
		undo_enabled(true, -1);
		///End SUPPORT_MULTI_STEP_UNDO
		return TRUE;
	}
	///End ADD_UNDO_BUTTON
	BOOL OnApply(Control cntrl)
	{
		GraphPage gp(m_strGraph);
		if(gp)
		{
			///Jasmine 12/03/08 v8.0982 PAGE_CLONE_CAN_APPLY_TO_EXISTING_PAGE
			/*vector<string> vs;
			vs.Add(m_gpTemp.GetName());
			page_add_to_one_graph(gp, vs); 
			int ii = 0;
			foreach(GraphLayer gl in m_gpTemp.Layers)
			{
				//gp.Layers(ii++).SetName(gl.GetName());
				copyLayerName(gl, gp.Layers(ii++));
			}
				
			int nOrder = graph_get_draw_order(m_gpTemp);
			graph_set_draw_order(gp, nOrder);*/
			
			///Jasmine 12/08/08 v8.0983 QA80-12464 KEEP_PREVIEW_RESULT_SOURCE_GRAPHS_CONSISTENT
			page_clone(m_gpTemp, gp);
			
			set_gp_noclick(gp, m_stPageSetting.dwNoClick);			
			gp.AxisLayerIcons = m_stPageSetting.bAxisIcon;
			string strLT;
			strLT.Format("page.icons=%d", m_stPageSetting.bPageIcon);
			gp.LT_execute(strLT);
			///End KEEP_PREVIEW_RESULT_SOURCE_GRAPHS_CONSISTENT
			///End PAGE_CLONE_CAN_APPLY_TO_EXISTING_PAGE
			gp.Refresh();
			GetItem(IDC_LAYERTOOL_APPLY).Enable = false;
		}
		return TRUE;
	}
	///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
	/*BOOL OnReorder(Control cntrl)
	{
		return reorderLayers();
	}*/
	///End REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
	BOOL OnOK(Control cntrl)
	{
		Button btnApply = GetItem(IDC_LAYERTOOL_APPLY);
		if(btnApply.Enable)
			OnApply(btnApply);
		return TRUE;	
	}
	//----COMBINE_LAYER_LIST_AND_SEL_LIST
	/*BOOL OnAdd(Control cntrl)
	{
		vector<uint> vnRows;
		if(!m_Layerlist.GetSelRows(vnRows))
			return FALSE;	
		m_Selectlist.SetReady(false);
		vector<string> vsSel;
		m_Selectlist.GetColValues(LAYER_LIST_NAME_COL, vsSel, m_Selectlist.GetRowOffset());
		for(int index = 0; index < vnRows.GetSize(); index++) 
		{
			vector<string> vs;
			//vs.Add(m_Layerlist.GetCell(vnRows[index], 1));
			m_Layerlist.GetRowValues(vnRows[index], vs);
			if(vsSel.Find(vs[LAYER_LIST_NAME_COL]) > -1)
				continue;
			m_Selectlist.SetRowValues(m_Selectlist.GetRows() - m_Selectlist.GetRowOffset(), vs, 0, true);
		}
		m_Selectlist.ResizeCols();
		m_Selectlist.SelRow(m_Selectlist.GetRows(), true);
		m_Selectlist.SetReady(true);
		Control ctrl;
		OnSelectListCellChange(ctrl, -1, -1);
		return TRUE;
	}
	BOOL OnRemove(Control cntrl)
	{
		vector<uint> vnRows;
		if(!m_Selectlist.GetSelRows(vnRows))
			return FALSE;	
		m_Selectlist.SetReady(false);	
		for(int index = vnRows.GetSize() - 1; index >= 0; index--) 
			m_Selectlist.DeleteRow(vnRows[index]);
		m_Selectlist.SelRow(vnRows[0], true);
		m_Selectlist.SetReady(true);
		Control ctrl;
		OnSelectListCellChange(ctrl, -1, -1);
		return TRUE;
	}*/
	//----end
	BOOL OnTabChange(Control ctrl)
	{
		SHOW_TIME("OnTabChange")
		SetFocus(GetItem(IDOK).GetSafeHwnd());//FORCE_TO_UPDATE_CHANGE
		onTabChange();
		
		highlightSelectLayerIcon(); /// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS
		
		OnRowColChange(ctrl);		///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		
		return true;
	}
	void OnAfterValueChange(int nRow, DWORD lParam)
	{
		SHOW_TIME("OnAfterValueChange")
		
		bool bNeedUpdate = false;
		bool bResize 	= true;
		DWORD dwEventType 	= 0;
		DWORD dwUpdateBits 	= 0;
		
		TreeNode tr = GetTree();
		TreeNode trNode = m_DynaCntrl.GetTreeNode(nRow);
		///Jasmine 09/04/09 SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME 
		if(lParam == FORCE_GUI_UPDATE_BIT)
		{	
			bNeedUpdate 	= true;
			dwUpdateBits	= DYNACONTROL_UPDATE_SHOWHIDE;
			TreeNode trJunk;
			trNode = trJunk;
		}
		///End SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME
		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		string strButton = GetGroupButton(trNode);
		if( EnableButtonOnChange(tr, true, strButton) )
		{
			bNeedUpdate = true;
			dwUpdateBits = DYNACONTROL_UPDATE_RECONSTRUCT;
		}
		///End INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		
		int nID = -1;
		if(trNode.IsValid())
			trNode.GetAttribute(STR_DATAID_ATTRIB, nID);
		
		switch(nID)
		{
		case LM_MODIFY_BTN_ID:
		//----COMBINE_LAYER_LIST_AND_SEL_LIST, on click button
			_modify_button_event(tr);
			break;
		///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		case LM_DISPLAY_TAB_RADIO_ID:			
			if( OnDisplayTabRadioChange(tr, m_tab.GetCurSel() == LAYERTOOL_DISPLAY_TAB) )
			{
				bNeedUpdate = true;
				dwEventType |= GETNEVENT_ON_CHANGE_UPDATE_GUI;
				dwUpdateBits |= DYNACONTROL_UPDATE_SHOWHIDE;
			}
			break;
		case LM_SET_BORDER_BTN_ID:
			_set_layer_border_width(tr);			
			break;
		///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		case LM_FILL_BG_COLOR_BTN_ID:
			_fill_layer_background_color(tr);
			break;
		case LM_ADD_BTN_ID:
			if( _add_button_event(tr) )
			{
				bNeedUpdate = true;
				dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;
			}
			break;
		case LM_SCALE_ELEMENT_ID:
			TreeNode trFactor = tree_get_node_by_tagname(m_paramTree, "fixfactor", true);
			_enable_scale_factor(trFactor, trNode);
			//UpdateDynaControl(true, GETNEVENT_ON_INIT);	///Jasmine 05/25/07 REDRAW_GUI_SMOOTHER
			//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
			bNeedUpdate = true;
			dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;
			break;
		///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		case LM_SET_SCALE_FACTOR_BTN_ID:
			_set_layer_scale_factor(tr);
			break;
		///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		case LM_ARRANGE_BTN_ID:
			if( 0 < _arrange_button_event(tr) )
			{
				bNeedUpdate = true;
				dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;			
			}
			break;
		case LM_DRAW_ORDER_ID:
			graph_set_draw_order(m_gpTemp, trNode.nVal);
			enable_apply();
			break;
		///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
		case LM_SIZR_TAB_RADIO_ID:
			if( OnSizeTabRadioChange(tr, m_tab.GetCurSel() == LAYERTOOL_SIZE_TAB) )
			{
				//UpdateDynaControl(false, GETNEVENT_ON_CHANGE_UPDATE_GUI, false, DYNACONTROL_UPDATE_SHOWHIDE);
				bNeedUpdate = true;
				dwEventType |= GETNEVENT_ON_CHANGE_UPDATE_GUI;
				dwUpdateBits |= DYNACONTROL_UPDATE_SHOWHIDE;
			}
			break;
		///End USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
		case LM_RESIZE_BTN_ID:
			_resize_button_event(tr);
			break;
		case LM_MOVE_BTN_ID:
			_move_button_event(tr);
			break;
		case LM_SWAP_BTN_ID:
			_swap_button_event(tr);
			break;
		case LM_ALIGN_BTN_ID:
			_align_button_event(tr);
			break;
		/// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
		case LM_LINK_PARENT_ID:
			///Jasmine 01/16/09 CHANGE_UNIT_ONLY_ON_LINKTO_NODE_CHANGE
			//_on_change_link_to(tr);
			_on_change_link_to(tr, LM_LINK_PARENT_ID);
			///End CHANGE_UNIT_ONLY_ON_LINKTO_NODE_CHANGE
			//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
			bNeedUpdate = true;
			dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;
			break;
		///end CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
		case LM_X_AXIS_ID:
		case LM_Y_AXIS_ID:
			bool bEnable = trNode.Use == 2;
			foreach(TreeNode cNode in trNode.Children)
				cNode.Enable = bEnable;
			//UpdateDynaControl(0, GETNEVENT_ON_INIT);	///Jasmine 05/25/07 REDRAW_GUI_SMOOTHER
			//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
			bNeedUpdate = true;
			dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;
			break;
		case LM_LINK_BTN_ID:
			if( _link_button_event(tr) )
			{
				bNeedUpdate = true;
				dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;	
			}
			break;
		/// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
		/*	
		case LM_DISLINK_BTN_ID:
			_dislink_button_event(tr);
			break;
		*/
		///end CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
		//----end
		
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH			
		//case LM_REF_LAYER_ID:
		case LM_SIZE_REF_LAYER_ID:
		case LM_MOVE_REF_LAYER_ID:
			//OnRefLayerChange(tr, nID);
			if( OnShowRefLayerScale(tr, nID) )
			{
				bNeedUpdate = true;
				dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;	
			}
			break;
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
			
		///Jasmine 12/29/08 v8.0991b QA80-12812  SET_SCALE_TYPE_IN_ADDING_NEW_LAYER	
		case LM_LAYER_TYPE_ID:
			if( OnScaleTypeChange(tr) )
			{
				bNeedUpdate = true;
				dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;	
			}
			break;
			
		case LM_LINK_TO_ID:
			if( OnShowLinkLayerScale(tr) )
			{
				bNeedUpdate = true;
				dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;	
			}
			break;
		///End SET_SCALE_TYPE_IN_ADDING_NEW_LAYER
		
		/*
		case LM_CUSTOM_ID:
			bool bCustom = trNode.nVal;
			trWidth.Enable = trHeight.Enable = trLeft.Enable = trTop.Enable = trUnits.Enable = !bCustom? 2 : 1;
			//UpdateDynaControl(true, GETNEVENT_ON_INIT);	///Jasmine 05/25/07 REDRAW_GUI_SMOOTHER
			UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
			break;
		*/
		
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH	
		//case LM_UNITS_BTN_ID:		
		case LM_SIZE_UNITS_BTN_ID:
		case LM_MOVE_UNITS_BTN_ID:
			if( OnUnitChange(tr, nID) )
			{
				bNeedUpdate = true;
				dwUpdateBits |= DYNACONTROL_UPDATE_RECONSTRUCT;	
			}
			break;
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		
		/// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS
		case LM_ARRANGE_SELECTION_ID:
		case LM_SWAP_LAYERA_ID:
		case LM_SWAP_LAYERB_ID:
			highlightSelectLayerIcon();
			break;		
		///end SET_ICON_COLOR_FOR_SELECTED_LAYERS
		
		default:
			break;//return	///Jasmine 01/14/09 NEED_CHECK_IF_REQUIRE_UPDATE
		}
		
		if(bNeedUpdate)
			UpdateDynaControl(bResize, dwEventType, false, dwUpdateBits);
		
		return;
	}
	///Jasmine 12/29/08 v8.0991b QA80-12812  SET_SCALE_TYPE_IN_ADDING_NEW_LAYER	
	bool OnScaleTypeChange(TreeNode& trGUI)
	{
		if(!trGUI || !trGUI.Add) 
			return false;
		
		TreeNode trAdd = trGUI.Add;
		if(!trAdd.LayerType || !trAdd.LinkTo || !trAdd.XScale || !trAdd.YScale)
			return false;
		
		int nType = trAdd.LayerType.nVal;
		///Jasmine 03/20/09 CENTRAILIZE_ADD_LAYER_CODE_IN_LAYADD_XF_AND_LAYERMANAGEMENT
		/*trAdd.LinkTo.Enable = type_Normal < nType;
		trAdd.XScale.Enable = type_RightY == nType? ENABLE_READ_ONLY : ENABLE;
		trAdd.YScale.Enable = type_TopX == nType? ENABLE_READ_ONLY : ENABLE;*/
		AddingLayerType _typeObj;
		
		trAdd.LinkTo.Enable = _typeObj.IsLink(nType);
		///Jasmine 03/24/09 SWITCH_LINKTO_NVAL_ON_LEFT_LAYER_SELECT_CHANGE
		if( !_typeObj.IsLink(nType) )
			trAdd.LinkTo.nVal = -1;
		else if(trAdd.LinkTo.nVal == -1)	///Jasmine 04/03/09 AUTO_FIND_PARENT_LAYER_FROM_SELECTED_LAYER ///Jasmine 04/08/09 AUTO_FIND_IS_REJECTED_BY_USER_SINCE_IT_CHANGE_USER_SETTING, uncomment
		{
			vector<uint> vnRows;
			m_Layerlist.GetSelRows(vnRows);
			if(vnRows.GetSize() > 0)
			{
				int nIndex = get_layer_index( vnRows[0] );
				///Jasmine 04/08/09 AUTO_FIND_IS_REJECTED_BY_USER_SINCE_IT_CHANGE_USER_SETTING
				/*
				///Jasmine 04/03/09 AUTO_FIND_PARENT_LAYER_FROM_SELECTED_LAYER
				int nParent = get_linked_layer_ancestor(m_gpTemp, nIndex, true);
				if( is_valid_layer_index(m_gpTemp, nParent) )
					nIndex = nParent;					
				///End AUTO_FIND_PARENT_LAYER_FROM_SELECTED_LAYER
				*/
				///End AUTO_FIND_IS_REJECTED_BY_USER_SINCE_IT_CHANGE_USER_SETTING
				trAdd.LinkTo.nVal = nIndex;
				bool bRet = OnShowLinkLayerScale(trGUI);
				ASSERT(bRet);
			}
		}
		///End SWITCH_LINKTO_NVAL_ON_LEFT_LAYER_SELECT_CHANGE
		trAdd.XScale.Enable = ENABLE;
		if( _typeObj.HasNoXAxis(nType) )
			trAdd.XScale.Enable = ENABLE_READ_ONLY;
		
		trAdd.YScale.Enable = ENABLE;
		if( _typeObj.HasNoYAxis(nType) )
			trAdd.YScale.Enable = ENABLE_READ_ONLY;
		///End CENTRAILIZE_ADD_LAYER_CODE_IN_LAYADD_XF_AND_LAYERMANAGEMENT
		
		//UpdateDynaControl(true, GETNEVENT_ON_INIT);	///Jasmine 05/25/07 REDRAW_GUI_SMOOTHER
		//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
		return true;
	}
	bool OnShowLinkLayerScale(TreeNode& trGUI)
	{			
		if(!trGUI || !trGUI.Add) 
			return false;
		
		TreeNode trAdd = trGUI.Add;
		if(!trAdd.LinkTo || !trAdd.XScale || !trAdd.YScale)
			return false;
		
		int 		nLinkTo = trAdd.LinkTo.nVal;
		GraphLayer 	gl 		= m_gpTemp.Layers(nLinkTo);
		//---Jasmine 03/24/09 nLinkTo=-1 is NONE due to Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
		//if(!gl)
		if(nLinkTo < 0 || !gl)
			return false;
		//---End
		
		int xscale, yscale;
		axis_get_scale_type(gl, &xscale, &yscale);
		
		trGUI.Add.XScale.nVal = xscale;
		trGUI.Add.YScale.nVal = yscale;
		
		//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
		return true;
	}
	///End SET_SCALE_TYPE_IN_ADDING_NEW_LAYER
	///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
	bool OnUnitChange(TreeNode& trGUI, int nID)
	{
		TreeNode trRefLayer, trUnits;
		if(LM_SIZE_UNITS_BTN_ID == nID)
		{
			trRefLayer	= trGUI.Resize.RefLayer;
			trUnits 	= trGUI.Resize.Units;
		}
		if(LM_MOVE_UNITS_BTN_ID == nID)
		{
			trRefLayer	= trGUI.Move.RefLayer;
			trUnits 	= trGUI.Move.Units;
		}
		
		TreeNode trWidth = tree_get_node_by_tagname(m_paramTree, "Width", true);
		TreeNode trHeight = tree_get_node_by_tagname(m_paramTree, "Height", true);
		TreeNode trLeft = tree_get_node_by_tagname(m_paramTree, "Left", true);
		TreeNode trTop = tree_get_node_by_tagname(m_paramTree, "Top", true);
		
		if(!trRefLayer.IsValid() || !trUnits.IsValid() || !trWidth.IsValid() || !trHeight.IsValid() || !trTop.IsValid() || !trLeft.IsValid())
			return false;		
		
		int oldunit, newunit = trUnits.nVal;
		trUnits.GetAttribute(STR_CHANGED_ATTRIB, oldunit);
		
		trRefLayer.Show = M_LINK == newunit;		///Kyle 01/22/2009 SHOW_LAYER_LIST_ON_M_LINK_SELECTED
		
		///Jasmine 03/06/07 QA70-9433 CONVERT_LAYER_UNITS
		/*double width = trWidth.dVal, height = trHeight.dVal, left = trLeft.dVal, top = trTop.dVal;
		convertDimensions(oldunit, newunit, width, height, left, top);*/
		double dPos[TOTAL_POS], dRefPos[TOTAL_POS];
		dPos[WIDTH_POS] = trWidth.dVal;
		dPos[HEIGHT_POS] = trHeight.dVal;
		dPos[LEFT_POS] = trLeft.dVal;
		dPos[TOP_POS] = trTop.dVal;
		
		///Jasmine 03/23/07 ADD_UNIT_PERCENT_OF_REF_LAYER
		int nTempUnit = newunit;
		
		//int nRef = tree_get_node_by_tagname(m_paramTree, "RefLayer", true).nVal;
		int nRef = trRefLayer.nVal;		
		GraphLayer layer = m_gpTemp.Layers(0);
		GraphLayer glRef = m_gpTemp.Layers(nRef);
		if(glRef && M_INCH != glRef.GetPosition(dRefPos)) 
			glRef.UnitsConvert(M_INCH, dRefPos);
		if(M_LINK == newunit)
			nTempUnit = M_INCH;
		if(M_LINK == oldunit)
		{	
			dPos[WIDTH_POS] 	= dPos[WIDTH_POS]*dRefPos[WIDTH_POS]/100;
			dPos[HEIGHT_POS] 	= dPos[HEIGHT_POS]*dRefPos[HEIGHT_POS]/100;
			dPos[LEFT_POS] 		= dPos[LEFT_POS]*dRefPos[WIDTH_POS]/100 + dRefPos[LEFT_POS];
			dPos[TOP_POS] 		= dPos[TOP_POS]*dRefPos[HEIGHT_POS]/100 + dRefPos[TOP_POS];					
			oldunit = M_INCH;
		}
		if(layer.IsValid() && layer.UnitsConvert(nTempUnit, dPos, oldunit))
		{
			if(M_LINK == newunit)
			{
				dPos[WIDTH_POS] 	= dRefPos[WIDTH_POS]? dPos[WIDTH_POS]*100/dRefPos[WIDTH_POS] : 100;
				dPos[HEIGHT_POS] 	= dRefPos[WIDTH_POS]? dPos[HEIGHT_POS]*100/dRefPos[HEIGHT_POS] : 100;
				dPos[LEFT_POS] 		= dRefPos[WIDTH_POS]? (dPos[LEFT_POS] - dRefPos[LEFT_POS])*100/dRefPos[WIDTH_POS]: 0;
				dPos[TOP_POS] 		= dRefPos[HEIGHT_POS]? (dPos[TOP_POS] - dRefPos[TOP_POS])*100/dRefPos[HEIGHT_POS]: 0;					
			}
		///End ADD_UNIT_PERCENT_OF_REF_LAYER
		
			if(LM_SIZE_UNITS_BTN_ID == nID)
			{
				trWidth.dVal = dPos[WIDTH_POS];
				trHeight.dVal = dPos[HEIGHT_POS];
			}
			
			if(LM_MOVE_UNITS_BTN_ID == nID)
			{
				trLeft.dVal = dPos[LEFT_POS];
				trTop.dVal = dPos[TOP_POS];
			}
			
			//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
			return true;
		}
		//End CONVERT_LAYER_UNITS
		return false;
	}
	///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
	void OnLayersNumberChange(bool bRestructure = false, int nSelRow = SEL_ROW_UNASSIGNED, bool bRecalculate = true)	///Jasmine 01/22/09 REARRANGE_OUTER_CHILD_LAYER	
	{
		m_strLayerList.Empty();
		m_vsLayerNames.RemoveAll();
		Tree trLayers;
		foreach(GraphLayer gl in m_gpTemp.Layers)
		{//get layer names
			int nIndex = gl.GetIndex() + 1;
			m_strLayerList += (string)nIndex + "|";
			TreeNode cNode = trLayers.AddNode("Layer"+(string)nIndex);
			///Jasmine 11/09/07 QA70-10621 USE_REAL_LAYER_NAME_NOT_INDEX 
			string strName;// = gl.GetName();
			///Jasmine 12/31/08 v8.0992c QA80-12812 REMOVE_NO_NAME_TO_KEEP_LAYER_DISPLAY_NAME_CONSISTENT_WITH_PLOT_DETAIL
			//if(!gl.GetName(strName))
				//strName = STR_NO_NAME;
			gl.GetName(strName);
			///End REMOVE_NO_NAME_TO_KEEP_LAYER_DISPLAY_NAME_CONSISTENT_WITH_PLOT_DETAIL
			///End USE_REAL_LAYER_NAME_NOT_INDEX
			cNode.Name.strVal = strName;
			m_vsLayerNames.Add(strName);
			cNode.Name.SetAttribute(STR_LABEL_ATTRIB, _L("Name"));
			///Jasmine 05/28/07 ADD_LINK_COL
			int nParentLayer;
			layer_get_link(gl, nParentLayer);
			if(-1 < nParentLayer)
				cNode.Link.nVal = ++nParentLayer;
			if(cNode.Link.IsValid())
				cNode.Link.SetAttribute(STR_LABEL_ATTRIB, _L("Link to"));
			///End ADD_LINK_COL
		}
		m_strLayerList.Delete(lstrlen(m_strLayerList) - 1);		
		
		
		//reset Layer List
		m_Layerlist.SetReady(false);		
		///Jasmine 12/16/08 v8.0987b MINUS_1_CANNOT_SEL_LAST_ROW
		bool bSelLastRow = false;
		if(SEL_ROW_UNASSIGNED == nSelRow) 
			nSelRow = m_Layerlist.GetSelectedRow();
		else if(SEL_LAST_ROW == nSelRow)
			bSelLastRow = true;
		///End MINUS_1_CANNOT_SEL_LAST_ROW
		m_Layerlist.UpdateGrid(trLayers);
		for(int nRow = m_Layerlist.GetRowOffset(); nRow < m_Layerlist.GetRows(); nRow++)
			m_Layerlist.SetCell(nRow, LAYER_LIST_INDEX_COL, nRow);
		///Jasmine 05/28/07 ADD_LINK_COL
		//m_Layerlist.ResizeCols();
		///Jasmine 02/13/09 AUTO_SIZE_BY_COLUMN_CONTENT
		//vector	vColWidthPercent = {0.10, 0.65, 0.22};//Sum a little less then 1, so the rollbar don't appear at first
		//m_Layerlist.ResizeCols(vColWidthPercent);
		m_Layerlist.ResizeCols(0.1, 1.0, 0);
		///End AUTO_SIZE_BY_COLUMN_CONTENT
		///End ADD_LINK_COL
		/// Hong 11/10/10 ORG-1467 FIX_DEFAULT_COLOR_IS_WRONG_IN_NEW_GRID
		// For details reason, see Hong 10/29/10 ORG-974 FIX_PLOTSETUP_OPEN_WITH_COLLST_EMPTY_WITH_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		m_Layerlist.SetReady(true);
		m_Layerlist.SelRow(nSelRow, bSelLastRow);
#else		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		/// end FIX_DEFAULT_COLOR_IS_WRONG_IN_NEW_GRID
		m_Layerlist.SelRow(nSelRow, bSelLastRow);	///Jasmine 12/16/08 v8.0987b MINUS_1_CANNOT_SEL_LAST_ROW
		m_Layerlist.SetReady(true);
#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__ /// Hong 11/10/10 ORG-1467 FIX_DEFAULT_COLOR_IS_WRONG_IN_NEW_GRID
		//check Selected Layer List
		//if(bRestructure)
			//m_Selectlist.ClearAll();
			
			
		//update TreeNode that has m_strLayerList
		TreeNode tr = GetTree();
		
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		//TreeNode trRef = tree_get_node_by_tagname(tr, "RefLayer", true);
		//if(trRef.IsValid())
		//{
			//trRef.SetAttribute(STR_COMBO_ATTRIB, m_strLayerList);
			//if(bRestructure)
				//OnRefLayerChange();
		//}
		vector<string> vsNodes = {"Resize", "Move", "Align"};
		for(int ii = 0; ii < vsNodes.GetSize(); ii++)
		{
			TreeNode trParent = tree_get_node_by_tagname(tr, vsNodes[ii], true);
			if(trParent && trParent.RefLayer)
				trParent.RefLayer.SetAttribute(STR_COMBO_ATTRIB, m_strLayerList);
		}
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		vector<string> vsNodes2 = {"LinkTo", "LayerA", "LayerB"};
		for(ii = 0; ii < vsNodes2.GetSize(); ii++)
		{
			TreeNode trNode = tree_get_node_by_tagname(tr, vsNodes2[ii], true);
			if(trNode)
			{
				/// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
				//trNode.SetAttribute(STR_COMBO_ATTRIB, m_strLayerList);
				/// Kenny 08/11/2009 QA81-14122 LINK_TO_SHOW_WRONG_ITEM_WHEN_LAYER_IS_NOT_LINKED
// 				string strCombo = _L("None") + "|" + m_strLayerList;
// 				trNode.SetAttribute(STR_COMBO_ATTRIB, strCombo);				
// 				string strIndexMap = _layer_index_str_to_index_map(strCombo);
				string strCombo;
				string strIndexMap = _layer_index_str_to_index_map(m_strLayerList, strCombo);
				trNode.SetAttribute(STR_COMBO_ATTRIB, strCombo);
				/// End QA81-14122 LINK_TO_SHOW_WRONG_ITEM_WHEN_LAYER_IS_NOT_LINKED
				trNode.SetAttribute(STR_INTMAP_ATTRIB, strIndexMap);
				///end SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
			}
		}
		
		if(bRecalculate)	///Jasmine 01/22/09 REARRANGE_OUTER_CHILD_LAYER	
		{
			int nRowNum, nColNum;
			///Jasmine 02/12/11 ORG-695 ARRANGE_OUTSIDE_CHILD_LAYER
			//_get_default_row_col_number(page_get_layer_count(m_gpTemp), nRowNum, nColNum);
			_get_default_row_col_number(_get_layer_count(m_gpTemp, NULL, /*bArrangeChild=*/true), nRowNum, nColNum);
			///End ARRANGE_OUTSIDE_CHILD_LAYER
			TreeNode trArrange = tree_get_node_by_tagname(tr, "Arrange", true);
			trArrange.Col.nVal = nColNum;
			trArrange.Row.nVal = nRowNum;
		}
		//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
	}
	///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
	//void OnRefLayerChange(int nID = -1, DWORD lParam = 0)
	//{
		//TreeNode tr = GetTree();
		//TreeNode trRef = tree_get_node_by_tagname(tr, "RefLayer", true);
		//int nRef = trRef.nVal;
		//GraphLayer glRef = m_gpTemp.Layers(nRef);
		//if(glRef.IsValid())
		//{//set reference layer size&position to treenode
			/////Jasmine 03/06/07 QA70-9433 CONVERT_LAYER_UNITS
			///*int nUnit = layer_get_unit(glRef);
			//if(nUnit > UNIT_POINT)
				//layer_set_unit(glRef, UNIT_PAGE);
			//double width, height, left, top;
			//layer_get_size(glRef, width, height, &nUnit);
			//layer_get_position(glRef, &left, &top);
			//if(nUnit > UNIT_POINT)
				//layer_set_unit(glRef, nUnit);
			//nUnit = UNIT_PAGE;*/
			//double dPos[TOTAL_POS];
			//int nUnit = glRef.GetPosition(dPos);
			//if(M_LINK == nUnit && glRef.UnitsConvert(M_PERCENT, dPos, nUnit))
				//nUnit = M_PERCENT;
			////End CONVERT_LAYER_UNITS
			//TreeNode trUnits = tree_get_node_by_tagname(tr, "Units", true);
			//TreeNode trWidth = tree_get_node_by_tagname(tr, "Width", true);
			//TreeNode trHeight = tree_get_node_by_tagname(tr, "Height", true);
			//TreeNode trLeft = tree_get_node_by_tagname(tr, "Left", true);
			//TreeNode trTop = tree_get_node_by_tagname(tr, "Top", true);
			//if(!trUnits.IsValid() || !trWidth.IsValid() || !trHeight.IsValid() || !trLeft.IsValid() || !trTop.IsValid())
				//return;
			//trUnits.nVal = nUnit;			
			//trWidth.dVal = dPos[WIDTH_POS];
			//trHeight.dVal = dPos[HEIGHT_POS];
			//trLeft.dVal = dPos[LEFT_POS];
			//trTop.dVal = dPos[TOP_POS];
			//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
		//}
	//}
	
	///Jasmine 01/04/09 v8.0993c QA80-12812 WHEN_CHANGE_SEL_LAYER_SHOW_ITS_SCALE
	bool OnShowRefLayerScale(TreeNode& trGUI, int nID)
	{
		TreeNode trRefLayer;
		
		if(LM_SIZE_REF_LAYER_ID == nID)
		{
			trRefLayer 	= trGUI.Resize.RefLayer;
		}
		if(LM_MOVE_REF_LAYER_ID == nID)
		{
			trRefLayer 	= trGUI.Move.RefLayer;
		}
		if( !trRefLayer.IsValid() )
			return false;
		
		int nRef = trRefLayer.nVal;
		GraphLayer glRef = m_gpTemp.Layers(nRef);
		if(!glRef.IsValid())
			return false;
		
		OnShowLayerScale(glRef, trGUI, nID);
		return true;
	}
	
	void OnShowLayerScale(GraphLayer& glRef, TreeNode& trGUI, int nID)
	{		
		TreeNode trUnits;
		
		if(LM_SIZE_REF_LAYER_ID == nID)
		{
			trUnits 	= trGUI.Resize.Units;
		}
		if(LM_MOVE_REF_LAYER_ID == nID)
		{
			trUnits 	= trGUI.Move.Units;
		}
		
		TreeNode trWidth 	= tree_get_node_by_tagname(trGUI, "Width", true);
		TreeNode trHeight 	= tree_get_node_by_tagname(trGUI, "Height", true);
		TreeNode trLeft 	= tree_get_node_by_tagname(trGUI, "Left", true);
		TreeNode trTop 		= tree_get_node_by_tagname(trGUI, "Top", true);
		
		if( !trUnits.IsValid() || !trWidth.IsValid() || !trHeight.IsValid() || !trLeft.IsValid() || !trTop.IsValid())
			return;
	///End WHEN_CHANGE_SEL_LAYER_SHOW_ITS_SCALE
		double dPos[TOTAL_POS];
		int nUnit = glRef.GetPosition(dPos);
		
		///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH	
		//if(M_LINK == nUnit && glRef.UnitsConvert(M_PERCENT, dPos, nUnit))
			//nUnit = M_PERCENT;
		///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		
		trUnits.nVal = nUnit;
		
		if(LM_SIZE_REF_LAYER_ID == nID)
		{
			trWidth.dVal = dPos[WIDTH_POS];
			trHeight.dVal = dPos[HEIGHT_POS];
		}
		if(LM_MOVE_REF_LAYER_ID == nID)
		{
			trLeft.dVal = dPos[LEFT_POS];
			trTop.dVal = dPos[TOP_POS];
		}
		///Kyle 01/22/2009 SHOW_LAYER_LIST_ON_M_LINK_SELECTED
		TreeNode trRefLayer;
		if(LM_SIZE_REF_LAYER_ID == nID)
			trRefLayer 	= trGUI.Resize.RefLayer;
		else if(LM_MOVE_REF_LAYER_ID == nID)
			trRefLayer 	= trGUI.Move.RefLayer;
		if(trRefLayer)
			trRefLayer.Show = M_LINK == trUnits.nVal;
		///End SHOW_LAYER_LIST_ON_M_LINK_SELECTED
		
		//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);///------ Folger 01/12/09 v8.0995c AVOID_MULTIPLE_GET_FORMAT_ALL_TO_SPEED_UP_LAYER_MANAGEMENT_ON_SELECTED_LAYER_CHANGE		

	}
	///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
	void enable_apply(bool bEnable = true, DWORD lParam = 0)
	{
		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		//GetItem(IDC_LAYERTOOL_APPLY).Enable = true;
		GetItem(IDC_LAYERTOOL_APPLY).Enable = GetItem(IDOK).Enable = bEnable;	
		///End INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
	}
	
	///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
	bool isRefButton(TreeNode& trNode)
	{
		if(!trNode)
			return false;
		
		return trNode.tagName.CompareNoCase("GetRefLayer") == 0;
	}
	string GetGroupButton(TreeNode& trNode)
	{
		//trNode is some setitng, and now no button under a setting node
		//so this function will assum button node is trNode's brother or its parent's brother
		if( !trNode ||  (!isRefButton(trNode) && trNode.ID == ONODETYPE_PUSHBUTTON_GROUP) )
			return "";
		
		TreeNode trParent = trNode.Parent();
		if(!trParent)
			return "";
			
		TreeNode trBtn = trParent.FindNodeByAttribute(STR_ID_ATTRIB, ONODETYPE_PUSHBUTTON_GROUP, FALSE); 
		if( isRefButton(trBtn) )
		{
			//action button is always the last node
			trBtn = trParent.LastNode;
			if( isRefButton(trBtn) || trBtn.ID != ONODETYPE_PUSHBUTTON_GROUP )
				return "";
		}
		if(trBtn)			
			return trBtn.tagName;
		
		return GetGroupButton(trParent);
	}
	bool EnableButtonOnChange(TreeNode& trGUI, bool bChange = true, LPCSTR lpcszButton = NULL)
	{
		if(!trGUI)
			return false;
		
		vector<string> vsButtons = {"ModifyButton", "ResizeButton", "MoveButton", 
									"SwapButton", "SetBGColorButton", "SetBorderButton",	///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
									"SetScaleFactorrButton"};	///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		vsButtons.Add("LinkButton"); /// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON		
		if(lpcszButton)
		{
			if(vsButtons.Find(lpcszButton) < 0)
				return false;
				
			vsButtons.SetSize(1);
			vsButtons[0] = lpcszButton;
		}
		
		bool 	bNeedUpdate = false;
		int 	nCount 	= vsButtons.GetSize();
		for(int ii = 0; ii< nCount; ii++)
		{
			TreeNode trNode = tree_get_node_by_tagname(trGUI, vsButtons[ii], true);
			if(trNode)
			{
				if(trNode.ID == ONODETYPE_PUSHBUTTON_GROUP)
				{
					trNode.Enable = bChange? ENABLE : DISABLE;
					bNeedUpdate = true;
				}
			}
		}
		
		//if(bUpdate)
			//UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
		return bNeedUpdate;
	}
protected:
	void ConstructTree()
	{
		TreeNode tr = InitTree();
		tr.SetAttribute(STR_NAME_ATTRIB, m_gpTemp.GetName());
		GETN_USE(tr)
		///Jasmine 05/09/07 REARRANGE_TAB_CONTENT		
		ConstructAddTree(tr);	///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
		///End REARRANGE_TAB_CONTENT
		
		ConstructArrangeTree(tr);
		
		ConstructSizeTree(tr);	///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
		
		ConstructLinkTree(tr);
		///Jasmine 02/01/09 CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
#ifndef REMOVE_AXES_TAB 
		ConstructAxesTree(tr);	///Jasmine 01/09/09 v8.0995 QA80-12812 ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL		
#endif//REMOVE_AXES_TAB
///End CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
		
		ConstructDisplayTree(tr);
		
		///Jasmine 03/23/07 ADD_AUTO_CHECK_BOX
		#ifdef AUTO_CHECK_BOX_READY
		addAutoCheckBox(tr);
		#endif
		//End ADD_AUTO_CHECK_BOX
		
		TREE_CTRL_VAR.SetTree(tr);		///Jasmine 01/07/09 v8.0994b GET_OPTIMAL_SIZE_FROM_DYNA_TREE
		
		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		EnableButtonOnChange(tr, false);
		///End INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
	}
	
///Jasmine 12/29/08 v8.0991b QA80-12812  SET_SCALE_TYPE_IN_ADDING_NEW_LAYER	
#define GETN_SCALE_TYPE_LIST(_NODE_NAME, _NODE_LABEL)	GETN_LIST(_NODE_NAME, _NODE_LABEL, 0, _L("Linear|Log 10|Probability|Probit|Reciprocal|Offset Reciprocal|Logit|Natural Log|Log 2"))
	///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
	void ConstructAddTree(TreeNode& trGUI)
	{		
		///Jasmine 03/20/09 CENTRAILIZE_ADD_LAYER_CODE_IN_LAYADD_XF_AND_LAYERMANAGEMENT
		AddingLayerType	_typeObj;
		string strCombo = _typeObj.GetTypeList(true);		
		///End CENTRAILIZE_ADD_LAYER_CODE_IN_LAYADD_XF_AND_LAYERMANAGEMENT

		GETN_USE(trGUI)

		GETN_BEGIN_BRANCH(Add, _L("Add Layer"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_LIST(LayerType, _L("Type"), 0, strCombo)																GETN_ID(LM_LAYER_TYPE_ID)
			///Jasmine 03/24/09 SWITCH_LINKTO_NVAL_ON_LEFT_LAYER_SELECT_CHANGE
			//GETN_LIST(LinkTo, _L("Link To"), 0, m_strLayerList)
			GETN_LIST(LinkTo, _L("Link To"), -1, m_strLayerList)	GETN_READ_ONLY										GETN_ID(LM_LINK_TO_ID)
			///End SWITCH_LINKTO_NVAL_ON_LEFT_LAYER_SELECT_CHANGE
			///Jasmine 12/29/08 v8.0991b QA80-12812  SET_SCALE_TYPE_IN_ADDING_NEW_LAYER	
			GETN_SCALE_TYPE_LIST(XScale, _L("X Scale"))
			GETN_SCALE_TYPE_LIST(YScale, _L("Y Scale"))
			///End SET_SCALE_TYPE_IN_ADDING_NEW_LAYER
			GETN_BUTTON_GROUP(AddButton, "", 0, STR_APPLY_BTN) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)			GETN_ID(LM_ADD_BTN_ID)
		GETN_END_BRANCH(Add)
		
	}
	///End USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
///End SET_SCALE_TYPE_IN_ADDING_NEW_LAYER
	
	void ConstructArrangeTree(TreeNode& trGUI)
	{
		GETN_USE(trGUI)
		
		GETN_BEGIN_BRANCH(Arrange, _L("Arrange"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_CHECK(ArrangeSelection, _L("Arrange Selected Layers"), 0)	GETN_ID(LM_ARRANGE_SELECTION_ID) /// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS ///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY
			GETN_LIST(PositionOrder, _L("Arrange Order"), 0, _L("Layer Index Order|Current Position Order"))	GETN_ID(LM_POSITION_ORDER_ID)  ///Jasmine 01/13/11 ORG-1084 KEEP_POSITION_ORDER_IN_ARRANGEMENT
			GETN_NUM(Row, _L("Number of Rows"), 1)			
			GETN_NUM(Col, _L("Number of Columns"), 1)		
			GETN_CHECK(AddNew, _L("Add Extra Layer(s) for Grid"), 1)
			GETN_CHECK(KeepRatio, _L("Keep Layer Aspect Ratio"), 0)
			/// Iris 10/22/2009 QA80-14515 KEEP_LINK_LAYERS_UNCHECK
			//GETN_CHECK(LinkArrange, _L("Link Layers"), 1) /// Iris 01/15/2009 LINK_TO_FIRST_LAYER_WHEN_ARRANGE
			GETN_CHECK(LinkArrange, _L("Link Layers"), 0) /// Iris 01/15/2009 LINK_TO_FIRST_LAYER_WHEN_ARRANGE
			///end KEEP_LINK_LAYERS_UNCHECK
			///Jasmine 09/04/09 SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME
			//GETN_CHECK(SmartArrange, _L("Hide Overlapping Axes/Ticks"), 0)	///Kyle 01/08/2009 v8.0994d QA80-12812 SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
			GETN_CHECK(SmartArrange, _L("Show Axes Frame"), 0)	
				GETN_OPTION_EVENT_EX(_show_smart_arrange_hint)
			GETN_STR(hint1, _L("Overlapping axes/ticks are hidden"), "") GETN_READ_ONLY_COLOR GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_USE_LABEL)// | DISPLAY_EDITOR_NEXT_LINE | DISPLAY_EDITOR_WRAPPED)
			///End SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME
			
			GETN_BEGIN_BRANCH(Margins, _L("Spacing (in % of Page Dimension)"))	//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				GETN_NUM(XGap, _L("Horizontal Gap"), 5)				
				GETN_NUM(YGap, _L("Vertical Gap"), 5)				
				GETN_NUM(LeftMargin, _L("Left Margin"), 15)			
				GETN_NUM(RightMargin, _L("Right Margin"), 10)		
				GETN_NUM(TopMargin, _L("Top Margin"), 10)			
				GETN_NUM(BottomMargin, _L("Bottom Margin"), 15)		
			GETN_END_BRANCH(Margins)			
			
			GETN_BUTTON_GROUP(ArrangeButton, "", 0, STR_APPLY_BTN) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_ARRANGE_BTN_ID)
		GETN_END_BRANCH(Arrange)
	}

	///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
#define GETN_REFLAYER_LIST			GETN_LIST(RefLayer, _L("Reference Layer"), 0, m_strLayerList)
#define GETN_REFLAYER_BTN(_ID)		GETN_BUTTON_GROUP(GetRefLayer, "", 0, _L("Show Reference Layer Scale")) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT) GETN_ID(_ID)
#define GETN_UNIT_BTN(_ID)			GETN_LIST(Units, _L("Units"), 0, STR_LAYER_UNIT_LIST + _L("|% of Reference Layer")) GETN_ID(_ID)
			
	void ConstructSizeTree(TreeNode& trGUI)
	{
		string strCombo;
		string strLabel;
		
		GETN_USE(trGUI)
		GETN_BEGIN_BRANCH(size_tab_option, STR_OPTION)	SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	///Jasmine 12/31/08 v8.0992c QA80-12883 SET_BRANCH_NO_CLOSEABLE
			GETN_RADIO_INDEX(radio, 0, strCombo)	GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)			GETN_ID(LM_SIZR_TAB_RADIO_ID)
		GETN_END_BRANCH(size_tab_option)	
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		//GETN_LIST(RefLayer, _L("Reference Layer"), 0, m_strLayerList)										GETN_ID(LM_REF_LAYER_ID)
		//GETN_LIST(Units, _L("Units"), 0, STR_LAYER_UNIT_LIST + _L("|% of Reference Layer"))					GETN_ID(LM_UNITS_BTN_ID)
		////End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		//GETN_CHECK(Custom, _L("Customized"), 1)																GETN_ID(LM_CUSTOM_ID)
		//GETN_CURRENT_SUBNODE.Show = false;///Jasmine 03/23/07 hide Customized checkbox
		
		strLabel = _L("Resize");
		strCombo += strLabel + "|";
		GETN_BEGIN_BRANCH(Resize, strLabel)	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			///Kyle 01/22/2009 SHOW_LAYER_LIST_ON_M_LINK_SELECTED
			//GETN_REFLAYER_LIST
			//GETN_REFLAYER_BTN(LM_SIZE_REF_LAYER_ID)
			//GETN_UNIT_BTN(LM_SIZE_UNITS_BTN_ID)
			GETN_UNIT_BTN(LM_SIZE_UNITS_BTN_ID)
			GETN_REFLAYER_LIST
			///End SHOW_LAYER_LIST_ON_M_LINK_SELECTED
			/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
// 			GETN_NUM(Width, _L("Width"), 68.2)	GETN_CONTROL_OPTION_BOX(true)	//GETN_READ_ONLY_COLOR	///Jasmine 04/09/07 ADD_USE_CHECK
// 			GETN_NUM(Height, _L("Height"), 71.8)GETN_CONTROL_OPTION_BOX(true)	//GETN_READ_ONLY_COLOR	
			GETN_NUM(Width, _L("Width"), 68.2)
			GETN_NUM(Height, _L("Height"), 71.8)
			/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			GETN_BUTTON_GROUP(ResizeButton, "", 0, STR_APPLY_BTN)  GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_RESIZE_BTN_ID)
				GETN_READ_ONLY		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		GETN_END_BRANCH(Resize)
		
		strLabel = _L("Move");
		strCombo += strLabel + "|";
		GETN_BEGIN_BRANCH(Move, strLabel)	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			///Kyle 01/22/2009 SHOW_LAYER_LIST_ON_M_LINK_SELECTED
			//GETN_REFLAYER_LIST
			//GETN_REFLAYER_BTN(LM_MOVE_REF_LAYER_ID)
			//GETN_UNIT_BTN(LM_MOVE_UNITS_BTN_ID)
			GETN_UNIT_BTN(LM_MOVE_UNITS_BTN_ID)
			GETN_REFLAYER_LIST
			///End SHOW_LAYER_LIST_ON_M_LINK_SELECTED
			/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
// 			GETN_NUM(Left, _L("Left"), 17.9)	GETN_CONTROL_OPTION_BOX(true)	//GETN_READ_ONLY_COLOR
// 			GETN_NUM(Top, _L("Top"), 11.6)		GETN_CONTROL_OPTION_BOX(true)	//GETN_READ_ONLY_COLOR
			GETN_NUM(Left, _L("Left"), 17.9)
			GETN_NUM(Top, _L("Top"), 11.6)
			/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			GETN_BUTTON_GROUP(MoveButton, "", 0, STR_APPLY_BTN)  GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)		GETN_ID(LM_MOVE_BTN_ID)
				GETN_READ_ONLY		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		GETN_END_BRANCH(Move)
		
		strLabel = _L("Swap");
		strCombo += strLabel + "|";
		GETN_BEGIN_BRANCH(Swap, strLabel)	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	
			///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
			//GETN_LIST(LayerA, _L("First Layer"), 0, m_strLayerList)
			//GETN_LIST(LayerB, _L("Second Layer"), page_get_layer_count(m_gpTemp, false) > 1? 1:0, m_strLayerList)	///Jasmine 12/08/08 v8.0983 SWAP_LAYERS_SHOULD_HAVE_TWO_DIFF_INIT_VALUE
			GETN_LIST(LayerA, _L("First Layer"), -1, m_strLayerList)	GETN_ID(LM_SWAP_LAYERA_ID) /// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS
				GETN_OPTION_SPECIALVALS("-1")  /// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
			GETN_LIST(LayerB, _L("Second Layer"), -1, m_strLayerList)	GETN_ID(LM_SWAP_LAYERB_ID) /// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS
				GETN_OPTION_SPECIALVALS("-1")  /// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
			///End INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
			GETN_BUTTON_GROUP(SwapButton, "", 0, STR_APPLY_BTN)  GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)		GETN_ID(LM_SWAP_BTN_ID) //Swap Layer A and Layer B	
				GETN_READ_ONLY		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		GETN_END_BRANCH(Swap)
		
		strLabel = _L("Align");
		strCombo += strLabel + "|";
		GETN_BEGIN_BRANCH(Align, strLabel)	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_REFLAYER_LIST
			///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
			//GETN_LIST(Direction, _L("Direction"), 0, _L("Left|Top|Right|Bottom"))
			GETN_LIST(Direction, _L("Direction"), 0, _L("Left|Top|Right|Bottom"))	
			///End INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
			GETN_BUTTON_GROUP(AlignButton, "", 0, STR_APPLY_BTN)  GETN_READ_ONLY_COLOR	GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_ALIGN_BTN_ID)
				GETN_READ_ONLY		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		GETN_END_BRANCH(Align)
		
		strCombo.TrimRight("|");	
		trGUI.size_tab_option.radio.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	}
	///End USE_RADIO_TO_SIMPLIFY_TAB_CONTENT

	///Jasmine 01/09/09 v8.0995 QA80-12812 ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL
	void ConstructAxesTree(TreeNode& trGUI)
	{
		GETN_USE(trGUI)		
		
		///Jasmine 10/11/2011 ORG-4052-P1 NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
		GETN_STR(RadarChartHint, _L("Radar Chart is not supported."), "")		GETN_HINT_EX(FALSE, FALSE) 
		GETN_CURRENT_SUBNODE.Show = false;
		///End NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
		
		///Jasmine 01/07/09 v8.0994b QA80-12812 CP_SAY_MODIFY_AXIS_SHOULD_NOT_WITH_ADD_LAYER
		GETN_BEGIN_BRANCH(EditLayer, _L("Modify Axes"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			///Jasmine 12/29/08 v8.0991b QA80-12812  SET_SCALE_TYPE_IN_ADDING_NEW_LAYER	
			GETN_SCALE_TYPE_LIST(XScale, _L("X Scale"))	
				//GETN_CONTROL_OPTION_BOX(true)	///Jasmine 04/09/07 ADD_USE_CHECK	/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			GETN_SCALE_TYPE_LIST(YScale, _L("Y Scale"))
				//GETN_CONTROL_OPTION_BOX(true)	///Jasmine 04/09/07 ADD_USE_CHECK	/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			///End SET_SCALE_TYPE_IN_ADDING_NEW_LAYER
			
			/*GETN_BEGIN_BRANCH(Axes, _L("Show"))		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				GETN_CHECK(BottomAxes, _L("Bottom"), 1)
				GETN_CHECK(LeftAxes, _L("Left"), 1)
				GETN_CHECK(TopAxes, _L("Top"), 0)
				GETN_CHECK(RightAxes, _L("Right"), 0)
			GETN_END_BRANCH(Axes)*/
				
				
			GETN_BEGIN_BRANCH(BottomAxes, _L("Bottom"))		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				_make_axes_nodes(GETN_CURRENT_SUBNODE);
			GETN_END_BRANCH(BottomAxes)
			
			GETN_BEGIN_BRANCH(LeftAxes, _L("Left"))		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				_make_axes_nodes(GETN_CURRENT_SUBNODE);
			GETN_END_BRANCH(LeftAxes)
			
			GETN_BEGIN_BRANCH(TopAxes, _L("Top"))		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				_make_axes_nodes(GETN_CURRENT_SUBNODE);
			GETN_END_BRANCH(TopAxes)
			
			GETN_BEGIN_BRANCH(RightAxes, _L("Right"))		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				_make_axes_nodes(GETN_CURRENT_SUBNODE);
			GETN_END_BRANCH(RightAxes)			
			
			GETN_BUTTON_GROUP(ModifyButton, "", 0, STR_APPLY_BTN) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_MODIFY_BTN_ID)
				GETN_READ_ONLY		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
		GETN_END_BRANCH(EditLayer)		
		///End CP_SAY_MODIFY_AXIS_SHOULD_NOT_WITH_ADD_LAYER
	}
	///End ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL
	
	void ConstructDisplayTree(TreeNode& trGUI)
	{
		///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		string strCombo;
		string strLabel;
		
		GETN_USE(trGUI)				
		GETN_LIST(DrawingOrder, _L("Drawing Order"), graph_get_draw_order(m_gpTemp), _L("Draw Composite|Draw Layer by Layer"))				GETN_ID(LM_DRAW_ORDER_ID)		
		
		GETN_BEGIN_BRANCH(display_tab_option, STR_OPTION)	SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
			GETN_RADIO_INDEX(radio, 0, strCombo)	GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)			GETN_ID(LM_DISPLAY_TAB_RADIO_ID)
		GETN_END_BRANCH(display_tab_option)	
		
		strLabel = _L("Color");
		strCombo += strLabel + "|";
		GETN_BEGIN_BRANCH(Color, strLabel)	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	
			///Jasmine 07/03/07 QA70-9929 COLOR_1_OFFSET_FROM_DYNA_CNTRL
			/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			//GETN_COLOR(bgColor, _L("Background Color"), 3)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE|COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_LT_INDEX)	GETN_CONTROL_OPTION_BOX(true)///Jasmine 05/31/07 QA80-9845 COLORWELL_OPTIONS_ATTRIBUTE
			GETN_COLOR(bgColor, _L("Background Color"), 3)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE|COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_LT_INDEX)
			/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			///Jasmine 06/15/07 MODIFICATION_SET_COLOR_FUNCTION
			//GETN_CHECK(Border, _L("Border"), false)	
			/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			//GETN_COLOR(FillColor, _L("Border Fill Color"), 3)		GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE|COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_LT_INDEX)	GETN_CONTROL_OPTION_BOX(true)
			GETN_COLOR(FillColor, _L("Border Fill Color"), 3)		GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE|COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_LT_INDEX)
			/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			///Kyle 01/13/2009 v8.0995d OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
			//GETN_COLOR(BorderColor, _L("Border Color"), 3)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE|COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_LT_INDEX)	GETN_CONTROL_OPTION_BOX(true)
			/////End COLOR_1_OFFSET_FROM_DYNA_CNTRL
			//GETN_LIST(BorderStyle, _L("Border Style"), 0, STR_BORDER_STYLE_LIST) 	GETN_CONTROL_OPTION_BOX(true)	///Kyle 01/12/2009  v8.0995c QA80-12812 ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE
			///Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
			//GETN_LIST(BorderStyle, _L("Border Style"), 0, STR_BORDER_STYLE_LIST) 	GETN_CONTROL_OPTION_BOX(true)
			///End BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
			//GETN_OPTION_EVENT_EX(_check_enable_display_border_color_width)
			/// Kenny 08/13/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			//GETN_COLOR(BorderColor, _L("Border Color"), 3)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE|COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_LT_INDEX)	GETN_CONTROL_OPTION_BOX(true)
			GETN_COLOR(BorderColor, _L("Border Color"), 3)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_NONE|COLORLIST_SINGLE|COLORLIST_CUSTOM|COLORLIST_LT_INDEX)
			/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			///End OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
			///End MODIFICATION_SET_COLOR_FUNCTION
			GETN_BUTTON_GROUP(SetBGColorButton, "", 0, STR_APPLY_BTN) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_FILL_BG_COLOR_BTN_ID)
				GETN_READ_ONLY		///Jasmine 12/30/08 v8.0992 QA80-12812 INDICATE_UPDATE_PREVIEW_BY_CLICK_BUTTON
	
		GETN_END_BRANCH(Color)
		
		strLabel = _L("Border Dimensions");
		strCombo += strLabel + "|";
		GETN_BEGIN_BRANCH(BorderWidth, strLabel + _L("(% of Layer)")) 	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	
		//GETN_CHECKBOX_BRANCH(0) //GETN_OPTION_EVENT(_on_check_border_width_branch_event)
			GETN_NUM(LeftBorder, _L("Left Border"), 0)
			GETN_NUM(TopBorder, _L("Top Border"), 0)
			GETN_NUM(RightBorder, _L("Right Border"), 0)
			GETN_NUM(BottomBorder, _L("Bottom Border"), 0)
			
			GETN_BUTTON_GROUP(SetBorderButton, "", 0, STR_APPLY_BTN) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_SET_BORDER_BTN_ID)
				GETN_READ_ONLY
		GETN_END_BRANCH(BorderWidth)
		
		///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		strLabel = _L("Scale Elements");
		strCombo += strLabel + "|";
		GETN_BEGIN_BRANCH(ScaleFactor, strLabel) 	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	
			/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
			//GETN_LIST(scalemode, _L("Scale Elements"), 0, _L("Use Source | Scale with Layer Frame | Fixed Factor"))GETN_ID(LM_SCALE_ELEMENT_ID)
			GETN_LIST(scalemode, _L("Scale Mode"), 0, _L("Scale with Layer Frame|Fixed Factor"))GETN_ID(LM_SCALE_ELEMENT_ID)
			/// END REMOVE_SPACE_FOR_LOCATION_STRING
			GETN_NUM(fixfactor, _L("Fixed Factor"), 1.0)	GETN_READ_ONLY
			///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
			
			GETN_BUTTON_GROUP(SetScaleFactorrButton, "", 0, STR_APPLY_BTN) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_SET_SCALE_FACTOR_BTN_ID)
				GETN_READ_ONLY
		GETN_END_BRANCH(ScaleFactor)
		///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
			
		strCombo.TrimRight("|");	
		trGUI.display_tab_option.radio.SetAttribute(STR_COMBO_ATTRIB, strCombo);
		///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
	}
	
	void ConstructLinkTree(TreeNode& trGUI)
	{
		GETN_USE(trGUI)		
		
		GETN_BEGIN_BRANCH(Link, _L("Link"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_LIST(Parent, _L("Link To"), -1, m_strLayerList)	
				GETN_ID(LM_LINK_PARENT_ID) /// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
				GETN_OPTION_SPECIALVALS("-1") /// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
			GETN_BEGIN_BRANCH(XAxes, _L("X Axis Link"))	GETN_COMBO_BRANCH(0,_L("None|Straight(1 to 1)|Custom"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	GETN_ID_BRANCH(LM_X_AXIS_ID)
				GETN_STR(X1, "X1", "")	GETN_READ_ONLY
				GETN_STR(X2, "X2", "")	GETN_READ_ONLY
			GETN_END_BRANCH(XAxes)
			GETN_BEGIN_BRANCH(YAxes, _L("Y Axis Link"))	GETN_COMBO_BRANCH(0,_L("None|Straight(1 to 1)|Custom"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	GETN_ID_BRANCH(LM_Y_AXIS_ID)
				GETN_STR(Y1, "Y1", "")	GETN_READ_ONLY
				GETN_STR(Y2, "Y2", "")	GETN_READ_ONLY
			GETN_END_BRANCH(YAxes)
			GETN_LIST(Unit, _L("Units"), M_LINK, STR_LAYER_UNIT_LIST + _L("|% of Linked Layer"))
			/// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
			//GETN_BUTTON_GROUP(LinkButton, "", 0, _L("Link"))  GETN_READ_ONLY_COLOR	GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_LINK_BTN_ID)
			//GETN_BUTTON_GROUP(DislinkButton, "", 0, _L("Unlink"))  GETN_READ_ONLY_COLOR	GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_DISLINK_BTN_ID)
			GETN_BUTTON_GROUP(LinkButton, "", 0, _L("Apply"))  GETN_READ_ONLY_COLOR	GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT)	GETN_ID(LM_LINK_BTN_ID)
			///end CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
		GETN_END_BRANCH(Link)
	}
	
	///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_INFO_FOR_USER_FRIENDLY
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int	GetTotalWidth(bool bMin = false)
	int	GetMinClientTrackWidth()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{	
		if( IsBottomPaneShown() )
		{
			RECT rSownBtn;
			GetClientRect(GetItem(IDC_SHOW_BOTTOM), rSownBtn);
			return rSownBtn.right + GetMinBottomPaneHeight() + 2*GetControlGap();
		}
			
		return m_nMinWidth;
	}
	///End ADD_INFO_FOR_USER_FRIENDLY
	
	/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	int	checkShowErrMsg(int nTab)
	{
		if( nTab < 0 || nTab >=  m_vnCurrentErrMsg.GetSize() )
			return CER_NO_ERROR;
		
		return m_vnCurrentErrMsg[nTab];
	}
	///end LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	
	///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	//void	ShowInfoMsg(int nInfo)
	void	ShowInfoMsg(int nInfo, bool bErrMag = false)
	///end LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	{
		//if(m_nCurrentInfo == nInfo)
			//return;
		
		RECT 	rShowBottom;
		GetClientRect(GetItem(IDC_SHOW_BOTTOM), rShowBottom);
		
		int 	nGap 	= GetControlGap();	
		int 	nHeight = GetDlgStatusMsgBoxHeight(rShowBottom.right - nGap);		
		
		m_nCurrentInfo = nInfo;
		
		string strInfo;
		if(CER_INPUT_ARGUMENT_LESS_THAN_SPECIFIED_VALUE == nInfo)
		{
			int nValue = 0;
			ocu_load_msg_str(nInfo, &strInfo, _L("Spacing"), &nValue);
		}
		else if(CER_LAYER_TOO_SMALL == nInfo)
		{
			int nInfo2;
			
			TreeNode trGUI 		= GetTree();
			TreeNode trMargins 	= tree_get_node_by_tagname(trGUI, "Margins", true);
			if(trMargins && 
			(trMargins.XGap.nVal || trMargins.YGap.nVal || trMargins.LeftMargin.nVal || trMargins.RightMargin.nVal || trMargins.TopMargin.nVal || trMargins.BottomMargin.nVal))
				nInfo2 = CER_ARRANGE_LAYERS_RESET_SPACING;
			else
				nInfo2 = CER_ARRANGE_LAYERS_RESET_ROW_COLUMN;
			
			string strErrMsg ;
			ocu_load_msg_str(nInfo2, &strErrMsg);			
			ocu_load_msg_str(nInfo, &strInfo, strErrMsg);
		}
		else
			ocu_load_err_msg_str(nInfo, &strInfo);
		
		
		/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
		//SetInfoMsg(strInfo);
		if( bErrMag )
			SetErrMsg(strInfo);
		else
			SetInfoMsg(strInfo);
		///end LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
		
		int nDiff = GetDlgStatusMsgBoxHeight(rShowBottom.right - nGap) - nHeight;
		if(nDiff != 0)
			OnDlgResize();
		
	}
	void	SetInfoMsg(LPCSTR lpcszMsg = NULL)
	{
		///Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		//CheckInitErrMsgBox(*this, COLOR_BLACK, COLOR_BLACK, COLORTEXTBLINK_DEFAULT);
		//if(lpcszMsg)
			//m_btnErrMessage.Text = lpcszMsg;
		CheckInitErrMsgBox(*this, COLOR_BLACK, COLOR_BLACK, COLORTEXTBLINK_OFF);
		CountSetErrMsg(lpcszMsg);
		///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	}
	
	/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	void 	SetErrMsg(LPCSTR lpcszMsg = NULL)
	{
		CheckInitErrMsgBox(*this, COLOR_RED, COLOR_BLACK, COLORTEXTBLINK_DEFAULT);
		///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		//if(lpcszMsg)
			//m_btnErrMessage.Text = lpcszMsg;
		CountSetErrMsg(lpcszMsg);
		///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	}
	///end LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	///End SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	
	///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_INFO_FOR_USER_FRIENDLY
	void InitTopTextPosition()
	{	
		///Jasmine 12/30/08 v8.0992 QA80-12812  TOP_TEXT_TOO_BIG
		GetItem(IDC_LAYERTOOL_TOP_TEXT).Visible = false;		///Jasmine 01/04/08 doing...need remove IDC_LAYERTOOL_TOP_TEXT after the new improvement is done
		int nGap = GetControlGap();	
		///End TOP_TEXT_TOO_BIG
		
		RECT rr;
		GetClientRect(GetItem(IDC_LAYERTOOL_TAB), rr);
		///Jasmine 12/30/08 v8.0992 QA80-12812  TOP_TEXT_TOO_BIG
		//int nDy = rr.top - rText.bottom - nGap;
		int nDy = nGap - rr.top;
		///End TOP_TEXT_TOO_BIG
		vector<uint> vnCtrls = {IDC_LAYERTOOL_SELECTION, IDC_LAYERTOOL_REORDER, IDC_LAYERTOOL_GRID, IDC_LAYERTOOL_TAB, 0};
		MoveControls(vnCtrls, 0, nDy);
		
		
		///Jasmine 01/07/09 v8.0994b GET_OPTIMAL_SIZE_FROM_DYNA_TREE
		SIZE sz;
		TREE_CTRL_VAR.GetOptimalSize(sz);
		
		RECT rTab;
		GetClientRect(m_tab, rTab);
		int nGridWidth 	= rTab.left;
		int nTabEdge	= rTab.left;
		m_tab.AdjustRect(FALSE, &rTab);
		nTabEdge 		= abs(nTabEdge - rTab.left);
		
		m_nMinWidth = nGap + nGridWidth + nGap + nTabEdge*2 + sz.cx + nGap;
		///End GET_OPTIMAL_SIZE_FROM_DYNA_TREE
		
	}
	///End ADD_INFO_FOR_USER_FRIENDLY
	void InitPreview()
	{
		Control ctrl = GetItem(IDC_LAYERTOOL_PREVIEW);	
		GraphControl gcCntrl;
		gcCntrl.CreateControl(ctrl.GetSafeHwnd());
		gcCntrl.Visible = false;
		GraphPageControl 	gpCntrl; 
		///Kyle 08/10/2010 ORG-172-S1 OC_DISABLE_ZOOM_FOR_PREVIEW
		//DWORD 	dwNoClicks = NOCLICK_AXES | NOCLICK_DATA_PLOT | NOCLICK_LABEL | NOCLICK_BUTTONS | NOCLICK_LAYER | NOCLICK_TICKLABEL | NOCLICK_LAYERICON;
		///Jasmine 08/13/2010 ORG-172-S2 CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL
		//DWORD 	dwNoClicks = NOCLICK_AXES | NOCLICK_DATA_PLOT | NOCLICK_LABEL | NOCLICK_BUTTONS | NOCLICK_LAYER | NOCLICK_TICKLABEL | NOCLICK_LAYERICON | NOCLICK_ZOOMPAN;
		DWORD 	dwNoClicks = OC_PREVIEW_NOCLICK_NOZOOMPAN | NOCLICK_LABEL | NOCLICK_BUTTONS;
		///End CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL
		///End OC_DISABLE_ZOOM_FOR_PREVIEW
		gpCntrl.Create(gcCntrl, dwNoClicks);
		m_gpTemp = gpCntrl.GetPage();
		GraphPage gp(m_strGraph);
		///Jasmine 12/03/08 v8.0982 PAGE_CLONE_CAN_APPLY_TO_EXISTING_PAGE
		if(gp)
		{
			///Jasmine 12/08/08 v8.0983 QA80-12464 KEEP_PREVIEW_RESULT_SOURCE_GRAPHS_CONSISTENT
			m_stPageSetting.dwNoClick = get_gp_noclick(gp);
			m_stPageSetting.bAxisIcon = gp.AxisLayerIcons;
			double dPageIcon = 1;
			gp.LT_execute("_icon_show = page.icons");
			LT_get_var("_icon_show", &dPageIcon);
			m_stPageSetting.bPageIcon = dPageIcon;
			
			bool bRet = page_clone(gp, m_gpTemp);
			///End KEEP_PREVIEW_RESULT_SOURCE_GRAPHS_CONSISTENT
			ASSERT(bRet);
			
			m_nActive = page_active_layer_index(gp);
			
			if(IsBottomPaneShown())
				gcCntrl.Visible = true;
		}
		/*{
			///Jasmine 08/01/07 APPLY_FORMAT_AFTER_ADD_GRAPH
			////MAKE_SAME_PAGE_SIZE
			//Tree 	tr;
			//tr = gp.GetFormat(FPB_STYLE_COLOR, FOB_ALL, TRUE, TRUE);//FPB_DIMENSION, FOB_DIMENSION);
			////TreeNode trPage = tr.Root.Page;
			////foreach(TreeNode cNode in trPage.Children)
				////if(cNode.tagName.Compare("Dimension"))
					////cNode.Remove();
			//m_gpTemp.ApplyFormat(tr);
			/////End 
			m_nActive = page_active_layer_index(gp);
			vector<string> vs;
			vs.Add(m_strGraph);
			page_add_to_one_graph(m_gpTemp, vs);
			
			//MAKE_SAME_PAGE_SIZE
			Tree 	tr;
			tr = gp.GetFormat(FPB_STYLE_COLOR, FOB_ALL, TRUE, TRUE);
			m_gpTemp.ApplyFormat(tr);
			
			//---Jasmine 11/25/08 v8.0979 QA80-12464 COPY_SOURCE_PAGE_SIZE_TO_PREVIEW
			//applyformat doesn't work, so I use LT here
			gp.LT_execute("s_width=page.width; s_height=page.height");
			//gp.LT_execute("s_width=; s_height=");//debug msg
						
			m_gpTemp.LT_execute("page.width=s_width; page.height=s_height");
			m_gpTemp.LT_execute("page.zoomWhole=1");
			//---
			///End 
			///End APPLY_FORMAT_AFTER_ADD_GRAPH
			int ii = 0;
			foreach(GraphLayer gl in gp.Layers)
			{
				///Jasmine 11/09/07 QA70-10621 USE_REAL_LAYER_NAME_NOT_INDEX
				//m_gpTemp.Layers(ii++).SetName(gl.GetName());
				copyLayerName(gl, m_gpTemp.Layers(ii++));
				///End USE_REAL_LAYER_NAME_NOT_INDEX
			}
			page_set_active_layer(m_gpTemp, m_nActive, false);
			//int nOrder = graph_get_draw_order(gp);
			//graph_set_draw_order(m_gpTemp, nOrder);
			if(IsBottomPaneShown())
				gcCntrl.Visible = true;
		}*/
		///End PAGE_CLONE_CAN_APPLY_TO_EXISTING_PAGE
		m_gpTemp.AxisLayerIcons = true;
		m_gpTemp.LT_execute("page.icons=0");	///Jasmine 12/11/2008 v8.0985 QA80-12464-P3 KYLE_CHANGE_VC_CODE_AND_PAGE_ICON_SHOW
	}
	void InitLayerList(TreeNode& tr)
	{		
		m_Layerlist.Init(IDC_LAYERTOOL_GRID, false, true, NULL, *this);
		m_Layerlist.SetReady(false);
		m_Layerlist.SetAllowSelection(true);
		m_Layerlist.SetSelection(flexSelectionListBox);
		m_Layerlist.SetEditable(flexEDKbdMouse);
		m_Layerlist.SetExtendLastCol(true);	
		m_Layerlist.SetupRowsCols(1, 1,  -1, 2);
		m_Layerlist.SetTreeNodeMoveRowsAttrib(tr);
		///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		string strInfo;
		ocu_load_err_msg_str(LAYER_MANAGE_LAYERLIST_INFO, &strInfo);
		m_Layerlist.SetToolTipsText(strInfo);
		///End SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
		m_Layerlist.SetReady(true);
	}
	/*void InitSelectedList()
	{
		m_Selectlist.Init(IDC_LAYERTOOL_DESTINATION, *this);
		m_Selectlist.SetAllowSelection(true);
		m_Selectlist.SetSelection(flexSelectionListBox);
		m_Selectlist.SetupRowsCols(0, 0, -1, 2);
	}*/
	/// Kenny 08/07/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
	void SetConflictItemsToUndefined()
	{
		TreeNode trGUI = GetTree();
		int nSelTab = m_tab.GetCurSel();
		switch (nSelTab)
		{
		case LAYERTOOL_SIZE_TAB:
			setConflictItemsInSizePosTabToUndefined(trGUI);
			break;
		case LAYERTOOL_LINK_TAB:
			setConflictItemsInLinkTabToUndefined(trGUI);
			break;
		case LAYERTOOL_AXES_TAB:
			setConflictItemsInAxesTabToUndefined(trGUI);
			break;
		case LAYERTOOL_DISPLAY_TAB:
			setConflictItemsInDisplayTabToUndefined(trGUI);
			break;
		}
	}
	void ClearAllUndefinedAttributes()
	{
		TreeNode trGUI = GetTree();
		tree_remove_attribute(trGUI, STR_ATTRIB_DYNACONTROL_UNDEFINED);
	}
	/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
private:
	///Jasmine 10/11/2011 ORG-4052-P1 NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
	bool isSelLayerAxesEditable()
	{
		vector<uint> vnRows;
		m_Layerlist.GetSelRows(vnRows);
		int nSize = vnRows.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			
			if( !isAxesEditable(gl) )
				return false;
		}
		
		return true;
	}
	
	bool isAxesEditable(const GraphLayer& gl)
	{			
		UINT nCoorType = gl.GetCoordinateType();
		return (nCoorType != FRAME_COOR_SPIDER);
	}
	///End NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
	
	/// Kenny 08/07/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
#define CHECK_RETURN_ON_SINGLE_SELECTION	\
	vector<uint> vnRows;\
	m_Layerlist.GetSelRows(vnRows);\
	if ( vnRows.GetSize() <= 1 )\
	{\
		return;\
	}
	void setConflictItemsInSizePosTabToUndefined(TreeNode& trGUI)
	{
		CHECK_RETURN_ON_SINGLE_SELECTION
		TreeNode trOptionRadio = trGUI.size_tab_option.radio;
		if( !trOptionRadio.IsValid() )
		{
			ASSERT(FALSE);
			return;
		}
		int nOption = trOptionRadio.nVal;
		bool bDoResize = SIZE_TAB_RESIZE == nOption;
		if ( !bDoResize && SIZE_TAB_MOVE != nOption )
			return;	// There's no need to check for Swap & Align action

		int nUnits = -1;
		double dPos[TOTAL_POS];

		bool bIsUnitsConflict = false;
		bool bIsWidthConflict = false;
		bool bIsHeightConflict = false;
		bool bIsLeftConflict = false;
		bool bIsTopConflict = false;

		bool bIsFirstLayer = true;
		for (int ii = 0; ii < vnRows.GetSize(); ++ii)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			if ( gl )
			{
				if ( bIsFirstLayer )
				{
					nUnits = gl.GetPosition(dPos);
					bIsFirstLayer = false;
				}
				else
				{
 					double dCurPos[TOTAL_POS];
 					int nCurUnits = gl.GetPosition(dCurPos);
					bIsUnitsConflict |= nCurUnits != nUnits;
					if ( bDoResize )
					{
						bIsWidthConflict	|= dCurPos[WIDTH_POS] != dPos[WIDTH_POS];
						bIsHeightConflict	|= dCurPos[HEIGHT_POS] != dPos[HEIGHT_POS];
						if ( bIsUnitsConflict && bIsWidthConflict && bIsHeightConflict )
							break;
					}
					else
					{
						bIsLeftConflict		|= dCurPos[LEFT_POS] != dPos[LEFT_POS];
						bIsTopConflict		|= dCurPos[TOP_POS] != dPos[TOP_POS];
						if ( bIsUnitsConflict && bIsLeftConflict && bIsTopConflict )
							break;
					}
				}
			}
		}
		TreeNode tnUnits;
		if ( bDoResize )
		{
			tnUnits = trGUI.Resize.Units;
			TreeNode tnWidth = trGUI.Resize.Width;
			TreeNode tnHeight = trGUI.Resize.Height;
			if ( tnWidth )
				tnWidth.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsWidthConflict);
			if ( tnHeight )
				tnHeight.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsHeightConflict);
		}
		else
		{
			tnUnits = trGUI.Move.Units;
			TreeNode tnLeft = trGUI.Move.Left;
			TreeNode tnTop = trGUI.Move.Top;
			if ( tnLeft )
				tnLeft.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsLeftConflict);
			if ( tnTop )
				tnTop.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsTopConflict);
		}
		if ( tnUnits )
			tnUnits.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsUnitsConflict);
	}
	void setConflictItemsInLinkTabToUndefined(TreeNode& trGUI)
	{
		CHECK_RETURN_ON_SINGLE_SELECTION
		TreeNode trLink = trGUI.Link;
		if( !trLink.IsValid() )
		{
			ASSERT(FALSE);
			return;
		}

		int nLinkTo = -1;

		int nXAxis = -1;
		int nXAxisX1 = -1;
		int nXAxisX2 = -1;

		int nYAxis = -1;
		int nYAxisY1 = -1;
		int nYAxisY2 = -1;

		string strX1, strX2, strY1, strY2;

		int nUnits = -1;

		bool bIsLinkToConflict = false;
		bool bIsXAxisLinkConflict = false;
		bool bIsXAxisX1Conflict = false;
		bool bIsXAxisX2Conflict = false;
		bool bIsYAxisLinkConflict = false;
		bool bIsYAxisY1Conflict = false;
		bool bIsYAxisY2Conflict = false;
		bool bIsUnitsConflict = false;

		bool bIsFirstLayer = true;
		for (int ii = 0; ii < vnRows.GetSize(); ++ii)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			if ( gl )
			{
				if ( bIsFirstLayer )
				{
					bool bRet = layer_get_link(gl, nLinkTo, &nXAxis, &nYAxis, &nUnits, &strX1, &strX2, &strY1, &strY2);
					bIsFirstLayer = false;
				}
				else
				{
					int nParentLayer, nCurXAxis, nCurYAxis, nCurUnit;
					string strCurX1, strCurX2, strCurY1, strCurY2;
					bool bRet = layer_get_link(gl, nParentLayer, &nCurXAxis, &nCurYAxis, &nCurUnit, &strCurX1, &strCurX2, &strCurY1, &strCurY2);
					bIsLinkToConflict		|= nParentLayer != nLinkTo;
					bIsXAxisLinkConflict	|= nCurXAxis != nXAxis;
					if ( !bIsXAxisLinkConflict && LINK_CUSTOM == nCurXAxis )
					{
						bIsXAxisX1Conflict |= strCurX1.CompareNoCase(strX1) != 0;
						bIsXAxisX2Conflict |= strCurX2.CompareNoCase(strX2) != 0;
					}
					bIsYAxisLinkConflict |= nCurYAxis != nYAxis;
					if ( !bIsYAxisLinkConflict && LINK_CUSTOM == nCurYAxis )
					{
						bIsYAxisY1Conflict |= strCurY1.CompareNoCase(strY1) != 0;
						bIsYAxisY2Conflict |= strCurY2.CompareNoCase(strY2) != 0;
					}
					bIsUnitsConflict |= nCurUnit != nUnits;
					if ( bIsLinkToConflict && bIsUnitsConflict && bIsXAxisLinkConflict && bIsYAxisLinkConflict )
						break;
				}
			}
		}
		TreeNode tnLink = trGUI.Link;
		TreeNode tnLinkTo = tnLink.Parent;
		TreeNode tnXAxis = tnLink.XAxes;
		TreeNode tnX1 = tnXAxis.X1;
		TreeNode tnX2 = tnXAxis.X2;
		TreeNode tnYAxis = tnLink.YAxes;
		TreeNode tnY1 = tnYAxis.Y1;
		TreeNode tnY2 = tnYAxis.Y2;
		TreeNode tnUnits = tnLink.Units;
		if ( tnLinkTo )
			tnLinkTo.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsLinkToConflict);
		if ( tnXAxis )
			tnXAxis.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsXAxisLinkConflict);
		if ( tnX1 )
		{
			tnX1.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsXAxisX1Conflict);
			tnX1.Enable &= !bIsXAxisLinkConflict;
		}
		if ( tnX2 )
		{
			tnX2.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsXAxisX2Conflict);
			tnX2.Enable &= !bIsXAxisLinkConflict;
		}
		if ( tnYAxis )
			tnYAxis.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsYAxisLinkConflict);
		if ( tnY1 )
		{
			tnY1.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsYAxisY1Conflict);
			tnY1.Enable &= !bIsYAxisLinkConflict;
		}
		if ( tnY2 )
		{
			tnY2.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsYAxisY2Conflict);
			tnY2.Enable &= !bIsYAxisLinkConflict;
		}
		if ( tnUnits )
			tnUnits.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsUnitsConflict);
	}
	void setConflictItemsInAxesTabToUndefined(TreeNode& trGUI)
	{		
		///Jasmine 10/11/2011 ORG-4052-P1 NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART		
		//CHECK_RETURN_ON_SINGLE_SELECTION
		vector<uint> vnRows;
		m_Layerlist.GetSelRows(vnRows);
		if ( vnRows.GetSize() <= 1 )
		{
			return;
		}
		
		if( !isSelLayerAxesEditable() )
			return;		
		///End NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
		
		TreeNode trEdit = trGUI.EditLayer;
		if ( !trEdit.IsValid() )
		{
			ASSERT(FALSE);
			return;
		}

		int nXScale, nYScale;
		vector<int> vnAxes, vnLabels, vnTitles, vnMajorTicks, vnMinorTicks;

		bool bIsXScaleConflict = false;
		bool bIsYScaleConflict = false;
		/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
// 		vector<bool> vbIsAxesConflict(4), vbIsLabelsConflict(4), vbIsTitlesConflict(4), vbIsMajorTicksConflict(4)/*, vbIsMinorTicksConflict(4)*/;
// 		vbIsAxesConflict = vbIsLabelsConflict = vbIsTitlesConflict = vbIsMajorTicksConflict /*= vbIsMinorTicksConflict*/ = false;
		vector<bool> vbIsAxesConflict(4);
		vector<bool> vbIsLabelsConflict(4);
		vector<bool> vbIsTitlesConflict(4);
		vector<bool> vbIsMajorTicksConflict(4);
		vector<bool> vbIsFormulasConflict(4);
		vbIsAxesConflict = vbIsLabelsConflict = vbIsTitlesConflict = vbIsMajorTicksConflict = vbIsFormulasConflict = false;

		vector<string> 	vsFormula;
		vector<int>		vnAxisType;
		vnAxisType.Data(0, AXIS_TOTAL-1);
		/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB

		bool bIsFirstLayer = true;
		for (int ii = 0; ii < vnRows.GetSize(); ++ii)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			if ( gl )
			{
				if ( bIsFirstLayer )
				{
					axis_get_scale_type(gl, &nXScale, &nYScale);
					BOOL bRet = layer_get_axes_object_properties(gl, vnAxes, vnLabels, vnTitles, vnMajorTicks, vnMinorTicks);
					/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
					ASSERT(bRet);
					bRet = _get_set_axis_label_formula(gl, vnAxisType, vsFormula, true);
					ASSERT(bRet);
					/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
					bIsFirstLayer = false;
				}
				else
				{
					int nCurXScale, nCurYScale;
					vector<int> vnCurAxes, vnCurLabels, vnCurTitles, vnCurMajorTicks, vnCurMinorTicks;
					/// Kenny 10/20/2009 QA80-14100 MORE_WORK_ON_ADDING_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
					//axis_get_scale_type(gl, &nCurXScale, &nCurXScale);
					axis_get_scale_type(gl, &nCurXScale, &nCurYScale);
					/// End QA80-14100 MORE_WORK_ON_ADDING_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
					BOOL bRet = layer_get_axes_object_properties(gl, vnCurAxes, vnCurLabels, vnCurTitles, vnCurMajorTicks, vnCurMinorTicks);

					/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
					ASSERT(bRet);
					vector<string> 	vsCurFormula;
					bRet = _get_set_axis_label_formula(gl, vnAxisType, vsCurFormula, true);
					ASSERT(bRet);
					/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB

					bIsXScaleConflict	|= nCurXScale != nXScale;
					bIsYScaleConflict	|= nCurYScale != nYScale;
					bool bIsAllConflict = bIsXScaleConflict && bIsYScaleConflict;
					for(int nAxisType = 0; nAxisType < AXIS_TOTAL; ++nAxisType)
					{
						vbIsAxesConflict[nAxisType]			|= vnCurAxes[nAxisType] != vnAxes[nAxisType];
						vbIsLabelsConflict[nAxisType]		|= vnCurLabels[nAxisType] != vnLabels[nAxisType];
						vbIsTitlesConflict[nAxisType]		|= vnCurTitles[nAxisType] != vnTitles[nAxisType];
						vbIsMajorTicksConflict[nAxisType]	|= vnCurMajorTicks[nAxisType] != vnMajorTicks[nAxisType];

						/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
						vbIsFormulasConflict[nAxisType]		|= vsCurFormula[nAxisType] != vsFormula[nAxisType];
						/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB

						if ( bIsAllConflict )
						{
							bIsAllConflict &=	vbIsAxesConflict[nAxisType]
											&& vbIsLabelsConflict[nAxisType]
											&& vbIsTitlesConflict[nAxisType]
											/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
											//&& vbIsMajorTicksConflict[nAxisType];
											&& vbIsMajorTicksConflict[nAxisType]
											&& vbIsFormulasConflict[nAxisType];
											/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
						}
					}
					if ( bIsAllConflict )
						break;
				}
			}
		}
		TreeNode trXScale = trEdit.XScale;
		TreeNode trYScale = trEdit.YScale;

		if ( trXScale )
			trXScale.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsXScaleConflict);
		if ( trYScale )
			trYScale.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsYScaleConflict);

		vector<string> vsNodePrefix = {"Bottom", "Left", "Top", "Right"};

		for(int nAxisType = 0; nAxisType < AXIS_TOTAL; ++nAxisType)
		{
			string strAxesNodeName = vsNodePrefix[nAxisType] + "Axes";
			TreeNode trAxes = trEdit.GetNode(strAxesNodeName);
			if ( trAxes )
			{
				TreeNode trAxisShow = trAxes.AxisShow;
				TreeNode trTickLabel = trAxes.TickLabel;
				TreeNode trTitle= trAxes.Title;
				TreeNode trTick = trAxes.Tick;
				/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
				TreeNode trFormula = trAxes.Formula;
				/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
				if ( trAxisShow )
					trAxisShow.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, vbIsAxesConflict[nAxisType]);
				if ( trTickLabel )
					trTickLabel.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, vbIsLabelsConflict[nAxisType]);
				if ( trTitle )
					trTitle.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, vbIsTitlesConflict[nAxisType]);
				if ( trTick )
					trTick.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, vbIsMajorTicksConflict[nAxisType]);
				/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
				if ( trFormula )
					trFormula.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, vbIsFormulasConflict[nAxisType]);
				/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
			}
		}
	}
	void setConflictItemsInDisplayTabToUndefined(TreeNode& trGUI)
	{
		CHECK_RETURN_ON_SINGLE_SELECTION
		TreeNode trOptionRadio = trGUI.display_tab_option.radio;
		if( !trOptionRadio.IsValid() )
		{
			ASSERT(FALSE);
			return;
		}

		int nOption = trOptionRadio.nVal;

		int nBGColor, nFillColor, nBorderColor;
		double dLeftBorder, dTopBorder, dRightBorder, dBottomBorder;
		int nScaleMode;
		double dFixedFactor;

		bool bIsBGColorConflict = false;
		bool bIsFillColorConflict = false;
		bool bIsBorderColorConflict = false;
		bool bIsLeftBorderConflict = false;
		bool bIsTopBorderConflict = false;
		bool bIsRightBorderConflict = false;
		bool bIsBottomBorderConflict = false;
		bool bIsScaleModeConflict = false;
		bool bIsFixedFactorConflict = false;

		bool bIsAllConflict = false;

		bool bIsFirstLayer = true;
		for (int ii = 0; ii < vnRows.GetSize(); ++ii)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			if ( gl )
			{
				Tree trFmt;
				trFmt = gl.GetFormat(FPB_STYLE_COLOR|FPB_DIMENSION|FPB_SHOW|FPB_SCALE, FOB_BACKGROUND|FOB_DIMENSION|FOB_OTHER, TRUE, TRUE);
				TreeNode tnBackground = trFmt.Root.Background;
				TreeNode tnBGDimension = tnBackground.Dimension;
				TreeNode tnDisplay = trFmt.Root.Display;
				if ( bIsFirstLayer )
				{
					nBGColor = tnBackground.Color.nVal;
					nFillColor = tnBackground.Fill.Color.nVal;
					nBorderColor = tnBackground.Border.Color.nVal;
					dLeftBorder = tnBGDimension.Left.dVal;
					dTopBorder = tnBGDimension.Top.dVal;
					dRightBorder = tnBGDimension.Right.dVal;
					dBottomBorder = tnBGDimension.Bottom.dVal;
					nScaleMode = tnDisplay.Scale ? tnDisplay.Scale.nVal : 0;
					dFixedFactor = tnDisplay.FixedFactor ? tnDisplay.FixedFactor.dVal : 1.0;
					bIsFirstLayer = false;
				}
				else
				{
					switch (nOption)
					{
					case DISPLAY_TAB_COLOR:
						bIsBGColorConflict		|= tnBackground.Color.nVal != nBGColor;
						bIsFillColorConflict	|= tnBackground.Fill.Color.nVal != nFillColor;
						bIsBorderColorConflict	|= tnBackground.Border.Color.nVal != nBorderColor;
						if ( bIsBGColorConflict && bIsFillColorConflict && bIsBorderColorConflict )
							bIsAllConflict = true;
						break;
					case DISPLAY_TAB_BORDER:
						bIsLeftBorderConflict	|= is_equal(tnBGDimension.Left.dVal, dLeftBorder, '!');
						bIsTopBorderConflict	|= is_equal(tnBGDimension.Top.dVal, dTopBorder, '!');
						bIsRightBorderConflict	|= is_equal(tnBGDimension.Right.dVal, dRightBorder, '!');
						bIsBottomBorderConflict	|= is_equal(tnBGDimension.Bottom.dVal, dBottomBorder, '!');
						if ( bIsLeftBorderConflict && bIsTopBorderConflict && bIsRightBorderConflict && bIsBottomBorderConflict )
							bIsAllConflict = true;
						break;
					case DISPLAY_TAB_SCALE_FACTOR:
						{
							int nCurScaleMode = tnDisplay.Scale ? tnDisplay.Scale.nVal : 0;
							double dCurFixedFactor = tnDisplay.FixedFactor ? tnDisplay.FixedFactor.dVal : 1.0;
							bIsScaleModeConflict	|= nCurScaleMode != nScaleMode;
							bIsFixedFactorConflict	|= !is_equal(dCurFixedFactor, dFixedFactor);
							if ( bIsScaleModeConflict && bIsFixedFactorConflict )
								bIsAllConflict = true;
						}
						break;
					default:
						ASSERT(FALSE);
						break;
					}
					if ( bIsAllConflict )
						break;
				}
			}
		}
		switch (nOption)
		{
		case DISPLAY_TAB_COLOR:
			{
				TreeNode tnColor = trGUI.Color;
				if ( tnColor )
				{
					tnColor.bgColor.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsBGColorConflict);
					tnColor.FillColor.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsFillColorConflict);
					tnColor.BorderColor.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsBorderColorConflict);
				}
			}
			break;
		case DISPLAY_TAB_BORDER:
			{
				TreeNode tnBorder = trGUI.BorderWidth;
				if ( tnBorder )
				{
					tnBorder.LeftBorder.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsLeftBorderConflict);
					tnBorder.TopBorder.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsTopBorderConflict);
					tnBorder.RightBorder.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsRightBorderConflict);
					tnBorder.BottomBorder.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsBottomBorderConflict);
				}
			}
			break;
		case DISPLAY_TAB_SCALE_FACTOR:
			{
				TreeNode tnScale = trGUI.ScaleFactor;
				if ( tnScale )
				{
					tnScale.scalemode.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsScaleModeConflict);
					tnScale.fixfactor.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsFixedFactorConflict);
				}
			}
			break;
		}
	}
	bool canApplyResize(TreeNode& trGUI, BOOL& bIsWidthUndefined, BOOL& bIsHeightUndefined)
	{
		BOOL bIsUnitsUndefined = FALSE;
		BOOL bIsRefLayerUndefined = FALSE;
		bIsWidthUndefined = FALSE;
		bIsHeightUndefined = FALSE;

		TreeNode trResize = trGUI.Resize;
		TreeNode trRefLayer = trResize.RefLayer;
		TreeNode trUnits 	= trResize.Units;

		trUnits.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsUnitsUndefined);
		trRefLayer.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsRefLayerUndefined);
		trResize.Width.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsWidthUndefined);
		trResize.Height.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsHeightUndefined);

		bool bCanApply = !( bIsUnitsUndefined || (trRefLayer.Show && bIsRefLayerUndefined) || (bIsWidthUndefined && bIsHeightUndefined) );
		return bCanApply;
	}
	bool canApplyMove(TreeNode& trGUI, BOOL& bIsLeftUndefined, BOOL& bIsTopUndefined)
	{
		BOOL bIsUnitsUndefined = FALSE;
		BOOL bIsRefLayerUndefined = FALSE;
		bIsLeftUndefined = FALSE;
		bIsTopUndefined = FALSE;

		TreeNode trMove = trGUI.Move;
		TreeNode trRefLayer = trMove.RefLayer;
		TreeNode trUnits 	= trMove.Units;

		trUnits.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsUnitsUndefined);
		trRefLayer.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsRefLayerUndefined);
		trMove.Left.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsLeftUndefined);
		trMove.Top.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsTopUndefined);

		bool bCanApply = !( bIsUnitsUndefined || (trRefLayer.Show && bIsRefLayerUndefined) || (bIsLeftUndefined && bIsTopUndefined) );
		return bCanApply;
	}
	/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
	///Kyle 01/21/2009 ON_LAYER_LINK_CHANGE
	void onLayerLinkChange()
	{
		if(!m_Layerlist.IsReady())
			return;
		vector<uint> vnRows;
		m_Layerlist.GetSelRows(vnRows);
		if(1 != vnRows.GetSize())
			return;

		TreeNode tr = GetTree();
		int nIndex = get_layer_index( vnRows[0] );
		GraphLayer gl = m_gpTemp.Layers(nIndex);
		if(!gl)
			return;

		TreeNode trLink = tree_get_node_by_tagname(tr, "Link", true);
		if(trLink.IsValid())
		{
			int nParentLayer, nXAxis, nYAxis, nUnit;
			string strX1, strX2, strY1, strY2;
			layer_get_link(gl, nParentLayer, &nXAxis, &nYAxis, &nUnit, &strX1, &strX2 , &strY1, &strY2);
			trLink.Parent.nVal = nParentLayer;
			trLink.XAxes.Use = nXAxis;
			trLink.YAxes.Use = nYAxis;
			trLink.Unit.nVal = nUnit;
			trLink.XAxes.X1.strVal = strX1;
			trLink.XAxes.X2.strVal = strX2;
			trLink.YAxes.Y1.strVal = strY1;
			trLink.YAxes.Y2.strVal = strY2;

			_on_change_link_to(tr);
		}
	}
	///End ON_LAYER_LINK_CHANGE

	///Jasmine 12/03/08 v8.0982 PAGE_CLONE_CAN_APPLY_TO_EXISTING_PAGE
	/*
	///Jasmine 11/09/07 QA70-10621 USE_REAL_LAYER_NAME_NOT_INDEX
	bool copyLayerName(const GraphLayer glSrc, GraphLayer& glDst)
	{
		if(!glSrc || !glDst)
			return false;
		string strName;
		if(!glSrc.GetName(strName))
			strName = "";
		BOOL bRet = glDst.SetName(strName);
		return TRUE == bRet;
	}
	///End USE_REAL_LAYER_NAME_NOT_INDEX
	*/
	///End PAGE_CLONE_CAN_APPLY_TO_EXISTING_PAGE
	///Jasmine 01/09/09 v8.0995 QA80-12812 KEEP_ACTIVE_TAB_AND_EACH_OPTION_VALUE
	bool loadSettingsFromRegister()
	{
		//check boxes
		vector<byte> vbCheckSettings;
		if(!load_default_checkboxes(STR_DLG_NAME, vbCheckSettings, STR_CHECK_BOX_VALUES) || vbCheckSettings.GetSize() < LM_REG_TOTAL)
			return false;
		
		TreeNode tr = GetTree();
			
		TreeNode trAddNew = tree_get_node_by_tagname(tr, "AddNew", true);
		if(trAddNew.IsValid())
			trAddNew.nVal = vbCheckSettings[LM_REG_ADD_EXTRACT_CHECK];
		
		TreeNode trKeepRatio = tree_get_node_by_tagname(tr, "KeepRatio", true);
		if(trKeepRatio.IsValid())
			trKeepRatio.nVal = vbCheckSettings[LM_REG_KEEP_RATIO_CHECK];
		
		TreeNode trSmartArrange = tree_get_node_by_tagname(tr, "SmartArrange", true);
		if(trSmartArrange.IsValid())
		{
			trSmartArrange.nVal = vbCheckSettings[LM_REG_SMART_ARRANGE_CHECK];
			_show_smart_arrange_hint(tr, -1, -1, trSmartArrange, 0, 0, *this);	///Jasmine 09/04/09 SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME
		}
		
		///Kyle 01/19/2009 SAVE_SETTING_OF_ARRANGE_SELECTION_AND_LINK_ARRANGE
		TreeNode trArrangeSelection = tree_get_node_by_tagname(tr, "ArrangeSelection", true);
		if(trArrangeSelection)
			trArrangeSelection.nVal = vbCheckSettings[LM_REG_ARRANGE_SELECTION_CHECK];
		
		TreeNode trLinkArrange = tree_get_node_by_tagname(tr, "LinkArrange", true);
		if(trLinkArrange)
			trLinkArrange.nVal = vbCheckSettings[LM_REG_LINK_ARRANGE_CHECK];
		///End SAVE_SETTING_OF_ARRANGE_SELECTION_AND_LINK_ARRANGE
	
		//other setting		
		///Jasmine 01/13/11 ORG-1084 KEEP_POSITION_ORDER_IN_ARRANGEMENT
		DWORD dwArrangeOrder;
		dlg_load_registry(STR_DLG_NAME, STR_ARRANGE_ORDER_VALUE, dwArrangeOrder, 0);
		TreeNode trArrangeOrder = tree_get_node_by_tagname(tr, "PositionOrder", true);
		if(trArrangeOrder)
			trArrangeOrder.nVal = dwArrangeOrder;
		///End KEEP_POSITION_ORDER_IN_ARRANGEMENT
		
		DWORD dwOption;
		dlg_load_registry(STR_DLG_NAME, STR_SIZE_TAB_OPTION, dwOption, 0);
		TreeNode trSizeTabOption = tree_get_node_by_tagname(tr, "size_tab_option", true);
		if(trSizeTabOption && trSizeTabOption.radio)
			trSizeTabOption.radio.nVal = dwOption;
		
		DWORD dwTab;
		dlg_load_registry(STR_DLG_NAME, STR_TAB_VALUE, dwTab, 0);
		m_tab.SetCurSel(dwTab);
					
		return true;
	}
	bool saveSettingsToRegister()
	{
		TreeNode tr = GetTree();
		
		//other setting
		///Jasmine 01/13/11 ORG-1084 KEEP_POSITION_ORDER_IN_ARRANGEMENT
		TreeNode trArrangeOrder = tree_get_node_by_tagname(tr, "PositionOrder", true);
		if(trArrangeOrder)
			dlg_save_to_registry(STR_DLG_NAME, STR_ARRANGE_ORDER_VALUE, trArrangeOrder.nVal);
		///End KEEP_POSITION_ORDER_IN_ARRANGEMENT
		
		bool bRet = dlg_save_to_registry( STR_DLG_NAME, STR_TAB_VALUE, m_tab.GetCurSel() );
		if(!bRet)
			ASSERT(0);
		
		TreeNode trSizeTabOption = tree_get_node_by_tagname(tr, "size_tab_option", true);
		if(trSizeTabOption && trSizeTabOption.radio)
		{
			bRet = dlg_save_to_registry( STR_DLG_NAME, STR_SIZE_TAB_OPTION, trSizeTabOption.radio.nVal );
			if(!bRet)
				ASSERT(0);
		}
		
		//check boxes
		vector<byte> vbCheckSettings(LM_REG_TOTAL);
		
		TreeNode trAddNew = tree_get_node_by_tagname(tr, "AddNew", true);
		if(trAddNew.IsValid())
			vbCheckSettings[LM_REG_ADD_EXTRACT_CHECK] = trAddNew.nVal;
		
		TreeNode trKeepRatio = tree_get_node_by_tagname(tr, "KeepRatio", true);
		if(trKeepRatio.IsValid())
			vbCheckSettings[LM_REG_KEEP_RATIO_CHECK] = trKeepRatio.nVal;
		
		TreeNode trSmartArrange = tree_get_node_by_tagname(tr, "SmartArrange", true);
		if(trSmartArrange.IsValid())
			vbCheckSettings[LM_REG_SMART_ARRANGE_CHECK] = trSmartArrange.nVal;
		
		///Kyle 01/19/2009 SAVE_SETTING_OF_ARRANGE_SELECTION_AND_LINK_ARRANGE
		TreeNode trArrangeSelection = tree_get_node_by_tagname(tr, "ArrangeSelection", true);
		if(trArrangeSelection)
			vbCheckSettings[LM_REG_ARRANGE_SELECTION_CHECK] = trArrangeSelection.nVal;
		
		TreeNode trLinkArrange = tree_get_node_by_tagname(tr, "LinkArrange", true);
		if(trLinkArrange)
			vbCheckSettings[LM_REG_LINK_ARRANGE_CHECK] = trLinkArrange.nVal;
		///End SAVE_SETTING_OF_ARRANGE_SELECTION_AND_LINK_ARRANGE
		
		return save_default_checkboxes(STR_DLG_NAME, vbCheckSettings, STR_CHECK_BOX_VALUES);
	}
	///End KEEP_ACTIVE_TAB_AND_EACH_OPTION_VALUE
	
	///Jasmine 09/15/09 QA81-14321 SAVE_SPACING_SETTING_FOR_ARRANGEMENT
	void loadSpacingSettings()
	{
		int nCol, nRow, nXGap, nYGap, nLeftMargin, nRightMargin, nTopMargin, nBottomMargin;
		if( !load_arrange_spacing_settings(m_gpTemp, nCol, nRow, nXGap, nYGap, nLeftMargin, nRightMargin, nTopMargin, nBottomMargin) )
			return;
		
		TreeNode tr = GetTree();
		TreeNode trArrange = tr.Arrange;
		TreeNode trMargins = trArrange.Margins;
		trArrange.Col.nVal 	= nCol;
		trArrange.Row.nVal 	= nRow;
		trMargins.XGap.nVal	= nXGap;		
		trMargins.YGap.nVal	= nYGap;				
		trMargins.LeftMargin.nVal 	= nLeftMargin;	
		trMargins.RightMargin.nVal 	= nRightMargin;		
		trMargins.TopMargin.nVal 	= nTopMargin;		
		trMargins.BottomMargin.nVal	= nBottomMargin;
	}
	
	void saveSpacingSettings()
	{
		TreeNode tr = GetTree();
		TreeNode trArrange = tr.Arrange;
		TreeNode trMargins = trArrange.Margins;
		
		int nCol, nRow, nXGap, nYGap, nLeftMargin, nRightMargin, nTopMargin, nBottomMargin;
		nCol = trArrange.Col.nVal;
		nRow = trArrange.Row.nVal;
		nXGap= trMargins.XGap.nVal;		
		nYGap= trMargins.YGap.nVal;				
		nLeftMargin		= trMargins.LeftMargin.nVal;	
		nRightMargin	= trMargins.RightMargin.nVal;		
		nTopMargin		= trMargins.TopMargin.nVal;		
		nBottomMargin	= trMargins.BottomMargin.nVal;
		
		if( !save_arrange_spacing_settings(m_gpTemp, nCol, nRow, nXGap, nYGap, nLeftMargin, nRightMargin, nTopMargin, nBottomMargin) )
			ASSERT(0);
	}
	///End SAVE_SPACING_SETTING_FOR_ARRANGEMENT
	
	///Jasmine 03/31/07 SUPPORT_MULTI_STEP_UNDO
	bool undo_enabled(bool bUpdateButton = false, int nInc = 0)
	{
		Button btnUndo = GetItem(IDC_LAYERTOOL_UNDO);
		if(bUpdateButton)
		{
			if(0==nInc)
				m_nUndoStackCount = 0;
			else
				m_nUndoStackCount += nInc;
			
			btnUndo.Enable = m_nUndoStackCount > 0? true:false;
		}
		
		return btnUndo.Enable;
	}
	///End SUPPORT_MULTI_STEP_UNDO
	///Jasmine 03/23/07 ADD_AUTO_CHECK_BOX
	void addAutoCheckBox(TreeNode& tr)//doing...
	{
		vector<string> vsTagNames = {"Width", "Height", "Left", "Top"};
		for(int ii = 0; ii < vsTagNames.GetSize(); ii++)
		{
			TreeNode trNode = tree_get_node_by_tagname(tr, vsTagNames[ii], true);
			if(trNode)
				octree_set_auto_support(&trNode);
		}
	}
	///End ADD_AUTO_CHECK_BOX
	void onTabChange()
	{
		int nSelTab = m_tab.GetCurSel();
		bool bEdit 		= nSelTab == LAYERTOOL_EDIT_TAB;
		bool bAdd 		= nSelTab == LAYERTOOL_ADD_TAB;
		bool bSize		= nSelTab == LAYERTOOL_SIZE_TAB;
		bool bDisplay	= nSelTab == LAYERTOOL_DISPLAY_TAB; ///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_DISPLAY_TAB_FOR_COLOR_AND_DRAW_ORDER
		bool bLink 		= nSelTab == LAYERTOOL_LINK_TAB;
///Jasmine 02/01/09 CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
#ifndef REMOVE_AXES_TAB 
		bool bAxes		= nSelTab == LAYERTOOL_AXES_TAB;	///Jasmine 01/09/09 v8.0995 QA80-12812 ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL
#else
		bool bAxes		= false;
#endif//REMOVE_AXES_TAB
///End CP_ASK_REMOVE_AXES_TAB_UNTIL_IT_WORK_FINE
		
		TreeNode tr = GetTree();
		
		///Jasmine 10/11/2011 ORG-4052-P1 NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
		if(tr.RadarChartHint)tr.RadarChartHint.Show = false;
		if(bAxes)
		{
			bAxes = isSelLayerAxesEditable();
			if(!bAxes && tr.RadarChartHint)
				tr.RadarChartHint.Show = true;
		}
		///End NO_XY_AXES_BUT_AXIS123_IN_RADAR_CHART
		
		if(tr.Add.IsValid())
			tr.Add.Show = bAdd;
		
				
		if(tr.Arrange.IsValid())
			tr.Arrange.Show = bEdit;//bAdd;		///Jasmine 05/09/07 REARRANGE_TAB_CONTENT
				
		OnSizeTabRadioChange(tr, bSize);///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
				
		if(tr.Link.IsValid())
			tr.Link.Show = bLink;			
		/// Kenny 08/07/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		if ( bLink )
		{
			setConflictItemsInLinkTabToUndefined(tr);
		}
		else if ( bAxes )
		{
			setConflictItemsInAxesTabToUndefined(tr);
		}
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			
		///Jasmine 01/09/09 v8.0995 QA80-12812 ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL
		if(tr.EditLayer.IsValid())
			tr.EditLayer.Show = bAxes;	
		///End ADD_TICK_LABEL_AND_TITLE_SHOW_CONTROL
		
		///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		OnDisplayTabRadioChange(tr, bDisplay);
		///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		
		UpdateDynaControl(false, GETNEVENT_ON_INIT, false);
	}
	///Jasmine 12/24/08 v8.0990c QA80-12812  USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
	bool OnSizeTabRadioChange(TreeNode& trGUI, bool bSize)
	{
		TreeNode trRadio = trGUI.size_tab_option.radio;
		if(!trRadio.IsValid())
			return false;
		
		trGUI.size_tab_option.Show = bSize;	
	
		highlightSelectLayerIcon(); /// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS
		
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		//if(trGUI.RefLayer.IsValid())
			//trGUI.RefLayer.Show = bSize;	
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
			
		//if(trGUI.Custom.IsValid())
			//trGUI.Custom.Show = bSize;	
			
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		//if(trGUI.Units.IsValid())
			//trGUI.Units.Show = bSize;	
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
			
		if(trGUI.Resize.IsValid())
			trGUI.Resize.Show = bSize && SIZE_TAB_RESIZE == trRadio.nVal;	
			
		if(trGUI.Move.IsValid())
			trGUI.Move.Show = bSize && SIZE_TAB_MOVE == trRadio.nVal;
			
		if(trGUI.Swap.IsValid())
			trGUI.Swap.Show = bSize && SIZE_TAB_SWAP == trRadio.nVal;
			
		if(trGUI.Align.IsValid())
			trGUI.Align.Show = bSize && SIZE_TAB_ALIGN == trRadio.nVal;

		/// Kenny 08/07/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		if ( bSize )
		{
			setConflictItemsInSizePosTabToUndefined(trGUI);
		}
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES

		return true;
	}
	///End USE_RADIO_TO_SIMPLIFY_TAB_CONTENT
	///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
	bool OnDisplayTabRadioChange(TreeNode& trGUI, bool bDisplay)
	{
		TreeNode trRadio = trGUI.display_tab_option.radio;
		if(!trRadio.IsValid())
			return false;
		
		trGUI.display_tab_option.Show = bDisplay;	
			
		if(trGUI.DrawingOrder.IsValid())
			trGUI.DrawingOrder.Show = bDisplay;	
		
		if(trGUI.Color.IsValid())
			trGUI.Color.Show = bDisplay && DISPLAY_TAB_COLOR == trRadio.nVal;	

		if(trGUI.BorderWidth.IsValid())
			trGUI.BorderWidth.Show = bDisplay && DISPLAY_TAB_BORDER == trRadio.nVal;	
		
		///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		if(trGUI.ScaleFactor.IsValid())
			trGUI.ScaleFactor.Show = bDisplay && DISPLAY_TAB_SCALE_FACTOR == trRadio.nVal;	
		///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB

		/// Kenny 08/07/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		if ( bDisplay )
		{
			setConflictItemsInDisplayTabToUndefined(trGUI);
		}
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
			
		return true;
	}
	///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
	bool showLayerListMenu(int nx, int ny)
	{
		vector<uint> vnSelRows;
		m_Layerlist.GetSelRows(vnSelRows);
		int nSize = vnSelRows.GetSize(), nClickRow, nClickCol, nCmd;
		m_Layerlist.GetMouseCell(nClickRow, nClickCol);
		if(!m_Layerlist.IsInGrid(nClickRow, nClickCol) || nClickRow < m_Layerlist.GetRowOffset())
			return false;
		vector<uint> vecIndex;
		vnSelRows.Find(vecIndex, nClickRow);
		if(!vecIndex.GetSize())
		{
			vnSelRows.SetSize(0);
			m_Layerlist.SelRow(nClickRow);
			vnSelRows.Add(nClickRow);
		}
		LayerListMenu	myMenu;
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
		if(!myMenu.GetCommand(nCmd))
			return false;
		switch(nCmd)
		{
		case LAYER_LIST_MENU_DELETE_LAYER:
			//return deleteLayers(vnSelRows);
			if( deleteLayers(vnSelRows) )
			{
				UpdateDynaControl(true, 0, false, DYNACONTROL_UPDATE_RECONSTRUCT);
				return true;
			}
			
			break;
		///Jasmine 12/24/08 v8.0990c QA80-12812  REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
		//case LAYER_LIST_MENU_REORDER_LAYER:
			//return reorderLayers();
			//break;
		///End REORDER_LAYER_RIGHT_AFTER_MOVE_AND_REMOVE_REORDER_BUTTON
		default:
			break;
		}
		return false;
	}
	bool deleteLayers(const vector<uint> vnSelRows)
	{
		int 	nRow;
		int 	nRowOffset 	= m_Layerlist.GetRowOffset();
		int 	nLayerCount = m_Layerlist.GetRows();
		bool 	bRestructure;
		DWORD 	dwCntrl = OCD_DEL_LINKED_OBJS | OCD_DEL_PARENT_IF_LAST | OCD_UNDO;
		
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON, not ready
		
		for(int ii = vnSelRows.GetSize() - 1; ii > -1; ii--)
		{
			nRow = vnSelRows[ii];
			///Jasmine 08/19/09 GETROWS_IS_WRONG_IN_DELETE_MULTI_LAYER
			//if(m_Layerlist.GetRows() <= nRowOffset + 1)
			if(nLayerCount <= nRowOffset + 1)
			///End GETROWS_IS_WRONG_IN_DELETE_MULTI_LAYER
			{
				MessageBox(GetSafeHwnd(), _L("Cannot delete last layer!"), _L("Attention!"), MB_OK | MB_ICONEXCLAMATION);
				break;
			}
			int nIndex = get_layer_index( nRow );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			if(gl.IsValid())
			{
				BOOL bRet = gl.Destroy(dwCntrl);
				///Jasmine 08/19/09 GETROWS_IS_WRONG_IN_DELETE_MULTI_LAYER
				ASSERT(bRet);
				ASSERT( m_gpTemp.IsValid() );
				nLayerCount--;
				///End GETROWS_IS_WRONG_IN_DELETE_MULTI_LAYER
			}
			bRestructure = true;
		}
				
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		if(bRestructure)
		{
			m_gpTemp.Refresh();
			OnLayersNumberChange(true);
		}
		return bRestructure;
	}
	bool reorderLayers()
	{
		//---Jasmine 01/09/2012 speed up
		//vector vn;
		//vector<string> vsVals;
		//m_Layerlist.GetColValues(LAYER_LIST_INDEX_COL, vsVals, m_Layerlist.GetRowOffset());
		//int nSize = convert_str_vector_to_num_vector(vsVals, vn);
		//bool bSame = true;
		//for(int ii = 0; ii < nSize; ii++)
		//{
			//vn[ii] -= 1;
			//if(ii != vn[ii])
				//bSame = false;
		//}
		//if(bSame)			
			//return false;
		vector<string> vsVals;
		m_Layerlist.GetColValues(LAYER_LIST_INDEX_COL, vsVals, m_Layerlist.GetRowOffset());
		
		vector<int> vn;
		int nSize = convert_string_vector_to_int_vector(vsVals, vn);
		vn -= 1;
		
		vector<int> vnIndex;
		vnIndex.Data(0, nSize-1);
		vnIndex = vn - vnIndex;
		
		vector<uint> vnFind;
		if(vnIndex.Find(MATREPL_TEST_GREATER | MATREPL_TEST_LESSTHAN, 0, vnFind) <= 0)
			return false;
		//---End 
		
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		reorder_graph_layer(m_gpTemp, vn);
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		m_gpTemp.Refresh();
		OnLayersNumberChange(true);
		return true;
	}
	///Jasmine 03/06/07 QA70-9433 CONVERT_LAYER_UNITS
	/*void convertDimensions(int oldunit, int newunit, double& width, double& height, double& left, double& top)
	{
		GraphLayer layer;
		layer = m_gpTemp.Layers(0);
		if(layer)
		{
			layer_set_size(layer, width, height, &oldunit);
			layer_set_position(layer, left, top);
			layer_set_unit(layer, newunit);			
			layer_get_size(layer, width, height); 
			layer_get_position(layer, &left, &top);
		}
		gp.Destroy();
	}*/
	
	/// Kenny 08/11/2009 QA81-14122 LINK_TO_SHOW_WRONG_ITEM_WHEN_LAYER_IS_NOT_LINKED
// 	static string _layer_index_str_to_index_map(LPCSTR lpcszLayerIndex)
// 	{
// 		string strLayerIndex(lpcszLayerIndex);
// 		if(strLayerIndex.IsEmpty())
// 			return "";
// 
// 		vector vIndex;
// 		strLayerIndex.GetTokens(vIndex, '|');
// 		vIndex = vIndex - 1;
// 
// 		vector<string> vsIndex;
// 		convert_double_vector_to_string_vector(vIndex, vsIndex, vIndex.GetSize());
// 
// 		string strIndexMap;
// 		strIndexMap.SetTokens(vsIndex, '|');
// 		return strIndexMap;
// 	}
	static string _layer_index_str_to_index_map(LPCSTR lpcszLayerIndex, string& strLayerIndexCombo)
	{
		strLayerIndexCombo = lpcszLayerIndex;
		
		vector vIndex;
		vector<string> vsIndex;

		if ( !strLayerIndexCombo.IsEmpty() )
		{
			strLayerIndexCombo.GetTokens(vIndex, '|');
			vIndex = vIndex - 1;
			convert_double_vector_to_string_vector(vIndex, vsIndex, vIndex.GetSize());
		}

		// Insert -1 as the first index to indicate NONE
		vsIndex.InsertAt(0, "-1");
		if ( vIndex.GetSize() > 0 )
			strLayerIndexCombo = _L("None") + "|" + strLayerIndexCombo;
		else
			strLayerIndexCombo = _L("None");
		
		string strIndexMap;
		strIndexMap.SetTokens(vsIndex, '|');
		return strIndexMap;
	}
	/// End QA81-14122 LINK_TO_SHOW_WRONG_ITEM_WHEN_LAYER_IS_NOT_LINKED
	
	void constructLinkToList()
	{
		if(!m_Layerlist.IsReady())
			return;
		vector<uint> vnRows;
		m_Layerlist.GetSelRows(vnRows);
		int nSize = vnRows.GetSize();
		vector<string> vs;
		m_strLayerList.GetTokens(vs, '|');
		for(int ii = 0; ii < nSize; ii++)
		{
			string strIndex = get_layer_index_str( vnRows[ii] );
			int nFind = vs.Find(strIndex), nCount = vs.GetSize() - nFind;
			if(-1 < nFind)
				vs.RemoveAt(nFind, nCount);
			if(!vs.GetSize())
				break;
		}
		
		string strLayerList;
		string strIndexMap; /// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
		//if(vs.GetSize()) /// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE, if empty at least should include <None>
		{			
			/// Kenny 08/11/2009 QA81-14122 LINK_TO_SHOW_WRONG_ITEM_WHEN_LAYER_IS_NOT_LINKED
// 			vs.InsertAt(0, _L("None"));  /// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
// 			strLayerList.SetTokens(vs, '|');
// 			strIndexMap = _layer_index_str_to_index_map(strLayerList);	 /// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE	
			strLayerList.SetTokens(vs, '|');
			strIndexMap = _layer_index_str_to_index_map(strLayerList, strLayerList);
			/// End QA81-14122 LINK_TO_SHOW_WRONG_ITEM_WHEN_LAYER_IS_NOT_LINKED	
		}
		TreeNode tr = GetTree();	
		TreeNode trLink = tree_get_node_by_tagname(tr, "Link", true);
		if(trLink.IsValid())
		{
			
			/// Iris 01/08/2009 SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
			/*
			bool bEnable = !strLayerList.IsEmpty();
			if(bEnable)
				trLink.Parent.SetAttribute(STR_COMBO_ATTRIB, strLayerList);
			*/
			bool bEnable = strLayerList.GetNumTokens('|') > 1; //if not link to layer, at least has <None>
			trLink.Parent.SetAttribute(STR_COMBO_ATTRIB, strLayerList);
			trLink.Parent.SetAttribute(STR_INTMAP_ATTRIB, strIndexMap);
			///end SET_DEFAULT_VAL_FROM_EMPTY_TO_NONE
			
			trLink.Parent.Enable = bEnable;
			//trLink.LinkButton.Enable = bEnable; /// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
		}
	}
	///End CONVERT_LAYER_UNITS
	
	/// Iris 01/08/2009 SET_ICON_COLOR_FOR_SELECTED_LAYERS
	int getSelectedLayers(vector<uint> &vnSelLayers)
	{
		int nTab = m_tab.GetCurSel();
		
		vector<uint> vnRows;
		if(!m_Layerlist.GetSelRows(vnRows))
			return 0;	
		vnSelLayers = vnRows -1;			
		
		TreeNode tr = GetTree();		
		if( LAYERTOOL_EDIT_TAB == nTab )
		{
			TreeNode trArrangeSelection = tree_get_node_by_tagname(tr, "ArrangeSelection", true);
			if( trArrangeSelection && 0 == trArrangeSelection.nVal ) // not check means arrange for all layers
			{
				vnSelLayers.Data(0, m_Layerlist.GetNumRows(), 1);
			}
		}
		
		if( LAYERTOOL_SIZE_TAB == nTab )
		{
			TreeNode trSizeRadio = tree_get_node_by_dataid(tr, LM_SIZR_TAB_RADIO_ID, true);
			if( trSizeRadio && SIZE_TAB_SWAP == trSizeRadio.nVal )
			{
				TreeNode trSwap = tree_get_node_by_tagname(tr, "Swap", true);
				if( trSwap && trSwap.LayerA && trSwap.LayerB )
				{					
					vnSelLayers.RemoveAll();
				
					if( -1 != trSwap.LayerA.nVal)
					{
						vnSelLayers.Add( trSwap.LayerA.nVal );
					}
					
					if( -1 != trSwap.LayerB.nVal)
					{
						vnSelLayers.Add( trSwap.LayerB.nVal );
					}					
				}
			}
		}		

		return vnSelLayers.GetSize();
	}
	
	void highlightSelectLayerIcon()
	{
		vector<uint> vnSelLayers;		
		getSelectedLayers(vnSelLayers);
		
		foreach(GraphLayer gl in m_gpTemp.Layers)
		{
			vector<uint> vnFindIndex;
			if( vnSelLayers.GetSize() > 0 && vnSelLayers.Find(vnFindIndex, gl.GetIndex()) > 0 ) // is selected layer
			{
				/// Iris 01/22/2009 IMPROVE_COLOR_OF_SELECTED_LAYER_ICON
				//gl.IndicatorBkColor = SYSCOLOR_BLUE;
				//gl.IndicatorTextColor = SYSCOLOR_WHITE;
				//gl.IndicatorBkColor = RGB(102, 242, 255); // want to use RGB color, but IndicatorBkColor no support.
				gl.IndicatorBkColor = SYSCOLOR_LTCYAN;
				///end IMPROVE_COLOR_OF_SELECTED_LAYER_ICON
			}
			else
			{
				gl.IndicatorBkColor = SYSCOLOR_LTGRAY;
				/// Iris 01/22/2009 IMPROVE_COLOR_OF_SELECTED_LAYER_ICON
				//gl.IndicatorTextColor = SYSCOLOR_BLACK;
				///end IMPROVE_COLOR_OF_SELECTED_LAYER_ICON
			}
				
		}	
		//---- Iris 01/09/2009 to improve speed
		//m_gpTemp.Refresh();
		m_gpTemp.AxisLayerIcons = true;
		//----
	}
	///end SET_ICON_COLOR_FOR_SELECTED_LAYERS
	
private:	
	bool _modify_button_event(TreeNode& trGUI)
	{	
		vector<uint> vnRows;
		if(!m_Layerlist.GetSelRows(vnRows))
			return false;	
		TreeNode trEdit = tree_get_node_by_tagname(trGUI, "EditLayer", true);
		if(!trEdit.IsValid())
			return false;
		vector<int> vnAxes(AXIS_TOTAL), vnTitles(AXIS_TOTAL), vnLabels(AXIS_TOTAL);	///Kyle 01/08/2009 v8.0994d QA80-12812 SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
		vector<int> vnMajorTicks(AXIS_TOTAL), vnMinorTicks(AXIS_TOTAL);		///Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
		//vector<int>	vnAxesType(AXIS_TOTAL);								/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
		vector<string> vsFormula(AXIS_TOTAL);
		int nSize = vnRows.GetSize();
		
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
			{
				/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
				vector<int>	vnAxesType;
				/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
				///Kyle 01/08/2009 v8.0994d QA80-12812 SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
				//axis_set_show(layer, AXIS_BOTTOM, trEdit.BottomAxes.AxisShow.nVal);
				//axis_label_set_show(layer, AXIS_BOTTOM, trEdit.BottomAxes.TickLabel.nVal);
				//axis_title_set_show(layer, AXIS_BOTTOM, trEdit.BottomAxes.Title.nVal);
				vector<string> vsNodePrefix = {"Bottom", "Left", "Top", "Right"};
				//vnAxesType.Data(0, AXIS_TOTAL-1);		/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
				for(int nAxisType = 0; nAxisType < AXIS_TOTAL; ++nAxisType)
				{
					string strAxesNodeName = vsNodePrefix[nAxisType] + "Axes";
					TreeNode trAxes = trEdit.GetNode(strAxesNodeName);

					/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
// 					vnAxes[nAxisType] 		= trAxes.AxisShow.nVal;
// 					///Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
// 					vnMajorTicks[nAxisType] = vnMinorTicks[nAxisType] = trAxes.Tick.nVal;
// 					///End ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
// 					vnTitles[nAxisType] 	= trAxes.Title.nVal;
// 					vnLabels[nAxisType] 	= trAxes.TickLabel.nVal;
					BOOL bIsAxisShowUndefined, bIsTickUndefined, bIsTitleUndefined, bIsTickLabelUndefined;
					trAxes.AxisShow.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsAxisShowUndefined);
					trAxes.Tick.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsTickUndefined);
					trAxes.Title.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsTitleUndefined);
					trAxes.TickLabel.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsTickLabelUndefined);

					vnAxes[nAxisType] 		= bIsAxisShowUndefined ? -1 : trAxes.AxisShow.nVal;
					vnMajorTicks[nAxisType] = vnMinorTicks[nAxisType] = bIsTickUndefined ? -1 : trAxes.Tick.nVal;
					vnTitles[nAxisType] 	= bIsTitleUndefined ? -1 : trAxes.Title.nVal;
					vnLabels[nAxisType] 	= bIsTickLabelUndefined ? -1 : trAxes.TickLabel.nVal;
					/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
					
					vsFormula[nAxisType] 	= trAxes.Formula.strVal;
					/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
					BOOL bIsFormulaUndefined;
					trAxes.Formula.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsFormulaUndefined);
					if ( !bIsFormulaUndefined )
						vnAxesType.Add(nAxisType);
					/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
				}
				///Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
				//_gl_smart_show_object(layer, vnAxes, vnLabels, vnTitles);
				/// Iris 01/22/2009 ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
				//_gl_smart_show_object(layer, vnAxes, vnLabels, vnTitles, vnMajorTicks, vnMinorTicks);
				gl_smart_show_object(layer, vnAxes, vnLabels, vnTitles, vnMajorTicks, vnMinorTicks);
				///end ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
				///End ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
				///End SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE

				///Jasmine 08/18/09 GUI_TO_ADD_2ND_NONLINEAR_AXIS
				_get_set_axis_label_formula(layer, vnAxesType, vsFormula, false);
				///End GUI_TO_ADD_2ND_NONLINEAR_AXIS
				
				//if link and set axis 1 to 1, cannot change the scale
				int nParentLayer, nXAxis, nYAxis;
				layer_get_link(layer, nParentLayer, &nXAxis, &nYAxis);
				/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
// 				if( !nXAxis && !is_optional_by_dyna_use_checkbox(trEdit.XScale) )	///Jasmine 04/09/07 ADD_USE_CHECK
// 				{
// 				///Jasmine 01/07/09 v8.0994d QA80-10257 REWRTIE_WITH_APPLY_FORMAT_TO_UNDO
// 					//axis_set_scale_type(layer, "X", xscale);
// 					axis_set_scale_type(layer, "X", trEdit.XScale.nVal, true);
// 				}
// 				if( !nYAxis && !is_optional_by_dyna_use_checkbox(trEdit.YScale) )	///Jasmine 04/09/07 ADD_USE_CHECK
// 				{
// 					//axis_set_scale_type(layer, "Y", yscale);
// 					axis_set_scale_type(layer, "Y", trEdit.YScale.nVal, true);
// 				}
				BOOL bIsXAxisUndefined, bIsYAxisUndefined;
				trEdit.XScale.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsXAxisUndefined);
				trEdit.YScale.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsYAxisUndefined);
				BOOL bCanApplyXAxis = !bIsXAxisUndefined && !is_optional_by_dyna_use_checkbox(trEdit.XScale);
				BOOL bCanApplyYAxis = !bIsYAxisUndefined && !is_optional_by_dyna_use_checkbox(trEdit.YScale);
				if ( bCanApplyXAxis )
				{
					axis_set_scale_type(layer, "X", trEdit.XScale.nVal, true);
				}
				if ( bCanApplyYAxis )
				{
					axis_set_scale_type(layer, "Y", trEdit.YScale.nVal, true);
				}
				/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
				///End REWRTIE_WITH_APPLY_FORMAT_TO_UNDO
			}
		}
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
				
		m_gpTemp.Refresh();
		return true;
	}	
	//----COMBINE_LAYER_LIST_AND_SEL_LIST, on click button
	bool _fill_layer_background_color(TreeNode& trGUI)
	{	
		vector<uint> vnRows;
		m_Layerlist.GetSelRows(vnRows);
		int nSize = vnRows.GetSize();
		if(!nSize)
			return false;
		///Jasmine 06/15/07 MODIFICATION_SET_COLOR_FUNCTION
		//TreeNode trBGColor = tree_get_node_by_tagname(trGUI, "bgColor", true);
		//TreeNode trBorder = tree_get_node_by_tagname(trGUI, "Border", true);
		//if(!trBGColor.IsValid() || !trBorder.IsValid())
		TreeNode trColor = tree_get_node_by_tagname(trGUI, "Color", true);		
		if(!trColor.IsValid())
			return false;
		///Jasmine 06/18/07 QA70-9929 COLOR_1_OFFSET_FROM_DYNA_CNTRL
		int nColor = okutil_ocolor_LT_color_convert(trColor.bgColor.nVal, false);
		//bool bBorder = trBorder.nVal;
		int nFillColor = okutil_ocolor_LT_color_convert(trColor.FillColor.nVal, false);
		int nBorderColor = okutil_ocolor_LT_color_convert(trColor.BorderColor.nVal, false);
		///End COLOR_1_OFFSET_FROM_DYNA_CNTRL
		bool bSetColor = !is_optional_by_dyna_use_checkbox(trColor.bgColor);
		bool bFillColor = !is_optional_by_dyna_use_checkbox(trColor.FillColor);
		bool bBorderColor = !is_optional_by_dyna_use_checkbox(trColor.BorderColor);

		/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		BOOL bIsBGColorUndefined = FALSE;
		BOOL bIsFillColorUndefined = FALSE;
		BOOL bIsBorderColorUndefined = FALSE;
		trColor.bgColor.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsBGColorUndefined);
		trColor.FillColor.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsFillColorUndefined);
		trColor.BorderColor.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsBorderColorUndefined);
		bSetColor &= !bIsBGColorUndefined;
		bFillColor &= !bIsFillColorUndefined;
		bBorderColor &= !bIsBorderColorUndefined;
		if ( !bSetColor && !bFillColor && !bBorderColor )
		{
			return true;
		}
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		
		///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		/*bool 	bBorderWidth = trGUI.BorderWidth.Use;		
		double 	dLeft, dTop, dRight, dBottom;
		if(bBorderWidth)
		{
			dLeft 	= trGUI.BorderWidth.LeftBorder.dVal;
			dTop 	= trGUI.BorderWidth.TopBorder.dVal;
			dRight 	= trGUI.BorderWidth.RightBorder.dVal;
			dBottom = trGUI.BorderWidth.BottomBorder.dVal;
		}*/
		///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
		///Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
		/////Kyle 01/12/2009  v8.0995c QA80-12812 ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE
		//bool bSetBorderStyle = !is_optional_by_dyna_use_checkbox(trColor.BorderStyle);
		//int nBorderStyle = -1;
		//if(bSetBorderStyle)
			//nBorderStyle = trColor.BorderStyle.nVal;
		/////End ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE
		///End BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
		
		BEFORE_UNDO_BLOCK
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
			{
				///Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
				/////Kyle 01/12/2009  v8.0995c QA80-12812 ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE
				//if(bSetBorderStyle)
					//layer.SetBorderStyle(nBorderStyle, 1, true);
				///End BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
				///End ADD_CONTROL_TO_SET_LAYER_BORDER_STYLE
				///Jasmine 01/07/09 v8.0994d QA80-10257 REWRTIE_WITH_APPLY_FORMAT_TO_UNDO
				//fill_layer_background_color(layer, nColor, bBorder);
				//fill_layer_background_color(layer, bSetColor? &nColor:NULL, bFillColor? &nFillColor:NULL, bBorderColor? &nBorderColor:NULL);
				///Kyle 01/13/2009 v8.0995d OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
				//fill_layer_background_color(layer, bSetColor? &nColor:NULL, bFillColor? &nFillColor:NULL, bBorderColor? &nBorderColor:NULL, true);
				///Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
				//fill_layer_background_color(layer, bSetColor? &nColor:NULL, bFillColor? &nFillColor:NULL, bBorderColor && nBorderStyle > 0? &nBorderColor:NULL, true);
				fill_layer_background_color(layer, bSetColor? &nColor:NULL, bFillColor? &nFillColor:NULL, bBorderColor? &nBorderColor:NULL, true);
				///End BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
				///End OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
				///End REWRTIE_WITH_APPLY_FORMAT_TO_UNDO
				
				///Kyle 01/13/2009 v8.0995d OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
				//if(bBorderWidth)
				///Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
				//if(bBorderWidth && nBorderStyle > 0)
				//////Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
				/*if(bBorderWidth)
				///End BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
				///End OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
				{
					///Jasmine 01/07/09 v8.0994d QA80-10257 REWRTIE_WITH_APPLY_FORMAT_TO_UNDO
					//set_layer_border_width(layer, &dLeft, &dTop, &dRight, &dBottom);
					set_layer_border_width(layer, &dLeft, &dTop, &dRight, &dBottom, true);
					///End REWRTIE_WITH_APPLY_FORMAT_TO_UNDO
				}*/
				///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
			}
		}		
		///End MODIFICATION_SET_COLOR_FUNCTION
		AFTER_UNDO_BLOCK
		
		m_gpTemp.Refresh();
		/*
		///Kyle 01/16/2009 UPDATE_GUI_SETTING_AFTER_APPLY_DISPLAY
		if(nSize>0)
		{
			int nIndex = get_layer_index( vnRows[0] );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			if(gl.IsValid())
				UpdateLayerSetting(gl, trColor, true);
		}
		///End UPDATE_GUI_SETTING_AFTER_APPLY_DISPLAY
		*/
		return true;
	}	
	///Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
	bool _set_layer_border_width(TreeNode& trGUI)
	{	
		vector<uint> vnRows;
		m_Layerlist.GetSelRows(vnRows);
		int nSize = vnRows.GetSize();
		if(!nSize)
			return false;
		
		TreeNode trBorder = tree_get_node_by_tagname(trGUI, "BorderWidth", true);		
		if(!trBorder.IsValid())
			return false;

		/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		BOOL bIsLeftBorderUndefined = FALSE;
		BOOL bIsTopBorderUndefined = FALSE;
		BOOL bIsRightBorderUndefined = FALSE;
		BOOL bIsBottomBorderUndefined = FALSE;
		trBorder.LeftBorder.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsLeftBorderUndefined);
		trBorder.TopBorder.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsTopBorderUndefined);
		trBorder.RightBorder.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsRightBorderUndefined);
		trBorder.BottomBorder.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsBottomBorderUndefined);
		if ( bIsLeftBorderUndefined && bIsTopBorderUndefined && bIsRightBorderUndefined && bIsBottomBorderUndefined )
		{
			return true;
		}
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		
		double	dLeft 	= trBorder.LeftBorder.dVal;
		double	dTop 	= trBorder.TopBorder.dVal;
		double	dRight 	= trBorder.RightBorder.dVal;
		double	dBottom = trBorder.BottomBorder.dVal;
		
		BEFORE_UNDO_BLOCK
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
			{
				//set_layer_border_width(layer, &dLeft, &dTop, &dRight, &dBottom, true);
				/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
				/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
				set_layer_border_width(layer, 
					bIsLeftBorderUndefined ? NULL : &dLeft, 
					bIsTopBorderUndefined ? NULL : &dTop, 
					bIsRightBorderUndefined ? NULL : &dRight, 
					bIsBottomBorderUndefined ? NULL : &dBottom, 
					true);
			}
		}		
		
		AFTER_UNDO_BLOCK
		
		m_gpTemp.Refresh();
		/*
		///Kyle 01/16/2009 UPDATE_GUI_SETTING_AFTER_APPLY_DISPLAY
		if(nSize>0)
		{
			int nIndex = get_layer_index( vnRows[0] );
			GraphLayer gl = m_gpTemp.Layers(nIndex);
			if(gl.IsValid())
				UpdateLayerSetting(gl, trBorder, true);
		}
		///End UPDATE_GUI_SETTING_AFTER_APPLY_DISPLAY
		*/
		return true;
	}
	///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
	///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
	void _enable_scale_factor(TreeNode& trFactor, const TreeNode& trScale)
	{
		trFactor.Enable = trScale.nVal == 1;
	}
			
	bool _set_layer_scale_factor(TreeNode& trGUI)
	{
		vector<uint> vnRows;
		m_Layerlist.GetSelRows(vnRows);
		int nSize = vnRows.GetSize();
		if(!nSize)
			return false;
		
		TreeNode trScaleFactor = tree_get_node_by_tagname(trGUI, "ScaleFactor", true);
		if( !trScaleFactor.IsValid() )
			return false;;

		/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		BOOL bIsScaleModeUndefined = FALSE;
		BOOL bIsFixedFactorUndefined = FALSE;
		trScaleFactor.scalemode.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsScaleModeUndefined);
		trScaleFactor.fixfactor.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsFixedFactorUndefined);
		if ( bIsScaleModeUndefined && bIsFixedFactorUndefined )
		{
			return true;
		}
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		
		int 	nMode 	= trScaleFactor.scalemode.nVal;	
		double 	dFactor	= trScaleFactor.fixfactor.dVal;
		if(-1 == nMode)
			return true;

		BEFORE_UNDO_BLOCK
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
			{
				/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
				// Backup the previous values in case they are not specified.
				int nOldMode;
				double dOldFactor;
				bool bRet = layer_get_scale_elements(layer, nOldMode, &dOldFactor);
				if (bIsScaleModeUndefined)
					nMode = nOldMode;
				if (bIsFixedFactorUndefined)
					dFactor = dOldFactor;
				/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
				layer_set_scale_elements(layer, nMode, dFactor, true);	
			}
		}		
		
		AFTER_UNDO_BLOCK
		
		m_gpTemp.Refresh();
			
		return true;
	}
	///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
	bool _add_button_event(TreeNode& trGUI)
	{	
		TreeNode trAdd = tree_get_node_by_tagname(trGUI, "Add", true);
		if(!trAdd.IsValid())
			return false;
				
		int nNewLayer;
		bool bLink;
		
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		int nType = trAdd.LayerType.nVal;
		///Jasmine 05/31/07 #0858 CALL_XF_LAYADD_LEAD_TO_CRASH
		int nLinkTo = trAdd.LinkTo.nVal;// + 1;
		//string strLT;
		//strLT.Format(";layadd graph:=%s type:=%d linkto:=%d", m_gpTemp.GetName(), nType, nLinkTo);
		//m_gpTemp.LT_execute(strLT);
		int bottom, left, top, right, xaxis, yaxis;
		///Jasmine 03/20/09 CENTRAILIZE_ADD_LAYER_CODE_IN_LAYADD_XF_AND_LAYERMANAGEMENT
		//int nUnit = nType? M_LINK : M_PERCENT;
		AddingLayerType _typeObj;
		if( !_typeObj.GetAxisSettings(nType, bottom, left, top, right, bLink, xaxis, yaxis) )
			return false;
		
		int nUnit = M_LINK;
		if(!bLink)
			nLinkTo = -1;
		if(nLinkTo == -1)
			nUnit = M_PERCENT;
		
		///End CENTRAILIZE_ADD_LAYER_CODE_IN_LAYADD_XF_AND_LAYERMANAGEMENT
		if( _typeObj.IsInset(nType) )
		{
			int		nLeft = INSET_LAYER_LEFT;
			int		nTop = INSET_LAYER_TOP;
			int		nWidth = INSET_LAYER_WIDTH;
			int		nHeight = INSET_LAYER_HEIGHT;
			/// Iris 01/06/2009 v8.0993e ADD_LAYER_BY_INSET_OTP_TO_SET_SIZE_ON_AXIS_LABEL
			//nNewLayer = page_add_layer(m_gpTemp, bottom, left, top, right, true, nLinkTo, xaxis, yaxis, &nUnit, &nLeft, &nTop, &nWidth, &nHeight);	
			//nNewLayer = page_add_layer(m_gpTemp, bottom, left, top, right, true, nLinkTo, xaxis, yaxis, &nUnit, &nLeft, &nTop, &nWidth, &nHeight, -1, "inset");	
			nNewLayer = page_add_layer(m_gpTemp, bottom, left, top, right, ADD_LAYER_INIT_SIZE_POS_MOVE_OFFSET, false, nLinkTo, xaxis, yaxis, &nUnit, &nLeft, &nTop, &nWidth, &nHeight, -1, "inset");	
			///end ADD_LAYER_BY_INSET_OTP_TO_SET_SIZE_ON_AXIS_LABEL
			
			if(_typeObj.IsInsetData(nType) && nNewLayer > 0)
			{
				GraphLayer glSource = m_gpTemp.Layers(nLinkTo);
				GraphLayer glNew = m_gpTemp.Layers(nNewLayer);
				if( glSource && glNew )
				{
					foreach(DataPlot dp in glSource.DataPlots)
					{
						glNew.AddPlot(dp);
					}				
					glNew.Rescale();
				}
			}
		}
		else
			nNewLayer = page_add_layer(m_gpTemp, bottom, left, top, right, ADD_LAYER_INIT_SIZE_POS_MOVE_OFFSET, false, nLinkTo, xaxis, yaxis, &nUnit);	
			
		///Jasmine 12/29/08 v8.0991b QA80-12812  SET_SCALE_TYPE_IN_ADDING_NEW_LAYER	
		if(nNewLayer > 0)
		{
			GraphLayer glNew = m_gpTemp.Layers(nNewLayer);
			
			///Jasmine 01/07/09 v8.0994d QA80-10257 REWRTIE_WITH_APPLY_FORMAT_TO_UNDO
			//axis_set_scale_type(glNew, "X", trAdd.XScale.nVal);
			//axis_set_scale_type(glNew, "Y", trAdd.YScale.nVal);
			axis_set_scale_type(glNew, "X", trAdd.XScale.nVal, true);
			axis_set_scale_type(glNew, "Y", trAdd.YScale.nVal, true);
			///End REWRTIE_WITH_APPLY_FORMAT_TO_UNDO
		///End SET_SCALE_TYPE_IN_ADDING_NEW_LAYER
			
			///Jasmine 03/23/09 SET_LAYER_NAME_WITH_ADDING_TYPE
			string strName;
			if( !glNew.GetName(strName) )
			{
				strName = _typeObj.GetAddingName(nType);
				glNew.SetName(strName, OCD_ENUM_NEXT);
			}
			///End SET_LAYER_NAME_WITH_ADDING_TYPE
		
			///Jasmine 10/25/2011 ORG-4217-S1 SEL_NEWLY_CREATED_LAYER_FOR_FURTHER_EDIT
			//page_set_active_layer(m_gpTemp, nNewLayer, false);	///Jasmine 03/24/09 KEEP_CURRENT_LAYER_SELECTED_AFTER_NEW_LAYER_ADD
			page_set_active_layer(m_gpTemp, nNewLayer, false);
			///End SEL_NEWLY_CREATED_LAYER_FOR_FURTHER_EDIT
		}
		///End CALL_XF_LAYADD_LEAD_TO_CRASH
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		
		if(nNewLayer <= 0)
			return error_report("Add Layer Fail!");
		
		m_gpTemp.Refresh();
		
		///Jasmine 10/25/2011 ORG-4217-S1 SEL_NEWLY_CREATED_LAYER_FOR_FURTHER_EDIT
		//OnLayersNumberChange();//OnLayersNumberChange(false, SEL_LAST_ROW);///Jasmine 03/24/09 KEEP_CURRENT_LAYER_SELECTED_AFTER_NEW_LAYER_ADD		
		if(bLink)
			m_bUpdateLinkTo = false;
		
		OnLayersNumberChange(false, SEL_LAST_ROW);
		
		m_bUpdateLinkTo = true;
		///End SEL_NEWLY_CREATED_LAYER_FOR_FURTHER_EDIT
		return true;
	}	
	///Jasmine 01/13/11 ORG-1084 KEEP_POSITION_ORDER_IN_ARRANGEMENT
	static void _reorder_layers_in_position_order(const GraphPage& gp, vector<int>& vnLayers)
	{
		vector vXPos, vYPos;
		for(int ii = 0; ii < vnLayers.GetSize(); ii++)
		{
			GraphLayer gl = gp.Layers( vnLayers[ii] );
		
			double dPos[TOTAL_POS];
			int nCurrentUnit = gl.GetPosition(dPos);
			if(nCurrentUnit != M_PERCENT)
				gl.UnitsConvert(M_PERCENT, dPos);
			
			vXPos.Add( dPos[LEFT_POS] );
			vYPos.Add( dPos[TOP_POS] );
		}
		
		vector vCombine;
		vCombine = nint(vYPos*100) * 1000 + vXPos;
		
		vector<uint> vIndex;	
		vCombine.Sort(SORT_ASCENDING, TRUE, vIndex, TRUE);
		vnLayers.Reorder(vIndex);
	}
	///End KEEP_POSITION_ORDER_IN_ARRANGEMENT
	int _arrange_button_event(TreeNode& trGUI)
	{
		TreeNode trArrange = tree_get_node_by_tagname(trGUI, "Arrange", true);
		TreeNode trMargins = tree_get_node_by_tagname(trGUI, "Margins", true);
		if(!trArrange.IsValid() || !trMargins.IsValid())
			return -1;
		int nColNum = trArrange.Col.nVal, nRowNum = trArrange.Row.nVal;
		///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		//int nMode = trArrange.scalemode.nVal - 1;	
		//double dFactor = trArrange.fixfactor.dVal;
		///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		bool bArrangeChild 		= true;						///Jasmine 02/12/11 ORG-695 ARRANGE_OUTSIDE_CHILD_LAYER
		bool bArrangeSelection 	= trArrange.ArrangeSelection.nVal;
		bool bAddNew 			= trArrange.AddNew.nVal;
		bool bKeepRatio 		= trArrange.KeepRatio.nVal;
		bool bPositionOrder 	= trArrange.PositionOrder.nVal;		///Jasmine 01/13/11 ORG-1084 KEEP_POSITION_ORDER_IN_ARRANGEMENT
		stLayersGridFormat 	stFormat;
		stFormat.nXGap = trMargins.XGap.nVal;		
		stFormat.nYGap = trMargins.YGap.nVal;				
		stFormat.nLeftMg = trMargins.LeftMargin.nVal;	
		stFormat.nRightMg = trMargins.RightMargin.nVal;		
		stFormat.nTopMg = trMargins.TopMargin.nVal;		
		stFormat.nBottomMg = trMargins.BottomMargin.nVal;	
		
		///Jasmine 02/11/09 SHARE_ERR_MSG_WITH_MERGE_GRAPH		
		int nErr = CER_NO_ERROR;
		arrange_layer_check_spacing(nRowNum, nColNum, stFormat, nErr);
		/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
		//if(	m_vnCurrentErrMsg[LAYERTOOL_EDIT_TAB] != nErr);			
		{
			m_vnCurrentErrMsg[LAYERTOOL_EDIT_TAB] = nErr;
			showInfoMsg();
		}
		///end LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
			
		if(nErr != CER_NO_ERROR)
			return -1;
		///End SHARE_ERR_MSG_WITH_MERGE_GRAPH
		
		///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY
		vector<uint> vnRows;
		vector<int> vnSel;
		if(bArrangeSelection)
		{
			m_Layerlist.GetSelRows(vnRows);
			int nSize = vnRows.GetSize();
			if(!nSize)
				return -1;
			for(int ii = 0; ii < nSize; ii++)
			{
				int nIndex = get_layer_index( vnRows[ii] );
				vnSel.Add(nIndex);
			}
		}
		///End ARRANGE_SELECTION_ONLY
		
		int nLayers = nRowNum*nColNum, nNewNum = 0;
		///Jasmine 02/12/11 ORG-695 ARRANGE_OUTSIDE_CHILD_LAYER
		int nLayerNum = bArrangeSelection? _get_layer_count(m_gpTemp, vnSel, bArrangeChild) : _get_layer_count(m_gpTemp, NULL, bArrangeChild);	///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY
		///End ARRANGE_OUTSIDE_CHILD_LAYER
		
		///Jasmine 01/13/11 ORG-1084 KEEP_POSITION_ORDER_IN_ARRANGEMENT
		if(bPositionOrder)
		{
			if(!bArrangeSelection)
				vnSel.Data( 0, m_gpTemp.Layers.Count()-1 );
			
			_reorder_layers_in_position_order(m_gpTemp, vnSel);				
		}
		///End KEEP_POSITION_ORDER_IN_ARRANGEMENT
		
		//add new
		if(bAddNew && nLayerNum < nLayers)//not enough
		{
			nNewNum = nLayers - nLayerNum;
			for(int index=0; index<nNewNum && !_beyond_layer_max_num(m_gpTemp, GetSafeHwnd()); index++) 
			{
				int nn = m_gpTemp.AddLayer("", CREATE_UNDOABLE);	///Jasmine 03/15/07 ADD_UNDO_BUTTON
				if(bArrangeSelection)	///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY
					vnSel.Add(nn);
			}
		}
		///Jasmine 02/12/11 ORG-695 ARRANGE_OUTSIDE_CHILD_LAYER
		int nTemp = bArrangeSelection? _get_layer_count(m_gpTemp, vnSel, bArrangeChild) : _get_layer_count(m_gpTemp, NULL, bArrangeChild);
		bAddNew = (nTemp > nLayerNum);///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY
		///End ARRANGE_OUTSIDE_CHILD_LAYER
		
		///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		//vector vdRatios, vdFixFactor;
		//if(bKeepRatio || -1 == nMode)
		vector vdRatios;
		if(bKeepRatio)
		///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		{
			foreach(GraphLayer gl in m_gpTemp.Layers)
			{
				///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY
				if(bArrangeSelection)
				{
					vector<uint> vecIndex;
					if(1 > vnSel.Find(vecIndex, gl.GetIndex()))//not in selection
						continue;
				}
				///End ARRANGE_SELECTION_ONLY
				if(bKeepRatio)
				{
					double dRatio = layer_get_ratio(gl);
					vdRatios.Add(dRatio);
				}
				///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
				//if(-1 == nMode)//get orignal scale elements
				//{
					//int nScaleMode;
					//layer_get_scale_elements(gl, nScaleMode, &dFactor);
					//if(!nScaleMode) dFactor = NANUM;
					//vdFixFactor.Add(dFactor);
				//}
				///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
			}
		}
		
		TreeNode trLinkTo = tree_get_node_by_tagname(trGUI, "LinkArrange", true);
		bool bLinkToFirstLayer = trLinkTo && trLinkTo.nVal; 
		
		TreeNode trSmart = tree_get_node_by_tagname(trArrange, "SmartArrange", true);
		bool bSmartObject = trSmart && trSmart.nVal;
		
		
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		/// Iris 01/22/2009 ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
		/*
		page_arrange_layers(m_gpTemp, nRowNum, nColNum, &stFormat, false, true, vnSel, true);	///Jasmine 05/17/07 MOVE_OUT_PORTRAIT_OPTION
		
		///Kyle 01/08/2009 v8.0994d QA80-12812 SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
		TreeNode trSmart = tree_get_node_by_tagname(trArrange, "SmartArrange", true);
		if(trSmart && trSmart.nVal)
			_gp_smart_show_object(m_gpTemp, nRowNum, nColNum, vnSel, stFormat.nXGap, stFormat.nYGap, SA_SHOW_INNER_AXIS);
		///End SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
		*/
		
		///Jasmine 01/22/09 REARRANGE_OUTER_CHILD_LAYER
		//page_arrange_layers(m_gpTemp, nRowNum, nColNum, &stFormat, false, true, vnSel, bLinkToFirstLayer, bSmartObject, SA_SHOW_INNER_AXIS, true);
		//bool bArrangeChild = false;	///Jasmine 02/12/11 ORG-695 ARRANGE_OUTSIDE_CHILD_LAYER
		page_arrange_layers(m_gpTemp, nRowNum, nColNum, &stFormat, false, true, vnSel, bLinkToFirstLayer, bArrangeChild, bSmartObject, SA_SHOW_INNER_AXIS, true);
		///End REARRANGE_OUTER_CHILD_LAYER
		///end ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH

		int ii;
		//int nSize = vdFixFactor.GetSize();	///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
		foreach(GraphLayer gl in m_gpTemp.Layers)
		{
			///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY
			if(bArrangeSelection)
			{
				vector<uint> vecIndex;
				int nIndex = gl.GetIndex();
				if(1 > vnSel.Find(vecIndex, nIndex))//not in selection
					continue;
			}
			///End ARRANGE_SELECTION_ONLY
			if(bKeepRatio)
				layer_set_ratio(gl, vdRatios[ii]);
			
			///Jasmine 08/06/09 QA81-14084 SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
			//int nScaleMode = nMode;//convert gui value
			//double dFixFactor = dFactor;
			//if(-1 == nMode)
			//{
				//nScaleMode = 0;
				//if(ii < nSize)
				//{
					//dFixFactor = vdFixFactor[ii];
					//nScaleMode = !is_missing_value(dFixFactor);//dFixFactor = NANUM means nMode should be 0
				//}				
			//}
			//layer_set_scale_elements(gl, nScaleMode, dFixFactor, true);	///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
			///End SEPARATE_SCALE_FACTOR_TO_DISPLAY_TAB
			
			/// Iris 01/22/2009 ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
			/*
			/// Iris 01/15/2009 LINK_TO_FIRST_LAYER_WHEN_ARRANGE
			TreeNode trLinkTo = tree_get_node_by_tagname(trGUI, "LinkArrange", true);
			bool bLinkToFirstLayer = trLinkTo && trLinkTo.nVal; 
			if(bLinkToFirstLayer)
			{
				int nParentLayer = get_linked_parent_layer(gl);
				int nLinkTo = bArrangeSelection && 0 != vnSel.GetSize()? vnSel[0] : 0;
				
				vector<uint> vn;
				if( nParentLayer < 0 // no link to 
					//---Jasmine 01/15/09 MAX_ASK_NOT_CHANGE_OLD_LINK_RELATIONSHIP_EVEN_UNIT_NOT_PECENT_OF_LINK_LAYER
					//|| nParentLayer >= 0 && M_LINK != gl.GetPosition() // linked but uint is not M_LINK
					//|| nParentLayer >= 0 && bArrangeSelection && vnSel.Find(MATREPL_TEST_EQUAL, nParentLayer, vn) <= 0 // linked but link to layer not in selected layer list
					//---
					)
				{
					if( nLinkTo != gl.GetIndex() ) 
					{
						int nLinkUint = M_LINK;
						layer_set_link(gl, nLinkTo, 0, 0, &nLinkUint);
					}
				}
			}
			///end LINK_TO_FIRST_LAYER_WHEN_ARRANGE
			*/
			///end ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
			
			ii++;			
		}
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		///Jasmine 09/15/09 QA81-14321 SAVE_SPACING_SETTING_FOR_ARRANGEMENT
		saveSpacingSettings();
		///End SAVE_SPACING_SETTING_FOR_ARRANGEMENT
		m_gpTemp.Refresh();
		/// Iris 01/15/2009 LINK_TO_FIRST_LAYER_WHEN_ARRANGE
		//if(bAddNew)
		if(bAddNew || bLinkToFirstLayer)
		///End LINK_TO_FIRST_LAYER_WHEN_ARRANGE
		{
			OnLayersNumberChange(true, SEL_ROW_UNASSIGNED, false);	///Jasmine 01/22/09 REARRANGE_OUTER_CHILD_LAYER	
			onLayerLinkChange();		///Kyle 01/21/2009 ON_LAYER_LINK_CHANGE
		}
		else
		{
			///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
			vector<uint> vnRows;
			if(m_Layerlist.GetSelRows(vnRows) && vnRows.GetSize() > 0)
			{
				int nIndex = get_layer_index( vnRows[0] );
				GraphLayer glCurrent = m_gpTemp.Layers(nIndex);
				if(glCurrent)
				{
					vector<string> vsUpdateBranch = {UPDATE_LAYER_SETTING_RESIZE, UPDATE_LAYER_SETTING_MOVE};
					if(bLinkToFirstLayer)
						vsUpdateBranch.Add(UPDATE_LAYER_SETTING_LINK);
					if(bSmartObject)
						vsUpdateBranch.Add(UPDATE_LAYER_SETTING_EDITLAYER);
					UpdateLayerSetting(glCurrent, trGUI, false, vsUpdateBranch);
				}
			}
			///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		}
			
		return bAddNew;
	}
	bool _resize_button_event(TreeNode& trGUI)
	{	
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		TreeNode trResize = tree_get_node_by_tagname(trGUI, "Resize", true);
		if(!trResize)
			return false;
		
		//TreeNode trUnits = tree_get_node_by_tagname(trGUI, "Units", true);
		//TreeNode trRef = tree_get_node_by_tagname(trGUI, "RefLayer", true);
		TreeNode trRefLayer = trGUI.Resize.RefLayer;
		TreeNode trUnits 	= trGUI.Resize.Units;
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		if(!trRefLayer.IsValid() || !trUnits.IsValid())
			return false;
			
		vector<uint> vnRows;
		if(!m_Layerlist.GetSelRows(vnRows))
			return false;	
			
		int 	nSize = vnRows.GetSize();
		int 	nUnit = trUnits.nVal;
		double 	width = trResize.Width.dVal;
		double	height= trResize.Height.dVal;	
		
		///Jasmine 04/09/07 ADD_USE_CHECK		
		bool bSetWidth = !is_optional_by_dyna_use_checkbox(trResize.Width);
		bool bSetHeight = !is_optional_by_dyna_use_checkbox(trResize.Height);
		if(!bSetWidth && !bSetHeight)
			return true;
		///End ADD_USE_CHECK
		/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		BOOL bIsWidthUndefined = FALSE;
		BOOL bIsHeightUndefined = FALSE;
		if ( !canApplyResize(trGUI, bIsWidthUndefined, bIsHeightUndefined) )
		{
			return true;
		}
		bSetWidth &= !bIsWidthUndefined;
		bSetHeight &= !bIsHeightUndefined;
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		bool bRef;
		int nRef = trRefLayer.nVal;
		///Jasmine 03/23/07 ADD_UNIT_PERCENT_OF_REF_LAYER
		if(M_LINK == nUnit)
		{
			if(width <= 0 || height <= 0)
				return false;
			double dRefPos[TOTAL_POS];
			GraphLayer glRef = m_gpTemp.Layers(nRef);
			if(glRef && M_INCH != glRef.GetPosition(dRefPos)) 
				glRef.UnitsConvert(M_INCH, dRefPos);
			width = width*dRefPos[WIDTH_POS]/100;
			height = height*dRefPos[HEIGHT_POS]/100;
			nUnit = M_INCH;			
		}
		///End ADD_UNIT_PERCENT_OF_REF_LAYER
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			if(!bRef && nRef == nIndex)
				bRef = true;
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
			{	///Jasmine 03/06/07 QA70-9433 CONVERT_LAYER_UNITS
				double dPos[TOTAL_POS];
				int nMyUnit = layer.GetPosition(dPos);
				//set new size
				dPos[WIDTH_POS] = width;
				dPos[HEIGHT_POS] = height;
				//change to current unit
				layer.UnitsConvert(nMyUnit, dPos, nUnit);
				///Jasmine 04/09/07 ADD_USE_CHECK	
				if(bSetWidth && bSetHeight)
					layer_set_size(layer, dPos[WIDTH_POS], dPos[HEIGHT_POS]);
				else if(bSetWidth)
					layer_set_width(layer, dPos[WIDTH_POS]);
				else 
					layer_set_height(layer, dPos[HEIGHT_POS]);
				///End ADD_USE_CHECK
			}	///End CONVERT_LAYER_UNITS
		}
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		m_gpTemp.Refresh();
		//if(bRef)	///Jasmine 04/03/07 it seems no need to update the settings about RefLayer here, as the setting haven't changed
			//OnRefLayerChange();
		return true;
	}
	bool _move_button_event(TreeNode& trGUI)
	{
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		TreeNode trMove = tree_get_node_by_tagname(trGUI, "Move", true);
		if(!trMove)
			return false;
		
		//TreeNode trUnits = tree_get_node_by_tagname(trGUI, "Units", true);
		//TreeNode trRef = tree_get_node_by_tagname(trGUI, "RefLayer", true);
		TreeNode trRefLayer = trGUI.Move.RefLayer;
		TreeNode trUnits 	= trGUI.Move.Units;
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		if(!trRefLayer.IsValid() || !trUnits.IsValid())
			return false;
		
		vector<uint> vnRows;
		if(!m_Layerlist.GetSelRows(vnRows))
			return false;	
			
		int 	nSize = vnRows.GetSize();
		int 	nUnit = trUnits.nVal;
		double 	left = trMove.Left.dVal;
		double	top = trMove.Top.dVal;
		
		///Jasmine 04/09/07 ADD_USE_CHECK		
		bool bSetLeft = !is_optional_by_dyna_use_checkbox(trMove.Left);
		bool bSetTop = !is_optional_by_dyna_use_checkbox(trMove.Top);
		if(!bSetLeft && !bSetTop)
			return true;
		///End ADD_USE_CHECK
		/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		BOOL bIsLeftUndefined = FALSE;
		BOOL bIsTopUndefined = FALSE;
		if ( !canApplyMove(trGUI, bIsLeftUndefined, bIsTopUndefined) )
		{
			return true;
		}
		bSetLeft &= !bIsLeftUndefined;
		bSetTop &= !bIsTopUndefined;
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		bool bRef;
		int nRef = trRefLayer.nVal;
		///Jasmine 03/23/07 ADD_UNIT_PERCENT_OF_REF_LAYER
		if(M_LINK == nUnit)
		{
			double dRefPos[TOTAL_POS];
			GraphLayer glRef = m_gpTemp.Layers(nRef);
			if(glRef && M_INCH != glRef.GetPosition(dRefPos)) 
				glRef.UnitsConvert(M_INCH, dRefPos);
			left = left*dRefPos[WIDTH_POS]/100 + dRefPos[LEFT_POS];
			top = top*dRefPos[HEIGHT_POS]/100 + dRefPos[TOP_POS];
			nUnit = M_INCH;			
		}
		///End ADD_UNIT_PERCENT_OF_REF_LAYER
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			if(!bRef && nRef == nIndex)
				bRef = true;
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
			{	///Jasmine 03/06/07 QA70-9433 CONVERT_LAYER_UNITS
				double dPos[TOTAL_POS];
				int nMyUnit = layer.GetPosition(dPos);
				//set new position
				dPos[LEFT_POS] = left;
				dPos[TOP_POS] = top;
				//change to current unit
				layer.UnitsConvert(nMyUnit, dPos, nUnit);
				///Jasmine 04/09/07 ADD_USE_CHECK		
				if(bSetLeft && bSetTop)
					layer_set_position(layer, dPos[LEFT_POS], dPos[TOP_POS]);
				else if(bSetLeft)
					layer_set_left(layer, dPos[LEFT_POS]);
				else
					layer_set_top(layer, dPos[TOP_POS]);
			}	///End CONVERT_LAYER_UNITS
		}
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		m_gpTemp.Refresh();
		//if(bRef)	///Jasmine 04/03/07 it seems no need to update the settings about RefLayer here, as the setting haven't changed
			//OnRefLayerChange();
		return true;
	}
	bool _swap_button_event(TreeNode& trGUI)
	{	
		double left1, top1, left2, top2;
		int unit1, unit2, nLayerA, nLayerB;
		TreeNode trLayerA = tree_get_node_by_tagname(trGUI, "LayerA", true);
		TreeNode trLayerB = tree_get_node_by_tagname(trGUI, "LayerB", true);
		if(!trLayerA.IsValid() || !trLayerB.IsValid())
			return false;
		
		nLayerA = trLayerA.nVal;
		nLayerB = trLayerB.nVal;
		//if(nLayerA == nLayerB)	///Jasmine 12/08/08 v8.0983 SWAP_LAYERS_SHOULD_HAVE_TWO_DIFF_INIT_VALUE
		if(-1 == nLayerA || -1 == nLayerB || nLayerA == nLayerB)	
			return true;
		
		if(nLayerA > nLayerB)
		{//set low index first
			int nTemp = nLayerA;
			nLayerA = nLayerB;
			nLayerB = nTemp;
		}
		
		GraphLayer layerA = m_gpTemp.Layers(nLayerA);
		GraphLayer layerB = m_gpTemp.Layers(nLayerB);
		if(!layerA.IsValid() || !layerB.IsValid())
			return false;
			
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON

			///Jasmine 03/06/07 QA70-9433 CONVERT_LAYER_UNITS
			layer_swap_position(layerA, layerB);
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		m_gpTemp.Refresh();
		
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		/*
		TreeNode trRefLayer = tree_get_node_by_tagname(trGUI, "RefLayer", true);
		if(trRefLayer.nVal == nLayerA || trRefLayer.nVal == nLayerB)
			OnRefLayerChange();
		*/
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		
		///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		vector<uint> vnRows;
		if(m_Layerlist.GetSelRows(vnRows) && vnRows.GetSize() > 0)
		{
			int nIndex = get_layer_index( vnRows[0] );
			GraphLayer glCurrent = m_gpTemp.Layers(nIndex);
			if(glCurrent)
			{
				vector<string> vsUpdateBranch = {UPDATE_LAYER_SETTING_MOVE};
				UpdateLayerSetting(glCurrent, trGUI, false, vsUpdateBranch);
			}
		}
		///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		return true;
	}
	bool _align_button_event(TreeNode& trGUI)
	{
		///Jasmine 12/24/08 v8.0990c QA80-12812  MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		TreeNode trAlign = tree_get_node_by_tagname(trGUI, "Align", true);
		if(!trAlign.IsValid())
			return false;
		//TreeNode trRef = tree_get_node_by_tagname(trGUI, "RefLayer", true);
		TreeNode trRefLayer = trAlign.RefLayer;
		if(!trRefLayer.IsValid())
			return false;
		///End MOVE_REFLAYER_AND_UNIT_IN_SUB_BRANCH
		
		vector<uint> vnRows;
		if(!m_Layerlist.GetSelRows(vnRows))
			return false;	
		vnRows.Sort();//set low index first
		
		int nSize 		= vnRows.GetSize();
		if(nSize <= 0)
			return false;
		
		int nRef 		= trRefLayer.nVal;
		GraphLayer glRef = m_gpTemp.Layers(nRef);
		if(!glRef.IsValid())
			return false;
		
		int nDirection 	= trAlign.Direction.nVal;
		if(nDirection < 0)
			return false;
		
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
				layer_aligns(glRef, layer, nDirection);
		}
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		m_gpTemp.Refresh();
		///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		if(m_Layerlist.GetSelRows(vnRows) && vnRows.GetSize() > 0)
		{
			int nIndex = get_layer_index( vnRows[0] );
			GraphLayer glCurrent = m_gpTemp.Layers(nIndex);
			if(glCurrent)
			{
				vector<string> vsUpdateBranch = {UPDATE_LAYER_SETTING_MOVE};
				UpdateLayerSetting(glCurrent, trGUI, false, vsUpdateBranch);
			}
		}
		///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		return true;
	}
	
	/// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
	///Jasmine 01/16/09 CHANGE_UNIT_ONLY_ON_LINKTO_NODE_CHANGE
	//static bool _on_change_link_to(TreeNode& trGUI)
	static bool _on_change_link_to(TreeNode& trGUI, int nNodeID = -1)
	///End CHANGE_UNIT_ONLY_ON_LINKTO_NODE_CHANGE
	{		
		TreeNode trLink = trGUI.Link;		
		int nLinkTo = trLink.Parent.nVal;
		
		trLink.XAxes.Enable = -1 != nLinkTo;
		trLink.YAxes.Enable = -1 != nLinkTo;
		
		bool bEnable;
		bEnable = trLink.XAxes.Enable && trLink.XAxes.Use == 2;
		trLink.XAxes.X1.Enable = bEnable;
		trLink.XAxes.X2.Enable = bEnable;
		
		bEnable = trLink.YAxes.Enable && trLink.YAxes.Use == 2;
		trLink.YAxes.Y1.Enable = bEnable;
		trLink.YAxes.Y2.Enable = bEnable;
		
		trLink.Unit.Enable = -1 != nLinkTo;
		///Jasmine 01/15/09 SET_DEFAULT_UNIT_TO_PECENT_OF_LINK_LAYER
		///Jasmine 01/16/09 CHANGE_UNIT_ONLY_ON_LINKTO_NODE_CHANGE
		//if(-1 != nLinkTo)
		if(LM_LINK_PARENT_ID == nNodeID && -1 != nLinkTo)
		///End CHANGE_UNIT_ONLY_ON_LINKTO_NODE_CHANGE
		{
			trLink.Unit.nVal = M_LINK;
		}
		///End SET_DEFAULT_UNIT_TO_PECENT_OF_LINK_LAYER
		return true;
	}
	///end CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
	
	bool _link_button_event(TreeNode& trGUI)
	{
		vector<uint> vnRows;
		if(!m_Layerlist.GetSelRows(vnRows))
			return false;	
		int nSize = vnRows.GetSize(), nRef, XAxes, YAxes, nUnit;
		TreeNode trRef = tree_get_node_by_tagname(trGUI, "Parent", true);
		if(!trRef.IsValid())
			return false;
		nRef = trRef.nVal;
		TreeNode trLink = tree_get_node_by_tagname(trGUI, "Link", true);
		if(!trLink.IsValid())
			return false;
		XAxes = trLink.XAxes.Use;
		YAxes = trLink.YAxes.Use;
		nUnit = trLink.Unit.nVal;
		string strX1 = trLink.XAxes.X1.strVal;
		string strX2 = trLink.XAxes.X2.strVal;
		string strY1 = trLink.YAxes.Y1.strVal;
		string strY2 = trLink.YAxes.Y2.strVal;

		/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		BOOL bIsLinkToUndefined = FALSE;
		BOOL bIsXAxisUndefined = FALSE;
		BOOL bIsX1Undefined = FALSE;
		BOOL bIsX2Undefined = FALSE;
		BOOL bIsYAxisUndefined = FALSE;
		BOOL bIsY1Undefined = FALSE;
		BOOL bIsY2Undefined = FALSE;
		BOOL bIsUnitsUndefined = FALSE;
		trLink.Parent.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsLinkToUndefined);
		trLink.XAxes.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsXAxisUndefined);
		trLink.XAxes.X1.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsX1Undefined);
		trLink.XAxes.X2.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsX2Undefined);
		trLink.YAxes.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsLinkToUndefined);
		trLink.YAxes.Y1.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsY1Undefined);
		trLink.YAxes.Y2.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsY2Undefined);
		trLink.Unit.GetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, bIsUnitsUndefined);
		bool bIsXAxisAllUndefined = bIsXAxisUndefined || (bIsX1Undefined && bIsX2Undefined);
		bool bIsYAxisAllUndefined = bIsYAxisUndefined || (bIsY1Undefined && bIsY2Undefined);
		bool bCanApply = !( bIsUnitsUndefined || (bIsLinkToUndefined && bIsXAxisAllUndefined && bIsYAxisAllUndefined) );
		if ( !bCanApply )
		{
			return true;
		}
		/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
		
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
			{
				/// Kenny 08/10/2009 QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
				// We can NOT change the related properties if it is undefined in the GUI.
				// To do this, we have to backup the previous value first.
				int nParentLayer, nCurXAxis, nCurYAxis, nCurUnit;
				string strCurX1, strCurX2, strCurY1, strCurY2;
				bool bRet = layer_get_link(layer, nParentLayer, &nCurXAxis, &nCurYAxis, &nCurUnit, &strCurX1, &strCurX2, &strCurY1, &strCurY2);
				if ( bIsLinkToUndefined )
					nRef = nParentLayer;
				if ( bIsXAxisUndefined )
					XAxes = nCurXAxis;
				if ( bIsYAxisUndefined )
					YAxes = nCurYAxis;
				if ( bIsUnitsUndefined )
					nUnit = nCurUnit;
				if ( bIsX1Undefined )
					strX1 = strCurX1;
				if ( bIsX2Undefined )
					strX2 = strCurX2;
				if ( bIsY1Undefined )
					strY1 = strCurY1;
				if ( bIsY2Undefined )
					strY2 = strCurY2;
				/// End QA80-14100 USE_UNDEFINED_STATUS_FOR_UNCOMMON_PROPERTIES
				layer_set_link(layer, nRef, XAxes, YAxes, &nUnit, strX1, strX2, strY1, strY2);
			}
		}
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		m_gpTemp.Refresh();
		///Jasmine 04/01/09 UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		if(m_Layerlist.GetSelRows(vnRows) && vnRows.GetSize() > 0)
		{
			int nIndex = get_layer_index( vnRows[0] );
			GraphLayer glCurrent = m_gpTemp.Layers(nIndex);
			if(glCurrent)
			{
				vector<string> vsUpdateBranch = {UPDATE_LAYER_SETTING_RESIZE, UPDATE_LAYER_SETTING_MOVE};
				UpdateLayerSetting(glCurrent, trGUI, false, vsUpdateBranch);
			}
		}
		///End UPDATE_LAYER_SETTING_SPECIFIED_BRANCH
		OnLayersNumberChange();
		return true;
	}
	/// Iris 01/09/2009 CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
	/*
	bool _dislink_button_event(TreeNode& trGUI)
	{
		vector<uint> vnRows;
		if(!m_Layerlist.GetSelRows(vnRows))
			return false;	
		int nSize = vnRows.GetSize();
		
		BEFORE_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		GraphLayer layer;
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = get_layer_index( vnRows[ii] );
			layer = m_gpTemp.Layers(nIndex);
			if(layer.IsValid())
				layer_set_link(layer, -1);
		}
		
		AFTER_UNDO_BLOCK	///Jasmine 03/15/07 ADD_UNDO_BUTTON
		
		m_gpTemp.Refresh();
		OnLayersNumberChange();
		return true;
	}
	*/
	///end CHANGE_LINK_UNLINK_BUTTON_TO_APPLY_BUTTON
	//----end
	string get_layer_index_str(int nRow)
	{
		return m_Layerlist.GetCell(nRow, LAYER_LIST_INDEX_COL);
	}
	int get_layer_index(int nRow)
	{
		return atoi( get_layer_index_str(nRow) ) - 1;//gui has 1 offset
	}
private:
	TreeEditControl		m_Layerlist;
	//GridListControl		m_Selectlist;
	TabControl			m_tab;
	GraphPage			m_gpTemp;
	vector<string>		m_vsLayerNames;
	string				m_strOldValue;
	string				m_strGraph;
	string				m_strLayerList;//layer index list
	bool				m_bUpdateLinkTo;		///Jasmine 10/25/2011 ORG-4217-S1 SEL_NEWLY_CREATED_LAYER_FOR_FURTHER_EDIT
	int					m_nUndoStackCount;	///Jasmine 03/31/07 SUPPORT_MULTI_STEP_UNDO
	int					m_nSelRow;
	int					m_nActive;
	int 				m_nMinWidth;		///Jasmine 12/24/08 v8.0990c QA80-12812  ADD_INFO_FOR_USER_FRIENDLY
	int					m_nCurrentInfo;		///Jasmine 12/31/08 v8.0992c QA80-12812 SHOW_CORRESPONGDING_HINTS_BY_CURSOR_POSITION
	vector<int>			m_vnCurrentErrMsg;	/// Iris 2/05/2009 QA80-13064 LM_NEED_ERR_MSG_WHEN_ARRANGE_FAILED
	
	stPageSetting		m_stPageSetting;		///Jasmine 12/08/08 v8.0983 QA80-12464 KEEP_PREVIEW_RESULT_SOURCE_GRAPHS_CONSISTENT
};

/// Iris 01/22/2009 ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH
/*
///Kyle 01/08/2009 v8.0994d QA80-12812 SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
//	0: 	hide
//	1: 	show
//	-1:	not change
///Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
///static void _gl_smart_show_object(GraphLayer& gl, const vector<int>& vnTicks, const vector<int>& vnLabels, const vector<int>& vnTitles, bool bRepaint = false)
static void _gl_smart_show_object(GraphLayer& gl, const vector<int>& vnAxes, const vector<int>& vnLabels, const vector<int>& vnTitles, const vector<int>& vnMajorTicks = NULL, const vector<int>& vnMinorTicks = NULL, bool bRepaint = false)
///End ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
{
	ASSERT(4 == vnAxes.GetSize() && 4 == vnLabels.GetSize() && 4 == vnTitles.GetSize());
	///Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
	ASSERT(!vnMajorTicks || 4 == vnMajorTicks.GetSize());
	ASSERT(!vnMinorTicks || 4 == vnMinorTicks.GetSize());
	///End ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
	if(!gl)
		return;

	Tree tr;
	tr = gl.GetFormat(FPB_ALL, FOB_AXIS_TICKS | FOB_AXIS_LABELS | FOB_LABELS, true, true);
	TreeNode trAxes = tr.Root.Axes;
	if(!trAxes)
	{
		ASSERT(false);
		return;
	}

	TreeNode trTicks, trLabels, trTitle, trShow, trColor;
	for(int ii=0; ii<4; ii++)
	{
		string strDefaultTitle;
		switch(ii)
		{
		case AXIS_BOTTOM:
			trTicks = tree_get_node_by_tagname(trAxes, "BottomTicks", true);
			trLabels = tree_get_node_by_tagname(trAxes, "BottomLabels", true);
			trTitle = tree_get_node_by_tagname(trAxes, "BottomTitle", true);
			strDefaultTitle = STR_X_DEFAULT_TITLE;		///Kyle 01/22/2009 SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY
			break;
		
		case AXIS_LEFT:
			trTicks = tree_get_node_by_tagname(trAxes, "LeftTicks", true);
			trLabels = tree_get_node_by_tagname(trAxes, "LeftLabels", true);
			trTitle = tree_get_node_by_tagname(trAxes, "LeftTitle", true);
			strDefaultTitle = STR_Y_DEFAULT_TITLE;		///Kyle 01/22/2009 SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY
			break;
			
		case AXIS_TOP:
			trTicks = tree_get_node_by_tagname(trAxes, "TopTicks", true);
			trLabels = tree_get_node_by_tagname(trAxes, "TopLabels", true);
			trTitle = tree_get_node_by_tagname(trAxes, "TopTitle", true);
			strDefaultTitle = STR_X_DEFAULT_TITLE;		///Kyle 01/22/2009 SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY
			break;
			
		case AXIS_RIGHT:
			trTicks = tree_get_node_by_tagname(trAxes, "RightTicks", true);
			trLabels = tree_get_node_by_tagname(trAxes, "RightLabels", true);
			trTitle = tree_get_node_by_tagname(trAxes, "RightTitle", true);
			strDefaultTitle = STR_Y_DEFAULT_TITLE;		///Kyle 01/22/2009 SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY
			break;
		default:
			ASSERT(false);
			return;
		}

		if(vnAxes[ii]>=0)
		{
			trShow = trTicks.GetNode("Show");
			trShow.nVal = vnAxes[ii];
		}
		///Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
		if(vnMajorTicks && vnMajorTicks[ii]>=0)
		{
			TreeNode trMajorTick = trTicks.GetNode("Major");
			trMajorTick.nVal = vnMajorTicks[ii];
		}
		if(vnMinorTicks && vnMinorTicks[ii]>=0)
		{
			TreeNode trMinorTick = trTicks.GetNode("Minor");
			trMinorTick.nVal = vnMinorTicks[ii];
		}
		///End ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT

		if(vnLabels[ii]>=0)
		{
			trShow = trLabels.GetNode("Show");
			trShow.nVal = vnLabels[ii];
		}

		if(vnTitles[ii]>=0)
		{
			trShow = trTitle.GetNode("Show");
			trShow.nVal = vnTitles[ii];
			///Kyle 01/22/2009 SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY
			if(vnTitles[ii] > 0)
			{
				TreeNode trTitltText = trTitle.GetNode("Text");
				TreeNode trLinkToVars = trTitle.GetNode("LinkToVars");
				if(trTitltText)
					trTitltText.strVal = strDefaultTitle;
				if(trLinkToVars)
					trLinkToVars.nVal = 1;
			}
			///End SHOW_DEFAULT_TITLE_IF_TITLE_IS_EMPTY
		}
	}
	gl.ApplyFormat(tr, bRepaint, true, true);
}

static void _gp_smart_show_object(GraphPage& gp, int nNumRow, int nNumCol, const vector<int>& vnSel, int nXGap, int nYGap, DWORD dwOptions = 0, bool bRefresh = false)
{
	if(!gp || nNumRow <= 0 || nNumCol <= 0)
		return;
	
	// remove duplicated, linked layers
	vector<int> vnSelected;
	vnSelected = vnSel;
	vnSelected.Sort();
	if(vnSelected.GetSize() <= 0)
		vnSelected.Data(0, gp.Layers.Count()-1);		// select all

	GraphLayer gl;
	double xx[TOTAL_POS];
	for(int ii = vnSelected.GetSize()-1; ii >= 0; ii--)
	{
		if(ii>0 && vnSelected[ii] == vnSelected[ii-1])
			vnSelected.RemoveAt(ii);
		else
		{
			gl = gp.Layers(vnSelected[ii]);
			if(!gl || (is_linked_layer(gl) && M_LINK == gl.GetPosition(xx)))
				vnSelected.RemoveAt(ii);
		}
	}

	int nNumLayerLastRow = nNumCol,
		nLaySelected = vnSelected.GetSize();
	if(vnSelected.GetSize() < nNumRow * nNumCol)		// not full, correct nNumRow & nNumLayerLastRow
	{
		nNumRow = nLaySelected / nNumCol;
		nNumLayerLastRow = nLaySelected -  nNumRow * nNumCol;
		if(nNumLayerLastRow == 0)
			nNumLayerLastRow = nNumCol;
		else
			nNumRow++;
	}
	bool 	bXBigGap		= nXGap >= SA_MIN_GAP,
			bYBigGap		= nYGap >= SA_MIN_GAP,
			bOuterTitle		= !(SA_HIDE_OUTER_TITLE & dwOptions),
			bInnerAxis		= SA_SHOW_INNER_AXIS & dwOptions,
			bInnerLabel		= SA_SHOW_INNER_TICK_LABEL & dwOptions;
	int nGrid = nNumCol * nNumRow;
	
	bool 	bTop, bBottom, bLeft, bRight;
	vector<int> vnAxes(4), vnLabels(4), vnTitles(4);

	for(int nPosIndex = 0; nPosIndex < nLaySelected; nPosIndex++)
	{
		gl = gp.Layers(vnSelected[nPosIndex]);
		ASSERT(gl);
		if(nPosIndex < nGrid)
		{
			int nColIndex = nPosIndex % nNumCol;	// [0, nNumCol)
			int nRowIndex = nPosIndex / nNumCol;	// [0, nNumRow)
			bTop = nRowIndex == 0;
			bBottom = (nRowIndex == nNumRow - 1) || (nRowIndex == nNumRow - 2 && nColIndex >= nNumLayerLastRow);
			bLeft = nColIndex == 0;
			bRight = (nColIndex == nNumCol - 1) || (nPosIndex == vnSelected.GetSize()-1);
	
			// left
			vnAxes[AXIS_LEFT] = bLeft || nXGap > 0 || bInnerAxis;
			vnTitles[AXIS_LEFT] = bLeft && bOuterTitle;
			vnLabels[AXIS_LEFT] = (bLeft || bXBigGap || bInnerLabel) && vnAxes[AXIS_LEFT];
	
			// bottom
			vnAxes[AXIS_BOTTOM] = bBottom || nYGap > 0 || bInnerAxis;
			vnTitles[AXIS_BOTTOM] = bBottom && bOuterTitle;
			vnLabels[AXIS_BOTTOM] = (bBottom || bYBigGap || bInnerLabel) && vnAxes[AXIS_BOTTOM];
	
			// top
			vnAxes[AXIS_TOP] = bTop || nYGap > 0;
			vnTitles[AXIS_TOP] = false;
			vnLabels[AXIS_TOP] = (!vnLabels[AXIS_BOTTOM] && bTop)? -1:0;
	
			// right
			vnAxes[AXIS_RIGHT] = bRight || nXGap > 0;
			vnTitles[AXIS_RIGHT] = false;
			vnLabels[AXIS_RIGHT] = (!vnLabels[AXIS_LEFT] && bRight)?-1:0;
		}
		else
		{
			vector<int> vn = {0, 0, 0, 0};
			vnAxes = vnLabels = vnTitles = vn;
		}
	
		_gl_smart_show_object(gl, vnAxes, vnLabels, vnTitles);
	}
	if(bRefresh)
		gp.Refresh();
}
///End SMART_SHOW_HIDE_AXIS_TICK_LABELS_AND_TITLE
*/
///end ADDED_TWO_OPTIONS_LINK_TO_AND_SMART_OBJECTS_WHEN_ARRANGE_IN_MERGE_GRAPH

static bool _beyond_layer_max_num(GraphPage& gp, HWND hParent)//beyondLayerMaxNum	///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
{
	int nLayers = gp.Layers.Count();
	if(nLayers >= 255 )
	{
		MessageBox(hParent, _L("Unable to add any more layers to this Graph."), _L("Attention!"), MB_ICONSTOP | MB_OK);
		return true;
	}
	
	return false;
}
static void _get_default_row_col_number(int nLayerNum, int& nRow, int& nCol, bool bIsLandscape = false)
{
	nRow = nCol = 1;
	if(nLayerNum <= 1)
		return;
	
	bool bb = bIsLandscape;
	while(nRow * nCol < nLayerNum)
	{
		if(bb)
			nCol++;
		else 
			nRow++;
		bb = !bb;
	}
}	
///Jasmine 05/16/07 QA80-9182 ARRANGE_SELECTION_ONLY
///Jasmine 02/12/11 ORG-695 ARRANGE_OUTSIDE_CHILD_LAYER
int _get_layer_count(GraphPage gp, vector<int>& vnSel = NULL, bool bArrangeChild = false)
{
	bool 	bExcludeLinked = true;//always exclude
	int 	nCount = 0;
	if( !gp )
		return nCount;	
	
	vector<int> vnLayers;
	if(vnSel)
		vnLayers = vnSel;
	else
		vnLayers.Data(0, gp.Layers.Count()-1);
	
	for(int ii = 0; ii < vnLayers.GetSize(); ii++)
	{
		GraphLayer gl = gp.Layers(vnLayers[ii]);
		if(!gl.IsValid())
			continue;
		
		double dPos[TOTAL_POS];
		int nUnit = gl.GetPosition(dPos);
		if(bExcludeLinked && is_linked_layer(gl) && M_LINK == nUnit)//if exclude linked layers
		{
			if(!bArrangeChild || is_child_layer_outside_parent(gl) <= 0)
				continue;
		}
		
		nCount++;
	}
	return nCount;
}
///End ARRANGE_OUTSIDE_CHILD_LAYER
///End ARRANGE_SELECTION_ONLY

///Jasmine 06/15/07 MODIFICATION_SET_COLOR_FUNCTION
//////Jasmine 02/02/09 RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
//static bool _on_check_border_width_branch_event(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
//{
	//TreeNode trBorderWidth = tree_get_node(tr, nRow);
	//if(!trBorderWidth)
		//return false;
	//int nUse = trBorderWidth.Use;
	//trBorderWidth.Enable = nUse;
	//trBorderWidth.SetAttribute(STR_ATTRIB_BRANCH, nUse? GETNBRANCH_OPEN : GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
	//return true;
//}
///End RYAN_SUGGEST_PUT_BORDER_WIDTH_OUT_OF_COLOR_BRANCH
///End MODIFICATION_SET_COLOR_FUNCTION

///Jasmine 09/04/09 SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME
static bool _show_smart_arrange_hint(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl = 0, int nType = 0, WndContainer& theDlg = NULL)
{
	TreeNode trArrange = trNode.Parent();
	if ( !trArrange )
		return false;
	
	if( !trArrange.hint1 )
		return false;
	
	trArrange.hint1.Show = trNode.nVal? true : false;
	
	theDlg.PostMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, -1, FORCE_GUI_UPDATE_BIT);
	return true;
}
///End SMART_ARRANGE_WILL_SHOW_SOMEAXES_AND_HIDE_SOME

///------ Folger 01/13/09 v8.0995d OPTION_GETN_EVENT_FOR_AXIS_TICK_ENABLE_STATUS
static bool _check_enable_axes_major_tick(TreeNode& trNode)
{
	TreeNode	trTicks = trNode.Parent();
	if ( !trTicks )
		return false;
	
	TreeNode	trTicksMajor = trTicks.Tick;
	if ( !trTicksMajor )
		return false;
	
	trTicksMajor.Enable = trNode.nVal > 0 ? ENABLE : DISABLE;
	return true;
}

static bool _check_enable_axes_major_tick(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	return _check_enable_axes_major_tick(trNode);
}
///------ End OPTION_GETN_EVENT_FOR_AXIS_TICK_ENABLE_STATUS

///Jasmine 08/18/09 GUI_TO_ADD_2ND_NONLINEAR_AXIS
static bool _check_enable_tick_label_formula(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl = 0, int nType = 0, WndContainer& theDlg = NULL)
{
	TreeNode trAxes = trNode.Parent();
	if ( !trAxes )
		return false;
	
	if( !trAxes.Formula )
		return false;
	
	trAxes.Formula.Enable = trNode.nVal? ENABLE : DISABLE;
	return true;
}
///End GUI_TO_ADD_2ND_NONLINEAR_AXIS

static void _make_axes_nodes(TreeNode& trAxesBranch)
{
	GETN_USE(trAxesBranch)
	
	GETN_CHECK(AxisShow, 	_L("Axis"), 		0)
		GETN_OPTION_EVENT_EX(_check_enable_axes_major_tick)		///------ Folger 01/13/09 v8.0995d OPTION_GETN_EVENT_FOR_AXIS_TICK_ENABLE_STATUS
	GETN_LIST(Tick, _L("Tick"), 0, STR_TICK_LIST)		///Kyle 01/12/2009 v8.0995c QA80-12812 ADD_TICK_DIRECTIONS_IN_AXES_TAB_OF_LAYER_MANAGEMENT
	GETN_CHECK(Title, 		_L("Title"), 		0)
	GETN_CHECK(TickLabel,	_L("Tick Label"), 	0)
	///Jasmine 08/18/09 GUI_TO_ADD_2ND_NONLINEAR_AXIS
		GETN_OPTION_EVENT_EX(_check_enable_tick_label_formula)
	GETN_STR(Formula, _L("Formula"), "")					
		GETN_READ_ONLY	
	GETN_STR(Hint, _L("Example: 2 * x"), "") GETN_READ_ONLY_COLOR GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_USE_LABEL)
	///End GUI_TO_ADD_2ND_NONLINEAR_AXIS
}
///Jasmine 08/18/09 GUI_TO_ADD_2ND_NONLINEAR_AXIS
/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
//static bool	_get_set_axis_label_formula(GraphLayer& gl, const vector<int>& vnAxis, vector<string>& vsFormula, bool bGet = true)
static bool	_get_set_axis_label_formula(GraphLayer& gl, const vector<int>& vnAxis, vector<string>& vsFormula, bool bGet = true, TreeNode& trPrefetchedFmt = NULL)
/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
{
	if( !gl )
		return false;

	/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
	if(bGet)
		vsFormula.SetSize( vnAxis.GetSize() );
	int nCount = min( vnAxis.GetSize(), vsFormula.GetSize() );
	if ( 0 == nCount )
		return true;
	/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB

	Tree trFmt;
	/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
	//trFmt = gl.GetFormat(FPB_ALL, FOB_AXIS_LABELS, TRUE, TRUE);
	if ( trPrefetchedFmt )
		trFmt = trPrefetchedFmt;
	else
		trFmt = gl.GetFormat(FPB_ALL, FOB_AXIS_LABELS, TRUE, TRUE);
	/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
	//tree structure: trFmt.Root.Axes.X.Labels.LeftLabels.Formula
	
	/// Kenny 08/26/2009 QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
// 	if(bGet)
// 		vsFormula.SetSize( vnAxis.GetSize() );
// 	int nCount = min( vnAxis.GetSize(), vsFormula.GetSize() );
	/// End QA80-14100 ADD_UNDEFINED_STATUS_HANDLING_SUPPORT_FOR_AXES_TAB
	
	for(int ii = 0; ii < nCount; ii++)
	{
		TreeNode 	trAxes;
		string 		strLabel;
		int 		nAxis = vnAxis[ii];
		switch(nAxis)
		{
		case AXIS_BOTTOM:		
		case AXIS_TOP:
			trAxes 		= trFmt.Root.Axes.X;
			strLabel	= AXIS_BOTTOM == nAxis? "BottomLabels" : "TopLabels";
			break;
			
		case AXIS_LEFT:
		case AXIS_RIGHT:
			trAxes 		= trFmt.Root.Axes.Y;
			strLabel	= AXIS_LEFT == nAxis? "LeftLabels" : "RightLabels";
			break;
			
		default:
			ASSERT(0);
			break;
		}
		if(!trAxes)
			continue;
		
		TreeNode trLabel = trAxes.Labels.GetNode(strLabel);
		string strFormulaNode = "Formula";
		if(bGet)
			vsFormula[ii] = trLabel.GetNode(strFormulaNode)? trLabel.GetNode(strFormulaNode).strVal : "";
		else//set
			tree_check_get_node(trLabel, strFormulaNode).strVal = vsFormula[ii];			
	}
	
	if(!bGet)//set
	{
		int iRet = gl.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag");
		ASSERT(0 == iRet);
		return gl.ApplyFormat(trFmt, TRUE, TRUE, TRUE);
	}
	
	return true;	
}
///End GUI_TO_ADD_2ND_NONLINEAR_AXIS

///Kyle 01/20/2009 BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE
/////Kyle 01/13/2009 v8.0995d OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
//static bool _check_enable_display_border_color_width(TreeNode& trNode)
//{
	//TreeNode trColor = trNode.Parent();
	//if(!trColor)
		//return false;
	//TreeNode trBorderColor = trColor.BorderColor;
	//TreeNode trBorderWidth = trColor.BorderWidth;
	//if(!trBorderColor || !trBorderWidth)
		//return false;
	//trBorderColor.Enable = trBorderWidth.Enable = trNode.nVal > 0 ? ENABLE : DISABLE;
	//return true;
//}
//
//static bool _check_enable_display_border_color_width(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
//{
	//return _check_enable_display_border_color_width(trNode);
//}
/////End OPTION_GETN_EVENT_FOR_BORDER_COLOR_WIDTH_ENABLE_STATUS
///End BORDER_STYLE_IN_DISPLAY_NOT_NEEDED_ANYMORE

int LayerManagement(int nMsg, DWORD dwCntrl = 0, LPVOID lpData = NULL)
{	
	HWND hParent = lpData;
	GraphPage gp = Project.Pages();
	if(!gp)
		return error_report("Active page should be a graph");
	LayerTool myDlg(gp);
	Window winExDlg = myDlg.GetWindow();
	if(winExDlg)
		return error_report(STR_DLG_NAME+" already open");
	Window winNewDlg(hParent);
	HWND hWnd = GetWindow();
	if(winNewDlg)
		hWnd = hParent;
	if(hWnd)
		return (IDOK == myDlg.DoModalEx(hWnd));
	return false;
}
