/*------------------------------------------------------------------------------*
 * File Name: LayerPlotContentsDlg.c				 								*
 * Creation: Kit Chen															*
 * Purpose: New OC based Layer Contents Dlg										*
 * Copyright (c) OriginLab Corp.	2010, 2011									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 12/20/10 PROPER_CODE_FOR_CALLED_FROM_VC_TO_OPEN_DLG						*
 *  Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG		*
 *  Iris 2/16/2011 ORG-2100-P11 FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM			*
 *	Kit 02/23/2011 ORG-2310 WHEN_APPLY_CHANGE_TO_LAYER_NEED_TO_REFRESH_PAGE		*
 *	Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED				*
 *	Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT						*
 *	Kit 05/23/2011 ORG-2939-P1 CAN_NOT_GET_CORRECT_GRAPH_PAGE_AFTER_ACTIVE_WKS_FROM_PLOT_DT
 *  Iris 6/14/2011 ORG-2857-P2 SHOW_ERR_MSG_FOR_NOT_SUPPORTED_PLOT_TYPE			*
 *	Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP*
 *  Iris 12/09/2011 ORG-4570-P1 BETTER_RESIZE_FOR_LAYER_CONTENTS_DLG			*
 *  Iris 3/09/2012 ORG-5245-P1 FIX_ALLOW_ADD_LABEL_COL_TO_3D_LAYER				*
 *	Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN							*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "DialogEx.h"
#include "DatasetList.h"
#include "LayerPlotList.h"
/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
#include "WksColLabels.h" 
#endif 
///End SHOW_COMMON_UDLS
#include <ocu.h>	///-----Kit 05/04/2011 ORG-2614-S1 MOVE_ERR_MSG_TO_VC

#define	STR_DLG_TITLE_NAME	_L( "Layer Contents" ) ///-----Kit 12/23/2010 ORG-1837-S2 KEEP_LAYER_CONTENTS_NAME_AND_MENU_NAME_CONSISTENT
#define	IDC_PLOTS_CTRL	IDC_LAYER_CONTENT_PLOTS_LIST

typedef bool (*FUNC_HWND) (HWND hParent = NULL);
typedef BOOL (*FUNC_PLOT_SETUP)(BOOL bNewPlot, int nPlotID, LPCTSTR lpcszTemplate, HWND hWndParent );
typedef	void (*PFNApplySystemThemeToPage)(OriginObject& obj);

#define		STR_AVAIL_DATA_CHOICE			"AvailData"
#define		STR_LAYER_NODE_NAME_DISPLAY		_LC("Layer", _CAT)

#define 	STR_OKBUTTON_OK					_L("OK")
#define 	STR_OKBUTTON_CLOSE				_L("Close")

#define 	STR_GROUP_DATAPLOTS_TIPS		_L("Can not group the selected plots. Plots should be contiguous in the list.") /// Iris 01/04/2011 ORG-1682-P4 IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
#define		STR_RESCALE_FROM_REG			"RescaleCheckBox"
#define		STR_INC_SHORTCUT_FROM_REG		"IncShortcutCheckBox"

///-----Kit 05/04/2011 ORG-2614-S1 MOVE_ERR_MSG_TO_VC
/*
///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
#define		MSG_CAN_NOT_PLOT_2D_PLOT_TO_3D_LAYER	_L("The column(s) selected in left pannel can not add to 3D Layer.")
///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
#define		MSG_CURR_PLOT_TYPE_NEDD_ALL_COLS_IN_SAME_WKS _L("The current plot type need all selected columns in same worksheet.")
#define		MSG_SEL_COL_NUM_IS_NOT_CORRESPOND_THE_CURR_PLOT_TYPE _L("The selected column's number is not correspond to current plot type require.")
///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
*/
///-----End MOVE_ERR_MSG_TO_VC

//---LayerContents class name changed by CPY from LayerContentsDlg per CPY 12/20/10 PROPER_CODE_FOR_CALLED_FROM_VC_TO_OPEN_DLG
class LayerPlotContentsDlg : public MultiPaneDlg
{
public:
	LayerPlotContentsDlg( int nPlotID = IDM_PLOT_UNKNOWN ) : MultiPaneDlg( IDD_LAYER_CONTENTS_DLG, "ODlg8", SUBPANE_POS_LEFT ) 
	{
		m_nPlotIDFromBitmapButton = nPlotID;	///-----Kit 01/04/2011 ORG-1837-S4 GET_PLOT_ID_WHEN_CLICK_GRAPH_ADD_PLOT
		m_nPlotID = IDM_PLOT_UNKNOWN; 	/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
	}

	~LayerPlotContentsDlg(){}

	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = MultiPaneDlg::DoModal(hWndParent);		
		return nRet;
	}	
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_OK(OnOK)
	ON_READY(OnReady)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	///Jasmine 12/22/10 ORG-1826-S1-1 INIT_POSITION_IN_MIDDLE_OF_SCREEN
	ON_INIT_SIZE(OnInitSize)	
	ON_RESTORESIZE(OnRestoreSize)
	///End INIT_POSITION_IN_MIDDLE_OF_SCREEN
	ON_SIZE(OnDlgResize)
	ON_BN_CLICKED(IDC_BTN_SHOW_LEFT_PANEL, OnShowBottomPane)
	
	ON_CBN_SELCHANGE( IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX, OnAvailDataComboChange )
	ON_BN_CLICKED( IDC_LAYER_CONTENTS_INCLUDE_SHORTCUT, OnIncShortcutWindowsChecked ) /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	ON_BN_CLICKED( IDC_LAYER_CONTENT_LAYER_PROPERTIES_BUTTON, OnClickLayerPropertiesButton )	
	ON_BN_CLICKED( IDC_LAYER_CONTENT_PLOT_SETUP_BUTTON, OnClickPlotSetupButton )	
	ON_BN_CLICKED( IDC_APPLY_BUTTON, OnClickApplyButton )
	ON_BN_CLICKED( IDC_PLOT_TYPE_SWITCH_BUTTON, OnClickPlotTypeDropDownButton ) /// Iris 12/29/2010 ORG-1879 ADD_PLOTTYPE_BMP_BUTTON
	ON_BN_CLICKED( IDC_LAYER_CONTENT_ADD_PLOT, OnAddPlots )
	ON_BN_CLICKED( IDC_LAYER_CONTENT_REMOVE_PLOT, OnRemovePlots )
	ON_BN_CLICKED( IDC_LAYER_CONTENT_GROUP_BUTTON, OnClickGroupButton )
	ON_BN_CLICKED( IDC_LAYER_CONTENT_UNGROUP_BUTTON, OnClickUnGroupButton )
	ON_BN_CLICKED( IDC_CHECK_LAYER_CONTENTS_RESCALE, OnClickRescaleCheckBox )
	
	ON_GRID_SEL_CHANGE( IDC_LAYER_CONTENT_DATA_LIST, OnSelDatasetList )	
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_LAYER_CONTENT_DATA_LIST, OnDataListBeforeMouseDown)
	ON_GRID_DBLCLICK( IDC_LAYER_CONTENT_DATA_LIST, OnDatasetListDoubleClick )///-----Kit 12/22/2010 ORG-1826-S4 SUPPORT_DOUBLE_CLICK_LEFT_PANEL_TO_ADD_PLOT
	ON_GRID_MOUSE_MOVE(IDC_LAYER_CONTENT_DATA_LIST, OnDatasetListMouseMove)	///-----Kit 02/24/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
	ON_GRID_AFTER_MOVE_COLUMNS(IDC_LAYER_CONTENT_DATA_LIST, OnAfterMoveColumns)///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	ON_GRID_AFTER_MOVE_COLUMNS(IDC_PLOTS_CTRL, OnAfterMovePlotColumns)///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS

	ON_BN_CLICKED( IDC_LAYER_CONTENT_MOVE_UP_DATA_PLOTS, OnMoveUpDataPlots )
	ON_BN_CLICKED( IDC_LAYER_CONTENT_MOVE_DOWN_DATA_PLOTS, OnMoveDownDataPlots )

	///----- IDC_PLOTS_CTRL Event Begin
	ON_GRID_DBLCLICK( IDC_PLOTS_CTRL, OnPlotsCtrlDBClick )///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE
	ON_GRID_SEL_CHANGE(IDC_PLOTS_CTRL, OnPlotsCtrlSelChange)
	ON_GRID_AFTER_SEL_CHANGE(IDC_PLOTS_CTRL, OnPlotsCtrlAfterSelChange)

	ON_GRID_BEFORE_MOUSE_DOWN( IDC_PLOTS_CTRL, OnPlotsCtrlBeforeMouseDown )
	ON_GRID_MOUSE_UP( IDC_PLOTS_CTRL, OnPlotsCtrlMouseUp ) /// Iris 1/11/2010 USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION

	ON_CONTEXTMENU(OnContextMenu)	///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	
	ON_GRID_BEFORE_EDIT( IDC_PLOTS_CTRL, OnPlotsCtrlBeforeEdit )
	ON_GRID_START_EDIT(IDC_PLOTS_CTRL, OnPlotsCtrlStartEdit)	///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
	ON_GRID_AFTER_EDIT( IDC_PLOTS_CTRL, OnPlotsCtrlAfterEdit )

	ON_GRID_BUTTON_CLICK( IDC_PLOTS_CTRL, OnPlotsCtrlRangeBtnClick )
	ON_GRID_BEFORE_MOVE_ROWS(IDC_PLOTS_CTRL, OnPlotsCtrlBeforeMoveRows) /// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	ON_GRID_AFTER_MOVE_ROWS(IDC_PLOTS_CTRL, OnPlotsCtrlAfterMoveRows)

	ON_GRID_MOUSE_MOVE(IDC_PLOTS_CTRL, OnPlotsCtrlMouseMove)	///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
	
	///-----Kit 01/05/2011 roll back the code. No need to remove DataPlot when double click
	//ON_GRID_DBLCLICK( IDC_PLOTS_CTRL, OnPlotsCtrlDoubleClick )	///-----Kit 12/29/2010 ORG-1826-S4 DBL_CLICK_PLOT_CTRL_REMOVE_PLOT
	///-----End roll back
	ON_GRID_COMBO_CLOSEUP( IDC_PLOTS_CTRL, OnPlotsCtrlComboCloseUp ) ///-----Kit 12/30/2010 WHEN_SELECTED_COMBO_BOX_MAKE_EIDT_MODE_AS_FINISH

	ON_USER_MSG(WM_USER_MSG_ON_DATAPLOT_CHANGED, OnAfterDataPlotChangedEvent)
	///----- IDC_PLOTS_CTRL Event End

	ON_USER_MSG(WM_USER_MSG_ON_HIDE_COL, HideSameCol)///Jasmine 12/29/10 ORG-1826-S1-3 HIDE_SHOW_SAME_NAME_COL
	
EVENTS_END

	//---Init
	bool OnInitDialog()
	{
		SetResizePaneByResizingEdge(true);///Jasmine 01/17/11 ORG-1999 RESIZE_PANE_BY_RESIZING_EDGE
		m_gp = Project.Pages();			///-----Kit 05/23/2011 ORG-2939-P1 CAN_NOT_GET_CORRECT_GRAPH_PAGE_AFTER_ACTIVE_WKS_FROM_PLOT_DT
		// Buttons
		m_btnGroupPlots		= GetDlgItem( IDC_LAYER_CONTENT_GROUP_BUTTON );
		m_btnUnGroupPlots	= GetDlgItem( IDC_LAYER_CONTENT_UNGROUP_BUTTON );
		m_btnAddPlot		= GetDlgItem( IDC_LAYER_CONTENT_ADD_PLOT );
		m_btnRemovePlot		= GetDlgItem( IDC_LAYER_CONTENT_REMOVE_PLOT );
		m_btnUp				= GetDlgItem( IDC_LAYER_CONTENT_MOVE_UP_DATA_PLOTS );
		m_btnDown			= GetDlgItem( IDC_LAYER_CONTENT_MOVE_DOWN_DATA_PLOTS );
		m_btnCancel			= GetDlgItem( IDCANCEL );
		m_btnOK				= GetDlgItem( IDOK );
		m_btnApply  		= GetDlgItem( IDC_APPLY_BUTTON );
		m_chkRescale		= GetDlgItem( IDC_CHECK_LAYER_CONTENTS_RESCALE );
		m_chkRescale.Value = LoadSetting(STR_RESCALE_FROM_REG, 0, STR_DLG_NAME); // Init Rescale checkbox from registry	
		
		/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		m_chkIncShortcut 	= GetDlgItem(IDC_LAYER_CONTENTS_INCLUDE_SHORTCUT); 
		m_chkIncShortcut.Value = LoadSetting(STR_INC_SHORTCUT_FROM_REG, 1, STR_DLG_NAME);
		///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		
		/// Iris 12/29/2010 ORG-1879 ADD_PLOTTYPE_BMP_BUTTON
		m_btnPlotType		= GetDlgItem( IDC_PLOT_TYPE_BITMAP_BUTTON );
		m_btnPlotTypeDropDown = GetDlgItem( IDC_PLOT_TYPE_SWITCH_BUTTON ); 
		///End ADD_PLOTTYPE_BMP_BUTTON
		GetItem(IDOK).Text = STR_OKBUTTON_CLOSE;
		
		vector<string> vsTipsEmpty;		
		m_btnUp.Init(1, IDB_ARROW_UP, 16, vsTipsEmpty);
		m_btnDown.Init(1, IDB_ARROW_DOWN, 16, vsTipsEmpty);
		
		/// Iris 12/29/2010 ORG-1879 ADD_PLOTTYPE_BMP_BUTTON
		vector<string> vsTips(1);
		vsTips[0] = _L("Plot Type");
		m_btnPlotType.Init(1, IDB_2D_PLOT, 16, vsTips, 0);
		m_btnPlotTypeDropDown.Init(1, IDB_DROP_DOWN, 9, vsTips, 0);	
		///End ADD_PLOTTYPE_BMP_BUTTON
		///Jasmine 01/17/11 ORG-1997-S5 SHOW_HINTS_WHEN_BTN_DISABLE
		vsTips[0] = _L("Add plot");
		m_btnAddPlot.Init(1, IDB_ARROW_RIGHT, 16, vsTips);
		vsTips[0] = _L("Remove plot");
		m_btnRemovePlot.Init(1, IDB_ARROW_LEFT, 16, vsTips);
		///End SHOW_HINTS_WHEN_BTN_DISABLE
		
		/// Iris 12/29/2010 ORG-1879 ADD_PLOTTYPE_BMP_BUTTON
		//vector<uint> vnButtons = {IDC_LAYER_CONTENT_ADD_PLOT, IDC_LAYER_CONTENT_REMOVE_PLOT, 0};
		vector<uint> vnButtons = {IDC_PLOT_TYPE_BITMAP_BUTTON, IDC_PLOT_TYPE_SWITCH_BUTTON, IDC_LAYER_CONTENT_ADD_PLOT, IDC_LAYER_CONTENT_REMOVE_PLOT, 0};
		SetSubPaneRightButtonIDs(vnButtons);
		///End ADD_PLOTTYPE_BMP_BUTTON
		
		vector<string> vsTooltipsShowBottomPane;
		vsTooltipsShowBottomPane.Add(_L("Show Left"));
		vsTooltipsShowBottomPane.Add(_L("Hide Left"));
		MultiPaneDlg::OnInitDialog(IDC_PLOTS_CTRL, IDC_BTN_SHOW_LEFT_PANEL, IDC_LAYER_CONTENT_DATA_LIST, vsTooltipsShowBottomPane, STR_DLG_NAME);
		
		/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		//m_pDatasetList 		= new DatasetList( IDC_LAYER_CONTENT_DATA_LIST, *this, STR_DATASET_LIST_HEADERS );
		m_pDatasetList 		= new DatasetList( IDC_LAYER_CONTENT_DATA_LIST, *this);
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		ASSERT( m_pDatasetList );
		
		/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		//m_pComboAvailData 	= new AvailDataCombo( GetItem( IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX ), m_pDatasetList, STR_AVAIL_DATA);
		m_pComboAvailData 	= new AvailDataCombo( GetItem( IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX ), m_pDatasetList);
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		ASSERT( m_pComboAvailData );
		///Jasmine 01/20/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
		int nTitleWidth;
		GetTextExtentSize(STR_AVAIL_DATA_WKS_IN_GLAYER, &nTitleWidth);
		//nTitleWidth
		RECT rrCombo;
		GetControlClientRect(IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX, rrCombo);			
		if(RECT_WIDTH(rrCombo) < nTitleWidth)
		{
			rrCombo.right = rrCombo.left + nTitleWidth;
			MoveControl(GetItem(IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX), rrCombo);
		}
		///End FILTER_GRAPH_SOURCE_DATA
		
		initPlotsListControl();	
		
		UpdateDatasetListAndPlotListBoldStatus(true, true); /// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
		enableDlgItems();
		showHideSubPaneControls();
		updateBitmapForPlotTypeButton();
		updateBitmapForPlotTypeButtonByPlotID(m_nPlotIDFromBitmapButton);	///-----Kit 03/02/2011 ORG-1837-S4 BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG
		
		///Jasmine 01/12/11 ORG-1997-S1 SHOW_LAYER_NAME_IN_TITLE
		//SetWindowText( GetSafeHwnd(), STR_DLG_TITLE_NAME );///-----Kit 12/23/2010 ORG-1837-S2 KEEP_LAYER_CONTENTS_NAME_AND_MENU_NAME_CONSISTENT
		string strTitle = STR_DLG_TITLE_NAME;
		GraphLayer lay = Project.ActiveLayer();
		if(lay)
		{
			string strName;
			lay.GetName(strName);
			strTitle += " - " + strName; 
		}
		SetWindowText( GetSafeHwnd(), strTitle );
		///End SHOW_LAYER_NAME_IN_TITLE
		return true;  
	}

	
	bool OnDestroy()
	{		
		SaveSetting(STR_RESCALE_FROM_REG, m_chkRescale.Value, STR_DLG_NAME);		
		SaveSetting(STR_INC_SHORTCUT_FROM_REG, m_chkIncShortcut.Value, STR_DLG_NAME); /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG		
		SetInitReady( false );
		
		delete m_pDatasetList;
		delete m_pComboAvailData;
		return MultiPaneDlg::OnDestroy();
	}
	
	bool OnOK()
	{
		if( m_btnApply.Enable ) // sth changed
			m_PlotsCtrl.ApplyDataPlotsToLayer();
		return true;
	}
	
	bool OnReady()
	{	
		SetInitReady( true );
		return true;
	}
	
	/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int getDlgMinWidth()
	int GetMinClientTrackWidth()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{	
		int nMinWidth = 0;
		int nGap = GetControlGap();
		
		if( !IsBottomPaneShown() )
		{			
			return GetMinTopPaneHeight();
		}
		else
		{
			/// Iris 12/09/2011 ORG-4570-P1 BETTER_RESIZE_FOR_LAYER_CONTENTS_DLG
			if( IsResizeSubPane() )
			{
				RECT rrCombo, rrAddPlot;
				GetControlClientRect(IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX, rrCombo);			
				GetControlClientRect(IDC_LAYER_CONTENT_ADD_PLOT, rrAddPlot);			
				nMinWidth = RECT_WIDTH(rrCombo) + RECT_WIDTH(rrAddPlot) + GetMinTopPaneHeight() + 3 * nGap + 50;
			}
			else							
			{
				RECT rrCancel;
				GetControlClientRect(IDCANCEL, rrCancel);	
				nMinWidth = rrCancel.right + nGap;
			}
			///End BETTER_RESIZE_FOR_LAYER_CONTENTS_DLG
			
			return nMinWidth;
		}
	}
	
	//virtual
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int GetTotalWidth(bool bGetMin = false)
	//{
	//	/// Iris 12/23/2010 GOOD_DLG_DEFAULT_SIZE_TO_REMOVE_SCROLLBAR_IN_GRID
	//	//return getDlgMinWidth();
	//	if( bGetMin )
	//	return getDlgMinWidth();
	//	else
	//		return 680; // init size when open dlg first time
	//	///End GOOD_DLG_DEFAULT_SIZE_TO_REMOVE_SCROLLBAR_IN_GRID
	//}
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	
	//virtual
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int GetTotalHeight(bool bGetMin = false)
	int GetMinClientTrackHeight()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{
		return 150;
	}
	
	//virtual
	int GetMinTopPaneHeight() 
	{ 
	
		vector<uint> vnIDs = {
							IDC_BTN_SHOW_LEFT_PANEL,
							IDC_LAYER_CONTENT_LAYER_PROPERTIES_BUTTON,
							IDC_LAYER_CONTENT_PLOT_SETUP_BUTTON,
							IDC_APPLY_BUTTON,
							IDOK,
							IDCANCEL							
							};
		
		int nGap = GetControlGap();
		int width = 2*nGap;
		for(int nn = 0; nn < vnIDs.GetSize(); nn++)
		{
			RECT rr;
			GetControlClientRect(vnIDs[nn], rr);
			width += RECT_WIDTH(rr) + nGap;
		}
		ASSERT(width > 50);
		return width; // 357		
	}
	
	//virtual
	int GetMainPaneControlIDs(vector<uint>& vnIDs) 
	{ 
		vector<uint> vnIDsTemp = {
								IDC_PLOTS_CTRL,
								IDC_LAYER_CONTENT_MOVE_UP_DATA_PLOTS,
								IDC_LAYER_CONTENT_MOVE_DOWN_DATA_PLOTS,
								IDC_LAYER_CONTENT_GROUP_BUTTON,
								IDC_LAYER_CONTENT_UNGROUP_BUTTON,
								IDC_BTN_SHOW_LEFT_PANEL,
								IDC_LAYER_CONTENT_LAYER_PROPERTIES_BUTTON,
								IDC_LAYER_CONTENT_PLOT_SETUP_BUTTON,
								IDC_APPLY_BUTTON,
								IDOK,
								IDCANCEL								
								};
		vnIDs = vnIDsTemp;
		return vnIDs.GetSize();
	}
	///Jasmine 12/22/10 ORG-1826-S1-1 INIT_POSITION_IN_MIDDLE_OF_SCREEN
	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
	{
		return FALSE;
	}
	BOOL OnRestoreSize(ODWP dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		
		lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
		pSz->top = -1;
		pSz->left =-1;
		/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//pSz->width = GetTotalWidth();
		//pSz->height = max(GetTotalHeight(), 300);
		pSz->width = 680; // init size when open dlg first time
		pSz->height = max(GetMinTrackHeight(), 300);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		
		return TRUE;
	}
	///End INIT_POSITION_IN_MIDDLE_OF_SCREEN
	
	bool OnDlgResize(int nType, int cx, int cy)
	{	
		if(!IsInitReady())
			return true;
		
		MoveControlsHelper	_temp(this);
		
		uint vnButtonIDs[] = {IDC_LAYER_CONTENT_LAYER_PROPERTIES_BUTTON, IDC_LAYER_CONTENT_PLOT_SETUP_BUTTON, IDC_APPLY_BUTTON, IDOK, IDCANCEL, 0};
		MultiPaneDlg::OnDlgResize(vnButtonIDs, cx, cy, false);			
		
		setMainPaneControlsPosition();
		setSubPaneControlsPosition();
		
		return true;
	}
	
	bool OnShowBottomPane( Control ctrl )
	{		
		MultiPaneDlg::OnShowBottomPane(ctrl);
		
		showHideSubPaneControls();		
		setMainPaneControlsPosition();
		setSubPaneControlsPosition();
		
		return true;
	}

	/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	bool OnIncShortcutWindowsChecked( Control ctrl )
	{
		bool bIsExternalFilter = false; // since external
		if( m_pDatasetList->QueryResultAndUpdateList( m_pComboAvailData->GetCurSel(), NULL, true ) )
			UpdateDatasetListAndPlotListBoldStatus(true, true);
		return true;
	}
	///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG

	//---OnAvailDataComboChange
	bool OnAvailDataComboChange( Control ctrl )
	{
		int nComboSel = m_pComboAvailData->GetCurSel();
		///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
		if(	m_pDatasetList->GetWksInGLayerDropdown() == nComboSel || 
			m_pDatasetList->GetWBookInGLayerDropdown() == nComboSel || 
			m_pDatasetList->GetMatInGLayerDropdown() == nComboSel)
		{
			vector<string> vsBookSheets;
			if(m_pDatasetList->GetWBookInGLayerDropdown() == nComboSel)
				m_PlotsCtrl.GetCurSourceBooks(vsBookSheets, EXIST_WKS);
			else
				m_PlotsCtrl.GetCurSourceSheets(vsBookSheets, m_pDatasetList->GetWksInGLayerDropdown() == nComboSel? EXIST_WKS : EXIST_MATRIX);
			m_pComboAvailData->OnComboSelChange(nComboSel, vsBookSheets);
		}
		else
		///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
			m_pComboAvailData->OnComboSelChange( nComboSel );
		
		UpdateDatasetListAndPlotListBoldStatus(true, true); /// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
		
		int nDataPageType = m_pDatasetList->GetType();

		m_PlotsCtrl.SetDataPageType( nDataPageType );
		
		updateBitmapForPlotTypeButton();
		return true;
	}

 	void OnPlotsCtrlBeforeEdit( Control ctrl, int nRow, int nCol, BOOL* pCancel )
 	{
 		m_PlotsCtrl.OnCellBeforeEdit( nRow, nCol, pCancel );
 	}

	///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
	void OnPlotsCtrlStartEdit(Control ctrl, int nRow, int nCol, BOOL* pCancel)
	{
		m_PlotsCtrl.OnCellStartEdit(nRow, nCol, pCancel);
	}
	///-----End MAKE_LEGEND_CAN_EDIT

	void OnPlotsCtrlAfterEdit( Control ctrl, int nRow, int nCol )
	{
		if( m_PlotsCtrl.OnCellAfterEdit(nRow, nCol) )
		{
			onAfterDataPlotChanged();
		}
	}

	void OnPlotsCtrlRangeBtnClick( Control ctrl, int nRow, int nCol )
	{
		if( m_PlotsCtrl.OnRangeCellBtnClick( nRow, nCol ) )
			onAfterDataPlotChanged();
	}
	
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	void OnPlotsCtrlBeforeMoveRows(Control ctrl, long nRow, long *pnPosition) 
	{
		if( !m_PlotsCtrl.IsAllowMoveRow(nRow, *pnPosition) )
			*pnPosition = nRow;
	}
	///End TO_MOVE_WHOLE_GROUP
	
	void OnPlotsCtrlAfterMoveRows(Control ctrl, long nRow, long *pnPosition) 
	{
		/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
		//m_PlotsCtrl.MoveDataPlot(nRow, *pnPosition, false, true);
		m_PlotsCtrl.MoveDataPlot(nRow, *pnPosition);		
		onAfterDataPlotChanged();		
		///End TO_MOVE_WHOLE_GROUP
	}	

	///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
	void OnPlotsCtrlMouseMove(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		SetPlotListToolTipHelper ttHelper(&m_PlotsCtrl);
		ttHelper.SetGridToolTip();
	}
	///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
	
	///-----Kit 12/30/2010 WHEN_SELECTED_COMBO_BOX_MAKE_EIDT_MODE_AS_FINISH
	void OnPlotsCtrlComboCloseUp( Control ctrl, int nRow, int nCol, BOOL *pFinishEdit )
	{
		*pFinishEdit = TRUE;
	}
	///-----
	
	BOOL OnAfterDataPlotChangedEvent(WPARAM wParam, LPARAM lParam)
	{
		onAfterDataPlotChanged();
		return true;
	}
	
	///Jasmine 12/29/10 ORG-1826-S1-3 HIDE_SHOW_SAME_NAME_COL
	BOOL HideSameCol(DWORD dwOption, int nCol)
	{
		bool bHide = dwOption & HIDE_COL;
		bool bFromDataList = dwOption & HIDE_DATALIST_COL;
		
		vector<int> vnDataListCols = {	COL_BOOK_NAME,			///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
										COL_BOOK_LN,
										COL_BOOK_SN,
										COL_SHEET,
										COL_DSNAME,
										COL_SNAME,
										COL_LNAME};
										///-----Kit 05/04/2011 ORG-2614-S1 HIDE_BOOK_LN_IN_TWO_PANEL_AT_THE_SAME_TIME
										//COL_BOOK_LN};	///-----Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
										///-----End HIDE_BOOK_LN_IN_TWO_PANEL_AT_THE_SAME_TIME
		vector<int> vnPlotListCols = {	PlotsCtrl_BookName,			///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
										PlotsCtrl_BookLN, ///-----Kit 05/04/2011 ORG-2614-S1 HIDE_BOOK_LN_IN_TWO_PANEL_AT_THE_SAME_TIME
										PlotsCtrl_BookSN,
										PlotsCtrl_Sheet,
										PlotsCtrl_DSName,
										PlotsCtrl_SName,
										PlotsCtrl_LName};
										
		vector<int> vnTemp;
		vnTemp = bFromDataList? vnDataListCols : vnPlotListCols;
		vector<uint> vecIndex;
		if( vnTemp.Find(vecIndex, nCol) < 1 )
		{
			return false;
		}
		
		int ii = vecIndex[0];
		
		if(bFromDataList)
		{
			///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
			int nColPos = m_pDatasetList->GetColPos( vnPlotListCols[ii] );
			m_PlotsCtrl.SetIsColHidden(nColPos, bHide);
			///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
		}
		else			
		{
			///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
			int nColPos = m_pDatasetList->GetColPos( vnDataListCols[ii] );
			m_pDatasetList->SetIsColHidden(nColPos, bHide);
			///End MOVE_COLUMN_ORDER
		}
		
		return true;
	}
	///End HIDE_SHOW_SAME_NAME_COL
	
	///-----Kit 02/24/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
	void OnDatasetListMouseMove(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		SetDatasetListToolTipHelper ttHelper(m_pDatasetList);
		ttHelper.SetGridToolTip();
	}
	///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW

	bool OnClickPlotSetupButton( Control ctrl )
	{
		// apply dataplot settings before open Plot Setup dialog
		Control junk;
		OnClickApplyButton(junk);
		
		// open Plot Setup dialog
		string strPath = "OriginLab\\PlotSetup.c";
		FUNC_PLOT_SETUP pfn = Project.FindFunction( "PlotSetup", strPath );
		ASSERT( pfn );

		///Jasmine 01/12/11 ORG-1997-S3 NOT_RETURN_FROM_PLOT_SETUP
		//HWND hWndParent = GetSafeHwnd();
		PostMessage( WM_CLOSE );
		
		HWND hWndParent = GetWindow(OGW_MAIN); 
		ASSERT( hWndParent );
		
		bool bOK;
		if( pfn )
		{
			///-----Kit 05/23/2011 ORG-2939-P1 CAN_NOT_GET_CORRECT_GRAPH_PAGE_AFTER_ACTIVE_WKS_FROM_PLOT_DT
			getGraphPage().CheckShowActivate();
			///-----End CAN_NOT_GET_CORRECT_GRAPH_PAGE_AFTER_ACTIVE_WKS_FROM_PLOT_DT
			bOK = pfn( false, IDM_PLOT_LINE, NULL, hWndParent );
		}
		
		/*
		// if click OK button in Plot Setup dialog
		if( bOK )
		{			
			///Jasmine 12/29/10 ORG-1826-S9 ADD_LAYER_CONTENT_BTN
			PostMessage( WM_CLOSE );
		}
		else
		{
			Tree trContents;
			GraphLayer gl = Project.ActiveLayer();
			gl.GetLayerContents(trContents, GETLC_BITS);
			
			m_PlotsCtrl.SetLayerContentsTreeToCtrl(trContents);
			///End ADD_LAYER_CONTENT_BTN
		}
		*/
		///End NOT_RETURN_FROM_PLOT_SETUP
		return true;
	}
	
	bool OnClickLayerPropertiesButton(Control ctrl)
	{
		// apply dataplot settings before open Layer Properties dialog
		Control junk;
		OnClickApplyButton(junk);
		
		// open Layer Properties dialog
		GraphLayer gl = Project.ActiveLayer();
		gl.LT_execute("layer -k p;");
		
		// apply changes from Layer Properties dialog to Layer Contents dialog
		m_PlotsCtrl.OnLayerPropertiesDlgClose();
		return true;
	}
	
	bool OnClickApplyButton(Control ctrl)
	{
		if( m_PlotsCtrl.ApplyDataPlotsToLayer() )
		{
			m_btnApply.Enable = false;
			m_btnOK.Text = STR_OKBUTTON_CLOSE;
			///Sophy 5/24/2012 ORG-5658-P1 OPENGL_LAYER_CONTENT_CHANGE_SHOULD_DIRTY_DATA refresh issue should be fix in VC level.
			//getGraphPage().Refresh(TRUE);///-----Kit 02/23/2011 ORG-2310 WHEN_APPLY_CHANGE_TO_LAYER_NEED_TO_REFRESH_PAGE
			///end OPENGL_LAYER_CONTENT_CHANGE_SHOULD_DIRTY_DATA
			return true;
		}
		return false;
	}
	///End HIDE_PLOT_SETUP_BTN_AND_ADD_APPLY_BTN
	
	/// Iris 12/29/2010 ORG-1879 ADD_PLOTTYPE_BMP_BUTTON
	bool OnClickPlotTypeDropDownButton( Control ctrl )
	{		
		vector<int> vnColTypes;
		m_pDatasetList->GetSelColTypes( vnColTypes );
		//SimplePlotTypeList typelist( m_pDatasetList->GetType(), m_PlotsCtrl.GetLayerBits(), vnColTypes );
		/// Iris 2/16/2011 ORG-2100-P11 FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
		//SimplePlotTypeList typelist( m_pDatasetList->GetType(), m_PlotsCtrl.GetLayerBits(), vnColTypes, m_nPlotID );		
		ASSERT(m_pDatasetList->m_pDatasetListHelper != NULL);
		SimplePlotTypeList typelist( m_pDatasetList->GetType(), m_PlotsCtrl.GetLayerBits(), vnColTypes, m_pDatasetList->m_pDatasetListHelper->IsVirtualMatrix(), m_nPlotID );
		///End FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
		///-----Kit 01/07/2011 ORG-1826-S14 ADD_CHECKED_STATE_IN_PLOT_TYPE_DROP_DOWN_MENU
		//PlotTypeListMenu myMenu( &typelist );
		PlotTypeListMenu myMenu( &typelist, m_nPlotIDFromBitmapButton );
		///-----
		
		RECT rrPlotType;
		GetControlClientRect( IDC_PLOT_TYPE_BITMAP_BUTTON, rrPlotType );
		ClientToScreen( &rrPlotType );
		int nx = rrPlotType.left, ny = rrPlotType.bottom;
		
		myMenu.TrackPopupMenu( 0,  nx, ny, GetSafeHwnd() );
		int nSel;
		if( !myMenu.GetSel(nSel) )
			return false;
		
		m_nPlotIDFromBitmapButton = typelist.GetPlotIDByIndex(nSel);
		if( m_nPlotIDFromBitmapButton != PLOT_ID_FOR_AUTO )
			m_nPlotID = m_nPlotIDFromBitmapButton;
		
		return updateBitmapForPlotTypeButtonByPlotID(m_nPlotIDFromBitmapButton);			
	}
	
	bool updateBitmapForPlotTypeButton()
	{
		if( NULL == m_pDatasetList )
			return false;
		
		/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		/*
		/// Iris 12/31/2010 ORG-1879 ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
 		if( PLOT_ID_FOR_AUTO == m_nPlotIDFromBitmapButton )
 			return true;
		///End ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
		*/
		int nOriginalPlotIDFromBitmapButton = m_nPlotIDFromBitmapButton;
		///End IMPROVE_PLOTTYPE_CHECK	
		
		/// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		int nPlotIDFromStyleHolder;
		bool bRet = getPlotIDFromStyleHolder(nPlotIDFromStyleHolder);
		ASSERT(bRet);		
		m_nPlotID = (m_nPlotIDFromBitmapButton == PLOT_ID_FOR_AUTO || m_nPlotIDFromBitmapButton == IDM_PLOT_UNKNOWN)? nPlotIDFromStyleHolder : m_nPlotIDFromBitmapButton;
		///End SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		
		// get plot type list according to selected col type, layer bits and datasheet type.
		vector<int> vnColTypes;
		m_pDatasetList->GetSelColTypes( vnColTypes );		
		/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		//SimplePlotTypeList typelist(m_pDatasetList->GetType(), m_PlotsCtrl.GetLayerBits(), vnColTypes );
		/// Iris 2/16/2011 ORG-2100-P11 FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
		//SimplePlotTypeList typelist(m_pDatasetList->GetType(), m_PlotsCtrl.GetLayerBits(), vnColTypes, m_nPlotID );		
		ASSERT(m_pDatasetList->m_pDatasetListHelper != NULL);
		SimplePlotTypeList typelist( m_pDatasetList->GetType(), m_PlotsCtrl.GetLayerBits(), vnColTypes, m_pDatasetList->m_pDatasetListHelper->IsVirtualMatrix(), m_nPlotID );
		///End FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
		///End IMPROVE_PLOTTYPE_CHECK
		
		///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
		//m_strPlottingMsg = typelist.GetPlottingMsg();
		m_errLast = typelist.GetErrorInfo();
		///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
		
		vector<int> vnPlotIDs;
		typelist.GetPlotIDs(vnPlotIDs);

		if( m_nPlotIDFromBitmapButton != PLOT_ID_FOR_AUTO ) /// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		{
			vector<uint> vn;
			if( vnPlotIDs.GetSize() == 0 || IDM_PLOT_UNKNOWN == m_nPlotIDFromBitmapButton || vnPlotIDs.Find(vn, m_nPlotIDFromBitmapButton) <= 0 )
			{
				m_nPlotIDFromBitmapButton = PLOT_ID_FOR_AUTO;
			}
		}
		
		/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		//return updateBitmapForPlotTypeButtonByPlotID(typelist, m_nPlotIDFromBitmapButton);			
		/// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		/*
		int nPlotIDFromStyleHolder;
		bool bRet = getPlotIDFromStyleHolder(nPlotIDFromStyleHolder);
		ASSERT(bRet);		
		m_nPlotID = m_nPlotIDFromBitmapButton == PLOT_ID_FOR_AUTO ? nPlotIDFromStyleHolder : m_nPlotIDFromBitmapButton;
		*/
		///End SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		
		// update plot type bitmap button		
		if( m_nPlotIDFromBitmapButton != nOriginalPlotIDFromBitmapButton )
			updateBitmapForPlotTypeButtonByPlotID(m_nPlotIDFromBitmapButton);	
	
		///End IMPROVE_PLOTTYPE_CHECK	
		
		/// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		if( PLOT_ID_FOR_AUTO == m_nPlotIDFromBitmapButton && typelist.IsPlotIDNotMatch() && vnPlotIDs.GetSize() > 0 )
			m_nPlotID = vnPlotIDs[0]; 
		///End SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH

		return true;
	}
	
	bool updateBitmapForPlotTypeButtonByPlotID(int nPlotID)
	{
		int nBMPID, nIndexInBMP;
		///Jasmine 02/15/11 ORG-2100-P9 NOT_ALL_PLOT_TYPE_HAS_BITMAP 
		//typelist.GetBmpSrcIDAndBmpIndex(nPlotID, nBMPID, nIndexInBMP);

		///-----Kit 03/02/2011 ORG-1837-S4 BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG
		//if( typelist.GetBmpSrcIDAndBmpIndex(nPlotID, nBMPID, nIndexInBMP) )	
		if( get_bmp_src_id_and_bmp_index_by_plot_id(nPlotID, nBMPID, nIndexInBMP) )
		///-----End BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG
		
		///End NOT_ALL_PLOT_TYPE_HAS_BITMAP
		{
			vector<string> vsTips(1);
			vsTips[0] = _L("Plot Type");
			m_btnPlotType.Init(1, nBMPID, 16, vsTips, nIndexInBMP);		
		}
		return true;
	}
	///End ADD_PLOTTYPE_BMP_BUTTON
	
	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	bool ShowErrorMsgBox()
	{
		string strErrMsg;
		if( GetShowErrorMsg(strErrMsg) )
		{
			MessageBox(GetSafeHwnd(), strErrMsg, ERROR_TITLE);
			m_errLast = Err_NoError;
			return false;
		}

		return true;
	}
	///-----End LC_SHOULD_SUPPORT_XYAM_PLOT

	//---AddPlots
	bool OnAddPlots( Control ctrl )
	{
		/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		/*
		int nNewPlotID = -1; // -1 mean use the default plot id when add plot
		
		///-----Kit 12/23/2010 ORG-1826-S5 FOLLOW_TEMPLATE_WHEN_ADDING_DATA_TO_RIGHT_PANEL
		if( PLOT_ID_FOR_AUTO == m_nPlotIDFromBitmapButton )  
		{
			///-----Kit 01/07/2011 ORG-864-P1 DISABLE_ADD_PLOT_BTN_WHEN_SEL_ROW_IS_WKS_TYPE_AND_PLOT_TYPE_IS_MAT_USE_ONLY
			if( !getPlotIDByAutoSelected(nNewPlotID) )
			{
				ASSERT( false );
				return error_report( "getPlotIDByAutoSelected(nNewPlotID) failed!" );
			}
			///-----End DISABLE_ADD_PLOT_BTN_WHEN_SEL_ROW_IS_WKS_TYPE_AND_PLOT_TYPE_IS_MAT_USE_ONLY				
		}
		else
		{
			nNewPlotID = m_nPlotIDFromBitmapButton; 
		}
		*/	

		///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
		/*
		if( !m_strPlottingMsg.IsEmpty() )
		{
			MessageBox(GetSafeHwnd(), m_strPlottingMsg, ERROR_TITLE);
			return false;
		}
		*/
		///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
		//string strErrMsg;
		//if( GetShowErrorMsg(strErrMsg) )
		//{
		//	MessageBox(GetSafeHwnd(), strErrMsg, ERROR_TITLE);
		//	return false;
		//}
		/// Iris 3/09/2012 ORG-5245-P1 FIX_ALLOW_ADD_LABEL_COL_TO_3D_LAYER
		//ShowErrorMsgBox();
		if( !ShowErrorMsgBox() )
			return false;
		///End FIX_ALLOW_ADD_LABEL_COL_TO_3D_LAYER
		///-----End LC_SHOULD_SUPPORT_XYAM_PLOT

		///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
		///End IMPROVE_PLOTTYPE_CHECK
			
		///-----End FOLLOW_TEMPLATE_WHEN_ADDING_DATA_TO_RIGHT_PANEL

	
// 		Tree trNewPlots;
//  		DWORD dwLayerBits = m_PlotsCtrl.GetLayerBits();
		
// 		if( !m_pDatasetList->GetNewDataPlotsTree( nNewPlotID, dwLayerBits, trNewPlots ) )
//  		{
//  			ASSERT(false);
// 			error_report( "GetNewDataPlotsTree failed!!" );
//  			return false;
//  		}
//  
//  		foreach( TreeNode tnPlots in trNewPlots.Children )
// 		{
// 			m_PlotsCtrl.AddDataPlots( tnPlots, ADDPLOTSFROMTREE_EDIT );
// 		}
// 		
// 		UpdateDatasetListAndPlotListBoldStatus(true, true); /// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
// 		onSelPlotsListEnableButtons();
// 		onAfterDataPlotChanged();

 		/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		//addDataPlots( nNewPlotID );
		///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
		//addDataPlots( m_nPlotID );
		if( !addDataPlots( m_nPlotID ) )
		{
			m_errLast = m_pDatasetList->GetLastError();
			ShowErrorMsgBox();
		}
		///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
		///End IMPROVE_PLOTTYPE_CHECK
		
		return true;
	}
	
	//---RemovePlots
	bool OnRemovePlots( Control ctrl )
	{
		/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		//vector<uint> vuSelRows;
		//m_PlotsCtrl.GetSelRows( vuSelRows );
		//m_PlotsCtrl.RemoveDataPlots( vuSelRows );
		/// Iris 12/29/2010 ORG-1826-S7 HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
		//m_PlotsCtrl.RemoveDataPlots();		
		vector<string> vsRemovedDatasetNames;
		m_PlotsCtrl.RemoveDataPlots(vsRemovedDatasetNames);		
		m_pDatasetList->SetSelectionByDatasetNames(vsRemovedDatasetNames);
		///End HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
		///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE

		UpdateDatasetListAndPlotListBoldStatus(true, false); /// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
		onSelPlotsListEnableButtons();
		onAfterDataPlotChanged();
		
		///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
		vector<int> vnTypes;
		if(m_pDatasetList->GetWksInGLayerDropdown() > 0)
			vnTypes.Add(EXIST_WKS);
		if(m_pDatasetList->GetMatInGLayerDropdown() > 0)
			vnTypes.Add(EXIST_MATRIX);
		if(vnTypes.GetSize() > 0)
		{		
			m_PlotsCtrl.CheckGetDifferentPageTypes(vnTypes);
			
			if(vnTypes.GetSize() > 0)
				m_pComboAvailData->RemoveWksOrMatInGLayerDropdown(vnTypes);
		}
		///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
		
		return true;
	}

	bool OnSelDatasetList( Control ctrl )
	{
		/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_REMOVE_PLOTS_SPEED
		if( NULL == m_pDatasetList || !m_pDatasetList->IsSelectionReady() )
			return false;
		///End TO_IMPROVE_REMOVE_PLOTS_SPEED
		
		onSelDatasetListEnableButtons();
		updateBitmapForPlotTypeButton();	
		return true;
	}
	
	bool onSelDatasetListEnableButtons()
	{		
		if( NULL == m_pDatasetList )
			return false;	
			
		if (!(m_pDatasetList->GetRows() - m_pDatasetList->GetRowOffset() != 0 && m_pDatasetList->GetSelectedRow() >= m_pDatasetList->GetRowOffset() ) )
		{
			m_btnAddPlot.Enable = false;
			return true;
		}		
		
		/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		/*
		vector<int> vnSelColTypes;		
		if( m_pDatasetList->GetSelColTypes( vnSelColTypes ) && vnSelColTypes.GetSize() > 0 )
		{
			DWORD dwLayerBits = m_PlotsCtrl.GetLayerBits();
			
			vector<uint> vuIndices;
			bool bFoundZ = (vnSelColTypes.Find(vuIndices, OKDATAOBJ_DESIGNATION_Z) > 0);
			
			if( IS_LAYER_BITS_ANY_3D(dwLayerBits) && (!bFoundZ || has_both_z_and_other_column_selected( vnSelColTypes ) ) )
			{
				m_btnAddPlot.Enable = false;
				return true;
			}
		}
		*/		
		///End IMPROVE_PLOTTYPE_CHECK
		
		m_btnAddPlot.Enable = true;
		return true;
	}	

	void onSelPlotsListEnableButtons()
	{
 		vector<uint> vuSelRows;
		/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
 		//m_PlotsCtrl.GetSelRows(vuSelRows);
 		m_PlotsCtrl.GetSelRowsEx(vuSelRows);
 		///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
 		
		m_btnUp.Enable				= m_PlotsCtrl.CanMoveUpSelRows(vuSelRows);
		m_btnDown.Enable			= m_PlotsCtrl.CanMoveDownSelRows(vuSelRows);
		m_btnGroupPlots.Enable 		= m_PlotsCtrl.CanDoGroupPlots(vuSelRows);
		m_btnUnGroupPlots.Enable 	= m_PlotsCtrl.CanDoUngroupPlots(vuSelRows);
 		m_btnRemovePlot.Enable		= m_PlotsCtrl.CanDoRemovePlots( vuSelRows );
	}
		
	bool OnClickGroupButton( Control ctrl )
	{
		/// Iris 01/04/2011 ORG-1682-P4 IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
 		vector<uint> vuSelRows;
 		m_PlotsCtrl.GetSelRowsEx(vuSelRows);
 		if( !check_vector_increment((vector)vuSelRows, 1) )
 		{
 			MessageBox(GetSafeHwnd(), STR_GROUP_DATAPLOTS_TIPS, ERROR_TITLE);
 			return false;
 		}
 		///End IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG

 		if( m_PlotsCtrl.SetDataPlotGroup(true) )
		{
			onAfterDataPlotChanged();
			m_btnGroupPlots.Enable = false;
			m_btnUnGroupPlots.Enable = true;
		}
	
		return true;
	}

	bool OnClickUnGroupButton( Control ctrl )
	{	
		if( m_PlotsCtrl.SetDataPlotGroup(false) )
		{
			onAfterDataPlotChanged();
		}

		m_btnUnGroupPlots.Enable = false;
		m_btnGroupPlots.Enable = true;
		return true;
	}	
	
	bool OnClickRescaleCheckBox( Control ctrl )
	{
		if( m_chkRescale.Value )
		{
			m_PlotsCtrl.SetLayerContentsChangeBit(LC_CHANGE_RESCALE_MODE);
			onAfterDataPlotChanged();
		}
		m_PlotsCtrl.SetIsRescale(m_chkRescale.Value);
		return true;
	}
	
	/// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
	bool UpdateDatasetListAndPlotListBoldStatus(bool bUpdateDataList, bool bUpdatePlotList)
	{
		if( bUpdateDataList )
		{
			vector<string> vsPlottedDatasetNames;
			m_PlotsCtrl.GetColValues(m_PlotsCtrl.GetColPos(PlotsCtrl_DSName), vsPlottedDatasetNames, m_PlotsCtrl.GetRowOffset());
				m_pDatasetList->UpdateBlodStatusByDatasetNames(vsPlottedDatasetNames);			
		}
		
		if( bUpdatePlotList )
		{		
			/// Iris 01/07/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED_MORE
			//vector<string> vsDatasetNames;
			//m_pDatasetList->GetColValues(m_pDatasetList->GetColPos(COL_DSNAME), vsDatasetNames, m_pDatasetList->GetRowOffset() );///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
			//m_PlotsCtrl.UpdateBlodStatusByDatasetNames(vsDatasetNames);	
			m_PlotsCtrl.UpdateBlodStatusByDatasetNames((GridListControl*)m_pDatasetList);
			///End SETBOLD_CAUSE_SLOW_SPEED_MORE
		}
		return true;
	}
	///End SET_BOLD_FONT_ON_PLOTTED_DATASETS
	
	void onAfterDataPlotChanged()
	{
		m_btnApply.Enable = m_PlotsCtrl.IsLayerContentsChanged()? true : m_btnApply.Enable;	
		m_btnOK.Text = m_btnApply.Enable ? STR_OKBUTTON_OK : STR_OKBUTTON_CLOSE;
	}
	
	void OnDataListBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel)
	{
		m_pDatasetList->OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
	}
	
	///-----Kit 12/22/2010 ORG-1826-S4 SUPPORT_DOUBLE_CLICK_LEFT_PANEL_TO_ADD_PLOT
	void OnDatasetListDoubleClick( Control ctrl )
	{
		OnAddPlots( ctrl );
	}
	///-----
	
	///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	void OnAfterMoveColumns(Control ctrl, long lCol, long *pnPosition)
	{
		m_pDatasetList->OnAfterMoveColumns(ctrl, lCol, pnPosition);
	}
	///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	void OnAfterMovePlotColumns(Control ctrl, long lCol, long *pnPosition)
	{
		m_PlotsCtrl.OnAfterMoveColumns(ctrl, lCol, pnPosition);
	}
	///End MOVE_COLUMN_ORDER
	
	///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE
	void OnPlotsCtrlDBClick( Control ctrl ) 
	{
		string 	strDatasetName = m_PlotsCtrl.GetCurDatasetName();
		if( strDatasetName.IsEmpty() )
			return;
		
		DWORD	dwCurSel = m_pComboAvailData->GetCurSel();
		m_pComboAvailData->GetDataIndexByDatasetName(dwCurSel, strDatasetName);
		if(m_pComboAvailData->GetCurSel() != dwCurSel)
		{
			m_pComboAvailData->SetCurSel(dwCurSel);
			
			Control ctrl; 
			OnAvailDataComboChange(ctrl);
		}
		
		int nPlot =	m_PlotsCtrl.GetCurDataPlotType();
		
		if(m_nPlotIDFromBitmapButton == nPlot)
			return;		
		m_nPlotIDFromBitmapButton = nPlot;
		
		vector<int> vnColTypes;
		/// Iris 2/16/2011 ORG-2100-P11 FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
		//SimplePlotTypeList typelist(0, 0, vnColTypes);
		ASSERT(m_pDatasetList->m_pDatasetListHelper);
		SimplePlotTypeList typelist(0, 0, vnColTypes, m_pDatasetList->m_pDatasetListHelper->IsVirtualMatrix());
		///End FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
		updateBitmapForPlotTypeButtonByPlotID(m_nPlotIDFromBitmapButton);			
	}
	///End SHOW_CURRENT_PLOT_TYPE
	
	bool 	OnPlotsCtrlSelChange( Control ctrl )
	{		
		/// Iris 1/11/2010 USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION
		//m_PlotsCtrl.CheckSelectAllPlotsInGroup();
		m_PlotsCtrl.OnSelChange();		
		/// End USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION
		return true;
	}
	
	void 	OnPlotsCtrlAfterSelChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
	{
		/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
		if( !m_PlotsCtrl.IsAllowSelectChangeEvent() )
			return;
		///End TO_IMPROVE_UNGROUP_SPEED
		onSelPlotsListEnableButtons();
	}
	
	void OnPlotsCtrlBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel)
	{		
		m_PlotsCtrl.OnBeforeMouseDown( nButton, nShift, X, Y, pCancel );
		///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN not need call it here, but in OnContextMenu
		//onAfterDataPlotChanged();	///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE
		///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	}	
	
	///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	BOOL OnContextMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if ( IDC_LAYER_CONTENT_DATA_LIST == nResIDCtrl )
		{
			m_pDatasetList->OnContextMenu(nx, ny);
			return TRUE;
		}
		else if ( IDC_PLOTS_CTRL == nResIDCtrl )
		{
			m_PlotsCtrl.OnContextMenu(nx, ny);
			onAfterDataPlotChanged();
			return TRUE;
		}
		return FALSE;
	}
	///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	/// Iris 1/11/2010 USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION
	void OnPlotsCtrlMouseUp(Control cntrl, short nButton, short nShift, float X, float Y)
	{		
		m_PlotsCtrl.OnMouseUp( nButton, nShift, X, Y );
	}
	///End USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION
	
	bool OnMoveUpDataPlots( Control ctrl )
	{
		/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
		/*
		vector<uint> vuSelRows;
		if( m_PlotsCtrl.GetSelRows( vuSelRows ) )
		{		
			int nSelRow = vuSelRows[0];
			int nNewRow = nSelRow - 1;
			if( m_PlotsCtrl.MoveDataPlot(nSelRow, nNewRow) )
			{
				onAfterDataPlotChanged();
				return true;
			}
		}
		*/
		if( m_PlotsCtrl.MoveDataPlots(true) )
		{
			onAfterDataPlotChanged();
			return true;
		}
		///End TO_MOVE_WHOLE_GROUP
		return false;	
	}

	bool OnMoveDownDataPlots( Control ctrl )
	{
		/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
		/*
		vector<uint> vuSelRows;
		if( m_PlotsCtrl.GetSelRows( vuSelRows ) )
		{		
			int nSelRow = vuSelRows[0];
			int nNewRow = nSelRow + 1;
			if( m_PlotsCtrl.MoveDataPlot(nSelRow, nNewRow) )
			{
				onAfterDataPlotChanged();
				return true;
			}
		}
		*/
		if( m_PlotsCtrl.MoveDataPlots(false) )
		{
			onAfterDataPlotChanged();
			return true;
		}
		///End TO_MOVE_WHOLE_GROUP
		return false;
	}
	
private:	
	bool enableDlgItems()
	{
		m_btnApply.Enable = false;
		m_btnGroupPlots.Enable = m_btnUnGroupPlots.Enable = false;

		//m_btnPlotType.Enable = 
		//m_btnPlotTypeDropDown.Enable = 
		m_btnAddPlot.Enable = m_btnRemovePlot.Enable = false;		

/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS		
// will call this method in DatasetList::UpdateDatasetList
#ifndef SUPPORT_COMMON_UDLS
		m_pDatasetList->InitColsShowHidden();		
#endif 
///End SHOW_COMMON_UDLS
		
		onSelDatasetListEnableButtons();
		onSelPlotsListEnableButtons();
		
		return true;
	}
	
	void setMainPaneControlsPosition()
	{
		RECT rrMain;
		Control ccMain;
		GetControlClientRect(IDC_PLOTS_CTRL, rrMain, &ccMain);
		
		// for top buttons
		uint vnTopButtonIDs[] = {
									IDC_LAYER_CONTENT_GROUP_BUTTON,
									IDC_LAYER_CONTENT_UNGROUP_BUTTON,
									IDC_LAYER_CONTENT_MOVE_UP_DATA_PLOTS,
									IDC_LAYER_CONTENT_MOVE_DOWN_DATA_PLOTS,
									IDC_CHECK_LAYER_CONTENTS_RESCALE,
									0
									};
		ArrangeControlsLeftRight(vnTopButtonIDs, rrMain.left, GetControlGap());				
		
		// move main control
		RECT rrButton;
		GetControlClientRect(vnTopButtonIDs[0], rrButton);
		rrMain.top = GetControlGap() + RECT_HEIGHT(rrButton) + GetControlGap();
		
		uint vnButtonIDs[] = {
									IDC_BTN_SHOW_LEFT_PANEL,
									IDC_LAYER_CONTENT_LAYER_PROPERTIES_BUTTON,
									IDC_LAYER_CONTENT_PLOT_SETUP_BUTTON,
									IDC_APPLY_BUTTON,
									IDOK,
									IDCANCEL,
									0
									};
		ArrangeControlsLeftRight(vnButtonIDs, rrMain.left, rrMain.bottom + GetControlGap());				
		MoveControl(ccMain, rrMain);
		
	}
	
	void setSubPaneControlsPosition()
	{		
		if( !IsBottomPaneShown() )
			return;		
		
		int nGap = GetControlGap();		
		RECT rrDataList, rrAvalidDataCombo, rrAddData;			
		Control ccDataList;
		GetControlClientRect(IDC_LAYER_CONTENT_DATA_LIST, rrDataList, &ccDataList);
		GetControlClientRect(IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX, rrAvalidDataCombo);
		/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		RECT rrIncShortcutWindowsCheck;
		GetControlClientRect(IDC_LAYER_CONTENTS_INCLUDE_SHORTCUT, rrIncShortcutWindowsCheck);
		///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		GetControlClientRect(IDC_LAYER_CONTENT_ADD_PLOT, rrAddData);
		
		// 1. move avlid data combo and inc shortuct windows checkbox
		rrAvalidDataCombo.left = nGap; 
		rrAvalidDataCombo.top = nGap; 		
		MoveControl(IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX, rrAvalidDataCombo.left, rrAvalidDataCombo.top);	
		
		/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		GetControlClientRect(IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX, rrAvalidDataCombo); // get the new rect after moving for avail datatype combobox
		rrIncShortcutWindowsCheck.left = nGap; 
		rrIncShortcutWindowsCheck.top = rrAvalidDataCombo.top + RECT_HEIGHT(rrAvalidDataCombo) + nGap; 		
		MoveControl(IDC_LAYER_CONTENTS_INCLUDE_SHORTCUT, rrIncShortcutWindowsCheck.left, rrIncShortcutWindowsCheck.top);
		GetControlClientRect(IDC_LAYER_CONTENTS_INCLUDE_SHORTCUT, rrIncShortcutWindowsCheck); // get the new rect after moving 
		///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		
		// 2. Move add plot and remove plot button at the center of dialog
		RECT rDlg;
		m_wndDlg.GetClientRect(&rDlg);
		/// Iris 12/29/2010 ORG-1879 ADD_PLOTTYPE_BMP_BUTTON
		/*
		int nButtonHeight = RECT_HEIGHT(rrAddData);
		int nRight = rrDataList.right;
		int nBottom = (RECT_HEIGHT(rDlg) - nGap)/2;
		MoveControl(IDC_LAYER_CONTENT_ADD_PLOT, nRight, nBottom, false);	
		
		nBottom += nGap + nButtonHeight;
		MoveControl(IDC_LAYER_CONTENT_REMOVE_PLOT, nRight, nBottom, false);	
		
		GetControlClientRect(IDC_LAYER_CONTENT_ADD_PLOT, rrAddData); // get new position		
		rrDataList.right = rrAddData.left - nGap;
		*/		
		RECT rrPlotType, rrSwitchPlotType;
		GetControlClientRect(IDC_PLOT_TYPE_BITMAP_BUTTON, rrPlotType);
		GetControlClientRect(IDC_PLOT_TYPE_SWITCH_BUTTON, rrSwitchPlotType);		
		
		int nAddButtonBottom = (RECT_HEIGHT(rDlg) + RECT_HEIGHT(rrAddData)) / 2;
		int nPlotTypeDropDownRight = rrDataList.right;		
		int nPlotTypeDropDownBottom = nAddButtonBottom - RECT_HEIGHT(rrAddData) - nGap;
		
		int nAddButtonRight = nPlotTypeDropDownRight - (RECT_WIDTH(rrPlotType) + RECT_WIDTH(rrSwitchPlotType) - RECT_WIDTH(rrAddData))/2 ;
		
		int nPlotTypeButtonBottom = nPlotTypeDropDownBottom;
		int nPlotTypeButtonRight = nPlotTypeDropDownRight - RECT_WIDTH(rrSwitchPlotType);
		
		MoveControl(IDC_LAYER_CONTENT_ADD_PLOT, nAddButtonRight, nAddButtonBottom, false);		
		MoveControl(IDC_PLOT_TYPE_BITMAP_BUTTON, nPlotTypeButtonRight, nPlotTypeButtonBottom, false);		
		MoveControl(IDC_PLOT_TYPE_SWITCH_BUTTON, nPlotTypeDropDownRight, nPlotTypeDropDownBottom, false);	
		MoveControl(IDC_LAYER_CONTENT_REMOVE_PLOT, nAddButtonRight, nAddButtonBottom + nGap + RECT_HEIGHT(rrAddData), false);	
		
		GetControlClientRect(IDC_PLOT_TYPE_BITMAP_BUTTON, rrPlotType);// get new position after moving
		rrDataList.right = rrPlotType.left - nGap;
		///End ADD_PLOTTYPE_BMP_BUTTON				
		
		// 3. resize data list
		/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		//rrDataList.top = rrAvalidDataCombo.top + RECT_HEIGHT(rrAvalidDataCombo) + nGap;		
		rrDataList.top = rrIncShortcutWindowsCheck.bottom + nGap;
		///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		rrDataList.bottom = rDlg.bottom - nGap;
		MoveControl(ccDataList, rrDataList);
	}

	bool initPlotsListControl()
	{
		m_PlotsCtrl.Init( IDC_PLOTS_CTRL, *this, m_pDatasetList->GetType() );
		m_PlotsCtrl.SetIsRescale(m_chkRescale.Value);
		
		///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
		/// Bill 02/24/2011 ORG-2331-S1 ADD_TOOL_TIP_TO_LAYER_CONTENT_DLG			
		//string strToolTip(STR_RIGHT_CLICK_ROW_HEADER_TOOL_TIP);
		//m_PlotsCtrl.SetToolTipsText(strToolTip);
		/// End ADD_TOOL_TIP_TO_LAYER_CONTENT_DLG
		///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
		
		return TRUE;
	}
	
	void showHideSubPaneControls()
	{
		vector<uint> vnCntrls = {
			IDC_LAYER_CONTENT_DATA_LIST,
			IDC_LAYER_CONTENT_AVAIL_DATA_COMBO_BOX,
			IDC_LAYER_CONTENTS_INCLUDE_SHORTCUT, /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
			IDC_LAYER_CONTENT_ADD_PLOT,
			IDC_LAYER_CONTENT_REMOVE_PLOT,
			/// Iris 12/29/2010 ORG-1879 ADD_PLOTTYPE_BMP_BUTTON
			IDC_PLOT_TYPE_SWITCH_BUTTON,
			IDC_PLOT_TYPE_BITMAP_BUTTON
			///End ADD_PLOTTYPE_BMP_BUTTON
		};

		bool bShowRight = IsBottomPaneShown();
		for(int nn = 0; nn < vnCntrls.GetSize(); nn++)
			GetItem(vnCntrls[nn]).Visible = bShowRight;	

	}
	
	GraphPage getGraphPage()
	{
		///-----Kit 05/23/2011 ORG-2939-P1 CAN_NOT_GET_CORRECT_GRAPH_PAGE_AFTER_ACTIVE_WKS_FROM_PLOT_DT
		//return Project.Pages();
		ASSERT(m_gp.IsValid());
		return m_gp;
		///-----End CAN_NOT_GET_CORRECT_GRAPH_PAGE_AFTER_ACTIVE_WKS_FROM_PLOT_DT
	}

	bool	addDataPlots( int nPlotID )
	{
		Tree trNewPlots;
		DWORD dwLayerBits = m_PlotsCtrl.GetLayerBits();
		if( !m_pDatasetList->GetDataPlotsTree( nPlotID, dwLayerBits, trNewPlots ) )
		{
			///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
			//ASSERT(false);
			//error_report( "GetDataPlotsTree failed!!" );

			///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
			return false;
		}
		/// Iris 01/05/2011 ORG-1682-P1 FIX_NOT_GROUPED_DATAPLOTS_WHEN_DATA_FROM_DIFF_SHEET
		/*
		foreach( TreeNode tnPlots in trNewPlots.Children )
		{
			m_PlotsCtrl.AddDataPlots( tnPlots, ADDPLOTSFROMTREE_EDIT );
		}
		*/
		if( m_PlotsCtrl.AddDataPlots( trNewPlots, ADDPLOTSFROMTREE_EDIT ) )
		{
		///End FIX_NOT_GROUPED_DATAPLOTS_WHEN_DATA_FROM_DIFF_SHEET
		
			/// Iris 01/07/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED_MORE
			//UpdateDatasetListAndPlotListBoldStatus(true, true); /// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
			m_pDatasetList->UpdateBlodStatusForSelectedRows();	
			///End SETBOLD_CAUSE_SLOW_SPEED_MORE
			
			///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
			vector<int> vnTypes;
			int nCurSel = m_pComboAvailData->GetCurSel();
			if(WKS_FOLDER == nCurSel || WKS_PROJECT == nCurSel || WKS_FAVS == nCurSel)
			{
				if(m_pDatasetList->GetWksInGLayerDropdown() < 0)//WBook dropdown is always with Wks dropdown, so check one of them is ok
					vnTypes.Add(EXIST_WKS);
			}			
			else if(MAT_FOLDER == nCurSel || MAT_PROJECT == nCurSel || MAT_FAVS == nCurSel)
			{
				if(m_pDatasetList->GetMatInGLayerDropdown() < 0)
					vnTypes.Add(EXIST_MATRIX);
			}
			else
			{
				int nFilterFuncIndex;
				if( m_pDatasetList->IsFilterByFunction(nCurSel, nFilterFuncIndex) )
				{
					if(m_pDatasetList->GetWksInGLayerDropdown() < 0)
						vnTypes.Add(EXIST_WKS);
					if(m_pDatasetList->GetMatInGLayerDropdown() < 0)
						vnTypes.Add(EXIST_MATRIX);
					m_pDatasetList->CheckGetCommonPageTypesInSelection(vnTypes);
				}
			}
			
			if(vnTypes.GetSize() > 0)
				m_pComboAvailData->AddWksOrMatInGLayerDropdown(vnTypes);
			///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT

			onSelPlotsListEnableButtons();
			onAfterDataPlotChanged();
		}

		return true;
	}

	///-----Kit 01/07/2011 ORG-864-P1 DISABLE_ADD_PLOT_BTN_WHEN_SEL_ROW_IS_WKS_TYPE_AND_PLOT_TYPE_IS_MAT_USE_ONLY
	/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
	//bool	getPlotIDByAutoSelected( int &nPlotID )
	bool	getPlotIDFromStyleHolder( int &nPlotID )
	///End IMPROVE_PLOTTYPE_CHECK
	{
		int nStyleHolderPlotID;
		if( m_PlotsCtrl.GetCurrentStyleHolderPlotID( nStyleHolderPlotID ) )
		{
			/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
			/*
			if( EXIST_WKS == m_pDatasetList->GetType() )
			{
				if( IDM_PLOT_CONTOUR == nStyleHolderPlotID )
				{
					nPlotID = IDM_PLOT_TRI_CONTOUR;
					return true;
				}
				else if( is_matrix_plot_id(nStyleHolderPlotID) )
				{
					nPlotID = IDM_PLOT_3D_LINE;				
					return true;
				}
			}	
			*/
			///End IMPROVE_PLOTTYPE_CHECK
			nPlotID = nStyleHolderPlotID;
			return true;
		}

		return error_report( "OnAddPlots(), m_PlotsCtrl.GetCurrentStyleHolderPlotID()  is failed" );
	}
	///-----End DISABLE_ADD_PLOT_BTN_WHEN_SEL_ROW_IS_WKS_TYPE_AND_PLOT_TYPE_IS_MAT_USE_ONLY

	///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
	bool	GetShowErrorMsg(string &strErrMsg)
	{
		bool bRet = true;
		switch( m_errLast )
		{
		case Err_CanNotAdd2DPlotTo3DLayer:
			{
				string strTmp;
				ocu_load_err_msg_str(MSG_CAN_NOT_PLOT_2D_PLOT_TO_3D_LAYER, &strTmp);	///-----Kit 05/04/2011 ORG-2614-S1 MOVE_ERR_MSG_TO_VC
				strErrMsg.Format(strTmp, GetPlotTypeName(m_nPlotID) );
			}
			break;
		///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
		case Err_CurrentPlotTypeNeedAllColsInSameWks:
			ocu_load_err_msg_str(MSG_CURR_PLOT_TYPE_NEDD_ALL_COLS_IN_SAME_WKS, &strErrMsg);	///-----Kit 05/04/2011 ORG-2614-S1 MOVE_ERR_MSG_TO_VC
			break;
		case Err_SelColsNumIsNotCorrespondThePlotType:
			{
				string strTmp;
				ocu_load_err_msg_str(MSG_SEL_COL_NUM_IS_NOT_CORRESPOND_THE_CURR_PLOT_TYPE, &strTmp);	///-----Kit 05/04/2011 ORG-2614-S1 MOVE_ERR_MSG_TO_VC
				int nColNeed = 0;
				if( IDM_PLOT_VECTOR == m_nPlotID )
					nColNeed = 3;
				strErrMsg.Format(strTmp, nColNeed);
			}
			break;
		///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
		
		/// Iris 6/14/2011 ORG-2857-P2 SHOW_ERR_MSG_FOR_NOT_SUPPORTED_PLOT_TYPE
		case Err_CurrentPlotTypeNotSupportInLC:
			{
				string strTmp;
				ocu_load_err_msg_str(MSG_LC_DLG_NOT_SUPPORTED_PLOTTYPE, &strTmp);
				strErrMsg.Format(strTmp, GetPlotTypeName(m_nPlotID) );
			}			
			break;
		///End SHOW_ERR_MSG_FOR_NOT_SUPPORTED_PLOT_TYPE	
		default:
			bRet = false;
			break;
		}

		return bRet;
	}
	///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER

private:
	DatasetList				*m_pDatasetList;
	AvailDataCombo			*m_pComboAvailData;
	LayerPlotList			m_PlotsCtrl;
	int						m_nPlotIDFromBitmapButton;
	/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
	int						m_nPlotID; 
	string					m_strPlottingMsg;
	///End IMPROVE_PLOTTYPE_CHECK
	
	///Jasmine 01/17/11 ORG-1997-S5 SHOW_HINTS_WHEN_BTN_DISABLE
	BitmapRadioButton		m_btnAddPlot;
	BitmapRadioButton		m_btnRemovePlot;
	///End SHOW_HINTS_WHEN_BTN_DISABLE
	Button 					m_btnGroupPlots;
	Button 					m_btnUnGroupPlots;
	BitmapRadioButton 		m_btnUp;
	BitmapRadioButton		m_btnDown;
	Button 					m_btnCancel;
	Button 					m_btnOK;
	Button					m_btnApply;
	Button					m_chkRescale;
	Button					m_chkIncShortcut;
	
	/// Iris 12/29/2010 ORG-1879 ADD_PLOTTYPE_BMP_BUTTON
	BitmapRadioButton		m_btnPlotType;
	BitmapRadioButton		m_btnPlotTypeDropDown;
	///End ADD_PLOTTYPE_BMP_BUTTON

	ErrorInfo				m_errLast;///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER

	GraphPage				m_gp;	///-----Kit 05/23/2011 ORG-2939-P1 CAN_NOT_GET_CORRECT_GRAPH_PAGE_AFTER_ACTIVE_WKS_FROM_PLOT_DT

};

//---- CPY 12/20/10 PROPER_CODE_FOR_CALLED_FROM_VC_TO_OPEN_DLG
/*
bool OpenLayerPlotContentsDlg( HWND hParent = NULL )
{
	GraphLayer gl = Project.ActiveLayer();
	
	if( !gl.IsValid() )
	{
		error_report( "Not Graph Layer. Open failed!" );
		return false;
	}

	LayerPlotContentsDlg lc;
	int nRet = lc.DoModalEx( hParent );

	return nRet >= 0 ? true : false;
}
*/
// return IDOK or IDCANCEL

#define	GET_PLOT_TYPE_FROM_PARAM( _lpPlotID ) (*(int*)(_lpPlotID) )	///-----Kit 01/04/2011 ORG-1837-S4 GET_PLOT_ID_WHEN_CLICK_GRAPH_ADD_PLOT
int LayerContentsDlg(int nMsg, DWORD dwCntrl, LPVOID lpData)
{
	if(nMsg != OMSG_OPEN)
		return -100;

	///-----Kit 01/04/2011 ORG-1837-S4 GET_PLOT_ID_WHEN_CLICK_GRAPH_ADD_PLOT
	//LayerPlotContentsDlg lc;
	int nPlotID = IDM_PLOT_UNKNOWN;
	if( NULL != lpData )
	{
		nPlotID = GET_PLOT_TYPE_FROM_PARAM( lpData );
	}
	LayerPlotContentsDlg lc( nPlotID );
	///-----End GET_PLOT_ID_WHEN_CLICK_GRAPH_ADD_PLOT

	return lc.DoModalEx( GetWindow(OGW_MDICLIENT) );
}
//---- end PROPER_CODE_FOR_CALLED_FROM_VC_TO_OPEN_DLG
