/*------------------------------------------------------------------------------*
 * File Name: ImportMenuCustomizationDlg.h										*
 *																				*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2010										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _CUSTOMIMPMENUDLG_H_
#define _CUSTOMIMPMENUDLG_H_

typedef enum {
	MENU_TYPE_FILE_TYPE,
	MENU_TYPE_THEME,
	MENU_TYPE_ALL,
} MENU_TYPE;

typedef enum {
	COL_TYPE_NAME,
	COL_TYPE_XF,
	COL_TYPE_THEME,
	COL_TYPE_COMMAND,
	COL_TYPE_DATE,
	COL_TYPE_EXT,
	COL_TYPE_TOOLTIP,
	COL_TYPE_TAGNAME,
} COL_TYPE;

#define TOTAL_SHOWN_COLS COL_TYPE_TOOLTIP + 1

////////////////////////////////////////////////////////////////////////////////////

class MenuListBase : public GridTableControl
{
public:
	MenuListBase();
	~MenuListBase();

	bool Init(UINT uID, WndContainer &Dlg);

private:
};

class CurrentMenuListModifyMenu : public Menu
{
public:
	CurrentMenuListModifyMenu();

	int GetCommand() { return m_nChoice; }

	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}

private:
	int m_nChoice;
};

class CurrentMenuList : public MenuListBase
{
public:
	CurrentMenuList();
	~CurrentMenuList();

	bool Init(UINT uID, WndContainer &Dlg);

	bool FillCurrentMenuContent(vector<string>& vsItems);

	void MoveItemsUp();
	void MoveItemsDown();

	void RemoveItems();

	void DoMenuListModifyMenu(int nx, int ny);

	void AddMenuItems(int nRows, vector<string> & vsItem);

	// virtual
	string GetClassName() { return "CurrentMenuList"; }

private:
	int getGroupDefaultShows(vector<uint>& vnDefaultShows, int nGroup);
};

class TotalMenuList : public MenuListBase
{
public:
	TotalMenuList();
	~TotalMenuList();

	bool Init(UINT uID, WndContainer &Dlg);

	// virtual
	string GetClassName() { return "TotalMenuList"; }

private:

	// virtual 
	int getGroupDefaultShows(vector<uint>& vnDefaultShows, int nGroup);
};

////////////////////////////////////////////////////////////////////////////////////

struct MenuInfo
{
	string strName;
	string strXF;
	string strThemePath;
	string strLTCmd;
	string strDate;
	string strToolTip;
	string strExt;
	string strTag;
};

class CustomizationHelper
{
public:
	CustomizationHelper(int nImportOrExport);

	int GetCurrentMenuList(vector<string> & vsTableValues, bool & bIsShowAddRemove, bool bSystem);
	int GetTotalMenuList(MENU_TYPE type, vector<string> & vsTableValues);	
	bool SaveCustomizeMenu(CurrentMenuList * pCurrentList, bool bIsShowAddRemove);
	int GetNumberOfTheme(vector<string> & vsTagName);
	
private:
	bool updateTotalMenuTree();
	//void menuInfoAddToStringVector(Array<MenuInfo&> & arrInfo, vector<string> & vs);
	void constructMeunList(CurrentMenuList * pCurrentList, TreeNode & trCurrentMenu, bool bIsShowAddRemove);
	void addMenuItem(TreeNode & trMenu, LPCSTR lpcszTagName, int & nThemeHotKey);
	void addAddRemoveMenuItem(TreeNode & trMenu, bool bShowAddRemove);

	bool getMenuItemInfo(TreeNode & trXF, TreeNode & trMenuItem, MenuInfo * pInfo);
	string getPath(int nPathType, bool bIsTheme);

	bool readCurrentMenuConfig(bool bSystem);
	int parseMenu(vector<string> & vsTableValues, bool & bShowAddRemoveMenuItem);

	TreeNode getCurrentPageMenu();

	void menuInfoAddToStringVector(MenuInfo & st, vector<string> & vs);
	void menuInfoAddToStringVector(Array<MenuInfo&> & arrInfo, vector<string> & vs);

private:
	Tree m_trTotalMenu;
	Array<MenuInfo&> m_arrTotalXF;
	Array<MenuInfo&> m_arrTotalTheme;

	Tree m_trCurrentMenu;
	TreeNode m_trWksMenu;
	TreeNode m_trGraphMenu;
	TreeNode m_trMatrixMenu;

	int m_nPageType;
	int m_nImportOrExport;
};

////////////////////////////////////////////////////////////////////////////////////

class CustomImpMenuDlg : public ResizeDialog
{
public:
	CustomImpMenuDlg(int nImportOrExport);
	~CustomImpMenuDlg();

	int DoModalEx(HWND hWndParent = NULL);

protected:

	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_OK(OnOK)
		ON_READY(OnReady)
		ON_SIZE(OnDlgResize)
		ON_DESTROY(OnDestroy)

		ON_BN_CLICKED(IDC_BUTTON_ADD_MENU, OnAddMenu)
		ON_BN_CLICKED(IDC_BUTTON_REMOVE_MENU, OnRemoveMenu)
		ON_BN_CLICKED(IDC_BUTTON_UP, OnUp)
		ON_BN_CLICKED(IDC_BUTTON_DOWN, OnDown)
		ON_BN_CLICKED(IDC_BUTTON_RESET, OnReset)
		ON_BN_CLICKED(IDC_CHECK_HIDE_MENU, OnShowAddRemoveMenu)

		/// Bill 09/26/2011 ORG-3795-P1 MOVE_UP_AND_MOVE_DOWN_SLOW_IN_GRID_TABLE
		// BN_DOUBLECLICKED notification code Sent when the user double-clicks a button. 
		// This notification code is sent automatically for BS_USERBUTTON, BS_RADIOBUTTON, and BS_OWNERDRAW buttons. 
		// Other button types send BN_DOUBLECLICKED only if they have the BS_NOTIFY style.
		// the up and down button is BitmapRadioButton, which is BS_OWNERDRAW button.
		// I handle double click event so that user woundn't feel slow.
		ON_BN_DOUBLECLICKED(IDC_BUTTON_UP, OnUp)
		ON_BN_DOUBLECLICKED(IDC_BUTTON_DOWN, OnDown)
		/// End MOVE_UP_AND_MOVE_DOWN_SLOW_IN_GRID_TABLE

		ON_CBN_SELCHANGE(IDC_COMBO_MENU_TYPE, OnMenuTypeChange)
		
		ON_GRID_BEFORE_MOUSE_DOWN(IDC_GRID_TOTAL_MENU, OnTotalMenuListBeforeMouseDown)		
		ON_GRID_SEL_CHANGE(IDC_GRID_TOTAL_MENU, OnTotalMenuListSelChange)
		ON_GRID_DBLCLICK(IDC_GRID_TOTAL_MENU, OnTotalMenuListDbClick) /// Bill 09/15/2011 ORG-3395-S7 ADD/REMOVE_MENU_ITME_WHEN_DOUBLE_CLICK
		
		ON_GRID_BEFORE_MOUSE_DOWN(IDC_GRID_CURRENT_MENU, OnCurrentMenuListBeforeMouseDown)
		ON_GRID_SEL_CHANGE(IDC_GRID_CURRENT_MENU, OnCurrentMenuListSelChange)
		ON_GRID_DBLCLICK(IDC_GRID_CURRENT_MENU, OnCurrentMenuListDbClick) /// Bill 09/15/2011 ORG-3395-S7 ADD/REMOVE_MENU_ITME_WHEN_DOUBLE_CLICK

		ON_CONTEXTMENU(OnContextMenu)
	EVENTS_END

	bool OnInitDialog();
	bool OnOK();
	bool OnReady();
	bool OnDlgResize(int nType, int cx, int cy);
	bool OnDestroy();

	bool OnAddMenu(Control);
	bool OnRemoveMenu(Control);
	bool OnUp(Control);
	bool OnDown(Control);
	bool OnReset(Control);
	bool OnShowAddRemoveMenu(Control);

	bool OnMenuTypeChange(Control);

	void OnCurrentMenuListBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL * pCancel);
	void OnCurrentMenuListSelChange(Control cntrl);
	void OnCurrentMenuListDbClick(Control cntrl); /// Bill 09/15/2011 ORG-3395-S7 ADD/REMOVE_MENU_ITME_WHEN_DOUBLE_CLICK
	
	void OnTotalMenuListBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL * pCancel);
	void OnTotalMenuListSelChange(Control cntrl);
	void OnTotalMenuListDbClick(Control cntrl);	/// Bill 09/15/2011 ORG-3395-S7 ADD/REMOVE_MENU_ITME_WHEN_DOUBLE_CLICK

	BOOL OnContextMenu(UINT nResIDCtrl, int nx, int ny);

private:
	void switchMenuType(MENU_TYPE type);
	void initCurrentMenu(bool bSystem);
	bool checkAddTheme(vector<uint> vnSelectToAdd);

	void updateFontColor();
	void updateButtonState();
	
	void removeMenu();
	void addMenu();

	string m_strMenu;
	bool m_bShowAddRemove;
	int m_nImportOrExport;
	
private:
	BitmapRadioButton m_btnDown;
	BitmapRadioButton m_btnUp;
	BitmapRadioButton m_btnAddMenu;
	BitmapRadioButton m_btnRemoveMenu;

	ComboBox m_cbMenuType;
	Button m_chkShowAddRemove;

	CurrentMenuList m_GridCurrentMenuList;
	TotalMenuList m_GridTotalMenuList;

	CustomizationHelper * m_pCustomMenuControl;
};

#endif // _CUSTOMIMPMENUDLG_H_
