/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 9/2/2011 CHANGE_GUI_TO_SHOW_FROM_HIDE_FOR_ADD_REMOVE_COMMAND			*
 *	Folger 10/13/2011 ORG-3861-P1 FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J	*
 *	Kit 10/24/2011 ORG-4157-P1 DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
 *	Kit 11/02/2011 ORG-4296-P1 IMPORT_CUSTOMIZE_MENU_NOT_UPDATE					*
 *	Kit 12/15/2011 ORG-4609-P1 READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_IMPORT_MENU_XML_FILE
 *	Tony 09/14/2012 ORG-6808-P1 REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU	*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <..\OriginLab\DialogEx.h>
#include <..\OriginLab\XFTree.h>
#include <..\OriginLab\XFunction.h>
#include <ocMenuid.h>
#include <Array.h>
#include "GridTableControl.h"
#include "ImportMenuCustomizationDlg.h"
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

////////////////////////////////////////////////////////////////////////////////////

#define STR_GRID_HEADER _L("Name|X-Function|Theme|Command|Date|Extension|Tooltips|TagName")

#define STR_MODIFY_CONTEXT_MENU_ADD_SEP _L("Add Separator")

#define STR_SEP_ITEM			_L("----- Separator -----")
#define STR_SEP_TAG				STR_TAG_NAME_PREFIX_SEPARATOR

#define STR_ADD_REMOVE_ITEM_DISP	_L("Customize...")

//---- CPY 9/2/2011 CHANGE_GUI_TO_SHOW_FROM_HIDE_FOR_ADD_REMOVE_COMMAND
//#define STR_HIDE_ADD_REMOVE_ITEM_TAG		_L("Customize")
//#define STR_DLG_NAME _L("MenuCustomizeDlg")
#define STR_DLG_NAME 					"ImportMenuCustomizeDlg"
#define STR_SHOW_ADD_REMOVE_ITEM_TAG	"ShowCustomizeMenu"
//----

#define STR_ADD_REMOVE_LT_COMMAND		"customMenu 0"

#define MENU_HOT_KEY '&'

#define NAME_COL_DEFAULT_WIDTH	2000

static string _get_menu_name(int nImportOrExport)
{
	switch (nImportOrExport)
	{
	case MCPT_FILEIMPORT:
		return _L("I&mport");
		
	case MCPT_FILEEXPORT:
		return _L("&Export");
		
	default:
		ASSERT(false);	
	}
	
	return "";
}

static string _get_menu_configure_file_name(int nImportOrExport, bool bRead, bool bSystem)
{
	string strFileName;	
	switch (nImportOrExport)
	{
	case MCPT_FILEIMPORT:
		strFileName = STR_CUS_MENU_XF_IMPORT_FILE_NAME;
		break;
		
	case MCPT_FILEEXPORT:
		strFileName = STR_CUS_MENU_XF_EXPORT_FILE_NAME;
		break;
		
	default:
		ASSERT(false);
		return "";
	}

	string strDir;
	okutil_get_theme_sub_folder_path(THTYPE_MENU, &strDir);
	
	string strSysFile = GetOriginPath(ORIGIN_PATH_SYSTEM) + strDir + strFileName;
	if (bSystem)
		return strSysFile;
	
	string strUserFile = GetOriginPath(ORIGIN_PATH_USER) + strDir + strFileName;
	///-----Kit 12/15/2011 ORG-4609-P1 READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_IMPORT_MENU_XML_FILE
	if ( bRead && !strUserFile.IsFile() )
		strUserFile = GetOriginPath(ORIGIN_PATH_GROUP) + strDir + strFileName;
	///-----End READ_GROUPSHARED_FOLDER_WHEN_UFF_NOT_HAVE_IMPORT_MENU_XML_FILE
	if (bRead)
	{
		if (strUserFile.IsFile())
			return strUserFile;

		if (strSysFile.IsFile())
			return strSysFile;

		return "";
	}
	
	return strUserFile;
}

static bool _save_menu_customize_result(int nImportOrExport, Tree * ptrMenu)
{
	string strFullPath = _get_menu_configure_file_name(nImportOrExport, false, false);
	
	CheckMakePath(GetFilePath(strFullPath));
	
	return ptrMenu->Save(strFullPath);
}

static bool _load_menu_customize_result(int nImportOrExport, Tree * ptrMenu, bool bSystem)
{
	string strFullPath = _get_menu_configure_file_name(nImportOrExport, true, bSystem);

	return ptrMenu->Load(strFullPath);
}

static char _pageType2WndType(int nPageType)
{
	switch (nPageType)
	{		
	case EXIST_WKS:
		return 'W';

	case EXIST_GRAPH:
		return 'G';

	case EXIST_MATRIX:
		return 'M';

	default:
		ASSERT(false);
	}
	
	return '\0';
}

class ConstructTotalMenuListHelper
{
public:
	ConstructTotalMenuListHelper(LPCSTR lpcszName, LPCSTR lpcszFile)
	{
		m_lpcszName = lpcszName;
		m_lpcszFile = lpcszFile;
		m_nGetN = -1;
	}
	
	bool Construct(TreeNode& trMenu)
	{
		if (!m_trXFInfo.Load(m_lpcszFile))
			return false;
				
		///Sophy 5/16/2012 ORG-5707-P1 USER_XF_WITH_EMPTY_DESCRIPTION_FAIL_TO_SHOW_IN_MENU
		if ( !isMenuEnabled() )
			return false;
		///end USER_XF_WITH_EMPTY_DESCRIPTION_FAIL_TO_SHOW_IN_MENU
		TreeNode trDesc;	
		string strXFDesp, strXFName;		
		if (octree_get_localization_node(&trDesc, &m_trXFInfo, IDV_HELP_DESCRIPTION, IDXF_DESCRIPTION, IDV_HELP_BRANCH, TRUE, IDRS_HELP_E))
		{
			xf_seperate_description(trDesc.strVal, strXFName, strXFDesp);
			///Sophy 5/16/2012 ORG-5707-P1 USER_XF_WITH_EMPTY_DESCRIPTION_FAIL_TO_SHOW_IN_MENU
			if ( strXFName.IsEmpty() )
				strXFName = m_lpcszName;
			///end USER_XF_WITH_EMPTY_DESCRIPTION_FAIL_TO_SHOW_IN_MENU
		}

		if (strXFName.IsEmpty())
			return false;
		
		TreeNode trXF = InsertXFNode(trMenu);
		
		if ( !lstrcmpi(m_lpcszName, "impasc") )
		{
			StringArray	arrCombo;
			getImpascMenuName(arrCombo);
	
			if (arrCombo.GetSize() != 2)
				return false;
			
			TreeNode trImpascS = trXF.AddNode("impASC_S");
			addMenuItemInfo(trImpascS, arrCombo[0], m_lpcszFile, strXFDesp, "impASC -dm m:=0", getXFext(m_lpcszName), false);
			trImpascS.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_G, "Einzelne&s ASCII...");
			trImpascS.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_J, "PASCIIt@C(&S)...");
			trImpascS.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_C, arrCombo[0]);
			
			TreeNode trImpascM = trXF.AddNode("impASC_M");
			addMenuItemInfo(trImpascM, arrCombo[1], m_lpcszFile, strXFDesp, "impASC -dm m:=1", getXFext(m_lpcszName), false);
			trImpascM.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_G, "&Mehrere ASCII...");
			trImpascM.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_J, "ASCII(&M)...");
			trImpascM.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_C, arrCombo[1]);
		}
		else
		{
			addMenuItemInfo(trXF.AddNode(m_lpcszName), strXFName, m_lpcszFile, strXFDesp, getXFLTCmd(m_trXFInfo, m_lpcszName), getXFext(m_lpcszName), false);
		}
		
		addXFTheme(trXF);
		
		return true;
	}
	
private:
	///Sophy 5/16/2012 ORG-5707-P1 USER_XF_WITH_EMPTY_DESCRIPTION_FAIL_TO_SHOW_IN_MENU
	bool isMenuEnabled()
	{
		TreeNode trMenuUse = tree_get_node_by_id(m_trXFInfo, IDXF_USGCTXT_MAIN_MENUS, true);
		if ( trMenuUse )
		{
			if ( trMenuUse.Use == 0 )
				return false;
			return true;
		}
		return false;
	}
	///end USER_XF_WITH_EMPTY_DESCRIPTION_FAIL_TO_SHOW_IN_MENU
	void getImpascMenuName(vector<string> & vsName)
	{
		TreeNode	trInfo = xf_get_variable_tree_node(m_trXFInfo, "menu");
		ASSERT(trInfo);
		trInfo.comboString.strVal.GetTokens(vsName, '|');
		
		ASSERT(vsName.GetSize() == 2);
		
		for (int i = 0 ; i < vsName.GetSize() ; ++i)
			vsName[i].Delete(0, vsName[i].Find(':') + 1);
	}

	///-----Kit 10/24/2011 ORG-4157-P1 DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
	DWORD getAllowWinBits()
	{
		ASSERT(m_trXFInfo.IsValid());
		
		const int winsUSGCTXTIds[] = 
		{
			IDXF_USGCTXT_WINDOW_GRAPH,
			IDXF_USGCTXT_WINDOW_WKS,
			IDXF_USGCTXT_WINDOW_MATRIX,
			IDXF_USGCTXT_WINDOW_REPORT,
			IDXF_USGCTXT_WINDOW_LAYOUT
		};
   
		const DWORD resultBits[] = 
		{
			CIAS_Graph,
			CIAS_Worksheet,
			CIAS_Matrix,
			CIAS_Report,
			CIAS_Layout
		};

		ASSERT(ARRAY_SIZE(winsUSGCTXTIds) == ARRAY_SIZE(resultBits));

		DWORD dwResult = 0;
		for (size_t ii = 0; ii < ARRAY_SIZE(winsUSGCTXTIds); ++ii )
		{
			TreeNode tr = tree_get_node_by_id(m_trXFInfo, winsUSGCTXTIds[ii], true);
			ASSERT(tr.IsValid());
			if ( 0 != tr.nVal )
				dwResult |= resultBits[ii];
		}
	
		return dwResult;
	}
	///-----End DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
	
	void addXFTheme(TreeNode & trXF)
	{	
		vector<string> vsFileName;
		vector<string> vsDisplayName;
		okutil_theme_get_class_settings(m_lpcszName, &vsFileName, &vsDisplayName, THTYPE_ANALYSIS,
										true, true, true,	// include default, last use, common
										false, false,		// not book & sheet theme
										true, true);		// include folder last use & system theme
	
		string strLTCmd;
		for (int i = 0 ; i < vsFileName.GetSize() ; ++i)
		{
			string strTagName;
			strTagName.Format("%s_%d", m_lpcszName, i);
			
			TreeNode trMenuItem = trXF.AddNode(strTagName);
			
			string strDisplayName;
			strDisplayName.Format("%s:%s", m_lpcszName, vsDisplayName[i]);			
			okutil_generate_run_xf_with_theme_ltcmd(m_lpcszName, vsDisplayName[i], strLTCmd);			
			addMenuItemInfo(trMenuItem, strDisplayName, vsFileName[i], "", strLTCmd, getXFext(m_lpcszName), true);
		}		
	}

	void addMenuItemInfo(TreeNode & trMenuItem, LPCSTR lpcszMenuName, LPCSTR lpcszFile, LPCSTR lpcszXFDesp,
							 LPCSTR lpcszLT, LPCSTR lpcszExt, bool bTheme)
	{
		///-----Kit 10/24/2011 ORG-4157-P1 DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
		const DWORD dwAllowWin = getAllowWinBits();
		trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_ALLOW_WIN, dwAllowWin);
		///-----End DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE

		trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_LABTALK_CMD_ATTRIB, lpcszLT);
		trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_EXTENSTION_ATTRIB, lpcszExt);
		
		trMenuItem.strVal = lpcszMenuName;
		trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB, lpcszXFDesp);
		if (bTheme)
		{
			if (!lstrcmpi(STR_DEFAULT, lpcszFile))
			{
				trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_THEME_PATH_TYPE_ATTRIB, ORIGIN_PATH_USER);
				trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_THEME_FILE_WITH_FULL_PATH_ATTRIB, lpcszFile);
			}
			else
			{
				trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_THEME_PATH_TYPE_ATTRIB, okutil_get_origin_path_type(lpcszFile));
				trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_THEME_FILE_WITH_FULL_PATH_ATTRIB, lpcszFile);
			}
		}
		else
		{
			trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_PATH_TYPE_ATTRIB, okutil_get_origin_path_type(lpcszFile));
			trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_FILE_WITH_FULL_PATH_ATTRIB, lpcszFile);
			
			addLocalizationAttr(trMenuItem);
		}
		
		trMenuItem.strVal += MenuSubfix();
	}

	void addLocalizationAttr(TreeNode & trMenuItem)
	{
		TreeNode trDesc;
		string strName, strDesc;
		if (octree_get_localization_node(&trDesc, &m_trXFInfo, IDV_HELP_DESCRIPTION, IDXF_DESCRIPTION, IDV_HELP_BRANCH, TRUE, IDRS_HELP_G))
		{				
			xf_seperate_description(trDesc.strVal, strName, strDesc);
			strName += MenuSubfix();
			trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_G, strName);
			trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_G, strDesc);
		}
		
		if (octree_get_localization_node(&trDesc, &m_trXFInfo, IDV_HELP_DESCRIPTION, IDXF_DESCRIPTION, IDV_HELP_BRANCH, TRUE, IDRS_HELP_J))
		{				
			xf_seperate_description(trDesc.strVal, strName, strDesc);
			strName += MenuSubfix();
			trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_J, strName);
			trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_J, strDesc);
		}
		
		if (octree_get_localization_node(&trDesc, &m_trXFInfo, IDV_HELP_DESCRIPTION, IDXF_DESCRIPTION, IDV_HELP_BRANCH, TRUE, IDRS_HELP_C))
		{				
			xf_seperate_description(trDesc.strVal, strName, strDesc);
			strName += MenuSubfix();
			trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_C, strName);
			trMenuItem.SetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_C, strDesc);
		}
	}

	string	MenuSubfix()
	{
		return isGetN() ? STR_THREE_DOTS : "";
	}
	
	LPCSTR	getXFLTCmd(TreeNode & trXFInfo, string & strXF)
	{
		if ( m_strLTCmd.IsEmpty() )
		{
			m_strLTCmd = strXF;
			
			if ( isGetN() )
			{
				m_strLTCmd += " -dm";
			}			
		}
		return (LPCSTR) m_strLTCmd;
	}
	
	LPCSTR	getXFext(LPCSTR lpcszXFName)
	{
		if ( m_strExt.IsEmpty() )
		{
			vector<string> vsExt;	
			okutil_get_xf_extension(lpcszXFName, &vsExt);
			
			/// Bill 09/16/2011 ORG-3395-S8 KEEP_EXT_SEPARATOR_CONSISTNET
			//m_strExt.SetTokens(vsExt, '|');
			vector<string> vsTokens;
			for (int i = 0 ; i < vsExt.GetSize() ; ++i)
			{
				vector<string> vsTemp;
				vsExt[i].GetTokens(vsTemp, ';');
				
				for (int j = 0 ; j < vsTemp.GetSize() ; ++j)
				{
					vsTemp[j].TrimLeft();
					vsTemp[j].TrimRight();
					
					if (vsTokens.Find(vsTemp[j]) == -1)
						vsTokens.Add(vsTemp[j]);
				}
			}			
			m_strExt.SetTokens(vsTokens, ';');
			/// End KEEP_EXT_SEPARATOR_CONSISTNET
		}
		return (LPCSTR) m_strExt;
	}

	int		isGetN()
	{
		if ( m_nGetN < 0 )
		{
			m_nGetN = tree_get_node_by_id(m_trXFInfo, IDXF_USGCTXT_GETN_DLG, true).nVal == 1;
		}
		return m_nGetN;
	}

	TreeNode	InsertXFNode(TreeNode& trRoot)
	{
		TreeNode	trSubGroup = tree_get_node_by_id(m_trXFInfo, IDV_SUBGROUP, true);
		TreeNode	trXF;
		if ( !trSubGroup )
		{
			ASSERT(FALSE);
			return trXF;
		}

		int			nSubGroup = trSubGroup.nVal;
		TreeNode	trBefore;
		foreach ( TreeNode trNode in trRoot.Children )
		{
			int		nSubGroupTemp = 0;
			if ( trNode.GetAttribute(STR_XF_EXT_SUB_GROUP, nSubGroupTemp) && nSubGroupTemp > nSubGroup )
			{
				trBefore = trNode;
				break;
			}
		}
		
		if ( trBefore )
			trXF = trRoot.InsertNode(trBefore, m_lpcszName);
		else
			trXF = trRoot.AddNode(m_lpcszName);

		trXF.SetAttribute(STR_XF_EXT_SUB_GROUP, nSubGroup);
		return trXF;
	}
	
private:
	LPCSTR	m_lpcszName;
	LPCSTR	m_lpcszFile;
	string	m_strExt;
	string	m_strLTCmd;
	int		m_nGetN;
	
	Tree m_trXFInfo;
};

static bool _get_menu_info(int nPageType, TreeNode& trTotalMenu)
{
	vector<string> vsNames;
	vector<string> vsFiles;	
	
	// IDXF_USGCTXT_WINDOW_GRAPH
	// IDXF_USGCTXT_WINDOW_MATRIX
	DWORD dwUsgCtxts = IDXF_USGCTXT_WINDOW_WKS;
	
	if (!okutil_find_files_from_map(&vsNames, &vsFiles, SUPPORTFILE_XF, FF_USE_C_NAMES, &dwUsgCtxts))
		return false;
	
	for ( int ii = 0 ; ii < vsNames.GetSize() ; ++ii )
	{
		if ( vsNames[ii].Match("imp*") )
		{			
			ConstructTotalMenuListHelper helper(vsNames[ii], vsFiles[ii]);
			helper.Construct(trTotalMenu);
		}
	}
	
	return true;
}

////////////////////////////////////////////////////////////////////////////////////

MenuListBase::MenuListBase()
{
}

MenuListBase::~MenuListBase()
{
}

bool MenuListBase::Init(UINT uID, WndContainer &Dlg)
{
	GridTableControl::Init(uID, Dlg);

	SetDlgName(STR_DLG_NAME);
	
	SetColHeaderString(STR_GRID_HEADER);
	if (!InitColsWidthFromReg())
	{
		SetColWidth(COL_TYPE_NAME, NAME_COL_DEFAULT_WIDTH);
	}

	SetAllowSelection(true);
	SetSelection(flexSelectionListBox);
	SetEditable();
	SetAlternateRowColors(); /// Bill 09/13/2011 ORG-3395-S4 SHIFT_BACKGROUND_COLOR

	return true;
}

CurrentMenuListModifyMenu::CurrentMenuListModifyMenu()
{
	m_nChoice = -1;
	
	Add(STR_MODIFY_CONTEXT_MENU_ADD_SEP, OnMenuItem, MF_STRING);
}

CurrentMenuList::CurrentMenuList()
{
}

CurrentMenuList::~CurrentMenuList()
{
}

bool CurrentMenuList::Init(UINT uID, WndContainer &Dlg)
{
	MenuListBase::Init(uID, Dlg);
	
	vector<int> vnAllCol;
	vnAllCol.Data(COL_TYPE_NAME, COL_TYPE_TOOLTIP, 1);
	AddGroup(vnAllCol);
	
	SetExplorerBar(flexExNone);
	
	return true;
}

bool CurrentMenuList::FillCurrentMenuContent(vector<string>& vsItems)
{
	return SetTableValue(vsItems, true);
}

void CurrentMenuList::MoveItemsUp()
{
	vector<uint> vnSelectedRows;	
	GetSelRows(vnSelectedRows);
	
	/// Bill 09/13/2011 ORG-3395-S4 SUPPORT_MULTI_SELECTION_FOR_MOVE_UP
	//for (int i = vnSelectedRows.GetSize() - 1 ; i >= 0 ; --i)
	for (int i = 0 ; i < vnSelectedRows.GetSize() ; ++i)
	/// End SUPPORT_MULTI_SELECTION_FOR_MOVE_UP
	{
		SetRowPosition(vnSelectedRows[i], vnSelectedRows[i] - 1);
	}
	
	/// Bill 09/14/2011 ORG-3395-S4 SCROLLBAR_SHOULD_GO_WITH_HIGHLIGHT_ITEM
	m_flx.ShowCell(vnSelectedRows[0] - 1, -1);
	/// End SCROLLBAR_SHOULD_GO_WITH_HIGHLIGHT_ITEM
}

void CurrentMenuList::MoveItemsDown()
{
	vector<uint> vnSelectedRows;	
	GetSelRows(vnSelectedRows);
	
	for (int i = vnSelectedRows.GetSize() - 1 ; i >= 0 ; --i)
	{
		SetRowPosition(vnSelectedRows[i], vnSelectedRows[i] + 1);
	}
	
	/// Bill 09/14/2011 ORG-3395-S4 SCROLLBAR_SHOULD_GO_WITH_HIGHLIGHT_ITEM
	m_flx.ShowCell(vnSelectedRows[vnSelectedRows.GetSize() - 1] + 1, -1);
	/// End SCROLLBAR_SHOULD_GO_WITH_HIGHLIGHT_ITEM
}

void CurrentMenuList::RemoveItems()
{
	vector<uint> vnSelectedRows;	
	GetSelRows(vnSelectedRows);
	
	vnSelectedRows.Sort();

	for (int i = vnSelectedRows.GetSize() - 1 ; i >= 0 ; --i)
	{
		DeleteRow(vnSelectedRows[i]);
	}
}

int CurrentMenuList::getGroupDefaultShows(vector<uint>& vnDefaultShows, int nGroup)
{
	vnDefaultShows.SetSize(TOTAL_SHOWN_COLS);

	vector<int> vnColLists = {COL_TYPE_NAME, COL_TYPE_TOOLTIP};

	vnDefaultShows = 0;
	for(int nSize = vnColLists.GetSize(), ii = 0; ii < nSize; ii++) 
		vnDefaultShows[ vnColLists[ii] ] = 1;
	
	return vnDefaultShows.GetSize();
}

void CurrentMenuList::DoMenuListModifyMenu(int nx, int ny)
{
	int nRow, nCol;
	
	GetMouseCell(nRow,nCol);
	
	if (GetRowOffset() <= nRow && nRow < GetRows())
	{
		SelRow(nRow);
		
		CurrentMenuListModifyMenu menu;
	
		int nCmd;
		menu.TrackPopupMenu(0, nx, ny, GetDlgSafeHwnd(), &nCmd);
	
		int nChoice = menu.GetCommand();
	
		if (nChoice == 0)
		{
			vector<string> vsSep;
			vsSep.SetSize(COL_TYPE_TAGNAME + 1);

			vsSep[COL_TYPE_NAME] = STR_SEP_ITEM;
			vsSep[COL_TYPE_XF] = "";
			vsSep[COL_TYPE_THEME] = "";
			vsSep[COL_TYPE_COMMAND] = "";
			vsSep[COL_TYPE_DATE] = "";
			vsSep[COL_TYPE_TOOLTIP] = "";
			vsSep[COL_TYPE_EXT] = "";
			vsSep[COL_TYPE_TAGNAME] = STR_SEP_TAG;

			AddMenuItems(1, vsSep);
		}
	}
}

void CurrentMenuList::AddMenuItems(int nRows, vector<string> & vsItem)
{
	int nRowSel = GetSelectedRow();

	if (nRowSel < 0 || nRowSel >= GetRows() - 1)
	{
		nRowSel = GetRows();
		m_flx.Rows += nRows;

		m_flx.SetTableValue(&vsItem, m_flx.Rows, m_flx.Cols, nRowSel, m_flx.FixedCols, true);
	}
	else
	{
		nRowSel += 1;
		for (int i = 0 ; i < nRows ; ++i)
			m_flx.AddItem("", nRowSel);	

		m_flx.SetTableValue(&vsItem, m_flx.Rows, m_flx.Cols, nRowSel, m_flx.FixedCols, true);
	}
	
	/// Bill 09/22/2011 ORG-3395-S9 SELECT_THE_NEW_ITEM_WHEN_ADD_MENU_TO_RIGHT_GRID
	m_flx.Row = nRowSel;
	m_flx.RowSel = nRowSel + nRows - 1;
	m_flx.ShowCell(nRowSel, -1);
	/// End SELECT_THE_NEW_ITEM_WHEN_ADD_MENU_TO_RIGHT_GRID
}

TotalMenuList::TotalMenuList()
{
}

TotalMenuList::~TotalMenuList()
{
}

bool TotalMenuList::Init(UINT uID, WndContainer &Dlg)
{
	MenuListBase::Init(uID, Dlg);
	
	vector<int> vnAllCol;
	vnAllCol.Data(COL_TYPE_NAME, COL_TYPE_TOOLTIP, 1);
	AddGroup(vnAllCol);
	
	SetExplorerBar(flexExSort);
	
	return true;
}

int TotalMenuList::getGroupDefaultShows(vector<uint>& vnDefaultShows, int nGroup)
{
	vnDefaultShows.SetSize(TOTAL_SHOWN_COLS);

	vector<int> vnColLists = {COL_TYPE_NAME, COL_TYPE_EXT};

	vnDefaultShows = 0;
	for(int nSize = vnColLists.GetSize(), ii = 0; ii < nSize; ii++) 
		vnDefaultShows[ vnColLists[ii] ] = 1;
	
	return vnDefaultShows.GetSize();
}

////////////////////////////////////////////////////////////////////////////////////

CustomizationHelper::CustomizationHelper(int nImportOrExport)
{
	m_arrTotalXF.SetAsOwner(TRUE);
	m_arrTotalTheme.SetAsOwner(TRUE);

	m_nImportOrExport = nImportOrExport;

	m_nPageType = get_active_page_type();

	updateTotalMenuTree();
}

int CustomizationHelper::GetTotalMenuList(MENU_TYPE type, vector<string> & vsTableValues)
{
	if (!m_trTotalMenu)
		return -1;

	switch (type)
	{
	case MENU_TYPE_FILE_TYPE:
		menuInfoAddToStringVector(m_arrTotalXF, vsTableValues);
		return m_arrTotalXF.GetSize();
		
	case MENU_TYPE_THEME:
		menuInfoAddToStringVector(m_arrTotalTheme, vsTableValues);
		return m_arrTotalTheme.GetSize();
		
	case MENU_TYPE_ALL:
		menuInfoAddToStringVector(m_arrTotalXF, vsTableValues);
		menuInfoAddToStringVector(m_arrTotalTheme, vsTableValues);
		return m_arrTotalXF.GetSize() + m_arrTotalTheme.GetSize();
		
	default:
		ASSERT(false);
	}
	
	return -1;
}

int CustomizationHelper::GetCurrentMenuList(vector<string> & vsTableValues, bool & bShowAddRemoveMenuItem, bool bSystem)
{
	bShowAddRemoveMenuItem = false; //CPY 9/2/2011 CHANGE_GUI_TO_SHOW_FROM_HIDE_FOR_ADD_REMOVE_COMMAND

	if (!readCurrentMenuConfig(bSystem))
	{
		// if we cannot find the file or it it empty, or errro, we consider same as file not there and then we must show Add/Remove
		bShowAddRemoveMenuItem = true; //CPY 9/2/2011 CHANGE_GUI_TO_SHOW_FROM_HIDE_FOR_ADD_REMOVE_COMMAND
		return -1;
	}

	return parseMenu(vsTableValues, bShowAddRemoveMenuItem);
}

bool CustomizationHelper::SaveCustomizeMenu(CurrentMenuList * pCurrentList, bool bShowAddRemoveMenuItem)
{
	Tree trMenu;
	
	TreeNode trCurrentPageMenu = getCurrentPageMenu();
	if (!trCurrentPageMenu)
		return false;
	
	trCurrentPageMenu.RemoveChildrenWithPrefix();
	constructMeunList(pCurrentList, trCurrentPageMenu, bShowAddRemoveMenuItem);

	m_trWksMenu.SetAttribute(STR_POPUP_TEXT_ATTRIB, _get_menu_name(m_nImportOrExport));
	m_trGraphMenu.SetAttribute(STR_POPUP_TEXT_ATTRIB, _get_menu_name(m_nImportOrExport));
	m_trMatrixMenu.SetAttribute(STR_POPUP_TEXT_ATTRIB, _get_menu_name(m_nImportOrExport));
	
	trMenu.AddNode(m_trWksMenu);
	trMenu.AddNode(m_trGraphMenu);
	trMenu.AddNode(m_trMatrixMenu);	
	
	return _save_menu_customize_result(m_nImportOrExport, &trMenu);
}

int CustomizationHelper::GetNumberOfTheme(vector<string> & vsTagName)
{
	int nRet = 0 ;
	
	for (int i = 0 ; i < vsTagName.GetSize() ; ++i)
	{
		foreach (TreeNode trXF in m_trTotalMenu.Children)
		{
			TreeNode tr = _get_node_in_children_by_tagname(trXF, vsTagName[i]);

			int nPathType;
			if (tr && tr.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_THEME_PATH_TYPE_ATTRIB, nPathType))
				++nRet;
		}
	}
	
	return nRet;
}

bool CustomizationHelper::updateTotalMenuTree()
{
	if(!_get_menu_info(m_nPageType, m_trTotalMenu))
		return false;
	
	foreach (TreeNode trXF in m_trTotalMenu.Children)
	{
		if (!trXF.tagName.CompareNoCase(STR_SHOW_ADD_REMOVE_ITEM_TAG))
			continue;

		foreach (TreeNode trMenuItem in trXF.Children)
		{
			MenuInfo * pInfo = new MenuInfo;

			bool bIsTheme = getMenuItemInfo(trXF, trMenuItem, pInfo);

			if (bIsTheme)
				m_arrTotalTheme.Add(*pInfo);
			else
				m_arrTotalXF.Add(*pInfo);
		}
	}
	
	return true;
}

static TreeNode _get_node_in_children_by_tagname(TreeNode & tr, LPCSTR lpcszTagName)
{
	TreeNode trNotFind;
	
	foreach (TreeNode trChild in tr.Children)
	{
		if (!trChild.tagName.CompareNoCase(lpcszTagName))
			return trChild;
	}
	
	return trNotFind;
}

void CustomizationHelper::constructMeunList(CurrentMenuList * pCurrentList, TreeNode & trCurrentMenu, bool bShowAddRemove)
{
	if (!trCurrentMenu || pCurrentList == NULL)
		return;
	
	int nThemeHotKey = 0;
	
	for (int nRow = pCurrentList->GetRowOffset() ; nRow < pCurrentList->GetRows() ; ++nRow)
	{
		string strTagName = pCurrentList->GetCell(nRow, COL_TYPE_TAGNAME);
		
		if (!strTagName.CompareNoCase(STR_SEP_TAG))
		{
			trCurrentMenu.AddNode(STR_SEP_TAG);
		}
		else
		{	
			addMenuItem(trCurrentMenu, strTagName, nThemeHotKey);
		}
	}

	addAddRemoveMenuItem(trCurrentMenu, bShowAddRemove);
}

///------ Folger 10/13/2011 ORG-3861-P1 FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J
//static void _get_attribute_add_to_treenode(TreeNode & tr1, LPCSTR lpcszAttr1, TreeNode & tr2, LPCSTR lpcszAttr2)
static void _get_attribute_add_to_treenode(TreeNode & tr1, LPCSTR lpcszAttr1, TreeNode & tr2, LPCSTR lpcszAttr2, int nCodePage)
///------ End FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J
{
	string strTemp;	
	tr1.GetAttribute(lpcszAttr1, strTemp);
	///------ Folger 10/13/2011 ORG-3861-P1 FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J
	//tr2.AddNode(lpcszAttr2).strVal = strTemp;
	TreeNode	trNode = tr2.AddNode(lpcszAttr2);
	trNode.SetAttribute(TREE_CodePage, nCodePage);
	trNode.strVal = strTemp;
	///------ End FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J
}

void CustomizationHelper::addMenuItem(TreeNode & trMenu, LPCSTR lpcszTagName, int & nThemeHotKey)
{
	TreeNode trNewMenuItem = trMenu.AddNode(STR_TAG_NAME_PREFIX_MENUITEM);
	
	trNewMenuItem.SetAttribute(STR_POPUP_TAG_ATTRIB, lpcszTagName);
	
	foreach (TreeNode trXF in m_trTotalMenu.Children)
	{
		TreeNode trMenuItem = _get_node_in_children_by_tagname(trXF, lpcszTagName);
		
		if (trMenuItem)
		{
			int nPathType;
			bool bIsTheme = trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_THEME_PATH_TYPE_ATTRIB, nPathType);
			
			string strType = _pageType2WndType(m_nPageType);
			trNewMenuItem.SetAttribute(STR_WINDOW_TYPE_ATTRIB, strType);

			///-----Kit 10/24/2011 ORG-4157-P1 DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
			int nAllowWin = 0;
			if ( trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_ALLOW_WIN, nAllowWin) )
			{
				trNewMenuItem.AddNode(STR_MENU_CUSTOMIZE_ITEM_ALLOW_WIN).nVal = nAllowWin;
			}
			///-----End DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
			
			string strLTCmd;
			trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_LABTALK_CMD_ATTRIB, strLTCmd);
			trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_LT_SCRIPT).strVal = strLTCmd;
			
			string strMenuText;
			if (bIsTheme)
			{
				ASSERT(0 <= nThemeHotKey && nThemeHotKey <= 9);
				strMenuText.Format("&%d %s", nThemeHotKey, trMenuItem.strVal);
				++nThemeHotKey;
			}
			else
				strMenuText = trMenuItem.strVal;			
			trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_MENU_TEXT).strVal = strMenuText;
			
			/// Bill 09/16/2011 ORG-3395-S8 ADD_PROMPT_TO_SHOW_TOOLTIP_AT_STATUS_BAR
			string strTooltip;
			trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB, strTooltip);			
			trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_PROMPT).strVal = strTooltip;
			/// End ADD_PROMPT_TO_SHOW_TOOLTIP_AT_STATUS_BAR
			
			/// Bill 09/21/2011 ORG-3861 LOCALIZATION_SUPPORT_FOR_FILE_IMPORT_MENU_CUSTOM_DLG
			///------ Folger 10/13/2011 ORG-3861-P1 FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J
			//_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_XF_NAME_G, trNewMenuItem, STR_MENUITEM_TAG_NAME_MENU_TEXT_G);
			//_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_XF_NAME_J, trNewMenuItem, STR_MENUITEM_TAG_NAME_MENU_TEXT_J);
			//_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_XF_NAME_C, trNewMenuItem, STR_MENUITEM_TAG_NAME_MENU_TEXT_C);
		
			//_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_G, trNewMenuItem, STR_MENUITEM_TAG_NAME_PROMPT_G);
			//_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_J, trNewMenuItem, STR_MENUITEM_TAG_NAME_PROMPT_J);
			//_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_C, trNewMenuItem, STR_MENUITEM_TAG_NAME_PROMPT_C);
			_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_XF_NAME_G, trNewMenuItem, STR_MENUITEM_TAG_NAME_MENU_TEXT_G, CP_US_ANSI);
			_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_XF_NAME_J, trNewMenuItem, STR_MENUITEM_TAG_NAME_MENU_TEXT_J, CP_Japanese);
			_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_XF_NAME_C, trNewMenuItem, STR_MENUITEM_TAG_NAME_MENU_TEXT_C, CP_Simplified_Chinese);
			
			_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_G, trNewMenuItem, STR_MENUITEM_TAG_NAME_PROMPT_G, CP_US_ANSI);
			_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_J, trNewMenuItem, STR_MENUITEM_TAG_NAME_PROMPT_J, CP_Japanese);
			_get_attribute_add_to_treenode(trMenuItem, STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_C, trNewMenuItem, STR_MENUITEM_TAG_NAME_PROMPT_C, CP_Simplified_Chinese);
			///------ End FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J
			/// End LOCALIZATION_SUPPORT_FOR_FILE_IMPORT_MENU_CUSTOM_DLG
			
			if (!lstrcmpi(lpcszTagName, "impwiz"))
			{
				trNewMenuItem.GetNode(STR_MENUITEM_TAG_NAME_MENU_TEXT).strVal += "\tCtrl+3";
				trNewMenuItem.GetNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_G).strVal += "\tStrg+3";
				trNewMenuItem.GetNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_J).strVal += "\tCtrl+3";
				trNewMenuItem.GetNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_C).strVal += "\tCtrl+3";
			}

			// not use
			trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_LT_ENABLE);
			trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_TOOL_BUTTON);			
			break;
		}
	}
}

void CustomizationHelper::addAddRemoveMenuItem(TreeNode & trMenu, bool bShowAddRemove)
{
	if (bShowAddRemove)
	{
		trMenu.AddNode(STR_SEP_TAG);

		TreeNode trNewMenuItem = trMenu.AddNode(STR_TAG_NAME_PREFIX_MENUITEM);
		trNewMenuItem.SetAttribute(STR_POPUP_TAG_ATTRIB, STR_SHOW_ADD_REMOVE_ITEM_TAG);

		string strType = _pageType2WndType(m_nPageType);
		trNewMenuItem.SetAttribute(STR_WINDOW_TYPE_ATTRIB, strType);
		trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_LT_SCRIPT).strVal = STR_ADD_REMOVE_LT_COMMAND;
		trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_MENU_TEXT).strVal = STR_ADD_REMOVE_ITEM_DISP;

		///-----Kit 10/24/2011 ORG-4157-P1 DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
		DWORD dwAllowWin = CIAS_Graph | CIAS_Worksheet | CIAS_Matrix | CIAS_Report | CIAS_Layout;
		trNewMenuItem.AddNode(STR_MENU_CUSTOMIZE_ITEM_ALLOW_WIN).nVal = dwAllowWin;
		///-----End DISABLE_SOME_IMPORT_MENU_ITEM_WHEN_WKS_REPORT_ACTIVE
		
		/// Bill 09/21/2011 ORG-3861 LOCALIZATION_SUPPORT_FOR_FILE_IMPORT_MENU_CUSTOM_DLG
		///------ Folger 10/13/2011 ORG-3861-P1 FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J
		//trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_G).strVal = "Anpassen...";
		//trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_J).strVal = "JX^";
		//trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_C).strVal = "Customize";
		TreeNode	trCustomizedG = trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_G);
		trCustomizedG.SetAttribute(TREE_CodePage, CP_US_ANSI);
		trCustomizedG.strVal = "Anpassen...";

		TreeNode	trCustomizedJ = trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_J);
		trCustomizedJ.SetAttribute(TREE_CodePage, CP_Japanese);
		trCustomizedJ.strVal = "JX^...";

		TreeNode	trCustomizedC = trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_MENU_TEXT_C);
		trCustomizedC.SetAttribute(TREE_CodePage, CP_Simplified_Chinese);
		trCustomizedC.strVal = "Customize...";
		///------ End FILE_IMPORT_MENU_SHOW_GIBBERISH_IN_G_AND_J
		/// End LOCALIZATION_SUPPORT_FOR_FILE_IMPORT_MENU_CUSTOM_DLG
		
		// no use
		trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_LT_ENABLE);
		trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_TOOL_BUTTON);
		trNewMenuItem.AddNode(STR_MENUITEM_TAG_NAME_PROMPT);
	}
}

/// Bill 09/21/2011 ORG-3861 LOCALIZATION_SUPPORT_FOR_FILE_IMPORT_MENU_CUSTOM_DLG
bool getLocalizationInfo(TreeNode & trMenuItem, MenuInfo * pInfo)
{
	char c = okutil_get_current_lang();
	
	switch (c)
	{
	case 'G':
		if (!trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_G, pInfo->strName) ||
			!trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_G, pInfo->strToolTip))
			return false;
		break;
		
	case 'J':
		if (!trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_J, pInfo->strName) ||
			!trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_J, pInfo->strToolTip))
			return false;
		break;
		
	case 'C':
		if (!trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_C, pInfo->strName) ||
			!trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB_C, pInfo->strToolTip))
			return false;
		break;
		
	default:
		return false;
	}
	
	return true;
}
/// End LOCALIZATION_SUPPORT_FOR_FILE_IMPORT_MENU_CUSTOM_DLG

bool CustomizationHelper::getMenuItemInfo(TreeNode & trXF, TreeNode & trMenuItem, MenuInfo * pInfo)
{
	if (!getLocalizationInfo(trMenuItem, pInfo))
	{	
		pInfo->strName = trMenuItem.strVal;
		trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_DESCRIPTION_ATTRIB, pInfo->strToolTip);
	}
	
	int nHotKey = pInfo->strName.Find(MENU_HOT_KEY);
	
	// delete string like (&A), (&B), etc.
	if (nHotKey != -1)
	{
		int nOpen = nHotKey - 1;
		int nClose = nHotKey + 2;

		if (pInfo->strName[nOpen] == '(' && 
			pInfo->strName[nClose] == ')')
			pInfo->strName.Delete(nOpen, nClose - nOpen + 1);
	}
	pInfo->strName.Remove(MENU_HOT_KEY);
	
	pInfo->strXF = trXF.tagName;
	trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_LABTALK_CMD_ATTRIB, pInfo->strLTCmd);			
	trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_EXTENSTION_ATTRIB, pInfo->strExt);
	pInfo->strTag = trMenuItem.tagName;

	int nPathType = -1;
	string strFullPath;
	bool bIsTheme = trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_THEME_PATH_TYPE_ATTRIB, nPathType);
	if (bIsTheme)
	{
		trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_THEME_FILE_WITH_FULL_PATH_ATTRIB, strFullPath);
	}
	else
	{
		trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_PATH_TYPE_ATTRIB, nPathType);
		trMenuItem.GetAttribute(STR_MENU_CUSTOMIZE_ITEM_XF_NAME_FILE_WITH_FULL_PATH_ATTRIB, strFullPath);
	}

	pInfo->strThemePath = getPath(nPathType, bIsTheme);
	pInfo->strDate = GetFileModificationDate(strFullPath, LDF_SHORT_AND_HHMM_SEPARCOLON);

	return bIsTheme;
}

string CustomizationHelper::getPath(int nPathType, bool bIsTheme)
{	
	if (nPathType < 0)
		return "";

	switch (nPathType)
	{
	case ORIGIN_PATH_USER:
		return E_USER;

	case ORIGIN_PATH_GROUP:
		return E_GROUP;
	}

	return E_SYSTEM;
}

bool CustomizationHelper::readCurrentMenuConfig(bool bSystem)
{
	bool bRet = _load_menu_customize_result(m_nImportOrExport, &m_trCurrentMenu, bSystem);
	
	if (bRet)
	{
		octree_tree_check_get_node_by_attribute(&m_trWksMenu, &m_trCurrentMenu, STR_WINDOW_TYPE_ATTRIB, "W");
		octree_tree_check_get_node_by_attribute(&m_trGraphMenu, &m_trCurrentMenu, STR_WINDOW_TYPE_ATTRIB, "G");
		octree_tree_check_get_node_by_attribute(&m_trMatrixMenu, &m_trCurrentMenu, STR_WINDOW_TYPE_ATTRIB, "M");
	}
	else
	{
		m_trCurrentMenu.Reset();
	}
	
	if (!m_trWksMenu)
	{
		m_trWksMenu = m_trCurrentMenu.AddNode(STR_TAG_NAME_PREFIX_POPUP);
		m_trWksMenu.SetAttribute(STR_WINDOW_TYPE_ATTRIB, "W");
	}	
	
	if (!m_trGraphMenu)
	{
		m_trGraphMenu = m_trCurrentMenu.AddNode(STR_TAG_NAME_PREFIX_POPUP);
		m_trGraphMenu.SetAttribute(STR_WINDOW_TYPE_ATTRIB, "G");
	}
		
	if (!m_trMatrixMenu)
	{
		m_trMatrixMenu = m_trCurrentMenu.AddNode(STR_TAG_NAME_PREFIX_POPUP);
		m_trMatrixMenu.SetAttribute(STR_WINDOW_TYPE_ATTRIB, "M");
	}
	
	return bRet;
}

int CustomizationHelper::parseMenu(vector<string> & vsTableValues, bool & bShowAddRemoveMenuItem)
{
	int nSize = 0;
	
	TreeNode trCurrentPageMenu = getCurrentPageMenu();
	
	if (!trCurrentPageMenu)
		return 0;
	
	bool bNeedUpdateMenu = false;		///------ Tony 09/14/2012 ORG-6808-P1 REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU
	foreach (TreeNode trMenu in trCurrentPageMenu.Children)
	{
		string strTagName;
		bool bExistFile = false;		///------ Tony 09/14/2012 ORG-6808-P1 REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU
		if (!trMenu.GetAttribute(STR_POPUP_TAG_ATTRIB, strTagName))
		{
			if (!trMenu.tagName.CompareNoCase(STR_MTR_SEPARATOR_TAG))
				strTagName = trMenu.tagName;
			else				
				continue;
		}
		
		if (!strTagName.CompareNoCase(STR_SHOW_ADD_REMOVE_ITEM_TAG))//if present, we will show Customize... menu item
		{
			vsTableValues.RemoveAt(vsTableValues.GetSize() - COL_TYPE_TAGNAME - 1, COL_TYPE_TAGNAME + 1);
			--nSize;
			bShowAddRemoveMenuItem = true;
			continue;
		}
		else if (!strTagName.CompareNoCase(STR_MTR_SEPARATOR_TAG))
		{
			vsTableValues.Add(STR_SEP_ITEM);
			for (int i = COL_TYPE_XF ; i <= COL_TYPE_TOOLTIP ; ++i)
				vsTableValues.Add("");
			vsTableValues.Add(strTagName);
			bExistFile = true;		///------ Tony 09/14/2012 ORG-6808-P1 REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU
		}
		else
		{		
			// find info in menu list
			foreach (TreeNode trXF in m_trTotalMenu.Children)
			{
				TreeNode trMenuItem = _get_node_in_children_by_tagname(trXF, strTagName);
				
				if (trMenuItem)
				{
					MenuInfo info;
					getMenuItemInfo(trXF, trMenuItem, &info);					
					menuInfoAddToStringVector(info, vsTableValues);
					bExistFile = true;		///------ Tony 09/14/2012 ORG-6808-P1 REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU
					break;
				}
			}
		}
		///------ Tony 09/14/2012 ORG-6808-P1 REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU
		//++nSize;
		if(bExistFile)
			++nSize;
		else
		{
			bNeedUpdateMenu = true;
			trMenu.Remove();
		}
		///------ End REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU
	}
	///------ Tony 09/14/2012 ORG-6808-P1 REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU
	if(bNeedUpdateMenu)
		_save_menu_customize_result(m_nImportOrExport, &trCurrentPageMenu);
	///------ End REMOVE_WHEN_FIEL_NOT_EXIST_AND_UPDATE_MENU
	return nSize;
}

void CustomizationHelper::menuInfoAddToStringVector(MenuInfo & st, vector<string> & vs)
{
	vs.Add(st.strName);
	vs.Add(st.strXF);
	vs.Add(st.strThemePath);
	vs.Add(st.strLTCmd);
	vs.Add(st.strDate);		
	vs.Add(st.strExt);
	vs.Add(st.strToolTip);
	vs.Add(st.strTag);
}

void CustomizationHelper::menuInfoAddToStringVector(Array<MenuInfo&> & arrInfo, vector<string> & vs)
{
	int nSize = arrInfo.GetSize();
	
	MenuInfo st;
	for(int i = 0 ; i < nSize ; ++i)
	{		
		st = arrInfo.GetAt(i);
		
		menuInfoAddToStringVector(st, vs);
	}
}

TreeNode CustomizationHelper::getCurrentPageMenu()
{
	if (m_nPageType == EXIST_MATRIX)
		return m_trMatrixMenu;
	else if (m_nPageType == EXIST_GRAPH)
		return m_trGraphMenu;
	else
		return m_trWksMenu;
}

////////////////////////////////////////////////////////////////////////////////////

CustomImpMenuDlg::CustomImpMenuDlg(int nImportOrExport) : ResizeDialog(IDD_CUSTOMIZE_IMP_MENU_DLG, "ODlg8")
{
	m_pCustomMenuControl = new CustomizationHelper(nImportOrExport);
	
	m_nImportOrExport = nImportOrExport;
	m_strMenu.Format(_L("File:%s:menu"), _get_menu_name(nImportOrExport));
	m_strMenu.Remove(MENU_HOT_KEY);
	
	m_bShowAddRemove = true;
}

CustomImpMenuDlg::~CustomImpMenuDlg()
{
	delete m_pCustomMenuControl;
}

int CustomImpMenuDlg::DoModalEx(HWND hWndParent)
{		
	InitMsgMap();
	int nRet = ResizeDialog::DoModal(hWndParent);		
	return nRet;
}

bool CustomImpMenuDlg::OnInitDialog()
{
	ResizeDialog::OnInitDialog(IDC_GRID_TOTAL_MENU, STR_DLG_NAME);

	vector<string> vsTipsEmpty;

	m_btnDown = GetItem(IDC_BUTTON_DOWN);
	m_btnDown.Init(1, IDB_ARROW_DOWN, 16, vsTipsEmpty);

	m_btnUp = GetItem(IDC_BUTTON_UP);
	m_btnUp.Init(1, IDB_ARROW_UP, 16, vsTipsEmpty);
	
	vector<string> vsTips(1);
	vsTips[0] = _L("Add Menu");
	m_btnAddMenu = GetItem(IDC_BUTTON_ADD_MENU);
	m_btnAddMenu.Init(1, IDB_ARROW_RIGHT, 16, vsTips);

	vsTips[0] = _L("Remove Menu");
	m_btnRemoveMenu = GetItem(IDC_BUTTON_REMOVE_MENU);
	m_btnRemoveMenu.Init(1, IDB_ARROW_LEFT, 16, vsTips);

	m_GridCurrentMenuList.Init(IDC_GRID_CURRENT_MENU, *this);
	m_GridTotalMenuList.Init(IDC_GRID_TOTAL_MENU, *this);

	m_cbMenuType = GetItem(IDC_COMBO_MENU_TYPE);
	m_cbMenuType.SetCurSel(0); // XF

	switchMenuType(MENU_TYPE_FILE_TYPE);
	m_GridTotalMenuList.SelRow(m_GridTotalMenuList.GetRowOffset(), false);
	
	initCurrentMenu(false);

	GetItem(IDC_STATIC_MENU).Text = m_strMenu;
	
	m_chkShowAddRemove = GetItem(IDC_CHECK_HIDE_MENU);
	m_chkShowAddRemove.Check = m_bShowAddRemove;
	
	GetItem(IDC_STATIC_XF_NAME).Visible = false;

	return true;
}

bool CustomImpMenuDlg::OnOK()
{
	m_pCustomMenuControl->SaveCustomizeMenu(&m_GridCurrentMenuList, m_chkShowAddRemove.Check);
	
	///-----Kit 11/02/2011 ORG-4296-P1 IMPORT_CUSTOMIZE_MENU_NOT_UPDATE
	double dVal = 0.0; 
	LT_get_var("menu.level", &dVal);

	string strRefreshCustomizeMenu; strRefreshCustomizeMenu.Format("menu.level=%d", (int)dVal);
	LT_execute(strRefreshCustomizeMenu);
	///-----End IMPORT_CUSTOMIZE_MENU_NOT_UPDATE

	return true;
}

bool CustomImpMenuDlg::OnReady()
{
	SetInitReady(true);
	return true;
}

void print_rect(RECT & rt)
{
	printf("left %d right %d top %d bottom %d\n", rt.left, rt.right, rt.top, rt.bottom);
}

bool CustomImpMenuDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return true;

	MoveControlsHelper _temp(this);
	int nGap = GetControlGap();

	// ok, cancel button
	RECT rtOK, rtCancel;
	RECT rtBnShowAddRemoveMenu;
	GetControlClientRect(IDC_CHECK_HIDE_MENU, rtBnShowAddRemoveMenu);
	GetControlClientRect(IDOK, rtOK);
	GetControlClientRect(IDCANCEL, rtCancel);

	int nButtonWidth = RECT_WIDTH(rtOK);
	int nButtonHeight = RECT_HEIGHT(rtOK);
	MoveControl(IDCANCEL, cx - nGap, cy - nGap, false);
	MoveControl(IDOK, cx - 2 * nGap - nButtonWidth, cy - nGap, false);	

	RECT rtAdd, rtRemove;
	GetControlClientRect(IDC_BUTTON_ADD_MENU, rtAdd);
	GetControlClientRect(IDC_BUTTON_REMOVE_MENU, rtRemove);
	int nArrowWidth = RECT_WIDTH(rtAdd);
	int nArrowHeight = RECT_HEIGHT(rtAdd);

	// Check box
	int nCheckHeight = RECT_HEIGHT(rtBnShowAddRemoveMenu);
	int nCheckWidth = RECT_WIDTH(rtBnShowAddRemoveMenu);
	MoveControl(IDC_CHECK_HIDE_MENU, (cx + nArrowWidth) / 2 + nGap, cy - 2 * nGap - nCheckHeight - nButtonHeight, true);

	// two grid
	RECT rtMenuType;
	GetControlClientRect(IDC_COMBO_MENU_TYPE, rtMenuType);

	int nGridBottom = cy - 3 * nGap - nCheckHeight - nButtonHeight;
	int nGridWidth = (cx - 4 * nGap - nArrowWidth) / 2;
	RECT rtGrid;

	GetControlClientRect(IDC_GRID_TOTAL_MENU, rtGrid);
	rtGrid.left = nGap;
	rtGrid.right =  rtGrid.left + nGridWidth;
	rtGrid.bottom = nGridBottom;
	MoveControl(GetItem(IDC_GRID_TOTAL_MENU), rtGrid);

	GetControlClientRect(IDC_GRID_CURRENT_MENU, rtGrid);
	rtGrid.left = cx - nGap - nGridWidth;
	rtGrid.right = cx - nGap;
	rtGrid.bottom = nGridBottom;
	MoveControl(GetItem(IDC_GRID_CURRENT_MENU), rtGrid);

	// add and remove button
	MoveControl(IDC_BUTTON_ADD_MENU, rtGrid.left - nGap, (rtGrid.bottom + rtGrid.top - nGap) / 2, false);
	MoveControl(IDC_BUTTON_REMOVE_MENU, rtGrid.left - nGap, (rtGrid.bottom + rtGrid.top + nGap) / 2 + nArrowHeight, false);

	// text
	RECT rtMenuName;
	GetControlClientRect(IDC_STATIC_MENU, rtMenuName);
	MoveControl(IDC_STATIC_MENU, rtGrid.left, rtMenuName.top, true);

	// reset, up, down button
	RECT rtDown;
	GetControlClientRect(IDC_BUTTON_DOWN, rtDown);
	vector<uint> vsIDs = { IDC_BUTTON_RESET, IDC_BUTTON_UP, IDC_BUTTON_DOWN, 0 };
	MoveControls(vsIDs, rtGrid.right - rtDown.right, 0);

	return true;
}

bool CustomImpMenuDlg::OnDestroy()
{
	m_GridTotalMenuList.OnDestroy();
	m_GridCurrentMenuList.OnDestroy();
	return true;
}

bool CustomImpMenuDlg::OnAddMenu(Control ctrl)
{
	addMenu();

	return true;
}

bool CustomImpMenuDlg::OnRemoveMenu(Control ctrl)
{
	removeMenu();
	
	return true;
}

bool CustomImpMenuDlg::OnUp(Control ctrl)
{
	m_GridCurrentMenuList.MoveItemsUp();
	
	/// Bill 09/14/2011 ORG-3395-S4 UPDATE_BUTTON_STATE_WHEN_MOVE_UP_OR_MOVE_DOWN
	updateButtonState();
	/// End UPDATE_BUTTON_STATE_WHEN_MOVE_UP_OR_MOVE_DOWN
	
	return true;
}

bool CustomImpMenuDlg::OnDown(Control ctrl)
{
	m_GridCurrentMenuList.MoveItemsDown();
	
	/// Bill 09/14/2011 ORG-3395-S4 UPDATE_BUTTON_STATE_WHEN_MOVE_UP_OR_MOVE_DOWN
	updateButtonState();
	/// End UPDATE_BUTTON_STATE_WHEN_MOVE_UP_OR_MOVE_DOWN
	
	return true;
}

bool CustomImpMenuDlg::OnReset(Control ctrl)
{
	// delete user file
	/// Bill 09/16/2011 ORG-3395-S8 DONOT_DELETE_USE_FILE_WHEN_CLICK_RESET
	//string strFileName = STR_CUS_MENU_XF_IMPORT_FILE_NAME;
	//string strDir;
	//okutil_get_theme_sub_folder_path(THTYPE_MENU, &strDir);
	//string strUserFile = GetOriginPath(ORIGIN_PATH_USER) + strDir + strFileName;
	//
	//if (strUserFile.IsFile())
	//	DeleteFile(strUserFile);
	/// End DONOT_DELETE_USE_FILE_WHEN_CLICK_RESET
	
	initCurrentMenu(true);
	
	return true;
}

bool CustomImpMenuDlg::OnShowAddRemoveMenu(Control ctrl)
{
	Button bnShow = GetItem(IDC_CHECK_HIDE_MENU);

	if (!bnShow.Check)
		OptionalMessage("HideAddRemove", MB_OK);
	
	return true;
}

bool CustomImpMenuDlg::OnMenuTypeChange(Control ctrl)
{
	int nCurSel = m_cbMenuType.GetCurSel();

	MENU_TYPE type;

	switch (nCurSel)
	{
	case 0:
		type = MENU_TYPE_FILE_TYPE;
		break;

	case 1:
		type = MENU_TYPE_THEME;
		break;

	case 2:
		type = MENU_TYPE_ALL;
		break;

	default:
		ASSERT(false);
		return false;
	}

	switchMenuType(type);
	return true;
}

void CustomImpMenuDlg::OnCurrentMenuListBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL * pCancel)
{
	m_GridCurrentMenuList.OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
}

void CustomImpMenuDlg::OnCurrentMenuListSelChange(Control cntrl)
{
	updateButtonState();
}

/// Bill 09/15/2011 ORG-3395-S7 ADD/REMOVE_MENU_ITME_WHEN_DOUBLE_CLICK
void CustomImpMenuDlg::OnCurrentMenuListDbClick(Control cntrl)
{
	removeMenu();
}
/// End ADD/REMOVE_MENU_ITME_WHEN_DOUBLE_CLICK

void CustomImpMenuDlg::OnTotalMenuListBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL * pCancel)
{
	m_GridTotalMenuList.OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
}

void CustomImpMenuDlg::OnTotalMenuListSelChange(Control cntrl)
{
	vector<uint> vnSelectedRows;	
	m_GridTotalMenuList.GetSelRows(vnSelectedRows);
	
	if (vnSelectedRows.GetSize() != 1)
		return;
	
	int nRow = vnSelectedRows[0];
	
	string strXFName = m_GridTotalMenuList.GetCell(nRow, COL_TYPE_XF);
	string strToolTip = m_GridTotalMenuList.GetCell(nRow, COL_TYPE_TOOLTIP);
	
	Control ctrl = GetItem(IDC_STATIC_XF_NAME);

	ctrl.Text = strXFName + ":" + strToolTip;
}

/// Bill 09/15/2011 ORG-3395-S7 ADD/REMOVE_MENU_ITME_WHEN_DOUBLE_CLICK
void CustomImpMenuDlg::OnTotalMenuListDbClick(Control cntrl)
{
	addMenu();
}
/// End ADD/REMOVE_MENU_ITME_WHEN_DOUBLE_CLICK

BOOL CustomImpMenuDlg::OnContextMenu(UINT nResIDCtrl, int nx, int ny)
{
	if (nResIDCtrl == IDC_GRID_CURRENT_MENU)
	{
		m_GridCurrentMenuList.DoMenuListModifyMenu(nx, ny);
	}
	
	return TRUE;
}

void CustomImpMenuDlg::switchMenuType(MENU_TYPE type)
{
	m_GridTotalMenuList.ShowGroup(0);
	vector<string> vsTableValues;
	int nSize = m_pCustomMenuControl->GetTotalMenuList(type, vsTableValues);
	
	if (nSize > 0)
	{
		m_GridTotalMenuList.SetRows(nSize);
		m_GridTotalMenuList.SetTableValue(vsTableValues, true);
	}
	else
	{
		m_GridTotalMenuList.SetRows(0);
	}

	updateFontColor();
}

void CustomImpMenuDlg::initCurrentMenu(bool bSystem)
{
	m_GridCurrentMenuList.ShowGroup(0);
	
	vector<string> vsTableValues;
	int nSize = m_pCustomMenuControl->GetCurrentMenuList(vsTableValues, m_bShowAddRemove, bSystem);

	if (nSize > 0)
	{
		m_GridCurrentMenuList.SetRows(nSize);
		m_GridCurrentMenuList.FillCurrentMenuContent(vsTableValues);
	}
	
	updateButtonState();
	updateFontColor();
}

bool CustomImpMenuDlg::checkAddTheme(vector<uint> vnSelectToAdd)
{
	int i;
	
	vector<string> vsExist;
	for (i = m_GridCurrentMenuList.GetRowOffset() ; i < m_GridCurrentMenuList.GetRows() ; ++i)
		vsExist.Add(m_GridCurrentMenuList.GetCell(i, COL_TYPE_TAGNAME));
	
	int nNumThemeExist = m_pCustomMenuControl->GetNumberOfTheme(vsExist);
	
	if (nNumThemeExist == 10)
		return false;
	
	vector<string> vsToAdd;	
	for (i = 0 ; i < vnSelectToAdd.GetSize() ; ++i)
		vsToAdd.Add(m_GridTotalMenuList.GetCell(vnSelectToAdd[i], COL_TYPE_TAGNAME));
	
	int nNumThemeToAdd = m_pCustomMenuControl->GetNumberOfTheme(vsToAdd);
	
	if (nNumThemeExist + nNumThemeToAdd > 10)
		return false;
	
	return true;
}

void CustomImpMenuDlg::updateFontColor()
{
	int i, j;

	for (i = m_GridTotalMenuList.GetRowOffset() ; i < m_GridTotalMenuList.GetRows() ; ++i)
		m_GridTotalMenuList.SetRowColor(i, COLOR_BLACK);

	for (i = m_GridTotalMenuList.GetRowOffset() ; i < m_GridTotalMenuList.GetRows() ; ++i)
	{
		string strTagLeft = m_GridTotalMenuList.GetCell(i, COL_TYPE_TAGNAME);
		
		for (j = m_GridCurrentMenuList.GetRowOffset() ; j < m_GridCurrentMenuList.GetRows() ; ++j)
		{
			string strTagRight = m_GridCurrentMenuList.GetCell(j, COL_TYPE_TAGNAME);
			if (strTagLeft == strTagRight)
			{
				m_GridTotalMenuList.SetRowColor(i, RGB(125, 125, 125), -1, true);
				break;
			}
		}
	}
}

void CustomImpMenuDlg::updateButtonState()
{
	int nRows = m_GridCurrentMenuList.GetRows();

	/// Bill 09/13/2011 ORG-3395-S4 KEEP_MULTI_SELECTION_AFTER_MOVING_UP_AND_DOWN
	vector<uint> vnSelectedRows;	
	m_GridCurrentMenuList.GetSelRows(vnSelectedRows);
	bool bNotContinuous = vnSelectedRows.GetSize() > 1 && !check_vector_increment((vector)vnSelectedRows, 1);
	/// End KEEP_MULTI_SELECTION_AFTER_MOVING_UP_AND_DOWN
	
	int nRowSel = m_GridCurrentMenuList.GetSelectedRow();
	
	if (nRows <= m_GridCurrentMenuList.GetRowOffset() || nRowSel < 0)
	{
		//m_btnRemoveMenu.PressedDown = false;
		m_btnRemoveMenu.Enable = false;		
	}
	else
		m_btnRemoveMenu.Enable = true;
	
	if (nRows >= 2 && nRowSel > 0 && !bNotContinuous && nRowSel + vnSelectedRows.GetSize() - 1 != nRows - 1)
		m_btnDown.Enable = true;
	else
	{
		//m_btnDown.PressedDown = false;
		m_btnDown.Enable = false;	
	}

	if (nRows >= 2 && nRowSel > 0 && !bNotContinuous && nRowSel != m_GridCurrentMenuList.GetRowOffset())
		m_btnUp.Enable = true;
	else
	{
		//m_btnUp.PressedDown = false;
		m_btnUp.Enable = false;		
	}
}

void CustomImpMenuDlg::removeMenu()
{
	m_GridCurrentMenuList.RemoveItems();

	updateButtonState();
	updateFontColor();
}

void CustomImpMenuDlg::addMenu()
{
	vector<uint> vnSelectedRows;	
	m_GridTotalMenuList.GetSelRows(vnSelectedRows);
	
	int i, j;

	// Remove exist menu.
	for (i = vnSelectedRows.GetSize() - 1 ; i >= 0 ; --i)
	{
		string strSelectedName = m_GridTotalMenuList.GetCell(vnSelectedRows[i], COL_TYPE_TAGNAME);
		
		for (j = 0 ; j < m_GridCurrentMenuList.GetRows() ; ++j)
		{
			string strTagName = m_GridCurrentMenuList.GetCell(j, COL_TYPE_TAGNAME);
			if (!strSelectedName.CompareNoCase(strTagName))
			{
				vnSelectedRows.RemoveAt(i);
				break;
			}
		}
	}

	vnSelectedRows.Sort();
	
	if (!checkAddTheme(vnSelectedRows))
	{
		MessageBox(GetSafeHwnd(), _L("Maximum number of themes shown on menu is 10."), _L("Error"), MB_OK);
		return;
	}
	
	vector<string> vsValue;
	for (i = 0 ; i < vnSelectedRows.GetSize() ; ++i)
	{		
		for (j = COL_TYPE_NAME ; j <= COL_TYPE_TAGNAME ; ++j)
			vsValue.Add(m_GridTotalMenuList.GetCell(vnSelectedRows[i], j));
	}

	m_GridCurrentMenuList.AddMenuItems(vnSelectedRows.GetSize(), vsValue);

	updateButtonState();
	updateFontColor();
}

BOOL ImportMenuCustomizationDlg(int nImportOrExport)
{
	CustomImpMenuDlg dlg(nImportOrExport);
	dlg.DoModalEx();

	return TRUE;
}
