/*------------------------------------------------------------------------------*
 * File Name: ImpWizardSheet.c													*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 10-15-2004 v8.0149 QA70-5658 IMPROVE_HDRVAR_EXTRACTION					*
 * EJP 10-22-2004 v8.0154 QA70-6554 EXTRACT_VARS_FROM_FILENAME					*
 * EJP 12-06-2004 v8.0171 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ						*
 * EJP 01-04-2005 v8.0181 QA70-6555 USING_MULTI_OPEN_FDLOG						*
 * SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG						*
 * EJP 2005-01-28 v8.0187 IMPROVE_NUMBER_OF_PREVIEW_HEADLINES					*
 * EJP 2005-05-10 v8.0231 SUPPORT_VERSION_CHANGES								*
 * EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS			*
 * EJP 2005-08-16 v8.0289 QA70-7996 IMPWIZ_SUPPORT_XFUNC						*
 * EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER						*
 * Hong 03/27/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE								*
 *	Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH					*
 *	Hong 04/28/07 QA9702 CLEARLY_NEW_OBJECT_NEEDED								*
 *	Sim 05-09-2007 MAKE_DEFAULT_SETTING_CONSISTENT								*
 *	Sim 05-31-2007 REMAKE_DEFAULT_SETTING_CONSISTENT							*
 *	Sim 06-23-2007 FIX_CHANGE_TO_BINARY_SETTING									*
 *	Sim 08-06-2007 SUPPORT_SMART_SPARKLINE										*
 * EJP 2008-02-05 v8.0801 QA70-11058 IW_NEED_SHOW_ALL_TEMPLATES_IN_UFF			*
 *	Hong 08/27/08 QA80-9206 v8.0833 FIX_FAIL_GET_ACTUAL_NUM_COLIMN_AS_PARTIAL_COUNTED
 *	Hong 02/16/09 QA80-13120 SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
 *	Hong 06/19/09 QA80-13790 FIX_HEADER_LINE_SETTING_BY_USER_NOT_USED_FOR_DETECT_NUM_COLS_IF_NULL_FILTER
 *	Hong 11/10/09 QA80-14079 PREVIEW_SHOULUD_NOT_DO_ANY_RENAME					*
 *	Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC							*
 *	Folger 09/27/2010 ORG-1161-P1 IMPORT_WIZARD_RUNTIME_ERROR_WHEN_SWITCH_DATA_SOURCE_TO_CLIPBOARD
 *	Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT		*
 *	Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY	*
 *	Sim 2011-03-05 ORG-2376-P1 FIX_IMPORT_ASCII_MULTI_BLOCKS_WITH_HEAD_LINES	*
 *	Sim 2011-3-15 ORG-2376 ASCII_IMPORT_SUPPORT_NEW_BOOK_FOR_NON_NUMERIC_DATA	*
 *	Zech 08/18/2011 ORG-3571-S1 ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS	*
 *	Sim 2011-11-11 ORG-3251 SUPPORT_MULTI_CHARACTER_AS_COLUMN_SEPARATOR_FOR_ASCIMP
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "fu_utils.h"
#include "iwbase.h"
#include "IWfirst.h"

// Constructor for WizardSheet class
ImpWizSheet::ImpWizSheet()
{
	m_saDataFiles.SetSize(1);

	m_WizPageSource 		= new ImpWizSourcePage;
	m_WizPageHeadLines		= new ImpWizHeadLinesPage;
	m_WizPageDataColumns	= new ImpWizDataColumnsPage;
	m_WizPageDataSelection  = new ImpWizDataSelectionPage; ///Jacky 12/21/03 v7.5784 ADD_DATASELECTION_PAGE
	m_WizPageHeadVariables	= new ImpWizHeadVariablesPage;
	
	m_WizPageHeadBytes		= new ImpWizHeaderBytesPage;
	m_WizPageDataPattern	= new ImpWizDataPatternPage;
	
	m_WizPageUserDef		= new ImpWizUserDefinedPage;
	m_WizPageFileTypes		= new ImpWizFileTypesPage;	///Jason 12/14/03 v7.5781 ADD_FILE_TYPES_PAGE
	m_WizPagePlotting		= new ImpWizPlottingPage;	///Jason 12/14/03 v7.5781 ADD_PLOTTING_PAGE
	
	m_WizPageSaveFilters	= new ImpWizSaveFiltersPage;	///Jason 12/14/03 v7.5781 ADD_SAVE_FILTERS_PAGE
	m_WizPageDrapAndDrop	= new ImpWizDrapAndDropPage;	///Jason 12/14/03 v7.5781 ADD_DRAP_AND_DROP_PAGE
	
	/// EJP 09-10-2004 v8.0132 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
	m_GetVarHowPage = new IWGetVarHowPage;
	m_GetVarByDelimPage = new IWGetVarByDelimPage;
	m_GetVarByPosPage = new IWGetVarByPosPage;
	/// end IMPROVE_HDRVAR_EXTRACTION
	
	/// EJP 10-22-2004 v8.0154 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	m_FileNameOptionsPage = new IWFileNameOptionsPage;
	/// end EXTRACT_VARS_FROM_FILENAME

	/// EJP 2005-08-18 v8.0291 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	m_XFuncOptionsPage = new ImpWizXFuncOptionsPage;
	/// end IMPWIZ_SUPPORT_XFUNC
	
	///Danice 1/9/04 v8.0797 ADD_PAGE_IN_ORDER
	/*
	m_WizPageSource->InitPage(IDD_IW_SOURCE, this);
	AddPage(*m_WizPageSource);
	
	//ASCII
    m_WizPageHeadLines->InitPage(IDD_AIW_HEADER, this);
    AddPage(*m_WizPageHeadLines);
	m_WizPageHeadVariables->InitPage(IDD_AIW_HDRVAR, this);	
	AddPage(*m_WizPageHeadVariables);
    m_WizPageDataColumns->InitPage(IDD_AIW_COLUMNS, this);
    AddPage(*m_WizPageDataColumns);
	///Jacky 12/21/03 v7.5784 ADD_DATASELECTION_PAGE
	m_WizPageDataSelection->InitPage(IDD_IW_RANGE, this);	
	AddPage(*m_WizPageDataSelection);
	///End ADD_DATASELECTION_PAGE
	
    //BINARY
    m_WizPageHeadBytes->InitPage(IDD_BIW_HEADER, this);
    AddPage(*m_WizPageHeadBytes);
	m_WizPageDataPattern->InitPage(IDD_BIW_DATAPATERN, this);
    AddPage(*m_WizPageDataPattern);
    
    //USER DEFINED
    m_WizPageUserDef->InitPage(IDD_IW_USER_DEFINED, this);
    AddPage(*m_WizPageUserDef);
	///Jason 12/14/03 v7.5781 ADD_FILE_TYPES_PAGE
	m_WizPageFileTypes->InitPage(IDD_IW_FILETYPES, this);
	AddPage(*m_WizPageFileTypes);
	///End ADD_FILE_TYPES_PAGE
	///Jason 12/14/03 v7.5781 ADD_PLOTTING_PAGE
	m_WizPagePlotting->InitPage(IDD_IW_PLOTTING, this);	
	AddPage(*m_WizPagePlotting);
	///End ADD_PLOTTING_PAGE
                                             
                                         
	//SAVE FILTERS
	///Jason 12/14/03 v7.5781 ADD_SAVE_FILTERS_PAGE
	m_WizPageSaveFilters->InitPage(IDD_IW_SAVE_FILTERS, this);	
	AddPage(*m_WizPageSaveFilters); 
	///End ADD_SAVE_FILTERS_PAGE
	///Jason 12/14/03 v7.5781 ADD_DRAP_AND_DROP_PAGE
	m_WizPageDrapAndDrop->InitPage(IDD_IW_DRAP_AND_DROP, this);	
	AddPage(*m_WizPageDrapAndDrop);
	///End ADD_DRAP_AND_DROP_PAGE
	*/
	
	m_WizPageSource->InitPage(IDD_IW_SOURCE, this);
	AddPage(*m_WizPageSource);

	/// EJP 10-22-2004 v8.0154 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	m_FileNameOptionsPage->InitPage(IDD_FILENAME_OPTIONS, this);
	AddPage(*m_FileNameOptionsPage);
	/// end EXTRACT_VARS_FROM_FILENAME

	m_WizPageHeadBytes->InitPage(IDD_BIW_HEADER, this);
    AddPage(*m_WizPageHeadBytes);
	m_WizPageDataPattern->InitPage(IDD_BIW_DATAPATERN, this);
    AddPage(*m_WizPageDataPattern);
    m_WizPageHeadLines->InitPage(IDD_AIW_HEADER, this);
    AddPage(*m_WizPageHeadLines);
    
	/// EJP 09-10-2004 v8.0132 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
	m_GetVarHowPage->InitPage(IDD_GET_VAR_HOW, this);
	AddPage(*m_GetVarHowPage);
	m_GetVarByDelimPage->InitPage(IDD_GET_VAR_BY_DELIM, this);
	AddPage(*m_GetVarByDelimPage);
	m_GetVarByPosPage->InitPage(IDD_GET_VAR_BY_POS, this);
	AddPage(*m_GetVarByPosPage);
	/// end IMPROVE_HDRVAR_EXTRACTION
	
	m_WizPageHeadVariables->InitPage(IDD_AIW_HDRVAR, this);	
	AddPage(*m_WizPageHeadVariables);

    m_WizPageDataColumns->InitPage(IDD_AIW_COLUMNS, this);
    AddPage(*m_WizPageDataColumns);
	m_WizPageDataSelection->InitPage(IDD_IW_RANGE, this);	
	AddPage(*m_WizPageDataSelection);
	m_WizPagePlotting->InitPage(IDD_IW_PLOTTING, this);	
	AddPage(*m_WizPagePlotting);
    m_WizPageUserDef->InitPage(IDD_IW_USER_DEFINED, this);
    AddPage(*m_WizPageUserDef);

	/// EJP 2005-08-18 v8.0291 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	m_XFuncOptionsPage->InitPage(IDD_XFUNC_OPTIONS, this);
    AddPage(*m_XFuncOptionsPage);
	/// end IMPWIZ_SUPPORT_XFUNC
    
    m_WizPageSaveFilters->InitPage(IDD_IW_SAVE_FILTERS, this);	
	AddPage(*m_WizPageSaveFilters); 
	m_WizPageDrapAndDrop->InitPage(IDD_IW_DRAP_AND_DROP, this);	
	AddPage(*m_WizPageDrapAndDrop);
	m_WizPageFileTypes->InitPage(IDD_IW_FILETYPES, this);
	AddPage(*m_WizPageFileTypes);
	///END ADD_PAGE_IN_ORDER
}
	
	// Initialize message maps for each WizPage
bool ImpWizSheet::InitSheet(string strFileName)
{	
	m_WizPageSource->InitMsgMap();

	/// EJP 10-22-2004 v8.0154 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	m_FileNameOptionsPage->InitMsgMap();
	/// end EXTRACT_VARS_FROM_FILENAME

	m_WizPageHeadBytes->InitMsgMap();
	m_WizPageDataPattern->InitMsgMap();
	m_WizPageHeadLines->InitMsgMap();

	/// EJP 09-10-2004 v8.0132 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
	m_GetVarHowPage->InitMsgMap();
	m_GetVarByDelimPage->InitMsgMap();
	m_GetVarByPosPage->InitMsgMap();
	/// end IMPROVE_HDRVAR_EXTRACTION

	m_WizPageHeadVariables->InitMsgMap();
	m_WizPageDataColumns->InitMsgMap();
	m_WizPageDataSelection->InitMsgMap();   ///Jacky 12/21/03 v7.5784 ADD_DATASELECTION_PAGE
	m_WizPagePlotting->InitMsgMap();
	m_WizPageUserDef->InitMsgMap();
	m_WizPageSaveFilters->InitMsgMap();		///Jason 12/14/03 v7.5781 ADD_SAVE_FILTERS_PAGE
	m_WizPageDrapAndDrop->InitMsgMap();		///Jason 12/14/03 v7.5781 ADD_DRAP_AND_DROP_PAGE
	m_WizPageFileTypes->InitMsgMap();		///Jason 12/14/03 v7.5781 ADD_FILE_TYPES_PAGE

	/// EJP 2005-08-18 v8.0291 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	m_XFuncOptionsPage->InitMsgMap();
	/// end IMPWIZ_SUPPORT_XFUNC

	///Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR
	IW_Init(strFileName);
	///END FOR_NEW_DIALOG_CONSTRUCTOR

	return true;
}
	
	/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
bool ImpWizSheet::IsDataFromClipboard()
{
	return (m_flags & FLAG_DATAFROM_CLIPBOARD);
}

void ImpWizSheet::SetDataFromClipboard() 
{
	m_flags |= FLAG_DATAFROM_CLIPBOARD;
}

void ImpWizSheet::SetDataFromFile() 
{
	m_flags &= ~FLAG_DATAFROM_CLIPBOARD;
}
/// end IMPROVE_DATA_CHANGE_DETECTION


void ImpWizSheet::EnableNextBT(bool bEnable) // = true)	
{
	EnableNextButton(bEnable);
}

void ImpWizSheet::EnableFinishBT(bool bEnable) // = true) 
{
	EnableFinishButton(bEnable);
}

void ImpWizSheet::IW_Init(LPCSTR lpcszFileName)
{
	//fuPrepareDefault(m_trFilter);
	fuPrepareDefault(m_trFilter, FILTER_TYPE_ASCII);
	fuGetASCIMP(m_trFilter, m_ascimp, TRUE); // TRUE = get Common node too
	fuGetBINIMP(m_trFilter, m_binimp, TRUE); // TRUE = get Common node too
	
	m_flags = 0;

	m_strFilterFileSaved.Empty(); /// EJP 08-08-2003 v7.0650 QA70-4073.53 USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
	
	///s_strDataFile = lpcszFileName;
	m_saDataFiles.SetSize(0);
	///------ Folger 09/27/2010 ORG-1161-P1 IMPORT_WIZARD_RUNTIME_ERROR_WHEN_SWITCH_DATA_SOURCE_TO_CLIPBOARD
	//if( lpcszFileName )
	if( lpcszFileName && '\0' != *lpcszFileName )
	///------ End IMPORT_WIZARD_RUNTIME_ERROR_WHEN_SWITCH_DATA_SOURCE_TO_CLIPBOARD
	///---Sim 01-04-2006 INIT_WITH_MULTI_FILE
		//m_saDataFiles.Add(lpcszFileName);
		str_separate(lpcszFileName, "\r\n", m_saDataFiles);
	///---END INIT_WITH_MULTI_FILE
	else
		m_saDataFiles.Add("");

	m_strWks.Empty();
	m_bPlotInitFirstTime = TRUE;                        // Only Init parts of Plotting Page once per wizard session
	m_iSaveFilter = IDC_SAVE_FILTER_GLOBAL_RADIO;
	m_strFilter.Empty();
	//m_vColWidths.SetSize(0);			///Danice 1/16/04 v8.0800 USE_ONLY_IN_DATA_COLUMNS
	m_iFixedWidthGridFontWidth = 16;
	m_iOnUserChange = CHANGE_NONE;

	m_iBinHdrPreviewLines = BIN_HDR_PREVIEW_NUM_ROWS;
	m_iAscHdrPreviewLines = AIW_HDR_PREVIEW_LINES_DEFAULT;
	/*
	s_saHdrParamName.SetSize(0);
	s_vHdrParamType.SetSize(0);
	s_vHdrParamOffset.SetSize(0);
	s_vHdrParamSize.SetSize(0);
	*/
	m_iPreviewFont = SYSTEM_FIXED_FONT; /// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT

	PageBase pbActiveWindow;
	pbActiveWindow = Project.Pages();                   // Get active page base (window)
	if( pbActiveWindow.IsValid() )                      // If valid...
	{
		m_iActivePageType = pbActiveWindow.GetType();   //   Save active page type in static
		m_strActivePageName = pbActiveWindow.GetName(); //   Save active page name in static
	}
	else                                                // Else not valid...
	{
		m_iActivePageType = EXIST_NONE;                 //   Set active page type to none
		m_strActivePageName.Empty();                    //   Set active page name to ""
	}
	
	if( EXIST_WKS == m_iActivePageType )
	{
		Worksheet wks(m_strActivePageName);
		///Tree trFilter;
		///trFilter = IW_GetFilter();
		fuSetDesignations(m_trFilter, wks.GetColDesignations());
		fuSetFormats(m_trFilter, wks.GetColFormats());
		///IW_SetFilter(trFilter);
	}
}
///Hong 9/26/06 MOVE_TO_FU_UTILS_AS_UTIL_FUNCTION
/*
/// Hong 9/05/06 REMOVE_FILE_IMPORT
static int GetFilterClassName(TreeNode& trFilter, string& strClassName)
{
	StringArray	saFilterClassName ={"IWASCII","IWBINARY", "IWUser","IWXF"};
	
	int nFilterType = fuGetType(trFilter);
	if ( nFilterType >= saFilterClassName.GetSize() )
		return IMPERR_FILTER_TYPE;
	strClassName = saFilterClassName[nFilterType];
	return IMPERR_NONE;
}
/// end REMOVE_FILE_IMPORT
*/
/// END MOVE_TO_FU_UTILS_AS_UTIL_FUNCTION

/// Zech 08/18/2011 ORG-3571-S1 ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS
static string get_next_available_file_name(LPCSTR lpcstrPath, LPCSTR lpcstrFilenameWithoutExtension, LPCSTR lpcstrExtension)
{
	int ii;
	string strFileTemp;
	for (ii = 1; ; ii++)
	{
		strFileTemp.Format("%s%s%d.%s", lpcstrPath, lpcstrFilenameWithoutExtension, ii, lpcstrExtension);
		if (!strFileTemp.IsFile())
			return strFileTemp;
	}	
}
/// END ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS

BOOL ImpWizSheet::OnClickFinish()
{
	ENABLE_CLICKED_FINISH;
	///Hong 8/31/06 MOVE_TO_USERDEFINE
	/*
	if( FILTER_TYPE_ASCII == m_trFilter.Type.nVal )
	{
		m_trFilter.Common.OCFile.strVal = FILTER_ASCII_OCFILE;
		m_trFilter.Common.OCFunction.strVal = FILTER_ASCII_OCFUNCTION;
	}
	else if( FILTER_TYPE_BINARY == m_trFilter.Type.nVal )
	{
		m_trFilter.Common.OCFile.strVal = FILTER_BINARY_OCFILE;
		m_trFilter.Common.OCFunction.strVal = FILTER_BINARY_OCFUNCTION;
	}
	*/
	///end MOVE_TO_USERDEFINE
	
	/// Zech 08/18/2011 ORG-3571-S1 ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS
	if (!iwSaveFilter(true))
	{
		string strErrorReport;
		strErrorReport.Format("%s %s.%s!", "Failed to save import filter", THEME_FILENAME_LAST_USED, IMPORT_FILTER_EXTENSION);
		error_report(strErrorReport);		
	}
	/// END ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS
	
	if( IS_SAVE_FILTER2 )
	{
		/// EJP 09-10-2003 v7.5690 NOTIFY_USER_WHEN_SAVE_FILTER_FAILS
		///iwSaveFilter();
		
		/// Zech 08/18/2011 ORG-3571-S1 ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS
		//if( !iwSaveFilter() )
		if (0 == _stricmp(GetFileName(m_strFilter, TRUE), THEME_FILENAME_LAST_USED))
		{
			string strAvailableLastUsedFilename;
			strAvailableLastUsedFilename = get_next_available_file_name(GetAppPath()+FILTERS_FOLDER_NAME, THEME_FILENAME_LAST_USED + "_backup", IMPORT_FILTER_EXTENSION);
			m_strFilter = GetFileName(strAvailableLastUsedFilename, TRUE);
			string strMessageTemp;
			strMessageTemp.Format("\"%s\" %s%s", THEME_FILENAME_LAST_USED, _L("is reserved by Origin, the filter name is renamed to:\n"), m_strFilter);
			MessageBox(GetSafeHwnd(), strMessageTemp, _L("Import Wizard"), MB_OK);
		}
		if( !iwSaveFilter(false) )
		/// END ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS
		{
			//Window winImpWiz = ImportWizDlg.GetWindow();
			//MessageBox(winImpWiz.GetSafeHwnd(), _L("Failed to save import filter."), _L("Import Wizard"), MB_OK);
			MessageBox(GetSafeHwnd(), _L("Failed to save import filter."), _L("Import Wizard"), MB_OK);
		}
		/// end NOTIFY_USER_WHEN_SAVE_FILTER_FAILS
	}
	/// EJP 09-03-2003 v7.5682 DETECT_IMPORT_SETTINGS_CHANGED
	else if( !iwIsLoadedFilterSettingsChanged() )
		m_strFilterFileSaved = m_strFilterLoaded;
	/// end DETECT_IMPORT_SETTINGS_CHANGED

	#ifndef IW_DEBUG
	Worksheet wks;
	wks.Attach(m_strWks);
	if( wks )
		wks.Destroy();
	#endif // !IW_DEBUG

	/// EJP 08-08-2003 v7.0650 QA70-4073.53 USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
	if( IS_GET_FILTER_ONLY )
	{
		DISABLE_GET_FILTER_ONLY2;	///Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR
		return TRUE;
	}
	/// end USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
	
	///Page pgTarget(s_strActivePageName);
	Page pgActive(m_strActivePageName);
	Page pgTarget;

	int iErr; /// EJP 10-30-2003 v7.75736 QA70-5448 NOTIFY_USER_OF_IMPORT_ERROR
	
	/// SY 01-28-2004 QA70-5896 v7.5808 SET_DOC_OBJECT_INFO_IN_IMPORT_WIZARD
	using Doc = LabTalk.DOC;
	Doc.DropCount = m_saDataFiles.GetSize();;
	/// end SET_DOC_OBJECT_INFO_IN_IMPORT_WIZARD
	
	/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
	pgTarget = pgActive;
	Layer lyTarget = pgTarget.Layers();
	/// end FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
	
	for( int nFile = 0; nFile < m_saDataFiles.GetSize(); nFile++ )
	{
		/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
		//pgTarget = pgActive;
		/// end FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
		//s_strDataFile = s_saDataFiles[nFile];
		m_saDataFiles[0] = m_saDataFiles[nFile];
		
		/// SY 01-28-2004 QA70-5896 v7.5808 SET_DOC_OBJECT_INFO_IN_IMPORT_WIZARD
		Doc.DropIndex = nFile + 1;
		//Doc.DropLayer = 1; // Currently always set to 1
		Doc.DropWinName$ = m_saDataFiles[nFile];
		/// end SET_DOC_OBJECT_INFO_IN_IMPORT_WIZARD
		
		/// EJP 10-30-2003 v7.5736 QA70-5448 NOTIFY_USER_OF_IMPORT_ERROR
		///ImportFile(pgTarget, s_trFilter, s_saDataFiles[nFile], nFile);
		/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
		///iErr = ImportFile(pgTarget, m_trFilter, m_saDataFiles[nFile], nFile);
		/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
		//Layer lyTarget = pgTarget.Layers();
		/// end FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
		///Hong 8/23/06 ADD_FILTER_FILENAME
		TreeNode trFilterFileName = m_trFilter.AddNode("FileName");
		trFilterFileName.strVal = m_strFilter;
		///end ADD_FILTER_FILENAME
		/// Hong 9/05/06 REMOVE_FILE_IMPORT
		//iErr = ImportFile(lyTarget, m_trFilter, m_saDataFiles[nFile], nFile);
		string strClassName;
		GetFilterClassName(m_trFilter, strClassName);
		/// Hong 04/28/07 QA9702 CLEARLY_NEW_OBJECT_NEEDED
		//IWBase& iwFilter = (IWBase&) Project.FindClass(strClassName);
		IWBase& iwFilter = (IWBase&) Project.CreateClass(strClassName);
		/// end CLEARLY_NEW_OBJECT_NEEDED
		Tree trInfo;
		/// Hong 8/08/06 NEED_GET_TARGET_LAYER_BY_FILTER
		/// Hong 06/20/07 v8.0645 FIX_RUNTIME_ERROR_IMPORT_TO_EXCELBOOK
		//lyTarget = GetTargetLayer(pgTarget, lyTarget.GetIndex(), nFile, m_trFilter, true);
		int nLayerIndex = 0;
		if ( lyTarget )
			nLayerIndex = lyTarget.GetIndex();
		lyTarget = GetTargetLayer(pgTarget, nLayerIndex, nFile, m_trFilter, true);
		/// end FIX_RUNTIME_ERROR_IMPORT_TO_EXCELBOOK
		/// end NEED_GET_TARGET_LAYER_BY_FILTER
		/// Hong 9/12/06 SUPPORT_MUTIIL_FILES
		iwFilter.InitFileArray();
		iwFilter.AddFile(m_saDataFiles[nFile], true );
		/// end SUPPORT_MUTIIL_FILES
		iErr = iwFilter.Execute(lyTarget, nFile, m_saDataFiles[nFile], trInfo, m_trFilter);
		/// end REMOVE_FILE_IMPORT
		/// end PRESERVE_ACTIVE_PAGE_AND_LAYER
		if( IMPERR_NONE != iErr )
		{
			ImportErrorMsgBox(iErr);
			/// Hong 09/22/09 QA90-13580 FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
			if ( ERR_FILE_EMPTY == iErr && m_saDataFiles.GetSize() > 1 )
				continue;
			else
			/// end FIX_DRAG_N_DROP_TO_WORKSPACE_FAIL_TO_WORK_CORRECLY
			break; // do not continue
		}
		/// end NOTIFY_USER_OF_IMPORT_ERROR
		
		/// EJP 08-08-2003 v7.0650 QA70-4073.53 USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
		/*
		if( IS_SAVE_FILTER )
			pgTarget.Info.System.Import.Filter$ = s_strFilter;
		else
			pgTarget.Info.System.Import.Filter$ = "";
		*/
		if( pgTarget )
			pgTarget.Info.System.Import.Filter$ = m_strFilterFileSaved;
		/// end USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
		
		/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
		DataRange drImported;
		drImported = iwFilter.GetDatRange();
		/// end FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
			
		if( m_iActivePageType == EXIST_PLOT )
		/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
		{
			//IW_PlotToActiveGraph(pgTarget, nFile); // Argument is 0 based index of file number until multiple files is implemented
			IW_PlotToActiveGraph(drImported, nFile);
			pgTarget.SetShow(PAGE_HIDDEN);/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
		}
		/// end FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
	}

	/// Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
	if (iErr == IMPERR_NONE && fuIsRunScriptAfterAllFileImported(m_trFilter))
	{
		string strLTScript;
		Layer lyTarget = pgTarget.Layers();

		if( fuGetPostImportScript(m_trFilter, strLTScript) && !strLTScript.IsEmpty() )
		{
			LT_execute(strLTScript);
		}
	}
	/// End ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
	
	/// EJP 09-16-2003 v7.5696 QA70-4575 UPDATE_PLOT_LEGEND
	if( m_iActivePageType == EXIST_PLOT )
		pgActive.LT_execute("Label -p 75 5 -B 0; Legend -s;");
	/// end UPDATE_PLOT_LEGEND

	/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
	///if( IS_DATAFROM_CLIPBOARD2 )
	if( IsDataFromClipboard() )
	/// end IMPROVE_DATA_CHANGE_DETECTION
		//DeleteFile(s_strDataFile); // delete temporary file
		DeleteFile(m_saDataFiles[0]); // delete temporary file
		
	return TRUE;
}

BOOL ImpWizSheet::OnClickCancel()
{
	DISABLE_CLICKED_FINISH;
	
	if( !m_strWks.IsEmpty() )
	{
#ifndef IW_DEBUG
		Worksheet wks(m_strWks);
		wks.Destroy();
#endif // !IW_DEBUG
		m_strWks.Empty();
	}

	/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
	///if( IS_DATAFROM_CLIPBOARD2 )
	if( IsDataFromClipboard() )
	/// end IMPROVE_DATA_CHANGE_DETECTION
		DeleteFile(m_saDataFiles[0]); // delete temporary file

	return TRUE;
}

BOOL ImpWizSheet::OnDestroyDialog()
{
	return TRUE;
}

void ImpWizSheet::UpdateImpStructFromTree()
{
	///---Sim 08-31-2006 GET_FILTER_BY_ID
	//if( m_trFilter.Type.nVal == FILTER_TYPE_ASCII )
	if( FILTER_TYPE_ASCII == fuGetType(m_trFilter) )
		fuGetASCIMP(m_trFilter, m_ascimp);
	//else if( m_trFilter.Type.nVal == FILTER_TYPE_BINARY )
	else if( FILTER_TYPE_BINARY == fuGetType(m_trFilter) )
		fuGetBINIMP(m_trFilter, m_binimp);
	///---END GET_FILTER_BY_ID
}

///---Sim 06-23-2007 FIX_CHANGE_TO_BINARY_SETTING
//bool ImpWizSheet::iwLoadFilter(LPCSTR lpcstrFilter)
bool ImpWizSheet::iwLoadFilter(LPCSTR lpcstrFilter, int nType)
///---END FIX_CHANGE_TO_BINARY_SETTING
{
	m_strFilterLoaded.Empty(); /// EJP 09-03-2003 v7.5682 DETECT_IMPORT_SETTINGS_CHANGED
		
	//fuPrepareDefault(m_trFilter, fuGetType(m_trFilter));//Hong 9/08/06 FILTER_IS_ALREADY
	if( lpcstrFilter && *lpcstrFilter )
	{
		///---Sim 02-01-2007 UPDATA_OLD_FILTER_TO_NEW_FILTER
		Tree trFilter;
		/// EJP 2005-05-10 v8.0231 SUPPORT_VERSION_CHANGES
		///if( !m_trFilter.Load(lpcstrFilter) )
		//if( !fuLoad(m_trFilter, lpcstrFilter) )
		if( !fuLoad(trFilter, lpcstrFilter) )
		/// end SUPPORT_VERSION_CHANGES
			printf("Error loading %s filter.\n", lpcstrFilter);
		/// EJP 09-03-2003 v7.5682 DETECT_IMPORT_SETTINGS_CHANGED
		/// Hong 9/04/06 CONVERT_ORIGIN75_FILTER_T0_80
		else
		{
			//if(m_trFilter.OriginVersion.dVal < 8.0473)/// Hong 9/12/06 GET_FILTER_BY_ID
			//if(fuGetOriginVersion(m_trFilter) < 8.0473)
			//{
				//Tree trFilter;
				//ConvFilter(m_trFilter, trFilter);
				//m_trFilter.Replace(trFilter.Clone());
			//}
			//if(fuGetOriginVersion(trFilter) < 8.0473)
			//{
			Tree trNewFilter;
			ConvFilter(trFilter, trNewFilter);
				//trFilter.Replace(trNewFilter.Clone());
			//}

			//int nType = fuGetType(trFilter);
			//fuPrepareDefault(m_trFilter, nType);
			//tree_copy_values_by_id(trFilter, m_trFilter);

			m_trFilter.Replace(trNewFilter);

			m_strFilterLoaded = lpcstrFilter;
		}
		/// end CONVERT_ORIGIN75_FILTER_T0_80
		/// end DETECT_IMPORT_SETTINGS_CHANGED
		///---END UPDATA_OLD_FILTER_TO_NEW_FILTER
	}
	/// Hong 9/08/06 FILTER_IS_ALREADY
	else // no filter, init as ASCII
	{
		/// Hong 9/18/06 INIT_FILTER_FROM_FILE_IF_NONE_FILTER_FOR_ASCII
		//fuPrepareDefault(m_trFilter, fuGetType(m_trFilter));
		//int nType = fuGetType(m_trFilter); ///---Sim 06-23-2007 FIX_CHANGE_TO_BINARY_SETTING remove
		fuPrepareDefault(m_trFilter, nType);
		string strDataFile = GetFileName();
		if(!strDataFile.IsEmpty() && nType == FILTER_TYPE_ASCII)
		{
			///---Sim 05-31-2007 REMAKE_DEFAULT_SETTING_CONSISTENT
			ASCIMP ascimp;
			fuGetASCIMP(m_trFilter, ascimp); ///---Sim 05-09-2007 MAKE_DEFAULT_SETTING_CONSISTENT
			/// Hong 06/19/09 QA80-13790 FIX_HEADER_LINE_SETTING_BY_USER_NOT_USED_FOR_DETECT_NUM_COLS_IF_NULL_FILTER
		#ifdef		__FIX_HEADER_LINE_SETTING_NOT_USED_FOR_AUTO_DETECT__
			int			nOldSeperator = ascimp.iDelimiter;
			int			nOldNumCols = ascimp.iNumColumns;
		#endif		//__FIX_HEADER_LINE_SETTING_NOT_USED_FOR_AUTO_DETECT__
			/// end FIX_HEADER_LINE_SETTING_BY_USER_NOT_USED_FOR_DETECT_NUM_COLS_IF_NULL_FILTER
			//AscImpReadFileStruct(strDataFile, &ascimp); 
			AscImpReadFileStruct(strDataFile, &ascimp, AIRF_USE_ASCIMP); 
			/// Hong 06/19/09 QA80-13790 FIX_HEADER_LINE_SETTING_BY_USER_NOT_USED_FOR_DETECT_NUM_COLS_IF_NULL_FILTER
		#ifdef		__FIX_HEADER_LINE_SETTING_NOT_USED_FOR_AUTO_DETECT__
			ascimp.iDelimiter = nOldSeperator;
			ascimp.iNumColumns = nOldSeperator;
		#endif		//__FIX_HEADER_LINE_SETTING_NOT_USED_FOR_AUTO_DETECT__
			/// end FIX_HEADER_LINE_SETTING_BY_USER_NOT_USED_FOR_DETECT_NUM_COLS_IF_NULL_FILTER
			// get some special default setting from file
			ASCIMP ascimpDefault;
			AscImpReadFileStruct(strDataFile, &ascimpDefault);
			///---Sim 2011-03-05 ORG-2376-P1 FIX_IMPORT_ASCII_MULTI_BLOCKS_WITH_HEAD_LINES
			//ascimp.iAutoSubHeaderLines = 0; ///---Sim 02-24-2007 DEFAULT_IS_DISABLE
			if ( ascimpDefault.iAutoSubHeaderLines )
			{
				ascimpDefault.iAutoSubHeaderLines = 0;				
				ascimpDefault.nLongNames = ascimpDefault.nLongNames <= 0 ? -1 : ascimpDefault.iHeaderLines + ascimpDefault.nLongNames - 1;
				ascimpDefault.nUnits = ascimpDefault.nUnits <= 0 ? -1 : ascimpDefault.iHeaderLines + ascimpDefault.nUnits - 1;
				ascimpDefault.nFirstParams = ascimpDefault.nFirstParams <= 0 ? -1 : ascimpDefault.iHeaderLines + ascimpDefault.nFirstParams - 1;
				ascimpDefault.nFirstUserParams = ascimpDefault.nFirstUserParams <= 0 ? -1 : ascimpDefault.iHeaderLines + ascimpDefault.nFirstUserParams - 1;
			}
			ascimp.iAutoSubHeaderLines = ascimpDefault.iAutoSubHeaderLines;
			ascimp.iHeaderLines = ascimpDefault.iHeaderLines;
			ascimp.iSubHeaderLines = ascimpDefault.iSubHeaderLines;
			///---END ORG-2376-P1 FIX_IMPORT_ASCII_MULTI_BLOCKS_WITH_HEAD_LINES
			ascimp.nLongNames = ascimpDefault.nLongNames;
			ascimp.nUnits = ascimpDefault.nUnits;
			ascimp.iLabels = ascimpDefault.iLabels;
			ascimp.iMaxLabels = ascimpDefault.iMaxLabels;
			///---Sim 2011-03-05 ORG-2376-P1 FIX_IMPORT_ASCII_MULTI_BLOCKS_WITH_HEAD_LINES
			ascimp.nFirstParams = ascimpDefault.nFirstParams;
			ascimp.nNumParams = ascimpDefault.nNumParams;
			ascimp.nFirstUserParams = ascimpDefault.nFirstUserParams;
			ascimp.nNumUserParams = ascimpDefault.nNumUserParams;
			///---END ORG-2376-P1 FIX_IMPORT_ASCII_MULTI_BLOCKS_WITH_HEAD_LINES
			
			ascimp.iRenameCols = 0; ///---Sim 01-18-2007 SHORT_NAME_IS_NOT_CHANGED_BY_DEFAULT
			//ascimp.iAutoColTypes = 0; // Hong 12/07/06 FIX_CAN_NOT_SET_FORMAT
			///---Sim 01-18-2007 SHOULD_ACCORD_DEFAULT_MODE_FOR_HEADER_LINES
			///---Sim 2011-03-05 ORG-2376-P1 FIX_IMPORT_ASCII_MULTI_BLOCKS_WITH_HEAD_LINES
			//ascimp.iAutoSubHeaderLines = 0; ///---Sim 02-24-2007 DEFAULT_IS_DISABLE
			///---END ORG-2376-P1 FIX_IMPORT_ASCII_MULTI_BLOCKS_WITH_HEAD_LINES
			///---END SHOULD_ACCORD_DEFAULT_MODE_FOR_HEADER_LINES
			ascimp.iPartialC2 = -1;// Hong 9/21/06 PARTIAL_DEFAULT_SELECT_ALL
			m_iNumColsEstimated = ascimp.iNumColumns;
			_MSG_INT(iwLoadFilterNoFilterInitAsASCII, ascimp.iDelimited)
			fuSetASCIMP(m_trFilter, ascimp);
			/*
			///---Sim 03-07-2007 CHANGE_DEFAULT_SETTING
			fuSetImportMode(m_trFilter, ASCIMP_MODE_NEW_SHEETS); ///---Sim 05-08-2007 REMOVE_REPLACE_OUT_OF_MULTI_FILE_IMPORT_MODE
			fuSetRenameWks(m_trFilter, TRUE);
			fuSetRenameWorkbook(m_trFilter, TRUE);
			fuSetRenameBookWithoutPath(m_trFilter, TRUE); // include path when rename book default is off
			fuSetAppendFileNameToWorkBookComments(m_trFilter, TRUE);
			///---END CHANGE_DEFAULT_SETTING
			
			/// Hong 03/27/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
			fuSetForceSameSize(m_trFilter, TRUE);
			/// end ADD_FORCE_ROW_SAME_SIZE
			*/
			///---END REMAKE_DEFAULT_SETTING_CONSISTENT
		}
		/// end INIT_FILTER_FROM_FILE_IF_NONE_FILTER_FOR_ASCII
		///// EJP 10-15-2004 v8.0149 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
		/////	ASCIMP ascimp;
		/////	AscImpReadFileStruct(GetFileName(), &ascimp);
		/////	ascimp.iAutoSubHeaderLines = 0; /// EJP 07-29-2002 v7.0637 QA70-4575 PROBLEM_50
		/////	m_iNumColsEstimated = ascimp.iNumColumns;
		/////	
		/////	_MSG_INT(iwLoadFilterNoFilterInitAsASCII, ascimp.iDelimited)
		/////
		/////	/// EJP 06-06-2003 QA70-4592 ASCII_HEADER_SCAN_MAIN_SUB_SEPARATION
		/////	/* CP made some internal changes to set these values.
		/////	ascimp.iHeaderLines += ascimp.iSubHeaderLines;
		/////	ascimp.iSubHeaderLines = 0;
		/////	ascimp.iRenameCols = 0;
		/////	ascimp.iMaxLabels = 0;
		/////	ascimp.iLabels = 0;
		/////	*/
		/////	/// end ASCII_HEADER_SCAN_MAIN_SUB_SEPARATION
		/////	fuSetASCIMP(m_trFilter, ascimp);
		//string strDataFile = GetFileName();
		//if( !strDataFile.IsEmpty() )
		//{
			//ASCIMP ascimp;
			//AscImpReadFileStruct(strDataFile, &ascimp);
			//ascimp.iAutoSubHeaderLines = 0;
			//m_iNumColsEstimated = ascimp.iNumColumns;
			//_MSG_INT(iwLoadFilterNoFilterInitAsASCII, ascimp.iDelimited)
			//fuSetASCIMP(m_trFilter, ascimp);
		//}
		///// end IMPROVE_HDRVAR_EXTRACTION
	}
	/// end FILTER_IS_ALREADY
	fuGetASCIMP(m_trFilter, m_ascimp, TRUE); // TRUE = get Common node too
	fuGetBINIMP(m_trFilter, m_binimp, TRUE); // TRUE = get Common node too
	_MSG_INT(iwLoadFilter, m_ascimp.iDelimited)
	return TRUE;
}

int ImpWizSheet::InitComboBoxWithTemplateNames(ComboBox &cbTarget, int iType)
{
	/// EJP 2008-02-05 v8.0801 QA70-11058 IW_NEED_SHOW_ALL_TEMPLATES_IN_UFF
	/*
	string strExt;
	switch( iType )
	{
	case EXIST_WKS:
		strExt = "otw";
		break;
	case EXIST_MATRIX:
		strExt = "otm";
		break;
	case EXIST_PLOT:
		strExt = "otp";
		break;
	default:
		return 1; // unsupported type
	}
	
	cbTarget.ResetContent();
	cbTarget.AddString(SZ_IW_DEFAULT);

	StringArray saTemplates;

	GetSystemFiles(saTemplates, strExt);

	string strFileName;
	for( int i = 0; i < saTemplates.GetSize(); i++ )
	{
		strFileName = GetFilenameWithoutExt(saTemplates[i]);
		cbTarget.AddString(strFileName);
	}
	*/
	StringArray saTemplates;
	switch( iType )
	{
	case EXIST_WKS:
		GetFileNames(saTemplates, NULL, "*.otw", GFIF_FILE_RECURSIVE | GFIF_STRIP_START_PATH);
		GetFileNames(saTemplates, NULL, "*.ogw", GFIF_FILE_RECURSIVE | GFIF_STRIP_START_PATH);
		break;
	case EXIST_MATRIX:
		GetFileNames(saTemplates, NULL, "*.otm", GFIF_FILE_RECURSIVE | GFIF_STRIP_START_PATH);
		GetFileNames(saTemplates, NULL, "*.ogm", GFIF_FILE_RECURSIVE | GFIF_STRIP_START_PATH);
		break;
	case EXIST_PLOT:
		GetFileNames(saTemplates, NULL, "*.otp", GFIF_FILE_RECURSIVE | GFIF_STRIP_START_PATH);
		GetFileNames(saTemplates, NULL, "*.ogg", GFIF_FILE_RECURSIVE | GFIF_STRIP_START_PATH);
		break;
	default:
		return 1; // unsupported type
	}

	cbTarget.ResetContent();
	cbTarget.AddString(SZ_IW_DEFAULT);

	for( int i = 0; i < saTemplates.GetSize(); i++ )
		cbTarget.AddString(saTemplates[i]);
	/// end IW_NEED_SHOW_ALL_TEMPLATES_IN_UFF
	
	cbTarget.SetCurSel(0);
	return 0;
}


BOOL ImpWizSheet::AIW_GetTempFileName(string &strFile)
{
	char sz[MAXFULLPATH];
	DWORD dw = GetTempPath(MAXFULLPATH, sz);
	if( dw )
	{
		strFile = sz;
		dw = GetTempFileName(strFile, "AIW", 0, sz);
		if( dw )
		{
			strFile = sz;
			return TRUE;
		}
	}
	return FALSE;
}

void ImpWizSheet::iw_SetRichEditFont(RichEdit &re, int iFont)
{
	int iFirstVisibleLineBefore = re.GetFirstVisibleLine(); // get first visible line

	long nStartChar, nEndChar;
	re.GetSel(nStartChar, nEndChar); // save selection
	re.SetSel(0, -1); // select all
	re.SetFont(iFont);
	re.SetSel(nStartChar, nEndChar); // restore selection

	int iFirstVisibleLineAfter = re.GetFirstVisibleLine();
	if( iFirstVisibleLineAfter != iFirstVisibleLineBefore ) // check first visible line
		re.LineScroll(iFirstVisibleLineBefore - iFirstVisibleLineAfter, 0);
}

void ImpWizSheet::iw_InitComboBox(ComboBox &cb, LPCSTR lpcszStrings, int *lpiValues)
{
	string str = lpcszStrings;
	StringArray saItems;
	str.GetTokens(saItems, '|');
	
	cb.ResetContent();
	for( int iItem = 0; iItem < saItems.GetSize(); iItem++ )
	{
		cb.AddString(saItems[iItem]);
		if( lpiValues )
		{
			cb.SetItemData(iItem, *lpiValues);
			lpiValues++;
		}
	}
}

/// EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
void ImpWizSheet::SetComboBoxCurSelByData(ComboBox &cb, DWORD dwData, int nDefaultItem)
{
	for( int nItem = 0; nItem < cb.GetCount(); nItem++ )
	{
		if( cb.GetItemData(nItem) == dwData )
		{
			nDefaultItem = nItem;
			break;
		}
	}
	cb.SetCurSel(nDefaultItem);
}
/// end ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS

//--------------------------------------------------------------------------
// UpdateImpStructCommonFromTree
//
// The low level import functions for ASCII and Binary get their settings
// from a single struct argument (ASCIMP or BINIMP).
// Copies of these structs are stored in the tree.
// These structs have common settings.
// These common settings are also stored in the tree's Common branch.
// We assume the tree's Common branch is always up to date.
// This function will update the struct from the Common branch and then
// update the struct stored in the tree.
//--------------------------------------------------------------------------
void ImpWizSheet::UpdateImpStructCommonFromTree()
{
	///---Sim 08-31-2006 GET_FILTER_BY_ID
	/*
	if( m_trFilter.Type.nVal == FILTER_TYPE_ASCII )
	{
		m_ascimp.iRenameWks = m_trFilter.Common.RenameWks.nVal;
		m_ascimp.iPartial 	= m_trFilter.Common.Partial.nVal;
		m_ascimp.iPartialC1 = m_trFilter.Common.PartialC1.nVal;
		m_ascimp.iPartialC2 = m_trFilter.Common.PartialC2.nVal;
		m_ascimp.iPartialR1 = m_trFilter.Common.PartialR1.nVal;
		m_ascimp.iPartialR2 = m_trFilter.Common.PartialR2.nVal;
		m_ascimp.iMode = fuGetImportMode(m_trFilter);
		///s_ascimp.iApplyRange = fuGetApplyRangeToGraph(s_trFilter);
		m_ascimp.iSkipRows = tree_node_get_int(m_trFilter.Common.SkipRows, 0); /// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
		m_ascimp.iReadRows = tree_node_get_int(m_trFilter.Common.ReadRows, 1); /// EJP 08-27-2003 v7.5677 QA70-5073 ADD_READROWS
		m_ascimp.flags = tree_node_get_int(m_trFilter.Common.Flags, 0); /// EJP 07-19-2004 v8.0101 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
		fuSetASCIMP(m_trFilter, m_ascimp);
	}
	else if( m_trFilter.Type.nVal == FILTER_TYPE_BINARY )
	{
		m_binimp.iRenameWks = m_trFilter.Common.RenameWks.nVal;
		m_binimp.iPartial 	= m_trFilter.Common.Partial.nVal;
		m_binimp.iPartialC1 = m_trFilter.Common.PartialC1.nVal;
		m_binimp.iPartialC2 = m_trFilter.Common.PartialC2.nVal;
		m_binimp.iPartialR1 = m_trFilter.Common.PartialR1.nVal;
		m_binimp.iPartialR2 = m_trFilter.Common.PartialR2.nVal;
		m_binimp.iMode = fuGetImportMode(m_trFilter);
		///s_binimp.iApplyRange = fuGetApplyRangeToGraph(s_trFilter);
		m_binimp.iSkipRows = tree_node_get_int(m_trFilter.Common.SkipRows, 0); /// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
		m_binimp.iReadRows = tree_node_get_int(m_trFilter.Common.ReadRows, 1); /// EJP 09-12-2003 v7.5693 QA70-5073 ADD_READROWS_TO_BINIMP
		m_binimp.flags = tree_node_get_int(m_trFilter.Common.Flags, 0); /// EJP 07-21-2004 v8.0102 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
		fuSetBINIMP(m_trFilter, m_binimp);

	}
	*/
	///---END GET_FILTER_BY_ID
}

void ImpWizSheet::ImportToWks(BOOL bTempWks) // = TRUE)
{
	waitCursor waitcursor;

	string strColDesig, strColFormat;
	
	int nErr = 0;
	if( bTempWks )
	{
		//Worksheet wks(s_strWks);
		Worksheet wks(m_strWks);
		if( !wks )
			return;
		while( wks.DeleteCol(0) ); // Remove all columns in temp worksheet

		/// EJP 08-19-2003 v7.5667 REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
		ASCIMP aiTemp;
		BINIMP biTemp;
		/// end REIMPORT_AFTER_USER_CHANGE_COL_FORMAT

		/// Hong 9/05/06 REMOVE_FILE_IMPORT
		string strClassName;
		Tree trInfo;
		GetFilterClassName(m_trFilter, strClassName);
		/// Hong 04/28/07 QA9702 CLEARLY_NEW_OBJECT_NEEDED
		//IWBase& iwFilter = (IWBase&) Project.FindClass(strClassName);
		IWBase& iwFilter = (IWBase&) Project.CreateClass(strClassName);
		/// end CLEARLY_NEW_OBJECT_NEEDED
		/// end REMOVE_FILE_IMPORT
		///---Sim 02-28-2007 DISABLE_SOME_OPTIONS_FOR_PREVIEW
		/// Hong 9/26/06 DONOT_RUN_SCRIPT_IN_PREVIEW
		bool bHaveScript = false;
		string strScript;
		bHaveScript = fuGetPostImportScript(m_trFilter, strScript);
			//bHaveScript = true;
		/// END DONOT_RUN_SCRIPT_IN_PREVIEW
		if ( bHaveScript )
			fuSetPostImportScript(m_trFilter, "");
		///---END DISABLE_SOME_OPTIONS_FOR_PREVIEW
		///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
		///// Hong 01/17/07 DONOT_ADD_SPARKLINES_IN_PREVIEW
		//bool bAddSparklines = fuGetSparkLine(m_trFilter);
		//fuSetSparkLine(m_trFilter, FALSE);
		///// end DONOT_ADD_SPARKLINES_IN_PREVIEW
		int nSparklines = fuGetSparkLine(m_trFilter);
		fuSetSparkLine(m_trFilter, SPARKLINE_NO_CHANGE);		
		///---END SUPPORT_SMART_SPARKLINE
		
		///---Sim 02-28-2007 DISABLE_SOME_OPTIONS_FOR_PREVIEW
		bool bAutoRename = fuIsAutoRename(m_trFilter);
		fuSetAutoRename(m_trFilter, FALSE);
		
		//bool bRenameWks, bRenameWkBk, bRenameWkBkComm, bRenameColComm, bRenameWksWithVar, bRenameWkbkWithVar;
		//fuDisableAllRename(m_trFilter, &bRenameWks, &bRenameWkBk, &bRenameWkBkComm, &bRenameColComm, &bRenameWksWithVar, &bRenameWkbkWithVar);
		///---END DISABLE_SOME_OPTIONS_FOR_PREVIEW
		
		//if( m_trFilter.Type.nVal == FILTER_TYPE_ASCII )
		if( fuGetType(m_trFilter) == FILTER_TYPE_ASCII )//Hong 8/31/06 GET_FILTER_BY_ID
		{
			/// EJP 08-19-2003 v7.5667 REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
			///ASCIMP aiTemp;
			/// end REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
			
			aiTemp = m_ascimp;
			/// EJP 12-06-2004 v8.0171 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
			///aiTemp.iRenameWks = 0;
			aiTemp.flags &= ~(AI_FLAG_FNAME_TO_WKBK_NAME); // do not rename temp workbook
			/// end SUPPORT_WKBK_IN_IMPWIZ

			///---Sim 03-06-2007 FIX_RESIDUAL_HIDDEN_BOOK
			aiTemp.flags &= ~(AI_FLAG_VARIABLE_TO_WKBK_NAME); // do not rename temp workbook
			///---END FIX_RESIDUAL_HIDDEN_BOOK
			
			/// EJP 09-20-2004 v8.0135 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
			aiTemp.flags |= AI_FLAG_DO_NOT_CALL_OC;
			/// end IMPORT_INFO_STORAGE_CLEANUP
			
#ifndef __ASCII_IMPORT_NON_NUMERIC_DATA_SUPPORT_NEW_BOOK__ ///---Sim 2011-3-15 ORG-2376 ASCII_IMPORT_SUPPORT_NEW_BOOK_FOR_NON_NUMERIC_DATA
			//if( NONNUMERIC_START_NEW_WKSCOL == aiTemp.iNonnumeric )
			if ( NONNUMERIC_MODE_NEW_WKS == aiTemp.iNonnumeric ) ///---Sim 2011-3-15 ORG-2376 ASCII_IMPORT_SUPPORT_NEW_BOOK_FOR_NON_NUMERIC_DATA
			{
				if( ASCIMP_MODE_APPEND_COLS != aiTemp.iMode )
					//aiTemp.iNonnumeric = NONNUMERIC_TERMINATE;
					aiTemp.iNonnumeric = NONNUMERIC_MODE_TERMINATE; ///---Sim 2011-3-15 ORG-2376 ASCII_IMPORT_SUPPORT_NEW_BOOK_FOR_NON_NUMERIC_DATA
			}
			else
				aiTemp.iMode = ASCIMP_MODE_REPLACE_DATA;
			///---Sim 2011-3-15 ORG-2376 ASCII_IMPORT_SUPPORT_NEW_BOOK_FOR_NON_NUMERIC_DATA			
#else //!__ASCII_IMPORT_NON_NUMERIC_DATA_SUPPORT_NEW_BOOK__
			aiTemp.iMode = ASCIMP_MODE_REPLACE_DATA;
			if ( NONNUMERIC_MODE_NEW_WKS == aiTemp.iNonnumeric || NONNUMERIC_MODE_NEW_BOOK == aiTemp.iNonnumeric )
			{
				if( ASCIMP_MODE_APPEND_COLS != aiTemp.iMode ) // when multifiles import mode is append columns, nonnumeric mode will force be changed to append columns.
					aiTemp.iNonnumeric = NONNUMERIC_MODE_TERMINATE;				
			}
#endif //!__ASCII_IMPORT_NON_NUMERIC_DATA_SUPPORT_NEW_BOOK__
			///---END ORG-2376 ASCII_IMPORT_SUPPORT_NEW_BOOK_FOR_NON_NUMERIC_DATA
			
			/// Hong 09/13/07 QA80-9206 v8.0702 FIX_FAIL_LIMIT_PREVIEW_COL_NUM
			/// Hong 11/21/07 v8.0751 FIX_PREVIEW_FAIL_GET_GUI_NUMCOLUMN			
			//if ( fuGetInt(m_trFilter, IDE_ASCIMP_DELIMITED, FALSE) 
			//	&& 0 == fuGetInt(m_trFilter, IDE_ASCIMP_NUMCOLUMNS, 0) )
			///---Sim 2011-11-11 ORG-3251 SUPPORT_MULTI_CHARACTER_AS_COLUMN_SEPARATOR_FOR_ASCIMP
			//if ( aiTemp.iDelimited && 0 == aiTemp.iNumColumns ) 
			if ( ASCIMP_DELIMITED_FIXED != aiTemp.iDelimited && 0 == aiTemp.iNumColumns ) 
			///---END ORG-3251 SUPPORT_MULTI_CHARACTER_AS_COLUMN_SEPARATOR_FOR_ASCIMP
			/// end FIX_PREVIEW_FAIL_GET_GUI_NUMCOLUMN
			{	// number of column is 0, means all columns
				// get number of column from file, and modify filter temporarily
				ASCIMP ascimpTemp;
				ascimpTemp = aiTemp;
				/// Hong 08/27/08 QA80-9206 v8.0833 FIX_FAIL_GET_ACTUAL_NUM_COLIMN_AS_PARTIAL_COUNTED
				ascimpTemp.iPartial = 0;
				/// end FIX_FAIL_GET_ACTUAL_NUM_COLIMN_AS_PARTIAL_COUNTED
				if ( !AscImpReadFileStruct(m_saDataFiles[m_nActiveDataFile], &ascimpTemp, AIRF_USE_ASCIMP) )				
					aiTemp.iNumColumns = ascimpTemp.iNumColumns;				
			}
			/// end FIX_FAIL_LIMIT_PREVIEW_COL_NUM
			iwSetPartialImportForPreview(aiTemp.iPartial,
				aiTemp.iPartialR1, aiTemp.iPartialC1, aiTemp.iPartialR2, aiTemp.iPartialC2,
				aiTemp.iNumColumns);
				
			fuSetASCIMP(m_trFilter, aiTemp, TRUE);
			/// Hong 11/10/09 QA80-14079 PREVIEW_SHOULUD_NOT_DO_ANY_RENAME
			bool bRenameWks, bRenameWkBk, bRenameWkBkComm, bRenameColComm, bRenameWksWithVar, bRenameWkbkWithVar;
			fuDisableAllRename(m_trFilter, &bRenameWks, &bRenameWkBk, &bRenameWkBkComm, &bRenameColComm, &bRenameWksWithVar, &bRenameWkbkWithVar);
			/// end PREVIEW_SHOULUD_NOT_DO_ANY_RENAME
			///---Sim 02-28-2007 DISABLE_SOME_OPTIONS_FOR_PREVIEW remove
			///// Hong 9/26/06 DONOT_RUN_SCRIPT_IN_PREVIEW
			//if(bHaveScript)
				//fuSetPostImportScript(m_trFilter, "");
			///// END DONOT_RUN_SCRIPT_IN_PREVIEW
			///---END DISABLE_SOME_OPTIONS_FOR_PREVIEW
			
			/// Hong 02/16/09 QA80-13120 SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
			bool			bOldVal = fuIsVarInPageInfo(m_trFilter);
			if ( bOldVal )
				fuSetVarInPageInfo(m_trFilter, false);
			/// end SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
			
			///---Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
			int nAutoSizeBak = fuGetAutoSize(m_trFilter);
			fuSetAutoSize(m_trFilter, FILTER_AUTO_SIZE_NO);
			///---END QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
			
			/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
			///PrepareWksColsForImport(wks.GetPage(), m_trFilter, m_saDataFiles[m_nActiveDataFile]);
			/// Hong 9/05/06 REMOVE_FILE_IMPORT
			//PrepareWksColsForImport(wks, m_trFilter, m_saDataFiles[m_nActiveDataFile]);
			nErr = iwFilter.Execute(wks, m_nActiveDataFile, m_saDataFiles[m_nActiveDataFile], trInfo, m_trFilter);
			/// end REMOVE_FILE_IMPORT
			/// end PRESERVE_ACTIVE_PAGE_AND_LAYER
			/// Hong 11/10/09 QA80-14079 PREVIEW_SHOULUD_NOT_DO_ANY_RENAME
			fuSetAllRename(m_trFilter, &bRenameWks, &bRenameWkBk, &bRenameWkBkComm, &bRenameColComm, &bRenameWksWithVar, &bRenameWkbkWithVar);
			/// end PREVIEW_SHOULUD_NOT_DO_ANY_RENAME
			fuSetASCIMP(m_trFilter, m_ascimp, TRUE);
			/// Hong 02/16/09 QA80-13120 SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
			if ( bOldVal )
				fuSetVarInPageInfo(m_trFilter, bOldVal);
			/// end SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
			
			///---Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
			fuSetAutoSize(m_trFilter, nAutoSizeBak);
			///---END QA81-14895 SPEED_UP_81_IMP_WIZ_ASC

			///---Sim 02-28-2007 DISABLE_SOME_OPTIONS_FOR_PREVIEW remove
			///// Hong 01/17/07 DONOT_ADD_SPARKLINES_IN_PREVIEW
			//if( bAddSparklines )
				//fuSetSparkLine(m_trFilter, bAddSparklines); 
			///// end DONOT_ADD_SPARKLINES_IN_PREVIEW
			//
			///// Hong 9/26/06 DONOT_RUN_SCRIPT_IN_PREVIEW
			//if(bHaveScript)
				//fuSetPostImportScript(m_trFilter, strScript);
			///// END DONOT_RUN_SCRIPT_IN_PREVIEW
			///---END DISABLE_SOME_OPTIONS_FOR_PREVIEW

			/// EJP 08-19-2003 v7.5667 REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
			/*
			strColDesig = wks.GetColDesignations();
			strColFormat = wks.GetColFormats();
			nErr = wks.ImportASCII(s_strDataFile, aiTemp);
			wks.SetColDesignations(strColDesig, false);
			wks.SetColFormats(strColFormat, false);
			*/
			/// end REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
		}
		//else if( m_trFilter.Type.nVal == FILTER_TYPE_BINARY )
		else if( fuGetType(m_trFilter) == FILTER_TYPE_BINARY )//Hong 8/31/06 GET_FILTER_BY_ID
		{
			/// EJP 08-19-2003 v7.5667 REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
			///BINIMP biTemp;
			/// end REIMPORT_AFTER_USER_CHANGE_COL_FORMAT

/// EJP: temp workaround, see tracker #4335.
			biTemp = m_binimp;
/*
biTemp.iHeaderBytes = s_binimp.iHeaderBytes;
biTemp.iAutoColTypes = s_binimp.iAutoColTypes;
biTemp.iNumColumns = s_binimp.iNumColumns;
biTemp.iPartial = s_binimp.iPartial;
biTemp.iPartialC1 = s_binimp.iPartialC1;
biTemp.iPartialC2 = s_binimp.iPartialC2;
biTemp.iPartialR1 = s_binimp.iPartialR1;
biTemp.iPartialR2 = s_binimp.iPartialR2;
biTemp.iRenameWks = s_binimp.iRenameWks;
biTemp.iBigEndian = s_binimp.iBigEndian;
biTemp.iApplyRange = s_binimp.iApplyRange;
biTemp.iMode = s_binimp.iMode;
biTemp.vParamType = s_binimp.vParamType;
biTemp.vParamSize = s_binimp.vParamSize;
biTemp.vParamCount = s_binimp.vParamCount;
biTemp.iSkipRows = s_binimp.iSkipRows; /// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
*/
			biTemp.iRenameWks = 0;
			/// EJP 12-06-2004 v8.0171 QA70-6555 SUPPORT_WKBK_IN_IMPWIZ
			///biTemp.iMode = ASCIMP_MODE_REPLACE_DATA;
			biTemp.flags &= ~(AI_FLAG_FNAME_TO_WKBK_NAME); // do not rename temp workbook
			/// end SUPPORT_WKBK_IN_IMPWIZ

			iwSetPartialImportForPreview(biTemp.iPartial,
				biTemp.iPartialR1, biTemp.iPartialC1, biTemp.iPartialR2, biTemp.iPartialC2,
				biTemp.iNumColumns);

			fuSetBINIMP(m_trFilter, biTemp, TRUE);
			
			///---Sim 02-28-2007 DISABLE_SOME_OPTIONS_FOR_PREVIEW remove
			///// Hong 9/26/06 DONOT_RUN_SCRIPT_IN_PREVIEW
			//if(bHaveScript)
				//fuSetPostImportScript(m_trFilter, "");
			///// END DONOT_RUN_SCRIPT_IN_PREVIEW
			///---END DISABLE_SOME_OPTIONS_FOR_PREVIEW
			
			/// Hong 02/16/09 QA80-13120 SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
			bool			bOldVal = fuIsVarInPageInfo(m_trFilter);
			if ( bOldVal )
				fuSetVarInPageInfo(m_trFilter, false);
			/// end SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
			
			/// EJP 2006-03-24 v8.0380 PRESERVE_ACTIVE_PAGE_AND_LAYER
			///PrepareWksColsForImport(wks.GetPage(), m_trFilter, m_saDataFiles[m_nActiveDataFile]);
			/// Hong 9/05/06 REMOVE_FILE_IMPORT
			//PrepareWksColsForImport(wks, m_trFilter, m_saDataFiles[m_nActiveDataFile]);
			nErr = iwFilter.Execute(wks, m_nActiveDataFile, m_saDataFiles[m_nActiveDataFile], trInfo, m_trFilter);
			/// end REMOVE_FILE_IMPORT
			/// end PRESERVE_ACTIVE_PAGE_AND_LAYER
			fuSetBINIMP(m_trFilter, m_binimp, TRUE);
			/// Hong 02/16/09 QA80-13120 SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
			if ( bOldVal )
				fuSetVarInPageInfo(m_trFilter, bOldVal);
			/// end SPEEDUP_IMPORT_AVOIDING_SET_VARAIBLE_TO_PAGE_INFO_WHEN_PREVIEW
			
			///---Sim 02-28-2007 DISABLE_SOME_OPTIONS_FOR_PREVIEW remove
			///// Hong 01/17/07 DONOT_ADD_SPARKLINES_IN_PREVIEW
			//if( bAddSparklines )
				//fuSetSparkLine(m_trFilter, bAddSparklines); 
			///// end DONOT_ADD_SPARKLINES_IN_PREVIEW
			//
			///// Hong 9/26/06 DONOT_RUN_SCRIPT_IN_PREVIEW
			//if(bHaveScript)
				//fuSetPostImportScript(m_trFilter, strScript);
			///// END DONOT_RUN_SCRIPT_IN_PREVIEW
			///---END DISABLE_SOME_OPTIONS_FOR_PREVIEW

			/// EJP 08-19-2003 v7.5667 REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
			/*
			strColDesig = wks.GetColDesignations();
			strColFormat = wks.GetColFormats();
			nErr = wuImportBinary(wks, s_strDataFile, &biTemp);
			wks.SetColDesignations(strColDesig, false);
			wks.SetColFormats(strColFormat, false);
			*/
			/// end REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
		}
		/// EJP 08-19-2003 v7.5667 REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
		else
		{
			//return; // Only ASCII and Binary supported here. ///---Sim 02-28-2007
		}
		
		///---Sim 02-28-2007 RECOVER_SOME_OPTIONS_AFTER_PREVIEW
		//fuSetAllRename(m_trFilter, &bRenameWks, &bRenameWkBk, &bRenameWkBkComm, &bRenameColComm, &bRenameWksWithVar, &bRenameWkbkWithVar);
	
		fuSetAutoRename(m_trFilter, bAutoRename);
		
		///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
		//if( bAddSparklines )
			//fuSetSparkLine(m_trFilter, bAddSparklines); 
		fuSetSparkLine(m_trFilter, nSparklines);
		///---END SUPPORT_SMART_SPARKLINE

		if(bHaveScript)
			fuSetPostImportScript(m_trFilter, strScript);
		///---END RECOVER_SOME_OPTIONS_AFTER_PREVIEW
		
		/// Hong 9/05/06 REMOVE_FILE_IMPORT
		/*
		/// EJP 10-22-2003 v7.5728 QA70-5211.2 FIX_DESIG_AND_FMT_ON_PARTIAL_IMPORT
		strColDesig = wks.GetColDesignations();
		strColFormat = wks.GetColFormats();
		/// end FIX_DESIG_AND_FMT_ON_PARTIAL_IMPORT

		/// EJP 11-24-2003 v7.5769 QA70-5417.18 FIX_DESIG_AND_FMT
		///wks.SetColFormats("9", true); // temporary set all cols to Text&Numeric
		/// end FIX_DESIG_AND_FMT
		
		///---Sim 08-31-2006 GET_FILTER_BY_ID
		//if( m_trFilter.Type.nVal == FILTER_TYPE_ASCII )
		if( FILTER_TYPE_ASCII == fuGetType(m_trFilter) )
		///---END GET_FILTER_BY_ID
			nErr = wks.ImportASCII(m_saDataFiles[m_nActiveDataFile], aiTemp);
		else
			nErr = wuImportBinary(wks, m_saDataFiles[m_nActiveDataFile], &biTemp);
		/// EJP 10-22-2003 v7.5728 QA70-5211.2 FIX_DESIG_AND_FMT_ON_PARTIAL_IMPORT
		///strColDesig = fuGetDesignations(s_trFilter);
		///strColFormat = fuGetFormats(s_trFilter);
		/// end FIX_DESIG_AND_FMT_ON_PARTIAL_IMPORT
		
		/// EJP 09-12-2003 v7.5692 QA70-5135.15 COL_DESIGNATION_REPEAT_NOT_REMEMBERED
		///wks.SetColDesignations(strColDesig, false);
		///wks.SetColFormats(strColFormat, false);
		bool bRepeat = fuGetRepetitive(m_trFilter);
		wks.SetColDesignations(strColDesig, bRepeat);
		wks.SetColFormats(strColFormat, bRepeat);
		/// end COL_DESIGNATION_REPEAT_NOT_REMEMBERED
		/// end REIMPORT_AFTER_USER_CHANGE_COL_FORMAT
		*/
		/// end REMOVE_FILE_IMPORT
	}
	else
	{
		Worksheet wks;
		//if( s_iActivePageType == EXIST_PLOT )			///Danice CALL_SHEET_FUNCTION
		if( m_iActivePageType == EXIST_PLOT )
		{
			//wks.Attach(s_strWks); // Re-use temp worksheet to import to and then keep	///Danice CALL_SHEET_FUNCTION
			wks.Attach(m_strWks);
		}
		else
		{
			//wks.Attach(s_strWks);
			wks.Attach(m_strWks);
			if( wks )
				wks.Destroy();
			
			wks = (Worksheet) Project.ActiveLayer();
			if(!wks)
			{
				printf("No active worksheet to import.\n");
				return;
			}
		}
		m_strWks = wks.GetPage().GetName();
		/*
		SetupWksCols(s_strWks, s_trFilter);

		if( s_trFilter.Type.nVal == FILTER_TYPE_ASCII )
			nErr = wks.ImportASCII(s_strDataFile, s_ascimp);
		else if( s_trFilter.Type.nVal == FILTER_TYPE_BINARY )
			nErr = wuImportBinary(wks, s_strDataFile, &s_binimp);
		*/
	}
}

void ImpWizSheet::iwSetPartialImportForPreview(int& nPartial, int& nR1, int& nC1, int& nR2, int& nC2, int& nCols)
{
	if( nPartial )
	{
		if( nC2 < 0 )
			nC2 = nCols - 1;
		if( (nC2 - nC1 + 1) > IW_NUM_DATA_PREVIEW_COLS )
			nC2 = nC1 + IW_NUM_DATA_PREVIEW_COLS - 1;

		if( -1 == nR2 || (nR2 - nR1 + 1) > IW_NUM_DATA_PREVIEW_ROWS )
			nR2 = nR1 + IW_NUM_DATA_PREVIEW_ROWS - 1;
	}
	else
	{
		nPartial = 1;
		nC1 = 0;
		if( nCols > IW_NUM_DATA_PREVIEW_COLS )
			nC2 = IW_NUM_DATA_PREVIEW_COLS - 1;
		else
			nC2 = nCols - 1;
		nR1 = 0;
		nR2 = IW_NUM_DATA_PREVIEW_ROWS - 1;
	}
}

///Danice 2/12/04 V8.0819 CHANGE_GRID_TO_CLASS
/*
//BOOL iw_SetGridFont(int iCtrl, int iFont)
BOOL ImpWizSheet::iw_SetGridFont(Control ctrlGrid, int iFont)
{
	//Control ctrlGrid = ImportWizDlg.GetItem(iCtrl, iPage);
	if( ctrlGrid )
	{
		Object objGrid = ctrlGrid.GetActiveXControl();
		if( objGrid )
		{
			int iFontSize;
			objGrid.FontName = GetFontName(iFont, &iFontSize);
			return TRUE;
		}
	}
	return FALSE;
}
*/
///END CHANGE_GRID_TO_CLASS

/// EJP 01-04-2005 v8.0181 QA70-6555 USING_MULTI_OPEN_FDLOG
void ImpWizSheet::SetFileName(int nIndex)
{
	m_nActiveDataFile = nIndex;
}
/// end USING_MULTI_OPEN_FDLOG

/// SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG
int ImpWizSheet::GetActiveDataFile()
{
	return m_nActiveDataFile;
}
/// end USING_MULTI_OPEN_FDLOG

///Danice 12/15/03 v7.5783 ADD_NEW_FUNCTION_SOURCE
void ImpWizSheet::SetFileNames(const vector<string>& vsFileNames) 
{
	m_saDataFiles = vsFileNames;
	m_nActiveDataFile = 0; /// EJP 01-04-2005 v8.0181 QA70-6555 USING_MULTI_OPEN_FDLOG
}

void ImpWizSheet::SetFileName(LPCSTR lpcStrFileName) 
{
	/// EJP 01-04-2005 v8.0181 QA70-6555 USING_MULTI_OPEN_FDLOG
	///m_saDataFiles[0] = lpcStrFileName;
	m_saDataFiles[m_nActiveDataFile] = lpcStrFileName;
	/// end USING_MULTI_OPEN_FDLOG
}

string ImpWizSheet::GetFileName(int nIndex) // = 0) 
{
	/// EJP 01-04-2005 v8.0181 QA70-6555 USING_MULTI_OPEN_FDLOG
	if( -1 == nIndex )
		nIndex = m_nActiveDataFile;
	/// end USING_MULTI_OPEN_FDLOG
	return m_saDataFiles[nIndex];
}

vector<string> ImpWizSheet::GetDataFiles()
{
	return m_saDataFiles;
}

short ImpWizSheet::GetPlottingLayer(int iIndex) // = 0)
{ 
	return m_vPlottingLayers[iIndex];
}

void ImpWizSheet::SetPlottingLayer(short layer, int iIndex) // = 0)
{ 
	m_vPlottingLayers[iIndex] = layer;
}

bool ImpWizSheet::PlotInitFirstTime()
{ 
	return m_bPlotInitFirstTime;
}

void ImpWizSheet::PlotInitFirstTime(bool bFirst)
{ 
	m_bPlotInitFirstTime = bFirst;
}

void ImpWizSheet::SetWksName(LPCSTR lpcszWksName) 
{
	m_strWks = lpcszWksName;
}

string ImpWizSheet::GetWksName() 
{
	return m_strWks;
}

void ImpWizSheet::SetFilter(string strFilter) 
{
	m_strFilter = strFilter;
}

string ImpWizSheet::GetFilter() 
{
	return m_strFilter;
}

void ImpWizSheet::SaveFilter(int IFilter) 
{
	m_iSaveFilter = IFilter;
}

int	ImpWizSheet::GetSaveFilter()
{ 
	return m_iSaveFilter;
}

void ImpWizSheet::SetActivePageType(int IActivePageType) 
{
	m_iActivePageType = IActivePageType ;
}

int	ImpWizSheet::GetActivePageType() 
{
	return m_iActivePageType;
}

string ImpWizSheet::GetActivePageName() 
{
	return m_strActivePageName;
}

void ImpWizSheet::AddPlottingLayers()
{
	m_vPlottingLayers.SetSize(0);
	for( int i = 0; i < m_saDataFiles.GetSize(); i++ )
		m_vPlottingLayers.Add(0); // 0=first layer
}
///END ADD_NEW_FUNCTION_SOURCE

///Danice 12/15/03 v7.5783 ADD_NEW_FUNCTION_HEADLINES
void ImpWizSheet::SetPreviewFont(int IPreviewFont) 
{
	m_iPreviewFont = IPreviewFont;
}

int ImpWizSheet::GetPreviewFont() 
{
	return m_iPreviewFont;
}

///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
/*
//---- CPY 1/14/04 v7.5801 LOST_DELIMITED_WHEN_ENTER_ASC_COL_PAGE
//void	SetASCIMP(ASCIMP Ascimp) {m_ascimp = Ascimp;}
void	SetASCIMP(const ASCIMP& Ascimp) 
{
	m_ascimp = Ascimp;
}
//---- end LOST_DELIMITED_WHEN_ENTER_ASC_COL_PAGE
void 	GetASCIMP(ASCIMP& Ascimp) {Ascimp = m_ascimp;}
*/
ASCIMP*	ImpWizSheet::GetASCIMP_Pointer() 
{
	return &m_ascimp;
}
///END NEW_ACCESS_METHOD_GET_POINTER

int ImpWizSheet::GetASCPreviewLines() 
{
	return m_iAscHdrPreviewLines;
}
///END ADD_NEW_FUNCTION_HEADLINES

///Danice 12/15/03 v7.5783 ADD_NEW_FUNCTION_HEADBYTES
void ImpWizSheet::SetBinPreviewLines(int IBinHdrPreviewLines)
{
	m_iBinHdrPreviewLines = IBinHdrPreviewLines;
}

int ImpWizSheet::GetBinPreviewLines() 
{
	return m_iBinHdrPreviewLines;
}

///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
//void	SetBINIMP(const BINIMP& Binimp) {m_binimp = Binimp;}
//void 	GetBINIMP(BINIMP& Binimp) {Binimp = m_binimp;}
BINIMP*	ImpWizSheet::GetBINIMP_Pointer() 
{
	return &m_binimp;
}
///END NEW_ACCESS_METHOD_GET_POINTER

void ImpWizSheet::SetUserChange(int IUserChange) 
{ 
	m_iOnUserChange = IUserChange;
}

int ImpWizSheet::GetUserChange() 
{
	return m_iOnUserChange;
}

//void	SetParamName(const vector<string>& vsParamName) {m_saHdrParamName = vsParamName;}
//void	GetParamName(vector<string>& vsParamName) {vsParamName = m_saHdrParamName;}
///END ADD_NEW_FUNCTION_HEADBYTES

void ImpWizSheet::SetHdrParam(const vector<string>& vsParamName, const vector<int>& viHdrParamType, const vector<int>& viHdrParamOffset, const vector<int>& viHdrParamSize) 
{
	m_saHdrParamName 	= vsParamName;
	m_vHdrParamType 	= viHdrParamType ;
	m_vHdrParamOffset 	= viHdrParamOffset ;
	m_vHdrParamSize 	= viHdrParamSize ;
}
void ImpWizSheet::GetHdrParam(vector<string>& vsParamName, vector<int>& viHdrParamType,vector<int>& viHdrParamOffset,vector<int>& viHdrParamSize) 
{
	vsParamName 		= m_saHdrParamName ;
	viHdrParamType 		= m_vHdrParamType ;
	viHdrParamOffset 	= m_vHdrParamOffset ;
	viHdrParamSize 		= m_vHdrParamSize ;
}

///Danice 12/19/03 v7.5784 ADD_NEW_FUNCTION_DATACOLUMNS
//void	SetNumColsEstimated(int INumColsEstimated){m_iNumColsEstimated = INumColsEstimated ;}
int	ImpWizSheet::GetNumColsEstimated() 
{
	return m_iNumColsEstimated;
}

///Danice 1/16/04 v8.0800 USE_ONLY_IN_DATA_COLUMNS
//void	SetColWidths(const vector<short>& vsColWidths) {m_vColWidths = vsColWidths;}
//void	GetColWidths(vector<short>& vsColWidths) {vsColWidths = m_vColWidths;}
///END USE_ONLY_IN_DATA_COLUMNS

void ImpWizSheet::SetFixedWidthGridFontWidth(int IFixedWidthGridFontWidth) 
{
	m_iFixedWidthGridFontWidth = IFixedWidthGridFontWidth;
}

int ImpWizSheet::GetFixedWidthGridFontWidth() 
{
	return m_iFixedWidthGridFontWidth;
}
///END ADD_NEW_FUNCTION_DATACOLUMNS

///Danice 12/29/03 v7.5790 ADD_BUSY_IN_SHEET
bool ImpWizSheet::IsBusy() 
{
	return m_bBusy;
}

void ImpWizSheet::SetBusy(bool bSet) // = true) 
{
	m_bBusy = bSet;
}
///END ADD_BUSY_IN_SHEET

///Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR
string ImpWizSheet::GetstrFilterFileSaved() 
{
	return m_strFilterFileSaved;
}
///END FOR_NEW_DIALOG_CONSTRUCTOR

/// EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA
///	///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
///	bool ImpWizSheet::IsUpgradeData(bool bWrite) // = false)
///	{
///		bool bTemp = m_UpgradeData;
///		m_UpgradeData = bWrite;		//reset to false after read
///		return bTemp;
///	}
///	///END FOR_CONTROL_UPGRADE_DATA
void ImpWizSheet::UpgradeData(WORD flags) // = 0xFFFF
{
	m_UpgradeData = flags;
}

bool ImpWizSheet::IsUpgradeData(WORD flag)
{
	if( m_UpgradeData & flag )
	{
		m_UpgradeData &= ~flag;
		return true;
	}
	return false;
}
/// end FOR_CONTROL_UPGRADE_DATA

/// Zech 08/19/2011 ORG-3571-S1 ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS
//BOOL ImpWizSheet::iwSaveFilter()
//{
	////switch( m_trFilter.Type.nVal )
	//switch( fuGetType(m_trFilter) )//Hong 8/31/06 GET_FILTER_BY_ID
	//{
	//case FILTER_TYPE_ASCII:
		//m_trFilter.RemoveChild("BINIMP");
		//m_trFilter.RemoveChild("UserDefined");
		//break;
	//case FILTER_TYPE_BINARY:
		//m_trFilter.RemoveChild("ASCIMP");
		//m_trFilter.RemoveChild("UserDefined");
		//break;
	//case FILTER_TYPE_USERDEFINED:
		//m_trFilter.RemoveChild("ASCIMP");
		//m_trFilter.RemoveChild("BINIMP");
		//break;
	///// EJP 2005-08-16 v8.0289 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	//case FILTER_TYPE_XFUNC:
		//m_trFilter.RemoveChild("ASCIMP");
		//m_trFilter.RemoveChild("BINIMP");
		//m_trFilter.RemoveChild("UserDefined");
		//break;
	///// end IMPWIZ_SUPPORT_XFUNC
	//default:
		//return FALSE;
	//}
	//
	///// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS, move check to later
	/////if( s_strFilter.IsEmpty() )
	/////	return FALSE;
	///// end SAVE_FILTER_IN_WKS
//
	//fuSetHeaderParamDefined(m_trFilter, 1);
	//
	///// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	///*
	//switch( s_iSaveFilter )
	//{
	//case IDC_SAVE_FILTER_GLOBAL_RADIO:
		//return iwSaveFilterInUserFilesFolder(s_strFilter);
	//case IDC_SAVE_FILTER_DATA_FOLDER_RADIO:
		//return iwSaveFilterInDataFileFolder(s_strFilter, s_strDataFile);
	//}
	//return FALSE;
	//*/
	//if( IDC_SAVE_FILTER_IN_WKS == m_iSaveFilter )
	//{
		//Page pgTarget(m_strActivePageName);
		//return fuSaveFilterToPage(m_trFilter, pgTarget);
	//}
	//
	//if( m_strFilter.IsEmpty() )
		//return FALSE;
//
	//string strPath;
	//if( IDC_SAVE_FILTER_GLOBAL_RADIO == m_iSaveFilter )
		//strPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
	//else // IDC_SAVE_FILTER_DATA_FOLDER_RADIO
		////strPath = GetFilePath(s_strDataFile);
		//strPath = GetFilePath(m_saDataFiles[0]);
	//if( !strPath.IsPath() )
		//CreateDirectory(strPath, NULL);
//
	///// EJP 08-08-2003 v7.0650 QA70-4073.53 USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
	///*
	//string strFile;
	//strFile.Format("%s%s.%s", strPath, s_strFilter, IMPORT_FILTER_EXTENSION);
	//s_strFilter = strFile;
	//
	//return s_trFilter.Save(strFile);
	//*/
	//m_strFilterFileSaved.Format("%s%s.%s", strPath, GetFileName(m_strFilter, TRUE), IMPORT_FILTER_EXTENSION);
	///// Hong 02/08/07 WHEN_AUTO_MAIN_HEADER_SHOULD_NOT_BE_SET_BY_USER
	//if( FILTER_TYPE_ASCII == fuGetType(m_trFilter) && 1 == fuGetInt(m_trFilter, IDE_ASCIMP_AUTOSUBHEAD, 0))
		//fuSetInt(m_trFilter, IDE_ASCIMP_HEADLINES, 0);
	///// end WHEN_AUTO_MAIN_HEADER_SHOULD_NOT_BE_SET_BY_USER
	//return fuSave(m_trFilter, m_strFilterFileSaved);
	///// end SAVE_FILTER_IN_WKS
//}

BOOL ImpWizSheet::iwSaveFilter(bool isLastUsedFilter)
{
	Tree trRootTemp;
	TreeNode trTemp;
	if (!isLastUsedFilter)
		trTemp = m_trFilter;
	else
	{
		trTemp = m_trFilter.Clone();
		trRootTemp.AddNode(trTemp);		
		string strAllFile = "*.*";
		if (trTemp.Display.strFileSpec)
			trTemp.Display.strFileSpec.strVal = strAllFile;
	}
	
	switch( fuGetType(trTemp) )
	{
	case FILTER_TYPE_ASCII:
		trTemp.RemoveChild("BINIMP");
		trTemp.RemoveChild("UserDefined");
		break;
	case FILTER_TYPE_BINARY:
		trTemp.RemoveChild("ASCIMP");
		trTemp.RemoveChild("UserDefined");
		break;
	case FILTER_TYPE_USERDEFINED:
		trTemp.RemoveChild("ASCIMP");
		trTemp.RemoveChild("BINIMP");
		break;
	case FILTER_TYPE_XFUNC:
		trTemp.RemoveChild("ASCIMP");
		trTemp.RemoveChild("BINIMP");
		trTemp.RemoveChild("UserDefined");
		break;
	default:
		return FALSE;
	}

	fuSetHeaderParamDefined(trTemp, 1);

	string strPath;
	if (!isLastUsedFilter)
	{
		if( IDC_SAVE_FILTER_IN_WKS == m_iSaveFilter )
		{
			Page pgTarget(m_strActivePageName);
			return fuSaveFilterToPage(trTemp, pgTarget);
		}
		
		if( m_strFilter.IsEmpty() )
			return FALSE;
	
		
		if( IDC_SAVE_FILTER_GLOBAL_RADIO == m_iSaveFilter )
			strPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
		else 
			strPath = GetFilePath(m_saDataFiles[0]);
	}
	else
		strPath.Format("%s%s", GetAppPath(), FILTERS_FOLDER_NAME);
	
	if( !strPath.IsPath() )
		CreateDirectory(strPath, NULL);

	string strFilterFileSavedTemp;
	strFilterFileSavedTemp.Format("%s%s.%s", strPath, isLastUsedFilter?THEME_FILENAME_LAST_USED:GetFileName(m_strFilter, TRUE), IMPORT_FILTER_EXTENSION);
	if (!isLastUsedFilter)
		m_strFilterFileSaved = strFilterFileSavedTemp;
	if( FILTER_TYPE_ASCII == fuGetType(trTemp) && 1 == fuGetInt(trTemp, IDE_ASCIMP_AUTOSUBHEAD, 0))
		fuSetInt(trTemp, IDE_ASCIMP_HEADLINES, 0);
	
	return fuSave(trTemp, strFilterFileSavedTemp);
}
/// END ADD_LAST_USED_FILTER_TO_IMPORT_WIZARD_DIALOGS



/// EJP 08-01-2003 v7.0642 DETECT_IMPORT_SETTINGS_CHANGED
bool ImpWizSheet::iwIsLoadedFilterSettingsChanged()
{
	if( m_strFilterLoaded.IsEmpty() )
		return false; // no filter was loaded

	// Load a copy of the filter we started with
	Tree trStartFilter;
	/// EJP 2005-05-10 v8.0231 SUPPORT_VERSION_CHANGES
	///if( !trStartFilter.Load(m_strFilterLoaded) )
	if( !fuLoad(trStartFilter, m_strFilterLoaded) )
	/// end SUPPORT_VERSION_CHANGES
		return false; // can not compare so assume no change

	//switch( m_trFilter.Type.nVal )
	int nType = fuGetType(m_trFilter);
	switch( nType )//Hong 8/31/06 GET_FILTER_BY_ID
	{
	case FILTER_TYPE_ASCII:
		{
			ASCIMP aiStart, aiCurrent;
			if( fuGetASCIMP(trStartFilter, aiStart) &&
				fuGetASCIMP(m_trFilter, aiCurrent) )
			{
				return (memcmp(&aiStart, &aiCurrent, sizeof(ASCIMP)) != 0);
			}
		}
		return false; // can not compare so assume no change
	case FILTER_TYPE_BINARY:
		{
			BINIMP biStart, biCurrent;
			if( fuGetBINIMP(trStartFilter, biStart) &&
				fuGetBINIMP(m_trFilter, biCurrent) )
			{
				/// EJP 09-08-2003 v7.5687 QA70-5118 FIX_COMPARE_BINIMP_STRUCTS
				///return (memcmp(&biStart, &biCurrent, sizeof(BINIMP)) != 0);
				return !is_BINIMP_equal(biStart, biCurrent);
				/// end FIX_COMPARE_BINIMP_STRUCTS
			}
		}
		return false; // can not compare so assume no change
	case FILTER_TYPE_USERDEFINED:
		{
			string strOCFile1, strOCFunc1;
			fuGetUserDefinedFunction(m_trFilter, strOCFile1, strOCFunc1);

			string strOCFile2, strOCFunc2;
			fuGetUserDefinedFunction(trStartFilter, strOCFile2, strOCFunc2);
			
			if( strOCFile1.CompareNoCase(strOCFile2) || strOCFunc1.CompareNoCase(strOCFunc2) )
				return true;
		}
		break;
	}
	return false; // can not compare so assume no change
}
/// end DETECT_IMPORT_SETTINGS_CHANGED


//--------------------------------------------------------------------------
// IW_PlotToActiveGraph
//
// Plot the data file, specified on the source page, into the active
// graph using the current settings on the Plotting page.
//
//--------------------------------------------------------------------------
/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
//BOOL ImpWizSheet::IW_PlotToActiveGraph(Page &pgData, int iFileNumber)
BOOL ImpWizSheet::IW_PlotToActiveGraph(DataRange& drPlots, int iFileNumber)
/// end FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
{
	GraphPage gpGraph(m_strActivePageName);
	if( gpGraph )
	{
		// Get Layer number and GraphLayer object
		int iLayerNumber; // 0 based layer number
		GraphLayer glLayer;
		iLayerNumber = m_vPlottingLayers[iFileNumber]; // Read 0 based layer number for current file from static 
		glLayer = gpGraph.Layers(iLayerNumber); // Get specified layer  
	
		if( !glLayer ) // If Layer is not valid...
			glLayer = gpGraph.Layers(); // Get active layer
	
		if( glLayer )
		{
			// Plot all datasets in Worksheet to specified Layer using specified Plot ID	
			///Tree trFilter; trFilter = IW_GetFilter();
			int iOriginPlotType = fuGetPlotID(m_trFilter);
	
	//			// This function is called after a file is imported.
	//			// It assumes the active window is the target worksheet.
			/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
			/*
			string strNewWks;
			strNewWks = pgData.GetName();
	//			PageBase pbActiveWindow;
	//			pbActiveWindow = Project.Pages();
	//			if( pbActiveWindow.IsValid() )
	//			{
	//				strNewWks = pbActiveWindow.GetName();
	
				string strLTCommand;
				//strLTCommand.Format("Win -a %%H;Layer -w %s 0 0 0 0 %d;", strNewWks, iOriginPlotType);
				strLTCommand.Format("Win -a %%H;Layer -w %s %d;", strNewWks, iOriginPlotType); // Hong 01/12/07 FIX_FAIL_SET_CORECT_RANGE
				glLayer.LT_execute(strLTCommand);
				*/
				plot_data_range(drPlots, glLayer, iOriginPlotType);
				/// end FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
				glLayer.Rescale();
	//			}			
		}
	}
	
	return TRUE;
}

/// EJP 09-08-2003 v7.5687 QA70-5118 FIX_COMPARE_BINIMP_STRUCTS
bool ImpWizSheet::is_BINIMP_equal(BINIMP &bi1, BINIMP &bi2)
{
	if( bi1.iHeaderBytes != bi2.iHeaderBytes ||
		bi1.iAutoColTypes != bi2.iAutoColTypes ||
		bi1.iNumColumns != bi2.iNumColumns ||
		bi1.iRenameWks != bi2.iRenameWks ||
		bi1.iBigEndian != bi2.iBigEndian ||
		bi1.iApplyRange != bi2.iApplyRange ||
		bi1.iMode != bi2.iMode ||
		bi1.iSkipRows != bi2.iSkipRows ||
		bi1.iPartial != bi2.iPartial )
	{
		return false;
	}
	
	if( bi1.iPartial )
	{
		if( bi1.iPartialC1 != bi2.iPartialC1 ||
			bi1.iPartialC2 != bi2.iPartialC2 ||
			bi1.iPartialR1 != bi2.iPartialR1 ||
			bi1.iPartialR2 != bi2.iPartialR2 )
		{
			return false;
		}
	}
	
	if( bi1.vParamType.GetSize() != bi2.vParamType.GetSize() ||
		bi1.vParamSize.GetSize() != bi2.vParamSize.GetSize() ||
		bi1.vParamCount.GetSize() != bi2.vParamCount.GetSize() )
	{
		return false;
	}
	
	for( int i = 0; i < bi1.vParamType.GetSize(); i++ )
	{
		if( bi1.vParamType[i] != bi2.vParamType[i] ||
			bi1.vParamSize[i] != bi2.vParamSize[i] ||
			bi1.vParamCount[i] != bi2.vParamCount[i] )
		{
			return false;
		}
	}
	
	return true;
}
/// end FIX_COMPARE_BINIMP_STRUCTS

/// SY 09/29/2004 QA70-5658 v8.0142 IMPROVE_HDRVAR_EXTRACTION
void ImpWizSheet::EnableFlag(DWORD dwFlag) 
{
	m_flags |= dwFlag;
}

void ImpWizSheet::DisableFlag(DWORD dwFlag) 
{
	m_flags &= ~dwFlag;
}

BOOL ImpWizSheet::IsFlagEnabled(DWORD dwFlag) 
{
	///return (m_flags & (iFlag));
	return (m_flags & dwFlag);
//	if( m_flags & iFlag )
//		return true;
//	return false;
}

BOOL ImpWizSheet::IsFlagDisabled(DWORD dwFlag) 
{
	return !IsFlagEnabled(dwFlag);
}	
/// end IMPROVE_HDRVAR_EXTRACTION	

