/*------------------------------------------------------------------------------*
 * File Name: ImpWizSaveFilters.h												*
 * Creation: Jason 12/12/2003													*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME							*
 *	 Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS						*
 *   Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_SAVEFILTERS						*
 *   Jason 12/19/03 v7.5781 USE_SHEET_SETFILTER									*
 *	 Jason 12/26/03 v7.5789 USE_M_CBNAME										*
 *	 Jason 12/26/03 v7.5789 USE_M_EDITFILESPEC									*
 *   Danice 2/24/04 v8.0825 PREVENT_INIT_RUN_IN_ASC_AND_BIN						*
 *   Danice 3/1/04 v8.0828 PAGE_INIT_ONCE										*
 *   SY 08/31/2004 v8.0127 QA70-5417.38 SAVE_FILTERS_FAILED						*
 *	Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST				*
 *------------------------------------------------------------------------------*/

#define ON_PAGE_CHECK_SAVE_FILTER


class ImpWizSaveFiltersPage : public ImpWizardPage
{
	// Constructor for ImpWizSaveFiltersPage class, use parent constructor
	//ImpWizSaveFiltersPage(int nID) : ImpWizardPage(nID) {}
	
public:
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInit_SaveFilters)
		PAGE_ON_ACTIVE(OnActive_SaveFilters)
		PAGE_ON_KILLACTIVE(OnKillActive_SaveFilters)

		ON_BN_CLICKED(IDC_SAVE_FILTER, OnClickSaveFilter_SaveFilters)
		ON_BN_CLICKED(IDC_SAVE_FILTER_DATA_FOLDER_RADIO, OnClickDestination_SaveFilters)
		ON_BN_CLICKED(IDC_SAVE_FILTER_GLOBAL_RADIO, OnClickDestination_SaveFilters)
		ON_BN_CLICKED(IDC_SAVE_FILTER_IN_WKS, OnClickDestination_SaveFilters)
		ON_EN_CHANGE(IDC_FILTER_DESCRIP, OnEditChangeFilterDescription)
		ON_CBN_SELCHANGE(IDC_SAVE_FILTERS_NAME_COMBO, OnSelChangeFilterName_SaveFilter)
		ON_CBN_EDITCHANGE(IDC_SAVE_FILTERS_NAME_COMBO, OnEditChangeFilterName_SaveFilter)
		ON_BN_CLICKED(IDC_SAVE_FILTERS_ADVANCED, OnClickAdvanced_SaveFilters)
		
		ON_BN_CLICKED(IDC_SAVE_FILTERS_OPEN_LIST, OnClickShowFilter)  // Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
		
		ON_EN_CHANGE(IDC_SAVE_FILTERS_APPLICABILITY_EDIT, OnChangeFileSpec)
	EVENTS_END

	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
	DWORD OnShowStatus(DWORD InternalStatus);
	///END NOTUSE_SHOW

	/// Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
	BOOL OnInit_SaveFilters();
	BOOL OnActive_SaveFilters();
	BOOL OnKillActive_SaveFilters();
	BOOL OnClickSaveFilter_SaveFilters(Control ctrl);
	BOOL OnClickAdvanced_SaveFilters(Control ctrl);
	BOOL OnClickDestination_SaveFilters(Control ctrl);
	BOOL OnSelChangeFilterName_SaveFilter(Control ctrl);
	BOOL OnEditChangeFilterName_SaveFilter(Control ctrl);
	/// end CHANGE_SOME_FUNCTION_NAME
	
	BOOL OnClickShowFilter(Control ctrl); // Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST

	BOOL OnEditChangeFilterDescription(Control ctrl);
	BOOL OnChangeFileSpec(Control ctrl);

	void SaveFilters_EnableControls();
	BOOL SaveFilters_UpdateData(BOOL bDataToDlg=TRUE);
	void SaveFilter_UpdateButtons();
	void SaveFilter_UpdateFilterComboBox();
	string AIW_GetExtensionFromPath(LPCSTR lpcszPath); // return extension in "*.abc" format
	void iwFillFilterComboBox(ComboBox& comboFilters, LPCSTR lpcszPath);
	void iwAddFiltersToComboBox(ComboBox& comboFilters, StringArray& saFilterFiles, int iFilterLocPrefix);
	
private:
	Button 		m_rbDataFolder;
	Button 		m_rbUserFolder;
	Button 		m_rbWks;
	Button 		m_chkAdvOptions;
	Button 		m_chkSaveFilter;
	Button 		m_chkShowFilter; // Hong 04/17/07 QA80-9634 V8.0602b FILTER_SHOW_IN_FILE_OPEN_LIST
	
	Edit 		m_ebDescrip;
	Edit 		m_editFileSpec;
	Edit 		m_ebDataFolder;
	Edit 		m_ebUserFilesFolder;
	
	ComboBox 	m_cbName;
};
