/*------------------------------------------------------------------------------*
 * File Name: ImpWizPlotting.h													*
 * Creation: Jason 12/14/2003													*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_PLOTTING							*
 *	 Jason 12/14/03 v7.5781 MOVED_INITIAL_FUNCTION								*
 *   Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_GETFILENAME						*
 *   Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_PLOTTINGLAYER					*
 *   Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_PLOTINITFIRSTTIME				*
 *   Jason 12/26/03 v7.5789 USE_M_CBPLOTTYPE									*
 *   Iris 02/12/04 v8.0819 ADD_PLOTGRID_CLASS									*
 *   Danice 2/16/04 v8.0821 FUNCTION_IN_RESIZE_CONTROL							*
 *   Danice 3/1/04 v8.0828 PAGE_INIT_ONCE										*
 *   Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL							*
 *   SY 10/13/2004 v8.0147 IMPORT_WIZARD_CLEANUP								*
 *------------------------------------------------------------------------------*/
 

 
#define ON_PAGE_CHECK_PLOTTING				if(!IS_SHOW_PLOTTING_PAGE) return false;

enum {PGCTRL_FILE_NAME_COL = 0, PGCTRL_LAYER_NUM_COL, PGCTRL_FILE_SIZE_COL, PGCTRL_MODIFY_DATE_COL, PGCTRL_TOTAL_COLS};

///Iris 02/12/04 ADD_PLOTGRID_CLASS
class PlotGridControl : public GridListControl
{
public:
	PlotGridControl();
	
	void Init(int nID, WndContainer& dlg);
	
	string	GetEditText();
	
	void Update(int iNumFiles);
	
	void SetFiles(vector<string> vsFiles);
	
	void SetPlottingLayerNum(vector<int> vnPlottingLayers);
	
private:
	vector<string> 	m_vsFileNames;
	vector<int> 	m_vnPlottingLayerNum;
};
///End ADD_PLOTGRID_CLASS

// Derived WizPage class for WizPage1
class ImpWizPlottingPage : public ImpWizardPage
{
	// Constructor for ImpWizPlottingPage class, use parent constructor
	//ImpWizPlottingPage(int nID) : ImpWizardPage(nID) {}
	
public:
	
	EVENTS_BEGIN
		//PAGE_ON_IS_SHOW(OnIsShow_Plotting)		///Danice 12/25/03 v7.5788 NOTUSE_SHOW
		PAGE_ON_INIT(OnInit_Plotting)
		PAGE_ON_ACTIVE(OnActivate_Plotting)
		PAGE_ON_KILLACTIVE(OnKillActive_Plotting)

		ON_CBN_SELCHANGE(IDC_IW_PLOT_TYPE, OnPlotTypeChange_Plotting)
		ON_GRID_COMBO_CLOSEUP(IDC_IW_PLOT_GRID_HLDR, OnGridComboCloseUpGrid_Plotting)
		ON_GRID_BEFORE_EDIT(IDC_IW_PLOT_GRID_HLDR, OnBeforeEditCell_Plotting)
	EVENTS_END

	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
	//Events handles
	//BOOL OnIsShow_Plotting(DWORD dwPageID, DWORD lParam);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	DWORD OnShowStatus(DWORD InternalStatus);
	///END NOTUSE_SHOW

	BOOL OnActivate_Plotting();	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME

	BOOL OnKillActive_Plotting();	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME

	BOOL OnBeforeEditCell_Plotting(Control ctrl, int iRow, int iCol, BOOL *pCancel); ///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME

	BOOL OnInit_Plotting();	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	int Plotting_GetCurSelPlotID();
	
	int Plotting_SetCurSelPlotID(int iPlotID);
	
	//--------------------------------------------------------------------------
	// Plotting_OnPlotTypeChange
	//
	// Dialog Builder calls this function when the selection in the Plot Type
	// combobox on the Plotting page changes.
	//--------------------------------------------------------------------------
	BOOL OnPlotTypeChange_Plotting(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL OnGridComboCloseUpGrid_Plotting(Control ctrl, int nRow, int nCol, BOOL* pFinishEdit);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	void Plotting_UpdateGrid();
	
	void Plotting_UpdateData(BOOL bDlgToData=true);

private:
	
	//Control 	m_ctrlGrid;///Iris 02/12/04 ADD_PLOTGRID_CLASS
	PlotGridControl		m_gridPlotControl;
	
	Edit 		m_editDesig;
	
	ComboBox 	m_cbPlotType;
	//ComboBox 	m_cmbxPlotType;		///Jason 12/26/03 v7.5789 USE_M_CBPLOTTYPE	
};
