/*------------------------------------------------------------------------------*
 * File Name: ImpWizPlotting.c													*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 

#include <Origin.h>
#include "IWfirst.h"

///Iris 02/12/04 ADD_PLOTGRID_CLASS
PlotGridControl::PlotGridControl()
{
}

void PlotGridControl::Init(int nID, WndContainer& dlg)
{		
	GridListControl::Init(nID, dlg);
	
	///Danice 2/16/04 v8.0821 FUNCTION_IN_RESIZE_CONTROL
	//SetupRowsCols(0, 1, IW_PLOTTING_GRID_NUM_COLS);	///Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL
	SetupRowsCols(1, 0, -1, IW_PLOTTING_GRID_NUM_COLS);
	m_flx.Editable = 1;
	//m_flx.FixedCols = 0;
	//m_flx.FixedRows = 1;
	///END FUNCTION_IN_RESIZE_CONTROL
	m_flx.ExtendLastCol = TRUE;
	m_flx.SelectionMode = flexSelectionFree ;
	m_flx.AllowSelection = TRUE;
	m_flx.AllowUserResizing = 1;
	//m_flx.ColWidthMin = 0;
	//m_flx.ColWidthMax = 0;
	m_flx.ExplorerBar = flexExSortShow;
	
	//Set Columns title
	/*
	m_flx.Row = 0;
	m_flx.Col = 	PGCTRL_FILE_NAME_COL;
	m_flx.Text = 	IW_FILE_NAME;
	m_flx.Col = 	PGCTRL_LAYER_NUM_COL;
	m_flx.Text = 	IW_LAYER_NUM;
	m_flx.Col = 	PGCTRL_FILE_SIZE_COL;
	m_flx.Text = 	IW_FILE_SIZE;
	m_flx.Col = 	PGCTRL_MODIFY_DATE_COL;
	m_flx.Text = 	IW_MODIFY_DATE;
	m_flx.ColDataType(3) = flexDTDate;
	*/
	SetColHeading(PGCTRL_FILE_NAME_COL, _L("File Name"));
	SetColHeading(PGCTRL_LAYER_NUM_COL, _L("Layer#"));
	SetColHeading(PGCTRL_FILE_SIZE_COL, _L("Size"));
	SetColHeading(PGCTRL_MODIFY_DATE_COL, _L("Modify Date"));
	
	string strLayers;
	/// SY 10/13/2004 v8.0147 IMPORT_WIZARD_CLEANUP
	///int i, iActive = GetLayerNumbers(strLayers); // Get 1 based Layer numbers for display
	int i, iActive = page_get_layer_numbers(strLayers); // Get 1 based Layer numbers for display
	/// end IMPORT_WIZARD_CLEANUP
	SetColComboList(PGCTRL_LAYER_NUM_COL, strLayers);
	/*
	int nLastRow = m_flx.Rows - 1;
	string strTemp = iActive;
	m_flx.Cell(flexcpText, nLastRow, PGCTRL_LAYER_NUM_COL) = strTemp;
	*/
	// Grid column widths
	//for( i = 0; i < IW_PLOTTING_GRID_NUM_COLS; i++ )
	//	m_flx.ColWidth(i) = m_flx.ClientWidth * 0.25;
	vector	vColWidthPercent = {0.25, 0.25, 0.25, 0.249};//Sum a little less then 1, so the rollbar don't appear at first
	ResizeCols(vColWidthPercent);
}

string PlotGridControl::GetEditText()
{
	return m_flx.EditText;
}

void PlotGridControl::Update(int iNumFiles)
{
	m_flx.Rows = iNumFiles + 1;

	for( int iFile = 0; iFile < iNumFiles; iFile++ )
	{
		/*
		m_flx.Row = iFile + 1;
	
		m_flx.Col = PGCTRL_FILE_NAME_COL; // file name
		m_flx.Text = GetFileName(m_vsFileNames[iFile]);//GetFileName(m_pSheet->GetFileName(iFile));
	
		m_flx.Col = PGCTRL_LAYER_NUM_COL; // layer number
		//str.Format("%d", m_pSheet->GetPlottingLayer(iFile)+1);
		string str;
		str.Format("%d", m_vnPlottingLayerNum[iFile]+1);
		m_flx.Text = str;

		m_flx.Col = PGCTRL_FILE_SIZE_COL; // file size
		m_flx.Text = GetFileSize(m_vsFileNames[iFile]);//GetFileSize(m_pSheet->GetFileName(iFile));
		
		m_flx.Col = PGCTRL_MODIFY_DATE_COL; // modify date
		//m_flx.Text = GetFileModificationDate(m_pSheet->GetFileName(iFile), LDF_SHORT_AND_HHMM_SEPARCOLON);
		m_flx.Text = GetFileModificationDate(m_vsFileNames[iFile], LDF_SHORT_AND_HHMM_SEPARCOLON);
		*/
		int	iNewFileRow = iFile+1;
		SetCell(iNewFileRow, PGCTRL_FILE_NAME_COL, GetFileName(m_vsFileNames[iFile]));
		SetCell(iNewFileRow, PGCTRL_LAYER_NUM_COL, m_vnPlottingLayerNum[iFile]+1);
		SetCell(iNewFileRow, PGCTRL_FILE_SIZE_COL, GetFileSize(m_vsFileNames[iFile]));
		SetCell(iNewFileRow, PGCTRL_MODIFY_DATE_COL, GetFileModificationDate(m_vsFileNames[iFile], LDF_SHORT_AND_HHMM_SEPARCOLON));
	}
}

void PlotGridControl::SetFiles(vector<string> vsFiles)
{
	m_vsFileNames = vsFiles;
}

void PlotGridControl::SetPlottingLayerNum(vector<int> vnPlottingLayers)
{
	m_vnPlottingLayerNum = vnPlottingLayers;
}
///End ADD_PLOTGRID_CLASS

///Danice 12/25/03 v7.5788 NOTUSE_SHOW
/*
//Events handles
BOOL OnIsShow_Plotting(DWORD dwPageID, DWORD lParam)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_PLOTTING
	return TRUE;
}
*/
DWORD ImpWizPlottingPage::OnShowStatus(DWORD InternalStatus)
{
	return (IS_SHOW_PLOTTING_PAGE ? PSS_Show : PSS_Ignore);
}
///END NOTUSE_SHOW


BOOL ImpWizPlottingPage::OnActivate_Plotting()	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_PLOTTING
	//Edit editDesig = ImportWizDlg.GetItem(IDC_IW_PLOT_RO_PLOT_DESIG, IDD_IW_PLOTTING);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_PLOTTING
	m_editDesig = GetItem(IDC_IW_PLOT_RO_PLOT_DESIG);
	m_editDesig.Text = fuGetDesignations(s_trFilter);
	Plotting_UpdateGrid();
	Plotting_UpdateData(false); // false = data to dialog
	return TRUE;
}

BOOL ImpWizPlottingPage::OnKillActive_Plotting()	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_PLOTTING
	Plotting_UpdateData();
	return true;
}

BOOL ImpWizPlottingPage::OnBeforeEditCell_Plotting(Control ctrl, int iRow, int iCol, BOOL *pCancel)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	if( iCol != 1 ) // if not Layer # column
		*pCancel = true; // do not allow editing
	return true;
}

BOOL ImpWizPlottingPage::OnInit_Plotting()	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_PLOTTING
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE

	///Jason 12/14/03 v7.5781 MOVED_INITIAL_FUNCTION
	m_editDesig = GetItem(IDC_IW_PLOT_RO_PLOT_DESIG);
	//m_ctrlGrid = GetItem(IDC_IW_PLOT_GRID_HLDR); ///Iris 02/12/04 ADD_PLOTGRID_CLASS
	m_cbPlotType = GetItem(IDC_IW_PLOT_TYPE);
	//m_cmbxPlotType = GetItem(IDC_IW_PLOT_TYPE);
	///End MOVED_INITIAL_FUNCTION

	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_IW_PLOT_GRID_HLDR, IDD_IW_PLOTTING);
	///Iris 02/12/04 ADD_PLOTGRID_CLASS
	/*
	if( !m_ctrlGrid )
		return FALSE;
	Object objPlottingGrid = m_ctrlGrid.GetActiveXControl();
	if( !objPlottingGrid )
		return FALSE;
	
	objPlottingGrid.Cols = IW_PLOTTING_GRID_NUM_COLS;
	objPlottingGrid.Editable = 1;
	objPlottingGrid.FixedCols = 0;
	objPlottingGrid.FixedRows = 1;
	objPlottingGrid.ExtendLastCol = TRUE;
	objPlottingGrid.AllowUserResizing = 1;
	objPlottingGrid.ColWidthMin = 0;
	objPlottingGrid.ColWidthMax = 0;
	objPlottingGrid.ExplorerBar = flexExSortShow;

	objPlottingGrid.Row = 0;
	objPlottingGrid.Col = 0;
	objPlottingGrid.Text = IW_FILE_NAME;
	objPlottingGrid.Col = 1;
	objPlottingGrid.Text = IW_LAYER_NUM;
	objPlottingGrid.Col = 2;
	objPlottingGrid.Text = IW_FILE_SIZE;
	objPlottingGrid.Col = 3;
	objPlottingGrid.Text = IW_MODIFY_DATE;
	objPlottingGrid.ColDataType(3) = flexDTDate;
	
	string strLayers;
	int i, iActive = GetLayerNumbers(strLayers); // Get 1 based Layer numbers for display
	objPlottingGrid.ColComboList(1) = strLayers;
	objPlottingGrid.Cell(flexcpText, 1, 1, objPlottingGrid.Rows - 1, 1) = iActive;
	*/
	m_gridPlotControl.Init(IDC_IW_PLOT_GRID_HLDR, *this); 
	///End ADD_PLOTGRID_CLASS


	//if( s_bPlotInitFirstTime )	///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_PLOTINITFIRSTTIME
	if( m_pSheet->PlotInitFirstTime() )
	{
		//ComboBox cmbxPlotType = ImportWizDlg.GetItem(IDC_IW_PLOT_TYPE, IDD_IW_PLOTTING);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_PLOTTING
		// Plot Type combox items
		m_cbPlotType.SetItemData(IW_PLOT_LINE, IDM_PLOT_LINE);
		m_cbPlotType.SetItemData(IW_PLOT_SCATTER, IDM_PLOT_SCATTER);
		m_cbPlotType.SetItemData(IW_PLOT_LINESYMB, IDM_PLOT_LINESYMB);
		m_cbPlotType.SetItemData(IW_PLOT_COLUMN, IDM_PLOT_COLUMN);
		m_cbPlotType.SetItemData(IW_PLOT_BAR, IDM_PLOT_BAR);

		///Iris 02/12/04 ADD_PLOTGRID_CLASS
		// Grid column widths
		//for( i = 0; i < IW_PLOTTING_GRID_NUM_COLS; i++ )
			//objPlottingGrid.ColWidth(i) = objPlottingGrid.ClientWidth * 0.25;
		///End ADD_PLOTGRID_CLASS
		
		//s_bPlotInitFirstTime = FALSE;	///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_PLOTINITFIRSTTIME
		m_pSheet->PlotInitFirstTime(FALSE);
	}

	return TRUE;
}

int ImpWizPlottingPage::Plotting_GetCurSelPlotID()
{
	//ComboBox cbPlotType = ImportWizDlg.GetItem(IDC_IW_PLOT_TYPE, IDD_IW_PLOTTING);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_PLOTTING
	int i = m_cbPlotType.GetCurSel();
	if( i != -1 )
		return m_cbPlotType.GetItemData(i);
	return IDM_PLOT_LINE;
}

int ImpWizPlottingPage::Plotting_SetCurSelPlotID(int iPlotID)
{
	int iIndex;
	switch( iPlotID )
	{
	case IDM_PLOT_SCATTER:
	case IDM_PLOT_LINESYMB:
	case IDM_PLOT_COLUMN:
		iIndex = iPlotID - IDM_PLOT_LINE;
		break;
	case IDM_PLOT_BAR:
		iIndex = IW_PLOT_BAR;
		break;
	default: // IDM_PLOT_LINE
		iIndex = IW_PLOT_LINE;
		break;
	}	 

	//ComboBox cbPlotType = ImportWizDlg.GetItem(IDC_IW_PLOT_TYPE, IDD_IW_PLOTTING);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_PLOTTING
	return m_cbPlotType.SetCurSel(iIndex);
}

//--------------------------------------------------------------------------
// Plotting_OnPlotTypeChange
//
// Dialog Builder calls this function when the selection in the Plot Type
// combobox on the Plotting page changes.
//--------------------------------------------------------------------------
BOOL ImpWizPlottingPage::OnPlotTypeChange_Plotting(Control ctrl)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ComboBox cmbxPlotType(ctrl);
	int iPlotTypeSel = cmbxPlotType.GetCurSel();
	if( iPlotTypeSel >= 0 )
		fuSetPlotID(s_trFilter, cmbxPlotType.GetItemData(iPlotTypeSel));
	else
		fuSetPlotID(s_trFilter, IDM_PLOT_UNKNOWN);
	return true;
}

BOOL ImpWizPlottingPage::OnGridComboCloseUpGrid_Plotting(Control ctrl, int nRow, int nCol, BOOL* pFinishEdit)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	///Iris 02/12/04 ADD_PLOTGRID_CLASS
	//Object objPlottingGrid = ctrl.GetActiveXControl();
	//string str = objPlottingGrid.EditText;
	string str = m_gridPlotControl.GetEditText();
	///End ADD_PLOTGRID_CLASS
	
	//s_vPlottingLayers[nRow - 1] = atoi(str) - 1;	///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_PLOTTINGLAYER
	m_pSheet->SetPlottingLayer(atoi(str) - 1, nRow - 1);
	return true;
}

void ImpWizPlottingPage::Plotting_UpdateGrid()
{
	int iNumFiles = NUM_DATA_FILES;
	///Iris 02/12/04 ADD_PLOTGRID_CLASS
	/*
	string str;
	
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_IW_PLOT_GRID_HLDR, IDD_IW_PLOTTING);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_PLOTTING
	if( !m_ctrlGrid )
		return;
	Object objPlottingGrid = m_ctrlGrid.GetActiveXControl();
	if( !objPlottingGrid )
		return;
	objPlottingGrid.Rows = iNumFiles + 1;

	for( int iFile = 0; iFile < iNumFiles; iFile++ )
	{
		objPlottingGrid.Row = iFile + 1;
	
		objPlottingGrid.Col = 0; // file name
		///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_GETFILENAME
		//objPlottingGrid.Text = GetFilename(s_saDataFiles[iFile]);
		objPlottingGrid.Text = GetFilename(m_pSheet->GetFileName(iFile));
	
		objPlottingGrid.Col = 1; // layer number
		//str.Format("%d", s_vPlottingLayers[iFile]+1); // +1=user sees with 1	///Jason 12/19/03 v7.5781 USE_SHEET_FUNCTION_PLOTTINGLAYER
		str.Format("%d", m_pSheet->GetPlottingLayer(iFile)+1);
		objPlottingGrid.Text = str;

		objPlottingGrid.Col = 2; // file size
		//objPlottingGrid.Text = GetFileSize(s_saDataFiles[iFile]);
		objPlottingGrid.Text = GetFileSize(m_pSheet->GetFileName(iFile));
		
		objPlottingGrid.Col = 3; // modify date
		//objPlottingGrid.Text = GetFileModificationDate(s_saDataFiles[iFile], LDF_SHORT_AND_HHMM_SEPARCOLON);
		objPlottingGrid.Text = GetFileModificationDate(m_pSheet->GetFileName(iFile), LDF_SHORT_AND_HHMM_SEPARCOLON);
		///End USE_SHEET_FUNCTION_GETDATAFILES
	}
	*/
	vector<string> vsFiles(iNumFiles);
	vector<int> vnPlottingLayers(iNumFiles);
	for( int iFile = 0; iFile < iNumFiles; iFile++ )
	{
		vsFiles[iFile] = m_pSheet->GetFileName(iFile);
		vnPlottingLayers[iFile] = m_pSheet->GetPlottingLayer(iFile);
	}
	
	m_gridPlotControl.SetFiles(vsFiles);	
 	m_gridPlotControl.SetPlottingLayerNum(vnPlottingLayers);
	m_gridPlotControl.Update(NUM_DATA_FILES);
	///End ADD_PLOTGRID_CLASS
}

void ImpWizPlottingPage::Plotting_UpdateData(BOOL bDlgToData) //=true)
{
	int i;
	string str;
	
	if( bDlgToData )
	{
		fuSetPlotID(s_trFilter, Plotting_GetCurSelPlotID());
	}
	else
	{
		Plotting_SetCurSelPlotID(fuGetPlotID(s_trFilter));
	}
}
