/*------------------------------------------------------------------------------*
 * File Name: ImpWizHeaderBytes.c												*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA								*
 *------------------------------------------------------------------------------*/
 

#include <Origin.h>
#include "IWfirst.h"
 
DWORD ImpWizHeaderBytesPage::OnShowStatus(DWORD InternalStatus)
{
	return (IS_FILTER_TYPE_BINARY ? PSS_Show : PSS_Ignore);
}

void ImpWizHeaderBytesPage::InitializeBitmapButtons()
{
	BitmapRadioButton radioButton;
	
	radioButton = GetItem(IDC_IW_BIN_HEADER_TBHLDR);
	vector<string>  vstrTips;
	vstrTips.SetSize(1);
	vstrTips[0] = _L("Position cursor immediately to right of last header byte and click refresh button");
	radioButton.Init(1, IDB_REFRESH_BLACK, 16, vstrTips);
}

int ImpWizHeaderBytesPage::AddBinHdrParam(LPCSTR lpcszName, int nType, int nSize, int nOffset)
{
	m_saHdrParamName.Add(lpcszName);
	m_vHdrParamType.Add(nType);
	m_vHdrParamSize.Add(nSize);
	m_vHdrParamOffset.Add(nOffset);
	return m_saHdrParamName.GetSize();
}

BOOL ImpWizHeaderBytesPage::DelBinHdrParam(int nIndex)
{
	m_saHdrParamName.RemoveAt(nIndex);
	m_vHdrParamType.RemoveAt(nIndex);	
	m_vHdrParamSize.RemoveAt(nIndex);
	m_vHdrParamOffset.RemoveAt(nIndex);
	for( int i = nIndex; i < HDRPARAM_COUNT; i++ )
		m_saHdrParamName[i].Format("P%d", i+1);
	return true;
}

BOOL ImpWizHeaderBytesPage::GetBinHdrParamListStr(string &str, int nIndex, BOOL bWithValue) //=true)
{
	if( nIndex < 0 || nIndex >= HDRPARAM_COUNT )
		return FALSE;

	char cTypeCode;
	switch( m_vHdrParamType[nIndex] )
	{
	case BIP_TYPE_INT:
		cTypeCode = 'I';
		break;
	case BIP_TYPE_UINT:
		cTypeCode = 'U';
		break;
	case BIP_TYPE_REAL:
		cTypeCode = 'R';
		break;
	case BIP_TYPE_STRING:
		cTypeCode = 'S';
		break;
	default:
		return FALSE;
	}

	str.Format("%s(%c%d,%d)", m_saHdrParamName[nIndex], cTypeCode, m_vHdrParamSize[nIndex], m_vHdrParamOffset[nIndex]);

	if( bWithValue )
	{
		string strVal;
		BinHeader_GetParamValAsStr(m_vHdrParamType[nIndex], m_vHdrParamOffset[nIndex], m_vHdrParamSize[nIndex], strVal);
		str += "=";
		str += strVal;
	}
	return TRUE;
}


BOOL ImpWizHeaderBytesPage::OnInit_BinHeader()///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	ON_PAGE_CHECK_BIN_HEADER
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE
	
	InitializeBitmapButtons();
	
	///Jacky 12/12/03 v7.5780 DEFINE_SOME_NEW_MEMBER
	//m_paramsList   = GetItem(IDC_BINHEADER_PARAMLIST );
	//m_valueEdit    = GetItem(IDC_BIW_HEADER_CANDINTERP_EDIT );
	m_paramChk     = GetItem(IDC_BIW_USE_PARAMETER_DEFINITIONS );
	m_btnAdd       = GetItem(IDC_BIW_HEADER_ADD_BUTTON );
	m_btnRemove    = GetItem(IDC_BIW_HEADER_REMOVE_BUTTON );
	m_chkBigEndian = GetItem(IDC_BIW_HEADER_BIGENDIAN_CHECK );
	m_editHeader   = GetItem(IDC_BIW_HEADER_SKIPHEADER_EDIT );
	m_edByteOffset = GetItem(IDC_BYTE_OFFSET );
	m_edValue      = GetItem(IDC_BIW_HEADER_CANDINTERP_EDIT );
	m_reAscPreview = GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT);
	m_reBinPreview = GetItem(IDC_BIW_HEADER_HEX_RICHEDIT);
	m_lbParams     = GetItem(IDC_BINHEADER_PARAMLIST );
    m_typeList     = GetItem(IDC_BIW_HEADER_CANDINTERP_COMBO );
	///End DEFINE_SOME_NEW_MEMBER
	
	///Danice READ_FROM_SHEET
	//m_pSheet->GetBINIMP(m_pBinimp);	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	m_pBinimp = m_pSheet->GetBINIMP_Pointer();
	m_pSheet->GetHdrParam(m_saHdrParamName, m_vHdrParamType, m_vHdrParamOffset, m_vHdrParamSize);
	///END READ_FROM_SHEET 
	
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	iw_InitFontComboBox(IDC_BIN_PREVIEW_FONT);
	/// end ALLOW_CHANGING_PREVIEW_FONT
    

	//RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//reAscPreview.SendMessage(EM_SETEVENTMASK, 0, ENM_CHANGE|ENM_SCROLL|ENM_SELCHANGE);
	m_reAscPreview.SendMessage(EM_SETEVENTMASK, 0, ENM_CHANGE|ENM_SCROLL|ENM_SELCHANGE);
	
	
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	///reAscPreview.SetFont(SYSTEM_FIXED_FONT);
	/// end ALLOW_CHANGING_PREVIEW_FONT
	
	
	//RichEdit reBinPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_HEX_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//reBinPreview.SendMessage(EM_SETEVENTMASK, 0, ENM_CHANGE|ENM_SCROLL|ENM_SELCHANGE);
	m_reBinPreview.SendMessage(EM_SETEVENTMASK, 0, ENM_CHANGE|ENM_SCROLL|ENM_SELCHANGE);
	
	
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	///reBinPreview.SetFont(SYSTEM_FIXED_FONT);
	/// end ALLOW_CHANGING_PREVIEW_FONT

	//BinHdr_UpdatePreview();	///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
	
	///Jacky 12/12/03 v7.5780 PAGE_QUESTION_UNSOLVED
	/* 
	ImportWizDlg.Page.BinHeader.InterpType.v1$=_L("Integer (1, 2 or 4 bytes)");
	ImportWizDlg.Page.BinHeader.InterpType.v2$=_L("Unsigned Integer (1, 2 or 4 bytes)");
	ImportWizDlg.Page.BinHeader.InterpType.v3$=_L("Real (4 or 8 bytes)");
	ImportWizDlg.Page.BinHeader.InterpType.v4$=_L("String (variable length)");
	ImportWizDlg.Page.BinHeader.InterpType.choice = 0;
	*/
	m_typeList.AddString(_L("Integer (1, 2 or 4 bytes)"));
	m_typeList.AddString(_L("Unsigned Integer (1, 2 or 4 bytes)"));
	m_typeList.AddString(_L("Real (4 or 8 bytes)"));
	m_typeList.AddString(_L("String (variable length)"));
	//m_typeList.SetCurSel(0);
	///End PAGE_QUESTION_UNSOLVED
	
    
    //Button paramChk = ImportWizDlg.GetItem(IDC_BIW_USE_PARAMETER_DEFINITIONS, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

    //paramChk.Check = 0;
	m_paramChk.Check = 0;
	
	//Button addBtn = ImportWizDlg.GetItem(IDC_BIW_HEADER_ADD_BUTTON, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//addBtn.Enable = 0;
	m_btnAdd.Enable = 0;
	//Button removeBtn = ImportWizDlg.GetItem(IDC_BIW_HEADER_REMOVE_BUTTON, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//removeBtn.Enable = 0;
	m_btnRemove.Enable = 0;
	
	//Control paramsList = ImportWizDlg.GetItem(IDC_BINHEADER_PARAMLIST, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//paramsList.Enable = 0;
	m_lbParams.Enable = 0;

	//Control valueEdit = ImportWizDlg.GetItem(IDC_BIW_HEADER_CANDINTERP_EDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//valueEdit.Enable = 0;
	m_edValue.Enable = 0;

	//Control typeList = ImportWizDlg.GetItem(IDC_BIW_HEADER_CANDINTERP_COMBO, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//typeList.Enable = 0;
	m_typeList.Enable = 0;
	
	
	BinHeader_ReadHeaderParamsFromTree(); // they are read into local static vectors
	BinHeader_UpdateParamListBox();

	///Danice 12/23/03 v7.5786 SAVE_CHANGE
	//m_pSheet->SetBINIMP(m_pBinimp);	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	m_pSheet->SetHdrParam(m_saHdrParamName, m_vHdrParamType, m_vHdrParamOffset, m_vHdrParamSize);
	///END SAVE_CHANGE

	return TRUE;
}

void ImpWizHeaderBytesPage::iw_InitFontComboBox(int iCtrl)
{
	ComboBox cbFonts = GetItem(iCtrl);
	if( cbFonts )
	{
		int iFontIDs[] = {OEM_FIXED_FONT, ANSI_FIXED_FONT, SYSTEM_FIXED_FONT};
		m_pSheet->iw_InitComboBox(cbFonts, _L("OEM|ANSI|System"), iFontIDs);
		m_pSheet->SetComboBoxCurSelByData(cbFonts, IW_PREVIEW_FONT);
	}
}

BOOL ImpWizHeaderBytesPage::OnActivate_BinHeader()///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	
	ON_PAGE_CHECK_BIN_HEADER
	///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
	/// EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA
	///if(m_pSheet->IsUpgradeData())
	if( m_pSheet->IsUpgradeData(IW_UPGRADE_BIN_DATA) )
	/// end FOR_CONTROL_UPGRADE_DATA
	{
		BinHdr_UpdatePreview();
		ENABLE_UPDATE_PREVIEW_NEEDED;	///Danice REFRESH_PREVIEW_WHEN_CHANGE
	}
	///END FOR_CONTROL_UPGRADE_DATA

	
	//m_pSheet->GetBINIMP(m_pBinimp);	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	m_pSheet->GetHdrParam(m_saHdrParamName, m_vHdrParamType, m_vHdrParamOffset, m_vHdrParamSize);

	//Edit editHeader = ImportWizDlg.GetItem(IDC_BIW_HEADER_SKIPHEADER_EDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	if(m_editHeader.Text == NULL || atoi(m_editHeader.Text) != m_pBinimp->iHeaderBytes)	///Danice REFRESH_PREVIEW_WHEN_CHANGE
		//editHeader.Text = s_binimp.iHeaderBytes;
		m_editHeader.Text = m_pBinimp->iHeaderBytes;
	
	//Button chkBigEndian = ImportWizDlg.GetItem(IDC_BIW_HEADER_BIGENDIAN_CHECK, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//chkBigEndian.Check = s_binimp.iBigEndian;
	m_chkBigEndian.Check = m_pBinimp->iBigEndian;
	
	
	BinHdr_SetFont(IW_PREVIEW_FONT); /// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT

	return TRUE;
}

BOOL ImpWizHeaderBytesPage::OnKillActive_BinHeader()///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	ON_PAGE_CHECK_BIN_HEADER
	BinHeader_WriteHeaderParamsToTree();
	
	///Danice SAVE_CHANGE
	//m_pSheet->SetBINIMP(m_pBinimp);	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	m_pSheet->SetHdrParam(m_saHdrParamName, m_vHdrParamType, m_vHdrParamOffset, m_vHdrParamSize);
	///END SAVE_CHANGE

	return true;
}

/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
void ImpWizHeaderBytesPage::BinHdr_SetFont(int iFont)
{
	//if( s_iOnUserChange != CHANGE_NONE )	///Danice 12/18/03 v7.5783 CALL_SHEET_FUCNTION
	if(m_pSheet->GetUserChange() != CHANGE_NONE)
		return;
	//s_iOnUserChange = CHANGE_FONT;
	m_pSheet->SetUserChange(CHANGE_FONT);
	
	iw_SetRichEditFont(IDC_BIW_HEADER_ASCII_RICHEDIT, iFont);
	iw_SetRichEditFont(IDC_BIW_HEADER_HEX_RICHEDIT, iFont);
	
	//s_iOnUserChange = CHANGE_NONE
	m_pSheet->SetUserChange(CHANGE_NONE);
}

void ImpWizHeaderBytesPage::iw_SetRichEditFont(int iCtrl, int iFont)
{
	RichEdit re = GetItem(iCtrl);
	if( re );
		m_pSheet->iw_SetRichEditFont(re, iFont);
}


BOOL ImpWizHeaderBytesPage::OnSelChangeFont_BinHeader(Control ctrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	ComboBox cbFonts(ctrl);
	if( cbFonts )
	{
		int iCurSel = cbFonts.GetCurSel();
		if( iCurSel >= 0 )
		{
			///Danice 12/25/03 v7.5788 CALL_SHEET_FUNCTION
			//m_iPreviewFont = cbFonts.GetItemData(iCurSel);
			//BinHdr_SetFont(m_iPreviewFont);
			m_pSheet->SetPreviewFont(cbFonts.GetItemData(iCurSel));
			BinHdr_SetFont(m_pSheet->GetPreviewFont());
			///END CALL_SHEET_FUNCTION
			return TRUE;
		}
	}
	return FALSE;
}
/// end ALLOW_CHANGING_PREVIEW_FONT

BOOL ImpWizHeaderBytesPage::OnSelChangeParamType_BinHeader(Control ctrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	BinHeader_UpdateParamValPreview();
	return true;
}

BOOL ImpWizHeaderBytesPage::BinHeader_WriteHeaderParamsToTree()
{
	fuRemoveHeaderParams(s_trFilter);
	for( int n = 0; n < m_saHdrParamName.GetSize(); n++ )
		fuAddBinHeaderParam(s_trFilter, m_saHdrParamName[n], m_vHdrParamType[n], m_vHdrParamOffset[n], m_vHdrParamSize[n]);
	return true;
}

bool ImpWizHeaderBytesPage::BinHeader_ReadHeaderParamsFromTree()
{
	/*
	s_saHdrParamName.SetSize(0);
	if( !fuGetHeaderParamNames(s_trFilter, s_saHdrParamName) )
		return false;

	int nCount = s_saHdrParamName.GetSize();	
	s_vHdrParamType.SetSize(nCount);
	s_vHdrParamOffset.SetSize(nCount);
	s_vHdrParamSize.SetSize(nCount);

	int iType, iOffset, iSize;
	for( int n = 0; n < nCount; n++ )
	{
		fuGetBinHeaderParam(s_trFilter, s_saHdrParamName[n], s_vHdrParamType[n], s_vHdrParamOffset[n], s_vHdrParamSize[n]);
	}
	*/
	m_saHdrParamName.SetSize(0);
	m_vHdrParamType.SetSize(0);
	m_vHdrParamOffset.SetSize(0);
	m_vHdrParamSize.SetSize(0);

	StringArray saNames;
	if( fuGetHeaderParamNames(s_trFilter, saNames) )
	{
		int iType, iOffset, iSize;
		for( int i = 0; i < saNames.GetSize(); i++ )
		{
			if( fuGetBinHeaderParam(s_trFilter, saNames[i], iType, iOffset, iSize) );
			{
				m_saHdrParamName.Add(saNames[i]);
				m_vHdrParamType.Add(iType);
				m_vHdrParamOffset.Add(iOffset);
				m_vHdrParamSize.Add(iSize);
			}
		}
	}
	return true;
}

//------ CPY 1/2/03 v7.0478 QA70-3604 RICH_EDIT_SCROLL_SYNCHRONIZED 
/*
//static BOOL OnVScrollAscPreview(EVENT_BEFORE_UPDATE_ARGS)
{
	RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT, IDD_BIW_HEADER );
	int iAscFirstVisible = reAscPreview.GetFirstVisibleLine();

	RichEdit reBinPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_HEXPREVIEW_RICHEDIT, IDD_BIW_HEADER );
	int iBinFirstVisible = reBinPreview.GetFirstVisibleLine();
	int iScroll = iAscFirstVisible - iBinFirstVisible;
	if( iScroll )
		reBinPreview.LineScroll(iScroll);
	//return TRUE;
}
*/
void ImpWizHeaderBytesPage::OnVScrollAscPreview(Control ctrl)
{
	
	
	//RichEdit reAscPreview = ctrl;    ///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//int iAscFirstVisible = reAscPreview.GetFirstVisibleLine();
	int iAscFirstVisible = m_reAscPreview.GetFirstVisibleLine();
	
	//RichEdit reBinPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_HEX_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//int iBinFirstVisible = reBinPreview.GetFirstVisibleLine();
	int iBinFirstVisible = m_reBinPreview.GetFirstVisibleLine();
	
	int iScroll = iAscFirstVisible - iBinFirstVisible;
	
	//if( iScroll )
	//	reBinPreview.LineScroll(iScroll);
	if( iScroll )
		m_reBinPreview.LineScroll(iScroll);
}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
int ImpWizHeaderBytesPage::get_bin_preview_char_index(int nAscPreviewCharIndex, RichEdit& reAscPreview, RichEdit& reBinPreview)
{
	int nLineNumber = reAscPreview.LineFromChar(nAscPreviewCharIndex);
	int	nChar1 = reAscPreview.LineIndex(nLineNumber);
	int nCharOffset = nAscPreviewCharIndex - nChar1;

	nChar1 = reBinPreview.LineIndex(nLineNumber);
	//every char is shown as 3 in bin preview, but the last char is only 2, so we better compute from line index
	return nChar1 + nCharOffset * 3;
}

// we try to select same in hex dump as in ascii dump
BOOL ImpWizHeaderBytesPage::OnSelChangeAscPreview(Control ctrl)
{
	//if( s_iOnUserChange != CHANGE_NONE )		///Danice CALL_SHEET_FUNCTION
	if( m_pSheet->GetUserChange() != CHANGE_NONE)
		return true;
	//s_iOnUserChange = CHANGE_ASC;
	m_pSheet->SetUserChange(CHANGE_ASC);
	long nStartChar, nEndChar;
	
	//RichEdit reAscPreview = ctrl;///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//reAscPreview.GetSel(nStartChar, nEndChar);
	m_reAscPreview.GetSel(nStartChar, nEndChar);
	
	//Edit edByteOffset = ImportWizDlg.GetItem(IDC_BYTE_OFFSET, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//edByteOffset.Text.Format("%d", GetByteOffsetFromAscPreviewCharIndex(nStartChar)); 
	m_edByteOffset.Text.Format("%d", GetByteOffsetFromAscPreviewCharIndex(nStartChar));
	
	//RichEdit reBinPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_HEX_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//nStartChar = get_bin_preview_char_index(nStartChar, reAscPreview, reBinPreview);
	nStartChar = get_bin_preview_char_index(nStartChar, m_reAscPreview, m_reBinPreview);
	
	//nEndChar = get_bin_preview_char_index(nEndChar, reAscPreview, reBinPreview);
	nEndChar = get_bin_preview_char_index(nEndChar, m_reAscPreview, m_reBinPreview);
	
	//reBinPreview.SetSel(nStartChar, nEndChar);
	m_reBinPreview.SetSel(nStartChar, nEndChar);
			
	//if(m_bBusy)
	if(m_pSheet->IsBusy())
		return FALSE;
	
	BinHeader_UpdateParamValPreview();
	//s_iOnUserChange = CHANGE_NONE;
	m_pSheet->SetUserChange(CHANGE_NONE);
	return true;
}
//------ end CPY 1/2/03 v7.0478 QA70-3604 RICH_EDIT_SCROLL_SYNCHRONIZED 

void ImpWizHeaderBytesPage::OnVScrollHexPreview(Control ctrl)
{
	RichEdit reHexPreview = ctrl; 
	int iBinFirstVisible = reHexPreview.GetFirstVisibleLine();
	
	//RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//int iAscFirstVisible = reAscPreview.GetFirstVisibleLine();
	int iAscFirstVisible = m_reAscPreview.GetFirstVisibleLine();
	
	//int iScroll = iBinFirstVisible - iAscFirstVisible;
	int iScroll = iBinFirstVisible - iAscFirstVisible;
	
	//if( iScroll )
	//	reAscPreview.LineScroll(iScroll);
	if( iScroll )
		m_reAscPreview.LineScroll(iScroll);
	
}

// we try to select same in hex dump as in ascii dump
BOOL ImpWizHeaderBytesPage::OnSelChangeHexPreview(Control ctrl)
{
	//if( s_iOnUserChange != CHANGE_NONE )	///Danice 12/18/03 v7.5783 CALL_SHEET_FUNCTION
	if(m_pSheet->GetUserChange() != CHANGE_NONE)
		return TRUE;
	//s_iOnUserChange = CHANGE_HEX;
	m_pSheet->SetUserChange(CHANGE_HEX);

	long nStartChar, nEndChar;
		
	//RichEdit reBinPreview = ctrl;  ///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//reBinPreview.GetSel(nStartChar, nEndChar);
	m_reBinPreview.GetSel(nStartChar, nEndChar);
	
	//Edit edByteOffset = ImportWizDlg.GetItem(IDC_BYTE_OFFSET, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//edByteOffset.Text.Format("%d", GetByteOffsetFromHexPreviewCharIndex(nStartChar)); 
	m_edByteOffset.Text.Format("%d", GetByteOffsetFromHexPreviewCharIndex(nStartChar)); 
	
	ConvertHexPreviewSelToAscPreviewSel(nStartChar, nEndChar);
	
	//RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//reAscPreview.SetSel(nStartChar, nEndChar);
	m_reAscPreview.SetSel(nStartChar, nEndChar);
	
	
	BinHeader_UpdateParamValPreview();
	//s_iOnUserChange = CHANGE_NONE;
	m_pSheet->SetUserChange(CHANGE_NONE);
	return TRUE;
}

void ImpWizHeaderBytesPage::ConvertHexPreviewSelToAscPreviewSel(long &nStartChar, long &nEndChar)
{
	/// EJP 08-22-2003 SET_OFFSET_WITHOUT_SEL_BUT_JUST_CARROT_POS, old code is off by 1 byte
	/*
	long nFirstChar = nStartChar;
	nStartChar = get_ascii_preview_char_index(nStartChar);
	if( nFirstChar == nEndChar ) // if no selection
		nEndChar = nStartChar;
	else
		nEndChar = get_ascii_preview_char_index(nEndChar - 1) + 1;
	*/
	if( nStartChar == nEndChar )
		nStartChar = get_ascii_preview_char_index(nStartChar - 1) + 1;
	else
		nStartChar = get_ascii_preview_char_index(nStartChar);		
	nEndChar = get_ascii_preview_char_index(nEndChar - 1) + 1;
	/// end SET_OFFSET_WITHOUT_SEL_BUT_JUST_CARROT_POS
}

int ImpWizHeaderBytesPage::get_ascii_preview_char_index(int nBinPreviewCharIndex)
{
	int nCharIndex = GetByteOffsetFromHexPreviewCharIndex(nBinPreviewCharIndex);
	nCharIndex += ((nCharIndex / 16) * 2);
	return nCharIndex;
}

BOOL ImpWizHeaderBytesPage::OnChangeHeaderSize_BinHeader(Control ctrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	Edit eHeaderBytes(ctrl);
	m_pBinimp->iHeaderBytes = atoi(eHeaderBytes.Text);

	/// EJP 06-10-2003 v7.0600 QA70-4520 SUPPORT_HUGE_HEADER_SIZES
	int iRowsNeeded = (m_pBinimp->iHeaderBytes / BIN_HDR_PREVIEW_BYTES_PER_ROW) + 3; // 3=1(at least one line)+2(two extra lines)
	if( iRowsNeeded < BIN_HDR_PREVIEW_NUM_ROWS )
		iRowsNeeded = BIN_HDR_PREVIEW_NUM_ROWS;
	//if( iRowsNeeded != s_iBinHdrPreviewLines )		///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
	if( iRowsNeeded != m_pSheet->GetBinPreviewLines() )
	{
		//s_iBinHdrPreviewLines = iRowsNeeded;
		m_pSheet->SetBinPreviewLines(iRowsNeeded);
		BinHdr_UpdatePreview();
	}
	/// end SUPPORT_HUGE_HEADER_SIZES
	
	ENABLE_UPDATE_PREVIEW_NEEDED;	///Danice REFRESH_PREVIEW_WHEN_CHANGE
	return TRUE;
}

BOOL ImpWizHeaderBytesPage::OnChangeByteOffset_BinHeader(Control ctrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	//if( s_iOnUserChange != CHANGE_NONE )		///Danice CALL_SHEET_FUNCTION
	if(m_pSheet->GetUserChange() != CHANGE_NONE)
		return true;
	//s_iOnUserChange = CHANGE_BYTEOFFSET;
	m_pSheet->SetUserChange(CHANGE_BYTEOFFSET);
	
	
	//Edit eByteOffset(ctrl); ///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	//int iByteOffset = atoi(eByteOffset.Text);
	int iByteOffset = atoi(m_edByteOffset.Text);
	
	//RichEdit reBinPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_HEX_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//int i = GetHexPreviewCharIndexFromByteOffset(iByteOffset);
	int i = GetHexPreviewCharIndexFromByteOffset(iByteOffset);
	
	//reBinPreview.SetSel(i, i+3);
	m_reBinPreview.SetSel(i, i+3);
	
	//RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	i = GetAscPreviewCharIndexFromByteOffset(iByteOffset);

	//reAscPreview.SetSel(i, i+1);
	m_reAscPreview.SetSel(i, i+1);
	
	
	//s_iOnUserChange = CHANGE_NONE;
	m_pSheet->SetUserChange(CHANGE_NONE);
	return true;
}

BOOL ImpWizHeaderBytesPage::OnClickBigEndian_BinHeader(Control ctrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	Button chkBigEndian(ctrl);
	m_pBinimp->iBigEndian = chkBigEndian.Check;
	BinHeader_UpdateParamValPreview();
	BinHeader_UpdateParamListBox(); /// EJP 09-29-2003 v7.5709 QA70-5211.5 UPDATE_HDRVAR_ON_CHANGE_ENDIAN
	return true;
}

BOOL ImpWizHeaderBytesPage::OnClickRefresh_BinHeader(Control ctrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	long nStartChar, nEndChar;
	
	//RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//reAscPreview.GetSel(nStartChar, nEndChar);
	m_reAscPreview.GetSel(nStartChar, nEndChar);
	//int nLineNumber = reAscPreview.LineFromChar(nEndChar);
	int nLineNumber = m_reAscPreview.LineFromChar(nEndChar);
	
	//int nLineIndex = reAscPreview.LineIndex(nLineNumber);
	int nLineIndex = m_reAscPreview.LineIndex(nLineNumber);
	
	int nCharOffset = nEndChar - nLineIndex;
	
	///Jacky 12/12/03 v7.5780 PAGE_QUESTION_UNSOLVED
	//ImportWizDlg.Page.BinHeader.SkipBytes = 16 * nLineNumber + nCharOffset;
	m_editHeader.Text = 16 * nLineNumber + nCharOffset;	///Danice 12/26/03 v7.5789 SKIP_BYTES
	///End PAGE_QUESTION_UNSOLVED
	
	//reAscPreview.SetSel(0, nEndChar);
	m_reAscPreview.SetSel(0, nEndChar);
	
	
	return TRUE;
}

BOOL ImpWizHeaderBytesPage::OnClickDefineParam_BinHeader(Control ctrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	Button chkDefineParam(ctrl);
			
	//Button btnAdd = ImportWizDlg.GetItem(IDC_BIW_HEADER_ADD_BUTTON, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//btnAdd.Enable = chkDefineParam.Check;
	m_btnAdd.Enable = chkDefineParam.Check;
	
	//Button btnRemove = ImportWizDlg.GetItem(IDC_BIW_HEADER_REMOVE_BUTTON, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//btnRemove.Enable = chkDefineParam.Check;
	m_btnRemove.Enable = chkDefineParam.Check;
	
	//ListBox lbParam = ImportWizDlg.GetItem(IDC_BINHEADER_PARAMLIST, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//lbParam.Enable = chkDefineParam.Check;
	m_lbParams.Enable = chkDefineParam.Check;
	
	//Edit edValue = ImportWizDlg.GetItem(IDC_BIW_HEADER_CANDINTERP_EDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//edValue.Enable = chkDefineParam.Check;
	m_edValue.Enable = chkDefineParam.Check;
	
	//ListBox typeList = ImportWizDlg.GetItem(IDC_BIW_HEADER_CANDINTERP_COMBO, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//typeList.Enable = chkDefineParam.Check;
	m_typeList.Enable = chkDefineParam.Check;
	
	
	return true;
}

BOOL ImpWizHeaderBytesPage::OnClickAddParam_BinHeader(Control ctrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	int nType, nOffset, nSize;
	if( !BinHeader_GetParamInfo(nType, nOffset, nSize) )
		return false;

	string str;
	str.Format("P%d", m_saHdrParamName.GetSize()+1);
	int n = AddBinHdrParam(str, nType, nSize, nOffset);
	BinHeader_AddParamToListBox(n-1);
	
	return true;
}

BOOL ImpWizHeaderBytesPage::OnClickRemoveParam_BinHeader(Control cntrl)///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
{
	
	//ListBox lbParams = ImportWizDlg.GetItem(IDC_BINHEADER_PARAMLIST, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//int nIndex = lbParams.GetCurSel();
	int nIndex = m_lbParams.GetCurSel();

	
	/// EJP 04-23-2003 QA70-4321 PREVENT_CRASH_ON_REMOVAL_OF_LAST_PARAM
	if( nIndex == -1 )
		return FALSE; // no selection
	/// end PREVENT_CRASH_ON_REMOVAL_OF_LAST_PARAM
	
	DelBinHdrParam(nIndex);
	BinHeader_UpdateParamListBox();
	
	//if( nIndex == lbParams.GetCount() ) // if deleted last item
	if( nIndex == m_lbParams.GetCount() )
		nIndex--; // update index for new last item
	if( nIndex >= 0 )
	//	lbParams.SetCurSel(nIndex);
		m_lbParams.SetCurSel(nIndex);
	
	return true;
}

void ImpWizHeaderBytesPage::BinHdr_UpdatePreview()
{
	char szTemp[BIN_HDR_PREVIEW_BYTES_PER_ROW];
	string strHexDumpTotal;
	string strHexDumpRow;
	string strAsciiDump;
	int nRead;

	file ff;
	ff.Open(s_strDataFile, file::modeRead | file::shareDenyRead | file::typeBinary);

	//for( int iRow = 0; iRow < s_iBinHdrPreviewLines; iRow++ ) 	///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
	for( int iRow = 0; iRow < m_pSheet->GetBinPreviewLines(); iRow++ )
	{	
		nRead = ff.Read(szTemp, sizeof(szTemp));
		if( 0 == nRead )
			break;
		
		strHexDumpRow = GetHexDump(szTemp, nRead);
		strHexDumpTotal += strHexDumpRow;
		strHexDumpTotal += "\r\n";

		for( int iChar = 0; iChar < nRead; iChar++ )
		{
			if( szTemp[iChar] < ' ' || '~' < szTemp[iChar] )
				szTemp[iChar] = '.';			
		}
			
		strAsciiDump += szTemp;
		strAsciiDump += "\r\n";
	}

	ff.Close();	
			
	//RichEdit reBinPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_HEX_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//reBinPreview.Text = strHexDumpTotal;
	m_reBinPreview.Text = strHexDumpTotal;

	//RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	
	//reAscPreview.Text = strAsciiDump;
	m_reAscPreview.Text = strAsciiDump;
	
	// Scroll hex wnd to top of file.  Why is this needed for hex wnd only?
	//int iBinFirstVisible = 0 - reBinPreview.GetFirstVisibleLine();
	int iBinFirstVisible = 0 - m_reBinPreview.GetFirstVisibleLine();
	
	//reBinPreview.LineScroll(iBinFirstVisible);
	m_reBinPreview.LineScroll(iBinFirstVisible);
	// Scroll hex wnd to top of file.  Why is this needed for hex wnd only?
	
}

void ImpWizHeaderBytesPage::BinHeader_AddParamToListBox(int nIndex)
{
	string str;
	GetBinHdrParamListStr(str, nIndex);
	
	
	//ListBox lbParams = ImportWizDlg.GetItem(IDC_BINHEADER_PARAMLIST, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//lbParams.AddString(str);
	m_lbParams.AddString(str);
	
}

void ImpWizHeaderBytesPage::BinHeader_UpdateParamListBox()
{
	
	
	/// EJP 04-23-2003 QA70-4321 PREVENT_CRASH_ON_REMOVAL_OF_LAST_PARAM
	//ListBox lbParams = ImportWizDlg.GetItem(IDC_BINHEADER_PARAMLIST, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//int iCurSel = lbParams.GetCurSel(); /// EJP 09-29-2003 v7.5709 QA70-5211.5 UPDATE_HDRVAR_ON_CHANGE_ENDIAN
	int iCurSel = m_lbParams.GetCurSel();

	//lbParams.ResetContent();
	m_lbParams.ResetContent();
	/// end PREVENT_CRASH_ON_REMOVAL_OF_LAST_PARAM
	
	for( int n = 0; n < HDRPARAM_COUNT; n++ )
		BinHeader_AddParamToListBox(n);
	/// EJP 09-29-2003 v7.5709 QA70-5211.5 UPDATE_HDRVAR_ON_CHANGE_ENDIAN
	if( iCurSel >= 0 )
		//lbParams.SetCurSel(iCurSel);
		m_lbParams.SetCurSel(iCurSel);
	/// end UPDATE_HDRVAR_ON_CHANGE_ENDIAN
	
}

BOOL ImpWizHeaderBytesPage::BinHeader_GetSelectedBytes(long &nFirst, long &nLast)
{
	long nStartChar, nEndChar;
	
	
	//RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_BIW_HEADER_ASCII_RICHEDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//reAscPreview.GetSel(nStartChar, nEndChar);
	m_reAscPreview.GetSel(nStartChar, nEndChar);
	
	
	if( nStartChar == nEndChar )
		return false;
	nFirst = GetByteOffsetFromAscPreviewCharIndex(nStartChar);
	nLast = GetByteOffsetFromAscPreviewCharIndex(nEndChar - 1);
	return true;
}

BOOL ImpWizHeaderBytesPage::BinHeader_GetParamInfo(int &nType, int &nOffset, int &nSize)
{
	long nFirst, nLast;
	if( !BinHeader_GetSelectedBytes(nFirst, nLast) )
		return false;

	nOffset = nFirst;
	
	//ListBox lbParamType = ImportWizDlg.GetItem(IDC_BIW_HEADER_CANDINTERP_COMBO, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//nType = lbParamType.GetCurSel();
	nType = m_typeList.GetCurSel();
	
	
	nSize = nLast - nFirst + 1;
	switch( nType )
	{
	case PARAM_TYPE_INT:
	case PARAM_TYPE_UINT:
		nType = (PARAM_TYPE_INT == nType ? BIP_TYPE_INT : BIP_TYPE_UINT);
		if( nSize > 4 )
			nSize = 4;
		else if( nSize == 3 )
			nSize = 2;
		break;
	case PARAM_TYPE_REAL:
		nType = BIP_TYPE_REAL;
		if( nSize >= 8 )
			nSize = 8;
		else
			nSize = 4;
		break;
	case PARAM_TYPE_STR:
		nType = BIP_TYPE_STRING;
		///nSize = nLast - nFirst;
		break;
	default:
		return false;
	}

	return true;
}

int ImpWizHeaderBytesPage::BinHeader_GetParamValAsStr(int nType, int nOffset, int nSize, string &strVal)
{
	file ff;
	if( ff.Open(s_strDataFile, file::modeRead|file::shareDenyRead|file::typeBinary) )
	{
		ReadBinaryHeaderParam(strVal, ff, nType, nOffset, nSize, !m_pBinimp->iBigEndian);
		ff.Close();
		return 0;
	}
	return 1; // failed to open
}

void ImpWizHeaderBytesPage::BinHeader_UpdateParamValPreview()
{
	string str;
	int nType, nOffset, nSize;
	if( BinHeader_GetParamInfo(nType, nOffset, nSize) )
		BinHeader_GetParamValAsStr(nType, nOffset, nSize, str);
	
	
	//Edit edValue = ImportWizDlg.GetItem(IDC_BIW_HEADER_CANDINTERP_EDIT, IDD_BIW_HEADER );///Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	//edValue.Text = str;
	m_edValue.Text = str;
	
}

int ImpWizHeaderBytesPage::GetByteOffsetFromHexPreviewCharIndex(int iCharIndex)
{
	// Binary preview has 50 chars per line representing 16 bytes.
	// Each byte is represented by 3 chars (2 for value, 1 for space).
	// There are 2 additional chars for the CR/LF.
	int iLines = (iCharIndex / 50); // full lines
	iCharIndex %= 50;
	return ((iLines * 16) + (iCharIndex / 3));
}

int ImpWizHeaderBytesPage::GetHexPreviewCharIndexFromByteOffset(int iByteOffset)
{
	///iByteOffset--;
	int iLines = iByteOffset / 16;
	iByteOffset %= 16;
	return ((iLines * 50) + (iByteOffset * 3));
}

int ImpWizHeaderBytesPage::GetByteOffsetFromAscPreviewCharIndex(int iCharIndex)
{
	// ASC Preview has 18 chars per line representing 16 bytes.
	// Each byte is represented by 1 char.
	// There are 2 additional chars for the CR/LF.
	int iLines = (iCharIndex / 18); // full lines
	iCharIndex %= 18;
	return ((iLines * 16) + iCharIndex);
}

int ImpWizHeaderBytesPage::GetAscPreviewCharIndexFromByteOffset(int iByteOffset)
{
	///iByteOffset--;
	int iLines = iByteOffset / 16;
	iByteOffset %= 16;
	return ((iLines * 18) + iByteOffset);
}
