/*------------------------------------------------------------------------------*
 * File Name: ImpWizFileTypes.h													*
 * Creation: Jason 12/14/2003													*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_FILE_TYPES							*
 *	 Jason 12/14/03 v7.5781 MOVED_INITIAL_FUNCTION								*
 *	 Jason 12/14/03 v7.5781 ADD_SOME_MACRO										*
 *	 Iris 02/12/04 v8.0819 REMOVE_FILETYPELIST_TO_CLASS							*
 *   Danice 2/16/04 v8.0821 ADD_SOME_ACCESS_FUNCTION							*
 *   Danice 3/1/04 v8.0828 PAGE_INIT_ONCE										*
 *   Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL							*
 *------------------------------------------------------------------------------*/
 

#define ON_PAGE_CHECK_FILE_TYPES			if(!IS_SHOW_FILE_TYPES_PAGE) return FALSE;

///End ADD_SOME_MACRO

///Iris 02/12/04 REMOVE_FILETYPELIST_TO_CLASS
class FileTypeList : public GridListControl
{
public:
	FileTypeList();
	
	void Init(int nID, WndContainer& dlg);

	void GetFileSpecNames(StringArray& saFileSpecNames);

	void UpdateFromExtList(LPCSTR lpcstrFileSpecList);
	
	void UpdateFromTree(StringArray saFileSpecNames);
};
///End REMOVE_FILETYPELIST_TO_CLASS

// Derived WizPage class for WizPage1
class ImpWizFileTypesPage : public ImpWizardPage
{
	// Constructor for ImpWizFileTypesPage class, use parent constructor
	//ImpWizFileTypesPage(int nID) : ImpWizardPage(nID) {}
	
public:
	
	EVENTS_BEGIN
		//PAGE_ON_IS_SHOW(OnIsShow_FileTypes)			///Danice 12/25/03 v7.5788 NOTUSE_SHOW
		PAGE_ON_INIT(OnInit_FileTypes)
		PAGE_ON_ACTIVE(OnActive_FileTypes)
		PAGE_ON_KILLACTIVE(OnKillActive_FileTypes)

		ON_GRID_BEFORE_EDIT(IDC_FILE_TYPES_WILDCARDS_GRID, OnBeforeEditTypes_FileTypes)
	EVENTS_END

	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
	//Events handles
	//BOOL OnIsShow_FileTypes();	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	DWORD OnShowStatus(DWORD InternalStatus);
	///END NOTUSE_SHOW

	BOOL OnInit_FileTypes();	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME

	BOOL OnActive_FileTypes();	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME

	BOOL OnKillActive_FileTypes();	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME

	BOOL OnBeforeEditTypes_FileTypes(Control ctrl, int iRow, int iCol, BOOL *pCancel);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME

	BOOL FileTypes_UpdateData(BOOL bDataToDlg=TRUE);

	void FileTypes_UpdateTreeFromGrid();

	void FileTypes_UpdateGridFromTree();

	void FileTypes_UpdateGridFromExtList(LPCSTR lpcstrFileSpecList);

	void FileTypes_SetupGrid();
	
private:
	
	//Control m_ctrlGrid;		///Iris 02/12/04 REMOVE_FILETYPELIST_TO_CLASS
	FileTypeList	m_ctrlFileTypeGrid;
	
	Edit 	m_editGroupName;
};
