#ifndef _IMG_CHANNEL_DATA_H
#define _IMG_CHANNEL_DATA_H

#define MATRIX_PAGE_SIGNAL_CHANNEL_VALUE "imgChannelMat"

class imgChannelData
{
public:
	imgChannelData(){}
	~imgChannelData()
	{
		if ( m_mp )
			m_mp.Destroy();
	}
	
	int SeparateChannelData(const MatrixObject& miSource, vector<string>& vsChannelName)
	{
		int nChannel = -1;
		//MatrixPage mp(MATRIX_PAGE_SIGNAL_CHANNEL_VALUE);
		if(!m_mp.IsValid())
		{
			m_mp.Create("Origin", CREATE_HIDDEN);
			m_mp.Rename(MATRIX_PAGE_SIGNAL_CHANNEL_VALUE);
		}
		MatrixLayer ml = m_mp.Layers(0);
	
		ml.SetSize(5, miSource.GetNumRows(), miSource.GetNumCols());
		
		vector<string> vsName = {"Intensity", "Red", "Green", "Blue"};
		for ( int ii = 0; ii < vsChannelName.GetSize(); ii++ )
			vsName[ii] = vsChannelName[ii];
		
		MatrixObject mIntensity(ml, 0);
		MatrixObject mRed(ml, 1);
		MatrixObject mGreen(ml, 2);
		MatrixObject mBlue(ml, 3);
		MatrixObject mRGB(ml, 4);
		mIntensity.SetLongName(vsName[0]);
		mRed.SetLongName(vsName[1]);
		mGreen.SetLongName(vsName[2]);
		mBlue.SetLongName(vsName[3]);
		
		if(!matobj_copy(mRGB,miSource))
		{
			return -1;
		}
	
		Image imgRGB(mRGB);
		Image imgR(mRed);
		Image imgG(mGreen);
		Image imgB(mBlue);
		
		
		BITMAPHANDLE* pLBmp = imgRGB.GetLBmp();
		
		if(GRAY_NO == L_IsGrayScaleBitmap(pLBmp))
		{
			if(SUCCESS != image_split_rgb(imgRGB, imgR, imgG, imgB))
				return -1;
			
	
			if(SUCCESS != L_GrayScaleBitmap(pLBmp, 8))
				return -1;
			
			imgRGB.CopyTo(mIntensity, true);
			imgR.CopyTo(mRed, true);
			imgG.CopyTo(mGreen, true);
			imgB.CopyTo(mBlue, true);
	
			nChannel = 4;
		}
		else
		{
			matrixbase& matbase = miSource.GetDataObject();
			matrixbase& mat = mIntensity.GetDataObject();
			mat = matbase;
			nChannel = 1;
		}
	
	
		mIntensity.SetInternalData(FSI_DOUBLE);
		mRed.SetInternalData(FSI_DOUBLE);	
		mGreen.SetInternalData(FSI_DOUBLE);	
		mBlue.SetInternalData(FSI_DOUBLE);	
	
		return nChannel;
	}

	bool GetChannelMatrix(MatrixObject& mo, const string& strChannelName)
	{
		MatrixLayer ml = m_mp.Layers();
		mo = ml.FindCol(strChannelName);
		
		if ( !mo.IsValid() )
			return false;
		return true;
		//foreach( MatrixObject mi in ml.MatrixObjects)
		//{
			//if ( mi.GetLongName() == strChannelName )
			//{
				//mo = mi;
				//return true;
			//}
		//}
		//return false;
	}
	
	//bool GetProfile(GraphObject& go, vector& vIntensity, int nChannelMode)
	//{
		//if ( CHANNEL_MODE_ALL == nChannelMode )
			//nChannelMode = CHANNEL_MODE_INTENSITY;
		//MatrixLayer ml = m_mp.Layers();
		//MatrixObject mo = ml.MatrixObjects(nChannelMode);
		//matrix& mat = mo.GetDataObject();
		////matrix& mat = m_mp.Layers().MatrixObjects(nChannelMode).GetDataObject();
		//
		//vector vxPoints;
		//vector vyPoints; 
		//return get_profile(go, mat, vxPoints, vyPoints, vIntensity);
	//}
	
private:
	MatrixPage m_mp;
};

#endif // _IMG_CHANNEL_DATA_H