/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE			*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <GetNBox.h>
#include <image_utils.h>
#include "ImageControl.h"
#include <ocGDI.h>
#include <control.h>


/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
/*
bool MOImageControl::CopyBitmapHandle(pBITMAPHANDLE pLBmp)
{
	pBITMAPHANDLE pLBmp0 = GetBitmapHandlePtr();
	if(pLBmp0)
	{
		if( SUCCESS == L_COPY_BITMAP(pLBmp, pLBmp0) )
			return true;
	}
	return false;
}
*/
pBITMAPHANDLE MOImageControl::CopyBitmapHandle()
{
	pBITMAPHANDLE pLBmp = getSrcBitmapHandlePtr();//GetBitmapHandlePtr();
	if( NULL == pLBmp )
	{
		error_report("failed to GetBitmapHandlePtr");
		return NULL;
	}

	L_FreeBitmap(&m_LBmpCopy);
	if( L_COPY_BITMAP(&m_LBmpCopy, pLBmp) < 1 )
	{
		error_report("failed to L_COPY_BITMAP");
		return NULL;
	}
	return &m_LBmpCopy;
}
/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE


//virtual
void MOImageControl::Update(pBITMAPHANDLE pLBmp)
{
	/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
	/*
	BITMAPHANDLE lbmpTemp;
	if(NULL == pLBmp)
	{
		pBITMAPHANDLE pLbmp = GetBitmapHandlePtr();
		if(pLbmp)
		{
			L_CopyBitmap(&lbmpTemp, pLbmp, sizeof(BITMAPHANDLE));
			pLBmp = &lbmpTemp;
		}
		else
		{
			error_report("failed to GetBitmapHandlePtr");
			return;
		}
	}
	checkRemoveTempDIB();
	m_hTempDIB = L_CHANGE_TO_DIB(pLBmp);

	//HBITMAP	hDDB = DDB_from_DIB(m_hTempDIB);
	//m_pictCntrl.SetBitMap(hDDB, true);
	m_pictCntrl.SetDIB(m_hTempDIB);
	*/
/*	if( NULL == pLBmp )
	{
		pBITMAPHANDLE pLbmp = GetBitmapHandlePtr();
		if( NULL == pLBmp )
		{
			error_report("failed to GetBitmapHandlePtr");
			return;
		}
	}
	L_FreeBitmap(&m_LBmpCopy);
	L_INIT_BITMAP(&m_LBmpCopy, pLBmp->Width, pLBmp->Height, pLBmp->BitsPerPixel); 
	if( L_COPY_BITMAP(&m_LBmpCopy, pLBmp) < 1 )
	{
		error_report("failed to L_COPY_BITMAP");
		return;
	}
	m_pictCntrl.SetLeadBitmap(&m_LBmpCopy);
*/	/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE

	
	HWND hWnd = m_pictCntrl.GetSafeHwnd();
	InvalidateRect(hWnd, NULL, true);
}
//---- CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY
/*
//virtual
bool MOImageControl::SetImage(MatrixObject& mo, bool bUpdateMatrixOnDestruct)
{
	if(m_pMatLBmp)
		delete m_pMatLBmp;
	m_matObj = mo; // save it for later to get original
	
	/// YuI 11/09/05 we probably do not want image manipulations be undoable in the dialog
	//	m_pMatLBmp = new MatrixObjLeadBitmap(mo, bUpdateMatrixOnDestruct);
	m_pMatLBmp = new MatrixObjLeadBitmap(mo, bUpdateMatrixOnDestruct, false); 
	/// end YuI

	/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
	CopyBitmapHandle();
	m_pictCntrl.SetLeadBitmap(&m_LBmpCopy);
	/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE
	
	Update();
	return true;
}
*/
bool MOImageControl::SetImage(Image& img)
{
	///Sandy 2006-11-1 add for invalid image input
	if(!img.IsValid())
		return false;
	//end 
	
	m_imgSrc = img;
	CopyBitmapHandle();
	m_pictCntrl.SetLeadBitmap(&m_LBmpCopy);	
	Update();
	return true;
}


//virtual 
int MOImageControl::GetImageWidth()
{
	pBITMAPHANDLE pLBmp = GetBitmapHandlePtr();//NULL;
	//if(m_pMatLBmp)
	//	pLBmp = m_pMatLBmp->GetLBmpPtr();
	if(pLBmp) 
		return pLBmp->Width;
	return ImageControlBase::GetImageWidth();
}


//virtual 
int MOImageControl::GetImageHeight()
{
	pBITMAPHANDLE pLBmp = GetBitmapHandlePtr();
	//if(m_pMatLBmp)
	//	pLBmp = m_pMatLBmp->GetLBmpPtr();
	if(pLBmp) 
		return pLBmp->Height;
	
	return ImageControlBase::GetImageHeight();
}


//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
//	virtual 
HWND MOImageControl::GetParent()
{
	if(m_pictCntrl)
	{
		Window wnd = m_pictCntrl.GetParent();
		if(wnd)
			return wnd.GetSafeHwnd();
	}
	return NULL;
}
//----
