/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sophy 3/8/2011 ORG-2252-P1 PROPER_TRANSPOSE_ALL_OBJECTS_IN_MATRIXLAYER		*
 *	Sophy 3/18/2011 ORG-2433-S8 PROPER_UPDATE_MATRIX_DIMENSION					*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "IgorProFile.h"
#include <oExtFile.h>
#include "fu_utils.h"
#include <okocutils.h>



static int _igp_file_type(string strName)
{
	string strExt;
	int nPos = strName.ReverseFind('.');
	strExt = strName.Mid(nPos+1, strlen(strName)-nPos);
	if (0 == strExt.CompareNoCase("ibw"))
		return TYPE_IBW;
	else
		return TYPE_PXP;
}

void IgorProFile::IgorProFile(LPCSTR lpcszFileName)
{
	m_strFileName = lpcszFileName;
	m_type = _igp_file_type(m_strFileName);
}

int IgorProFile::Open(int nBaseOffset)
{
	m_nBaseOffset = nBaseOffset;
	m_nColIndex = 1;
	
	if(!Open(m_strFileName, file::modeRead|file::typeBinary|file::shareDenyWrite)){
		printf("Fail to load file : %s\n", m_strFileName);
		return IMPERR_FILE_OPEN;
	}
	
	byte bb;
	Read(&bb, 1);
	
	m_info.platform = bb?IGP_WIN:IGP_MAC;
	SeekToBegin();
	
	return 0;
	
}

int IgorProFile::GetVersion()
{
	return m_info.version;
}

int IgorProFile::GetDim()
{
	return m_info.dim;
}

int IgorProFile::GetType()
{
	return m_type;
}

#define IMPORT_TO_MATRIX(_FSI_, _TYPE_, _MODE_)	\
		{ml.SetInternalDataType(_FSI_);\
		Matrix<_TYPE_> mm(ml, nIndex);	\
		mm.SetSize(m_info.nDim[1], m_info.nDim[0]);	\
		return igp_read_data_m(&mm, this, m_nBaseOffset, &m_info, d2, d3, _MODE_);}

int IgorProFile::Import2Matrix(MatrixLayer &ml, int nIndex, int d2, int d3)
{
	if(m_info.type & NT_CMPLX)
		IMPORT_TO_MATRIX(FSI_COMPLEX, complex, 1)
	else if (m_info.type & NT_FP32)
		IMPORT_TO_MATRIX(FSI_REAL, float, 1)
	else if(m_info.type & NT_FP64)
		IMPORT_TO_MATRIX(FSI_DOUBLE, double, 1)
	else if((m_info.type & NT_UNSIGNED) && (m_info.type & NT_I8))
		IMPORT_TO_MATRIX(FSI_BYTE, byte, 1)
	else if((m_info.type & NT_UNSIGNED) && (m_info.type & NT_I16))
		IMPORT_TO_MATRIX(FSI_USHORT, unsigned short, 1)
	else if((m_info.type & NT_UNSIGNED) && (m_info.type & NT_I32))
		IMPORT_TO_MATRIX(FSI_ULONG, unsigned int, 1)
	else if(m_info.type & NT_I8)
		IMPORT_TO_MATRIX(FSI_CHAR, char, 1)
	else if(m_info.type & NT_I16)
		IMPORT_TO_MATRIX(FSI_SHORT, short, 1)
	else if(m_info.type & NT_I32)
		IMPORT_TO_MATRIX(FSI_LONG, int, 1)
	else
		ASSERT(false);
	
	return 1;
}


// Read the header information
int IgorProFile::ReadHeader(TreeNode &tr)
{
	SeekToBegin();
	igp_construct_pxp_tree(this, 0, &tr, m_info.platform);
	return 1;
}

int IgorProFile::GetAxis(vector &vd, int dim)
{
	vd.SetSize(m_info.nDim[dim]);
	vd.Data(m_info.sfB[dim], m_info.sfA[dim]*(m_info.nDim[dim]-1), m_info.sfA[dim]);
	return 1;
}

// Read variables
int IgorProFile::ImportVariables(Worksheet &wks, TreeNode &tr)
{
	// Fisher: Not handle this at this time
	if ( wks && tr.GetNodeCount()>0 ){
		impinfo_AddFile(wks, m_strFileName, tr, ASCIMP_MODE_NEW_SHEETS, FILTER_TYPE_XFUNC);
	}
	
	return 1;
}

///Sophy 3/17/2011 ORG-2252-P2 IGORPRO_ROW_COLUMN_PLOT_DIFF_FROM_ORIGIN
static	void	_check_reset_layer_dimension(MatrixLayer& ml, igp_Info* pInfo)
{
	if ( !ml || NULL == pInfo )
		return;
	int nCols = ml.GetNumCols();
	int nRows = ml.GetNumRows();
	Tree trFormat;
	///Sophy 3/18/2011 ORG-2433-S8 PROPER_UPDATE_MATRIX_DIMENSION
	//trFormat = ml.GetFormat(FPB_ALL, FOB_ALL, true, true);
	//TreeNode trX, trY;
	//trX = trFormat.Root.Dimensions.X;
	//trX.First.nVal = 0;
	//trX.Last.nVal = nCols - 1;
	//
	//trY = trFormat.Root.Dimensions.Y;
	//trY.First.nVal = 0;
	//trY.Last.nVal = nRows - 1;
	trFormat.Root.Dimensions.X.First.dVal = pInfo->sfB[0];
	trFormat.Root.Dimensions.X.Last.dVal = pInfo->sfA[0] * (nCols - 1) + pInfo->sfB[0];
	trFormat.Root.Dimensions.Y.First.dVal = pInfo->sfB[1];
	trFormat.Root.Dimensions.Y.Last.dVal = pInfo->sfA[1] * (nRows - 1) + pInfo->sfB[1];
	ml.UpdateThemeIDs(trFormat.Root);
	///end PROPER_UPDATE_MATRIX_DIMENSIONPROPER_UPDATE_MATRIX_DIMENSION
	ml.ApplyFormat(trFormat, true, true);
}
///end IGORPRO_ROW_COLUMN_PLOT_DIFF_FROM_ORIGIN

int IgorProFile::ImportWave(string strName, Worksheet &wks)
{
	switch (m_info.dim) {
	case IGP_WAVE_DIM1:
		if ( !wks ){
			WorksheetPage wp;
			wp.Create("Origin");
			wks = wp.Layers(0);
			TreeNode trJunk;
			impinfo_AddFile(wks, m_strFileName, trJunk, ASCIMP_MODE_NEW_SHEETS, FILTER_TYPE_XFUNC);
			m_nColIndex = 1;
		}
		if(wks.GetNumCols()<m_nColIndex)
			wks.SetSize(-1, m_nColIndex);
			
		Column col(wks,m_nColIndex-1);
		///Sophy 3/15/2011 ORG-2433-S3 NO_RENAME_COLUMN_SHORT_NAME_WHEN_IMPORT_1D_WAVE
		//col.SetName(strName);
		///end NO_RENAME_COLUMN_SHORT_NAME_WHEN_IMPORT_1D_WAVE
		col.SetLongName(strName);
		col.SetType(OKDATAOBJ_DESIGNATION_Y );
		
		// Set sampling interval
		if( fabs(m_info.sfA[0]) >= 0.000001 )
			col.SetEvenSampling(m_info.sfB[0], m_info.sfA[0]);

		string strRange;
		strRange.Format("%s!%d",wks.m_strBookSheet, m_nColIndex++);
		if(m_info.type != FSI_MIXED)
			return igp_read_data(strRange, this, m_nBaseOffset, &m_info, 0, 0, 0, 1);
		break;

	case IGP_WAVE_DIM2:
	case IGP_WAVE_DIM3:
	case IGP_WAVE_DIM4:
		// X, Y, Z and T axis

		//Import to matrix
		int ii, jj, d2, d3;
		d2 = m_info.nDim[2]?m_info.nDim[2]:1;
		d3 = m_info.nDim[3]?m_info.nDim[3]:1;
		///Sophy 3/15/2011 ORG-2433-S1 SUPPORT_READ_MULTI_DIMENSION_TEXT_WAVE_INTO_WORKSHEET
		if ( m_info.type == 0 )//multi-dimension text wave, need import to worksheet now.
		{
			vector<string> vsText;
			igp_read_data_text(&vsText, this, m_nBaseOffset, &m_info, 1);
			int nRows = m_info.nDim[0];
			int nCols = m_info.nDim[1];
			int nLayers = d2 * d3;
			vector<string> vsSub;
			int nOffset = 0;
			
			WorksheetPage wp;
			wp.Create("Origin");
			wks = wp.Layers(0);
			for ( int iLayer = 1; iLayer < nLayers; iLayer++ )
				wp.AddLayer();
			for ( iLayer = 0; iLayer < nLayers; iLayer++ )
			{
				wks = wp.Layers(iLayer);
				wks.SetSize(-1, nCols);
				for ( int iCol = 0; iCol < nCols; iCol++ )
				{
					vector<string> vsSub;
					vsText.GetSubVector(vsSub, nOffset, nOffset + nRows - 1);
					nOffset += nRows;
					Column colObj = wks.Columns(iCol);
					colObj.PutStringArray(vsSub);
					string strFactor;
					strFactor.Format("[%d][%d]", iCol, iLayer);
					colObj.SetLongName(strName + strFactor);
				}
			}	
				///Sophy 3/15/2011 ORG-2433-S6 SET_FILEINFO_TO_EACH_WORKSHEET set to last worksheet
				TreeNode trJunk;
				impinfo_AddFile(wks, m_strFileName, trJunk, ASCIMP_MODE_NEW_SHEETS, FILTER_TYPE_XFUNC);
				wks.Detach();
				///end SET_FILEINFO_TO_EACH_WORKSHEET
			break;
		}
		///end SUPPORT_READ_MULTI_DIMENSION_TEXT_WAVE_INTO_WORKSHEET
		
        MatrixPage mp;
        MatrixObject mo;
		mp.Create("origin");
		
		mp.Label = strName;
		mp.TitleShow = WIN_TITLE_SHOW_BOTH;
		
		for(ii=0; ii<d3-1; ++ii)
			mp.AddLayer();
		for(ii=0; ii<d3; ++ii){
			MatrixLayer ml = mp.Layers(ii);
			if(d2>1)
				ml.Insert(d2-1);
			for(jj=0; jj<d2; ++jj){
				Import2Matrix(ml, jj, jj, ii);
			}
			///Sophy 3/17/2011 ORG-2252-P2 IGORPRO_ROW_COLUMN_PLOT_DIFF_FROM_ORIGIN actually, there is no need to do transposition
			// Transpose the matrix for numeric wave
			//if(m_info.nDim[1]<30){
				/////Sophy 3/8/2011 ORG-2252-P1 PROPER_TRANSPOSE_ALL_OBJECTS_IN_MATRIXLAYER
				////bool	bTransposed = false;
				////foreach(mo in ml.MatrixObjects){
					////matrixbase& mat = mo.GetDataObject();
					////if( !bTransposed ){
						////bTransposed = true;
						////mat.Transpose();
					////}
				////}
				//ml.Transpose();
				/////end PROPER_TRANSPOSE_ALL_OBJECTS_IN_MATRIXLAYER
			//}
			///end IGORPRO_ROW_COLUMN_PLOT_DIFF_FROM_ORIGIN
			
			//Set page name
			string strTmp;
			if(1 == d3 && 1 == d2)
				strTmp.Format("%s", strName);
			else if(1 == d3 && 1 != d2)
				strTmp.Format("%s___", strName);
			else if(1 != d3 && 1 != d2)
				strTmp.Format("%s____%d", strName, ii);
			else
				ASSERT(false);	
			
			ml.SetName(strTmp);
			_check_reset_layer_dimension(ml, &m_info);	///Sophy 3/17/2011 ORG-2252-P2 IGORPRO_ROW_COLUMN_PLOT_DIFF_FROM_ORIGIN
			
		}
		///Sophy 3/15/2011 ORG-2433-S6 SET_FILEINFO_TO_EACH_WORKSHEET set to last worksheet
		TreeNode trJunk;
		impinfo_AddFile(mp.Layers(-1), m_strFileName, trJunk, ASCIMP_MODE_NEW_SHEETS, FILTER_TYPE_XFUNC);
		///end SET_FILEINFO_TO_EACH_WORKSHEET
		// Set as image mode
		///Sophy 3/17/2011 ORG-2252-P2 IGORPRO_ROW_COLUMN_PLOT_DIFF_FROM_ORIGIN
		//if(m_info.nDim[1]>=30)
		if ( m_info.nDim[0] > 1 && m_info.nDim[1] > 1 )
		///end IGORPRO_ROW_COLUMN_PLOT_DIFF_FROM_ORIGIN
			mp.SetViewMode(TRUE, TRUE);

		break;
	default:
		return -1;
		break;
	}

	return -1;

}

int IgorProFile::ImportALL(TreeNode &tr, string path, Worksheet& wks)
{
	string strLabel;
	int nType, nDataOffset;
	Tree trVar;

	foreach(TreeNode cNode in tr.Children)
	{
		Project.ActivateFolder(path);
		if(cNode.GetNodeCount() > 0)
		{
			// Support selection on folder			
			int val;
			cNode.GetAttribute(STR_STOP_ATTRIB, val);
			if(0 == val) continue;
			
			if(!cNode.GetAttribute(STR_LABEL_ATTRIB, strLabel))
				strLabel = tr.tagName;
			Folder fld = Project.ActiveFolder();
			fld.AddSubfolder(strLabel);
			string strNext = path+strLabel+"/";	
			Project.ActivateFolder(strNext);
			///Sophy 9/28/2011 ORG-1344-P1 IGORPRO_NEED_AUTO_RESIZE_WORKSHET_AFTER_IMPORT
			if ( wks )
			{
				autosize_rowcol(wks, 1.5, -1, -1, -1, AS_NOHEIGHT|AS_INVALIDATE);
			}
			///end IGORPRO_NEED_AUTO_RESIZE_WORKSHET_AFTER_IMPORT
			Worksheet wksNext;
			ImportALL(cNode, strNext, wksNext);	
			wks = wksNext;
		}
		else
		{
			// Support selection on item
			if(0 == cNode.nVal)	continue;
			
			if(!cNode.GetAttribute(STR_LABEL_ATTRIB, strLabel))
				strLabel = tr.tagName;
			cNode.GetAttribute(STR_DATAID_ATTRIB, nType);
			cNode.GetAttribute(STR_DATA_ATTRIB, nDataOffset);

			// TODO Import Type
			m_nBaseOffset = nDataOffset;	
			switch(nType){
				case kWaveRecord:
					igp_read_header(this, m_nBaseOffset, &m_info, 1);
					ImportWave(strLabel, wks);
					break;
				case kVariablesRecord:
					igp_get_variables(this, m_nBaseOffset, &trVar);
					///Sophy 3/15/2011 ORG-2433-S2 IMPORT_VARIABLES_TO_NOTES_WINDOW
					{
						trVar.SetAttribute(STR_LABEL_ATTRIB, "Variables");
						string strOut;
						vector<int> vnTableDisplayFormat = { DISPLAY_CENTER, DISPLAY_RIGHT, DISPLAY_RIGHT};
						string strDoubleFormat = "*";
						DWORD dwCtrl = TREE2STR_CHECK_USER_LABEL | TREE2STR_SKIP_HIDDEN | TREE2STR_SIMPLE_TYPE_ONLY | TREE2STR_USE_TAB_AS_SEPARATOR;
						tree_to_str(trVar, strOut, vnTableDisplayFormat, dwCtrl, strDoubleFormat);
						Note nt;
						nt.Create(CREATE_VISIBLE);
						nt.Text = strOut;
					}
					///end IMPORT_VARIABLES_TO_NOTES_WINDOW
					break;
				case kDataFolderStartRecord:
					Folder fld = Project.ActiveFolder();
					fld.AddSubfolder(strLabel);
					break;					
				default:
					break;
			}
			// TODO

		}

	}

	Project.ActivateFolder(path);
	///Sophy 3/15/2011 ORG-2433-S2 IMPORT_VARIABLES_TO_NOTES_WINDOW
	//ImportVariables(wks, trVar);
	///end IMPORT_VARIABLES_TO_NOTES_WINDOW
	
	return 1;
}


// Interface for import bin file
int IgorProFile::ImportIBW(Worksheet& wks, int nCol)
{
	if (!IsOpen()) {
		printf("Fail to load file : %s\n", m_strFileName);
		return IMPERR_FILE_OPEN;
	}

	igp_read_header(this, 0, &m_info, 0);
	m_nBaseOffset = 0;
	m_nColIndex = nCol+1;
	return ImportWave(m_info.bname, wks);
}


