/*------------------------------------------------------------------------------*
 * File Name: IWAscHdrVarToken.c												*
 * Purpose: Ask user how to extract ASCII header variables.						*
 * Copyright (c) OriginLab Corp. 2004											*
 * 																				*
 * Modification Log:															*
 * SY 01/05/2004 QA70-5658 v8.0181 IMPROVE_HDRVAR_EXTRACTION					*
 * SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER						*
 * EJP 2006-04-26 v8.0400 UPDATE_PREVIEW_LINES_ON_CHANGE_NUM_HDR_LINES			*
 *	Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
 *	Sophy 10/11/2012 ORG-6048-P1 IMPWIZ_VARIABLE_TO_EXTRACE_GRID_SHOULD_NOT_BE_EDITABLE
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "IWfirst.h"

/// SY 01/05/2004 QA70-5658 v8.0181 IMPROVE_HDRVAR_EXTRACTION
// Move to FileImport.h
///	enum {
///		IW_FN_VAR_FULL = 0,		// path, name, and extension
///		IW_FN_VAR_PATH,			// path only
///		IW_FN_VAR_NAME_EXT,		// name and extension only
///		IW_FN_VAR_NAME_ONLY,	// name only, no extension
///		IW_FN_NUM_LINES			// number of FN lines
///	};
/// end IMPROVE_HDRVAR_EXTRACTION

/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

#define SZ_COLHDR_METHOD		_L("Method")
#define SZ_COLHDR_VARNAME		_L("Name")
#define SZ_COLHDR_VARVALUE		_L("Value")
#define SZ_VAR_METH_DELIM		_L("Delimiter")
#define SZ_VAR_METH_POS			_L("Position")

#define GRID_FIXED_ROWS			1

#ifdef SHOW_TOKEN_INFO_IN_GRID
#define GRID_NUM_COLS			8
#else
#define GRID_NUM_COLS			3
#endif // SHOW_TOKEN_INFO_IN_GRID

IWVarListCtrl::IWVarListCtrl()
{
}

void IWVarListCtrl::Init(int nID, WndContainer& dlg)
{		
	GridListControl::Init(nID, dlg);

	SetupRowsCols(1, 0, 1, GRID_NUM_COLS); // fixed rows, fixed cols, num rows, num cols

	SetColHeading(0, SZ_COLHDR_METHOD);
	SetColHeading(1, SZ_COLHDR_VARNAME);
	SetColHeading(2, SZ_COLHDR_VARVALUE);

	#ifdef SHOW_TOKEN_INFO_IN_GRID
	SetColHeading(2, "NameLine");
	SetColHeading(3, "NameDelim");
	SetColHeading(4, "NameToken");
	SetColHeading(5, "ValLine");
	SetColHeading(6, "ValDelim");
	SetColHeading(7, "ValToken");
	#endif // SHOW_TOKEN_INFO_IN_GRID
	
	SetEditable(flexEDNone); ///Sophy 10/11/2012 ORG-6048-P1 IMPWIZ_VARIABLE_TO_EXTRACE_GRID_SHOULD_NOT_BE_EDITABLE
}

void IWVarListCtrl::SetCell(int nRow, int nCol, int n)
{
	string str;
	str.Format("%d", n);
	SetCell(nRow, nCol, str);
}

void IWVarListCtrl::SetCell(int nRow, int nCol, LPCSTR lpcsz)
{
	SetCell(lpcsz, flexcpText, nRow, nCol);
}

int IWVarListCtrl::Add(LPCSTR lpcszVarName, LPCSTR lpcszVarValue, BOOL bDelim)
{
	int n = m_flx.Rows;
	m_flx.Rows = n + 1;

	string str;
	str = (bDelim ? SZ_VAR_METH_DELIM : SZ_VAR_METH_POS);
	SetCell(str, flexcpText, n, 0);

	SetCell(lpcszVarName, flexcpText, n, 1);
	SetCell(lpcszVarValue, flexcpText, n, 2);
	return 0;
}

#ifdef SHOW_TOKEN_INFO_IN_GRID
int IWVarListCtrl::AddVarInfo(TreeNode& trVar)
{
	int nRow = m_flx.Rows - 1;

	if( trVar.Name.Line )
		SetCell(nRow, 2, trVar.Name.Line.nVal);
	else
		SetCell(nRow, 2, "");
	
	if( trVar.Name.Delimiter )
		SetCell(nRow, 3, trVar.Name.Delimiter.nVal);
	else
		SetCell(nRow, 3, "");
	
	if( trVar.Name.Token )
		SetCell(nRow, 4, trVar.Name.Token.nVal);
	else
		SetCell(nRow, 4, "");

	if( trVar.Value.Line )
		SetCell(nRow, 5, trVar.Value.Line.nVal);
	else
		SetCell(nRow, 5, "");

	if( trVar.Value.Delimiter )
		SetCell(nRow, 6, trVar.Value.Delimiter.nVal);
	else
		SetCell(nRow, 6, "");

	if( trVar.Value.Token )
		SetCell(nRow, 7, trVar.Value.Token.nVal);
	else
		SetCell(nRow, 7, "");

	return 0;
}
#endif // SHOW_TOKEN_INFO_IN_GRID

/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

IWGetVarPage::IWGetVarPage()
{
	m_nNumHdrLines = -1; /// EJP 2006-04-26 v8.0400 UPDATE_PREVIEW_LINES_ON_CHANGE_NUM_HDR_LINES
}

BOOL IWGetVarPage::OnInit()
{
	if( !ImpWizardPage::Init() )
		return FALSE;

	m_reLines = GetItem(IDC_HDRVAR_HEADER);
	m_reLines.SetFont(IW_PREVIEW_FONT);

	//m_chkVarNameConst = GetItem(IDC_VARNAME_CONST);
	CheckRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT, IDC_VARNAME_CONST);
	
	m_ebVarName = GetItem(IDC_VARNAME);
	m_cbVarNameLine = GetItem(IDC_VARNAME_LINE);

	m_cbVarValueLine = GetItem(IDC_VARVAL_LINE);

	m_gridVars.Init(IDC_HDRVAR_VARIABLES, *this);

	ASCIMP* pai = m_pSheet->GetASCIMP_Pointer();
	fuSetASCIMP(IW_FILTER, *pai);
	
	return TRUE;
}

BOOL IWGetVarPage::OnActive()
{
	/// EJP 2006-04-26 v8.0400 UPDATE_PREVIEW_LINES_ON_CHANGE_NUM_HDR_LINES
	///if( m_strDataFileName.CompareNoCase(IW_DATAFILE) )
	if( m_strDataFileName.CompareNoCase(IW_DATAFILE) ||
		m_nNumHdrLines != ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) )
	/// end UPDATE_PREVIEW_LINES_ON_CHANGE_NUM_HDR_LINES
	{
		m_strDataFileName = IW_DATAFILE;
		/// EJP 2006-04-26 v8.0400 UPDATE_PREVIEW_LINES_ON_CHANGE_NUM_HDR_LINES
		m_nNumHdrLines = ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR);
		fuSetASCIMP(IW_FILTER, *(IW_ASCIMP_PTR));
		/// end UPDATE_PREVIEW_LINES_ON_CHANGE_NUM_HDR_LINES
		get_lines_for_variables(m_saLines, IW_DATAFILE, IW_FILTER);
		UpdateLines();
		UpdateLineComboBoxItems();
	}
	return TRUE;
}

BOOL IWGetVarPage::OnClickVarNameConst(Control ctrl)
{
	UpdateVarNameControlsEnable();
	AdjustVariableGroupHeight();
	return TRUE;
}

BOOL IWGetVarPage::OnSelChangeVarNameLine(Control ctrl)
{
	int n = m_cbVarNameLine.GetCurSel();
	if( n >= 0 )
	{
		//string str;
		//m_cbVarNameLine.GetLBText(n, str);
		//m_cbVarNameLine.Text = str;
		//m_cbVarValueLine.Text = str; // Value Line follows Name Line
		m_cbVarValueLine.SetCurSel(n);
	}
	return TRUE;
}

BOOL IWGetVarPage::OnSelChangeVarValueLine(Control ctrl)
{
	int n = m_cbVarValueLine.GetCurSel();
	if( n >= 0 )
	{
		//string str;
		//m_cbVarValueLine.GetLBText(n, str);
		//m_cbVarValueLine.Text = str;
		//m_cbVarNameLine.Text = str;
		m_cbVarNameLine.SetCurSel(n);
	}
	return TRUE;
}

BOOL IWGetVarPage::OnSelChangeVar(Control ctrl)
{
	BOOL bEdit = FALSE;
	BOOL bDel = FALSE;

	int nRow = m_gridVars.GetSelectedRow();
	if( nRow > 0 )
	{
		nRow--; // make zero based index
		TreeNode tnVar;
		if( GetVarFromFilter(tnVar, nRow) )
		{
			/// SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
			///if( (VarType_Delimiter == GetPageVarType() && tnVar.Value.Delimiter) ||
			if( (VarType_Delimiter == GetPageVarType() && (tnVar.Value.Delimiter || tnVar.Value.Delimiters)) ||
			/// end SUPPORT_MULTI_DELIMITER
				(VarType_Position == GetPageVarType() && tnVar.Value.Offset) )
			{
				bEdit = TRUE;
				SetVar(tnVar);
			}
		}
		bDel = TRUE;
	}

	Button btn;
	btn = GetItem(IDC_VAR_EDIT);
	btn.Enable = bEdit;
	btn = GetItem(IDC_VAR_DELETE);
	btn.Enable = bDel;
	
	return TRUE;
}

BOOL IWGetVarPage::OnClickSave(Control ctrl)
{
	return AddVar();
}

BOOL IWGetVarPage::OnClickEdit(Control ctrl)
{
	/*
	int nRow = m_gridVars.GetSelectedRow();
	if( nRow > 0 )
	{
		nRow--; // make zero based index
		TreeNode tnVar;
		if( GetVarFromFilter(tnVar, nRow) )
		{
			/// SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
			///if( (VarType_Delimiter == GetPageVarType() && tnVar.Value.Delimiter) ||
			if( (VarType_Delimiter == GetPageVarType() && (tnVar.Value.Delimiter || tnVar.Value.Delimiters)) ||
			/// end SUPPORT_MULTI_DELIMITER
				(VarType_Position == GetPageVarType() && tnVar.Value.Offset) )
			{
				return SetVar(tnVar);
			}
		}
	}
	*/
	DeleteSelectedVars();
	AddVar();
	return TRUE;
}

BOOL IWGetVarPage::OnClickDelete(Control ctrl)
{
	return DeleteSelectedVars();
}

BOOL IWGetVarPage::AddVar()
{
	Tree tnVar;
	if( GetVar(tnVar) )
	{
		AddVarToGrid(tnVar);
		return AddVarToFilter(tnVar);
	}		
	return FALSE;
}

BOOL IWGetVarPage::DeleteSelectedVars()
{
	vector<uint> vnSelRows;
	m_gridVars.GetSelRows(vnSelRows);

	int nSelRowIndex = vnSelRows.GetSize();
	if( nSelRowIndex <= 0 )
		return FALSE; // no selected rows
	nSelRowIndex--; // last vector element index = size - 1
	
	TreeNode tnVars;
	if( !GetVarsFromFilter(tnVars) )
		return FALSE; // failed to get vars node
	
	int nNodeIndex = tnVars.GetNodeCount();
	if( nNodeIndex <= 0 )
		return FALSE; // no vars
	
	TreeNode tnCur, tnPrev;
	tnCur = tnVars.LastNode;
	while( tnCur )
	{
		int n = vnSelRows[nSelRowIndex];
		
		tnPrev = tnCur.PrevNode;
		if( nNodeIndex == vnSelRows[nSelRowIndex] )
		{
			tnVars.RemoveChild(tnCur);
			if( --nSelRowIndex < 0 )
				break;
		}
		
		tnCur = tnPrev;
		nNodeIndex--;
	}

	AddVarsToGrid(tnVars);
	return TRUE;
}

BOOL IWGetVarPage::GetVar(TreeNode& tnVar)
{
	if( tnVar )
	{		
		tnVar.Reset();
		tnVar.AddNode("Name");
		tnVar.AddNode("Value");
		if( GetVarName(tnVar.Name) && GetVarValue(tnVar.Value) )
			return TRUE;
	}
	return FALSE;
}

BOOL IWGetVarPage::SetVar(TreeNode& tnVar)
{
	if( tnVar )
	{
		if( SetVarName(tnVar.Name) && SetVarValue(tnVar.Value) )
		{
			AdjustVariableGroupHeight();
			return TRUE;
		}
	}
	return FALSE;
}

BOOL IWGetVarPage::AddVarToFilter(TreeNode& tnVar)
{
	return fuAddHdrVar(IW_FILTER, tnVar);
}

BOOL IWGetVarPage::GetVarFromFilter(TreeNode& tnVar, int nIndex)
{
	return fuGetVar(IW_FILTER, tnVar, nIndex);
}

BOOL IWGetVarPage::DelVarFromFilter(int nIndex)
{
	return fuDelHdrVar(IW_FILTER, nIndex);
}

BOOL IWGetVarPage::GetVarsFromFilter(TreeNode& tnVars)
{
	return fuGetVars(IW_FILTER, tnVars);
}

BOOL IWGetVarPage::GetLine(string& strLine, int nLine)
{
	if( nLine < 0 ) // if file name line index
	{
		nLine *= -1;
		nLine--;
	}
	else // header line index
	{
		nLine += IW_FN_NUM_LINES;
	}
	if( nLine > m_saLines.GetSize() )
		strLine.Empty();
	else
		strLine = m_saLines[nLine];
	return TRUE;
}
	
int IWGetVarPage::GetLineIndex(BOOL bVarValue)// = TRUE);
{
	int nLineID;
	
	if( bVarValue ) // Variable Value
		nLineID = IDC_VARVAL_LINE;
	else // Variable Name
		nLineID = IDC_VARNAME_LINE;

	int n;
	string str;
	ComboBox cb;

	cb = GetItem(nLineID);
	n = cb.GetCurSel();
	cb.GetLBText(n, str);
	if( 'H' == str[0] ) // header line
		n = atoi(str.Right(3)) - 1;
	else // file name line
		n = atoi(str.Right(2)) * -1;

	return n;
}

void IWGetVarPage::SetLineIndex(int nLine, BOOL bVarValue)// = TRUE);
{
	if( nLine < 0 )
		nLine = (nLine * -1) - 1;
	else
		nLine += IW_FN_NUM_LINES;
	
	int nLineID;
	if( bVarValue ) // Variable Value
		nLineID = IDC_VARVAL_LINE;
	else // Variable Name
		nLineID = IDC_VARNAME_LINE;
	
	ComboBox cb;
	cb = GetItem(nLineID);
	cb.SetCurSel(nLine);
}

void IWGetVarPage::AddVarToGrid(TreeNode& tnVar)
{
	string strVarName, strVarValue;
	///if( get_header_variable(strVarName, strVarValue, m_saLines, tnVar) )
	/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
	/*
	if( get_variable_from_data_file(strVarName, strVarValue, m_saLines, tnVar) )
	{
		strVarName.MakeValidCName('_');
		strVarValue.TrimLeft();
		strVarValue.TrimRight();
	*/
	string	strNiceName;
	string	*pstrNiceName = NULL;
#ifdef		GUI_SHOW_NICE_NAME
	pstrNiceName = &strNiceName;
#endif		//GUI_SHOW_NICE_NAME
	if ( get_variable_from_data_file(strVarName, strVarValue, m_saLines, tnVar, pstrNiceName) )
	{
		if ( pstrNiceName )
			strVarName = *pstrNiceName;
	/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR	
		/// SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
		///BOOL bDelim = (tnVar.Value.Delimiter ? TRUE : FALSE);
		BOOL bDelim = (tnVar.Value.Delimiter || tnVar.Value.Delimiters) ? TRUE : FALSE;
		/// end SUPPORT_MULTI_DELIMITER
		m_gridVars.Add(strVarName, strVarValue, bDelim);
	}

	#ifdef SHOW_TOKEN_INFO_IN_GRID
	m_gridVars.AddVarInfo(tnVar);
	#endif // SHOW_TOKEN_INFO_IN_GRID
}

void IWGetVarPage::AddVarsToGrid(TreeNode& tnVars)
{
	m_gridVars.ClearAll();
	if( tnVars )
	{
		foreach( TreeNode tn in tnVars.Children )
			AddVarToGrid(tn);
	}
}

//--------------------------------------------------------------------------
//  The following functions are for upadating the contents of the 
//  dialog's controls.
//--------------------------------------------------------------------------

BOOL IWGetVarPage::UpdateVarNameControlsEnable()
{
	BOOL bVarNameConst = (IDC_VARNAME_CONST == GetCheckedRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT));
	m_ebVarName.Enable = bVarNameConst;
	m_cbVarNameLine.Enable = !bVarNameConst;
	return bVarNameConst;
}

void IWGetVarPage::UpdateData(bool bFromDialogToData) //=true)
{
	if( bFromDialogToData )
	{
	}
	else // from data to dialog
	{
		TreeNode tnVars;
		GetVarsFromFilter(tnVars);
		AddVarsToGrid(tnVars);
	}
	UpdateVarNameControlsEnable();
}

void IWGetVarPage::UpdateLineComboBoxItems()
{
	int nNameCurSel = m_cbVarNameLine.GetCurSel();
	m_cbVarNameLine.ResetContent();
	
	int nValueCurSel = m_cbVarValueLine.GetCurSel();
	m_cbVarValueLine.ResetContent();
	
	int n;
	string str;
	for( n = 1; n <= IW_FN_NUM_LINES; n++ )
	{
		str.Format("FN%02d", n);
		m_cbVarNameLine.AddString(str);
		m_cbVarValueLine.AddString(str);
	}	
	for( n = 1; n <= m_saLines.GetSize() - IW_FN_NUM_LINES; n++ )
	{
		str.Format("H%03d", n);
		m_cbVarNameLine.AddString(str);
		m_cbVarValueLine.AddString(str);
	}
	
	if( nNameCurSel < 0 )
	{
		if( m_cbVarNameLine.GetCount() > IW_FN_NUM_LINES )
			nNameCurSel = IW_FN_NUM_LINES; // first header line
		else
			nNameCurSel = 0; // first file line
	}
	m_cbVarNameLine.SetCurSel(nNameCurSel);

	if( nValueCurSel < 0 )
	{
		if( m_cbVarValueLine.GetCount() > IW_FN_NUM_LINES )
			nValueCurSel = IW_FN_NUM_LINES; // first header line
		else
			nValueCurSel = 0; // first file line
	}
	m_cbVarValueLine.SetCurSel(nValueCurSel);
}

BOOL IWGetVarPage::UpdateLines()
{
	StringArray saTmp;
	saTmp = m_saLines;

	string str;
	for( int nLine = 0; nLine < m_saLines.GetSize(); nLine++ )
	{
		if( nLine < IW_FN_NUM_LINES )
			str.Format("FN%02d  ", nLine + 1);
		else
			str.Format("H%03d  ", nLine - IW_FN_NUM_LINES + 1);
		saTmp[nLine].Insert(0, str);
	}
	m_reLines.Text.Empty();
	m_reLines.Text.SetTokens(saTmp, '\n');
	return TRUE;
}

BOOL IWGetVarPage::AdjustVariableGroupHeight()
{
	Control ctrl;
	int n;
	RECT rc;
	BOOL bVisible;

	int nVarName = GetCheckedRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT);
	
	if( IDC_VARNAME_CONST == nVarName )
	{
		bVisible = FALSE;
		ctrl = GetItem(IDC_VARNAME_EXTRACT);
	}
	else
	{
		bVisible = TRUE;
		ctrl = GetItem(IDC_VARNAME_LINE);
	}
	
	ctrl.GetWindowRect(&rc);
	n = rc.bottom + 4;
	
	ctrl = GetItem(IDC_VARIABLE_GRP);
	ctrl.GetWindowRect(&rc);
	rc.bottom = n;
	ScreenToClient(&rc);
	ctrl.MoveWindow(&rc);

	ctrl = GetItem(IDC_HDRVAR_VARIABLES);
	ctrl.GetWindowRect(&rc);
	rc.top = n + 4;
	ScreenToClient(&rc);
	ctrl.MoveWindow(&rc);
	
	ctrl = GetItem(IDC_VARNAME_LINE_LABEL);
	ctrl.Visible = bVisible;
	m_cbVarNameLine.Visible = bVisible;

	ShowVarNameControls(bVisible);
	return TRUE;
}

/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

IWGetVarByDelimPage::IWGetVarByDelimPage()
{
}

DWORD IWGetVarByDelimPage::OnShowStatus(DWORD InternalStatus)
{
	if( IsShowPage() )
		return PSS_Show;
	return PSS_Ignore;
}

BOOL IWGetVarByDelimPage::IsShowPage()
{
	return fuIsExtractVarByDelimiter(IW_FILTER);
}

BOOL IWGetVarByDelimPage::OnInit()
{
	if( !IWGetVarPage::OnInit() )
		return FALSE;

	m_cbVarNameToken = GetItem(IDC_VARNAME_TOKEN);
	m_cbVarNameDelim = GetItem(IDC_VARNAME_DELIM);
	m_ebVarNameDelimOther = GetItem(IDC_VARNAME_DELIM_OTHER);
	
	m_cbVarValueToken = GetItem(IDC_VARVAL_TOKEN);
	m_cbVarValueDelim = GetItem(IDC_VARVAL_DELIM);
	m_ebVarValueDelimOther = GetItem(IDC_VARVAL_DELIM_OTHER);

	string str;
	GetDelimiterNames(str);
	SetComboBoxItems(m_cbVarNameDelim, str, '|');		
	SetComboBoxItems(m_cbVarValueDelim, str, '|');		

	AdjustVariableGroupHeight();
	return TRUE;
}

BOOL IWGetVarByDelimPage::OnActive()
{
	if( !IsShowPage() )
		return FALSE;

	IWGetVarPage::OnActive();
	
	if( m_cbVarNameDelim.GetCurSel() < 0 )
		m_cbVarNameDelim.SetCurSel(0);
	if( m_cbVarValueDelim.GetCurSel() < 0 )
		m_cbVarValueDelim.SetCurSel(0);

	UpdateTokenComboBoxItems(); // variable's value tokens
	UpdateTokenComboBoxItems(false); // false = variable's name tokens

	UpdateData(false); // false = data to dialog
	UpdateVarValueControlsEnable(); // enable/disable controls based on var name is constant
	return TRUE;
}

BOOL IWGetVarByDelimPage::OnKillActive()
{
	UpdateData(); // dialog to data
	return TRUE;
}

BOOL IWGetVarByDelimPage::OnSelChangeVarNameDelim(Control ctrl)
{
	int nDelim = m_cbVarNameDelim.GetCurSel();
	if( 0 <= nDelim )
	{
		/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
		///m_ebVarNameDelimOther.Enable = (DelimOther == nDelim);
		m_ebVarNameDelimOther.Enable = (DelimOther == nDelim || DelimMulti == nDelim );
		/// end SUPPORT_MULTI_DELIMITER
		UpdateTokenComboBoxItems(false); // false = tokens for var names
	}
#ifdef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	CopyNameDelimToValueDelim();
#endif // VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	return TRUE;
}

#ifdef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
void IWGetVarByDelimPage::CopyNameDelimToValueDelim()
{
	int n = m_cbVarNameDelim.GetCurSel();
	if( n >= 0 )
		m_cbVarValueDelim.SetCurSel(n);

	m_ebVarValueDelimOther.Enable = m_ebVarNameDelimOther.Enable;
	
	string str = m_ebVarNameDelimOther.Text;
	m_ebVarValueDelimOther.Text = str;
	
	UpdateTokenComboBoxItems();
}
#else // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
void IWGetVarByDelimPage::CopyValueDelimToNameDelim()
{
	int n = m_cbVarValueDelim.GetCurSel();
	if( n >= 0 )
		m_cbVarNameDelim.SetCurSel(n);

	m_ebVarNameDelimOther.Enable = m_ebVarValueDelimOther.Enable;
	
	string str = m_ebVarValueDelimOther.Text;
	m_ebVarNameDelimOther.Text = str;
	
	UpdateTokenComboBoxItems(false);
}
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS

BOOL IWGetVarByDelimPage::OnChangeVarNameDelimOther(Control ctrl)
{
	UpdateTokenComboBoxItems(false); // false = tokens for var names
#ifdef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	CopyNameDelimToValueDelim();
#endif // VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	return TRUE;
}

BOOL IWGetVarByDelimPage::OnSelChangeVarValueDelim(Control ctrl)
{
	/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	///m_ebVarValueDelimOther.Enable = (m_cbVarValueDelim.GetCurSel() == DelimOther);
	int nDelimSel = m_cbVarValueDelim.GetCurSel();
	m_ebVarValueDelimOther.Enable = (DelimOther == nDelimSel || DelimMulti == nDelimSel);
	/// end SUPPORT_MULTI_DELIMITER
	UpdateTokenComboBoxItems();
#ifndef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	CopyValueDelimToNameDelim();
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	return TRUE;
}

BOOL IWGetVarByDelimPage::OnChangeVarValueDelimOther(Control ctrl)
{
	UpdateTokenComboBoxItems();
#ifndef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	CopyValueDelimToNameDelim();
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	return TRUE;
}

BOOL IWGetVarByDelimPage::OnSelChangeVarNameLine(Control ctrl)
{
#ifdef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	IWGetVarPage::OnSelChangeVarNameLine(ctrl);
	UpdateTokenComboBoxItems(false); // false = variable's name tokens
	UpdateTokenComboBoxItems(); // variable's value tokens
#else // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	UpdateTokenComboBoxItems(false); // false = variable's name tokens
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	return TRUE;
}

BOOL IWGetVarByDelimPage::OnSelChangeVarValueLine(Control ctrl)
{
#ifdef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	UpdateTokenComboBoxItems(false); // false = variable's name tokens
#else // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	IWGetVarPage::OnSelChangeVarValueLine(ctrl);
	UpdateTokenComboBoxItems(); // variable's value tokens
	UpdateTokenComboBoxItems(false); // false = variable's name tokens
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	return TRUE;
}

void IWGetVarByDelimPage::UpdateTokenComboBoxItems(BOOL bVarValue) //=true)
{
	BOOL bRet;
	Tree trToken;
	ComboBox cb;

	if( bVarValue )
	{
		bRet = GetVarValue(trToken);
		cb = GetItem(IDC_VARVAL_TOKEN);
	}
	else
	{
		bRet = GetVarName(trToken, FALSE); // FALSE = ignore constant setting
		cb = GetItem(IDC_VARNAME_TOKEN);
	}

	cb.ResetContent();
	
	if( !bRet )
		return;
	
	int nLine = tree_node_get_int(trToken.Line);
	string strLine;
	GetLine(strLine, nLine);
	
	StringArray saTokens;
	if( !get_tokens_by_delim(saTokens, strLine, trToken) )
		return;

	SetComboBoxItems(cb, saTokens);	
	cb.SetCurSel(0);
}

BOOL IWGetVarByDelimPage::UpdateVarNameControlsEnable()
{
	BOOL bVarNameConst = IWGetVarPage::UpdateVarNameControlsEnable();
	
	m_cbVarNameDelim.Enable = !bVarNameConst;
	int nDelimSel = m_cbVarNameDelim.GetCurSel();
	/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	///BOOL bDelimOther = (DelimOther == nDelimSel && !bVarNameConst);
	BOOL bDelimOther = ( (DelimOther == nDelimSel || DelimMulti == nDelimSel) && !bVarNameConst );
	/// end SUPPORT_MULTI_DELIMITER
	m_ebVarNameDelimOther.Enable = bDelimOther;
	m_cbVarNameToken.Enable = !bVarNameConst;
	return bVarNameConst;
}

void IWGetVarByDelimPage::UpdateVarValueControlsEnable()
{
	int nDelimSel = m_cbVarValueDelim.GetCurSel();
	/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	///BOOL bDelimOther = (DelimOther == nDelimSel);
	BOOL bDelimOther = ( DelimOther == nDelimSel || DelimMulti == nDelimSel );
	/// end SUPPORT_MULTI_DELIMITER
	m_ebVarValueDelimOther.Enable = bDelimOther;
}

void IWGetVarByDelimPage::GetDelimiters(string& str)
{
	str = ",\t =:";
}

void IWGetVarByDelimPage::GetDelimiterNames(string& str)
{
	str = _L("Comma|Tab|Space|Equal|Colon|Other|Multiple");
}

BOOL IWGetVarByDelimPage::GetVarName(TreeNode& tnVarName, BOOL bAllowConstant) // = TRUE
{
	if( bAllowConstant )
	{
		if( IDC_VARNAME_CONST == GetCheckedRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT) )
		{
			tnVarName.Constant.strVal = m_ebVarName.Text;
			return TRUE;
		}
	}

	/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	///int nLine, nToken, nDelim;
	///if( GetTokenInfo(nLine, nToken, nDelim, false) )
	int nLine, nToken;
	vector<int> vnDelim;
	if( GetTokenInfo(nLine, nToken, vnDelim, false) )
	/// end SUPPORT_MULTI_DELIMITER
	{
		tnVarName.Line.nVal = nLine;
		tnVarName.Token.nVal = nToken;
		/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
		///tnVarName.Delimiter.nVal = nDelim;
		tnVarName.Delimiters.nVals = vnDelim;
		/// end SUPPORT_MULTI_DELIMITER
		return TRUE;
	}
	return FALSE;
}

BOOL IWGetVarByDelimPage::GetVarValue(TreeNode& tnVarValue)
{
	/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	///int nLine, nToken, nDelim;
	///if( GetTokenInfo(nLine, nToken, nDelim) )
	int nLine, nToken;
	vector<int> vnDelim;
	if( GetTokenInfo(nLine, nToken, vnDelim) )
	/// end SUPPORT_MULTI_DELIMITER
	{
		tnVarValue.Line.nVal = nLine;
		tnVarValue.Token.nVal = nToken;
		/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
		///tnVarValue.Delimiter.nVal = nDelim;
		tnVarValue.Delimiters.nVals = vnDelim;
		/// end SUPPORT_MULTI_DELIMITER
		return TRUE;
	}
	return FALSE;
}

BOOL IWGetVarByDelimPage::SetVarName(TreeNode& tnVarName)
{
	BOOL bRet = FALSE;
	if( tnVarName )
	{
		if( tnVarName.Constant )
		{
			///m_chkVarNameConst.Check = 1;
			CheckRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT, IDC_VARNAME_CONST);
			
			m_ebVarName.Text = tnVarName.Constant.strVal;
			bRet = TRUE;
		}
		else
		{
			///m_chkVarNameConst.Check = 0;
			CheckRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT, IDC_VARNAME_EXTRACT);
			
			/// EJP SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
			if( tnVarName.Delimiters )
				bRet = SetTokenInfo(tnVarName.Line.nVal, tnVarName.Token.nVal, tnVarName.Delimiters.nVals, FALSE);
			else
			/// end SUPPORT_MULTI_DELIMITER
			bRet = SetTokenInfo(tnVarName.Line.nVal, tnVarName.Token.nVal, tnVarName.Delimiter.nVal, FALSE);
		}
		UpdateVarNameControlsEnable();
	}
	return bRet;
}

BOOL IWGetVarByDelimPage::SetVarValue(TreeNode& tnVarValue)
{
	if( tnVarValue )
	{
		/// EJP SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
		if( tnVarValue.Delimiters )
			return SetTokenInfo(tnVarValue.Line.nVal, tnVarValue.Token.nVal, tnVarValue.Delimiters.nVals);
		else
		/// end SUPPORT_MULTI_DELIMITER
		return SetTokenInfo(tnVarValue.Line.nVal, tnVarValue.Token.nVal, tnVarValue.Delimiter.nVal);
	}
	return FALSE;
}

/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
///BOOL IWGetVarByDelimPage::GetTokenInfo(int& nLine, int& nToken, int& nDelim, BOOL bVarValue) // = TRUE)
BOOL IWGetVarByDelimPage::GetTokenInfo(int& nLine, int& nToken, vector<int>& vnDelim, BOOL bVarValue) // = TRUE)
/// end SUPPORT_MULTI_DELIMITER
{
	int nTokenID, nDelimID, nDelimOtherID;
	
	if( bVarValue ) // Variable Value
	{
		nTokenID = IDC_VARVAL_TOKEN;
		nDelimID = IDC_VARVAL_DELIM;
		nDelimOtherID = IDC_VARVAL_DELIM_OTHER;
	}
	else // Variable Name
	{
		nTokenID = IDC_VARNAME_TOKEN;
		nDelimID = IDC_VARNAME_DELIM;
		nDelimOtherID = IDC_VARNAME_DELIM_OTHER;
	}

	int n;
	string str;
	ComboBox cb;

	/////////////////////////////// Line
	nLine = GetLineIndex(bVarValue);

	/////////////////////////////// Delimiter
	cb = GetItem(nDelimID);
	n = cb.GetCurSel();
	vnDelim.SetSize(1); /// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	if( DelimOther == n )
	{
		Edit eb = GetItem(nDelimOtherID);
		str = eb.Text;
		if( str.IsEmpty() )
			/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
			///nDelim = 0;
			vnDelim[0] = 0;
			/// end SUPPORT_MULTI_DELIMITER
		else
			/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
			///nDelim = str.GetAt(0);
			vnDelim[0] = str.GetAt(0);
			/// end SUPPORT_MULTI_DELIMITER
	}
	/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	else if( n < 0 )
	{
		vnDelim[0] = 0;
	}
	else if( DelimMulti == n )
	{
		Edit eb = GetItem(nDelimOtherID);
		str = eb.Text;
		if( str.IsEmpty() )
			vnDelim[0] = 0;
		else
		{
			int nNumDelims = CheckDelimiters(str);
			vnDelim.SetSize(nNumDelims);
			for( int i = 0; i < nNumDelims; i++ )
				vnDelim[i] = str.GetAt(i);
		}
	}
	/// end SUPPORT_MULTI_DELIMITER
	else
	{
		string strDelims;
		GetDelimiters(strDelims);
		/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
		///nDelim = strDelims[n];
		vnDelim[0] = strDelims[n];
		/// end SUPPORT_MULTI_DELIMITER
	}
	
	/////////////////////////////// Token
	cb = GetItem(nTokenID);
	nToken = cb.GetCurSel();
	
	return TRUE;
}

BOOL IWGetVarByDelimPage::SetTokenInfo(int nLine, int nToken, int nDelim, BOOL bVarValue) // = TRUE)
/// SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
{
	vector<int> vnDelim;
	vnDelim.Add(nDelim);
	return SetTokenInfo(nLine, nToken, vnDelim, bVarValue);
}

BOOL IWGetVarByDelimPage::SetTokenInfo(int nLine, int nToken, vector<int>& vnDelim, BOOL bVarValue) // = TRUE)
/// end SUPPORT_MULTI_DELIMITER
{
	int nTokenID, nDelimID, nDelimOtherID;
	
	if( bVarValue )
	{
		nTokenID = IDC_VARVAL_TOKEN;
		nDelimID = IDC_VARVAL_DELIM;
		nDelimOtherID = IDC_VARVAL_DELIM_OTHER;
	}
	else // Var Name
	{
		nTokenID = IDC_VARNAME_TOKEN;
		nDelimID = IDC_VARNAME_DELIM;
		nDelimOtherID = IDC_VARNAME_DELIM_OTHER;
	}

	int n;
	string str;
	ComboBox cb;
	
	/////////////////////////////// Line
	SetLineIndex(nLine, bVarValue);

	/////////////////////////////// Delimiter
	cb = GetItem(nDelimID);
	
	/// SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
	int nDelim;

	if( vnDelim.GetSize() > 1 ) // Multi delimiters
		n = DelimMulti;
	else
	{
		nDelim = vnDelim[0];
	/// end SUPPORT_MULTI_DELIMITER
		string strDelims;
		GetDelimiters(strDelims);
		
		n = 0;
		while( strDelims[n] )
		{
			if( strDelims[n] == nDelim )
				break;
			n++;
		}
	} /// SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
	
	cb.SetCurSel(n);
	if( DelimOther == n )
	{
		str = (char)nDelim;
		Edit eb = GetItem(nDelimOtherID);
		eb.Text = str;
	}
	/// SY 01/14/2005 QA70-5658 v8.0185 SUPPORT_MULTI_DELIMITER
	else if( DelimMulti == n )
	{
		DelimtersToString(vnDelim, str);
		Edit eb = GetItem(nDelimOtherID);
		eb.Text = str;
	}
	/// end SUPPORT_MULTI_DELIMITER
	
	/////////////////////////////// Token
	cb = GetItem(nTokenID);
	UpdateTokenComboBoxItems(bVarValue);
	cb.SetCurSel(nToken);
	
	return true;
}

void IWGetVarByDelimPage::ShowVarNameControls(BOOL bVisible)
{
	Control ctrl;
	ctrl = GetItem(IDC_VARNAME_DELIM_LABEL);
	ctrl.Visible = bVisible;
	m_cbVarNameDelim.Visible = bVisible;
	m_ebVarNameDelimOther.Visible = bVisible;
	ctrl = GetItem(IDC_VARNAME_TOKEN_LABEL);
	ctrl.Visible = bVisible;
	m_cbVarNameToken.Visible = bVisible;
}

/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

IWGetVarByPosPage::IWGetVarByPosPage()
{
}

DWORD IWGetVarByPosPage::OnShowStatus(DWORD InternalStatus)
{
	if( IsShowPage() )
		return PSS_Show;
	return PSS_Ignore;
}

BOOL IWGetVarByPosPage::IsShowPage()
{
	return fuIsExtractVarByPosition(IW_FILTER);
}

BOOL IWGetVarByPosPage::OnInit()
{
	if( !IWGetVarPage::OnInit() )
		return FALSE;

	m_ebVarNameStart = GetItem(IDC_VARNAME_START);
	m_ebVarNameEnd = GetItem(IDC_VARNAME_END);
	m_ebVarNamePreview = GetItem(IDC_VARNAME_PREVIEW);
	
	m_ebVarValueStart = GetItem(IDC_VARVAL_START);
	m_ebVarValueEnd = GetItem(IDC_VARVAL_END);
	m_ebVarValuePreview = GetItem(IDC_VARVAL_PREVIEW);

	vector<string>  vstrTips;
	vstrTips.SetSize(1);

	m_btnSetName = GetItem(IDC_SET_VARNAME_USING_SEL);
	vstrTips[0] = _L("Click here after selecting the characters for the variable name");
	m_btnSetName.Init(1, IDB_REFRESH_BLACK, 16, vstrTips);
	
	m_btnSetValue = GetItem(IDC_SET_VARVALUE_USING_SEL);
	vstrTips[0] = _L("Click here after selecting the characters for the variable value");
	m_btnSetValue.Init(1, IDB_REFRESH_BLACK, 16, vstrTips);

	AdjustVariableGroupHeight();
	return TRUE;
}

BOOL IWGetVarByPosPage::OnActive()
{
	if( !IsShowPage() )
		return FALSE;

	IWGetVarPage::OnActive();

	UpdateData(false); // false = data to dialog
	return TRUE;
}

BOOL IWGetVarByPosPage::OnKillActive()
{
	UpdateData(); // dialog to data
	return TRUE;
}

BOOL IWGetVarByPosPage::OnSelChangeVarNameLine(Control ctrl)
{
	/// Hong 11/22/06 TURN_ON_AUTO_UPDATE
	// snow think we should not remove auto update
	///* remove auto update
#ifdef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	IWGetVarPage::OnSelChangeVarNameLine(ctrl);
	UpdateVarPreview(FALSE); // update name preview
	UpdateVarPreview(); // update value preview
#else // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	UpdateVarPreview(FALSE); // update name preview
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	//*/
	//UpdateVarPreview(FALSE); // update name preview
	/// end TURN_ON_AUTO_UPDATE
	return TRUE;
}

BOOL IWGetVarByPosPage::OnSelChangeVarValueLine(Control ctrl)
{
	/// Hong 11/22/06 TURN_ON_AUTO_UPDATE
	// snow think we should not remove auto update
	///* remove auto update
#ifdef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	UpdateVarPreview(FALSE);
#else // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	IWGetVarPage::OnSelChangeVarValueLine(ctrl);
	UpdateVarPreview(); // update value preview
	UpdateVarPreview(FALSE);
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	//*/
	//UpdateVarPreview(); // update value preview
	/// end TURN_ON_AUTO_UPDATE
	return TRUE;
}

BOOL IWGetVarByPosPage::OnChangeVarNameStart(Control ctrl)
{
	UpdateVarPreview(FALSE); // update name preview
	return TRUE;
}

BOOL IWGetVarByPosPage::OnChangeVarNameEnd(Control ctrl)
{
	UpdateVarPreview(FALSE); // update name preview
	return TRUE;
}

BOOL IWGetVarByPosPage::OnChangeVarValueStart(Control ctrl)
{
	/* remove auto update
#ifndef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	m_ebVarNameStart.Text = m_ebVarValueStart.Text;
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	*/
	UpdateVarPreview(); // update value preview
	return TRUE;
}

BOOL IWGetVarByPosPage::OnChangeVarValueEnd(Control ctrl)
{
	/* remove auto update
#ifndef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	m_ebVarNameEnd.Text = m_ebVarValueEnd.Text;
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	*/
	UpdateVarPreview(); // update value preview
	return TRUE;
}

BOOL IWGetVarByPosPage::GetTokenFromSelectedText(TreeNode& tnToken)
{
	int nFirstLine, nLastLine, nFirstChar, nLastChar;

	if( !GetRichEditSelection(m_reLines, nFirstLine, nLastLine, nFirstChar, nLastChar) )
		return FALSE;
	if( nFirstLine != nLastLine || nLastChar < IW_EXTRACT_VAR_PREVIEW_LINE_PREFIX_WIDTH )
		return FALSE;
	
	if( nFirstLine >= IW_FN_NUM_LINES )
		nFirstLine -= IW_FN_NUM_LINES;
	else
		nFirstLine = (nFirstLine + 1) * -1;
	
	if( nFirstChar < IW_EXTRACT_VAR_PREVIEW_LINE_PREFIX_WIDTH )
		nFirstChar = IW_EXTRACT_VAR_PREVIEW_LINE_PREFIX_WIDTH;

	tnToken.Reset();
	tnToken.Line.nVal = nFirstLine;
	tnToken.Offset.nVal = nFirstChar - IW_EXTRACT_VAR_PREVIEW_LINE_PREFIX_WIDTH;
	tnToken.Length.nVal = nLastChar - nFirstChar + 1;
	return TRUE;
}

BOOL IWGetVarByPosPage::OnClickSetVarName(Control ctrl)
{
	Tree trToken;
	if( !GetTokenFromSelectedText(trToken) )
		return FALSE;
	return SetVarName(trToken);
}

BOOL IWGetVarByPosPage::OnClickSetVarValue(Control ctrl)
{
	Tree trToken;
	if( !GetTokenFromSelectedText(trToken) )
		return FALSE;
	return SetVarValue(trToken);
}

BOOL IWGetVarByPosPage::UpdateVarPreview(BOOL bVarValue) // = TRUE
{
	Edit eb;
	if( bVarValue )
		eb = GetItem(IDC_VARVAL_PREVIEW);
	else
		eb = GetItem(IDC_VARNAME_PREVIEW);
	eb.Text = "";

	int nLine, nOffset, nLength;
	if( GetTokenInfo(nLine, nOffset, nLength, bVarValue) )
	{
		string strLine;
		/*
		if( nLine < 0 )
		{
			nLine *= -1;
			nLine--;
		}
		else
		{
			nLine += 3;
		}
		strLine = m_saLines[nLine];
		*/
		GetLine(strLine, nLine);
		eb.Text = strLine.Mid(nOffset, nLength);
	}
	return TRUE;
}

BOOL IWGetVarByPosPage::UpdateVarNameControlsEnable()
{
//	BOOL bVarNameConst = IWGetVarPage::UpdateVarNameControlsEnable();
//	m_ebVarNameStart.Enable = !bVarNameConst;
//	m_ebVarNameEnd.Enable = !bVarNameConst;
//	m_ebVarNamePreview.Enable = !bVarNameConst;
//	return bVarNameConst;
	return IWGetVarPage::UpdateVarNameControlsEnable();
}

BOOL IWGetVarByPosPage::GetVarName(TreeNode& tnVarName, BOOL bAllowConstant)
{
	if( IDC_VARNAME_CONST == GetCheckedRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT) )
	{
		tnVarName.Constant.strVal = m_ebVarName.Text;
		return TRUE;
	}

	int nLine, nOffset, nLength;
	if( GetTokenInfo(nLine, nOffset, nLength, FALSE) )
	{
		tnVarName.Line.nVal = nLine;
		tnVarName.Offset.nVal = nOffset;
		tnVarName.Length.nVal = nLength;
		return TRUE;
	}
	return FALSE;
}

BOOL IWGetVarByPosPage::GetVarValue(TreeNode& tnVarValue)
{
	int nLine, nOffset, nLength;
	if( GetTokenInfo(nLine, nOffset, nLength) )
	{
		tnVarValue.Line.nVal = nLine;
		tnVarValue.Offset.nVal = nOffset;
		tnVarValue.Length.nVal = nLength;
		return TRUE;
	}
	return FALSE;
}

BOOL IWGetVarByPosPage::SetVarName(TreeNode& tnVarName)
{
	BOOL bRet = FALSE;
	if( tnVarName )
	{
		if( tnVarName.Constant )
		{
			///m_chkVarNameConst.Check = 1;
			CheckRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT, IDC_VARNAME_CONST);

			m_ebVarName.Text = tnVarName.Constant.strVal;
			bRet = TRUE;
		}
		else
		{
			///m_chkVarNameConst.Check = 0;
			CheckRadioButton(IDC_VARNAME_CONST, IDC_VARNAME_EXTRACT, IDC_VARNAME_EXTRACT);

			bRet = SetTokenInfo(tnVarName.Line.nVal, tnVarName.Offset.nVal, tnVarName.Length.nVal, FALSE);
		}
		UpdateVarNameControlsEnable();
	}
	return bRet;
}

BOOL IWGetVarByPosPage::SetVarValue(TreeNode& tnVarValue)
{
	if( tnVarValue )
	{
		return SetTokenInfo(tnVarValue.Line.nVal, tnVarValue.Offset.nVal, tnVarValue.Length.nVal);
	}
	return FALSE;
}

BOOL IWGetVarByPosPage::GetTokenInfo(int& nLine, int& nOffset, int& nLength, BOOL bVarValue) // = TRUE)
{
	int nStartID, nEndID;
	
	if( bVarValue ) // Variable Value
	{
		nStartID = IDC_VARVAL_START;
		nEndID = IDC_VARVAL_END;
	}
	else // Variable Name
	{
		nStartID = IDC_VARNAME_START;
		nEndID = IDC_VARNAME_END;
	}

	int n;
	string str;
	Edit eb;

	/////////////////////////////// Line
	nLine = GetLineIndex(bVarValue);

	/////////////////////////////// Offset
	eb = GetItem(nStartID);
	str = eb.Text;
	nOffset = atoi(str) - 1;
	if( nOffset < 0 )
		nOffset = 0;
	
	/////////////////////////////// Length
	eb = GetItem(nEndID);
	str = eb.Text;
	n = atoi(str) - 1;
	if( n < nOffset )
		n = nOffset;
	nLength = n - nOffset + 1;
	
	return TRUE;
}

BOOL IWGetVarByPosPage::SetTokenInfo(int nLine, int nOffset, int nLength, BOOL bVarValue) // = TRUE)
{
	int nStartID, nEndID;
	
	if( bVarValue ) // Variable Value
	{
		nStartID = IDC_VARVAL_START;
		nEndID = IDC_VARVAL_END;
	}
	else // Variable Name
	{
		nStartID = IDC_VARNAME_START;
		nEndID = IDC_VARNAME_END;
	}

	int n;
	string str;
	Edit eb;
	
	/////////////////////////////// Line
	SetLineIndex(nLine, bVarValue);

	/////////////////////////////// Offset
	str.Format("%d", nOffset + 1);
	eb = GetItem(nStartID);
	eb.Text = str;

	/////////////////////////////// Length
	n = nOffset + nLength;
	str.Format("%d", n);
	eb = GetItem(nEndID);
	eb.Text = str;
	
	return TRUE;
}

void IWGetVarByPosPage::ShowVarNameControls(BOOL bVisible)
{
	Control ctrl;
	ctrl = GetItem(IDC_VARNAME_START_LABEL);
	ctrl.Visible = bVisible;
	m_ebVarNameStart.Visible = bVisible;
	ctrl = GetItem(IDC_VARNAME_END_LABEL);
	ctrl.Visible = bVisible;
	m_ebVarNameEnd.Visible = bVisible;
	ctrl = GetItem(IDC_VARNAME_PREVIEW_LABEL);
	ctrl.Visible = bVisible;
	m_ebVarNamePreview.Visible = bVisible;
	m_btnSetName.Visible = bVisible;
}
