/*------------------------------------------------------------------------------*
 * File Name: IWAscHdrVarHow.h													*
 * Purpose: Ask user how to extract variables.									*
 * Copyright (c) OriginLab Corp. 2004											*
 * 																				*
 * Modification Log:															*
 * SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP					*
 *	Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
 *	Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
 *------------------------------------------------------------------------------*/

//--------------------------------------------------------------------------
// IWAscHdrVarHowPage
//
// This is the page where the user chooses which method will be used to
// extract variables.
//--------------------------------------------------------------------------
class IWGetVarHowPage : public ImpWizardPage
{
public:
	IWGetVarHowPage();
	
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInit)
		PAGE_ON_ACTIVE(OnActive)
		PAGE_ON_KILLACTIVE(OnKillActive)

		ON_BN_CLICKED(IDC_EXTRACT_BY_DELIM, OnClickExtractByDelim)
		ON_BN_CLICKED(IDC_EXTRACT_BY_POS, OnClickExtractByPos)
		ON_BN_CLICKED(IDC_SPECIFY_DELIM_AND_SCAN, OnClickExtractByScan)
		ON_BN_CLICKED(IDC_SPECIFY_OCFUNC, OnClickExtractByOCFunc)
		ON_BN_CLICKED(IDC_BROWSE_FILE, OnClickBrowse)
		
		/// SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
		ON_BN_CLICKED(IDC_VAR_ADD_INTO_PAGE_INFO, OnClickAddIntoPageInfo)
		/// end IMPORT_INFO_STORAGE_CLEANUP
		/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		ON_BN_CLICKED(IDC_VAR_ADD_INTO_UDL, OnClickAddIntoUDL)
		/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		
		/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		ON_BN_CLICKED(IDC_SAVE_FILE_INFO, OnClickSaveFileInfo)
		/// end ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
	EVENTS_END

	DWORD OnShowStatus(DWORD InternalStatus);

	bool OnInit();
	BOOL OnActive();
	BOOL OnKillActive();

	BOOL OnClickExtractByDelim(Control ctrl);
	BOOL OnClickExtractByPos(Control ctrl);
	BOOL OnClickExtractByScan(Control ctrl);
	BOOL OnClickExtractByOCFunc(Control ctrl);
	BOOL OnClickBrowse(Control ctrl);

	/// SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
	BOOL OnClickAddIntoPageInfo(Control ctrl);
	/// end IMPORT_INFO_STORAGE_CLEANUP
	
	/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	BOOL OnClickAddIntoUDL(Control ctrl);
	/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	
	/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
	BOOL OnClickSaveFileInfo(Control ctrl);
	/// end ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
	
	void UpdateData(bool bFromDialogToData=true);
	void UpdateControlEnable();
	/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	//void UpdatePageInfoControlEnable();
	void UpdateVarAdditionalControlEnable();
	/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS

private:
	Button m_extractByDelim;
	Button m_extractByPos;
	Button m_extractByScan;
	Button m_extractByOCFunc;
	Edit m_ebOCFileName;
	Button m_btnBrowse;
	Edit m_ebOCFuncName;
	Button m_chkAddIntoPageInfo; /// SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
	Button m_chkAddIntoUDL; /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	Button m_chkSaveFileInfo; /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
};
 