/*------------------------------------------------------------------------------*
 * File Name: IWAscHdrVarHow.c													*
 * Purpose: Ask user how to extract ASCII header variables.						*
 * Copyright (c) OriginLab Corp. 2004											*
 * 																				*
 * Modification Log:															*
 * SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP					*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "IWfirst.h"

IWGetVarHowPage::IWGetVarHowPage()
{
}
 
DWORD IWGetVarHowPage::OnShowStatus(DWORD InternalStatus)
{
	if( FILTER_TYPE_ASCII == fuGetType(IW_FILTER) )
		return PSS_Show;
	return PSS_Ignore;
}

bool IWGetVarHowPage::OnInit()
{
	m_extractByDelim = GetItem(IDC_EXTRACT_BY_DELIM);
	m_extractByPos = GetItem(IDC_EXTRACT_BY_POS);
	m_extractByScan = GetItem(IDC_SPECIFY_DELIM_AND_SCAN);
	m_extractByOCFunc = GetItem(IDC_SPECIFY_OCFUNC);
	m_btnBrowse = GetItem(IDC_BROWSE_FILE);
	m_ebOCFileName = GetItem(IDC_OC_FILE_NAME);
	m_ebOCFuncName = GetItem(IDC_OC_FUNC_NAME);
	
	/// SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
	m_chkAddIntoPageInfo = GetItem(IDC_VAR_ADD_INTO_PAGE_INFO);
	/// end IMPORT_INFO_STORAGE_CLEANUP

	/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	m_chkAddIntoUDL = GetItem(IDC_VAR_ADD_INTO_UDL);
	/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	
	m_chkSaveFileInfo = GetItem(IDC_SAVE_FILE_INFO); /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	
	return true;
}

BOOL IWGetVarHowPage::OnActive()
{
	UpdateData(false); // false = data to dialog
	UpdateControlEnable();
	return TRUE;
}

BOOL IWGetVarHowPage::OnKillActive()
{
	UpdateData(); // dialog to data
	return TRUE;
}

BOOL IWGetVarHowPage::OnClickExtractByDelim(Control ctrl)
{
	fuSetExtractVarByDelimiter(IW_FILTER, m_extractByDelim.Check);
	UpdateVarAdditionalControlEnable(); /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	return TRUE;
}

BOOL IWGetVarHowPage::OnClickExtractByPos(Control ctrl)
{
	fuSetExtractVarByPosition(IW_FILTER, m_extractByPos.Check);
	UpdateVarAdditionalControlEnable(); /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	return TRUE;
}

BOOL IWGetVarHowPage::OnClickExtractByScan(Control ctrl)
{
	fuSetExtractVarByScanning(IW_FILTER, m_extractByScan.Check);
	UpdateVarAdditionalControlEnable(); /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	return TRUE;
}

BOOL IWGetVarHowPage::OnClickExtractByOCFunc(Control ctrl)
{
	fuSetExtractVarByOCFunc(IW_FILTER, m_extractByOCFunc.Check);
	UpdateControlEnable();
	return TRUE;
}

/// SY 09/29/2004 QA70-5658 v8.0142 IMPROVE_HDRVAR_EXTRACTION
BOOL IWGetVarHowPage::OnClickBrowse(Control ctrl)
{
	StringArray saFiletypes;
	saFiletypes.SetSize(2);
	
	saFiletypes[0]="[Origin C Source File (*.c)] *.c";
	saFiletypes[1]="[Origin C++ Source File (*.cpp)] *.cpp";
	
	string strOCFile = GetOpenBox(saFiletypes);
	if( !strOCFile.IsEmpty() )
		m_ebOCFileName.Text = strOCFile;
	
	return TRUE;
}
/// end IMPROVE_HDRVAR_EXTRACTION

/// SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
BOOL IWGetVarHowPage::OnClickAddIntoPageInfo(Control ctrl)
{
	fuSetVarInPageInfo(IW_FILTER, m_chkAddIntoPageInfo.Check);
	return TRUE;
}
/// end IMPORT_INFO_STORAGE_CLEANUP

/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
BOOL IWGetVarHowPage::OnClickAddIntoUDL(Control ctrl)
{
	fuSetVarInPageInfo(IW_FILTER, m_chkAddIntoPageInfo.Check);
	return TRUE;
}
/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS

/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
BOOL IWGetVarHowPage::OnClickSaveFileInfo(Control ctrl)
{
	ASCIMP*	pAscimp = m_pSheet->GetASCIMP_Pointer();
	if( m_chkSaveFileInfo.Check )
		pAscimp->flags &= ~AI_FLAG_NO_IMPORT_INFO_TO_PAGE;
	else
		pAscimp->flags |= AI_FLAG_NO_IMPORT_INFO_TO_PAGE;

	return TRUE;
}
/// end ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED

void IWGetVarHowPage::UpdateData(bool bFromDialogToData) //=true)
{
	if( bFromDialogToData )
	{
		fuSetExtractVarOCFunc(IW_FILTER, m_ebOCFileName.Text, m_ebOCFuncName.Text);
		fuSetVarInPageInfo(IW_FILTER, m_chkAddIntoPageInfo.Check); // Hong 01/15/07 setting can check by coding, need save to filter
		fuSetVarInUDL(IW_FILTER, m_chkAddIntoUDL.Check); /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		fuSetNotSaveImportInfoToPage(IW_FILTER, m_chkSaveFileInfo.Check ? 0 : 1); 
		/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		ASCIMP*	pAscimp = m_pSheet->GetASCIMP_Pointer();
		if( m_chkSaveFileInfo.Check )
			pAscimp->flags &= ~AI_FLAG_NO_IMPORT_INFO_TO_PAGE;
		else
			pAscimp->flags |= AI_FLAG_NO_IMPORT_INFO_TO_PAGE;
		/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	}
	else // from data to dialog
	{
		m_extractByDelim.Check = fuIsExtractVarByDelimiter(IW_FILTER);
		m_extractByPos.Check = fuIsExtractVarByPosition(IW_FILTER);
		m_extractByScan.Check = fuIsExtractVarByScanning(IW_FILTER);

		m_extractByOCFunc.Check = fuIsExtractVarByOCFunc(IW_FILTER);
		fuGetExtractVarOCFunc(IW_FILTER, m_ebOCFileName.Text, m_ebOCFuncName.Text);

		/// SY 01/07/2005 v8.0184 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
		m_chkAddIntoPageInfo.Check = fuIsVarInPageInfo(IW_FILTER);
		/// end IMPORT_INFO_STORAGE_CLEANUP
		m_chkAddIntoUDL.Check = fuIsVarInUDL(IW_FILTER); /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
		ASCIMP*	pAscimp = m_pSheet->GetASCIMP_Pointer();
		m_chkSaveFileInfo.Check = pAscimp->flags & AI_FLAG_NO_IMPORT_INFO_TO_PAGE ? 0 : 1;
		/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	}
}

/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
//void IWGetVarHowPage::UpdatePageInfoControlEnable()
void IWGetVarHowPage::UpdateVarAdditionalControlEnable()
/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
{
	if( m_extractByDelim.Check || m_extractByPos.Check ||
		m_extractByScan.Check || m_extractByOCFunc.Check )
	{
		///--- Hong 01/15/07 
		// default turn on "Add variable to page info" when it change from disable to enable by user setting
		if( !m_chkAddIntoPageInfo.Enable )
			m_chkAddIntoPageInfo.Check = 1;
		///---
		m_chkAddIntoPageInfo.Enable = TRUE;
		m_chkAddIntoUDL.Enable = TRUE; /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	}
	else
	{
		m_chkAddIntoPageInfo.Enable = FALSE;
		m_chkAddIntoPageInfo.Check = 0; ///--- Hong 01/15/07 default uncheck if no variable extract		
		m_chkAddIntoUDL.Enable = FALSE; /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	}
}

void IWGetVarHowPage::UpdateControlEnable()
{
	BOOL bEnable = m_extractByOCFunc.Check;
	m_ebOCFileName.Enable = bEnable;
	m_btnBrowse.Enable = bEnable;
	m_ebOCFuncName.Enable = bEnable;
	
	UpdateVarAdditionalControlEnable(); /// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
}

