/*------------------------------------------------------------------------------*
 * File Name: GroupFolderManager.c	 											*
 * Creation: Kit 09/27/2011														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011*
 * All Rights Reserved															*
 * 																				*
 *	Folger 12/09/2011 ORG-4362-P9 COPY_CLIENTUPDATE_EXE_AFTER_PUBLISH_FILES		*
 *	Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN		*
 *------------------------------------------------------------------------------*/

#ifndef _GROUPFOLDERMANAGER_H
#define _GROUPFOLDERMANAGER_H

#include "GridControl.h"
///-----Kit 09/27/2011 : For code clean, I have remove some code mark, if you need, please get the old version from sos.
class FileListControl : public GridListControl
{
public:
	FileListControl(int nID, WndContainer &dlg, bool bSource, FilePublishBase *pFilePublish);
	void Init(int nID, WndContainer &dlg);
	void UpdateList();
	
	int AddRowsFromFileNames(const vector<string> &vsFiles);
	
	int AddRows(const vector<string> &vsRowsInfo);
	int FilterSelected(vector<string> &vsFiles, bool bFilterOlder = false, vector<bool>* pvbOlder = NULL);
	
	int GetSelFiles(vector<string> &vsFiles);
	
	int RemoveSelRows(const vector<string> &vsFiles);
	void RestoreItemsStatus(const vector<string> &vsFiles, bool bPublish = true);
	
	int GetColStatus();
	//set cell color of COL_FILE, and value of col m_nColStatus
	void SetRowProperties(int nRow,int nFileStatus);
	
	void OnMouseMove(Control cntrl, short nButton, short nShift, float X, float Y);
	///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//void OnBeforeMouseDown(short nButton, short nShift, float X, float Y, BOOL* pCancel);
	void ShowMenu(int nx, int ny);
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN

	int  GetFilesWithSubCategory(vector<string> &vsFileNamesWithSubCate);

protected:
	void	SetupColTypes();
private:
	void selectRow(int nRow = -1);
	
	bool	getRowInfoByFilesName(const vector<string> &vsFiles, const vector<string> &vsColVals, vector<string> &vsRowInfo);
	
private:
	FilePublishBase			*m_pFilePublish;
	bool					m_bSource;
	vector<bool>			m_vbShow;			// the shown cols
	int 					m_nColStatus;
};


class FilePublishDlg : public ResizeDialog
{
public:
	FilePublishDlg(bool bGroupMgr = true);

	~FilePublishDlg();

	int DoModalEx(HWND hWndParent = NULL);

protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	ON_DESTROY(OnDestroy)
	ON_RESTORESIZE(OnRestoreSize)
	ON_GETMINMAXINFO(OnMinMaxInfo)		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	
	ON_CBN_SELCHANGE(IDC_FP_DROPDOWN, OnComboChange)
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	ON_CBN_SELCHANGE(IDC_FP_VERSION_COMBO, OnVersionComboChange)
	ON_BN_CLICKED(IDC_FP_VERSION_SPECIFY, OnVersionSpecify)
	ON_GRID_MOUSE_MOVE(IDC_FP_USER_LIST, OnMouseMoveSrcFileList)
	ON_GRID_MOUSE_MOVE(IDC_FP_GROUP_LIST, OnMouseMoveDestFileList)
	ON_CBN_SELCHANGE(IDC_FP_DEST_CATEGORY_COMBO, OnDestCateComboChange)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_FP_USER_LIST, OnBeforeMouseDownUser)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_FP_GROUP_LIST, OnBeforeMouseDownGroup)
	ON_CONTEXTMENU(OnContextMenu)		///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	ON_BN_CLICKED(IDC_FP_PUBLISH_BTN, OnPublish)
	ON_BN_CLICKED(IDC_FP_GET_BACK_BTN, OnGetBack)
	//ON_GRID_DBLCLICK(IDC_FP_USER_LIST, OnDblClickToSel)
	ON_BN_CLICKED(IDC_FP_REMOVE_GROUP_BTN, OnRemoveGroup)
	ON_BN_CLICKED(IDC_FP_REMOVE_USER_BTN, OnRemoveUser)
	ON_BN_CLICKED(IDC_FP_OK_BTN, OnOK)		//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
	//ON_BN_CLICKED(IDC_FP_GROUP_BTN, OnSetGroupFolder)	//------ Folger 09/14/07 ADD_SET_GROUP_FOLDER_DIALOG
	
	ON_GRID_SEL_CHANGE(IDC_FP_USER_LIST, OnUserSelChange)
	ON_GRID_SEL_CHANGE(IDC_FP_GROUP_LIST, OnGroupSelChange)
 
	ON_HELPINFO(OnHelp)			//------ Folger 11/14/07 MAP_DIALOG_CHM_HELP

	ON_BN_CLICKED(IDC_OPEN_USER_LIST_PATH_BTN, OnClickOpenUserListFolder)
	ON_BN_CLICKED(IDC_OPEN_GROUP_LIST_PATH_BTN, OnClickOpenGroupListFolder)

	///-----Kit 02/17/2011 ORG-2126-S6 SUPPORT_DOUBLE_CLICK_TO_PUBLISH_FILES
	ON_GRID_DBLCLICK(IDC_FP_USER_LIST, OnDBLClickToPublishFile)
	///-----End SUPPORT_DOUBLE_CLICK_TO_PUBLISH_FILES
EVENTS_END
	BOOL	OnInitDialog();

	BOOL	OnDlgResize(int nType, int cx, int cy);

	BOOL	OnRestoreSize(ODWP dwSizeInfo);

	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int		GetTotalWidth(bool bMin);

	//int		GetTotalHeight(bool bMin);
	int		GetMinClientTrackWidth();
	int		GetMinClientTrackHeight();
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS

	BOOL	OnDestroy();

	BOOL	OnComboChange(Control ctrl);

	BOOL	OnVersionComboChange(Control ctrl);

	BOOL	OnVersionSpecify(Control ctrl);
	
	BOOL	OnMouseMoveSrcFileList(Control cntrl, short nButton, short nShift, float X, float Y);
	BOOL	OnMouseMoveDestFileList(Control cntrl, short nButton, short nShift, float X, float Y);

	BOOL	OnDestCateComboChange(Control ctrl);
	void	OnBeforeMouseDownUser(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);

	BOOL	OnContextMenu(UINT nResIDCtrl, int nx, int ny);		///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN

	void	OnBeforeMouseDownGroup(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	void	OnDBLClickToPublishFile(Control ctrl);

	BOOL	OnPublish(Control ctrl);
	
	BOOL	OnGetBack(Control ctrl);
	
	BOOL	OnRemoveUser(Control ctrl);
	
	BOOL	OnRemoveGroup(Control ctrl);
	
	BOOL	OnOK(Control ctrl);
	void	OnUserSelChange(Control control);
	
	void	OnGroupSelChange(Control control);
	BOOL	OnHelp(int &nHelpID, int nIdCtrlFocus);
	BOOL	OnClickOpenUserListFolder(Control ctrl);

	BOOL	OnClickOpenGroupListFolder(Control ctrl);

private:
	int		getComboCurSel();

	BOOL	initFilePublish(int nComboCurSel);

	BOOL	initFileListControl();
	/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int		getMinWidth();
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	bool	checkRemoveOlder(vector<string>& vsFiles, vector<bool>& vbOlder);
	void	setListColor(DWORD dwSpecialFileType);
	
	void	initFileTypeCombo();
	void	initOldVersionCombo();
	
	void	initDestCategoryCombo(bool bShow = false);
	void	enableButtons(FileListControl *filelist, int nBtnAddID, int nBtnRemoveID);

	void	initHintCtrl();
	int		getHowManyLinesInText(LPCTSTR lpcszText);
	void	initColorHint();

	void	setHintColor(uint uResourceID, uint uColor, LPCTSTR lpcszHint);

	void	resizeColorHint(int nTop, int nLeft, int nHintHeight);

	int		putCtrl(uint uResourceID, int nTop, int nLeft, int nCtrlHeight, bool bResizeCtrlByCtrlText = true, bool bSingleLine = true);
	void	resizeUserListFolderPathCtrl(bool bUseCurrentTopHeight, int nTop = -1, int nCtrlHeight = -1);

	void	resizeGroupFolderPathCtrl(int nTop, int nCtrlHeight);

	void	resizeFolderPathCtrl(const vector<int> &vnResIDs, int nRefResourceID, int nTop, int nCtrlHeight, LPCTSTR lpcszPath);
	
	bool	getEllipsisText(int nWidth, string &strText);
	string	getUserListFolderPath();

	string	getGroupListFolderPath();

	string	getUserListFolderPathTextPrefix();

	string getGroupListFolderPathTextPrefix();

	BOOL	CopyClientUpdateEXE();		///------ Folger 12/09/2011 ORG-4362-P9 COPY_CLIENTUPDATE_EXE_AFTER_PUBLISH_FILES
	
private:
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	string				m_strCurOldVersionKey;
	string				m_strSpecifiedPath;
	ComboBox			m_OldVersionCombo;
	Button				m_btnVersionSpecify;
	vector<string>		m_vsOldVersionKeys;

	ComboBox			m_CateCombo;
	
	bool				m_bFilterOlder;
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	ComboBox 			m_FileTypeCombo;
	FileListControl		*m_pUserList;
	FileListControl		*m_pGroupList;
	FilePublishBase		*m_pFilePublish;
	bool				m_bGroupMgr;		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	Button				m_btnOK;			//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//vector<int>			m_vnIndexMap;		//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	string				m_strDlgName;		//------ Folger 09/14/07 SAVE_USER_COMBO_SELECTION		
};


#endif	//_GROUPFOLDERMANAGER_H