/*------------------------------------------------------------------------------*
 * File Name: GridQuery.h														*
 * Creation: CPY 8/30/2004													    *
 * Purpose: General Grid Query Functions and classes							*
 * Copyright (c) OriginLab Corp.2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 8/30/04 QA70-6667 RESULT_SHEET_QUERY		, created this file			*
 *------------------------------------------------------------------------------*/

#ifndef _GRID_QUERY_H
#define _GRID_QUERY_H


#define			EVENTHANDLER_INSERTRELATEDCOLS			"InsertRelatedCols"

class GridQuery : public Grid
{
public:
	bool BuildQuery(TreeNode& trQuery, TreeNode& trOtherItems)
	{
		int	nErr = BuildQueryTree(trQuery);
		if ( nErr )
		{
			out_str("Empty Query tree, probably because of inappropriate selection in the Results Log.");
			return false;
		}
		buildOtherItemsQueryTree(trOtherItems);
		return true;
	}
	int DoQuery(const TreeNode& trQuery, TreeNode& trResults, const TreeNode& trOtherItems)
	{
		int nErr = Find(trQuery, trResults, trOtherItems);
		if(nErr)
			return -1;
		
		return trResults.GetNodeCount();
	}
		
private:
	void buildOtherItemsQueryTree(TreeNode &trOtherItems)
	{
		// User name:
		trOtherItems.Table.ID = IDST_REPORT_NOTES;
		trOtherItems.Table.Value1.ID = IDE_NOTES_USERNAME;
		trOtherItems.Table.Value2.ID = IDE_NOTES_CREATION_TIME;
		
		// Input:		
		trOtherItems.Table1.ID = IDST_REPORT_INPUT_TABLE;
		trOtherItems.Table1.FirstDim.ID = make_one_set_ID(IDST_REPORT_INPUT_ONE_SET, 0);
		//---- CPY 10/25/04 v8.0155 USE_EXCEL_NOTATION_FOR_EXTRACTION
		//trOtherItems.Table1.FirstDim.Value1.ID = IDE_INPUT_X;
		//trOtherItems.Table1.FirstDim.Value2.ID = IDE_INPUT_Y;
		trOtherItems.Table1.FirstDim.Value1.ID = IDE_INPUT_X_EXCEL;
		/// ML 11/8/2005 QA70-8135 Z_IN_REPORT_TABELS
		//trOtherItems.Table1.FirstDim.Value2.ID = IDE_INPUT_Y_EXCEL;
		trOtherItems.Table1.FirstDim.Value2.ID = IDE_INPUT_MAIN_EXCEL;
		/// end Z_IN_REPORT_TABELS
		//-----

		trOtherItems.Table1.FirstDim.Value1.SetAttribute(STR_EVENTS_ATTRIB, EVENTHANDLER_INSERTRELATEDCOLS);
		trOtherItems.Table1.FirstDim.Value2.SetAttribute(STR_EVENTS_ATTRIB, EVENTHANDLER_INSERTRELATEDCOLS);

	}
};

class QueryResultsWks : public Worksheet
{
public:
	bool Create(const TreeNode& treeQuery, const TreeNode& treeResult, LPCSTR lpcszTitle, bool bDelayShowWin = true)
	{
		int nOption = bDelayShowWin? CREATE_HIDDEN : CREATE_VISIBLE;
		string strOp = treeQuery.Op.Name.strVal; //"FitLinear";
		if(Create(NULL, nOption))
		{
			m_wpg = GetPage();
			SetSize(-1, 0);
			SetReportTree(treeResult, 0);
			string strResult = lpcszTitle;
			strResult += " Query Results: " + strOp;
			m_wpg.Rename("Query1");
			m_wpg.SetLongName(strResult);
			if(bDelayShowWin)
			{
				// if called from mouse event handler, we cannot create create visible new window, as that would mess up mouse events
				// so we have to delay making the new window visible (actual MDI win creation) until after we exit this routine
				string strLTShowWindow = ";win -a " + m_wpg.GetName(); // LT leading ; to indicate PostMessage execution
				LT_execute(strLTShowWindow);
			}
			return true;
		}
		return false;
	}
private:
	WorksheetPage m_wpg;
};
#endif //_GRID_QUERY_H
