/*------------------------------------------------------------------------------*
 * File Name: GraphObjTools.h 													*
 * Creation: Sim 01-08-2010														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sophy 1/18/2010 CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS			*
 *	Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS	*
 *	Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS						*
 *	Folger 01/21/09 QA81-14995 GADGET_TOOLS_SHOULD_USE_SAME_WORKSHEET_OUTPUT_NOTATION
 *	Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
 *	Sophy 1/22/2010 QA80-14996 GR_OBJ_NEED_MOVE_EVENT_WHEN_UNDO_MOVE_OPERATION_FOR_QUICK_FIT
 *	CPY 1/22/10 QA81-15020 CLOSE_BUTTON_USE_SIMPLER_LT_BASED_CODE				*
 *	Sophy 01/23/10 QA80-15015 GROBJ_NEED_OPTION_CTRL_DELETE_OPERATION_UNDOABLE_OR_NOT
 *	Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT						*
 *	Sophy 1/27/2010 FILTER_UNSUITABLE_PLOTTYPE_IN_CONTEXT_MENU					*
 *  Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB									*
 *	Sophy 1/29/2010 ROI_ATTACHED_LINES_FAIL_TO_SET_POSITION_CORRECTLY_FOR_THE_FIRST_TIME
 *	Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
 *	Sophy 2/1/2010 SHOW_DATA_TIME_STAMP_WHEN_OUTPUT_TO_SCRIPT_WINDOW			*
 *	Hong 02/01/10 QA80-14832 FIX_ROI_BOX_FAIL_DISPLAY_CORRECT_POSITION_IN_DATA_DISPLAY_DLG_WHEN_CREATE
 *	Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES			*
 *	CPY 2/2/10 QA81-15066 CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT			*
 *	Sophy 2/3/2010 ROI_CONTEXT_MENU_DATAPLOT_SHOW_LEGEND_AS_IN_NLFIT			*
 *	Sophy 2/4/2010 PROPERLY_UPDATE_GROBJ_POSITION_ACCORDING_TO_LAYER_SCALE		*
 *	Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU				*
 *	Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY			*
 *	Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE									*
 *	Sophy 2/5/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS						*
 *	Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE			*
 *	Iris 2/10/2010 QA81-15099 FIX_BAD_ROI_INIT_POS_WHEN_LAYER_FROM_LARGE_THAN_TO*
 *	Sophy 2/10/2010 QA81-15097 ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED		*
 *	Sophy 2/11/2010 QA81-15104-P3 REFRESH_GRAPH_ON_ROI_EXPAND					*
 *	Sophy 2/11/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS						*
 *	Sophy 2/11/2010 QA81-15107 SUPPORT_EXTEND_POSITION_FOR_GRAPHOBJECT_CONNECT	*
 *	Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU						*
 *  Iris 2/20/2010 QUICKFIT_SHOULD_USE_SELECTED_PLOT_NOT_ACTIVE_PLOT_AS_INPUT	*
 *	Sophy 2/22/2010 QA81-14930 IMPROVE_CODE_FOR_ROI_TOOLS						*
 *	Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY		*
 *  Iris 2/25/2010 TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE		*
 *  Iris 2/25/2010 FIX_EXPAND_FULL_RANGE_FIT_CURVE_UPWARD_MOVED					*
 *	Sophy 3/1/2010 OC_WORKAROUND_FOR_CONNECTED_OBJ_WRONG_POSITION_ON_LAYER_RESIZE
 *	Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR	*
 *	Kyle 03/08/2010 CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS				*
 *	Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT							*
 *	Kyle 03/15/2010 IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
 *	Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS			*
 *	Sophy 3/30/2010 QA81-15217-S1 MORE_WORK_ON_CLONE_MAIN_OBJ					*
 *	Folger 04/08/10 ROI_TEXT_LABEL_SHOULD_BE_WHITEOUT							*
 *	Sophy 4/9/2010 QA81-15290 QUICK_STATS_SHOW_PREVIEW_LINE_LABELS				*
 *	Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2			*
 *	Sophy 4/13/2010 SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU				*
 *	Sophy 4/14/2010 BACKWORD_COMPATIBILITY_SUPPORT_FOR_GADGET_ATTACHMENTS		*
 *	Folger 04/16/10 QA81-15311 GR_BUTTON_OBJ_RECT_SHADOW_REMAINED_AFTER_DESTROY	*
 *	Sophy 4/29/2010 QUICKFIT_EXPAND_TO_FULL_RANGE_SHOULD_UPDATE_X_SCALE			*
 *	Sophy 4/29/2010 ORG-59 DATAPOINTS_OPERATION_SHOULD_ALLOW_UNDO				*
 *	Sophy 4/29/2010 ORG-59 REGION_STATS_GADGET_SHOULD_SEL_ALL_PLOTS_BY_DEFAULT	*
 *	Sophy 5/5/2010 EXPAND_FULL_RANGE_SHOULD_DO_NOTHING_WHEN_ALL_POINTS_ARE_MISSING_VALUE
 *	Sophy 6/8/2010 ORG-48-P9 FAIL_TO_DEFAUL_THEME_FROM_CONTEXT_MENU				*
 *	Sophy 6/8/2010 ORG-48-P10 PROPER_GET_DATAPLOT_POINTS_FOR_EXPAND_FULL_RANGE	*
 *	Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG		*
 *	Kyle 09/08/2010 ORG-998-P6 SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY			*
 *	Folger 09/14/2010 PICK_PEAK_GADGET_FAILED_TO_WORK_AFTER_RELOAD_PROJECT		*
 *	Sophy 10/15/2010 ORG-1263-P1 UPDATE_INDICATOR_SETTINGS_FOR_RISETIME_TOOL	*
 *	Sophy 10/15/2010 ORG-1265-P1 PROPER_INIT_ROI_POSITION_WITH_LARGE_MAGNITUDE_X_VALUES
 *	Folger 11/25/2010 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
 *	Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK		*
 *	Folger 12/15/2010 ORG-1752-P1 QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG
 *	Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG					*
 *	Sophy 12/27/2010 ORG-1844-P1 OPTION_TO_REMOVE_CONTEXT_MENU_FROM_ROI_BOX		*
 *	Kyle 12/28/2010 ORG-1736-S2 ALLOW_DISABLE_APPLY_BUTTON_ONLY_AFTER_CLICK_APPLY
 *	Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
 *	Sophy 1/6/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL			*
 *	Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
 *	Sophy 1/11/2011 ORG-1394-P4 ALLOW_FITTED_CURVE_FOR_COMMON_GADGET_EXCEPT_QUICKFIT
 *	Hong 01/14/11 ORG-1944-P2 FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA	*
 *	Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
 *	Sophy 1/20/2011 ORG-2068-S1 GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
 *	Kyle 02/12/2011 ORG-2228-P1 GRAPH_OBJECT_GET_STATES_LOSE_GOC_EXPORT_PROGRAMMED
 *	Kit 02/14/2011 ORG-2229-P1 BRING_GADGET_TO_FONT_WHEN_SEL					*
 *	Kit 02/14/2011 ORG-2230-P1 USE_HOT_KEY_TO_SWAP_ROI_OBJ						*
 *	Kit 02/17/2011 ORG-2229-P2 MOVE_ALL_RELATE_OBJS_TO_TOP_WHEN_SEL_ROI_OBJS	*
 *	Folger 03/18/2011 ORG-2479-S1 MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS			*
 *	Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
 *	Folger 03/23/2011 QA-528-P3 GADGET_PREFERENCE_DLG_WRONG_F1_MAPPING			*
 *	Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET			*
 *	Sophy 3/28/2011 ORG-2536-P2 COMPATIBILITY_ISSUE_ON_ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
 *	Folger 04/15/2011 ORG-2466-P1 PROPER_LANGUAGE_MENU_FOR_GADGET_DLG			*
 *	Jasmine 05/16/2011 ORG-2462-S6 REPOSITION_TOP_LABEL_ON_TOP_WHEN_DATA_CHANGE	*
 *	Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA		*
 *	Sophy 5/18/2011 ORG-2888-P1 FITTED_CURVE_NOT_DRAW_PROPERLY_WHEN_UPDATE_SOURCE_DATA_WITH_SCALE_CHANGED
 *	Sophy 5/31/2011 ORG-2985-P1 GROBJCURVETOOL_GET_REGION_DATA_SHOULD_INCLUDE_BOUNDARY_POINTS
 *	Sophy 6/10/2011 ORG-3046-S1 GADGET_NEW_DIALOG_FOR_SELECT_MULTIPLE_PLOTS		*
 *	Sophy 8/10/2011 ORG-3496-P1 QUICK_FIT_SUBPOPUP_CONTEXT_MENU_NOT_CHECKED_PROPERLY
 *  Sen 08/25/2011 ORG-2298-P2 MAKE_BASELINE_TAB_WORK_CORRECTLY					*
 *  Sen 08/29/2011 ORG-2298-P9 MAKE_FULL_RANGE_HATCH_AREA_CORRECT				*
 *	Zech 09/05/2011 ORG-3492-P5 DISPLAY_EXE_FOLDER_THEMES_ON_GADGET_LOAD_THEME_FLYOUT
 *	Sophy 9/6/2011 ORG-1931-P1 GADGET_PREFERENCE_DIALOG_THEME_SUPPORT			*
 *	Sophy 9/14/2011 ORG-3797-P1 GADGET_PREFERENCE_APPLY_BROKEN_AFTER_ADD_THEME_SUPPORT
 *	Kit 09/28/2011 ORG-3724-P5 GADGETS_MSG_NEED_DUMP_INFO_TO_SCRIPT_WIN_WHEN_SELECTED
 *	Kit 09/29/2011 ORG-3724-P7 SCRIPT_WIN_SHOULD_NOT_OPEN_WHEN_DUMP_INFO_TO_MSG_LOG
 *	Sophy 10/13/2011 ORG-4031-P1 INTEG_GADGET_BASELINE_DATASET_LOST_FROM_851_TO_86
 *	Hong 11/18/11 ORG-3527 PLOT_SUPPORT_SKIP_HIDDEN_ROW_IN_WKS					*
 *	Sophy 12/1/2011 ORG-4487-P1 INIT_POSITION_FOR_NON_LINEAR_SCALE_GRAPH		*
 *	Sophy 2/29/2012 ORG-5178-P1 CLIENT_TO_SCREEN_IN_GADGET_SHOULD_USE_VIEW_ISTEAD_OF_GRAPH_FRAME
 *	Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER							*
 *	Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
 *	Philip 07/18/2012 ORG-6183 INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
 *	Philip 08/20/2012 ORG-6519-P1 FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER		*
 *	Philip 09/05/2012 ORG-6662-S1 QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS	*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <Control.h>
#include <GetNBox.h>
#include <..\OriginLab\OriginEvents.h>
#include <..\Originlab\theme_utils.h>
#include "grobj_utils.h"
#include "GraphObjTools.h"
#include "GraphObjToolDlg.h"
#include <xfutils.h>

#pragma labtalk(0)



int	roi_tool_option_access(DWORD dwTestBit, int nOption)
{
	static	DWORD _ROICtrl = 0;
	static	DWORD _ROIThis = 0;	///Sophy 2/23/2011 ORG-2313-P1 GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	#ifdef	_DEBUG
	DWORD dwTemp = _ROICtrl;
	DWORD dwThis = _ROIThis;
	#endif	/// _DEBUG
	if ( ROI_OP_GET == nOption )
		return (_ROICtrl & dwTestBit);
	else if ( ROI_OP_SET == nOption )
	{
		_ROICtrl |= dwTestBit;
		return _ROICtrl;
	}
	else if ( ROI_OP_REMOVE == nOption )
	{
		_ROICtrl &= ~dwTestBit;
		return _ROICtrl;
	}
	else if ( ROI_OP_RESET == nOption )
	{
		_ROICtrl = 0;
		return _ROICtrl;
	}
	///Sophy 2/23/2011 ORG-2313-P1 GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	else if ( ROI_OP_GET_THIS == nOption )
	{
		return _ROIThis;
	}
	else if ( ROI_OP_SET_THIS == nOption )
	{
		_ROIThis = dwTestBit;
		return _ROIThis;
	}
	else
	{
		ASSERT(0); //check why come here!
	}
	///end GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	return 0;
}

///Sophy 2/10/2010 QA81-15097 ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED
bool	is_active_graphlayer_xyexchanged()
{
	int nExchangeXY = 0;
	_LT_Obj
	{
		nExchangeXY = layer.exchangexy;
	}
	return (0 != nExchangeXY);
}
///end ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED

///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
///Kyle 03/15/2010 IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
//bool	is_plot_for_ROI(const DataPlot& dp, const GraphObject& gr, vector<int>& vnI1, vector<int>& vnI2) // NULL, NULL
bool	is_plot_for_ROI(const DataPlot& dp, const GraphObject& gr, LPCSTR lpcszTag, vector<int>& vnI1, vector<int>& vnI2) // NULL, NULL, NULL
///End IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
{
	if ( !dp || !gr )
		return false;
	vector<int> vI1, vI2;
	XYRange xySrc;
	Column colY;
	///Sophy 5/31/2011 ORG-2985-P1 GROBJCURVETOOL_GET_REGION_DATA_SHOULD_INCLUDE_BOUNDARY_POINTS
	//if ( (dp.GetDataRegions(gr, vI1, vI2) > 0) )
	if ( (dp.GetDataRegions(gr, vI1, vI2, NULL, GDPS_CHECK_EDGE) > 0) )
	///end GROBJCURVETOOL_GET_REGION_DATA_SHOULD_INCLUDE_BOUNDARY_POINTS
	{
		///Kyle 03/15/2010 IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
		//if ( dp.GetDataRange(xySrc) && xySrc.GetYColumn(colY) && is_dataobj_tagged(colY, STR_DATASETOBJ_FITCURVE) )
		//	return false;
		if( lpcszTag )
		{
			if ( dp.GetDataRange(xySrc) && xySrc.GetYColumn(colY) && is_dataobj_tagged(colY, lpcszTag) )
				return false;
		}
		///End IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
		if ( !okutil_is_good_plot_type_for_analysis(dp.GetPlotType()) )
			return false;
		
		if ( vnI1 )
			vnI1 = vI1;
		if ( vnI2 )
			vnI2 = vI2;
		
		return true;
	}
	return false;
}
///Sophy 4/11/2011 ORG-2606-P2 PROPER_UPDATE_ROI_POSITION_WHEN_NOT_ATTACH_TO_SCALE
static	bool	_set_roi_position(GraphObject& go, double x0, double x1, double y0 = NaN, double y1 = NaN)
{
	if ( !go || is_missing_value(x0) || is_missing_value(x1) )
		return false;
	
	Tree tr;
	tr = go.GetFormat(FPB_ALL, FOB_ALL, true, true);
	int nDirection = tr.Root.Direction.nVal;
	tr.Reset(); //after get the Direction settings, reset the tree to make ApplyFormat faster.
	tr.Root.Direction.nVal = 0;
	if ( 0 != go.UpdateThemeIDs(tr.Root) )
	{
		ASSERT(false);
		return false;
	}
	bool bRet = go.ApplyFormat(tr, true ,true);
	//set position properties
	go.Attach = ATTACH_TO_SCALE;
	tr.Reset();
	vector vX(4);
	vX[0] = x0; vX[1] = x1; vX[2] = x1; vX[3] = x0;
	tr.Root.Data.X.dVals = vX;
	if ( y0 != y1 && !is_missing_value(y0) && !is_missing_value(y1) )
	{
		vector vY(4);
		vY[0] = y0; vY[1] = y0; vY[2] = y1; vY[3] = y1;
		tr.Root.Data.Y.dVals = vY;
	}
	tr.Root.Dimension.Units.nVal = UNITS_SCALE;
	if ( 0 != go.UpdateThemeIDs(tr.Root) )
	{
		ASSERT(false);
		return false;
	}
	bRet &= go.ApplyFormat(tr, true, true);
	//set back direction settings
	go.Attach = ATTACH_TO_LAYER;
	tr.Reset();
	tr.Root.Direction.nVal = nDirection;
	tr.Root.Dimension.Units.nVal = UNITS_LAYER;
	if ( 0 != go.UpdateThemeIDs(tr.Root) )
	{
		ASSERT(false);
		return false;
	}
	bRet &= go.ApplyFormat(tr, true, true);
	return bRet;
}
///end PROPER_UPDATE_ROI_POSITION_WHEN_NOT_ATTACH_TO_SCALE
bool	update_roi_position(GraphObject& go, double dLeft, double dTop, double dRight, double dBottom)
{
	///Sophy 4/11/2011 ORG-2606-P2 PROPER_UPDATE_ROI_POSITION_WHEN_NOT_ATTACH_TO_SCALE
	//if ( !go )
		//return false;
	//
	//vector vx(4), vy(4);
	//vx[0] = dLeft, vx[1] = dRight; vx[2] = dRight; vx[3] = dLeft;
	//vy[0] = dTop, vy[1] = dTop; vy[2] = dBottom; vy[3] = dBottom;
	//Tree tr;
	//tr = go.GetFormat(FPB_DATA, FOB_ALL, true, true);
	//tr.Root.Data.X.dVals = vx;
	//tr.Root.Data.Y.dVals = vy;
//
	//int nErr = go.UpdateThemeIDs(tr.Root);
	//if(nErr == 0)
	//{
		//go.ApplyFormat(tr, true, true);
		//return true;
	//}
	//out_int("err = ", nErr);
	//return false;	
	return _set_roi_position(go, dLeft, dRight, dTop, dBottom);
	///end PROPER_UPDATE_ROI_POSITION_WHEN_NOT_ATTACH_TO_SCALE
}

///Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT, moved from QuickFit.c
int get_source_data_plot_index_from_ROI(const GraphObject& go)
{
	Tree trInfo;
	int nPlotIndex = -1;
	if ( go && tree_get_binary_storage(trInfo, go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.curPlotIndex )
		nPlotIndex = trInfo.curPlotIndex.nVal;
	else
		nPlotIndex = get_selected_data_plot();
	return nPlotIndex;
}

///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
int	grobjtool_construct_x_scale_branch(TreeNode& trParent)
{
	if ( !trParent )
		return -1;
	GETN_USE(trParent)
	GETN_BEGIN_BRANCH(XScale, _L("X Scale")) GETN_ID_BRANCH(GROBJ_XSCALE_BRANCH_ID) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		//GETN_NUM(leftx, _L("From"), 0)	GETN_ID(GROBJ_XSCALE_FROM_ID)
		//GETN_NUM(rightx, _L("To"), 10)	GETN_ID(GROBJ_XSCALE_TO_ID)
		GETN_STR(leftx, _L("From"), "0")	GETN_ID(GROBJ_XSCALE_FROM_ID)
		GETN_STR(rightx, _L("To"), "10")	GETN_ID(GROBJ_XSCALE_TO_ID)
		///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		GETN_CHECK(fixscale, _L("Fixed(Prevent moving by ROI)"), 0)	GETN_ID(GROBJ_XSCALE_FIXED_ID)
	GETN_END_BRANCH(XScale)
	return 0;
}

bool	check_update_roi_x_position(TreeNode& trXScale, LPCSTR lpcszXFName)
{
	if( trXScale.fixscale.nVal )	// Fixed checkbox default is unchecked, if it is fixed load from theme, should use x position settings in theme.
		return false;

	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return false;

	string strRect;
	double dLeft, dRight;

	get_ROI_main_obj_name(gl, lpcszXFName, strRect);
	if( check_get_roi_x_position(gl, dLeft, dRight, strRect) )
	{
		trXScale.leftx.dVal = dLeft;
		trXScale.rightx.dVal = dRight;
		///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		ColFmtInfo xFmtInfo;
		get_plot_source_format(gl, -1, &xFmtInfo);
		if ( LT_FORMAT_NUMERIC != xFmtInfo.m_nLTFormat )
		{
			set_node_datetime_picker(trXScale.leftx, xFmtInfo.m_strDispFmt, LT_FORMAT_DATE == xFmtInfo.m_nLTFormat, xFmtInfo.m_bForDateTimePicker);
			set_node_datetime_picker(trXScale.rightx, xFmtInfo.m_strDispFmt, LT_FORMAT_DATE == xFmtInfo.m_nLTFormat, xFmtInfo.m_bForDateTimePicker);
		}
		///Sophy 5/3/2012 ORG-5612-P1 SET_NUMERIC_DISPLAY_FORMAT_WHEN_NOT_DATETIME
		else
		{
			set_node_datetime_picker(trXScale.leftx, "*", false, false);
			set_node_datetime_picker(trXScale.rightx, "*", false, false);
		}
		///end SET_NUMERIC_DISPLAY_FORMAT_WHEN_NOT_DATETIME
		///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		return true;
	}
	return false;
}
///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL

///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
int grobjtool_construct_position_branch(TreeNode& trParent)
{
	if ( !trParent )
		return -1;
	GETN_USE(trParent)
	GETN_BEGIN_BRANCH(shapeProp, _L("Shape Position")) GETN_ID_BRANCH(GROBJ_POSITION_BRANCH_ID) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_STR(xFrom, _L("X1"), "0")	GETN_ID(GROBJ_POSITION_X_FROM_ID)
		GETN_STR(xTo, _L("X2"), "10")		GETN_ID(GROBJ_POSITION_X_TO_ID)
		GETN_STR(yFrom, _L("Y1"), "0")	GETN_ID(GROBJ_POSITION_Y_FROM_ID)
		GETN_STR(yTo, _L("Y2"), "10")		GETN_ID(GROBJ_POSITION_Y_TO_ID)
	GETN_END_BRANCH(shapeProp)
	return 0;

}
///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT


bool get_rect_ROI_init_x_range(const GraphLayer& gl, double& x0, double& x1)
{
	if( !gl )
		return false;
	///------ Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
	//double dx = fabs(gl.X.To - gl.X.From);
	int		nScaleType = gl.X.Type;
	double	from = gl.X.From;
	double	to = gl.X.To;
	if ( SCALE_TYPE_LINEAR != nScaleType )
	{
		from = real_space(from, nScaleType);
		to = real_space(to, nScaleType);
	}
	double dx = fabs(from - to);
	///------ End QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
	
	double min = dx * 0.2;
	double max = dx * 0.7;
	///------ Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
	//double from = gl.X.From;
	//double to = gl.X.To;
	///------ End QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
	x0 = (from < to? from : to) + (from < to ? min : max);
	x1 = (from < to? from : to) + (from < to ? max : min);

	///------ Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
	if ( SCALE_TYPE_LINEAR != nScaleType )
	{
		x0 = real_inv_space(x0, nScaleType);
		x1 = real_inv_space(x1, nScaleType);
	}
	///------ End QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
	return true;
}
///Sophy 7/24/2012 ORG-6332-S1 SIGNIFICANTS_CUTOFF_FOR_GADGET_ROI_ON_GRAPHLAYER
///Sophy 9/28/2012 ORG-7008-P1 ROI_POSITION_CUTOFF_MAKE_GETDATA_FAIL
//#define	_CUTOFF(dVal) dVal = atof(ftoa(dVal, "*"));
#define	_CUTOFF(dVal)				//make it do nothing
///end ROI_POSITION_CUTOFF_MAKE_GETDATA_FAIL
///end SIGNIFICANTS_CUTOFF_FOR_GADGET_ROI_ON_GRAPHLAYER

///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
static	bool	_get_go_rect(GraphLayer& gl, GraphObject& go, double& dLeft = NULL, double& dRight = NULL, double& dTop = NULL, double& dBottom = NULL)
{
	if ( !gl || !go )
		return false;
	double xx1, xx2, yy1, yy2;
	int nLeft, nTop, nRight, nBottom;
	nLeft = go.Left;
	nRight = go.Left + go.Width;
	nTop = go.Top;
	nBottom = go.Top + go.Height;
	gl.PageToWorld(xx1, yy1, nLeft, nBottom);
	gl.PageToWorld(xx2, yy2, nRight, nTop);
	///Sophy 7/24/2012 ORG-6332-S1 SIGNIFICANTS_CUTOFF_FOR_GADGET_ROI_ON_GRAPHLAYER
	ColFmtInfo xFmtInfo, yFmtInfo;
	bool bRet = get_plot_source_format(gl, -1, &xFmtInfo, &yFmtInfo);
	bool bCutOffX = !(bRet && (LT_FORMAT_DATE == xFmtInfo.m_nLTFormat || LT_FORMAT_TIME == xFmtInfo.m_nLTFormat));
	bool bCutOffY = !(bRet && (LT_FORMAT_DATE == yFmtInfo.m_nLTFormat || LT_FORMAT_TIME == yFmtInfo.m_nLTFormat));
	if ( bCutOffX )_CUTOFF(xx1);
	if ( bCutOffX )_CUTOFF(xx2);
	if ( bCutOffY )_CUTOFF(yy1);
	if ( bCutOffY )_CUTOFF(yy2);
	///end SIGNIFICANTS_CUTOFF_FOR_GADGET_ROI_ON_GRAPHLAYER
	if(dLeft != NULL)
		dLeft = xx1;
	
	if(dRight != NULL)
		dRight = xx2;
	
	if(dTop != NULL)
		dTop =yy2;
	
	if(dBottom != NULL)
		dBottom = yy1;
	return true;
}
///end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED

///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
bool get_plot_source_format(const GraphLayer& gl, int nPlotIndex, ColFmtInfoPtr pxFmtInfo, ColFmtInfoPtr pyFmtInfo)
{
	if ( !gl )
		return false;
	DataPlot dp = gl.DataPlots(nPlotIndex);
	if ( !dp )
		return false;
	XYRange xySrc;
	if ( !dp.GetDataRange(xySrc) )
		return false;
	
	Column colX, colY;
	xySrc.GetXColumn(colX);
	xySrc.GetYColumn(colY);
	if ( !colX.IsValid() || !colY.IsValid() )
		return false;

	bool bDateTimePickerX = true, bDateTimePickerY = true;
	string strXFmt, strYFmt;
	int nXLTFormat = get_lt_datetime_display_format(colX, strXFmt, bDateTimePickerX);
	int nYLTFormat = get_lt_datetime_display_format(colY, strYFmt, bDateTimePickerY);
	if ( NULL != pxFmtInfo )
	{
		pxFmtInfo->m_nLTFormat = nXLTFormat;
		pxFmtInfo->m_strDispFmt = strXFmt;
		pxFmtInfo->m_bForDateTimePicker = bDateTimePickerX;
	}
	if ( NULL != pyFmtInfo )
	{
		pyFmtInfo->m_nLTFormat = nYLTFormat;
		pyFmtInfo->m_strDispFmt = strYFmt;
		pyFmtInfo->m_bForDateTimePicker = bDateTimePickerY;
	}
	return true;
}
///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME

bool check_get_roi_x_position(const GraphLayer& gl, double& dLeft, double& dRight, LPCSTR lpcszRect)
{
	double x0, x1;

	GraphObject go;
	///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	//FRECT rr;
	//if( lpcszRect && *lpcszRect && (go = gl.GraphObjects(lpcszRect)) && get_go_rect(go, rr) )
	//{
		//x0 = rr.left;
		//x1 = rr.right;
	//}
	if ( lpcszRect && *lpcszRect && (go = gl.GraphObjects(lpcszRect)) && _get_go_rect(gl, go, x0, x1) )
	{
		;//do nothing.
	}
	///end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	///Sophy 2/17/2011 QUICKFIT_QUICKPEAKS_NEED_TO_INIT_POSITION_FROM_OTHER_GADGETS
	//else
	else if ( !_access_obj_position(gl, &x0, &x1, NULL, NULL, true) )
	///end QUICKFIT_QUICKPEAKS_NEED_TO_INIT_POSITION_FROM_OTHER_GADGETS
	{
		if( !get_rect_ROI_init_x_range(gl, x0, x1) )
			return false;
	}
	//Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
	/*
	int nPlot = get_source_data_plot_index_from_ROI(go);
	DataPlot dp;
	///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	//if( nPlot>=0 && (dp=gl.DataPlots(nPlot)) )
	if ( (dp = gl.DataPlots(nPlot)) ) //support init from active plot.
	///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	{
		///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
		//strLeft = get_value_by_format(dp, x0);
		//strRight = get_value_by_format(dp, x1);
		double dOffset = gl.X.From;
		strLeft = get_value_by_format(dp, x0, 0, true, &dOffset);
		strRight = get_value_by_format(dp, x1, 0, true, &dOffset);
		///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
	}
	else
	{
		///Sophy 10/15/2010 ORG-1265-P1 PROPER_INIT_ROI_POSITION_WITH_LARGE_MAGNITUDE_X_VALUES
		//strLeft = ftoa(x0, "*"); 	when x0 = 2451080.1 and x1 = 2451082.85
		//strRight = ftoa(x1, "*"); these two strLeft & strRight got same values, the area becomes a line, and is not good.
		strLeft = ftoa(x0);
		strRight = ftoa(x1);
		///end PROPER_INIT_ROI_POSITION_WITH_LARGE_MAGNITUDE_X_VALUES
	}
	*/
	dLeft = x0;
	dRight = x1;
	///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
	return true;
}

///End PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT

bool	get_ROI_main_obj_name(const GraphLayer& gl, LPCSTR lpcszROIType, string& strObjName)
{
	if ( !gl )
		return false;
	
	Tree tr;
	if ( !gl.GetBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, tr) )
		return false;
	
	TreeNode trROIType = tr.GetNode(lpcszROIType);
	if ( !trROIType )
		return false;
	
	strObjName = trROIType.strVal;
	GraphObject go = gl.GraphObjects(strObjName);
	return go.IsValid();
}

bool	set_ROI_main_obj_name(const GraphLayer& gl, LPCSTR lpcszROIType, LPCSTR lpcszObjName)
{
	if ( !gl )
		return false;
	
	Tree tr;
	gl.GetBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, tr);
	TreeNode trROIType = tree_check_get_node(tr, lpcszROIType);
	if ( NULL == lpcszObjName )
	{
#ifdef	_DEBUG
		string strMsg;
		strMsg.Format("Clear Obj Name for %s : %s", lpcszROIType, trROIType.strVal);
		out_str(strMsg);
#endif	//_DEBUG
		trROIType.strVal = ""; //clear
	}
	else
	{
		GraphObject go = gl.GraphObjects(lpcszObjName);
		if ( !go )
			return false;
		
		trROIType.strVal = lpcszObjName;
#ifdef	_DEBUG
		string strMsg;
		strMsg.Format("Set Obj Name for %s : %s", lpcszROIType, trROIType.strVal);
		out_str(strMsg);
#endif	//_DEBUG
	}
	gl.PutBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, tr);
	return true;
}
///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL

///Sophy 2/17/2011 ORG-2227-P1 MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
#define	STR_ROI_LAST_FILL_COLOR	"LastROIColor"
bool	access_ROI_fill_color(const GraphLayer& gl, int& nColor, int nOpt)
{
	if ( !gl )
		return false;
	
	Tree tr;
	gl.GetBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, tr);
	TreeNode trROIColor;
	if ( ROI_OP_GET == nOpt || ROI_OP_UPDATE == nOpt )
	{
		trROIColor = tr.GetNode(STR_ROI_LAST_FILL_COLOR);
		if ( trROIColor )
			nColor = trROIColor.nVal;
		if ( ROI_OP_UPDATE == nOpt || SYSCOLOR_WHITE == nColor || SYSCOLOR_BLACK == nColor )
		{
			if ( trROIColor ) //only if detected other gadgets on the layer, need to increment the color
				nColor++;
		}
		if ( nColor > SYSCOLOR_DKGRAY )
			nColor = SYSCOLOR_RED;	
	}
	else if ( ROI_OP_SET == nOpt )
	{
		trROIColor = tree_check_get_node(tr, STR_ROI_LAST_FILL_COLOR);
		trROIColor.nVal = nColor;
	}
	///Sophy 2/18/2011 ORG-2227-P1 MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
	else if ( ROI_OP_RESET == nOpt )
	{
		trROIColor = tr.GetNode(STR_ROI_LAST_FILL_COLOR);
		if ( trROIColor )
			trROIColor.Remove();
	}
	///end MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
	gl.PutBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, tr);
	
	return true;
}

bool	update_auto_fill_color(TreeNode& trColor)
{
	GraphLayer gl = Project.ActiveLayer();
	if ( gl && trColor )
	{
		int nColor = trColor.nVal;
		if ( INDEX_COLOR_AUTOMATIC == nColor )
		{
			int nAutoColor;
			trColor.GetAttribute(STR_ATTRIB_AUTO_COLOR, nAutoColor);
			access_ROI_fill_color(gl, nAutoColor, ROI_OP_UPDATE);
			trColor.SetAttribute(STR_ATTRIB_AUTO_COLOR, nAutoColor);			
		}
		return true;
	}
	return false;
}
///end MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR

///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
bool	ROI_apply_handle(TreeNode& tr)
{
	string strLTCmd;
	string strXFName;
	string strMainObjName;
	if ( tr.trGUI )
		tr = tr.trGUI;
	if ( tr.GetAttribute(STR_XFNAME_ATTRIB, strXFName) && tr.GetAttribute(STR_MAINOBJ_NAME_ATTRIB, strMainObjName) )
	{
		GraphObjCurveTool gBaseTool(strMainObjName);
		SET_MODIFIED_OUTSIDE(tr, false);	///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
		///------ Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
		//gBaseTool.SetGUITree(tr);
		///Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
		//gBaseTool.SetGUITreeUpdateLastUsed(tr);
		gBaseTool.SetGUITree(tr, true);
		//CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
		///------ End APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
		strLTCmd.Format("run.section(graph_controls.ogs, GraphToolEvent, %s %s %d %d);", strXFName, strMainObjName, OE_BUTTONCLICK, GOT_BTN_APPLY);	
		LT_execute(strLTCmd);
	}
	return true;
}
///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG

///--------------------- Sophy 9/13/2008 GRAPH_OBJ_TOOL_BASE_CLASS
#define	GRAPH_TOOL_SETTINGS		"GraphToolSettings"
#define GRAPH_TOOL_CLASS_INFO	"GraphToolClassInfo"
GraphObjTool::GraphObjTool(LPCSTR lpcszMainObjName)
{
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	/*
	GraphPage gp = Project.Pages();
	if(!gp)
		return;

	GraphLayer gl = gp.Layers();//Layers(0);CPY 9/24/08 QA70-92268 GR_SHOULD_ALLOW_ON_MULTI_LAYER_GRAPH
	if(!gl)
	{
		return;
	}
	m_gp = gp;
	m_gl = gl;
	m_attObjNames.SetSize( CTP_SIZE );
	connectToObj(lpcszMainObjName);
	*/
	m_strGrName = "";
	
	m_vnObjIDs.SetSize(0);
	m_vsObjNames.SetSize(0);
	
	m_vnObjIDs.Add(GOT_OBJ_CLOSE);
	m_vsObjNames.Add("Close");

	m_nRightTopObjs = 0;	
	
	if ( lpcszMainObjName )
		Init(lpcszMainObjName);
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	m_gapCtrl.xGap = 0.2;
	m_gapCtrl.yGap = 0.2;

}

//---- CPY 9/26/08 QA70-12266 ADDTOOL_XF_NEEDS_PROJ_VAR_TO_INDICATE_THEY_ARE_STILL_ACTIVE
int GraphObjTool::GetTotalNumTools()
{
	string strVar = GetSignature();
	double dd = 0;
	LT_get_var(strVar, &dd);
	return dd;
}
BOOL GraphObjTool::OnDestroy()
{
	referenceCount(false);
	
	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	set_ROI_main_obj_name(m_gl, GetXFName());	 //clear information
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL

	///------ Folger 04/16/10 QA81-15311 GR_BUTTON_OBJ_RECT_SHADOW_REMAINED_AFTER_DESTROY
	#ifndef		__ENLARGE_GR_OBJ_ERASE_INFLATE_SIZE__
	if ( m_gp )
		m_gp.Refresh();
	#endif		/// __ENLARGE_GR_OBJ_ERASE_INFLATE_SIZE__
	///------ End GR_BUTTON_OBJ_RECT_SHADOW_REMAINED_AFTER_DESTROY
	return true;
}

/// Fisher 2008-9-18 For OnDestroy()
/*
In some tool like basic curve FFT, The preview graph and the temp data worksheet 
were shared by multiple tools. So their destructor cannot simply delete the preview
graph and temp data wks, we need a mechanism to specify a count of the 
number of references to it held by other objects, If an object's shared count 
reaches zero, the object has become deletable.

CPY removed Fisher's code and condence it to referenceCount
*/

// use Project variable to keep track of the number of instances of a gr tool
int GraphObjTool::referenceCount(bool bInc) // true to increment, false to decrement
{
	string strVar = GetSignature();
	double dd = 0;
	LT_get_var(strVar, &dd);
	dd = dd + (bInc? 1:-1);
	if(dd <= 0)
	{
		string strLT;
		strLT.Format("del -v %s", strVar);
		LT_execute(strLT);
	}
	else
		LT_set_var(strVar, dd);
	return (int)dd;
}
//----

//----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE
//	virtual 
///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
//BOOL GraphObjTool::Init()
BOOL GraphObjTool::Init(LPCSTR lpcszMainObjName)
///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
{
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	//if(!IsValidLayer())
		//return false;
	//
	//if(!IsValidGrObj())
	//{
		//ASSERT(false);
		//return false;
	//}
	//set_go_behind_data(m_go);
	////set_go_user_deleteable(m_go, true);CPY 9/23/08 this is now done as part of set_LT_script
//
	///// YuI 09/24/08 QA70-12264 OPTION_TO_SELECT_GR_OBJECT_BEFORE_DATA
	//set_go_hittest_before_data(m_go);
	///// end OPTION_TO_SELECT_GR_OBJECT_BEFORE_DATA
//
	//referenceCount(true);//---- CPY 9/26/08 QA70-12266 ADDTOOL_XF_NEEDS_PROJ_VAR_TO_INDICATE_THEY_ARE_STILL_ACTIVE
	
	if ( !connectToObj(lpcszMainObjName) )
		return false;
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	return true;
}

BOOL	GraphObjTool::GetMainObjName(string& strObjName)
{
	if ( m_go )
	{
		strObjName = m_go.GetName();
		return TRUE;
	}
	return FALSE;
}

//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
bool GraphObjTool::Attach(LPCSTR lpcszMainObjName)
{
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	///Sophy 2/22/2010 QA81-14930 IMPROVE_CODE_FOR_ROI_TOOLS
	//if ( !m_gp )
	//{
		//GraphPage gp = Project.Pages();
		//if(!gp)
			//return false;
		//m_gp = gp;
	//}
	//if ( !m_gl )
	//{
		//GraphLayer gl = m_gp.Layers();//Layers(0);CPY 9/24/08 QA70-92268 GR_SHOULD_ALLOW_ON_MULTI_LAYER_GRAPH
		//if(!gl)
		//{
			//return false;
		//}
		//m_gl = gl;
	//}
	///Sophy 3/3/2011 ORG-1930-P1 PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
	//it's strange that when save two Graphs with OPJ and loading, Project.Pages get Graph2 while Project.ActiveLayer get Graph1:0...
	//but Project.ActiveLayer seems consistent with page.name$ in Labtalk, so need to get layer first, then page.
	//m_gp = Project.Pages();
	//if ( !m_gp )
		//return false;
	//
	//m_gl = m_gp.Layers();
	//if ( !m_gl )
		//return false;
	m_gl = Project.ActiveLayer();
	if ( !m_gl )
		return false;
	m_gp = m_gl.GetPage();
	if ( !m_gp )
		return false;
	///end PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
	///end IMPROVE_CODE_FOR_ROI_TOOLS
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	
	if(lpcszMainObjName && *lpcszMainObjName != '\0' )
	{
		//ASSERT(m_strGrName.IsEmpty());
		m_strGrName = lpcszMainObjName;
		m_go = m_gl.GraphObjects(m_strGrName);
		if(m_go)
			return true;
	}
	return false;
}
//virtual 
void GraphObjTool::OnMoving()
{
	if(!IsValidGrObj())
		return;
	
	///--- Sandy 2008-12-10 centralize and update the string to data display as well, 
	//						since the status bar shows the x info But kept on blinking so user can really use it
	/*
	FRECT frect;
	m_go.GetTempBoundingBox(&frect);
	string str;
	double x1 = m_gl.X.From;
	double x2 = m_gl.X.To;
	double xx1 = x1 + frect.left * (x2-x1);
	double xx2 = x1 + frect.right * (x2-x1);
	
	str.Format("x= %g - %g, dx= %g", xx1, xx2, xx2-xx1);
	*/
	string str;
	//_get_go_bounding_box_info(m_go, str);
	getBoundingBoxInfo(str);
	
	if(!str.IsEmpty())
		SetDataDisplayText(str);
	
	///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	///Sophy 5/12/2011 ORG-2844-P1 UNDOBLOCK_MESSUP_WHEN_OC_DOES_NOT_END_THE_BLOCK
	if ( IsSupportEditData() )
	///end UNDOBLOCK_MESSUP_WHEN_OC_DOES_NOT_END_THE_BLOCK
	{
		if ( !QUERY_ROI_TOOL_OPTION(ROI_OPTION_UNDO_BEGIN) ) //if already begin undo block, and is still moving, should not create new undo block
		{
			Project.UndoBlockBegin();
			SET_ROI_TOOL_OPTION(ROI_OPTION_UNDO_BEGIN);
		}
	///Sophy 5/12/2011 ORG-2844-P1 UNDOBLOCK_MESSUP_WHEN_OC_DOES_NOT_END_THE_BLOCK
	}
	///end UNDOBLOCK_MESSUP_WHEN_OC_DOES_NOT_END_THE_BLOCK
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL

	SetStatusBarText(str);
}

///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
BOOL	GraphObjTool::OnMove()
{
	if ( IsSupportEditData() ) //I think only those tools that support edit data points need this logic, just to make other tools more efficient.
	{
		if ( QUERY_ROI_TOOL_OPTION(ROI_OPTION_UNDO_BEGIN) ) //already begin undo block
		{
			int nBlockID = Project.UndoBlockId();
			UndoControl(UNDO_INCRE, &nBlockID);
			Project.UndoBlockEnd();
			REMOVE_ROI_TOOL_OPTION(ROI_OPTION_UNDO_BEGIN);
		}
	}
	return TRUE;
}

#define	STR_UNDO_STACK	"UndoStack"
BOOL	GraphObjTool::UndoControl(DWORD dwCtrl, int* pnBlockID)
{
	vector<int> vnBlocks(0);
	int nSize = GetUndoStack(vnBlocks);
	BOOL bRet = FALSE;
	if ( UNDO_INCRE == dwCtrl )
	{
		int nBlockID = (NULL != pnBlockID) ? *pnBlockID : 0;
		vnBlocks.Add(nBlockID);
		nSize++;
		bRet = (nSize > 0);
	}
	else if ( UNDO_DECRE == dwCtrl )
	{
		if ( nSize > 0 )
		{
			nSize--;
			if ( NULL != pnBlockID )
				*pnBlockID = vnBlocks[nSize];
			vnBlocks.SetSize(nSize);
			bRet = TRUE;
		}
	}
	else if ( UNDO_UNDOABLE == dwCtrl )
	{
		bRet = (nSize > 0);
	}
	else
	{
		ASSERT(false);
		return FALSE;
	}

	SetUndoStack(vnBlocks);
	return bRet;
}

///Sophy 1/20/2011 ORG-2068-S1 GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
#define	STR_MAINOBJ_POSITION	"LastROIPosition"
///Sophy 2/17/2011 QUICKFIT_QUICKPEAKS_NEED_TO_INIT_POSITION_FROM_OTHER_GADGETS
static	bool	_access_obj_position(GraphLayer& gl, double* pdX1, double* pdX2, double* pdY1, double* pdY2, bool bGet)
{
	if ( !gl )
		return false;
	
	Tree trInfo;
	BOOL bRet = gl.GetBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, trInfo);
	if ( bGet && !bRet )
		return false;
	
	TreeNode trLastPosition = bGet ? trInfo.GetNode(STR_MAINOBJ_POSITION) : tree_check_get_node(trInfo, STR_MAINOBJ_POSITION);
	if ( !trLastPosition )
		return false;
	
	if ( bGet )
	{
		*pdX1 = trLastPosition.XFrom.dVal;
		*pdX2 = trLastPosition.XTo.dVal;
		if ( NULL != pdY1 )
			*pdY1 = trLastPosition.YFrom.dVal;
		if ( NULL != pdY2 )
			*pdY2 = trLastPosition.YTo.dVal;
	}
	else //set
	{
		trLastPosition.XFrom.dVal = *pdX1;
		trLastPosition.XTo.dVal = *pdX2;
		if ( NULL != pdY1 )
			trLastPosition.YFrom.dVal = *pdY1;
		if ( NULL != pdY2 )
			trLastPosition.YTo.dVal = *pdY2;
		gl.PutBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, trInfo);
	}
	return true;
}
///end QUICKFIT_QUICKPEAKS_NEED_TO_INIT_POSITION_FROM_OTHER_GADGETS

///Sophy 3/3/2011 ORG-2313-P1 NOTIFY_GROBJS_WHEN_SOURCE_DATA_SERIES_CHANGE
void	GraphObjTool::DelayTranslateMessage(int nEventID, int nMsg)
{
	string strLayerRange, strLTCmd;
	strLayerRange.Format("[%s]%d", m_gp.GetName(), m_gl.GetIndex() + 1);
	strLTCmd.Format("queue { layer -o %s { run.section(graph_controls.ogs, GraphToolEvent, %s %s %d %d); } }", strLayerRange, GetXFName(), m_go ? m_go.GetName() : "Rect", nEventID, nMsg);
	LT_execute(strLTCmd);
}
///end NOTIFY_GROBJS_WHEN_SOURCE_DATA_SERIES_CHANGE

bool	GraphObjTool::PrevMainObjPositionAccess(double* pdX1, double* pdX2, double* pdY1, double* pdY2, bool bGet)
{
	///Sophy 2/17/2011 QUICKFIT_QUICKPEAKS_NEED_TO_INIT_POSITION_FROM_OTHER_GADGETS
	//if ( !m_gl )
		//return false;
	//
	//Tree trInfo;
	//BOOL bRet = m_gl.GetBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, trInfo);
	//if ( bGet && !bRet )
		//return false;
	//
	//TreeNode trLastPosition = bGet ? trInfo.GetNode(STR_MAINOBJ_POSITION) : tree_check_get_node(trInfo, STR_MAINOBJ_POSITION);
	//if ( !trLastPosition )
		//return false;
	//
	//if ( bGet )
	//{
		//*pdX1 = trLastPosition.XFrom.dVal;
		//*pdX2 = trLastPosition.XTo.dVal;
		//if ( NULL != pdY1 )
			//*pdY1 = trLastPosition.YFrom.dVal;
		//if ( NULL != pdY2 )
			//*pdY2 = trLastPosition.YTo.dVal;
	//}
	//else //set
	//{
		//trLastPosition.XFrom.dVal = *pdX1;
		//trLastPosition.XTo.dVal = *pdX2;
		//if ( NULL != pdY1 )
			//trLastPosition.YFrom.dVal = *pdY1;
		//if ( NULL != pdY2 )
			//trLastPosition.YTo.dVal = *pdY2;
		//m_gl.PutBinaryStorage(STR_ROI_MAIN_OBJ_STORAGE, trInfo);
	//}
	//return true;
	return _access_obj_position(m_gl, pdX1, pdX2, pdY1, pdY2, bGet);
	///end QUICKFIT_QUICKPEAKS_NEED_TO_INIT_POSITION_FROM_OTHER_GADGETS
}
///end GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
int		GraphObjTool::GetUndoStack(vector<int>& vnUndoBlockIDs)
{
	Tree tr;
	if ( !GetTree(tr) )
		return 0;
	TreeNode trUndoStack = tree_check_get_node(tr, STR_UNDO_STACK);
	vnUndoBlockIDs = trUndoStack.nVals;
	return vnUndoBlockIDs.GetSize();
}
int		GraphObjTool::SetUndoStack(const vector<int> vnUndoBlockIDs)
{
	Tree tr;
	if ( !GetTree(tr) )
		return 0;
	TreeNode trUndoStack = tree_check_get_node(tr, STR_UNDO_STACK);
	trUndoStack.nVals = vnUndoBlockIDs;
	SetTree(tr);
	return vnUndoBlockIDs.GetSize();
}
///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL

///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL

///Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
#define	ROI_DELAY_EXECUTE_EX(_DirtyBit, _EventID, _Code, _Msg)	{	\
	if ( !QUERY_ROI_TOOL_OPTION(_DirtyBit) )	\
	{	\
		roi_tool_option_access(_DirtyBit, ROI_OP_SET);	\
		string strLT;	\
		string strLayerRange; \
		strLayerRange.Format("[%s]%d", m_gp.GetName(), m_gl.GetIndex() + 1); \
		strLT.Format(";layer -o %s { run.section(graph_controls.ogs, GraphToolEvent, %s %s %d %d); }", strLayerRange, GetXFName(), m_go ? m_go.GetName() : "Rect", _EventID, _Msg);	\
		LT_execute(strLT);	\
	}	\
	else	\
	{	\
		_Code;	\
		roi_tool_option_access(_DirtyBit, ROI_OP_REMOVE);	\
	} \
}

#define	ROI_DELAY_EXECUTE(_DirtyBit, _EventID, _Code)		ROI_DELAY_EXECUTE_EX(_DirtyBit, _EventID, _Code, 0)
///end ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE

///Sophy 7/19/2010 ORG-25-P8 MULTAI_GADGETS_ON_SAME_LAYER_FAIL_TO_UPDATE_CORRECTLY_ON_RESCALE
#define	ROI_DELAY_RESCALE(_Msg)	{	\
	if ( GROBJEVENTS_SELF_DELAY_EVENT == _Msg )	\
	{	\
		m_gp.Refresh(TRUE); \
		OnRescale();	\
	}	\
	else	\
	{	\
		string strLT;	\
		string strLayerRange; \
		strLayerRange.Format("[%s]%d", m_gp.GetName(), m_gl.GetIndex() + 1); \
		strLT.Format(";layer -o %s { run.section(graph_controls.ogs, GraphToolEvent, %s %s %d %d); }", strLayerRange, GetXFName(), m_go ? m_go.GetName() : "Rect", OE_SCALE_CHANGE, GROBJEVENTS_SELF_DELAY_EVENT);	\
		LT_execute(strLT);	\
	}	\
}
///end MULTAI_GADGETS_ON_SAME_LAYER_FAIL_TO_UPDATE_CORRECTLY_ON_RESCALE

///-----Kit 02/14/2011 ORG-2230-P1 USE_HOT_KEY_TO_SWAP_ROI_OBJ
#define		CONVERT_TAB_INDEX(_goIndex)	((_goIndex) << 24)
#define		STR_MAX_ROI_OBJ_TAB_INDEX	"_MAX_ROI_TAB_INDEX"

static int	_get_num_roi_obj_in_layer(const GraphLayer &gl, vector<uint> &vuROIObjsIndexes)
{
	foreach(GraphObject go in gl.GraphObjects)
	{
		if( is_roi_obj(go) )
			vuROIObjsIndexes.Add(go.GetIndex());
	}

	return vuROIObjsIndexes.GetSize();
}

static bool	_reset_roi_objs_tab_index(const GraphLayer &gl, const vector<uint> &vuROIObjsIndexes)
{
	for(int ii = 0; ii < vuROIObjsIndexes.GetSize(); ++ii)
	{
		GraphObject go = gl.GraphObjects(vuROIObjsIndexes[ii]);
		update_go_states(go, CONVERT_TAB_INDEX(ii+1));
	}

	return true;
}
static bool _update_roi_objs_tab_index(GraphObject &go, GraphLayer &gl)
{
	if( !(go.IsValid() && gl.IsValid()) )
		return false;

	vector<uint> vuROIObjsIndexes;
	_get_num_roi_obj_in_layer(gl, vuROIObjsIndexes);

	return _reset_roi_objs_tab_index(gl, vuROIObjsIndexes);
}
///-----End USE_HOT_KEY_TO_SWAP_ROI_OBJ
	
void GraphObjTool::OnEvent(int nEvent, int nMsg)
{
	switch(nEvent)
	{
	///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
	///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	case OE_WIN_OPEN:  /// when oen OGG, there is no OE_WIN_ACTIVATE, so this is a tricky solution since OE_WIN_ACTIVATE will be posted in ROI_DELAY_EXECUTE
		///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS
		//need to update event handler whenever load opj or ogg
		int* pnXFEvtHandlerState = GetXFEventHandlersState();
		if ( pnXFEvtHandlerState != NULL )
			*pnXFEvtHandlerState = 0;
		///end BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS
		///Sophy 3/3/2011 ORG-1930-P1 PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
		DelayTranslateMessage(OE_WIN_ACTIVATE, GROBJEVENTS_SELF_DELAY_EVENT);
		break;
		///end PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
	///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	case OE_WIN_ACTIVATE: //when opj load, the page may not be active and fail to check version, so need to check when activated.
		///Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
		//CheckROIVersion();
		//if ( !roi_tool_option_access(ROI_OPTION_VERSION_CHECKED, ROI_OP_GET) ) //not checked, maybe GUI tree not ready, should delay check.
		//{
			//string strLT;
			//strLT.Format(";run.section(graph_controls.ogs, GraphToolEvent, %s %s %d);", GetXFName(), m_go.GetName(), OE_WIN_OPEN);
			//LT_execute(strLT);
		//}
		//else
			//roi_tool_option_access(ROI_OPTION_VERSION_CHECKED, ROI_OP_REMOVE); //if checked, should be removed for other ROI to use.
		///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
		//ROI_DELAY_EXECUTE(ROI_OPTION_VERSION_CHECKED, OE_WIN_ACTIVATE, CheckROIVersion());
		///Sophy 3/3/2011 ORG-1930-P1 PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
		//ROI_DELAY_EXECUTE(ROI_OPTION_VERSION_CHECKED, OE_WIN_ACTIVATE, OnActivate());
		OnActivate();
		///end PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
		///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
		///end ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
		
		break;
	///end VERSION_CHECKING_FOR_ROI_COMPATIBILITY
	///Sophy 4/6/2011 ORG-2592-P1 GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
	case OE_WIN_DEACTIVATE:
		OnDeactivate();
		break;
	///end GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
	case OE_MOVING:
	case OE_RESIZING:
	///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	case OE_GRAPHOBJ_ROTATING:
	case OE_GRAPHOBJ_SKEWING:
	case OE_GRAPHOBJ_EDITING:
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
		OnMoving();
		break;
	///Sophy 3/3/2011 ORG-2313-P1 NOTIFY_GROBJS_WHEN_SOURCE_DATA_SERIES_CHANGE
	case OE_DATA_CHANGE:
		DelayTranslateMessage(OE_MOVE, GROBJEVENTS_SELF_DELAY_EVENT);
		break;
	///end NOTIFY_GROBJS_WHEN_SOURCE_DATA_SERIES_CHANGE
	///Sophy 1/4/2011 ORG-1841-S5 GROBJTOOL_NEED_TO_UPDATE_RESULT_ON_RORATE_AND_SKEW
	case OE_GRAPHOBJ_ROTATE:
	case OE_GRAPHOBJ_SKEW:
	///end GROBJTOOL_NEED_TO_UPDATE_RESULT_ON_RORATE_AND_SKEW
	///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	case OE_GRAPHOBJ_EDIT:
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	case OE_MOVE:
	case OE_RESIZE:
		{
			ROIToolOptionAccessHelper*		pclHelper = NULL;
			if ( O_QUERY_BOOL(nMsg, GROBJEVENTS_FROM_EVENT_FUNCTION) )
				pclHelper = new ROIToolOptionAccessHelper(ROI_OPTION_ON_MOVE_EVENT);
			OnMove();
			NICE_SAFE_REMOVAL(pclHelper);
		}
		break;
	/// Fisher 7/20/09 QA80-13975 HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL
	case OE_SCALE_CHANGE:
		///Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
		///Sophy 5/18/2011 ORG-2888-P1 FITTED_CURVE_NOT_DRAW_PROPERLY_WHEN_UPDATE_SOURCE_DATA_WITH_SCALE_CHANGED
#ifndef	__PROPER_DELAY_RESCALE_FOR_CALC__
		///end FITTED_CURVE_NOT_DRAW_PROPERLY_WHEN_UPDATE_SOURCE_DATA_WITH_SCALE_CHANGED
		if ( IsDelayUpdate() )
		{
			///Sophy 7/19/2010 ORG-25-P8 MULTAI_GADGETS_ON_SAME_LAYER_FAIL_TO_UPDATE_CORRECTLY_ON_RESCALE
			//ROI_DELAY_EXECUTE(ROI_OPTION_SCALE_CHANGED, OE_SCALE_CHANGE, OnRescale());
			ROI_DELAY_RESCALE(nMsg);
			///end MULTAI_GADGETS_ON_SAME_LAYER_FAIL_TO_UPDATE_CORRECTLY_ON_RESCALE
		}
		else
		{
			OnRescale();
		}
		///Sophy 5/18/2011 ORG-2888-P1 FITTED_CURVE_NOT_DRAW_PROPERLY_WHEN_UPDATE_SOURCE_DATA_WITH_SCALE_CHANGED
#else
		DelayTranslateMessage(OE_MOVE, GROBJEVENTS_SELF_DELAY_EVENT);
#endif	//__PROPER_DELAY_RESCALE_FOR_CALC__
		///end FITTED_CURVE_NOT_DRAW_PROPERLY_WHEN_UPDATE_SOURCE_DATA_WITH_SCALE_CHANGED
		///end ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
		break;
	/// End HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL
	///Sophy 12/4/2009 QA80-14799 EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT
	case OE_DATAMASK_CHANGE:
		OnMasked();
		break;
	///end EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT
	case OE_WIN_CLOSE:
	case OE_DELETE:
		//printf("%d: on Destroy\n", nEvent);
		OnDestroy();
		break;
		
	case OE_BUTTONCLICK:
//---- CPY 1/22/10 QA81-15020 CLOSE_BUTTON_USE_SIMPLER_LT_BASED_CODE
//		switch(nMsg)
//		{
		break;
//----
///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
/*
#ifndef	_ROI_TOOL_NEW_MENU_
		case GOT_BTN_PLOTS:
			DoShowPlots();
			break;
		case GOT_BTN_OUTPUT:
			DoOutput();
			break;
		case GOT_BTN_EDIT:
			DoEdit();
			break;
			
		case GOT_BTN_FUNCTION:
			DoFunction();
			break;
#else
		case GOT_BTN_CONTEXT:
			DoContext();
			break;
#endif	//_ROI_TOOL_NEW_MENU_		
*/
///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
//---- CPY 1/22/10 QA81-15020 CLOSE_BUTTON_USE_SIMPLER_LT_BASED_CODE
//		case GOT_BTN_CLOSE:
//			DestroyInternal();
//			break;
//		}
//----
	default:
		//out_int("other even = ", nEvent);
	}
}
//----

bool GraphObjTool::connectToObj(LPCSTR lpcszMainObjName)
{
	if( Attach(lpcszMainObjName) )
		///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
		//return readClassInfo();
		return loadClassInfo();
		///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	
	return false;
}

/*
void GraphObjTool::saveClassInfo()
{
	if(!m_go)
	{
		ASSERT(false);
		return;
	}
	Tree tr;
	tr.attObjNames.strVals = m_attObjNames;
	tree_put_binary_storage( tr, m_go, GRAPH_TOOL_CLASS_INFO );	
}

bool GraphObjTool::readClassInfo()
{
	if(m_go)
	{
		Tree tr;
		tree_get_binary_storage( tr, m_go, GRAPH_TOOL_CLASS_INFO );
		if(tr.attObjNames)
		{
			vector<string> vsTemp;
			vsTemp = tr.attObjNames.strVals;
			for(int ii = 0; ii < vsTemp.GetSize() && ii < CTP_SIZE; ii ++)
				m_attObjNames[ii] = vsTemp[ii];
			
			return true;
		}
	}
	return false;
}
*/
///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
bool	GraphObjTool::saveClassInfo()
{
	if(!IsValidLayer())
		return false;
	
	if(!IsValidGrObj())
	{
		ASSERT(false);
		return false;
	}
	
	Tree tr;
	if ( !SaveClassInfo(tr) )
		return false;
	if ( !tree_put_binary_storage( tr, m_go, GRAPH_TOOL_CLASS_INFO ) )
		return false;
	
	return true;
}
bool	GraphObjTool::loadClassInfo()
{
	if(!IsValidLayer())
		return false;
	
	if(!IsValidGrObj())
	{
		ASSERT(false);
		return false;
	}
	
	Tree tr;
	if ( tree_get_binary_storage( tr, m_go, GRAPH_TOOL_CLASS_INFO ) )
	{
		if ( !LoadClassInfo(tr) )
			return false;
	}
	
	return true;
}
///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
void GraphObjTool::AddNewLine(string& str, string strNew)
{
	if(!str.IsEmpty())
		str += "\r\n";
	
	str += strNew;
}


//-----
//------ CPY 1/22/10 QA81-15020 CLOSE_BUTTON_USE_SIMPLER_LT_BASED_CODE
/*
///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
void GraphObjTool::DestroyInternal()
{
	if ( m_go )
	{
		string strScript;
		strScript.Format("run.section(graph_controls, DestroyObjects, %s %d %s);", m_gp.GetName(), m_gl.GetIndex() + 1, m_go.GetName());
		LT_execute(strScript);
		OnDestroy();
	}
}
*/
//------ end CLOSE_BUTTON_USE_SIMPLER_LT_BASED_CODE
 
/*
int	GraphObjTool::CreateAdvancedButtons(LPCSTR lpcszXFName, DWORD dwCtrl)
{
	int nNumBtns = 0;
	string strScript;
	if ( dwCtrl & GOT_BTN_CLOSE )
	{
		check_create_attachment(m_go, m_goClose, "\z(0)", GROT_TEXT, CTP_INNER_RIGHT_TOP, CJ_VIEW_X_GAP_N | CJ_VIEW_Y_GAP_N);
		strScript.Format("run.section(graph_controls, GraphToolEvent, %s %s %d %d);", lpcszXFName, m_go.GetName(), OE_BUTTONCLICK, GOT_BTN_CLOSE);
		set_LT_script(m_goClose, strScript, GRCT_MOUSEUP, 1);
		nNumBtns++;
	}
#ifndef	_ROI_TOOL_NEW_MENU_	
	if ( dwCtrl & GOT_BTN_PLOTS )
	{
		check_create_attachment(m_go, m_goPlots, "\z(12)", GROT_TEXT, CTP_RIGHT_TOP, CJ_VIEW_X_GAP_N | CJ_VIEW_Y_GAP_L);
		strScript.Format("run.section(graph_controls, GraphToolEvent, %s %s %d %d);", lpcszXFName, m_go.GetName(), OE_BUTTONCLICK, GOT_BTN_PLOTS);
		set_LT_script(m_goPlots, strScript, GRCT_MOUSEUP, 1);
		nNumBtns++;
	}
	if ( dwCtrl & GOT_BTN_OUTPUT )
	{
		check_create_attachment(m_go, m_goOutput, " + ", GROT_TEXT, CTP_RIGHT_TOP, CJ_VIEW_X_GAP_N | CJ_VIEW_Y_GAP_XL);
		strScript.Format("run.section(graph_controls, GraphToolEvent, %s %s %d %d);", lpcszXFName, m_go.GetName(), OE_BUTTONCLICK, GOT_BTN_OUTPUT);
		set_LT_script(m_goOutput, strScript, GRCT_MOUSEUP, 1);
		nNumBtns++;
	}
	if ( dwCtrl & GOT_BTN_EDIT )
	{
		check_create_attachment(m_go, m_goEdit, "... ", GROT_TEXT, CTP_RIGHT_TOP, CJ_VIEW_X_GAP_N | CJ_VIEW_Y_GAP_XXL);
		strScript.Format("run.section(graph_controls, GraphToolEvent, %s %s %d %d);", lpcszXFName, m_go.GetName(), OE_BUTTONCLICK, GOT_BTN_EDIT);
		set_LT_script(m_goEdit, strScript, GRCT_MOUSEUP, 1);
		nNumBtns++;
	}
#else
	if ( dwCtrl & GOT_BTN_CONTEXT )
	{
		check_create_attachment(m_go, m_goContext, "\z(12)", GROT_TEXT, CTP_RIGHT_TOP, CJ_VIEW_X_GAP_N | CJ_VIEW_Y_GAP_N);
		strScript.Format("run.section(graph_controls, GraphToolEvent, %s %s %d %d);", lpcszXFName, m_go.GetName(), OE_BUTTONCLICK, GOT_BTN_CONTEXT);
		set_LT_script(m_goContext, strScript, GRCT_MOUSEUP, 1);
		nNumBtns++;
	}
#endif	//_ROI_TOOL_NEW_MENU_
	return nNumBtns;
}
*/
///END QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS

BOOL	GraphObjTool::OnPreMove()
{
	if(!IsValidLayer())
		return false;
	
	if( !IsValidGrObj() )
		return false;
	return true;// derived class can return false to prevent OnMove handling
}

BOOL	GraphObjTool::SetTree( const TreeNode& tr )
{
	return tree_put_binary_storage( tr, m_go, GRAPH_TOOL_SETTINGS );
}
BOOL	GraphObjTool::GetTree( TreeNode& tr )
{
	///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	//return tree_get_binary_storage( tr, m_go, GRAPH_TOOL_SETTINGS );
	if ( !tr || !m_go )
		return FALSE;
	BOOL bRet = tree_get_binary_storage( tr, m_go, GRAPH_TOOL_SETTINGS );
	tr.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, GetXFName());
	return bRet;
	///end ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
}
//----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE
/*
int	GraphObjTool::GetAttachmentCount()
{
	vector<uint>	vUIDs;
	m_go.GetConnectedObjects( vUIDs );
	return vUIDs.GetSize();
}
*/
//-----

//--- CPY 9/23/08 BASELINE_NEED_TO_BE_CONNECTED
// returns <0 for err, 1 if already existed and type correct then just get out, 0 if normal creation on empty slot
//int	GraphObjTool::CreateAttachedFreeLine(GraphObject* pgo, int nPos)
//int	GraphObjTool::CreateAttachedFreeLine(GraphObject* pgo, int nPos, int nLineType)
int		GraphObjTool::CreateAttachedFreeLine(GraphObject* pgo, int nPos ,  int nLineType, int nColor)///-------Sandy 2008-12-9 add color option
{
	/// Hong 12/12/08 v8.0986 CLEAN_MAGIC_NUMBER
	//if( !IsValidLayer() || !IsValidGrObj() || nPos > 2 || nPos < 0)
	if( !IsValidLayer() || !IsValidGrObj() || nPos >= CTP_FREE_NUM || nPos < 0)
	/// end CLEAN_MAGIC_NUMBER
		return -1;
	
	///----- Sandy 2008-12-2 add ployline as one kind of free line, and only support these two type of line
	if(nLineType != GROBJ_TN_POLYLINE && nLineType != GROBJ_TN_LINE2 )
		return -1;
	
	GraphObject go;
	
	///----- Sandy 2008-12-2 add ployline as one kind of free line
	//if(GetAttachment(CTP_FREE_1 + nPos, go, GROBJ_TN_LINE2) > 0)
	int nType;
	//if(GetAttachment(CTP_FREE_1 + nPos, go, nLineType) > 0)
	// to do
	if ( 0 == GetAttachment(go, 0) )
	{
		// TO_DO to add code to compare type, if wrong type, will need to destroy it and continue
		go.GetObjectType(&nType); ///Sandy 2008-12-4 I don't know why runtime error happen here
		if(nType == nLineType)
		{
			// return 1 only if type is correct
			if(pgo)
			{
				*pgo = go;
			}
			
			return 1;
		}
	}
	//-----
	
	///----- Sandy 2008-12-2 add ployline as one kind of free line
	//if(!add_line(m_gl, go))
		//return -2;
	
	//add code to compare type, if wrong type, will need to destroy it and continue
	if(go)
		go.Destroy();
	
	switch(nLineType)
	{
	case GROBJ_TN_LINE2:
		if(!add_line(m_gl, go))
			return -2;
		break;
	case GROBJ_TN_POLYLINE:
		go = m_gl.CreateGraphObject(GROBJ_TN_POLYLINE);
		if(!go)
			return -2;
		break;
	default:
			return -2;
		break;
	}
	//------end 
		
	if(pgo)
		*pgo = go;
	
	///Sandy 2008-12-9 add 
	if(!set_go_color(go, nColor))
		error_report("Fail to free line color in GraphObjTool::CreateAttachedFreeLine()");	
		
	set_go_selectable(go, false);
	// to do
	//m_attObjNames[CTP_FREE_1 + nPos] = go.GetName();
	///Sophy 1/4/2010 QA80-14916 LT_COMMAND_GET_ALL_CONNECTED_GRAPHOBJECTS
	//m_go.ConnectTo(go, -1, -1, false, 0);
	go.ConnectTo(m_go, -1, -1, false, 0); //make m_go as unique ROOT in the connected graphobject tree.
	///end LT_COMMAND_GET_ALL_CONNECTED_GRAPHOBJECTS
	saveClassInfo();
	
	return 0;
}
//--- end BASELINE_NEED_TO_BE_CONNECTED



/// YuI 09/23/08 by CP's request cleaning unnecesary code
//	#define MASTER "master"
/// end YuI 09/23/08 

// returns <0 for err, 1 if already existed and type correct then just get out, 0 if normal creation on empty slot
/*
int	GraphObjTool::CreateAttachment(int nObjType, int nPos, GraphObject* pgo, LPCSTR lpcszInitText, int nParam)
{
	if( !IsValidLayer() || !IsValidGrObj() || nPos >= CTP_SIZE || nObjType > GROBJ_TN_SCALER )
		return -1;
	//----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE
	//ASSERT( m_attObjNames[nPos].IsEmpty() ); //allow create objects on same position?
	GraphObject go;
	if(GetAttachment(nPos, go, nObjType) > 0)
	{
		// TO_DO to add code to compare type, if wrong type, will need to destroy it and continue
		// return 1 only if type is correct
		if(pgo)
			*pgo = go;
		return 1;
	}
	//-----
	go = m_gl.CreateGraphObject( nObjType );

	/// YuI 09/23/08 by CP's request cleaning unnecesary code
	/#
	/// Fisher 2008-9-19
	Tree tr;
	tr.master.strVal = m_go.GetName();
	go.PutBinaryStorage(MASTER, tr);
	/// End Fisher
	#/
	/// end YuI 09/23/08 
	
	if( nPos > CTP_AUTO ) //nPos > -1
		m_attObjNames[nPos] = go.GetName();
	bool bRet = connect_justify( m_go, go, nPos );
	if(pgo)
		*pgo = go;
	
	//----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE
	if(GROBJ_TN_TEXT == nObjType)
	{
		go.Text = lpcszInitText? lpcszInitText: " "; // must have something
		Tree tr;
		///---- Folger 09/24/08, Max suggestted default 18 font size is better, CPY added nParam
	 	//tr.Root.Font.Size.nVal = 14;
	 	///------ Folger 05/06/09 MAX_SUGGEST_BIGGER_FONT_SIZE_FOR_GRAPH_OBJ_TEXT
	 	//tr.Root.Font.Size.nVal = nParam > 0? nParam: 18;
	 	tr.Root.Font.Size.nVal = nParam > 0? nParam: 24;
	 	///------ End MAX_SUGGEST_BIGGER_FONT_SIZE_FOR_GRAPH_OBJ_TEXT
	 	///----
	 	tr.Root.States.nVal = GOC_NO_RESIZE | GOC_NO_ROTATE | GOC_NO_SKEW | GOC_NO_EDIT | GOC_NO_BORDERSIZE | GOC_NO_IN_PLACE_EDIT;//CPY 9/24/08 moved to here from curve_integ XF
	 	//----- CPY 9/24/08 CENTER_LABEL_ON_TOOL_AFTER_ROMAN_ADD_SUCH_SUPPORT
	 	if(nPos == CTP_TOP || CTP_BOTTOM == nPos)
	 		tr.Root.Alignment.Horizontal.nVal = 1;// center
	 	//-----
		go.UpdateThemeIDs(tr.Root);
		go.ApplyFormat(tr, true, true);
	}		
	// and need to save into binary storage
	saveClassInfo();
	//-----

	return bRet?0:-1;//need to continue...
}



// return 0 if not such obj in given position
// return -1 if nObjType >=
// return 1 if found obj
int		GraphObjTool::GetAttachment(int nPos, GraphObject& go, int nObjType)
{
	if( nPos < 0 || nPos >= CTP_SIZE || nObjType > GROBJ_TN_SCALER ) //Sophy, should not allow CTP_AUTO ?
		return -1;
	if( m_attObjNames[nPos].IsEmpty() )
		return 0;
	
	vector<uint>	vUIDs;
	if ( m_go.GetConnectedObjects( vUIDs ) > 0 )
	{
		GraphObject gotmp;
		for( int ii = 0; ii < vUIDs.GetSize(); ii++ )
		{	
			gotmp = Project.GetObject( vUIDs[ii] );
			if( gotmp.GetName().CompareNoCase(m_attObjNames[nPos]) == 0 )
			{
				go = gotmp;
				return 1;
			}
		}
	}
	return 0;
}
*/

///Sophy 1/11/2010 CLEAN_GRAPHOBJTOOL_CODE
int	GraphObjTool::CreateAttachment(GraphObject& go, int nObjID, int nPos, int nObjType, LPCSTR lpcszInitText, int nParam)
{
	go = m_gl.CreateGraphObject(nObjType);
	///Sophy 1/29/2010 ROI_ATTACHED_LINES_FAIL_TO_SET_POSITION_CORRECTLY_FOR_THE_FIRST_TIME
	if ( GROT_LINE == nObjType || GROT_POLYLINE == nObjType || GROT_POLYGON == nObjType ) ///Sophy 2/24/2010 quick fit preview curve
		go.Attach = ATTACH_TO_SCALE;
	///end ROI_ATTACHED_LINES_FAIL_TO_SET_POSITION_CORRECTLY_FOR_THE_FIRST_TIME
	
	if ( GROBJ_TN_TEXT == nObjType )
	{
		///Sophy 5/4/2011 ORG-2762 GROBJCURVETOOL_ATTACH_BUTTON_FORCE_ATTACH_TO_LAYER
		//on some PC, the default value of Attach is to Page, and that give bigger object size, so here should explicitly init it
		go.Attach = ATTACH_TO_LAYER;
		///end GROBJCURVETOOL_ATTACH_BUTTON_FORCE_ATTACH_TO_LAYER
		go.Text = lpcszInitText ? lpcszInitText : " ";
		Tree trFormat;
		trFormat.Root.Font.Size.nVal = nParam > 0 ? nParam : 16;
		trFormat.Root.States.nVal = GOC_NO_RESIZE | GOC_NO_ROTATE | GOC_NO_SKEW | GOC_NO_EDIT | GOC_NO_BORDERSIZE | GOC_NO_IN_PLACE_EDIT;
		if ( CTP_TOP == nPos || CTP_BOTTOM == nPos )
			trFormat.Root.Alignment.Horizontal.nVal = 1;
		///------ Folger 04/08/10 ROI_TEXT_LABEL_SHOULD_BE_WHITEOUT
		trFormat.Root.TextWhiteOut.nVal = 1;
		///------ End ROI_TEXT_LABEL_SHOULD_BE_WHITEOUT

		go.UpdateThemeIDs(trFormat.Root);
		go.ApplyFormat(trFormat, true, true);
	}
	go.SetName(GetAttObjName(nObjID));
	
	bool bRet = connect_justify(m_go, go, nPos, &m_gapCtrl);
	if ( nPos == CTP_RIGHT_TOP )
		m_nRightTopObjs++;
	
	///Sophy 01/23/10 QA80-15015 GROBJ_NEED_OPTION_CTRL_DELETE_OPERATION_UNDOABLE_OR_NOT
	string strLT;
	strLT.Format("%s.DelUndoable=0;", go.GetName());
	LT_execute(strLT);
	///end GROBJ_NEED_OPTION_CTRL_DELETE_OPERATION_UNDOABLE_OR_NOT
	
	return (bRet ? 0 : -1);
}

int		GraphObjTool::GetAttachment(GraphObject& go, int nObjID)
{
	string strObjName = GetAttObjName(nObjID);
	go = m_gl.GraphObjects(strObjName);
	if ( go )
		return 0;
	return -1;
}


///Sophy 1/14/2010 MOVE_CLOSE_BUTTON_TO_BASE_CLASS
//virtual
int		GraphObjTool::CreateAttachments()
{
	for ( int ii = 0; ii < m_vnObjIDs.GetSize(); ii++ )
	{
		GraphObject go;
		string strScript;
		switch ( m_vnObjIDs[ii] )
		{
		case GOT_OBJ_CLOSE:
			CreateAttachment(go, m_vnObjIDs[ii], CTP_INNER_RIGHT_TOP, GROT_TEXT, "\z(0)");
			//---- CPY 1/22/10 QA81-15020 CLOSE_BUTTON_USE_SIMPLER_LT_BASED_CODE
			//strScript.Format("run.section(graph_controls, GraphToolEvent, %s %s %d %d);", GetXFName(), m_go.GetName(), OE_BUTTONCLICK, GOT_BTN_CLOSE);
			strScript="run.section(graph_controls, OnROICloseButton)";
			//----
			set_LT_script(go, strScript, GRCT_MOUSEUP, 1);
			break;
		}
	}
	return 0;
}
//virtual
int		GraphObjTool::GetAttachments()
{
	int nRet = GetAttachment(m_goClose, GOT_OBJ_CLOSE);
	if ( 0 != nRet )
		return nRet;
	return 0
}
///end MOVE_CLOSE_BUTTON_TO_BASE_CLASS

string	GraphObjTool::GetAttObjName(int nObjID)
{
	string strObjName = "";
	int nObjIndex = find_in_list(nObjID, m_vnObjIDs, false);
	if ( nObjIndex >= 0 )
	{
		ASSERT(m_go);
		if ( m_go )
			strObjName += m_go.GetName();
		strObjName += m_vsObjNames[nObjIndex];
	}
	return strObjName;
}
///end CLEAN_GRAPHOBJTOOL_CODE


///Sandy 2008-12-23 move in GraphObjCurveTool class as member function
void GraphObjTool:: getBoundingBoxInfo(string& str)
{
	if(m_go)
	{
		if(m_gl)
		{
			FRECT frect;
			m_go.GetTempBoundingBox(&frect);
			/// Hong 02/01/10 QA80-14832 FIX_ROI_BOX_FAIL_DISPLAY_CORRECT_POSITION_IN_DATA_DISPLAY_DLG_WHEN_CREATE
			/*
			double x1 = m_gl.X.From;
			double x2 = m_gl.X.To;
			double xx1 = x1 + frect.left * (x2-x1);
			double xx2 = x1 + frect.right * (x2-x1);
			*/
			double		xx1 = frect.left, xx2 = frect.right;
			ASSERT( ATTACH_TO_PAGE != m_go.Attach );
			if ( ATTACH_TO_LAYER == m_go.Attach ) // return value of GetTempBoundingBox is in percentage
			{
				double 	x1 = m_gl.X.From;
				double 	x2 = m_gl.X.To;
				xx1 = x1 + frect.left * (x2-x1);
				xx2 = x1 + frect.right * (x2-x1);
			}
			/// end FIX_ROI_BOX_FAIL_DISPLAY_CORRECT_POSITION_IN_DATA_DISPLAY_DLG_WHEN_CREATE
			///Sophy 12/31/2009 QA80-14904-S2 BETTER_NOTATION_IN_DISPLAY_WINDOW_FOR_ROI_TOOLS
			//str.Format("x= %g - %g, dx= %g", xx1, xx2, xx2-xx1);
			str.Format("x= %g to %g, dx= %g", xx1, xx2, xx2-xx1);
			///end BETTER_NOTATION_IN_DISPLAY_WINDOW_FOR_ROI_TOOLS
		}
	}
}

///--------------------- end Sophy 9/13/2008 GRAPH_OBJ_TOOL_BASE_CLASS

//////////////////////////////////////////////////////////////////////////////////////////////////
/// Fisher 2008-9-13	GRAPH_OBJ_CURVE_TOOL
//////////////////////////////////////////////////////////////////////////////////////////////////
GraphObjCurveTool::GraphObjCurveTool(LPCSTR lpcszMainObjName) : GraphObjTool(lpcszMainObjName)
{
	//---- CPY 10/1/08 MOVE_DATA_DISPLAY_CODE_TO_BASE_CLASS
	m_i1 = m_i2 = -1;
	m_x1 = m_x2 = NANUM;
	//----
	m_vnObjIDs.Add(GOT_OBJ_LABEL);
	m_vsObjNames.Add("Label");
	
	m_vnObjIDs.Add(GOT_OBJ_CONTEXT);
	m_vsObjNames.Add("Context");
}

///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
//virtual
BOOL GraphObjCurveTool::Init(LPCSTR lpcszMainObjName)
{
	if ( !GraphObjTool::Init(lpcszMainObjName) )
		return false;
	
	if ( 0 != GetAttachments() )
		return false;
	
	///------ Folger 12/15/2010 ORG-1752-P1 QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG
	PreviewDataWksNameAccess(TRUE);
	///------ End QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG
	return true;
}
///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS

///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
//virtual
bool	GraphObjCurveTool::CheckROIVersion()
{
	double dCurVersion = GetVersion();
	double dOldVersion;
	Tree trGUI;
	if ( GetGUITree(trGUI) )
	{
		///Sophy 3/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
		string	strToolXFName; //if storage XFName not consistent with current XFName, should NOT check version
		if ( trGUI.GetAttribute(STR_XFNAME_ATTRIB, strToolXFName) && strToolXFName.CompareNoCase(GetXFName()) != 0 )
			return false;
		//end VERSION_CHECKING_FOR_ROI_COMPATIBILITY
		if ( !trGUI.GetAttribute(STR_VERSION_ATTRIB, dOldVersion) ) //if no attribute set, default as 8.0
			dOldVersion = 8.0;
		///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
		//if ( dOldVersion < dCurVersion )
		if ( (int)(dOldVersion * 10) != (int)(dCurVersion * 10) )
		///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
		{
			///Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE centralize code
			//roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET);
			///end ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
			string	strMsg = _L("The panel tool %s is incompatible with current Origin version.\nPlease remove it and add a new one from the Gadgets menu.");
			strMsg.Format(strMsg, GetPreferenceTitle());
			if ( !UpdateTopLabel(strMsg) ) //maybe the text not exist, should dump to script window.
			{
				LT_execute("type -a");
				///-----Kit 09/28/2011 ORG-3724-P5 GADGETS_MSG_NEED_DUMP_INFO_TO_SCRIPT_WIN_WHEN_SELECTED
				//out_str(strMsg);
				strMsg.Write(WRITE_SCRIPT_WINDOW);
				///-----End GADGETS_MSG_NEED_DUMP_INFO_TO_SCRIPT_WIN_WHEN_SELECTED
			}
		}
		///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
		else if ( dOldVersion < dCurVersion )
		{
			RemakeGUITree();
			CheckCreateAttachments();	///Sophy 4/14/2010 BACKWORD_COMPATIBILITY_SUPPORT_FOR_GADGET_ATTACHMENTS
			UpdateXScaleSettings(); ///Sophy 3/28/2011 ORG-2536-P2 COMPATIBILITY_ISSUE_ON_ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
		}
		///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
		return true;
	}
	return false;
}
bool	GraphObjCurveTool::SetVersion()
{
	double dCurVersion = GetVersion();
	Tree trGUI;
	if ( GetGUITree(trGUI) )
	{
		trGUI.SetAttribute(STR_XFNAME_ATTRIB, GetXFName());	///Sophy 3/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
		trGUI.SetAttribute(STR_VERSION_ATTRIB, dCurVersion);
		trGUI.SetAttribute(STR_MAINOBJ_NAME_ATTRIB, m_go.GetName());	///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
		SetGUITree(trGUI);
		return true;
	}
	return false;
}
///end VERSION_CHECKING_FOR_ROI_COMPATIBILITY

//------ CPY 10/1/08 MOVE_DATA_DISPLAY_CODE_TO_BASE_CLASS
/*
BOOL GraphObjCurveTool::GetData(DataPlot& dp, int& i1, int& i2)
{
	ASSERT(IsValidGrObj());
	if(!m_go) return false; // release level checking		
	return find_intersect_dataplot(m_go, dp, i1, i2);
*/
///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
//BOOL GraphObjCurveTool::GetData()
virtual BOOL GraphObjCurveTool::GetData(DWORD dwCtrl /*=GROBJ_DATA_DEFAULT*/)
///end ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
{
	ASSERT(IsValidGrObj());
	if(!m_go)
		return false; // release level checking			
	roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET);	///Jasmine 05/16/2011 ORG-2462-S6 REPOSITION_TOP_LABEL_ON_TOP_WHEN_DATA_CHANGE
	ROIToolOptionAccessHelper	clHelper(ROI_OPTION_IGNORE_EVENT);
	///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	//if(!find_intersect_dataplot(m_go, m_dp, m_i1, m_i2))
	int nNoMissing = 0;
	if( !find_intersect_dataplot(m_go, m_dp, m_i1, m_i2) || ((dwCtrl & GROBJ_SKIP_ALL_MASKED_DATA) && (nNoMissing = m_dp.GetDataPoints(m_i1, m_i2, m_vX, m_vY)) <= 0) )
	///end ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	{
		///Sophy 1/23/2010 MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
		string strHints = _L("No Data Selected");
		UpdateTopLabel(strHints);
		///end MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
		m_i1 = m_i2 = -1;
		return false;
	}
	///Sophy 1/25/2010 SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS
	///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	//else if ( (m_i2 - m_i1 + 1) < GetPointsLimit() )
	else if ( nNoMissing < GetPointsLimit() )
	///end ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	{
		string strHints = _L("%s requires at least %d points");
		strHints.Format(strHints, GetToolName(), GetPointsLimit());
		UpdateTopLabel(strHints);
		m_i1 = m_i2 = -1;
		return false;
	}
	///end SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS
	m_dp.GetDataPoint(m_i1, &m_x1, NULL);
	m_dp.GetDataPoint(m_i2, &m_x2, NULL);
	SetPlot(m_dp.GetIndex()); /// Iris 2/20/2010 QUICKFIT_SHOULD_USE_SELECTED_PLOT_NOT_ACTIVE_PLOT_AS_INPUT	
	return true;
}

/// YuI 10/09/08 QA70-12265-P3 CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER
///Sophy 12/14/2009 QA80-14686-P2 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
//BOOL GraphObjCurveTool::GetData(vector& vX, vector& vY)
BOOL GraphObjCurveTool::GetData(vector& vX, vector& vY, DWORD dwCtrl)
///end DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
{
	///Sophy 12/14/2009 QA80-14686-P2 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
	//return find_intersect_dataplot(m_go, m_dp, vX, vY);
	///Sophy 1/23/2010 MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
	//return find_intersect_dataplot(m_go, m_dp, vX, vY, true, dwCtrl);
	ROIToolOptionAccessHelper	clHelper(ROI_OPTION_IGNORE_EVENT);
	///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	//if ( !find_intersect_dataplot(m_go, m_dp, vX, vY, true, dwCtrl) )
	if ( !find_intersect_dataplot(m_go, m_dp, vX, vY, true, dwCtrl) || ((dwCtrl & GROBJ_SKIP_ALL_MASKED_DATA) && m_dp.GetDataPoints(m_go, m_vX, m_vY, NULL, dwCtrl) <= 0) )
	///end ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	{
		string strHints = _L("No Data Selected");
		UpdateTopLabel(strHints);
		return false;
	}
	///Sophy 1/25/2010 SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS
	else if ( vX.GetSize() < GetPointsLimit() )
	{
		string strHints = _L("%s requires at least %d points");
		strHints.Format(strHints, GetToolName(), GetPointsLimit());
		UpdateTopLabel(strHints);
		return false;
	}
	SetPlot(m_dp.GetIndex()); /// Iris 2/20/2010 QUICKFIT_SHOULD_USE_SELECTED_PLOT_NOT_ACTIVE_PLOT_AS_INPUT
	return true;
	///end MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
	///end DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
}
/// end CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER

///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
bool	GraphObjCurveTool::SetCloneMainObjName(LPCSTR lpcszName, LPCSTR lpcszTextName)
{
	Tree trInfo;
	tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
	trInfo.cloneROI.strVal = lpcszName;
	trInfo.cloneTextObj.strVal = lpcszTextName;
	tree_put_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
	
	return true;
}
bool	GraphObjCurveTool::GetCloneMainObjName(string& strName, string& strTextName)
{
	Tree trInfo;
	tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
	if ( trInfo.cloneROI )
	{
		strName = trInfo.cloneROI.strVal;
		strTextName = trInfo.cloneTextObj.strVal;
		return true;
	}
	return false;
}

static	void	_copy_format(const GraphObject& goSrc, GraphObject& goDst)
{
	if ( goSrc && goDst )
	{
#define	OBJ_FORMAT	(FPB_DIMENSION | FPB_STYLE | FPB_STYLE_FILL | FPB_OTHER | FPB_DATA)
		Tree trFmt;
		trFmt = goSrc.GetFormat(OBJ_FORMAT, FOB_ALL, true, true);
		goDst.ApplyFormat(trFmt, true, true);		
	}
}

///Sophy 4/9/2010 QA81-15290 QUICK_STATS_SHOW_PREVIEW_LINE_LABELS
//virtual
bool	GraphObjCurveTool::CloneAttachments(GraphObject& goCloneMain)
{
	if ( !goCloneMain )
		return false;
	//clone label object
	GraphObject gt;
	cloneObj(m_goLabel, gt);
	connectObj(goCloneMain, gt);
	
	SetCloneMainObjName(goCloneMain.GetName(), gt.GetName());
	
	return true;
}

bool	GraphObjCurveTool::CloneAndConnect(GraphObject& goCloneMain, GraphObject& goSrc)
{
	GraphObject gc;
	if ( cloneObj(goSrc, gc) )
		return connectObj(goCloneMain, gc);
	return false;
}

///Sophy 4/13/2010 SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU
bool	GraphObjCurveTool::InsertPopup(Menu& pm, uint nPosition, LPCSTR lpcszLabel, const vector<string>& vsItems, const vector<int>& vnCmdIDs, int nCheckIndex/* = -1*/)
{
	if ( vsItems.GetSize() != vnCmdIDs.GetSize() || vsItems.GetSize() == 0 )
		return false;
	
	Menu subMenu;
	for ( int iItem = 0; iItem < vsItems.GetSize(); iItem++ )
	{
		DWORD dwFlag = MF_STRING;
		if ( iItem == nCheckIndex )
			dwFlag |= MF_CHECKED;
		subMenu.Add(vsItems[iItem], vnCmdIDs[iItem], dwFlag);
	}
	pm.InsertPopup(nPosition, lpcszLabel, subMenu);
	return true;
}

bool	GraphObjCurveTool::InsertMenuItem(Menu& pm, uint nPosition, LPCSTR lpcszLabel, int nCmdID, UINT nFlags)
{
	pm.InsertMenu(nPosition, nFlags | MF_BYPOSITION, nCmdID, lpcszLabel);
	return true;
}

///end SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU


bool	GraphObjCurveTool::checkCloneMainObj()
{
	if ( IsCloneMainObj() && IsValidGrObj() )
	{
		//clone main object, without the script
		GraphObject gc;
		cloneObj(m_go, gc);
		
		//switch the index to keep orignial main object at the top for select and move again.
		int nIndexgo = m_go.GetIndex();
		int nIndexgc = gc.GetIndex();
		m_go.SetIndex(nIndexgc);
		gc.SetIndex(nIndexgo);
		///Sophy 3/30/2010 QA81-15217-S1 MORE_WORK_ON_CLONE_MAIN_OBJ
		disable_go_move(gc);
		CloneAttachments(gc);
		///end MORE_WORK_ON_CLONE_MAIN_OBJ
		MakePrintable(gc);	///Sophy 3/24/2010 QA80-15217-P1 MAKE_CLONED_MAIN_OBJECT_VISIBLE_PRINTIABLE
		m_gp.Refresh(); //refresh for better view of attachments of the main object.
		return true;
	}
	return false;
}

bool	GraphObjCurveTool::cloneObj(GraphObject& goSrc, GraphObject& goDst)
{
	if ( goSrc )
	{
		int nObjType;
		goSrc.GetObjectType(&nObjType);
		goDst = m_gl.CreateGraphObject(nObjType);
		if ( GROT_TEXT == nObjType )
			goDst.Text = goSrc.Text;
		_copy_format(goSrc, goDst);
		goDst.Attach = ATTACH_TO_SCALE;
		return true;
	}
	return false;
}

 //connect without justify, for cloned object
bool	GraphObjCurveTool::connectObj(GraphObject& goMain, GraphObject& go)
{
	if ( !goMain || !go )
		return false;
	RECT rectConfine = {-300, -300, 300, 300};
	return go.ConnectTo(goMain, CTP_AUTO, CTP_AUTO, FALSE, OCR_SITE2 | OCR_CNTRL_NOT_DRAW_EDGE_IF_UNSELECTABLE, &rectConfine);
}
///end QUICK_STATS_SHOW_PREVIEW_LINE_LABELS

bool	GraphObjCurveTool::updateLastCloneObjs()
{
	string strClonedObjName, strClonedTextName;
	if ( GetCloneMainObjName(strClonedObjName, strClonedTextName) )
	{
		GraphObject gc = m_gl.GraphObjects(strClonedObjName);
		GraphObject gt = m_gl.GraphObjects(strClonedTextName);
		if ( gc )
		{
			_copy_format(m_go, gc);
			///Sophy 3/30/2010 QA81-15217-S1 MORE_WORK_ON_CLONE_MAIN_OBJ
			disable_go_move(gc);
			if ( gt )
				gt.Text = m_goLabel.Text;
			///end MORE_WORK_ON_CLONE_MAIN_OBJ
			MakePrintable(gc);	///Sophy 3/24/2010 QA80-15217-P1 MAKE_CLONED_MAIN_OBJECT_VISIBLE_PRINTIABLE
			return true;
		}
	}
	return false;
}
///end CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS

///Sandy 2008-12-23 move in GraphObjCurveTool class as member function
void GraphObjCurveTool:: getBoundingBoxInfo(string& str)
{
	string str1, str2;
	///Sophy 1/7/2011 ORG-1845-S3 SHOW_MULTI_SELECTION_PLOTS_INFO_ON_DATA_DISPLAY_BOX
	if ( IsSupportMultiPlots() )
	{
		int nPlots = m_vsPlotLegend.GetSize();
		for ( int iPlot = 0; iPlot < nPlots; iPlot++ )
		{
			string strOnePlot;
			strOnePlot.Format("%s[%d:%d]", m_vsPlotLegend[iPlot], m_vI1[iPlot] + 1, m_vI2[iPlot] + 1);
			str1 += strOnePlot + "\n";
		}
	}
	else
	{
	///end SHOW_MULTI_SELECTION_PLOTS_INFO_ON_DATA_DISPLAY_BOX
		if(m_dp && m_i1 >=0 && m_i2 >=0)
		{
			string strLegend;
			m_dp.GetLegend(strLegend, NULL, false);
			str1.Format("%s[%d:%d]", strLegend, m_i1+1, m_i2+1);
		}
	}
	GraphObjTool::getBoundingBoxInfo(str2);
	
	str = str1 + "\n" +str2;
}

///-----Kit 02/14/2011 ORG-2229-P1 BRING_GADGET_TO_FONT_WHEN_SEL
bool	GraphObjCurveTool::OnSelect()
{	
	///-----Kit 02/17/2011 ORG-2229-P2 MOVE_ALL_RELATE_OBJS_TO_TOP_WHEN_SEL_ROI_OBJS
	m_go.MoveObject(MO_TOP);
	for(int ii = 0; ii < m_vnObjIDs.GetSize(); ++ii)
	{
		GraphObject go = m_gl.GraphObjects(GetAttObjName(m_vnObjIDs[ii]));
		if( !go.IsValid() )
		{
			if ( GOT_OBJ_NAME == m_vnObjIDs[ii] ) ///Sophy 3/1/2011 maybe "ToolName" GraphObject not created, since most case it is hidden, this is different from other attachments.
				continue; //this will skip the ASSERT
			ASSERT(false);
			continue;
		}

		go.MoveObject(MO_TOP);
	}
	///Sophy 5/6/2011 ORG-2783-P2 PROPER_REDRAW_ROI_WHEN_ONSELECT I don't think we need to redraw whole page here.
	//m_gp.Refresh();
	m_go.Invalidate();
	///end PROPER_REDRAW_ROI_WHEN_ONSELECT
	///-----End MOVE_ALL_RELATE_OBJS_TO_TOP_WHEN_SEL_ROI_OBJS
	return true;
}
///-----End BRING_GADGET_TO_FONT_WHEN_SEL

//virtual
BOOL GraphObjCurveTool::OnMove()
{
	
	string strMsg;
	//if(m_dp && m_i1 >=0 && m_i2 >=0)
	//{
		//string strLegend;
		//m_dp.GetLegend(strLegend, NULL, false);
		//strMsg.Format("%s[%d:%d]", strLegend, m_i1+1, m_i2+1);
	//}
	
	//_get_go_bounding_box_info(m_go, strMsg);
	getBoundingBoxInfo(strMsg);
	
	if(!strMsg.IsEmpty())
		SetDataDisplayText(strMsg);
	
	///Sophy 2/1/2010 SHOW_DATA_TIME_STAMP_WHEN_OUTPUT_TO_SCRIPT_WINDOW
	SYSTEMTIME st;
	get_current_time(st);
	double dDate;
	if ( SystemTimeToJulianDate(&dDate, &st) )
	{
		Tree tr;
		GetTree(tr);
		tr.OpDateTime.strVal = GetToolName() + "(" + get_date_str(dDate) + ")";
		SetTree(tr);
	}
	///end SHOW_DATA_TIME_STAMP_WHEN_OUTPUT_TO_SCRIPT_WINDOW
	/////----Sandy 2008-12-10 update status bar when moving is stop as well
	//string str;
	//get_go_bounding_box_info(m_go, str);
	///Sophy 1/20/2011 ORG-2068-S1 GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
	double dLeft, dRight, dTop, dBottom;
	GetRectCoordinate(dLeft, dRight, dTop, dBottom);
	double dYFrom = min(dTop, dBottom);
	double dYTo = max(dTop, dBottom);
	double dXFrom = min(dLeft, dRight);
	double dXTo = max(dLeft, dRight);
	PrevMainObjPositionAccess(&dXFrom, &dXTo, &dYFrom, &dYTo, false); //save last main object position
	///end GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT	
	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	UpdateXScaleSettings();
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	return GraphObjTool::OnMove();;
}
//----- end MOVE_DATA_DISPLAY_CODE_TO_BASE_CLASS

// return < 0 if no preview graph, 1 = initial show, 0 = already shown 
// this function will always check and create wks if has been deleted by user
int GraphObjCurveTool::CheckShowPreview()
{	
	if(m_strPreviewGraphName.IsEmpty())
		m_strPreviewGraphName = m_strGraphTemplate;

	if(m_strPreviewGraphName.IsEmpty())
		return -1; // pewview graph not needed
	
	ASSERT(!m_strPreviewDataWksName.IsEmpty());// for now, assume wks based, so with a graph, must have wks
	
	int nRet = 0;
	if(!m_glPreview)
	{
		GraphPage gp(m_strPreviewGraphName);
		if(!gp)
		{	
	   		gp.Create(m_strGraphTemplate);
	   		gp.SetName(m_strPreviewGraphName);
	   		gp.SetLongName(m_strPreviewGraphLongName);
	   		m_glPreview = gp.Layers(0); 
	   		nRet = 1;
		}
		else
			m_glPreview = gp.Layers(0);
	}
	if(CheckPreviewDataWks() > 0)
		nRet = 1;
	return nRet;
}

/// Fisher 9/16/2008
// return < 0 if no preview graph, 1 = initial show, 0 = already shown 
int		GraphObjCurveTool::CheckPreviewDataWks(bool bCreate)// = true)
{
	if(m_strPreviewDataWksName.IsEmpty())
		return -1; 		// no temp data wks
	
	if(!m_wks)	// Need temp worksheet
	{
		//---- CPY 7/20/09 QA70-13575 HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL
		//if(!m_wks.Attach(m_strPreviewDataWksName))
		if(!m_wks.Attach(m_strPreviewDataWksName) && bCreate)
		//----
		{
			WorksheetPage wp;
			wp.Create(NULL, CREATE_HIDDEN);
			///------ Folger 12/15/2010 ORG-1752-P1 QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG
			//wp.SetName(m_strPreviewDataWksName);
			wp.SetName(m_strPreviewDataWksName, OCD_ENUM_NEXT);
			m_strPreviewDataWksName = wp.GetName();
			PreviewDataWksNameAccess(FALSE);
			///------ End QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG
			wp.SetLongName(m_strPreviewDataWksLongName);
			m_wks = wp.Layers(0);
	   		return 1;
		}
	}

	return 0;
}

///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
/*
//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
///Sophy 8/21/2009 QA80-14175 CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
//int GraphObjCurveTool::Create(LPCSTR lpcszXFName, int color, DWORD dwCntrl, const TreeNode& trGUI)
int GraphObjCurveTool::Create(LPCSTR lpcszXFName, DWORD dwCntrl, const TreeNode& trGUI)
///end CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
{
	GraphPage gp = Project.Pages();
	if(!gp)	
		return -1;
	
	GraphLayer gl = gp.Layers(); //Layers(0);CPY 9/24/08 QA70-92268 GR_SHOULD_ALLOW_ON_MULTI_LAYER_GRAPH
	if(!gl)
		return -2;
	
	GraphObject go;
	double x0 = 25, y0 = 25, x1 = 70, y1 = 70;
	///Sophy 8/21/2009 QA80-14175 CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	//int nColor = SYSCOLOR_YELLOW;
	//if(color > 0)
		//nColor = okutil_ocolor_LT_color_convert(color, false);
	int nColor = trGUI.rectcolor.nVal;
	///end CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH

	int nDirection = (dwCntrl & GCTC_FREE_FORM_RECT)? LN_FREE:LN_VERTICAL;

	if(add_rect(gl, go, x0, y0, x1, y1, nColor, ATTACH_TO_LAYER, nDirection, true))	//  ATTACH_TO_SCALE, LN_VERTICAL
	{
		if(Attach(go.GetName()))
		{
			if(trGUI != NULL)
			{
				if(!SetGUITree(trGUI))
					return 2;
	}
			if(!Init())
				return 3;
			//CPY 10/1/08 QA70-12321 ADD_LT_WAY_TO_FORCE_XF_COMPILE,
			//string strXFFunc; strXFFunc.Format("%s_events", lpcszXFName);
			string strLT;strLT.Format("run.section(graph_controls,GraphTool,%%1 %s)", lpcszXFName);
			set_LT_script(go, strLT, GRCT_ANY_EVENT, 1);
			
			///Sophy 8/26/2009 QA80-14169 MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE
			MakePrintable(go); //if move this code before set_LT_script, will fail to make the rectangle printable, or lese we'll not need to virtual this function.
			///end MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE
			
			///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
			CheckAttachObjs();
			///end CLEAN_CODE_FOR_ROI_TOOLS
			OnMove();
			return 0;
		}
	}
	return 1;
}
*/
int GraphObjCurveTool::Create(LPCSTR lpcszXFName, DWORD dwCntrl, const TreeNode& trGUI, int nROIShape/* = SHAPE_RECT*/)
{
	GraphPage gp = Project.Pages();
	if(!gp)	
		return -1;
	m_gp = gp;

	GraphLayer gl = gp.Layers(); //Layers(0);CPY 9/24/08 QA70-92268 GR_SHOULD_ALLOW_ON_MULTI_LAYER_GRAPH
	if(!gl)
		return -2;
	m_gl = gl;
	
	GraphObject go;
	double x0 = 25, y0 = 25, x1 = 70, y1 = 70;
	
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	int nAttach = ATTACH_TO_LAYER;
	bool bPercent = true;
	double dLeftX, dRightX;
	bool bFixWidth = false; /// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	//if( CheckGetMainObjectXPositionFromGUITree(trGUI, dLeftX, dRightX) )
	///Sophy 3/5/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	//if( CheckGetMainObjectXPositionFromGUITree(trGUI, dLeftX, dRightX, bFixWidth) )
	double dBottomY = y0, dTopY = y1;
	///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	if ( !m_dp.IsValid() )
	{
		m_dp = m_gl.DataPlots(-1);//attach to active plot
	}
	///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	if( CheckGetMainObjectPositionFromGUITree(trGUI, dLeftX, dRightX, bFixWidth, dBottomY, dTopY) )
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	{
		nAttach = ATTACH_TO_SCALE;
		bPercent = false; // replace percent by scale
		x0 = dLeftX;
		x1 = dRightX;
		///Sophy 3/5/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
		y0 = dBottomY;
		y1 = dTopY;
		///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	}	
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	
	///Sophy 8/21/2009 QA80-14175 CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	//int nColor = SYSCOLOR_YELLOW;
	//if(color > 0)
		//nColor = okutil_ocolor_LT_color_convert(colr, false);
	
	///Sophy 1/18/2010 CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
	//int nColor = trGUI.rectcolor.nVal;
	int nColor = SYSCOLOR_YELLOW;
	TreeNode trColor = GetFillColorNode(trGUI);
	if ( trColor )
	{
		nColor = trColor.nVal;
		///Sophy 2/17/2011 ORG-2227-P1 MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
		if ( INDEX_COLOR_AUTOMATIC == nColor )
		{
			trColor.GetAttribute(STR_ATTRIB_AUTO_COLOR, nColor);
		}
		access_ROI_fill_color(m_gl, nColor, ROI_OP_SET);
		///end MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
	}
	///end CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
	///end CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	
	///Sophy 2/10/2010 QA81-15097 ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED
	//int nDirection = (dwCntrl & GCTC_FREE_FORM_RECT)? LN_FREE:LN_VERTICAL;
	int nDirection = (dwCntrl & GCTC_FREE_FORM_RECT) ? LN_FREE : (is_active_graphlayer_xyexchanged() ? LN_HORIZONTAL : LN_VERTICAL);
	///end ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED
				
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	//if(add_rect(gl, go, x0, y0, x1, y1, nColor, ATTACH_TO_LAYER, nDirection, true))	//  ATTACH_TO_SCALE, LN_VERTICAL
	///Sophy 3/4/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	//if(add_rect(gl, go, x0, y0, x1, y1, nColor, nAttach, nDirection, true, bPercent))	//  ATTACH_TO_SCALE, LN_VERTICAL
	///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	//bool bROICreated = false;
	//if ( SHAPE_RECT == nROIShape )
		//bROICreated = add_rect(gl, go, x0, y0, x1, y1, nColor, nAttach, nDirection, true, bPercent);
	//else if ( SHAPE_CIRCLE == nROIShape )
	//{
		/////Sophy 12/10/2010 ORG-1704-S7 SUPPORT_CREATE_ROI_OBJECT_AS_OVAL so no need to make it like a circle, if user want, they should provide correct position of the oval
		////bROICreated = add_circle(gl, go, (x0 + x1)/2, (y0 + y1)/2, (x1 - x0)/2, (y1 - y0)/2, nColor, SYSCOLOR_LTYELLOW, nAttach, bPercent);
		////go.Width = go.Height; //make it like a circle. 
		//bROICreated = add_ellipse(gl, go, x0, y0, x1, y1, nColor, nAttach, bPercent);
		/////end SUPPORT_CREATE_ROI_OBJECT_AS_OVAL
	//}
	BOOL bROICreated = CreateMainObj(go, x0, y0, x1, y1, nColor, nDirection, nROIShape);
	/////end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	if ( bROICreated )
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	{
		if(Attach(go.GetName()))
		{
			///Sophy 3/4/2011 ORG-2384-P1 NEED_RESET_TOOLS_ON_CREATE_GADGET_TOOL
			LT_execute("dotool 0");
			///end NEED_RESET_TOOLS_ON_CREATE_GADGET_TOOL
			set_go_behind_data(go);
			//set_go_user_deleteable(m_go, true);CPY 9/23/08 this is now done as part of set_LT_script

			/// YuI 09/24/08 QA70-12264 OPTION_TO_SELECT_GR_OBJECT_BEFORE_DATA
			set_go_hittest_before_data(go);
			/// end OPTION_TO_SELECT_GR_OBJECT_BEFORE_DATA

			///Sophy 12/27/2010 ORG-1844-P1 OPTION_TO_REMOVE_CONTEXT_MENU_FROM_ROI_BOX
			update_go_states(go, GOC_NO_CONTEXT);
			///end OPTION_TO_REMOVE_CONTEXT_MENU_FROM_ROI_BOX
			//CPY 10/1/08 QA70-12321 ADD_LT_WAY_TO_FORCE_XF_COMPILE,
			//string strXFFunc; strXFFunc.Format("%s_events", lpcszXFName);
			string strLT;strLT.Format("run.section(graph_controls,GraphTool,%%1 %s)", lpcszXFName);
			set_LT_script(go, strLT, GRCT_ANY_EVENT, 1);
			///Sophy 1/22/2010 QA80-14996 GR_OBJ_NEED_MOVE_EVENT_WHEN_UNDO_MOVE_OPERATION_FOR_QUICK_FIT
			strLT.Format("%s.UndoEvent=1;", go.GetName());
			LT_execute(strLT);
			///end GR_OBJ_NEED_MOVE_EVENT_WHEN_UNDO_MOVE_OPERATION_FOR_QUICK_FIT
			///Sophy 01/23/10 QA80-15015 GROBJ_NEED_OPTION_CTRL_DELETE_OPERATION_UNDOABLE_OR_NOT
			strLT.Format("%s.DelUndoable=0;", go.GetName());
			LT_execute(strLT);
			///end GROBJ_NEED_OPTION_CTRL_DELETE_OPERATION_UNDOABLE_OR_NOT
	
			///Sophy 8/26/2009 QA80-14169 MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE
			{
				ROIToolOptionAccessHelper	clHelper(ROI_OPTION_IGNORE_EVENT); ///Sophy 11/5/2010 ORG-1443 ROI_TOOL_NEED_IGNORE_ANY_EVENTS_WHEN_CREATING_MAIN_OBJ
				MakePrintable(go); //if move this code before set_LT_script, will fail to make the rectangle printable, or lese we'll not need to virtual this function.			
			}
			///end MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE
	
			referenceCount(true);//---- CPY 9/26/08 QA70-12266 ADDTOOL_XF_NEEDS_PROJ_VAR_TO_INDICATE_THEY_ARE_STILL_ACTIVE
			
			///-----Kit 02/14/2011 ORG-2229-P1 BRING_GADGET_TO_FONT_WHEN_SEL
			ASSERT(m_go.IsValid() && m_gl.IsValid());
			_update_roi_objs_tab_index(m_go, m_gl);
			///-----End BRING_GADGET_TO_FONT_WHEN_SEL

			if(trGUI != NULL)
			{
				///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
				UpdateAttribsInGUITree(trGUI);
				///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
				if(!SetGUITree(trGUI))
					return 2;
			}
			
			///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
			//CheckAttachObjs();
			if ( 0 != CreateAttachments() )
				return 3;
			
			if ( 0 != GetAttachments() )
				return 4;
			///end CLEAN_CODE_FOR_ROI_TOOLS			
			SetVersion();	///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY	
			
			set_ROI_main_obj_name(m_gl, GetXFName(), m_go.GetName()); ///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
			/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
			//OnMove();
			if( bFixWidth )
			{
				disable_go_move(go);
			}
			///Sophy 1/20/2011 ORG-2068-S1 GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
			///Sophy 8/9/2011 ORG-3459-P1 PROPER_ADD_GADGET_ACCORDING_TO_LAST_TOOL_POSITION
			/* //should not done here, but in check_get_roi_x_position
			//else //not fixed position, need to update position according to last ROI.
			//{
				//double dXFrom, dXTo, dYFrom, dYTo;
				//if ( PrevMainObjPositionAccess(&dXFrom, &dXTo, &dYFrom, &dYTo, true) ) //try to get
				//{
					////m_go.Attach = ATTACH_TO_SCALE; ///Sophy 4/22/2011 ORG-2606-P4 ATTACHMENTS_REFRESH_ISSUE_WHEN_CHANGE_ROI_POSITION_ON_CREATE
					//update_roi_position(m_go, dXFrom, dYFrom, dXTo, dYTo);
					//UpdateInnerAttachments(); ///Sophy 6/17/2011 ORG-3097-P1 UPDATE_ATTACHMENTS_POSITION_WHEN_MAINOBJ_POSITION_CHANGED_BY_CODE
					//m_gp.Refresh(TRUE); ///Sophy 4/22/2011 ORG-2606-P4 ATTACHMENTS_REFRESH_ISSUE_WHEN_CHANGE_ROI_POSITION_ON_CREATE
				//}
			//}
			*/
			///end PROPER_ADD_GADGET_ACCORDING_TO_LAST_TOOL_POSITION
			///end GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
			///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
			///Sophy 4/29/2010 ORG-59 REGION_STATS_GADGET_SHOULD_SEL_ALL_PLOTS_BY_DEFAULT
			//OnMove(); //this is done in DoDataCmd();
			DoDataCmd(GOT_DATAPLOT_ALL); //this will apply to all ROI tools that support selecting all curves, if other tools in the future do NOT want thsi logic, need to virtual a new function IsSelAllPlotsOnStats or something like this.
			///end REGION_STATS_GADGET_SHOULD_SEL_ALL_PLOTS_BY_DEFAULT
			OnStatsPlotsChange(MENU_CMD_DATAPLOT_ALL);	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
			
			return 0;
		}
	}
	return 1;
}

///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
void	GraphObjCurveTool::UpdateAttribsInGUITree(TreeNode& trGUI)
{
	XFExeContext*	pXFExecCtxt = Project.GetCurrentXFExeCtxt();
	if ( pXFExecCtxt )
	{
		Tree		tr;
		TreeNode	trGetN;
		if ( pXFExecCtxt->GetGUI(tr, trGetN) )
		{
			tree_node_copy_attribute(trGetN, trGUI, STR_THEME_FILE_ATTRIB);
			///------ Folger 03/23/2011 QA-528-P3 GADGET_PREFERENCE_DLG_WRONG_F1_MAPPING
			tree_node_copy_attribute(trGetN, trGUI, STR_HELPID_ATTRIB);
			///------ End GADGET_PREFERENCE_DLG_WRONG_F1_MAPPING
			UpdateBranchIDs(trGetN, trGUI);///Sophy 2/5/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS

		}
	}
	else
	{
		///Sophy 3/4/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL when debug is turn on and popup a message box, will affect the execution of ";label -rc Rect"
		//ASSERT(FALSE);
		///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	}
}

string	GraphObjCurveTool::GetCurrentThemeName()
{
	Tree	trGUI;
	if ( GetGUITree(trGUI) )
	{
		string		strThemeFile;
		if ( trGUI.GetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile) )
			return okutil_theme_file_to_display_name(strThemeFile);
	}

	return "";
}

///Sophy 2/5/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS
//virtual
bool	GraphObjCurveTool::UpdateBranchIDs(TreeNode& trGetN, TreeNode& trGUI)
{
	TreeNode trGetNGUI = trGetN.trGUI;
	if ( trGetNGUI && trGUI )
	{
		int nDataID, nRepeatID;
		if ( trGetNGUI.GetAttribute(STR_DATAID_ATTRIB, nDataID) && trGetNGUI.GetAttribute(STR_REPEAT_ID_ATTRIB, nRepeatID) )
		{
			trGUI.SetAttribute(STR_DATAID_ATTRIB, nDataID);
			trGUI.SetAttribute(STR_REPEAT_ID_ATTRIB, nRepeatID);
			return true;
		}
		ASSERT(FALSE); //never come here.
		return false;
	}
	return false;
}
///end FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS

/// virtual
bool	GraphObjCurveTool::UpdateThemeTree(TreeNode& trThemeTree)
{
	if ( !trThemeTree )
		return false;

	///Sophy 2/5/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_ID
	TreeNode trResults = trThemeTree.Results;
	if ( trResults )
		trResults.Remove();
	///end FAIL_TO_LOAD_THEME_WITH_DUPLICATED_ID
	
	string		strTheme = GetCurrentThemeName();
	if ( !strTheme.IsEmpty() && !IS_THEME_WITH_ORDER(strTheme) && theme_is_valid_name_for_save_as(strTheme) )
		trThemeTree.SetAttribute(STR_DEFAULT_THEME_NAME, strTheme);
	
	return true;
}
///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS

int	GraphObjCurveTool::CreateAttachments()
{
	int nRet = GraphObjTool::CreateAttachments();
	if ( 0 != nRet )
		return nRet;
	
	for ( int ii = 0; ii < m_vnObjIDs.GetSize(); ii++ )
	{
		string strScript;
		switch ( m_vnObjIDs[ii] )
		{
		case GOT_OBJ_LABEL:
			CreateAttachment(m_goLabel, m_vnObjIDs[ii], CTP_TOP, GROBJ_TN_TEXT, "No Data Selected");
			///Sophy 2/12/2010 MORE_CLEAN_CODE_TO_RESET_LABEL_POSITION
			roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET); //force reset position when init its contents.
			///end MORE_CLEAN_CODE_TO_RESET_LABEL_POSITION
			break;
			
		case GOT_OBJ_CONTEXT:
			CreateAttachment(m_goContext, m_vnObjIDs[ii], CTP_RIGHT_TOP, GROT_TEXT, "\z(12)");
			strScript.Format("run.section(graph_controls, GraphToolEvent, %s %s %d %d);", GetXFName(), m_go.GetName(), OE_BUTTONCLICK, GOT_BTN_CONTEXT);
			set_LT_script(m_goContext, strScript, GRCT_MOUSEUP, 1);
			break;
		}
	}
	CheckUpdateToolName();	///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
	return 0;
}

//virtual
int	GraphObjCurveTool::GetAttachments()
{
	int nRet = GraphObjTool::GetAttachments();
	if ( 0 != nRet )
		return nRet;
	
	nRet = GetAttachment(m_goLabel, GOT_OBJ_LABEL);
	if ( 0 != nRet )
		return nRet;
	
	nRet = GetAttachment(m_goContext, GOT_OBJ_CONTEXT);
	if  ( 0 != nRet )
		return nRet;
	
	return 0;
}


//virtual
void	GraphObjCurveTool::OnEvent(int nEvent, int nMsg)
{
	if ( QUERY_ROI_TOOL_OPTION(ROI_OPTION_IGNORE_EVENT) )
		return;
	
	///Sophy 2/23/2011 ORG-2313-P1 GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	if ( QUERY_ROI_TOOL_OPTION(ROI_OPTION_INGORE_THIS) )
	{
		uint nObjUID = roi_tool_option_access(0, ROI_OP_GET_THIS);
		uint nThisObjUID = m_go.GetUID();
		if ( nObjUID == nThisObjUID )
			return;
	}
	///end GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	
	switch(nEvent)
	{
	case OE_BUTTONCLICK:
		switch(nMsg)
		{
		//case GOT_BTN_PLOTS:
			//DoShowPlots();
			//break;
		//case GOT_BTN_OUTPUT:
			//DoOutput();
			//break;
		//case GOT_BTN_EDIT:
			//DoEdit();
			//break;
			//
		//case GOT_BTN_FUNCTION:
			//DoFunction();
			//break;
			
		case GOT_BTN_CONTEXT:
			//DoContext();
			ROI_DELAY_EXECUTE_EX(ROI_OPTION_DO_CONTEXT, OE_BUTTONCLICK, DoContext(), GOT_BTN_CONTEXT);
			break;
			
		///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
		case GOT_BTN_APPLY:
			UpdateROIGUI();
			break;
			
		///Sophy 12/17/2010 ORG-1783-S1 APPLY_BUTTON_ON_DATA_EDIT_DLG_SUPPORT
		case GOT_BTN_DATA_EDIT_APPLY:
			UpdateData();
			break;
		///end APPLY_BUTTON_ON_DATA_EDIT_DLG_SUPPORT
			
		default:
			out_int("Unknown button clicked. ID = ", nMsg);
			break;
		///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG

		}
		///Sophy 5/5/2011 ORG-2783 BUTTONCLICK_EVENT_SHOULD_NOT_TRIGGER_ONSELECT_EVENT
		break;//or else will run section OE_SELECT below
		///end BUTTONCLICK_EVENT_SHOULD_NOT_TRIGGER_ONSELECT_EVENT
	///-----Kit 02/14/2011 ORG-2229-P1 BRING_GADGET_TO_FONT_WHEN_SEL
	case OE_SELECT:
		OnSelect();
		break;
	///-----End BRING_GADGET_TO_FONT_WHEN_SEL
	default:
		//out_int("other even = ", nEvent);
	}
	if ( nEvent == 500 )
	{
		Tree trGUI;
		GetGUITree(trGUI);
	}
	GraphObjTool::OnEvent(nEvent, nMsg);
	///Sophy 1/6/2011 ORG-1932 PROPER_INIT_ATTACHMENTS_POSITION_ON_RESCALE_OR_RESIZE
	if ( OE_RESIZE == nEvent || OE_SCALE_CHANGE == nEvent )
		UpdateInnerAttachments();
	///end PROPER_INIT_ATTACHMENTS_POSITION_ON_RESCALE_OR_RESIZE
}

///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS


///Sophy 12/5/2011 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
static	int	_cvt_LT_data_index_to_cmd(int nLTDataIndex)
{
	int nCmd = 0;
	if ( nLTDataIndex == 0 )
		nCmd = GOT_DATAPLOT_ALL;
	else if ( nLTDataIndex > 0 )
	{
		nCmd = nLTDataIndex + GOT_DATAPLOT_BEGIN;
	}
	else
	{
		ASSERT(false);
	}
	return nCmd;
}
static	int	_cvt_LT_data_to_roi_op(int nLTOp)
{
	switch(nLTOp)
	{
	case GGTDATA_REMOVE:
		return ROI_OP_REMOVE;
	case GGTDATA_ADD:
		return ROI_OP_ADD;
	case GGTDATA_REPLACE:
		return ROI_OP_REPLACE;
	default:
		out_str("_cvt_LT_data_to_roi_op, case not handled!");
	}
	ASSERT(false);
	return ROI_OP_GET;
}
///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
//virtual
void	GraphObjCurveTool::OnMessage(GadgetMsgPtr pMsg)
{
	LTVarTempChange junk("@PTOC", 1); //temporarily allow cast ODWP to TreeNode*
	switch(pMsg->nMessage)
	{
	case GGT_DOOUTPUT:
		DoOutput(pMsg->wParam, pMsg->lParam);
		break;
	case GGT_DOEXPAND:
		ExpandFullRange();
		break;
	case GGT_GETGUITREE:
		TreeNode* pTr = (TreeNode*)(ODWP)pMsg->lpMoreInfo;
		if ( pTr && pTr->IsValid() )
			GetGUITree(*pTr);
		break;
	case GGT_SETGUITREE:
		TreeNode* pTr = (TreeNode*)(ODWP)pMsg->lpMoreInfo;
		if ( pTr && pTr->IsValid() )
			ApplyAfterEdit(*pTr); //call SetGUITree and update display.
		break;
	///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
	case GGT_LOADTHEME:
	case GGT_SAVETHEME:
		LPCSTR lpcszThemeName = (LPCSTR)(ODWP)(void*)pMsg->lpMoreInfo;
		string strThemeName(lpcszThemeName);
		strThemeName.TrimLeft("\"");
		strThemeName.TrimRight("\"");
		string strThemeFileName = okutil_theme_construct_filename(strThemeName, THTYPE_ANALYSIS, ORIGIN_PATH_USER, THTYPESCOPE_ANALYSIS_CLASS, GetXFName(), "", NULL);
		if ( GGT_SAVETHEME == pMsg->nMessage )
			SaveTheme(strThemeFileName);
		else
		{
			LoadTheme(strThemeName);
		}
		break;
	case GGT_SETDATA:
		int nCmd = _cvt_LT_data_index_to_cmd(pMsg->wParam);
		int nOp = _cvt_LT_data_to_roi_op(pMsg->lParam);
		DoDataCmd(nCmd, nOp | ROI_OP_LT);
		break;
	///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
	default:
		ASSERT(false);
		return;
	}
	return;
}

///------ Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
/// virtual
int	GraphObjCurveTool::OnGlobalGadget(int nMsg, LPARAM lParam)
{
	LTVarTempChange junk("@PTOC", 1);
	int				nReturn = -1;

	switch ( nMsg )
	{
	case GLOBALGADGET_GET_SETTING:
		{
			TreeNode*	ptrGUITree = (TreeNode*)lParam;
			nReturn = GetGUITree(*ptrGUITree) ? 0 : -1;
		}
		break;

	default:
		O_A_FAIL;
		break;
	}

	return nReturn;
}

/// virtual
int	GraphObjCurveTool::Create(TreeNode& trGUI)
{
	if ( !trGUI )
		return -1;

	GraphLayer	gl = Project.ActiveLayer();
	if ( !gl )
		return -2;

	int		nCount = gl.GraphObjects.Count();

	LT_execute(GetXFName());

	GraphObject	goMain = gl.GraphObjects(nCount);
	if ( !goMain )
		return -3;

	Init(goMain.GetName());
	return SetGUITree(trGUI) && UpdateROIGUI() ? 0 : -4;
}
///------ End GLOBAL_GADGET_MANAGER
///end LT_OBJ_TO_CONTROL_GADGET_TOOLS

///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
//bool	GraphObjCurveTool::CheckAttachObjs()
//{
	//CreateAdvancedButtons(GetXFName());
	//return true;
//}

///Sophy 1/22/2010 CENTRALIZE_OPEN_PREFERENCE_DIALOG_TO_BASE_CLASS
//since most ROI tool based on GetN have similar code to change parameter, I move it to base class, but still allow derived class to overwrite it as to do their own things.
//virtaul
bool	GraphObjCurveTool::DoEdit(HWND hWndParent/* = NULL*/)
{
	Tree trGUI;
	if ( !GetGUITree(trGUI) )
		return false;
	
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	///------ Folger 11/25/2010 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	if ( BranchAsTab() )
	{
		tr.trGUI.nVal = 1;
		tr.trGUI.Replace(trGUI, true, true, false);
		
		GADGET_GUI_FIRST_SUBNODES_AS_TABS(tr);
		///------ Folger 03/23/2011 QA-528-P3 GADGET_PREFERENCE_DLG_WRONG_F1_MAPPING
		tree_node_copy_attribute(trGUI, tr, STR_HELPID_ATTRIB);
		///------ End GADGET_PREFERENCE_DLG_WRONG_F1_MAPPING
	}
	else
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
		tr.Replace(trGUI, true, true, false);
	tr.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, GetXFName());
	///Sophy 9/6/2011 ORG-1931-P1 GADGET_PREFERENCE_DIALOG_THEME_SUPPORT
	tr.SetAttribute(STR_XFUNCTION_NAME_ATTRIB, GetXFName());
	string strThemeFile;
	if ( trGUI.GetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile) )
		tr.SetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile);
	///end GADGET_PREFERENCE_DIALOG_THEME_SUPPORT
	string strTitle;
	strTitle.Format("%s %s", GetPreferenceTitle(), STR_PREFERENCES);
	///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS
	//if ( GetNBox(tr, NULL, strTitle, "", hWndParent) )
	TreeNode trEvt;
	if ( tr.trGUI )
		trEvt = tr.trGUI.GetNode(STR_EVENT_HANDLE);
	else
		trEvt = tr.GetNode(STR_EVENT_HANDLE);
	GET_GETN_EVT(trEvt, pfnEvt)
	///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
	TreeNode trAppEvt;
	if ( tr.trGUI )
		trAppEvt = tr.trGUI.GetNode(STR_APPLY_EVT);
	else
		trAppEvt = tr.GetNode(STR_APPLY_EVT);
	GET_APPLY_EVT(trAppEvt, pfnAppEvt);
	bool bShowAppBtn = pfnAppEvt != NULL;
	///Kyle 12/28/2010 ORG-1736-S2 ALLOW_DISABLE_APPLY_BUTTON_ONLY_AFTER_CLICK_APPLY
	///Sophy 9/19/2011 ORG-1931-S1 GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
	//if( bShowAppBtn )
	///end GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
	{
		///Sophy 9/14/2011 ORG-3797-P1 GADGET_PREFERENCE_APPLY_BROKEN_AFTER_ADD_THEME_SUPPORT
		//tr.SetAttribute(STR_XF_BITS, DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY);
		///Sophy 9/19/2011 ORG-1931-S1 GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
		//DWORD dwXFBits = DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY | DYNALAYOUT_NO_EXECUTE_XF_ON_APPLY | DYNALAYOUT_NO_DESCRIPTION;
		DWORD dwXFBits = DYNALAYOUT_NO_EXECUTE_XF_ON_APPLY | DYNALAYOUT_NO_DESCRIPTION;
		if ( bShowAppBtn )
			dwXFBits |= DYNALAYOUT_CONTROL_APPLY_UNDO_BTN_STATUS_SEPARATELY;
		///end GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
		///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
		int nGUIXFBits = 0;
		if ( trGUI.GetAttribute(STR_XF_BITS, nGUIXFBits) && O_QUERY_BOOL(nGUIXFBits, DYNALAYOUT_THEME_MODIFIED_OUTSIDE) )
			dwXFBits |= DYNALAYOUT_THEME_MODIFIED_OUTSIDE;
		///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
		tr.SetAttribute(STR_XF_BITS, dwXFBits);
		///end GADGET_PREFERENCE_APPLY_BROKEN_AFTER_ADD_THEME_SUPPORT
	}
	///End ALLOW_DISABLE_APPLY_BUTTON_ONLY_AFTER_CLICK_APPLY

	///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
	if ( GetNBox(tr, pfnEvt, strTitle, "", hWndParent, bShowAppBtn, pfnAppEvt) )
	///end BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS
	{
		roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET);	///Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES
		///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
		//UpdateMainRect(tr);
		//SetGUITree(tr);
		//SetResultsTree(NULL);
		//OnMove();
		///------ Folger 11/29/2010 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
		///Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
		//if ( BranchAsTab() )
		//{
			/////------ Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
			////SetGUITree(tr.trGUI);
			//SetGUITreeUpdateLastUsed(tr.trGUI);
			/////------ End APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
		//}
		//else
		/////------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
			/////------ Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
			////SetGUITree(tr);
			//SetGUITreeUpdateLastUsed(tr);
			/////------ End APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
		TreeNode trGUI = tr;
		if ( BranchAsTab() && tr.trGUI )
			trGUI = tr.trGUI;
		
		///Sophy 9/6/2011 ORG-1931-P1 GADGET_PREFERENCE_DIALOG_THEME_SUPPORT
		if ( tr.GetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile) )
			trGUI.SetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile);
		///end GADGET_PREFERENCE_DIALOG_THEME_SUPPORT
		///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
		//SetGUITree(trGUI, true);
		/////end CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
		//UpdateROIGUI();
		ApplyAfterEdit(trGUI);
		///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
		///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
		return true;
	}
	return true;
}
///end CENTRALIZE_OPEN_PREFERENCE_DIALOG_TO_BASE_CLASS

///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
BOOL	GraphObjCurveTool::SaveTheme(LPCSTR lpcszThemeFile)
{
	string strThemeFileName(lpcszThemeFile);
	Tree tr;
	GetTree(tr);
	BOOL bSaved = theme_save_settings(tr, strThemeFileName);
	if( !bSaved )
		popup_errmsg_save_readonly_file(strThemeFileName, GetWindow() );
	GetGUITree(tr);
	tr.SetAttribute(STR_THEME_FILE_ATTRIB, strThemeFileName);
	SetGUITree(tr);
	UpdateGUIOnThemeChange(tr); //notify gadget dialog
	return bSaved;
}
BOOL	GraphObjCurveTool::LoadTheme(LPCSTR lpcszTheme)
{
	Tree	tr;
	GetTree(tr);
	tr.RemoveChild("Results");
	theme_update_on_new_sel(tr, lpcszTheme);
	SetTree(tr);
	roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET); //need to reset label position since top label parameters may changes.
	Tree	trGUI;
	GetGUITree(trGUI);
	string strThemeFileName = okutil_theme_construct_filename(lpcszTheme, THTYPE_ANALYSIS, ORIGIN_PATH_USER, THTYPESCOPE_ANALYSIS_CLASS, GetXFName(), "", NULL);
	trGUI.SetAttribute(STR_THEME_FILE_ATTRIB, strThemeFileName);
	UpdateGUIOnThemeChange(trGUI);
	SetGUITree(trGUI);
	UpdateROIGUI();
	return TRUE;
}
///end LT_OBJ_TO_CONTROL_GADGET_TOOLS

///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
/// virtual
void	GraphObjCurveTool::ApplyAfterEdit(TreeNode& trGUI)
{
	SET_MODIFIED_OUTSIDE(trGUI, false);	///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
	SetGUITree(trGUI, true);
	UpdateROIGUI();
}
///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET

///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
BOOL	GraphObjCurveTool::CreateMainObj(GraphObject& goMainObj, double dX0, double dY0, double dX1, double dY1, int nColor, int nDirection, int nShape)
{
	if ( !m_gl )
		return FALSE;
	int nType = (SHAPE_RECT == nShape) ? GROT_RECT : GROT_ELLIPSE;
	goMainObj = m_gl.CreateGraphObject(nType);
	goMainObj.Attach = ATTACH_TO_SCALE;
	
	vector vx(4), vy(4);
	vx[0] = dX0, vx[1] = dX1; vx[2] = dX1; vx[3] = dX0;
	vy[0] = dY0, vy[1] = dY0; vy[2] = dY1; vy[3] = dY1;
	
	Tree tr;
	tr.Root.Direction.nVal = 0;
	tr.Root.Span.nVal = 0;
	tr.Root.Data.X.dVals = vx;
	tr.Root.Data.Y.dVals = vy;
	tr.Root.Fill.Color.nVal = nColor;
	
	tr.Root.States.nVal = GOC_NO_ROTATE | GOC_NO_SKEW | GOC_NO_EDIT | GOC_NO_BORDERSIZE | GOC_NO_IN_PLACE_EDIT; //CPY 9/12/08 ADD_FFT_TOOL_XF_SHOULD_NOT_ALLOW_RECT_ROTATE_ETC	
	int nErr = goMainObj.UpdateThemeIDs(tr.Root);
	if ( 0 == nErr )
	{
		goMainObj.ApplyFormat(tr, TRUE, TRUE);
	}
	///Sophy, when layer is XY-Exchanged, if change Root.Diretion, and with ATTACH_TO_SCALE as object's attach properties, position & movement of the object is problematic
	goMainObj.Attach = ATTACH_TO_LAYER;
	Tree trFormat;
	trFormat.Root.Direction.nVal = nDirection;
	nErr = goMainObj.UpdateThemeIDs(trFormat.Root);
	if ( 0 == nErr )
	{
		goMainObj.ApplyFormat(trFormat, TRUE, TRUE);
	}
	return TRUE;
}

///end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
bool	GraphObjCurveTool::DoContext()
{
	//---- CPY 2/2/10 CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT
	//POINT pt;
	//GetCursorPos(&pt);
	//----
	
	uint nCurItemPos = 0;
	Menu pm;	
	pm.Add(STR_DO_OUTPUT, GOT_BTN_OUTPUT); nCurItemPos++;
	AddUpdateLastOutputSubmenu(pm, nCurItemPos); /// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	AddGotoReport(pm, nCurItemPos);
	AddGotoSource(pm, nCurItemPos);	///Sophy 1/4/2011 ORG-1889-S1 ADD_GOTO_SOURCE_WORKSHEET_CONTEXT_FOR_CLUSTER_TOOL

	pm.Add(NULL, 0, MF_SEPARATOR); nCurItemPos++;
	
	AddPlots(pm, nCurItemPos);
	pm.Add(STR_EXPAND_FULL_RANGE, GOT_BTN_EXPAND_FULL_RANGE, MF_STRING | (IsExpandable() ? 0 : MF_GRAYED)); nCurItemPos++;
	if ( IsAllowFullWidth() )
	{
		pm.Add(STR_EXPAND_HORIZONTAL, GOT_BTN_EXPAND_HORIZONTAL, MF_STRING | (IsExpandable() ? 0 : MF_GRAYED)); nCurItemPos++;
	}
	if ( IsAllowFullHeight() )
	{
		pm.Add(STR_EXPAND_VERTICAL, GOT_BTN_EXPAND_VERTICAL, MF_STRING | (IsExpandable() ? 0 : MF_GRAYED)); nCurItemPos++;
	}
	///Sophy 3/1/2011 ORG-2342-S1 GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
	if ( !IsSupportMultiPlots() ) //currently, only support those tool that NOT support multiple selection
	{
		DWORD dwFlag = MF_STRING;
		if ( !IsExpandable() )
			dwFlag |= MF_GRAYED;
		AddMarkers(pm, nCurItemPos, dwFlag);
	}
	///end GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION;
	///Sophy 1/6/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	if ( IsAllowLockedROI() )
	{
		int nLock = 0;
		UpdateGUILockNode(ROI_OP_GET, &nLock); //get lock state
		pm.Add(STR_LOCK_MAIN_OBJ, GOT_BTN_LOCKED, MF_STRING | ((1 == nLock) ? MF_CHECKED : 0)); nCurItemPos++;
	}
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	UpdateContextMenu(pm, nCurItemPos);
	pm.Add(NULL, 0, MF_SEPARATOR); nCurItemPos++;
	//AddDataEdit(pm, nCurItemPos); ///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL ///Sophy 12/30/2010 remove from context.
	pm.Add(STR_SAVE_THEME, GOT_THEME_SAVE);	nCurItemPos++; ///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	pm.Add(STR_SAVE_THEME_DEFAULT, GOT_THEME_SAVE_DEFAULT);	nCurItemPos++;	///Sophy 1/5/2011 ORG-1906-S2 GROBJTOOL_SAVE_DEFAULT_THEME_SUPPORT
	///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
	AddThemes(pm);
	///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
	pm.Add(STR_DO_EDIT, GOT_BTN_EDIT); nCurItemPos++;
	
	int nCmdID;
	//---- CPY 2/2/10 QA81-15066 CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT
	//int XAdj = m_goContext.Width * 0.1, YAdj = m_goContext.Height * 0.07;
	//pm.TrackPopupMenu(TPM_LEFTBUTTON | TPM_LEFTALIGN  , pt.x + XAdj, pt.y - YAdj, GetWindow(), &nCmdID);
	int nx = m_goContext.Left + m_goContext.Width;
	int ny = m_goContext.Top;
	
	nx += m_goContext.Width * 0.4;	///Sophy 2/3/2010 CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT add a gap for better view
	m_gp.LPtoDP(nx, ny);
	///Sophy 2/29/2012 ORG-5178-P1 CLIENT_TO_SCREEN_IN_GADGET_SHOULD_USE_VIEW_ISTEAD_OF_GRAPH_FRAME
	//Window wnd = m_gp.GetWindow();
	Window wnd = m_gp.GetWindow(-1); //minus value to get drawing window
	///end CLIENT_TO_SCREEN_IN_GADGET_SHOULD_USE_VIEW_ISTEAD_OF_GRAPH_FRAME
	RECT rr;
	rr.left = rr.right = nx;
	rr.top = rr.bottom = ny;
	wnd.ClientToScreen(&rr);
	pm.TrackPopupMenu(TPM_LEFTBUTTON | TPM_LEFTALIGN, rr.left, rr.top, wnd.GetSafeHwnd(), &nCmdID);
	//---- end CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT
	if ( nCmdID != 0 )
	{
		DWORD dwHigher = GOT_BTN_FIXED_MASK & nCmdID;
		if ( 0 == dwHigher )
		{
			if ( nCmdID > GOT_DATAPLOT_BEGIN && nCmdID < GOT_DATAPLOT_END )
			{
				DoDataCmd(nCmdID);
			}
			else if ( nCmdID > GOT_THEME_BEGIN && nCmdID < GOT_THEME_END )
			{
				DoThemeCmd(nCmdID);
			}
			///Sophy 3/1/2011 ORG-2342-S1 GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
			else if ( nCmdID > GOT_MARKER_BEGIN && nCmdID < GOT_MARKER_END )
			{
				DoMoveCmd(nCmdID);
			}
			///end GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
			///Sophy 8/10/2011 ORG-3496-P1 QUICK_FIT_SUBPOPUP_CONTEXT_MENU_NOT_CHECKED_PROPERLY
			else if ( nCmdID > GOT_FUNCTION_BEGIN && nCmdID < GOT_FUNCTION_END )
			{
				int nIndex = nCmdID - GOT_FUNCTION_BEGIN - 1;
				SetFunction(nIndex);
				OnMove();//
			}
			///end QUICK_FIT_SUBPOPUP_CONTEXT_MENU_NOT_CHECKED_PROPERLY
			else
			{
				switch(nCmdID)
				{
				/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
				case GOT_BTN_OUTPUT_MARKER_ONLY:
				/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
				case GOT_BTN_OUTPUT:
					/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
					//DoOutput();
					/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
					//if ( DoOutput(false) )
					if ( DoOutput(false, nCmdID == GOT_BTN_OUTPUT_MARKER_ONLY) )
					/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
					{
						checkCloneMainObj();	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
					}
					///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
					break;
					
				case GOT_BTN_EDIT:
					DoEdit();				
					break;
					
				case GOT_BTN_EXPAND_FULL_RANGE:
					DoExpand();
					break;
				case GOT_BTN_EXPAND_HORIZONTAL:
					ExpandHorizontal();
					break;
				case GOT_BTN_EXPAND_VERTICAL:
					ExpandVertical();
					break;
					
				///Sophy 1/6/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
				case GOT_BTN_LOCKED:
					OnLockROI();
					break;
				///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
				case GOT_BTN_FIT:
					DoFit();
					break;
					
				case GOT_BTN_FINDXY:
					DoFindXY();
					break;
					
				///Sophy 1/15/2010 ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
				case GOT_BTN_UPDATE_LIST:
					DoUpdateList();
					break;
				///end ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
									
				///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
				case GOT_BTN_GOTO_REPORT:
					DoActiveReport();
					break;
				///end ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
				///Sophy 1/4/2011 ORG-1889-S1 ADD_GOTO_SOURCE_WORKSHEET_CONTEXT_FOR_CLUSTER_TOOL
				case GOT_BTN_GOTO_SOURCE:
					OnActivateSource();
					break;
				///end ADD_GOTO_SOURCE_WORKSHEET_CONTEXT_FOR_CLUSTER_TOOL
				/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
				case GOT_BTN_UPDATE_LAST_OUTPUT:
					if ( DoOutput(true) )
					{
						updateLastCloneObjs();	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
					}
					break;
				///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU				
				case GOT_BTN_DATA_EDIT:
					DoEditData();
					OnMove();	///Sophy 6/11/2010 ORG-25-P3 UPDATE_RESULT_DIALOG_AFTER_EDIT_POINTS
					break;
				///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
				///Jasmine 06/08/2011 ORG-3016-S2 ADD_SHOW_ASYMPTOTES_TO_MENU
				case GOT_SHOW_ASYMPTOTES:
					DoShowAsyptotes();
					break;
				///End ADD_SHOW_ASYMPTOTES_TO_MENU
				default:
					ASSERT(false);
					break;
				}
			}
		}
		else
		{
			int	nIndex = (GOT_BTN_FLEX_MASK & nCmdID) - 1;
			switch(dwHigher)
			{
			case GOT_BTN_FUNCTION:
				///Sophy 8/10/2011 ORG-3496-P1 QUICK_FIT_SUBPOPUP_CONTEXT_MENU_NOT_CHECKED_PROPERLY
				//SetFunction(nIndex);
				ASSERT(false); //make sure should never come here any more.
				///end QUICK_FIT_SUBPOPUP_CONTEXT_MENU_NOT_CHECKED_PROPERLY
				break;

			///Kyle 03/08/2010 CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS
			case GOT_CMD_CUSTOM:
				{
					///Philip 09/05/2012 ORG-6662-S1 QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS
					//OnCmdCustom(nCmdID);
					if(!OnCmdCustom(nCmdID))
						return false; //do not update result
					///end QUICK_PEAKS_IMPROVE_SUBTRACT_BASELINE_EVENTS
				}
				break;
			///End CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS
			default:
				ASSERT(false);
				break;
			}
			OnMove(); //update result
		}
	}
	return true;
}

bool	GraphObjCurveTool::RemoveMenu(Menu& pm, uint& nPosition, uint nDeletePos) //0
{
	if ( 0 <= nDeletePos && nDeletePos <= nPosition && pm && pm.RemoveMenu(nDeletePos, MF_BYPOSITION) )
	{
		nPosition--;
		return TRUE;
	}
	return FALSE;
}
///Sophy 1/23/2010 MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
bool	GraphObjCurveTool::UpdateTopLabel(LPCSTR lpcszText, bool bShow) //true
{
	if ( !m_goLabel )
		return false;
	
	if ( NULL != lpcszText )
		m_goLabel.Text = lpcszText;

	///Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES
	if ( QUERY_ROI_TOOL_OPTION(ROI_OPTION_RESET_LABEL_POS) )
	{
		m_goLabel.Left = m_go.Left + (m_go.Width - m_goLabel.Width) / 2;
		m_goLabel.Top = m_go.Top - m_goLabel.Height;
		roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_REMOVE);
	}
	///end RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES
	m_goLabel.Show(bShow);
	return true;
}
///end MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL

///Sophy 4/12/2010 QA81-15290 LABELS_INSIDE_ROI_SHOULD_NOT_BE_WHITEOUT
bool	GraphObjCurveTool::SetLabelTransparent(GraphObject& goLabel)
{
	if ( !goLabel )
		return false;
	Tree trFormat;
	trFormat.Root.TextWhiteOut.nVal = 0;
	int nErr = goLabel.UpdateThemeIDs(trFormat.Root);
	if ( nErr != 0 )
		return false;
	return goLabel.ApplyFormat(trFormat, true, true);
}
///end LABELS_INSIDE_ROI_SHOULD_NOT_BE_WHITEOUT
///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
bool	GraphObjCurveTool::AddGotoReport(Menu& pm, uint& nPosition)
{	
	DWORD dwFlags = MF_STRING;
	Worksheet wks;
	if ( !GetReportWorksheet(wks) )
		dwFlags |= MF_GRAYED;
	pm.Add(STR_GOTO_REPORT, GOT_BTN_GOTO_REPORT, dwFlags); nPosition++;
	return true;	
}
///end ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
///Sophy 1/4/2011 ORG-1889-S1 ADD_GOTO_SOURCE_WORKSHEET_CONTEXT_FOR_CLUSTER_TOOL
bool	GraphObjCurveTool::AddGotoSource(Menu& pm, uint& nPosition)
{
	DWORD dwFlags = MF_STRING;
	Worksheet wks;
	if ( GetSourceWorksheet(wks) ) //allow goto source worksheet
	{
		pm.Add(STR_GOTO_SOURCE, GOT_BTN_GOTO_SOURCE, dwFlags); nPosition++;
	}
	return true;
}
///end ADD_GOTO_SOURCE_WORKSHEET_CONTEXT_FOR_CLUSTER_TOOL
///Sophy 3/1/2011 ORG-2342-S1 GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
int		GraphObjCurveTool::AddMarkers(Menu& pm, uint& nPosition, DWORD dwFlag)
{
	int nMarkers = 0;
	Menu mnMarkers;
	DataPlot dp;
	if ( GetSelectedPlot(dp) )
	{
		vector<int> vnBegin, vnEnd;
		if ( (nMarkers = dp.GetDataMarkers(vnBegin, vnEnd)) > 0 )
		{
			for ( int iMarker = 0; iMarker < nMarkers; iMarker++ )
			{
				string strLabel;
				strLabel.Format(_L("Marker%d"), iMarker + 1);
				mnMarkers.Add(strLabel, GOT_MARKER_BEGIN + iMarker + 1, dwFlag);
			}
			pm.AddPopup(_L("Move ROI to"), mnMarkers); nPosition++;
		}
	}
	return nMarkers;
}
///end GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION

int		GraphObjCurveTool::AddPlots(Menu& pm, uint& nPosition)
{
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	/*
	int nCurPlotIndex = -1;
	Tree trInfo;
	if ( tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.curPlotIndex )
	{
		nCurPlotIndex = trInfo.curPlotIndex.nVal;
	}
	else
		nCurPlotIndex = m_gl.DataPlots().GetIndex();
	*/	
	///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG
	//int nCurPlotIndex = -1;
	//DataPlot dpActive;
	//if( GetSelectedPlot(dpActive) )
		//nCurPlotIndex = dpActive.GetIndex();
	/////End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	//
	//Menu subMenu;
	//string strLabel;
	//vector<int> vI1;
	//vector<int> vI2;
	////DataPlot dpActive = m_gl.DataPlots(nCurPlotIndex); /// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	//if ( dpActive && dpActive.GetDataRegions(m_go, vI1, vI2) <= 0 )
	//{
		//nCurPlotIndex = -1;
	//}
	//
	//vector<string>	vsItems(0);
	//vector<int>		vnCmdIDs(0);
	//XYRange xySrc;
	//Column colY;
	//foreach(DataPlot dp in m_gl.DataPlots)
	//{
		//if ( IsPlotForROI(dp) )
		//{
			//if ( nCurPlotIndex < 0 ) //if previously active plot is not in region, should set another one as active
			//{
				//nCurPlotIndex = dp.GetIndex();
				///// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
				///*
				//trInfo.curPlotIndex.nVal = nCurPlotIndex;
				//tree_put_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
				//*/
				//SetPlot(nCurPlotIndex);
				/////End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
			//}
			//
			//string strName;
			/////Sophy 2/3/2010 ROI_CONTEXT_MENU_DATAPLOT_SHOW_LEGEND_AS_IN_NLFIT
			////dp.GetRangeString(strName, NTYPE_SHORT_NAME_ONLY | NTYPE_BOOKSHEET_XY_RANGE | NTYPE_ADD_ROW_RANGE);
			//dp.GetLegend(strName);
			/////end ROI_CONTEXT_MENU_DATAPLOT_SHOW_LEGEND_AS_IN_NLFIT
			//strLabel.Format("Plot(%d)\t%s", dp.GetIndex() + 1, strName);
			//vsItems.Add(strLabel);
			//vnCmdIDs.Add(GOT_BTN_PLOTS | (dp.GetIndex() + 1));
		//}
	//}
	//if ( vsItems.GetSize() > 1 )
	//{
		//uint nPosition = 0;
		//for ( int iItem = 0; iItem < vsItems.GetSize(); iItem++ )
		//{
			//DWORD dwFlag = MF_STRING;
			//if ( !GetMultiPlotsState() )
			//{
				//if ( vnCmdIDs[iItem] == (GOT_BTN_PLOTS | (nCurPlotIndex + 1)) ) //current plot
					//dwFlag |= MF_CHECKED;
			//}
				//
			//subMenu.Add(vsItems[iItem], vnCmdIDs[iItem], dwFlag); nPosition++;
		//}
		/////Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
		//UpdatePlotsMenu(subMenu, nPosition);
		/////end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	//}
	//else if ( vsItems.GetSize() == 1 )
		//subMenu.Add(vsItems[0], vnCmdIDs[0], MF_STRING | MF_GRAYED | MF_CHECKED);
	//
	//if ( vsItems.GetSize() > 0 )
	//{
		//pm.AddPopup(STR_SHOW_PLOTS, subMenu, GOT_BTN_PLOTS);
		//nPosition++;
	//}
	Menu subMenu;
	if ( ConstructPlotsMenu(subMenu) )
	{
		pm.AddPopup(STR_SHOW_PLOTS, subMenu, GOT_BTN_PLOTS);
		nPosition++;
	}
	///end SUPPORT_SEL_DATA_IN_GADGET_DLG
	return 0;
}

///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG
bool	GraphObjCurveTool::ConstructPlotsMenu(Menu& pm)
{
	vector<int> vnPlots;
	GetSelectedPlots(vnPlots);
	
	vector<string>	vsItems(0);
	vector<int>		vnCmdIDs(0);
	XYRange xySrc;
	Column colY;
	string strLabel;
	foreach(DataPlot dp in m_gl.DataPlots)
	{
		if ( IsPlotForROI(dp) )
		{		
			string strName;
			dp.GetLegend(strName);
			///Sophy 8/11/2011 ORG-3497-P1 GADGET_CONTEXT_MENU_FAIL_TO_SHOW_PLOT_NAME_IF_CONTAINS_TAB
			//strLabel.Format("Plot(%d)\t%s", dp.GetIndex() + 1, strName);
			strLabel.Format("Plot(%d)    %s", dp.GetIndex() + 1, strName);
			///end GADGET_CONTEXT_MENU_FAIL_TO_SHOW_PLOT_NAME_IF_CONTAINS_TAB
			okutil_ampersand_string_for_display(&strLabel, TRUE);
			vsItems.Add(strLabel);
			vnCmdIDs.Add(GOT_DATAPLOT_BEGIN | (dp.GetIndex() + 1));
		}
	}
	uint nPosition = 0;
	if ( vsItems.GetSize() > 0 )
	{
		for ( int iItem = 0; iItem < vsItems.GetSize(); iItem++ )
		{
			DWORD dwFlag = MF_STRING;
			int nPlotIndex = (vnCmdIDs[iItem] & ~(GOT_DATAPLOT_BEGIN)) - 1;
			if ( find_in_list(nPlotIndex, vnPlots, false) >= 0 )
			{
				dwFlag |= MF_CHECKED;
				if ( !IsSupportMultiPlots() && vnCmdIDs.GetSize() == 1 )
					dwFlag |= MF_GRAYED; //only one plot, disable selection
			}
				
			pm.Add(vsItems[iItem], vnCmdIDs[iItem], dwFlag); nPosition++;
		}
	}
	UpdatePlotsMenu(pm, nPosition);
	return nPosition > 0;
}
///end SUPPORT_SEL_DATA_IN_GADGET_DLG

bool	GraphObjCurveTool::ConstructThemesMenu(Menu& thm)
{
	vector<string>		vsThemes;
	vector<string>		vsFiles;
	/// Zech 09/05/2011 ORG-3492-P5 DISPLAY_EXE_FOLDER_THEMES_ON_GADGET_LOAD_THEME_FLYOUT
	//int					nCount = okutil_theme_get_class_settings(GetXFName(), &vsFiles, &vsThemes, THTYPE_ANALYSIS, TRUE, TRUE);
	int					nCount = okutil_theme_get_class_settings(GetXFName(), &vsFiles, &vsThemes, THTYPE_ANALYSIS, TRUE, TRUE, TRUE, FALSE, FALSE, TRUE, TRUE);
	/// END DISPLAY_EXE_FOLDER_THEMES_ON_GADGET_LOAD_THEME_FLYOUT
	if ( 0 == nCount )
	{
		thm.Add(_L("(&None)"), ID_THEME_NONE, MF_STRING | MF_GRAYED);
		return false;
	}
	
	int					nSel = vsThemes.Find(GetCurrentThemeName());
	vector<int>			vnCategories;
	okutil_prepare_theme_display_names(&vsThemes, &vnCategories, TRUE);
	int				nLastCategories = vnCategories[0];
	
	for ( int ii=0; ii<nCount; ++ii )
	{
		int nFlag = nSel == ii ? MF_CHECKED : MF_UNCHECKED;
		
		if ( nLastCategories != vnCategories[ii] )
		{
			thm.Add(NULL, 0, MF_SEPARATOR);
			nLastCategories = vnCategories[ii];
		}
		thm.Add(vsThemes[ii], GOT_THEME_BEGIN | (ii + 1), nFlag);
	}
	return true;
}

///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
//virtual
bool	GraphObjCurveTool::IsPlotForROI(const DataPlot& dp)
{
	///Kyle 03/15/2010 IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
	//return is_plot_for_ROI(dp, m_go);
	///Sophy 1/11/2011 ORG-1394-P4 ALLOW_FITTED_CURVE_FOR_COMMON_GADGET_EXCEPT_QUICKFIT
	//return is_plot_for_ROI(dp, m_go, STR_DATASETOBJ_FITCURVE);
	return is_plot_for_ROI(dp, m_go);	
	///end ALLOW_FITTED_CURVE_FOR_COMMON_GADGET_EXCEPT_QUICKFIT
	///End IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
}
//virtual
bool	GraphObjCurveTool::UpdatePlotsMenu(Menu& pm, uint& nPosition)
{
	if ( pm && IsSupportMultiPlots() )
	{
		if ( m_gl.DataPlots.Count() <= 0 ) //no plots
			return false;
		if ( nPosition > 0 )
			pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
		///Sophy 1/7/2011 ORG-1934-P4 STATS_DOES_NEED_SHOW_LOCKED_PLOTS_CONTROL_MENU
		if ( IsShowLockedPlotsMenu() )
		///end STATS_DOES_NEED_SHOW_LOCKED_PLOTS_CONTROL_MENU
		{
			DWORD dwStates = 0;
			UpdateROIState(dwStates, false);
			pm.Add(_L("Show Locked Analysis Plot(s)"), GOT_DATAPLOT_LOCKED, O_QUERY_BOOL(dwStates, GADGET_DATA_ALLOW_LOCKED) ? (MF_STRING | MF_CHECKED) : MF_STRING); nPosition++;
			pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
		}
		DWORD dwFlag = MF_STRING;
		if ( GetMultiPlotsState() )
			dwFlag |= MF_CHECKED;
		pm.Add(_L("All Plots"), GOT_DATAPLOT_ALL, dwFlag); nPosition++;
		///Sophy 6/10/2011 ORG-3046-S1 GADGET_NEW_DIALOG_FOR_SELECT_MULTIPLE_PLOTS
		pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
		///Jasmine 08/11/2011 ORG-3502 CHANGE_CUSTOMIZE_TEXT_TO_SELECT
		//pm.Add(_L("Customize..."), GOT_DATAPLOT_USER, MF_STRING); nPosition++;	
		pm.Add(_L("Select") + STR_THREE_DOTS, GOT_DATAPLOT_USER, MF_STRING); nPosition++;	
		///End CHANGE_CUSTOMIZE_TEXT_TO_SELECT
		///end GADGET_NEW_DIALOG_FOR_SELECT_MULTIPLE_PLOTS
		return true;
	}
	return false;
}

bool	GraphObjCurveTool::DoSelAllPlots()
{
	//return SetMultiPlotsState(!GetMultiPlotsState());
	if ( !GetMultiPlotsState() )
		SetMultiPlotsState(true);
	return true;
}

bool	GraphObjCurveTool::GetMultiPlotsState()
{
	if ( !IsSupportMultiPlots() )
		return false;
	Tree trInfo;
	if ( tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.allPlots )
	{
		int nState = trInfo.allPlots.nVal;
		return (1 == nState);
	}
	return false;
}

bool	GraphObjCurveTool::SetMultiPlotsState(bool bOn)
{
	if ( !IsSupportMultiPlots() )
		return false;
	int nState = bOn ? 1 : 0;
	Tree trInfo;
	tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
	trInfo.allPlots.nVal = nState;
	tree_put_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
	return true;
}

bool	GraphObjCurveTool::AddDataEdit(Menu& pm, uint& nPosition)
{
	if ( pm && IsSupportEditData() )
	{
		pm.Add(_L("Edit Data Points..."), GOT_BTN_DATA_EDIT, MF_STRING); nPosition++;
		pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
		return true;
	}
	return false;
}

enum {
	DATA_DELETE_ROW = 0,
	DATA_DELETE_XY,
	DATA_MASK,
	DATA_UNMASK,	///Sophy 12/17/2010 ORG-1783-S1 UNMASK_ON_DATA_EDIT_DLG_SUPPORT
	DATA_CLEAR,
	DATA_ZERO,
	DATA_SET_VALUE,
};
#define	DATA_OP_LIST	_L("Delete Whole Row|Apply Mask|Unmask|Clear Data|Set to 0|Set as")
enum {
	DATA_INNER_PTS = 0,
	DATA_OUTER_PTS = 1,
};
#define	DATA_REGION		_L("Inner Points|Outer Points")

static	bool	_on_operation_change(TreeNode& tr, int nRow, int nType, Dialog& Dlg)
{
	int nOp = tr.opera.nVal;
	tr.value.Show = (DATA_SET_VALUE == nOp);
	return true;
}
///Sophy 12/17/2010 ORG-1783-S1 APPLY_BUTTON_ON_DATA_EDIT_DLG_SUPPORT
typedef	struct {
	int	nOpera;
	int nDataRegion;
	double dNewVal;
} DataEditDlgBuffer, *DataEditDlgBufferPtr;
static	bool	_Edit_Data_Points_Setting_Access(int& nOpera, int& nDataRegion, double& dNewVal, int nOption)
{
	static	int	_nOpera;
	static	int	_nDataRegion;
	static	double	_dNewVal;
	static	DataEditDlgBufferPtr	pInfoBuffer = NULL;
	switch(nOption)
	{
	case ROI_OP_GET:
		if ( NULL == pInfoBuffer )
			return false;
		nOpera = pInfoBuffer->nOpera;
		nDataRegion = pInfoBuffer->nDataRegion;
		dNewVal = pInfoBuffer->dNewVal;
		break;
	case ROI_OP_SET:
		if ( NULL == pInfoBuffer )
			pInfoBuffer = new DataEditDlgBuffer;
		pInfoBuffer->nOpera = nOpera;
		pInfoBuffer->nDataRegion = nDataRegion;
		pInfoBuffer->dNewVal = dNewVal;
		break;
	case ROI_OP_RESET:
		NICE_SAFE_REMOVAL(pInfoBuffer);
		break;
	default:
		ASSERT(false);
		break;
	}
	return true;
}
static	int	_getn_Edit_Data_Points_handle(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{
	DECLARE_BUTTON_ENABLES

	if ( GETNE_ON_APPLY == nEvent )
	{
		bOKEnable = false;
		bApplyEnable = false;
	}
	return 0;
}
static	bool	_ROI_Edit_Data_Points_Apply(TreeNode& tr)
{
	string strLTCmd;
	string strXFName;
	string strMainObjName;
	if ( tr.GetAttribute(STR_XFNAME_ATTRIB, strXFName) && tr.GetAttribute(STR_MAINOBJ_NAME_ATTRIB, strMainObjName) )
	{
		int nOpera = tr.opera.nVal;
		int nDataRegion = tr.region.nVal;
		double dNewVal = tr.value.dVal;
		_Edit_Data_Points_Setting_Access(nOpera, nDataRegion, dNewVal, ROI_OP_SET);
		strLTCmd.Format("run.section(graph_controls.ogs, GraphToolEvent, %s %s %d %d);", strXFName, strMainObjName, OE_BUTTONCLICK, GOT_BTN_DATA_EDIT_APPLY);	
		LT_execute(strLTCmd);;
	}
	return true;
}
///end APPLY_BUTTON_ON_DATA_EDIT_DLG_SUPPORT
bool	GraphObjCurveTool::DoEditData(HWND hWndParent/* = NULL*/)
{
	int nUserID = GET_USER_DATAID(0);
	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_LIST(opera, _L("Data Points Operation"), 0, DATA_OP_LIST)	GETN_ID(nUserID++)	GETN_OPTION_EVENT(_on_operation_change)
	GETN_NUM(value, _L("Value"), 0)									GETN_ID(nUserID++)
	GETN_LIST(region, _L("Data Region"), 0, DATA_REGION)			GETN_ID(nUserID++)
	///Sophy 12/17/2010 ORG-1783-S1 APPLY_BUTTON_ON_DATA_EDIT_DLG_SUPPORT
	//if ( GetNBox(tr, NULL, _L("Edit Data Points"), NULL, hWndParent) )
	tr.SetAttribute(STR_XFNAME_ATTRIB, GetXFName());
	if ( m_go.IsValid() )
		tr.SetAttribute(STR_MAINOBJ_NAME_ATTRIB, m_go.GetName());
	if ( GetNBox(tr, _getn_Edit_Data_Points_handle, _L("Edit Data Points"), NULL, hWndParent, true, _ROI_Edit_Data_Points_Apply) )
	///end APPLY_BUTTON_ON_DATA_EDIT_DLG_SUPPORT
	{
		_ROI_Edit_Data_Points_Apply(tr);
		return true;
	}
	return false;
}


class	RemoveRowHelper
{
public:
	RemoveRowHelper(){}
	~RemoveRowHelper(){}
	void	Init()
	{
		m_vsWorksheetColNames.SetSize(0);
		m_vnColIndices.SetSize(0);
		m_vsWorksheetNames.SetSize(0);
		m_arrIndices.SetSize(0);
		m_arrIndices.SetAsOwner(true);
	}
	int		Add(LPCSTR lpcszWorksheetName, vector<int> vnIndices)
	{
		if ( NULL == lpcszWorksheetName || strlen(lpcszWorksheetName) == 0 )
			return -1;
		
		int nIndex = m_vsWorksheetNames.Find(lpcszWorksheetName);
		if ( nIndex < 0 )
		{
			nIndex = m_vsWorksheetNames.Add(lpcszWorksheetName);
			if ( nIndex < 0 )
				return nIndex; //error
			
			vector<int>* pp;
			pp = new vector<int>;
			*pp = vnIndices;
			m_arrIndices.Add(*pp);
			return nIndex;
		}
		vector<int>& vnIndicesNew = m_arrIndices.GetAt(nIndex);
		vnIndicesNew.Append(vnIndices);
		return nIndex;
	}
	int		AddOneColumn(LPCSTR lpcszWorksheetName, vector<int> vnIndices, int nColIndex)
	{
		string strKey;
		strKey.Format("%s_%d", lpcszWorksheetName, nColIndex);
		int nIndex = m_vsWorksheetColNames.Find(strKey);
		if ( nIndex < 0 )
		{
			m_vsWorksheetColNames.Add(strKey);
			m_vsWorksheetNames.Add(lpcszWorksheetName);
			m_vnColIndices.Add(nColIndex);
			vector<int>* pp;
			pp = new vector<int>;
			*pp = vnIndices;
			m_arrIndices.Add(*pp);
			return nIndex;
		}
		vector<int>& vnIndicesNew = m_arrIndices.GetAt(nIndex);
		vnIndicesNew.Append(vnIndices);
		return nIndex;
	}
	void	Handle(BOOL bWholeRow = TRUE)
	{
		int iWorksheet = 0;
		for ( iWorksheet = 0; iWorksheet < m_vsWorksheetNames.GetSize(); iWorksheet++ )
		{
			Worksheet wks(m_vsWorksheetNames[iWorksheet]);
			if ( wks )
			{
				vector<int>& vnIndices = m_arrIndices.GetAt(iWorksheet);
				if ( bWholeRow || m_vnColIndices.GetSize() == 0 )
				{
					///Sophy 12/2/2010 ORG-25-P9 SELECT_DUPLICATE_RANGES_MAKE_DELETE_SELECTION_ON_WRONG_RANGE
					//vnIndices.Sort(); //sort and delete from the end to delete multiple rows
					RemoveDuplicates(vnIndices);
					///end SELECT_DUPLICATE_RANGES_MAKE_DELETE_SELECTION_ON_WRONG_RANGE
					///Sophy 4/29/2010 ORG-59 DATAPOINTS_OPERATION_SHOULD_ALLOW_UNDO
					//for ( int iRowIndex = vnIndices.GetSize() - 1; iRowIndex >= 0; iRowIndex-- )
						//wks.DeleteRow(vnIndices[iRowIndex]);
					wks.SetSelectedRange(vnIndices);
					wks.DeleteSelection(true);
					///end DATAPOINTS_OPERATION_SHOULD_ALLOW_UNDO
				}
				else
				{
					vector<uint> vnTemp;
					vnTemp = vnIndices;
					wks.DeleteRows(vnTemp, m_vnColIndices[iWorksheet], m_vnColIndices[iWorksheet], WDR_USE_SELECTIONS | WDR_UNDO);
				}
			}
		}
	}
protected:
	///Sophy 12/2/2010 ORG-25-P9 SELECT_DUPLICATE_RANGES_MAKE_DELETE_SELECTION_ON_WRONG_RANGE
	void	RemoveDuplicates(vector<int>& vnIndices)
	{
		vector<int> vnTemp(0);
		vnIndices.Sort();
		int nPrev = -1000;
		int nSize = vnIndices.GetSize();
		for ( int ii = 0; ii < nSize; ii++ )
		{
			if ( vnIndices[ii] != nPrev )
			{
				nPrev = vnIndices[ii];
				vnTemp.Add(nPrev);
			}
		}
		vnIndices = vnTemp;
	}
	///end SELECT_DUPLICATE_RANGES_MAKE_DELETE_SELECTION_ON_WRONG_RANGE
private:
	vector<string>		m_vsWorksheetColNames;
	vector<int>			m_vnColIndices;
	vector<string>		m_vsWorksheetNames;
	Array<vector<int>&>	m_arrIndices;
};

RemoveRowHelper rrHelper;

static	bool	_update_data_one_plot(DataPlot& dp, GraphObject& gr, int nOpera, int nDataRegion, double dNewVal)
{
	if ( !dp || !gr )
		return false;
	
	vector<int> vnI1, vnI2;
	///Sophy 5/31/2011 ORG-2985-P1 GROBJCURVETOOL_GET_REGION_DATA_SHOULD_INCLUDE_BOUNDARY_POINTS
	//int nRegions = dp.GetDataRegions(gr, vnI1, vnI2);
	int nRegions = dp.GetDataRegions(gr, vnI1, vnI2, NULL, GDPS_CHECK_EDGE);
	///end GROBJCURVETOOL_GET_REGION_DATA_SHOULD_INCLUDE_BOUNDARY_POINTS
	if ( DATA_OUTER_PTS == nDataRegion ) //need to update region information
	{
		ASSERT(nRegions > 0);
		vector<int> vnI1Ex(0), vnI2Ex(0);
		if ( vnI1[0] > 0 )
		{
			vnI1Ex.Add(0);
			vnI2Ex.Add(vnI1[0] - 1);
		}
		for ( int iReg = 0; iReg < nRegions - 1; iReg++ )
		{
			vnI1Ex.Add(vnI2[iReg] + 1);
			vnI2Ex.Add(vnI1[iReg + 1] - 1);
		}
		int i1, i2;
		dp.GetRange(i1, i2);
		if ( vnI2[nRegions - 1] < i2 )
		{
			vnI1Ex.Add(vnI2[nRegions-1] + 1);
			vnI2Ex.Add(i2);
		}
		vnI1 = vnI1Ex;
		vnI2 = vnI2Ex;
		nRegions = vnI1.GetSize();
	}
	
	XYRange	rngXY;
	string	strY;
	if ( dp.GetDataRange(rngXY) && rngXY.GetDatasetNames(strY) )
	{
		for ( int iReg = nRegions - 1; iReg >= 0; iReg-- )
		{
			if ( DATA_SET_VALUE == nOpera )
			{
				///Sophy 4/29/2010 ORG-59 DATAPOINTS_OPERATION_SHOULD_ALLOW_UNDO
				//Dataset ds(strY);
				//if ( ds )
				//{
					//for ( int iPt = vnI1[iReg]; iPt <= vnI2[iReg]; iPt++ )
					//{
						//ds[iPt] = dNewVal;
					//}
				//}
				vector vX, vY;
				///Sophy 6/22/2010 ORG-25-P4 PROPER_SET_DATPOINTS_VALUE_WHEN_MASKED
				//rngXY.GetData(vY, vX);
				dp.GetDataPoints(0, -1, vX, vY);
				///end PROPER_SET_DATPOINTS_VALUE_WHEN_MASKED

				//update value by a sub range
				vector vSub;
				vY.GetSubVector(vSub, vnI1[iReg], vnI2[iReg]);
				vSub = dNewVal;
				vY.SetSubVector(vSub, vnI1[iReg]);
				
				rngXY.SetData(&vY, &vX, 0, NULL, DRS_KEEP_LARGER_DEST_SIZE | DRS_FORCE_UNDO);
				///end DATAPOINTS_OPERATION_SHOULD_ALLOW_UNDO
			}
			else if ( DATA_MASK == nOpera )
			{
				DatasetObject dsObj(strY);
				if ( dsObj )
				{
					///Sophy 4/29/2010 ORG-59 DATAPOINTS_OPERATION_SHOULD_ALLOW_UNDO
					//dsObj.SetMask(vnI1[iReg], vnI2[iReg]);
					dsObj.SetMask(vnI1[iReg], vnI2[iReg], false, true);
					///end DATAPOINTS_OPERATION_SHOULD_ALLOW_UNDO
				}
			}
			///Sophy 12/17/2010 ORG-1783-S1 UNMASK_ON_DATA_EDIT_DLG_SUPPORT
			else if ( DATA_UNMASK == nOpera )
			{
				vector<uint> vnIndices;
				vnIndices.Data(vnI1[iReg], vnI2[iReg], 1);
				Project.SetDatasetMasks(strY, vnIndices);
			}
			///end UNMASK_ON_DATA_EDIT_DLG_SUPPORT
			else if ( DATA_DELETE_ROW == nOpera )
			{
				Column colY;
				if ( rngXY.GetYColumn(colY) )
				{
					Worksheet wks;
					colY.GetParent(wks);
					wks.GetRangeString(strY);
					
					vector<int> vnIndices;
					vnIndices.Data(vnI1[iReg], vnI2[iReg], 1);
					rrHelper.Add(strY, vnIndices);
				}
			}
			else
			{
				ASSERT(FALSE);
				return false;
			}
		}
	}
	return true;
}
///Sophy 12/23/2010 ORG-1846-P2 SPEEDUP_DATA_MANIPULATION_ON_LARGE_DATA
static	bool	_faster_update_data_one_plot(DataPlot& dp, GraphObject& gr, int nOpera, int nDataRegion, double dNewVal)
{
	if ( !dp || !gr )
		return false;
	
	vector<int> vnI1, vnI2, vnAllInnerPoints, vnAllOuterPoints, vnDataPoints;
	///Sophy 5/31/2011 ORG-2985-P1 GROBJCURVETOOL_GET_REGION_DATA_SHOULD_INCLUDE_BOUNDARY_POINTS
	//int nRegions = dp.GetDataRegions(gr, vnI1, vnI2, &vnAllInnerPoints);
	///Sophy 2/3/2012 ORG-4677-P1 DATA_MANIPULATION_SHOULD_EXCLUDE_POINTS_ON_REGION_EDGE
	//int nRegions = dp.GetDataRegions(gr, vnI1, vnI2, &vnAllInnerPoints, GDPS_CHECK_EDGE);
	int nRegions = dp.GetDataRegions(gr, vnI1, vnI2, &vnAllInnerPoints);
	///end DATA_MANIPULATION_SHOULD_EXCLUDE_POINTS_ON_REGION_EDGE
	///end GROBJCURVETOOL_GET_REGION_DATA_SHOULD_INCLUDE_BOUNDARY_POINTS
	vnDataPoints = vnAllInnerPoints;
	if ( DATA_OUTER_PTS == nDataRegion ) //need to update region information
	{
		int i1, i2;
		dp.GetRange(i1, i2);
		vnAllOuterPoints.Data(i1, i2, 1);
		vnAllOuterPoints.RemoveAt(vnAllInnerPoints);
		vnDataPoints = vnAllOuterPoints;
	}
	vector<uint> vunDataPoints;
	vunDataPoints = vnDataPoints;
	XYRange	rngXY;
	string	strY;
	if ( dp.GetDataRange(rngXY) && rngXY.GetDatasetNames(strY) )
	{
		if ( DATA_SET_VALUE == nOpera )
		{
			vector vX, vY;
			///Sophy 1/7/2011-P1 DATAPLOT_GETDATAPOINTS_NEED_GET_VALUE_BEFORE_MASK
			//dp.GetDataPoints(0, -1, vX, vY);
			/// Hong 11/18/11 ORG-3527 PLOT_SUPPORT_SKIP_HIDDEN_ROW_IN_WKS
			//dp.GetDataPoints(0, -1, vX, vY, NULL, NULL, GETDATAPTS_BEFORE_MASK);
			dp.GetDataPoints(0, -1, vX, vY, NULL, NULL, GETDATAPTS_BEFORE_MASK | GETDATAPTS_BEFORE_WKS_HIDDEN_ROW);
			/// end PLOT_SUPPORT_SKIP_HIDDEN_ROW_IN_WKS
			///end DATAPLOT_GETDATAPOINTS_NEED_GET_VALUE_BEFORE_MASK
			vY.Replace(vunDataPoints, dNewVal);
			rngXY.SetData(&vY, &vX, 0, NULL, DRS_KEEP_LARGER_DEST_SIZE | DRS_FORCE_UNDO);
		}
		else if ( DATA_UNMASK == nOpera || DATA_MASK == nOpera )
		{
			Project.SetDatasetMasks(strY, &vnDataPoints, DATA_MASK == nOpera, TRUE);
		}
		else if ( DATA_DELETE_ROW == nOpera )
		{
			Column colY;
			if ( rngXY.GetYColumn(colY) )
			{
				Worksheet wks;
				colY.GetParent(wks);
				wks.GetRangeString(strY);
				rrHelper.Add(strY, vnDataPoints);
			}
		}
		else if ( DATA_DELETE_XY == nOpera )
		{
			Column colX, colY;
			if ( rngXY.GetXColumn(colX) && rngXY.GetYColumn(colY) )
			{
				Worksheet wks;
				colY.GetParent(wks);
				wks.GetRangeString(strY);
				
				rrHelper.AddOneColumn(strY, vnDataPoints, colY.GetIndex());
				rrHelper.AddOneColumn(strY, vnDataPoints, colX.GetIndex());
			}
		}
		else
		{
			ASSERT(FALSE);
			return false;
		}
	}
	return true;
}
///end SPEEDUP_DATA_MANIPULATION_ON_LARGE_DATA
bool	GraphObjCurveTool::UpdateData()
{
	///Sophy 12/20/2010 ORG-1783-P1 PREVENT_EVENTS_WHEN_DATA_CHANGED_BY_GADGET
	///Sophy 2/23/2011 ORG-2313-P1 GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	//ROIToolOptionAccessHelper	clHelper(ROI_OPTION_IGNORE_EVENT);
	ROIToolEventBlockHelper evtHelper(m_go.GetUID());
	///end GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	///end PREVENT_EVENTS_WHEN_DATA_CHANGED_BY_GADGET
	int nOpera;
	int nDataRegion;
	double dNewVal;
	if ( !_Edit_Data_Points_Setting_Access(nOpera, nDataRegion, dNewVal, ROI_OP_GET) )
		return false;
	
	UndoBlock ub;	///Sophy 4/29/2010 ORG-59 DATAPOINTS_OPERATION_SHOULD_ALLOW_UNDO
	
	if ( DATA_DELETE_ROW == nOpera || DATA_DELETE_XY == nOpera )
		rrHelper.Init();
	if ( DATA_CLEAR == nOpera )
	{
		dNewVal = get_missing_value();
		nOpera = DATA_SET_VALUE;
	}
	else if ( DATA_ZERO == nOpera )
	{
		dNewVal = 0;
		nOpera = DATA_SET_VALUE;
	}	
	vector<int> vnSelPlots;
	GetSelectedPlots(vnSelPlots);
	for ( int iSelPlot = 0; iSelPlot < vnSelPlots.GetSize(); iSelPlot++ )
	{
		DataPlot dp = m_gl.DataPlots(vnSelPlots[iSelPlot]);
		if ( dp )
		{
			_faster_update_data_one_plot(dp, m_go, nOpera, nDataRegion, dNewVal);
		}
	}

	if ( DATA_DELETE_ROW == nOpera || DATA_DELETE_XY == nOpera )
		rrHelper.Handle(DATA_DELETE_ROW == nOpera);
	
	int nBlockID = Project.UndoBlockId();
	UndoControl(UNDO_INCRE, &nBlockID); //add to undo block
	///Sophy 6/11/2010 ORG-25-P3 UPDATE_RESULT_DIALOG_AFTER_EDIT_POINTS
	m_gp.Refresh(TRUE);	
	LT_execute("sec -p 0.002");
	///end UPDATE_RESULT_DIALOG_AFTER_EDIT_POINTS
	_Edit_Data_Points_Setting_Access(nOpera, nDataRegion, dNewVal, ROI_OP_RESET); //clear temperary buffer.
	InvalidateResults(); //after edit data, need to invalidate the result according new data.
	return true;
}

bool	GraphObjCurveTool::OnSetPlot(int nIndex)
{
	SetMultiPlotsState(false);
	return SetPlot(nIndex);
}
///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL

bool	GraphObjCurveTool::SetPlot(int nIndex)
{
	Tree trInfo;
	tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
	trInfo.curPlotIndex.nVal = nIndex;
	tree_put_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);

	return true;
}

/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
virtual bool	GraphObjCurveTool::GetSelectedPlot(DataPlot& dp)
{
	int nCurPlotIndex = -1;
	Tree trInfo;
	if ( tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.curPlotIndex )
	{
		nCurPlotIndex = trInfo.curPlotIndex.nVal;	
	}
	else
	{
		/// Iris 2/20/2010 QUICKFIT_SHOULD_USE_SELECTED_PLOT_NOT_ACTIVE_PLOT_AS_INPUT
		//nCurPlotIndex = m_gl.DataPlots().GetIndex();
		nCurPlotIndex = m_dp? m_dp.GetIndex() : get_selected_data_plot();
		///End QUICKFIT_SHOULD_USE_SELECTED_PLOT_NOT_ACTIVE_PLOT_AS_INPUT
	}
	
	dp = m_gl.DataPlots(nCurPlotIndex);
	return dp.IsValid();
}
///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU

///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
//virtual
BOOL	GraphObjCurveTool::IsExpandable()
{
	Tree	trGUI;
	GetGUITree(trGUI);
	TreeNode	trFixed = trGUI.roi.XScale.fixscale;
	return !(trFixed && trFixed.nVal);
}
///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL

bool	GraphObjCurveTool::DoExpand()
{
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	/*
	int nCurPlotIndex = -1;
	Tree trInfo;
	if ( tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.curPlotIndex )
		nCurPlotIndex = trInfo.curPlotIndex.nVal;
	
	DataPlot dp = m_gl.DataPlots(nCurPlotIndex);
	*/
	DataPlot dp;
	GetSelectedPlot(dp);
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	if ( dp )
	{
		{
			ROIToolOptionAccessHelper		clHelper(ROI_OPTION_IGNORE_EVENT);

			///------ Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY
			DoExpand(dp);
			///------ End ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY
		}
		
		/// Iris 2/25/2010 FIX_EXPAND_FULL_RANGE_FIT_CURVE_UPWARD_MOVED
		//m_gp.Refresh();	///Sophy 2/11/2010 QA81-15104-P3 REFRESH_GRAPH_ON_ROI_EXPAND
		// set as true to redraw graph page after changed layer scale in DoExpand. If not redraw here, 
		// will cause draw Fit Curve based on the original layer scale.
		m_gp.Refresh(true); 
		///End FIX_EXPAND_FULL_RANGE_FIT_CURVE_UPWARD_MOVED
		///Sophy 4/29/2010 QUICKFIT_EXPAND_TO_FULL_RANGE_SHOULD_UPDATE_X_SCALE
		//graphobjtool_events(*this, m_go.GetName(), OE_RESIZE);
		graphobjtool_events(*this, m_go.GetName(), OE_RESIZE, GROBJEVENTS_FROM_EVENT_FUNCTION); //add GROBJEVENTS_FROM_EVENT_FUNCTION as quickfit do expand need to update X scale
		///end QUICKFIT_EXPAND_TO_FULL_RANGE_SHOULD_UPDATE_X_SCALE
	}

	return true;
}

/// Iris 2/25/2010 TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
// before expand rect, to check and change layer axis scale if data points outside layer, and get the rect's full range.
void	GraphObjCurveTool::BeforeExpandRect(DataPlot& dp, double& dMinX, double& dMaxX, double& dMinY, double& dMaxY)
{
	vector vX, vY;
	///Sophy 6/8/2010 ORG-48-P10 PROPER_GET_DATAPLOT_POINTS_FOR_EXPAND_FULL_RANGE
	//dp.GetDataPoints(0, -1, vX, vY);
	int nR1, nC1, nR2, nC2;
	DataRange dr;
	Datasheet dsht;
	dp.GetDataRange(dr);
	dr.GetRange(0, nR1, nC1, nR2, nC2, dsht);
	dp.GetDataPoints(nR1, nR2, vX, vY);
	///end PROPER_GET_DATAPLOT_POINTS_FOR_EXPAND_FULL_RANGE
	vX.GetMinMax(dMinX, dMaxX);
	vY.GetMinMax(dMinY, dMaxY);
	
	get_min_max_inc(dMinX, dMaxX, m_gl.X.Type, 0.08);
	get_min_max_inc(dMinY, dMaxY, m_gl.Y.Type, 0.02);
	if( dMinX < m_gl.X.From )
		m_gl.X.From = dMinX;
	if( dMaxX > m_gl.X.To )
		m_gl.X.To = dMaxX;
	if( dMinY < m_gl.Y.From )
		m_gl.Y.From = dMinY;
	if( dMaxY > m_gl.Y.To )
		m_gl.Y.To = dMaxY;
	
	// get x/y min and max with marge for rect size
	vX.GetMinMax(dMinX, dMaxX);
	vY.GetMinMax(dMinY, dMaxY);
	get_min_max_inc(dMinX, dMaxX, m_gl.X.Type, 0.04);
	get_min_max_inc(dMinY, dMaxY, m_gl.Y.Type, 0.01);	
}
///End TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE

///------ Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY
/// virtual
void	GraphObjCurveTool::DoExpand(DataPlot& dp)
{
	/// Iris 2/25/2010 TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
	/*
	vector vX, vY;
	dp.GetDataPoints(0, -1, vX, vY);
	double dMinX, dMaxX, dMinY, dMaxY;
	vX.GetMinMax(dMinX, dMaxX);
	vY.GetMinMax(dMinY, dMaxY);
	
	double dWidth = (dMaxX - dMinX);
	double dHeight = (dMaxY - dMinY);
	get_min_max_inc(dMinX, dMaxX, m_gl.X.Type, 0.08);
	get_min_max_inc(dMinY, dMaxY, m_gl.Y.Type, 0.02);
	m_gl.X.From = dMinX;
	m_gl.X.To = dMaxX;
	m_gl.Y.From = dMinY;
	m_gl.Y.To = dMaxY;
	
	//Sophy, need the following code as to better update m_go's position, if removed, m_gl.WorldToPage will get incorrect values
	m_go.Left = dMinX;
	m_go.Width = dWidth;
	m_go.Top = dMaxY;
	m_go.Height = dHeight;
	
	int nLeft, nTop, nRight, nBottom;
	vX.GetMinMax(dMinX, dMaxX);
	vY.GetMinMax(dMinY, dMaxY);
	get_min_max_inc(dMinX, dMaxX, m_gl.X.Type, 0.04);
	get_min_max_inc(dMinY, dMaxY, m_gl.Y.Type, 0.01);
	*/
	double dMinX, dMaxX, dMinY, dMaxY;
	BeforeExpandRect(dp, dMinX, dMaxX, dMinY, dMaxY);
	///Sophy 12/27/2010 ORG-1845-P1 CENTRALIZE_CODE_FOR_EXPAND_ROI_WITH_MULTI_PLOTS_SUPPORT
	vector<int> vnPlots;
	GetSelectedPlots(vnPlots);
	double dMinX2, dMaxX2, dMinY2, dMaxY2;
	for ( int iPlot = 0; iPlot < vnPlots.GetSize(); iPlot++ )
	{
		DataPlot dpMore = m_gl.DataPlots(vnPlots[iPlot]);
		if ( dpMore )
		{
			BeforeExpandRect(dpMore, dMinX2, dMaxX2, dMinY2, dMaxY2);
			if ( dMinX2 < dMinX )
				dMinX = dMinX2;
			if ( dMaxX2 > dMaxX )
				dMaxX = dMaxX2;
			if ( dMinY2 < dMinY )
				dMinY = dMinY2;
			if ( dMaxY2 > dMaxY )
				dMaxY = dMaxY2;
		}
	}
	///end CENTRALIZE_CODE_FOR_EXPAND_ROI_WITH_MULTI_PLOTS_SUPPORT
	///Sophy 4/8/2010 EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS
	/*
	//Sophy, need the following code as to better update m_go's position, if removed, m_gl.WorldToPage will get incorrect values
	m_go.Left = dMinX;
	m_go.Width = (dMaxX - dMinX);
	m_go.Top = dMaxY;
	m_go.Height = (dMaxY - dMinY);		
	
	int nLeft, nTop, nRight, nBottom;
	///End TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
	
	m_gl.WorldToPage(nLeft, nTop, dMinX, dMaxY);
	m_gl.WorldToPage(nRight, nBottom, dMaxX, dMinY);
	if ( is_active_graphlayer_xyexchanged() ) //need to exchange height and width
	{
		int nTemp;
		SWAP(nLeft, nRight, nTemp);
		SWAP(nTop, nBottom, nTemp);
	}

	m_go.Left = nLeft - 5;  //ten pixel margin as to include points on the edge.
	m_go.Top = nTop - 5;
	m_go.Width = abs(nRight - nLeft) + 10;
	m_go.Height = abs(nTop - nBottom) + 10;
	*/
	ExpandROI(dMinX, dMaxX, dMinY, dMaxY);
	///end EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS
}
///------ End ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY

///Sophy 4/8/2010 EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS
void	GraphObjCurveTool::ExpandROI(double dMinX, double dMaxX, double dMinY, double dMaxY)
{
	///Sophy 3/1/2011 ORG-2342-S1 GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION //just to make code consistent
	/////Sophy 5/5/2010 EXPAND_FULL_RANGE_SHOULD_DO_NOTHING_WHEN_ALL_POINTS_ARE_MISSING_VALUE
	//if ( is_missing_value(dMaxY - dMinY) || is_missing_value(dMaxX - dMinX) )
	//{
		//error_report("Fail to expand to full range, no valid data selected.");
		//return;
	//}
	/////end EXPAND_FULL_RANGE_SHOULD_DO_NOTHING_WHEN_ALL_POINTS_ARE_MISSING_VALUE
	//m_go.Left = dMinX;
	//m_go.Width = (dMaxX - dMinX);
	//m_go.Top = dMaxY;
	//m_go.Height = (dMaxY - dMinY);		
	//
	//int nLeft, nTop, nRight, nBottom;
	//m_gl.WorldToPage(nLeft, nTop, dMinX, dMaxY);
	//m_gl.WorldToPage(nRight, nBottom, dMaxX, dMinY);
	//
	//if ( is_active_graphlayer_xyexchanged() ) //need to exchange height and width
	//{
		//int nTemp;
		//SWAP(nLeft, nRight, nTemp);
		//SWAP(nTop, nBottom, nTemp);
	//}
//
	//m_go.Left = nLeft - 5;  //ten pixel margin as to include points on the edge.
	//m_go.Top = nTop - 5;
	//m_go.Width = abs(nRight - nLeft) + 10;
	//m_go.Height = abs(nTop - nBottom) + 10;	
	update_roi_position(m_go, dMinX, dMinY, dMaxX, dMaxY);
	///end GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
}
///end EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS

///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
bool	GraphObjCurveTool::DoActiveReport()
{
	Worksheet wks;
	if ( GetReportWorksheet(wks) )
	{
		wks.CheckShowActivate();
		return true;
	}
	return false;
}
///end ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
bool	GraphObjCurveTool::DoSaveTheme()
{
	Tree tr;
	GetTree(tr);
	UpdateThemeTree(tr);	///Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
	string strThemeFileName = theme_ask_save_as_filename(tr, GetWindow());
	if ( strThemeFileName.IsEmpty() )
		return false;
	///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
	//BOOL bSaved = theme_save_settings(tr, strThemeFileName);
	//if( !bSaved )
		//popup_errmsg_save_readonly_file(strThemeFileName, GetWindow() );
	//
	/////------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
	//GetGUITree(tr);
	//tr.SetAttribute(STR_THEME_FILE_ATTRIB, strThemeFileName);
	//SetGUITree(tr);
	/////------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
	//UpdateGUIOnThemeChange(tr); //notify gadget dialog
	//return bSaved;
	return SaveTheme(strThemeFileName);
	///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
}
///end ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS

///Sophy 1/5/2011 ORG-1906-S2 GROBJTOOL_SAVE_DEFAULT_THEME_SUPPORT
bool	GraphObjCurveTool::DoSaveThemeDefault()
{
	bool bSaved = false;
	Tree tr;
	GetTree(tr);
	tr.RemoveChild("Results");
	bSaved = theme_default_setting_management(tr, THEME_DEFAULT_SET);
	UpdateGUIOnThemeChange(tr); //notify gadget dialog
	return bSaved;
}
///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
bool	GraphObjCurveTool::CheckUpdateToolName()
{
	Tree trGUI;
	GetGUITree(trGUI);
	TreeNode trToolName = GetToolNameNode(trGUI);
	if ( trToolName )
	{
		m_vnObjIDs.Add(GOT_OBJ_NAME);
		m_vsObjNames.Add("ToolName");
		
		int nShow = 0;
		trToolName.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nShow);
		
		if ( nShow == 1 )
		{
			if ( GetAttachment(m_goToolName, GOT_OBJ_NAME) < 0 )
			{
				CreateAttachment(m_goToolName, GOT_OBJ_NAME, CTP_INNER_LEFT_TOP, GROT_TEXT, trToolName.strVal);
				SetLabelTransparent(m_goToolName);
				set_go_selectable(m_goToolName, false);
			}
			else
			{
				m_goToolName.Text = trToolName.strVal;
				connect_justify(m_go, m_goToolName, CTP_INNER_LEFT_TOP, &m_gapCtrl); //once the content changed, may need to justify again
				m_goToolName.Show(true);
			}
		}
		else
		{
			if ( GetAttachment(m_goToolName, GOT_OBJ_NAME) == 0 )
				m_goToolName.Show(false); //hide it.
		}
		
	}
	return true;
}
///end SHOW_TOOLNAME_FOR_ROI_TOOLS
//---- CPY 2/2/10 CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT
// this function seems no longer used, should be cleaned up
/*
bool	GraphObjCurveTool::DoShowPlots()
{
	int nCurPlotIndex = -1;
	Tree trInfo;
	if ( tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.curPlotIndex )
	{
		nCurPlotIndex = trInfo.curPlotIndex.nVal;
	}
	else
		nCurPlotIndex = m_gl.DataPlots().GetIndex();
	
	
	Menu pm;
	string strLabel;
	vector<int> vI1;
	vector<int> vI2;
	DataPlot dpActive = m_gl.DataPlots(nCurPlotIndex);
	if ( dpActive && dpActive.GetDataRegions(m_go, vI1, vI2) <= 0 )
	{
		nCurPlotIndex = -1;
	}
	XYRange xySrc;
	Column colY;
	foreach(DataPlot dp in m_gl.DataPlots)
	{
		if ( (dp.GetDataRegions(m_go, vI1, vI2) > 0) && dp.GetDataRange(xySrc) && xySrc.GetYColumn(colY) && !is_dataobj_tagged(colY, STR_DATASETOBJ_FITCURVE) ) 
		{
			if ( nCurPlotIndex < 0 ) //if previously active plot is not in region, should set another one as active
				nCurPlotIndex = dp.GetIndex();
			
			string strName;
			dp.GetRangeString(strName, NTYPE_SHORT_NAME_ONLY | NTYPE_BOOKSHEET_XY_RANGE | NTYPE_ADD_ROW_RANGE);
			strLabel.Format("Plot(%d)%s\t%s", dp.GetIndex() + 1, (nCurPlotIndex == dp.GetIndex() ? "*" : ""), strName);
			pm.Add(strLabel, dp.GetIndex() + 1);
		}
	}
	
	int nCmdID = 0;
	POINT pt;
	int XAdj = m_goPlots.Width * 0.1, YAdj = m_goPlots.Height * 0.07;
	GetCursorPos(&pt);
	pm.TrackPopupMenu(TPM_LEFTBUTTON | TPM_LEFTALIGN  , pt.x + XAdj, pt.y - YAdj, GetWindow(), &nCmdID);
	if ( nCmdID != 0 )
	{
		trInfo.curPlotIndex.nVal = nCmdID - 1;
		tree_put_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
		if ( nCmdID - 1 != nCurPlotIndex )
			OnMove(); //as to update result.
	}
	return true;
}
*/
//----- end CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT


bool	GraphObjCurveTool::UpdateInnerAttachments()
{
	CheckUpdateToolName();
	///Sophy 2/11/2010 QA81-15107 SUPPORT_EXTEND_POSITION_FOR_GRAPHOBJECT_CONNECT
#ifndef	__EXTEND_POSITION_FOR_GROBJ_CONNECT__
	return connect_justify(m_go, m_goClose, CTP_INNER_RIGHT_TOP, &m_gapCtrl);
#else
	///Sophy 3/1/2010 OC_WORKAROUND_FOR_CONNECTED_OBJ_WRONG_POSITION_ON_LAYER_RESIZE
#define	__CTP_POSITION_NOT_FIXED__
#ifdef	__CTP_POSITION_NOT_FIXED__
	connect_justify(m_go, m_goClose, CTP_INNER_RIGHT_TOP, &m_gapCtrl);
	connect_justify(m_go, m_goContext, CTP_RIGHT_TOP, &m_gapCtrl);
#else
	//do nothing
#endif	//__CTP_POSITION_NOT_FIXED__
	return true;
	///end OC_WORKAROUND_FOR_CONNECTED_OBJ_WRONG_POSITION_ON_LAYER_RESIZE
	return true;
#endif	//__EXTEND_POSITION_FOR_GROBJ_CONNECT__
}
///end CLEAN_CODE_FOR_ROI_TOOLS
///Sophy 8/21/2009 QA80-14175 CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
int	GraphObjCurveTool::UpdateMainRect(const TreeNode& trGUI)
{
	if ( !m_go )
		return 1;
	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	ROIToolOptionAccessHelper	clHelper(ROI_OPTION_IGNORE_EVENT);
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL

	Tree trFormat;
	trFormat = m_go.GetFormat(FPB_ALL, FOB_ALL, true, true);
	///Sophy 1/18/2010 CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
	//trFormat.Root.Fill.Color.nVal = trGUI.rectcolor.nVal;
	TreeNode trColor = GetFillColorNode(trGUI);
	if ( trColor )
	{
		///Sophy 2/17/2011 ORG-2227-P1 MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
		//trFormat.Root.Fill.Color.nVal = trColor.nVal;
		int nColor = trColor.nVal;
		if ( INDEX_COLOR_AUTOMATIC == nColor )
			trColor.GetAttribute(STR_ATTRIB_AUTO_COLOR, nColor);
		trFormat.Root.Fill.Color.nVal = nColor;
		///end MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
	}
	///end CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
	if ( m_go.ApplyFormat(trFormat, true, true) )
	{
		///Kyle 02/12/2011 ORG-2228-P1 GRAPH_OBJECT_GET_STATES_LOSE_GOC_EXPORT_PROGRAMMED, this bug is fixed in vc, no need to do this now
		//MakePrintable(m_go);	///Sophy 8/26/2009 QA80-14169 MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE when doEdit and if not set again, will not be printable
		///End GRAPH_OBJECT_GET_STATES_LOSE_GOC_EXPORT_PROGRAMMED
		///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
		CheckUpdateMainObjPosition();
		///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
		return 0;
	}
	return 1;
}
///end CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
///Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
//bool GraphObjCurveTool::SetGUITree(const TreeNode& trGUI)
bool GraphObjCurveTool::SetGUITree(const TreeNode& trGUI, bool bUpdateLastUsedTheme/* = false*/)
///end CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
{
	Tree tr;
	GetTree(tr);
	tr.GUI.Replace(trGUI.Clone(), true, true);
	///Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
	if ( bUpdateLastUsedTheme )
	{
		tr.RemoveChild("Results");
		theme_update_last_used(GetXFName(), tr);
	}
	///end CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
	return SetTree(tr);
}
bool GraphObjCurveTool::GetGUITree(Tree& trGUI)
{
	Tree tr;
	if ( GetTree(tr) )
	{
		trGUI = tr.GUI;
		///Sophy 11/26/2009 EVT_HANDLER_IN_TREENODE_INVALID_WHEN_RESTART_ORIGIN
		UpdateGUITree(trGUI);
		///end EVT_HANDLER_IN_TREENODE_INVALID_WHEN_RESTART_ORIGIN
		return trGUI.IsValid();
	}
	return false;
}

///------ Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
///Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
//BOOL	GraphObjCurveTool::SetGUITreeUpdateLastUsed(const TreeNode& trGUI)
//{
	//BOOL	bReturn = SetGUITree(trGUI);
	//if ( !bReturn )
		//return FALSE;
	//
	//string	strXF;
	//if ( !trGUI.GetAttribute(STR_XFNAME_ATTRIB, strXF) )
		//return FALSE;
//
	//Tree	tr;
	//GetTree(tr);
	//tr.RemoveChild("Results");
	//theme_update_last_used(strXF, tr);
	//return TRUE;
//}
///end CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
///------ End APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
///Sophy 3/1/2011 ORG-2342-S1 GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
BOOL	GraphObjCurveTool::DoMoveCmd(int nCmdID)
{
	int nMarkers = 0;
	Menu mnMarkers;
	DataPlot dp;
	if ( GetSelectedPlot(dp) )
	{
		int iMarker = nCmdID - GOT_MARKER_BEGIN - 1;
		vector<int> vnBegin, vnEnd;
		if ( (nMarkers = dp.GetDataMarkers(vnBegin, vnEnd)) > 0 && iMarker >= 0 && iMarker < nMarkers)
		{
			double dX1, dY1, dX2, dY2;
			dp.GetDataPoint(vnBegin[iMarker], &dX1, &dY1);
			dp.GetDataPoint(vnEnd[iMarker], &dX2, &dY2);
			double dXFrom = min(dX1, dX2);
			double dXTo = max(dX1, dX2);
			double dYFrom = min(dY1, dY2);
			double dYTo = max(dY1, dY2);
			{
				ROIToolOptionAccessHelper		clHelper(ROI_OPTION_IGNORE_EVENT);
				update_roi_position(m_go, dXFrom, dYFrom, dXTo, dYTo);
			}
			///Sophy 3/3/2011 ORG-2342-P1 DELAY_CALCULATION_WHEN_CHANGE_ROI_POSITION_BY_CODE
			//graphobjtool_events(*this, m_go.GetName(), OE_RESIZE, GROBJEVENTS_FROM_EVENT_FUNCTION); 
			//I do NOT want to use DelayTranslateMessage(OE_RESIZE, GROBJEVENTS_FROM_EVENT_FUNCTION); since it gets flashing
			graphobjtool_events(*this, m_go.GetName(), OE_SCALE_CHANGE, GROBJEVENTS_FROM_EVENT_FUNCTION); 
			///end DELAY_CALCULATION_WHEN_CHANGE_ROI_POSITION_BY_CODE
		}
	}	
	return false;
}
///end GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
//BOOL	GraphObjCurveTool::DoDataCmd(int nCmdID)
BOOL	GraphObjCurveTool::DoDataCmd(int nCmdID, DWORD dwCtrl/* = 0*/)
///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
{
	/// Hong 01/14/11 ORG-1944-P2 FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA
	if ( !OnBeforePlotChanged() )
		return FALSE;
	/// end FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA
	vector<int> vnPlots(0);
	if ( GOT_DATAPLOT_ALL == nCmdID )
	{
		///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
		//SetMultiPlotsState(!GetMultiPlotsState()); //flip	
		if ( O_QUERY_BOOL(dwCtrl, ROI_OP_LT) )
		{
			int nOp = dwCtrl & ROI_OP_MASK;
			SetMultiPlotsState(ROI_OP_REMOVE != nOp);
		}
		else
		{
			SetMultiPlotsState(!GetMultiPlotsState()); //flip
		}
		///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
		if ( GetMultiPlotsState() && m_gl.IsValid() )
		{
			foreach(DataPlot dp in m_gl.DataPlots)
			{
				if ( IsPlotForROI(dp) )
				{
					vnPlots.Add(dp.GetIndex());
				}
			}
		}
	}
	else if ( GOT_DATAPLOT_LOCKED == nCmdID )
	{
		GetSelectedPlots(vnPlots); //keep selected plots
		DWORD dwState;
		UpdateROIState(dwState, false);
		O_TOGGLE_BIT(dwState, GADGET_DATA_ALLOW_LOCKED);
		UpdateROIState(dwState, true);
		for ( int iPlot = 0; iPlot < vnPlots.GetSize(); iPlot++ )
		{
			DataPlot dp = m_gl.DataPlots(vnPlots[iPlot]);
			if ( !IsPlotForROI(dp) )
			{
				vnPlots.RemoveAt(iPlot);
				iPlot--;
			}
		}
	}
	///Sophy 6/10/2011 ORG-3046-S1 GADGET_NEW_DIALOG_FOR_SELECT_MULTIPLE_PLOTS
	else if ( GOT_DATAPLOT_USER == nCmdID )
	{
		GetSelectedPlots(vnPlots);
		int nPlots = vnPlots.GetSize();
		GETN_TREE(trUser);
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		GETN_BEGIN_BRANCH(DataPlots, _L("Plots")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN | GETNBRANCH_CHECK_CONTROL)
			foreach(DataPlot dp in m_gl.DataPlots)
			{
				if ( IsPlotForROI(dp) )
				{		
					string strName, strLabel;
					dp.GetLegend(strName);
					strLabel.Format("Plot(%d)    %s", dp.GetIndex() + 1, strName);
					int nCheck = find_in_list(dp.GetIndex(), vnPlots, false) >= 0 ? 1 : 0;
					GETN_CHECK(Plot, strLabel, nCheck) GETN_ID(dp.GetIndex() + 1); //use DataID as Plot Index
				}
			}		
		GETN_END_BRANCH(DataPlots)
		if ( !GetNBox(trUser, _L("Select Plots")) )
			return FALSE; //if cancel, not need to do anything.
		vnPlots.RemoveAll();
		foreach(TreeNode trPlot in trUser.DataPlots.Children)
		{
			if ( trPlot.nVal ) //checked
			{
				vnPlots.Add(trPlot.DataID - 1);
			}
		}
		SetMultiPlotsState(vnPlots.GetSize() == nPlots && GetMultiPlotsState() );
	}
	///end GADGET_NEW_DIALOG_FOR_SELECT_MULTIPLE_PLOTS
	///Sophy 2/14/2011 ORG-2225-P1 CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
	else if ( GOT_DATAPLOT_INNER == nCmdID || GOT_DATAPLOT_OUTER == nCmdID )
	{
		GetSelectedPlots(vnPlots);
		DWORD dwState;
		UpdateROIState(dwState, false);
		O_SET_BIT(dwState, GADGET_EDIT_INNER_POINTS, GOT_DATAPLOT_INNER == nCmdID);
		UpdateROIState(dwState, true);
	}
	///end CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
	///Sophy 1/4/2011 ORG-1895-P1 FAIL_TO_SELECT_PLOT_WHEN_NOT_SUPPORT_MULTI_SEL_MODE
	else if ( !IsSupportMultiPlots() )
	{
		int	nIndex = nCmdID - GOT_DATAPLOT_BEGIN - 1;
		SetPlot(nIndex);
	}
	///end FAIL_TO_SELECT_PLOT_WHEN_NOT_SUPPORT_MULTI_SEL_MODE
	else //support select multiple plots
	{
		GetSelectedPlots(vnPlots);
		int	nIndex = nCmdID - GOT_DATAPLOT_BEGIN - 1;
		///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
		if ( O_QUERY_BOOL(dwCtrl, ROI_OP_LT) )
		{
			int nOp = dwCtrl & ROI_OP_MASK;
			int nPos = find_in_list(nIndex, vnPlots, false);
			if ( ROI_OP_ADD == nOp && nPos < 0 )
				vnPlots.Add(nIndex);
			else if ( ROI_OP_REMOVE == nOp && nPos >= 0 )
			{
				vnPlots.RemoveAt(nPos);
				SetMultiPlotsState(false);
			}
			else if ( ROI_OP_REPLACE == nOp )
			{
				vnPlots.SetSize(1);
				vnPlots[0] = nIndex;
			}
		}
		else
		{
		///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
			int nPos = find_in_list(nIndex, vnPlots, false);
			if ( nPos >= 0 ) //in, remove
			{
				vnPlots.RemoveAt(nPos);
				SetMultiPlotsState(false); //clear the flag, since not all available plots are selected now.
			}
			else
				vnPlots.Add(nIndex); //not in, add
		///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
		}
		///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
	}
	SetSelectedPlots(vnPlots);
	OnMove();
	return OnPlotChanged();
}

BOOL	GraphObjCurveTool::DoThemeCmd(int nCmdID)
{
	if ( GOT_THEME_SAVE == nCmdID )
	{
		DoSaveTheme();
	}
	///Sophy 1/5/2011 ORG-1906-S2 GROBJTOOL_SAVE_DEFAULT_THEME_SUPPORT
	else if ( GOT_THEME_SAVE_DEFAULT == nCmdID )
	{
		DoSaveThemeDefault();
	}
	///end GROBJTOOL_SAVE_DEFAULT_THEME_SUPPORT
	else
	{
		vector<string>		vsThemes;
		vector<string>		vsFiles;
		/// Zech 09/05/2011 ORG-3492-P5 DISPLAY_EXE_FOLDER_THEMES_ON_GADGET_LOAD_THEME_FLYOUT
		//int					nCount = okutil_theme_get_class_settings(GetXFName(), &vsFiles, &vsThemes, THTYPE_ANALYSIS, TRUE, TRUE);
		int					nCount = okutil_theme_get_class_settings(GetXFName(), &vsFiles, &vsThemes, THTYPE_ANALYSIS, TRUE, TRUE, TRUE, FALSE, FALSE, TRUE, TRUE);
		/// END DISPLAY_EXE_FOLDER_THEMES_ON_GADGET_LOAD_THEME_FLYOUT
		int					nIndex = nCmdID - GOT_THEME_BEGIN - 1;
		ASSERT(nIndex < nCount);
		///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
		//Tree	tr;
		//GetTree(tr);
		//tr.RemoveChild("Results");
		//theme_update_on_new_sel(tr, vsThemes[nIndex]);
		//SetTree(tr);
		//roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET); //need to reset label position since top label parameters may changes.
		//Tree	trGUI;
		//GetGUITree(trGUI);
		//trGUI.SetAttribute(STR_THEME_FILE_ATTRIB, vsFiles[nIndex]);
		//UpdateGUIOnThemeChange(trGUI);
		//SetGUITree(trGUI);
		//UpdateROIGUI();
		LoadTheme(vsThemes[nIndex]);
		///end ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	}
	return TRUE;
}

BOOL	GraphObjCurveTool::UpdateROIState(DWORD& dwState, bool bSet)
{
	Tree tr;
	if ( GetTree(tr) )
	{
		if ( bSet )
		{
			tr.ROIState.nVal = dwState;
			SetTree(tr);
		}
		else
		{
			TreeNode trROIState = tr.ROIState;
			if ( trROIState )
				dwState = trROIState.nVal;
			else
			{
				dwState = GADGET_EDIT_INNER_POINTS;
			}
		}
	}
	return TRUE;
}
	
BOOL	GraphObjCurveTool::GetSelectedPlots(vector<int>& vnPlots)
{
	Tree trInfo;
	vnPlots.SetSize(0);
	if ( IsSupportMultiPlots() && tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.SelPlots ) //multiple selection mode
	{
		vnPlots = trInfo.SelPlots.nVals;
	}
	else //single plots
	{
		DataPlot dp;
		if ( GetSelectedPlot(dp ) )
			vnPlots.Add(dp.GetIndex());
	}
	return (vnPlots.GetSize() > 0);
}

BOOL	GraphObjCurveTool::SetSelectedPlots(const vector<int>& vnPlots)
{
	if ( IsSupportMultiPlots() ) //multiple plots
	{
		Tree trInfo;
		tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
		trInfo.SelPlots.nVals = vnPlots;
		tree_put_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO);
	}
	else //single plot
	{
		if ( vnPlots.GetSize() > 0 )
			SetPlot(vnPlots[0]);
	}
	return TRUE;
}

BOOL	GraphObjCurveTool::ExpandFullRange()
{
	Selection.Remove(m_go);
	return DoExpand();
}

#define	_SWAP(a, b) { double d = a; a = b; b = a; }
BOOL	GraphObjCurveTool::ExpandHorizontal()
{
	if ( !m_gl || !m_gl )
		return FALSE;
	
	Selection.Remove(m_go);
	double dLeft, dRight, dTop, dBottom;
	GetRectCoordinate(dLeft, dRight, dTop, dBottom);
	double dYFrom = min(dTop, dBottom);
	double dYTo = max(dTop, dBottom);
	double dXFrom = m_gl.X.From;
	double dXTo = m_gl.X.To;
	{
		ROIToolOptionAccessHelper		clHelper(ROI_OPTION_IGNORE_EVENT);
		update_roi_position(m_go, dXFrom, dYFrom, dXTo, dYTo);
	}
	graphobjtool_events(*this, m_go.GetName(), OE_RESIZE, GROBJEVENTS_FROM_EVENT_FUNCTION); 
	return TRUE;
}

BOOL	GraphObjCurveTool::ExpandVertical()
{
	if ( !m_go || !m_gl )
		return FALSE;
	
	Selection.Remove(m_go);
	double dLeft, dRight, dTop, dBottom;
	GetRectCoordinate(dLeft, dRight, dTop, dBottom);
	double dYFrom = m_gl.Y.From;
	double dYTo = m_gl.Y.To;
	double dXFrom = min(dLeft, dRight);
	double dXTo = max(dLeft, dRight);
	{
		ROIToolOptionAccessHelper		clHelper(ROI_OPTION_IGNORE_EVENT);
		update_roi_position(m_go, dXFrom, dYFrom, dXTo, dYTo);
	}
	graphobjtool_events(*this, m_go.GetName(), OE_RESIZE, GROBJEVENTS_FROM_EVENT_FUNCTION); 
	return TRUE;
}

BOOL	GraphObjCurveTool::OnResetPosition()
{
	if ( !m_go || !m_gl )
		return FALSE;

	Selection.Remove(m_go);
	double dX1, dX2, dY1, dY2;
	dX1 = m_gl.X.From;
	dX2 = m_gl.X.To;
	dY1 = m_gl.Y.From;
	dY2 = m_gl.Y.To;
	double dLeft = dX1 + (dX2 - dX1) * 0.2;
	double dRight = dX2 - (dX2 - dX1) * 0.2;
	double dTop = dY2 - (dY2 - dY1) * 0.2;
	double dBottom = dY1 + (dY2 - dY1) * 0.2;
	{
		ROIToolOptionAccessHelper		clHelper(ROI_OPTION_IGNORE_EVENT);
		update_roi_position(m_go, dLeft, dTop, dRight, dBottom);
	}
	graphobjtool_events(*this, m_go.GetName(), OE_RESIZE, GROBJEVENTS_FROM_EVENT_FUNCTION);
	return TRUE;
}

BOOL	GraphObjCurveTool::OnUndo()
{
	int nUndoBlockID = 0;
	if ( UndoControl(UNDO_DECRE, &nUndoBlockID) ) //can undo
	{
		Project.Undo(nUndoBlockID);
		string strLTCmd;
		strLTCmd.Format("queue { run.section(graph_controls.ogs, GraphToolEvent, %s %s %d %d); }", GetXFName(), m_go.GetName(), OE_MOVE, GROBJEVENTS_FROM_EVENT_FUNCTION);	
		LT_execute(strLTCmd);
		return TRUE;
	}
	return FALSE;
}

BOOL	GraphObjCurveTool::IsUndoable()
{
	return UndoControl(UNDO_UNDOABLE);
}
	
///Sophy 1/6/2011 ORG-1934-P1 UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS
BOOL	GraphObjCurveTool::IsAllPlotsAllowEdit()
{
	vector<int> vnPlots;
	if ( !GetSelectedPlots(vnPlots) )
		return FALSE;
	for ( int iPlot = 0; iPlot < vnPlots.GetSize(); iPlot++ )
	{
		DataPlot dp = m_gl.DataPlots(vnPlots[iPlot]);
		XYRange xySrc;
		Column colY;

		if ( dp.GetDataRange(xySrc) && xySrc.GetYColumn(colY) && is_dataobj_tagged(colY, STR_DATASETOBJ_FITCURVE) )
			return false;
		if( !okutil_is_good_plot_type_for_analysis(dp.GetPlotType()) )
			return false;
		vector<uint> vnUIDs;
		if ( colY.IsValid() && colY.IsDataProtected() )
			return false;
	}
	return TRUE;
}
///end UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS

///Sophy 1/6/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
BOOL	GraphObjCurveTool::UpdateGUILockNode(int nOp/* = ROI_OP_GET*/, int* pnLockState/* = NULL*/)
{
	Tree trGUI;
	if ( GetGUITree(trGUI) )
	{
		bool bDirty = false;
		TreeNode trLockNode = GetGUILockNode(trGUI);
		if ( trLockNode )
		{
			if ( ROI_OP_GET == nOp && NULL != pnLockState )
				*pnLockState = trLockNode.nVal;
			else if ( ROI_OP_SET == nOp )
			{
				///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
				if ( trLockNode.nVal != 1 )
					bDirty = true;
				///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE 
				trLockNode.nVal = 1;
			}
			else if ( ROI_OP_REMOVE == nOp )
			{
				///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
				if ( trLockNode.nVal != 0 )
					bDirty = true;
				///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE 
				trLockNode.nVal = 0;
			}
			else if ( ROI_OP_TOGGLE == nOp )
			{
				int nLockVal = trLockNode.nVal;
				trLockNode.nVal = (nLockVal ? 0 : 1);
				if ( NULL != pnLockState )
					*pnLockState = trLockNode.nVal;
				///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
				bDirty = true;
				///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE 
			}
		}
		///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
		if ( bDirty )
		{
			SET_MODIFIED_OUTSIDE(trGUI, true);
		}
		///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
		SetGUITree(trGUI);
		return TRUE;
	}
	return FALSE;
}
BOOL	GraphObjCurveTool::OnLockROI()
{
	int nLock = 0;
	UpdateGUILockNode(ROI_OP_TOGGLE, &nLock); //get nLock after toggle.
	disable_go_move(m_go, true, true, false, (0 == nLock));
	return TRUE;
}
///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
///Sophy 11/26/2009 EVT_HANDLER_IN_TREENODE_INVALID_WHEN_RESTART_ORIGIN
typedef int(*PFN_XF_MAKE_TREE)(TreeNode& tr, LPCSTR lpcszVarName);
void	GraphObjCurveTool::UpdateGUITree(TreeNode& trGUI)
{
	///Sophy 3/3/2011 ORG-1930-P1 PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
	string strToolXFName;
	if ( trGUI.GetAttribute(STR_XFNAME_ATTRIB, strToolXFName) && strToolXFName.CompareNoCase(GetXFName()) != 0 )
	{
		ASSERT(0);
		return;
	}
	///end PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
	int* pnXFEvtHandlerState = GetXFEventHandlersState();
	if ( pnXFEvtHandlerState != NULL && 0 == *pnXFEvtHandlerState )
	{
		///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
		//string strXFName = GetXFName();
		//string strFuncName;
		//strFuncName.Format("%s_make_tree", strXFName);
		//Tree tr;
		
		//PFN_XF_MAKE_TREE pfn = Project.FindCompiledFunction(strFuncName);
		//if ( pfn )
		//{
			//pfn(tr, "trGUI");
		Tree	tr;
		if ( MakeTree(tr) )
		{
		///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
			///Sophy 1/28/2010 FAIL_TO_APPLY_THEME_SETTINGS_DUE_TO_EVT_HANGLER_UPDATE_CODE here should only update "Handle" attribute
			//tree_copy_values(trGUI, tr);
			//trGUI.Replace(tr);
			octree_copy_atts_by_id(&tr, &trGUI, STR_ATTRIB_HANDLER);
			octree_copy_atts_by_id(&tr, &trGUI, STR_GETN_HANDLE);	///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS
			///end FAIL_TO_APPLY_THEME_SETTINGS_DUE_TO_EVT_HANGLER_UPDATE_CODE
			///------ Folger 09/14/2010 PICK_PEAK_GADGET_FAILED_TO_WORK_AFTER_RELOAD_PROJECT
			octree_copy_atts_by_id(&tr, &trGUI, STR_ATTRIB_HANDLER_RC);
			///------ End PICK_PEAK_GADGET_FAILED_TO_WORK_AFTER_RELOAD_PROJECT
			SetGUITree(trGUI); //should save GUI tree after handler updated for later use.
			*pnXFEvtHandlerState = 1;
		}
	}
}
///end EVT_HANDLER_IN_TREENODE_INVALID_WHEN_RESTART_ORIGIN

///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
BOOL	GraphObjCurveTool::RemakeGUITree()
{
	Tree	trGUI;
	GetGUITree(trGUI);
	///Sophy 3/3/2011 ORG-1930-P1 PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
	string strToolXFName;
	if ( trGUI.GetAttribute(STR_XFNAME_ATTRIB, strToolXFName) && strToolXFName.CompareNoCase(GetXFName()) != 0 )
	{
		ASSERT(0);
		return FALSE;
	}
	///end PROPER_GET_ACTIVE_LAYER_WHEN_INIT_GADGET_ON_OPJ_LOADING
	Tree	tr;
	if ( !MakeTree(tr) )
		return FALSE;

	BeforeUpdateGUITree(trGUI, tr);	///Sophy 10/13/2011 ORG-4031-P1 INTEG_GADGET_BASELINE_DATASET_LOST_FROM_851_TO_86
	
	octree_copy_values_by_id(&trGUI, &tr);
	octree_copy_atts_by_id(&trGUI, &tr, STR_SHOW_ATTRIB);

	octree_node_copy_attribute(&trGUI, &tr, STR_THEME_FILE_ATTRIB);
	
	AfterUpdateGUITree(trGUI, tr);	///Sophy 10/13/2011 ORG-4031-P1 INTEG_GADGET_BASELINE_DATASET_LOST_FROM_851_TO_86
	
	SetGUITree(tr);	
	return SetVersion();
}

/// virtual
BOOL	GraphObjCurveTool::MakeTree(TreeNode& tr)
{
	string strXFName = GetXFName();
	string strFuncName;
	strFuncName.Format("%s_make_tree", strXFName);
	
	PFN_XF_MAKE_TREE pfn = Project.FindCompiledFunction(strFuncName);
	if ( pfn )
	{
		pfn(tr, "trGUI");
		return TRUE;
	}
	
	return FALSE;
}
///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2

bool GraphObjCurveTool::SetResultsTree(const TreeNode& trResults)
{
	Tree tr;
	GetTree(tr);
	if(trResults)
	{
		///Sophy 1/23/2010 MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
		//as to Max's suggestion, all ROI tools output to worksheet should not rename column Short Name
		trResults.SetAttribute(STR_TR2WKS_NO_RENAME_SNAME_ATTRIB, TRUE);
		tree_set_attribute_to_all_nodes(trResults, STR_TR2WKS_NO_RENAME_SNAME_ATTRIB, "1");	///Sophy 7/14/2010 ORG-558 ALL_ROI_TOOLS_SHOULD_NOT_RENAME_OUTPUT_COLUMN_SHORTNAME
		///end MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
		///Sophy 6/12/2009 IMPROVE_RISETIME_TOOL_FOR_OSCILLOSCOPE_SIGNAL_PROCESSING
#ifdef	IMPROVE_RISETIME_TOOL
		tr.Results.Replace(trResults.Clone(), true, true); //need to remember some attribute
#else	//keep old logic
		tr.Results.Replace(trResults.Clone(), true, true, true);
#endif	//IMPROVE_RISETIME_TOOL
		///end IMPROVE_RISETIME_TOOL_FOR_OSCILLOSCOPE_SIGNAL_PROCESSING
	}
	else
		tr.Results.Remove();
	return SetTree(tr);
}
//virtual
bool GraphObjCurveTool::GetResultsTree(TreeNode& trResults)
{
	Tree tr;
	if ( GetTree(tr) && tr.Results)
	{
		trResults = tr.Results;
	}
	
	return trResults.IsValid();	
}

///Sandy add 2009-2-24 get result tree by clone sub-tree of gui
bool GraphObjCurveTool::GetResultsTree(TreeNode& trResults, LPCSTR lpcszTagName)
{
	Tree tr;
	if ( GetTree(tr) )
	{
		///Sophy 1/6/2011 ORG-1895-P3 RESET_RESULT_TREE_WHEN_NO_DATA_SELECTED_LOSE_LABEL_ATTRIB
		//if ( !tr.Results )
		if ( !tr.Results || tr.Results.Children.Count() == 0 )
		///end RESET_RESULT_TREE_WHEN_NO_DATA_SELECTED_LOSE_LABEL_ATTRIB
		{
			ASSERT(tr.GUI);
			/// Sen 08/25/2011 ORG-2298-P2 MAKE_BASELINE_TAB_WORK_CORRECTLY
			//TreeNode trOutputQuantites = tr.GUI.GetNode(lpcszTagName);
			TreeNode trOutputQuantites = GetResultNode(tr.GUI, lpcszTagName);
			/// End MAKE_BASELINE_TAB_WORK_CORRECTLY
			ASSERT(trOutputQuantites);
			//tr.results.DataID = tr.GUI.quantites.DataID + 1;
			tr.Results.Replace(trOutputQuantites.Clone(), true, true, true);
			tree_remove_attribute(tr.results, STR_ID_ATTRIB); // GETN_CHECK etc things no longer needed and better clean it
			tree_remove_attribute(tr.results, STR_LABEL_ATTRIB); // to avoid double storage, they will be transfered over later anyway
			SetTree(tr);
		}
		trResults = tr.Results;
	}
	
	return trResults.IsValid();
}
/// Sen 08/25/2011 ORG-2298-P2 MAKE_BASELINE_TAB_WORK_CORRECTLY
/// virtual
TreeNode	GraphObjCurveTool::GetResultNode(TreeNode& trGUI, LPCSTR lpcszName)
{
	return trGUI.GetNode(lpcszName);
}
/// End MAKE_BASELINE_TAB_WORK_CORRECTLY
void GraphObjCurveTool::ConnectToTempPreviewDataAndGraph()
{
	if(!m_wks && !m_strPreviewDataWksName.IsEmpty())
		m_wks.Attach(m_strPreviewDataWksName);
	
	if(m_strPreviewGraphName.IsEmpty())
		m_strPreviewGraphName = m_strGraphTemplate;
	if(!m_glPreview && !m_strPreviewGraphName.IsEmpty())
	{
		GraphPage gp(m_strPreviewGraphName);
		if(gp)
			m_glPreview = gp.Layers(0);
	}
}

BOOL GraphObjCurveTool::OnDestroy()
{
	if(GraphObjTool::OnDestroy())
	{
		if(GetTotalNumTools() < 1)
		{
			ConnectToTempPreviewDataAndGraph();
			if(m_wks)
				m_wks.Destroy();
			if(m_glPreview)
				m_glPreview.Destroy();
		}
		///Sophy 2/18/2011 ORG-2227-P1 MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
		vector<uint> vnObjIDs;
		if ( _get_num_roi_obj_in_layer(m_gl, vnObjIDs) <= 1 ) //maybe this is the last ROI on the layer.
		{
			int nColorJunk;
			access_ROI_fill_color(m_gl, nColorJunk, ROI_OP_RESET);
		}
		///end MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
	}
	return true;
}

///Sandy 2009-2-25 add CENTRALIZE_TO_BASE_CLASS_GROBJ_UTILS
void 	GraphObjCurveTool::OutputResultTree(bool bToScript, bool bToResLog, bool bAppendWks, string strWksPageName, DWORD dwCtrl)
{
	TreeNode trResults;
	if(!GetResultsTree(trResults))
	{
		error_report("Invalid Result Tree in GraphObjCurveTool::OutputResultTree()");
		return;
	}
	
	if(bAppendWks)
	{
		///------ Folger 01/21/09 QA81-14995 GADGET_TOOLS_SHOULD_USE_SAME_WORKSHEET_OUTPUT_NOTATION
		//WorksheetPage wp(strWksPageName);
		//Worksheet resWks;
		//if(!wp)
		//{
			//wp.Create("Origin", CREATE_NACTIVE);
			//resWks = wp.Layers(0);
			//resWks.SetSize(-1, 0);
			//wp.Rename(strWksPageName);
		//}
		//else
			//resWks = wp.Layers(0);
		//
		//out_tree_to_wks(trResults, resWks);
		///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
		//out_tree_to_wks(trResults, strWksPageName);
		out_tree_to_wks(trResults, strWksPageName, CREATE_HIDDEN | CREATE_LOAD_1ST_LAYER_ONLY);
		///end ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
		///------ End GADGET_TOOLS_SHOULD_USE_SAME_WORKSHEET_OUTPUT_NOTATION
	}
	if(bToScript || bToResLog)
	{
		Tree trTemp;
		trTemp = trResults;
		///Sophy 12/17/2009 QA80-14598-P4 RISE_TIME_TOOL_NEED_CREATE_LONGNAME_IN_RESULT_COLUMN
		if ( dwCtrl & OUTTREE_USE_TAGNAME_IN_SCRIPT_WIN )
			tree_remove_attribute(trTemp, STR_LABEL_ATTRIB); 
		///end RISE_TIME_TOOL_NEED_CREATE_LONGNAME_IN_RESULT_COLUMN
		trTemp.Show = 1;
		string strOut;
		vector<int> vnTableDisplayFormat = { DISPLAY_CENTER, DISPLAY_RIGHT, DISPLAY_RIGHT};

		///Sophy 8/19/2009 DUMP_RESULT_WITH_DOUBLE_USE_GLOBAL_DECIMAL_DIGIT_SETTINGS
		//tree_to_str(trTemp, strOut, vnTableDisplayFormat, TREE2STR_SKIP_HIDDEN | TREE2STR_SIMPLE_TYPE_ONLY | dwCtrl);
		string strDoubleFormat = "*";
		///Sophy 1/27/2010 TREE_TO_STR_SUPPORT_SPECIFY_SEPARATOR_FOR_NAME_AND_VALUE
		//tree_to_str(trTemp, strOut, vnTableDisplayFormat, TREE2STR_SKIP_HIDDEN | TREE2STR_SIMPLE_TYPE_ONLY | dwCtrl, strDoubleFormat);
		dwCtrl |= TREE2STR_SKIP_HIDDEN | TREE2STR_SIMPLE_TYPE_ONLY | TREE2STR_USE_TAB_AS_SEPARATOR;
		tree_to_str(trTemp, strOut, vnTableDisplayFormat, dwCtrl, strDoubleFormat);
		///end TREE_TO_STR_SUPPORT_SPECIFY_SEPARATOR_FOR_NAME_AND_VALUE
		///end DUMP_RESULT_WITH_DOUBLE_USE_GLOBAL_DECIMAL_DIGIT_SETTINGS
		if(bToScript)
		{
			LT_execute("type -a");
			///Sophy 2/1/2010 SHOW_DATA_TIME_STAMP_WHEN_OUTPUT_TO_SCRIPT_WINDOW
			Tree tr;
			GetTree(tr);
			
			if ( tr.OpDateTime )
			{
				///-----Kit 09/28/2011 ORG-3724-P5 GADGETS_MSG_NEED_DUMP_INFO_TO_SCRIPT_WIN_WHEN_SELECTED
				//out_str(tr.OpDateTime.strVal);
				tr.OpDateTime.strVal.Write(WRITE_SCRIPT_WINDOW);
				///-----End GADGETS_MSG_NEED_DUMP_INFO_TO_SCRIPT_WIN_WHEN_SELECTED
				///Sophy 11/9/2011 ORG-4338-P1 GADGET_OUTPUT_TO_SCRIPT_WINDOW_NEED_START_NEWLINE
				string strNewLine = "\n";
				strNewLine.Write(WRITE_SCRIPT_WINDOW);
				///end GADGET_OUTPUT_TO_SCRIPT_WINDOW_NEED_START_NEWLINE

			}
			///end SHOW_DATA_TIME_STAMP_WHEN_OUTPUT_TO_SCRIPT_WINDOW
			///-----Kit 09/28/2011 ORG-3724-P5 GADGETS_MSG_NEED_DUMP_INFO_TO_SCRIPT_WIN_WHEN_SELECTED
			//out_str(strOut);
			strOut.Write(WRITE_SCRIPT_WINDOW);
			///-----End GADGETS_MSG_NEED_DUMP_INFO_TO_SCRIPT_WIN_WHEN_SELECTED
		}
		if(bToResLog)
		{
			if(m_gp) // should really have this
			{
				Project.OutStringToResultsLog("", false, m_gp.GetName());
			}
			strOut.WriteLine(WRITE_OUTPUT_LOG);
		}
	}	
}


void GraphObjCurveTool::GetRectCoordinate(double& dLeft, double& dRight, double& dTop, double& dBottom)
{
	///Sophy 2/4/2010 PROPERLY_UPDATE_GROBJ_POSITION_ACCORDING_TO_LAYER_SCALE
	//FRECT frect;
	//m_go.GetTempBoundingBox(&frect);
	//double x1 = m_gl.X.From;
	//double x2 = m_gl.X.To;
	//double xx1 = x1 + frect.left * (x2-x1);
	//double xx2 = x1 + frect.right * (x2-x1);
	//double y1 = m_gl.Y.To;
	//double y2 = m_gl.Y.From;
	//double yy1 = y1 + frect.bottom * (y2-y1);
	//double yy2 = y1 + frect.top * (y2-y1);
	///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	//double xx1, xx2, yy1, yy2;
	//int nLeft, nTop, nRight, nBottom;
	//nLeft = m_go.Left;
	//nRight = m_go.Left + m_go.Width;
	//nTop = m_go.Top;
	//nBottom = m_go.Top + m_go.Height;
	//m_gl.PageToWorld(xx1, yy1, nLeft, nBottom);
	//m_gl.PageToWorld(xx2, yy2, nRight, nTop);
	/////end PROPERLY_UPDATE_GROBJ_POSITION_ACCORDING_TO_LAYER_SCALE
	//if(dLeft != NULL)
		//dLeft = xx1;
	//
	//if(dRight != NULL)
		//dRight = xx2;
	//
	//if(dTop != NULL)
		//dTop =yy2;
	//
	//if(dBottom != NULL)
		//dBottom = yy1;
	_get_go_rect(m_gl, m_go, dLeft, dRight, dTop, dBottom);
	///end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
}


//---- end CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS

///Sophy 1/18/2010 CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
//virtual
TreeNode	GraphObjCurveTool::GetFillColorNode(const TreeNode& trGUI)
{
	TreeNode trColor;
	if ( trGUI )
		trColor = trGUI.rectcolor;
	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	if ( !trColor )
		trColor = trGUI.roi.rectcolor;
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	ASSERT(trColor);
	return trColor;
}
///end CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS

///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
//virtual
TreeNode	GraphObjCurveTool::GetToolNameNode(const TreeNode& trGUI)
{
	TreeNode trToolName;
	if ( trGUI )
		trToolName = trGUI.toolname;
	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	if ( !trToolName )
		trToolName = trGUI.roi.toolname;
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	
	ASSERT(trToolName);
	return trToolName;
}
///end SHOW_TOOLNAME_FOR_ROI_TOOLS
///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
//virtual
bool GraphObjCurveTool::SaveClassInfo(TreeNode& tr)
{
	//tr.attObjNames.strVals = m_attObjNames;
	//tree_put_binary_storage( tr, m_go, GRAPH_TOOL_CLASS_INFO );	
	
	return true;
}
//virtual
bool GraphObjCurveTool::LoadClassInfo(const TreeNode& tr)
{
	//tree_get_binary_storage( tr, m_go, GRAPH_TOOL_CLASS_INFO );
	//if(tr.attObjNames)
	//{
		//vector<string> vsTemp;
		//vsTemp = tr.attObjNames.strVals;
		//for(int ii = 0; ii < vsTemp.GetSize() && ii < CTP_SIZE; ii ++)
			//m_attObjNames[ii] = vsTemp[ii];
		//
		//return true;
	//}
	
	return true;
}
///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS

///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
//virtual
bool	GraphObjCurveTool::CheckGetMainObjectPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& pbFixWidth, double& y0, double& y1)
{
	if ( !trGUI || !trGUI.roi.XScale )
		return false;
	
	TreeNode trXScale = trGUI.roi.XScale;
	pbFixWidth = trXScale && trXScale.fixscale && trXScale.fixscale.nVal;

	TreeNode trXFrom = trXScale.leftx;
	TreeNode trXTo = trXScale.rightx;

	if( !trXFrom || !trXTo )
	{
		ASSERT(false);
		return false;
	}
	///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
	//x0 = get_value_by_format(m_dp, trXFrom.strVal);
	//x1 = get_value_by_format(m_dp, trXTo.strVal);
	///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
	//double dOffset = m_gl.X.From;
	//x0 = get_value_by_format(m_dp, trXFrom.strVal, true, &dOffset);
	//x1 = get_value_by_format(m_dp, trXTo.strVal, true, &dOffset);
	x0 = trXFrom.dVal;
	x1 = trXTo.dVal;
	///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
	///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
	///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	double dYFrom = m_gl.Y.From;
	double dYTo = m_gl.Y.To;
	y0 = (dYFrom + y0 * fabs(dYTo - dYFrom)/100.0);
	y1 = (dYFrom + y1 * fabs(dYTo - dYFrom)/100.0);
	///end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	return true;
}

//virtual
bool	GraphObjCurveTool::UpdateXScaleSettings()
{
	if ( !IsAllowLockedROI() ) //cluster tool not allowed, no need to add extra treenode
		return false;

	Tree trGUI;
	if ( GetGUITree(trGUI) )
	{
		///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
		/*
		///Sophy 3/28/2011 ORG-2536-P2 COMPATIBILITY_ISSUE_ON_ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
		if ( ATTACH_TO_SCALE != m_go.Attach )
			m_go.Attach = ATTACH_TO_SCALE;
		///end COMPATIBILITY_ISSUE_ON_ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
		Tree tr;
		tr = m_go.GetFormat(FPB_DATA, FOB_SPECIAL, true, true);
		vector vx;
		vx = tr.Root.Data.X.dVals;
		if( vx.GetSize() > 2 )
		{
			trGUI.roi.XScale.leftx.strVal = get_value_by_format(m_dp, vx[0]);
			trGUI.roi.XScale.rightx.strVal = get_value_by_format(m_dp, vx[1]);
			SetGUITree(trGUI);
		}
		*/
		double dLeft, dRight;
		GetRectCoordinate(dLeft, dRight);
		///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
		//trGUI.roi.XScale.leftx.strVal = get_value_by_format(m_dp, dLeft);
		//trGUI.roi.XScale.rightx.strVal = get_value_by_format(m_dp, dRight);
		///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		//double dOffset = m_gl.X.From;
		//trGUI.roi.XScale.leftx.strVal = get_value_by_format(m_dp, dLeft, 0, true, &dOffset);
		//trGUI.roi.XScale.rightx.strVal = get_value_by_format(m_dp, dRight, 0, true, &dOffset);
		trGUI.roi.XScale.leftx.dVal = dLeft;
		trGUI.roi.XScale.rightx.dVal = dRight;
		///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
		SetGUITree(trGUI);
		///end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
		return true;
	}
	return false;
}
void	GraphObjCurveTool::CheckUpdateMainObjPosition()
{
	Tree trGUI;
	if ( GetGUITree(trGUI) )
	{
		TreeNode trXScale = trGUI.roi.XScale;
		if ( !trXScale )
			return;
		///Sophy 3/8/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		if ( !m_dp.IsValid() )
			m_dp = m_gl.DataPlots(-1); //if not valid plot, should get active one.
		///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
		//double x0 = get_value_by_format(m_dp, trXScale.leftx.strVal);
		//double x1 = get_value_by_format(m_dp, trXScale.rightx.strVal);
		///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		//double dOffset = m_gl.X.From;
		//double x0 = get_value_by_format(m_dp, trXScale.leftx.strVal, true, &dOffset);
		//double x1 = get_value_by_format(m_dp, trXScale.rightx.strVal, true, &dOffset);
		double x0 = trXScale.leftx.dVal;
		double x1 = trXScale.rightx.dVal;
		///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
		CheckSetMainObjectXPosition(x0, x1);
	
		bool bDisable = trXScale.fixscale.nVal;
		disable_go_move(m_go, true, true, false, !bDisable);
	}
}
///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB	
//virtual
bool GraphObjCurveTool::CheckSetMainObjectXPosition(double& x0, double& x1)
{
	/// Iris 2/10/2010 QA81-15099 FIX_BAD_ROI_INIT_POS_WHEN_LAYER_FROM_LARGE_THAN_TO
	/*
	if( x0 > x1 )
	{
		double tmp;
		tmp = x0;
		x0 = x1;
		x1 = tmp;
	}
	
	if( x0 < m_gl.X.From )
		x0 = m_gl.X.From;
	
	if( x1 > m_gl.X.To )
		x1 = m_gl.X.To;
	*/
	#pragma xor(push, FALSE)
	BOOL	bDescending = m_gl.X.From > m_gl.X.To;

	if( bDescending ^ (x0 > x1) )
	{
		double tmp;
		tmp = x0;
		x0 = x1;
		x1 = tmp;
	}
	
	if( bDescending ^ (x0 < m_gl.X.From) )
		x0 = m_gl.X.From;
	
	if( bDescending ^ (x1 > m_gl.X.To) )
		x1 = m_gl.X.To;
	///End FIX_BAD_ROI_INIT_POS_WHEN_LAYER_FROM_LARGE_THAN_TO

	int nType;
	m_go.GetObjectType(&nType);
	if( GROT_RECT == nType ) // the current Main graph object type all are rect, if not rect, need override this function.
	{
		//---- Iris 1/28/2010 this way not exact to set position, for example, set 2 as left, but in fact it is 2.0031
		//goMain.X = x0 + (x1-x0)/2.0;
		//goMain.DX = x1 - x0;	
		///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
		//Tree tr;
		//tr.Root.Dimension.Units.nVal = UNITS_SCALE;
		//tr.Root.Dimension.Attachment.nVal = 2;
		//
		//if(0 != m_go.UpdateThemeIDs(tr.Root) )
		//{
			//ASSERT(false); return false;
		//}
		//
		//if( !m_go.ApplyFormat(tr, true, true) )
		//{
			//ASSERT(false); return false;
		//}				
		//
		//vector vv(4);
		//vv[0] = x0; vv[1] = x1; vv[2] = x1; vv[3] = x0;
		//
		//tr.Reset();
		//tr.Root.Data.X.dVals = vv;
		//
		//if(0 != m_go.UpdateThemeIDs(tr.Root) )
		//{
			//ASSERT(false); return false;
		//}				
			//
		//bool bRet = m_go.ApplyFormat(tr, true, true);		
		bool bRet = _set_roi_position(m_go, x0, x1);
		///end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
		if( bRet )
		{
			graphobjtool_events(*this, m_go.GetName(), OE_RESIZE);
		}
		return bRet;
		//---- 
	}
	ASSERT(false);
	return false;	
}
///End ADD_LEFTX_RIGHTX_IN_ROI_TAB

///Kyle 09/08/2010 ORG-998-P6 SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY
// virtual
bool GraphObjCurveTool::GetMainObjectXPosition(double& x0, double& x1)
{
	///Sophy 4/11/2011 ORG-2606-P2 PROPER_UPDATE_ROI_POSITION_WHEN_NOT_ATTACH_TO_SCALE
	//if( !m_go )
		//return false;
//
	//int nType;
	//m_go.GetObjectType(&nType);
	//if( GROT_RECT != nType )
		//return false;
//
	//Tree tr;
	//tr = m_go.GetFormat(FPB_DATA, FOB_ALL, true, true);
	//if( !(tr.Root && tr.Root.Data) )
		//return false;
//
	//vector vx;
	//vx = tr.Root.Data.X.dVals;
	//vx.GetMinMax(x0, x1);
//
	//return true;
	return _get_go_rect(m_gl, m_go, x0, x1);
	///end PROPER_UPDATE_ROI_POSITION_WHEN_NOT_ATTACH_TO_SCALE
}
///End SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY

///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
void	GraphObjCurveTool::AddThemes(Menu& pm)
{
	Menu				subMenu;
	if ( ConstructThemesMenu(subMenu) )
		pm.AddPopup(STR_DO_THEMES, subMenu, GOT_THEME_BEGIN);
}

/// virtual
bool	GraphObjCurveTool::UpdateROIGUI()
{
	Tree	trGUI;
	GetGUITree(trGUI);

	UpdateMainRect(trGUI);
	CheckUpdateToolName();
	UpdateAttachments();	///Sophy 10/15/2010 ORG-1263-P1 UPDATE_INDICATOR_SETTINGS_FOR_RISETIME_TOOL
	OnMove();

	return true;
}

/// virtual
void	GraphObjCurveTool::UpdateGUIOnThemeChange(TreeNode& trGUI)
{
	m_gp.Refresh();
}
///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU

///------ Folger 12/15/2010 ORG-1752-P1 QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG
BOOL	GraphObjCurveTool::PreviewDataWksNameAccess(BOOL bLoad)
{
	Tree	tr;
	if ( !GetTree(tr) )
		return FALSE;

	if ( bLoad )
	{
		TreeNode	trPreviewDataWksName = tr.PreviewDataWksName;
		if ( !trPreviewDataWksName )
			return FALSE;

		m_strPreviewDataWksName = trPreviewDataWksName.strVal;
		return TRUE;
	}

	tr.PreviewDataWksName.strVal = m_strPreviewDataWksName;
	return SetTree(tr);
}
///------ End QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG


void graphobjtool_events(GraphObjTool& iTool, LPCSTR lpcszMainObjName, int nEvent, int nMsg)
{
	//if ( nMsg != 0 || OE_RESIZE == nEvent )
		//iTool.CheckAttachObjs();
	iTool.Init(lpcszMainObjName);
	iTool.OnEvent(nEvent, nMsg);
}
///Sophy 12/5/2011 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
int	graphobjtool_msg(GraphObjTool& iTool, LPVOID lpMsgInfo)
{
	if ( NULL == lpMsgInfo )
		return -1;
	
	GadgetMsgPtr pMsg = (GadgetMsgPtr)lpMsgInfo;
	iTool.Init(pMsg->szObjName);
	iTool.OnMessage(pMsg);
	return 0;
}
///end LT_OBJ_TO_CONTROL_GADGET_TOOLS

///------ Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
int	GlobalGadget_graphobjtool(GraphObjTool& iTool, int nMsg, WPARAM wParam, LPARAM lParam)
{
	LTVarTempChange junk("@PTOC", 1);
	
	switch ( nMsg )
	{
	case GLOBALGADGET_CAN_CREATE_GADGET:
		{
			GraphLayer	gl = Project.ActiveLayer();
			return gl.IsValid();
		}

	case GLOBALGADGET_CREATE_GADGET:
		if ( GlobalGadget_graphobjtool(iTool, GLOBALGADGET_CAN_CREATE_GADGET, wParam, lParam) )
		{
			TreeNode*	ptrGUITree = (TreeNode*)lParam;
			return iTool.Create(*ptrGUITree);
		}

	default:
		break;
	}
	
	O_A(wParam);
	iTool.Init((LPCTSTR)wParam);
	return iTool.OnGlobalGadget(nMsg, lParam);
}
///------ End GLOBAL_GADGET_MANAGER

////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////Dialog Implementation Related//////////////////////////////////////////
///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
#define	STR_DLG_NAME	_L("Gadget Dialog")

GadgetDlg::GadgetDlg() : MultiPaneDlg(IDD_GADGET_DLG, "ODlg8")
{
	m_dwCtrl = 0;	///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ

}

GadgetDlg::~GadgetDlg()
{
}
///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
//BOOL	GadgetDlg::Create(HWND hWndParent)
BOOL	GadgetDlg::Create(HWND hWndParent, BOOL bVisible)
///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
{
	InitMsgMap();
	
	DWORD dwOptions = 0;
	BOOL bRet = MultiPaneDlg::Create(hWndParent, dwOptions);
	///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	//Visible = true;
	Visible = bVisible;
	///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	return bRet;
}

///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
BOOL	GadgetDlg::UpdateDlgCtrl(DWORD dwBits, int nOpt)
{
	if ( ROI_OP_SET == nOpt )
	{
		O_ADD_BIT(m_dwCtrl, dwBits);
	}
	else if ( ROI_OP_REMOVE == nOpt )
	{
		O_REMOVE_BIT(m_dwCtrl, dwBits);
	}
	return true;
}
///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ

BOOL	GadgetDlg::OnInitDialog()
{
	///Sophy 12/23/2010 ORG-1841 NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	//ResizeDialog::OnInitDialog(IDC_BOTTOM_TAB, STR_DLG_NAME);
	vector<string> vsTips(2);
	vsTips[0] = _L("Show Bottom Panel");
	vsTips[1] = _L("Hide Bottom Panel");
	MultiPaneDlg::OnInitDialog(0, IDC_SHOW_BOTTOM, IDC_BOTTOM_TAB, vsTips, STR_DLG_NAME);
	///end NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET

	///------ Folger 04/15/2011 ORG-2466-P1 PROPER_LANGUAGE_MENU_FOR_GADGET_DLG
	SetLangMenu(IDR_GADGET_MENU);
	///------ End PROPER_LANGUAGE_MENU_FOR_GADGET_DLG

	m_TableOne.Init(IDC_VSFLEXGRID_1, *this, STR_DLG_NAME);
	m_TableTwo.Init(IDC_VSFLEXGRID_2, *this, STR_DLG_NAME);
	
	m_BottomTab = GetItem(IDC_BOTTOM_TAB);
	m_BottomTab.InsertItem(TAB_INNER_POINTS, _L("Inner Points"));
	m_BottomTab.InsertItem(TAB_OUTER_POINTS, _L("Outer Points"));
	m_BottomTab.SetCurSel(0);
	OnTabChange(m_BottomTab);
	Text = STR_DLG_NAME;
	
	
	Control ctrl = GetDlgItem(IDC_SET_DATA);
	if ( ctrl )
		ctrl.Enable = false;
	m_strLastValue = "";
	InitButtons();
	ArrangeControls();
	UpdateDlgData();
	return TRUE;
}

BOOL	GadgetDlg::OnReady()
{
	SetInitReady();
	return TRUE;
}

BOOL	GadgetDlg::OnDlgResize(int nType, int cx, int cy)
{
	if ( !IsInitReady() )
		return FALSE;
	
	MoveControlsHelper _temp(this);
	Control cc;
	RECT rr;
	GetControlClientRect(IDC_BOTTOM_TAB, rr, &cc);
	rr.bottom = cy;
	rr.right = cx;
	MoveControl(cc, rr);
	
	GetControlClientRect(IDC_BOTTOM_TAB, rr, &cc);
	m_BottomTab.AdjustRect(FALSE, &rr);
	MoveControl(GetItem(IDC_VSFLEXGRID_1), rr);
	MoveControl(GetItem(IDC_VSFLEXGRID_2), rr);
	
	///Sophy 12/23/2010 ORG-1841 NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	RECT rOutput;
	GetControlClientRect(IDC_OUTPUT_RESULT, rOutput, &cc);
	RECT rShowBtn;
	GetControlClientRect(IDC_SHOW_BOTTOM, rShowBtn, &cc);
	int nWidth = RECT_WIDTH(rShowBtn);
	rShowBtn.top = rOutput.top;
	rShowBtn.bottom = rOutput.bottom;
	rShowBtn.right = cx;
	rShowBtn.left = cx - nWidth;
	MoveControl(cc, rShowBtn);
	///end NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	return TRUE;
}

///Sophy 12/23/2010 ORG-1841 NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
void	GadgetDlg::SetAllowResizing(BOOL bAllow)
{
	int nStyle = GetWindowLong(Window::GetSafeHwnd(), GWL_STYLE);
	O_SET_BIT(nStyle, WS_THICKFRAME, bAllow);
	SetWindowLong(Window::GetSafeHwnd(), GWL_STYLE, nStyle);
	UpdateWindow(TRUE);
}
BOOL	GadgetDlg::OnShowBottomPane(Control ctrl)
{
	MultiPaneDlg::OnShowBottomPane(ctrl);
	return OnResize();
}

BOOL	GadgetDlg::OnResize()
{
	Control ctrlShowHideBtn;
	RECT rBtn;
	GetControlClientRect(IDC_SHOW_BOTTOM, rBtn, &ctrlShowHideBtn);
	
	int nHeight = 0;
	if ( IsBottomPaneShown() )
	{
		SetAllowResizing(TRUE);
		Control ctrlTab;
		RECT rTab;
		GetControlClientRect(IDC_BOTTOM_TAB, rTab, &ctrlTab);
		Control ctrlGrid;
		RECT rGrid;
		GetControlClientRect(IDC_VSFLEXGRID_1, rGrid, &ctrlGrid);
		nHeight = RECT_HEIGHT(rTab) + RECT_HEIGHT(rGrid);
	}
	else
		SetAllowResizing(FALSE);
	
	RECT	rWin;
	m_wndDlg.GetWindowRect(&rWin);
	m_wndDlg.ClientToScreen(&rBtn);
	rWin.bottom = rBtn.bottom + GetControlGap() + nHeight;
	m_wndDlg.MoveWindow(&rWin);
	return TRUE;
}

BOOL	GadgetDlg::OnInnerPoints()
{
	O_SET_BIT(m_dwState, GADGET_EDIT_INNER_POINTS, true);
	initEditMenu();
	return TRUE;
}

BOOL	GadgetDlg::OnOuterPoints()
{
	O_SET_BIT(m_dwState, GADGET_EDIT_INNER_POINTS, false);
	initEditMenu();
	return TRUE;
}

BOOL	GadgetDlg::OnExpandFullRange()
{
	return m_pTool->ExpandFullRange();
}

BOOL	GadgetDlg::OnExpandHorizontal()
{
	return m_pTool->ExpandHorizontal();
}

BOOL	GadgetDlg::OnExpandVertical()
{
	return m_pTool->ExpandVertical();
}

BOOL	GadgetDlg::OnResetPosition()
{
	return m_pTool->OnResetPosition();
}

BOOL	GadgetDlg::OnCmdUIUpdate(CmdUI cmdUI)
{
	CmdUIInfo cmdInfo;
	cmdUI.GetMenuInfo(cmdInfo);
	int nMenuID = cmdInfo.m_nID;
	if ( ID_UNDO == nMenuID )
	{
		BOOL bUndoable = m_pTool->IsUndoable();
		cmdUI.Enable(bUndoable);
	}
	///Sophy 1/6/2011 ORG-1934-P1 UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS
	else if ( ID_DELETE_ROWS == nMenuID
		|| ID_MASK_DATA == nMenuID
		|| ID_UNMASK_DATA == nMenuID
		|| ID_CLEAR_DATA == nMenuID
	)
	{
		BOOL bAllowEdit = m_pTool->IsAllPlotsAllowEdit();
		cmdUI.Enable(bAllowEdit);
	}
	///end UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS
	///Sophy 2/17/2011 ORG-1955-P1 PROPER_INIT_COPY_DATA_MENU_ITEM_STATE
	else if ( ID_COPY_DATA == nMenuID )
	{
		vector<int> vnPlots;
		cmdUI.Enable(m_pTool->GetSelectedPlots(vnPlots));
	}
	///end PROPER_INIT_COPY_DATA_MENU_ITEM_STATE
	return TRUE;
}

///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
class	GadgetDlgMsgHelper
{
public:
	GadgetDlgMsgHelper(PFN_GADGET_MSG_HANDLER pfnMsgHandler, int nMsg, DWORD dwParam = 0)
	{
		m_pfnMsgHandler = pfnMsgHandler;
		m_nMsg = nMsg;
		m_dwParam = dwParam;
	}
	~GadgetDlgMsgHelper()
	{
		if ( m_pfnMsgHandler )
		{
			m_pfnMsgHandler(m_nMsg, m_dwParam);
		}
	}
private:
	PFN_GADGET_MSG_HANDLER	m_pfnMsgHandler;
	int						m_nMsg;
	DWORD					m_dwParam;
};
///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
BOOL	GadgetDlg::OnUndo()
{
	//Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	GadgetDlgMsgHelper msgHelper(GetMsgHandler(), MSG_UNDO_CHANGED, 0);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	return m_pTool->OnUndo();
}

BOOL	GadgetDlg::OnDeleteRowClicked(Control ctrl)
{
	return OnDeleteRow();
}

BOOL	GadgetDlg::OnDeleteRow()
{
	int nRet = warning_msg_box(_L("Delete Worksheet Rows will remove whole row from worksheet, do you want to continue?"), true, 'E', MB_YESNO);
	if ( nRet != IDYES )
		return FALSE;
	//Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	GadgetDlgMsgHelper msgHelper(GetMsgHandler(), MSG_UNDO_CHANGED, 0);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	int nOpera = DATA_DELETE_ROW;
	int nRegion = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? DATA_INNER_PTS : DATA_OUTER_PTS;
	double dNewVal = 0;
	_Edit_Data_Points_Setting_Access(nOpera, nRegion, dNewVal, ROI_OP_SET);
	return m_pTool->OnUpdateData();
}

BOOL	GadgetDlg::OnDeleteXYClicked(Control ctrl)
{
	return OnDeleteXY();
}

BOOL	GadgetDlg::OnDeleteXY()
{
	//Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	GadgetDlgMsgHelper msgHelper(GetMsgHandler(), MSG_UNDO_CHANGED, 0);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	int nOpera = DATA_DELETE_XY;
	int nRegion = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? DATA_INNER_PTS : DATA_OUTER_PTS;
	double dNewVal = 0;
	_Edit_Data_Points_Setting_Access(nOpera, nRegion, dNewVal, ROI_OP_SET);
	return m_pTool->OnUpdateData();
}

BOOL	GadgetDlg::OnCopyDataClicked(Control ctrl)
{
	return OnCopyData();
}

BOOL	GadgetDlg::OnCopyData()
{
	UpdateROIState(true);
	return m_pTool->OnCopyData();
}

BOOL	GadgetDlg::OnMaskClicked(Control ctrl)
{
	return OnMask();
}

BOOL	GadgetDlg::OnMask()
{
	//Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	GadgetDlgMsgHelper msgHelper(GetMsgHandler(), MSG_UNDO_CHANGED, 0);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	int nOpera = DATA_MASK;
	int nRegion = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? DATA_INNER_PTS : DATA_OUTER_PTS;
	double dNewVal = 0;
	_Edit_Data_Points_Setting_Access(nOpera, nRegion, dNewVal, ROI_OP_SET);
	GetDlgItem(IDC_UNDO).Enable = true;
	return m_pTool->OnUpdateData();
}

BOOL	GadgetDlg::OnUnmaskClicked(Control ctrl)
{
	return OnUnmask();
}

BOOL	GadgetDlg::OnUnmask()
{
	//Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	GadgetDlgMsgHelper msgHelper(GetMsgHandler(), MSG_UNDO_CHANGED, 0);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	int nOpera = DATA_UNMASK;
	int nRegion = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? DATA_INNER_PTS : DATA_OUTER_PTS;
	double dNewVal = 0;
	_Edit_Data_Points_Setting_Access(nOpera, nRegion, dNewVal, ROI_OP_SET);
	return m_pTool->OnUpdateData();
}

BOOL	GadgetDlg::OnClearDataClicked(Control ctrl)
{
	return OnClearData();
}

BOOL	GadgetDlg::OnClearData()
{
	//Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	GadgetDlgMsgHelper msgHelper(GetMsgHandler(), MSG_UNDO_CHANGED, 0);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	int nOpera = DATA_CLEAR;
	int nRegion = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? DATA_INNER_PTS : DATA_OUTER_PTS;
	double dNewVal = 0;
	_Edit_Data_Points_Setting_Access(nOpera, nRegion, dNewVal, ROI_OP_SET);
	return m_pTool->OnUpdateData();
}

BOOL	GadgetDlg::OnSetDataClicked(Control ctrl)
{
	//Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	GadgetDlgMsgHelper msgHelper(GetMsgHandler(), MSG_UNDO_CHANGED, 0);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	int nOpera = DATA_SET_VALUE;
	int nRegion = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? DATA_INNER_PTS : DATA_OUTER_PTS;
	double dNewVal = atof(GetDlgItem(IDC_NEW_VALUE).Text);
	_Edit_Data_Points_Setting_Access(nOpera, nRegion, dNewVal, ROI_OP_SET);
	GetDlgItem(IDC_UNDO).Enable = true;
	return m_pTool->OnUpdateData();
}

///Sophy 2/22/2011 ORG-2225-P1 ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
BOOL	GadgetDlg::OnEditSwitch(Control ctrl)
{
	O_TOGGLE_BIT(m_dwState, GADGET_EDIT_INNER_POINTS);
	int nDataCmdID = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? GOT_DATAPLOT_INNER : GOT_DATAPLOT_OUTER;
	return OnChangeData(nDataCmdID);
}
///end ADD_EDIT_INNER_OUTER_SWITCH_BUTTON


BOOL	GadgetDlg::OnValueChange(Control ctrl)
{
	string strValue = ctrl.Text;
	if ( atof(strValue) == NANUM && !strValue.IsEmpty() && strValue.Compare("--") != 0 )
		ctrl.Text = m_strLastValue;
	else
		m_strLastValue = strValue;
	GetDlgItem(IDC_SET_DATA).Enable = !m_strLastValue.IsEmpty();
	return TRUE;
}
///Sophy 1/6/2011 ORG-1934-P1 UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS
void	GadgetDlg::updateControls()
{
	bool bEnableEditButtons = m_pTool->IsAllPlotsAllowEdit();
	vector<uint> vnEditBtns = {
		IDC_DELETE_ROW,
		IDC_MASK,
		IDC_UNMASK,
		IDC_CLEAR_DATA,
		IDC_SET_DATA	
	};
	for ( int iBtn = 0; iBtn < vnEditBtns.GetSize(); iBtn++ )
	{
		Button btnCtrl = GetItem(vnEditBtns[iBtn]);
		if ( btnCtrl )
			btnCtrl.Enable = bEnableEditButtons;
	}
	///Sophy 1/25/2011 ORG-1957-P3 PROPER_UPDATE_BUTTON_STATE_ON_DATA_CHANGE
	Button btnCtrl = GetItem(IDC_GOTO_SRC_WORKSHEET);
	if ( btnCtrl )
	{
		Worksheet wks;
		btnCtrl.Enable = m_pTool->GetSourceWorksheet(wks);
	}
	btnCtrl = GetItem(IDC_COPY_DATA);
	if ( btnCtrl )
	{
		vector<int> vnPlots;
		btnCtrl.Enable = m_pTool->GetSelectedPlots(vnPlots);
	}
	///end PROPER_UPDATE_BUTTON_STATE_ON_DATA_CHANGE
	///Sophy 2/18/2011 ORG-2225-P1 ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
	Button btn = GetItem(IDC_EDIT_INNER_OUTER);
	if ( btn )
	{
		btn.Check = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS) ? 0 : 1;
	}
	///end ADD_EDIT_INNER_OUTER_SWITCH_BUTTON

}
///end UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS

enum {
	GADGET_EDIT_MENU_POS	= 0,
	GADGET_DATA_MENU_POS,
	GADGET_SETTINGS_MENU_POS,
};
BOOL	GadgetDlg::InitMenu()
{
	initEditMenu();
	initDataMenu();
	initSettingsMenu();
	return TRUE;
}

void	GadgetDlg::initEditMenu()
{
	///Sophy 2/14/2011 ORG-2225-P1 CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
	//HWND	hWnd = GetSafeHwnd();
	//HMENU	hMenu = GetMenu(hWnd);
	//Menu	mn(hMenu);
	//string strLabel;
	//bool bInnerPoints = O_QUERY_BOOL(m_dwState, GADGET_EDIT_INNER_POINTS);
	//mn.GetMenuString(ID_INNER_POINTS, strLabel, MF_BYCOMMAND);
	//mn.ModifyMenu(ID_INNER_POINTS, MF_BYCOMMAND | (bInnerPoints ? MF_CHECKED : 0), ID_INNER_POINTS, strLabel);
	//mn.GetMenuString(ID_OUTER_POINTS, strLabel, MF_BYCOMMAND);
	//mn.ModifyMenu(ID_OUTER_POINTS, MF_BYCOMMAND | (bInnerPoints ? 0 : MF_CHECKED), ID_OUTER_POINTS, strLabel);	
	///end CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
}
void	GadgetDlg::initDataMenu()
{
	HWND	hWnd = GetSafeHwnd();
	HMENU	hMenu = GetMenu(hWnd);
	HMENU hSubMenu = GetSubMenu(hMenu, GADGET_DATA_MENU_POS);
	if ( NULL == hSubMenu )
		return;
	Menu	mnChangeData(hSubMenu);
	mnChangeData.RemoveAllItems();
	///Sophy 2/14/2011 ORG-2225-P1 CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
	UpdateROIState(false);	 //need update inner/outer points state
	///end CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
	m_pTool->GetPlotsMenu(mnChangeData);
}

void	GadgetDlg::initSettingsMenu()
{
	HWND	hWnd = GetSafeHwnd();
	HMENU	hMenu = GetMenu(hWnd);
	Menu	mn(hMenu);
	string strLabel;
	bool bShowAttaches = m_pTool->DoToolControl(TOOL_CTRL_TYPE_ATTACHESMODE, ROI_OP_GET);
	
	GraphObject grMain;
	if ( m_gl )
		grMain = m_gl.GraphObjects(m_strMainObjName);
	int nShape = SHAPE_RECT;
	if ( grMain )
	{
		int nTypeID;
		grMain.GetObjectType(&nTypeID);
		if ( nTypeID == GROT_RECT )
			nShape = SHAPE_RECT;
		else if ( nTypeID == GROT_ELLIPSE )
			nShape = SHAPE_CIRCLE;
	}
	mn.ModifyMenu(ID_CHANGE_SHAPE, MF_STRING | MF_BYCOMMAND | ((SHAPE_CIRCLE == nShape) ? MF_CHECKED : 0), ID_CHANGE_SHAPE, _L("Use Circular ROI Box"));
	
	mn.GetMenuString(ID_SHOWHIDE_ATTACHES, strLabel, MF_BYCOMMAND);
	mn.ModifyMenu(ID_SHOWHIDE_ATTACHES, MF_BYCOMMAND | (bShowAttaches ? MF_CHECKED : 0), ID_SHOWHIDE_ATTACHES, strLabel);
	bool bRealtime = m_pTool->DoToolControl(TOOL_CTRL_TYPE_REALTIME, ROI_OP_GET);
	mn.GetMenuString(ID_REALTIME_CALC, strLabel, MF_BYCOMMAND);
	mn.ModifyMenu(ID_REALTIME_CALC, MF_BYCOMMAND | (bRealtime ? MF_CHECKED : 0), ID_REALTIME_CALC, strLabel);
	HMENU	hSubMenu = GetSubMenu(hMenu, GADGET_SETTINGS_MENU_POS);
	Menu	mnSettings(hSubMenu);
	hSubMenu = mnSettings.GetPopupHmenu(ID_THEME_NONE);
	if ( NULL == hSubMenu ) //maybe inited, check theme id
		hSubMenu = mnSettings.GetPopupHmenu(GOT_THEME_BEGIN | 1);
	Menu	mnThemes(hSubMenu);
	mnThemes.RemoveAllItems();
	m_pTool->GetThemesMenu(mnThemes);
}

void	GadgetDlg::updateUndoSettings()
{
	GetDlgItem(IDC_UNDO).Enable = m_pTool->IsUndoable();
}

void	GadgetDlg::UpdateROIState(bool bToROI)
{
	m_pTool->UpdateROIState(m_dwState, bToROI);
}

///end NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET

BOOL	GadgetDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	return FALSE;
}

BOOL	GadgetDlg::OnDestroy()
{
	ResizeDialog::OnDestroy();
	return TRUE;
}

BOOL	GadgetDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	nHelpID = GetHelpID();
	return TRUE;
}

BOOL	GadgetDlg::OnOK()
{
	return FALSE; //return FALSE to prevent from closing
}

BOOL	GadgetDlg::OnCancel()
{
	string	strCmd;
	strCmd.Format("run.section(graph_controls.ogs, DelayDestroy, %s)", m_strMainObjName);
	LT_execute(strCmd);
	Visible = false; //hide it
	return FALSE; //return FALSE to prevent calling OnDestroy
}

///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
BOOL	GadgetDlg::OnIdle()
{
	if ( O_QUERY_BOOL(m_dwCtrl, GADGETDLG_CTRL_MAKE_INVISIBLE) == Visible )
	{
		///Sophy 4/8/2011 ORG-2592-P2 PROPER_SHOW_HIDE_GADGET_WHEN_MINIMIZE_ORIGIN_MAIN_WIN
		Window win = GetParent();
		if ( win && win.IsIconic() )
			return TRUE;
		///end PROPER_SHOW_HIDE_GADGET_WHEN_MINIMIZE_ORIGIN_MAIN_WIN
		Visible = !O_QUERY_BOOL(m_dwCtrl, GADGETDLG_CTRL_MAKE_INVISIBLE);
	}
	return TRUE;
}
///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
BOOL	GadgetDlg::OnTabChange(Control ctrl)
{
	const int nCurSel = m_BottomTab.GetCurSel();
	m_TableOne.SetVisible(TAB_INNER_POINTS == nCurSel);
	m_TableTwo.SetVisible(TAB_OUTER_POINTS == nCurSel);
	return TRUE;
}
///Sophy 12/17/2010 ORG-1755-S4 ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
//BOOL	GadgetDlg::OnBeforeMouseDownTable(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
//{
	//if ( MK_RBUTTON == nButton )
	//{
		//Control ctrl;
		//const int nCurSel = m_BottomTab.GetCurSel();
		//if ( TAB_INNER_POINTS == nCurSel )
		//{
			//m_TableOne.OnBeforeMouseDown(ctrl, nButton, nShift, X, Y, pCancel);
		//}
		//else if ( TAB_OUTER_POINTS == nCurSel )
		//{
			//m_TableTwo.OnBeforeMouseDown(ctrl, nButton, nShift, X, Y, pCancel);
		//}
		//return TRUE;
	//}
	//if ( pCancel && !m_TableOne.IsMouseOnHeader() && !m_TableTwo.IsMouseOnHeader() )
		//*pCancel = TRUE; //force NOT editable.
	//return FALSE;
//}
BOOL	GadgetDlg::OnBeforeSort(Control ctrl, long lCol, short* pSort)
{
	int nCurSel = m_BottomTab.GetCurSel();
	if ( TAB_INNER_POINTS == nCurSel )
	{
		return m_TableOne.BeforeSort();
	}
	else  if ( TAB_OUTER_POINTS == nCurSel )
	{
		return m_TableTwo.BeforeSort();
	}
	return FALSE;
}

BOOL	GadgetDlg::OnAfterSort(Control ctrl, long lCol, short* pSort)
{
	int nCurSel = m_BottomTab.GetCurSel();
	if ( TAB_INNER_POINTS == nCurSel )
	{
		return m_TableOne.AfterSort();
	}
	else  if ( TAB_OUTER_POINTS == nCurSel )
	{
		return m_TableTwo.AfterSort();
	}
	return FALSE;
}

BOOL	GadgetDlg::OnContext(UINT nResID, int nX, int nY)
{
	if ( nResID == IDC_VSFLEXGRID_1 )
	{
		///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
		//return m_TableOne.ShowContextMenu(nX, nY);
		return m_TableOne.ShowContextMenu(m_pTool, nX, nY);
		///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	}
	else if ( nResID == IDC_VSFLEXGRID_2 )
	{
		///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
		//return m_TableTwo.ShowContextMenu(nX, nY);
		return m_TableTwo.ShowContextMenu(m_pTool, nX, nY);
		///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	}
	return FALSE;
}
///end ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
BOOL	GadgetDlg::OnActiveLayerChange()
{
	///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	return TRUE; //since we have OnActivate/OnDeactivate to show/hide the dialog, no need this logic any more.
	///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	BOOL bVisible = StartGadget();
	Visible = bVisible;
	return bVisible;
}

BOOL	GadgetDlg::OnActivateReportClicked(Control ctrl)
{
	return m_pTool->OnActivateResult();
}

BOOL	GadgetDlg::OnPreferencesClicked(Control ctrl)
{
	return OnPreferences; //to do
}

BOOL	GadgetDlg::OnPreferences()
{
	return m_pTool->OnPreferences(GetSafeHwnd());
}

BOOL	GadgetDlg::OnResultSheetChange(Control ctrl)
{
	string strText = ctrl.Text;
	return UpdateReportSheetName(strText);	///Sophy 6/25/2010 ORG-25-P5 UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG
}

///Sophy 12/17/2010 ORG-1755-S4 ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
BOOL	GadgetDlg::OnShowHideCols(UINT wParam, UINT lParam)
{
	int nCurSel = m_BottomTab.GetCurSel();
	if ( TAB_INNER_POINTS == nCurSel )
	{
		return m_TableTwo.UpdateDisplay(wParam, lParam);
	}
	else if ( TAB_OUTER_POINTS == nCurSel )
	{
		return m_TableOne.UpdateDisplay(wParam, lParam);
	}
	return FALSE;
}
///end ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL

BOOL	GadgetDlg::CheckInitTool()
{
	m_gl = Project.ActiveLayer();
	if ( !m_gl )
		return FALSE;
	if ( !get_ROI_main_obj_name(m_gl, GetToolType(), m_strMainObjName) )
		return FALSE;
	return TRUE;
}

BOOL	GadgetDlg::ArrangeControls()
{
	//temp testing code begin
	SetControlGap(3);
	vector<uint> vnGroupBtnIDs = {
		IDC_BTN_PREPERENCES,
		IDC_BTN_ACTIVATE_REPORT
	};
	const int nControlGap = GetControlGap();
	int nBottom = ArrangeControlsLeftRight(vnGroupBtnIDs, nControlGap, nControlGap, nControlGap);
	Button btnFirst;
	RECT rFirstBtn;
	GetControlClientRect(vnGroupBtnIDs[0], rFirstBtn, &btnFirst);
	
	vector<uint> vnControlIDs = {
		IDC_REPORT_LABEL,
		IDC_EDIT_REPORT_SHEET,
		IDC_OUTPUT_RESULT
	};
	nBottom = ArrangeControlsLeftRight(vnControlIDs, nControlGap, nBottom + 2 * nControlGap, nControlGap);
	
	Control cFrame = GetItem(IDC_FRAME);
	MoveControl(cFrame, rFirstBtn);
	cFrame.Visible = false;
	
	Control tab;
	RECT rTab;
	GetControlClientRect(IDC_BOTTOM_TAB, rTab, &tab);
	rTab.top = nBottom + nControlGap;
	rTab.left = nControlGap;
	MoveControl(tab, rTab);
	//temp testing code end
	return FALSE; //to do
}

BOOL	GadgetDlg::InitButtons()
{
	vector<uint> vnBtnsToHide = {
		IDC_BTN_ACTIVATE_REPORT,
		IDC_BUTTON1,
		IDC_BUTTON2,
		IDC_BUTTON3, 
		IDC_BUTTON4, 
		IDC_BUTTON5, 
		IDC_BUTTON6, 
		IDC_BUTTON7, 
		IDC_BUTTON8
	}
	for ( int iBtn = 0; iBtn < vnBtnsToHide.GetSize(); iBtn++ )
	{
		Button btn = GetItem(vnBtnsToHide[iBtn]);
		if ( btn )
			btn.Visible = false;
	}
	
	vector<uint> vnBtns = {
		IDC_BTN_PREPERENCES,
		IDC_BTN_ACTIVATE_REPORT,
		IDC_OUTPUT_RESULT
	};
	
	vector<string> vsBtnTips(vnBtns.GetSize());
	
	vsBtnTips[0] = _L("Preferences");
	vsBtnTips[1] = _L("Go");
	vsBtnTips[2] = _L("Output Report");
	
	vector<int> vnBitmaps = {
		IDB_PF_ADV,
		IDB_ACTIVATE_WKS,
		IDB_DUMP_DATA_INTO_WKS
	};
	for ( iBtn = 0; iBtn < vnBtns.GetSize(); iBtn++ )
	{
		Button btnCtrl = GetItem(vnBtns[iBtn]);
		if ( btnCtrl )
			btnCtrl.Visible = true;
		BitmapRadioButton btn = GetItem(vnBtns[iBtn]);
		vector<string> vsTips(1);
		vsTips[0] = vsBtnTips[iBtn];
		if ( btn )
		{
			btn.Init(1, vnBitmaps[iBtn], 16, vsTips);
		}
	}
	return TRUE;
}
///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL


///Sophy 6/25/2010 ORG-23-S8 XY_INTERP_FOR_GADGET_TOOL_DLG
#define	STR_INTERP_DLG_NAME		"Interpolate Y From X"
InterpXYDlg::InterpXYDlg() : ResizeDialog(IDD_QUICK_FIT_FINDXY, "ODlg8")
{
}

int	InterpXYDlg::DoModalEx(InterpParams& stParams, HWND hWndParent)
{
	m_stParams = stParams;
	InitMsgMap();
	return ResizeDialog::DoModal(hWndParent);
}

BOOL	InterpXYDlg::OnInitDialog()
{
	Text = _L(STR_INTERP_DLG_NAME); //update the dialog title
	InitControls();
	LoadSettings();
	InitRangeText();
	UpdateButtonState();
	m_bFocusReset = false;
	return true;
}

BOOL	InterpXYDlg::OnReady()
{
	SetInitReady();
	return TRUE;
}

BOOL	InterpXYDlg::OnIdle()
{
	if ( !m_bFocusReset )
	{
		SetFocus(m_edtX.GetSafeHwnd());
		m_bFocusReset = true;
	}
	return TRUE;
}
BOOL	InterpXYDlg::OnDestroy()
{
	SaveSettings();
	return TRUE;
}

BOOL	InterpXYDlg::OnOutputChange(Control ctrl)
{
	if ( m_btnOutputScriptWindow.Value )
		m_nOutputTarget = OUTPUT_TO_SCRIPTWINDOW;
	else if ( m_btnOutputResultLog.Value )
		m_nOutputTarget = OUTPUT_TO_RESULTLOG;
	else if ( m_btnOutputWorksheet.Value )
		m_nOutputTarget = OUTPUT_TO_WORKSHEET;
	else
		ASSERT(false);
	UpdateButtonState();
	return TRUE;
}

BOOL	InterpXYDlg::OnClickInterp(Control ctrl)
{
	vector vInput, vOutput;
	if ( Calculate(vInput, vOutput) > 0 )
	{
		string strOutput;
		vector<string> vsOutput;
		convert_double_vector_to_string_vector(vOutput, vsOutput, vOutput.GetSize());
		strOutput.SetTokens(vsOutput, ';');
		m_edtY.Text = strOutput;
	}
	return TRUE;
}

///Sophy 6/30/2010 ORG-23-P6 PROPER_CHECK_WHEN_OUTPUT_TO_WORKSHEET
static	void _check_report_worksheet(TreeNode& trReport, LPCSTR lpcszWorksheetName, int nOutputTarget)
{
	if ( OUTPUT_TO_WORKSHEET == nOutputTarget )
	{
		out_tree_to_wks(trReport, lpcszWorksheetName, CREATE_HIDDEN | CREATE_LOAD_1ST_LAYER_ONLY);
	}
}
///end PROPER_CHECK_WHEN_OUTPUT_TO_WORKSHEET
BOOL	InterpXYDlg::OnClickOutput(Control ctrl)
{
#define	STR_NEXT_LINE	"\r\n"

	vector vInput, vOutput;
	if ( Calculate(vInput, vOutput) > 0 )
	{
		string strComments, strOutput, strRng = "";
		XYRange xySrc;
		m_dpSrc.GetDataRange(xySrc, m_stParams.ni1, m_stParams.ni2);
		if ( xySrc )
			strRng = xySrc.GetDescription(GETLC_MAIN_OBJ_ONLY | GETLC_COL_LONG_NAME | GETLC_INCLUDE_LOOSE_DATA);
		strComments.Format(_L("Interpolate Y from X on %s"), strRng);
		strOutput = strComments + STR_NEXT_LINE + "X\t\tY" + STR_NEXT_LINE;
		string strWorksheet = m_edtWorksheetName.Text;
		for ( int ii = 0; ii < vInput.GetSize(); ii++ )
		{
			double dInput = vInput[ii], dOutput = vOutput[ii];
			strOutput += get_value_by_format(m_dpSrc, dInput) + "\t\t" + ftoa(dOutput, "*") + STR_NEXT_LINE;
			///Sophy 6/30/2010 ORG-23-S9 BETTER_LABELS_FOR_RESULT_CURVE
			GETN_TREE(trReport)
			GETN_NUM(X, _L("Specified X"), dInput)
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_X);
			GETN_NUM(Y, _L("Found Y"), dOutput)
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_COMMENTS_LABEL_ATTRIB, strComments);
			///end BETTER_LABELS_FOR_RESULT_CURVE
			///Sophy 6/30/2010 ORG-23-P6 PROPER_CHECK_WHEN_OUTPUT_TO_WORKSHEET
			//out_tree_to_wks(trReport, strWorksheet, CREATE_HIDDEN | CREATE_LOAD_1ST_LAYER_ONLY);
			_check_report_worksheet(trReport, strWorksheet, m_nOutputTarget);
			///end PROPER_CHECK_WHEN_OUTPUT_TO_WORKSHEET
		}
		switch( m_nOutputTarget )
		{
		case OUTPUT_TO_SCRIPTWINDOW:
			LT_execute("type -a"); //show script window
			strOutput.Write(WRITE_SCRIPT_WINDOW);
			break;
			
		case OUTPUT_TO_RESULTLOG:
			Project.OutStringToResultsLog(strOutput, false);
			break;
			
		case OUTPUT_TO_WORKSHEET:
			//already output above...
			UpdateButtonState(); //enable "Go" if possible
			break;
			
		default:
			ASSERT(false);
			break;
		}
		return TRUE;
	}
	return FALSE;
}

int		InterpXYDlg::GetInput(vector& vInput)
{
	vInput.SetSize(0);
	string strInput = m_edtX.Text;
	vector<string> vsXs;
	int nSize = strInput.GetTokens(vsXs, ';');
	for ( int ii = 0; ii < nSize; ii++ )
	{
		double dValue = get_value_by_format(m_dpSrc, vsXs[ii]);
		vInput.Add(dValue);
	}
	return nSize;
}

int		InterpXYDlg::GetOutput(const vector& vInput, vector& vOutput)
{
	vector vInputLocal;
	vInputLocal = vInput;
	vOutput.SetSize(vInputLocal.GetSize());
	if ( vInputLocal.GetSize() > 0 )
	{
		vector vX, vY;
		if ( !m_dpSrc || m_dpSrc.GetDataPoints(m_stParams.ni1, m_stParams.ni2, vX, vY) <= 0 )
		{
			ASSERT(false);
			return -1;
		}
		
		GraphLayer gl;
		m_dpSrc.GetParent(gl);
		int nXScale = LINEAR_SPACE, nYScale = LINEAR_SPACE;
		nXScale = gl.X.Type;
		nYScale = gl.Y.Type;
		
		vInputLocal = real_space(vInputLocal, nXScale);
		vX = real_space(vX, nXScale);
		vY = real_space(vY, nYScale);
		;
		int nRet = ocmath_interpolate(vInputLocal, vOutput, vInputLocal.GetSize(), vX, vY, vX.GetSize(), m_stParams.nMethod, m_stParams.dSmoothFactor, NULL, NULL, 0, m_stParams.nBoundary);
		if ( OE_NOERROR != nRet )
			return -2;
		vInputLocal = real_inv_space(vInputLocal, nXScale);
		vOutput = real_inv_space(vOutput, nYScale);
	}
	return vOutput.GetSize();
}

int		InterpXYDlg::Calculate(vector& vInput, vector& vOutput)
{
	vInput.SetSize(0);
	vOutput.SetSize(0);
	if ( GetInput(vInput) > 0 )
		GetOutput(vInput, vOutput);
	
	return vOutput.GetSize();
}

BOOL	InterpXYDlg::OnClickGoToWorksheet(Control ctrl)
{
	string strWorksheet = m_edtWorksheetName.Text;
	Worksheet wks(strWorksheet);
	if ( wks.IsValid() )
	{
		wks.CheckShowActivate();
	}
	return TRUE;
}

BOOL	InterpXYDlg::OnOutputWorksheetChange(Control ctrl)
{
	return TRUE;
}

void	InterpXYDlg::InitControls()
{
	m_btnOutputScriptWindow = GetItem(IDC_OUTPUT_TO_SCRIPTWINDOW);
	m_btnOutputResultLog = GetItem(IDC_OUTPUT_TO_RESULTLOG);
	m_btnOutputWorksheet = GetItem(IDC_OUTPUT_TO_WORKSHEET);
	m_edtWorksheetName = GetItem(IDC_OUTPUT_WORKSHEET_NAME);
	m_edtX = GetItem(IDC_X_VALUES);
	m_edtY = GetItem(IDC_Y_VALUES);
	RichEdit edHint = GetItem(IDC_FINDXY_HINT);
	if(edHint)
	{
		edHint.Enable = false;
		edHint.Text = _L("Enter semicolon separated values to find multiple values.");
		edHint.SetTextColor(0, -1, color_index_to_rgb(SYSCOLOR_BLUE));
	}
	
	m_edtY.ReadOnly = TRUE;	///Sophy 6/30/2010 ORG-23-S0 MAKE_EDIT_CONTROL_READONLY_TO_ALLOW_COPY
	
	Button btnInterp = GetItem(IDC_BTN_INTERP);
	btnInterp.Text = _L("Interpolate");
}

void	InterpXYDlg::InitRangeText()
{
	Control ctrlRangeHints = GetItem(IDC_RANGE_HINTS);
	GraphLayer glSrc = Project.ActiveLayer();
	if ( glSrc )
	{
		m_dpSrc = glSrc.DataPlots(m_stParams.nPlotIndex);
		if ( m_dpSrc )
		{
			vector vX, vY;
			if ( m_dpSrc.GetDataPoints(m_stParams.ni1, m_stParams.ni2, vX, vY) <= 0 )
			{
				ASSERT(false);
				return;
			}
			double dMinX, dMaxX, dMinY, dMaxY;
			vX.GetMinMax(dMinX, dMaxX);
			vY.GetMinMax(dMinY, dMaxY);
			string strRngHints;
			strRngHints.Format("X Range = [%s, %s]\r\nY Range = [%s, %s]", get_value_by_format(m_dpSrc, dMinX), get_value_by_format(m_dpSrc, dMaxX), ftoa(dMinY), ftoa(dMaxY));
			ctrlRangeHints.Text = strRngHints;
		}
	}
}

void	InterpXYDlg::LoadSettings()
{
	m_nOutputTarget = LoadSetting("OutputTarget", 0, STR_INTERP_DLG_NAME);
	m_btnOutputScriptWindow.Value = (OUTPUT_TO_SCRIPTWINDOW == m_nOutputTarget);
	m_btnOutputResultLog.Value = (OUTPUT_TO_RESULTLOG == m_nOutputTarget);
	m_btnOutputWorksheet.Value = (OUTPUT_TO_WORKSHEET == m_nOutputTarget);
	
	string strWorksheet;
	dlg_load_registry(STR_INTERP_DLG_NAME, "OutputWorksheet", strWorksheet, "[InterpXY]Result");
	m_edtWorksheetName.Text = strWorksheet;
}

void	InterpXYDlg::SaveSettings()
{
	SaveSetting("OutputTarget", m_nOutputTarget, STR_INTERP_DLG_NAME);
	dlg_save_to_registry(STR_INTERP_DLG_NAME, "OutputWorksheet", m_edtWorksheetName.Text);
}

void	InterpXYDlg::UpdateButtonState()
{
	m_edtWorksheetName.Enable = m_btnOutputWorksheet.Value;
	string strWorksheet = m_edtWorksheetName.Text;
	BOOL bEnable = m_edtWorksheetName.Enable;
	if ( bEnable )
	{
		Worksheet wks(strWorksheet);
		bEnable = wks.IsValid();
	}
	Button btnGotoReport = GetItem(IDC_BTN_GO_TO_REPORT);
	btnGotoReport.Enable = bEnable;
}

void	OpenInterpXYDlg(InterpParams& stParams)
{
	InterpXYDlg dlg;
	dlg.DoModalEx(stParams, GetWindow());
	return;
}

///end XY_INTERP_FOR_GADGET_TOOL_DLG

///------ Folger 12/02/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
IntegrateMissingValueHelper::IntegrateMissingValueHelper(vector& vx, vector& vy, BOOL bNeedRestore)
{
	m_pvx = &vx;
	m_pvy = &vy;
	ASSERT(m_pvx->GetSize() == m_pvy->GetSize());
	int nOldSize = vx.GetSize();
	int nSize = ocmath_1d_remove_missingvalue(vx, vy, nOldSize);
	if ( nSize >= 0 && nSize < nOldSize )
	{
		vx.SetSize(nSize);
		vy.SetSize(nSize);
		m_bNeedRestore = bNeedRestore;
		if ( m_bNeedRestore )
		{
			m_vBackupX = vx;
			m_vBackupY = vy;
		}
	}
	else
		m_bNeedRestore = FALSE;
}

IntegrateMissingValueHelper::~IntegrateMissingValueHelper()
{
	if ( m_bNeedRestore )
	{
		*m_pvx = m_vBackupX;
		*m_pvy = m_vBackupY;
	}
}

int		IntegrateMissingValueHelper::GetSize()
{
	return m_pvx->GetSize();
}

///------ Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
//IntegToolHelper::IntegToolHelper(vector& vx, vector& vy, double& x1, double& x2)
IntegToolHelper::IntegToolHelper(vector& vx, vector& vy, double& x1, double& x2, vector* pvxPlot/* = NULL*/, vector* pvyPlot/* = NULL*/)
///------ End QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
{
	m_pvX = &vx;
	m_pvY = &vy;
	m_pX1 = &x1;
	m_pX2 = &x2;

	///------ Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
	if ( pvxPlot && pvyPlot )
	{
		m_vxPlot = *pvxPlot;
		m_vyPlot = *pvyPlot;
	}
	///------ End QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
	
	///Philip 07/18/2012 ORG-6183 INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
	m_bIsCurveInteg = false;//default
	///end INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
}
IntegToolHelper::~IntegToolHelper()
{
}

string	IntegToolHelper::CreateArea(GraphLayer& gl, LPCSTR lpcszName)
{
	if ( m_goIntegArea )
		return FALSE;

	m_goIntegArea = gl.CreateGraphObject(GROBJ_TN_POLYGON, lpcszName);
	m_goIntegArea.Attach = ATTACH_TO_SCALE;
	set_go_selectable(m_goIntegArea, false);
	set_go_behind_data(m_goIntegArea);
	UpdateAreaSettings();
	return m_goIntegArea.GetName();
}

BOOL	IntegToolHelper::UpdateAreaSettings(BOOL bShow/* = TRUE*/)
{
	if ( !m_goIntegArea )
		return FALSE;

	Tree trFmt;
	trFmt.Root.Border.Width.nVal = 0; //no border
	trFmt.Root.Fill.Pattern.Style.nVal = 0; //none
	trFmt.Root.Fiil.Pattern.PatternColor.nVal = 0; //black
	trFmt.Root.Fill.Pattern.UseBorderColor.nVal = 0;
	trFmt.Root.Fill.Pattern.Width.nVal = 1;
	trFmt.Root.Fill.Color.nVal = 18; //light gray
	m_goIntegArea.UpdateThemeIDs(trFmt.Root);
	m_goIntegArea.ApplyFormat(trFmt, true, true);
	
	return m_goIntegArea.Show(bShow);
}

BOOL	IntegToolHelper::Integ(IntegrationResult& pInteg, BOOL bNeedExtrapolate/* = FALSE*/, BOOL bLimitToRect/* = TRUE*/, int nAreaType/* = MATHEMATICAL_AREA*/, IntegInfo* pstInfo/* = NULL*/, int nBaselineRange/* = BASELINE_RANGE_WITHIN_ROI*/)
{
	vector vx, vy;
	vx = *m_pvX; vy = *m_pvY;
	IntegrateMissingValueHelper			clHelper(vx, vy, FALSE);
	int		nSize = clHelper.GetSize();
	
	vector vIntgCurve;
	vIntgCurve.SetSize(nSize);
	
	if( nSize > 1) 
	{
		{
			IntegrateMissingValueHelper			clHelperBase(m_vbx, m_vby, TRUE);
			vector	vby;
			vby = m_vby;
			int		nvbxSize = m_vbx.GetSize();
			
			/// Sen 08/25/2011 ORG-2298-P2 MAKE_BASELINE_TAB_WORK_CORRECTLY
			if(BASELINE_RANGE_WITHIN_ROI == nBaselineRange)
			{
			/// End MAKE_BASELINE_TAB_WORK_CORRECTLY
				if ( nvbxSize > nSize )
				{
					ASSERT(nvbxSize - nSize <= 2);
					if ( m_vbx[0] < vx[0] )
						vby.RemoveAt(0);
					if ( m_vbx[nvbxSize - 1] > vx[nSize - 1] )
						vby.RemoveAt(vby.GetSize() - 1);
				}
			}
			int nRet = ocmath_integrate( vx, vy, 0, nSize-1, &pInteg, vIntgCurve, nAreaType, vby, TRUE);
			if(nRet != OE_NOERROR)
			{
				error_report("error return in ocmath_integrate");
			}
			
			if(bLimitToRect)
			{
				IntegrateMissingValueHelper			clHelperEx(m_vxEx, m_vyEx, TRUE);
				
				int		nSizeEx = clHelperEx.GetSize();
				int nDataPtsIntegrated = nSizeEx + 2;
				vIntgCurve.SetSize(nDataPtsIntegrated);
				
				IntegrationResult pIntegJunk;
				vector vobx(nDataPtsIntegrated);
				vector voby(nDataPtsIntegrated);
				vector vbxEx, vbyEx;
				vbxEx = m_vxEx;
				vbyEx.SetSize(vbxEx.GetSize());
				
				int nRet = ocmath_interpolate(vbxEx, vbyEx, vbxEx.GetSize(), m_vbx, m_vby, m_vbx.GetSize());
				if(0 != nRet)
				{
					error_report("fail to interpolate baseline curvePeakInteg.");
					return FALSE;
				}	
				
				DWORD dwOption = OCMATH_INTEGRATE_WITH_BOUNDS_SORT;
				if(bNeedExtrapolate)
					dwOption |=  OCMATH_INTEGRATE_WITH_BOUNDS_EXTRAPOLATE;;
				nRet = ocmath_integrate_with_bounds(m_s1,m_s2, nSizeEx, m_vxEx, m_vyEx, &pIntegJunk, vbyEx,  nAreaType, &nDataPtsIntegrated, vIntgCurve, vobx, voby, dwOption, SEARCH_FROM_PEAK);
				if(nRet != OE_NOERROR)
				{
					error_report("error return in ocmath_integrate_with_bounds");
				}
				ASSERT(nRet == 0);
				vIntgCurve.SetSize(nDataPtsIntegrated);
				vobx.SetSize(nDataPtsIntegrated);
				voby.SetSize(nDataPtsIntegrated);
				pInteg.Area = pIntegJunk.Area;
				
				vx = vobx;
			}
		}
	}
	else
	{
		pInteg.x1 = pInteg.x2 = vx[0];
	}
	
	*m_pX1 = pInteg.x1;
	*m_pX2 = pInteg.x2;
	m_Area = pInteg.Area;
	m_dxPeak = pInteg.dxPeak;	///Sophy 2/24/2012 ORG-5151-S1 SHOW_FWHM_INSTEAD_OF_ROI_X_RANGE_ON_TOP
	if ( pstInfo )
	{
		pstInfo->nSize = nSize;
		pstInfo->vx = vx;
		pstInfo->vy = vy;
		pstInfo->vIntgCurve = vIntgCurve;
	}
	
	return TRUE;
}

void IntegToolHelper::Sort(vector& vX, vector& vY, DWORD dwSortOptions)
{
	vector<uint> vnIndices;
	vX.Sort(dwSortOptions, TRUE, vnIndices);
	vY.Reorder(vnIndices);
}

BOOL	IntegToolHelper::RemoveMissingValuesAndSort(vector& vX, vector& vY, DWORD dwSortOptions, vector& vxRef/* = NULL*/, vector& vyRef/* = NULL*/)
{
	ASSERT(vX.GetSize() == vY.GetSize());
	if ( vX.GetSize() != vY.GetSize() || vX.GetSize() == 0 )
		return FALSE;
	
	IntegrateMissingValueHelper		clHelper(vX, vY, FALSE);	
	Sort(vX, vY, dwSortOptions);
	return TRUE;
}

/// Sen 08/29/2011 ORG-2298-P9 MAKE_FULL_RANGE_HATCH_AREA_CORRECT
//void	IntegToolHelper::InterploateRectBounds(vector& vX, vector& vY, double& dY1, double& dY2, BOOL bNeedExtrap, DataPlot& Plot)
void	IntegToolHelper::InterploateRectBounds(vector& vX, vector& vY, double& dY1, double& dY2, BOOL bNeedExtrap, DataPlot& Plot, vector* pvInterpolateX/* = NULL*/, vector* pvInterpolateY/* = NULL*/)
/// End MAKE_FULL_RANGE_HATCH_AREA_CORRECT
{
	BOOL	bLeftBound = FALSE, bRightBound = FALSE;
	///------ Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
	//vector	vPlotX, vPlotY;
	//XYRange xyData;
	//if ( Plot.GetDataRange(xyData, 0, -1) && xyData && xyData.GetData(vPlotY, vPlotX) )
	if ( m_vxPlot.GetSize() == 0 )
	{
		XYRange		xyData;
		if ( Plot.GetDataRange(xyData, 0, -1) && xyData )
			xyData.GetData(m_vyPlot, m_vxPlot);
	}
	if ( m_vxPlot.GetSize() > 0 )
	///------ End QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
	{
		double dMin, dMax;
		///------ Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
		//vPlotX.GetMinMax(dMin, dMax);
		m_vxPlot.GetMinMax(dMin, dMax);
		///------ End QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
		if ( m_s1 > m_s2 )
		{
			double dTemp = m_s1;
			m_s1 = m_s2;
			m_s2 = dTemp;
		}
		if ( dMin > m_s1 )
			bLeftBound = TRUE;
		if ( dMax < m_s2 )
			bRightBound = TRUE;
	}
	
	dY1 = dY2 = NANUM;
	/// Sen 08/29/2011 ORG-2298-P9 MAKE_FULL_RANGE_HATCH_AREA_CORRECT
	//IntegrateMissingValueHelper		clhelper(m_vxEx, m_vyEx, TRUE);
	vector&		vInterpolateX = pvInterpolateX ? *pvInterpolateX : m_vxEx;
	vector&		vInterpolateY = pvInterpolateY ? *pvInterpolateY : m_vyEx;
	/// End MAKE_FULL_RANGE_HATCH_AREA_CORRECT
	///Philip 08/20/2012 ORG-6519-P1 FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
	//vector&		m_vX = *m_pvX;
	//if ( m_vX[0] > m_s1 && (bNeedExtrap || !bLeftBound) )
	bool bIsAscending = (vX[0] <= vX[vX.GetSize() - 1]);
	bool bLeftGap = bIsAscending ? m_s1 < vX[0] : m_s1 < vX[vX.GetSize() - 1];
	bool bRightGap = bIsAscending ? m_s2 > vX[vX.GetSize() - 1] : m_s2 > vX[0];
	if ( bLeftGap && (bNeedExtrap || !bLeftBound) )
	///end FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
	{
		/// Sen 08/29/2011 ORG-2298-P9 MAKE_FULL_RANGE_HATCH_AREA_CORRECT
		//ocmath_interpolate(&m_s1, &dY1, 1, m_vxEx, m_vyEx, m_vxEx.GetSize());
		ocmath_interpolate(&m_s1, &dY1, 1, vInterpolateX, vInterpolateY, vInterpolateX.GetSize());
		/// End MAKE_FULL_RANGE_HATCH_AREA_CORRECT
		///Philip 08/20/2012 ORG-6519-P1 FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
		//vX.InsertAt(0, m_s1);
		//vY.InsertAt(0, dY1);
		_insert_point_at_head_or_tail_of_curve(bIsAscending, true, vX, vY, m_s1, dY1);
		///end FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
	}
	///Philip 08/20/2012 ORG-6519-P1 FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
	//if ( m_vX[m_vX.GetSize() -1] < m_s2 && (bNeedExtrap || !bRightBound) )
	if ( bRightGap && (bNeedExtrap || !bRightBound) )
	///end FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
	{
		/// Sen 08/29/2011 ORG-2298-P9 MAKE_FULL_RANGE_HATCH_AREA_CORRECT
		//ocmath_interpolate(&m_s1, &dY1, 1, m_vxEx, m_vyEx, m_vxEx.GetSize());
		ocmath_interpolate(&m_s2, &dY2, 1, vInterpolateX, vInterpolateY, vInterpolateX.GetSize());
		/// End MAKE_FULL_RANGE_HATCH_AREA_CORRECT
		///Philip 08/20/2012 ORG-6519-P1 FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
		//vX.Add(m_s2);
		//vY.Add(dY2);
		_insert_point_at_head_or_tail_of_curve(bIsAscending, false, vX, vY, m_s2, dY2);
		///end FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
	}
}

#define		CHECK_HIDE_INTEG_AREA_AND_RETURN \
			if ( vY.GetSize() == 0 ) \
			{ \
				m_goIntegArea.Show(FALSE); \
				return FALSE; \
			}


BOOL	IntegToolHelper::UpdateIntegArea(DataPlot& Plot, BOOL bLimitToRect/* = TRUE*/, BOOL bNeedExtrap/* = FALSE*/, BOOL bShow/* = TRUE*/)
{		
	if ( !m_goIntegArea )
		return FALSE;
	
	vector vX, vY;
	vX = *m_pvX;	vY = *m_pvY;
	CHECK_HIDE_INTEG_AREA_AND_RETURN;
	
	///Philip 07/18/2012 ORG-6183 INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
	//save baseline XY
	vector vbxSaved, vbySaved;
	if(m_bIsCurveInteg)
	{
		vbxSaved = m_vbx;
		vbySaved = m_vby;
	}
	///end INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
	
	if ( bLimitToRect )
	{
		double	dY1 = NANUM;
		double	dY2 = NANUM;
		InterploateRectBounds(vX, vY, dY1, dY2, bNeedExtrap, Plot);
	}
	RemoveMissingValuesAndSort(vX, vY, SORT_ASCENDING, m_vbx, m_vby);
	
	CHECK_HIDE_INTEG_AREA_AND_RETURN;
	
	GraphLayer		gl;
	Plot.GetParent(gl);
	int		nScale = gl.Y.Type;
	vector<uint> vnIndices;
	if ( nScale == SCALE_TYPE_LOG10 || nScale == SCALE_TYPE_LN || nScale == SCALE_TYPE_LOG2 )
	{
		m_vby.Find(MATREPL_TEST_LESSTHAN | MATREPL_TEST_EQUAL, gl.Y.From, vnIndices);
		m_vby.Replace(vnIndices, gl.Y.From);
	}
	vnIndices.SetSize(0);
	m_vby.Find(MATREPL_TEST_EQUAL, NANUM, vnIndices);
	m_vby.Replace(vnIndices, gl.Y.From);
	vnIndices.SetSize(0);
	m_vbx.Find(MATREPL_TEST_LESSTHAN, vX[0], vnIndices);
	m_vbx.Replace(vnIndices, NANUM);
	vnIndices.SetSize(0);
	m_vbx.Find(MATREPL_TEST_GREATER, vX[vX.GetSize() - 1], vnIndices);
	m_vbx.Replace(vnIndices, NANUM);
	
	/// Sen 08/29/2011 ORG-2298-P9 MAKE_FULL_RANGE_HATCH_AREA_CORRECT
	//RemoveMissingValuesAndSort(m_vbx, m_vby, SORT_DESCENDING);
	//vX.Append(m_vbx);
	//vY.Append(m_vby);
	///Sophy 10/20/2011 ORG-4113-P1 WRONG_INTEG_AREA_IN_INTEG_GADGET_PREVIEW restore Sen's change here
	/*
	vector vbxex, vbyex;
	vbxex = m_vbx;
	vbyex = m_vby;
	if ( bLimitToRect )
	{
		double	dY1 = NANUM;
		double	dY2 = NANUM;
		InterploateRectBounds(vbxex, vbyex, dY1, dY2, bNeedExtrap, Plot, &vbxex, &vbyex);
	}
	RemoveMissingValuesAndSort(vbxex, vbyex, SORT_DESCENDING);
	vX.Append(vbxex);
	vY.Append(vbyex);
	*/
	///Philip 07/18/2012 ORG-6183 INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
	if(m_bIsCurveInteg)
	{
		RemoveMissingValuesAndSort(m_vbx, m_vby, SORT_ASCENDING);
		RemoveMissingValuesAndSort(vbxSaved, vbySaved, SORT_ASCENDING);//ensure baseline is ordered and clean
		if ( bLimitToRect )
		{
			double	dY1 = NANUM;
			double	dY2 = NANUM;
			//interpolate rect bound for BASELINE
			InterploateRectBounds(m_vbx, m_vby, dY1, dY2, bNeedExtrap, Plot, &vbxSaved, &vbySaved);
		}
		Sort(m_vbx, m_vby, SORT_DESCENDING);//no missing vals in m_vbx, m_vby; just sort in reverse order
	}
	else
	///end INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
	{
		RemoveMissingValuesAndSort(m_vbx, m_vby, SORT_DESCENDING);
	}
	vX.Append(m_vbx);
	vY.Append(m_vby);
	///end WRONG_INTEG_AREA_IN_INTEG_GADGET_PREVIEW
	///End MAKE_FULL_RANGE_HATCH_AREA_CORRECT
	
	Tree trFmt;
	trFmt = m_goIntegArea.GetFormat(FPB_DATA, FOB_ALL, TRUE, TRUE);
	trFmt.Root.Data.X.dVals = vX;
	trFmt.Root.Data.Y.dVals = vY;
	m_goIntegArea.ApplyFormat(trFmt, TRUE, TRUE);
	
	m_goIntegArea.Show(bShow);
	
	return TRUE;
}
///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK

///------ Folger 03/18/2011 ORG-2479-S1 MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS
TreeNode	roi_get_gui_tree(TreeNode& tr)
{
	TreeNode	trGUI = tr.trGUI;
	if ( !trGUI )
		trGUI = tr;
	
	return trGUI;
}

bool	roi_is_event_from_preference_dlg(TreeNode& tr)
{
	GUI_TREE(trGUI, tr);

	string strXFName;
	if ( trGUI.GetAttribute(STR_XFNAME_ATTRIB, strXFName) && !strXFName.IsEmpty() )
		return true;
	return false;
}
///------ End MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS

///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
void	gadget_gui_apply_support(TreeNode& trGUI, PEVENT_GETN pfnGetN, PAPPLY_FUNC pfnApply)
{
	GETN_USE(trGUI)
	GETN_STR(GETNEVT, "EventHandle", "")	GETN_GLOBAL_EVT(pfnGetN)				GETN_CURRENT_SUBNODE.Show = false;
	GETN_STR(APPLYEVT, "ApplyHandle", "")	GETN_APPLY_EVT(pfnApply)				GETN_CURRENT_SUBNODE.Show = false;
}
///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET

bool	init_shape_position(TreeNode& trGUI, bool bCheckInitAttrib/* = true*/)
{
	if ( !trGUI )
		return false;
	
	TreeNode trROI = trGUI.roi;
	if ( !trROI )
		return false;
	
	TreeNode trShapeProp = trROI.shapeProp;
	if ( !trShapeProp )
		return false;
	
#define	STR_SHAPE_INIT	"InitValue"
	int nInit = 0;
	if ( bCheckInitAttrib && trShapeProp.GetAttribute(STR_SHAPE_INIT, nInit) && nInit == 1 )
		return false; //already init
	
	GraphLayer gl = Project.ActiveLayer();
	if ( gl )
	{
		double dX1, dX2, dY1, dY2;
		dX1 = gl.X.From;
		dX2 = gl.X.To;
		dY1 = gl.Y.From;
		dY2 = gl.Y.To;
		///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		//trShapeProp.xCenter.dVal = (dX1 + dX2)/2;
		//trShapeProp.yCenter.dVal = (dY1 + dY2)/2;
		//trShapeProp.width.dVal = (dX2 - dX1) * 0.6; //60 percent
		//trShapeProp.height.dVal = (dY2 - dY1) * 0.6;
		DataPlot m_dp = gl.DataPlots(-1); //get active plot
		///Sophy 12/1/2011 ORG-4487-P1 INIT_POSITION_FOR_NON_LINEAR_SCALE_GRAPH
		//trShapeProp.xFrom.strVal = get_value_by_format(m_dp, dX1 + (dX2 - dX1) * 0.2, 0, true);
		//trShapeProp.xTo.strVal = get_value_by_format(m_dp, dX2 - (dX2 - dX1) * 0.2, 0, true);
		//trShapeProp.yFrom.strVal = get_value_by_format(m_dp, dY1 + (dY2 - dY1) * 0.2, 0, false); //60 percent
		//trShapeProp.yTo.strVal = get_value_by_format(m_dp, dY2 - (dY2 - dY1) * 0.2, 0, false);
		int nXScaleType = gl.X.Type, nYScaleType = gl.Y.Type;
		if ( SCALE_TYPE_LINEAR != nXScaleType )
		{
			dX1 = real_space(dX1, nXScaleType);
			dX2 = real_space(dX2, nXScaleType);
		}
		if ( SCALE_TYPE_LINEAR != nYScaleType )
		{
			dY1 = real_space(dY1, nYScaleType);
			dY2 = real_space(dY2, nYScaleType);
		}
		double dMinX = dX1 + fabs(dX2 - dX1) * 0.2;
		double dMaxX = dX2 - fabs(dX2 - dX1) * 0.2;
		double dMinY = dY1 + fabs(dY2 - dY1) * 0.2;
		double dMaxY = dY2 - fabs(dY2 - dY1) * 0.2;
		if ( SCALE_TYPE_LINEAR != nXScaleType )
		{
			dMinX = real_inv_space(dMinX, nXScaleType);
			dMaxX = real_inv_space(dMaxX, nXScaleType);
		}
		if ( SCALE_TYPE_LINEAR != nYScaleType )
		{
			dMinY = real_inv_space(dMinY, nYScaleType);
			dMaxY = real_inv_space(dMaxY, nYScaleType);
		}
		///Sophy 12/23/2011 ORG-4611-P1 PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
		//trShapeProp.xFrom.strVal = get_value_by_format(m_dp, dMinX, 0, true);
		//trShapeProp.xTo.strVal = get_value_by_format(m_dp, dMaxX, 0, true);
		//trShapeProp.yFrom.strVal = get_value_by_format(m_dp, dMinY, 0, false); //60 percent
		//trShapeProp.yTo.strVal = get_value_by_format(m_dp, dMaxY, 0, false);
		///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		//double dOffsetX = gl.X.From;
		//double dOffsetY = gl.Y.From;
		//trShapeProp.xFrom.strVal = get_value_by_format(m_dp, dMinX, 0, true, &dOffsetX);
		//trShapeProp.xTo.strVal = get_value_by_format(m_dp, dMaxX, 0, true, &dOffsetX);
		//trShapeProp.yFrom.strVal = get_value_by_format(m_dp, dMinY, 0, false, &dOffsetY); //60 percent
		//trShapeProp.yTo.strVal = get_value_by_format(m_dp, dMaxY, 0, false, &dOffsetY);
		trShapeProp.xFrom.dVal = dMinX;
		trShapeProp.xTo.dVal = dMaxX;
		trShapeProp.yFrom.dVal = dMinY;
		trShapeProp.yTo.dVal = dMaxY;
		
		ColFmtInfo xFmtInfo, yFmtInfo;
		get_plot_source_format(gl, -1, &xFmtInfo, &yFmtInfo);
		if ( LT_FORMAT_NUMERIC != xFmtInfo.m_nLTFormat )
		{
			set_node_datetime_picker(trShapeProp.xFrom, xFmtInfo.m_strDispFmt, LT_FORMAT_DATE == xFmtInfo.m_nLTFormat, xFmtInfo.m_bForDateTimePicker);
			set_node_datetime_picker(trShapeProp.xTo, xFmtInfo.m_strDispFmt, LT_FORMAT_DATE == xFmtInfo.m_nLTFormat, xFmtInfo.m_bForDateTimePicker);
		}
		///Sophy 5/3/2012 ORG-5612-P1 SET_NUMERIC_DISPLAY_FORMAT_WHEN_NOT_DATETIME
		else
		{
			set_node_datetime_picker(trShapeProp.xFrom, "*", false, false);
			set_node_datetime_picker(trShapeProp.xTo, "*", false, false);
		}
		///end SET_NUMERIC_DISPLAY_FORMAT_WHEN_NOT_DATETIME
		if ( LT_FORMAT_NUMERIC != yFmtInfo.m_nLTFormat )
		{
			set_node_datetime_picker(trShapeProp.yFrom, yFmtInfo.m_strDispFmt, LT_FORMAT_DATE == yFmtInfo.m_nLTFormat, yFmtInfo.m_bForDateTimePicker);
			set_node_datetime_picker(trShapeProp.yTo, yFmtInfo.m_strDispFmt, LT_FORMAT_DATE == yFmtInfo.m_nLTFormat, yFmtInfo.m_bForDateTimePicker);
		}
		///Sophy 5/3/2012 ORG-5612-P1 SET_NUMERIC_DISPLAY_FORMAT_WHEN_NOT_DATETIME
		else
		{
			set_node_datetime_picker(trShapeProp.yFrom, "*", false, false);
			set_node_datetime_picker(trShapeProp.yTo, "*", false, false);
		}
		///end SET_NUMERIC_DISPLAY_FORMAT_WHEN_NOT_DATETIME
		///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
		///end PROPER_DISPLAY_TIME_FORMAT_IN_GADGET_TOOL
		///end INIT_POSITION_FOR_NON_LINEAR_SCALE_GRAPH
		///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
		trShapeProp.SetAttribute(STR_SHAPE_INIT, 1);
	}
	return true;
}

///Philip 08/21/2012 ORG-6519-P1 FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER
static bool _insert_point_at_head_or_tail_of_curve(bool vCurve_X_IsAscending, bool bAtHead, vector& vCurve_X, vector& vCurve_Y, const double& dPoint_X, const double& dPoint_Y)
{
	if(vCurve_X.GetSize() != vCurve_Y.GetSize())
		return false;
	
	int iPos;
	if(vCurve_X_IsAscending)
	{//x values are in (non-strict)ascending order, e.g. vCurve_X[0] = 1, vCurve_X[1] = 2, vCurve_X[2] = 3, ...
		if(bAtHead)
			iPos = 0;
		else //at tail
			iPos = vCurve_X.GetSize();
	}
	else
	{//x values are in (strict)descending order, e.g. vCurve_X[0] = 100, vCurve_X[1] = 99, vCurve_X[2] = 98, ...
		if(bAtHead)
			iPos = vCurve_X.GetSize();
		else
			iPos = 0;
	}
	
	return vCurve_X.InsertAt(iPos, dPoint_X) && vCurve_Y.InsertAt(iPos, dPoint_Y);
}
///end FIX_PROBLEM_WHEN_DATA_IN_DESCENDING_ORDER