/*------------------------------------------------------------------------------*
 * File Name: ParamBox.c														*
 * Creation: CPY 1/27/03														*
 * Purpose: Origin C support for a general parameters edit box					*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE				*
 *	CPY 5/20/03 CHECK_BOX_CLICK_OUTSIDE_CHECK_TO_TOGGLE							*
 *	CPY 5/22/03 v7.0589 SHIFT_SHOW_FOR_CLASSES									*
 *	CPY 5/30/03 QA70-4577 EVENT_HANDLER_NEED_DIALOG_AND_VALUE_UPDATE			*
 *	CPY 6/11/03 QA70-4450 v7.0601 TTILE_KEY_TO_BECOME_MODLESS					*
 *	CPY 7/8/03 QA70-4796 v7.0620 GET_N_BOX_EVENT_FUNC_MOVE_WIN					*
 *	CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS							*
 *	CPY 10/11/03 QA70-5332 HELP_CUSTOMIZED										*
 *	CPY v7.5785 12/19/03 QA70-5738 GETN_BOX_COMBO_CHANGE_NEEDED					*
 *	CPY v7.5811 1/30/04 QA70-5910 PREVIEW_GETNBOX								*
 *  Danice v8.0868 5/8/04 QA70-6381 GETNBOX_SAME_AS_GETNVIEWBOX 				*
 *  Danice v8.0870 5/11/04 QA70-6222 GETNTREE_AUTO_LOAD_DEFAULT					*
 *	CPY 6/7/04 LIMIT_GETN_HEIGHT_AND_SCROLL_IF_TOO_HEIGHT						*
 *	CPY 6/11/04 GETN_SAVE_SETTINGS_ONLY_LOAD_DEFAULT_IF_NEW						*
 *	YuI 7/15/04 v7.5909 QA70-6688 OC_TOOLS_IMPLEMENTATION						*
 *  SY 07/21/2004 QA70-6641 MOVE_OC_TREE_UTILITY_TO_VC_LEVEL					*
 *  SY 07/27/2004 QA70-6719 v8.0105 GETN_AUTO_RESIZE_WIDTH_WITH_LONG_LABEL		*
 *  Forest 09/10/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD                     *
 *	CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG							* 
 *	Forest 9/13/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG						*
 *  Iris 9/15/04 GETN_BOX_DLG_CREATE		 									*
 *  Iris 9/15/04 MOVE_DECLARATION_TO_HEADER										*
 *	Forest 9/15/04 QA70-6682 GETN_THEME_FACTORY_DEFAULT							*
 *	CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH								*
 *	CPY 9/24/04 FACTORY_DEFAULT_SAVE_CLASS_NAME_ONLY							*
 *  Forest 9/27/04 QA70-6682 LOAD_THEME_FROM_SYSTEM_AND_USER					*
 *  Danice 9/28/04 QA70-6631 v8.0140 TREE_BRANCH_COLLAPSED_IMPROVEMENT			*
 *	CPY 10/7/04 COMBO_BRANCH_FOR_MULTIPLE_RANGE_MODE							*
 *  Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME					*
 *	YuI 10/28/04 INPUT_DATA_RANGE_INCAPSULATION									*
 *  Danice 11/10/04 v8.0161 SUPPORT_EMPTY_TREENODE_AND_LABEL_CONTROL			*
 *  Danice 11/11/04 QA70-6891 v8.0162 SAVE_ROW_DATA_SET_BOLD_NEEDED				*
 *  Danice 11/15/04 QA70-7169 v8.0163 TREE_ROW_SHOW_ALTERNATE_COLORS			*
 *  Danice 11/16/04 QA70-7169 v8.0162 MARK_EMPTY_GETN_STR						*
 *  Danice 11/29/04 QA70-7169 v8.0167 NEW_WAY_FOR_ALTERNATE_COLORS				*
 *  Danice 12/16/04 v8.0175 ADD_TREENODE_FROM_ROW								*
 *  Iris 12/24/04 GENERATE_READ_BUILD_IN_ADVAN_ID_THEME							*
 *  Iris 12/27/04 IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE							*
 *	Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE								*
 * Frank 1/28/05	GETN_DIALOG_NOT_UPDATE_THEME_DESCRIPTION_IF_EMPTY_STRING	*
 *  DG 3/2/05 ENABLE_ORIGIN_WHEN_MODAL_WINDOW									*
 *	YuI 03/14/05 INTERACTIVE_DROPDOWN_BUTTON_OPTIONAL							*
 *	ML 3/16/2005 MENUACTION_MENUS												*
 *  DG 3/17/05 v8.0204 SUPPORT_GETN_BOX_GRIDVIEW								*
 * Frank 3/22/05	APPLY_ADDTREENODES_WITH_NEW_RULE							*
 *	AW 03/22/05 MORE_ON_ADD_SHOW_ADVANCED_CHECK_BOX								*
 *  DG 3/30/05 v8.0211 VALIDATE_KILL_FOCUS										*
 *  DG 3/30/05 v8.0212 SUPPORT_MAX_HEIGHT_WIDTH_SETTING							*
 *  Frank 3/30/05	TREE_EDIT_SUPPORT_MOVE_ROWS									*
 *  DG 4/2/05 v8.0214 MINI_SIZE_FOR_GETN_BOX									*
 *	ML 4/15/2005 XVAR_DATA_CHANGE_ATT											*
 *	CPY 4/25/05 XY_DATA_RANGE_INTERACTIVE_CONTORL_CHANGE_NOTIFICATION			*
 *  DG 4/27/05 QA70-7631 v8.0227 FIT_SIZE_WHEN_LIST_CHANGED						*
 *	ML 4/29/2005 RETURNING_VALUE_FROM_XFUNCTION									*
 *	DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC									*
 *  Iris 6/02/05 UPDATE_PRO_ID_SETTING											*
 *  DG 6/13/05 v8.0249 VIEW_GRAPH_GETNBOX										*
 *  Iris 06/28/05 v8.0258 FIX_RUNTIME_ERROR_IN_GETN_BOX							*
 *	YuI 07/22/05 INTERACTIVE_CONTROL_SHOULD_BE_EDITABLE_IN_GRAPH				*
 *  SY 8/17/05 QA70-8027 v8.0290 IMPORT_WIZARD_XF								*
 *	AW 08/31/05 FIXING_SAME_TAGNAME_IN_TREE_TABLE								*
 *	Jasmine 09/17/05 v8.0307 SET_AND_GET_THEME_FILE_NAME						*
 *	YuI 09/19/05 QA70-8119 SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT				*
 *	YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES				*
 *	RVD 11/21/2005 QA80-8338 v8.0339 ATTACH_XF_USER_TREE						*
 *	ML 11/21/2005 QA70-8338 ATTACHING_USER_TREE									*
 * CPY 11/24/05 QA70-8363 COMBO_CHANGE_IN_EVENT_NOT_PROPER_UPDATED				*
 *  Iris 12/20/05 QA70-7586 LET_THEME_BOX_ALWAYS_SHOW							*
 *	CPY 12/26/05 GETNGRAPH_BOX_TYPE_4											*
 *	YuI 12/19/05 XFUNCTION_OC_TO_VC_CONVERSION									*
 * EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX						*
 *	ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg									*
 * EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE			*
 * Hong 04/04/06 QA70-6903 FIXED_ERROR_OUTPUT_OF_HIDDEN_NODE                    *
 *	TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON									*
 *	TD 6-23-06 FILE_BROWSER_NO_WORKING_WITH_INVALID_FILE_NAME					*
 *	CPY 8/11/06 IMAGE_OPEN_DLG_MOVED_TO_GETN									*
 *	CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY								*
 *	CPY 9/9/2006 IMAGE_GETN_PREVIEW_UPDATE_WHEN_INPUT_CHANGED					*
 *	CPY 10/2/06 FILE_DIALOG_SHOW_ASCII_FOR_ALL_IMPORT							*
 *  SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET						*
 *	Jasmine 10/13/06 QA70-9037 NEW_SAVE_AS_DIALOG								*
 *  Iris 10/25/06 GET_RUNTIME_ERR_AFTER_EDIT_DATA_CONTROL_FOR_XYRANGE			*
 *	Jasmine 10/26/06 KEEP_DLG_MODEL												*
 *	CPY 10/31/06 SIMPLE_GETN_DLG_CODE_MOVED_TO_GETNPREW_AND_GETNIMAGE_DLG		*
 *  Iris 11/01/06 v8.0502d FIX_MSG_BOX_FAIL_TO_SHOW_IN_GETN_PREVW_DLG			*
 *  Iris 12/06/2006 CANCEL_FILE_SEL_SHOULD_NOT_OEPN_XF_DLG						*
 *  Iris 12/18/2006 v8.0527 SHOW_LONG_NAME_ON_PAGES_BOX							*
 *	Jasmine 01/11/07 OPEN_REPORT_TREE_BROWSER									*
 *	Jasmine 01/18/07 ADD_REPORT_TREE_FILTER_STRING								*
 * 	Hong 01/22/07 FIX_SAVE_DIALOG_FAIL_WITH_GROUP_TYPE							*
 *	Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS							*
 *	Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY							*
 *  Iris 02/25/2007 v8.0570 FIX_CHANGE_GRID_BUT_ENTER_CUSTOMBUTTON_EVENT		*
 *	Jake 04/16/07 DEBUG_FOR_SAVE_AS_DIALOG										*
 *	Jasmine 04/20/07 QA70-9655 USE_NEW_BROWSE_FOR_FOLDER_DLG					*
 *	Jasmine 05/09/07 FIX_THEME_SAVE_GROUP_RESIZE_BUG							*
 *	TD 5-10-2007 XFUNCTION_BUILDER_NOT_INFORM_ON_RANGE_CHANGE					*
 *	CPY 5/16/07 QA70-9659 GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME				*
 *	Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG				*
 *	CPY 6/4/2007 TREE_NODE_CHANGE_VAL_LEAD_TO_GRID_MESSED_UP					*
 *	Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE									*
 *	EJP 2007-06-05 v8.0634 XF_ARG_SUPPORT_MULTISEL_FILE_DLG						*
 *	Joseph 06/12/07 v8.0639b  FIX_BUG_ON_CHANGE_DEFAULT_DATA					*
 *	Folger 06/18/08 REMOVE_STR_ENABLE_EMBED_ATTRIB								*
 *	Folger 06/20/07 OPEN_SHEETS_BROWSER											*
 *	Folger 06/20/07 CREATE_DLG_MODEL											*
 *	Sim 06-30-2007 THEME_APPIED_SHOUND_DEFAULT_UPDATE_GRID						*
 *  Iris 07/04/2007 v8.0655 INCORRECT_TYPE_LIST_FOR_ALL_FILES_TYPE_IN_EXP_ASC_XF*
 *	Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE							*
 *	Hong 07/13/07 v8.0659 NEED_COMMON_DESCIPTION								*
 *	Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER			*
 *	Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE									*
 *	EJP 2007-08-09 v8.0768 QA70-10171 FIX_IMG_MISSING_IN_IMG_PREVIEW_DLG		*
 *	EJP 2007-08-21 v8.0687 QA70-10280 FIX_DEFAULT_PATH_FOR_XF_FILE_AND_FILES_ARG*
 *	Cheney 2007-9-28 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_INTO_THEME_AS_MAX_SAID*
 *	Sim 10-12-2007 QA70-10520 CENTRALIZE_MAKE_PAGE_SHORT_LONG_NAME				*
 *	Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO									*
 *	Sim 12-06-2007 IMPROVE_EVENT1_PARAM_STR_AUX									*
 *	Arvin 12/24/07 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
 *	Jasmine 02/29/08 QA80-11043-P2 GETN_BUTTONS_SEPARATELY_ENABLE_DISABLE		*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Hong 07/18/08 QA80-11861 FIX_FILE_GROUP_FAIL_USING_DEFAULT_PATH				*
 *	Sim 09-05-2008 CLEAN_DEFAULT_THEME											*
 *  Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN			*
 *	Sophy 12/18/2008 v8.0988 QA80-12798 CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU*
 *	Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON						*
 *	Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5				*
 *  Iris 03/25/2009 QA80-13295-P3 GOTO_DLG_SUPPORT_COL_BROWSER					*
 *	Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
 *	Folger 05/04/09 QA80-13552 GRAPH_BROWSER_NEEDS_MORE_CONTROL_OPTIONS			*
 *	Folger 06/15/09 QA80-13771 GRAPH_BROWSER_SUPPORT_GENERAL_CUSTOMIZATION_BY_SPECIFIC_FILTER_FUNCTION
 *	Jasmine 07/16/09 #13952 HIDDEN_CONTROL_IS_IGNORED_IN_MOVING_AND_APPEAR_IN_BAD_POSITION 
 *	Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS			*
 *	YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION						*
 *	Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Jasmine 03/14/11 ORG-2375-P2 EXP_WKS_NEED_BROWSE_REPORT_SHEET				*
 *	Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
 *	CPY 7/14/2011 IMAGE_THUMBNAIL_CHKBOX_CRASH									*
 *	CPY 7/28/2011 ORG-3350-P1 SHOULD_BE_ABLE_TO_SHIP_BUILT_IN_FUNCTION_THEMES	*
 *  Sen 08/01/2011 ORG-2629-P5 NO_LAST_USED_THEME_CREATED_AFTER_USING          *
 *	Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *  Sen 08/03/2011 ORG-2629-P7 TO_FIX_CLICK_SAVE_TO_NEW_THEME_BUT_NO_DIALOG_OPENS
 *	Kenny 08/17/2011 ORG-3535-P1 FIND_AND_REPLACE_DIALOG_FLICKERING_WHEN_RESIZE	*
 *	Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
 *	Zech 10/10/2011 ORG-4001-P1 GRAY_OUT_DELETE_SUBMENU_IN_THEME_DROPDOWN_WHEN_NO_THEME_AVAILABLE_EXCEPT_FOR_LAST_USED
 *	Kenny 10/10/2011 ORG-4051-P1 FIND_AND_REPLACE_CLICK_SKIP_LINKED_CELLS_CHECKBOX_DRAWING_BUG*
 *	Zech 12/17/2011 ORG-4452-P1 ENABLE_DROPDOWN_IN_GETNBOX_COLUMN_BROWSER		*
 *	Folger 02/07/2012 ORG-4452-P2 LT_GETN_SHOULD_GET_RANGE_STRING_FROM_COLUMN_BROWSER
 *	Folger 03/19/2012 ORG-5311-P1 RUNTIME_ERROR_WHEN_DELETE_LAST_VAR_IN_XF_BUILDER
 *	Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
 *	Folger 06/05/2012 ORG-5592-S1 SUPPRT_CUSTOM_COLUMN_IDENTIFIER_IN_OPERATION_TOOLS
 *	Folger 07/03/2012 ORG-6076 SUPPRT_GET_SELECTION_RANGE_FROM_INTERATIVE_CONTROL_FROM_OC
 *	Folger 07/16/2012 ORG-6225-P1 SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
 *	Philip 08/02/2012 ORG-6395-P1 GRAY_OUT_DELETE_IN_THEME_MENU_OF_3DPARAMETRICFUNCPLOT_DIALOG
 *	Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
 *	Folger 09/18/2012 ORG-6861 SUPPORT_LT_GETN_MATRIX_BROWSER					*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>

#pragma labtalk(0) //--- CPY 7/26/05 hide all functions in this file from LT access, as XF should be used instead

#include "DialogEx.h" // CPY 7/2/04 consoidate all dialog related headers into a single one
#include "XFunctionEx.h" //CPY 2/6/06
#include <image_utils.h>/// CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY
#include <xfutils.h> /// CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY
#define BASE_WINDOW MultiPaneDlg
#include "TreeEditEvents.h"
//#include <Profiler.h>


//#define _MEASUER_TIME
#define HOUR_GLASS			waitCursor junk;
#ifdef _MEASUER_TIME
	#include <Profiler.h>
	#define PROFILE_HRGLASS		Profiler junk;
#else
	#define PROFILE_HRGLASS		HOUR_GLASS
#endif

/// YuI 7/15/04 v7.5909 QA70-6688 OC_TOOLS_IMPLEMENTATION
#include <Tools.h>
/// end OC_TOOLS_IMPLEMENTATION

/// Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
#include "GetNdlg.h"
/// End MOVE_DECLARATION_TO_HEADER
#include <ocn.h> ////--------- CPY 5/16/07 QA70-9659 GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME

#define THE_TREE_NODE	m_paramTree.FirstNode

///Iris 12/27/04 IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE
/////Iris 12/24/04 GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
//#define		ADVAN_ID_THEME_FILE		"AdvanIDs"
//static 	Tree s_trAdvanIDs;
////end GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
///End IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE

/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
static HWND _get_origin_win()
{
	return GetWindow();
}
/// end XYDATARANGE_PROPERTY_IMPLEMENTATION

/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
typedef	bool (*PFN_GETNBOX2)(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn, HWND hWndParent);
/// end NEW_TREECONTROL_FOR_GetNBoxDlg

/// Iris 4/30/2008 QA80-10442 WANT_REMEMBER_X_DATA_TYPE_IN_THEME
/*
///Cheney 2007-9-28 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_INTO_THEME_AS_MAX_SAID
//as fit linear has no dlg itself, so I should remove XDataType node here
///Arvin 12/24/07 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
//static void _remove_datatype_node_from_gui_if_exist(TreeNode& tr)
static void _remove_datatype_attrib_from_gui(TreeNode& tr)
///end XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
{
	TreeNode trXDataType = tr.Graph1.XDataType;
	if(trXDataType)
		///Arvin 12/24/07 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
		//trXDataType.Remove();
		trXDataType.RemoveAttribute(STR_USE_ATTRIB);
		///END XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
}
///end XDATATYPE_SHOULD_NOT_SAVE_INTO_THEME_AS_MAX_SAID
*/
///end WANT_REMEMBER_X_DATA_TYPE_IN_THEME

//------ CPY 7/3/06 QA70-8798 GETNBOX2_BETTER_EVENTS
///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
//bool GetNBox(TreeNode& tr, PEVENT_GETN pfnEvent, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent)//=NULL=NULL = NULL;
/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
//int GetNBox(TreeNode& tr, PEVENT_GETN pfnEvent, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent, bool bShowApplyButton)//=NULL=NULL = NULL;
int GetNBox(TreeNode& tr, PEVENT_GETN pfnEvent, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent, bool bShowApplyButton, PAPPLY_FUNC pfnApply)//=NULL ,=NULL ,= NULL, = NULL, false, NULL;
///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
///End GETN_BOX_ADD_APPLY_BUTTON
{
	Function		fn = Project.FindFunction("DynaBox");
	PFN_DYNABOX		pfn = fn;
	if (pfn)
		///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
		//return pfn(tr, pfnEvent, lpcszTitle, lpcszDescription, hWndParent);
		/// Iris 10/28/2008 QA80-12479 FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
		//return pfn(tr, pfnEvent, lpcszTitle, lpcszDescription, hWndParent, bShowApplyButton);
		return pfn(tr, pfnEvent, lpcszTitle, lpcszDescription, hWndParent, bShowApplyButton, pfnApply);
		///end FIX_CANNOT_SHOW_APPLY_BTN_IN_SIMPLE_GETN
		///End GETN_BOX_ADD_APPLY_BUTTON
	
	return false;
}
//------

//bool GetNBox(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn, HWND hWndParent) //=NULL,NULL,NULL, NULL, NULL	///DG SUPPORT_GETN_BOX_GRIDVIEW
bool GetNBox(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn, HWND hWndParent, bool bSetGridView, bool bTranspose) //=NULL,NULL,NULL, NULL, NULL, false, false
{
	/// ML 2/14/2006 NEW_TREECONTROL_FOR_GetNBoxDlg
	if (!bSetGridView && !bTranspose)
	{
		bool			bUseGetNBox2 = true;//MessageBox(GetWindow(), "Do you want to use new GetNBox?", "GetNBox", MB_YESNO) == IDYES;
		if ( bUseGetNBox2 )
		{
			Function		fnGetNBox2 = Project.FindFunction("DynaBox2", "Originlab\\DynaBox");
			PFN_GETNBOX2	pfnGetNBox2 = fnGetNBox2;
			if (pfnGetNBox2)
				return pfnGetNBox2(tr, lpcszTitle, lpcszDescription, pfn, pEvtFn, hWndParent);
		}
	}
#ifdef _OLD_GETN_BOX_CODE //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER

	/// end NEW_TREECONTROL_FOR_GetNBoxDlg
	int nID = IDD_GET_N_BOX_TREE;//IDD_GET_N_BOX;
	// we have two GetNBox dialog, one support ActiveCurve with range control and the other does not
	// and the decision is coming from the tree attribute
	string strCurveNode;
	int nThemeType;
	if(tr.GetAttribute(STR_ACTIVE_CURVE, strCurveNode))
		nID = IDD_GET_N_BOX_RANGE;
	else if(tr.tagName == "GetNBox")
		nID = IDD_GET_N_BOX;
	//-------- CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	else if(tr.tagName == "GUI")
		nID = IDD_GETNBOX_THEME;
	else if( is_xf_gui_getn_tree(tr) )
		nID = IDD_GETNBOX_THEME;
	/// end XF_THEME_SUPPORT
	//--------
	
	//GetNBoxDlg myDlg(nID, tr, lpcszTitle, lpcszDescription, pfn, pEvtFn, strCurveNode);	///DG SUPPORT_GETN_BOX_GRIDVIEW
	GetNBoxDlg myDlg(nID, tr, lpcszTitle, lpcszDescription, pfn, pEvtFn, strCurveNode, bSetGridView, bTranspose);
	int nRet = myDlg.DoModalEx(hWndParent);
	if(IDOK == nRet)
	{
		myDlg.UpdateEditTreeNode(tr);
		return true;
	}
#endif //#ifdef _OLD_GETN_BOX_CODE //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER

	return false;  
}

////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION 
void GetNBox(int& nRefRet, TreeNode& trNode, LPCSTR lpcszTitle, LPCSTR lpcszTextOK, LPCSTR lpcszTextApply, LPCSTR lpcszDescription, PEVENT_FUNC pEvtFn, HWND hWndParent) //=NULL,NULL,NULL, NULL, NULL
{
	Function		fnGetNBox3 = Project.FindFunction("DynaBox3", "Originlab\\DynaBox");
	PFN_GETNBOX3	pfnGetNBox3 = fnGetNBox3;
	if (pfnGetNBox3)
		nRefRet= pfnGetNBox3(trNode, lpcszTitle, lpcszTextOK, lpcszTextApply, lpcszDescription, pEvtFn, hWndParent);
	else
		nRefRet = -1;
}
/// ----- END MORE_ON_ASCII_OPTION

bool TreeEditControl::UpdateGrid(TreeNode &tr, bool bChkCellResize, bool bTranspose, bool bCallNodesHandlers) //=true, false, true
{
	bool bResize = false;
	bool bInit = true;
	
	_DBSTR("UpdateGridValues");
	/// AW 10/03/05 FIX_OC_DIRECTLY_EXIT_WHEN_TR_IS_EMPTY
	// when tr is empty, m_trTable.SetTree(m_trEdit, NULL, true, !bTranspose); will exit OC running without an message
	//if(tr.IsValid())
	if(tr.IsValid() && tr.GetNodeCount() > 0 )
	/// END FIX_OC_DIRECTLY_EXIT_WHEN_TR_IS_EMPTY
		m_trEdit=tr;
	else
	//--- CPY 3/3/05 INTERNAL_XF_EDIT
	//	return false;
	{
		if(IsTreeView())
			CreateGridView(1, 1);
		else // already in GridView
		{
			ClearAll();
			SetupRowsCols(1, 1, 1, 1);
		}
		return false;
	}
	//---
	
	///DG 3/9/05 ADD_CALL_NODE_HANDLE : CPY 8/3/04 GETN_DLG_CALL_NODE_BASED_EVENT_HANDLERS_ON_INIT
//	if(bCallNodesHandlers) CPY 5/21/05 move to later
//		invokeAllNodesHandlers();
	///end ADD_CALL_NODE_HANDLE
	
	///Frank 3/30/05	TREE_EDIT_SUPPORT_MOVE_ROWS
	setMoveRows(m_trEdit);
	m_bTranspose = !bTranspose;
	///End	TREE_EDIT_SUPPORT_MOVE_ROWS
	
	m_trTable.SetTree(m_trEdit, NULL, true, !bTranspose);
	int nRows=m_trTable.GetNumRows(), nCols=m_trTable.GetNumCols();
	get_tree_display_settings();
	if(bInit)
	{
		//TreeTable tTable(m_trEdit, vnTableDisplayFormat, true, !bTranspose);
		if(IsTreeView())
			CreateGridView(nRows+1, nCols+1);
		else // already in GridView
		{
			ClearAll();
			SetupRowsCols(1, 1, nRows+1, nCols+1);
		}
		// setup headers
		for(int ii=-1; ii<nCols; ii++)
		{
			for(int jj=-1; jj<nRows; jj++)
			{
				if(-1 == ii || -1 == jj) //Set header
				{
					string strVal = m_trTable.GetCell(ii, jj);
					SetCell(jj+1, ii+1, strVal);
				}
			}
		}
	}
	prepareGridForDisplay(bResize, bInit);
	
	///Frank 9/15/04 QA70-6086	SET_UNEDITABLE_AFTER_UPDATE_GRID 
	onAfterUpdateValues() ;
	///End	SET_UNEDITABLE_AFTER_UPDATE_GRID
	
	//---- CPY 1/14/05
	if(bChkCellResize)
	{
		resizeGrid();
	}
	//---- end

	//---- CPY 5/21/05 movd here from above
	if(bCallNodesHandlers)
		invokeAllNodesHandlers();
	//----

	return true;
}

bool TreeEditControl::prepareEditCell(int nRow, double& dbRowSizeFactor, vector<int>& vnBranchRowsToExpand, int nCol)//=EDIT_COL_INDEX)
{
	TreeNode trNode = get_tree_node(nRow, nCol);
	m_flx.Row = nRow;
	
	m_flx.Col = nCol;// last col need to be right aligned
	static int s_ID = 1;
	EditorManager	trNodeManager;
	ODWP	dwTemp;
	string strTemp;
	
	if(trNode)
	{
		int nNodeType = trNode.ID;
		switch(nNodeType)
		{
		case TRGP_BRANCH:
			prepareBranch(trNode, nRow, nCol, vnBranchRowsToExpand);
			string strCombo;
			bool	bIsCheck;
			if(isEditableBranch(trNode, NULL, &bIsCheck, &strCombo))
			{
				if(bIsCheck)
				{
					SetCell(JUSTIFICATION_CHECKBOX, flexcpPictureAlignment, nRow, nCol);//flexPicAlignCenterCenter	;
					dbRowSizeFactor *= ROW_HEIGHT_ENLARGER_CHKBOX;
				}
				else // has to be combo, assume TRGP_ENUM_LIST
				{
					dwTemp = trNodeManager.New(TRGP_ENUM_LIST, nRow, s_ID++, strCombo);
					SetCell(dwTemp, flexcpData, nRow, nCol);
					dbRowSizeFactor *= trNodeManager.GetCellHeightFactor(dwTemp);
				}
			}
			break;
		case TRGP_CHECK:
			SetCell(JUSTIFICATION_CHECKBOX, flexcpPictureAlignment, nRow, nCol);//flexPicAlignCenterCenter	;
			dbRowSizeFactor *= ROW_HEIGHT_ENLARGER_CHKBOX;
			break;
		case TRGP_SLIDEREDIT:///----- YuI 01/14/04 v7.5801 QA70-5799 SLIDER_CONTROL_TO_GETNBOX
		case TRGP_SLIDER:
		/// YuI 03/14/05 INTERACTIVE_DROPDOWN_BUTTON_OPTIONAL
		/*
		case TRGP_INTERACTIVE: ///----- YuI 1/26/04 v7.5807 QA70-5797 INTERACTIVE_TEXT_PROPERTY_IMPLEMENTATION
			m_flx.Cell(flexcpAlignment, nRow, nCol) = JUSTIFICATION_NUM;
		*/
		/// end INTERACTIVE_DROPDOWN_BUTTON_OPTIONAL
			// fall through
		case TRGP_ENUM_LIST: 
		case TRGP_COLOR:
#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER		
		case TRGP_RANGE:
#endif
			dwTemp = trNodeManager.New(nNodeType, nRow, s_ID++, get_node_combo_str(trNode));
			SetCell(dwTemp, flexcpData, nRow, nCol);
			dbRowSizeFactor *= trNodeManager.GetCellHeightFactor(dwTemp);
			break;
		/// YuI 7/23/04 v7.5103 QA70-6582 GETN_MULTILINE_TEXT_IMPLEMENTATION
		case TRGP_MULTILINE_TEXT:
		/// TD 2-16-04 QA70-7368 CODE_EDITOR_IN_DIALOG
		case ONODETYPE_CODE_EDITOR:
			dwTemp = trNodeManager.New(nNodeType, nRow, s_ID++, get_node_combo_str(trNode));
			SetCell(dwTemp, flexcpData, nRow, nCol);
			dbRowSizeFactor *= trNodeManager.GetCellHeightFactor(dwTemp);
			dbRowSizeFactor += 2; // three line in height always. May change later
			SetCell(JUSTIFICATION_MULTILINE, flexcpAlignment, nRow, nCol);//CPY 12/20/04
			break;
#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER		
		
		/// YuI 03/14/05 INTERACTIVE_DROPDOWN_BUTTON_OPTIONAL
		case TRGP_INTERACTIVE: 
			SetCell(JUSTIFICATION_NUM, flexcpAlignment, nRow, nCol);
			string strDropDownButtonId = IDC_INTERACTIVE_POPUP_BTN;
			
			//check if dropdown button id optionally overriden
			trNode.GetAttribute(STR_INTERACTIVE_DROP_DOWN_BUTTON_ID_ATTRIB, strDropDownButtonId);
			dwTemp = trNodeManager.New(nNodeType, nRow, s_ID++, strDropDownButtonId);
			SetCell(dwTemp, flexcpData, nRow, nCol);
			dbRowSizeFactor *= trNodeManager.GetCellHeightFactor(dwTemp);
			break;
		/// end INTERACTIVE_DROPDOWN_BUTTON_OPTIONAL
		
		/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
		case TRGP_XY_COMPLEX_DATA_RANGE:
		case TRGP_XYZ_DATA_RANGE:
		case TRGP_XY_DATA_RANGE:
			SetCell(JUSTIFICATION_NUM, flexcpAlignment, nRow, nCol);
			dwTemp = trNodeManager.New(nNodeType, nRow, s_ID++, get_node_combo_str(trNode));
			SetCell(dwTemp, flexcpData, nRow, nCol);
			dbRowSizeFactor *= trNodeManager.GetCellHeightFactor(dwTemp);
			trNodeManager.SetTree(dwTemp, trNode);
			break;
		/// end XYDATARANGE_PROPERTY_IMPLEMENTATION
		/// end GETN_MULTILINE_TEXT_IMPLEMENTATION
		/// YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL
		case TRGP_DATA_RANGE:
			//----------- CPY 6/16/04 QA70-6294 OC_INPUT_DATA_NODE_CLEANUP
			//createDataRangeCell(nNodeType, nRow, s_ID++, trNode, dbRowSizeFactor);
			prepareBranch(trNode, nRow, nCol, vnBranchRowsToExpand);
			PrepareInputDataBranch(nNodeType, nRow, s_ID++, trNode, dbRowSizeFactor);
			//-----------
			break;
		/// end NEW_DATA_SELECTOR_TOOL
#endif //#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER		
	
		/// YuI 10/03/04 QA70-4387 GETN_PICTURE_IMPLEMENTATION
		case TRGP_PICTURE:
			///Frank 10/16/04 CELL_WIDTH_NEED_UPDATE_LOAD_PICTURE
			/*
			m_flx.Cell(flexcpAlignment, nRow, nCol) = JUSTIFICATION_CHECKBOX;
			if(trNode.pict)
			{
				int nPictureHeight = trNode.pict.GetHeight();
				int nPictureWidth  = trNode.pict.GetWidth();
				double dAspectRatio = (double) nPictureHeight / nPictureWidth;
				RECT rect;
				GetCellRect(nRow, nCol, rect);
				int ny = PixelsToTwips((rect.right - rect.left) * dAspectRatio);
				m_flx.RowHeight(nRow) = ny;
				dbRowSizeFactor = -1; // to indicate that caller should not process it
			}
			*/
			if(resetPiructRowHight(nRow, nCol, trNode) >= 0)
				dbRowSizeFactor = -1; // to indicate that caller should not process it
			///End CELL_WIDTH_NEED_UPDATE_LOAD_PICTURE
			break;
		/// end GETN_PICTURE_IMPLEMENTATION

		case TRGP_DOUBLE:
			//printf("numeric %s cell alignment at nCol=%d, nRow =%d to %d\n", trNode.tagName, nCol,nRow, JUSTIFICATION_NUM);
			SetCell(JUSTIFICATION_NUM, flexcpAlignment, nRow, nCol);//flexAlignCenterCenter;
			break;
		default:
			//printf("strtype %s cell alignment at nCol=%d, nRow =%d to %d\n", trNode.tagName, nCol,nRow, JUSTIFICATION_STR);
			SetCell(JUSTIFICATION_STR, flexcpAlignment, nRow, nCol);//flexAlignCenterCenter;
		}
					
		if(LABEL_COL_INDEX != nCol)	//Label Column the same as Edit column
			setTreeRowUserColors(trNode, nRow, nCol);	///Danice NEW_WAY_FOR_ALTERNATE_COLORS
		
		if(setGridCellValue(nRow, nCol, trNode))
			dbRowSizeFactor = -1; //CPY 12/20/04 centralize Row height auto size code inside setGridCellValue
			
		checkShowComboIndicator(nRow, nCol, trNode);/// CPY TD 11-30-04 QA70-6582 ADD_COMBO_IMAGE_TO_RIGHT_OF_EDIT_CELL
		///Danice TREE_ROW_SHOW_ALTERNATE_COLORS : user don't set color, use default
		if(m_vnTreeRowColors.GetSize() < TOTAL_BASIC_ALTERNATE_COLORS)
		{
			//--- CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
			if(trNode.GetAttribute(STR_ATTRIB_LABEL_COLOR, strTemp))
			{
				DWORD dwColor = atoi(strTemp);
				SetCell(dwColor, flexcpForeColor, nRow, LABEL_COL_INDEX);
			}
			if(trNode.GetAttribute(STR_ATTRIB_BKGRND_COLOR, strTemp))
			{
				DWORD dwColor = atoi(strTemp);
				SetCell(dwColor, flexcpBackColor, nRow, LABEL_COL_INDEX);
			}			
			//---
		}
		///end TREE_ROW_SHOW_ALTERNATE_COLORS
	}
//		flx.ComboSearch = flexCmbSearchNone;
//		flx.CellAlignment = flexAlignLeftTop; //flexAlignRightCenter;
	///Danice SUPPORT_BRANCH_DISPLAY_OPTIONS
	//if(trNode.IsValid() && trNode.Show == 0)
		//return false;
	//if(trNode.IsValid())				///Danice SUPPORT_GRID_VIEW
	if(m_bCheckTreeShow && trNode.IsValid() && IsTreeView())	///Danice ADD_CHECK_SHOW_OPTION
	{
		if(0 == trNode.Show)
			return false;
		else
		{
			for(TreeNode trParent = trNode.Parent(); trParent.IsValid(); trParent = trParent.Parent())
			{
				if(0 == trParent.Show)
					return false;
			}
		}
	}
	///END SUPPORT_BRANCH_DISPLAY_OPTIONS
	
	if(m_bIsFlatDialogDisplay)
		SetCell(RGB(255,255,255), flexcpBackColor, nRow, nCol);
	return true;
}	

//------- CPY 11/19/05 QA70-8339 ROC_CURVE_NEEDS_STATE_VALUES moved here
bool TreeEditControl::check_translate_OnComboCloseUp(const TreeNode& trNode, string& strEdit, string strOldEdit)
{
	if(TRGP_STR_GROUP == trNode.ID)
	{
		string str = strOldEdit;
		vector<string> strOldVals;
		strOldEdit.GetTokens(strOldVals);
		if(!is_in_list(strEdit, strOldVals))
			strEdit = strOldEdit + " " + strEdit;
		else
			strEdit = strOldEdit;
			
		return true;
	}
	return false;
}
//------- end ROC_CURVE_NEEDS_STATE_VALUES

bool TreeEditControl::check_translate(const TreeNode& trNode, string& strEdit, bool bValueToItem) //=false
{
	// Get special values
	string strValues;
	if( !trNode.GetAttribute(STR_SPECIALVALS_ATTRIB, strValues))
		return false;

	// Get list items
	string strItems;
	strItems = get_node_combo_str(trNode);
	if( strItems.IsEmpty() )
		return false;
	
	if( strItems[0] == '|' ) // if editable
		strItems.Delete(0); // delete leading pipe to avoid item index offset

	// Set From and To string arrays
	StringArray saFrom, saTo;
	if( bValueToItem )
	{
		if( strValues.GetTokens(saFrom, '|') <= 0 || strItems.GetTokens(saTo, '|') <= 0 )
			return false;
	}
	else
	{
		if( strValues.GetTokens(saTo, '|') <= 0 || strItems.GetTokens(saFrom, '|') <= 0 )
			return false;
	}
	
	// Get From index
	int nFrom;
	if( !is_in_list(strEdit, saFrom, false, &nFrom) )
		return false;

	// Check From index with number of list items
	if( saTo.GetSize() <= nFrom )
		return false;
	
	// Get list item special value
	strEdit = saTo[nFrom];

	return true; // strEdit changed
}
	
void TreeEditControl::get_tree_display_settings()
{
	string strTemp;
	if(m_trEdit.GetAttribute(STR_ATTRIB_NUMFMT, strTemp))
		m_strNumFormat = strTemp;	
	if(m_trEdit.GetAttribute(STR_ATTRIB_EDITCOL_ALIGN, strTemp))
	{
		StringArray saItems;
		int nToSet[NUM_EDIT_COL_ALIGNMENTS] = {DISPLAY_CENTER, DISPLAY_LEFT, DISPLAY_RIGHT};
		int nn = strTemp.GetTokens(saItems, '|');
		for(int ii = 0; ii < NUM_EDIT_COL_ALIGNMENTS; ii++)
		{
			if(ii < nn)
				nToSet[ii] = get_value(saItems[ii], nToSet[ii], DISPLAY_LEFT,DISPLAY_RIGHT);
			else
				nToSet[ii] = -1;
		}
		m_nCheckAlignment = get_alignment(nToSet[0], DISPLAY_CENTER);
		m_nNumAlignment = get_alignment(nToSet[1], DISPLAY_LEFT);
		m_nStrAlignment = get_alignment(nToSet[2], DISPLAY_RIGHT);
	}
	///Danice TREE_ROW_SHOW_ALTERNATE_COLORS
	if(m_trEdit.GetAttribute(STR_ATTRIB_TREE_ROW_COLOR, strTemp))
	{
		vector<string> vsColors;
		vector<uint> vnColors;
		int nSize=strTemp.GetTokens(vsColors, '|');
		///Danice NEW_WAY_FOR_ALTERNATE_COLORS
		/*
		for(int ii=0; ii<nSize; ii++)
			vnColors.Add(atoi(vsColors[ii]));
		
		//SetTreeRowAlternateColors(vnColors);
		*/
		m_vnTreeRowColors.SetSize(nSize);
		for(int ii=0; ii<nSize; ii++)
			m_vnTreeRowColors[ii]=atoi(vsColors[ii]);

	}
	///end TREE_ROW_SHOW_ALTERNATE_COLORS
	///Danice MARK_EMPTY_GETN_STR
	if(m_trEdit.GetAttribute(STR_ATTRIB_TREE_INDICATOR_COLOR, strTemp))
	{
		vector<string> vsColors;
		int nSize=strTemp.GetTokens(vsColors, '|');
		for(int ii=0; ii<nSize; ii++)
			m_vnIndicatorColors.Add(atoi(vsColors[ii]));
	}
	///end MARK_EMPTY_GETN_STR

}


bool TreeEditControl::Update(TreeNode& tr, bool bResize, bool bInit, bool bCallNodesHandlers) // = true = false = true
{	
	//PROFILE_HRGLASS

	_DBSTR("UpdateGrid");
	
		
	if(bInit)
		Cleanup();	///DG 4/21/05 : clean before new tree
	if( tr.IsValid() ) /// YuI added if
	{
		m_trEdit = tr;
		///Danice SUPPORT_EMPTY_TREENODE_AND_LABEL_CONTROL
		if(m_trEdit.GetNodeCount() < 1)
			m_bShowLabelCol=false;
		else
			m_bShowLabelCol=true;
		///end SUPPORT_EMPTY_TREENODE_AND_LABEL_CONTROL
		
		//--- CPY 8/3/04 GETN_DLG_CALL_NODE_BASED_EVENT_HANDLERS_ON_INIT
		if(bCallNodesHandlers)
			invokeAllNodesHandlers();
		//--- end GETN_DLG_CALL_NODE_BASED_EVENT_HANDLERS_ON_INIT
	}
	
	setMoveRows(m_trEdit); 	///Frank 3/30/05	TREE_EDIT_SUPPORT_MOVE_ROWS

	//--- CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
	string strTemp;
	if(m_trEdit.GetAttribute(STR_ATTRIB_VERT_GRID_LINES, strTemp))
	{
		SetGridLines(atoi(strTemp));
	}
	get_tree_display_settings();
	
	m_strThemeFilePrefix = "";
	theme_get_class_option(m_trEdit, m_strThemeFilePrefix);
	
	
	m_flx.Redraw = flexRDNone;
	if(bInit)
	{
		//Cleanup();	///DG 4/21/05 : clean up will clean all, should clean at the beginning, move ahead

		m_flx.Rows = m_flx.FixedRows;	//delete all but headers
		///DG 4/20/05 REWRITE_TREE_GET_NODE
		/*
		///Frank 3/22/05	APPLY_ADDTREENODES_WITH_NEW_RULE
		//AddTreeNodes(m_trEdit, 2); //CPY 2/26/04, add 2, indicate tree has 2 cols
		AddTreeNodes(m_trEdit, -1, NULL, true, false, -1, NULL, 2); //CPY 2/26/04, add 2, indicate tree has 2 cols
		///End	APPLY_ADDTREENODES_WITH_NEW_RULE
		*/
		AddTreeNodes(m_trEdit, 0, NULL, -1, NULL, true, 2);
		///end REWRITE_TREE_GET_NODE
	}
	
#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER		
	/// YuI 10/28/04 INPUT_DATA_RANGE_INCAPSULATION
	createAddDataRange(m_trEdit);
	/// end INPUT_DATA_RANGE_INCAPSULATION	
#endif
	
	prepareGridForDisplay(bResize, bInit);
	
	m_flx.Redraw = flexRDBuffered;
	if(bInit)
	{
		RemoveSelection();
		//m_bDataReady = true;
		SetReady();
	}
	///Frank 9/15/04 QA70-6086	SET_UNEDITABLE_AFTER_UPDATE_GRID 
	onAfterUpdateValues() ;
	///End	SET_UNEDITABLE_AFTER_UPDATE_GRID 
	return true;
}

#ifdef _OLD_GETN_BOX_CODE //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER

void GetNBoxDlg::UpdateEditTreeNode(TreeNode& tr)
{
	tr = m_input_tr;
}
	
	//int DoModalEx(HWND hWndParent = NULL)
int GetNBoxDlg::DoModalEx(HWND hWndParent)
{
	DWORD dwDlgOptions =preCreateGetNBoxDlg(hWndParent);

	int nRet = DoModal(hWndParent, dwDlgOptions);
	if(nRet != IDCANCEL)
	{
		m_input_tr.Replace(THE_TREE_NODE);
			
		//if(isUseCurveRange())
		//{
			//TreeNode trCurve = m_dataRange.GetCurveRange();
			//m_input_tr.AddNode(trCurve.Clone());
		//}
		updateShiftShowStatus();
		saveDefaultGUI();
	}
	// the following are no longer needed since we are no longer static
	//s_paramTree.Reset();
	//s_pApplyFunc = NULL;
	//s_pEventFunc = NULL;
	return nRet;
}
DWORD 	GetNBoxDlg::preCreateGetNBoxDlg(HWND hWndParent)
{
	InitMsgMap();
	
	DWORD dwDlgOptions = 0;
	if(hWndParent)
		dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;
		
	
	if(isUseCurveRange())
	{
		TreeNode trCurve = THE_TREE_NODE.GetNode(m_strCuveNode);
		if(trCurve)
		{
			TreeNode trCurveOnMain = m_paramTree.AddNode(m_strCuveNode);
			trCurveOnMain.Replace(trCurve.Clone());
			THE_TREE_NODE.RemoveChild(m_strCuveNode); // to be consistent, so we will always add it back later
			string strYdata = trCurveOnMain.Range1.Ydata.strVal;
			string strXdata = trCurveOnMain.Range1.Xdata.strVal;
			Curve	cuv(strXdata, strYdata);
		}
		else
		{
			trCurve = m_paramTree.AddNode(m_strCuveNode);
		}
	}
	return dwDlgOptions;
	
}
//int CreateEx(HWND hWndParent = NULL)
int GetNBoxDlg::CreateEx(HWND hWndParent)
{
	DWORD dwDlgOptions = preCreateGetNBoxDlg(hWndParent);
	return Create(hWndParent, dwDlgOptions);
}
	
///DG SUPPORT_GETN_BOX_GRIDVIEW
bool GetNBoxDlg::Update(TreeNode& tr, bool bResize, bool bInit, bool bCallNodesHandlers) //true, false, true
{
	m_treeEditCntrl.SetReady(false);
	bool bRet;
	if(m_bSetGridView)
	{
		if(bInit)
			m_treeEditCntrl.CreateGridView();
		bRet=m_treeEditCntrl.UpdateGrid(tr, bResize, m_bTranspose, bCallNodesHandlers);
	}
	else
	{
		if(bInit)
			m_treeEditCntrl.CreateTreeView();
		bRet=m_treeEditCntrl.Update(tr, bResize, bInit, bCallNodesHandlers);
	}
	m_treeEditCntrl.SetReady(true);
	return bRet;
}
///end SUPPORT_GETN_BOX_GRIDVIEW

//#define THE_GRID MyDlg.GetItem(IDC_PARAMS_GRID).GetActiveXControl()
//protected: ///MOVE_DECLARATION_TO_HEADER
	
///Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
//EVENTS_BEGIN
BEGIN_MESSAGE_MAP(GetNBoxDlg)
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_APPLY, OnApplyButton)
	ON_GETNDLG_MSGS(IDC_PARAMS_GRID)
	///Danice GETNBOX_SAME_AS_GETNVIEWBOX
	/*
	ON_EVENT(EN_SETFOCUS, IDC_PARAMS_GRID, OnSetFocus)
	ON_USER_MSG(WM_USER_ON_CHILD_KILL_FOCUS, OnEditorKillFocus)
	ON_USER_MSG(WM_USER_RECONSTRUCT, OnReconstructGrid)
	//ON_SIZE(OnResize)
	ON_GRID_BEFORE_EDIT(IDC_PARAMS_GRID, OnBeforeEdit)
	ON_GRID_VALIDATE_EDIT(IDC_PARAMS_GRID, OnValidateEdit)
	ON_GRID_AFTER_EDIT(IDC_PARAMS_GRID, OnAfterEdit)
	ON_GRID_ROW_COL_CHANGE(IDC_PARAMS_GRID, OnRowColChange)
	ON_GRID_COMBO_CLOSEUP(IDC_PARAMS_GRID, OnComboCloseUp)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_PARAMS_GRID, OnBeforeMouseDown)
	ON_GRID_DRAW_CELL(IDC_PARAMS_GRID, OnDrawCell)
	ON_GRID_BUTTON_CLICK(IDC_PARAMS_GRID, OnButtonClick)
	*/
	///END GETNBOX_SAME_AS_GETNVIEWBOX
	ON_GRID_AFTER_COLLAPSE(IDC_PARAMS_GRID, OnAfterCollapse)
	
	ON_CLICK_KEY(OnKey) //CPY 6/11/03 QA70-4450 v7.0601 TTILE_KEY_TO_BECOME_MODLESS

	ON_HELPINFO(OnHelp) //CPY 10/11/03 QA70-5332 HELP_CUSTOMIZED
	
	///Danice GETNBOX_SAME_AS_GETNVIEWBOX
	/*
	///////////// Range Control related ////////////
	ON_SLIDE_BEFORE(IDC_PARAMS_RANGE_SLIDER, OnRangeSlide)
	ON_EVENT(EN_SETFOCUS, IDC_PARAMS_X_FROM, OnSetFocusFrom)
	ON_EVENT(EN_SETFOCUS, IDC_PARAMS_X_TO, OnSetFocusTo)
	ON_EVENT(EN_KILLFOCUS, IDC_PARAMS_X_FROM, OnKillFocusFrom)
	ON_EVENT(EN_KILLFOCUS, IDC_PARAMS_X_TO, OnKillFocusTo)
	ON_BN_CLICKED(IDC_PARAMS_RANGE_FULL, OnFullRange)
	///////////// end Range Control related ////////////
	*/
	///END GETNBOX_SAME_AS_GETNVIEWBOX
#if _OC_VER >= 0x0800
	ON_CHANGE_SELECTION(OnSelectionChange)
	ON_SELECTION_TRACK(OnSelectionTrack)
//	ON_DS_SELECTION_TRACK(OnDSSelectionTrack)
//	ON_DS_SELECTION_CHANGE(OnDSSelectionChange)
	/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
	ON_BN_CLICKED(IDC_DATARANGE_DLG_BUTTON, OnInteractiveDataRange)
	ON_BN_CLICKED(IDC_XY_DATARANGE_DLG_BUTTON, OnInteractiveXYDataRange)
	ON_BN_CLICKED(IDC_INTERACTIVE_POPUP_BTN,  OnInteractivePopUp)
	/// end VECTORIAL_NUMERIC_FUNCTIONS
	ON_CBN_SELCHANGE(IDC_PARAMS_THEME, OnComboChangeTheme)  //------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	///Forest 9/13/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	ON_BN_CLICKED(IDC_PARAMS_SAVE, OnSaveTheme)
	ON_BN_CLICKED(IDC_PARAMS_SAVE_AS, OnSaveThemeAs)
	///End GETN_THEME_SAVEAS_NEW_DIALOG
	ON_BN_CLICKED(IDC_PARAMS_SHOW_ADVANCED, OnShowAdvancedCheck) //---- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX

#endif //if _OC_VER >= 0x0800
//EVENTS_END  ///Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
END_MESSAGE_MAP      

//------------ Event Handlers ------------------------
//private:
BOOL GetNBoxDlg::OnInitDialog()
{
	waitCursor junk;
	//Profiler jj;
	
	ResizeDialog::OnInitDialog();
	
	//if(isUseCurveRange())
		//m_dataRange.InitControls(*this, 
		//IDC_PARAMS_RANGE_FROM, IDC_PARAMS_RANGE_TO, IDC_PARAMS_RANGE_SLIDER, 
		//IDC_PARAMS_RANGE_FULL,IDC_PARAMS_X_FROM, IDC_PARAMS_X_TO, IDC_PARAMS_DATASET );

	//---  CPY 5/22/03 v7.0589 SHIFT_SHOW_FOR_CLASSES
	m_chkShiftShow = GetItem(IDC_PARAMS_SHIFTSHOW);
	
	/// Iris 6/09/05 CHECK_PRO_ID_WHEN_CHECK_ADVANCE_ID
	/// Iris 6/02/05 UPDATE_PRO_ID_SETTING
	//update_param_tree_for_pro_ids(THE_TREE_NODE, is_pro_version());
	///end UPDATE_PRO_ID_SETTING
	///end CHECK_PRO_ID_WHEN_CHECK_ADVANCE_ID
	
	//--- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	m_chkAdvanced = GetItem(IDC_PARAMS_SHOW_ADVANCED); 
	if(m_chkAdvanced)
	{
		/// Iris 2/08/06 QA70-7586 v8.0364 HIDDEN_SHOW_ADVANCED_BOX_FOR_XF_GETN_DLG
		//m_chkAdvanced.Visible = true;
		bool 	bShow = true;
		string 	strName = THE_TREE_NODE.tagName;
		if( 0 == strName.Compare("XFGUI") )
			bShow = false;
		m_chkAdvanced.Visible = bShow;
		///End HIDDEN_SHOW_ADVANCED_BOX_FOR_XF_GETN_DLG
		
		///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
		//m_chkAdvanced.Check = false; // should get this from registry, same location as other class specific settings
		m_chkAdvanced.Check = isShowAdvanced(THE_TREE_NODE); ///Get show advanced from TreeNode attribute STR_SHOW_ADVANCED_ATTRIB
		///End	GETN_DLG_ADVANCED_CHECK_SAVE
	/// AW 03/22/05 MORE_ON_ADD_SHOW_ADVANCED_CHECK_BOX
	// only do update_param_tree_advanced_ids when m_chkAdvanced is true
	//}
	//update_param_tree_advanced_ids(THE_TREE_NODE, isShowAdvanced()); 
		update_param_tree_advanced_ids(THE_TREE_NODE, isShowAdvanced()); 
	}
	// END MORE_ON_ADD_SHOW_ADVANCED_CHECK_BOX
	//---
	///Iris 3/30/05 HIDDEN_PRO_FEATURE_FOR_REGULAR_VERSION
	//------- CPY 4/22/05 QA70-7651 DESC_STATS_ON_ROWS_CLEAN
	/// Iris 6/02/05 UPDATE_PRO_ID_SETTING
	//update_param_tree_for_pro_ids(THE_TREE_NODE, is_pro_version());
	///end UPDATE_PRO_ID_SETTING
	//-------
	///end HIDDEN_PRO_FEATURE_FOR_REGULAR_VERSION
	
//		m_chkAutoUpdate = GetItem(
	int nIsShiftShow = getShiftShowStatus();
	if(nIsShiftShow >= 0)
	{
		m_chkShiftShow.Visible = true;
		m_chkShiftShow.Check = nIsShiftShow;
	}
	//--- end SHIFT_SHOW_FOR_CLASSES
	
	//------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	m_comboTheme = GetItem(IDC_PARAMS_THEME); 
	m_btnSaveTheme = GetItem(IDC_PARAMS_SAVE);
	if(m_comboTheme)
	{
		//------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
		m_editThemeDescription = GetItem(IDC_PARAMS_DESCRIPTION);
		///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
		string strThemeDescription = 	updateThemeDescription(THE_TREE_NODE, false);
		if(!strThemeDescription.IsEmpty())
			m_strDescription = strThemeDescription;
		//m_strDescription = 	updateThemeDescription(THE_TREE_NODE, false);
		//updateThemeDescription(THE_TREE_NODE, false);
		///End	GETN_DLG_ADVANCED_CHECK_SAVE
		//------
		///Forest 9/13/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
		//if(!loadThemeFilesToCombo(THE_TREE_NODE))
			//m_comboTheme.Visible = false; // indicate not to use
		loadThemeFilesToCombo(THE_TREE_NODE);
		///End GETN_THEME_SAVEAS_NEW_DIALOG
	}
	//------

	//check if we need Outline tree
	int nSubBranchs = 0;
	tree_count_items(THE_TREE_NODE, &nSubBranchs);
	
	PEVENT_FUNC pfn = getEventHandler();
	m_treeEditCntrl.Init(IDC_PARAMS_GRID, IDD_GET_N_BOX == m_nDlgID? true:false, nSubBranchs>0? true:false, pfn, *this);
	
	// if there is event handler, we will need to call that too
	if(pfn)
	{
		int nCntrlTypes[] = {
			ONODETYPE_CHECKBOX,
			ONODETYPE_DROPDOWN_NUMERIC_FLOAT,
			ONODETYPE_DROPLIST_STRINGS,
			ONODETYPE_DROPLIST_COLORS,
			0
		};
		int ii = 0;			
		while(nCntrlTypes[ii] > 0)
		{
			//m_pEventFunc(THE_TREE_NODE, -1, nCntrlTypes[ii]);
			pfn(THE_TREE_NODE, -1, nCntrlTypes[ii], *this); //CPY 5/30/03 QA70-4577 EVENT_HANDLER_NEED_DIALOG_AND_VALUE_UPDATE, added *this
			ii++;
		}
	}
	
	int nCaptionID = 0;
	Control cCaption = GetItem(IDC_PARAMS_DESCRIPTION);
	if(!m_strDescription.IsEmpty())
	{
		nCaptionID = IDC_PARAMS_DESCRIPTION;
		cCaption.Text = m_strDescription;
		cCaption.Visible = true;
	}
	else
		cCaption.Visible = false;		
		
	Button cApplyBtn = GetItem(IDC_APPLY);
	m_bUseTryForApply = false;
	if(m_pApplyFunc)
	{
		//CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE
		string strApplyButtonText;
		if(THE_TREE_NODE.GetAttribute(STR_OPERATION_TRY, strApplyButtonText))
		{
			m_bUseTryForApply = true;
			cApplyBtn.Text = strApplyButtonText;
		}
	}
	else
	{
		cApplyBtn.Visible = false;
	}
	
	///DG SUPPORT_GETN_BOX_GRIDVIEW
	/*
	//--------- CPY SY 07/27/2004 QA70-6719 v8.0105 GETN_AUTO_RESIZE_WIDTH_WITH_LONG_LABEL
	//m_treeEditCntrl.Update(THE_TREE_NODE, true, true);
	m_treeEditCntrl.Update(THE_TREE_NODE, false, true);
	*/
	Update(THE_TREE_NODE, false, true);
	///end SUPPORT_GETN_BOX_GRIDVIEW

	enableButton(IDC_APPLY, m_pApplyFunc? true:false);
	if(!m_strTitle.IsEmpty())
		m_wndDlg.Text = m_strTitle;
	
	///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING
	THE_TREE_NODE.GetAttribute(STR_ATTRIB_MAX_HEIGHT_WIDTH, m_strMaxHeightWidth);
	///end SUPPORT_MAX_HEIGHT_WIDTH_SETTING
	
	m_treeEditCntrl.SetReady(); ///	SY 07/27/2004 QA70-6719 v8.0105 GETN_AUTO_RESIZE_WIDTH_WITH_LONG_LABEL
	m_treeEditCntrl.Resize();
	resizeDlgToFit();
	
	return true;
}
//---- CPY 10/20/05 
BOOL GetNBoxDlg::OnReady()	
{
	//resizeDlgToFit();
	//PostDlgMessage(WM_USER_RECONSTRUCT, GRID_CHANGE_SIZE | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE);
//	TreeEditDlg::OnReconstructGrid(GRID_CHANGE_SIZE | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE, 0);
//	resizeDlgToFit();

	return true;
}
//----

	//----- CPY 10/11/03 QA70-5332 HELP_CUSTOMIZED
	BOOL GetNBoxDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		//---- CPY 10/26/05 QA70-5496 GETN_BOX_F1_TO_OC_HANDLER
		TreeNode tr = THE_TREE_NODE;
		string strClassOption;;
		theme_get_class_option(tr, strClassOption);
		if(!strClassOption.IsEmpty())
		{
			string strLT;
			strLT.Format("help %s", strClassOption);
			LT_execute(strLT);
		}
		//----
		/// EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX
		else
		{
			int nDlgID;
			if( tr.GetAttribute(STR_DATAID_ATTRIB, nDlgID) )
			{
				nHelpID = nDlgID;
				return TRUE;
			}
		}
		/// end UNIQUE_ID_FOR_HELP_WITH_GETN_BOX
		return FALSE; // do no call default help
	}
	//----- end QA70-5332
	
	BOOL GetNBoxDlg::OnDestroy(void)
	{
		m_treeEditCntrl.OnDestroy();
		m_nShiftShowCheck = m_chkShiftShow.Visible? m_chkShiftShow.Check : -1;
	
		///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
		updateThemeDescription(THE_TREE_NODE);
		tree_set_or_remove_attribute(THE_TREE_NODE, STR_SHOW_ADVANCED_ATTRIB,  isShowAdvanced());
		///End	GETN_DLG_ADVANCED_CHECK_SAVE

		/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
		// I am adding this as additional protection against OC runtime error which could
		// prevent EnableGUI execution when interactive control is destroyed
		Project.EnableGUI(TRUE);
		/// end VECTORIAL_NUMERIC_FUNCTIONS
		return true;
	}

	#if _OC_VER >= 0x0800
	
	//---- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	BOOL 	GetNBoxDlg::OnShowAdvancedCheck(Control oCntrl)
	{
		//resizeDlgToFit(); cannot directly resize in message handler
		update_param_tree_advanced_ids(THE_TREE_NODE, isShowAdvanced());  ///Iris 12/24/04 GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
		PostMessage(WM_USER_RECONSTRUCT, GRID_CHANGE_SHOW | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE);
		return true;
	}
	//----
	
	///Iris 12/27/04 IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE, move to analysis_utils
	/////Iris 12/24/04 GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
	//static void _update_param_tree_by_advanced_ids_changed(TreeNode& trParam, bool bShow)
	//{
		//if(!trParam)
			//return;
		//
		//string strShow = bShow? "1" : "0";
		//vector<int> vnIDs;
		//if( _get_built_in_advanced_GUI_ids(vnIDs) )		
			//tree_set_attributes(trParam, vnIDs, strShow);		
	//}
	//
	//static void _generate_build_in_advanced_GUI_ids_theme_file(string strThemeFile) //template function here
	//{
		//Tree tr;
		//TreeNode trNodeID = tr.AddNode("IDs");
		//
		//vector<int> vnAdvanNodeIDs = {IDE_GEO_MEAN, IDE_LCI, IDE_UCI, IDE_SD_X_2, IDE_SD_X_3, IDE_MAD};
		//trNodeID.nVals = vnAdvanNodeIDs;
		//
		//tr.Save(strThemeFile);
	//}
	//
	//static bool _get_built_in_advanced_GUI_ids(vector<int>& vnIDs)
	//{
		//string strFilePath = theme_get_theme_file_name(ADVAN_ID_THEME_FILE);
		//if( !strFilePath.IsFile() )
			//_generate_build_in_advanced_GUI_ids_theme_file(strFilePath);
		//
		//if( !s_trAdvanIDs.FirstNode.IsValid() )
			//if( !s_trAdvanIDs.Load(strFilePath))
				//return false;
		//
		//vnIDs = s_trAdvanIDs.FirstNode.nVals;		
		//return true;
	//}		
	/////End GENERATE_READ_BUILD_IN_ADVAN_ID_THEME
	///End IMPROVE_ACCESS_ADVAN_IDS_THEME_FILE
	
	BOOL	GetNBoxDlg::OnSelectionChange()
	{
		return m_treeEditCntrl.OnSelectionChange();
	}
	
	BOOL	GetNBoxDlg::OnSelectionTrack()
	{
		return m_treeEditCntrl.OnSelectionTrack();
	}
	/*
	BOOL	OnDSSelectionTrack()
	{
		if( Visible )
			return m_treeEditCntrl.OnDSSelectionTrack();
	}
	
	BOOL	OnDSSelectionChange()
	{
		if( Visible )
			return m_treeEditCntrl.OnDSSelectionChange();
	}
	*/

	BOOL	GetNBoxDlg::OnInteractiveDataRange(Control ctrl)
	{
		Window wnd = GetWindow();
		return m_treeEditCntrl.DoInteractiveDlg(&wnd, TRUE, TRUE);
	}
	
	BOOL	GetNBoxDlg::OnInteractiveXYDataRange(Control ctrl)
	{
		Window wnd = GetWindow();
		return m_treeEditCntrl.DoXYDataRangeDlg(&wnd, TRUE);
	}
	
	BOOL	GetNBoxDlg::OnInteractivePopUp(Control ctrl)
	{
		Window wnd = GetWindow();
		RECT rectButton;
		ctrl.GetWindowRect(&rectButton);
		int nX = (rectButton.left + rectButton.right) / 2;
		int nY = (rectButton.top + rectButton.bottom) / 2;
		
		return m_treeEditCntrl.DoInteractivePopUp(&wnd, nX, nY);
	}
	/// end VECTORIAL_NUMERIC_FUNCTIONS
	//------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	//void GetNBoxDlg::updateThemeDescription(TreeNode& trGUI, bool bEditToTree) // = true
	string GetNBoxDlg::updateThemeDescription(TreeNode& trGUI, bool bEditToTree) // = true
	{
		string str;
		if(m_editThemeDescription)
		{
			if(bEditToTree)
				trGUI.SetAttribute(STR_THEME_COMMENT_ATTRIB, m_editThemeDescription.Text);
			else
			{
				trGUI.GetAttribute(STR_THEME_COMMENT_ATTRIB, str);
				///Frank 1/28/05	GETN_DIALOG_NOT_UPDATE_THEME_DESCRIPTION_IF_EMPTY_STRING
				//m_editThemeDescription.Text = str;
				/// DSC 4/19/04 UPDATE_DISCRIPTION_ON_SEL_CHANGE also update if empty
				// if(!str.IsEmpty())
				// 	m_editThemeDescription.Text = str;
				m_editThemeDescription.Text = str;
				///end  UPDATE_DISCRIPTION_ON_SEL_CHANGE
				///End	GETN_DIALOG_NOT_UPDATE_THEME_DESCRIPTION_IF_EMPTY_STRING
			}
		}
		return str;
	}
	//------
	
	
	void GetNBoxDlg::updateSaveButton(const string& strSelTheme)//--- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
	{
		bool bEnable = true;
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		//if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(strSelTheme) )
		if ( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || theme_is_factory_default(strSelTheme) )
		///---END CLEAN_DEFAULT_THEME
			bEnable = false;
		
		m_btnSaveTheme.Enable = bEnable;
		m_editThemeDescription.Enable = bEnable;
	}
	
	//------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	BOOL GetNBoxDlg::OnComboChangeTheme(Control ctrl)
	{
		string strSel;
		m_comboTheme.GetLBText(m_comboTheme.GetCurSel(),strSel);
		///Forest 9/13/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
		//printf("Combo sel changed to %s\n", strSel);	
		updateSaveButton(strSel);
		
		if(theme_update_on_new_sel(THE_TREE_NODE, strSel))
		{
			///DG SUPPORT_GETN_BOX_GRIDVIEW
			/*
			m_treeEditCntrl.SetReady(false);//CPY 10/15/04 FOREST_FOUND_BRANCH_USE_VAL_CHANGE_ON_UPDATE
			m_treeEditCntrl.Update(THE_TREE_NODE, false);
			m_treeEditCntrl.SetReady(true);
			*/
			Update(THE_TREE_NODE, false);
			///end SUPPORT_GETN_BOX_GRIDVIEW
			updateThemeDescription(THE_TREE_NODE, false);
		}
		else
			printf("failed to load theme = %s\n", strSel);
		return	true;// event handler always returns true
	}
	//------
	
	///Forest 9/13/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	BOOL	GetNBoxDlg::OnSaveTheme(Control ctrl)
	{
		updateThemeDescription(THE_TREE_NODE);
		
		/// Iris 4/30/2008 QA80-10442 WANT_REMEMBER_X_DATA_TYPE_IN_THEME
		/*
		///Cheney 2007-9-28 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_INTO_THEME_AS_MAX_SAID
		//return theme_save_settings(THE_TREE_NODE);
		TreeNode tr = THE_TREE_NODE.Clone();
		///Arvin 12/24/07 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
		//_remove_datatype_node_from_gui_if_exist(tr);
		_remove_datatype_attrib_from_gui(tr);
		///end XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
		return theme_save_settings(tr);
		///end XDATATYPE_SHOULD_NOT_SAVE_INTO_THEME_AS_MAX_SAID
		*/
		return theme_save_settings(THE_TREE_NODE);
		///end WANT_REMEMBER_X_DATA_TYPE_IN_THEME
	}
	
	BOOL	GetNBoxDlg::OnSaveThemeAs(Control ctrl)
	{
		string strDescription ;
		string strFullFileName = theme_ask_save_as_filename(THE_TREE_NODE, GetSafeHwnd());
		if(strFullFileName.IsEmpty())
			return	true;
		
		updateThemeDescription(THE_TREE_NODE, false);
		
		/// Iris 4/30/2008 QA80-10442 WANT_REMEMBER_X_DATA_TYPE_IN_THEME
		/*
		///Cheney 2007-9-28 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_INTO_THEME_AS_MAX_SAID
		//if(	theme_save_settings(THE_TREE_NODE, strFullFileName) )
		//	loadThemeFilesToCombo(THE_TREE_NODE);
		TreeNode tr = THE_TREE_NODE.Clone();
		///Arvin 12/24/07 QA70-10442 XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
		//_remove_datatype_node_from_gui_if_exist(tr);
		_remove_datatype_attrib_from_gui(tr);
		///end XDATATYPE_SHOULD_NOT_SAVE_DATATYPE_ATTRIB_INTO_THEME
		if(	theme_save_settings(tr, strFullFileName) )
			loadThemeFilesToCombo(tr);
		///end XDATATYPE_SHOULD_NOT_SAVE_INTO_THEME_AS_MAX_SAID
		*/
		if(	theme_save_settings(THE_TREE_NODE, strFullFileName) )
			loadThemeFilesToCombo(THE_TREE_NODE);
		///end WANT_REMEMBER_X_DATA_TYPE_IN_THEME
		
		return	true;// event handler always returns true
	}
	///End GETN_THEME_SAVEAS_NEW_DIALOG

	#endif //if _OC_VER >= 0x0800
	
	BOOL GetNBoxDlg::OnApplyButton(Control cntrl)
	{
		PAPPLY_FUNC pfn = getApplyFunction();

		if(pfn)
		{
			//---- CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE
			//bool bResult = s_pApplyFunc(THE_TREE_NODE);
			if(m_bUseTryForApply) // for Operation class Try case, use can still Cancel and can still OK
			{
				m_input_tr.Replace(THE_TREE_NODE);		
				pfn(m_input_tr); // must pass original treenode for operation to get_parent to get real tree
				return TRUE;
			}
			else
				pfn(THE_TREE_NODE);	
			//---- end OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE
			
			enableButton(IDOK, false); // already apply, no need to do OK
			if(m_bApply1stTime)
			{
				Button cBtn = GetItem(IDCANCEL);
				cBtn.Text = "Close";
				m_bApply1stTime = false;
			}
		}
		return TRUE;
	}


	//------- CPY 6/11/03 QA70-4450 v7.0601 TTILE_KEY_TO_BECOME_MODLESS
	BOOL GetNBoxDlg::OnKey(BOOL bRollingUp)
	{
		if(!bRollingUp && isUseCurveRange())
		{
			TreeNode trInput = m_paramTree.GetNode(m_strCuveNode);
			if(trInput)
			{
				GraphPage gpg = Project.Pages();
				if(gpg)
				{
					if(trInput.Page.strVal.CompareNoCase(gpg.GetName()) == 0 )
						return TRUE;
				}
			}
			return FALSE;
		}
		return TRUE;
	}
	//------- end TTILE_KEY_TO_BECOME_MODLESS
	
	
	//------------ vcFlex Grid Event Handlers ------------
	void GetNBoxDlg::OnAfterCollapse(Control cntrl, int nRow, short nState)
	{
		if(m_treeEditCntrl.IsResizeOnCollapse(nRow, nState))	//----CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
			resizeDlgToFit();
	}
	//--------- CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX
	//virtual
	BOOL GetNBoxDlg::OnReconstructGrid(UINT wParam, UINT lParam)
	{
		BOOL bOK = TreeEditDlg::OnReconstructGrid(wParam, lParam);

		if(wParam & GRID_CHANGE_SHOW)
			resizeDlgToFit();
		
		return bOK;
	}
	//---------		
		
	///DG FIT_SIZE_WHEN_LIST_CHANGED
	void GetNBoxDlg::OnComboCloseUp(Control cntrl, int nRow, int nCol, BOOL* pFinishEdit)
	{
		TreeEditDlg::OnComboCloseUp(cntrl, nRow, nCol, pFinishEdit);
		int nxGrid, nyGrid;
		m_treeEditCntrl.GetGridSize(nxGrid, nyGrid);
		RECT r1;
		m_wndDlg.GetClientRect(&r1);
		if(nxGrid > RECT_WIDTH(r1))
			resizeDlgToFit();
	}
	///end FIT_SIZE_WHEN_LIST_CHANGED

	//////////// local utilities/helper functions
//private: ///Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
	//------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	void GetNBoxDlg::trimThemeFileForDisplay(string& strFilename)
	{
		int n1 = strFilename.Find('-');
		int n2 = strFilename.ReverseFind('.');
		if(n1 > 0 && n2 > n1)
			strFilename = strFilename.Mid(n1+1, n2-n1-1);
	}
	
	bool GetNBoxDlg::loadThemeFilesToCombo(const TreeNode& trGUI)
	{
		m_comboTheme.ResetContent();
		vector<string> vsThemeList;
		
		int nSel = theme_get_list(trGUI, vsThemeList);
		for(int ii = 0; ii < vsThemeList.GetSize(); ii++)
			m_comboTheme.AddString(vsThemeList[ii]);

		if(vsThemeList.GetSize() == 0)
			return false;

		m_comboTheme.SetCurSel(nSel);
		if(vsThemeList.GetSize() > nSel)///Forest 03/09/05
			updateSaveButton(vsThemeList[nSel]);
		return true;
	}
	//------

	// return -1, 0 1, -1 if not applicable
	int	GetNBoxDlg::getShiftShowStatus()
	{
		if(m_strClassName.IsEmpty())
			return -1;
		//----- CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
		if(IDD_GETNBOX_THEME == m_nDlgID)
			return -1;
		//-----
		return shiftShow();
	}
	void GetNBoxDlg::updateShiftShowStatus()
	{
		if(!m_strClassName.IsEmpty() && m_nShiftShowCheck >= 0)
			shiftShow(false, m_nShiftShowCheck);
	}
	//bool GetNBoxDlg::shiftShow(bool bGet = true, bool bVal = false) /// Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
	bool GetNBoxDlg::shiftShow(bool bGet, bool bVal)
	{
		Registry reg(HKEY_CURRENT_USER);
		string strKey = GetRegKey() + "\\Classes\\" + m_strClassName;
		string strVal = "GUI"; // we use just one dword
		DWORD	dwShiftShowBit = 0x00000001;
		
		DWORD dwVal = 0;
		if(bGet)
		{
			reg.GetValue(strKey, strVal, dwVal);
			return (dwVal & dwShiftShowBit)? true:false;
		}
		else
		{
			reg.GetValue(strKey, strVal, dwVal);
			if(bVal)
				dwVal |= dwShiftShowBit;
			else
				dwVal &=~dwShiftShowBit;
			
			reg.SetValue(strKey, strVal, dwVal);
		}
		return true;
	}
	void	GetNBoxDlg::saveDefaultGUI()
	{
		if(!m_strClassName.IsEmpty())
			save_default_settings(m_input_tr, m_strClassName, SETTINGS_GUI);
	}
	
	bool GetNBoxDlg::isUseCurveRange() { return m_strCuveNode.IsEmpty()? false:true;}
	
	PEVENT_FUNC GetNBoxDlg::getEventHandler()
	{
		PEVENT_FUNC temp_pEventFunc = m_pEventFunc;// wait until we can call member function pointer directly
		TreeNode trNode = THE_TREE_NODE;

		if(trNode)
			return temp_pEventFunc;
		
		return NULL;
	}
	PAPPLY_FUNC GetNBoxDlg::getApplyFunction()
	{
		PAPPLY_FUNC temp_pApplyFunc = m_pApplyFunc;// wait until we can call member function pointer directly
		TreeNode trNode = THE_TREE_NODE;

		if(trNode)
			return temp_pApplyFunc;
		
		return NULL;
	}
	
	void GetNBoxDlg::enableButton(uint nBtnID, bool bEnable)
	{
		Control cBtn = GetItem(nBtnID);
		cBtn.Enable = bEnable;
	}
	void GetNBoxDlg::resizeDlgToFit()
	{
		/// SY 07/27/2004 QA70-6719 v8.0105 GETN_AUTO_RESIZE_WIDTH_WITH_LONG_LABEL
		if( !m_treeEditCntrl.IsReady() )
			return;
		/// end GETN_AUTO_RESIZE_WIDTH_WITH_LONG_LABEL
		
		uint nBtnIds[] = {
			IDC_APPLY,
			IDCANCEL,
			IDOK,
			0};
	
		uint nBtnNoApply[] = {
			IDCANCEL,
			IDOK,
			0};
		
		if(m_pApplyFunc)	
			resizeDialog(nBtnIds);
		else
			resizeDialog(nBtnNoApply);
	}
	//--- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	//bool GetNBoxDlg::isShowAdvanced()
	bool GetNBoxDlg::isShowAdvanced(TreeNode &tr)
	{
		///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
		string str;
		if(tr)
			if(tr.GetAttribute(STR_SHOW_ADVANCED_ATTRIB,str))
				return true;
		///End	GETN_DLG_ADVANCED_CHECK_SAVE
			
		if(m_chkAdvanced)
		{
			if(m_chkAdvanced.Check)
				return true;
		}
		return false;
	}
	//---
	
	// assume grid as top control underneath a caption and other controls follows in a row
	// we assume the caption top position is unchanged
	//void GetNBoxDlg::resizeDialog(uint* pIntIDs, int nCaptionID = IDC_PARAMS_DESCRIPTION) /// Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
	void GetNBoxDlg::resizeDialog(uint* pIntIDs)
	{
		int nEdge = GetControlGap();
		int nGap = 8;
		int ny = nEdge;
				
		int nxGrid, nyGrid;
		
		m_treeEditCntrl.GetGridSize(nxGrid, nyGrid);
		
	//printf("resizeDialog, GetGridSize width = %d, height=%d\n", nxGrid, nyGrid);
		
		///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING
		/*
		//---CPY 6/7/04 LIMIT_GETN_HEIGHT_AND_SCROLL_IF_TOO_HEIGHT
		int nMaxGridHeight = GetSystemMetrics(SM_CYSCREEN) * 0.6;
		if(nyGrid > nMaxGridHeight)
			nyGrid = nMaxGridHeight;
		//---
		*/
		double dHeightPercent=0.6, dWidthPercent=0.8, dTemp;	//default
		int nMaxGridHeight, nMaxGridWidth;
		vector<string> vsHeightWidth;
		m_strMaxHeightWidth.GetTokens(vsHeightWidth, '|');
		for(int ii=0; ii<vsHeightWidth.GetSize(); ii++)
		{
			if(0 == ii)
			{
				dTemp=atof(vsHeightWidth[ii]);
				if(0 < dTemp)
					dHeightPercent=dTemp;
			}
			else if(1 == ii)
			{
				dTemp=atof(vsHeightWidth[ii]);
				if(0 < dTemp)
					dWidthPercent=dTemp;
			}
		}
		nMaxGridHeight = GetSystemMetrics(SM_CYSCREEN) * dHeightPercent;
		nMaxGridWidth = GetSystemMetrics(SM_CXSCREEN) * dWidthPercent;
		
		if(nyGrid > nMaxGridHeight)
			nyGrid=nMaxGridHeight;
		if(nxGrid > nMaxGridWidth)
			nxGrid=nMaxGridWidth;
		///end SUPPORT_MAX_HEIGHT_WIDTH_SETTING
		
		RECT r1, r2;
		Button btn = GetItem(pIntIDs[0]);
		btn.GetWindowRect(&r1);
		int nBtnWidth = r1.right - r1.left;
		int nBtnHeight= r1.bottom - r1.top;
		
		// next we caculate the size of dialog
		int cx = nEdge + nxGrid + nEdge, nGroupWidth, nGroupHeight;
		///DG MINI_SIZE_FOR_GETN_BOX
		GetGroupTotalSize(pIntIDs, nGroupWidth, nGroupHeight);
		if(nGroupWidth > cx)
			cx=nGroupWidth;
		///end MINI_SIZE_FOR_GETN_BOX
		
		m_wndDlg.GetClientRect(&r1);
		int nOldDlgW = r1.right - r1.left;
		int nOldDlgH = (r1.bottom - r1.top);
		///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING
		//if(cx < nOldDlgW)
			//cx = nOldDlgW;
		///end SUPPORT_MAX_HEIGHT_WIDTH_SETTING
	
		int nCaptionLabel = IDC_PARAMS_DESCRIPTION_LABEL;
		if(m_comboTheme)
		{
			uint uThemeItems[] = {IDC_PARAMS_THEME_LABEL, IDC_PARAMS_THEME, IDC_PARAMS_SAVE, IDC_PARAMS_SAVE_AS, 0};
			///Iris 12/20/05 QA70-7586 LET_THEME_BOX_ALWAYS_SHOW
			//if(isShowAdvanced())	//--- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX, replace m_comboTheme.Visible with isShowAdvanced
			//{
			///End LET_THEME_BOX_ALWAYS_SHOW
				// make all these buttons/controls visible
				ShowControls(uThemeItems);
				///DG MINI_SIZE_FOR_GETN_BOX
				GetGroupTotalSize(uThemeItems, nGroupWidth, nGroupHeight);
				if(nGroupWidth > cx)
					cx=nGroupWidth;
				///end MINI_SIZE_FOR_GETN_BOX
				int nynew = ArrangeControlsLeftRight(uThemeItems, nEdge, ny, cx, IDC_PARAMS_THEME, nEdge);
				ny = nynew + nEdge;
			///Iris 12/20/05 QA70-7586 LET_THEME_BOX_ALWAYS_SHOW
			//}
			//else	///Forest 9/13/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
			//{
			//	ShowControls(uThemeItems, false);
			//	nCaptionLabel = 0;
			//}
			///End LET_THEME_BOX_ALWAYS_SHOW
		}
		else			///Iris 11/14/04 FIX_RUNTIME_ERROR_IN_SIMPLE_GETNBOX
			nCaptionLabel = 0;
		
		//----- CPY 11/5/04 QA70-7127 THEME_DESCRIPTOPN_SAVED_INTO_THEME_FILE
		uint uThemeLabels[] = {IDC_PARAMS_DESCRIPTION_LABEL, IDC_PARAMS_DESCRIPTION, 0};
		if(nCaptionLabel == 0)
		{
			uThemeLabels[1] = 0;
			ShowControls(uThemeLabels, false);
			uThemeLabels[0] = IDC_PARAMS_DESCRIPTION;
		}
		ShowControls(uThemeLabels);
		ny = ArrangeControlsLeftRight(uThemeLabels, nEdge, ny, cx, IDC_PARAMS_DESCRIPTION, nEdge) + nEdge;
		//------	
		//----- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
		// shift show check box is no longer used, so it is ok that we support only one check box at the bottom
		Button* pBottomCheckBox = NULL;
		if(m_chkAdvanced)
			pBottomCheckBox = &m_chkAdvanced;
		else
		{
			if(m_chkShiftShow)
				pBottomCheckBox = &m_chkShiftShow;
		}
		//------ end ADD_SHOW_ADVANCED_CHECK_BOX
			
		
		//---- CPY 5/22/03 v7.0589 SHIFT_SHOW_FOR_CLASSES
		int nCheckBoxes = 0;
		int nCheckBoxHeight = 0;
		if(pBottomCheckBox)
		{
			RECT rCheckBox;
			pBottomCheckBox->GetWindowRect(&rCheckBox);
			nCheckBoxHeight = rCheckBox.bottom - rCheckBox.top;
			nCheckBoxes = nEdge + nCheckBoxHeight + nEdge; 
		}
		//----
		int cy = ny + nyGrid + nEdge + nCheckBoxes + nBtnHeight + nEdge;
		// we need to resize the dialog
		int nxDiff = cx - nOldDlgW;
		int nyDiff = cy - nOldDlgH;
		m_wndDlg.GetWindowRect(&r1);
		r1.right += nxDiff;
		r1.bottom += nyDiff;
		m_wndDlg.MoveWindow(&r1);
		
		
		r2.top = ny;
		r2.left = nEdge;
		r2.right = cx - nEdge;
		r2.bottom = cy - 2*nEdge - nBtnHeight - nCheckBoxes;

		m_treeEditCntrl.MoveWindow(r2);	

		//---- CPY 5/22/03 v7.0589 SHIFT_SHOW_FOR_CLASSES
		if(nCheckBoxHeight && pBottomCheckBox)
		{
			r2.top = ny + nyGrid + nEdge;
			r2.left = nEdge;
			r2.right = cx - nEdge;
			r2.bottom = r2.top + nCheckBoxHeight;
			pBottomCheckBox->MoveWindow(&r2);
		}
		//---- end 

		// now move the buttons to all along the bottom
		ArrangeControlsRightLeft(pIntIDs, cx, r2.bottom + nEdge);
	}
//}; ///Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
///END GETNBOX_SAME_AS_GETNVIEWBOX

#endif //#ifdef _OLD_GETN_BOX_CODE //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER

//--- CPY 1/7/05 ADD_TOOLBAR_TO_DIALOG
bool ResizeDialog::InitToolBar(int nToolbarID, int nDlgCntrlID)
{
	HWND hWnd = GetSafeHwnd();
	if(nDlgCntrlID > 0)
	{
		Control cc = GetDlgItem(nDlgCntrlID);
		if(cc)
			hWnd = cc.GetSafeHwnd();
	}		
	m_toolbar.CreateControl(hWnd);
	if(m_toolbar.LoadToolBar(nToolbarID))
	{
		if(nDlgCntrlID > 0)
			m_toolbar.RePosition();
		
		return true;
	}
	return false;
}
int	ResizeDialog::GetToolBarHeight()
{
	if(m_toolbar)
	{
		RECT rr;
		m_toolbar.GetWindowRect(&rr);
		return RECT_HEIGHT(rr) + 1;
	}
	return 0;
}
#define ID_FOR_ACTIVE_X 10000 // CPY, I have no idea why, but GetDlgCtrlID for ActiveX like vsFlex is giving me very large ID
//---

//---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW
void ResizeDialog::MoveControl(Control& cc, RECT& rr)
{
	if(!cc)
		return;

#ifndef __PA_FLICKER_FREE		/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
	if(m_pMoveControlsHelper && !m_pMoveControlsHelper->IsExclude(cc))
		m_pMoveControlsHelper->Add(cc, rr);
	else
#endif // __PA_FLICKER_FREE		/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
		cc.MoveWindow(&rr);
}
void ResizeDialog::GetClientRect(Control& cc, RECT& rr)
{
	if(!cc)
		return;
		
#ifndef __PA_FLICKER_FREE		/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
	if(m_pMoveControlsHelper && !m_pMoveControlsHelper->IsExclude(cc) && m_pMoveControlsHelper->GetClientRect(cc, rr))
		return;
#endif // __PA_FLICKER_FREE		/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
	
	cc.GetWindowRect(&rr);
	m_wndDlg.ScreenToClient(&rr);
}

/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
#ifdef __PA_FLICKER_FREE
MoveControlsHelper::MoveControlsHelper(Window* pWndParent)
{
	ASSERT(pWndParent);
	m_hWndParent = pWndParent->GetSafeHwnd();
	pWndParent->BeginCacheWindowPos();
}

MoveControlsHelper::~MoveControlsHelper()
{
	Window wndParent(m_hWndParent);
	wndParent.EndCacheWindowPos();
}
#else
/// End REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
MoveControlsHelper::MoveControlsHelper(ResizeDialog* pDlg)
{
	m_nWnds = 0;
	m_pDlg = pDlg;
	m_pDlg->SetMoveControlsHelper(this);
}
MoveControlsHelper::~MoveControlsHelper()
{
	if(m_nWnds)
		m_pDlg->SizeMoveChildWindows(m_hWnds, m_rects);
	
	m_pDlg->SetMoveControlsHelper(NULL);
}
void MoveControlsHelper::Add(Control& btn, RECT& rr)
{
	int ii;
	if(isInList(btn, ii))
	{
		m_rects[ii] = rr;
		return;
	}
		
	m_hWnds.Add((OUIP)btn.GetSafeHwnd());
	m_rects[m_nWnds++] = rr;
}
bool MoveControlsHelper::isInList(Control& btn, int& ii)
{
	OUIP nWnd = (OUIP)btn.GetSafeHwnd();
	for(ii = 0; ii < m_hWnds.GetSize(); ii++)
	{
		if(nWnd == m_hWnds[ii])
			return true;
	}
	return false;
}

// return false if btn not in our list
bool MoveControlsHelper::GetClientRect(Control& btn, RECT& rr)
{
	int ii;
	if(isInList(btn, ii))
	{
		rr = m_rects[ii];
		return true;
	}
	return false;
}

//---- CPY 6/21/2006 FLEX_CNTRL_MOVE_SIZE_PROBLEM
int MoveControlsHelper::Exclude(int nCntrlID)
{
	m_vnExcludeList.Add(nCntrlID);
	return m_vnExcludeList.GetSize();
}
bool MoveControlsHelper::IsExclude(Control& btn)
{
	//	if(m_vnExcludeList.GetSize() < 1)
	//		return false;
	if(btn)
	{
		HWND hWnd = btn.GetSafeHwnd();
		int nCntrlID = GetDlgCtrlID(hWnd);
		//printf("cntrl id = %d, hwnd = %X\n", nCntrlID, hWnd);
		if(nCntrlID >= ID_FOR_ACTIVE_X || find_in_list(nCntrlID, m_vnExcludeList, false) >= 0 )
		{
			//out_int("excluded= ", nCntrlID);
			return true;
		}
	}
	return false;
}

//----
#endif // __PA_FLICKER_FREE		/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
//----

/// Kenny 08/17/2011 ORG-3535-P1 FIND_AND_REPLACE_DIALOG_FLICKERING_WHEN_RESIZE
CDeferWindowPosHelper::CDeferWindowPosHelper(int nNumWnds /*= -1*/)
{
	m_hDWP = NULL;
	BeginDefer(nNumWnds);
}

CDeferWindowPosHelper::~CDeferWindowPosHelper()
{
	EndDefer();
}

BOOL CDeferWindowPosHelper::BeginDefer(int nNumWnds /*= -1*/)
{
	if (m_hDWP)
	{
		ASSERT(0);	// you must call EndDeferWindowPos() first!
		return FALSE;
	}
	
	Reset();
	BOOL bRet = TRUE;
	if ( (m_nNumWnds = nNumWnds) > 0 )	// the caller knows how many windows he/she is going to reposition
	{
		m_hDWP	= BeginDeferWindowPos(m_nNumWnds);
		bRet	= m_hDWP != NULL;
	}
	return bRet;
}

BOOL CDeferWindowPosHelper::Defer(HWND hWnd, int x, int y, int cx, int cy, UINT uFlags /*= SWP_DEFAULT*/, HWND hWndInsertAfter /*= NULL*/)
{
	if ( m_nNumWnds > 0 )
	{
		if ( m_hDWP )
		{
			m_hDWP = DeferWindowPos(m_hDWP, hWnd, hWndInsertAfter, x, y, cx, cy, uFlags);
		}
		return m_hDWP != NULL;
	}
	// The caller is not sure how many windows is going to be repositioned, so we have to cache them here
	m_vhWnds.Add((OUIP)hWnd);
	
	m_vnRects.Add(x);
	m_vnRects.Add(y);
	m_vnRects.Add(cx);
	m_vnRects.Add(cy);
	
	m_vnFlags.Add(uFlags);
	m_vhWndInsertAfters.Add((OUIP)hWndInsertAfter);
	return TRUE;
}

BOOL CDeferWindowPosHelper::Defer(HWND hWnd, const RECT& rect, UINT uFlags /*= SWP_DEFAULT*/, HWND hWndInsertAfter /*= NULL*/)
{
	return Defer(hWnd, rect.left, rect.top, RECT_WIDTH(rect), RECT_HEIGHT(rect), uFlags, hWndInsertAfter);
}

BOOL CDeferWindowPosHelper::EndDefer()
{
	BOOL bRet = FALSE;
	if ( m_nNumWnds > 0 )
	{
		bRet = m_hDWP != NULL && EndDeferWindowPos(m_hDWP);
	}
	else if ( m_vhWnds.GetSize() > 0 )
	{
		m_nNumWnds = m_vhWnds.GetSize();
		ASSERT( (m_vnRects.GetSize() % 4) == 0 && m_vnRects.GetSize() / 4 == m_nNumWnds );
		ASSERT( m_vnFlags.GetSize() == m_nNumWnds && m_vhWndInsertAfters.GetSize() == m_nNumWnds );
		
		CDeferWindowPosHelper buddyHelper;
		if ( buddyHelper.BeginDefer(m_nNumWnds) )
		{
			for(int ii = 0; ii < m_nNumWnds; ++ii)
			{
				int nRectMemOffset = ii * 4;
				if ( !buddyHelper.Defer((HWND)m_vhWnds[ii], 
										m_vnRects[nRectMemOffset], m_vnRects[nRectMemOffset+1], m_vnRects[nRectMemOffset+2], m_vnRects[nRectMemOffset+3],
										m_vnFlags[ii], 
										(HWND)m_vhWndInsertAfters[ii]) )
					break;
			}
			bRet = buddyHelper.EndDefer();
		}
	}
	Reset();
	return bRet;
}

/// Kenny 10/10/2011 ORG-4051-P1 FIND_AND_REPLACE_CLICK_SKIP_LINKED_CELLS_CHECKBOX_DRAWING_BUG
BOOL CDeferWindowPosHelper::GetWndRect(HWND hWnd, RECT& rect, BOOL bGetRectFromParent /*= TRUE*/)
{
	int nIdx = GetWndIdx(hWnd);
	if ( nIdx < 0 )
	{
		if ( bGetRectFromParent )
		{
			Window wnd(hWnd);
			Window wndParent = wnd.GetParent();
			wnd.GetWindowRect(&rect);
			wndParent.ScreenToClient(&rect);
			return TRUE;
		}
		return FALSE;
	}
	int nRectMemOffset = nIdx * 4;
	rect.left	= m_vnRects[nRectMemOffset+0];
	rect.top	= m_vnRects[nRectMemOffset+1];
	rect.right	= rect.left + m_vnRects[nRectMemOffset+2];
	rect.bottom	= rect.top + m_vnRects[nRectMemOffset+3];
	return TRUE;
}

BOOL CDeferWindowPosHelper::SetWndRect(HWND hWnd, const RECT& rect, UINT uFlags /*= SWP_DEFAULT*/, HWND hWndInsertAfter /*= NULL*/)
{
	int nIdx = GetWndIdx(hWnd);
	if ( nIdx < 0 )
	{
		return Defer(hWnd, rect, uFlags, hWndInsertAfter);
	}
	int nRectMemOffset = nIdx * 4;
	m_vnRects[nRectMemOffset+0]	= rect.left;
	m_vnRects[nRectMemOffset+1]	= rect.top;
	m_vnRects[nRectMemOffset+2]	= RECT_WIDTH(rect);
	m_vnRects[nRectMemOffset+3]	= RECT_HEIGHT(rect);
	return TRUE;
}

int CDeferWindowPosHelper::GetWndIdx(HWND hWnd)
{
	int nNumWnds = m_vhWnds.GetSize();
	for (int ii = 0; ii < nNumWnds; ++ii)
	{
		if ( (HWND)m_vhWnds[ii] == hWnd )
			return ii;
	}
	return -1;
}
/// End FIND_AND_REPLACE_CLICK_SKIP_LINKED_CELLS_CHECKBOX_DRAWING_BUG

void CDeferWindowPosHelper::Reset()
{
	m_nNumWnds	= -1;
	m_hDWP		= NULL;
	m_vhWnds.RemoveAll();
	m_vnRects.RemoveAll();
	m_vnFlags.RemoveAll();
	m_vhWndInsertAfters.RemoveAll();
}
/// End FIND_AND_REPLACE_DIALOG_FLICKERING_WHEN_RESIZE

/// Kenny 02/03/2012 ORG-4177-P1 PA_WIZARD_DLG_IMPROVE_STEP_UPDATE
CRedrawLocker::CRedrawLocker(HWND hWnd, UINT nRedrawFlags /*= RDW_INVALIDATE | RDW_UPDATENOW | RDW_ERASE | RDW_ALLCHILDREN*/)
{
	m_hWnd			= hWnd;
	m_nRedrawFlags	= nRedrawFlags;
	Window wnd(hWnd);
	wnd.SetRedraw(FALSE);
}

CRedrawLocker::~CRedrawLocker()
{
	Window wnd(m_hWnd);
	wnd.SetRedraw(TRUE);
	wnd.RedrawWindow(NULL, NULL, m_nRedrawFlags);
}
/// End PA_WIZARD_DLG_IMPROVE_STEP_UPDATE

//------ CPY 10/1/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
// starting from nx, ny as the top-left position, move controls one after another to
// the right, nGap < 0 will use default gap between controls
// return the lowest y position
// if cx is given, then nIDStretch will be stretched to fill right most to cx location
int ResizeDialog::ArrangeControlsLeftRight(uint nButtonIDs[], int nx, int ny, int cx, int nIDStretch, int nGap)
{
	if(cx > 0 && nIDStretch > 0)
	{
		Control cToStretch;
		RECT rr;
		if(GetControlClientRect(nIDStretch, rr, &cToStretch))
		{
			int nOldWidth = RECT_WIDTH(rr);
			//get combined width
			int nTotal = 0, ntgap = nGap<0? GetControlGap() : nGap;
			int ii = 0;
			RECT rt;
			while(nButtonIDs[ii])
			{
				Control ct = GetItem(nButtonIDs[ii++]);
				if(ct && ct.Visible)
				{
					GetClientRect(ct, rt);//ct.GetWindowRect(&rt);	Jasmine 05/09/07 FIX_THEME_SAVE_GROUP_RESIZE_BUG					
					nTotal += ntgap + RECT_WIDTH(rt);
				}
			}
			int nExtra = cx - nx - nTotal;
			///Jasmine 05/09/07 FIX_THEME_SAVE_GROUP_RESIZE_BUG
			/*
			if(nExtra > 2*nOldWidth) nExtra = 2*nOldWidth;
			else if(nExtra < -0.5*nOldWidth) nExtra = -0.5*nOldWidth;
			*/
			if(nExtra + nOldWidth < GetControlGap()) nExtra = -0.5*nOldWidth;
			///End FIX_THEME_SAVE_GROUP_RESIZE_BUG
			rr.right += nExtra;
			//cToStretch.MoveWindow(&rr);
			MoveControl(cToStretch, rr); //---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW
		}
	}
	return ArrangeControlsLeftRight(nButtonIDs, nx, ny, nGap);
}
//------ end GETN_THEME_SAVEAS_NEW_DIALOG


// global functin for displaying the tree
bool out_params(TreeNode& tr)
{
	TreeNode cNode = tr.FirstNode;
	
	if(cNode == NULL)
		return false;
	
	string strLabel;
	string strVal;
	
	while(cNode)
	{
		//--- 
		if(!cNode.GetAttribute(STR_LABEL_ATTRIB, strLabel))
			strLabel = cNode.tagName;
		
		strVal = cNode.Text;
		
		printf("%s->%s\n", strLabel, strVal);
		
		//----
		cNode = cNode.NextNode;
	}
	return true;
}


static void out_v(LPCSTR lpcsz, vector<int>& vv)
{
	//printf("%s:", lpcsz);
	for(int ii = 0; ii < vv.GetSize(); ii++)
		printf(" %d,", vv[ii]);
	
	out_str("");
}
		

//--------------------- vsFlex routines that might be used in other dialogs --------

/*
int TwipsToPixels(Window wndDlg, int twips, bool bX=true)
{
	DeviceContext dc = wndDlg.GetDC();
	
	double vv = 0.5 + dc.GetDeviceCaps(bX? LOGPIXELSX : LOGPIXELSY) * (double)twips / 1440.0;
	return vv;
}
*/


/////////////////////////////////////////
// utilities for GetNBox handling
// convert i1 0-offset and i2 to notation "12 - 34" that is one offset and contains at least 1 point
// pass in values of -1 to indicate Auto
string range_to_str(int i1, int i2)
{
	string strAuto = "Auto";
	string str1 = (i1+1);
	string str2 = i2;

	if(i1<0)
		str1 = strAuto;
	if(i2<0)
		str2 = strAuto;
	
	return str1 + " - " + str2;
}

static int atoi_check_auto(const string& str)
{
	if(str.IsEmpty())
		return -1;
	str.TrimLeft();
	if(str[0] >= '0' && str[0] <= '9')
		return atoi(str);
	
	return -1;
}

bool str_to_range(LPCSTR lpcszRange, int& i1, int& i2)
{
	string strTemp = lpcszRange;
	int nPos = strTemp.Find('-');
	i1 = i2 = -1;
	if(nPos < 0)
		return false;
	
	i1 = atoi_check_auto(strTemp.Left(nPos));
	i2 = atoi_check_auto(strTemp.Mid(nPos+1));
	return true;
}


/**#
	construct a string "min|max|steps"
*/
string range_to_str(double min, double max, int nSteps)
{
	string str;
	char szmin[30];
	char szmax[30];
	DoubleToStr(min, szmin, 30, "*");
	DoubleToStr(max, szmax, 30, "*");
	
	str.Format("%s|%s|%d", szmin, szmax, nSteps);
	return str;
}
/**#
	from the string "min|max|steps" to return numeric values
	Example:
	void tt(double min, double max, int nsteps)
	{
		string str = range_to_str(min, max, nsteps);
		out_str(str);
		
		double a, b;
		int nn;
		if(str_to_range(str, a, b, nn))
			printf("It is from %f to %f and num steps = %d\n", a, b, nn);
	}
*/
bool str_to_range(LPCSTR lpcszRange, double& min, double& max, int& nSteps)
{
	vector<string> vsTemp;
	string str = lpcszRange;
	int nn = str.GetTokens(vsTemp, '|');
	if(nn != 3)
		return false;
	
	min = atof(vsTemp[0]);
	max = atof(vsTemp[1]);
	nSteps = atof(vsTemp[2]);
	return true;
}


//////////// functions used inside TreeEditControl
//---- CPY 9/21/05 JASMINE_FOUND_GETN_BUTTON_BROKEN
static bool _is_str_combo_list(const string& str)
{
	if(str == "...")
		return true; // vsFlex button via comboList
	
	return str.Find('|') >= 0? true:false;
}
//----

//---------- CPY 9/10/05 IRIS_FOUND_BRANCH_COMBO_SINGLE_ITEM_WITH_SPACE_BECOMES_TWO
//string get_node_combo_str(TreeNode& trNode)
string get_node_combo_str(TreeNode& trNode, bool bMakeEmptyIfNotPipeSeparated)
{
	string strTemp;
	// only some node type can support combo
	int nNodeID = trNode.ID;
	/*
	if(TRGP_NUMERIC_LIST == nNodeID || TRGP_STR_LIST == nNodeID || TRGP_RANGE == nNodeID || TRGP_STR_BUTTON == nNodeID || TRGP_SLIDEREDIT == nNodeID || TRGP_SLIDER == nNodeID) /// YuI 1/15/04: added slider
	{
		trNode.GetAttribute(STR_COMBO_ATTRIB, strTemp);
	}
	*/
	switch( nNodeID )
	{
	//--- CPY 10/7/04 COMBO_BRANCH_FOR_MULTIPLE_RANGE_MODE
	case TRGP_BRANCH:
		trNode.GetAttribute(STR_ATTRIB_BRANCH_COMBO, strTemp);		
		break;
	//--- end COMBO_BRANCH_FOR_MULTIPLE_RANGE_MODE
	case TRGP_NUMERIC_LIST:
	case TRGP_ENUM_LIST:
	case TRGP_STR: // CPY 7/16/04 allow edit control to also have combo
	case TRGP_RANGE:
	case TRGP_STR_BUTTON:
	case TRGP_SLIDEREDIT:
	case TRGP_SLIDER:
	case TRGP_STR_GROUP: //--- CPY 11/19/05 QA70-8339 ROC_CURVE_NEEDS_STATE_VALUES
		trNode.GetAttribute(STR_COMBO_ATTRIB, strTemp);
		break;
	}
	//---------- CPY 9/10/05 IRIS_FOUND_BRANCH_COMBO_SINGLE_ITEM_WITH_SPACE_BECOMES_TWO
	if(bMakeEmptyIfNotPipeSeparated && !strTemp.IsEmpty() && !_is_str_combo_list(strTemp))//strTemp.Find('|') < 0)
		strTemp.Empty();
	//----------	
	return strTemp;
}
bool is_node_need_numeric_validation(TreeNode& trNode)
{
	switch(trNode.ID)
	{
	case TRGP_NUMERIC_LIST:
		{
			string str = get_node_combo_str(trNode);
			if(str[0] != '|')
				return false;
		}
		// fall through
	case TRGP_DOUBLE:
		return true;
	}
	return false;
}
/*
string get_combo_str_by_index(int nIndex, LPCSTR lpcsz)
{
	int nPos = 0;
	if(lpcsz[0] == '|')
		lpcsz++; // skip, usually should not be allowed
	
	string strSrc = lpcsz;
	return strSrc.GetToken(nIndex, '|');
}

string get_node_val_as_str(TreeNode& trNode)
{
	string strTemp;
	int	nIndex;
	trNode.GetAttribute(STR_COMBO_ATTRIB, strTemp);
	nIndex = atoi(trNode.Text);
	return get_combo_str_by_index(nIndex, strTemp);
}
*/

///Jasmine 02/29/08 QA80-11043-P2 GETN_BUTTONS_SEPARATELY_ENABLE_DISABLE
//vnBtns: indexes of buttons to disable, other buttons will be enable
void disable_buttons_in_group(const vector<int>& vnBtns, TreeNode& trBtnGroup)
{
	if(!trBtnGroup)
		return;
	
	DWORD dwEnableBits = 0x00FF; // we only have 3 buttons, so only bits 0,1,2, having more bits on should be ok
	for(int ii = 0 ; vnBtns && ii < vnBtns.GetSize(); ii++)
	{
		DWORD dwBitsToTurnOff = 1;
		dwBitsToTurnOff <<= vnBtns[ii];
		dwEnableBits &= ~dwBitsToTurnOff;
	}
	
	dwEnableBits |= ENABLE_INDEP_BY_BITS; // this bit to tell buttons to control separately by lower bits
	trBtnGroup.Enable = dwEnableBits;
}
///End GETN_BUTTONS_SEPARATELY_ENABLE_DISABLE

#ifndef _TREE_UTILS_FROM_DLL	/// SY 07/21/2004 QA70-6641 MOVE_OC_TREE_UTILITY_TO_VC_LEVEL
//nSetShow = 0,1 will force all child nodes to set Show to same
void tree_get_shows(TreeNode& tr, vector<int>& vv, int nSetShow)// = -1)
{
	int nVal;
	foreach(TreeNode cNode in tr.Children)
	{
		if(nSetShow >= 0)
			cNode.Show = nSetShow;
		
		nVal = cNode.Show;
		vv.Add(nVal);
		if(cNode.GetNodeCount() > 0) // branch node
			tree_get_shows(cNode, vv, nVal);
	}
}

//nSetEnable = 0,1 will force all child nodes to set Enable to same
void tree_get_enables(TreeNode& tr, vector<int>& vv, int nSetEnable)// = -1)
{
	int nVal;
	foreach(TreeNode cNode in tr.Children)
	{
		if(nSetEnable >= 0)
			cNode.Enable = nSetEnable;
		
		nVal = cNode.Enable;
		vv.Add(nVal);
		if(cNode.GetNodeCount() > 0) // branch node
			tree_get_enables(cNode, vv, nVal);
	}
}

bool is_same(const vector<int>& v1, const vector<int>& v2)
{
	//----
	//out_v("New", v1);
	//out_v("Old", v2);
	//----
	uint nSize = v1.GetSize();
	if(nSize != v2.GetSize())
		return false;
	
	for(int ii = 0; ii < nSize; ii++)
	{
		if(v1[ii] != v2[ii])
			return false;
	}
	return true;
	
}

//---- CPY v7.5785 12/19/03 QA70-5738 GETN_BOX_COMBO_CHANGE_NEEDED
// return -2 if totally diff, no way to compare
// return -1 if same
// return 0 offset index of 1st diff string otherwise
int get_changed(const vector<string>& vs1, const vector<string>& vs2, bool bCaseSensitive)// = true)
{
	uint nSize = vs1.GetSize();
	if(nSize != vs2.GetSize())
		return -2;
	
	for(int ii = 0; ii < nSize; ii++)
	{
		if(bCaseSensitive)
		{
			if(vs1[ii].Compare(vs2[ii]) != 0)
			 return ii;
		}
		else 
		{
			if(vs1[ii].CompareNoCase(vs2[ii]) != 0)
				return ii;
		}
	}
	return -1;
}
/// SY 07/21/2004 QA70-6641 MOVE_OC_TREE_UTILITY_TO_VC_LEVEL
#else //_TREE_UTILS_FROM_DLL
void tree_get_shows(TreeNode& tr, vector<int>& vv, int nSetShow)// = -1)
{
	octree_attribute_values(&tr, STR_SHOW_ATTRIB, nSetShow, &vv);
}

void tree_get_enables(TreeNode& tr, vector<int>& vv, int nSetEnable)// = -1)
{
	octree_attribute_values(&tr, STR_ENABLE_ATTRIB, nSetEnable, &vv);
}

bool is_same(const vector<int>& v1, const vector<int>& v2)
{
	return oc_is_same(&v1, &v2);
}

int get_changed(const vector<string>& vs1, const vector<string>& vs2, bool bCaseSensitive)// = true)
{
	return ocget_changed(&vs1, &vs2, bCaseSensitive);
}
#endif // _TREE_UTILS_FROM_DLL	
/// end SY 07/21/2004 QA70-6641 MOVE_OC_TREE_UTILITY_TO_VC_LEVEL



//////////////////////////// CPY 1/21/04
////////////////////
// some other basic utilities
////////////////////
void SetRect(RECT& rect, int nLeft, int nTop, int nRight, int nBottom)
{
	rect.left = nLeft;
	rect.top = nTop;
	rect.right = nRight;
	rect.bottom = nBottom;
}


//------------------------- end utilities ----------------------




///Danice GETNTREE_AUTO_LOAD_DEFAULT
bool tree_load_default_setting(TreeNode& tr, bool bCheckSettingBranch) //=true
{
	bool bLoad = false;
	bool bKeepCheckStats = bCheckSettingBranch;
	string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, THTYPE_ANALYSIS);//TREE_PROPERTY_SAVE_PATH;
	vector<int> vnIDs;
	vector<string> vsValues;
	///Forest 09/10/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD
	string strThemeFile = "";
	///Frank 1/22/05
	//tr.GetAttribute(STR_THEME_FILE_ATTRIB, strThemeFile);
	//theme_get_file_info(tr, strThemeFile);
	///Jasmine 09/17/05 v8.0307 SET_AND_GET_THEME_FILE_NAME
	//tree_get_file_name(tr, strThemeFile);///Frank 1/24/05 v8.0185 CENTRALIZE_CODE_OF_FILE_NAME_ATTRIB
	tree_get_theme_file_name(tr, strThemeFile);
	///End SET_AND_GET_THEME_FILE_NAME
	///Frank 1/22/05
	
	string strFullFileName = strPath + strThemeFile;
	if(strFullFileName.IsFile())
	{
		if( tree_read_values_with_ids(strFullFileName, vnIDs, vsValues) )
			if( 0 < tree_set_values_by_ids(tr, vnIDs, vsValues) )
				return	true;
	} 
	//---- CPY 2/24/05 TURN_OFF_BRANCH_DEFAULT_LOADING
	/*
	///End SETTINGS_THEME_FILE_SAVE_LOAD
	foreach(TreeNode trNode in tr.Children)
	{
		if(trNode.GetNodeCount() > 0)
		{
			string strBranch, strID;
			if(bCheckSettingBranch && trNode.GetAttribute(STR_ATTRIB_BRANCH, strBranch) && GETNBRANCH_SAVE_SETTINGS == atoi(strBranch))
				bCheckSettingBranch = false;
			if(!bCheckSettingBranch && trNode.GetAttribute(STR_DATAID_ATTRIB, strID))
			{
				string strDefaultFile = strPath + strID +"-" + THEME_FILENAME_DEFAULT + ".ois";
				if(strDefaultFile.IsFile())
				{
					if(tree_read_values_with_ids(strDefaultFile, vnIDs, vsValues))
						if(0 < tree_set_values_by_ids(trNode, vnIDs, vsValues))
							bLoad = true;
				}
			}
			if(!bLoad)
				bLoad = tree_load_default_setting(trNode, bCheckSettingBranch);
			//Apply check setting to next node
			if(bCheckSettingBranch != bKeepCheckStats)
				bCheckSettingBranch = bKeepCheckStats;
		}
	}
	return bLoad;
	*/
	return false;
	//---- end 
}
///END GETNTREE_AUTO_LOAD_DEFAULT

//-------- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
string TreeEditSaveSettingMenu::getCopyThemeFullPathFilename(const string& strNodeID)
{
	string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, THTYPE_ANALYSIS);//TREE_PROPERTY_SAVE_PATH_USER; 
	
	string strFile = strPath + THEME_FILENAME_NO_CLASS + "_" + strNodeID + "-" + THEME_FILENAME_COPY + ".ois";
	return strFile;
}
	
bool TreeEditSaveSettingMenu::loadBranchThemeFile(int nCmd)
{
	///Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME
	/*
	string strFullFileName = TREE_PROPERTY_SAVE_PATH_USER + m_vsSaveFile[nCmd - SETTING_LOAD];
	if(strFullFileName.IsFile())
		return theme_load_settings(m_trInputData, strFullFileName);
	// next try system path
	strFullFileName = TREE_PROPERTY_SAVE_PATH + m_vsSaveFile[nCmd - SETTING_LOAD];
	return theme_load_settings(m_trInputData, strFullFileName);
	*/
	return theme_load_settings(m_trInputData, m_vsSaveFile[nCmd - SETTING_LOAD]);
	///End CENTRALIZE_CODE_ON_BRANCH_THEME
}
string TreeEditSaveSettingMenu::askSaveFileName(HWND hWndParent)
{
	string strNodeID;
	m_trInputData.GetAttribute(STR_DATAID_ATTRIB, strNodeID);
	string strClassOption = THEME_FILENAME_NO_CLASS;
	string strThemeFile;
	strClassOption = strClassOption + "_" + strNodeID;
	//return theme_ask_save_as_filename(strClassOption, strThemeFile, hWndParent);
	return theme_ask_save_as_filename(strClassOption, strThemeFile, hWndParent, NULL, true);
}

///Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME
//void TreeEditSaveSettingMenu::addBranchThemeFiles(const string& strNodeID)
//{
	//vector<string> vsFileList;
	//FindFiles(vsFileList, TREE_PROPERTY_SAVE_PATH, "ois");	//List all the ois files from system folder
//
	/////----Forest 9/27/04 QA70-6682 LOAD_THEME_FROM_SYSTEM_AND_USER
	//vector<string> vsFileListUser;
	//FindFiles(vsFileListUser, TREE_PROPERTY_SAVE_PATH_USER, "ois");	//List all the ois files from user folder
	//vsFileList.Append(vsFileListUser);
	/////----
	//
	/////Forest 09/14/04 QA70-6682	SETTINGS_THEME_FILE_SAVE_LOAD
	///*
	//int nIDIndex = strNodeID.GetLength()+1; //add 1 for "-"
	//for(int ii=0; ii<vsFileList.GetSize(); ii++)
	//{
		////search the available ois file
		//if(0 != vsFileList[ii].CompareNoCase(GetFileName(m_strDefaultFile)) && 
		   //0 != vsFileList[ii].CompareNoCase(GetFileName(m_strCopyToFile)) && 
		   //vsFileList[ii].Left(nIDIndex) == (strNodeID+"-") )
		//{
			//m_vsSaveFile.Add(vsFileList[ii]);
		//}
	//}
	//
	//for(ii=0; ii<m_vsSaveFile.GetSize(); ii++)
	//{
		//string strFileName = m_vsSaveFile[ii];
		//strFileName.TrimLeft(strFileName.Left(nIDIndex));
		//strFileName.Format("%s %s", _L("Load"), strFileName);
		//Add(strFileName, OnMenuItem);	//add the available setting file to menu
	//}
	//*/
	//string strPrefix = THEME_FILENAME_NO_CLASS + "_" + strNodeID + "-";
	//int nPrefixLength = strPrefix.GetLength();
	//for(int ii = 0; ii < vsFileList.GetSize(); ii++)
	//{
		//if(0 != vsFileList[ii].CompareNoCase(GetFileName(m_strCopyToFile)) && 
		   //vsFileList[ii].Left(nPrefixLength) == strPrefix )
		//{
			//m_vsSaveFile.Add(vsFileList[ii]);
		//}
	//}
	//
	//if(m_vsSaveFile.GetSize() > 0)
		//Add( NULL, OnMenuItem );
//
	//for(ii = 0; ii < m_vsSaveFile.GetSize(); ii++)
	//{
		//string strFileName = m_vsSaveFile[ii];
		//strFileName = strFileName.Right(strFileName.GetLength() - nPrefixLength);
		//strFileName = strFileName.Left(strFileName.GetLength() - 4 );//remove ".ois"
		//Add("Load Branch Settings - " + strFileName, OnMenuItem);	//add the available setting file to menu
	//}		
	/////End SETTINGS_THEME_FILE_SAVE_LOAD
//}
void TreeEditSaveSettingMenu::addBranchThemeFiles(const string& strNodeID)
{
	string strPrefix = THEME_FILENAME_NO_CLASS + "_" + strNodeID;
	vector<string>  vsFilenames, vsDisplayNames;
	//int iThemes = theme_get_class_settings(strPrefix, vsFilenames, vsDisplayNames);
	//int iThemes = theme_get_class_settings(strPrefix, vsFilenames, vsDisplayNames, true);
	
	/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
	// int iThemes = theme_get_class_settings(strPrefix, vsFilenames, vsDisplayNames, THTYPE_REPORT_TABLE);
	int iThemes = okutil_theme_get_class_settings(strPrefix, &vsFilenames, &vsDisplayNames, THTYPE_REPORT_TABLE);
	/// end MOVE_GET_CLASS_SETTINGS_TO_VC
	
	if(iThemes == 0 || (iThemes == 1 && vsDisplayNames[0] == THEME_FILENAME_COPY) )	//no theme files found except copy file
		return;

	Add( NULL, OnMenuItem );
	
	for(int ii = 0; ii < iThemes; ii++)
	{
		if( vsDisplayNames[ii] == THEME_FILENAME_COPY )
			continue;
		m_vsSaveFile.Add(vsFilenames[ii]);
		Add("Load Branch Settings - " + vsDisplayNames[ii], OnMenuItem);
	}
}
///End	CENTRALIZE_CODE_ON_BRANCH_THEME		

//---- CPY 10/9/04 THEME_RELATED_CODE_MOVED_TO_GETNBOX_C
int TreeEditSaveSettingMenu::DoTrackPopup(int nx, int ny, HWND hWndParent)
{
	TrackPopupMenu(0,  nx, ny, hWndParent);
	int nCmd;
	if(!GetCommand(nCmd))
		return TREE_NONE;
	//vector<int> vnIDs;
	//vector<string> vsValues;
	string strFullFileName;
	switch(nCmd)
	{
	case SETTING_SEPARATOR_0:
	case SETTING_SEPARATOR_1:
		break;
		//case SETTING_SET_AS_DEFAULT:
		//if(tree_get_values_with_ids(m_trInputData, vnIDs, vsValues))
			//tree_save_values_with_ids(m_strDefaultFile, vnIDs, vsValues);
		//break;
	case SETTING_RESET_TO_DEFAULT:
		//if(tree_read_values_with_ids(m_strDefaultFile, vnIDs, vsValues) &&
			//0 < tree_set_values_by_ids(m_trInputData, vnIDs, vsValues) )
		//{
			//return TREE_VAL_CHANGED;
		//}
		///Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME
		/*
		int		n1 = m_strThemeFilePrefix.Find('_');
		string  strClassname;
		int		nOption;
		if(n1 < 0)
		{
			strClassname = m_strThemeFilePrefix;
			nOption = 0;
		}
		else
		{
			strClassname = m_strThemeFilePrefix.Left(n1);
			nOption = atoi( m_strThemeFilePrefix.Right(m_strThemeFilePrefix.GetLength() - n1 - 1) );
		}
		Tree	trOpGUI;
		if( get_operation_GUI_tree(strClassname, trOpGUI, nOption) )
			if( 0 < tree_copy_values_by_id(trOpGUI, m_trInputData) )
				return TREE_VAL_CHANGED;
		*/
		if( theme_load_factory_default(m_strThemeFilePrefix, m_trInputData) )
			return TREE_VAL_CHANGED;
		///End	CENTRALIZE_CODE_ON_BRANCH_THEME
		break;
	case SETTING_SAVE:
		//strFullFileName = askSaveFileName(TREE_PROPERTY_SAVE_PATH, strNodeID + "-", ".ois", &hWndParent);///Forest 09/14/04 QA70-6682	SETTINGS_THEME_FILE_SAVE_LOAD
		strFullFileName = askSaveFileName(hWndParent);
		
		///Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME	
		/*
		if(!strFullFileName.IsEmpty() && tree_get_values_with_ids(m_trInputData, vnIDs, vsValues))
			tree_save_values_with_ids(strFullFileName, vnIDs, vsValues);
		*/
		if(!strFullFileName.IsEmpty())
			theme_save_settings(m_trInputData, strFullFileName);
		///End	CENTRALIZE_CODE_ON_BRANCH_THEME
		break;
	case SETTING_COPY:
		///Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME	
		/*
		if(tree_get_values_with_ids(m_trInputData, vnIDs, vsValues))
			tree_save_values_with_ids(m_strCopyToFile, vnIDs, vsValues);
		*/
		theme_save_settings(m_trInputData, m_strCopyToFile);
		///End	CENTRALIZE_CODE_ON_BRANCH_THEME
		break;
	case SETTING_PASTE:
		///Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME	
		/*
		if(tree_read_values_with_ids(m_strCopyToFile, vnIDs, vsValues) &&
			0 < tree_set_values_by_ids(m_trInputData, vnIDs, vsValues))
		{
			DeleteFile(m_strCopyToFile); 
			return TREE_VAL_CHANGED;
		}
		*/
		if( theme_load_settings(m_trInputData, m_strCopyToFile) )
		{
			DeleteFile(m_strCopyToFile); 
			return TREE_VAL_CHANGED;
		}			
		///End	CENTRALIZE_CODE_ON_BRANCH_THEME
		break;
	default :	//SETTING_LOAD
		if(loadBranchThemeFile(nCmd))
		{
			return TREE_VAL_CHANGED;
		}
		break;
	}
	
	return TREE_NONE;
}
//---- end THEME_RELATED_CODE_MOVED_TO_GETNBOX_C


//-------- end THEME_FILE_USER_PATH_SYSTEM_PATH

//--------- CPY SY 07/27/2004 QA70-6719 v8.0105 GETN_AUTO_RESIZE_WIDTH_WITH_LONG_LABEL
// start moving functions out of GridControl.h

///Frank 3/20/05 v8.0207 APPLY_ADDTREENODES_WITH_NEW_RULE		
//void GridTreeControl::addTreeRow(TreeNode& cNode, int nLevel, DWORD dwCntrl, bool bIsBranch)	///Danice ADD_TREENODE_FROM_ROW
//void GridTreeControl::addTreeRow(TreeNode& cNode, int nLevel, DWORD dwCntrl, bool bIsBranch, int *pnFromRow) // = false, NULL
void GridTreeControl::addTreeRow(TreeNode& cNode, int nLevel, bool bIsBranch, int *pnFromRow, int nCols) // = false, NULL, 0
///End APPLY_ADDTREENODES_WITH_NEW_RULE		
{
	//int nCols = dwCntrl & 0x000F; // lowest byte for num of cols, = 0 if no need to add extra cols	///Frank 3/20/05 v8.0207 APPLY_ADDTREENODES_WITH_NEW_RULE		
	
	string strTemp;
	if(!cNode.GetAttribute(STR_LABEL_ATTRIB, strTemp) || strTemp.IsEmpty())
	{
		if(!cNode.GetAttribute(STR_NAME_ATTRIB, strTemp) || strTemp.IsEmpty())
			strTemp = cNode.tagName;
	}
	
	if(!bIsBranch && nCols)
	{
		for(int ii = 1; ii < nCols; ii++)
			strTemp += "\t";
	}
	
	///Danice ADD_TREENODE_FROM_ROW
	/*
	m_flx.AddItem(strTemp);
	int nRow = m_flx.Rows - 1;
	*/
	int nRow=m_flx.Rows;
	//if(NULL == pnFromRow || nRow <= *pnFromRow)	///DG 1/21/05 : order is not right
	if(NULL == pnFromRow || nRow < *pnFromRow)
	{
		m_flx.AddItem(strTemp);
	}
	else
	{
		m_flx.AddItem(strTemp, *pnFromRow);
		nRow = (*pnFromRow)++;
	}
	///end ADD_TREENODE_FROM_ROW
	///Danice SAVE_ROW_DATA_SET_BOLD_NEEDED
	string strTemp2;
	if(cNode.GetAttribute(STR_DATA_ATTRIB, strTemp2))
	{
		double dbRowData=atoi(strTemp2);
		SetRowData(nRow, dbRowData);
	}
	///end
	
	if(m_bIsOutlineTree && nLevel >= 0)
	{
		SetIsSubtotal(nRow, true);
		SetRowOutlineLevel(nRow, nLevel);
		/// TD 3-23-04 QA70-6053 PICTURE_IN_OC
		setCellIcon(cNode, nRow, 0);
		/// end PICTURE_IN_OC

	}
	//--- CPY 7/15/04 the following seems not correct?
	// bIsBranch is better then cNode.GetNodeCount() > 0 ??
	// also nRow seems not right, runtime error even if I put m_flx.Rows - 1
	// this is not the right place to do this, should not call IsCollapsed in the middle of adding
	//	///Danice 7/14/04 QA70-6631 v8.0905 TREE_BRANCH_COLLAPSED_DEFAULT
	//	if(cNode.GetNodeCount() > 0)
	//		m_flx.IsCollapsed(nRow) = flexOutlineCollapsed;
	//	///end TREE_BRANCH_COLLAPSED_DEFAULT
	//----
}
//--------- end CPY SY 07/27/2004 QA70-6719

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
// Class Implementation Functions for GridControl and related classes
/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

//--- CPY 7/29/04 FIT_LR_DLG_NOT_VISIBLE_DUE_TO_NEG_GRID_HEIGHT
// this should typically not used as we setup each row's height in prepareEditCell already
void GridControl::ResizeAllRows(int nExtraPixcels )//= 0);
{
	bool bAllRowSameWidth = false;
	int nExtra = PixelsToTwips(nExtraPixcels);
	m_flx.AutoSizeMode = flexAutoSizeRowHeight;
	m_flx.AutoSize(0, m_flx.Cols - 1, bAllRowSameWidth, nExtra);
}

void GridControl::GetGridSize(int& nx, int& ny)
{
	int nCellH;
	ny = 0;
	nx = 0;
	int count = 0;
	for(int nRow = 0; nRow < m_flx.Rows; nRow++)
	{
		nCellH = GetCell(flexcpHeight, nRow, m_flx.Col);
		//--- CPY 7/29/04 FIT_LR_DLG_NOT_VISIBLE_DUE_TO_NEG_GRID_HEIGHT
		int nH = GetRowHeight(nRow);
		string str = GetCell(flexcpText, nRow, 0);
		if(nCellH < 0) // something is wrong, it should never happen, but we don't know why this happens yet
		{
			//printf("- height(%d) at Row = %d, tag = %s, rowH = %d\n", nCellH, nRow, str, nH);
			if(GetIsRowHidden(nRow))
				nCellH = 7;// there are some bugs, result height too small, so just adding some here
			else
				nCellH = nH;
		}
		//else
		//	printf("+ height(%d) at Row = %d, tag = %s, rowH = %d\n", nCellH, nRow, str, nH);
		//---
		//---- CPY 10/20/05 SMOOTH_XF_GETN_BOX_NOT_PROPER_SIZE_ON_INIT
		// not sure why yet, will find clean solution later
		if(2==m_flx.Cols && IsCheckBoxCell(nRow, 1) && nH > 0 && nCellH < nH && nCellH > nH/3)
		{
			//printf("trying to fix checkbox size, %d->%d\n", nCellH, nH);
			nCellH = nH;
		}
		//-----
		//printf("+ height(%d) at Row = %d, tag = %s, rowH = %d\n", nCellH, nRow, str, nH);
		
		ny += nCellH;
		count++;
	}
	//printf("total rows %d, ny = %d\n", count, ny);
	ny = TwipsToPixels(ny);
	
	int nn = 0;
	for(int nCol = 0; nCol < m_flx.Cols; nCol++)
	{
		nn += GetColWidth(nCol); //flx.Cell(flexcpWidth, 0, nCol);
	}
		
	nx = TwipsToPixels(nn);
	// gain 1 more pixels
	nx++;
	ny++;
	_DBINT2("Grid width/height =", nx, ny)
}



//Frank  7/28/04 v8.0105  COLLAPSED_BRANCE_WITHOUT_LEAF_NODES
//Add argument of skip leaf.
//One reason is Collapse on leaf node in branch will do nothing;
//another reason, in some place like in Parameter Node of FO simulation, the count of leaf note is  not stable, so need to remove the leaf's collapsed state.
//so add an argument to skip the leaf. the same of function SetCollapsed
int GridListControl::GetCollapsed(vector<byte>& vn, bool bOnlyTopLevelIsBranch)// = true )
{
	if(m_flx.OutlineBar == flexOutlineBarNone)
		return -1;
	vn.SetSize(0);
	int nCounts = 0;
	for(int nRow = m_flx.FixedRows; nRow < m_flx.Rows; nRow++)
	{
		//Frank  7/28/04 v8.0105  COLLAPSED_BRANCE_WITHOUT_LEAF_NODES
		//if(m_flx.IsSubtotal(nRow))//&& m_flx.RowOutlineLevel(nRow) < 3)
		if(isBranch(nRow, bOnlyTopLevelIsBranch) )
		{
			nCounts++;
			int nCollapsed = GetIsCollapsed(nRow);
			nCollapsed = (flexOutlineCollapsed == nCollapsed)? 1:0;
			vn.Add(nCollapsed);
			_DBINT2("GetCollapsed Row/Collapsed = ", nRow, nCollapsed);
		}
	}
	return nCounts;
}

// CPY 1/28/05 SET_COLLAPSED_NULL_VEC_FOR_TRUE_TO_ALL
// use NULL for vn to set collapse to all nodes for faster operations
bool GridListControl::SetCollapsed(const vector<byte>& vn, bool bOnlyTopLevelIsBranch)// = true  )
{
	if(m_flx.OutlineBar == flexOutlineBarNone)
		return false;
	int nn = 0;

	for(int nRow = m_flx.FixedRows; nRow < m_flx.Rows; nRow++)
	{
		//--- CPY 1/28/05 SET_COLLAPSED_NULL_VEC_FOR_TRUE_TO_ALL
		if(NULL == vn)
		{
			SetIsCollapsed(nRow, flexOutlineCollapsed);
			continue;
		}
		//---
		//Frank  7/28/04 v8.0105  COLLAPSED_BRANCE_WITHOUT_LEAF_NODES
		//if(m_flx.IsSubtotal(nRow))// && m_flx.RowOutlineLevel(nRow) < 3)
		if(isBranch(nRow, bOnlyTopLevelIsBranch))
		{
			if(nn >= vn.GetSize())
				return false;
			
			BOOL bIsCollasped = vn[nn++]? true:false;
			_DBINT2("SetCollapsed Row/Collapsed = ", nRow, bIsCollasped);
			
			int nCollapsed = bIsCollasped?flexOutlineCollapsed : flexOutlineSubtotals;//flexOutlineExpanded;
			SetIsCollapsed(nRow, nCollapsed);
			
			///Danice TREE_BRANCH_COLLAPSED_IMPROVEMENT
			if(!bIsCollasped)
			{
				for(int nParent=GetParent(nRow); -1 < nParent; nParent=GetParent(nParent))
				{
					if(flexOutlineCollapsed == GetIsCollapsed(nParent) )
					{
						SetIsCollapsed(nParent, flexOutlineCollapsed);
						break;
					}
				}
			}
			///end TREE_BRANCH_COLLAPSED_IMPROVEMENT
		}
		else if(!bOnlyTopLevelIsBranch)
			nn++;
	}
	return true;
}
bool GridListControl::SetCollapsed(int nRow, bool bIsCollasped)	//------- CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX
{
	if(m_flx.OutlineBar == flexOutlineBarNone)
		return false;
	if(nRow < m_flx.Rows && nRow >= m_flx.FixedRows)
	{
		int nCollapsed = bIsCollasped?flexOutlineCollapsed : flexOutlineSubtotals;//flexOutlineExpanded;
		SetIsCollapsed(nRow, nCollapsed);
		return true;
	}
	return false;
}
// return -1 if not applicable, otherwise 1 = collapsed, 0 = expended
int GridListControl::GetCollapsed(int nRow)
{
	if(m_flx.OutlineBar == flexOutlineBarNone)
		return -1;
	if(nRow < m_flx.Rows && nRow >= m_flx.FixedRows)
	{
		return GetIsCollapsed(nRow);
	}
	return -1;
}
//--- end FIT_LR_DLG_NOT_VISIBLE_DUE_TO_NEG_GRID_HEIGHT

#ifdef _OLD_GETN_MODELESS_DLG //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER
///--- CPY 7/29/05 QA70-7884 GETN_MODELESS
static bool	assign_PDLG(LPVOID lpDest, GetNModelessDlg* pDlg)
{
	if(NULL == lpDest)
		return false;
	DWORD		*pdwDest = (DWORD*)lpDest;
	DWORD		dwHandle = (DWORD)pDlg;
	*pdwDest = dwHandle;
	return true;
}


bool CreateGetNBox(DWORD* ppDlg, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn, HWND hWndParent)
{
	int nID = IDD_GET_N_BOX_TREE;
	if(tr.tagName == "GetNBox")
		nID = IDD_GET_N_BOX;
	else if(tr.tagName == "GUI")
		nID = IDD_GETNBOX_THEME;

	//DWORD dw = ppDlg;
	//GetNModelessDlgPtr* ppGetNDlg = (GetNModelessDlgPtr*)dw;
	GetNModelessDlg* pDlg = new GetNModelessDlg(NULL, nID, tr, lpcszTitle, lpcszDescription, pfn, pEvtFn);
	if(NULL == hWndParent)
		hWndParent = GetWindow();
	pDlg->CreateEx(hWndParent);
	pDlg->ShowWindow(SW_NORMAL);		
	return true;
}
//----
#endif //_OLD_GETN_MODELESS_DLG

int		get_data_range_UID_in_tree(TreeNode& tr)
{
	TreeNode trInputData = tr.FindNodeByAttribute(STR_ID_ATTRIB, TRGP_DATA_RANGE);
	TreeNode trTemp;
	if( trInputData )
		trTemp = trInputData.Parent();
			
	string strTemp;
	if( trTemp && trTemp.GetAttribute(STR_DATARANGE_UID_ATTRIB, strTemp) )
	{
		int	uidInputDataRange = atoi(strTemp);
		return uidInputDataRange;
	}
	
	return -1;
}
////////////////////////////////////////////////////////////////////////////////////
/// end INPUT_DATA_RANGE_INCAPSULATION


///DG 1/24/05 POSITION_TOP_ITEM_WITHOUT_PANE
bool ResizeDialog::PositionTopPane(int cx, int cy)
{
	vector<uint> vnCntrIDs;
	vector	vyRatios;
	if(!GetTopPaneControls(vnCntrIDs, vyRatios))
		return false;
	
	// first see if there is a need to resize any of the controls
	int nEdge = GetControlGap();
	int nSumy = 0;
	int ii;
	vector<uint> vnTopDownIDs;
	vector<uint> vnHorzIDs, vnHorzPrevIDs, vnHorzAlignTypes;
	for(ii = 0; ii < vyRatios.GetSize(); ii++)
	{
		if(vyRatios[ii] > 0) // resize needed
			;
		else if(vyRatios[ii] < 0) // horizontal position
		{
			vnHorzIDs.Add(vnCntrIDs[ii]);
			vnHorzPrevIDs.Add(vnCntrIDs[ii-1]);// runtime error if ii = 0
			vnHorzAlignTypes.Add(vyRatios[ii] == -1? 0:1); // will add as macro later
			continue;
		}
		else // keep height
		{
			RECT rr;
			GetControlClientRect(vnCntrIDs[ii], rr);
			nSumy += RECT_HEIGHT(rr);
		}
		if(ii > 0)
			nSumy += nEdge;
		vnTopDownIDs.Add(vnCntrIDs[ii]);
	}
	int ny = nEdge + GetToolBarHeight();
	int nyTotal = cy - ny;
	vector<int> vnHeights;
	vnHeights.SetSize(vnTopDownIDs.GetSize());
	vnHeights = 0;
	if(nyTotal > nSumy)
	{
		int nyToDivide = nyTotal - nSumy;
		int jj = 0;
		for(ii = 0; ii < vyRatios.GetSize(); ii++)
		{
			if(vyRatios[ii] < 0)
				continue;
			if(vyRatios[ii] > 0)
				vnHeights[jj] = 0.5 + nyToDivide * vyRatios[ii]; 
			
			jj++;
		}
	}
	vnTopDownIDs.Add(0);
	ArrangeControlsTopDown(vnTopDownIDs, nEdge, ny, nEdge, vnHeights, cx - 2*nEdge);
	if(vnHorzIDs.GetSize() > 0)
	{
	}
	return true;
}
///end POSITION_TOP_ITEM_WITHOUT_PANE

//---- CPY 1/15/05 XF_DLG_CODE_CLEANUP
//cMainItem.MoveWindow(&rMain, m_bRepaintWhenMove);
//virtual
void ResizeDialog::PositionTopPaneMainItem(Control& cMainItem, RECT& rMain, int cx, uint nMainItemID)
{
	///DG POSITION_TOP_ITEM_WITHOUT_PANE
	/*
	vector<uint> vnTopDownIDs;
	vector	vyRatios;
	if(!GetTopPaneControls(vnTopDownIDs, vyRatios))
	{
		cMainItem.MoveWindow(&rMain, m_bRepaintWhenMove);
		return;
	}
	// first see if there is a need to resize any of the controls
	int nEdge = GetControlGap();
	int nSumy = 0;
	int ii;
	for(ii = 0; ii < vyRatios.GetSize(); ii++)
	{
		if(vyRatios[ii] > 0) // resize needed
			;
		else // keep height
		{
			RECT rr;
			GetControlClientRect(vnTopDownIDs[ii], rr);
			nSumy += RECT_HEIGHT(rr);
		}
		if(ii > 0)
			nSumy += nEdge;
	}
	int ny = nEdge;
	int nyTotal = rMain.bottom - ny;
	vector<int> vnHeights;
	vnHeights.SetSize(vyRatios.GetSize());
	vnHeights = 0;
	if(nyTotal > nSumy)
	{
		int nyToDivide = nyTotal - nSumy;
		for(ii = 0; ii < vyRatios.GetSize(); ii++)
		{
			if(vyRatios[ii] > 0)
				vnHeights[ii] = 0.5 + nyToDivide * vyRatios[ii]; 
		}
	}
	vnTopDownIDs.Add(0);
	ArrangeControlsTopDown(vnTopDownIDs, nEdge, ny, nEdge, vnHeights, cx - 2*nEdge);		
	*/
	if(!PositionTopPane(cx, rMain.bottom))
		//---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW
		//cMainItem.MoveWindow(&rMain, m_bRepaintWhenMove);
		MoveControl(cMainItem, rMain);
		//----
	///end POSITION_TOP_ITEM_WITHOUT_PANE
}
///Jasmine 07/16/09 #13952 HIDDEN_CONTROL_IS_IGNORED_IN_MOVING_AND_APPEAR_IN_BAD_POSITION 
//int ResizeDialog::ArrangeControlsTopDown(uint nButtonIDs[], int nx, int ny, int nGap, vector<int>& vnHeights, int nW)
int ResizeDialog::ArrangeControlsTopDown(uint nButtonIDs[], int nx, int ny, int nGap, vector<int>& vnHeights, int nW, bool bForceResize/*= false*/)
///End HIDDEN_CONTROL_IS_IGNORED_IN_MOVING_AND_APPEAR_IN_BAD_POSITION
{
	RECT rr, r1;
	rr.left = nx;
	rr.top = ny;
	/// TD 3-2-05 QA70-7459 REPOSITION_WINDOWS_VECTOR
//	vector<uint> hWnds;
//	RECT rects[MAX_NUM_CTRLS];
	/// end REPOSITION_WINDOWS_VECTOR
	if(nGap < 0)
		nGap = m_nEdge;
	int ii = 0;
	int nMaxWidth = 0;
	while(nButtonIDs[ii] > 0)
	{
		Control btn;// = GetItem(nButtonIDs[ii]);
		//if(btn && btn.Visible)
		///Jasmine 07/16/09 #13952 HIDDEN_CONTROL_IS_IGNORED_IN_MOVING_AND_APPEAR_IN_BAD_POSITION 
		//if(GetControlClientRect(nButtonIDs[ii], r1, &btn) && btn.Visible)
		if(GetControlClientRect(nButtonIDs[ii], r1, &btn) && (btn.Visible || bForceResize))
		///End HIDDEN_CONTROL_IS_IGNORED_IN_MOVING_AND_APPEAR_IN_BAD_POSITION
		{
			/// TD 3-2-05 QA70-7459 REPOSITION_WINDOWS_VECTOR
			//hWnds.Add((uint)btn.GetSafeHwnd());
			/// end REPOSITION_WINDOWS_VECTOR
			//btn.GetWindowRect(&r1);
			if(vnHeights == NULL || vnHeights[ii] == 0)
			{
				rr.bottom = rr.top + RECT_HEIGHT(r1);
				rr.right = rr.left + RECT_WIDTH(r1);
			}
			else
			{
				rr.bottom = rr.top + vnHeights[ii];
				rr.right = nW > 0? nW : rr.left + RECT_WIDTH(r1);
			}
			if(nMaxWidth < RECT_WIDTH(rr))
				nMaxWidth = RECT_WIDTH(rr);
			
			/// TD 3-2-05 QA70-7459 REPOSITION_WINDOWS_VECTOR
			//btn.MoveWindow(&rr, m_bRepaintWhenMove);
			//rects[ii] = rr;
			/// end REPOSITION_WINDOWS_VECTOR
			MoveControl(btn, rr); //---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW

			rr.top = rr.bottom + nGap;
		}
		ii++;
	}
	/// TD 3-2-05 QA70-7459 REPOSITION_WINDOWS_VECTOR
//	SizeMoveChildWindows(hWnds, rects);
	/// end REPOSITION_WINDOWS_VECTOR
	return nx + nMaxWidth;
}



int TreeEditInputData::GetInputDataDescription(TreeNode& trInputData, string& strDRDesc)
{
	/// YuI 03/22/05 LOW_LEVEL_FUNCTION_TO_CHECK_RANGE_REALITY
	/*
	
	/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
	if( trInputData.ID == TRGP_XY_DATA_RANGE )
	{
		string strVal = trInputData.X.strVal;
		if( strVal.Compare(STR_NEW) == 0 || strVal.Compare(STR_ACTIVE) == 0 )
		{
			strDRDesc = strVal;
			return 1;
		}
	}
	/// end XYDATARANGE_PROPERTY_IMPLEMENTATION

	DataRange dr;
	dr.Create(trInputData);
	strDRDesc = dr.GetDescription();
	dr.Destroy();
	*/
	
	/// YuI 03/19/07 QA70-9503 MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
	//	SelfCreatingDataRange dr;
	DataRange dr;
	/// end MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
	
	
	/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	//	strDRDesc = dr.GetDescription();
	/// YuI 12/19/05 XFUNCTION_OC_TO_VC_CONVERSION
	//	dr.SetTree(trInputData);
	//	strDRDesc = dr.GetRuntimeDescription();
#ifndef	SELF_CREATING_RANGE_VC_BASED
	dr.SetTree(trInputData);
	strDRDesc = dr.GetRuntimeDescription();
#else
	dr.SetSCTree(trInputData);
	dr.GetRuntimeDescription(strDRDesc);
#endif //	SELF_CREATING_RANGE_VC_BASED
	/// end XFUNCTION_OC_TO_VC_CONVERSION
	/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
	
	/// end LOW_LEVEL_FUNCTION_TO_CHECK_RANGE_REALITY
	
	
	//out_str(strDRDesc);
	return strDRDesc.GetNumTokens('\r') + 1;
}
//----
#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER		

/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
BOOL	TreeEditInputData::OnContextUpdate()
{
	static int l_nPreviouseContext = EXIST_NONE;
	PageBase pg = Project.Pages();
	int nNewContext = pg.GetType();
	if( l_nPreviouseContext == EXIST_NONE || l_nPreviouseContext != nNewContext )
	{
		// need to modify anything only on context change
		// here we need to check what kind of page is active and update tree under the 
		// context sensitive control in accordance
		// for WKS pages it will not have any subbranches and control will act just like
		// regular interactive control
		// for graph pages - need to add branches to create datarange like tree
		// and control will be more like datarange control
		TreeNode trInputData = get_tree_node(m_nEditRow);
		if( !trInputData.IsValid() )
			return FALSE;
		
		switch( nNewContext )
		{
			case EXIST_GRAPH:
			{
				Tree trTemp;
				init_input_data_branch_from_selection(trTemp, DRR_GET_DEPENDENT);
				createAddDataRange(trTemp);
			}
			break;
			
			case EXIST_WKS:
			{
				foreach( TreeNode trTemp in trInputData.Children )
				{
					trInputData.RemoveChild(trTemp);
				}
			}
			break;		
		}
	}
	
	return TRUE;
}

BOOL	TreeEditInputData::DoInteractiveDlg(Window* pOwner, BOOL bModalParent, BOOL bDataRange)
{
	PageBase pg = Project.Pages();
	if( !pg )
		return error_report("No page for interactive dialog");
	
	if( pg.GetType() == EXIST_GRAPH )
	{
		DataRange dr;
		int nSubRange;
		if( GetDataRange(dr, nSubRange) )
		{
			DataSelectorTool dsTool;
			dsTool = Project.GetTool(OTT_DATA_SELECTOR);	
			dsTool.SetDataRange(dr, nSubRange);
			Project.ActivateTool(OTT_DATA_SELECTOR);
			
			return DoDataRangeGraphDlg(*this, pOwner, bModalParent);
		}
	}
	else if( pg.GetType() == EXIST_WKS && !bDataRange )
	{
		//MessageBox(NULL, "Dialog is not ready yet.\rPlease set focus to control and make selection in a worksheet instead", "", MB_OK);
	}
	
	return TRUE;
}

BOOL	TreeEditInputData::DoXYDataRangeDlg(Window* pOwner, BOOL bModalParent)
{
	PageBase pg = Project.Pages();
	if( !pg )
		return error_report("No page for interactive dialog");
	
	TreeNode trEdit = get_tree_node(m_nEditRow, m_nEditCol);
	if( pg.GetType() == EXIST_GRAPH && !is_xyz_data_range_node(trEdit) )
	{
		// YuI 07/21/05: the code in OnDialogDeactivate in COKPage 
		// is replacing page in the current tool
		// and OnDialogDeactivate gets called if there is GraphPage control in the dialog
		// and dialog gets hidden
		// so it is crucial to activate tool later then manipulation with active dialogs is finished
		// so I am moving this code into the XYDataRangeGraphDlg class
		/*
		DataRange dr;
		dr.Create(trEdit);
		DataSelectorTool dsTool;
		dsTool = Project.GetTool(OTT_DATA_SELECTOR);	
		dsTool.SetDataRange(dr, 0);
		Project.ActivateTool(OTT_DATA_SELECTOR);
		*/
		return DoXYDataRangeGraphDlg(*this, pOwner, bModalParent, trEdit);
	}
	else if( pg.GetType() == EXIST_WKS )
	{
		pOwner->ShowWindow(SW_HIDE);
		
		BOOL bReturn = DoXYDataRangeWksDlg(trEdit);
		if( bReturn )
		{
			string strOldVal;
			GetInputDataDescription(trEdit, strOldVal);
			tree_set_attribute_to_all_nodes(trEdit, STR_CHANGED_ATTRIB, strOldVal);
		//	TreeEditControl* pCntrl = this;
		//	pCntrl->UpdateGridValues();
		}
		pOwner->ShowWindow(SW_SHOW);
		pOwner->PostMessage(WM_USER_ON_CHILD_KILL_FOCUS);
		if( bModalParent )
		{
			Window wndMain(_get_origin_win());
			if( wndMain )
				wndMain.Enable = FALSE;
		}
		return bReturn;
	}
}


/*
static string	_get_column_description(Column col)
{
	string strReturn;
	strReturn.Format("Col(%d)", col.GetIndex() + 1);
	return strReturn;
}
*/

#define	INPUT_DATA_MENU_NEW			(-2)
#define	INPUT_DATA_MENU_ACTIVE		(-3)
class	InputDataPopUpMenu	:	public	MenuBase
{
public:
	InputDataPopUpMenu(BOOL bOutput)	:	MenuBase()
	{
		m_bAddNew = bOutput;
		if( !bOutput )
		{
			GraphLayer gl = Project.ActiveLayer();
			if( gl )
			{
				m_bAddActive = TRUE;
			}
		}
		Populate();
	}
	//virtual
	int DoTrackPopup(int nx, int ny, HWND hWndParent)
	{
		TrackPopupMenu(0,  nx, ny, hWndParent);
		int nCmd;
		if(!GetCommand(nCmd))
			return 0;
		//----- CPY 3/7/05
		// New/Active etc already handled by special handler, so general handlers are just index, so need to offset if needed
		if( m_bAddActive )
			nCmd--;
		if( m_bAddNew )
			nCmd--;
		//-----
		OnMenuSelectionChange(nCmd);
		return 1;
	}
public:
	int	GetSelection()
	{
		return m_nSelection;
	}
	
	BOOL	GetSelection(Column& col)
	{
		Worksheet wks = Project.ActiveLayer();
		if( wks )
		{
			Column colTemp(wks, GetSelection());
			if( colTemp )
			{
				col = colTemp;
				return TRUE;
			}
		}
		
		return FALSE;
	}
	
	BOOL	GetSelection(DataPlot& dp)
	{
		GraphLayer gl = Project.ActiveLayer();
		if( gl )
		{
			//----- CPY 3/7/05
			/*
			int nPlot = m_nSelection;
			if( m_bAddActive )
				nPlot--;
			if( m_bAddNew )
				nPlot--;
			*/
			int nPlot = GetSelection();
			//----
			DataPlot dpTemp;
			dpTemp = gl.DataPlots(nPlot);
			if( dpTemp )
			{
				dp = dpTemp;
				return TRUE;
			}
		}
		
		return FALSE;
	}
protected:
	void	Populate()
	{
		if( m_bAddNew )
			Add(STR_NEW, OnMenuNew);

		if( m_bAddActive )
			Add(STR_ACTIVE, OnMenuActive);
			
		Layer ll = Project.ActiveLayer();
		Worksheet  wks;
		GraphLayer gl;
		if( wks = ll )
		{
			int nIndex = 0;
			foreach(Column cc in wks.Columns)
			{
				if( nIndex == 10 )
				{
					AddMoreItem();
					break;
				}
				Add(_get_column_description(cc), OnMenuItem);
				nIndex++;
			}
		}
		else if( gl = ll )
		{
			if( gl.DataPlots.Count() > 0 )
			{
				int nIndex = 0;
				foreach(DataPlot dp in gl.DataPlots)
				{
					if( nIndex == 10 )
					{
						AddMoreItem();
						break;
					}
					DataPlotStrings dps;
					dp.GetPlotType(&dps);
					Add(dps.szPlotDesigDescription, OnMenuItem);
					nIndex++;
				}	
			}
		}
	}
	
	void	AddMoreItem()
	{
		Add(NULL, OnMenuMore); // separator
		Add(_L("More..."), OnMenuMore);
	}
	
	void OnMenuNew(UINT nPos)
	{
		m_nSelection = INPUT_DATA_MENU_NEW;
	}
	
	void OnMenuActive(UINT nPos)
	{
		m_nSelection = INPUT_DATA_MENU_ACTIVE;
	}
	
	void OnMenuMore(UINT nPos)
	{
		vector<string> arrStrings;
		Layer ll = Project.ActiveLayer();
		Worksheet wks;
		GraphLayer gl;
		if( wks = ll )
		{
			foreach(Column cc in wks.Columns)
			{
				arrStrings.Add(_get_column_description(cc));
			}
		}
		else if( gl = ll )
		{
			foreach(DataPlot dp in gl.DataPlots)
			{
				DataPlotStrings dps;
				dp.GetPlotType(&dps);
				arrStrings.Add(dps.szPlotDesigDescription);
			}	
		}
		
		int nSel = ListInputBox(&arrStrings, "");
		OnMenuSelectionChange(nSel);
	}
	
	void		OnMenuSelectionChange(int nSel)
	{
		if( nSel < 0 )
			return;
		
		m_nSelection = nSel;
	}
	
	
	
private:
	int 	m_nSelection;
	BOOL	m_bAddNew;
	BOOL	m_bAddActive;
};
// if function is internal <active> must be resolved into absolute range
BOOL	TreeEditInputData::ResolvePopUpSelectionActive(BOOL bResolve)
{
	TreeNode trEdit = get_tree_node(m_nEditRow, m_nEditCol);
	if( bResolve )
	{
		return resolve_active_data_plot(trEdit);
	}
	else
	{
		foreach( TreeNode trTemp in trEdit.Children )
		{
			trTemp.strVal = STR_ACTIVE;
		}
	}
	
	return TRUE;
}

// if function is internal Col(1) etc must be resolved into absolute range
BOOL	TreeEditInputData::ResolvePopUpSelectionColumn(Column& col, string& strSel, BOOL bResolve)
{
	if( !col )
		return FALSE;
		
	if( bResolve )
	{
		return make_column_range_string(strSel, col);
	}
	else
	{
		if( col )
		{
			strSel = _get_column_description(col);
		}
	}
	
	return TRUE;
}

BOOL	TreeEditInputData::DoInteractivePopUp(Window* pOwner, int nX, int nY)
{
	TreeNode trEdit = get_tree_node(m_nEditRow, m_nEditCol);
	/// ML 3/16/2005 MENUACTION_MENUS
	///////////////////////////////////////////////////////////////////
	
	/// YuI 08/08/05 XVAR_ACTION_OBJECT_SHOULD_NOT_DEPEND_ON_ENTIRE_VAR_TREE
	//	TreeNode	trVar = trEdit.Parent();
	TreeNode	trVar = trEdit;
	/// end XVAR_ACTION_OBJECT_SHOULD_NOT_DEPEND_ON_ENTIRE_VAR_TREE
	
	return DoInteractiveDataPopupMenu(*this, trVar, pOwner, nX, nY);
	
	///////////////////////////////////////////////////////////////////
	/// end MENUACTION_MENUS
	BOOL bAddNew = _is_output(trEdit);
	InputDataPopUpMenu menuInputData(bAddNew);
	menuInputData.DoTrackPopup(nX, nY, pOwner->GetSafeHwnd());
	int nSelection = menuInputData.GetSelection();
	BOOL bNewSelected = (nSelection == INPUT_DATA_MENU_NEW);
	BOOL bActiveSelected = (nSelection == INPUT_DATA_MENU_ACTIVE);

	Layer ll = Project.ActiveLayer();
	GraphLayer gl;
	Worksheet wks;
	string strSel;

	if( bNewSelected )
	{
		foreach( TreeNode trTemp in trEdit.Children )
		{
			trTemp.strVal = STR_NEW;
		}
	}

	if( gl = ll )
	{
		EditorManager	trNodeManager;
		if( bActiveSelected )
		{
			foreach( TreeNode trTemp in trEdit.Children )
			{
				trTemp.strVal = STR_ACTIVE;
			}
		}
		else if( !bNewSelected )
		{
			DataPlot dp;
			menuInputData.GetSelection(dp);
			data_plot_update_xy_data_range_tree(dp, trEdit);
		}
	}
	else if( wks = ll )
	{
		if( bNewSelected )
			strSel = STR_NEW;
		else
		{
			Column col;
			if( menuInputData.GetSelection(col) )
				strSel = _get_column_description(col);
		}
		
		/// ML 3/16/2005 MENUACTION_MENUS
		//EditorManager	trNodeManager;
		//DWORD	dwTemp = m_flx.Cell(flexcpData, m_nEditRow, m_nEditCol);
		//trNodeManager.SetText(dwTemp, strSel, OXVT_STRING);
		//trNodeManager.SetEditorStr(m_dwEditor, strSel);
		SetEditText(strSel);
		/// end MENUACTION_MENUS
	}
				
	
	pOwner->PostMessage(WM_USER_ON_CHILD_KILL_FOCUS);
	return TRUE;
}
/// end VECTORIAL_NUMERIC_FUNCTIONS
#endif //#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER		


static BOOL	_is_var_node(TreeNode& tr)
{
	int nVar;
	if( tr.GetAttribute(STR_XF_VARIABLE_NODE_ATTRIB, nVar) && nVar != 0 )
		return TRUE;
	
	return FALSE;
}

/// YuI 08/08/05 XVAR_ACTION_OBJECT_SHOULD_NOT_DEPEND_ON_ENTIRE_VAR_TREE
static bool _is_xvar_input_ex(TreeNode &tr, bool bExcludeOutput)
{
	// first check attribute
	int nIO;
	if( tr.GetAttribute(STR_XF_VAR_IO_ATTRIB, nIO) )
	{
		return ((nIO == IO_INPUT) || (!bExcludeOutput && nIO == IO_INOUTPUT));
	}
	
	// no attribute. Try parent
	TreeNode trVar = tr.Parent();
	if( trVar && _is_var_node(trVar) )
		return is_xvar_input(trVar, bExcludeOutput);
	
	return false;
}

static bool _is_xvar_output_ex(TreeNode &tr, bool bExcludeInput)
{
	// first check attribute
	int nIO;
	if( tr.GetAttribute(STR_XF_VAR_IO_ATTRIB, nIO) )
	{
		return ((nIO == IO_OUTPUT) || (!bExcludeInput && nIO == IO_INOUTPUT));
	}
	
	// no attribute. Try parent
	TreeNode trVar = tr.Parent();
	if( trVar && _is_var_node(trVar) )
		return is_xvar_output(trVar, bExcludeInput);
	
	return false;
}

/// end XVAR_ACTION_OBJECT_SHOULD_NOT_DEPEND_ON_ENTIRE_VAR_TREE

bool	is_xvar_input(TreeNode &trVar, bool bExcludeOutput)
{
	if( !_is_var_node(trVar) )
	/// YuI 08/08/05 XVAR_ACTION_OBJECT_SHOULD_NOT_DEPEND_ON_ENTIRE_VAR_TREE
	//	return FALSE;
		return _is_xvar_input_ex(trVar, bExcludeOutput);
	/// end XVAR_ACTION_OBJECT_SHOULD_NOT_DEPEND_ON_ENTIRE_VAR_TREE
	
	/// YuI 02/03/06 XFUNCTION_OC_TO_VC_CONVERSION
	/*
	XVariableHelper	xv(trVar);
	XVariableBase* pVar = xv.Var();
	if( !pVar )
		return error_report("Failed to construct XVariable");
	
	return pVar->IsInput(bExcludeOutput);
	*/
	return okxf_is_variable_input(&trVar, bExcludeOutput);
	/// end XFUNCTION_OC_TO_VC_CONVERSION
}

bool	is_xvar_output(TreeNode &trVar, bool bExcludeInput)
{
	if( !_is_var_node(trVar) )
	/// YuI 08/08/05 XVAR_ACTION_OBJECT_SHOULD_NOT_DEPEND_ON_ENTIRE_VAR_TREE
	//	return FALSE;
		return _is_xvar_output_ex(trVar, bExcludeInput);
	/// end XVAR_ACTION_OBJECT_SHOULD_NOT_DEPEND_ON_ENTIRE_VAR_TREE
	/// YuI 02/03/06 XFUNCTION_OC_TO_VC_CONVERSION
	/*
	XVariableHelper	xv(trVar);
	XVariableBase* pVar = xv.Var();
	if( !pVar )
		return error_report("Failed to construct XVariable");
	
	return pVar->IsOutput(bExcludeInput);
	*/
	return okxf_is_variable_output(&trVar, bExcludeInput);
	/// end XFUNCTION_OC_TO_VC_CONVERSION
}


//enum { IO_INPUT, IO_OUTPUT, IO_INOUTPUT };
static bool	_is_output(TreeNode& trEdit)
{
	TreeNode trVar = trEdit.Parent();
	
	return is_xvar_output(trVar, true);
}



/// YuI 03/14/2005 MATRIX_OBJECT_SELECTION
BOOL TreeEditControl::updateActiveWksSel(string& strSelection, int nSelectionType)
{
	TreeNode trEdit = get_tree_node(m_nEditRow, m_nEditCol);
	if( !trEdit )
		return FALSE;
	
	TreeNode trVar = trEdit.Parent();
	if( !trVar )
		return TRUE;
	
	if( !_is_var_node(trVar) )
		return TRUE;// not var node - proceed
	/// YuI 02/03/06 XFUNCTION_OC_TO_VC_CONVERSION
	/*
	XVariableHelper	xv(trVar);
	XVariableBase* pVar = xv.Var();
	if( !pVar )
		return error_report("Failed to construct XVariable");
	
	int nVarType = pVar->GetType();
	switch( nVarType )
	{
	case XVT_MATRIX:
	//case XVT_MATRIXOBJECT:
		if( nSelectionType != EXIST_MATRIX )
			return FALSE;
	// for simple types we return value in the last cell in selected range
	}
	return TRUE;
	*/
	if( okxf_get_variable_type(&trVar) == XVT_MATRIX && nSelectionType != EXIST_MATRIX )
		return FALSE;
	
	return TRUE;
	/// end XFUNCTION_OC_TO_VC_CONVERSION
}
/// end MATRIX_OBJECT_SELECTION


//////////////////////////////////////////////////////////////////////////////////////
static	bool	is_matrix_plot_type(int nPlotID)
{
	switch (nPlotID)
	{
	case IDM_PLOT_3D_MESH:
	case IDM_PLOT_CONTOUR:
	case IDM_PLOT_MATRIX_IMAGE:
		return true;
	}
	
	return false;
}


BOOL	DoInteractiveDataPopupMenu(TreeEditInputData &ctrl, TreeNode &trVar, Window* pOwner, int nX, int nY)
{
#ifdef _XV_ACTION_BASE_
	XVarDataPopupMenuHelper		menuhlp(trVar);
	
	menuhlp.DoInteractiveDataPopupMenu(ctrl, pOwner, nX, nY);
#endif //_XV_ACTION_BASE_
	
	return TRUE;
}

//---- CPY 6/10/2008 REMOVE_GETN_NEXT_PREV_DLG
/*
/// SY 8/17/05 QA70-8027 v8.0290 IMPORT_WIZARD_XF
bool GetNPrevNextBox(TreeNode& tr, LPCSTR lpcszTitle, HWND hWndParent, bool bSetGridView, bool bTranspose) //= NULL, NULL, false, false
{
	int nID = IDD_GETNBOX_NEXT_REPV;
	
	GetNPrevNextDlg myDlg(tr, lpcszTitle, bSetGridView, bTranspose);
	
	int nRet = myDlg.DoModalEx(hWndParent);
	// true for Next and false for Prev
	myDlg.UpdateEditTreeNode(tr);
	
	return nRet;
}

GetNPrevNextDlg::GetNPrevNextDlg(TreeNode& tr, LPCSTR lpcszTitle, bool bSetGridView, bool bTranspose) : TreeEditDlg(IDD_GETNBOX_NEXT_REPV, "ODlg")
{
	m_input_tr = tr;
	m_paramTree.AddNode(tr.Clone());
	m_strTitle = lpcszTitle;
	
	m_bSetGridView = bSetGridView;
	m_bTranspose = bTranspose;
}

GetNPrevNextDlg::~GetNPrevNextDlg()
{
	OnDestroy();
}

BEGIN_MESSAGE_MAP(GetNPrevNextDlg)
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_GETNDLG_MSGS(IDC_PARAMS_GRID)
	ON_GRID_AFTER_COLLAPSE(IDC_PARAMS_GRID, OnAfterCollapse)
	
	ON_BN_CLICKED(IDC_PREV, OnClickPrev)
	ON_BN_CLICKED(IDC_NEXT, OnClickNext)
END_MESSAGE_MAP


BOOL GetNPrevNextDlg::OnInitDialog()
{
	waitCursor junk;
	
	ResizeDialog::OnInitDialog();
	
	m_btnPrev = GetItem(IDC_PREV);
	m_btnNext = GetItem(IDC_NEXT);
	
	//check if we need Outline tree
	int nSubBranchs = 0;
	tree_count_items(THE_TREE_NODE, &nSubBranchs);
	BOOL bSubBranch = nSubBranchs > 0 ? TRUE : FALSE;
	m_treeEditCntrl.Init(IDC_PARAMS_GRID, FALSE, bSubBranch, NULL, *this);
	
	Update(THE_TREE_NODE, TRUE, TRUE);

	if( !m_strTitle.IsEmpty() )
		m_wndDlg.Text = m_strTitle;
	
	m_treeEditCntrl.SetReady();
	m_treeEditCntrl.Resize();
	resizeDlgToFit();
	
	return TRUE;
}

BOOL GetNPrevNextDlg::OnDestroy()
{
	m_treeEditCntrl.OnDestroy();
	return true;
}

int GetNPrevNextDlg::DoModalEx(HWND hWndParent)
{
	InitMsgMap();
	
	DWORD dwDlgOptions = 0;
	if( hWndParent )
		dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;

	int nRet = DoModal(hWndParent, dwDlgOptions);
	m_input_tr.Replace(THE_TREE_NODE);
			
	return nRet;
}

int GetNPrevNextDlg::CreateEx(HWND hWndParent)
{
	InitMsgMap();
	
	DWORD dwDlgOptions = 0;
	if( hWndParent )
		dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;
	
	return Create(hWndParent, dwDlgOptions);
}

bool GetNPrevNextDlg::Update(TreeNode& tr, bool bResize, bool bInit, bool bCallNodesHandlers) //true, false, true
{
	m_treeEditCntrl.SetReady(false);
	bool bRet;
	if( m_bSetGridView )
	{
		if( bInit )
			m_treeEditCntrl.CreateGridView();
		bRet = m_treeEditCntrl.UpdateGrid(tr, bResize, m_bTranspose, bCallNodesHandlers);
	}
	else
	{
		if( bInit )
			m_treeEditCntrl.CreateTreeView();
		bRet = m_treeEditCntrl.Update(tr, bResize, bInit, bCallNodesHandlers);
	}
	m_treeEditCntrl.SetReady(true);
	
	return bRet;
}

void GetNPrevNextDlg::OnAfterCollapse(Control cntrl, int nRow, short nState)
{
	if( m_treeEditCntrl.IsResizeOnCollapse(nRow, nState) )
		resizeDlgToFit();
}

void GetNPrevNextDlg::resizeDlgToFit()
{
	if( !m_treeEditCntrl.IsReady() )
		return;
	
	uint nBtnIds[] = {IDC_NEXT, IDC_PREV, 0};
	resizeDialog(nBtnIds);
}

void GetNPrevNextDlg::resizeDialog(uint* pIntIDs)
{
	int nEdge = GetControlGap();
	int ny = nEdge;
	int nxGrid, nyGrid;
	
	m_treeEditCntrl.GetGridSize(nxGrid, nyGrid);
	
	RECT r1, r2;
	Button btn = GetItem(pIntIDs[0]);
	btn.GetWindowRect(&r1);
	int nBtnWidth = r1.right - r1.left;
	int nBtnHeight= r1.bottom - r1.top;
	
	// next we caculate the size of dialog
	int cx = nEdge + nxGrid + nEdge;
	int cy = ny + nyGrid + nEdge + nBtnHeight + nEdge;
	int nGroupWidth, nGroupHeight;
	GetGroupTotalSize(pIntIDs, nGroupWidth, nGroupHeight);
	if( nGroupWidth > cx )
		cx = nGroupWidth;
	
	m_wndDlg.GetClientRect(&r1);
	int nOldDlgW = r1.right - r1.left;
	int nOldDlgH = (r1.bottom - r1.top);
	
	// we need to resize the dialog
	int nxDiff = cx - nOldDlgW;
	int nyDiff = cy - nOldDlgH;
	m_wndDlg.GetWindowRect(&r1);
	r1.right += nxDiff;
	r1.bottom += nyDiff;
	m_wndDlg.MoveWindow(&r1);
	
	r2.top = ny;
	r2.left = nEdge;
	r2.right = cx - nEdge;
	r2.bottom = cy - 2*nEdge - nBtnHeight;

	m_treeEditCntrl.MoveWindow(r2);	

	int nGap = nxDiff;
	// now move the buttons to all along the bottom
	ArrangeControlsRightLeft(pIntIDs, cx, r2.bottom + nEdge, nGap);
}

BOOL GetNPrevNextDlg::OnClickPrev(Control ctrl)
{
	// true for Next and false for Prev
	Update(THE_TREE_NODE, FALSE, FALSE);
	Close(FALSE);
	return TRUE;
}

BOOL GetNPrevNextDlg::OnClickNext(Control ctrl)
{
	// true for Next and false for Prev
	Update(THE_TREE_NODE, FALSE, FALSE);
	Close(TRUE);
	return TRUE;
}
*/
//----- end CPY 6/10/2008 REMOVE_GETN_NEXT_PREV_DLG
/// end IMPORT_WIZARD_XF 

/// AW 08/31/05 FIXING_SAME_TAGNAME_IN_TREE_TABLE
// move from treetable.h

TreeNode	TreeTable::GetTreeNode(int nCol, int nRow)
{
	TreeNode  trNode;
	if(nCol < 0 || nRow<0 || nCol >= GetNumCols() || nRow >= GetNumRows())
		return trNode;
	int nTemp;
	if(m_bTranspose)
	{
		nTemp = nRow;
		nRow = nCol;
		nCol = nTemp;
	}
	///If the tree just have one column.
	if(m_vsRowTagNames.GetSize() == 0)
		return m_trNode.GetNode(m_vsColTagNames[nCol]);
	///If the tree just have one row.
	if(m_vsColTagNames.GetSize() == 0)
		return m_trNode.GetNode(m_vsRowTagNames[nRow]);
	TreeNode trFirstLevelNode;
	
	/// AW 08/31/05 FIXING_SAME_TAGNAME_IN_TREE_TABLE
	//trFirstLevelNode = m_trNode.GetNode(m_vsColTagNames[nCol]);
	if ( nCol < m_trNode.Children.Count() )		///------ Folger 03/19/2012 ORG-5311-P1 RUNTIME_ERROR_WHEN_DELETE_LAST_VAR_IN_XF_BUILDER
		trFirstLevelNode = m_trNode.Children.Item(nCol);
	/// END FIXING_SAME_TAGNAME_IN_TREE_TABLE
	if(trFirstLevelNode)
		trNode	= trFirstLevelNode.GetNode(m_vsRowTagNames[nRow]);
	return trNode;
}
///Hong 04/04/06 QA70-6903 FIXED_ERROR_OUTPUT_OF_HIDDEN_NODE
//void	TreeTable::processTwoDimensionTreeNodeValue(TreeNode &tr, vector<string> &vsColTagNames, vector<string> &vsRowTagNames,vector<string> &vsTableCellValues, string strDoubleValueFormat)
void	TreeTable::processTwoDimensionTreeNodeValue(TreeNode &tr, vector<string> &vsColTagNames, vector<string> &vsRowTagNames,vector<string> &vsTableCellValues, string strDoubleValueFormat, bool bSkipHidden)
///End FIXED_ERROR_OUTPUT_OF_HIDDEN_NODE
{
	TreeNode		tr1LevNode;
	TreeNode		tr2LevNode;
	string			strTemp;
	vector<string>	vsTempValus;
	///Hong 04/04/06 QA70-6903 FIXED_ERROR_OUTPUT_OF_HIDDEN_NODE
	//for(int nColIndex = 0; nColIndex < vsColTagNames.GetSize(); nColIndex++) 
	int		iColSize = tr.Children.Count();	
	for(int nColIndex = 0; nColIndex < iColSize; nColIndex++)
	///End FIXED_ERROR_OUTPUT_OF_HIDDEN_NODE
	{ 
		vsTempValus.RemoveAll();
		vector<string>	vsTreeNodeSectionValue;
		/// AW 08/31/05 FIXING_SAME_TAGNAME_IN_TREE_TABLE
		//tr1LevNode = tr.GetNode(vsColTagNames[nColIndex]);
		tr1LevNode = tr.Children.Item(nColIndex);
		/// END FIXING_SAME_TAGNAME_IN_TREE_TABLE
		///Hong 04/04/06 QA70-6903 FIXED_ERROR_OUTPUT_OF_HIDDEN_NODE
		//if(!tr1LevNode)
		if(!tr1LevNode || (bSkipHidden && tr1LevNode.Show == 0))
		///End FIXED_ERROR_OUTPUT_OF_HIDDEN_NODE
			continue;		
		processLeafTreeNodeValue(tr1LevNode, vsRowTagNames, vsTempValus, strDoubleValueFormat);
		vsTableCellValues.Append(vsTempValus);
	}
}
/// END FIXING_SAME_TAGNAME_IN_TREE_TABLE

//--- 	CPY 9/9/2006 IMAGE_GETN_PREVIEW_UPDATE_WHEN_INPUT_CHANGED
#define STR_IMG_INPUT_ATTRIB	"InputImage"

//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
static void _check_show_msg(ImageControlBase* pimgCntrl, const string& strErrMsg)
{
	HWND hDlg = pimgCntrl->GetParent();
	if(hDlg)
		getn_dlg_check_show_msg(hDlg, strErrMsg);
}
//--------- CPY 5/16/07 QA70-9659 GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME
/*
///Joseph	12/07/06	ADD_MESSAGE_BOX
//void getn_dlg_check_show_msg(HWND hDlg, const string& strErrMsg)
void getn_dlg_check_show_msg(HWND hDlg, const string& strErrMsg, bool bIsXF)
///End	ADD_MESSAGE_BOX
{
	Window wnd(hDlg);
	if(strErrMsg.IsEmpty())
	{
		wnd.SendMessage(WM_USER_MSG_ON_DLG);
		return;
	}
	
	//---- CPY 10/31/06 SIMPLE_GETN_DLG_CODE_MOVED_TO_GETNPREW_AND_GETNIMAGE_DLG
	//int nErrCode = -1;
	//if(is_str_numeric_integer(strErrMsg, &nErrCode))
	int nErrCode = 0;
	string str = strErrMsg;
	LPSTR lpstr = str.GetBuffer(str.GetLength() + MAXLINE);
	LPSTR lpstr2 = is_str_numeric_integer_with_args(lpstr, &nErrCode);
	LPCSTR lpcstr = NULL;
	if(lpstr2) // is numeric and may have additional argument
	{
		if(*lpstr2 != '\0')
			lpcstr = lpstr2;
	}
	else
		
	{
		///Joseph	12/07/06	ADD_MESSAGE_BOX
		if(bIsXF)
			lpcstr = str;
		else
		{
			string strErrMsgTag(lpstr);
			strErrMsgTag = strErrMsgTag + ":";
			strErrMsg.TrimLeft(strErrMsgTag);
			lpcstr = strErrMsg;
		}
		///End	ADD_MESSAGE_BOX
	}
	
	if(NULL == lpcstr)
		wnd.SendMessage(WM_USER_MSG_ON_DLG, nErrCode);
	else
	{	// trying to send a string
		const void *pp = lpcstr;
		DWORD lParam = (DWORD)pp;
		wnd.SendMessage(WM_USER_MSG_ON_DLG, nErrCode, lParam);
	}
	//------ end SIMPLE_GETN_DLG_CODE_MOVED_TO_GETNPREW_AND_GETNIMAGE_DLG
}
*/
bool getn_dlg_check_show_msg(HWND hDlg, LPCSTR lpcszErrMsg, LPCSTR lpcszTag, string* pstrLastSenderName, BOOL bAutoClearMsg)
{
	return process_err_msg_from_event(lpcszTag, lpcszErrMsg, hDlg, pstrLastSenderName, bAutoClearMsg);
}
//----- end GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME


//----

//------ CPY 9/25/05 QA70-8132 GETN_IMAGE_BOX_EVENTS_CLEAN
int	xf_GetNImageBox_event_handler(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, 
int nType, ImageControlBase* pimgCntrl,
PFNXFONINIT pfnOnInit, PFNXFONCHANGE pfnOnChange)
{
	int nRet = 0;

	/// EJP 2007-08-09 v8.0768 QA70-10171 FIX_IMG_MISSING_IN_IMG_PREVIEW_DLG
	///TreeNode trInput = trGetN.imgi;
	TreeNode trInput;
	StringArray saAttr;
	IntArray naValue;
	saAttr.Add(STR_XF_VAR_IO_ATTRIB); naValue.Add(IO_INPUT);
	saAttr.Add(STR_XF_VAR_TYPE); naValue.Add(XVT_IMAGE);
	octree_find_node_with_int_attr(&trGetN, &trInput, &saAttr, &naValue);
	/// end FIX_IMG_MISSING_IN_IMG_PREVIEW_DLG

	string strErrMsg;//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS

	//--- 	CPY 9/9/2006 IMAGE_GETN_PREVIEW_UPDATE_WHEN_INPUT_CHANGED
	//if((dwCntrl & GETNEVENT_ON_ANY) == GETNEVENT_ON_INIT)
	BOOL bInit = (dwCntrl & GETNEVENT_ON_ANY) == GETNEVENT_ON_INIT? true:false;
	if(trInput && !bInit && trNode && trNode.tagName == trInput.tagName)
	{
		string strImgIVal;
		if(trGetN.GetAttribute(STR_IMG_INPUT_ATTRIB, strImgIVal) && strImgIVal.CompareNoCase(trNode.strVal)!= 0) // use has changed input
			bInit = true;	
	}
	if(bInit)
	//---
	{
		//---- CPY 9/5/06 IMG_DLG_REMOVE_MATRIXOBJ_DEPENDENCY
		/*
		MatrixLayer ml = Project.ActiveLayer();
		if(!ml)
			return 0;
		MatrixObject mo = ml.MatrixObjects();
		if(mo)
			pimgCntrl->SetImage(mo, false);
		else
			error_report("failed to get active matixobject");
		*/
		// by default, we assume to preview using image specified in imgi variable
		if(trInput)
		{
			
			string strInputImg = trInput.strVal;	
			Image imgi;
			if(!okxf_resolve_string_get_origin_object(strInputImg, &imgi)||(!imgi.IsValid()))
			{
				warning_msg_box(XFERR_INVALID_IMAGE, false);
			}
			//end
			
			
			///Sandy 2006-11-1 report error when image invalid
			//pimgCntrl->SetImage(imgi);
			if(!pimgCntrl->SetImage(imgi))
				warning_msg_box(XFERR_INVALID_IMAGE, false); 
			//end
			//------ CPY 9/9/2006 IMAGE_GETN_PREVIEW_UPDATE_WHEN_INPUT_CHANGED
			trGetN.SetAttribute(STR_IMG_INPUT_ATTRIB, strInputImg);
			//------
		}
		//----
		bool bUpdate = false;
		bool bOKEnable = true; //#define GETNGEVT_OK_ENABLE			0x0004	
		
		if(pfnOnInit)
			pfnOnInit(trGetN, pimgCntrl, bUpdate, bOKEnable, strErrMsg);
		//--- CPY 7/2/2006 QA70-8798 OK_BUTTON_DISABLED_BY_EVENT
		//return bUpdate
		if(bUpdate) nRet |= GETNGEVT_GRID_NEED_UPDATE;
		if(bOKEnable) nRet |= GETNGEVT_OK_ENABLE;
		_check_show_msg(pimgCntrl, strErrMsg);//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
		return nRet;
		//---
	}
	// subsequent events
	bool bUpdateGetNDisplay = false;
	bool bOKEnable = true;
	/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
	///BITMAPHANDLE lbmpTemp;
	///if(pimgCntrl->CopyBitmapHandle(&lbmpTemp))
	pBITMAPHANDLE pLBmp = pimgCntrl->CopyBitmapHandle();
	if( pLBmp )
	/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE
	{
		bool bSuccess = true;
		if(pfnOnChange)
			/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
			///pfnOnChange(&lbmpTemp, trGetN, trNode, pimgCntrl, bSuccess, bUpdateGetNDisplay);
			pfnOnChange(pLBmp, trGetN, trNode, pimgCntrl, bSuccess, bUpdateGetNDisplay, bOKEnable, strErrMsg);
			/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE
				
		if(bSuccess)
			/// EJP 2006-03-17 v8.0376 QA70-8187 GET_DATA_VALUES_DIRECT_FROM_IMAGE
			///pimgCntrl->Update(&lbmpTemp);
			pimgCntrl->Update();
			/// end GET_DATA_VALUES_DIRECT_FROM_IMAGE
		
		///Sandy 2006-11-3 clean up error message
		//else
			//out_str("_rotate_imag failed");
	}
	else
		out_str("CopyBitmapHandle failed");		
	
//	return bUpdateGetNDisplay; // indicate no need to update GetN dialog controls
	if(bUpdateGetNDisplay) nRet |= GETNGEVT_GRID_NEED_UPDATE;
	if(bOKEnable) nRet |= GETNGEVT_OK_ENABLE;
	
	_check_show_msg(pimgCntrl, strErrMsg);//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
	
	return nRet;
}
/*
int	xf_GetNGraphPreviewBox_event_handler(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType,
PageBase& previewGraph, Datasheet& previewData,
PFNXF_G_ONINIT pfnOnInitGrid, PFNXF_G_ONINIT pfnOnInitGraph, PFNXF_G_ONINIT pfnOnInitPreview, 
PFNXF_G_ONCHANGE pfnOnChange, PFNXF_G_ONUPDATE pfnOnUpdateGraph, PFNXF_G_ONUPDATE pfnOnUpdatePreview, PFNXF_G_ONSETUP pfnOnDlgSetup)
{
	//--- CPY 5/20/06 CHANGE_GETN_PREVIEW_TO_DATASHEET_FROM_WKSHEET
	if(GETNEVENT_ON_SETUP & dwCntrl)
	{
		if(pfnOnDlgSetup)
			return pfnOnDlgSetup(trGetN, previewGraph, previewData);
		
		return 0;
	}
	//---
	bool bInit = (dwCntrl & GETNEVENT_ON_INIT) ? true : false;
	bool bUpdateGraph = (dwCntrl & GETNEVENT_UPDATE_GRAPH) ? true : false;
	bool bUpdatePreview = (dwCntrl & GETNEVENT_UPDATE_PREVIEW) ? true : false;

	bool bUpdateTreeByGraph = (dwCntrl & GETNEVENT_UPDATE_GUI_TREE) ? true : false;
	bool bNeedUpdateGraphs = false;	
	bool bUpdateGrid = false;	
	if(bInit)
	{
		if(bUpdateGraph)
			pfnOnInitGraph(trGetN, previewGraph, previewData, bUpdateGrid);
		else if(bUpdatePreview)
			pfnOnInitPreview(trGetN, previewGraph, previewData, bUpdateGrid);
		else //if(!bUpdateGraph && !bUpdatePrew)
			pfnOnInitGrid(trGetN, previewGraph, previewData, bUpdateGrid);
		return bUpdateGrid;
	}
	// subsequent events, must be some sort of changes, either user change grid or user change graph
	// or just event to update the various graphs
	if(bUpdateTreeByGraph)
		pfnOnChange(trGetN, trNode, previewGraph, previewData, true, bNeedUpdateGraphs, bUpdateGrid);
	else if(bUpdatePreview)
		pfnOnUpdatePreview(trGetN, previewGraph, previewData);
	else if(bUpdateGraph)
		pfnOnUpdateGraph(trGetN, previewGraph, previewData);
	else
		pfnOnChange(trGetN, trNode, previewGraph, previewData, false, bNeedUpdateGraphs, bUpdateGrid);

	return bUpdateGrid; // false will indicate no need to update GetN dialog controls
}
*/
//------- end GETN_IMAGE_BOX_EVENTS_CLEAN

///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
static	DWORD	_convert_getn_event_grid_update_bits(DWORD dwUpdateGrid)
{
	DWORD	dw = 0;
	
	if ( UPDATE_GRID_SIMPLE & dwUpdateGrid )
		dw |= GETNGEVT_GRID_NEED_UPDATE;
	if ( UPDATE_GRID_RESET & dwUpdateGrid )
		dw |= GETNGEVT_GRID_NEED_RESET;
	
	return dw;
}
///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED

/// YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION
BOOL	xf_is_extended_event(int nEventId)
{
	// add new event ID's as neccesary
	switch( nEventId )
	{
	case GETNE_ON_DESTORY:
		return TRUE;
	}
	
	return FALSE;
}
/// end XFUNCTION_EVENT2_IMPLEMENTATION

//------- CPY 12/26/05 GETNGRAPH_BOX_TYPE_4
///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
/*
int xf_GetNPreviewDlg_event_handler(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg, 
PageBase& pgGraph, Datasheet& wksGraphData, PictureControl& pict,
PFNXF_G_ONINIT pfnOnInitGrid, PFNXF_G_ONINIT pfnOnInitGraph, 
PFNXF_G_ONCHANGE pfnOnChange, PFNXF_G_ONUPDATE pfnOnUpdateGraph, PFNXF_G_ONSETUP pfnOnDlgSetup, PFNXF_G_ONUPDATE pfnOnDestroy,
PFNXF_G_ONCUSTOMBUTTON pfnOnCustomButton)	///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
*/
int xf_GetNPreviewDlg_event_handler(TreeNode& trGetN, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg, 
PageBase& pgGraph, Datasheet& wksGraphData, PictureControl& pict,
PFNXF_G_ONINIT pfnOnInitGrid, PFNXF_G_ONINITGRAPH pfnOnInitGraph, 
PFNXF_G_ONCHANGE pfnOnChange, PFNXF_G_ONUPDATE pfnOnUpdateGraph, PFNXF_G_ONSETUP pfnOnDlgSetup, PFNXF_G_ONUPDATE pfnOnDestroy,
PFNXF_G_ONCUSTOMBUTTON pfnOnCustomButton)	///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
{
	//--- CPY 5/20/06 CHANGE_GETN_PREVIEW_TO_DATASHEET_FROM_WKSHEET
	if(GETNEVENT_ON_SETUP == (dwCntrl & GETNEVENT_ON_ANY))
	{
		DWORD dwOptions = 0;
		if(pfnOnDlgSetup)
		{
			vector<string> vsTitles;
			pfnOnDlgSetup(trGetN, theDlg, dwOptions, vsTitles);
			if(vsTitles.GetSize() > 0) // user has made changes
			{
				string str;
				str.SetTokens(vsTitles, '\n');
				const void *pp = (LPCSTR)str;
				LPARAM lParam = (LPARAM)pp;
				theDlg.SendMessage(WM_USER_ON_SET_TAB_TITLES, 0, lParam);
			}
		}		
		return dwOptions;
	}
	//---
	
	//------ CPY 10/24/06 XF_DLG_DESTROY_EVENT added pfnOnDestroy
	if(GETNEVENT_ON_DESTROY == (dwCntrl & GETNEVENT_ON_ANY) && pfnOnDestroy)
	{
		pfnOnDestroy(trGetN, pgGraph, wksGraphData, pict);
		return 0;
	}
	//------

	string strErrMsg;
	bool bFromTheme = ((dwCntrl & GETNEVENT_ON_ANY) == GETNEVENT_ON_THEME) ? true : false;
	bool bInit = ((dwCntrl & GETNEVENT_ON_ANY) == GETNEVENT_ON_INIT) ? true : false;
	bool bUpdateGraph = (dwCntrl & GETNEVENT_UPDATE_GRAPH) ? true : false;
	//bool bUpdatePreview = false;//(dwCntrl & GETNEVENT_UPDATE_PREVIEW) ? true : false;
	bool bChangeByControlsOnGraph = (dwCntrl & GETNEVENT_UPDATE_GUI_TREE) ? true : false;
	///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
	//bool bNeedUpdateGraphs = false;	
	DWORD dwUpdateGraphs = 0;	
	///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
	///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
	//bool bUpdateGrid = false;
	/////---Sim 06-30-2007 THEME_APPIED_SHOUND_DEFAULT_UPDATE_GRID
	//if ( bFromTheme )
		//bUpdateGrid = true;
	DWORD	dwUpdateGrid = 0;
	if ( bFromTheme )
		dwUpdateGrid = UPDATE_GRID_RESET;
	///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
	///---END THEME_APPIED_SHOUND_DEFAULT_UPDATE_GRID
	///Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY
	//bool bOKEnable = true;//#define GETNGEVT_OK_ENABLE			0x0004	//--- CPY 7/2/2006 QA70-8798 OK_BUTTON_DISABLED_BY_EVENT
	DWORD dwEnables = GETNGEVT_ENABLE_ALL_BUTTONS;

	int nRet = 0;
	if(bInit)
	{
		if(bUpdateGraph)
			///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
			//pfnOnInitGraph(trGetN, pgGraph, wksGraphData, pict, bUpdateGrid, dwEnables, strErrMsg);
			pfnOnInitGraph(trGetN, pgGraph, wksGraphData, pict, dwUpdateGrid, dwEnables, strErrMsg);
			///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		else //if(!bUpdateGraph && !bUpdatePrew)
			///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
			//pfnOnInitGrid(trGetN, pgGraph, wksGraphData, pict, dwUpdateGraphs, bUpdateGrid, dwEnables, strErrMsg);
			pfnOnInitGrid(trGetN, pgGraph, wksGraphData, pict, dwUpdateGraphs, dwUpdateGrid, dwEnables, strErrMsg);
			///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		//--- CPY 7/2/2006 QA70-8798 OK_BUTTON_DISABLED_BY_EVENT
		//return bUpdateGrid? GETNGEVT_GRID_NEED_UPDATE : 0;
		///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		//if(bUpdateGrid) nRet |= GETNGEVT_GRID_NEED_UPDATE;
		nRet |= _convert_getn_event_grid_update_bits(dwUpdateGrid);
		///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		//if(bOKEnable) nRet |= GETNGEVT_OK_ENABLE;
		///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		if ( UPDATE_GRAPH_CHANGED & dwUpdateGraphs )
			nRet |= GETNGEVT_GRAPH_NEED_UPDATE;
		if ( UPDATE_GRAPH_INVALID & dwUpdateGraphs )
			nRet |= GETNGEVT_GRAPH_ERROR;
		///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		nRet |= dwEnables;
		getn_dlg_check_show_msg(theDlg.GetSafeHwnd(), strErrMsg);//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS

		return nRet;
		//---
	}
	// subsequent events, must be some sort of changes, either user change grid or user change graph
	// or just event to update the various graphs
//	if(bUpdateTreeByGraph)
//		pfnOnChange(trGetN, trNode, previewGraph, previewData, true, bNeedUpdateGraphs, bUpdateGrid);
//	else if(bUpdatePreview)
//		pfnOnUpdatePreview(trGetN, previewGraph, previewData);
//	else 
	
	///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
	int nButton = 0;
	if(pfnOnCustomButton)
	{
		//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
		/*
		if(GETNEVENT_ON_CUSTOM_BUTTON1 == (dwCntrl & GETNEVENT_ON_ANY))
			nButton = CUSTOM_BUTTON1;
		if(GETNEVENT_ON_CUSTOM_BUTTON2 == (dwCntrl & GETNEVENT_ON_ANY))
			nButton = CUSTOM_BUTTON2;
		if(GETNEVENT_ON_CUSTOM_BUTTON3 == (dwCntrl & GETNEVENT_ON_ANY))
			nButton = CUSTOM_BUTTON3;
		*/
		///--------- CPY Iris 02/25/2007 v8.0570 FIX_CHANGE_GRID_BUT_ENTER_CUSTOMBUTTON_EVENT
		//nButton = GETNEVENT_TO_CUSTOM_BUTTON(dwCntrl);
		int nn = GETNEVENT_TO_CUSTOM_BUTTON(dwCntrl);
		if(nn >= 1 && nn <= CUSTOM_BUTTONS_COUNT)
			nButton = nn;	
		///---------end FIX_CHANGE_GRID_BUT_ENTER_CUSTOMBUTTON_EVENT
		//-------- end ADDING_CUSTOM_BUTTON4
	}
	if(bUpdateGraph)
		pfnOnUpdateGraph(trGetN, pgGraph, wksGraphData, pict);
	else if(nButton)
		///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		//pfnOnCustomButton(trGetN, nButton, pgGraph, wksGraphData, pict, bChangeByControlsOnGraph, bNeedUpdateGraphs, bUpdateGrid, dwEnables, strErrMsg);
		///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		//pfnOnCustomButton(trGetN, nButton, pgGraph, wksGraphData, pict, bChangeByControlsOnGraph, dwUpdateGraphs, bUpdateGrid, dwEnables, strErrMsg);
		pfnOnCustomButton(trGetN, nButton, pgGraph, wksGraphData, pict, bChangeByControlsOnGraph, dwUpdateGraphs, dwUpdateGrid, dwEnables, strErrMsg);
		///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
	///End GETN_PREVIEW_DLG_NEED_MORE_BTNS	
	else
		///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		//pfnOnChange(trGetN, trNode, pgGraph, wksGraphData, pict, bChangeByControlsOnGraph, bNeedUpdateGraphs, bUpdateGrid, dwEnables, strErrMsg);
		///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		//pfnOnChange(trGetN, trNode, pgGraph, wksGraphData, pict, bChangeByControlsOnGraph, dwUpdateGraphs, bUpdateGrid, dwEnables, strErrMsg);
		pfnOnChange(trGetN, trNode, pgGraph, wksGraphData, pict, bChangeByControlsOnGraph, dwUpdateGraphs, dwUpdateGrid, dwEnables, strErrMsg);
		///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE

	///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
	//if(bUpdateGrid)
		//nRet |= GETNGEVT_GRID_NEED_UPDATE;
	nRet |= _convert_getn_event_grid_update_bits(dwUpdateGrid);
	///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
	///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
	//if(bNeedUpdateGraphs)
		//nRet |= GETNGEVT_GRAPH_NEED_UPDATE;
	if ( UPDATE_GRAPH_CHANGED & dwUpdateGraphs )
		nRet |= GETNGEVT_GRAPH_NEED_UPDATE;
	if ( UPDATE_GRAPH_INVALID & dwUpdateGraphs )
		nRet |= GETNGEVT_GRAPH_ERROR;
	///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
	
	//if(bOKEnable) nRet |= GETNGEVT_OK_ENABLE;//--- CPY 7/2/2006 QA70-8798 OK_BUTTON_DISABLED_BY_EVENT
	nRet |= dwEnables;
	///End ENABLE_CUSTOM_BUTTONS_SEPARATELY
	if(!bUpdateGraph) //--- Iris 11/01/06 v8.0502d FIX_MSG_BOX_FAIL_TO_SHOW_IN_GETN_PREVW_DLG
	{
		getn_dlg_check_show_msg(theDlg.GetSafeHwnd(), strErrMsg);//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
	}

	return nRet;
}
//------- end GETNGRAPH_BOX_TYPE_4 


//------ CPY 8/23/2007 CHENEY_MOVED_SOME_FILES_BROKE_MDIM_XF
///Iris 4/01/05 CENTRALIZE_GET_SEL_STR_FROM_COMBOLIST
string    get_selected_string_from_combolist(TreeNode &trList)
{
	if(!trList)
		return "";
	
	string			  strNameList;
   	vector<string>    vsNames;   	
   	trList.GetAttribute(STR_COMBO_ATTRIB, strNameList);
   	strNameList.GetTokens(vsNames, '|');
   	
	int     nChoose = trList.nVal;
   	return nChoose < vsNames.GetSize()? vsNames[nChoose] : "";
}
////---- end CHENEY_MOVED_SOME_FILES_BROKE_MDIM_XF

//--- CPY 11/24/05 QA70-8363 COMBO_CHANGE_IN_EVENT_NOT_PROPER_UPDATED
//--- Sophy 4/9/08 SET_STRING_INSERT_CASE_SENSITIVE
//bool set_str_insert_combo(TreeNode& trReport, LPCSTR lpcszVal, LPCSTR lpcszValBefore,bool bFullMatch)
bool set_str_insert_combo(TreeNode& trReport, LPCSTR lpcszVal, LPCSTR lpcszValBefore,bool bFullMatch)
//--- end SET_STRING_INSERT_CASE_SENSITIVE
{
	trReport.strVal = lpcszVal;
	string strAttri;
	trReport.GetAttribute(STR_COMBO_ATTRIB, strAttri);
	//--- Sophy 4/9/08 SET_STRING_INSERT_CASE_SENSITIVE
	//insert_str_to_str_list(lpcszVal, strAttri, lpcszValBefore, STR_TOKEN_SEP);
	insert_str_to_str_list(lpcszVal, strAttri, lpcszValBefore, bFullMatch, STR_TOKEN_SEP);
	//--- end SET_STRING_INSERT_CASE_SENSITIVE
	trReport.SetAttribute(STR_COMBO_ATTRIB, strAttri);
	return true;
}

///Sophy 7/3/2008 INSERT_STR_INTO_TREENODE_COMBO_WITHOUT_UPDATE_ITS_VALUE
bool	insert_str_into_combo( TreeNode& trReport, LPCSTR lpcszVal, LPCSTR lpcszValBefore, bool bFullMatch )
{
	string strAttri;
	trReport.GetAttribute(STR_COMBO_ATTRIB, strAttri);
	insert_str_to_str_list(lpcszVal, strAttri, lpcszValBefore, bFullMatch, STR_TOKEN_SEP);
	trReport.SetAttribute(STR_COMBO_ATTRIB, strAttri);
	return true;
}
///end INSERT_STR_INTO_TREENODE_COMBO_WITHOUT_UPDATE_ITS_VALUE

///Sophy 4/9/2008 REMOVE_STR_FROM_COMBO
bool remove_str_from_combo(TreeNode& trReport,LPCSTR lpcszVal,bool bFullMatch)//default bFullMatch=true;
{
	string strAttri;
	trReport.GetAttribute(STR_COMBO_ATTRIB, strAttri);
	remove_str_from_str_list(lpcszVal,strAttri,bFullMatch);
	trReport.SetAttribute(STR_COMBO_ATTRIB, strAttri);
	return true;
}
///end REMOVE_STR_FROM_COMBO
DWORD GetNTreeChanges::GetMsg()
{
	getReconstructWpara();
	
	if(m_wParam == 0)
		;//out_str("No reconstruct message, wParam = 0");
	else
	{
		string str;
		if(m_wParam & GRID_CHANGE_VALUE)
			str+= "value ";
		if(m_wParam & GRID_CHANGE_COMBOSTR)
			str+= "combo-str ";
		if(m_wParam & GRID_CHANGE_TREE_STRUCTURE)
			str+= "tree-struct ";
		
		str += "Changed";
		//out_str(str);
	}
	return m_wParam;
}

void GetNTreeChanges::getReconstructWpara()
{
	int nNodeCount ;
	vector<int> vShows;
	vector<int> vEnables;
	vector<string> vsLabels; 
	vector<string> vsNewValue;
	vector<string> vsCombos; 
	
	nNodeCount = getGetNValues(vShows, vEnables,vsNewValue, vsCombos, vsLabels);

	m_wParam = is_same(vShows, m_vShows)? 0 : GRID_CHANGE_SHOW;

	if(!is_same(vEnables, m_vEnables))
		m_wParam |= GRID_CHANGE_ENABLE;
	
	int nChanges = tree_update_changes(m_tr, m_vsValue);
	if(nChanges > 0)
		m_wParam |= GRID_CHANGE_VALUE;
	
	//---- CPY v7.5785 12/19/03 QA70-5738 GETN_BOX_COMBO_CHANGE_NEEDED
	int nChanged = get_changed(vsCombos, m_vsCombos);
	if(nChanged >= 0)
	{
		// save index into tree for faster update later
		string strTemp = nChanged;
		m_tr.SetAttribute(STR_COMBO_CHANGED, strTemp);
		m_wParam |= GRID_CHANGE_COMBOSTR;
	}
	//---- end GETN_BOX_COMBO_CHANGE_NEEDED
	
	/// YuI 09/22/05 GETN_BUTTON_BRANCH_OPTION
	if( nNodeCount != m_nNodeCount )
		m_wParam |= GRID_CHANGE_TREE_STRUCTURE;
	
	nChanged = get_changed(vsLabels, m_vsLabels);
	if(nChanged >= 0)
		m_wParam |= GRID_CHANGE_TREE_STRUCTURE;
	/// end GETN_BUTTON_BRANCH_OPTION
	//return m_wParam;
}
int GetNTreeChanges::getGetNValues( vector<int> &vShows, vector<int> &vEnables,vector<string> &vValues,vector<string> &vsCombos,  vector<string> &vsLabels)
{
	// we need to know if event handler has changed any .Show 
	tree_get_shows(m_tr, vShows);
	tree_get_enables(m_tr, vEnables);
	
	///Joseph 06/12/07 v8.0639b  FIX_BUG_ON_CHANGE_DEFAULT_DATA
	//bug: in XFbuilder after we changed the the variable default data, the Data Field values disappered.
	//reason: in function tree_get_values(m_tr, vValues), the treenode  including the root node. 
	//        but in function tree_update_changes(tr, m_vsValue), the treeNode not including the root node.
	//        so they don't match in the function tree_update_changes.
	//We fix this bug just by not including the root node value in function tree_get_values;
	
	//tree_get_values(m_tr, vValues);//CPY 5/30/03 QA70-4577 EVENT_HANDLER_NEED_DIALOG_AND_VALUE_UPDATE
	tree_get_values(m_tr, vValues, true);
	///End FIX_BUG_ON_CHANGE_DEFAULT_DATA
	
	tree_get_attributes(m_tr,vsCombos, STR_COMBO_ATTRIB); //---- CPY v7.5785 12/19/03 QA70-5738 GETN_BOX_COMBO_CHANGE_NEEDED

	tree_get_attributes(m_tr, vsLabels, STR_LABEL_ATTRIB); 
	
	return tree_count_items_by_attribute(m_tr);
}
//-----------------------------------------------
//-----------------------------------------------
//-----------------------------------------------

//virtual
void TreeEditControl::OnAfterEdit(int nRow, int nCol)
{
	_DBINT("OnAfterEdit, nRow = ", nRow)
	if(!IsReady())	///DG 4/2/05
		return;
	
	//Profiler jj;
	GridListControl::OnAfterEdit(nRow, nCol);//m_bMouseDownToggleCheck = false;//---- CPY 5/20/03 CHECK_BOX_CLICK_OUTSIDE_CHECK_TO_TOGGLE
	bool	bCheckCellSizeChange = false; // only certain cell type need checking CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
	//TreeNode trNode = get_tree_node(nRow);	///Danice 9/15/04 SUPPORT_GRID_VIEW
	GetNTreeChanges gnMsg(m_trEdit);		///Frank 11/16/05 QA70-8293 RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
	TreeNode trNode = get_tree_node(nRow, nCol);
	if(trNode)
	{
		int nVal;
		ODWP	dwTemp = GetCell(flexcpData, nRow, nCol);
		//------- CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX
		//	/// YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL
		//	//	string strOldVal = strOldVal = trNode.strVal;
		//	string strOldVal;
		//	if( trNode.ID != TRGP_DATA_RANGE ) 
		//		strOldVal = trNode.strVal;
		//	/// end NEW_DATA_SELECTOR_TOOL
		string strOldVal = getValue(trNode);
		//--------
		_DBINT("OnAfterEdit, dwTemp = ", dwTemp);
		if(dwTemp)
		{
			EditorManager	trNodeManager;
			BOOL bModified;
			///----- YuI 01/14/04 v7.5801 QA70-5799 SLIDER_CONTROL_TO_GETNBOX
			/*
			if(m_dwEditor)
				bModified = trNodeManager.AfterEdit(dwTemp);
			else if(TRGP_RANGE == trNode.ID)
			{
				string strCellText = m_flx.Cell(flexcpText, nRow, nCol);
				bModified = trNodeManager.AfterEdit(dwTemp, AFTER_EDIT_USE_STR, strCellText);
				
				string	strNew = trNodeManager.GetText(dwTemp);
				m_flx.Cell(flexcpText, nRow, nCol) = strNew;
				bCheckCellSizeChange = true;//CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
			}
			else // no editor, then possible to be using grid's combo
			{
				bModified = trNodeManager.AfterEdit(dwTemp, m_flx.ComboIndex);
				bCheckCellSizeChange = true;//CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
			}
			*/
			switch( trNode.ID )
			{
			case TRGP_SLIDEREDIT:
			case TRGP_SLIDER:
			//case TRGP_INTERACTIVE:///----- YuI 1/26/04 v7.5807 QA70-5797 INTERACTIVE_TEXT_PROPERTY_IMPLEMENTATION
				{
					bModified = trNodeManager.AfterEdit(dwTemp);
					string	strNew = trNodeManager.GetText(dwTemp);
					SetCell(strNew, flexcpText, nRow, nCol);
				}
				break;
				
#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER		
			case TRGP_RANGE:
				{
					string strCellText = GetCell(flexcpText, nRow, nCol);
					bModified = trNodeManager.AfterEdit(dwTemp, AFTER_EDIT_USE_STR, strCellText);
					string	strNew = trNodeManager.GetText(dwTemp);
					SetCell(strNew, flexcpText, nRow, nCol);
					bCheckCellSizeChange = true;
				}
				break;
			case TRGP_INTERACTIVE:
			case TRGP_MULTILINE_TEXT:
			case ONODETYPE_CODE_EDITOR: /// TD 2-16-04 QA70-7368 CODE_EDITOR_IN_DIALOG
				{
					bModified = trNodeManager.AfterEdit(dwTemp);
					string	strNew;
					if( m_dwEditor )
						strNew = trNodeManager.GetEditorStr(m_dwEditor);
					else
					/// YuI 07/21/06 CRASH_IN_F10_DIALOG_FOR_XYRANGE
					//	strNew = trNodeManager.GetText(dwTemp);
					strNew = GetCell(flexcpText, nRow, nCol);
					/// end CRASH_IN_F10_DIALOG_FOR_XYRANGE
					
					SetCell(strNew, flexcpText, nRow, nCol);
					trNode.strVal = strNew;
					bCheckCellSizeChange = bModified; /// YuI 10/19/05 INTERACTIVE_CONTOROL_NEED_UPDATE_RESIZE_GETN_GRID
				
					/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
					// we need to update parent if this node is part of XYRange or XYZRange
					if( TRGP_INTERACTIVE == trNode.ID )
					{
						TreeNode trParent = trNode.Parent();
						if( TRGP_XY_DATA_RANGE == trParent.ID || TRGP_DATA_RANGE == trParent.ID 
							|| TRGP_XYZ_DATA_RANGE == trParent.ID || TRGP_XY_COMPLEX_DATA_RANGE == trParent.ID )			
						{
							int nParentRow = nRow - 1;
							TreeNode trTemp = trNode;
							while( trTemp = trTemp.PrevNode )
								nParentRow--;
							
							SetInputDataBranchValue(nParentRow, nCol, trParent);
						}
					}
					/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
				}
				break;
			
			
			/// YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL
			case TRGP_XY_COMPLEX_DATA_RANGE: /// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
			case TRGP_XYZ_DATA_RANGE: /// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
			case TRGP_XY_DATA_RANGE: /// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
			case TRGP_DATA_RANGE:
				//----------- CPY 6/16/04 QA70-6294 OC_INPUT_DATA_NODE_CLEANUP
				/*
				{
					TreeNode trDataRange;
					trNodeManager.GetTree(dwTemp, trDataRange);
					DataRange dr;
					dr.Create(trDataRange);
					m_flx.Cell(flexcpText, nRow, nCol) = dr.GetDescription();
					dr.Destroy();
				}
				*/	
				/// YuI 07/21/06 CRASH_IN_F10_DIALOG_FOR_XYRANGE
				//	SetInputDataBranchValue(nRow, nCol, trNode);
				SetInputDataBranchValue(nRow, nCol, trNode, FALSE);
				/// end CRASH_IN_F10_DIALOG_FOR_XYRANGE
				//----------- end CPY 6/16/04 QA70-6294 OC_INPUT_DATA_NODE_CLEANUP
				bCheckCellSizeChange = true; /// YuI 10/19/05 INTERACTIVE_CONTOROL_NEED_UPDATE_RESIZE_GETN_GRID
				break;
			/// end NEW_DATA_SELECTOR_TOOL
			//------ end QA70-5890
#endif //#ifdef _INTERACTIVE_CNTRL_IN_FLEX_GRID //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER		
			
			//--- CPY 8/26/05 ADD_HELP_TO_XF
			case TRGP_EXTERNAL_EDIT:
				bModified = false;
				break;
			//---
			
			default:
				if(m_dwEditor)
					bModified = trNodeManager.AfterEdit(dwTemp);
				else
				{
					bModified = trNodeManager.AfterEdit(dwTemp, m_flx.ComboIndex);
					bCheckCellSizeChange = true;
				}
			}
			///----- end QA70-5799
			_DBINT("After Edit returns ", bModified)
			setValue(trNode, trNodeManager, dwTemp, bModified);
		}
		else
		{
			switch(trNode.ID)
			{
			//------ CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX
			//case TRGP_CHECK:
			//	nVal = m_flx.Cell(flexcpChecked, nRow, nCol);
			//	trNode.nVal = flexUnchecked == nVal? 0:1;
			case TRGP_BRANCH:
			case TRGP_CHECK:
				nVal = GetCell(flexcpChecked, nRow, nCol);
				_DBINT("--------------- TreeEditControl::OnAfterEdit before setCheckBoxValue nVal = ", nVal);
				setCheckBoxValue(trNode, flexUnchecked == nVal? 0:1);
				break;
			
			//--- CPY 8/26/05 ADD_HELP_TO_XF
			case TRGP_EXTERNAL_EDIT:
				out_str("tree node is external edit, will add later");
				bCheckCellSizeChange = false;//CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
				break;
			//---
			/// YuI 11/20/06
			/*
			//---- Iris 10/25/06 GET_RUNTIME_ERR_AFTER_EDIT_DATA_CONTROL_FOR_XYRANGE, just a temporary solution, will email to yuri
			case TRGP_XY_DATA_RANGE:
				EditorManager	trNodeManager;
				string strLabel = m_flx.Cell(flexcpText, nRow, nCol);
				trNodeManager.SetCompositeRangeString(trNode, strLabel);							
				break;
			//----
			*/
			
			case TRGP_XY_COMPLEX_DATA_RANGE:
			case TRGP_XYZ_DATA_RANGE:
			case TRGP_XY_DATA_RANGE:
			case TRGP_DATA_RANGE:
				{
				   	SetInputDataBranchValue(nRow, nCol, trNode, FALSE);
					bCheckCellSizeChange = true;
				}
				break;
				
			default:
				/// EJP 12-16-2004 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
				///trNode.strVal = m_flx.Cell(flexcpText, nRow, nCol);
				string strVal = GetCell(flexcpText, nRow, nCol);
				check_translate(trNode, strVal);
				trNode.strVal = strVal;
				/// end ASCIMP_OPTIONS_USE_GETNBOX
				bCheckCellSizeChange = true;//CPY 8/24/03 v7.5674 QA70-5061 ADD_DISPLAY_OPTIONS
				break;
			}
		}
		
		// data changed, OK button should be enabled, which might be disabled by
		// apply button
		
		/// YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL
		/*
		string strNewVal = trNode.strVal;
		if(strNewVal.Compare(strOldVal) != 0)
		{
			invokeEventHandler(trNode, nRow, bCheckCellSizeChange, strOldVal);
			PostDlgMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, nRow);///Danice 3/9/04 v8.0834 ADD_MORE_MESSAGE
		}
		*/
		//---- CPY 4/25/05 XY_DATA_RANGE_INTERACTIVE_CONTORL_CHANGE_NOTIFICATION
		/*
		if( trNode.ID != TRGP_DATA_RANGE 
			&& trNode.ID != TRGP_XY_DATA_RANGE /// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
			)
		{
			//------ CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX
			//string strNewVal = trNode.strVal;
			bool bIsBranchCheckBox;
			string strNewVal = getValue(trNode, &bIsBranchCheckBox);
			//------

			/// ML 4/15/2005 XVAR_DATA_CHANGE_ATT
			//if(strNewVal.Compare(strOldVal) != 0)
			bool		bChangeEv = tree_changed_data(trNode, 0) || strNewVal.Compare(strOldVal) != 0;
			if (bChangeEv)
			/// end XVAR_DATA_CHANGE_ATT
			{
				invokeEventHandler(trNode, nRow, bCheckCellSizeChange, strOldVal);
				//PostDlgMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, nRow);///Danice 3/9/04 v8.0834 ADD_MORE_MESSAGE
				PostDlgMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, nRow, nCol);	///Danice 9/17/04 SUPPORT_GRID_VIEW
				
				if(bIsBranchCheckBox) //------ CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX
					//closeBranch(nRow, trNode);	///BRANCH_CHECKBOX_IMPROVEMENT
					updateBranchUseShow(trNode, nRow, atoi(strNewVal));
			}
		}
		else
		{
			// for now always assume data range has changed by editing
			invokeEventHandler(trNode, nRow, bCheckCellSizeChange, strOldVal);
			//PostDlgMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, nRow);///Danice 3/9/04 v8.0834 ADD_MORE_MESSAGE
			PostDlgMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, nRow, nCol);	///Danice 9/17/04 SUPPORT_GRID_VIEW
		}
		/// end NEW_DATA_SELECTOR_TOOL
		*/
		bool bIsBranchCheckBox;
		string strNewVal = getValue(trNode, &bIsBranchCheckBox);
		bool		bChangeEv = tree_changed_data(trNode, 0) || isValueChanged(trNode, strNewVal, strOldVal);//strNewVal.Compare(strOldVal) != 0;
		/// TD 5-24-07 CHANGING_DATARANGE_DEFAULT_VAL_FROM_GRID
		//if (bChangeEv)
		if (bChangeEv || trNode.GetNodeCount() > 0 )
		/// end CHANGING_DATARANGE_DEFAULT_VAL_FROM_GRID
		{
			///-----Frank 11/16/05 QA70-8293 RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
			//bool bPostedReconstructMsg = invokeEventHandler(trNode, nRow, nCol, bCheckCellSizeChange, strOldVal);
			// enum {HANDLER_MSG_NOT_POSTED, HANDLER_MSG_POSTED, HANDLER_NOT_CALLED};
			int nPostedReconstructMsg = invokeEventHandler(trNode, nRow, nCol, bCheckCellSizeChange, strOldVal);

			tree_node_changed(trNode, true, strOldVal);
			///-----End RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
			
			//PostDlgMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, nRow, nCol);	///Danice 9/17/04 SUPPORT_GRID_VIEW
			SentDlgMessage(WM_USER_TREEEDITOR_VALUE_CHANGE, nRow, nCol);	///Frank 11/16/05 QA70-8293 RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC

			if(bIsBranchCheckBox) //------ CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX
				updateBranchUseShow(trNode, nRow, atoi(strNewVal));
			
			//---- CPY 10/26/05 INTERACTIVE_CONTOROL_NEED_UPDATE_RESIZE_GETN_GRID
			// the following still does not work, will need to find problem some place else
			//printf("after invokeEventHandler, bPostedReconstructMsg(%d), bCheckCellSizeChange(%d)\n", bPostedReconstructMsg, bCheckCellSizeChange);
			//if(!bPostedReconstructMsg && bCheckCellSizeChange)
			///-----Frank 11/16/05 QA70-8293 RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
			//if(nPostedReconstructMsg != HANDLER_MSG_POSTED && bCheckCellSizeChange)
				//PostDlgMessage(WM_USER_RECONSTRUCT, GRID_CHANGE_SIZE | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE);
			//LT_execute("sec -p 0.05");	//force not to update when deleting variables, but it's time-consuming 
			DWORD dw = gnMsg.GetMsg();
			tree_node_changed(trNode, true);
			dw |= GRID_CHANGE_SIZE | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE;
			/// TD 5-24-07 CHANGING_DATARANGE_DEFAULT_VAL_FROM_GRID
			//----------- CPY 6/4/2007 TREE_NODE_CHANGE_VAL_LEAD_TO_GRID_MESSED_UP
			// we do not need GRID_CHANGE_TREE_STRUCTURE|GRID_CHANGE_SHOW anymore as this is used only for grid view
			//if(trNode.GetNodeCount() > 0 )
			if(1)
			//-----------
			{
				dw &= ~(GRID_CHANGE_TREE_STRUCTURE|GRID_CHANGE_SHOW); //It may look as if structure changed but it's not, value itself has a structure-- which also changes shows
			}
			/// end CHANGING_DATARANGE_DEFAULT_VAL_FROM_GRID
			//printf("after invokeEventHandler, bPostedReconstructMsg(%d), bCheckCellSizeChange(%d)\n", nPostedReconstructMsg, bCheckCellSizeChange);
			if(nPostedReconstructMsg != HANDLER_MSG_POSTED && bCheckCellSizeChange)
				PostDlgMessage(WM_USER_RECONSTRUCT, dw);
			///-----End5 RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
				
			//----
				
		}
		//--------- end XY_DATA_RANGE_INTERACTIVE_CONTORL_CHANGE_NOTIFICATION
		
		///Danice MARK_EMPTY_GETN_STR && MARK_EMPTY_GETN_STR_CENTRALIZE
		bool bIsWaitInput;
		if(isCheckWaitInput(trNode, nRow, bIsWaitInput))
			setWaitInputRowLabel(trNode, nRow, bIsWaitInput);
		///end MARK_EMPTY_GETN_STR && MARK_EMPTY_GETN_STR_CENTRALIZE
	}
	//-- CPY 4/12/04 SLIDER_TRACK_NOTIFICATION
	m_nEditRow = -1;// to indicate not in editing
	//--
}


/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
// codes specific to DynaDlg

//------- CPY 6/10/2006 QA70-8428 XF_AUTO_GETN_NEED_FILE_PATH_SUPPORT

/// SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
/*
//----- CPY 8/11/06 IMAGE_OPEN_DLG_MOVED_TO_GETN
typedef bool (*PFN_IMG_DLG) (HWND hwndParent, string& szFileName, LPCSTR lpcszTitle, bool bOpen);
typedef bool (*PFN_IMGS_DLG) (HWND hwndParent, StringArray& saFileName, LPCSTR lpcszTitle, bool bOpen, bool bMultiSel);

int get_open_box_by_file_group(string& strFile, LPCSTR lpcszGroup, LPCSTR lpcszTitle, BOOL bMultiFiles)
{
	//---- CPY 10/2/06 FILE_DIALOG_SHOW_ASCII_FOR_ALL_IMPORT
	string strTitle = lpcszTitle; 
	if(strTitle.IsEmpty()) 
		strTitle = lpcszGroup;	// we may have a better file group label somewhere, but this is at least better then "Multiple ASCII"
	//----
	if(lstrcmpi(lpcszGroup, "image") == 0)
	{
		/// Iris 8/28/06 SUPPORT_GRAPHS_FILES_CONTRL
		if(bMultiFiles)
		{
			Function fn = Project.FindFunction("image_files_dlg", "image_utils");
			PFN_IMGS_DLG pfn = fn;
			if( pfn )
			{
				StringArray saFiles;
				bool bRet = pfn(GetWindow(), saFiles, strTitle, true, true);
				if(bRet)
				{
					//--- Iris 8/31/06
					//file_name_array_to_str(strFile, saFiles);
					strFile = str_combine(saFiles, "\r\n");
					//--- 
					return 1;
				}
			}
		}
		///end SUPPORT_GRAPHS_FILES_CONTRL
		else
		{
			Function fn = Project.FindFunction("image_file_dlg", "image_utils");
			PFN_IMG_DLG pfn = fn;
			if( pfn )
			{
				bool bRet = pfn(GetWindow(), strFile, strTitle, true);
				if(bRet)
					return 1;
			}
		}
		return 0;
	}
	init_fdlog_with_group_name(lpcszGroup, NULL, NULL, strTitle);
	
	int nType = (bMultiFiles ? FDLOG_TYPE_MULTI_OPEN : FDLOG_TYPE_OPEN_SINGLE);
	StringArray saFileNames;
	if( GetFDLogBox(saFileNames, nType) )
	{
		int nFiles = saFileNames.GetSize();
		if( nFiles > 1 )
			//--- Iris 8/31/06
			//file_name_array_to_str(strFile, saFileNames);
			strFile = str_combine(saFileNames, "\r\n");
			//--- 
		else
			strFile = saFileNames[0];
		return nFiles;
	}
	return 0;
}
*/
/// end XF_THEME_BOOK_AND_SHEET
//----- end IMAGE_OPEN_DLG_MOVED_TO_GETN

//-------- CPY 8/22/06 QA80-7729 GRAPH_BRWOSER_BUTTON_IN_GETN
//BOOL ProjectBrowseGraph(HWND hWndParent, string& strGraphName, LPCSTR lpcszStartPEpath, bool bShowFolders)
///Jasmine 10/26/06 KEEP_DLG_MODEL
//static string _browse_get_graph(LPCSTR lpcszGraphs, bool bMutiplePages = false, LPCSTR lpcszExcludePage = NULL, LPCSTR lpcszPEpathToStart = NULL)
//static string _browse_get_graph(HWND hWndParent, LPCSTR lpcszGraphs, bool bMutiplePages = false, LPCSTR lpcszExcludePage = NULL, LPCSTR lpcszPEpathToStart = NULL, bool bIncLongName = false, bool bEnableEmbed = true)		///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
//static string _browse_get_graph(HWND hWndParent, LPCSTR lpcszGraphs, bool bMutiplePages = false, LPCSTR lpcszPEpathToStart = NULL, bool bIncLongName = false, bool bEnableEmbed = true)		///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
//static string _browse_get_graph(HWND hWndParent, LPCSTR lpcszGraphs, LPCSTR lpcszPEpathToStart = NULL, bool bIncLongName = false, DWORD dwCtrl = ENABLE_EMBEDED, int nPageType = EXIST_GRAPH)
static string _browse_get_graph(HWND hWndParent, LPCSTR lpcszGraphs, LPCSTR lpcszPEpathToStart = NULL, bool bIncLongName = false, DWORD dwCtrl = ENABLE_EMBEDED, int nPageType = EXIST_GRAPH, LPCSTR lpcszFilterFuncName = NULL)
///end FILTER_GRAPH_FUNCTION_SUPPORT
//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
{
	/// Iris 8/23/06 QA80-7729 GRAPH_BRWOSER_BUTTON_IN_GETN
	//string str;
	//Function fn = Project.FindFunction("ProjectBrowseGraph", "ProjectBrowser");
	//PFN_IMG_DLG pfn = fn; // reuse this as it happens to be the same
	//if( pfn )
	//{
		//bool bRet = pfn(GetWindow(), str, lpcszPEpathToStart, true);
		//if(bRet)
			//return str;
	//}
	//str.Empty();
	//return str;
	string 	strGraphs(lpcszGraphs);
	
	strGraphs = get_page_short_name_from_page_list(strGraphs, STR_PAGE_LIST_SEPARATOR, -1);/// Iris 12/18/2006 v8.0527 SHOW_LONG_NAME_ON_PAGES_BOX
	
	//open_page_preview_list_dlg(GetWindow(), strGraphs, bMutiplePages, lpcszPEpathToStart, true, lpcszExcludePage);
	//open_page_preview_list_dlg(hWndParent, strGraphs, bMutiplePages, lpcszPEpathToStart, true, lpcszExcludePage, bEnableEmbed);			///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
	//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
	//open_page_preview_list_dlg(hWndParent, strGraphs, bMutiplePages, lpcszPEpathToStart, true, bEnableEmbed);				///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
	dwCtrl |= SHOW_FOLDERS;
	//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
	//open_page_preview_list_dlg(hWndParent, strGraphs, lpcszPEpathToStart, dwCtrl);
	/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
	//open_page_preview_list_dlg(hWndParent, strGraphs, lpcszPEpathToStart, dwCtrl, nPageType);
	open_page_preview_list_dlg(hWndParent, strGraphs, lpcszPEpathToStart, dwCtrl, nPageType, lpcszFilterFuncName);
	///end FILTER_GRAPH_FUNCTION_SUPPORT
	//-------End CONTROL_BROWSE_PAGE_TYPE
	//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
	/// Iris 12/18/2006 v8.0527 SHOW_LONG_NAME_ON_PAGES_BOX
	if(bIncLongName)
	{
		vector<string> vsPages;
		strGraphs.GetTokens(vsPages, STR_PAGE_LIST_SEPARATOR);
		for(int nn=0; nn<vsPages.GetSize(); nn++)
		{
			string 	str = vsPages[nn];
			Page 	pg(str);
			///---Sim 10-12-2007 QA70-10520 CENTRALIZE_MAKE_PAGE_SHORT_LONG_NAME
			//str += " - " + pg.GetLongName();
			str = get_page_short_long_name(pg);
			///---END QA70-10520 CENTRALIZE_MAKE_PAGE_SHORT_LONG_NAME
			vsPages[nn] = str;
		}
		
		strGraphs.SetTokens(vsPages, STR_PAGE_LIST_SEPARATOR);		
	}
	///end SHOW_LONG_NAME_ON_PAGES_BOX
	
	return strGraphs;
	
}
//---------

// return true if is Group path case
static bool _parse_node_combo_for_file(TreeNode& node, vector<string>& saTypes, string& strGroup, string& strTitle, const string& strMarker)
{
	string strCombo;
	string strExtList;
	if(node.GetAttribute(STR_COMBO_ATTRIB, strCombo) && strCombo.GetLength() > strMarker.GetLength())
	{
		// Hong 02/09/07 SUPPORT_KEY_STRING_NOT_SENSITIVE
		//int nMrkerPos = strCombo.Find(strMarker);
		string strTemp = strCombo;
		strTemp.MakeUpper();
		int nMrkerPos = strTemp.Find(strMarker);
		/// end SUPPORT_KEY_STRING_NOT_SENSITIVE
		int nSep = strCombo.Find(':', nMrkerPos);
		/// Iris 07/04/2007 v8.0655 INCORRECT_TYPE_LIST_FOR_ALL_FILES_TYPE_IN_EXP_ASC_XF		
		// for "...Save|:|c:\c\vc32\.test.txt", in old codes, nEnd will be -1, this is not correct.
		/*
		/// TD 6-18-07 QA80-9933 EDITABLE_COMBO_WITH_BROWSE_BUTTON
		int nEnd = strCombo.Find("|:|", nSep);
		/// end EDITABLE_COMBO_WITH_BROWSE_BUTTON		
		*/
		int nEnd = strCombo.Find("|:|", nMrkerPos);
		///end INCORRECT_TYPE_LIST_FOR_ALL_FILES_TYPE_IN_EXP_ASC_XF
		if(nSep > 0)
		{
			/// TD 6-18-07 QA80-9933 EDITABLE_COMBO_WITH_BROWSE_BUTTON
			/// Iris 07/04/2007 v8.0655 INCORRECT_TYPE_LIST_FOR_ALL_FILES_TYPE_IN_EXP_ASC_XF
			/*
			if(nEnd > nSep)
				strExtList = strCombo.Mid(nSep+1, nEnd - nSep-1);
			*/
			if(nEnd > 0)
			{
				if(nEnd > nSep)
					strExtList = strCombo.Mid(nSep+1, nEnd - nSep-1);
				else
					//do nothing
			}
			///end INCORRECT_TYPE_LIST_FOR_ALL_FILES_TYPE_IN_EXP_ASC_XF
			else
			/// end EDITABLE_COMBO_WITH_BROWSE_BUTTON
			strExtList = strCombo.Mid(nSep+1);
			strExtList.TrimLeft();
		}
	}
	if(strExtList.IsEmpty())
		saTypes.Add("[All Files *.*] *.*");
	//---- CPY 8/11/06 IMAGE_OPEN_DLG_MOVED_TO_GETN
	else if(strExtList[0] != '[') // user had specified a file group name instead
	{
		strGroup = strExtList;
		_get_file_types(strGroup, saTypes); // Hong 01/22/07 FIX_SAVE_DIALOG_FAIL_WITH_GROUP_TYPE
		int nPos = strExtList.Find(' ');// group tilte
		if(nPos > 0)
		{
			strGroup = strExtList.Left(nPos);
			strTitle = strExtList.Mid(nPos+1);strTitle.TrimLeft();
		}
		return true;
		//int nFiles = get_open_box_by_file_group(strFileNameNew, strGroup, strTitle, false);
		//bDlgDone = true;
	}
	//---- end IMAGE_OPEN_DLG_MOVED_TO_GETN
	else
		strExtList.GetTokens(saTypes, '|');

	return false;
}

/// Hong 01/22/07 FIX_SAVE_DIALOG_FAIL_WITH_GROUP_TYPE
static bool _get_file_types(string strGroup, StringArray& saTypes)
{
	string strScript;
	strScript = "FDlog.UseGroup(" + strGroup + ");";
	LT_execute(strScript);	

	int nTypeCount = LabTalk.FDlog.NumTypes;
	string str;
	char szType[MAXFULLPATH];
	for( int nType = 1; nType <= nTypeCount; nType++ )
	{
		str.Format("FDlog.Type%d$", nType);
		if( LT_get_str(str, szType, MAXFULLPATH) )
			saTypes.Add(szType);
	}
	return true;
}
/// end FIX_SAVE_DIALOG_FAIL_WITH_GROUP_TYPE

//#define FILE_BROWSER   "...File:"    
//only assumption is combo string is in the form of "buttonText..File:ext list
///Jasmine 10/26/06 KEEP_DLG_MODEL
//BOOL	DynaDlg_OnGenericControlMsg(TreeNode &node, uint nCode)
///------ Folger 06/15/09 QA80-13771 GRAPH_BROWSER_SUPPORT_GENERAL_CUSTOMIZATION_BY_SPECIFIC_FILTER_FUNCTION
//BOOL	DynaDlg_OnGenericControlMsg(TreeNode &node, uint nCode, HWND hWndParent)// = NULL
BOOL	DynaDlg_OnGenericControlMsg(TreeNode &node, uint nCode, HWND hWndParent, LPCSTR lpcsFilterFuncName/* = NULL*/)// = NULL
///------ End GRAPH_BROWSER_SUPPORT_GENERAL_CUSTOMIZATION_BY_SPECIFIC_FILTER_FUNCTION
{
	string strFileName = node.strVal;
	string strFileNameNew;
	StringArray saTypes;
	string strGroup, strTitle;
	if(DGC_BUTTON_PATH == nCode)
	{
		///Jasmine 04/20/07 QA70-9655 USE_NEW_BROWSE_FOR_FOLDER_DLG
		string strNewVal;// = BrowseGetPath(node.strVal);
		char szNewPath[MAX_PATH];
		string strOldVal = node.strVal;
		
		strOldVal = cvt_predefined_path_to_real_path(strOldVal);/// Iris 07/03/2007 v8.0654 USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL
		/// Hong 07/13/07 v8.0659 NEED_COMMON_DESCIPTION
		//if(IDOK == browse_get_path_dialog(hWndParent, szNewPath, strOldVal, _L("Select the folder for the exported graph(s)."), true))		
		if(IDOK == browse_get_path_dialog(hWndParent, szNewPath, strOldVal, _L("Please select desired folder")))		
		/// end NEED_COMMON_DESCIPTION
			strNewVal = szNewPath;
		///End USE_NEW_BROWSE_FOR_FOLDER_DLG
		if(!strNewVal.IsEmpty() && strNewVal.CompareNoCase(node.strVal))
		{
			node.strVal = strNewVal;
			return TRUE;
		}
		return FALSE;
	}
	//---- CPY 8/17/06 QA70-8428 ADD_SAVE_AS_OPTION
	else if(DGC_BUTTON_SAVEAS == nCode)
	{
		//string strMarker = "..Save";
		string strMarker = "..SAVE"; // Hong 02/09/07 SUPPORT_KEY_STRING_NOT_SENSITIVE
		
		string strName = strFileName; ///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
		///Jasmine 10/13/06 NEW_SAVE_AS_DIALOG
		string strFullName;
		//--- Iris 10/26/06 CORRECT_NEW_SAVE_AS_DLG_LOGIC
		//bool bNewSaveAsDB = node.GetAttribute(STR_FILENAME_ATTRIB, strFullName);
		//if(bNewSaveAsDB)
		//	strFileName = strFullName;
		if(node.GetAttribute(STR_FILENAME_ATTRIB, strFullName) && !strFullName.IsEmpty())
			///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
			//strFileName = strFullName;
			strName = strFullName;
			///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
		int 	nOptions = 0;
		node.GetAttribute(STR_DLG_OPTIONS_ATTRIB, nOptions);				
		//--- 
		///End NEW_SAVE_AS_DIALOG
		
		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
		//strFileName = cvt_predefined_path_to_real_path(strFileName);/// Iris 07/03/2007 v8.0654 USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL
		strName = cvt_predefined_path_to_real_path(strName);/// Iris 07/03/2007 v8.0654 USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
		
		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
		//string strFilePath = GetFilePath(strFileName);
		string strFilePath = GetFilePath(strName);
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		string strFileBrowserPath;
		if ( node.GetAttribute(STR_BROWSER_COMBO_FILE_PATH, strFileBrowserPath) )
			strFilePath = cvt_predefined_path_to_real_path(strFileBrowserPath);
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
		//string strName = GetFileName(strFileName);
		strName = GetFileName(strName);
		if ( !is_str_valid_for_filename(strName) ) // maybe like <long name>, <short name>, in Export Graph
			strName.Empty();
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
		_parse_node_combo_for_file(node, saTypes, strGroup, strTitle, strMarker);
		//------ Iris 10/26/06 CORRECT_NEW_SAVE_AS_DLG_LOGIC
		/*
		///Jasmine 10/13/06 NEW_SAVE_AS_DIALOG
		//strFileNameNew = GetSaveAsBox(saTypes, strFilePath, strFileName);if(bNewSaveAsDB)
		if(bNewSaveAsDB)
		{	
			strFileNameNew = strFullName;
			if(okutil_FileDialog(&strName, true, &saTypes, strFilePath, FDLG_SUPPRESS_WARNING_SAVE_TO_EXISTING|FDLG_FILENAME_BOX_READ_ONLY, NULL, "Save As"))
				strFileNameNew = strName;//use the old name
			node.SetAttribute(STR_FILENAME_ATTRIB, strFileNameNew);
			strFileNameNew = GetFilePath(strFileNameNew);
		}
		else
			strFileNameNew = GetSaveAsBox(saTypes, strFilePath, strFileName);
		///End NEW_SAVE_AS_DIALOG
		*/
		if(okutil_FileDialog(&strName, true, &saTypes, strFilePath, nOptions, NULL, "Save As"))
			strFileNameNew = strName;
		
		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		int nWithoutExt = 0;
		if ( node.GetAttribute(STR_BROWSER_FILE_NAME_WITHOUT_EXT, nWithoutExt) && nWithoutExt )
		{
			string strNameTemp, strExtTemp;
			if ( separate_file_name_ext(strFileNameNew, &strNameTemp, &strExtTemp) )
			{
					strFileNameNew = strNameTemp;
			}
		}		
		
		//clear code, cancel dialog means do noting
		////----Jake 04/16/07 DEBUG_FOR_SAVE_AS_DIALOG
		//else strFileNameNew = strFullName;
		////----end DEBUG_FOR_SAVE_AS_DIALOG
		if ( !strFileNameNew.IsEmpty() )
		{
			
			if ( node.GetAttribute(STR_BROWSER_COMBO_FILE_PATH, strFileBrowserPath) )
			{
				if ( strFileNameNew.CompareNoCase(strFileBrowserPath + strFileName) ) // different from original
				{
					strFileBrowserPath = GetFilePath(strFileNameNew);
					strFileNameNew = GetFileName(strFileNameNew);
					
					// else if go the end, will possibly return FALSE and don't go to xf event. like some we change folder but don't change filename
					// that isn't our expectation
					node.SetAttribute(STR_BROWSER_COMBO_FILE_PATH, strFileBrowserPath);
					node.strVal = strFileNameNew;
					return TRUE;
				}
				return FALSE;
			}
			
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		
			if(node.GetAttribute(STR_FILENAME_ATTRIB, strFullName))
			{
				///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
				if ( strFileNameNew.CompareNoCase(strFullName) ) // different from original
				{
				///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
					node.SetAttribute(STR_FILENAME_ATTRIB, strFileNameNew);
					strFileNameNew = GetFilePath(strFileNameNew);
				///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
					node.strVal = strFileNameNew;
					return TRUE;
				}
				return FALSE;
				///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON clear code
			}
		}///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		//------
	}
	else if(DGC_BUTTON_GRAPH ==  nCode || DGC_BUTTON_GRAPHS == nCode)
	{
		string 		strExcludePage;
		int			nMultiplePages;
		node.GetAttribute(STR_EXCLUDE_PAGE_ATTRIB, strExcludePage);
		/// Iris 8/28/06 SUPPORT_GRAPHS_FILES_CONTRL
		//node.GetAttribute(STR_MULTI_PAGE_ATTRIB, nMultiplePages);
		nMultiplePages = DGC_BUTTON_GRAPH == nCode? false : true;	
		///end SUPPORT_GRAPHS_FILES_CONTRL
		//string strNewVal = _browse_get_graph(node.strVal, nMultiplePages, strExcludePage);
		
		/// Iris 12/18/2006 v8.0527 SHOW_LONG_NAME_ON_PAGES_BOX
		//string strNewVal = _browse_get_graph(hWndParent, node.strVal, nMultiplePages, strExcludePage);
		int			nIncLongName = 0;
		///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
		int			nEnableEmbed = 1;
//#define STR_ENABLE_EMBED_ATTRIB "enable_embed"		///Folger 06/18/08 REMOVE_STR_ENABLE_EMBED_ATTRIB
		node.GetAttribute(STR_ENABLE_EMBED_ATTRIB, nEnableEmbed);
		///End ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
		node.GetAttribute(STR_PAGE_NAME_INC_LONG_NAME_ATTRIB, nIncLongName);		
		//string strNewVal = _browse_get_graph(hWndParent, node.strVal, nMultiplePages, strExcludePage, NULL, nIncLongName, nEnableEmbed);		///Folger 05/29/07 ADD_BOOL_ENABLE_EMBED_IN_PAGE_PREVIEW_LIST_DLG
		//------Folger 07/18/07 CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
		//string strNewVal = _browse_get_graph(hWndParent, node.strVal, nMultiplePages, NULL, nIncLongName, nEnableEmbed);		///Folger 06/05/07 COMMENT_STR_EXCLUDE_PAGE
		//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
		//int nShowLayout = 0;
		//node.GetAttribute(STR_SHOW_LAYOUT_ATTRIB, nShowLayout);
		int nPageType = EXIST_GRAPH;
		node.GetAttribute(STR_BROWSE_PAGE_TYPE_ATTRIB, nPageType);
		//-------End CONTROL_BROWSE_PAGE_TYPE
		DWORD dwCtrl = 0;
		dwCtrl |= nMultiplePages ? SELECT_MULTIPLE_PAGES : 0;
		dwCtrl |= nEnableEmbed ? ENABLE_EMBEDED : 0;
		///------ Folger 05/04/09 QA80-13552 GRAPH_BROWSER_NEEDS_MORE_CONTROL_OPTIONS
		int		nBrowserControlOptions = 0;
		if ( node.GetAttribute(STR_BROWSER_CONTROL_OPTIONS_ATTRIB, nBrowserControlOptions) )
		{
			if ( BROWSER_CONTROL_SORT_PAGES & nBrowserControlOptions )
				dwCtrl |= SORT_PAGE;
			if ( BROWSER_CONTROL_EXCLUDE_3D_GRAPHS & nBrowserControlOptions )
				dwCtrl |= FILTER_3D_GRAPH;
		}
		///------ End GRAPH_BROWSER_NEEDS_MORE_CONTROL_OPTIONS
		//-------Folger 07/19/07 CONTROL_BROWSE_PAGE_TYPE
		//dwCtrl |= nShowLayout ? SHOW_LAYOUT : 0;
		/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
		//string strNewVal = _browse_get_graph(hWndParent, node.strVal, NULL, nIncLongName, dwCtrl);
		string strNewVal = _browse_get_graph(hWndParent, node.strVal, NULL, nIncLongName, dwCtrl, nPageType, lpcsFilterFuncName);
		///end FILTER_GRAPH_FUNCTION_SUPPORT
		//-------End CONTROL_BROWSE_PAGE_TYPE
		//------End CLEAN_UP_CONTROL_BITS_INTO_DWORD_FOR_GRAPH_BROWSER
		///end SHOW_LONG_NAME_ON_PAGES_BOX
		if(!strNewVal.IsEmpty() && strNewVal.CompareNoCase(node.strVal))
		{
			node.strVal = strNewVal;
			return TRUE;
		}
		return FALSE;		
	}
	//----
	///Jasmine 01/11/07 OPEN_REPORT_TREE_BROWSER
	else if(DGC_BUTTON_REPORT ==  nCode || DGC_BUTTON_REPORTS == nCode)
	{
		int	nSelMode = 1;
		if(DGC_BUTTON_REPORTS ==  nCode)
			node.GetAttribute(STR_DATA_ATTRIB, nSelMode);
		///Jasmine 01/18/07 ADD_REPORT_TREE_FILTER_STRING
		string strNewVal, strFilter;
		node.GetAttribute(STR_FILTER_ATTRIB, strFilter);
		vector<uint> vuIDs;
		open_report_tree_browser(strNewVal, vuIDs, nSelMode, strFilter, hWndParent);
		///End ADD_REPORT_TREE_FILTER_STRING
		if(!strNewVal.IsEmpty() && strNewVal.CompareNoCase(node.strVal))
		{
			node.strVal = strNewVal;
			return TRUE;
		}
		return FALSE;		
	}
	///End OPEN_REPORT_TREE_BROWSER
	///Folger 06/20/07 OPEN_SHEETS_BROWSER
	else if(DGC_BUTTON_SHEET ==  nCode || DGC_BUTTON_SHEETS == nCode)
	{
		bool bMultiSelect = DGC_BUTTON_SHEETS == nCode ? true : false;
		///Jasmine 03/14/11 ORG-2375-P2 EXP_WKS_NEED_BROWSE_REPORT_SHEET
		//string strNewVal = _browse_get_sheet(hWndParent, node.strVal, bMultiSelect);
		int bIncludeReportSheet;
		node.GetAttribute(STR_INCLUDE_REPORT_SHEET_ATTRIB, bIncludeReportSheet);
		string strNewVal = _browse_get_sheet(hWndParent, node.strVal, bMultiSelect, bIncludeReportSheet);
		///End EXP_WKS_NEED_BROWSE_REPORT_SHEET
		if(!strNewVal.IsEmpty() && strNewVal.CompareNoCase(node.strVal))
		{
			node.strVal = strNewVal;
			return TRUE;
		}
		return FALSE;
	}
	///End OPEN_SHEETS_BROWSER
	/// EJP 2007-06-05 v8.0634 XF_ARG_SUPPORT_MULTISEL_FILE_DLG
	///if(DGC_BUTTON_FILE == nCode || DGC_BUTTON_FILES == nCode)
	if( DGC_BUTTON_FILE == nCode || DGC_BUTTON_FILES == nCode || DGC_BUTTON_FILE_MULTISEL == nCode )
	/// end XF_ARG_SUPPORT_MULTISEL_FILE_DLG
	{
		/// Iris 8/28/06 SUPPORT_GRAPHS_FILES_CONTRL
		//string strMarker = "..File";
		//string  strMarker = DGC_BUTTON_FILE == nCode? "..File" : "..Files";

		/// EJP 2007-06-05 v8.0634 XF_ARG_SUPPORT_MULTISEL_FILE_DLG
		///	string  strMarker = DGC_BUTTON_FILE == nCode? "..FILE" : "..FILES"; // Hong 02/09/07 SUPPORT_KEY_STRING_NOT_SENSITIVE
		string strMarker = "..FILE";
		if( DGC_BUTTON_FILES == nCode )
			strMarker += "S";
		else if( DGC_BUTTON_FILE_MULTISEL == nCode )
			strMarker += "MULTISEL";
		/// end XF_ARG_SUPPORT_MULTISEL_FILE_DLG

		bool	bMulFiles = DGC_BUTTON_FILE == nCode? false : true;
		///end SUPPORT_GRAPHS_FILES_CONTRL

		/// EJP 2007-08-21 v8.0687 QA70-10280 FIX_DEFAULT_PATH_FOR_XF_FILE_AND_FILES_ARG
		///	if(!strFileName.IsFile())/// TD 6-23-06 FILE_BROWSER_NO_WORKING_WITH_INVALID_FILE_NAME
		///		strFileName = "";
		///
		///	string strFilePath = GetFilePath(strFileName);
		string strFirstFileName;
		if( bMulFiles )
			strFirstFileName = strFileName.GetToken(0, '\n');
		else
			strFirstFileName = strFileName;
		string strFilePath = GetFilePath(strFirstFileName);
		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		string strFileBrowserPath;
		if ( node.GetAttribute(STR_BROWSER_COMBO_FILE_PATH, strFileBrowserPath) )
			strFilePath = cvt_predefined_path_to_real_path(strFileBrowserPath);
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		/// end FIX_DEFAULT_PATH_FOR_XF_FILE_AND_FILES_ARG

		bool bDlgDone = false;
		if(_parse_node_combo_for_file(node, saTypes, strGroup, strTitle, strMarker))
		{
			/// EJP 2007-06-05 v8.0634 XF_ARG_SUPPORT_MULTISEL_FILE_DLG
			///	//--- Iris 11/01/06 v8.0502d NEED_SHOW_DEFAULT_PATH_FOR_XF_IMGPLATTE
			///	//int nFiles = get_open_box_by_file_group(strFileNameNew, strGroup, strTitle, bMulFiles);
			///	int nFiles = get_open_box_by_file_group(strFileNameNew, strGroup, strTitle, bMulFiles, false, strFilePath, GetFileName(strFileName, true));
			///	//---
			DWORD dwFlags = 0;
			if( bMulFiles )
				dwFlags |= (DGC_BUTTON_FILE_MULTISEL == nCode ? OPENBOX_FLAG_MULTISEL : OPENBOX_FLAG_MULTIFILES);
			/// Hong 07/18/08 QA80-11861 FIX_FILE_GROUP_FAIL_USING_DEFAULT_PATH
			//int nFiles = get_open_box_by_file_group(strFileNameNew, strGroup, strTitle, dwFlags, strFilePath, GetFileName(strFileName, true));
			LPCSTR 		lpcszDefaultPath = strFilePath;
			if ( strFilePath.IsEmpty() )
				lpcszDefaultPath = NULL;
			int nFiles = get_open_box_by_file_group(strFileNameNew, strGroup, strTitle, dwFlags, lpcszDefaultPath, GetFileName(strFileName, true));
			/// end FIX_FILE_GROUP_FAIL_USING_DEFAULT_PATH
			/// end XF_ARG_SUPPORT_MULTISEL_FILE_DLG

			/// Iris 12/06/2006 CANCEL_FILE_SEL_SHOULD_NOT_OEPN_XF_DLG
			if(nFiles <= 0)
				return FALSE;
			///end CANCEL_FILE_SEL_SHOULD_NOT_OEPN_XF_DLG
			bDlgDone = true;
		}

		if(!bDlgDone)
		{
			/// Iris 8/28/06 SUPPORT_GRAPHS_FILES_CONTRL
			if(bMulFiles)
			{
				vector<string> saFilePaths;
				int iNumSelFiles = GetMultiOpenBox( saFilePaths, saTypes, strFilePath, strFileName, "Open", false );
				if(iNumSelFiles >= 0)
					//--- Iris 8/31/06
					//file_name_array_to_str(strFileNameNew, saFilePaths);
					strFileNameNew = str_combine(saFilePaths, "\r\n");	
					//---
			}
			///end SUPPORT_GRAPHS_FILES_CONTRL
			else
			{
				strFileNameNew = GetOpenBox(saTypes, strFilePath, strFileName);
			}
		}
			
		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		if ( !strFileNameNew.IsEmpty() && node.GetAttribute(STR_BROWSER_COMBO_FILE_PATH, strFileBrowserPath ) )
		{
			if ( bMulFiles )
			{
				ASSERT(FALSE);
				// Sim, to do, need check all file paths are consistent and remove all file paths
			}
			else
			{
				if ( strFileNameNew.CompareNoCase(strFileBrowserPath + strFileName) ) // different from original
				{
					strFileBrowserPath = GetFilePath(strFileNameNew);
					strFileNameNew = GetFileName(strFileNameNew);
					
					// else if go the end, will possibly return FALSE and don't go to xf event. like some we change folder but don't change filename
					// that isn't our expectation
					node.SetAttribute(STR_BROWSER_COMBO_FILE_PATH, strFileBrowserPath);
					node.strVal = strFileNameNew;
					return TRUE;
				}
				return FALSE;
			}
		}
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
	}
	///Iris 03/25/2009 QA80-13295-P3 GOTO_DLG_SUPPORT_COL_BROWSER
	else if( DGC_BUTTON_COLUMN == nCode || DGC_BUTTON_COLUMNS == nCode )
	{
		bool bMultipleSelect = (DGC_BUTTON_COLUMNS == nCode);
		bool bXYRange = false;
		/// Zech 12/17/2011 ORG-4452-P1 ENABLE_DROPDOWN_IN_GETNBOX_COLUMN_BROWSER
		//bool bOnlySelectableInSheet = true;
		double dEnableListDropdown;
		LT_get_var("@ELD", &dEnableListDropdown);
		bool bOnlySelectableInSheet = !(bool)dEnableListDropdown;
		/// END ENABLE_DROPDOWN_IN_GETNBOX_COLUMN_BROWSER
		StringArray saSelections;
		if( open_column_browser(hWndParent, saSelections, bMultipleSelect, bXYRange, bOnlySelectableInSheet) )
		{
			///------ Folger 02/07/2012 ORG-4452-P2 LT_GETN_SHOULD_GET_RANGE_STRING_FROM_COLUMN_BROWSER
			//string strVal;
			//for(int nn=0; nn<saSelections.GetSize(); nn++)
			//{
				//DataRange dr;
				//dr.Add("Range1", saSelections[nn]);
				
				//Column col;
				//range_get_col(dr, 0, col);
				///strVal += col.GetName() + "|";
			//}
			//strVal.TrimRight('|');
			//node.strVal = strVal;
			node.strVal.SetTokens(saSelections, '|');
			///------ End LT_GETN_SHOULD_GET_RANGE_STRING_FROM_COLUMN_BROWSER
			return TRUE;
		}
	}
	///end GOTO_DLG_SUPPORT_COL_BROWSER
	///------ Folger 09/18/2012 ORG-6861 SUPPORT_LT_GETN_MATRIX_BROWSER
	else if ( DGC_BUTTON_MATRIX == nCode || DGC_BUTTON_MATRICES == nCode )
	{
		StringArray saSelections;
		if( OnShowMatrixBrowserEx(saSelections, hWndParent, DGC_BUTTON_MATRIX == nCode ? SCD_SINGLE_SELECTION : 0) )
		{
			node.strVal.SetTokens(saSelections, '|');
			return TRUE;
		}
	}
	///------ End SUPPORT_LT_GETN_MATRIX_BROWSER
	
	if(!strFileNameNew.IsEmpty() && strFileNameNew.CompareNoCase(strFileName))
	{
		node.strVal = strFileNameNew;
		return TRUE;
	}	
	return FALSE;
}
/// end EDITBOX_WITH_BUTTON

///Iris 03/25/2009 QA80-13295-P3 GOTO_DLG_SUPPORT_COL_BROWSER
/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
//typedef BOOL (*FUNC_VECTOR_STR_HWND_INT_BOOL_BOOL_DWORD_STR) (vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL);	///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX
///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
//typedef BOOL (*FUNC_VECTOR_STR_HWND_INT_BOOL_BOOL_DWORD_STR) (vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, UINT nSelectedColUID = 0);
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
//bool open_column_browser(HWND hWndParent, vector<string>& vsSelections, bool bMultipleSelect, bool bXYRange, bool bOnlySelectableInSheet)
///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
//bool open_column_browser(HWND hWndParent, vector<string>& vsSelections, bool bMultipleSelect, bool bXYRange, bool bOnlySelectableInSheet, LPCSTR lpcszBookSheetSpecified/* = NULL*/)
bool open_column_browser(HWND hWndParent, vector<string>& vsSelections, bool bMultipleSelect, bool bXYRange, bool bOnlySelectableInSheet, void* pMore/* = NULL*/)
///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
{
	string strDlgName = bXYRange? _L("Dataset Browser") : _L("Column Browser");
	
	FUNC_RANGE_BROWSER pfn = Project.FindFunction("RangeBrowser", "Originlab\\RangeBrowser.c");
	if(!pfn)
		return error_report("Fail to find RangeBrowser function!");

	DWORD dwFilter = SCD_NO_RESULT_SHEET;
	if( bOnlySelectableInSheet )
		dwFilter |= SCD_ONLY_SELECTABLE_IN_LAYER;
	///------ Folger 06/01/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	//if( !pfn(vsSelections, hWndParent, EXIST_WKS, bXYRange, bMultipleSelect, dwFilter, strDlgName))
	///------ Folger 09/17/2012 ORG-6848-P1 BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
	//if( !pfn(vsSelections, hWndParent, EXIST_WKS, bXYRange, bMultipleSelect, dwFilter, strDlgName, 0, lpcszBookSheetSpecified) )
	if( !pfn(vsSelections, hWndParent, EXIST_WKS, bXYRange, bMultipleSelect, dwFilter, strDlgName, 0, pMore) )
	///------ End BETTER_OUTPUT_COLUMNS_FILTERING_FOR_INPUT_COLUMN_BROWSER
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
		return false; // user click Cancel button
	return true;	
}
///end GOTO_DLG_SUPPORT_COL_BROWSER

/// YuI 11/10/06
#ifndef	_INTERACTIVE_CNTRL_IN_FLEX_GRID
void TreeEditInputData::SetInputDataBranchValue(int nRow, int nCol, const TreeNode& trNode, BOOL bTreeToCell = TRUE)
{
	string strLabel;
	EditorManager	trNodeManager;
	if( trNode.ID == TRGP_XY_DATA_RANGE || trNode.ID == TRGP_XYZ_DATA_RANGE || trNode.ID == TRGP_XY_COMPLEX_DATA_RANGE )
	{
		if( bTreeToCell )
		{
			if( trNodeManager.GetCompositeRangeString(trNode, strLabel) )
				SetCell(strLabel, flexcpText, nRow, nCol);
		}
		else
		{
			strLabel = GetCell(flexcpText, nRow, nCol);
			trNodeManager.SetCompositeRangeString(trNode, strLabel);
		}
	}
	else
	{
		GetInputDataDescription(trNode, strLabel);
		SetCell(strLabel, flexcpText, nRow, nCol);
	}

	if( IsTreeView() )
	{
		DWORD dwTemp;
		foreach( TreeNode trChild in trNode.Children )
		{
			nRow++;
			try {
				SetCell(trChild.strVal, flexcpText, nRow, nCol);
				trNodeManager.SetText(GetCell(flexcpData, nRow, nCol), trChild.strVal, OXVT_STRING);
			} 
			catch (int nErr)
			{
				printf("SetInputDataBranchValue err at nRow = %d\n", nRow);
			}
		}
	}
}
#endif //	_INTERACTIVE_CNTRL_IN_FLEX_GRID

///Joseph 02/07/07 FIX_BUG_ON_MORE_PAGES
///// Iris 12/27/2006 v8.0533 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
//int post_getn_dialog_message(int nMsg, uint wParam, uint lParam)
//{
	//static HWND s_hDlg;
	//
	//if(PGDM_SET_HDLG == nMsg)
	//{
		//s_hDlg = (HWND)wParam;
		//return 0;
	//}
	//else
	//{
		//if(NULL != s_hDlg)
		//{
			//Window wnd(s_hDlg);
			//if(wnd)
			//{
				//wnd.PostMessage(nMsg);			
				//return 0;
			//}
		//}		
	//}
	//return -1;
//}
/////end CALL_EVENT1_ON_GRAPH_OBJ_MOVING
///Joseph 02/25/07 ARGUMENTS_ORDER_NOT_RIGHT
//int post_getn_dialog_message(int nMsg, uint wParam, uint nPageID, uint lParam)
int post_getn_dialog_message(int nMsg, WPARAM wParam, LPARAM lParam , uint nPageID)
///End ARGUMENTS_ORDER_NOT_RIGHT
{
	static vector<OUIP>	s_vnHWNDs;
	static vector<int>	s_vnPageIDs;
	if(0 == nPageID)
	{
		Page pg = Project.Pages();
		if(!pg)
		{
			return -1;
		}
		nPageID = pg.GetUID();
		if(0 == nPageID)
		{
			return -1;
		}
	}
	if(PGDM_SET_HDLG == nMsg)
	{
		if(wParam)
		{
			s_vnHWNDs.Add(wParam);
			s_vnPageIDs.Add(nPageID);
		}
		else
		{
			int ii = find_in_list(nPageID, s_vnPageIDs, false);
			if(ii >= 0)
			{
				s_vnHWNDs.RemoveAt(ii);
				s_vnPageIDs.RemoveAt(ii);
			}
		}
		return 0;
	}
	else
	{
		int ii = find_in_list(nPageID, s_vnPageIDs, false);
		if(ii >= 0)
		{
			OUIP uHwnd = s_vnHWNDs[ii];
			HWND hWnd = (HWND)uHwnd;
			Window wnd(hWnd);
			if(wnd)
			{
				//--- Iris 02/09/2007 v8.0559 POST_MSG_WITH_GO_INDEX
				//wnd.PostMessage(nMsg);
				wnd.PostMessage(nMsg, wParam, lParam);
				//--- 
				return 0;
			}
		}
	}		
	return -1;
}
///End FIX_BUG_ON_MORE_PAGES


///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
bool is_theme_dialog(const TreeNode& trGetN)
{
#ifndef		_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
	///Sophy 12/18/2008 v8.0988 QA80-12798 CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU
	//if trGetN.AutoUpdate exist and trGetN.AutoUpdate.Enable = false (from change parameters), then there is no theme control in the Dialog
	if((trGetN.AutoUpdate) && (!trGetN.AutoUpdate.Enable))
		return false;
	///end CHANGE_PARAMETERS_SHOULD_SHOW_THEME_MENU
#endif		//_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
	
	if(is_xf_gui_getn_tree(trGetN) && trGetN.tagName.CompareNoCase(XFGUI_GETN_TAGNAME_NO_THEME )|| trGetN.tagName == "GUI")
		return true;
	else
		return false;
}
///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE

///Folger 06/20/07 CREATE_DLG_MODEL
///Jasmine 03/14/11 ORG-2375-P2 EXP_WKS_NEED_BROWSE_REPORT_SHEET
//static string _browse_get_sheet(HWND hWndParent, LPCSTR lpcszSheets, bool bMutiSelect = true)
static string _browse_get_sheet(HWND hWndParent, LPCSTR lpcszSheets, bool bMutiSelect = true, bool bIncludeReportSheet = false)
///End EXP_WKS_NEED_BROWSE_REPORT_SHEET
{
	string strSheets = lpcszSheets;
	vector<string> vsResult;
	strSheets.GetTokens(vsResult, STR_PAGE_LIST_SEPARATOR);
	///Jasmine 03/14/11 ORG-2375-P2 EXP_WKS_NEED_BROWSE_REPORT_SHEET
	//open_sheet_list_dlg(hWndParent, vsResult, bMutiSelect);
	open_sheet_list_dlg(hWndParent, vsResult, bMutiSelect, bIncludeReportSheet);
	///End EXP_WKS_NEED_BROWSE_REPORT_SHEET
	strSheets.SetTokens(vsResult, STR_PAGE_LIST_SEPARATOR);
	return strSheets;
}
///End CREATE_DLG_MODEL

///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
// MOVE to GetNBox.h
//#define STR_DS_SETTINGS_BRANCH	"DialogSettings"
///---END QA80-11371 THEME_SAVING_OPTIONS
#define STR_EXEC_VALS_BRANCH	"ExecutionValues"

TreeNode get_external_settings_branch(const TreeNode& trGetN, int nType, bool bCheckAddNode)// = EX_SETTING_BRANCH, false
{
	TreeNode tr = trGetN.GetNode(STR_DS_SETTINGS_BRANCH); // hard code, because got troubles when searched treenode by small id
	if ( !tr && bCheckAddNode )
	{
		tr = trGetN.AddNode(STR_DS_SETTINGS_BRANCH)
	}

	switch ( nType )
	{
	case EX_SETTING_EXEC_VALS:
		if ( tr )
		{
			TreeNode trDs = tr;
			tr = trDs.GetNode(STR_EXEC_VALS_BRANCH);
			if ( !tr && bCheckAddNode )
			{
				tr = trDs.AddNode(STR_EXEC_VALS_BRANCH)
			}
		}
		break;
	default:
		break;
	}

	return tr;
}
///---END GET_CREATED_OUTPUT_PAGE_INFO

///---Sim 12-06-2007 IMPROVE_EVENT1_PARAM_STR_AUX
#define CHAR_SEP_AUX_SETTING '|'

void set_aux_value(string& strAux, LPCSTR lpcszSetting, bool bAdd) // = true
{
	if ( !bAdd )
		strAux.Empty();
	
	if ( !strAux.IsEmpty() )
		strAux += CHAR_SEP_AUX_SETTING;
	strAux += lpcszSetting;
}

bool is_aux_value(LPCSTR lpcszAux, LPCSTR lpcszSetting)
{
	string strAux(lpcszAux);
	StringArray saAuxSettings;
	strAux.GetTokens(saAuxSettings, CHAR_SEP_AUX_SETTING);
	
	return ( saAuxSettings.Find(lpcszSetting) >= 0 );	
}
///---END IMPROVE_EVENT1_PARAM_STR_AUX

///---Sandy 2008-3-18 MOVE_FROM_PFM_UTILS
bool set_combo_string(TreeNode& trCombo, vector<string>& vsOps)
{
			
	if(!trCombo)
		return false;
	
	if(vsOps.GetSize() <= 0)
		return false;
	
	string strList;
	strList.SetTokens(vsOps, '|');
	trCombo.SetAttribute(STR_ID_ATTRIB, TRGP_ENUM_LIST);
	trCombo.SetAttribute(STR_COMBO_ATTRIB, strList);
	
	return true;
}
///---END MOVE_FROM_PFM_UTILS

///------ Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
GetNOptionEventHelper::GetNOptionEventHelper(DWORD dwCntrl)
{
	m_dwEvents = O_GET_NBITS(GETNEVENT_ON_ANY, dwCntrl);
}

BOOL	GetNOptionEventHelper::IsInit()
{
	return GETNEVENT_ON_INIT == m_dwEvents;
}

BOOL	GetNOptionEventHelper::IsTheme()
{
	return GETNEVENT_ON_THEME == m_dwEvents;
}
///------ End QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE

/// Iris 7/11/2011 ORG-2629 CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS
void ThemeControlHelper::Init(Dialog* pDlg, int nComboID, int nButtonID, TreeNode& trSettings, LPCSTR lpcszFile, LPCSTR lpcszFunc)
{
	m_pDlg = pDlg;
	m_cmb = pDlg->GetItem(nComboID);
	m_cmb.Enable = false;
	m_btn = pDlg->GetItem(nButtonID);
	
	m_trDefaultSettings = trSettings; // m_trDefaultSettings always cannot be change
	m_trSettings = trSettings; // m_trSettings is the settings tree according to the selection in Theme combo
	m_bChangeEventReady = true;
	m_strExtenalFileName = lpcszFile;
	m_strExtenalFuncName = lpcszFunc;
	
	bool bSelectedThemeChanged = false;
	refreshComboList(NULL, &bSelectedThemeChanged);
	if( bSelectedThemeChanged )
		trSettings = m_trSettings;
}

void ThemeControlHelper::refreshComboList(LPCSTR lpsczSel, bool* pbSelectedThemeChanged)
{
	string strOldSel;
	int nOldSel = m_cmb.GetCurSel();
	if( nOldSel >= 0 )
		m_cmb.GetLBText(nOldSel, strOldSel);
	
	m_cmb.ResetContent();
	
	vector<string> vsThemeFiles;
	//---- CPY 7/28/2011 ORG-3350-P1 SHOULD_BE_ABLE_TO_SHIP_BUILT_IN_FUNCTION_THEMES
	//theme_get_list(m_trDefaultSettings, vsThemeFiles);	
	theme_get_list(m_trDefaultSettings, vsThemeFiles, true, true);
	//---- end SHOULD_BE_ABLE_TO_SHIP_BUILT_IN_FUNCTION_THEMES
	if( vsThemeFiles.GetSize() == 0 )
		return;

	for(int ii = 0; ii < vsThemeFiles.GetSize(); ii++)
		m_cmb.AddString( vsThemeFiles[ii] );
	
	bool bInitSelDone = false;
	if( lpsczSel )
	{
		int index = -1;
		if( (index = vsThemeFiles.Find(lpsczSel)) >= 0 )
		{
			m_cmb.SetCurSel(index);	
			bInitSelDone = true;
		}
	}
	else if( nOldSel >= 0 )
	{		
		m_cmb.SetCurSel(nOldSel);
		bInitSelDone = true;
	}
	
	if( !bInitSelDone )
	{
		m_cmb.SetCurSel(0);	
	}
	
	bool bSelectedThemeChanged = false;
	string strSel;	
	m_cmb.GetLBText(m_cmb.GetCurSel(), strSel);	
	if( nOldSel < 0 // if not init the selection before
		|| 0 != lstrcmp(strSel, strOldSel) ) // if the selected theme changed, need to load from new theme file to setting tree
	{
		getSettingTreeFromComboSel(m_cmb.GetCurSel(), m_trSettings);
		bSelectedThemeChanged = true;
	}
	if( pbSelectedThemeChanged != NULL )
		*pbSelectedThemeChanged = bSelectedThemeChanged;
}

///------ Folger 07/16/2012 ORG-6225-P1 SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
//bool ThemeControlHelper::ShowPopupMenu(HWND hWnd, TreeNode& trToSave, TreeNode& trToLoading, bool& bIsLoading)
bool ThemeControlHelper::ShowPopupMenu(HWND hWnd, TreeNode& trToSave, TreeNode& trToLoading, bool& bIsLoading, PFN_THEME_MENU_CALLBACK pfn/* = NULL*/)
///------ End SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
{
	// get theme filename list
	vector<string> vsThemeFiles;
	for(int ii = 0; ii < m_cmb.GetCount(); ii++)
	{
		string str;
		m_cmb.GetLBText(ii, str);
		str.TrimRight(CHAR_UNSAVE_SIGN); // remove *
		str.TrimRight(); // remove space
		vsThemeFiles.Add(str);
	}
	int nSel = m_cmb.GetCurSel();
	int nDefaultOffset = 0;
	if ( vsThemeFiles.GetSize() > 0 && theme_is_factory_default(vsThemeFiles[0]) )
	{
		vsThemeFiles.RemoveAt(0);
		--nSel;
		++nDefaultOffset;
	}	
	
	// constuct and show theme context menu 
	RECT rrButton;
	m_btn.GetClientRect(&rrButton);	
	m_btn.ClientToScreen(&rrButton);

	///------ Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	DWORD		dwCntrls = THEMEMENUCNTRL_PASTE;
	TreeNode	trRef = trToSave;
	if ( !trRef )
		trRef = trToLoading;
	if ( theme_can_paste_settings(trRef) )
		O_ADD_BIT(dwCntrls, THEMEMENUCNTRL_PASTABLE);
	///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	dwCntrls |= THEMEMENUCNTRL_COPY; ///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
	
	/// Zech 10/10/2011 ORG-4001-P1 GRAY_OUT_DELETE_SUBMENU_IN_THEME_DROPDOWN_WHEN_NO_THEME_AVAILABLE_EXCEPT_FOR_LAST_USED
	/*
	ThemeControlMenu myMenu(isSaveEnable()
		, false
		, false
		, false
		, vsThemeFiles
		, nSel
		, true
		, true		
		, false
		, false
		///------ Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
		, dwCntrls
		///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
		);
	*/		
	ThemeControlMenu myMenu(isSaveEnable()
		, false
		, false
		, false
		, vsThemeFiles
		, nSel
		, true
		///Philip 08/02/2012 ORG-6395-P1 GRAY_OUT_DELETE_IN_THEME_MENU_OF_3DPARAMETRICFUNCPLOT_DIALOG
		//, getThemeFileNumExceptLastUsed(vsThemeFiles) > 0
		, isAnyThemeFileDeletable(vsThemeFiles)
		///end GRAY_OUT_DELETE_IN_THEME_MENU_OF_3DPARAMETRICFUNCPLOT_DIALOG
		, false
		, false
		, dwCntrls
		);
	/// END GRAY_OUT_DELETE_SUBMENU_IN_THEME_DROPDOWN_WHEN_NO_THEME_AVAILABLE_EXCEPT_FOR_LAST_USED
	
	myMenu.TrackPopupMenu(0,  rrButton.right, rrButton.top, hWnd);	
	
	int					nCmd;
	if( myMenu.GetCommand(nCmd) )// do theme actions on menu selection	
	{
		///------ Folger 07/16/2012 ORG-6225-P1 SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
		if ( pfn && !pfn(nCmd, trToSave, trToLoading) )
			return false;
		///------ End SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG

		bIsLoading = false;
		switch(nCmd)
		{
		case THEME_MENU_SAVE_AS_DEFAULT:
			{
				saveAsDefault(trToSave);
			}
			break;
			
		case THEME_MENU_SAVE:
			{
				/// Sen 08/03/2011 ORG-2629-P7 TO_FIX_CLICK_SAVE_TO_NEW_THEME_BUT_NO_DIALOG_OPENS
				//save(trToSave);
				save(hWnd, trToSave);
				/// End TO_FIX_CLICK_SAVE_TO_NEW_THEME_BUT_NO_DIALOG_OPENS
			}
			break;
			
		case THEME_MENU_SAVE_AS:
			{	
				saveAs(hWnd, trToSave);
			}
			break;
			
		/// Bill 07/15/2011 SUPPORT_DELETE_BUTTON_FOR_THEME_MENU
		case THEME_MENU_DELETE:
			{
				/// Iris 7/18/2011 TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
				//deleteTheme(trToSave);
				//refreshComboList();
				if( deleteTheme(trToSave) )
					refreshComboList("");
				///End TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
			}
			break;
		/// End SUPPORT_DELETE_BUTTON_FOR_THEME_MENU
			
		case THEME_MENU_RESET:
			{
				bIsLoading = true;
				getSystemDefaultSettingTree(trToLoading);
			}
			break;

		///------ Folger 08/02/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
		case THEME_MENU_COPY:
			theme_copy_settings(trToSave);
			break;

		case THEME_MENU_PASTE:
			if ( (bIsLoading = theme_paste_settings(trToLoading)) )
				OnDlgSettingChange();
			break;
		///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
		
		default:
			if( nCmd >= THEME_MENU_LOADING_START )
			{
				bIsLoading = true;
				int nIndex = nCmd - THEME_MENU_LOADING_START;
				int nCmbSel = nIndex + nDefaultOffset;

				getSettingTreeFromComboSel(nCmbSel, trToLoading);
				
				removeComboListUnsaveSign(nCmbSel);				
			}
			break;
		}
		return true;
	}		
	return false; // nothing selected in menu
}

void ThemeControlHelper::removeComboListUnsaveSign(int nCmbSel)
{
	int nOldSel = m_cmb.GetCurSel();
	string strText;
	m_cmb.GetLBText(nOldSel, strText);
	if( !strText.IsEmpty() && strText.GetAt(strText.GetLength()-1) == CHAR_UNSAVE_SIGN ) // if include *
	{
		strText.TrimRight(CHAR_UNSAVE_SIGN);
		strText.TrimRight();
		m_cmb.DeleteString(nOldSel);
		m_cmb.InsertString(nOldSel, strText);
	}		
	
	if( -1 == nCmbSel )
		m_cmb.SetCurSel(nOldSel);
	else
		m_cmb.SetCurSel(nCmbSel);
}

void ThemeControlHelper::OnDlgSettingChange()
{
	if( !m_bChangeEventReady )
		return;
	
	int nSel = m_cmb.GetCurSel();
	string strText;
	m_cmb.GetLBText(nSel, strText);
	strText.TrimRight();
	
	if( !strText.IsEmpty() && strText.GetAt(strText.GetLength()-1) == CHAR_UNSAVE_SIGN)
	{	
		return; // already added *
	}
	
	string strNew;
	strNew.Format("%s %c", strText, CHAR_UNSAVE_SIGN);
	m_cmb.DeleteString(nSel);
	m_cmb.InsertString(nSel, strNew);
	m_cmb.SetCurSel(nSel);
}
	
bool ThemeControlHelper::saveAsDefault(const TreeNode& trNewSettings)
{
	return saveTheme(STR_DEFAULT, trNewSettings);
}

string ThemeControlHelper::getCurrentThemeName()
{
	int nCurSel = m_cmb.GetCurSel();
	if( nCurSel < 0 )
		return "";
	
	string strText;
	m_cmb.GetLBText(nCurSel, strText);
	strText.TrimRight(CHAR_UNSAVE_SIGN);
	strText.TrimRight();
	
	return strText;
}

bool ThemeControlHelper::isSaveEnable()
{	
	string strThemeName = getCurrentThemeName();
	/// Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
	//return !strThemeName.IsEmpty();
	return theme_can_save(strThemeName);
	/// END DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
}
/// Sen 08/03/2011 ORG-2629-P7 TO_FIX_CLICK_SAVE_TO_NEW_THEME_BUT_NO_DIALOG_OPENS
//bool ThemeControlHelper::save(const TreeNode& trNewSettings)
bool ThemeControlHelper::save(HWND hWnd, const TreeNode& trNewSettings)
{
	string strThemeName = getCurrentThemeName();	
	string strClassOption;
	if(strThemeName.IsEmpty())
	{
		theme_get_class_option(trNewSettings, strClassOption);
		theme_ask_save_as_filename(strClassOption, strThemeName, hWnd);	
		if( strThemeName.IsEmpty() )
			return false;
	}
/// End TO_FIX_CLICK_SAVE_TO_NEW_THEME_BUT_NO_DIALOG_OPENS
	return saveTheme(strThemeName, trNewSettings);	
}

bool ThemeControlHelper::saveAs(HWND hWnd, const TreeNode& trNewSettings)
{
	string strClassOption, strName;
	theme_get_class_option(trNewSettings, strClassOption);
	theme_ask_save_as_filename(strClassOption, strName, hWnd);	
	if( strName.IsEmpty() ) // clicked Calcel button 
		return false;

	return saveTheme(strName, trNewSettings);	
}

/// Bill 07/15/2011 SUPPORT_DELETE_BUTTON_FOR_THEME_MENU
bool ThemeControlHelper::deleteTheme(const TreeNode & tr)
{
	/// Iris 7/18/2011 TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
	//theme_delete_settings(tr, m_pDlg->GetSafeHwnd());
	//return true;
	return theme_delete_settings(tr, m_pDlg->GetSafeHwnd());
	///End TO_FIX_SELECTED_WRONG_THEME_AFTER_DELETE_THEME
}
/// End SUPPORT_DELETE_BUTTON_FOR_THEME_MENU

bool ThemeControlHelper::saveTheme(LPCSTR lpcszName, const TreeNode& trNewSettings)
{
	bool bRet = false;
	if(is_theme_default(lpcszName))
	{
		bRet = theme_default_setting_management(trNewSettings, THEME_DEFAULT_SET);
	}
	else
	{
		string strClassOption;
		theme_get_class_option(trNewSettings, strClassOption);
		/// Iris 7/18/2011 ORG-3273 SAVE_THEME_WITH_CORRECT_NAME_AND_FOLDER
		//string strFullPath = theme_get_settings_file(lpcszName, strClassOption);
		//theme_save_settings(trNewSettings, strFullPath);		
		int nThemeType = tree_get_theme_type(m_trSettings);
		string strFullPath = theme_get_settings_file(lpcszName, strClassOption, nThemeType);		
		theme_save_settings(trNewSettings, strFullPath, nThemeType);
		///End SAVE_THEME_WITH_CORRECT_NAME_AND_FOLDER
		bRet = strFullPath.IsFile();
	}	
	
	if( bRet )
	{
		afterSaveTheme(lpcszName);
		return true;
	}
	return false;
}

void ThemeControlHelper::afterSaveTheme(LPCSTR lpcszName)
{
	removeComboListUnsaveSign();
	
	string strCurrentName = getCurrentThemeName();	
	if( 0 != strCurrentName.Compare(lpcszName) )
	{
		refreshComboList(lpcszName);
	}	
}

bool ThemeControlHelper::getSystemDefaultSettingTree(TreeNode& trSettings)
{
	ThemeForceLoadFactoryHelper		clHelper(m_trDefaultSettings);	
	refreshComboList("");
		
	trSettings = m_trDefaultSettings;	
	return true;
}

bool ThemeControlHelper::getSettingTreeFromComboSel(int nCmbSel, TreeNode& trSettings)
{	
	string strName;
	m_cmb.GetLBText(nCmbSel, strName);
	strName.TrimRight(CHAR_UNSAVE_SIGN); // remove *
	strName.TrimRight(); // remove space
	bool bRet = getSettingTreeFromThemeFile(strName, trSettings);
	
	if( bRet && !m_strExtenalFileName.IsEmpty() && !m_strExtenalFuncName.IsEmpty() )
	{
		Function fn = Project.FindFunction(m_strExtenalFuncName, m_strExtenalFileName);
		CONSTRUCT_THEME_SETTINGS_FUNC pfn = fn;
		if( pfn && pfn(trSettings) )
		{
			// load from theme file again after reconstruct all treenodes
			bRet = getSettingTreeFromThemeFile(strName, trSettings);
		}
	}
	return bRet;
}

// this function should be only used in getSettingTreeFromComboSel, since this function only load theme from file once time,
// but getSettingTreeFromComboSel allow to load two times accoding to m_strExtenalFuncName and m_strExtenalFileName
bool ThemeControlHelper::getSettingTreeFromThemeFile(LPCSTR lpcszThemeName, TreeNode& trSettings)
{	
	if( 0 == lstrlen(lpcszThemeName) )
		return false;
	
	bool bRet;
	if(is_theme_default(lpcszThemeName))
	{
		bRet = theme_default_setting_management(trSettings, THEME_DEFAULT_GET);
	}
	else
	{
		string strClassOption;
		theme_get_class_option(m_trDefaultSettings, strClassOption);
		
		/// Iris 7/18/2011 ORG-3273 SAVE_THEME_WITH_CORRECT_NAME_AND_FOLDER
		//string strFullPath = theme_get_settings_file(lpcszThemeName, strClassOption);
		int nThemeType = tree_get_theme_type(m_trDefaultSettings);
		string strFullPath = theme_get_settings_file(lpcszThemeName, strClassOption, nThemeType);
		///End SAVE_THEME_WITH_CORRECT_NAME_AND_FOLDER
		if( !strFullPath.IsFile() )
			return error_report("Cannot find theme file - " + strFullPath);
		
		bRet = theme_load_settings(trSettings, strFullPath, false);
	}
	return bRet;
	//return theme_load_settings(trSettings, strFullPath);
}	
///End CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS

/// Sen 08/01/2011 ORG-2629-P5 NO_LAST_USED_THEME_CREATED_AFTER_USING	
bool ThemeControlHelper::SaveLastUsedTheme(TreeNode& tr)
{
	string strClassOption;
	if( theme_get_class_option(tr, strClassOption) )
	{
		theme_update_last_used(strClassOption, tr);
		return true;
	}
	return false;	
}
/// End NO_LAST_USED_THEME_CREATED_AFTER_USING

///Philip 08/02/2012 ORG-6395-P1 GRAY_OUT_DELETE_IN_THEME_MENU_OF_3DPARAMETRICFUNCPLOT_DIALOG
/*
	/// Zech 10/10/2011 ORG-4001-P1 GRAY_OUT_DELETE_SUBMENU_IN_THEME_DROPDOWN_WHEN_NO_THEME_AVAILABLE_EXCEPT_FOR_LAST_USED
	int ThemeControlHelper::getThemeFileNumExceptLastUsed(vector<string> &vsThemeFileNames)
	{
		int nCount = vsThemeFileNames.GetSize(), nNotLastUsed = 0;
		for (int nIndex = 0; nIndex < nCount; nIndex++)
			if (PDS_LAST_USED != str_to_predefined_type(vsThemeFileNames[nIndex]))
				nNotLastUsed++;
		return nNotLastUsed;		
	}
	/// END GRAY_OUT_DELETE_SUBMENU_IN_THEME_DROPDOWN_WHEN_NO_THEME_AVAILABLE_EXCEPT_FOR_LAST_USED
*/
bool ThemeControlHelper::isAnyThemeFileDeletable(vector<string> &vsThemeFileNames)
{
	int nSize = vsThemeFileNames.GetSize();
	for(int i = 0; i < nSize; i++)
	{
		int nPath_t;
		okutil_separate_composite_name(vsThemeFileNames[i], &nPath_t, NULL, ORIGIN_PATH_USER);
		int nPredef_t = str_to_predefined_type(vsThemeFileNames[i]);
		if(PDS_LAST_USED != nPredef_t && ORIGIN_PATH_SYSTEM != nPath_t && ORIGIN_PATH_GROUP != nPath_t)
			return true;//allow to delete theme iff it is USER defined
	}
	return false;
}
///end GRAY_OUT_DELETE_IN_THEME_MENU_OF_3DPARAMETRICFUNCPLOT_DIALOG

///------ Folger 06/05/2012 ORG-5592-S1 SUPPRT_CUSTOM_COLUMN_IDENTIFIER_IN_OPERATION_TOOLS
void make_custom_filter_node(TreeNode& tr, LPCSTR lpcszCustom/* = ""*/)
{
	GETN_USE(tr)

	GETN_STR(CustomHint, "", "") GETN_ID(IDE_QUANTITIES_DATA_IDENTIFIER_CUSTOM_HINT) GETN_HINT_EX(FALSE, FALSE)
	GETN_CURRENT_SUBNODE.SetAttribute(STR_DELAY_DATAID_ASSIGN_ATTRIB, PA_DELAY_DATAID_ASSIGN_VER6);
	string strCustomHint;
	ocu_load_err_msg_str(IDS_CUSTOM_LEGEND_HINT, strCustomHint);
	GETN_CURRENT_SUBNODE.SetAttribute(STR_LABEL_ATTRIB, strCustomHint);

	GETN_STR(Custom, _L("Custom Identifier"), lpcszCustom) GETN_ID(IDE_QUANTITIES_DATA_IDENTIFIER_CUSTOM)
	GETN_CURRENT_SUBNODE.SetAttribute(STR_DELAY_DATAID_ASSIGN_ATTRIB, PA_DELAY_DATAID_ASSIGN_VER6);
}
///------ End SUPPRT_CUSTOM_COLUMN_IDENTIFIER_IN_OPERATION_TOOLS

///------ Folger 07/03/2012 ORG-6076 SUPPRT_GET_SELECTION_RANGE_FROM_INTERATIVE_CONTROL_FROM_OC
static HWND s_hWndDyna = NULL;
static BOOL GetDynaWndCallback(HWND hWnd, LPARAM lParam)
{
	s_hWndDyna = hWnd;
	return FALSE;
}

static HWND s_hWndRangeEdit = NULL;
#define STR_INTERACTIVE_NODE_VALUE_PLACEHOLDER "Range"
static BOOL EnumDynaChildWndCallback(HWND hWnd, LPARAM lParam)
{
	Window wnd(hWnd);
	if ( wnd.Text.Compare(STR_INTERACTIVE_NODE_VALUE_PLACEHOLDER) == 0 )
	{
		s_hWndRangeEdit = hWnd;
		return FALSE;
	}
	return TRUE;
}

#define	WM_CONTROL_ON_INTERACTIVE_BUTTON_CLICKED	(WM_USER + 124)
static bool interactive_range_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nType, WndContainer& getNContainer)
{
	if( nEventInfo & GETNEVENT_ON_INIT)
	{
		Window wndContainer = getNContainer;
		HWND hWnd = wndContainer.GetSafeHwnd();

		s_hWndDyna = NULL;
		EnumChildWindows(hWnd, GetDynaWndCallback, 0);

		if ( s_hWndDyna )
		{
			s_hWndRangeEdit = NULL;
			EnumChildWindows(s_hWndDyna, EnumDynaChildWndCallback, 0);
			if ( s_hWndRangeEdit )
			{
				Window wndDyna(s_hWndDyna);
				Window wndRangeEdit(s_hWndRangeEdit);
				wndRangeEdit.Text = "";
				wndDyna.PostMessage(WM_CONTROL_ON_INTERACTIVE_BUTTON_CLICKED, GetDlgCtrlID(s_hWndRangeEdit), IDC_INTERACTIVE_POPUP_BTN);
			}
		}
	}

	return true;
}

class WksSelectionPreserver
{
public:
	WksSelectionPreserver(Worksheet& wks)
	{
		if ( wks )
			grid.Attach(wks);

		if ( grid )
		{
			grid.GetSelection(vR1, vC1, vR2, vC2, TRUE);
			bData = vR1.GetSize() == 0 || vR1[0] >= 0;
		}
	}
	~WksSelectionPreserver()
	{
		if ( grid )
		{
			if ( !bData )
			{
				vector<int> vnTypes;
				grid.GetShowLabels(vnTypes);

				int nOffset = vnTypes.GetSize();
				vR1 += nOffset;
				vR2 += nOffset;
			}

			grid.SetSelection(vR1, vC1, vR2, vC2, bData);
		}
	}

private:
	vector<int> vR1, vC1, vR2, vC2;
	Grid grid;
	BOOL bData;
};

string get_interative_selection_range(DWORD dwOptions/* = 0*/)
{
	GETN_TREE(tr);
	GETN_INTERACTIVE(r1, "a very longlonglonglong label to enlarge interactive dialog width", STR_INTERACTIVE_NODE_VALUE_PLACEHOLDER) GETN_OPTION_EVENT_EX(interactive_range_event)
	GETN_CURRENT_SUBNODE.SetAttribute(STR_INTERACTIVE_CONTROL_OPTIONS_ATTRIB, dwOptions);
	GETN_CURRENT_NODE.SetAttribute(GETNBOX_SHOW_DIALOG_OPTIONS, DLG_HIDDEN);

	Worksheet wks = Project.ActiveLayer();
	WksSelectionPreserver presever(wks);
	
	GetNBox(tr);
	return tr.r1.strVal;
}
///------ End SUPPRT_GET_SELECTION_RANGE_FROM_INTERATIVE_CONTROL_FROM_OC


///Junon comments: I change this function from theme_utils.c file to this file, because the FitToolsGetXfromY.c file call this function
//////////////////////////////////////////////////////////
/////////// general dialog utilities     /////////////////
//////////////////////////////////////////////////////////
// return the gap between controls that might be used by caller
// for repositioning of other controls
int dlg_resize_buttons_relative_to_main_item(Dialog& dlg, uint nButtonIDs[], uint nMainItemID, int cx, int cy)
{
	Window wndDlg = dlg.GetWindow();
	RECT r1, r2;
	Button btnClose = dlg.GetItem(nButtonIDs[0]);
	btnClose.GetWindowRect(&r1);
	int nBtnWidth = r1.right - r1.left;
	int nBtnHeight= r1.bottom - r1.top;
	wndDlg.ScreenToClient(&r1);
	int nEdge = r1.top;
	
	Control cMainItem = dlg.GetItem(nMainItemID);
	cMainItem.GetWindowRect(&r1);
	wndDlg.ScreenToClient(&r1);
	r1.bottom = cy - nEdge;
	r1.right = cx - nBtnWidth - 2*nEdge;
	
	cMainItem.MoveWindow(&r1);
	
	int ii = 0;
	r2.left = r1.right + nEdge;
	r2.top = nEdge;
	r2.right = r2.left + nBtnWidth;
	r2.bottom = r2.top + nBtnHeight;
	while(nButtonIDs[ii] > 0)
	{
		Button btn = dlg.GetItem(nButtonIDs[ii]);
		if(btn)
		{
			btn.MoveWindow(&r2);
			r2.top += nBtnHeight + nEdge;
			r2.bottom += nBtnHeight + nEdge;
		}
		ii++;
	}
	return nEdge;
}