/*------------------------------------------------------------------------------*
 * File Name: GetNPrewDlg	 													*
 * Creation: CPY 1/12/2006														*
 * Purpose: A General GetN dialog with a Graph Preview tab						*
 * Copyright (c) OriginLab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 2/13/2006 NEW_TREE_CONTROL	                                            *
 * Joe 5/16/2006 SAVE_SMOOTH_DIALOG                                             *
 *	CPY 7/20/06 FFT_FILTERS_ZOOM_RECT_FOR_BETTER_PREVIEW						*
 *	CPY 9/24/06 XF_PREVIEW_DLG_NEED_PREVIEW_ON_THE_SIDE							*
 *	Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG		*
 *	CPY 10/3/04 GRAPH_CNTRL_BASE_CLASS_FOR_EMF									*
 *	CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS						*
 *	CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT			*
 *  Iris 10/31/06 RESIZE_MSG_AND_GRID_BETTER									*
 *	Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS							*
 *	Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY							*
 *	Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME								*
 *	Jasmine 02/14/07 NOCLICK_ON_LABEL_BUTTONS									*
 *	Hong 03/27/07 v8.0590 GET_FIXED_POSTION_BY_PUT_IN_ONE_ARRAY					*
 *	Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 *	Jasmine 04/20/07 OPTION_HIDDEN_BUTTON_NOT_IN_CAL							*
 *	Sim 06-22-2007 FIX_BUTTON_ENABLE_ISSUE_ON_INIT_GRAPH_EVENT					*
 *	Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW					*
 *	Sim 06-30-2007 FIX_UPDATE_GRID_HANDLER										*
 *	Sim 06-22-2007 FIX_BUTTON_ENABLE_ISSUE_ON_INIT_GRAPH_EVENT					*
 *	Sim 07-09-2007 UPDATE_GRID_IS_NOT_INIT_GRID									*
 *	Sim 07-09-2007 AUTO_PREVIEW_MECHANISM										*
 *	Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE							*
 *	Sim 07-13-2007 FIX_UPDATE_GRID_WHEN_GRAPH_CHANGE							*
 *	Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON				*
 *	Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF								*
 *	Sim 08-21-2007 LIMIT_MINIMUM_WIDTH_FOR_ALL_BUTTON							*
 *	Jasmine 08/28/07 QA80-10311 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME				*
 *	Sim 10-22-2007 GETN_PREVIEW_FRAMEWORK_DONOT_NEED_TO_DEAL_WITH_LOCALIZATION	*
 *	Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME	*
 *	Folger 01/10/07 FIX_RESIZE_WHEN_SHOW_AND_HIDE_MESSAGE_BAR					*
 *	Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON								*
 *	Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU						*
 *	Kyle 11/10/2008 QA80-12528 HANDLE_STATE_OF_APPLY_BUTTON						*
 *	Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
 *	Kyle 06/26/2009 RESET_THE_BOTTOM_OF_CONTROL_IDC_GRID_TO_ONE_GAP_ABOVE_IDOK	*
 *	Kenny 07/20/2009 QA80-13978 PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG		*
 *	Sim 10-10-2009 QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT	*
 *	YuI 11/06/09 QA70-14501 NODE_EVENTS_NOT_FIRED_ON_INIT_OF_PREVIEW_DIALOG		*
 *	Folger 11/18/09 QA81-14676 GETN_PREVIEW_DIALOG_NOT_RESIZE_WELL_FOR_HINT_TEXT*
 *	Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED					*
 *	Jasmine 08/13/2010 ORG-172-S2 CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL	*
 *	Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING		*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include <Profiler.h>
#define _SHOW_TIME				Profiler junk;
#define PROFILE_HRGLASS			waitCursor junk;

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include <Array.h>


#include "GraphPageControl.h"
#define BASE_WINDOW		MultiPaneDlg
#include	"DynaDlg.h"
#include <ocGDI.h>
#include "GetNPrevwDlg.h"
/// end NEW_TREE_CONTROL

//#define DMSG(_ERROR_STR)	out_str(_ERROR_STR);

#define STR_DLG_NAME	_L("GetNPreview Dialog")

///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
//#define STR_AUTO_PREVIEW_NODE	"AutoPreview"	///Jasmine 08/28/07 QA80-10311 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME	
/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
//#define DS_BIT_AUTO_PREVIEW		0x0001
/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	
static HWND s_hdlg;






#pragma labtalk(2)
// from LabTalk, call this when a line in a graph is moved
// typically, we use wParam = 0 for top, 1 for left, 3 = bottom, and 2 for right
void notify_dlg_on_move_obj(int wParam = 0, int lParam = 0)
{
	Window win(s_hdlg);
	if(win)
	{
		win.PostMessage(WM_USER_ON_MOVE_LINE, wParam, lParam);
	}
}
//----- CPY 7/20/06 FFT_FILTERS_ZOOM_RECT_FOR_BETTER_PREVIEW
// when a Zoom rect is moved in a layer, it can call this function to 
// cause another layer to zoom in
// queue    {x1=v1;y1=v2;x2=v3;y2=v4;}
void notify_dlg_on_zoom_change(int nLayer)
{
	Window win(s_hdlg);
	if(win)
	{
		win.PostMessage(WM_USER_ON_MOVE_LINE, nLayer, 1);
	}
}
//------

bool GetNBoxEx(TreeNode& tr, PGRAPH_FUNC pfn, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent, int nEventID) //=NULL, NULL, NULL, NULL, 0
{
	int nID; 
	///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	/*
	///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME
	//GetNPrevwDlg myDlg(tr, lpcszTitle, lpcszDescription, pfn, nEventID, 0);	
	
	if( (is_xf_gui_getn_tree(tr) && tr.tagName.CompareNoCase(XFGUI_GETN_TAGNAME_NO_THEME) )|| tr.tagName == "GUI")
		nID = IDD_GETN_PREVIEW_THEME;
	else
		nID = IDD_GETN_PREVIEW;	
	*/
	if(!tr)
		return false;
	
	if(is_theme_dialog(tr))
		nID = IDD_GETN_PREVIEW_THEME;
	else
		nID = IDD_GETN_PREVIEW;
	///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	
	GetNPrevwDlg myDlg(nID, tr, lpcszTitle, lpcszDescription, pfn, nEventID, 0);
	///End ADD_NEW_PREVIEW_DLG_NO_THEME
	int nRet = myDlg.DoModalEx(hWndParent);
	if(IDOK == nRet)
	{
		myDlg.UpdateEditTreeNode(tr);
		return true;
	}
	return false;
}

///Sophy 3/29/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
bool GetNPreviewGraph(WndContainer* pwndContainer, GraphPage& gp, Datasheet& ds, int iGraphTab = 0)
{
	GetNPrevwDlg* pPreviewDlg = (GetNPrevwDlg*)pwndContainer;
	if ( NULL == pPreviewDlg )
		return false;
	return pPreviewDlg->GetPreviewGraph(gp, ds, iGraphTab);
}
bool LoadEMF(PictureControl& pict, LPCSTR lpcszEMF, int nDrawMode = PCDM_STRETCH_KEEP_ASPECT_RATIO)
{
	HENHMETAFILE hEMF = load_enhanced_metafile(lpcszEMF);
	if ( !pict || NULL == hEMF )
		return false;
	pict.SetEnhMetaFile(hEMF);
	pict.DrawMode = nDrawMode;	
	pict.SetBackgroundColor(SYSCOLOR_WHITE);
	pict.SetBorderColor(SYSCOLOR_LTGRAY);
	return true;
}
///end FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG

BOOL GetNP()
{
	GETN_TREE(myTree)
	GETN_OPTION_GRIDLINE(flexGridFlatVert) //--- 1. divider line
	
	GETN_COMBO(numExp, "Number of Terms", 1, "1|2|3")
	//GETN_READ_ONLY
	
	GETN_BEGIN_BRANCH(DecayTime, "Decay Times")
	   GETN_OPTION_BRANCH(GETNBRANCH_OPEN | GETNBRANCH_KEEP_SIZE_ON_COLLAPSE) //--- 3. Set branch options
	   GETN_NUM(decayT1, "1st Decay Time (t1)", 0.0)
	   GETN_NUM(decayT2, "2nd Decay Time (t2)", 0.0)
	   GETN_OPTION_COLOR_LABEL(COLOR_ORANGE) //--- 2. color label
	//	GETN_READ_ONLY
	  GETN_NUM(decayT3, "3rd Decay Time (t3)", 0.0)
	   GETN_OPTION_COLOR_LABEL(COLOR_RED) //--- 2. color label
	GETN_END_BRANCH(DecayTime)
	
	GETN_BEGIN_BRANCH(settings, "Options")
	   GETN_OPTION_COLOR_LABEL(COLOR_NAVY) //--- 2. color label
	   GETN_OPTION_BRANCH(GETNBRANCH_KEEP_SIZE_ON_EXPAND) //--- 3. Set branch options
	   GETN_NUM(yOffset, "Y Offset", 0.0)
	   
	   GETN_CHECK(yOffsetVary,"Vary Y Offset", true)            
	   GETN_CHECK(usexOffset,"Use X Offset", false)
	   GETN_BEGIN_BRANCH(xOffset, "Time offsets")
	       GETN_NUM(xOffsetValue, "X Offset", 0.0)
	       GETN_CHECK(xOffsetVary,"Vary X Offset", true)
	   GETN_END_BRANCH(xOffset)
	GETN_END_BRANCH(settings)
	
	
	GETN_CHECK(PartialRange, "Fit Partial Data", false)
	
	GETN_BUTTON(Path, "File path", "c:\\")
	GETN_STR(Path2, "Path2", "")
	
	GETN_COLOR(FitCurveColor, "Fit Curve color", 1)
	
	if(GetNBoxEx(myTree, NULL, "Title", "descr", GetWindow(), 0))
		out_tree(myTree);
	
	return true;
}


//CPY 9/24/06 XF_PREVIEW_DLG_NEED_PREVIEW_ON_THE_SIDE, added true for bPreviewOnRight
///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME
//GetNPrevwDlg::GetNPrevwDlg(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfn, int nEventID, DWORD dwOptions)
//: DynaDlg(tr, "Odlg8", true)
GetNPrevwDlg::GetNPrevwDlg(int nDlgID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfn, int nEventID, DWORD dwOptions)
: DynaDlg(nDlgID, tr, "Odlg8", true)
///End ADD_NEW_PREVIEW_DLG_NO_THEME
{
	m_nDlgID = nDlgID;		//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	m_strTitle = lpcszTitle;
	m_strDescription = lpcszDescription;
	
	m_nGetNDlgType = nEventID;
	m_dwCntrl = 0;
	m_pGraphFunc = pfn;
	
	m_nActiveTab = 0;	///Sophy 7/13/2012 ORG-6207-S2 GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
	
	m_bAutoPreview = false; ///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
	///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	m_bUpdateGraph = false; ///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
}

/// TD 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
BOOL GetNPrevwDlg::OnInitSize(int &left, int &top, int &right, int  &bottom)
{
	return FALSE;
}
BOOL GetNPrevwDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	///Joseph 03/07/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	//replace with center function
	/*
	string strClassOption;
	theme_get_class_option(GetTree(), strClassOption);
	string strDlgName = STR_DLG_NAME + STR_DLG_NAME_SEPERATOR + strClassOption;
	lstrcpyn(pSz->szDialogName, strDlgName, MAXLINE);
	*/
	string strDlgName = getDlgName(STR_DLG_NAME);
	lstrcpyn(pSz->szDialogName, strDlgName, MAXLINE);
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	SIZE sz;
	GetDlgOptimalSize(sz);
	
	///Joseph 02/15/07 ROLL_BRAK_TO_TD_DESIGN
	//pSz->top = -sz.cy/2;
	//pSz->left = - sz.cx/2;
	pSz->top = -1;
	pSz->left =-1;
	///End ROLL_BRAK_TO_TD_DESIGN

	pSz->width = sz.cx;
	pSz->height = sz.cy;
	
	///Joseph 03/07/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	if(0 == HasPreviousSize(strDlgName))
	{
		SetBottomPaneHeight(300);
	}
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	return TRUE;
}

//#define SAVING_SPACE_FOR_CUSTOM_BUTTON 30 ///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF

bool GetNPrevwDlg::GetDlgOptimalSize(SIZE& sz)
{
	Control ctrlCombo = GetItem(IDC_THEME_COMB);
	Control ctrlText = GetItem(IDC_PARAMS_DESCRIPTION);
	Control ctrlOKButton = GetItem(IDOK);
	Control ctrlCancelButton = GetItem(IDCANCEL); ///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF
	Control ctrlShowPreviewButton = GetItem(IDC_SHOW_BOTTOM); ///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF
	
	RECT rCombo, rText, rOKButton;
	RECT rCancelButton; ///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF
	RECT rShowPreviewButton; ///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF
	GetClientRect(ctrlCombo, rCombo);
	///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF
	//GetClientRect(ctrlCombo, rText);
	//GetClientRect(ctrlCombo, rOKButton);	
	GetClientRect(ctrlText, rText);
	GetClientRect(ctrlOKButton, rOKButton);	
	///---END QA-10258 FIX_SIZE_OF_PREVIEW_XF
	GetClientRect(ctrlCancelButton, rCancelButton); ///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF
	GetClientRect(ctrlShowPreviewButton, rShowPreviewButton); ///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF
	bool bPreviewOnRight = GetPreviewOnRight();
	
	///------ Folger 11/18/09 QA81-14676 GETN_PREVIEW_DIALOG_NOT_RESIZE_WELL_FOR_HINT_TEXT
	//TREE_CTRL_VAR.GetOptimalSize(sz);
	DynaCntrlGetOptimalSizeHelper	clHelper(TREE_CTRL_VAR);
	clHelper.GetOptimalSize(sz);
	///------ End GETN_PREVIEW_DIALOG_NOT_RESIZE_WELL_FOR_HINT_TEXT
	
	int nEdge = GetControlGap();
	int nGridx, nGridy;
	///Joseph 03/13/07 ADJUST_PREVIEWDLG_SIZE_OPTIMAL_SIZE_TOO_SMALL
	//hard code, Adjust the size.
	//nGridx = sz.cx + 2 * nEdge; 
	//nGridy = sz.cy + 5 * nEdge;
	nGridx = sz.cx + 2 * nEdge + 100;
	nGridy = sz.cy + 5 * nEdge + 100;
	///End ADJUST_PREVIEWDLG_SIZE_OPTIMAL_SIZE_TOO_SMALL
	
	///---Sim 08-17-2007 QA-10258 FIX_SIZE_OF_PREVIEW_XF
	/*
	///Joseph 04/11/07 SET_PREVIEW_DLG_MIN_SIZE
	int nCustomVisibleCount = 1; 
	
	if(GetItem(IDOK).Visible)
		nCustomVisibleCount++ ;
		
	for(int ii = 1, jj = IDC_GETN_CUSTOM_BTN1; ii <= CUSTOM_BUTTONS_COUNT; ii++, jj++)
	{
		Control btn = GetItem(jj);
		
		if(btn.Visible)
			 nCustomVisibleCount++;
	}
	
	int nTotalButtonWidth = nCustomVisibleCount * (rOKButton.right - rOKButton.left + nEdge);
	
	if(nGridx < nTotalButtonWidth)
		nGridx = nTotalButtonWidth;
	///End SET_PREVIEW_DLG_MIN_SIZE
	*/
	int nTotalButtonWidth = 0;
	
	nTotalButtonWidth += RECT_WIDTH(rShowPreviewButton);
	
	nTotalButtonWidth += 2*nEdge + RECT_WIDTH(rCancelButton);
	
	if(ctrlOKButton.Visible)
		nTotalButtonWidth += 2*nEdge + RECT_WIDTH(rOKButton);

	/// Kenny 07/20/2009 QA80-13978 PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG
#ifdef __PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG
	Control ctrlApply = GetItem(IDC_APPLY);
	Control ctrlPreviewBtn = GetItem(IDC_GETN_PREVIEW_BTN);
	Control ctrlAutoPreviewBtn = GetItem(IDC_GETN_AUTO_PREVIEW_BTN);
	RECT rectTmp;
	if(ctrlApply.Visible)
	{
		GetClientRect(ctrlApply, rectTmp);
		nTotalButtonWidth += 2*nEdge + RECT_WIDTH(rectTmp);
	}
	if(ctrlPreviewBtn.Visible)
	{
		GetClientRect(ctrlPreviewBtn, rectTmp);
		nTotalButtonWidth += 2*nEdge + RECT_WIDTH(rectTmp);
	}
	if(ctrlAutoPreviewBtn.Visible)
	{
		GetClientRect(ctrlAutoPreviewBtn, rectTmp);
		nTotalButtonWidth += 2*nEdge + RECT_WIDTH(rectTmp);
	}
#endif // __PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG
	/// End QA80-13978 PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG
	
	for(int ii = 1, jj = IDC_GETN_CUSTOM_BTN1; ii <= CUSTOM_BUTTONS_COUNT; ii++, jj++)
	{
		Control btn = GetItem(jj);
		RECT rr;
		GetClientRect(btn, rr);
		
		if(btn.Visible)
			 nTotalButtonWidth += 2*nEdge + RECT_WIDTH(rr);
	}
	
	//if(nGridx < nTotalButtonWidth + SAVING_SPACE_FOR_CUSTOM_BUTTON )
		//nGridx = nTotalButtonWidth + SAVING_SPACE_FOR_CUSTOM_BUTTON;
	if(nGridx < nTotalButtonWidth )
		nGridx = nTotalButtonWidth;
	///---END QA-10258 FIX_SIZE_OF_PREVIEW_XF
	
	nGridy = nGridy + RECT_HEIGHT(rCombo) + RECT_HEIGHT(rText) + RECT_HEIGHT(rOKButton);
	
	///---Sim 08-21-2007 LIMIT_MINIMUM_WIDTH_FOR_ALL_BUTTON
	if ( nTotalButtonWidth > sz.cx )
		m_nMinWidth = nTotalButtonWidth;
	else
	///---END LIMIT_MINIMUM_WIDTH_FOR_ALL_BUTTON
		m_nMinWidth = sz.cx;		///Joseph 04/11/07 SET_PREVIEW_DLG_MIN_SIZE
	if(bPreviewOnRight)
	{
		nGridx = nGridx + 2 * nEdge + 300;
		
	}
	else
	{
		nGridy = nGridy + 300 + 2 * nEdge;
	}
	sz.cx = nGridx;
	sz.cy = nGridy;
	///Joseph 03/07/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	//SetBottomPaneHeight(300);	
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	return true;
}
//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
/*
///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
BOOL GetNPrevwDlg::OnClickCustomButtom1(Control ctrl)
{
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_CUSTOM_BUTTON1);
	return TRUE;
}
BOOL GetNPrevwDlg::OnClickCustomButtom2(Control ctrl)
{
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_CUSTOM_BUTTON2);
	return TRUE;
}
BOOL GetNPrevwDlg::OnClickCustomButtom3(Control ctrl)
{
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_CUSTOM_BUTTON3);
	return TRUE;
}
///End GETN_PREVIEW_DLG_NEED_MORE_BTNS
*/
BOOL GetNPrevwDlg::OnClickCustomButton(int nID)
{
	if(nID >= IDC_GETN_CUSTOM_BTN1 && nID <= IDC_GETN_CUSTOM_BTN4)
	{
		int nn = nID - IDC_GETN_CUSTOM_BTN1 + 1;// CUSTOM_BUTTON = 1,2,3,4
		DWORD dw = CUSTOM_BUTTON_TO_GETN_EVENT(nn);
		invokeHandlers(-1, -1, -1, dw);
	}
	else
		out_int("Invalid button id for custom button: ", nID);
	return TRUE;
}
//--------- end ADDING_CUSTOM_BUTTON4

int GetNPrevwDlg::DoModalEx(HWND hParent)
{	
	InitMsgMap();// will be called from internal later
	
	int nRet = DynaDlg::DoModal(hParent);
	if(nRet != IDCANCEL)
	{
		UpdateInputTree();			
	}
	return nRet;
}

///Sophy 3/29/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
BOOL	GetNPrevwDlg::GetPreviewGraph(GraphPage& gp, Datasheet& dsht, int iGraphTab)
{
	int nEMFPos = XFGSETUP_EMF_POS(m_dwCntrl);
	if ( nEMFPos > 0 ) //there exist EMF preview control
	{
		if ( iGraphTab >= nEMFPos - 1)
			iGraphTab++; //skip EMF control
	}
	if ( iGraphTab >= m_arrGraph.GetSize() )
		return FALSE;
	DialogViewControl& prevCtrl = m_arrGraph.GetAt(iGraphTab);
	gp = prevCtrl.GetPage();
	dsht = prevCtrl.GetWorksheet();
	return gp.IsValid() && dsht.IsValid();
}
///end FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG


BOOL GetNPrevwDlg::OnInitDialog()
{
	PROFILE_HRGLASS
	
	//show_time("enter GetNPrevwDlg::OnInitDialog");//---- CPY 4/23/07 GRAPH_EXPORT_SPEED_TESTING

	vector<string>  vstrTipsUpDown;
	vstrTipsUpDown.SetSize(2);
	vstrTipsUpDown[0] = _L("Show Preview Panel (slower)");//May be time-consuming)");	///Jasmine 05/04/07 by Mike's request
	vstrTipsUpDown[1] = _L("Hide Preview Panel (faster)");//To save time)");
	///Jasmine 10/19/07 QA70-10563 TAB_LABEL_LOCALIZATION
	vector<string> vsButtomTab;// = {"Preview", "Control"};
	vsButtomTab.SetSize(2);
	vsButtomTab[0] = _L("Preview");//May be time-consuming)");	///Jasmine 05/04/07 by Mike's request
	vsButtomTab[1] = _L("Control");
	vsButtomTab.Add(_L("Preview2"));	///Sophy 3/29/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	vsButtomTab.Add(_L("Preview3"));		///Sophy 4/17/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	///End TAB_LABEL_LOCALIZATION
	int nBottomPaneDefaultHeight = 300;//---- CPY 9/16/06 BETTER_DEFAULT_GETN_PREVIEW_DLG_SIZE
	///Joseph 03/07/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	//need to save the splitter setting.
	//DynaDlg::OnInitDialog(IDC_GRID, IDC_SHOW_BOTTOM, IDC_GRAPH_TAB, vstrTipsUpDown, STR_DLG_NAME, 0, vsButtomTab, nBottomPaneDefaultHeight );
	DynaDlg::OnInitDialog(IDC_GRID, IDC_SHOW_BOTTOM, IDC_GRAPH_TAB, vstrTipsUpDown, getDlgName(STR_DLG_NAME), 0, vsButtomTab, nBottomPaneDefaultHeight );
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	InitDynaControl(IDC_GRID);
	//---CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
	////--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
	//m_btnErrMessage = GetItem(IDC_ERR_MESSAGE_BOX2);
	//m_btnErrMessage.Text = "";
	//--- 
	
	///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
	m_btnPreview = GetItem(IDC_GETN_PREVIEW_BTN);
	m_chkAutoPreview = GetItem(IDC_GETN_AUTO_PREVIEW_BTN);
	
	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifndef THEME_CONTROL_POPUP_MENU
	//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	if (m_nDlgID == IDD_GETN_PREVIEW_THEME)
	{
	BitmapRadioButton btnSave = GetItem(IDC_SAVE_BTN);
	vector<string> vsTips;
	vsTips.Add(_L("Save theme"));
	btnSave.Init(1, IDB_PAGEXFBAR_SAVE, 16, vsTips);
	
	BitmapRadioButton btnSaveAs = GetItem(IDC_SAVE_AS_BTN);	
	vsTips.RemoveAll();
	vsTips.Add(_L("Save theme as..."));
	btnSaveAs.Init(1, IDB_PAGEXFBAR_SAVEAS, 16, vsTips);
	}
	//--------End USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
#else
	if ( m_nDlgID == IDD_GETN_PREVIEW_THEME )
	{
		BitmapRadioButton btnSaveAs = GetItem(IDC_SAVE_AS_BTN);
		vector<string> vsTips;
		btnSaveAs.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
	}
#endif
	//------ End ADD_THEME_CONTROL_POPUP_MENU
	
	if ( m_btnPreview )
		m_btnPreview.Enable = m_bUpdateGraph;
	if ( m_chkAutoPreview )
		m_chkAutoPreview.Check = m_bAutoPreview;
	
	if ( !(m_dwXFBits & DYNALAYOUT_PREVIEW_BUTTON) )
	{
		//m_bUpdateGraph = false;
		m_bAutoPreview = true;
		if ( m_btnPreview )
		{
			m_btnPreview.Visible = false;
			m_btnPreview.Enable = m_bUpdateGraph;
		}
		if ( m_chkAutoPreview )
		{
			m_chkAutoPreview.Visible = false;
			m_chkAutoPreview.Check = m_bAutoPreview;
		}
	}
	///---END AUTO_PREVIEW_MECHANISM
	///Sophy 3/29/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	//vector<string> vsGraphTemplates = {"Origin", "Origin"};
	//m_vsTabCntrlGraphTemplates = vsGraphTemplates;
	///end FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	SetDialogTitle(m_strTitle);
	
	TreeNode tr = GetTree();
	InitThemeControls(this, tr, IDC_THEME_COMB, IDC_THEME_TEXT, IDC_SAVE_BTN, IDC_SAVE_AS_BTN, IDC_PARAMS_DESCRIPTION, IDC_PARAMS_DESCRIPTION_LABEL);//------ CPY 5/20/06 THEME_COMBO_IN_BASE_CLASS
	//--- CPY 5/20/06 CHANGE_GETN_PREVIEW_TO_DATASHEET_FROM_WKSHEET
	DWORD dw = 	invokeHandlers(-1, -1, -1, GETNEVENT_ON_SETUP);
	m_dwCntrl = dw; //----- CPY 10/3/04 GRAPH_CNTRL_BASE_CLASS_FOR_EMF
	//---
	///Sophy 7/13/2012 ORG-6207-S2 GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
	LoadSettings();
	///end GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
	ShowCustomButton();
	initGraphTabs();
	initAllEvents();
	updateGrid(false);// on Init
	///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG	
	LoadBranchSetting();
	UpdateDlgSize();
	///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	SetInitReady();
		
	s_hdlg = GetSafeHwnd();
	/// Iris 02/06/2007 v8.0556 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	Page pg = Project.Pages();
	PostMessageOnObjectChange(true, pg);
	///end CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	///---Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
	if ( DYNALAYOUT_NOT_CLOSE_ON_ENTER_KEY & m_dwXFBits )
		SetDefaultButton(FALSE);
	///---END QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
	//show_time("exit GetNPrevwDlg::OnInitDialog");//---- CPY 4/23/07 GRAPH_EXPORT_SPEED_TESTING
	return true;
}

/// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
//DialogViewControl& GetNPrevwDlg::getGraph(int nGraph)
DialogViewControl& GetNPrevwDlg::getGraph(int nGraph, bool *pbOK)
{
	nGraph = 0;
	if(m_dwCntrl & XFGSETUP_EMF_1ST)
	{
		if(m_dwCntrl & XFGSETUP_2_TABS)
			nGraph = 1;
		else
		{
			if(pbOK) *pbOK = false; /// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
			return NULL;
		}
	}
	if(pbOK) *pbOK = true; /// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
	return m_arrGraph.GetAt(nGraph);
}

PictureControl&		GetNPrevwDlg::getPict()
{
	int nn = 0;
	if(!(m_dwCntrl & XFGSETUP_EMF_1ST))
	{
		if(!(m_dwCntrl & XFGSETUP_2_TABS))
			return NULL;
		if(m_dwCntrl & XFGSETUP_EMF_2ND)
			nn = 1;// do not support both tabs as EMF, so 1st has higher priority
		else
			return NULL;
	}
	EMFViewControl& dlgVCntrl = (EMFViewControl&)m_arrGraph.GetAt(nn);
	if(dlgVCntrl!=NULL)
	{
		PictureControl* pPict = dlgVCntrl.GetPictPtr();
		return *pPict;
	}
	
	return NULL;
}

BOOL GetNPrevwDlg::OnDestroy()
{
	///DG 6/6/05 EVENT_FROM_OBJECT
	s_hdlg = NULL;
	///end EVENT_FROM_OBJECT
	///Sophy 7/13/2012 ORG-6207-S2 GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
	SaveSettings();
	///end GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
	/// ML 2/13/2006 NEW_TREE_CONTROL
	//return TreeEditDlg::OnDestroy();
	return DynaDlg::OnDestroy();
	/// end NEW_TREE_CONTROL
}

///Sophy 7/13/2012 ORG-6207-S2 GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
#define	STR_ACTIVETAB_KEY	"ActiveTab"
BOOL	GetNPrevwDlg::LoadSettings()
{
	m_nActiveTab = LoadSetting(STR_ACTIVETAB_KEY, 0);
	return TRUE;
}
BOOL	GetNPrevwDlg::SaveSettings()
{
	if ( O_QUERY_BOOL(m_dwCntrl, XFGSETUP_REMEMBER_ACTIVE_TAB) )
		SaveSetting(STR_ACTIVETAB_KEY, m_nActiveTab);
	return TRUE;
}
///end GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
BOOL GetNPrevwDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;
	///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
	MoveControlsHelper	_temp(this);		
	_temp.Exclude(IDC_GRID);
	///End DLG_RESIZE_PAINT_MESS
	///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
	//uint nButtonIDs[] = {IDCANCEL, IDOK, 0};
	/// Hong 03/27/07 v8.0590 GET_FIXED_POSTION_BY_PUT_IN_ONE_ARRAY
	/*
	vector<uint> vnBtns = {IDCANCEL};
	vector<uint> nCustomBtns = {IDOK, IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4, 0};
	for(int ii = 0; nCustomBtns[ii] !=0; ii++)
	{
		if(GetItem(nCustomBtns[ii]).Visible)
			vnBtns.InsertAt(1, nCustomBtns[ii]);//btn1, btn2,...,cancel
		else
			continue;
	}
	//if(vnBtns.GetSize() > 1)//some custom buttons are used
		//vnBtns.Add(0);
	//else
	//{
		//vnBtns.Add(IDOK);
		vnBtns.Add(0);
	//}
	*/
	///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
	//vector<uint> vnBtns = {IDCANCEL, IDOK, IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4, 0};
	/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	//	vector<uint> vnBtns = {IDCANCEL, IDOK, IDC_GETN_PREVIEW_BTN, IDC_GETN_AUTO_PREVIEW_BTN, IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4, 0};
#ifndef __PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG	/// Kenny 07/20/2009 QA80-13978 PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG
	vector<uint> vnBtns = {IDCANCEL, IDOK, IDC_APPLY, IDC_GETN_PREVIEW_BTN, IDC_GETN_AUTO_PREVIEW_BTN, IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4, 0};
	/// Kenny 07/20/2009 QA80-13978 PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG
#else
	vector<uint> vnBtns = {IDCANCEL, IDOK, IDC_APPLY, IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4, IDC_GETN_PREVIEW_BTN, IDC_GETN_AUTO_PREVIEW_BTN, 0};
#endif
	///End QA80-13978 PUT_PREVIEW_BTN_ON_THE_LEFTMOST_OF_GETN_DLG
	/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	///---END AUTO_PREVIEW_MECHANISM
	/// end GET_FIXED_POSTION_BY_PUT_IN_ONE_ARRAY
	///Jasmine 04/20/07 OPTION_HIDDEN_BUTTON_NOT_IN_CAL
	//MultiPaneDlg::OnDlgResize(vnBtns, cx, cy, false);//nButtonIDs
	MultiPaneDlg::OnDlgResize(vnBtns, cx, cy, false, -1, -1, false);
	///End OPTION_HIDDEN_BUTTON_NOT_IN_CAL
	///End GETN_PREVIEW_DLG_NEED_MORE_BTNS
	resizeTopPaneControl();	///DG 5/24/05
	//if(IsBottomPaneShown())
	//	updateBottomTabSize();
	return TRUE;
}
/*
BOOL GetNPrevwDlg::OnShowBottomPane(Control cntrl)
{
	MultiPaneDlg::OnShowBottomPane(cntrl);
	updateShowBottomPane();
	return true;
}
*/
BOOL GetNPrevwDlg::OnCancel()
{
	Page pg = Project.Pages();
	if(pg)
		PostMessageOnObjectChange(false, pg);
	return true;
}

//virtual 
void GetNPrevwDlg::ResizeDlgControls()//CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT	
{
	 //OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
	resizeTopPaneControl();
}


void GetNPrevwDlg::OnAfterValueChange(int nRow, int nCol)
{
	PROFILE_HRGLASS	//will be slow if big data is used
	
	/// ML 2/13/2006 NEW_TREE_CONTROL
	//TreeNode trNode = m_treeEditCntrl.GetTreeNode(nRow);
	TreeNode trNode = TREE_CTRL_VAR.GetTreeNode(nRow);
	/// end NEW_TREE_CONTROL
	if(!trNode)
	{
		error_report("Get Edit TreeNode fail");
		return;
	}
	
//	int nNodeID = trNode.DataID;
	invokeHandlers(nRow, nCol, -1, 0);

}

//vritaul
void GetNPrevwDlg::OnChangeTheme(const string& strSel, TreeNode& tr)
{
	//----- CPY 7/26/06 THEME_CHANGE_BREAK_SMOOTH
	//initAllEvents();
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_THEME);
	//-----
}

PGRAPH_FUNC GetNPrevwDlg::getGraphHandler()
{
	return m_pGraphFunc;
}

///---Sim 10-10-2009 QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT
//virtual 
void GetNPrevwDlg::InvokeGlobalEventOnInitDialog()
{
	m_DynaCntrl.InvokeHandlers(GETNEVENT_ON_OC_SPECIFY);   /// AW 05/23/07 QA80-9821 v8.0622 SUPPORT_GETN_OC_EVENT
}
///---END QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT
//---- CPY 10/24/06 XF_DLG_DESTROY_EVENT
//virtual 
void GetNPrevwDlg::InvokeHandlerOnDestroy()
{
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_DESTROY);
}
//----

void GetNPrevwDlg::initAllEvents()
{
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_INIT);
	
	///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
	if (m_bAutoPreview && m_btnPreview.Enable )
	{
		invokeHandlers(-1, -1, -1, GETNEVENT_UPDATE_GRAPH);
	}
	///---END AUTO_PREVIEW_MECHANISM
}

///---Sim 06-22-2007 FIX_BUTTON_ENABLE_ISSUE_ON_INIT_GRAPH_EVENT
static int _combine_setting(int nLast, int nCurrent, int nOneTurnOffMask)
{
	int nRet = 0;
	nRet |= (nLast & nOneTurnOffMask ) & ( nCurrent & nOneTurnOffMask ); // turn off if anyone of they did
	nRet |= (nLast & ~nOneTurnOffMask ) | ( nCurrent & ~nOneTurnOffMask ); // turn on if anyone of they did
	return nRet;
}
///---END FIX_BUTTON_ENABLE_ISSUE_ON_INIT_GRAPH_EVENT

int GetNPrevwDlg::invokeHandlers(int nRow, int nCol, int nCntrlType, DWORD nEventInfo)
{
	TreeNode trNode;
	if(nRow >= 0 && nCol >= 0)
		/// ML 2/13/2006 NEW_TREE_CONTROL
		//trNode = m_treeEditCntrl.GetTreeNode(nRow, nCol);
		trNode = TREE_CTRL_VAR.GetTreeNode(nRow, nCol);
		/// end NEW_TREE_CONTROL

	///---Sim 07-13-2007 FIX_UPDATE_GRID_WHEN_GRAPH_CHANGE
	//int nUpdate = 0;
	bool bUpdate = false;
	///---END FIX_UPDATE_GRID_WHEN_GRAPH_CHANGE
	
	bool	bReset = false;	///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
	
	TreeNode tr = GetTree();
	PGRAPH_FUNC pViewfn = getGraphHandler();
	if(pViewfn)
	{
		//--- CPY 5/20/06 CHANGE_GETN_PREVIEW_TO_DATASHEET_FROM_WKSHEET
		//--- CPY 8/15/06 CHENEY_EMAIL_ABOUT_SMOOTH_FFT_FILTER_UPDATE_BUGS
		//if(GETNEVENT_ON_SETUP & nEventInfo)
		int nEvenType = (nEventInfo & GETNEVENT_ON_ANY);
		if(GETNEVENT_ON_SETUP == nEvenType)
		//---
		{
			return pViewfn(tr, nRow, nCol, trNode, nEventInfo, nCntrlType, *this, NULL, NULL, NULL); 
		}
		//---
		/// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
		//DialogViewControl& graphPreview = getGraph(0);
		//int nRet = pViewfn(tr, nRow, nCol, trNode, nEventInfo, nCntrlType, *this, graphPreview.GetPage(), graphPreview.GetWorksheet(), getPict()); // grid event
		bool	bOK;
		DialogViewControl& graphPreview = getGraph(0, &bOK);
		GraphPage 	pg;
		Datasheet	dSheet;
		if(bOK)
		{
			pg = graphPreview.GetPage();
			dSheet = graphPreview.GetWorksheet();
		}
		int nRet = pViewfn(tr, nRow, nCol, trNode, nEventInfo, nCntrlType, *this, pg, dSheet, getPict()); // grid event
		///end REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
		
		///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
		if ( GETNEVENT_UPDATE_GRAPH & nEventInfo ) // equal to click preview button
			//enablePreviewButton(false);
			m_bUpdateGraph = false;
		///---END AUTO_PREVIEW_MECHANISM
		///---Sim 06-30-2007 FIX_UPDATE_GRID_HANDLER
		//if(nRet & GETNGEVT_GRID_NEED_UPDATE)
			//nUpdate += 1;
		///---END FIX_UPDATE_GRID_HANDLER
		///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		//if ( nRet & GETNGEVT_GRAPH_ERROR ) // setting error, force close preview button
			//enablePreviewButton(false);
		///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		// Sim 07-10-2007 GETNEVENT_UPDATE_GUI_TREE is not useful, it is strange logic. No reason for update graph when update gui tree.
		///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
		if ( nRet & GETNGEVT_GRAPH_NEED_UPDATE )
			//enablePreviewButton(true);
			m_bUpdateGraph = true;
			
		if ( nRet & GETNGEVT_GRAPH_ERROR ) 
		{
			enablePreviewButton(false); // setting error, force close preview button
		}
		else
		{
			
			//if((nRet & GETNGEVT_GRAPH_NEED_UPDATE) || (GETNEVENT_ON_INIT == nEvenType) || (GETNEVENT_UPDATE_GUI_TREE & nEventInfo))
			//if( ((nRet & GETNGEVT_GRAPH_NEED_UPDATE) && m_bAutoPreview) || (GETNEVENT_ON_INIT == nEvenType) || ((GETNEVENT_UPDATE_GUI_TREE & nEventInfo) && m_bAutoPreview))
			if( (m_bUpdateGraph && m_bAutoPreview) || (GETNEVENT_ON_INIT == nEvenType) || ((GETNEVENT_UPDATE_GUI_TREE & nEventInfo) && m_bAutoPreview))
		///---END AUTO_PREVIEW_MECHANISM
			{
				///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
				//if(nRet & GETNGEVT_GRAPH_NEED_UPDATE) 
				if ( m_bUpdateGraph )
				///---END AUTO_PREVIEW_MECHANISM
				{
					nEventInfo &=~GETNEVENT_UPDATE_GUI_TREE;
				}
				if(!(GETNEVENT_UPDATE_GUI_TREE & nEventInfo)) // Sim 07-10-2007 GETNEVENT_UPDATE_GUI_TREE means the change from graph, avoid to update graph twice
				{
					try //CPY 5/5/06 smooth -d from graph shows dialog messed up, added try catch
					{
						///---Sim 06-22-2007 FIX_BUTTON_ENABLE_ISSUE_ON_INIT_GRAPH_EVENT
						//pViewfn(tr, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, graphPreview.GetPage(), graphPreview.GetWorksheet(), getPict());
						///---Sim 07-02-2007 FIX_BUTTON_ENABLE_VALUE_BETWEEN_EVENT_HANDLE
						//nRet = pViewfn(tr, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, graphPreview.GetPage(), graphPreview.GetWorksheet(), getPict());
						/// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
						//int nCurRet = pViewfn(tr, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, graphPreview.GetPage(), graphPreview.GetWorksheet(), getPict());
						int nCurRet = pViewfn(tr, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, pg, dSheet, getPict());
						///end REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
						nRet = _combine_setting(nRet, nCurRet, GETNGEVT_ENABLE_ALL_BUTTONS);
						///---END FIX_BUTTON_ENABLE_VALUE_BETWEEN_EVENT_HANDLE
						///---END FIX_BUTTON_ENABLE_ISSUE_ON_INIT_GRAPH_EVENT
					}
					catch(int nErr)
					{
						out_int("GetNPrevwDlg::invokeHandlers event throw exception = ", nErr);
					}
					///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
					if ( GETNEVENT_ON_INIT != nEvenType )
						//enablePreviewButton(false);
						m_bUpdateGraph = false;
					///---END AUTO_PREVIEW_MECHANISM
				}
			}
		///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
			enablePreviewButton(m_bUpdateGraph);
		}
		///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		
		///---Sim 10-22-2007 GETN_PREVIEW_FRAMEWORK_DONOT_NEED_TO_DEAL_WITH_LOCALIZATION
		/*
		///Cheney 2007-8-27 ADD_HINTS_AND_LOCALIZE_NONEPREVIEW_TEMPLATE
		//if select none preview at first, then check AutoPreview check box,
		//m_bUpdateGraph == false, so I add code here 
		/// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
		//if(is_nonepreview_template(graphPreview.GetPage()))
		//	bool bRet = load_text_for_nonepreview_graphpage(graphPreview.GetPage(), TEMPLATE_NONE_PREVIEW_CONTENT, TEMPLATE_NONE_PREVIEW_HINTS); 
		if(is_nonepreview_template(pg))
			bool bRet = load_text_for_nonepreview_graphpage(pg, TEMPLATE_NONE_PREVIEW_CONTENT, TEMPLATE_NONE_PREVIEW_HINTS); 
		///end REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
		///end ADD_HINTS_AND_LOCALIZE_NONEPREVIEW_TEMPLATE
		*/
		///---END GETN_PREVIEW_FRAMEWORK_DONOT_NEED_TO_DEAL_WITH_LOCALIZATION
		
		///---Sim 07-13-2007 FIX_UPDATE_GRID_WHEN_GRAPH_CHANGE
		if(nRet & GETNGEVT_GRID_NEED_UPDATE)
			bUpdate = true;
		///---END FIX_UPDATE_GRID_WHEN_GRAPH_CHANGE
		
		///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		if ( GETNGEVT_GRID_NEED_RESET & nRet )
		{
			bUpdate = bReset = true;
		}
		///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		
		///---Sim 07-09-2007 UPDATE_GRID_IS_NOT_INIT_GRID
		// need add OnUpdateGrid event in xfunction with preview dialog.
		/*
		///---Sim 06-30-2007 FIX_UPDATE_GRID_HANDLER
		if(nRet & GETNGEVT_GRID_NEED_UPDATE)
			nUpdate += 1;
		if ( nUpdate )
		{
			DWORD dwEventInfo = nEventInfo;
			dwEventInfo &= ~GETNEVENT_ON_ANY; // clear event info
			dwEventInfo |= GETNEVENT_ON_INIT; // set init event, for update grid
			try //CPY 5/5/06 smooth -d from graph shows dialog messed up, added try catch
			{
				///---Sim 07-02-2007 FIX_BUTTON_ENABLE_VALUE_BETWEEN_EVENT_HANDLE
				//nRet = pViewfn(tr, nRow, nCol, trNode, dwEventInfo, nCntrlType, *this, graphPreview.GetPage(), graphPreview.GetWorksheet(), getPict());
				int nCurRet = pViewfn(tr, nRow, nCol, trNode, dwEventInfo, nCntrlType, *this, graphPreview.GetPage(), graphPreview.GetWorksheet(), getPict());
				nRet = _combine_setting(nRet, nCurRet, GETNGEVT_ENABLE_ALL_BUTTONS);
				///---END FIX_BUTTON_ENABLE_VALUE_BETWEEN_EVENT_HANDLE
			}
			catch(int nErr)
			{
				out_int("GetNPrevwDlg::invokeHandlers event throw exception = ", nErr);
			}
		}
		///---END FIX_UPDATE_GRID_HANDLER
		*/
		///---END UPDATE_GRID_IS_NOT_INIT_GRID
		
		///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
		if ( !(GETNEVENT_UPDATE_GRAPH & nEventInfo) )
		{
		///---END AUTO_PREVIEW_MECHANISM
			//--- CPY 7/2/2006 QA70-8798 OK_BUTTON_DISABLED_BY_EVENT
			Control ctlOKButton = GetItem(IDOK);
			if(ctlOKButton)
				ctlOKButton.Enable = (nRet & GETNGEVT_OK_ENABLE)? true:false;
			///Kyle 11/10/2008 QA80-12528 HANDLE_STATE_OF_APPLY_BUTTON
			Control ctlApplyButton = GetItem(IDC_APPLY);								// Apply button should be disabled when OK button is disabled, 
			if(ctlApplyButton)															// and while OK button is changed to enabled, also the apply button should be enabled
				ctlApplyButton.Enable = (nRet & GETNGEVT_OK_ENABLE)? true:false;
			///End HANDLE_STATE_OF_APPLY_BUTTON
			
			//---
			//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
			/////Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
			/////Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY
			//ctlOKButton = GetItem(IDC_GETN_CUSTOM_BTN1);
			//if(ctlOKButton)
				//ctlOKButton.Enable = (nRet & GETNGEVT_ENABLE_CUSTOM_BUTTON1)? true:false;
			//ctlOKButton = GetItem(IDC_GETN_CUSTOM_BTN2);
			//if(ctlOKButton)
				//ctlOKButton.Enable = (nRet & GETNGEVT_ENABLE_CUSTOM_BUTTON2)? true:false;
			//ctlOKButton = GetItem(IDC_GETN_CUSTOM_BTN3);
			//if(ctlOKButton)
				//ctlOKButton.Enable = (nRet & GETNGEVT_ENABLE_CUSTOM_BUTTON3)? true:false;
			/////End ENABLE_CUSTOM_BUTTONS_SEPARATELY
			/////End GETN_PREVIEW_DLG_NEED_MORE_BTNS
			EnableCustomButtons(nRet);
			//----------
		///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
		}
		///---END AUTO_PREVIEW_MECHANISM
	}
	///---Sim 07-13-2007 FIX_UPDATE_GRID_WHEN_GRAPH_CHANGE
	//if(nUpdate)
	if(bUpdate)
	///---END FIX_UPDATE_GRID_WHEN_GRAPH_CHANGE
	{
		///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
		//updateGrid(true, true);
		updateGrid(true, true, bReset);
		///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
	}
	return 0;
}


void GetNPrevwDlg::SetDialogTitle(LPCSTR lpcszTitle)
{
	Window wDlg=GetWindow();
	wDlg.Text = lpcszTitle;
}

BOOL GetNPrevwDlg::OnSelectionChange()
{
	/// ML 2/13/2006 NEW_TREE_CONTROL
	//return m_treeEditCntrl.OnSelectionChange();
	return TREE_CTRL_VAR.OnSelectionChange();
	/// end NEW_TREE_CONTROL
}
BOOL GetNPrevwDlg::OnSelectionTrack()
{
	/// ML 2/13/2006 NEW_TREE_CONTROL
	//return m_treeEditCntrl.OnSelectionTrack();
	return TREE_CTRL_VAR.OnSelectionTrack();
	/// end NEW_TREE_CONTROL
}

void GetNPrevwDlg::resizeTopPaneControl()
{
	Control ctrlGrid = GetItem(IDC_GRID);
	RECT rr;
	GetClientRect(ctrlGrid, rr);
	
	int nEdge=GetControlGap(), nx=nEdge, ny=nEdge, cx=rr.right, cy=rr.bottom;
//ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny, cx, IDC_THEME_COMB);
	ny = ResizeThemeControls(nEdge, cx, ny);
	//MoveControl(IDC_THEME_TEXT, nx, cy+nEdge);
	//---- CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT
	/*
	//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
	if(m_btnErrMessage)
	{
		RECT 	rr2;
		m_btnErrMessage.GetWindowRect(&rr2);
		int		nErrMessageHeight = rr2.bottom - rr2.top;
		
		rr.bottom = rr.bottom - nErrMessageHeight - nEdge;
		ctrlGrid.MoveWindow(&rr);
		
		rr2.top = rr.bottom + nEdge;
		rr2.bottom = rr2.top + nErrMessageHeight;
		rr2.left = rr.left;
		rr2.right = rr.right;
		m_btnErrMessage.MoveWindow(&rr2);
	}
	//---
	*/
	int		nErrMessageHeight = GetDlgStatusMsgBoxHeight(RECT_WIDTH(rr));
	rr.top = ny + nEdge;
	///Kyle 06/26/2009 RESET_THE_BOTTOM_OF_CONTROL_IDC_GRID_TO_ONE_GAP_ABOVE_IDOK
	RECT rrOK, rrDlg;
	m_wndDlg.GetClientRect(&rrDlg);
	Control btnOK = GetItem(IDCANCEL);//IDOK);
	GetClientRect(btnOK, rrOK);	
	rr.bottom = rrDlg.bottom - RECT_HEIGHT(rrOK) - 2 * nEdge;
	///End RESET_THE_BOTTOM_OF_CONTROL_IDC_GRID_TO_ONE_GAP_ABOVE_IDOK
	//------ Folger 01/10/07 FIX_RESIZE_WHEN_SHOW_AND_HIDE_MESSAGE_BAR
	//if(nErrMessageHeight)
	if(nErrMessageHeight>0)
	//------
	{
		RECT rr2;
		rr2 = rr;
		rr.bottom = rr.bottom - nErrMessageHeight - nEdge;
		ctrlGrid.MoveWindow(&rr);
		rr2.top = rr.bottom + nEdge;
		m_btnErrMessage.MoveWindow(&rr2);
		m_btnErrMessage.Visible = true;
	}
	else
	{
		//--- Iris 10/31/06 RESIZE_MSG_AND_GRID_BETTER
		///Kyle 06/26/2009 RESET_THE_BOTTOM_OF_CONTROL_IDC_GRID_TO_ONE_GAP_ABOVE_IDOK
		//RECT rrOK, rrDlg;
		//m_wndDlg.GetClientRect(&rrDlg);
		//Control btnOK = GetItem(IDCANCEL);//IDOK);
		//GetClientRect(btnOK, rrOK);	
		//rr.bottom = rrDlg.bottom - RECT_HEIGHT(rrOK) - 2 * nEdge;		
		///End RESET_THE_BOTTOM_OF_CONTROL_IDC_GRID_TO_ONE_GAP_ABOVE_IDOK
		ctrlGrid.MoveWindow(&rr);
		//---
		m_btnErrMessage.Visible = false;
	}
	//------ end DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT
	
}
///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
//void GetNPrevwDlg::updateGrid(bool bOnUpdate , bool bTreeChanged)
//{
	//UpdateDynaControl(true, bOnUpdate? 0:GETNEVENT_ON_INIT, false, bTreeChanged?DYNACONTROL_UPDATE_RECONSTRUCT:0);
//}
void GetNPrevwDlg::updateGrid(bool bOnUpdate , bool bTreeChanged, bool bReset/* = false*/)
{
	/// YuI 11/06/09 QA70-14501 NODE_EVENTS_NOT_FIRED_ON_INIT_OF_PREVIEW_DIALOG
	// if we come here on init dialog BOOL GetNPrevwDlg::OnInitDialog()
	// then (and only then) bOnUpdate will be fallse
	// if this is the case we need to call Node handlers
	// my change will make behaviour of preview dialog consistent with regular GetN dialog
	// please see BOOL DynaBoxDlg::OnInitDialog()
	// there is call to UpdateDynaControl 
	// UpdateDynaControl(true, GETNEVENT_ON_INIT, true); ///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	// notice true as 3rd argument to enforce node level handlers invocation
	
	//	UpdateDynaControl(true, bOnUpdate? (bReset ? GETNEVENT_ON_CHANGE_UPDATE_GUI : 0) : GETNEVENT_ON_INIT, false, bTreeChanged?DYNACONTROL_UPDATE_RECONSTRUCT:0);
	UpdateDynaControl(true, bOnUpdate? (bReset ? GETNEVENT_ON_CHANGE_UPDATE_GUI : 0) : GETNEVENT_ON_INIT, !bOnUpdate, bTreeChanged?DYNACONTROL_UPDATE_RECONSTRUCT:0);
	/// end NODE_EVENTS_NOT_FIRED_ON_INIT_OF_PREVIEW_DIALOG
}
///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED

///jasmine 08/06/10 ORG-389 ADD_MATRIX_IMAGE_PREVIEW
void GetNPrevwDlg::addMatrixControl(int nCntrlID, int nIndex)
{
	MatrixViewControl* pMatrixView = new MatrixViewControl(m_dwCntrl);
	m_arrGraph.Add(*pMatrixView);
	createMatrixControl(pMatrixView, nCntrlID);
	m_vnTabCntrlItemIDs.Add(nCntrlID);
}
///End ADD_MATRIX_IMAGE_PREVIEW

//----- CPY 10/3/04 GRAPH_CNTRL_BASE_CLASS_FOR_EMF
void GetNPrevwDlg::addEMFControl(int nCntrlID, int nIndex)
{
	EMFViewControl* pEMFView = new EMFViewControl(m_dwCntrl);
	m_arrGraph.Add(*pEMFView);
	createEMFControl(pEMFView, nCntrlID);
	m_vnTabCntrlItemIDs.Add(nCntrlID);
}
void GetNPrevwDlg::addGraphControl(int nCntrlID, int nIndex)
{
	GetNPrevwGraphControl*	pGraphPCtrl;
	pGraphPCtrl = new GetNPrevwGraphControl(m_dwCntrl);
	m_arrGraph.Add(*pGraphPCtrl);
	createGraphControl(pGraphPCtrl, nCntrlID, nIndex);
	m_vnTabCntrlItemIDs.Add(nCntrlID);
}
void GetNPrevwDlg::initGraphTabs()
{
	m_arrGraph.SetAsOwner(true);
	uint nTabs = getTabGraphContrlCounts();
	//----- CPY 10/3/04 GRAPH_CNTRL_BASE_CLASS_FOR_EMF
	/*
	GetNPrevwGraphControl*	pGraphPCtrl;
	for(int ii=0; ii< nGraphs; ii++) //
	{
		pGraphPCtrl = new GetNPrevwGraphControl(m_dwCntrl);
		m_arrGraph.Add(*pGraphPCtrl);
		createGraphControl(pGraphPCtrl, ii);
	}
	*/
	if(nTabs < 1) return;
	int ii = 0;
	m_vnTabCntrlItemIDs.SetSize(0);
	///Sophy 3/29/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	/*
	if(m_dwCntrl & XFGSETUP_EMF_1ST)
		addEMFControl(IDC_PICTURE_CNTRL, ii);
	///jasmine 08/06/10 ORG-389 ADD_MATRIX_IMAGE_PREVIEW
	else if(m_dwCntrl & XFGSETUP_MATRIX_CNTRL)
		addMatrixControl(IDC_PICTURE_CNTRL, ii);
	///End ADD_MATRIX_IMAGE_PREVIEW	
	else
		addGraphControl(IDC_GRAPH_PREVIEW, ii);

	ii++;
	if(nTabs > 1)
	{
		if(m_dwCntrl & XFGSETUP_EMF_2ND)
			addEMFControl(IDC_PICTURE_CNTRL, ii);
		else
			addGraphControl((m_dwCntrl & XFGSETUP_EMF_1ST)? IDC_GRAPH_PREVIEW : IDC_GRAPH_CNTRL, ii);
	}
	else
	{
		DeleteBottomTabItem(1);
	}
	*/
	vector<int>	vnPictCtrlIDs = {IDC_PICTURE_CNTRL, 0}; //need 0 to indicate the end
	int iPictCtrlIndex = 0;
	///Sophy 4/17/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	//vector<int> vnGraphCtrlIDs = {IDC_GRAPH_PREVIEW, IDC_GRAPH_CNTRL, 0}
	vector<int> vnGraphCtrlIDs = {IDC_GRAPH_PREVIEW, IDC_GRAPH_CNTRL, IDC_GRAPH_PREVIEW2, 0}
	///end FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	int iGraphCtrlIndex = 0;
	for ( int iTab = 0; iTab < nTabs; iTab++ )
	{
		if ( XFGSETUP_EMF_POS(m_dwCntrl) -1 == iTab && vnPictCtrlIDs[iPictCtrlIndex] != 0 )
		{
			addEMFControl(vnPictCtrlIDs[iPictCtrlIndex++], iTab);
		}
		else if ( XFGSETUP_MATRIX_POS(m_dwCntrl) -1 == iTab && vnPictCtrlIDs[iPictCtrlIndex] != 0 )
		{
			addMatrixControl(vnPictCtrlIDs[iPictCtrlIndex++], iTab);
		}
		else if ( vnGraphCtrlIDs[iGraphCtrlIndex] != 0 )
		{
			addGraphControl(vnGraphCtrlIDs[iGraphCtrlIndex++], iTab);
		}
	}
	int nTotalTabs = m_BottomTab ? m_BottomTab.GetItemCount() : 0;
	while ( nTotalTabs > nTabs )
	{
		DeleteBottomTabItem(nTotalTabs - 1); //remove extra tab from end.
		nTotalTabs--;
	}
	///end FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	///Sophy 4/17/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	//vector<int> vnCntrlList = {IDC_PICTURE_CNTRL, IDC_GRAPH_PREVIEW, IDC_GRAPH_CNTRL};
	vector<int> vnCntrlList = {IDC_PICTURE_CNTRL, IDC_GRAPH_PREVIEW, IDC_GRAPH_CNTRL, IDC_GRAPH_PREVIEW2};
	///end FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
	for(int jj = 0; jj < vnCntrlList.GetSize(); jj++)
	{
		if(find_in_list(vnCntrlList[jj], m_vnTabCntrlItemIDs, false) < 0)
		{
			Control cntrl = GetItem(vnCntrlList[jj]);
			if(cntrl)
				cntrl.Visible = false;
		}
	}
	//------
	///Sophy 7/13/2012 ORG-6207-S2 GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
	if ( O_QUERY_BOOL(m_dwCntrl, XFGSETUP_REMEMBER_ACTIVE_TAB) )
	{
		m_BottomTab.SetCurSel(m_nActiveTab);
	}
	///end GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
}

///jasmine 08/06/10 ORG-389 ADD_MATRIX_IMAGE_PREVIEW
void GetNPrevwDlg::createMatrixControl(MatrixViewControl* pMatrixView, int nCntrlID)
{
	Control cntrl = GetItem(nCntrlID);
	if(cntrl)
	{
		cntrl.Visible = false; // first make invisible to avoid flashing
		HWND hWnd = cntrl.GetSafeHwnd();
		MatrixControl matrixCntrl;
		matrixCntrl.CreateControl(hWnd);
		if(matrixCntrl)
			pMatrixView->Create(matrixCntrl);
	}
}
///End ADD_MATRIX_IMAGE_PREVIEW

//----- CPY 10/3/04 GRAPH_CNTRL_BASE_CLASS_FOR_EMF
void GetNPrevwDlg::createEMFControl(EMFViewControl* pEMFView, int nCntrlID)
{
	Control cntrl = GetItem(nCntrlID);
	if(cntrl)
	{
		cntrl.Visible = false; // first make invisible to avoid flashing
		HWND hWnd = cntrl.GetSafeHwnd();
		PictureControl gcCntrl;
		gcCntrl.CreateControl(hWnd);
		if(gcCntrl)
		{
			pEMFView->Create(gcCntrl);
		}
	}
}
//-----

void GetNPrevwDlg::createGraphControl(GetNPrevwGraphControl* pGraph, int nCntrlID, int nTab)
{
	Control cntrl = GetItem(nCntrlID);
	//DWORD dwNoClicks = NOCLICK_DATA_PLOT | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON | NOCLICK_AXES;	///Jasmine 02/14/07 NOCLICK_ON_LABEL_BUTTONS
	///Jasmine 08/13/2010 ORG-172-S2 CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL
	//DWORD dwNoClicks = NOCLICK_DATA_PLOT | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON | NOCLICK_AXES | NOCLICK_LABEL | NOCLICK_BUTTONS;
	DWORD dwNoClicks = OC_TOOL_NOCLICK | NOCLICK_ZOOMPAN | NOCLICK_LABEL | NOCLICK_BUTTONS;
	///End CENTRALIZE_NOCLICK_BIT_FOR_PREVIEW_IN_OC_TOOL
	if(cntrl)
	{
		cntrl.Visible = false; // first make invisible to avoid flashing
		HWND hWnd = cntrl.GetSafeHwnd();
		GraphControl gcCntrl;
		gcCntrl.CreateControl(hWnd);
		if(gcCntrl)
		{
			///Sophy 3/29/2012 ORG-4118 FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
			//pGraph->Create(gcCntrl,dwNoClicks, m_vsTabCntrlGraphTemplates[nTab]);
			pGraph->Create(gcCntrl,dwNoClicks, "Origin");
			///end FILTERIIR_NEED_SHOW_MORE_TABS_ON_GETNPREVIEW_DIALOG
		}
	}
}
void _show_rect(LPCSTR lpcszStr, RECT& rr)
{
	printf("%s:left=%d,right=%d\ntop=%d,bottom=%d,height=%d\n",lpcszStr, rr.left,rr.right,rr.top,rr.bottom,rr.bottom-rr.top);
}
int GetNPrevwDlg::GetBottomPaneSubControls(vector<uint>& vnCntrls)
{
	//vnCntrls.SetSize(0);
	//vnCntrls.Add(IDC_GRAPH_PREVIEW);
	vnCntrls = m_vnTabCntrlItemIDs;
	return m_BottomTab.GetCurSel();
}

Control& GetNPrevwDlg::getTabGraphContrl(int nShowTab)
{
	Control cntrl;
	int nGraphs = getTabGraphContrlCounts();
	if(0 > nShowTab || nGraphs < nShowTab)
		return cntrl;
	int nID = m_vnTabCntrlItemIDs[nShowTab];
	cntrl = GetItem(nID);
	return cntrl;
}

void GetNPrevwDlg::OnMoveLine(uint wParam, uint lParam)
{
	//----- CPY 7/20/06 FFT_FILTERS_ZOOM_RECT_FOR_BETTER_PREVIEW
	if(lParam == 1)
		updatePreviewOnZoomChange(wParam);
	else
	//-----
	invokeHandlers(-1, -1, -1, GETNEVENT_UPDATE_GUI_TREE);

}


/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
BOOL 	GetNPrevwDlg::OnApplyButton(Control ctrl)
{
	///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
	//return CheckApplyButtonEvent(GetTree(), GETNE_ON_APPLY, 0);
	int nApplyReturn = 0;
	CheckApplyButtonEvent(GetTree(), GETNE_ON_APPLY, 0, "", &nApplyReturn);
	
	bool bRet = (0 == nApplyReturn);

	///Kyle 11/10/2008 QA80-12528 HANDLE_STATE_OF_APPLY_BUTTON
	// only allow to apply once for a specifically setting
	Control ctlApplyButton = GetItem(IDC_APPLY);
	if(ctlApplyButton)
		ctlApplyButton.Enable = false;
	///End HANDLE_STATE_OF_APPLY_BUTTON
	return bRet;
	///---END QA80-11156 XF_PANEL_APPLY_BUTTON
}
/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION

//----- CPY 7/20/06 FFT_FILTERS_ZOOM_RECT_FOR_BETTER_PREVIEW
static double _get_v(int n)
{
	double vv;
	LT_get_var("v" + n, &vv);
	return vv;
}

void GetNPrevwDlg::updatePreviewOnZoomChange(int nLayerToZoom)
{
	/// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
	//DialogViewControl& graphPreview = getGraph(0);
	bool	bOK;
	DialogViewControl& graphPreview = getGraph(0, &bOK);
	if(!bOK)
		return;
	///end REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
	
	GraphPage gp = graphPreview.GetPage();
	if(gp)
	{
		GraphLayer gl = gp.Layers(nLayerToZoom);
		if(gl)
		{
			// zoom rect gr when moved will update LT global variables v1-v4
			//x1=v1;y1=v2;x2=v3;y2=v4;
			Scale xaxis(gl.X);
			xaxis.From = _get_v(1);
			xaxis.To = _get_v(3);
			Scale yaxis(gl.Y);
			yaxis.From = _get_v(2);
			yaxis.To = _get_v(4);
		}
	}
}
//-----

/// Iris 02/06/2007 v8.0556 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
BOOL 	GetNPrevwDlg::InvokeGlobalEventOnGraphObjectChange(uint wParam, uint lParam)
{
	/// Iris 02/16/2007 v8.0564 FIX_AFTER_CALL_USERMSG_FAIL_UPDATE_GUI_TREE
	// Cannot change GUI tree(including add node, add attribute, update attirubte val...) in User Message Event, I did not known why
	//---- Iris 02/26/2007 v8.0570 CORRECT_WRONG_USAGE_ON_GETTREE
	//Tree tr;
	TreeNode tr;
	//----
	tr = GetTree();
	if(tr)
	{
		tr.SetAttribute(STR_GO_MSG_INFO_1_ATTRIB, (int)wParam);
		tr.SetAttribute(STR_GO_MSG_INFO_2_ATTRIB, (int)lParam);
		//---- Iris 02/26/2007 v8.0570 CORRECT_WRONG_USAGE_ON_GETTREE
		//SetInputTree(tr);
		//----
	}
	///end FIX_AFTER_CALL_USERMSG_FAIL_UPDATE_GUI_TREE
	
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_GRAPH_OBJECT);

	return true;
}
/// end CALL_EVENT1_ON_GRAPH_OBJ_MOVING

///---Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW
//virtual
DWORD GetNPrevwDlg::OnExternalMessage(uint wParam, uint lParam)
{
	TreeNode tr = GetTree();
	if(tr)
	{
		tr.SetAttribute(STR_GO_MSG_INFO_1_ATTRIB, (int)wParam);
		tr.SetAttribute(STR_GO_MSG_INFO_2_ATTRIB, (int)lParam);
	}	
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_EXTERNAL_MSG);
	return 0;
}
///---END SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW

///Joseph 03/07/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
//get the class option name, for regesty.
string GetNPrevwDlg::getDlgName(LPCSTR lpcszDlg)
{
	string strDlgName(lpcszDlg);
	string strClassOption;
	theme_get_class_option(GetTree(), strClassOption);
	
	return strDlgName + ":" + strClassOption;
}
///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS


///Joseph 04/11/07 SET_PREVIEW_DLG_MIN_SIZE
/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int	GetNPrevwDlg::GetTotalHeight(bool bMin)
//{
//	return BASE_WINDOW::GetTotalHeight(bMin);
//}
//
//int	GetNPrevwDlg::GetTotalWidth(bool bMin)
int	GetNPrevwDlg::GetMinClientTrackHeight()
{
	return BASE_WINDOW::GetMinClientTrackHeight();
}

int	GetNPrevwDlg::GetMinClientTrackWidth()
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
{
	return m_nMinWidth;
}
///End SET_PREVIEW_DLG_MIN_SIZE

///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
BOOL GetNPrevwDlg::OnPreview(Control ctrl)
{
	//Button btnPreview = ctrl;
	
	invokeHandlers(-1, -1, -1, GETNEVENT_UPDATE_GRAPH);
	//btnPreview.Enable = false;
	
	return TRUE;
}

BOOL GetNPrevwDlg::OnAutoPreview(Control ctrl)
{
	Button chkAutoPreview = ctrl;
	///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	//m_bAutoPreview = chkAutoPreview.Check;
	
	//if (m_bAutoPreview && m_btnPreview.Enable )
	//{
		//invokeHandlers(-1, -1, -1, GETNEVENT_UPDATE_GRAPH);
		////btnPreview.Enable = false;
	//}
	
	//return TRUE;

	bool bAutoPreview = chkAutoPreview.Check;
	TreeNode trGetN = GetTree();
	controlNodeValueAutoPreview(trGetN, bAutoPreview, false); // set value
	
	return SetAutoPreview(bAutoPreview);
	///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME	
}

///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
bool GetNPrevwDlg::SetAutoPreview(bool bAuto) //= true)
{
	m_bAutoPreview = bAuto;
	if (m_bAutoPreview && m_btnPreview.Enable )
	{
		invokeHandlers(-1, -1, -1, GETNEVENT_UPDATE_GRAPH);
	}
	return true;
}
///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME	

void GetNPrevwDlg::enablePreviewButton(bool bEnable) // = true
{
	if (m_btnPreview)
		m_btnPreview.Enable = bEnable;
}
///---END AUTO_PREVIEW_MECHANISM
///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
/*
///Jasmine 08/28/07 QA80-10311 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
BOOL GetNPrevwDlg::OnSaveTheme(Control ctrl)
{
	TreeNode tr = GetTree();
	addAutoPreviewNode(tr);
	BOOL bRet = DynaDlg::OnSaveTheme(ctrl);
	removeAutoPreviewNode(tr);
	return bRet;
}
BOOL GetNPrevwDlg::OnSaveThemeAs(Control ctrl)
{
	TreeNode tr = GetTree();
	addAutoPreviewNode(tr);
	BOOL bRet = DynaDlg::OnSaveThemeAs(ctrl);
	removeAutoPreviewNode(tr);
	return bRet;
}
BOOL GetNPrevwDlg::LoadTheme(TreeNode& trGetN, string strTheme)
{
	addAutoPreviewNode(trGetN, false);
	BOOL bRet = DynaDlg::LoadTheme(trGetN, strTheme);
	TreeNode trAutoPreview = trGetN.GetNode(STR_AUTO_PREVIEW_NODE);
	if(trAutoPreview && (m_dwXFBits & DYNALAYOUT_PREVIEW_BUTTON) && m_chkAutoPreview.Visible)
	{
		m_chkAutoPreview.Check = trAutoPreview.nVal;
		OnAutoPreview(m_chkAutoPreview);
	}
	removeAutoPreviewNode(trGetN);
	return bRet;
}
bool GetNPrevwDlg::addAutoPreviewNode(TreeNode& tr, bool bLoad)//load check state
{
	if(!(m_dwXFBits & DYNALAYOUT_PREVIEW_BUTTON) || !m_chkAutoPreview.Visible)
		return true;			
	TreeNode trAutoPreview = tree_check_get_node(tr, STR_AUTO_PREVIEW_NODE);
	if(!trAutoPreview)
		return false;
	if(bLoad)
		trAutoPreview.nVal = m_bAutoPreview? 1 : 0;
	trAutoPreview.DataID = GET_USER_DATAID(USER_ID_COUNT - 1);
	return true;	
}
bool GetNPrevwDlg::removeAutoPreviewNode(TreeNode& tr)
{
	TreeNode trAutoPreview = tree_check_get_node(tr, STR_AUTO_PREVIEW_NODE);
	if(!trAutoPreview || trAutoPreview.Remove())
		return true;
	return false;
}
///End SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
*/

//virtual 
BOOL GetNPrevwDlg::OnAfterUpdateDynaControl(uint wParam, uint lParam)
{
	//out_str("After Update Dyna");
	if ( isAutoPreviewShowed() )
	{
		TreeNode trGetN = GetTree();
		bool bVal;
		if ( controlNodeValueAutoPreview(trGetN, bVal, true) ) // get value
		{
			m_chkAutoPreview.Check = bVal;
			SetAutoPreview(bVal);
		}
	}
	return true;
}

bool GetNPrevwDlg::controlNodeValueAutoPreview(TreeNode& trGetN, bool& bVal, bool bGetValue)
{
	//TreeNode trDialogSettingParam1 = tree_get_node_by_id(trGetN, IDE_XF_DS_PARAM1, true);
	//TreeNode trDialogSettings = trGetN.GetNode("DialogSettings"); // hard code, because got troubles when searched treenode by small id
	TreeNode trDialogSettings = get_external_settings_branch(trGetN);
	if ( !trDialogSettings )
		return false;
	
	TreeNode trDialogSettingParam1 = tree_get_node_by_id(trDialogSettings, IDE_XF_DS_PARAM1, true);
	if ( !trDialogSettingParam1 )
		return false;
	
	DWORD dw = trDialogSettingParam1.nVal;
	
	if ( bGetValue )
	{
		if (dw & DS_BIT_AUTO_PREVIEW)
			bVal = true;
		else
			bVal = false;
	}
	else
	{
		if ( bVal )
			dw |= DS_BIT_AUTO_PREVIEW;
		else
			dw &= ~DS_BIT_AUTO_PREVIEW;
		
		trDialogSettingParam1.nVal = dw;
	}
	
	return true;
}

bool GetNPrevwDlg::isAutoPreviewShowed()
{
	return ( (m_dwXFBits & DYNALAYOUT_PREVIEW_BUTTON) && m_chkAutoPreview.Visible);
}
///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
