/*------------------------------------------------------------------------------*
 * File Name:	GetNImageDlg.h 													*
 * Creation: 	CPY 2/16/2006													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG		*
 *  Iris 10/31/06 FIX_CRASH_IF_USED_GETN_IMAGE_DLG_FOR_LONG_TIME				*
 *  Joseph 11/09/06  ADD_THEME_CHANGE_EVENT										*
 *  Joseph 11/13/06  ADD_THEME_DESCRIPTION 										*
 *	Joseph 11/21/06	SET_THEME_DESCRIPTION_TRIM_MENU								*
 *	Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON				*
 *  Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER						*
 *	Folger 05/29/08 GETN_IMAGE_DIALOG_SHOULD_INVOKE_ON_THEME_CHANGE_EVENT		*
 * Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG					*
 *------------------------------------------------------------------------------*/

#ifndef _GETN_IMAGE_DLG2_H_
#define _GETN_IMAGE_DLG2_H_

class GetNImageSplitter : public DynaSplitter
{
public:
	GetNImageSplitter();
	//--- Iris 10/31/06 FIX_CRASH_IF_USED_GETN_IMAGE_DLG_FOR_LONG_TIME
	~GetNImageSplitter()
	{
		delete m_pimgView;
	}
	//--- 
	void Setup(TreeNode& tr, PIMAGE_FUNC pfnImg, int nEventID, DWORD dwOptions);
	///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	//virtual
	string GetDlgTitle(){ return GetDlgName() }
	///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	
	//------ Folger 05/29/08 GETN_IMAGE_DIALOG_SHOULD_INVOKE_ON_THEME_CHANGE_EVENT
	//void OnChangeTheme(){ invokeHandlers(-1, -1, -1, GETNEVENT_ON_THEME); }	///Joseph 11/09/06  ADD_THEME_CHANGE_EVENT
	
	//virtual
	void OnChangeTheme(const string& strSel, TreeNode& tr);
	//------
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitSplitter) 
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnResize)
	
	ON_GETNDLG_MSGS(GetTreeEditPaneID())
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	
	//ON_BN_CLICKED(IDC_DATARANGE_DLG_BUTTON, OnInteractiveDataRange)
	//ON_BN_CLICKED(IDC_XY_DATARANGE_DLG_BUTTON, OnInteractiveXYDataRange)
	//ON_BN_CLICKED(IDC_DATA_SELECT_POPUP_BTN,  OnInteractivePopUp)

	ON_USER_MSG(WM_USER_ON_TRACK, OnTrackSlider) //---- CPY 9/12/05 GET_N_IMAGE_DIALOG
	ON_DC_GENERIC(OnGenericControlMsg) //---- CPY 8/22/06 Iris found SaveAs button works in DynaBox and not here
	ON_USER_MSG(WM_USER_MSG_ON_DLG, OnDynamicMsg)	//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
EVENTS_END

public:	

	//BOOL OnSelectionChange() {return m_treeEditCntrl.OnSelectionChange();}
	//BOOL OnSelectionTrack() {return m_treeEditCntrl.OnSelectionTrack();}
//	BOOL OnSelectionChange();
//	BOOL OnSelectionTrack();
///Joseph 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	SIZE GetOptimalSize()
	{	
		SIZE sze;
		TREE_CTRL_VAR.GetOptimalSize(sze);
		return sze;
	}
///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS


	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	void	SetErrMsg(WndContainer& wndParent, LPCSTR lpcszErrMsg = NULL)
	{
		CheckInitErrMsgBox(wndParent, COLOR_RED, COLOR_BLACK, COLORTEXTBLINK_DEFAULT);
		///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		//if(lpcszErrMsg)
			//m_btnErrMessage.Text = lpcszErrMsg;
		CountSetErrMsg(lpcszErrMsg);
		///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	}

	int getMsgBoxHeight(int nMsgBoxWidth)
	{
		Control ctrl = m_btnErrMessage;
		if(!ctrl)
			return 0;
		string str = ctrl.Text;
		int nLength = ctrl.Text.GetLength();
		if(nLength < 1)
			return 0;
		uint nn = GetDialogBaseUnits();
		int nw1 = LOWORD(nn);nw1 = 0.5 + 0.8*nw1;
		int nh1 = HIWORD(nn);nh1 = 0.5 + 0.95*nh1;
		int nTextWidth = nLength * nw1;
		return nh1 * (1 + nTextWidth/nMsgBoxWidth);
	}
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	
	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER, set this func as public
	BOOL	OnDynamicMsg(WPARAM wParam, LPARAM lParam);//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER

protected:
	//BOOL OnInteractiveDataRange(Control ctrl);
	//BOOL OnInteractiveXYDataRange(Control ctrl);
	//BOOL OnInteractivePopUp(Control ctrl);

	BOOL OnInitSplitter();
	
	void OnAfterValueChange(int nRow, int nCol){invokeHandlers(nRow, nCol, -1, 0);}
	
	BOOL OnTrackSlider(WPARAM wParam, LPARAM lParam); //---- CPY 9/12/05 GET_N_IMAGE_DIALOG

	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER, set this func as public
	//BOOL	OnDynamicMsg(uint wParam, uint lParam);//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
private:
	PIMAGE_FUNC getImageHandler() { return m_pImageFunc; } 
	void initAllEvents() { invokeHandlers(-1, -1, -1, GETNEVENT_ON_INIT);}

	void invokeHandlers(int nRow, int nCol, int nCntrlType, DWORD nEventInfo);//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
	
private:
	//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
	PIMAGE_FUNC					m_pImageFunc;
	ImageControlBase			*m_pimgView;	
	DWORD						m_dwOptions;
	//------
	bool						m_bIsReady;
};

#define STR_DLG_NAME 					"GetNImageDlg2"

//---- CPY 9/12/05 GET_N_IMAGE_DIALOG
//enum {
//	GETNG_IMAGE_PANE = 1,
//};
//-----
class GetNImageDlg : public MultiPaneDlg
{
public:
	GetNImageDlg(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PIMAGE_FUNC pfnImg = NULL, int nEventID = XF_GETN_GRAPH_OLD, DWORD dwOptions = 0);	
	///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME
	//GetNImageDlg(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PIMAGE_FUNC pfnImg = NULL, int nEventID = XF_GETN_GRAPH, DWORD dwOptions = 0);	
	GetNImageDlg(TreeNode& tr, int nDlgID, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PIMAGE_FUNC pfnImg = NULL, int nEventID = XF_GETN_GRAPH_OLD, DWORD dwOptions = 0);	
	///End ADD_NEW_PREVIEW_DLG_NO_THEME
	~GetNImageDlg();
	
	int DoModalEx(HWND hWndParent)
	{
		InitMsgMap();
		
		DWORD dwDlgOptions = 0;
		//--- CPY QA70-8122 GETN_IMAGE_DLG_NEED_REPOSITION_BETWEEN_SESSION
		//if(hWndParent)
		//	dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;
		//---
		int nRet = DoModal(hWndParent, dwDlgOptions);
		if(IDOK == nRet)
		{
			 //m_input_tr = m_splitter.GetTree();
		}
		return nRet;
	}
	void UpdateEditTreeNode(TreeNode& tr)
	{
		tr = m_splitter.GetTree();//m_input_tr;
	}
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	//ON_PAGE_SPLITTER_READY(OnReady)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_GETMINMAXINFO(OnMinMaxInfo) //---- CPY 5/14/06 BETTER_DIALOG_POS_SIZE
	ON_HELPINFO(OnHelp)
	
	ON_OK(OnClickOK)
	ON_CANCEL(OnClickCancel)
	
	ON_BN_CLICKED(IDC_PARAMS_MORE, OnShowPreview)
	
	ON_CBN_SELCHANGE(IDC_GETN_THEME_COMB, OnComboChangeTheme)
	ON_BN_CLICKED(IDC_GETN_SAVE_BTN, OnSaveTheme)
	ON_BN_CLICKED(IDC_GETN_SAVE_AS_BTN, OnSaveThemeAs)
	
	///DG 7/27/05 : for changing the input data
//	ON_CHANGE_SELECTION(OnSelectionChange)
//	ON_SELECTION_TRACK(OnSelectionTrack)
	///end
	ON_USER_MSG(WM_USER_MSG_ON_DLG_FROM_SPLITTER, OnDynamicMsg) //----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
	ON_USER_MSG(WM_USER_MSG_UPDATE_OK_BUTTON, OnUpdateOKButton) //--- Iris 11/20/2006 OK_BUTTON_DISABLED_BY_EVENT
	
	///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
EVENTS_END

	/// YuI 09/29/05 MATRIX_OBJECT_VAR_INTERACTIVE_CONTROL
	BOOL OnDestroy();
	/// end MATRIX_OBJECT_VAR_INTERACTIVE_CONTROL

	BOOL OnInitDialog();
	BOOL OnReady();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);
	BOOL OnClickOK();
	BOOL OnClickCancel();
	
	BOOL OnShowPreview(Control ctrl);
	
	BOOL OnComboChangeTheme(Control ctrl);
	BOOL OnSaveTheme(Control ctrl);
	BOOL OnSaveThemeAs(Control ctrl);

//	BOOL OnSelectionChange() { return m_splitter.OnSelectionChange(); }
//	BOOL OnSelectionTrack() { return m_splitter.OnSelectionTrack(); }
	BOOL OnDynamicMsg(WPARAM wParam, LPARAM lParam); //----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
	BOOL OnUpdateOKButton(uint wParam, uint lParam); //--- Iris 11/20/2006 OK_BUTTON_DISABLED_BY_EVENT
///Joseph 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	BOOL	OnInitSize();
	BOOL OnRestoreSize(ODWP dwSizeInfo);
	bool 	GetDlgOptimalSize(SIZE& sze);
	bool 	SetInitSize();
///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
protected:
	void SetDialogTitle(LPCSTR lpcszTitle);
	
private:
	void resizeTopPaneControl(int cx, int cy);
	void replaceLabelSizeForSplitter();
	void setThemeDescirp();   ///Joseph 11/21/06	SET_THEME_DESCRIPTION_TRIM_MENU
	
	void loadThemeFilesToCombo(TreeNode& trGUI);
	bool saveAsTheme(LPCSTR lpcszThemeFilename);
	void updateSaveButton(const string& strSelTheme);
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	//string updateThemeDescription(TreeNode& tr, bool bEditToTree = true);  ///Joseph 11/13/06  ADD_THEME_DESCRIPTION
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	TreeNode	getInputTree()
	{
		return m_splitter.GetTree(false);
	}
	///Joseph 11/21/06	SET_THEME_DESCRIPTION_TRIM_MENU
	TreeNode 	getGUITree()
	{
		return m_splitter.GetTree(true);
	}
	///End SET_THEME_DESCRIPTION_TRIM_MENU
	//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
	
	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	//int 	getDlgStatusMsgBoxHeight(int nStatusBoxWidth);
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	void 	resizeStatusMsgBox();
	//-----
	
	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	//temp mechanism, will centralize later
	bool resizeDlgDescrip(int cx, int cy, int ny);
	int getMsgBoxHeight(Control ctrl, int nMsgBoxWidth);
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	
private:
//	TreeNode				m_input_tr;
	string					m_strTitle;
	string					m_strDescription;
	
	GetNImageSplitter		m_splitter;
	
	vector<uint>			m_vnThemeSaveGroup;
	vector<uint> 			m_vnThemeDescrip; ///Joseph 11/13/06  ADD_THEME_DESCRIPTION
	ComboBox				m_comboTheme;
	//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	//Control					m_btnSaveTheme;
	BitmapRadioButton		m_btnSaveTheme;
	//--------End USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	Control					m_txtStatus;
	
	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	//Control 				m_ctrlLabel;
	Button					m_ctrlLabel;
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE
//	Button					m_btnErrMessage;//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
	int						m_nDlgID;		//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
};
#endif //_GETN_IMAGE_DLG2_H_

