/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Frank 4/16/04 			ADD_FUNCTION_PREV									*
 *	Frank 4/21/04	v8.0860 ADD_FUNCTION_PREVIEW								*
 *	CPY 5/25/04 	v7.5878 FO_ADD_PROFILE_DUE_TO_SLOW_LAUNCH					*
 *	CPY 5/26/04		v7.5878 FO_FUNC_PREVIEW_IMPROVEMENT							*
 *	Frank 5/29/04	v8.0880 QA70-6086	REMOVE_SIMULATE_SETFUNCTION				*
 * 	Frank 7/06/04	v8.0901 QA70-6483 LOAD_CURVE_FROM_FDF						*
 * 	Frank 8/4/04	v8.0110 HANDLE_OPENIN_CODEBUILDER							*
 *  Danice 11/11/04 v8.0162 ADD_TWO_NEW_BTN										*
 *  Frank v8.0169	12/04/04			OC_BUTTON_WARMING_MESSAGE				*
 *  Frank v8.0174	12/15/04			SEPARATE_GUI_AND_ACTION					*
 *  Danice 12/16/04 v8.0175	CODE_CLEAN_UP_REMOVE_DUPLICATE						*
 *  DG 5/18/05 v8.0236 REWRITE_SIMULATE											*
 *  DG 7/8/05 v8.0263 CHECK_FOR_UPDATES											*
 *	Jasmine 09/26/05 v8.0310 SPLITTER_INIT_SIZE_ON_READY						*
 *	Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE			*
 *	Jasmine 11/12/05 v8.0335 QA70-8114  REMOVE_GET_UPDATE_BUTTON				*
 *	Jasmine 01/23/06 v8.0361 GETWINDOW_TO_PARENT_WIN							*
 *	CPY 3/15/06 SPLITTER_INIT_NEEDED_TO_BE_CALLED_FROM_RESIZE					*
 *	Jasmine 05/18/06 v8.0411 RETURN_SEL_FUNCTION								*
 *	CPY 5/29/06 CHANGE_FO_TO_USE_NEW_DYNA_CTRL									*
 * Hong 7/18/06 ADD_BUTTON_SIMULATE                                             *
 *	Jasmine 11/01/06 FIX_FO_BUG													*
 *	Jasmine 11/24/06 SEL_FUNC_AFTER_OPEN										*
 *	Jasmine 12/19/06 ADD_HPARENT_TO_MAKE_FO_MODAL								*
 *	Jasmine 01/27/07 IMPROVE_QUITTING											*
 *	Jasmine 03/01/07 ADD_FO_HELP_TAB											*
 *	Jasmine 03/02/07 ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS				*
 *	Jasmine 03/02/07 UPDATE_DYNACONTROL_ON_FUNC_TYPE_CHANGE						*
 *	Jasmine 03/02/07 DISABLE_BTNS_IF_SELECT_SEPARATOR							*
 *	Jasmine 03/05/07 ACTIVE_HELP_TAB_IF_SELECT_USER_DEFINED_FUNC				*
 *	Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX							*
 *	Jasmine 05/11/07 ADD_DERIVATIVES_CHECKBOX									*
 *	Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT 				*
 *	Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT				*
 *	Jasmine 06/14/07 SET_RESET_BUTTON_STATUS									*
 *	Jasmine 07/09/07 v8.0655 CURVEMAKER_RENAME_TO_SIMCURVE_AND_NOT_USE_IN_LT	*
 *	Jasmine 07/09/07 v8.0655 CALL_SIMSURFACE_WHEN_CATE_IS_SURFACE_FITTING		*
 *	Folger 07/11/07 MORE_CONSTRAINTS_TO_ENABLE_RESET_BUTTON						*
 *	Folger 07/11/07 MORE_CONSTRAINTS_TO_ENABLE_SAVE_BUTTON						*
 *	Jasmine 09/07/07 MOVE_FOHINTS_TXT_TO_LOCALIZATION_FOLDER					*
 *	Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST								*
 *	Folger 12/14/07 CENTRALIZED_CODE_OF_HIDING_RESERVE_CATEGORIES				*
 *  Format 06/04/08 ADD_SETBOTTOMPANEHEIGHT_CALLED_CONDITION					*
 *	Folger 07/07/08 QA80-11810-P1 FORCE_SAVE_BEFORE_SIMULATE_FROM_FO			*
 *	TD 03-06-2009 QA80-13204 FUNC_ORG_DLG_FLASHING								*
 *	Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE					*
 *	Jasmine 06/24/10/ORG-2-S5 OPEN_FITTING_FUNCTION_WIZARD						*
 *	Folger 07/06/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT						*
 *	Jasmine 07/23/10 ORG-486-P3 STOP_WORK_ON_INVALID_FUNCTION_IF_SAVE_FAIL		*
 *	Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
 *	Sim 2011-11-21 ORG-4412 SUPPORT_IMPLICIT_FITTING_ON_FDF_FILE				*
 *  Iris 2/15/2012 ORG-4412-S2 FO_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC_MORE
 *  Iris 3/13/2012 ORG-4412-S5 NEED_CHANGE_FUNCTION_ON_FUNC_MODEL_CHANGE		*
 *  Junon 17/08/2012 ORG-5003 DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
 *------------------------------------------------------------------------------*/
#include <Origin.h>
#include "DialogEx.h"
//#include "FunctionGroup.h"
//#include <fdftree.h>

#ifdef XF_ORGANIZER //CPY DSC 12/9/05 REMOVE_XF_ORGANIZER
//#include "XFunctionEx.h"
#endif

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include "NumFunctionOrganizer.h"
/// TD 09-09-2008 QA80-11924  PCH_USAGE_ISSUE_CAUSE_COMPILE_PROBLEMS
#include 	<..\originlab\XFunctionEx.h>	
/// end PCH_USAGE_ISSUE_CAUSE_COMPILE_PROBLEMS

#include "NLFitSelFunction.h"
#include "nlsf_utils.h"
//----- CPY 5/29/06 CHANGE_FO_TO_USE_NEW_DYNA_CTRL
//#include "TreeEditSplitter.h"
#include "SplitterControl.h"
#include "DynaSplitter.h"
#include "DynaCBSplitter.h" //--CPY 10/5/06
//-----
//#include <fdftree.h> //CPY 5/26/04 v7.5878 FO_FUNC_PREVIEW_IMPROVEMENT

#include <ocGDI.h>
#define  _DMSG(_str)  //out_str(_str);
#define  _DMSG_S(_str) //out_str(_str);

//----- CPY 5/25/04 v7.5878 FO_ADD_PROFILE_DUE_TO_SLOW_LAUNCH
#include <Profiler.h>
#define HOUR_GLASS			waitCursor junk;
#define _SHOW_TIME			Profiler junk;
	// change the following to HOUR_GLASS when finish with all speed improvement
#define PROFILE_HRGLASS		HOUR_GLASS  //_SHOW_TIME //
#define _SEL_FUNC_PREV_SHOW_TIME		//_SHOW_TIME
#define _UPDATE_PREV_SHOW_TIME			//_SHOW_TIME
#define _REPRESH_PREV_SHOW_TIME			//_SHOW_TIME
//-----	
#define WM_USER_BUTTON_ENABLE 		(WM_USER + 1002)
#define WM_USER_ON_FUNC_CHANGE		(WM_USER + 1004)
#define WM_USER_ON_CHANGE_FUNC_HELP	(WM_USER + 1008)	///Jasmine 03/01/07 ADD_FO_HELP_TAB 

#include "FunctionOrganizerEx.h"

#define STR_PRE_NAME 			"Function Preview"			//Frank 4/21/04		v8.0860 ADD_FUNCTION_PREVIEW
#include 	"FOFunctionListSplitter.h"
//#include 	"FOSimulateSplitter.h"		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE Remove simulation from FO, will create a new dialog deal with FO simulation.
#include	"FOFunctPrev.h"				//Frank 4/21/04		v8.0860 ADD_FUNCTION_PREVIEW
#include 	"FunctionMgr.h"				//Frank 8/4/04		v8.0110 HANDLE_OPENIN_CODEBUILDER
/// TD 09-09-2008 QA80-11924  PCH_USAGE_ISSUE_CAUSE_COMPILE_PROBLEMS
// Moved to the top, all PCH files should be at the top
//#include 	<..\originlab\XFunctionEx.h>	
/// end PCH_USAGE_ISSUE_CAUSE_COMPILE_PROBLEMS

#define STR_TAB_FUNCTION_PREVIEW			_L("Equation")
#define STR_TAB_CURVE_PREVIEW				_L("Sample Curve")
#define STR_TAB_FUNCTION_HELP				_L("Hints")
//#define STR_TAB_SIMULATE					"Simulate"  ///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
#define STR_TAB_FUNCTION_CODE				_L("Function code")
#define STR_OK_BUTTON_WARN_MESSAGE			_L("Save changes before closing dialog?")	//"Are you sure you want to quit and save all the changes?"	///Jasmine 01/27/07 IMPROVE_QUITTING
#define STR_FO_HELP_FILE					"FOHints.txt"//okutil_get_origin_path(ORIGIN_PATH_SYSTEM)+"FOHints.txt"	///Jasmine 03/01/07 ADD_FO_HELP_TAB	///Jasmine 09/07/07 MOVE_FOHINTS_TXT_TO_LOCALIZATION_FOLDER
#define	STR_CATE_NAME_SURFACE_FITTING		"Surface Fitting"

//Tab option: 1, Function Preview; 2. Operation Log; 3. Parameter control
//CPY 5/26/04 v7.5878 FO_FUNC_PREVIEW_IMPROVEMENT
//I have moved FO_VIEW_FUNC_PREV as 1st choice
///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
//enum {FO_VIEW_FUNC_PREV, FO_VIEW_CURVE_PREV, FO_VIEW_SIMULATION }; 
enum {FO_VIEW_FUNC_PREV, FO_VIEW_CURVE_PREV, FO_VIEW_FUNC_HELP};	///Jasmine 03/01/07 ADD_FO_HELP_TAB 
///End  REMOVEFO_SIMULATION_TO_SEPERATE

///Hong 7/18/06 ADD_BUTTON_SIMULATE
///DG 2/25/05 BTN_STATUS_CONTROL
//enum {INDEX_BTN_SAVE, INDEX_BTN_NEW_CATE, INDEX_BTN_NEW_FUNC, INDEX_BTN_DUPL, INDEX_BTN_ADD, INDEX_BTN_DEL, INDEX_BTN_GET_UPDATES, TOTAL_BTN_NUM};	///DG CHECK_FOR_UPDATES	///Jasmine 11/12/05 v8.0335 QA70-8114  REMOVE_GET_UPDATE_BUTTON
//enum {INDEX_BTN_SAVE, INDEX_BTN_NEW_CATE, INDEX_BTN_NEW_FUNC, INDEX_BTN_DUPL, INDEX_BTN_ADD, INDEX_BTN_DEL, TOTAL_BTN_NUM};
enum {INDEX_BTN_SAVE, INDEX_BTN_NEW_CATE, INDEX_BTN_NEW_FUNC, 
	INDEX_BTN_WIZARD, ///Jasmine 06/24/10/ORG-2-S5 OPEN_FITTING_FUNCTION_WIZARD
	INDEX_BTN_DUPL, INDEX_BTN_ADD, INDEX_BTN_DEL, INDEX_BTN_SIMULATE, 
	INDEX_BTN_RESET, 	///Jasmine 06/14/07 SET_RESET_BUTTON_STATUS
	TOTAL_BTN_NUM};
///END BTN_STATUS_CONTROL
///End ADD_BUTTON_SIMULATE 

class FODlg : public MultiPaneDlg
{	
public:
	///Jasmine 11/24/06 SEL_FUNC_AFTER_OPEN
	///Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT 
	///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	FODlg(LPCSTR lpcszSel = NULL, DWORD dwCntrl = 0, TreeNode& trChangedFDFs = NULL) : MultiPaneDlg(IDD_FO_DLG, "ODlg8")
	{
		m_strSel = lpcszSel;
		m_dwCntrl = dwCntrl;
///Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
		m_trChangedFDFs = trChangedFDFs;
		string strFile = okutil_get_origin_path(USER_FOLDER, STR_FDF_FILE_FOLDER) + STR_TEMP_XML_FILE;
		m_trChangedFDFs.Save(strFile);
	}
	///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	///End ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT
	///End SEL_FUNC_AFTER_OPEN
	~FODlg()
	{
		string strFile = okutil_get_origin_path(USER_FOLDER, STR_FDF_FILE_FOLDER) + STR_TEMP_XML_FILE;
		if(strFile.IsFile())
			DeleteFile(strFile);
///End NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	}
	int DoModalEx(HWND hWndParent = NULL, int nFuncType = 0)
	{
		InitMsgMap();// will be called from internal later
		
		DWORD dwDlgOptions = 0;
		//--- CPY 7/8/03 QA70-4796 v7.0620 GET_N_BOX_EVENT_FUNC_MOVE_WIN
		//if(hWndParent)
		//	dwDlgOptions |= DLG_NO_DEFAULT_REPOSITION;
		//---
		
		m_FO.setFuncType(nFuncType);

		int nRet = DoModal(hWndParent, dwDlgOptions);
		if(nRet != IDCANCEL)
		{
			//m_input_tr.Replace(THE_TREE_NODE);
			//saveDefaultGUI();
		}
		return nRet;
	}
	///Jasmine 05/18/06 RETURN_SEL_FUNCTION
	string GetSel()
	{
		return m_FO.GetSel();
	}
	///Jasmine 06/11/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	TreeNode GetChangedFDFs()
	{
		string strFile = okutil_get_origin_path(USER_FOLDER, STR_FDF_FILE_FOLDER) + STR_TEMP_XML_FILE;
		if(strFile.IsFile())
			m_trChangedFDFs.Load(strFile);
		return m_trChangedFDFs;
	}
	///End NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
	///Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST
	bool IsChangeSaved()
	{
		return m_bChangeSaved;	
	}
	///End UPDATE_NLFIT_DB_FUNCTION_LIST
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)	///Jasmine 09/26/05 SPLITTER_INIT_SIZE_ON_READY
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	
	ON_SYSCOMMAND(OnSystemCommand) //CPY 5/29/06 CHANGE_FO_TO_USE_NEW_DYNA_CTRL
	
	ON_OK(OnClickOK)
	ON_CANCEL(OnClickCancel)
	
	ON_BN_CLICKED(IDC_FO_SAVE, OnClickSave)
	ON_BN_CLICKED(IDC_FO_NEW_CATE, OnClickNewCate)
	ON_BN_CLICKED(IDC_FO_NEW_FUNC, OnClickNewFunc)
	ON_BN_CLICKED(IDC_FO_FUNTION_WIZARD, OnClickWizardBtn)	///Jasmine 06/24/10/ORG-2-S5 OPEN_FITTING_FUNCTION_WIZARD
	ON_BN_CLICKED(IDC_FO_DUPLICATE, OnClickDupli)
	ON_BN_CLICKED(IDC_FO_ADD, OnClickAdd)
	ON_BN_CLICKED(IDC_FO_DELETE, OnClickDelete)
	ON_BN_CLICKED(IDC_FO_SIMULATE, OnClickSimulate)
	ON_BN_CLICKED(IDC_FO_RESET, OnClickReset)
	//ON_BN_CLICKED(IDC_FO_CHECK_FOR_UPDATE, OnClickUpdates)	///Jasmine 11/12/05 v8.0335 QA70-8114  REMOVE_GET_UPDATE_BUTTON
	
	ON_BN_CLICKED(IDC_FO_SHOW_PE, OnShowBottomPane)
	
	ON_TAB_SEL_CHANGE(IDC_FO_VIEW_TABS, OnTabChange)
	ON_USER_MSG(WM_USER_BUTTON_ENABLE, OnButtonEnable)
	ON_USER_MSG(WM_USER_ON_FUNC_CHANGE, OnRefreshPrev)
	ON_USER_MSG(WM_USER_ON_CHANGE_FUNC_HELP, OnUpdateFOHelp)	///Jasmine 03/01/07 ADD_FO_HELP_TAB 
	
	///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	ON_INIT_SIZE(OnInitSize)	
	ON_RESTORESIZE(OnRestoreSize)
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
EVENTS_END

//------------ Event Handlers ------------------------
	BOOL OnInitDialog()
	{
		PROFILE_HRGLASS //CPY 5/25/04 v7.5878 FO_ADD_PROFILE_DUE_TO_SLOW_LAUNCH
		
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Previews");
		vstrTipsUpDown[1] = _L("Hide Previews");
		MultiPaneDlg::OnInitDialog(IDC_FO_BOX, IDC_FO_SHOW_PE, IDC_FO_VIEW_TABS, vstrTipsUpDown, STR_FDF_DLG_NAME);
		
		m_tabFunc = GetItem(IDC_FO_VIEW_TABS);
		
		//--- CPY 5/26/04 v7.5878 FO_FUNC_PREVIEW_IMPROVEMENT
		// I have changed the order so FO_VIEW_FUNC_PREV is 1st and FO_VIEW_SIMULATION is last
		m_tabFunc.InsertItem(FO_VIEW_FUNC_PREV,  STR_TAB_FUNCTION_PREVIEW);//"Function"); Frank 6/30/04
		m_tabFunc.InsertItem(FO_VIEW_CURVE_PREV, STR_TAB_CURVE_PREVIEW);//"Curve");
		m_tabFunc.InsertItem(FO_VIEW_FUNC_HELP, STR_TAB_FUNCTION_HELP);///Jasmine 03/01/07 ADD_FO_HELP_TAB 
		//m_tabFunc.InsertItem(FO_VIEW_SIMULATION, STR_TAB_SIMULATE);//"Simulation"); ///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
		//m_tabFunc.InsertItem(FO_FUNCTIOIN_CODE_SHOW, STR_TAB_FUNCTION_CODE);//"Function code");
		RECT rr;
		m_tabFunc.GetItemRect(0,&rr);rr.bottom += 10;
		m_tabFunc.MoveWindow(&rr);// no need to worry about width, it will be resized later
		
		//---
		///Jasmine 11/01/06 FIX_FO_BUG
		//make m_NFFunctionPrev before m_FO
		//m_Simulate.Init(IDC_FO_SIMULATE_BOX, *this, 0, "");/// make invisible until open bottom pane 		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE

		m_NFFunctionPrev.Init(IDC_FO_FUNCTIONPREV_BOX,*this, 0, "");		//Frank 4/21/04		v8.0860 ADD_FUNCTION_PREVIEW
		m_NFCurvePrev.Init(IDC_FO_CURVEPREV_BOX,*this, 0, "");	
		m_edFOHelp = GetItem(IDC_FO_HELP_BOX);	///Jasmine 03/01/07 ADD_FO_HELP_TAB
		hideAllControlInBottomPane();
		m_FO.Init(IDC_FO_BOX, *this, 0, STR_FDF_DLG_NAME);
		///End FIX_FO_BUG
		m_FO.SetSel(m_strSel);///Jasmine 11/24/06 SEL_FUNC_AFTER_OPEN
		m_FO.SetSectionUnSaveSign(m_trChangedFDFs);	///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT 
		//------ Folger 12/14/07 CENTRALIZED_CODE_OF_HIDING_RESERVE_CATEGORIES
		//if(m_dwCntrl)
		if (m_dwCntrl & FO_SHOW_ONE_CATEGORY)
		//------
		{
			m_FO.ShowSelCategory();	///Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT 
			GetItem(IDC_FO_NEW_CATE).Enable = false;
		}
		//------ Folger 12/14/07 CENTRALIZED_CODE_OF_HIDING_RESERVE_CATEGORIES
		else if (m_dwCntrl & FO_REMOVE_RESERVE_CATEGORIES)
		{
			m_FO.HideReserveCategories();
		}
		//------
		m_bChangeSaved = false;		///Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST
		return true;
	}
	
	///Jasmine 09/26/05 v8.0310 SPLITTER_INIT_SIZE_ON_READY
	BOOL OnReady()
	{
		///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		//We update dlgsize  on function OnRestoreDlg now
		//UpdateDlgSize();
		///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		UpdateDlgShow();	
		SetInitReady();
		//UpdateDlgSize();	
		
		m_FO.OnReady();
		//m_Simulate.OnReady();	///Jasmine 09/27/05 v8.0310 SPLITTER_INIT_SIZE_ON_READY 		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
		
		OnRefreshPrev(1,-1);
		
		Control ctrl;
		OnShowBottomPane(ctrl);
		
		///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		if(0 == HasPreviousSize())
			m_FO.SetTreeEditPaneSize(70, true);
		///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
		string strCate = m_strSel.GetToken(0,'|');
		string strFunc = m_strSel.GetToken(1,'|');
		//Control ctrl;
		if(!strCate.CompareNoCase(STR_NEW_DOT_DOT_DOT))
			OnClickNewCate(ctrl);
		if(!strFunc.CompareNoCase(STR_NEW_DOT_DOT_DOT))
			OnClickNewFunc(ctrl);
		///End ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
		return true;
	}
	///End SPLITTER_INIT_SIZE_ON_READY
	BOOL OnDestroy()
	{
		//saveSimulateSettings();		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE

		///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE
		okutil_post_origin_message(SN_ON_FITTING_FUNCTION_CHANGE);
		///End ANNOUNCE_FITTING_FUNC_CHANGE
		
		return MultiPaneDlg::OnDestroy();
	}
		
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
			
		//uint nButtonIDs[] = {IDC_FO_SAVE, IDC_FO_NEW_CATE, IDC_FO_NEW_FUNC, IDC_FO_DUPLICATE, IDC_FO_ADD, IDC_FO_DELETE, IDCANCEL, IDOK, IDC_FO_CHECK_FOR_UPDATE, 0}; ///Jasmine 11/12/05 v8.0335 QA70-8114  REMOVE_GET_UPDATE_BUTTON
		///Hong 7/18/06 ADD_BUTTON_SIMULATE
		//uint nButtonIDs[] = {IDC_FO_SAVE, IDC_FO_NEW_CATE, IDC_FO_NEW_FUNC, IDC_FO_DUPLICATE, IDC_FO_ADD, IDC_FO_DELETE, IDCANCEL, IDOK, 0}; 
		uint nButtonIDs[] = {IDC_FO_SAVE, IDC_FO_NEW_CATE, IDC_FO_NEW_FUNC, 
							IDC_FO_FUNTION_WIZARD, ///Jasmine 06/24/10/ORG-2-S5 OPEN_FITTING_FUNCTION_WIZARD					
							IDC_FO_DUPLICATE, IDC_FO_ADD, IDC_FO_DELETE, IDCANCEL, IDOK, IDC_FO_SIMULATE, IDC_FO_RESET, 0}; 
		///end ADD_BUTTON_SIMULATE
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy);
		if(IsBottomPaneShown())
		{
			movePagesToTab();
		}
		m_FO.OnDlgResize(nType, cx, cy);//CPY 3/15/06 SPLITTER_INIT_NEEDED_TO_BE_CALLED_FROM_RESIZE
		return TRUE;
	}
	
	//----- CPY 10/11/03 QA70-5332 HELP_CUSTOMIZED
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		/*
		PEVENT_FUNC pfn = getEventHandler();
		if(pfn)
		{
			pfn(THE_TREE_NODE, -2, -1, *this); //CPY 5/30/03 QA70-4577 EVENT_HANDLER_NEED_DIALOG_AND_VALUE_UPDATE, added *this
		}
		*/
		return FALSE; // do no call default help
	}
	//----- end QA70-5332
	
	
	BOOL OnShowBottomPane(Control cntrl)
	{
		MultiPaneDlg::OnShowBottomPane(cntrl);
		if(IsBottomPaneShown())
		{
			int	nTabOrder = m_tabFunc.GetCurSel();
			updateBottomTabDisplay(nTabOrder);
		}
		else
		{
			hideAllControlInBottomPane();
		}	
		return TRUE;
	}
	
	BOOL OnTabChange(Control cntrl)
	{
		int nTab = m_tabFunc.GetCurSel();
		updateBottomTabDisplay(nTab);
		/*
		updateTabDisplay(nTab);
		*/
		return TRUE;		
	}
	
	BOOL OnClickOK()
	{
		bool bRet=true;
		if(m_FO.CheckIfUnSave())
		{
			if(IDNO == MessageBox(GetSafeHwnd(), STR_OK_BUTTON_WARN_MESSAGE, ERROR_ATTENTION_DIAOLG, MB_YESNO | MB_DEFBUTTON1 | MB_ICONEXCLAMATION))
				return true;	///Jasmine 01/27/07 IMPROVE_QUITTING
			//bRet =	saveAllAndSimulateSetting();//Frank 12/29/04
			bRet = saveAllFunctions();
		}
		//saveAllAndSimulateSetting();
		return bRet;
	}
	
	BOOL OnClickCancel()
	{
		SetFocus(GetItem(IDCANCEL).GetSafeHwnd());///Jasmine 11/02/06 FIX_FO_BUG, force to update change
		if(m_FO.CheckIfUnSave())
		{
			int nChoose=MessageBox(GetSafeHwnd(), STR_CANCEL_BTN_WARN_MESSAGE, ERROR_ATTENTION_DIAOLG, MB_YESNOCANCEL | MB_DEFBUTTON1 | MB_ICONASTERISK);
			if(IDYES == nChoose)
				//return saveAllAndSimulateSetting();//m_FO.SaveAll();//Frank 12/29/04 
				return saveAllFunctions();
			else if(IDNO == nChoose)
				return true;
			else
				return false;
		}
		//saveAllAndSimulateSetting();
		return true;
	}
	
	BOOL OnClickSave(Control ctrl)
	{
		///Jasmine 07/23/10 ORG-486-P3 STOP_WORK_ON_INVALID_FUNCTION_IF_SAVE_FAIL
		//m_FO.SaveSelSection();
		if( !m_FO.SaveSelSection() )
			return FALSE;
		///End STOP_WORK_ON_INVALID_FUNCTION_IF_SAVE_FAIL
		OnButtonEnable();		//--------Folger 07/11/07 MORE_CONSTRAINTS_TO_ENABLE_SAVE_BUTTON
		m_bChangeSaved = true;	///Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST
		return TRUE;
	}
	BOOL OnClickNewCate(Control ctrl)
	{
		m_FO.NewCategory();
		return true;
	}
	BOOL OnClickNewFunc(Control ctrl)
	{
		m_FO.NewFunction();
		return true;
	}
	///Jasmine 06/24/10/ORG-2-S5 OPEN_FITTING_FUNCTION_WIZARD
	BOOL OnClickWizardBtn(Control ctrl)
	{
		m_FO.NewFunctionInWizard();
		return FALSE;
	}
	///End OPEN_FITTING_FUNCTION_WIZARD
	BOOL OnClickDupli(Control ctrl)
	{
		///DG 5/23/05 QA70-6729 : duplicate need to duplicate simulate
		//m_FO.DuplicateSection();
		m_tabFunc.SetCurSel(FO_VIEW_FUNC_PREV);
		Tree trSrcFunction;
		trSrcFunction = m_FO.GetSelFuncDetail();
		m_FO.DuplicateSection();
		TreeNode trNewFunction = m_FO.GetSelFuncDetail();
		//m_Simulate.DuplicateSimulation(trSrcFunction, trNewFunction);		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE

		///end
		return true;
	}
	
	BOOL OnClickAdd(Control ctrl)
	{
		m_FO.AddFunction();
		return true;
	}
	
	BOOL OnClickDelete(Control ctrl)
	{
		m_FO.DelSelSection();
		m_bChangeSaved = true;	///Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST
		return true;
	}
	BOOL OnClickSimulate(Control ctrl)
	{
		///Jasmine 07/23/10 ORG-486-P3 STOP_WORK_ON_INVALID_FUNCTION_IF_SAVE_FAIL
		//OnClickSave(ctrl);		//------ Folger 07/07/08 QA80-11810-P1 FORCE_SAVE_BEFORE_SIMULATE_FROM_FO
		if( !OnClickSave(ctrl) )
			return FALSE;
		///End STOP_WORK_ON_INVALID_FUNCTION_IF_SAVE_FAIL
		TreeNode trSrcFunction;
		string strCommand;
		strCommand = m_FO.GetSel(false);
		if(strCommand.IsEmpty())
			return false;
		///Jasmine 07/09/07 v8.0655 CURVEMAKER_RENAME_TO_SIMCURVE_AND_NOT_USE_IN_LT
		/*
		strCommand = "\"" + strCommand;
		strCommand.Replace("|", "\" \"");
		strCommand += "\"";
		LT_execute("curvemaker -d "+ strCommand);
		*/	
		string strCate = strCommand.GetToken(0, '|');
		string strFunc = strCommand.GetToken(1, '|');
		///Jasmine 10/19/07 QA70-10558 CHECK_INDEPENDENT_VARIABLE_NUMBER_TO_OPEN_SIMCURVE
		///Jasmine 07/09/07 v8.0655 CALL_SIMSURFACE_WHEN_CATE_IS_SURFACE_FITTING
		//string strXF = strCate.CompareNoCase(STR_CATE_NAME_SURFACE_FITTING)? "simcurve" : "simsurface";
		int nSimulate = m_FO.GetSimulateType();
		if(nSimulate < 0)
			return false;
		vector<string> vsSimulate = {"simcurve", "simsurface"};
		string strXF =  vsSimulate[nSimulate];
		///End CHECK_INDEPENDENT_VARIABLE_NUMBER_TO_OPEN_SIMCURVE
		XFunction xf;
		TreeNode trXF;
		if(!xf.Load(&trXF, strXF, 0, true, false, true))
		{
			return false;
		}
		//set xf variable
		int nErr;
		xf.SetArg("categorylist", strCate);
		if(!strFunc.IsEmpty())
			xf.SetArg("functionlist", strFunc);
		///End CALL_SIMSURFACE_WHEN_CATE_IS_SURFACE_FITTING
		if ( xf.ExecuteLabTalk(NULL, NULL, NULL, 0, &nErr, LTXF_SHOW_DIALOG) != 0 )
		{
			return false;
		}
		///End CURVEMAKER_RENAME_TO_SIMCURVE_AND_NOT_USE_IN_LT
		return true;	
	}
	///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	BOOL OnClickReset(Control ctrl)
	{
		m_FO.ResetSelSection();
		OnButtonEnable();		//--------Folger 07/11/07 MORE_CONSTRAINTS_TO_ENABLE_RESET_BUTTON
		return TRUE;
	}
	///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	///Jasmine 11/12/05 v8.0335 QA70-8114  REMOVE_GET_UPDATE_BUTTON
	/*
	BOOL OnClickUpdates(Control ctrl)
	{
		return true;
	}
	*/
	///End REMOVE_GET_UPDATE_BUTTON
protected :
	//Set the Save, New, Duplicate, Add and Delete button stats
	void OnButtonEnable(bool bChangeListBtnDisable=false, uint lParam=false)
	{
		///DG 2/25/05 BTN_STATUS_CONTROL
		//vector<uint> vnBtnIDs={IDC_FO_SAVE, IDC_FO_NEW_CATE, IDC_FO_NEW_FUNC, IDC_FO_DUPLICATE, IDC_FO_ADD, IDC_FO_DELETE, IDC_FO_CHECK_FOR_UPDATE};	///DG CHECK_FOR_UPDATES	///Jasmine 11/12/05 v8.0335 QA70-8114  REMOVE_GET_UPDATE_BUTTON
		///Hong 7/18/06 ADD_BUTTON_SIMULATE
		//vector<uint> vnBtnIDs={IDC_FO_SAVE, IDC_FO_NEW_CATE, IDC_FO_NEW_FUNC, IDC_FO_DUPLICATE, IDC_FO_ADD, IDC_FO_DELETE};
		vector<uint> vnBtnIDs={IDC_FO_SAVE, IDC_FO_NEW_CATE, IDC_FO_NEW_FUNC, 
								IDC_FO_FUNTION_WIZARD, ///Jasmine 06/24/10/ORG-2-S5 OPEN_FITTING_FUNCTION_WIZARD
								IDC_FO_DUPLICATE, IDC_FO_ADD, IDC_FO_DELETE, IDC_FO_SIMULATE, 
								IDC_FO_RESET};	///Jasmine 06/14/07 SET_RESET_BUTTON_STATUS
		///end ADD_BUTTON_SIMULATE
		vector<bool> vbBtnEnable;
		m_FO.GetButtonStatus(vbBtnEnable);
		for(int ii=0; ii<TOTAL_BTN_NUM; ii++)
		{
			if(bChangeListBtnDisable && INDEX_BTN_SAVE!=ii && INDEX_BTN_NEW_CATE!=ii)	///Jasmine 03/02/07 DISABLE_BTNS_IF_SELECT_SEPARATOR
			{
				Button btn=GetItem(vnBtnIDs[ii]);
				if(btn.Enable)
					btn.Enable=false;
			}
			else
				GetItem(vnBtnIDs[ii]).Enable = vbBtnEnable[ii];
		}
		///end BTN_STATUS_CONTROL
		///Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT 
		if(m_dwCntrl & FO_SHOW_ONE_CATEGORY)
			GetItem(IDC_FO_NEW_CATE).Enable = false;
		///End ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT
		
		///Sophy 7/19/2010 ORG-545-P1 PROPER_UPDATE_BUILDER_BUTTON_STATE_ON_SEL_CHANGE
		//GetItem(IDC_FO_FUNTION_WIZARD).Enable = true;///Jasmine 06/24/10/ORG-2-S5 OPEN_FITTING_FUNCTION_WIZARD
		///end PROPER_UPDATE_BUILDER_BUTTON_STATE_ON_SEL_CHANGE
	}
	//Refresh the Preview display by current function detail
	//void OnRefreshPrev(uint wParam, uint lParam)	///DG CLOSE_FO_SIMULATION_FOR_XF
	///Jasmine 03/05/07 ACTIVE_HELP_TAB_IF_SELECT_USER_DEFINED_FUNC
	//void OnRefreshPrev(bool bBottomPane, uint lParam)
	void OnRefreshPrev(bool bBottomPane, int nChangeTab = -1)
	{
		_REPRESH_PREV_SHOW_TIME
		_DMSG("calling OnRefreshPrev")
		if(IsBottomPaneShown())
		{
			if(-1 < nChangeTab)
				m_tabFunc.SetCurSel(nChangeTab);
	///End ACTIVE_HELP_TAB_IF_SELECT_USER_DEFINED_FUNC
			int	nTabOrder = m_tabFunc.GetCurSel();
			updateBottomTabDisplay(nTabOrder);
		}			
		///DG CLOSE_FO_SIMULATION_FOR_XF
		if(!bBottomPane)
		{
			MultiPaneDlg::DisableBottomPane();
			Control ctrl;
			OnShowBottomPane(ctrl);
		}
		else
		{
			MultiPaneDlg::EnableBottomPane();
		}
		///end CLOSE_FO_SIMULATION_FOR_XF
	}
	///Jasmine 03/01/07 ADD_FO_HELP_TAB 
	void OnUpdateFOHelp(bool bUpdate = true, uint lParam = 0)
	{
		string strRowLabel = m_FO.GetCurrentRowLabel(), strHelp;
		if(strRowLabel.IsEmpty())
			m_edFOHelp.Text = "";
		///Jasmine 09/07/07 MOVE_FOHINTS_TXT_TO_LOCALIZATION_FOLDER
		string strHint;
		BOOL bRet = okutil_find_sys_path_with_file(&strHint, STR_FO_HELP_FILE, GLOBAL_LOCALIZED_PATH, TRUE);
		///End MOVE_FOHINTS_TXT_TO_LOCALIZATION_FOLDER
		int nRet = okutil_read_file_section(strHint + STR_FO_HELP_FILE, strRowLabel, &strHelp, NULL); 
		m_edFOHelp.Text = strHelp;
		
		///Jasmine 07/28/08 MODIFY_DEFINE_PEAK_FUNC_ERRMSG_BY_MAX_REQUEST, temp code, later we should move STR_FO_HELP_FILE into oErrMsg
		if( 0 == strRowLabel.CompareNoCase(STR_PEAK_FUNC_CHECK_E) || 0 == strRowLabel.CompareNoCase(STR_FUNC_PARAMETERS_SETTINGS) )
		{
			if( !m_edFOHelp.Text.IsEmpty() )
				m_edFOHelp.Text += "\r\n\r\n";
			
			ocu_load_err_msg_str(FO_PEAK_FUNC_MSG, &strHelp);	
			m_edFOHelp.Text += strHelp + "\r\n\r\n" + STR_MSG_FO_HOW_TO_SET_PEAK_ATTRIB;///Jasmine 07/14/10 ORG-540-P3
		}
		///End MODIFY_DEFINE_PEAK_FUNC_ERRMSG_BY_MAX_REQUEST
	}
	///ADD_FO_HELP_TAB
	int GetMinTopPaneHeight(){return 400;}
	
	///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	BOOL	OnInitSize()
	{
		return FALSE;
	}
	BOOL	OnRestoreSize(ODWP dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;

		lstrcpyn(pSz->szDialogName, STR_FDF_DLG_NAME, MAXLINE);
			
		SIZE sz;
		GetDlgOptimalSize(sz);
		///Joseph 02/15/07 ROLL_BRAK_TO_TD_DESIGN
		//pSz->top = -sz.cy/2;
		//pSz->left = -sz.cx/2;
		pSz->top = -1;
		pSz->left = -1;
		///End ROLL_BRAK_TO_TD_DESIGN
		pSz->width = sz.cx;
		pSz->height = sz.cy;
		///Format 06/04/08 ADD_SETBOTTOMPANEHEIGHT_CALLED_CONDITION
		//SetBottomPaneHeight(120);
		if(0 == HasPreviousSize(STR_FDF_DLG_NAME))
		{
			SetBottomPaneHeight(120);
		}
		///End ADD_SETBOTTOMPANEHEIGHT_CALLED_CONDITION

		return TRUE;
	}
	bool 	GetDlgOptimalSize(SIZE& sze)
	{
		//hard code
		sze.cx = 800;
		sze.cy = 670;
		return true;
	}
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
private:
	bool	saveAllFunctions()
	{
		m_bChangeSaved = true;	///Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST
		return m_FO.SaveAll();
	}
	//bool	saveAllAndSimulateSetting()
	///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
	//bool	saveSimulateSettings()
	//{
		///*
			//bool bRet=m_FO.SaveAll();
			//
			////This will save the last setting of the function to nlsf.oss file.
			////m_Simulate.GetFunction(NULL);	///DG REWRITE_SIMULATE
			//m_Simulate.SaveSimulateSettings();
			//return bRet;
			//*/
		//return m_Simulate.SaveSimulateSettings();
	//}
	///End	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
	void	hideAllControlInBottomPane()
	{
		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
		//vector<uint> vnBottomTab={IDC_FO_SIMULATE_BOX, IDC_FO_CURVEPREV_BOX, IDC_FO_FUNCTIONPREV_BOX, 0};
		vector<uint> vnBottomTab={IDC_FO_CURVEPREV_BOX, IDC_FO_FUNCTIONPREV_BOX, IDC_FO_HELP_BOX, 0};	///Jasmine 03/01/07 ADD_FO_HELP_TAB
		///End 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
		ShowControls(vnBottomTab, false);
	}
	void 	updateBottomTabDisplay(int nTabToShow) // = -1
	{
		int nSelTab=movePagesToTab();
		switch(nSelTab)
		{
		case FO_VIEW_FUNC_PREV:
			setFunctionFormulaPreview(true);
			break;
		case FO_VIEW_CURVE_PREV:
			setFunctionFormulaPreview(false);
			break;
		///Jasmine 03/01/07 ADD_FO_HELP_TAB
		case FO_VIEW_FUNC_HELP:
			OnUpdateFOHelp();
			break;
		///End ADD_FO_HELP_TAB
		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE	
		/*
		case FO_VIEW_SIMULATION:
			selTabSimulatePreview();
			break;
		*/
		///End  REMOVEFO_SIMULATION_TO_SEPERATE	
		///End FUNCTION_FILE_INFO
		default:
			out_str("Error, nTab not a valid tab");
			break;
		}
	}
	int		movePagesToTab()
	{
		hideAllControlInBottomPane();	//hide then show to force refresh
		int nSelTab=m_tabFunc.GetCurSel();
		RECT rTab;
		m_tabFunc.GetWindowRect(&rTab);
		ScreenToClient(&rTab);
		m_tabFunc.AdjustRect(FALSE, &rTab);
		
		int nID = 0;
		switch(nSelTab)
		{ 
		case FO_VIEW_FUNC_PREV:
			nID = IDC_FO_FUNCTIONPREV_BOX;
			break;
		case FO_VIEW_CURVE_PREV:
			nID = IDC_FO_CURVEPREV_BOX;
			break;
		///Jasmine 03/01/07 ADD_FO_HELP_TAB
		case FO_VIEW_FUNC_HELP:
			nID = IDC_FO_HELP_BOX;
			break;
		///End ADD_FO_HELP_TAB
		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
		//case FO_VIEW_SIMULATION:
			//nID = IDC_FO_SIMULATE_BOX;
			//break;
		///End  REMOVEFO_SIMULATION_TO_SEPERATE
		}
		if(nID)
		{
			Control ctrl  = GetItem(nID);
			ctrl.Visible=true;
			ctrl.MoveWindow(&rTab);
		}
		else
			error_report("movePagesToTab found Invalid nSelTab");
		return nSelTab;
	}
	//Change the function name and add another function to deal with fucntion prev 
	///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
	/*
	void selTabSimulatePreview()
	{
		PROFILE_HRGLASS
		//TreeNode trSelFun = m_FO.GetSelFunc();
		TreeNode trFunctionDetail = m_FO.GetSelFuncDetail();
		///DG REWRITE_SIMULATE
		//m_Simulate.OnChangeSimulateByFunctionSelect(trFunctionDetail, bFunctionDetailChanged);
		m_Simulate.UpdateSimulate(trFunctionDetail);
		///end REWRITE_SIMULATE
	}	
	*/
	///End	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
	
	bool	setFunctionFormulaPreview( bool bFormular )
	{
		int			nNumDataset;
		TreeNode	trFunction = m_FO.GetSelFuncDetail();
		string 		strFilePath ;
		bool	bLoadPreviewSecc = false;
		if(bFormular)
		{
			bLoadPreviewSecc = m_NFFunctionPrev.LoadNLSFFunctionPreview(trFunction, bFormular);
			m_NFFunctionPrev.SetVisible(bLoadPreviewSecc);
		}
		else
		{
			bLoadPreviewSecc = m_NFCurvePrev.LoadNLSFFunctionPreview(trFunction, bFormular);
			m_NFCurvePrev.SetVisible(bLoadPreviewSecc);
		}
		return bLoadPreviewSecc;
	}
private:
	FunctionListSplitter		m_FO;
	//FOSimulateSplitter			m_Simulate;		///Frank 11/11/05 	v8.0333 QA70-8114  REMOVEFO_SIMULATION_TO_SEPERATE
	TabControl					m_tabFunc;
	NFPreviewControl			m_NFFunctionPrev;
	NFPreviewControl			m_NFCurvePrev;
	Edit						m_edFOHelp;			///Jasmine 03/01/07 ADD_FO_HELP_TAB
	Tree						m_trChangedFDFs;	///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT 
	string						m_strSel;			///Jasmine 11/24/06 SEL_FUNC_AFTER_OPEN
	DWORD 						m_dwCntrl;			///Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT 
	bool						m_bChangeSaved;		///Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST
};
///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
///Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT 
///Jasmine 12/19/06 ADD_HPARENT_TO_MAKE_FO_MODAL
///Jasmine 05/18/06 RETURN_SEL_FUNCTION
///Jasmine 11/24/06 SEL_FUNC_AFTER_OPEN
//BOOL OpenFO(string& strSel)
BOOL OpenFO(string& strSel, DWORD dwCntrl = 0, HWND hParent = NULL, TreeNode& trChangedFDFs = NULL)	
{
	FODlg 	myDlg(strSel, dwCntrl, trChangedFDFs);
///End SEL_FUNC_AFTER_OPEN
///End ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT 
///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	Window winExDlg = myDlg.GetWindow();
	if(winExDlg)
	{
		out_str("FO already open");
		return false;
	}
	Window winNewDlg(hParent);
	HWND hWnd = GetWindow();
	if(winNewDlg)
		hWnd = hParent;
	if(hWnd)
	{
		int nRet = myDlg.DoModalEx(hWnd);
		trChangedFDFs = myDlg.GetChangedFDFs();	///Jasmine 06/08/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
		if(nRet != IDCANCEL)
		{
			strSel = myDlg.GetSel();
			return true;
		}
		///Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST
		if(myDlg.IsChangeSaved())
			return true;
		///End UPDATE_NLFIT_DB_FUNCTION_LIST
	}
	return false;
}
///End RETURN_SEL_FUNCTION
///End ADD_HPARENT_TO_MAKE_FO_MODAL

//return the uniform text for the given file name list
string get_unsave_file_list(const vector<string>& vsFileList)
{
	Window wnd = GetWindow();
	///------ Folger 07/06/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT
	//DeviceContext dc = wnd.GetDC();
	DeviceContext	dc(wnd);
	///------ End BETTER_USE_OC_DEVICE_CONTEXT
	string strFileList = "";
	for(int ii=0; ii<vsFileList.GetSize(); ii++)
	{
		strFileList += vsFileList[ii];
		
		SIZE sz;
		sz = dc.GetTextExtent(vsFileList[ii], vsFileList[ii].GetLength());
		if((ii+1)%4==0)
			strFileList += "\n";
		else if(sz.cx <= 64)
			strFileList += "\t\t";
		else if(sz.cx <= 128)
			strFileList += "\t";
	}
	return strFileList;
}

/// YuI 7/23/04 v7.5103 QA70-6582 GETN_MULTILINE_TEXT_IMPLEMENTATION
static bool OnChangeFunctionForm(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trType=trn.GetNode(cvt_str_to_tag_name(STR_FUNC_FORM), false);//STR_FUNC_TYPE	///Jasmine 03/21/06 ADD_FUNC_FORM
	//if( trn.FuncType )
	if( trType.IsValid() )
	{
		/// TD 03-06-2009 QA80-13204 FUNC_ORG_DLG_FLASHING
		DWORD dwUpdateBits = 0;
		/// end FUNC_ORG_DLG_FLASHING
		BOOL bOriginC = (trType.strVal.Compare(ORIGINC_FUNCTION_TYPE_IN_COMBO) == 0);
		
		/// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
		TreeNode	trTreatNumAsDoubl = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_TREAT_NUM_AS_DOUBLE), false);
		ASSERT( trTreatNumAsDoubl );

		if ( trTreatNumAsDoubl )
		{
			trTreatNumAsDoubl.Show = bOriginC;
		}
		/// End TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
		
		///Jasmine 03/05/07 ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX
		TreeNode tr=trn.GetNode(cvt_str_to_tag_name(STR_FUNC_TYPE), false);
		BOOL bExternalDLL;
		if(tr.IsValid())
			bExternalDLL = (tr.strVal.Compare(STR_FUNCTION_TYPE_EXTERN_DLL) == 0);
		int nButtonID =  (bOriginC && !bExternalDLL)? IDC_OPEN_IN_CODE_BUILDER_BUTTON_FIT_FUNCTION : -1;
		//trn.Function.SetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonID);
		/// TD 03-06-2009 QA80-13204 FUNC_ORG_DLG_FLASHING
		//trn.GetNode(cvt_str_to_tag_name(STR_FUNC_FUNCTION), false).SetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonID);
		int nButtonIdOld = 1;
		trn.GetNode(cvt_str_to_tag_name(STR_FUNC_FUNCTION), false).GetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonIdOld);
		if(nButtonIdOld != nButtonID)
		{
			dwUpdateBits |=  DYNACONTROL_UPDATE_SHOWHIDE;
			trn.GetNode(cvt_str_to_tag_name(STR_FUNC_FUNCTION), false).SetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonID);
		}
		/// end FUNC_ORG_DLG_FLASHING
		///Jasmine 05/11/07 ADD_DERIVATIVES_CHECKBOX
		TreeNode trDerivatives =trn.GetNode(cvt_str_to_tag_name(STR_FUNC_ENABLE_DERIVATIVES), false);
		if(trDerivatives.IsValid())
		{
			/// TD 03-06-2009 QA80-13204 FUNC_ORG_DLG_FLASHING
			BOOL bWasShown = trDerivatives.Show;
			/// end FUNC_ORG_DLG_FLASHING
			trDerivatives.Show = (!bExternalDLL && (bOriginC || trType.strVal.Compare(STR_FUNCTION_FORM_Y_SCRIPT) == 0));
			/// TD 03-06-2009 QA80-13204 FUNC_ORG_DLG_FLASHING
			//if(!trDerivatives.Show)
			//	trDerivatives.nVal = false;
			if(!trDerivatives.Show)
			{
				dwUpdateBits |= (trDerivatives.nVal ? DYNACONTROL_UPDATE_VALUE : 0)| (bWasShown ? DYNACONTROL_UPDATE_SHOWHIDE : 0);
				trDerivatives.nVal = false;
			}
			else
			{
				dwUpdateBits |=  ((!bWasShown) ? DYNACONTROL_UPDATE_SHOWHIDE : 0);
			}
			/// end FUNC_ORG_DLG_FLASHING
		}
		///End ADD_DERIVATIVES_CHECKBOX
		
		///Jasmine 08/17/2011 ORG-3522-S1 NO_INTEGAL_FOR_OC_AND_EXTERNAL_DLL
		//(!bExternalDLL && (bOriginC || trType.strVal.Compare(STR_FUNCTION_FORM_Y_SCRIPT) == 0));
		TreeNode trIntegFunc =trn.GetNode(cvt_str_to_tag_name(STR_LT_FUNC_INIT), false);
		
		TreeNode trFuncModel = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_MODEL), false); ///Junon 17/08/2012 ORG-5003 DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
		if(trIntegFunc)
		{
			BOOL bWasShown = trIntegFunc.Show;
			///Junon 17/08/2012 ORG-5003 DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
			//trIntegFunc.Show =	!trFuncModel.strVal.Compare(STR_FUNC_MODEL_IMPLICIT) == 0 && !bExternalDLL && (
					//trType.strVal.Compare(STR_FUNCTION_FORM_Y_SCRIPT) == 0 ||
					//trType.strVal.Compare(STR_FUNCTION_FORM_EQUATIONS) == 0 ||
					//trType.strVal.Compare(STR_FUNCTION_FORM_EXPRESSION) == 0 );
			trIntegFunc.Show =	trFuncModel.strVal.Compare(STR_FUNC_MODEL_IMPLICIT) != 0 && !bExternalDLL && (
							 	trType.strVal.Compare(STR_FUNCTION_FORM_Y_SCRIPT) == 0 ||
								trType.strVal.Compare(STR_FUNCTION_FORM_EQUATIONS) == 0 ||
								trType.strVal.Compare(STR_FUNCTION_FORM_EXPRESSION) == 0 );
			///End DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
			if(!trIntegFunc.Show)
			{
				dwUpdateBits |= (bWasShown ? DYNACONTROL_UPDATE_SHOWHIDE : 0);
			}
			else
			{
				dwUpdateBits |= ((!bWasShown)? DYNACONTROL_UPDATE_SHOWHIDE : 0);
			}
		}
		///End NO_INTEGAL_FOR_OC_AND_EXTERNAL_DLL
		
		/// TD 03-06-2009 QA80-13204 FUNC_ORG_DLG_FLASHING
		//dlg.SendMessage(WM_USER_ON_UPDATE_DYNA_CONTROL);	///Jasmine 03/02/07 UPDATE_DYNACONTROL_ON_FUNC_TYPE_CHANGE
		if(dwUpdateBits)
			dlg.SendMessage(WM_USER_ON_UPDATE_DYNA_CONTROL, 0, dwUpdateBits);	///Jasmine 03/02/07 UPDATE_DYNACONTROL_ON_FUNC_TYPE_CHANGE	
		/// end FUNC_ORG_DLG_FLASHING
	}
	
	return true;
}
static bool OnChangeFunctionType(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trType=trn.GetNode(cvt_str_to_tag_name(STR_FUNC_TYPE), false);
	if( trType.IsValid() )
	{
		BOOL bExternalDLL = (trType.strVal.Compare(STR_FUNCTION_TYPE_EXTERN_DLL) == 0);
		trn.GetNode(cvt_str_to_tag_name(STR_FUNCTION_DLL_SOURCE), false).Show = bExternalDLL;
		trn.GetNode(cvt_str_to_tag_name(STR_FUNC_FORM), false).Show = !bExternalDLL;
		OnChangeFunctionForm(trn, -1, nType, dlg);
	}
	
	return true;
}
///End ADD_EXTERNAL_DLL_SOURCE_EDIT_BOX

///---Sim 2011-11-21 ORG-4412 SUPPORT_IMPLICIT_FITTING_ON_FDF_FILE	
static bool OnChangeFunctionModel(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	_update_controls_on_function_model(trn);
	///Junon 17/08/2012 ORG-5003 DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
	OnChangeFunctionForm(trn, nRow, nType, dlg);
	///End DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
	return true;	
}
///---END ORG-4412 SUPPORT_IMPLICIT_FITTING_ON_FDF_FILE	

/// Iris 2/07/2012 ORG-4412-S2 FO_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC

static bool OnChangeFormulaNumbers(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trFuncModel = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_MODEL), false);
	TreeNode trFormulaNumbers = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_FORMULA_NUMBERS), false);
	TreeNode trDep = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_DEPENDENT_VARS), false);	
	
	ASSERT( trFuncModel && trDep && trFormulaNumbers );
	if( trFuncModel && nlsf_is_implicit_func(trFuncModel.strVal) && trDep && trFormulaNumbers )
	{	
		trDep.strVal = nlsf_get_dep_vars_by_formula_numbers(trFormulaNumbers.nVal);
		return true;
	}
	return false;
}

static bool OnChangeDepVars(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trDep = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_DEPENDENT_VARS), false);
	TreeNode trFormulaNumbers = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_FORMULA_NUMBERS), false);
	/// Iris 2/15/2012 ORG-4412-S2 FO_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC_MORE
	//if( trDep && trFormulaNumbers )
	TreeNode trFuncModel = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_MODEL), false);
	if( trDep && trFormulaNumbers && trFuncModel && nlsf_is_implicit_func(trFuncModel.strVal) )
	///End FO_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC_MORE
	{			
		trFormulaNumbers.nVal = nlsf_get_formula_numbers_by_dep_vars(trDep.strVal);
		return true;
	}
	return false;
}

static void _update_controls_on_function_model(TreeNode& trFunction)
{
	TreeNode trFuncModel = trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_MODEL), false);
	TreeNode trFuncType = trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_TYPE), false);
	ASSERT( trFuncModel && trFuncType );
	if( !trFuncModel || !trFuncType )
		return;
	bool bImplicit = nlsf_is_implicit_func(trFuncModel.strVal);	
	bool bSysFunction = (0 == trFuncType.strVal.CompareNoCase(STR_FUNCTION_TYPE_BUILD_IN));
	///Junon 17/08/2012 ORG-5003 DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
	TreeNode trPeakFunc = trFunction.GetNode(cvt_str_to_tag_name(STR_PEAK_FUNC_CHECK_E), false);
	if(bImplicit)
	{
		trPeakFunc.Enable = false;
		trPeakFunc.nVal = false;
	}
	else
	{
		trPeakFunc.Enable = true;
	}
	///End DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
	TreeNode trIndep = trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_INDEPENDENT_VARS), false);
	TreeNode trFormulaNumbers = trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_FORMULA_NUMBERS), false);
	TreeNode trDep = trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_DEPENDENT_VARS), false);		
	ASSERT( trIndep && trDep && trFormulaNumbers );
	if( trIndep && trDep && trFormulaNumbers )
	{		
		trIndep.SetAttribute(STR_LABEL_ATTRIB, bImplicit ? STR_FUNC_VARS : STR_FUNC_INDEPENDENT_VARS);		
		trFormulaNumbers.Show = bImplicit; 
		/// Iris 2/15/2012 ORG-4412-S2 FO_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC_MORE
		if( bImplicit ) // when function model from explicit to implicit, need convert dep name as f1, f2... according to formula numbers
			trDep.strVal = nlsf_get_dep_vars_by_formula_numbers(atoi(trFormulaNumbers.strVal));
		///End FO_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC_MORE
		trDep.SetAttribute(STR_LABEL_ATTRIB, bImplicit ? STR_FUNC_ESTIMATES : STR_FUNC_DEPENDENT_VARS);		
		trDep.Enable = !bImplicit && !bSysFunction;
	}
	
	/// Iris 2/08/2012 ORG-4412-S4 TO_HIDE_CONSTRAINTS_CONTROL_FOR_IMPLICIT_FUNC
	TreeNode trEnableConstraints= trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_ENABLE_CONSTRAINTS), false);	
	TreeNode trConstraints = trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_CONSTRAINTS), false);	
	ASSERT( trEnableConstraints && trConstraints );
	if( trEnableConstraints && trConstraints )
	{
		trEnableConstraints.Show = trConstraints.Show = !bImplicit;
	}
	///End TO_HIDE_CONSTRAINTS_CONTROL_FOR_IMPLICIT_FUNC
	
	/// Iris 3/13/2012 ORG-4412-S5 NEED_CHANGE_FUNCTION_ON_FUNC_MODEL_CHANGE
	TreeNode trFunc = trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_FUNCTION), false);
	if( bImplicit && trFunc && (0 == trFunc.strVal.Find("y =") || 0 == trFunc.strVal.Find("y=") ) )
	{
		trFunc.strVal.Delete(0);
		string strDepVar = trDep.strVal.IsEmpty() ? "f" : trDep.strVal.GetToken(0, ',');
		trFunc.strVal = strDepVar + trFunc.strVal;
	}
	///End NEED_CHANGE_FUNCTION_ON_FUNC_MODEL_CHANGE	
}		
///End FO_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC

static bool OnModifyParaInit(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trFunction=trn.GetNode(cvt_str_to_tag_name(STR_FUNC_NAME), false);
	//if( trn.FuncName )
	if( trFunction.IsValid() )
		Functions.OnModifyFunction(trFunction.strVal, TRUE);
	return true;
}

/// Iris 4/30/2008 QA80-11474 ADD_USE_ORIGINC_CHECKBOX_FOR_PARAM_INIT_SCRIPT
static bool OnEnableParamUseOriginC(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode	trUseOriginC = tree_get_node(trn, nRow);
	TreeNode 	trParaInit = trn.GetNode(cvt_str_to_tag_name(STR_FUNC_PARA_INIT_GUI), false);	
	
	ASSERT( trUseOriginC );
	ASSERT( trParaInit );
	
	if( trUseOriginC && trParaInit )
	{
		bool		bEnableEditInBuilder = trUseOriginC.nVal;
		/// TD 05-08-2008 QA80-11524 CLICK_ON_PARAM_OPENS_FUNCTION_IN_CODE_BUILDER
		//int 		nButtonID =  bEnableEditInBuilder? IDC_OPEN_IN_CODE_BUILDER_BUTTON_FIT_FUNCTION : -1;
		int 		nButtonID =  bEnableEditInBuilder? IDC_OPEN_IN_CODE_BUILDER_BUTTON_PARA_INIT : -1;
		/// end CLICK_ON_PARAM_OPENS_FUNCTION_IN_CODE_BUILDER
		/// TD 03-06-2009 QA80-13204 FUNC_ORG_DLG_FLASHING
		//trParaInit.SetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonID);
		//dlg.SendMessage(WM_USER_ON_UPDATE_DYNA_CONTROL);	
		int nButtonIDOld = -1;
		trParaInit.GetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonIDOld);
		if(nButtonIDOld != nButtonID)
		{
			trParaInit.SetAttribute(STR_MULTILINE_BUTTON_ID_ATTRIB, nButtonID);
			dlg.SendMessage(WM_USER_ON_UPDATE_DYNA_CONTROL, 0, DYNACONTROL_UPDATE_SHOWHIDE);	
		}
		/// end FUNC_ORG_DLG_FLASHING
		
		return true;
	}
	
	return false;
}
///end ADD_USE_ORIGINC_CHECKBOX_FOR_PARAM_INIT_SCRIPT

///Jasmine 03/02/07 ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
static bool OnEnableParaInit(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trCheck = tree_get_node(trn, nRow);
	TreeNode trParaInit=trn.GetNode(cvt_str_to_tag_name(STR_FUNC_PARA_INIT_GUI), false);
	if(trCheck.IsValid() && trCheck.Enable == 1 && trParaInit.IsValid())
		trParaInit.Enable = trCheck.nVal;
	return true;
}
static bool OnEnableConstraints(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trCheck = tree_get_node(trn, nRow);
	TreeNode trContraints=trn.GetNode(cvt_str_to_tag_name(STR_FUNC_CONSTRAINTS), false);
	if(trCheck.IsValid() && trContraints.IsValid())
		trContraints.Enable = trCheck.nVal;
	return true;
}
///End ADD_ENABLE_PARA_INIT_AND_ENABLE_CONSTRAINTS
static bool OnModifyFunctionBody(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trFunction=trn.GetNode(cvt_str_to_tag_name(STR_FUNC_NAME), false);
	//if( trn.FuncName  )
	if( trFunction.IsValid()  )
		Functions.OnModifyFunction(trFunction.strVal, FALSE);
	return true;
}
/// end GETN_MULTILINE_TEXT_IMPLEMENTATION


#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
BOOL Foopen()
{
	//------ Folger 12/14/07 CENTRALIZED_CODE_OF_HIDING_RESERVE_CATEGORIES
	//FODlg 	myDlg;
	DWORD dw = is_pro_version() ? FO_SHOW_ALL_CATEGORIES : FO_REMOVE_RESERVE_CATEGORIES;
	FODlg	myDlg(NULL, dw);
	//------
	
	///Jasmine 01/23/06 GETWINDOW_TO_PARENT_WIN
	//int nRet = myDlg.DoModalEx(GetWindow());
	HWND hParent = GetWindow();
	if(hParent)
	{
		int nRet = myDlg.DoModalEx(hParent);
		return (nRet != IDCANCEL);
	}
	///End GETWINDOW_TO_PARENT_WIN
	return false;
}
