 /*-----------------------------------------------------------------------------*
 * File Name: FunctionBrowser.h		 											*
 * Creation: Danice	 															*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 1/24/05 QA70-7345 v8.0185 CREATATION										*
 * DG 3/11/05 v8.0202 FB_STRUCTURE_REWRITE										*
 * DG 4/2/05 v8.0214 MAKE_FB_MULTIPANEDLG										*
 *------------------------------------------------------------------------------*/

#ifndef _FB_H
#define _FB_H
#include <tree_utils.h>
#include "FBFilter.h"
//class FunctionBrowserDlg : public ResizeDialog///DG MAKE_FB_MULTIPANEDLG
class FunctionBrowserDlg : public MultiPaneDlg
{
public :
	FunctionBrowserDlg() : MultiPaneDlg(IDD_FB_DLG, "Odlg8") 
	{
		vector<uint> vnCategoryGroup = {IDC_FB_CATEGORY_TEXT, IDC_FB_CATEGORY_COMB, IDC_FB_CATEGORY_SELECT_BTN, 0};
		vector<uint> vnFilterGroup = {IDC_FB_FILTER_TEXT, IDC_FB_FILTER_COMB, IDC_FB_FILTER_EDIT_BTN, 0};
		vector<uint> vnSearchGroup = {IDC_FB_SEARCH_LABEL, IDC_FB_SEARCH_ED, IDC_FB_SEARCH_BTN, 0};
		
		m_vnCategoryGroup = vnCategoryGroup;
		m_vnFilterGroup = vnFilterGroup;
		m_vnSearchGroup = vnSearchGroup;
	}
	int  DoModal(HWND hParent = NULL) //call from xf-dialog
	{
		InitMsgMap();
		int nRet = MultiPaneDlg::DoModal(hParent);
		return nRet;
	}
	int Create(HWND hParent=NULL) //call from CB, etc
	{
		InitMsgMap();
		int nRet = MultiPaneDlg::Create(hParent);
		return nRet;
	}
	string GetFunction() { return m_strInsertFunction; }
protected:
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_SIZE(OnDlgResize)
	ON_DESTROY(OnDestroy)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	ON_OK(OnInsert)
	
	ON_BN_CLICKED(IDC_FB_SHOW_DETAIL, OnShowBottomPane)
	
	ON_BN_CLICKED(IDC_FB_CATEGORY_SELECT_BTN, OnClickSelectCate)
	ON_BN_CLICKED(IDC_FB_FILTER_EDIT_BTN, OnClickFilter)
	ON_BN_CLICKED(IDC_FB_SEARCH_BTN, OnClickSearchFunction)
	
	ON_CBN_SELCHANGE(IDC_FB_CATEGORY_COMB, OnCategoryChange)
	ON_CBN_SELCHANGE(IDC_FB_FILTER_COMB, OnFilterChange)
	
	ON_GRID_ROW_COL_CHANGE(IDC_FB_FUNCTION_LIST, OnRowChange)	
	ON_GRID_MOUSE_MOVE(IDC_FB_FUNCTION_LIST, OnMouseMoveList)
EVENTS_END
	
	bool 	OnInitDialog();
	void	OnDestroy();
	bool 	OnDlgResize(int nType, int cx, int cy);
	bool 	OnInsert();
	bool	OnShowBottomPane(Control ctrl);
	
	bool 	OnClickSelectCate(Control ctrl);
	bool 	OnClickFilter(Control ctrl);
	bool 	OnClickSearchFunction(Control ctrl);
	
	bool 	OnCategoryChange(Control ctrl);
	bool 	OnFilterChange(Control ctrl);
	
	void	OnRowChange(Control ctrl);
	void 	OnMouseMoveList(Control ctrl, short nButton, short nShift, float X, float Y);
	
private:
	///Forest 4/5/05 SAVE_AND_LOAD_USE_SELECTION
	bool	saveSelections();
	bool	loadSelections();
	///End SAVE_AND_LOAD_USE_SELECTION
	
	void	repositionControl(int cx, int cy);
	
	void	updateFunctionDetail();
	
	void 	LoadCateListToCombo(LPCSTR lpcSelected = NULL);
	
	void	LoadFilterListToCombo(LPCSTR lpcDispName = NULL);

private:
	OCFBFunctionList			m_List;
	
	ComboBox					m_cmboxCateList;
	ComboBox					m_cmboxFilterList;
	Edit						m_edSearch;//search edit box
	RichEdit					m_rchDetail;
	
	string						m_strInsertFunction;
	
	vector<uint>				m_vnCategoryGroup;
	vector<uint>				m_vnFilterGroup;
	vector<uint>				m_vnSearchGroup;
};

#endif //_FB_H