/*------------------------------------------------------------------------------*
 * File Name: FitWizCoreBase.h													*
 * Creation: Jasmine 11/10/08													*
 * Purpose: Origin C Header Files												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 12/11/08 QA80-12765 v8.0985 CHANGE_PARAMETER_FAILS_TO_REMEMBER_SETTINGS_FROM_LAST_CLOSE_IN_PA_FITTING
 *	Folger 12/30/08 v8.0992 NANOSIZER_USING_NEW_XFWIZARD_FRAMEWORK				*
 *	Folger 02/11/09 SHARE_WIZ_CORE_BASE_CODE_BETWEEN_PA_AND_NANOSIZER			*
 *	Folger 02/13/09 IGNORE_AUTO_INIT_STATUS_IF_AND_ONLY_IF_CHANGE_PARAM			*
 *	Jasmine 04/24/09 DEFINE_DATA_ID__USED_IN_PA_NANO_SIZER_FIT_TREE				*
 *	Jasmine 04/28/09 ASSIGN_ID_NEED_IMPROVE										*
 *	Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT								*
 *	Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT							*
 *	Folger 06/26/09 NANOSIZER_FAILS_TO_REMEMBER_DEFAULT_FUNCTION_IN_THEME		*
 *	Jasmine 06/30/09 NANOSIZER_NEED_FITTYPE_TO_SHOW_SPEC_NODE_IN_GUI_TREE		*
 *	Sophy 7/6/2009 SUPPORT_NANOSIZER_OUTPUTGUIMANAGER							*
 *	Folger 09/05/09 FAILS_TO_PASTE_RESULTS_TABLE_TO_REPORT_GRAPH_DURING_CHANGE_PARAM_IN_PA
 *	Folger 10/20/09 NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT						*
 *	Folger 10/28/09 QA81-14552 WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA		*
 *	Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE					*
 *	Kyle 03/11/2010 PICK_PEAK_ROI_TOOL_SHARES_UTILS_FUNCTION_WITH_PA			*
 *  Iris 3/23/2011 ORG-2504-S1 CHANGE_MAX_ITER_NUM_AND_TOLERANCE_FOR_PA			*
 *	Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
 *------------------------------------------------------------------------------*/

#ifndef __FIT_WIZ_CORE_BASE_H__
#define __FIT_WIZ_CORE_BASE_H__

#include <..\OriginLab\XFCore.h>
#include <..\OriginLab\XFWiz.h>
#include <..\OriginLab\pa_utils.h>

#define LIMIT_MAX_ITERATIONS_OF_PEAK_FIT		50		///Jasmine 04/07/08 MAX_ITER_SHARED_IN_PAFIT_AND_SPFMFIT
#define LIMIT_TOLERANCE_OF_PEAK_FIT				0.05	///Jasmine 04/08/08 HIGHER_TOLERANCE_BY_EASWAR_REQUEST
/// Iris 3/23/2011 ORG-2504-S1 CHANGE_MAX_ITER_NUM_AND_TOLERANCE_FOR_PA
#define LIMIT_MAX_ITERATIONS_OF_PA_FIT			200
#define LIMIT_TOLERANCE_OF_PA_FIT				1e-6
///End CHANGE_MAX_ITER_NUM_AND_TOLERANCE_FOR_PA

#define		PEAK_FITTING_OUTPUT_EMPTY_RANGE_NAME		"FitPeak"		///------ Folger 01/19/09 QA80-12969 PA_FITTING_SUPPORT_ANALYSIS_TEMPLATE

///Jasmine 04/24/09 DEFINE_DATA_ID__USED_IN_PA_NANO_SIZER_FIT_TREE
///Jasmine 04/28/09 ASSIGN_ID_NEED_IMPROVE
enum{
	PEAK_FITTING_DATAID_FITCONTROL_TREE_BEGIN 	= 1,
	PEAK_FITTING_DATAID_FITCONTROL_TREE_END 	= 10,

	PEAK_FITTING_DATAID_RESULT_TREE_BEGIN		= 20,
	PEAK_FITTING_DATAID_RESULT_TREE_END			= 120,//80	///Jasmine 06/25/09 ASSIGN_ID_NEED_IMPROVE
	
	PEAK_FITTING_DATAID_BASELINE_PARAMS			= 500,	
	PEAK_FITTING_DATAID_DEFAULT_FUNCTION		= 501,	 ///------ Folger 06/26/09 NANOSIZER_FAILS_TO_REMEMBER_DEFAULT_FUNCTION_IN_THEME
};


#define FITWIZ_BASE_ANCHOR_X_DATAID_IN_GETN_TREE       GET_USER_DATAID(0) + 100
#define FITWIZ_BASE_ANCHOR_Y_DATAID_IN_GETN_TREE       GET_USER_DATAID(0) + 200

#define FITWIZ_PEAK_XC_DATAID_IN_GETN_TREE      	   GET_USER_DATAID(0) + 300
#define FITWIZ_PEAK_H_DATAID_IN_GETN_TREE              GET_USER_DATAID(0) + 400

//------ Folger 12/03/08 QA80-12701 v8.0982 THEME_SETTING_CONTROL_FOR_BASELINE_FUNCTION_APPLIED_IN_PA_FIT
#define	FITWIZ_PEAK_FITTING_DATAID_START				GET_USER_DATAID(0) + 1000

#define	FITWIZ_PEAK_FITTING_DATAID_RANGE_UID			FITWIZ_PEAK_FITTING_DATAID_START
#define	FITWIZ_PEAK_FITTING_DATAID_GRAPH_UID			FITWIZ_PEAK_FITTING_DATAID_START + 1
///------ Folger 09/05/09 FAILS_TO_PASTE_RESULTS_TABLE_TO_REPORT_GRAPH_DURING_CHANGE_PARAM_IN_PA
#define	FITWIZ_PEAK_FITTING_DATAID_RESULT_TABLE_UID		FITWIZ_PEAK_FITTING_DATAID_START + 2
///------ End FAILS_TO_PASTE_RESULTS_TABLE_TO_REPORT_GRAPH_DURING_CHANGE_PARAM_IN_PA

#define	FITWIZ_PEAK_FITTING_DATAID_DISABLED_CENTER		FITWIZ_PEAK_FITTING_DATAID_START + 10
#define	FITWIZ_PEAK_FITTING_DATAID_DISABLED_HEIGHT		FITWIZ_PEAK_FITTING_DATAID_START + 11

#define	FITWIZ_PEAK_FITTING_DATAID_BASELINE_FUNCTION	FITWIZ_PEAK_FITTING_DATAID_START + 20

//------ Folger 12/11/08 QA80-12765 v8.0985 CHANGE_PARAMETER_FAILS_TO_REMEMBER_SETTINGS_FROM_LAST_CLOSE_IN_PA_FITTING
#define	FITWIZ_PEAK_FITTING_DATAID_FITWORKAREA_BEGIN	FITWIZ_PEAK_FITTING_DATAID_START + 30
#define	FITWIZ_PEAK_FITTING_DATAID_FITWORKAREA_END		FITWIZ_PEAK_FITTING_DATAID_START + 49
//------ End CHANGE_PARAMETER_FAILS_TO_REMEMBER_SETTINGS_FROM_LAST_CLOSE_IN_PA_FITTING

#define	FITWIZ_PEAK_FITTING_DATAID_END					GET_USER_DATAID(0) + 2000

#define	FITWIZ_BASE_CREATE_DATAID_FUNCTION_USING		FITWIZ_PEAK_FITTING_DATAID_END
//------ End THEME_SETTING_CONTROL_FOR_BASELINE_FUNCTION_APPLIED_IN_PA_FIT
///End ASSIGN_ID_NEED_IMPROVE
///End DEFINE_DATA_ID__USED_IN_PA_NANO_SIZER_FIT_TREE

#define		PeakWizManager		XFWizManager

/*	
FitWizCoreBase should not have xf steps.
It only concerns about fitting and report
*/
////////////////////////////////////////////////////////
///////////////////	FitWizCoreBase	////////////////////
////////////////////////////////////////////////////////

///Sophy 11/29/2011 ORG-145-P3 PROPER_INIT_PARAMETER_VALUES_WHEN_MODIFIED_PEAK_ON_CHANGE_PARAM
enum {
	CORECONTROL_PEAK_MODIFIED	= 0x0001,
};
///end PROPER_INIT_PARAMETER_VALUES_WHEN_MODIFIED_PEAK_ON_CHANGE_PARAM
class FitWizCoreBase : public XFCore
{
public:
	FitWizCoreBase();
	~FitWizCoreBase();
	
	void 				SetFinishButtonClicked(bool bClicked = true);
	bool 				IsFinishButtonClicked();
	
	//------ Folger 10/16/08 SAVE_PLOT_UIDS_IN_PA_CORE_TO_WORKAROUND_MISSING_PREVIEW_PLOT_IN_PA_FIT
	bool				AccessOriginalRangePlots(vector<uint>& vnPlots, bool bGet = true);
	//------
	
	//------ Folger 12/30/08 v8.0992 NANOSIZER_USING_NEW_XFWIZARD_FRAMEWORK
	bool				GetTargetPage(Page& pg);
	//------ End NANOSIZER_USING_NEW_XFWIZARD_FRAMEWORK
	
	///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
	virtual	bool		GetPreviewLayer(GraphLayer& gl,  bool bSetActive = true)		{ ASSERT(false); return false; }
	///------ End NANOSIZER_FITTING_BASED_SUPPORT
	///Sophy 11/29/2011 ORG-145-P3 PROPER_INIT_PARAMETER_VALUES_WHEN_MODIFIED_PEAK_ON_CHANGE_PARAM
	BOOL				GetCoreControl(DWORD dwBit){ return O_QUERY_BOOL(m_dwCtrl, dwBit); }
	void				SetCoreControl(DWORD dwBit, bool bAdd = true){ O_SET_BIT(m_dwCtrl, dwBit, bAdd); }
	///end PROPER_INIT_PARAMETER_VALUES_WHEN_MODIFIED_PEAK_ON_CHANGE_PARAM
public:	 	
	virtual void 		Destroy();
	
	/// Iris 11/04/2008 v8.0965b NEW_PA_SUPPORT_CREATE_REPORT_GRAPH_ON_SOURCE
	//bool				GetSourceRange(XYRange& xySource){xySource = m_xySource; return xySource.IsValid()}///Sandy 2008-11-4 Iris need a really born input range without any change(after plot)
	virtual bool		GetSourceRange(DataRange& drSource);
	void				SetSourceRange(const DataRange& drSource);
	///end NEW_PA_SUPPORT_CREATE_REPORT_GRAPH_ON_SOURCE
	
	virtual bool 		HasBaseline();
	
	///------ Folger 12/21/2011 ORG-4653-P1 AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
	/*
	//------ Folger 12/11/08 QA80-12765 v8.0985 CHANGE_PARAMETER_FAILS_TO_REMEMBER_SETTINGS_FROM_LAST_CLOSE_IN_PA_FITTING
	bool				IsAutoUpdated();
	//------
	///------ Folger 02/13/09 IGNORE_AUTO_INIT_STATUS_IF_AND_ONLY_IF_CHANGE_PARAM
	bool				IsChangeParam();
	///------ End IGNORE_AUTO_INIT_STATUS_IF_AND_ONLY_IF_CHANGE_PARAM

	///------ Folger 10/28/09 QA81-14552 WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA
	bool				IsRecalculate();
	///------ End WRONG_REPORT_STATUS_WHEN_CHANGE_PARAM_IN_PA
	
	///Jasmine 02/17/11 ORG-544-P1 NO_FIT_OUTCOME_IN_SCRIPT_MOCE
	bool				IsOpenWizDlg();
	///End NO_FIT_OUTCOME_IN_SCRIPT_MOCE
	*/
	///------ End AUTO_UPDATE_SHOULD_NOT_BREAK_IF_INPUT_IS_EMPTY_FOR_XF
	
	virtual int			GetBaselineFitFunc(string& strFuncName) { return -1; } /// Iris 12/24/2008 v8.0990c FIX_APPLY_SHARE_TO_BASELINE_PARAM_IF_CHANGED_FUNC_IN_BASECREATE_PAGE
	/// Iris 01/16/2009 FIX_APPLY_SHARE_TO_INCORRECT_PARAM_IF_HAS_BASELINE_FUNC_WITHOUT_FIT
	virtual bool		GetBaselineFitMode(){ return false; }  
	virtual	int			GetBaseMode() { return PA_BM_CONSTANT; }
	///end FIX_APPLY_SHARE_TO_INCORRECT_PARAM_IF_HAS_BASELINE_FUNC_WITHOUT_FIT
	
	///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
	virtual	bool		GetBaseParamFixMode() { return false; }
	///------ End NANOSIZER_FITTING_BASED_SUPPORT

	///------ Folger 10/20/09 NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT
	bool				AccessPeakLabelSettings(int& nLabelXYType, bool bGet = true);
	virtual	bool		GetPeaksCenterRange(XYRange& xyPeaksCenter)		{ ASSERT(FALSE); return FALSE; }
	///------ End NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT

	///------ Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
	virtual	BOOL		CheckUpdateOperationTree(DWORD dwUIDOp);
	BOOL				UpdateGetNFromWizOp(TreeNode& trGetN);
	///------ End REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
	
///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
public:
	ODWP				m_dwGetDoneDlg;
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
				
protected:
	XFWizInputOutputRange*	getIORange();
	///------ Folger 02/11/09 SHARE_WIZ_CORE_BASE_CODE_BETWEEN_PA_AND_NANOSIZER
	//bool				getContextRange(XYRange& xy, LPCSTR lpcszXFName, bool bIsInput, int nIndex = 0);
	bool				getContextRange(DataRange& dr, LPCSTR lpcszXFName, bool bIsInput, int nIndex = 0);
	///------ End SHARE_WIZ_CORE_BASE_CODE_BETWEEN_PA_AND_NANOSIZER
			
	///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	virtual bool		Apply();
	virtual bool		IsFitStep() { ASSERT(FALSE); return false; }
	///---END NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	
	///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	Worksheet	 		CheckGetInterimResult(const string strInterimSheet);
	virtual string		GetTempBookPrefix() { ASSERT(FALSE); return ""; }
	///---END NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT

	///------ Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
private:
	BOOL				UpdateFittingOutputs(TreeNode& trGetN);
	///------ End REUID_PA_OUTPUTS_FOR_AUTO_UPDATE

protected:
	///---Sim 06-23-2009 NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
 	int 				m_nInstanceID;
 	WorksheetPage       m_wpInterim;
	///---END NANOSIZER_WIZ_AUTO_UPDATE_SUPPORT
	
private:
	GraphLayer 			m_glOriginal;
		
	vector<uint>		m_vnOriginalRangePlots;	//------ Folger 10/16/08 SAVE_PLOT_UIDS_IN_PA_CORE_TO_WORKAROUND_MISSING_PREVIEW_PLOT_IN_PA_FIT
	
	DataRange			m_drSource; /// Iris 11/04/2008 v8.0965b NEW_PA_SUPPORT_CREATE_REPORT_GRAPH_ON_SOURCE
	
	bool 				m_bIsFinishButtonClicked; 

	///------ Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
	vector<int>			m_vnSourceGraphUID;
	vector<uint>		m_vnIdsToUIDs;
	vector<int>			m_vnReportLayerUID;
	///------ End REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
	DWORD				m_dwCtrl;	///Sophy 11/29/2011 ORG-145-P3 PROPER_INIT_PARAMETER_VALUES_WHEN_MODIFIED_PEAK_ON_CHANGE_PARAM
};

/*
put util function shared in PA&Nanosizer here
I want to put them in XFWizard_utils, 
but it need GetN.h
*/
////////////////////////////////////////////////////////
///////////////////	util functin	////////////////////
////////////////////////////////////////////////////////
void xf_turnon_user_event_receiver(TreeNode& trGetN);

///Jasmine 06/30/09 NANOSIZER_NEED_FITTYPE_TO_SHOW_SPEC_NODE_IN_GUI_TREE
//bool create_op_get_gui_tree(TreeNode& trOp, TreeNode& trGUI, LPCSTR lpcszOperation);
///Sophy 7/6/2009 SUPPORT_NANOSIZER_OUTPUTGUIMANAGER
//bool create_op_get_gui_tree(TreeNode& trOp, TreeNode& trGUI, LPCSTR lpcszOperation, int nOption = 0);
typedef	struct tagXFInfo {
	string		strSetInfoFromXF;
	StringArray	saOptions;
	StringArray	saNames;
	string		strCategory;
}XFInfo;
bool create_op_get_gui_tree(TreeNode& trOp, TreeNode& trGUI, LPCSTR lpcszOperation, XFInfo* xfInfo = NULL);
///end SUPPORT_NANOSIZER_OUTPUTGUIMANAGER
///End NANOSIZER_NEED_FITTYPE_TO_SHOW_SPEC_NODE_IN_GUI_TREE

int assign_new_ID(TreeNode& tr, int& nID);

///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
class PeakFitHelperBase;
bool access_peak_params_dlg(PeakFitHelperBase *pFitHelperBase, int nOption, DWORD dwCntrl = 0);
///------ End NANOSIZER_FITTING_BASED_SUPPORT

//----- Iris 2008-10-09 NEW_PA
//bool 	   	xf_check_is_user_event(TreeNode& trGetN, int& nUserEventID = NULL);
bool 	   	xf_check_is_user_event(TreeNode& trGetN, int& nUserEventID = NULL, int* pnUserEventInfo = NULL);
//-----

bool 		construct_tree_from_xyrange(TreeNode& trXYR, const DataRange& xy);

///Kyle 03/11/2010 PICK_PEAK_ROI_TOOL_SHARES_UTILS_FUNCTION_WITH_PA, moved to graph_utils.h
// ///------ Folger 10/20/09 NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT
// bool		get_plot_from_xyr_in_gl(GraphLayer gl, XYRange& xy,  DataPlot& dp, int nPlotType = -1);
// ///------ End NANOSIZER_FAILS_TO_SWITCH_LABEL_PLOT
///End PICK_PEAK_ROI_TOOL_SHARES_UTILS_FUNCTION_WITH_PA

#endif//__FIT_WIZ_CORE_BASE_H__
