/*------------------------------------------------------------------------------*
 * File Name: FitFuncWiz.h	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 06/22/10 ORG-2-S2 WANT_DESTINATION_PATH								*
 *	Jasmine 06/23/10 ORG-2-S4 FUNCTION_WIZARD_ALLOW_USER_DEFINED_FUNC_CHANGE_FORM*
 *	Jasmine 07/09/10 ORG-2-P11 REMEMBER_LAST_USE_CATEGORY						*
 *	Jasmine 07/14/10 FFW_TEST_SPEED												*
 *	Folger 08/12/10 ORG-733-P2 UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD		*
 *	Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
 *	Folger 09/25/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD			*
 *	Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL					*
 *	Zech ORG-3779-S1 SHOW_REMIND_MESSAGE_WHEN_SUCCESSFULLY_SAVE_FITTING_FUNCTION_IN_FITTING_FUNCTION_BUILDER
 *	Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
 *	Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
 *	Sim 2011-11-18 ORG-4409 FIX_FDF_SHOULD_NOT_DELETE_LT_FUNC_INIT_SECT			*
 *	Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY					*
 *  Junon 13/09/2012 ORG-6812-P1 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER*
 *  Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 this file contains seven classes:
 	1. FitFuncWizPlaceHolder
 	2. FitFuncWizDlg 	
 *------------------------------------------------------------------------------*/ 
 
#ifndef _FFW_H
#define _FFW_H

#include <okocUtils.h>
#include "DialogEx.h"

//---Jasmine 07/14/10 FFW_TEST_SPEED
//#define FFW_TEST_SPEED
#include <Profiler.h>

#ifdef FFW_TEST_SPEED
	#define _SHOW_TIME(_ID, _STR)			Profiler junk; MyOutput output(_ID, _STR);
#else
	#define _SHOW_TIME(_ID, _STR)
#endif
//---

#define	STR_FFW_DLG_NAME			"Fitting Function Wizard"	///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
#define STR_FFW_DLG_CATEGORY		"Category"					///Jasmine 07/09/10 ORG-2-P11 REMEMBER_LAST_USE_CATEGORY

#include "FFWPages.h"
#include "FFWParamPage.h"
#include "FFWFuncBodyPage.h"
#include "FFWIntegralPages.h"


//for test
void _out(int nPageID, LPCSTR lpcszTemp)
{
	string str(lpcszTemp);
	str += " ";
	switch (nPageID)
	{
		case IDD_FIT_FUNC_NAME_PAGE:
			str += "IDD_FIT_FUNC_NAME_PAGE";
			break;
		case IDD_FIT_FUNC_TYPE_PAGE:
			str += "IDD_FIT_FUNC_TYPE_PAGE";
			break;
		case IDD_FIT_FUNC_PARAM_PAGE:
			str += "IDD_FIT_FUNC_PARAM_PAGE";
			break;
		case IDD_FIT_FUNC_BEFORE_AFTER_PAGE:
			str += "IDD_FIT_FUNC_BEFORE_AFTER_PAGE";
			break;
		case IDD_FIT_FUNC_INTEGRAND_PAGE:
			str += "IDD_FIT_FUNC_INTEGRAND_PAGE";
			break;
		case IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE:
			str += "IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE";
			break;
		case IDD_FIT_FUNC_INITIAL_CODE_PAGE:
			str += "IDD_FIT_FUNC_INITIAL_CODE_PAGE";
			break;
		case IDD_FIT_FUNC_DERIVED_PARAMETERS_PAGE:
			str += "IDD_FIT_FUNC_DERIVED_PARAMETERS_PAGE";
			break;
		case IDD_FIT_FUNC_BOUNDS_CONSTRAINTS_PAGE:
			str += "IDD_FIT_FUNC_BOUNDS_CONSTRAINTS_PAGE";
			break;
		case IDD_FIT_FUNC_BODY_PAGE:
			str += "IDD_FIT_FUNC_BODY_PAGE";
			break;
		case IDD_FIT_FUNC_GOAL_PAGE:
			str += "IDD_FIT_FUNC_GOAL_PAGE";
			break;
		default:
			ASSERT(FALSE);
	}
	out_str(str);
}

class MyOutput
{
public:
	MyOutput(int nID, LPCSTR lpczOutput){m_ID = nID; m_str = lpczOutput;}
	~MyOutput(){out_str(""); _out(m_ID, m_str);}
private:
	string 	m_str;
	int		m_ID;
};

/*------------------------------------------------------------------------------*
 * FitFuncWizPlaceHolder 														*
 *------------------------------------------------------------------------------*/
 
/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
// Move to NLFitSelFunction.h, otherwise this enumeration cannot be used in NLFit when calling function OpenFitFuncWizDlg without using default value
/*
enum{
	FFW_MODE_AUTO			= 0x0000, //should be detecteed by input trFDF tree.
	FFW_CREATE_FUNC 		= 0x0001,
	FFW_EDIT_BUILTIN_FUNC	= 0x0002,
	FFW_EDIT_USER_FUNC		= 0x0003,
	FFW_CREATE_OR_EDIT		= 0x0004,
	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	FFW_MODE_MASK			= 0x00FF,
	FFW_OPTION_MASK			= 0xFF00,
	FFW_OPT_CREATE_NEW		= 0x0100,
	///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
};
*/
/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION


///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
enum
{
	FFWRESULTS_ONFINISH			= 0x00010000,
};
///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD

class FitFuncWizPlaceHolder : public WizardSheet
{
private :
	int							m_nJumpToPage;
	int							m_nJumpFromPage;
	FFWGoalPage                 m_FFWGoalPage;
	FFWNameTypePage				m_FFWNameTypePage;
	FFWParamPage				m_FFWParamPage;
	FFWFitFuncBodyPage			m_FFWFuncBodyPage;
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	/*
#ifdef INTEGRAL_CONVOLUTION_READY_IN_FFW
	FFWIntegrandPage			m_FFWIntegrandPage;
	FFWFitIntegralPage			m_FFWFitIntegralPage;
#endif//INTEGRAL_CONVOLUTION_READY_IN_FFW
	*/
	FFWFitIntegralPage			m_FFWFitIntegralPage;
	///End CREATE_FITFUNC_WITH_INTEGRAL
	FFWInitialCodePage			m_FFWInitialCodePage;
	FFWBoundsConstraintsPage	m_FFWBoundsConstraintsPage;
	FFWDerivedParametersPage	m_FFWDerivedParametersPage;
	FFWBeforeAfterPage			m_FFWBeforeAfterPage;

	int 						m_nFFWMode;
	
	/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	bool						m_bIsNewCategory;
	string						m_strOpenedCategory;
	/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	
	DWORD						m_dwFoCntrl;		///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
	
	///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	LPDWORD						m_pdwResults;
	///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD

	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	HWND						m_hwndDlg;
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS

public:
	Tree						m_trFunction;
	///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	//FFWFunctionOrganizer		m_NFO;
	FFWFunctionOrganizer*		m_pNFO;
	///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	
	
public:
	///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	//FitFuncWizPlaceHolder(){ m_nJumpToPage = m_nJumpFromPage = -1; m_nFFWMode = FFW_MODE_AUTO; }
	FitFuncWizPlaceHolder(NumFunctionOrganizer* pNFO = NULL
		///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
		, LPDWORD pdwResults = NULL
		///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
		)
	{
		m_nJumpToPage = m_nJumpFromPage = -1; m_nFFWMode = FFW_MODE_AUTO;
		m_pNFO = new FFWFunctionOrganizer(pNFO);
		m_bIsNewCategory = false; m_strOpenedCategory.Empty();	/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
		///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
		if ( (m_pdwResults = pdwResults) )
			*m_pdwResults = 0;
		///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
		///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
		m_hwndDlg = NULL;
		///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	}
	~FitFuncWizPlaceHolder()
	{
		NICE_SAFE_REMOVAL(m_pNFO);
	}
	///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO

	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	void	SetDlgHwnd(HWND hWnd)	{ m_hwndDlg = hWnd; }
	HWND	GetDlgHwnd()			{ return m_hwndDlg; }
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS

	void	SetMode(int nFFWMode){ m_nFFWMode = nFFWMode; }	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	int		GetMode(){ return m_nFFWMode; }
	void 	InitMaps(WndContainer& wnd);
	
	void 	OnCodeBuilderContentChange();
	bool 	OnFinish();
	///------ Folger 09/25/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	bool 	OnCancel(BOOL bCanFinish);
	///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	
	void	SaveSettings();///Jasmine 07/09/10 ORG-2-P11 REMEMBER_LAST_USE_CATEGORY

	//---wizard path control
	int 	MarkNextPage(int nFromID, int nToID, int nPageID, int nOption = -1);
	int 	MarkPreviousPage(int nFromID, int nToID, int nPageID, int nOption = -1);
	bool 	IsExpectedPage(int nPageID);
	void 	ResetExpectedPage();
	int 	RetrieveToPage();
	int  	RetrieveFromPage();
	
	bool 	IsEditablePage(int nPageID);
	
	void 	UpdateButtonStatus(int nPageID);
	//---
	
	/// Bill 07/05/2010 ORG-478-P3 CHECK_CREATE_OR_EDIT_FUNCTION
	bool	IsCreateMode()
	{
		///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
		//return m_nFFWMode == FFW_CREATE_FUNC;
		if ( m_nFFWMode == FFW_CREATE_FUNC)
			return true;
		
		if( m_nFFWMode == (FFW_CREATE_OR_EDIT | FFW_OPT_CREATE_NEW) )
			return true;
		
		return false;
		///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	}
	bool	IsEditMode()
	{
		///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
		//return m_nFFWMode == FFW_EDIT_BUILTIN_FUNC || m_nFFWMode == FFW_EDIT_USER_FUNC;
		return !IsCreateMode();
		///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	}
	/// End CHECK_CREATE_OR_EDIT_FUNCTION
	
	/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	void SetIsNewCategory(bool bIsNewCategory) {m_bIsNewCategory = bIsNewCategory;}
	bool IsNewCategory() {return m_bIsNewCategory;}
	
	void SetOpenedCategory(LPCSTR lpcszOpenedCategory) {m_strOpenedCategory = lpcszOpenedCategory;}
	string GetOpenedCategory() {return m_strOpenedCategory;}
	/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	
	///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
	void SetFoCntrl(DWORD dwCntrl) 
	{
		m_dwFoCntrl =  dwCntrl;
	}
	bool IsDisableCategory() 
	{
		if(m_dwFoCntrl == FO_SHOW_ONE_CATEGORY)
			return true;
		else
			return false;
	}
	bool IsRemoveReserveCategory() 
	{
		if(m_dwFoCntrl == FO_REMOVE_RESERVE_CATEGORIES)
			return true;
		else
			return false;
	}
	///------ End SET_BIT_TO_DISABLE_CATEGORY
	
private:
	int 	checkWizardMode();
};
	
void FitFuncWizPlaceHolder::InitMaps(WndContainer& wnd)
{
	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	//m_nFFWMode = checkWizardMode(); should be init by SetMode();
	if ( m_nFFWMode == FFW_MODE_AUTO )
		m_nFFWMode = checkWizardMode();
	///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	
	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	if ( (m_nFFWMode & FFW_MODE_MASK) == FFW_CREATE_OR_EDIT )
	{
	m_FFWGoalPage.InitPage(IDD_FIT_FUNC_GOAL_PAGE,this,wnd);
	AddPage(m_FFWGoalPage);
	}
	///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	m_FFWNameTypePage.InitPage(IDD_FIT_FUNC_TYPE_PAGE, this, wnd);
	AddPage(m_FFWNameTypePage);
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	m_FFWFitIntegralPage.InitPage(IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE, this, wnd);
	AddPage(m_FFWFitIntegralPage);
	///End CREATE_FITFUNC_WITH_INTEGRAL
	m_FFWParamPage.InitPage(IDD_FIT_FUNC_PARAM_PAGE, this, wnd);
	AddPage(m_FFWParamPage);
	m_FFWFuncBodyPage.InitPage(IDD_FIT_FUNC_BODY_PAGE, this, wnd);
	AddPage(m_FFWFuncBodyPage);
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
/*
#ifdef INTEGRAL_CONVOLUTION_READY_IN_FFW
	m_FFWIntegrandPage.InitPage(IDD_FIT_FUNC_INTEGRAND_PAGE, this, wnd);
	AddPage(m_FFWIntegrandPage);
	m_FFWFitIntegralPage.InitPage(IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE, this, wnd);
	AddPage(m_FFWFitIntegralPage);
#endif//INTEGRAL_CONVOLUTION_READY_IN_FFW
*/
	///End CREATE_FITFUNC_WITH_INTEGRAL
	m_FFWInitialCodePage.InitPage(IDD_FIT_FUNC_INITIAL_CODE_PAGE, this, wnd);
	AddPage(m_FFWInitialCodePage);
	m_FFWBoundsConstraintsPage.InitPage(IDD_FIT_FUNC_BOUNDS_CONSTRAINTS_PAGE, this, wnd);
	AddPage(m_FFWBoundsConstraintsPage);
	m_FFWDerivedParametersPage.InitPage(IDD_FIT_FUNC_DERIVED_PARAMETERS_PAGE, this, wnd);
	AddPage(m_FFWDerivedParametersPage);
	m_FFWBeforeAfterPage.InitPage(IDD_FIT_FUNC_BEFORE_AFTER_PAGE, this, wnd);
	AddPage(m_FFWBeforeAfterPage);

 	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	if ( (m_nFFWMode & FFW_MODE_MASK) == FFW_CREATE_OR_EDIT )
    m_FFWGoalPage.InitMsgMap();
	///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	m_FFWNameTypePage.InitMsgMap();
	m_FFWParamPage.InitMsgMap();
	m_FFWFuncBodyPage.InitMsgMap();
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	/*
#ifdef INTEGRAL_CONVOLUTION_READY_IN_FFW
	m_FFWIntegrandPage.InitMsgMap();
	m_FFWFitIntegralPage.InitMsgMap();
#endif//INTEGRAL_CONVOLUTION_READY_IN_FFW
	*/
	m_FFWFitIntegralPage.InitMsgMap();
	///End CREATE_FITFUNC_WITH_INTEGRAL
	m_FFWInitialCodePage.InitMsgMap();
	m_FFWBoundsConstraintsPage.InitMsgMap();
	m_FFWDerivedParametersPage.InitMsgMap();
	m_FFWBeforeAfterPage.InitMsgMap();
}

void FitFuncWizPlaceHolder::OnCodeBuilderContentChange()
{
	FFWPageBase * pPage = (FFWPageBase*) GetActivePage();

	int nPageID  = pPage->GetPageID();

	if ( IDD_FIT_FUNC_BODY_PAGE == nPageID)
	{
		FFWFitFuncBodyPage * pBasePage = (FFWFitFuncBodyPage*) pPage;
		pBasePage->OnContentChange();
	}
	else if ( IDD_FIT_FUNC_INITIAL_CODE_PAGE == nPageID )
	{
		FFWInitialCodePage * pFFWInitialCodePage = (FFWInitialCodePage*) pPage;
		pFFWInitialCodePage->OnContentChange();
	}
}

bool FitFuncWizPlaceHolder::OnFinish()
{	
	//last page OnKillActiviePage is not called yet
	FFWPageBase * pPage = (FFWPageBase*) GetActivePage();
	pPage->OnKillActiviePage();
	
	//save function
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	///---Sim 2011-11-18 ORG-4409 FIX_FDF_SHOULD_NOT_DELETE_LT_FUNC_INIT_SECT
 	//bool bKeepLTFuncBody = (m_pNFO->ReadTempWithIntegState(m_trFunction) == 1);
 	//m_pNFO->RemoveLTFuncBody(m_trFunction, bKeepLTFuncBody);
	///---END ORG-4409 FIX_FDF_SHOULD_NOT_DELETE_LT_FUNC_INIT_SECT
 	m_pNFO->RemoveFormulaHintText(m_trFunction);
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
	string strCategory;   
	m_trFunction.GetAttribute(STR_CATEGORY_ATTRIB, strCategory);
	if ( !m_pNFO->IsCategoryExist(strCategory) )
	{
		if ( !m_pNFO->NewCategory(strCategory) )
			return false;
	}
	
	m_trFunction.SetAttribute(STR_CHANGED_ATTRIB, "");
	
	///Jasmine 06/22/10 ORG-2-S2 WANT_DESTINATION_PATH
	string strFilePath, strErrMsg;
	bool bRet = m_pNFO->SaveFunction(m_trFunction, &strErrMsg, &strFilePath);
	
	string strFunctionName = m_pNFO->GetFunctionName(m_trFunction);
	string strMessage;	
	if(bRet)
	/// Zech ORG-3779-S1 SHOW_REMIND_MESSAGE_WHEN_SUCCESSFULLY_SAVE_FITTING_FUNCTION_IN_FITTING_FUNCTION_BUILDER
	//	strMessage.Format(_L("Fitting function %s is saved in %s."), strFunctionName, strFilePath);
	{
		strMessage.Format(_L("Fitting function %s is saved in %s."), strFunctionName, strFilePath);
		
		if (m_FFWParamPage.IsCheckPeak())
		{
			string strRemindMsg;
			ocu_load_err_msg_str(FFWMSG_PEAK_FUNCTION_USING_METHOD_REMIND, strRemindMsg);
			strMessage += "\r\n\r\n" + _L(strRemindMsg);
		}
	}
	/// END SHOW_REMIND_MESSAGE_WHEN_SUCCESSFULLY_SAVE_FITTING_FUNCTION_IN_FITTING_FUNCTION_BUILDER
	else
		strMessage.Format(_L("Failed to save fitting function %s. %s"), strFunctionName, strErrMsg);
	///End WANT_DESTINATION_PATH
	okoc_out_msg(strMessage, 'I');

	///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	if ( bRet )
	{
		if ( m_pdwResults )
			O_ADD_BIT(*m_pdwResults, FFWRESULTS_ONFINISH);
	}
	///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	return bRet;
}

///------ Folger 09/25/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
bool 	FitFuncWizPlaceHolder::OnCancel(BOOL bCanFinish)
{
	int				nActive = GetActiveIndex();
	FFWPageBase*	pPage = GetPage(nActive);
	if ( IDD_FIT_FUNC_GOAL_PAGE != pPage->GetPageID() )
	{
		if ( bCanFinish )
		{
			int		nReturn = MessageBox(GetSafeHwnd(), STR_CANCEL_BTN_WARN_MESSAGE, ERROR_ATTENTION_DIAOLG, MB_YESNOCANCEL);
			if ( IDCANCEL == nReturn )
				return false;
			
			if ( IDYES == nReturn )
				return OnFinish();
		}
		else
		{
			int		nReturn = MessageBox(GetSafeHwnd(), _L("Are you sure you want to exit the builder?"), ERROR_ATTENTION_DIAOLG, MB_YESNO);
			if ( IDNO == nReturn )
				return false;
		}
	}
	
	string	strFuncName, strFileName;
	if( m_trFunction && !m_trFunction.IsEmpty() )
		nlf_get_func_names(m_trFunction, strFuncName, strFileName);
	nlf_delete_precompile_files(strFuncName);
	return true;
}
///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD

///Jasmine 07/09/10 ORG-2-P11 REMEMBER_LAST_USE_CATEGORY
void FitFuncWizPlaceHolder::SaveSettings()
{
	dlg_save_to_registry(STR_FFW_DLG_NAME, STR_FFW_DLG_CATEGORY, m_FFWNameTypePage.GetCategory());	
}
///End REMEMBER_LAST_USE_CATEGORY

int FitFuncWizPlaceHolder::MarkNextPage(int nFromID, int nToID, int nPageID, int nOption/* = -1*/)
{	
	string strForm;
	string strType; 
	int nNextPage = -1;

	switch (nPageID)
	{
	case IDD_FIT_FUNC_GOAL_PAGE:	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
		break;
	case IDD_FIT_FUNC_TYPE_PAGE:
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
		nNextPage = IDD_FIT_FUNC_PARAM_PAGE;
		if( m_FFWNameTypePage.IsCheckFitWithInteg() )
			nNextPage = IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE;
		break;
	case IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE:
		nNextPage = IDD_FIT_FUNC_PARAM_PAGE;
		break;
	///End CREATE_FITFUNC_WITH_INTEGRAL
	case IDD_FIT_FUNC_PARAM_PAGE:
		if(FFW_EDIT_BUILTIN_FUNC == m_nFFWMode)
			nNextPage = IDD_FIT_FUNC_INITIAL_CODE_PAGE;
		else
			nNextPage = IDD_FIT_FUNC_BODY_PAGE;
		break;
	case IDD_FIT_FUNC_BODY_PAGE:
		nNextPage = IDD_FIT_FUNC_INITIAL_CODE_PAGE;
		break;
	case IDD_FIT_FUNC_INITIAL_CODE_PAGE:
	case IDD_FIT_FUNC_BOUNDS_CONSTRAINTS_PAGE:
	case IDD_FIT_FUNC_DERIVED_PARAMETERS_PAGE:
	case IDD_FIT_FUNC_BEFORE_AFTER_PAGE:
		break;
	default:
		ASSERT(FALSE);
	}

	m_nJumpToPage = nNextPage;
	m_nJumpFromPage = nPageID;
	return m_nJumpToPage;
}

int FitFuncWizPlaceHolder::MarkPreviousPage(int nFromID, int nToID, int nPageID, int nOption/* = -1*/)
{
	m_nJumpToPage = nFromID;
	m_nJumpFromPage = -1;
	return m_nJumpToPage;
}

bool FitFuncWizPlaceHolder::IsExpectedPage(int nPageID)
{	
	bool bRet = (-1 == m_nJumpToPage || nPageID == m_nJumpToPage);
	return bRet;	
}

void FitFuncWizPlaceHolder::ResetExpectedPage()
{	
	m_nJumpToPage = -1;
}

int FitFuncWizPlaceHolder::RetrieveToPage()
{
	return m_nJumpToPage;
}

int FitFuncWizPlaceHolder::RetrieveFromPage()
{
	return m_nJumpFromPage;
}

bool FitFuncWizPlaceHolder::IsEditablePage(int nPageID)
{
	bool bEdit = true;
	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	//switch(m_nFFWMode)
	switch(m_nFFWMode & FFW_MODE_MASK)
	///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	{
	case FFW_CREATE_OR_EDIT:	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	case FFW_CREATE_FUNC:
		break;
		
	case FFW_EDIT_BUILTIN_FUNC:
		vector<int> vnReadOnlyPages = {	
						IDD_FIT_FUNC_TYPE_PAGE,
		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
//#ifdef INTEGRAL_CONVOLUTION_READY_IN_FFW	
						//IDD_FIT_FUNC_INTEGRAND_PAGE,	IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE,
//#endif//INTEGRAL_CONVOLUTION_READY_IN_FFW
						IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE,
		///End CREATE_FITFUNC_WITH_INTEGRAL
						IDD_FIT_FUNC_BODY_PAGE
						};
		vector<uint> vecIndex;
		if( vnReadOnlyPages.Find(vecIndex, nPageID) > 0 )
			bEdit = false;
			
		break;
	
	case FFW_EDIT_USER_FUNC:
		///Jasmine 06/23/10 ORG-2-S4 FUNCTION_WIZARD_ALLOW_USER_DEFINED_FUNC_CHANGE_FORM
		//if(IDD_FIT_FUNC_TYPE_PAGE == nPageID)
			//bEdit = false;
		///End FUNCTION_WIZARD_ALLOW_USER_DEFINED_FUNC_CHANGE_FORM
		break;
		
	default:
		ASSERT(0);
		break;
	}
	
	return bEdit;
}

void FitFuncWizPlaceHolder::UpdateButtonStatus(int nPageID)
{
	bool bBack	= true;
	bool bNext	= true;
	bool bFinish =false;
	switch(nPageID)
	{
	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	case IDD_FIT_FUNC_GOAL_PAGE:
		bBack = false;
	///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE

	case IDD_FIT_FUNC_TYPE_PAGE:
		///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
		//bBack = false;
		if ( (m_nFFWMode & FFW_MODE_MASK) != FFW_CREATE_OR_EDIT )
			bBack = false;
		///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
		break;
	case IDD_FIT_FUNC_INTEGRAL_EQUATION_PAGE:	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	case IDD_FIT_FUNC_PARAM_PAGE:
		bBack = IsEditablePage(IDD_FIT_FUNC_TYPE_PAGE);
		break;
	case IDD_FIT_FUNC_BODY_PAGE:
	case IDD_FIT_FUNC_INITIAL_CODE_PAGE:
	case IDD_FIT_FUNC_BOUNDS_CONSTRAINTS_PAGE:
		///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
		bFinish = !m_pNFO->HasDerivedParameters(m_trFunction);
		break;
		///End NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	case IDD_FIT_FUNC_DERIVED_PARAMETERS_PAGE:
	case IDD_FIT_FUNC_BEFORE_AFTER_PAGE:
		if ( nPageID == IDD_FIT_FUNC_BEFORE_AFTER_PAGE )
			bNext = false;
		bFinish = true;
		break;;
	}
	EnableNextButton(bNext);
	EnableBackButton(bBack);
	EnableFinishButton(bFinish);
}

int FitFuncWizPlaceHolder::checkWizardMode()
{
	if(!m_trFunction)
		return -1;
	
	if(!m_trFunction.FirstNode)
		return FFW_CREATE_FUNC;
	///Jasmine 06/23/10 ORG-2-S4 FUNCTION_WIZARD_ALLOW_USER_DEFINED_FUNC_CHANGE_FORM
	if(m_pNFO->IsSysFunc(m_trFunction) || m_pNFO->IsSharedFunc(m_trFunction))
		return FFW_EDIT_BUILTIN_FUNC;
	///End FUNCTION_WIZARD_ALLOW_USER_DEFINED_FUNC_CHANGE_FORM
	return FFW_EDIT_USER_FUNC;
}

/*------------------------------------------------------------------------------*
 * FitFuncWizPlaceHolder End													*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * FitFuncWizDlg																	*
 *------------------------------------------------------------------------------*/
//this buttons are defined in VC, have to define again here with same value.
#define ID_WIZBACK			0x3023
#define ID_WIZNEXT			0x3024
#define ID_WIZFINISH		0x3025 
 
class FitFuncWizDlg : public Dialog
{
public:
	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	//FitFuncWizDlg() : Dialog(IDD_FIT_FUNC_WIZARD, "Odlg8")
	///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	//FitFuncWizDlg(int nFFWMode = FFW_MODE_AUTO) : Dialog(IDD_FIT_FUNC_WIZARD, "Odlg8")
	//FitFuncWizDlg(int nFFWMode = FFW_MODE_AUTO, NumFunctionOrganizer* pNFO = NULL) : Dialog(IDD_FIT_FUNC_WIZARD, "Odlg8")
	FitFuncWizDlg(int nFFWMode = FFW_MODE_AUTO, NumFunctionOrganizer* pNFO = NULL
		///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
		, LPDWORD pdwResults = NULL
		///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
		/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
		, bool bIsNewCategory = false
		, LPCSTR lpcszOpenedCategory = NULL
		/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
		, DWORD dwCntrl = 0		///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
		) : Dialog(IDD_FIT_FUNC_WIZARD, "Odlg8")
	///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	{
		m_nMode = nFFWMode;	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
		///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
		///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
		//m_pPlaceHolder = new FitFuncWizPlaceHolder(pNFO);
		m_pPlaceHolder = new FitFuncWizPlaceHolder(pNFO, pdwResults);
		///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
		///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
		/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
		m_pPlaceHolder->SetIsNewCategory(bIsNewCategory);
		m_pPlaceHolder->SetOpenedCategory(lpcszOpenedCategory);
		/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
		m_pPlaceHolder->SetFoCntrl(dwCntrl);		///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
	}
	///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	~FitFuncWizDlg()
	{
		NICE_SAFE_REMOVAL(m_pPlaceHolder);
	}
	///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	
	
	/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	//int 	DoModalEx(HWND hParent, const TreeNode& trOld);
	int 	DoModalEx(HWND hParent, const TreeNode& trOld, bool bNewCategory = false);
	/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION

	void 	GetFunction(TreeNode &trFunction){trFunction = m_pPlaceHolder->m_trFunction;}
	
protected:
	EVENTS_BEGIN
		ON_SYSCOMMAND(OnSystemCommand)				///Sophy 7/7/2010 ORG-432-S7 MAKE_MIN_BUTTON_TO_ROLLUP_DIALOG
		PAGE_ON_INIT(OnInitDialog)
		PAGE_ON_FINISH(OnFinish)
		PAGE_ON_CANCEL(OnCancel)
		ON_READY(OnReady)							///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
		ON_DESTROY(OnDestroy)						///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
		ON_BN_CLICKED(IDC_BTN_SHOWHIDE, OnShowHide)	///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
		ON_USER_MSG(WM_USER_ON_CONTENT_CHANGE, OnContentChange)	
		///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
		ON_USER_MSG(WM_FFW_USER_MSG_RESTORE_PAGE_SIZE, OnRestorePageSize)
		///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	EVENTS_END

	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	BOOL OnRestorePageSize(WPARAM wParam, LPARAM lParam);
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	BOOL OnSystemCommand(int nCmd);	///Sophy 7/7/2010 ORG-432-S7 MAKE_MIN_BUTTON_TO_ROLLUP_DIALOG
	BOOL OnInitDialog();
	BOOL OnFinish();	
	///------ Folger 08/12/10 ORG-733-P2 UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD
	//BOOL OnCancel(){return TRUE;}
	BOOL OnCancel();
	///------ End UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD
	///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
	BOOL OnReady();
	BOOL OnDestroy();
	BOOL LoadSettings();
	BOOL SaveSettings();
	BOOL SaveSetting(LPCSTR lpcszValName, DWORD dwVal, LPCSTR lpcszDlgName = NULL);
	BOOL LoadSetting(LPCSTR lpcszValName, DWORD& dwVal, LPCSTR lpcszDlgName = NULL);
	///end BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
	BOOL OnShowHide(Control ctrl);	///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
	void OnContentChange(DWORD wParam, DWORD lParam);
	void GetClientRect(Control& ctrl, RECT& rect);
	void MoveControl(Control& ctrl, RECT& rect);
private:
	BitmapRadioButton	        m_chkShowViewLeftPane;///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	//FitFuncWizPlaceHolder 		m_PlaceHolder;
	FitFuncWizPlaceHolder* 		m_pPlaceHolder;
	///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
	//bool						m_bShowLeft;///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER	
	int							m_nLeftPanelWidth;
	///end BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
	int							m_nMode;	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	bool						m_bNewCategory;		/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
};

/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
//int FitFuncWizDlg::DoModalEx(HWND hParent, const TreeNode& trFunction)
int FitFuncWizDlg::DoModalEx(HWND hParent, const TreeNode& trFunction, bool bNewCategory/* = false*/)
/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
{
	m_pPlaceHolder->m_trFunction = trFunction.Clone();
	
	InitMsgMap();		
	
	m_bNewCategory = bNewCategory;	/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION	
	int nRet = Dialog::DoModal(hParent, DLG_TITLE_TO_HAVE_PAGE_NAME);
	
	return nRet;
}

///Sophy 7/7/2010 ORG-432-S7 MAKE_MIN_BUTTON_TO_ROLLUP_DIALOG
BOOL FitFuncWizDlg::OnSystemCommand(int nCmd)
{
	if( SC_MINIMIZE == nCmd)
	{
		BOOL bClose = !IsRolledup();
		if(bClose)
		{
			if ( OM_RETURN_NOT_PRESENT == OptionalMessageStatus("NLFitMinimizeToModalless") )
				OptionalMessage("ClickMinimizeToRollDown", MB_OK);
		}
		Rollup(bClose);
		return FALSE;
	}
	return TRUE;
}
///end MAKE_MIN_BUTTON_TO_ROLLUP_DIALOG
BOOL FitFuncWizDlg::OnInitDialog()
{
	///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	vector<string>  vstrTipsLeftRight;
	vstrTipsLeftRight.SetSize(2);
	vstrTipsLeftRight[0] = _L("Show hints");
	vstrTipsLeftRight[1] = _L("Hide hints");
	m_chkShowViewLeftPane = GetItem(IDC_BTN_SHOWHIDE);
	m_chkShowViewLeftPane.Init(2, IDB_LEFT_RIGHT_BTN, 12, vstrTipsLeftRight);
	///End SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	m_pPlaceHolder->Create(IDC_PAGE_FRAME, *this);
	m_pPlaceHolder->SetMode(m_nMode);	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	m_pPlaceHolder->InitMaps(*this);
	///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
	//m_bShowLeft = true;	///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	RECT rcLeft;
	GetClientRect(GetItem(IDC_HINTS_FRAME), rcLeft);
	m_nLeftPanelWidth = RECT_WIDTH(rcLeft);
	///end BUTTON_FOR_SHOW_HIDE_LEFT_PANEL

	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	m_pPlaceHolder->SetDlgHwnd(GetSafeHwnd());
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	
	return TRUE;
}

BOOL FitFuncWizDlg::OnFinish()
{	
	if( m_pPlaceHolder->OnFinish() )
		return TRUE;
	return FALSE;
}

///------ Folger 08/12/10 ORG-733-P2 UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD
BOOL FitFuncWizDlg::OnCancel()
{
	///------ Folger 09/25/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	/*
	string	strFuncName, strFileName;
	nlf_get_func_names(m_pPlaceHolder->m_trFunction, strFuncName, strFileName);
	nlf_delete_precompile_files(strFuncName);
	return TRUE;
	*/
	Button		btnFinish = GetItem(ID_WIZFINISH);
	return m_pPlaceHolder->OnCancel(btnFinish.Enable);
	///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
}
///------ End UPDATE_FIT_BUTTONS_AFTER_EDIT_FROM_WIZARD

///Sophy 6/29/2010 ORG-432-S8 BUTTON_FOR_SHOW_HIDE_LEFT_PANEL
BOOL FitFuncWizDlg::OnReady()
{
	LoadSettings();
	return TRUE;
}
BOOL FitFuncWizDlg::OnDestroy()
{
	SaveSettings();
	return TRUE;
}

BOOL FitFuncWizDlg::SaveSettings()
{
	///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	//SaveSetting("ShowLeftPanel", m_bShowLeft);
    SaveSetting("ShowLeftPanel", m_chkShowViewLeftPane.Check);
    ///End SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	m_pPlaceHolder->SaveSettings();///Jasmine 07/09/10 ORG-2-P11 REMEMBER_LAST_USE_CATEGORY
	return TRUE;
}

BOOL FitFuncWizDlg::LoadSettings()
{
	DWORD dwShow = 1;
	LoadSetting("ShowLeftPanel", dwShow);
	if ( dwShow == 0 ) //last time is NOT show when close
	{
		//last time saved position is the rect when left panel is hidden, so should move left.
		RECT rWin;
		Window win = GetWindow();
		win.GetWindowRect(&rWin);
		///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
		//int nOffset = m_bShowLeft ? -m_nLeftPanelWidth : m_nLeftPanelWidth;
		//rWin.left += nOffset;
		//rWin.right += nOffset;
		rWin.left -= m_nLeftPanelWidth;
		rWin.right -= m_nLeftPanelWidth;
		///End SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
		win.MoveWindow(&rWin);
		
		Control ctrl = GetItem(IDC_BTN_SHOWHIDE);
		OnShowHide(ctrl); //call this as to hide it
		return true;///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	}
	m_chkShowViewLeftPane.Check = true;///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	return TRUE;
}

BOOL FitFuncWizDlg::SaveSetting(LPCSTR lpcszValName, DWORD dwVal, LPCSTR lpcszDlgName)
{
	string strSecName = lpcszDlgName;
	if ( strSecName.IsEmpty() )
		strSecName = STR_FFW_DLG_NAME;
	return dlg_save_to_registry(strSecName, lpcszValName, dwVal);
}

BOOL FitFuncWizDlg::LoadSetting(LPCSTR lpcszValName, DWORD& dwVal, LPCSTR lpcszDlgName)
{
	string strSecName = lpcszDlgName;
	if ( strSecName.IsEmpty() )
		strSecName = STR_FFW_DLG_NAME;
	return dlg_load_registry(strSecName, lpcszValName, dwVal, dwVal);
}

BOOL FitFuncWizDlg::OnShowHide(Control ctrl)
{
	//m_bShowLeft = !m_bShowLeft;///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	Control ctrlHideShow = GetItem(IDC_HINTS_FRAME);
	///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	//ctrlHideShow.Visible = m_bShowLeft;
	ctrlHideShow.Visible = m_chkShowViewLeftPane.Check;
	///End SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER

	ctrlHideShow = GetItem(IDC_FIT_FUNC_HINTS);
	///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	//ctrlHideShow.Visible = m_bShowLeft;
    //ctrl.Text = m_bShowLeft ? ">>" : "<<";
	ctrlHideShow.Visible = m_chkShowViewLeftPane.Check;
	///End SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	
	RECT rWin;
	Window win = GetWindow();
	win.GetWindowRect(&rWin);
	///Junon 13/09/2012 ORG-6812-P2 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	//int nOffset = m_bShowLeft ? -m_nLeftPanelWidth : m_nLeftPanelWidth;
	int nOffset = m_chkShowViewLeftPane.Check ? -m_nLeftPanelWidth : m_nLeftPanelWidth;
	///End SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	rWin.left += nOffset;

	//win.MoveWindow(&rWin);///Junon 13/09/2012 ORG-6812-P1 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	
	//move this button
	{
		///Junon 13/09/2012 ORG-6812-P1 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
		MoveControlsHelper clMoveCtrlHelper(this);
		///End SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
		RECT rCtrl;
		vector<uint> vnCtrlIDs = {IDC_BTN_SHOWHIDE, IDC_PAGE_FRAME, IDC_FIT_FUNC_NEXT_HINTS, ID_WIZBACK, ID_WIZNEXT, IDCANCEL, ID_WIZFINISH};
		for ( int iCtrl = 0; iCtrl < vnCtrlIDs.GetSize(); iCtrl++ )
		{
			Control ctrlRightPanel = GetItem(vnCtrlIDs[iCtrl]);
			GetClientRect(ctrlRightPanel, rCtrl);
			rCtrl.left -= nOffset;
			rCtrl.right -= nOffset;
			MoveControl(ctrlRightPanel, rCtrl);
		}
	}
	///Junon 13/09/2012 ORG-6812-P1 SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	win.MoveWindow(&rWin);
	///End SHOW_HIDE_PANEL_ISSUES_IN_FITTING_FUNCTION_BUILDER
	return TRUE;
}

void FitFuncWizDlg::GetClientRect(Control& ctrl, RECT& rect)
{
	ctrl.GetWindowRect(&rect);
	Window wnd(GetSafeHwnd());
	wnd.ScreenToClient(&rect);
}
void FitFuncWizDlg::MoveControl(Control& ctrl, RECT& rect)
{
	ctrl.MoveWindow(&rect);
}
///end BUTTON_FOR_SHOW_HIDE_LEFT_PANEL

void FitFuncWizDlg::OnContentChange(DWORD wParam, DWORD lParam)
{
	if ( FUNCTION_MANAGER_ON_CODE_BUILDER_SAVE_FUNCTION == (uint) lParam )
	{
		m_pPlaceHolder->OnCodeBuilderContentChange();
	}
}

///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
BOOL	FitFuncWizDlg::OnRestorePageSize(WPARAM wParam, LPARAM lParam)
{
	FFWPageBase*	page = (FFWPageBase*)m_pPlaceHolder->GetActivePage();
	if ( page )
	{
		page->RestorePageSize();
		return TRUE;
	}
	ASSERT(FALSE);
	return FALSE;
}
///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS

/*------------------------------------------------------------------------------*
 * FitFuncWizDlg End																*
 *------------------------------------------------------------------------------*/

#endif//_FFW_H
