/*------------------------------------------------------------------------------*
 * File Name: FilePublish.h														*
 * Creation: Jasmine 08/15/07													*
 * Purpose: 																	*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING				*
 *	Folger 08/20/07 ADD_BOOLEAN_CONTROL_COPY_DIRECTION							*
 *	Folger 08/21/07 CENTRALIZE_CODE_FOR_GROUP_FOLDER_MNGR						*
 *	Folger 08/22/07 UNFIY_FUNC_GET_FILES_INTERFACE								*
 *	Hong 08/22/07 v8.0687 REMOVE_FILE_NOT_EXIST_IN_ACCORDING_FOLDER				*
 *	Hong 08/22/07 IMPROVE_CODE													*
 *	Folger 08/23/07 IMPLEMENT_TEMPLATE_PUBLISH									*
 *	Folger 08/24/07 GET_COL_HEADING_BY_FILE_PATH								*
 *	Folger 08/27/07 ADD_FILETYPES_OGS_THEME_XF									*
 *	Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY	*
 *	Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80						*
 *	Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH						*
 *	Folger 08/30/07 FIX_BUGS_WHEN_MOVE_FILES_FROM_GROUP_TO_USER					*
 *	Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80	*
 *	Folger 08/30/07 USE_NEW_OKUTIL_ADD_TEMPLATE									*
 *	Folger 08/31/07 USE_OKUTIL_FUNCTION_GET_ORIGIN75_USER_PATH					*
 *	CPY 9/1/2007 CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES					*
 *	Folger 09/03/07 SUPPORT_GET_ORIGIN75_PATH_IN_FILE_PUBLISH					*
 *	Folger 09/03/07 SUPPORT_MORE_FILE_TYPES										*
 *	Folger 09/04/07 GET_NLFIT_FILE_NAME_INSTEAD_OF_FUNCTION_NAME				*
 *	Folger 09/05/07 CLEAN_UP_FDF_MODIFICATION_CODES								*
 *	Folger 09/08/07 SUPPORT_PATCH_FILE											*
 *	Folger 09/11/07 MAKE_PATH_BEFORE_COPY										*
 *	Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE								*
 *	Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR			*
 *	CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH			*
 *	Folger 09/24/07 CLEAN_UP_TEMPLATE_PUBLISH_FOR_CORRECT_LOGIC					*
 *	Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION					*
 *	Folger 09/27/07 RESET_ATTRIBUTE_WHEN_COPY_FILE								*
 *	Folger 09/27/07 DELETE_FILE_REGARDLESS_OF_READ_ONLY							*
 *	Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION					*
 *	Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML							*
 *	EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER		*
 *	Folger 10/08/07 QA70-10469 FIX_OPX_FILES_CANNOT_BE_SEEN_IN_GORUPMGR_GROUP_SIDE*
 *	Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE									*
 *	Folger 11/27/07 EXCLUDE_DEFAULT_FUNCTION_IN_GRID							*
 *	Folger 12/05/07 REMOVE_UNKNOWN_TEMPLATE_SAVED_IN_USER_TEMPLATE_XML			*
 *	Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF			*
 *	Folger 01/31/08 QA80-10933 FIX_BUG_OF_DLL_FILE_NAME_CONVENTION				*
 *	Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE					*
 *	Folger 04/03/08 FIX_DEFAULT_XML_PUBLISH_IN_ALL_FILES						*
 *	Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES				*
 *	Folger 09/19/08 FIX_TEMPLATE_TRANSFER_FAIL_WHEN_TEMPLATE_XML_IN_UFF_IS_NOT_EXIST
 *	Folger 09/18/08 QA80-12217 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER	*
 *	Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL		*
 *	Kenny 11/11/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES		*
 *	Folger 07/12/10 ORG-532 TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES			*
 *	Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE				*
 *	Kyle 08/04/2010 ORG-710-P1 SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
 *	Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES			*
 *	Kit 01/27/2011 ORG-2126-P1 SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX				*
 *	Kit 01/31/2011 ORG-2126-S2 USE_FILE_NAME_AS_FIST_COL_NAME					*
 *	Kit 02/17/2011 ORG-2126-P3 INDEX_OUT_OF_RANGE_WHEN_OPEN_GROUP_FOLDER_MANAGER*
 *	Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH		*
 *	Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
 *	Folger 11/12/2011 ORG-4362-P3 FAILED_TO_PUBLISH_XF							*
 *	Kit 11/23/2011 ORG-4363-P6 PUBLISH_GRAPH_THEME_FAILED_IN_GROUP_MGR			*
 *	Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT					*
 *	Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER		*
 *	Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION	*
 *------------------------------------------------------------------------------*/

#ifndef _FILE_PUBLISH_H_
#define	_FILE_PUBLISH_H_

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
// comment out all the old code and rewrite it with new design
//

#define SUPPORT_PACKAGE_FILES


#define STR_ORIGIN_REGISTRY_KEY 			"Software\\OriginLab\\"
///------ Folger 07/12/10 ORG-532 TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES
//#define CURRENT_VERSION						8.1
///------ End TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES

enum
{
	FB_COL_FILE,
	FB_COL_FILE_SPECIFIED,		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	FB_COL_CATEGORY,
	FB_COL_FILETYPE,
	FB_COL_FILESIZE,
	FB_COL_FILEDATE,
	FB_COL_NUMS,
};

#include "NumFunctionOrganizer.h"

///-----Kit 01/27/2011 ORG-2126-P1 SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX
#define		STR_FILE_TYPE_OGW				_L("Analysis Templates")
#define		STR_FILE_TYPE_DIALOG_THEME		_L("Dialog Themes")
#define		STR_FILE_TYPE_FUNCTION_THEME	_L("Function Themes")		///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
#define		STR_FILE_TYPE_FDF				_L("Fitting Functions")
#define		STR_FILE_TYPE_IMPORT_FILTER		_L("Import Filters")
#define		STR_FILE_TYPE_OGS				_L("LabTalk Scripts Files")
#define		STR_FILE_TYPE_DATABASE			_L("Database Files")
#define		STR_FILE_TYPE_ORIGINC			_L("OriginC Files")
//#ifdef SUPPORT_PACKAGE_FILES				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_PACKAGE			_L("Package Files")
//#endif										///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_TEMPLATE			_L("Page Templates")
#define		STR_FILE_TYPE_PATCH				_L("Patches")
#define		STR_FILE_TYPE_PROJECT			_L("Project Files")
#define		STR_FILE_TYPE_THEME				_L("Window Themes")
#define		STR_FILE_TYPE_XF				_L("X-Functions")
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
//#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_OMC				_L("Menu Customization Files")
//#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER

///-----Kit 10/08/2011 ORG-3938-P2 IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
//#define		STR_FILE_TYPE_DEFAULT_SETTINGS	_L("Default Settings")
#define		STR_FILE_TYPE_DEFAULT_SETTINGS	_L("Custom Settings")
///-----End IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
#define		STR_FILE_TYPE_TEXT_FILE			_L("Column Formula")				///-----Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES
#define		STR_FILE_TYPE_PAL_FILE			_L("Palette Files")					///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
#define		STR_FILE_TYPE_OTHER_FILE		_L("Other Files")
///------End SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX

///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
#define		STR_FILE_TYPE_USERBUTTONS		_L("User Button Group")
///end TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS

#define		STR_PAL_FILE_SUB_PATH			"Palettes\\"

#define STR_UPDATE_FOLDER					"Updates\\"
#define STR_UPDATE_INI_FILE					"update.ini"
#define STR_SECTION_PATCH					"patch8"
#define STR_KEY_BUILD						"build"

enum FileType
{
	FILE_TYPE_OGW,
	FILE_TYPE_DIALOG_THEME,
	FILE_TYPE_FUNCTION_THEME,		///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
	FILE_TYPE_FDF,
	FILE_TYPE_IMPORT_FILTER,
	FILE_TYPE_OGS,
	FILE_TYPE_DATABASE,
	FILE_TYPE_ORIGINC,
	FILE_TYPE_PACKAGE,
	FILE_TYPE_TEMPLATE,
	FILE_TYPE_PATCH,
	FILE_TYPE_PROJECT,
	FILE_TYPE_THEME,
	FILE_TYPE_XF,
	FILE_TYPE_OMC,
	FILE_TYPE_DEFAULT_SETTINGS,
	FILE_TYPE_TEXT,					///-----Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES
	FILE_TYPE_PALETTE,				///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
	FILE_TYPE_USERBUTTONS,	///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
	FILE_TYPE_OTHER_FILE,
	FILE_TYPE_ALL_FILE,
};

#define STR_PROJECT_FILE_EXT			".opj"
#define STR_ANALYSIS_TEMPLATE_EXT		".ogw"
///Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE
//#define STR_OTHER_FILE_EXT				".doc|.pdf"
#define STR_OTHER_FILE_EXT				".doc|.docx|.pdf"
///End TRANSFER_USER_FILES_HANDLE_DOCX_FILE

///-----Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES
#define STR_TEXT_FILE_EXT				".txt"
///-----End SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES

///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
#define STR_PALETTE_FILE_EXT			".pal"
///-----End ORG3938-P1 SUPPORT_PALETTE_FILES

#define STR_PACKAGE_80_EXT				".opx"
#define STR_PACKAGE_75_EXT				".opk"
#define STR_PACKAGE_SUB_FOLDER			"Auto Install\\" /// EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER

#define STR_DATABASE_FILE_EXT			".ODQ|.ODS"

/// Kenny 11/11/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES
/*
static bool _update_function_to_nlsf(LPCSTR lpcszCategoryName, LPCSTR lpcszNewName, LPCSTR lpcszOldName, LPCSTR lpcszFileName, LPCSTR lpcszIniPath)
{
	string strINIFileUser(lpcszIniPath), strOldName(lpcszOldName), strNewName(lpcszNewName);
	string strFileName = GetFileName(lpcszFileName, true);

	strINIFileUser.TrimRight("\\");
	strINIFileUser += "\\" + "NLSF.ini";
	INIFile iniNLSF(strINIFileUser);

	bool bRet = true;
	if(!strOldName.IsEmpty())
		bRet &= update_ini_line(iniNLSF, lpcszCategoryName, strOldName, NULL);
	if(bRet && !strNewName.IsEmpty())
		bRet &= update_ini_line(iniNLSF, lpcszCategoryName, strNewName, strFileName);
	return bRet;
}
static bool _update_category_to_nlsf(LPCSTR lpcszNewName, LPCSTR lpcszOldName, LPCSTR lpcszIniPath)
{
	string strINIFileUser(lpcszIniPath), strOldName(lpcszOldName), strNewName(lpcszNewName);
	
	strINIFileUser.TrimRight("\\");
	strINIFileUser += "\\" + "NLSF.ini";
	INIFile iniNLSF(strINIFileUser);

	vector<string> vsKeys, vsValues, vsCKeys, vsCValues;
	int nPos;
	bool bRet=true;
	if(!strOldName.IsEmpty() && !strNewName.IsEmpty())
	{
		bRet &= _nlf_get_section_keys_and_values(strOldName, vsKeys, vsValues, NULL, lpcszIniPath);
		bRet &= _nlf_get_section_keys_and_values(STR_NODE_CATEGORY, vsCKeys, vsCValues, NULL, lpcszIniPath);
	}

	if(!strOldName.IsEmpty())
	{
		bRet &= update_ini_line(iniNLSF, STR_NODE_CATEGORY, strOldName, NULL);	//delete old category in category list
		if(!strNewName.IsEmpty())
			bRet &= update_ini_line(iniNLSF, STR_NODE_CATEGORY, NULL, NULL);//delete the whole old category list 
		if(bRet)
			bRet &= update_ini_line(iniNLSF, strOldName, NULL, NULL);	//delete old category and the functions
		nPos = vsCKeys.Find(strOldName);
	}

	if(!strNewName.IsEmpty())
	{
		for(int nIndex =0 ;nIndex <  vsKeys.GetSize(); nIndex++)
			bRet &= update_ini_line(iniNLSF, strNewName, vsKeys[nIndex], vsValues[nIndex]);
		if(strOldName.IsEmpty())
			update_ini_line(iniNLSF, STR_NODE_CATEGORY, strNewName, STR_FDF_FILE_FOLDER);
		else
		{
			if(nPos > -1 && nPos < vsCKeys.GetSize())
				vsCKeys[nPos] = strNewName;
			for(nIndex =0 ;nIndex <  vsCKeys.GetSize(); nIndex++)
				bRet &= update_ini_line(iniNLSF, STR_NODE_CATEGORY, vsCKeys[nIndex], vsCValues[nIndex]);
		}
	}
	return bRet;
}

static bool _nlf_get_section_keys_and_values(LPCSTR lpcszSection, vector<string> &saKeys, vector<string> &saValues, int* pnDefaultSel, LPCSTR lpcszPath)
{
	int	nDefaultSel = 0;
	saKeys.RemoveAll();

	string strNLSFIniFilePath(lpcszPath);
	strNLSFIniFilePath.TrimRight("\\");
	strNLSFIniFilePath += "\\" + "NLSF.ini";
	INIFile iniNLSF(strNLSFIniFilePath);// when full path given, no need to worry about 2nd arg

	int nKeysCount = iniNLSF.GetKeyNames(saKeys, lpcszSection);
	
	if(saValues != NULL)
	{
		saValues.RemoveAll();
		for(int nIndex = 0 ; nIndex < nKeysCount ; nIndex++)
			saValues.Add( iniNLSF.ReadString(lpcszSection, saKeys[nIndex]));
	}
	
	if(pnDefaultSel != NULL )
	{
		int nDefaIndex = saKeys.Find("Default Function" , 0 , true);
		if(nDefaIndex < 0 )
		{
			nDefaultSel = 0;
		}
		else
		{
			string strDefFunction;

			strDefFunction = saValues[nDefaIndex];
			saKeys.RemoveAt( nDefaIndex , 1);
			saValues.RemoveAt( nDefaIndex , 1);
			nDefaultSel = saKeys.Find( strDefFunction , 0 , true );
		}
		*pnDefaultSel = nDefaultSel;
	}
	return true;
}
*/

/// End QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES

///-----Kit 09/27/2011 ORG-3938	REFACTOR_CODE
// struct FDFPaths
// {
// 	string strFilePath;
// 	string strIniPath;
// 	string strSysPath;
// };

// static bool get_origin_user_path(string& strFilePath, LPCSTR lpcszRegVerKey, bool bUserPath)
// {
// 	strFilePath.Empty();
// 	Registry reg(HKEY_CURRENT_USER);
// 	string	strMainKey = STR_ORIGIN_REGISTRY_KEY,
// 			strPath = bUserPath ? "Path" : "Executable Path";
// 	strMainKey += lpcszRegVerKey;
// 	vector<string> vsLanguages;
// 	if(reg.EnumKey(vsLanguages, strMainKey)==0)
// 		return false;
// 
// 	for(int ii = 0; ii < vsLanguages.GetSize(); ii++)
// 	{
// 		if(reg.GetValue(strMainKey + "\\" + vsLanguages[ii], strPath, strFilePath) && strFilePath.IsPath())
// 			return true;
// 	}
// 	return false;
// }
///-----End REFACTOR_CODE

struct FDFPaths;
class GroupFunctionOrganizer : public NumFunctionOrganizer
{
public:
	int		GetCategoryList(vector<string> &vsCategorys, LPCSTR lpcszIniPath);
	int		GetFunctionList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, LPCSTR lpcstrCategoryName, const FDFPaths& fdfPaths);
	int		GetFilesList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, const FDFPaths& fdfPaths);
	
	bool	AddFile(LPCSTR lpcszName, const FDFPaths& fdfSrcPaths, const FDFPaths& fdfDestPaths);
	bool	RemoveFile(LPCSTR lpcszName, const FDFPaths& fdfPaths, bool bBackup);
	int		GetCategories(LPCSTR lpcszFileName, string &strFunction, vector<string>& vsCategories, const FDFPaths& fdfPaths);
	
private:
	bool	getFunctionFileSourceDestination(LPCSTR lpcszName, string& strSrcFilePath, string& strDestFilePath);	
	bool	checkGetDLLFileName(LPCSTR lpcszName, string &strDLLFile, LPCSTR lpcszSysPath, bool bCopy = true);
	int		checkGetCategory(LPCSTR lpcszFDF, string& strFunction, vector<string>& vsCategories);
};

class FilePublishBase
{
public:
	FilePublishBase();
	virtual int		GetAvailableCates(vector<string>& vsCategories);
	virtual void	SetDestCategory(LPCSTR lpcszCategory);
	
	virtual string	GetDestCategory(LPCSTR lpcszFile);
	
	virtual bool	IsSrcPathSpecified();

	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int		PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	virtual int		RemoveFiles(vector<string> &vsFileNames, bool bSource);
	
	int				GetColNames(vector<string> &vsColNames, bool bSource);

	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);
	virtual int		GetShownInfo(vector<bool>& vbShow);

	virtual bool	GetFileFullPath(string &strFile1, string &strFile2);
	const string&	GetSrcPath();
	const string&	GetDestPath();
	
	string			GetFileSize(LPCSTR lpcszFile, bool bSource);
	
	string			GetFileDate(LPCSTR lpcszFile, bool bSource);

	virtual bool	GetSpecialFileType(DWORD &dwSpecialFileType);

	virtual int		CopyFiles(vector<string> &vsFileNames, bool bSource = true);
protected:
	void			GetFiles(LPCSTR lpcszPath, const vector<string> &vsFileExt, vector<string>& vsFiles);

protected:
	virtual bool	GetSourceDestFilePath();
	string			GetGroupFolderPath(LPCSTR lpcszSubPath=NULL);
///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
public:
	int				m_nRecursive;
///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
protected:
	string			m_strSrcPath;
	string			m_strDestPath;
};
class FileTransferBase : public FilePublishBase
{
public:
	FileTransferBase(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	
	///-----Kit 01/31/2011 ORG-2126-S2 USE_FILE_NAME_AS_FIST_COL_NAME
	/*
	//virtual
	int GetColNames(vector<string> &vsColNames, bool bSource)
	{
		vsColNames.SetSize(FB_COL_NUMS);
		if(bSource)
			vsColNames[FB_COL_FILE] = _L(m_strRegistryKey);
		else
		{
			string strFile;
			strFile.Format(_L("%s User Files"), ftoa(CURRENT_VERSION));
			vsColNames[FB_COL_FILE] = strFile;
		}
		vsColNames[FB_COL_CATEGORY] = _L("Category");
		vsColNames[FB_COL_FILETYPE] = _L("File Type");
		vsColNames[FB_COL_FILESIZE] = _L("File Size");
		vsColNames[FB_COL_FILEDATE] = _L("Modified Date");

		return vsColNames.GetSize();
	}
	*/
	///-----End USE_FILE_NAME_AS_FIST_COL_NAME
	
	virtual bool	IsSrcPathSpecified();
protected:
	// virtual
	bool			GetSourceDestFilePath();

protected:
	string			m_strRegistryKey;
	string			m_strSpecifiedPath;
	bool			m_bSrcPathSpecified;
};

///-----Kit 09/27/2011 ORG-3938	REFACTOR_CODE
// static		void		_check_create_tempalte_xml(const string& strFile)
// {
// 	if ( !strFile.IsFile() )
// 	{
// 		Tree trXML;
// 		load_template_tree(trXML);
// 		foreach (TreeNode trBranch in trXML.Children)
// 		{
// 			trBranch.Reset(true);
// 		}
// 		trXML.Save(strFile);
// 	}
// }
///-----End REFACTOR_CODE

class TemplatePublish : public FilePublishBase
{
public:
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource);
	
private:
	bool		findTemplate(TreeNode& trBranch, string strFile, string& strCate);
};
class TemplateTransfer : public FileTransferBase
{
public:
	TemplateTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);

	virtual int GetFiles(bool bSource, vector<string>& vsFiles);

	virtual int PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource);

private:
	bool		getTemplateCategory(LPCSTR lpcszFile, string &strCategorys);
};

class ImpFilterPublish : public FilePublishBase
{
public:
	ImpFilterPublish();

	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource);
};
class ImpFilterTransfer : public FileTransferBase
{
public:
	ImpFilterTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
};

class FDFPublish : public FilePublishBase
{
public:
	FDFPublish();

	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource);
	
private:
	GroupFunctionOrganizer	m_gfo;
};
class FDFTransfer : public FileTransferBase
{
public:
	FDFTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int PublishFiles(vector<string> &vsFileNames, bool bSource = true);

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource = true);

protected:
	void		GetFDFPaths(bool bSource, FDFPaths& fdfPaths);

private:
	GroupFunctionOrganizer	m_gfo;
};

class OGSPublish : public FilePublishBase
{
public:
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
};
class OGSTransfer : public FileTransferBase
{
public:
	OGSTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);

	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
};

typedef vector<string> VecStr;

typedef VecStr* VecStrPtr;

class FileCategoryImpl
{
public:
	bool			Init(FilePublishBase *pFileCate, LPCSTR lpcszFileExts);
	
public:
	///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	bool			GetFileFullPath(string &strFile1, string &strFile2);
	string			GetDestCategory(LPCSTR lpcszFile, LPCSTR lpcszExtPatterns);
	///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	int				GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);	
	int				GetShownInfo(vector<bool>& vbShow);
	int				GetFiles(bool bSource, bool bRecursive, vector<string>& vsFiles);
	int				RemoveFiles(vector<string> &vsFileNames, bool bSource);
	

public:
	virtual int		PublishFiles(vector<string> &vsFileNames, bool bSource = true);

public:
	VecStrPtr		GetXFFiles(bool bSource){ return bSource ? &m_vsXFSrcFiles : &m_vsXFDstFiles; }
	VecStrPtr		GetXFFullFiles(bool bSource) { return bSource ? &m_vsXFSrcFullFiles : &m_vsXFDstFullFiles; }
	VecStrPtr		GetCategories(){ return &m_vsCategories; }

protected:

	VecStr 			m_vsXFSrcFiles;
	VecStr			m_vsXFDstFiles;
	VecStr			m_vsXFSrcFullFiles;
	VecStr			m_vsXFDstFullFiles;
	VecStr			m_vsFileExts;

	VecStr			m_vsCategories;		///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH

	FilePublishBase *m_pFileCate;
};
//class FileCategoryPublishImpl : public FileCategoryImpl
//{
//public:
//	
//};
class FileCategoryTransferImpl : public FileCategoryImpl
{
public:
	bool Init(FilePublishBase *pFileCate, LPCSTR lpcszFileExts, bool bSrcPathSpecified);
	//virtual 
	int	PublishFiles(vector<string> &vsFileNames, bool bSource = true);
private:
	bool	m_bSrcPathSpecified;
};

class FileCategoryPublish : public FilePublishBase
{
public:
	FileCategoryPublish(LPCSTR lpcszFileExts);  

	virtual bool	GetFileFullPath(string &strFile1, string &strFile2);	///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH

	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);
	virtual int		GetShownInfo(vector<bool>& vbShow);
	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int		PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	virtual int		RemoveFiles(vector<string> &vsFileNames, bool bSource);
	
protected:
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//vector<string> 	m_vsXFUserFiles;
	//vector<string> 	m_vsXFGroupFiles;
	//vector<string> 	m_vsXFUserFullFiles;
	//vector<string> 	m_vsXFGroupFullFiles;
	//vector<string>	m_vsFileExts;
	FileCategoryImpl m_FileCateImpl;
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
};
class FileCategoryTransfer : public FileTransferBase
{
public:
	FileCategoryTransfer(LPCSTR lpcszFileExt, LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);

	virtual bool	GetFileFullPath(string &strFile1, string &strFile2);

	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);	
	virtual int		GetShownInfo(vector<bool>& vbShow);
	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int		PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	virtual int		RemoveFiles(vector<string> &vsFileNames, bool bSource);
protected:	
	virtual int		CopyFiles(vector<string> &vsFileNames, bool bSource = true);

protected:
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//vector<string> 	m_vsXFSrcFiles;
	//vector<string> 	m_vsXFDestFiles;
	//vector<string> 	m_vsXFSrcFullFiles;
	//vector<string> 	m_vsXFDestFullFiles;
	//vector<string>	m_vsFileExts;
	FileCategoryTransferImpl m_FileCateImpl;
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
};

class ThemePublish : public FileCategoryPublish
{
public:
	ThemePublish(LPCSTR lpcszFileExt);
};
class ThemeTransfer : public FileCategoryTransfer
{
public:
	ThemeTransfer(LPCSTR lpcszFileExt, LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);

	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);

	///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
	//virtual void	SetDestCategory(LPCSTR lpcszCategory);
	///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH

	virtual int		GetAvailableCates(vector<string>& vsCategories);

	///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
	//virtual string	GetDestCategory(LPCSTR lpcszFile);
	///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH

	///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
//protected:
//	vector<string>	m_vsCategories;
	///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
	//string			m_strDestCategory;
	///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
};

///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
class WindowThemePublish : public ThemePublish
{
public:
	WindowThemePublish();
	
	virtual string	GetDestCategory(LPCSTR lpcszFile);	///-----Kit 11/23/2011 ORG-4363-P6 PUBLISH_GRAPH_THEME_FAILED_IN_GROUP_MGR
};
class WindowThemeTransfer : public ThemeTransfer
{
public:
	WindowThemeTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);

	virtual string	GetDestCategory(LPCSTR lpcszFile);	///-----Kit 11/02/2011 ORG-4062-P3 PUBLISH_WINDOW_THEME_FILE_OUT_OF_INDEX
	///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
	virtual void	SetDestCategory(LPCSTR lpcszCategory);
private:
	string			m_strDestCategory;
	///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
};
///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES


///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
//class DialogThemePublish : public FilePublishBase
class DialogThemePublish : public ThemePublish
///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
{
public:
	DialogThemePublish();
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);

	virtual string	GetDestCategory(LPCSTR lpcszFile); ///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	
};
class DialogThemeTransfer : public ThemeTransfer
{
public:
	DialogThemeTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);

	///-----Kit 10/19/2011 ORG-4062-P2 DST_CATEGORY_NOT_GET_CORRECT
	virtual int		GetAvailableCates(vector<string>& vsCategories);
	virtual string	GetDestCategory(LPCSTR lpcszFile);
	///-----End DST_CATEGORY_NOT_GET_CORRECT
};

///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
//DialogTheme's copy
class FunctionThemePublish : public ThemePublish
{
public:
	FunctionThemePublish();
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual string	GetDestCategory(LPCSTR lpcszFile); 
};
class FunctionThemeTransfer : public ThemeTransfer
{
public:
	FunctionThemeTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int		GetAvailableCates(vector<string>& vsCategories);
	virtual string	GetDestCategory(LPCSTR lpcszFile);
};
///------ End ADD_OFP_FUNCTION_THEME_SUPPORT

class XFPublish : public FileCategoryPublish
{
public:
	XFPublish();

	///------ Folger 11/12/2011 ORG-4362-P3 FAILED_TO_PUBLISH_XF
	virtual string GetDestCategory(LPCSTR lpcszFile);
	///------ End FAILED_TO_PUBLISH_XF
};
class XFTransfer : public FileCategoryTransfer
{
public:
	XFTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);

	virtual string GetDestCategory(LPCSTR lpcszFile);
};

class DefaultSettingsPublish : public FilePublishBase
{
public:
	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);	///-----Kit 11/30/2011 ORG-4362-P7 CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE
	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
};
class DefaultSettingsTransfer : public FileTransferBase
{
public:
	DefaultSettingsTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);	///-----Kit 11/30/2011 ORG-4362-P7 CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE
	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
};

///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
class UserButtonSettingsPublish : public FilePublishBase
{
public:
	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);
	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
};
class UserButtonSettingsTransfer : public FileTransferBase
{
public:
	UserButtonSettingsTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);
	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int		PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	virtual int		RemoveFiles(vector<string> &vsFileNames, bool bSource);
	virtual bool	GetFileFullPath(string &strFile1, string &strFile2);
protected:
	bool			IsFileFullPath(LPCSTR lpcszFileName);
};
///end TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS

class CommonFilePublish : public FilePublishBase
{
public:
	CommonFilePublish(LPCSTR lpcszFileExt, LPCSTR lpcszSubPath = NULL);
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int PublishFiles(vector<string> &vsFileNames, bool bSource = true);

private:
	string m_strFileExt;	//------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
};
class CommonFileTransfer : public FileTransferBase
{
public:
	CommonFileTransfer(LPCSTR lpcszFileExt, LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath, LPCSTR lpcszSubPath = NULL);
	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);

private:
	string m_strFileExt;
};

class OMCPublish : public CommonFilePublish
{
public:
	OMCPublish();
	int PublishFiles(vector<string> &vsFileNames, bool bSource = true);
};
class OMCTransfer : public FileTransferBase
{
public:
	OMCTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
};

class OriginCPublish : public FilePublishBase
{
public:
	OriginCPublish();
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	
private:
};
class OriginCTransfer : public FileTransferBase
{
public:
	OriginCTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
};

class PatchPublish : public FilePublishBase
{
public:
	PatchPublish();

	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int PublishFiles(vector<string> &vsFileNames, bool bSource = true);

	virtual int RemoveFiles(vector<string> &vsFileNames, bool bSource);
	
private:
	bool		checkSetUpdateINI();
};
class PatchTransfer : public FileTransferBase
{
public:
	PatchTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	virtual int GetFiles(bool bSource, vector<string>& vsFiles);
};

///-----Kit 10/09/2011 : for more flexible, may be we should to extract this class to base, and public 2 class name : publish and transfer
//						 but now, I can not see we need to do this, so just use a class instead.
class AllFileCtrlImpl	
{
public:
	AllFileCtrlImpl();
	~AllFileCtrlImpl();
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//void				Init(bool bGroupMgr, LPCSTR lpcszRegKey = NULL, LPCSTR lpcszSpeciPath = NULL);
	void				Init(bool bGroupMgr, LPCSTR lpcszRegKey = NULL, LPCSTR lpcszSpeciPath = NULL, int nRecursive = 0);
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	int					GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource, int *pnFileType = NULL);
	int					GetShownInfo(vector<bool>& vbShow);	
	int					GetFiles(bool bSource, vector<string>& vsFiles);
	int					PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	int					RemoveFiles(vector<string> &vsFileNames, bool bSource);	
	bool				GetFileFullPath(string &strFile1, string &strFile2);

	vector<int>&		GetAllValidFileType(){ return m_vnValidFileType; }

	// for theme transfer only
	int					GetAvailableCates(vector<string>& vsCategories);
	void				SetDestCategory(LPCSTR lpcszCategory);
	bool				GetDestCategory(string &strCategory, LPCSTR lpcszFile);

	int					GetFileTypeFromFileExt(LPCSTR lpcszExt);

private:
	
	bool				createFilePublish(LPCSTR lpcszExt, FilePublishBase* &pFilePublish, int &nFileType);
	bool				createFilePublish(int nFileType, FilePublishBase* &pFilePublish);
	void				checkRemoveFilePublish(int nFileType, FilePublishBase* &pFilePublish);	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
	int					fileOperation(vector<string> &vsFileNames, bool bSource = true, bool bPublish = true);

private:
	FilePublishBase		*m_pWindowThemeFilePublish;
	FilePublishBase		*m_pXFFilePublish;
	FilePublishBase		*m_pDialogThemeFilePublish;
	FilePublishBase		*m_pFunctionThemeFilePublish;		///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
	
	vector<int>			m_vnValidFileType;
	vector<string>		m_vsAllFileTypeExt;

	bool				m_bGroupMgr;
	LPCSTR				m_lpcszRegKey;
	LPCSTR				m_lpcszSpeciPath;
	int 				m_nRecursive;		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
};

class AllFilePublish : public FilePublishBase
{
public:	
	AllFilePublish();

	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);
	virtual int		GetShownInfo(vector<bool>& vbShow);	
	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int		PublishFiles(vector<string> &vsFileNames, bool bSource = true);
	virtual int		RemoveFiles(vector<string> &vsFileNames, bool bSource);	
	virtual bool	GetFileFullPath(string &strFile1, string &strFile2);

// private:
// 	int				getFileTypeFromFileExt(LPCSTR lpcszExt);
// 	bool			getFilePublishDerivation(int nFileType, FilePublishBase* &pFilePublish);
// 	void			checkRemovePublishDerivation(int nFileType, FilePublishBase* &pFilePublish);	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
// 	int				fileOperation(vector<string> &vsFileNames, bool bSource = true, bool bPublish = true);

// private:
// 	FilePublishBase		*m_pThemeFilePublish;
// 	FilePublishBase		*m_pXFFilePublish;
// 	vector<int>			m_vnValidFileType;
// 	vector<string>		m_vsAllFileTypeExt;
	AllFileCtrlImpl		m_AllFileImpl;
};
class AllFileTransfer : public FileTransferBase
{
public:	
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//AllFileTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath);
	AllFileTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath, int Recursive);
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION

	virtual int		GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource);
	virtual int		GetShownInfo(vector<bool>& vbShow);

	virtual int		GetFiles(bool bSource, vector<string>& vsFiles);
	virtual int		PublishFiles(vector<string> &vsFileNames, bool bSource = true);

	virtual int		RemoveFiles(vector<string> &vsFileNames, bool bSource);
	virtual bool	GetFileFullPath(string &strFile1, string &strFile2);

	// for theme transfer only
	virtual int		GetAvailableCates(vector<string>& vsCategories);
	virtual void	SetDestCategory(LPCSTR lpcszCategory);
	virtual string	GetDestCategory(LPCSTR lpcszFile);

private:

	//int				getFileTypeFromFileExt(LPCSTR lpcszExt);
	//bool			getFileTransferDerivation(int nFileType, FilePublishBase* &pFileTransfer);
	//void			checkRemoveTransferDerivation(int nFileType, FileTransferBase* &pFileTransfer);
	//int				fileOperation(vector<string> &vsFileNames, bool bSource = true, bool bPublish = true);
	
	void			initAllFileTypeName();	///-----Kit 01/27/2011 ORG-2126-P1 SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX
	
private:
	//// need to keep some info
	//FileTransferBase	*m_pThemeFileTransfer;
	//FileTransferBase	*m_pXFFileTransfer;
	//vector<int>			m_vnValidFileType;
	//vector<string>		m_vsAllFileTypeExt;

	AllFileCtrlImpl		m_AllFileImpl;

	vector<string>		m_vsAllFileTypeName;	///-----Kit 01/27/2011 ORG-2126-P1 SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX
};

///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
//FilePublishBase* create_file_publish(int nFileType, bool bGroupMgr = true, LPCSTR lpcszRegKey = NULL, LPCSTR lpcszSpecPath = NULL;	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
FilePublishBase* create_file_publish(int nFileType, bool bGroupMgr = true, LPCSTR lpcszRegKey = NULL, LPCSTR lpcszSpecPath = NULL, int nRecursive = 0);
///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION

bool get_origin_user_path(string& strFilePath, LPCSTR lpcszRegVerKey, bool bUserPath);

#endif//_FILE_PUBLISH_H_
