/*------------------------------------------------------------------------------*
 * File Name: FilePublish.c			 											*
 * Creation: Kit 09/27/2011														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011*
 * All Rights Reserved															*
 * Kit 10/10/2011 ORG-3938-P4 GET_TEMPLATE_TYPE_FORM_TEMPLATE_INI_WRONG 		*
 * Kyle 10/12/2011 ORG-4062-P1 TRANSFER_USER_FILES_FAILED_TO_LIST_FILES_IN_SPECIFIED_FOLDER
 * Kit 10/13/2011 ORG-3938-P5 CUSTOM_SETTING_TYPE_GET_FILES_TOO_SLOW			*
 * Kit 10/19/2011 ORG-4062-P2 DST_CATEGORY_NOT_GET_CORRECT						*
 * Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH		*
 * Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
 *	Folger 11/12/2011 ORG-4362-P3 FAILED_TO_PUBLISH_XF							*
 *	Kit 11/23/2011 ORG-4363-P6 PUBLISH_GRAPH_THEME_FAILED_IN_GROUP_MGR			*
 *	Kit 11/30/2011 ORG-4362-P7 CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE				*
 *	Kit 12/21/2011 ORG-4609-P1 PAL_FILE_CANNOT_PUBLISH							*
 *	Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT					*
 * 	Tony 07/12/2012 ORG-2840-P5 ADD_FITFUNC_XML									*
 *	Tony 07/18/2012 ORG-5952-S1 FIX_FITTING_FUNCTIONS							*
 *	Folger 07/23/2012 ORG-6262-P1 FAILED_TO_GET_86_AS_OLDER_VERSION_IN_ORIGIN	*
 *  Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER		*
 *	Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION	*
 *	Tony 08/15/2012 ORG-2840-S4 REMOVE_SAME_SYSTEM_THEME_DIALOG				*
 *	Tony 09/14/2012 ORG-6796-P1 DEFAULT_SETTING_GET_CORRECT_FILES				*
 *------------------------------------------------------------------------------*/

#include <origin.h>
#include "FilePublish.h"
#include "theme_utils.h"

#define	FITFUNCXML "CustomizedBuiltIn.xml"
///-----Kit 09/27/2011 ORG-3938	REFACTOR_CODE
// move from FilePublish.h

static int _get_template_type_from_name(LPCSTR lpcszFileName)
{
	string strName, strExt;
	separate_file_name_ext(lpcszFileName, &strName, &strExt);
	if(strExt.Left(1) == ".")
		strExt = strExt.GetToken(1, '.');
	if(!strExt.CompareNoCase("otp"))
		return EXIST_GRAPH;
	if(!strExt.CompareNoCase("otw"))
		return EXIST_WKS;
	if(!strExt.CompareNoCase("otm"))
		return EXIST_MATRIX;
	return EXIST_NONE;
}

static string _check_get_pictrue_name(LPCSTR lpcszFileFullName)
{
	char szFileName[100];
	char szExt[20];
	string strRet;

	lstrcat(szFileName, lpcszFileFullName);
	check_add_file_ext(szFileName, NULL, szExt);
	string strExt = szExt;

	if (strExt.CompareNoCase("OTP") == 0)
	{
		string strPicture = get_graph_template_preview_file(lpcszFileFullName);
		lstrcat(szFileName, strPicture);
		check_add_file_ext(szFileName, NULL, szExt);
		string strNameOnly = GetFileName(lpcszFileFullName, true);
		string strPath = GetFilePath(lpcszFileFullName);
		strRet = strPath + strNameOnly + '.' + szExt;
	}

	return strRet;
}

//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80
//------ Folger 08/29/07 SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH
static TreeNode _tree_add_cate_node(TreeNode& trParent, string& strCateName)
{
	string strCateNode = tree_get_enum_node_name(trParent, STR_CATEGORY_NODE);//STR_BRANCH_NODE);	///Jasmine 02/05/06 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS_NAME_CHANGE
	TreeNode trCate = trParent.AddNode(strCateNode, TRGP_BRANCH);
	if(strCateName.IsEmpty())
		strCateName = tree_get_enum_attribute_value(trParent, STR_LABEL_ATTRIB, STR_NEW_CATEGORY_PREFIX);
	bool flag = trCate.SetAttribute(STR_LABEL_ATTRIB, strCateName);
	return trCate;
}
static TreeNode _tree_add_temp_node(TreeNode& trParent, string strTempName, string strFileName)
{
	string strTempNode = tree_get_enum_node_name(trParent, STR_TEMPLATE_NODE);
	TreeNode trTemplate = trParent.AddNode(strTempNode, ONODETYPE_TREE_NODE);
	bool flag = trTemplate.SetAttribute(STR_LABEL_ATTRIB, strTempName);
	flag = trTemplate.SetAttribute(STR_FILENAME_ATTRIB, strFileName);
	return trTemplate;
}
//------ End SAVE_PARTITIAL_GROUP_PATH_FOR_PUBLISH

//------ Folger 09/11/07 FIX_BUGS_IN_FDF_FILE_COMPARE
static int _append_file_ext(vector<string> &vsFiles, string strExt)
{
	int nSize = vsFiles.GetSize();
	///------ Tony 07/12/2012 ORG-2840-P5 ADD_FITFUNC_XML
	//Avoid CustomizedBuiltIn.xml to add ".fdf" 
	if(0 != nSize && !vsFiles[nSize - 1].Compare(FITFUNCXML))
		nSize--;
	///------ End ADD_FITFUNC_XML
	for (int ii=0; ii<nSize; ii++)
	{
		vsFiles[ii] += strExt;
	}
	return nSize;
}
//------ End FIX_BUGS_IN_FDF_FILE_COMPARE

#ifndef _OLD_GROUP_FOLDER_MANAGER_AND_TRANSFER_USER_FILES_

static void _check_create_tempalte_xml(const string& strFile)
{
	if ( !strFile.IsFile() )
	{
		Tree trXML;
		load_template_tree(trXML);
		foreach (TreeNode trBranch in trXML.Children)
		{
			trBranch.Reset(true);
		}
		trXML.Save(strFile);
	}
}

bool get_origin_user_path(string& strFilePath, LPCSTR lpcszRegVerKey, bool bUserPath)
{
	strFilePath.Empty();
	Registry reg(HKEY_CURRENT_USER);
	string	strMainKey = STR_ORIGIN_REGISTRY_KEY,
		strPath = bUserPath ? "Path" : "Executable Path";
	strMainKey += lpcszRegVerKey;
	vector<string> vsLanguages;
	if(reg.EnumKey(vsLanguages, strMainKey)==0)
		return false;

	for(int ii = 0; ii < vsLanguages.GetSize(); ii++)
	{
		if(reg.GetValue(strMainKey + "\\" + vsLanguages[ii], strPath, strFilePath) && strFilePath.IsPath())
			return true;
	}
	return false;
}
///------ Tony 07/12/2012 ORG-2840-P5 ADD_FITFUNC_XML
static void _append_CustomizedBuiltInxml(vector<string> &vsFiles, LPCSTR strSrcPath)
{
	string strPath;
	strPath = strPath + strSrcPath+ FITFUNCXML;
	if(strPath.IsFile())
	{
		vector<string> vsFitfuncXml(1);
		vsFitfuncXml[0] = FITFUNCXML;
		vsFiles.Append(vsFitfuncXml);	
	}
}
///------END ORG-2840-P5 ADD_FITFUNC_XML
/************************************************************************/
/* GroupFunctionOrganizer
/************************************************************************/
#define	_update_function_to_nlsf(lpcszCategoryName, lpcszNewName, lpcszOldName, lpcszFileName, lpcszIniPath)	\
	nlsf_update_function(lpcszCategoryName, lpcszNewName, lpcszOldName, lpcszFileName, 0, lpcszIniPath)


#define	_update_category_to_nlsf(lpcszNewName, lpcszOldName, lpcszIniPath)	\
	nlsf_update_category(lpcszNewName, lpcszOldName, 0, lpcszIniPath)

#define	_nlf_get_section_keys_and_values(lpcszSection, saKeys, saValues, pnDefaultSel, lpcszPath)	\
	nlf_get_section_keys_and_values(lpcszSection, saKeys, saValues, pnDefaultSel, 0, lpcszPath)

int	GroupFunctionOrganizer::GetCategoryList(vector<string> &vsCategorys, LPCSTR lpcszIniPath)
{
	vsCategorys.SetSize(0);
	_nlf_get_section_keys_and_values(STR_NODE_CATEGORY, vsCategorys, NULL, NULL, lpcszIniPath);

	return vsCategorys.GetSize();
}

struct FDFPaths
{
	string strFilePath;
	string strIniPath;
	string strSysPath;
};

int	GroupFunctionOrganizer::GetFunctionList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, LPCSTR lpcstrCategoryName, const FDFPaths& fdfPaths)
{
	vsFunctions.SetSize(0);
	vsFunctionFullFileNames.SetSize(0);

	string strPath = fdfPaths.strFilePath;
	strPath.TrimRight("\\");
	strPath += "\\";

	int nDefaultFunc = 0;
	_nlf_get_section_keys_and_values(lpcstrCategoryName, vsFunctions, vsFunctionFullFileNames, &nDefaultFunc, fdfPaths.strIniPath);

	string strFunctionFullPath;
	for (int ii = vsFunctionFullFileNames.GetSize() - 1; ii >= 0; ii--)
	{
		strFunctionFullPath = strPath + vsFunctionFullFileNames[ii] + ".fdf";
		if ( !strFunctionFullPath.IsFile() )
		{
			vsFunctionFullFileNames.RemoveAt(ii);
			vsFunctions.RemoveAt(ii);
		}	
	}
	return vsFunctions.GetSize();
}

int GroupFunctionOrganizer::GetFilesList(vector<string> &vsFunctions, vector<string> &vsFunctionFullFileNames, const FDFPaths& fdfPaths)
{
	vector<string> vsCategoties;
	GetCategoryList(vsCategoties, fdfPaths.strIniPath);

	for (int ii = 0; ii < vsCategoties.GetSize(); ii++)
	{			
		vector<string> vsFuncTemp, vsFuncFNamesTemp;
		if ( GetFunctionList(vsFuncTemp, vsFuncFNamesTemp, vsCategoties[ii], fdfPaths) > 0 )
		{
			vsFunctions.Append(vsFuncTemp);
			vsFunctionFullFileNames.Append(vsFuncFNamesTemp);
		}			
	}	
	return vsFunctions.GetSize();
}

bool GroupFunctionOrganizer::AddFile(LPCSTR lpcszName, const FDFPaths& fdfSrcPaths, const FDFPaths& fdfDestPaths)
{
	string strSrcFilePath = fdfSrcPaths.strFilePath;
	string strDestFilePath = fdfDestPaths.strFilePath;
	if(!getFunctionFileSourceDestination(lpcszName, strSrcFilePath, strDestFilePath))
		return false;

	string strDLLFile;		//------ Folger 01/14/08 NEED_TO_MANIPULATE_DLL_FILE_WITH_EXTERNAL_DLL_FDF

	CheckMakePath(GetFilePath(strDestFilePath));
	if (copyfile(strSrcFilePath, strDestFilePath, 0))
		return false;
	if ( checkGetDLLFileName(strSrcFilePath, strDLLFile, fdfSrcPaths.strSysPath) )
		copyfile(strDLLFile, GetFilePath(strDestFilePath) + GetFileName(strDLLFile));

	vector<string> vsCategories;
	string strFunction;
	if(fdfSrcPaths.strIniPath.IsEmpty())		// specified fdf, try to get the ini file or get a default category and function name
		checkGetCategory(strSrcFilePath, strFunction, vsCategories);
	else
		GetCategories(lpcszName, strFunction, vsCategories, fdfSrcPaths);

	for (int ii = 0; ii < vsCategories.GetSize(); ii++)
	{
		_update_category_to_nlsf(vsCategories[ii], NULL, fdfDestPaths.strIniPath);
		_update_function_to_nlsf(vsCategories[ii], strFunction, NULL, lpcszName, fdfDestPaths.strIniPath);
	}
	return true;
}

bool GroupFunctionOrganizer::RemoveFile(LPCSTR lpcszName, const FDFPaths& fdfPaths, bool bBackup)
{
	vector<string> vsCategories;		
	string strFunction;
	GetCategories(lpcszName, strFunction, vsCategories, fdfPaths);

	for (int ii = 0; ii < vsCategories.GetSize(); ii++)
	{
		_update_function_to_nlsf(vsCategories[ii], NULL, strFunction, lpcszName, fdfPaths.strIniPath);
	}

	string strPath = fdfPaths.strFilePath;
	strPath.TrimRight("\\");
	strPath += "\\";
	string strFilePath = strPath + lpcszName + ".fdf";
	string strDLLFile;
	checkGetDLLFileName(lpcszName, strDLLFile, fdfPaths.strSysPath, false);

	if(bBackup)
	{
		string	strDeletePath = strPath + STR_FDF_DELETE_FILE_FOLDER + "\\";
		if( CheckMakePath( strDeletePath ) )
		{
			copyfile(strFilePath, strDeletePath + lpcszName + ".fdf", 0);
			copyfile(strDLLFile, strDeletePath + GetFileName(strDLLFile));
		}
	}
	if (!okutil_delete_file(strFilePath, true))
		return false;

	okutil_delete_file(strDLLFile, true);

	return true;
}

int GroupFunctionOrganizer::GetCategories(LPCSTR lpcszFileName, string &strFunction, vector<string>& vsCategories, const FDFPaths& fdfPaths)
{
	vsCategories.RemoveAll();
	GetCategoryList(vsCategories, fdfPaths.strIniPath);
	for (int ii = vsCategories.GetSize() - 1; ii >= 0; ii--)
	{
		vector<string> vsFunctions, vsFunctionFullFileNames;
		GetFunctionList(vsFunctions, vsFunctionFullFileNames, vsCategories[ii], fdfPaths);
		int nIndex = vsFunctionFullFileNames.Find(lpcszFileName);
		if (nIndex < 0)
		{
			vsCategories.RemoveAt(ii);
		}
		else
		{
			if (strFunction.IsEmpty())
				strFunction = vsFunctions[nIndex];
		}
	}

	return vsCategories.GetSize();
}


bool GroupFunctionOrganizer::getFunctionFileSourceDestination(LPCSTR lpcszName, string& strSrcFilePath, string& strDestFilePath)
{ 
	///------ Tony 07/18/2012 ORG-5952-S1 FIX_FITTING_FUNCTIONS	
	//strSrcFilePath.TrimRight("\\");
	//strSrcFilePath = strSrcFilePath + "\\" + lpcszName + ".fdf";
	//strDestFilePath.TrimRight("\\");
	//strDestFilePath = strDestFilePath + "\\" + lpcszName + ".fdf";
	string strFitFunc;
	string strFdf;
	strFitFunc = FITFUNCXML;
	if(!strFitFunc.Compare(lpcszName))
		strFdf = "";
	else
		strFdf = ".fdf";
	
	strSrcFilePath.TrimRight("\\");
	strSrcFilePath = strSrcFilePath + "\\" + lpcszName + strFdf;
	strDestFilePath.TrimRight("\\");
	strDestFilePath = strDestFilePath + "\\" + lpcszName + strFdf;
	///------ End FIX_FITTING_FUNCTIONS
	return true;
}

bool GroupFunctionOrganizer::checkGetDLLFileName(LPCSTR lpcszName, string &strDLLFile, LPCSTR lpcszSysPath, bool bCopy /*= true*/)
{
	INIFile fdf(lpcszName, false);
	string strFuncType = fdf.ReadString(STR_FUNC_GENERAL_INFO, STR_FUNC_TYPE);
	if ( strFuncType.CompareNoCase(STR_FUNCTION_TYPE_EXTERN_DLL) != 0 )
		return false;

	string strFile = fdf.ReadString(STR_FUNC_GENERAL_INFO, STR_FUNCTION_SOURCE);

	vector<string> vsTmp;
	strFile.GetTokens(vsTmp, '.');
	strFile = vsTmp[0];
	//------
	LPSTR lpszDLLFile = strFile.GetBuffer(MAXLINE);
	check_add_file_ext(lpszDLLFile, STR_FUNCTION_DLL_SOURCE);
	strFile.ReleaseBuffer();
	strDLLFile = GetFilePath(lpcszName) + strFile;
	if ( !strDLLFile.IsFile() )
	{
		if ( !bCopy )
			return false;
		strDLLFile = lpcszSysPath;
		strDLLFile.TrimRight("\\");
		strDLLFile += "\\";

		strDLLFile += strFile;
		if ( !strDLLFile.IsFile() )
			return false;
	}

	return true;
}

int GroupFunctionOrganizer::checkGetCategory(LPCSTR lpcszFDF, string& strFunction, vector<string>& vsCategories)
{
	string strFDF = lpcszFDF;
	INIFile fdf(lpcszFDF);
	strFunction = fdf.ReadString(STR_FUNC_GENERAL_INFO, STR_FUNC_NAME);
	strFunction.TrimLeft();
	strFunction = strFunction.GetToken(0);
	strFunction.TrimRight();
	if(strFunction.IsEmpty())
		return 0;
	string strFileName = GetFileName(lpcszFDF, true);

	vsCategories.SetSize(0);
	string strIniPath = GetFilePath(lpcszFDF);
	strIniPath.TrimRight("\\");
	int nPos = strIniPath.ReverseFind('\\');
	if(nPos > 0)
	{
		strIniPath = strIniPath.Left(nPos);				// the parent path
		GetCategoryList(vsCategories, strIniPath);
	}

	for (int ii = vsCategories.GetSize() - 1; ii >= 0; ii--)
	{
		vector<string> vsFunctions, vsFunctionFullFileNames;
		int nDefaultFunc = 0;
		_nlf_get_section_keys_and_values(vsCategories[ii], vsFunctions, vsFunctionFullFileNames, &nDefaultFunc, strIniPath);

		int nFuncIndex = vsFunctions.Find(strFunction);
		int nFileIndex = vsFunctionFullFileNames.Find(strFileName);
		if (nFuncIndex < 0 || nFileIndex < 0 || nFuncIndex != nFileIndex)
			vsCategories.RemoveAt(ii);
	}
	if(vsCategories.GetSize() == 0)				// default category
	{
		vsCategories.Add("Origin Basic Functions");
	}

	return vsCategories.GetSize();
}


/************************************************************************/
/* FilePublishBase
/************************************************************************/
FilePublishBase::FilePublishBase()
{
	GetSourceDestFilePath();
}

//virtual 
int	FilePublishBase::GetAvailableCates(vector<string>& vsCategories)
{
	vsCategories.SetSize(0);
	return 0;
}

//virtual 
void FilePublishBase::SetDestCategory(LPCSTR lpcszCategory)
{
	ASSERT(false);
}

//virtual 
string FilePublishBase::GetDestCategory(LPCSTR lpcszFile)
{
	return "";
}

//virtual 
bool FilePublishBase::IsSrcPathSpecified()
{
	return false;
}

//virtual 
int FilePublishBase::GetFiles(bool bSource, vector<string>& vsFiles)
{
	return -1;
}

//virtual 
int FilePublishBase::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	int nSize = vsFileNames.GetSize();
	vector<string> vsFileFullNames(nSize);

	const string &strPath = bSource ? m_strSrcPath : m_strDestPath;
	for (int ii=0; ii<nSize; ii++)
	{
		vsFileFullNames[ii] = strPath + vsFileNames[ii];
	}
	int nRet = CopyFiles(vsFileFullNames, bSource);

	if (nRet != nSize)
	{
		for (ii=nSize-1; ii>=0; ii--)
		{
			if (vsFileFullNames[ii].IsEmpty())
				vsFileNames.RemoveAt(ii);
		}
	}
	return nRet;
}

//virtual 
int FilePublishBase::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	int nSize = vsFileNames.GetSize();
	string strPath = bSource ? m_strSrcPath : m_strDestPath;
	for (int ii=nSize-1; ii>=0; ii--)
	{
		if (!okutil_delete_file(strPath + vsFileNames[ii], true))
			vsFileNames.RemoveAt(ii);
	}
	return vsFileNames.GetSize();
}

///-----Kit 01/31/2011 ORG-2126-S2 USE_FILE_NAME_AS_FIST_COL_NAME
//virtual int GetColNames(vector<string> &vsColNames, bool bSource)
int FilePublishBase::GetColNames(vector<string> &vsColNames, bool bSource)
	///-----
{
	vsColNames.SetSize(FB_COL_NUMS);

	///-----Kit 01/31/2011 ORG-2126-S2 USE_FILE_NAME_AS_FIST_COL_NAME
	/*
	if(bSource)
	vsColNames[FB_COL_FILE] = _L("User Files");
	else
	vsColNames[FB_COL_FILE] = _L("Group Files");
	*/
	vsColNames[FB_COL_FILE]		= _L("File Name");
	vsColNames[FB_COL_FILE_SPECIFIED]	= _L("File Name(Specified)");		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	///-----End USE_FILE_NAME_AS_FIST_COL_NAME

	vsColNames[FB_COL_CATEGORY] = _L("Category");
	vsColNames[FB_COL_FILETYPE] = _L("File Type");
	vsColNames[FB_COL_FILESIZE] = _L("File Size");
	vsColNames[FB_COL_FILEDATE] = _L("Modified Date");

	return vsColNames.GetSize();
}

//virtual 
int FilePublishBase::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	vsRowInfo.SetSize(FB_COL_NUMS);
	///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	//	vsRowInfo[FB_COL_FILE] = lpcszKey;
	//vsRowInfo[FB_COL_CATEGORY] = "";
	vsRowInfo[FB_COL_FILE] = GetFileName(lpcszKey);
	vsRowInfo[FB_COL_FILE_SPECIFIED] = lpcszKey;		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	vsRowInfo[FB_COL_CATEGORY]	= GetFilePath(lpcszKey);
	///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	vsRowInfo[FB_COL_FILETYPE] = "";
	vsRowInfo[FB_COL_FILESIZE] = GetFileSize(lpcszKey, bSource);
	vsRowInfo[FB_COL_FILEDATE] = GetFileDate(lpcszKey, bSource);
	return vsRowInfo.GetSize();
}

//virtual 
int FilePublishBase::GetShownInfo(vector<bool>& vbShow)
{
	vbShow.SetSize(FB_COL_NUMS);
	vbShow = false;
	vbShow[FB_COL_FILE] = true;
	vbShow[FB_COL_FILESIZE] = true;
	vbShow[FB_COL_FILEDATE] = true;

	return 3;
}

//virtual 
bool FilePublishBase::GetFileFullPath(string &strFile1, string &strFile2)
{
	strFile1 = m_strSrcPath + strFile1;
	strFile2 = m_strDestPath + strFile2;
	return true;
}

const string& FilePublishBase::GetSrcPath()
{
	return m_strSrcPath;
}

const string& FilePublishBase::GetDestPath()
{
	return m_strDestPath;
}

string FilePublishBase::GetFileSize(LPCSTR lpcszFile, bool bSource)
{
	string strFile = lpcszFile;
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//if ( strFile.IsFile() )
	if ( strFile.IsFile() && is_str_valid_file_path(strFile))
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		;
	else if(bSource)
		strFile = m_strSrcPath + strFile;
	else
		strFile = m_strDestPath + strFile;
	uint nSize;
	GetFileSize(strFile, &nSize);

	// always return the size in KB
	if(nSize > 1024)
		nSize = nSize/1024.0 + 0.5;
	else if(nSize > 0)
		nSize = 1;
	string strSize;
	strSize.Format("%d KB", nSize);
	return strSize;
}

string FilePublishBase::GetFileDate(LPCSTR lpcszFile, bool bSource)
{
	string strFile = lpcszFile;
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//if ( strFile.IsFile() )
	if ( strFile.IsFile() && is_str_valid_file_path(strFile))
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		;
	else if(bSource)
		strFile = m_strSrcPath + strFile;
	else
		strFile = m_strDestPath + strFile;
	return GetFileModificationDate(strFile, LDF_SHORT);
}

void FilePublishBase::GetFiles(LPCSTR lpcszPath, const vector<string> &vsFileExt, vector<string>& vsFiles)
{
	vsFiles.SetSize(0);
	string strPath(lpcszPath);
	if(!strPath.IsPath())
		return;

	for(int ii = 0; ii < vsFileExt.GetSize(); ii++)
	{
		vector<string> vsFindFiles;
		///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
		//FindFiles(vsFindFiles, lpcszPath, vsFileExt[ii], fals);
		FindFiles(vsFindFiles, lpcszPath, vsFileExt[ii], false, m_nRecursive);
		///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
		vsFiles.Append(vsFindFiles);
	}		
}

int FilePublishBase::CopyFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	//ASSERT(bSource);		///----- Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	if(vsFileNames.GetSize() == 0)
		return 0;

	// copy files
	int nFileCopied = 0;
	for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
	{
		string strDestFile, strDestPath;
		strDestFile = vsFileNames[ii];
		if(bSource)
			strDestFile.Replace(m_strSrcPath, m_strDestPath);
		else
			strDestFile.Replace(m_strDestPath, m_strSrcPath);

		strDestPath = GetFilePath(strDestFile);
		if ( !strDestPath.IsPath() )
			CheckMakePath(strDestPath);

		if ( !copyfile(vsFileNames[ii], strDestFile, 0) )
			nFileCopied++;
		else
		{
			vsFileNames[ii].Empty();
		}
	}
	return nFileCopied;
}


//virtual 
bool FilePublishBase::GetSourceDestFilePath()
{
	m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER);
	m_strDestPath = GetGroupFolderPath();

	return true;
}

string FilePublishBase::GetGroupFolderPath(LPCSTR lpcszSubPath/* = NULL*/)
{
	return okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER, lpcszSubPath, true);
}

/************************************************************************/
/* FileTransferBase
/************************************************************************/
FileTransferBase::FileTransferBase(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath)
{
	m_strRegistryKey = lpcszRegKey;
	///------ Folger 07/23/2012 ORG-6262-P1 FAILED_TO_GET_86_AS_OLDER_VERSION_IN_ORIGIN
	LPCSTR lpcszOrigin86 = "Origin 8.6";
	if ( m_strRegistryKey.Find(lpcszOrigin86) == 0 )
	{
		m_strRegistryKey = "Origin 9" + m_strRegistryKey.Mid(lstrlen(lpcszOrigin86));
	}
	///------ End FAILED_TO_GET_86_AS_OLDER_VERSION_IN_ORIGIN
	m_strSpecifiedPath = lpcszSpecifiedPath;
	m_bSrcPathSpecified = false;
	GetSourceDestFilePath();
}

//virtual 
bool FileTransferBase::IsSrcPathSpecified()
{
	return m_bSrcPathSpecified;
}

// virtual
bool FileTransferBase::GetSourceDestFilePath()
{
	m_strDestPath = okutil_get_origin_path(ORIGIN_PATH_USER);

	if(get_origin_user_path(m_strSrcPath, m_strRegistryKey, true))
	{
		m_bSrcPathSpecified = false;
	}
	else
	{
		m_bSrcPathSpecified = true;
		m_strSrcPath = m_strSpecifiedPath;
	}
	m_strSrcPath.TrimRight("\\");
	if(m_strSrcPath.IsEmpty())
		return false;
	m_strSrcPath += "\\";
	if(!m_strSrcPath.IsPath())
	{
		m_strSrcPath.Empty();
		return false;
	}

	return true;
}

///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
/************************************************************************/
/* FileCategoryImpl
/************************************************************************/
//FileCategoryImpl::FileCategoryImpl(FilePublishBase *pFileCate, LPCSTR lpcszFileExts)
//{
//	m_pFileCate = NULL;
//}

bool FileCategoryImpl::Init(FilePublishBase *pFileCate, LPCSTR lpcszFileExts)
{
	m_pFileCate = pFileCate;

	int nErr;
	return okutil_get_tokens(lpcszFileExts, &m_vsFileExts, '|', &nErr);
}

///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
bool FileCategoryImpl::GetFileFullPath(string &strFile1, string &strFile2)
{
	// trim the category info
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//string strTmp = m_pFileCate->IsSrcPathSpecified() ? GetFileName(strFile1) : strFile1;
	//strFile1 = m_pFileCate->GetSrcPath() + strTmp;
	strFile1 = m_pFileCate->GetSrcPath() + strFile1;
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION

	strFile2 = m_pFileCate->GetDestPath() + strFile2;
	return true;
}

string FileCategoryImpl::GetDestCategory(LPCSTR lpcszFile, LPCSTR lpcszExtPatterns)
{
	ASSERT(NULL != lpcszFile);
	string strExt;
	separate_file_name_ext(lpcszFile, NULL, &strExt);
	ASSERT(!strExt.IsEmpty());

	VecStr vsExtPatterns;
	string strExtPatterns(lpcszExtPatterns);
	strExtPatterns.GetTokens(vsExtPatterns, '|');
	
	ASSERT(vsExtPatterns.GetSize() == m_vsCategories.GetSize());
	
	const int index = vsExtPatterns.Find(strExt);
	if ( index < 0 )
	{
		ASSERT(false);
		return "";
	}

	return m_vsCategories[index] + "\\";

	//if ( strExt.Find(vsExtPatterns[0]) >= 0 )
	//	return m_vsCategories[0] + "\\";

	//ASSERT(strExt.Find(vsExtPatterns[1]) >= 0);
	//return m_vsCategories[1] + "\\";
}
///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH

int	FileCategoryImpl::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	vsRowInfo.SetSize(FB_COL_NUMS);
	vsRowInfo[FB_COL_FILE] 		= GetFileName(lpcszKey);
	vsRowInfo[FB_COL_FILE_SPECIFIED] 	= lpcszKey;		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	///-----Kit 1025/2011 ORG-4062-P2 GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
	//vsRowInfo[FB_COL_CATEGORY] 	= GetFilePath(lpcszKey);
	vsRowInfo[FB_COL_CATEGORY] 	= m_pFileCate->GetDestCategory(lpcszKey);
	///-----End GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
	vsRowInfo[FB_COL_FILETYPE] 	= "";
	vsRowInfo[FB_COL_FILESIZE] 	= m_pFileCate->GetFileSize(lpcszKey, bSource);
	vsRowInfo[FB_COL_FILEDATE] 	= m_pFileCate->GetFileDate(lpcszKey, bSource);
	return vsRowInfo.GetSize();
}

int FileCategoryImpl::GetShownInfo(vector<bool>& vbShow)
{
	vbShow.SetSize(FB_COL_NUMS);
	vbShow = false;
	vbShow[FB_COL_FILE] =
	vbShow[FB_COL_FILESIZE] =
	vbShow[FB_COL_FILEDATE] = true;

	return 3;		// shown cols
}

int	FileCategoryImpl::GetFiles(bool bSource, bool bRecursive, vector<string>& vsFiles)
{
	const string &strPath = bSource ? m_pFileCate->GetSrcPath() : m_pFileCate->GetDestPath();

	// here can be imporve, we can only find the category path specified.
	for (int ii = 0; ii<m_vsFileExts.GetSize(); ii++)
	{
		string strFile;
		GetFilenamesInFolder(strFile, strPath, m_vsFileExts[ii], bRecursive);
		if ( strFile.IsEmpty() )
			continue;
		
		vector<string> vsTmp;
		strFile.GetTokens(vsTmp, '|');
		vsFiles.Append(vsTmp);
	}

	VecStr &vsXFFullFiles	= *GetXFFullFiles(bSource);
	VecStr &vsXFFiles		= *GetXFFiles(bSource);

	vsXFFullFiles = vsFiles;
	const int nSize = vsFiles.GetSize();
	vsXFFiles.SetSize(nSize);

	for ( ii = 0; ii < nSize; ++ii )
	{
		vsFiles[ii].Replace(strPath, "");
		vsXFFiles[ii] = vsFiles[ii];
	}

	return nSize;
}

int	FileCategoryImpl::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	const int nSize = vsFileNames.GetSize();
	vector<string> vsFileFullNames(nSize);

	VecStr &vsSrcFiles = *GetXFFiles(bSource);
	VecStr &vsDstFiles = *GetXFFiles(!bSource);
	VecStr &vsSrcFullFiles = *GetXFFullFiles(bSource);
	VecStr &vsDstFullFiles = *GetXFFullFiles(!bSource);

	const string &strSrcPath = bSource ? m_pFileCate->GetSrcPath() : m_pFileCate->GetDestPath();
	const string &strDstPath = bSource ? m_pFileCate->GetDestPath() : m_pFileCate->GetSrcPath();
	for ( int ii = 0; ii < nSize; ++ii )
	{
		const int nIndex = vsSrcFiles.Find(vsFileNames[ii]);
		vsFileFullNames[ii] = vsSrcFullFiles[nIndex];
		if (vsDstFiles.Find(vsFileNames[ii]) < 0)
		{
			vsDstFiles.Add(vsFileNames[ii]);
			vsDstFullFiles.Add(vsFileFullNames[ii]);
			vsDstFullFiles[vsDstFullFiles.GetSize()-1].Replace(strSrcPath, strDstPath);
		}
	}

	int nRet = m_pFileCate->CopyFiles(vsFileFullNames, bSource);
	if (nRet != nSize)
	{
		for (int ii=nSize-1; ii>=0; ii--)
		{
			if (vsFileFullNames[ii].IsEmpty())
			{
				const int nIndex = vsSrcFiles.Find(vsFileNames[ii]);
				vsSrcFiles.RemoveAt(nIndex);
				vsSrcFullFiles.RemoveAt(nIndex);

				vsFileNames.RemoveAt(ii);
			}
		}
	}

	return nRet;
}

int FileCategoryImpl::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	const int nSize = vsFileNames.GetSize();

	VecStr &vsXFFiles = *GetXFFiles(bSource);
	VecStr &vsXFFullFiles = *GetXFFullFiles(bSource);

	for (int ii = nSize-1; ii>=0; ii--)
	{
		const int nIndex = vsXFFiles.Find(vsFileNames[ii]);
		if ( nIndex < 0 )
		{
			ASSERT(false);
			continue;
		}

		if (okutil_delete_file(vsXFFullFiles[nIndex], true))
		{
			vsXFFiles.RemoveAt(nIndex);
			vsXFFullFiles.RemoveAt(nIndex);
		}
		else
		{
			vsFileNames.RemoveAt(ii);
		}
	}

	return vsFileNames.GetSize();
}
///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES

/************************************************************************/
/* FileCategoryPublishImpl
/************************************************************************/
// nothing


/************************************************************************/
/* FileCategoryTransferImpl
/************************************************************************/
bool FileCategoryTransferImpl::Init(FilePublishBase *pFileCate, LPCSTR lpcszFileExts, bool bSrcPathSpecified)
{
	m_bSrcPathSpecified = bSrcPathSpecified;
	return FileCategoryImpl::Init(pFileCate, lpcszFileExts);
}

//virtual 
int	FileCategoryTransferImpl::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	ASSERT(bSource);

	const int nSize = vsFileNames.GetSize();

	vector<string> vsFileFullNames(nSize);

	const string &strSrcPath = m_pFileCate->GetSrcPath();
	const string &strDstPath = m_pFileCate->GetDestPath();

	for (int ii = 0; ii < nSize; ii++ )
	{
		if(m_bSrcPathSpecified)
		{
			///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
			//const int nIndex = m_vsXFSrcFiles.Find(strFileName);
			string strFileName = GetFileName(vsFileNames[ii]);
			vector<string> vsXFSrcFilesName;
			vsXFSrcFilesName.SetSize(0);
			for(int jj = 0; jj < m_vsXFSrcFiles.GetSize(); jj++)
			{	
				vsXFSrcFilesName.Add(GetFileName(m_vsXFSrcFiles[jj]));
			}

			const int nIndex = vsXFSrcFilesName.Find(strFileName);
			///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
			
			if ( nIndex < 0 )
				continue;

			vsFileFullNames[ii] = m_vsXFSrcFullFiles[nIndex];
			ASSERT(!vsFileFullNames[ii].IsEmpty());
			const string strDestFile = m_pFileCate->GetDestCategory(strFileName) + strFileName;
			vsFileNames[ii] = strDestFile;									// will use this to update the dest list
			if (m_vsXFDstFiles.Find(strDestFile) < 0)
			{
				m_vsXFDstFiles.Add(strDestFile);
				m_vsXFDstFullFiles.Add(strDstPath + strDestFile);
			}
		}
		else
		{
			const int nIndex = m_vsXFSrcFiles.Find(vsFileNames[ii]);
			if ( nIndex < 0 )
			{
				ASSERT(false);
				continue;
			}
			vsFileFullNames[ii] = m_vsXFSrcFullFiles[nIndex];
			if (m_vsXFDstFiles.Find(vsFileNames[ii]) < 0)
			{
				m_vsXFDstFiles.Add(vsFileNames[ii]);
				m_vsXFDstFullFiles.Add(m_vsXFSrcFullFiles[nIndex]);
				m_vsXFDstFullFiles[m_vsXFDstFullFiles.GetSize()-1].Replace(strSrcPath, strDstPath);
			}
		}
	}

	const int nRet = m_pFileCate->CopyFiles(vsFileFullNames, bSource);

	if (nRet != nSize)
	{
		for (int ii=nSize-1; ii>=0; ii--)
		{
			if (vsFileFullNames[ii].IsEmpty())
			{
				const int nIndex = m_vsXFSrcFiles.Find(vsFileNames[ii]);
				if ( nIndex < 0 )
				{
					ASSERT(false);
					continue;
				}
				m_vsXFSrcFiles.RemoveAt(nIndex);
				m_vsXFSrcFullFiles.RemoveAt(nIndex);
				vsFileNames.RemoveAt(ii);
			}
		}
	}
	return nRet;

}

/************************************************************************/
/* FileCategoryPublish
/************************************************************************/
FileCategoryPublish::FileCategoryPublish(LPCSTR lpcszFileExts)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//int nErr;
	//okutil_get_tokens(lpcszFileExts, &m_vsFileExts, '|', &nErr);
	m_FileCateImpl.Init(this, lpcszFileExts);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
//virtual 
bool FileCategoryPublish::GetFileFullPath(string &strFile1, string &strFile2)
{
	return m_FileCateImpl.GetFileFullPath(strFile1, strFile2);
}
///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH

//virtual 
int FileCategoryPublish::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//vsRowInfo.SetSize(FB_COL_NUMS);
	//vsRowInfo[FB_COL_FILE] 		= GetFileName(lpcszKey);
	//vsRowInfo[FB_COL_CATEGORY] 	= GetFilePath(lpcszKey);
	//vsRowInfo[FB_COL_FILETYPE] 	= "";
	//vsRowInfo[FB_COL_FILESIZE] 	= GetFileSize(lpcszKey, bSource);
	//vsRowInfo[FB_COL_FILEDATE] 	= GetFileDate(lpcszKey, bSource);
	//return vsRowInfo.GetSize();
	return m_FileCateImpl.GetRowInfo(lpcszKey, vsRowInfo, bSource);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
int FileCategoryPublish::GetShownInfo(vector<bool>& vbShow)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//vbShow.SetSize(FB_COL_NUMS);
	//vbShow = false;
	//vbShow[FB_COL_FILE] =
	//	vbShow[FB_COL_FILESIZE] =
	//	vbShow[FB_COL_FILEDATE] = true;

	//return 3;		// shown cols
	return m_FileCateImpl.GetShownInfo(vbShow);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
int FileCategoryPublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//for (int ii=0; ii<m_vsFileExts.GetSize(); ii++)
	//{
	//	string strFile;
	//	GetFilenamesInFolder(strFile, bSource ? m_strSrcPath : m_strDestPath, m_vsFileExts[ii], true);
	//	vector<string> vsTmp;
	//	strFile.GetTokens(vsTmp, '|');
	//	vsFiles.Append(vsTmp);
	//}

	//const int nSize = vsFiles.GetSize();

	//if (bSource)
	//{
	//	m_vsXFUserFullFiles = vsFiles;
	//	m_vsXFUserFiles.SetSize(nSize);
	//}
	//else
	//{
	//	m_vsXFGroupFullFiles = vsFiles;
	//	m_vsXFGroupFiles.SetSize(nSize);
	//}
	//for (ii=0; ii<nSize; ii++)
	//{
	//	if (bSource)
	//	{
	//		vsFiles[ii].Replace(m_strSrcPath, "");
	//		m_vsXFUserFiles[ii] = vsFiles[ii];
	//	}
	//	else
	//	{
	//		vsFiles[ii].Replace(m_strDestPath, "");
	//		m_vsXFGroupFiles[ii] = vsFiles[ii];
	//	}
	//}

	//return nSize;
	return m_FileCateImpl.GetFiles(bSource, true, vsFiles);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
int FileCategoryPublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//const int nSize = vsFileNames.GetSize();
	//vector<string> vsFileFullNames(nSize);

	//if (bSource)
	//{
	//	for(int ii=0; ii<nSize; ii++)
	//	{
	//		int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
	//		vsFileFullNames[ii] = m_vsXFUserFullFiles[nIndex];
	//		if (m_vsXFGroupFiles.Find(vsFileNames[ii]) < 0)
	//		{
	//			m_vsXFGroupFiles.Add(vsFileNames[ii]);
	//			m_vsXFGroupFullFiles.Add(vsFileFullNames[ii]);
	//			m_vsXFGroupFullFiles[m_vsXFGroupFullFiles.GetSize()-1].Replace(m_strSrcPath, m_strDestPath);
	//		}
	//	}
	//}
	//else
	//{
	//	for(int ii = 0; ii < nSize; ii++ )
	//	{
	//		int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
	//		vsFileFullNames[ii] = m_vsXFGroupFullFiles[nIndex];
	//		if (m_vsXFUserFiles.Find(vsFileNames[ii]) < 0)
	//		{
	//			m_vsXFUserFiles.Add(vsFileNames[ii]);
	//			m_vsXFUserFullFiles.Add(vsFileFullNames[ii]);
	//			m_vsXFUserFullFiles[m_vsXFUserFullFiles.GetSize()-1].Replace(m_strDestPath, m_strSrcPath);
	//		}
	//	}
	//}

	//int nRet = CopyFiles(vsFileFullNames, bSource);
	//if (nRet != nSize)
	//{
	//	for (int ii=nSize-1; ii>=0; ii--)
	//	{
	//		if (vsFileFullNames[ii].IsEmpty())
	//		{
	//			if (bSource)
	//			{
	//				int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
	//				m_vsXFUserFiles.RemoveAt(nIndex);
	//				m_vsXFUserFullFiles.RemoveAt(nIndex);
	//			}
	//			else
	//			{
	//				int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
	//				m_vsXFGroupFiles.RemoveAt(nIndex);
	//				m_vsXFGroupFullFiles.RemoveAt(nIndex);
	//			}

	//			vsFileNames.RemoveAt(ii);
	//		}
	//	}
	//}

	//return nRet;
	return m_FileCateImpl.PublishFiles(vsFileNames, bSource);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
int FileCategoryPublish::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//int nSize = vsFileNames.GetSize();
	//if ( !bSource )
	//{
	//	for (int ii=nSize-1; ii>=0; ii--)
	//	{
	//		int nIndex = m_vsXFGroupFiles.Find(vsFileNames[ii]);
	//		if (okutil_delete_file(m_vsXFGroupFullFiles[nIndex], true))
	//		{
	//			m_vsXFGroupFiles.RemoveAt(nIndex);
	//			m_vsXFGroupFullFiles.RemoveAt(nIndex);
	//		}
	//		else
	//		{
	//			vsFileNames.RemoveAt(ii);
	//		}
	//	}
	//}
	//else
	//{
	//	for (int ii=nSize-1; ii>=0; ii--)
	//	{
	//		int nIndex = m_vsXFUserFiles.Find(vsFileNames[ii]);
	//		if (okutil_delete_file(m_vsXFUserFullFiles[nIndex], true))
	//		{
	//			m_vsXFUserFiles.RemoveAt(nIndex);
	//			m_vsXFUserFullFiles.RemoveAt(nIndex);
	//		}
	//		else
	//		{
	//			vsFileNames.RemoveAt(ii);
	//		}
	//	}
	//}
	//return vsFileNames.GetSize();
	return m_FileCateImpl.RemoveFiles(vsFileNames, bSource);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

/************************************************************************/
/* FileCategoryTransfer
/************************************************************************/
FileCategoryTransfer::FileCategoryTransfer(LPCSTR lpcszFileExt, LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//int nErr;
	//okutil_get_tokens(lpcszFileExts, &m_vsFileExts, '|', &nErr);
	m_FileCateImpl.Init(this, lpcszFileExt, m_bSrcPathSpecified);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
bool FileCategoryTransfer::GetFileFullPath(string &strFile1, string &strFile2)
{
	///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	//// trim the category info
	//string strTmp = IsSrcPathSpecified() ? GetFileName(strFile1) : strFile1;
	//strFile1 = m_strSrcPath + strTmp;

	//strFile2 = m_strDestPath + strFile2;
	//return true;
	return m_FileCateImpl.GetFileFullPath(strFile1, strFile2);
	///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
}

//virtual 
int FileCategoryTransfer::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//vsRowInfo.SetSize(FB_COL_NUMS);
	//vsRowInfo[FB_COL_FILE] 		= GetFileName(lpcszKey);
	//vsRowInfo[FB_COL_CATEGORY] 	= GetFilePath(lpcszKey);
	//vsRowInfo[FB_COL_FILETYPE] 	= "";
	//vsRowInfo[FB_COL_FILESIZE] 	= GetFileSize(lpcszKey, bSource);
	//vsRowInfo[FB_COL_FILEDATE] 	= GetFileDate(lpcszKey, bSource);

	//return vsRowInfo.GetSize();
	return m_FileCateImpl.GetRowInfo(lpcszKey, vsRowInfo, bSource);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
int FileCategoryTransfer::GetShownInfo(vector<bool>& vbShow)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//vbShow.SetSize(FB_COL_NUMS);
	//vbShow = false;
	//vbShow[FB_COL_FILE] =
	//	vbShow[FB_COL_FILESIZE] =
	//	vbShow[FB_COL_FILEDATE] = true;

	//return 3;	// shown cols
	return m_FileCateImpl.GetShownInfo(vbShow);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
int FileCategoryTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//bool bRecursive = !(bSource && m_bSrcPathSpecified);
	//for (int ii=0; ii<m_vsFileExts.GetSize(); ii++)
	//{
	//	string strFile;
	//	GetFilenamesInFolder(strFile, bSource ? m_strSrcPath : m_strDestPath, m_vsFileExts[ii], bRecursive);
	//	vector<string> vsTmp;
	//	strFile.GetTokens(vsTmp, '|');
	//	vsFiles.Append(vsTmp);
	//}
	//int nSize = vsFiles.GetSize();

	//if (bSource)
	//{
	//	m_vsXFSrcFullFiles = vsFiles;
	//	m_vsXFSrcFiles.SetSize(nSize);
	//}
	//else
	//{
	//	m_vsXFDestFullFiles = vsFiles;
	//	m_vsXFDestFiles.SetSize(nSize);
	//}
	//for (ii=0; ii<nSize; ii++)
	//{
	//	if (bSource)
	//	{
	//		vsFiles[ii].Replace(m_strSrcPath, "");
	//		m_vsXFSrcFiles[ii] = vsFiles[ii];
	//	}
	//	else
	//	{
	//		vsFiles[ii].Replace(m_strDestPath, "");
	//		m_vsXFDestFiles[ii] = vsFiles[ii];
	//	}
	//}
	//return nSize;
	///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	//const bool bRecursive = !(bSource && m_bSrcPathSpecified);  
	bool bRecursive;
	if(m_nRecursive == 0)
	{
		bRecursive = !(bSource && m_bSrcPathSpecified);  
	}
	else
	{
		bRecursive = m_nRecursive;
	}
	///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
	return m_FileCateImpl.GetFiles(bSource, bRecursive, vsFiles);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES   
}

//virtual 
int FileCategoryTransfer::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//ASSERT(bSource);

	//int nSize = vsFileNames.GetSize();
	//vector<string> vsFileFullNames(nSize);

	//for (int ii = 0; ii < nSize; ii++ )
	//{
	//	if(m_bSrcPathSpecified)
	//	{
	//		string strFileName = GetFileName(vsFileNames[ii]);
	//		int nIndex = m_vsXFSrcFiles.Find(strFileName);
	//		vsFileFullNames[ii] = m_vsXFSrcFullFiles[nIndex];
	//		string strDestFile = GetDestCategory() + strFileName;
	//		vsFileNames[ii] = strDestFile;									// will use this to update the dest list
	//		if (m_vsXFDestFiles.Find(strDestFile) < 0)
	//		{
	//			m_vsXFDestFiles.Add(strDestFile);
	//			m_vsXFDestFullFiles.Add(m_strDestPath + strDestFile);
	//		}
	//	}
	//	else
	//	{
	//		int nIndex = m_vsXFSrcFiles.Find(vsFileNames[ii]);
	//		vsFileFullNames[ii] = m_vsXFSrcFullFiles[nIndex];
	//		if (m_vsXFDestFiles.Find(vsFileNames[ii]) < 0)
	//		{
	//			m_vsXFDestFiles.Add(vsFileNames[ii]);
	//			m_vsXFDestFullFiles.Add(m_vsXFSrcFullFiles[nIndex]);
	//			m_vsXFDestFullFiles[m_vsXFDestFullFiles.GetSize()-1].Replace(m_strSrcPath, m_strDestPath);
	//		}
	//	}
	//}
	//int nRet = CopyFiles(vsFileFullNames, bSource);
	//if (nRet != nSize)
	//{
	//	for (int ii=nSize-1; ii>=0; ii--)
	//	{
	//		if (vsFileFullNames[ii].IsEmpty())
	//		{
	//			int nIndex = m_vsXFSrcFiles.Find(vsFileNames[ii]);
	//			m_vsXFSrcFiles.RemoveAt(nIndex);
	//			m_vsXFSrcFullFiles.RemoveAt(nIndex);
	//			vsFileNames.RemoveAt(ii);
	//		}
	//	}
	//}
	//return nRet;
	return m_FileCateImpl.PublishFiles(vsFileNames, bSource);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
int FileCategoryTransfer::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	ASSERT(!bSource);

	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//int nSize = vsFileNames.GetSize();
	//for (int ii = nSize-1; ii >= 0; ii--)
	//{
	//	int nIndex = m_vsXFDestFiles.Find(vsFileNames[ii]);
	//	if (okutil_delete_file(m_vsXFDestFullFiles[nIndex], true))
	//	{
	//		m_vsXFDestFiles.RemoveAt(nIndex);
	//		m_vsXFDestFullFiles.RemoveAt(nIndex);
	//	}
	//	else
	//	{
	//		vsFileNames.RemoveAt(ii);
	//	}
	//}
	//return vsFileNames.GetSize();
	return m_FileCateImpl.RemoveFiles(vsFileNames, bSource);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	
}


//virtual 
int FileCategoryTransfer::CopyFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	ASSERT(bSource);
	if(vsFileNames.GetSize() == 0)
		return 0;
	if ( !m_bSrcPathSpecified )
		return FileTransferBase::CopyFiles(vsFileNames, bSource);

	int nFileCopied = 0;
	for(int ii=vsFileNames.GetSize()-1; ii>=0; ii--)
	{
		string strFileName = GetFileName(vsFileNames[ii]);
		// it needs specifying a category, special handle
		string strDestPath = m_strDestPath + GetDestCategory(strFileName);
		if ( !strDestPath.IsPath() )
			CheckMakePath(strDestPath);

		string strDestFile = strDestPath + strFileName;
		if ( !copyfile(vsFileNames[ii], strDestFile, 0) )
			nFileCopied++;
		else
			vsFileNames[ii].Empty();
	}
	return nFileCopied;
}

/************************************************************************/
/* ThemePublish
/************************************************************************/
#define STR_THEME_FILE_FOLDER			"Themes\\"
ThemePublish::ThemePublish(LPCSTR lpcszFileExt) : FileCategoryPublish(lpcszFileExt)
{
	m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_THEME_FILE_FOLDER, TRUE);
	m_strDestPath = GetGroupFolderPath(STR_THEME_FILE_FOLDER);
}

/************************************************************************/
/* ThemeTransfer
/************************************************************************/
ThemeTransfer::ThemeTransfer(LPCSTR lpcszFileExt, LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileCategoryTransfer(lpcszFileExt, lpcszRegKey, lpcszSpecifiedPath)
{
	if(!m_bSrcPathSpecified)
		m_strSrcPath += STR_THEME_FILE_FOLDER;
	m_strDestPath += STR_THEME_FILE_FOLDER;

	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	// hard code, available categories
	//m_vsCategories.SetSize(0);
	//m_vsCategories.Add("Graph");
	//m_vsCategories.Add("Worksheet");
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

//virtual 
int ThemeTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	const int nFiles = FileCategoryTransfer::GetFiles(bSource, vsFiles);
	///Kyle 10/12/2011 ORG-4062-P1 TRANSFER_USER_FILES_FAILED_TO_LIST_FILES_IN_SPECIFIED_FOLDER
//	///Kyle 08/04/2010 ORG-710-P1 SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
//	//if(bSource && m_bSrcPathSpecified)		// no need to check the category
//	//	return nFiles;
//	bool bCheckCate = m_bSrcPathSpecified && !m_strDestCategory.IsEmpty();
//	///End SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
	if(bSource && m_bSrcPathSpecified)		// no need to check the category
		return nFiles;

	///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
	//bool bCheckCate = !bSource && m_bSrcPathSpecified && !m_strDestCategory.IsEmpty();		// check dest only and only when source path specified
	///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
	///End TRANSFER_USER_FILES_FAILED_TO_LIST_FILES_IN_SPECIFIED_FOLDER

	VecStr &vsXFFullFiles = *m_FileCateImpl.GetXFFullFiles(bSource);
	VecStr &vsXFFiles = *m_FileCateImpl.GetXFFiles(bSource);

	for(int ii = nFiles-1; ii >= 0; ii--)
	{
		string strPath = GetFilePath(vsFiles[ii]);

		///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
		//bool bDiffCate = bCheckCate && m_strDestCategory.CompareNoCase(strPath);		///Kyle 08/04/2010 ORG-710-P1 SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
		const string strDestCategory = GetDestCategory(vsFiles[ii]);
		bool bCheckCate = !bSource && m_bSrcPathSpecified && !strDestCategory.IsEmpty();		// check dest only and only when source path specified
		bool bDiffCate = bCheckCate && strDestCategory.CompareNoCase(strPath);
		///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH

		strPath.TrimRight("\\");
		///Kyle 08/04/2010 ORG-710-P1 SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
		//if(m_vsCategories.Find(strPath) < 0)
		///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
		//if( bDiffCate || m_vsCategories.Find(strPath) < 0 )
		if( bDiffCate || m_FileCateImpl.GetCategories()->Find(strPath) < 0 )
		///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
			///End SHOW_ONLY_GRAPH_OR_WORKSHEET_THEME_IF_PATH_SPECIFIED
		{

			///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
			//if (bSource)
			//{
			//	m_vsXFSrcFullFiles.RemoveAt(ii);
			//	m_vsXFSrcFiles.RemoveAt(ii);
			//}
			//else
			//{
			//	m_vsXFDestFullFiles.RemoveAt(ii);
			//	m_vsXFDestFiles.RemoveAt(ii);
			//}
			vsXFFullFiles.RemoveAt(ii);
			vsXFFiles.RemoveAt(ii);
			///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
			vsFiles.RemoveAt(ii);
			nFiles--;
		}
	}
	return nFiles;
}

///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
////virtual 
//void ThemeTransfer::SetDestCategory(LPCSTR lpcszCategory)
//{
//	m_strDestCategory = lpcszCategory;
//	m_strDestCategory.TrimRight("\\");
//	m_strDestCategory += "\\";
//}
///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH

//virtual 
int	ThemeTransfer::GetAvailableCates(vector<string>& vsCategories)
{
	if(m_bSrcPathSpecified)
	{
		///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
		//vsCategories = m_vsCategories;
		vsCategories = *(m_FileCateImpl.GetCategories());
		///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
		return vsCategories.GetSize();
	}

	vsCategories.SetSize(0);
	return 0;
}

///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
////virtual 
//string ThemeTransfer::GetDestCategory(LPCSTR lpcszFile)
//{
//	return m_strDestCategory;
//}
///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH

///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
/************************************************************************/
/*  WindowThemePublish
/************************************************************************/
WindowThemePublish::WindowThemePublish()
	: ThemePublish("*.oth")
{
}

///-----Kit 11/23/2011 ORG-4363-P6 PUBLISH_GRAPH_THEME_FAILED_IN_GROUP_MGR
//virtual 
string	WindowThemePublish::GetDestCategory(LPCSTR lpcszFile)
{
	return GetFilePath(lpcszFile);
}
///-----End PUBLISH_GRAPH_THEME_FAILED_IN_GROUP_MGR

/************************************************************************/
/*  WindowThemePublish
/************************************************************************/
WindowThemeTransfer::WindowThemeTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath)
	: ThemeTransfer("*.oth", lpcszRegKey, lpcszSpecifiedPath)
{
	// hard code, available categories
	///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	//m_vsCategories.SetSize(2);	// now only 2 sub categories
	//m_vsCategories[0] = "Graph";
	//m_vsCategories[1] = "Worksheet";
	VecStr &vsCategories = *(m_FileCateImpl.GetCategories());
	vsCategories.SetSize(2);
	vsCategories[0] = "Graph";
	vsCategories[1] = "Worksheet";
	///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
}
///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES

///-----Kit 11/02/2011 ORG-4062-P3 PUBLISH_WINDOW_THEME_FILE_OUT_OF_INDEX
//virtual 
string	WindowThemeTransfer::GetDestCategory(LPCSTR lpcszFile)
{
	///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
	string strReturn;
	if ( m_bSrcPathSpecified )
	{
		strReturn = m_strDestCategory;
	}
	else
	{
		///-----Kit 11/02/2011 : That's very very very very tricky code here !!!!!! YOU MUST very careful here
		///						 For window theme and graph theme share the same file extension.
		///						 we can not get the destination category from file extension
		///						 so lpcszFile should keep the category path  !!!!
		///						 it is something like Worksheet\wks.oth or Graph\graph.oth
		///						 fortunately, we can know the path("Worksheet" and "Graph"), when we open Transfer User File dialog
		///						 or we can get the path from the combo box in Transfer User File dialog to know that, what sub path it is !!!!

		strReturn = GetFilePath(lpcszFile);
		ASSERT(!strReturn.IsEmpty());
	}

	if ( !strReturn.IsEmpty() && strReturn[strReturn.GetLength()-1] != '\\')
		strReturn += "\\";

	return strReturn;
	///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
}
///-----End PUBLISH_WINDOW_THEME_FILE_OUT_OF_INDEX

///-----Kit 11/04/2011 ORG-4062-P3 THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH
//virtual 
void WindowThemeTransfer::SetDestCategory(LPCSTR lpcszCategory)
{
	ASSERT(m_bSrcPathSpecified);
	m_strDestCategory = lpcszCategory;
}
///-----End THEME_FILE_TRANSFER_FAILED_IN_SPECIFY_PATH

///------ Folger 11/12/2011 ORG-4362-P3 FAILED_TO_PUBLISH_XF
static	string	_get_xf_category(LPCSTR lpcszFile)
{
	string		strFile(lpcszFile);
	int			nLastBackSlash = strFile.ReverseFind('\\');
	if ( nLastBackSlash )
		return strFile.Left(nLastBackSlash + 1);

	return "";
}
///------ End FAILED_TO_PUBLISH_XF

/************************************************************************/
/*  XFPublish
/************************************************************************/
XFPublish::XFPublish() 
	: FileCategoryPublish("*.oxf")
{
	m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_XF_FILE_FOLDER, TRUE);
	m_strDestPath = GetGroupFolderPath(STR_XF_FILE_FOLDER);
}

///------ Folger 11/12/2011 ORG-4362-P3 FAILED_TO_PUBLISH_XF
/// virtual
string XFPublish::GetDestCategory(LPCSTR lpcszFile)
{
	return _get_xf_category(lpcszFile);
}
///------ End FAILED_TO_PUBLISH_XF

/************************************************************************/
/* XFTransfer
/************************************************************************/
XFTransfer::XFTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileCategoryTransfer("*.oxf", lpcszRegKey, lpcszSpecifiedPath)
{
	if(m_bSrcPathSpecified == false)
		m_strSrcPath += STR_XF_FILE_FOLDER + "\\";
	m_strDestPath += STR_XF_FILE_FOLDER + "\\";
}

//virtual 
string XFTransfer::GetDestCategory(LPCSTR lpcszFile)
{
	///------ Folger 11/12/2011 ORG-4362-P3 FAILED_TO_PUBLISH_XF
	//return "Miscellaneous\\";
	return _get_xf_category(lpcszFile);
	///------ End FAILED_TO_PUBLISH_XF
}

/************************************************************************/
/* TemplatePublish
/************************************************************************/
//virtual 
int TemplatePublish::GetFiles(bool bSource, vector<string>& vsFiles)
{

	Tree trXML;
	if (!load_template_tree(trXML, bSource ? TEMPLATE_LOCATION_USER_FOLDER : TEMPLATE_LOCATION_SERVER_GROUP_FOLDER))
		return 0;

	tree_get_attributes(trXML, vsFiles, STR_FILENAME_ATTRIB);

	for (int ii=vsFiles.GetSize()-1; ii>=0; ii--)
	{
		if (vsFiles[ii].IsEmpty() || (bSource && template_get_origin_path_type(vsFiles[ii]) == ORIGIN_PATH_UNDEF))
			vsFiles.RemoveAt(ii);
		else
			vsFiles[ii] = GetFileName(vsFiles[ii]);
	}

	return vsFiles.GetSize();

}

//virtual 
int TemplatePublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	//Load template XML
	Tree trXML;		
	if (!load_template_tree(trXML, bSource ? TEMPLATE_LOCATION_USER_FOLDER : TEMPLATE_LOCATION_SERVER_GROUP_FOLDER))
		return 0;

	//if destination xml files not exist, create it
	Tree trTmp;
	string strPath = bSource ? STR_SERVER_GROUP_TEMPLATE_XML : STR_TEMPLATE_XML;

	_check_create_tempalte_xml(strPath);

	const int nSize = vsFileNames.GetSize();
	vector<string> vsFileFullNames(nSize);
	vector<string> vsPictures;		

	const string &strPathFrom = bSource ? m_strSrcPath : m_strDestPath;
	const string &strPathTo = bSource ? m_strDestPath : m_strSrcPath;

	for (int ii=0; ii<nSize; ii++)
	{
		vsFileFullNames[ii] = strPathFrom + vsFileNames[ii];
		//add picture
		string strPicture = _check_get_pictrue_name(vsFileFullNames[ii]);
		if (!strPicture.IsEmpty())
			vsPictures.Add(strPicture);

		const int nTemplateType = _get_template_type_from_name(vsFileNames[ii]);
		TreeNode trBranch = tree_get_node_by_id(trXML, nTemplateType);
		string strCate;

		findTemplate(trBranch, bSource ? vsFileFullNames[ii] : vsFileNames[ii], strCate);
		okutil_add_template(strPath, strCate, vsFileNames[ii], nTemplateType);
	}

	//copy files
	const int nRet = CopyFiles(vsFileFullNames, bSource);
	if (nRet != nSize)
	{
		for (ii=nSize-1; ii>=0; ii--)
		{
			if (vsFileFullNames[ii].IsEmpty())
				vsFileNames.RemoveAt(ii);
		}
	}
	if (vsPictures.GetSize())
		CopyFiles(vsPictures, bSource);

	return nRet;

}

//virtual 
int TemplatePublish::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{		
	//Load template XML
	Tree trXML;		
	if (!load_template_tree(trXML, bSource ? TEMPLATE_LOCATION_USER_FOLDER : TEMPLATE_LOCATION_SERVER_GROUP_FOLDER))
		return 0;

	int nSize = vsFileNames.GetSize();
	for (int ii=nSize-1; ii>=0; ii--)
	{
		string strFileFullName = (bSource ? m_strSrcPath : m_strDestPath) + vsFileNames[ii];
		TreeNode trNode = trXML.FindNodeByAttribute(STR_NAME_ATTRIB, vsFileNames[ii]);
		if (trNode)
			trNode.Remove();

		if (!bSource)
		{
			if (!okutil_delete_file(strFileFullName, true))
				vsFileNames.RemoveAt(ii);
			//delete picture
			string strPicture = _check_get_pictrue_name(strFileFullName);
			if (!strPicture.IsEmpty())
				okutil_delete_file(strPicture, true);
		}				
	}
	trXML.Save(bSource ? STR_TEMPLATE_XML : STR_SERVER_GROUP_TEMPLATE_XML);
	return vsFileNames.GetSize();
}


bool TemplatePublish::findTemplate(TreeNode& trBranch, string strFile, string& strCate)
{
	TreeNode tr;
	if(trBranch.IsValid())
		tr = trBranch.FindNodeByAttribute(STR_FILENAME_ATTRIB, strFile);
	if(!tr.IsValid() || !tr.Parent().IsValid())
		return false;
	tr = tr.Parent();
	tr.GetAttribute(STR_LABEL_ATTRIB, strCate);
	if(!lstrlen(strCate))
		strCate = tr.tagName;
	return true;
}

/************************************************************************/
/* TemplateTransfer
/************************************************************************/
#define STR_TEMPLATE_INI			"template.ini"

TemplateTransfer::TemplateTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{
}

//virtual 
int TemplateTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsFileExts = {".otp", ".otw", ".otm"};
	GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsFileExts, vsFiles);

	return vsFiles.GetSize();
}

//virtual 
int TemplateTransfer::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	ASSERT(bSource);
	int nSize = vsFileNames.GetSize();
	vector<string> vsFileFullNames(nSize);
	vector<string> vsPictures;

	_check_create_tempalte_xml(STR_TEMPLATE_XML);
	for (int ii=0; ii<nSize; ii++)
	{
		string strCate;
		if ( !getTemplateCategory(vsFileNames[ii], strCate) )
			strCate = m_strRegistryKey;

		int nTemplateType = _get_template_type_from_name(vsFileNames[ii]);
		vsFileFullNames[ii] = m_strSrcPath + vsFileNames[ii];

		okutil_add_template(STR_TEMPLATE_XML, strCate, vsFileNames[ii], nTemplateType);

		string strPicture = _check_get_pictrue_name(vsFileFullNames[ii]);
		if (!strPicture.IsEmpty())
			vsPictures.Add(strPicture);
	}
	int nRet = CopyFiles(vsFileFullNames, bSource);
	if (nRet != nSize)
	{
		for (ii=nSize-1; ii>=0; ii--)
		{
			if (vsFileFullNames[ii].IsEmpty())
				vsFileNames.RemoveAt(ii);
		}
	}
	if (vsPictures.GetSize())
		CopyFiles(vsPictures, bSource);

	return nRet;
}

//virtual 
int TemplateTransfer::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{		
	ASSERT(!bSource);
	Tree trXML;
	if (!load_template_tree(trXML, TEMPLATE_LOCATION_USER_FOLDER))
		return 0;

	int nSize = vsFileNames.GetSize();
	for (int ii=nSize-1; ii>=0; ii--)
	{
		string strFileFullName = m_strDestPath + vsFileNames[ii];
		TreeNode trNode = trXML.FindNodeByAttribute(STR_NAME_ATTRIB, vsFileNames[ii]);
		if (trNode)
			trNode.Remove();

		if (!okutil_delete_file(strFileFullName, true))
			vsFileNames.RemoveAt(ii);
		//delete picture
		string strPicture = _check_get_pictrue_name(strFileFullName);
		if (!strPicture.IsEmpty())
			okutil_delete_file(strPicture, true);
	}
	trXML.Save(m_strDestPath + STR_TEMPLATE_XML);
	return vsFileNames.GetSize();
}

bool TemplateTransfer::getTemplateCategory(LPCSTR lpcszFile, string &strCategory)
{
	///-----Kit 10/10/2011 ORG-3938-P4 GET_TEMPLATE_TYPE_FORM_TEMPLATE_INI_WRONG
	//INIFile ini(m_strSrcPath + STR_TEMPLATE_INI);
	//const string strFile(lpcszFile);	
	//string strFileName = GetFileName(strFile, false);

	//vector<string> vsSections;
	//ini.GetSectionNames(vsSections);

	//int nSize = vsSections.GetSize();
	//for (int ii=1; ii<nSize; ii++)
	//{
	//	vector<string> vsKeys;
	//	ini.GetKeyNames(vsKeys, vsSections[ii]);
	//	int nKeySize = vsKeys.GetSize();
	//	for (int jj=0; jj<nKeySize; jj++)
	//	{
	//		string strKeyValue = ini.ReadString(vsSections[ii], vsKeys[jj]);
	//		strKeyValue.TrimLeft();
	//		strKeyValue.TrimRight();
	//		if( (!strKeyValue.IsEmpty() && strFile.CompareNoCase(strKeyValue)==0 ) || (strKeyValue.IsEmpty() && strFileName.CompareNoCase(vsKeys[jj])==0) )
	//			return vsSections[ii];
	//	}
	//}
	//return "";
#define STR_DEFAULT_TEMPLATE_XML	"template.xml"
	Tree trTemplateXML;
	if ( !trTemplateXML.Load(m_strSrcPath + STR_DEFAULT_TEMPLATE_XML) )
		return false;
#undef	STR_DEFAULT_TEMPLATE_XML
	
	string strFileName = GetFileName(lpcszFile, FALSE);
	int nPageType = _get_template_type_from_name(strFileName);
	ASSERT(nPageType != EXIST_NONE);

	TreeNode trPageNode = tree_get_node_by_dataid(trTemplateXML, nPageType);
	ASSERT(trPageNode.IsValid());

	TreeNode trTemplateNode = trPageNode.FindNodeByAttribute(STR_NAME_ATTRIB, strFileName);

	if ( !trTemplateNode.IsValid() )
		return false;

	TreeNode trCategory = trTemplateNode.Parent();
	ASSERT(trCategory.IsValid());
	return trCategory.GetAttribute(STR_LABEL_ATTRIB, strCategory) && !trCategory.IsEmpty();
	///-----End GET_TEMPLATE_TYPE_FORM_TEMPLATE_INI_WRONG
}

/************************************************************************/
/* ImpFilterPublish
/************************************************************************/
ImpFilterPublish::ImpFilterPublish()
{
	m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, FILTERS_FOLDER_NAME, TRUE);
	m_strDestPath = GetGroupFolderPath(FILTERS_FOLDER_NAME);
}

//virtual 
int ImpFilterPublish::GetFiles(bool bSource, vector<string>& vsFiles)
{ 
	vector<string> vsExt = {IMPORT_FILTER_EXTENSION};
	string strPath;
	if(bSource)
		strPath = m_strSrcPath;
	else
		strPath = m_strDestPath;

	GetFiles(strPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

//virtual 
int ImpFilterPublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{ 
	int nSize = vsFileNames.GetSize();
	vector<string> vsFileFullNames(nSize);
	for (int ii=0; ii<nSize; ii++)
	{
		vsFileFullNames[ii] = (bSource ? m_strSrcPath : m_strDestPath) + vsFileNames[ii];
		bool bValue;

		string strGroupPath = GetGroupFolderPath();
		string strFileName = GetFilenameWithoutExt(vsFileNames[ii]);
		if (get_filter_setting(strFileName,
			bValue,
			bSource ? FILTER_LOCATION_USER_FOLDER : FILTER_LOCATION_GROUP_FOLDER,
			FILTER_SETTING_DRAG_AND_DROG,
			bSource ? "" : strGroupPath))
		{
			set_filter_setting(strFileName,
				bValue,
				bSource ? FILTER_LOCATION_GROUP_FOLDER : FILTER_LOCATION_USER_FOLDER,
				FILTER_SETTING_DRAG_AND_DROG,
				bSource ? strGroupPath : "");
		}
	}
	int nRet = CopyFiles(vsFileFullNames, bSource);

	if (nRet != nSize)
	{
		for (ii=nSize-1; ii>=0; ii--)
		{
			if (vsFileFullNames[ii].IsEmpty())
				vsFileNames.RemoveAt(ii);
		}
	}

	return nRet;
}

//virtual 
int ImpFilterPublish::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	int nSize = vsFileNames.GetSize();
	for (int ii=nSize-1; ii>=0; ii--)
	{
		string strFileFullName = (bSource ? m_strSrcPath : m_strDestPath) + vsFileNames[ii];
		bool bValue;
		string strGroupPath = GetGroupFolderPath();
		string strFileName = GetFilenameWithoutExt(vsFileNames[ii]);
		if (get_filter_setting(strFileName,
			bValue,
			bSource ? FILTER_LOCATION_USER_FOLDER : FILTER_LOCATION_GROUP_FOLDER,
			FILTER_SETTING_DRAG_AND_DROG,
			bSource ? "" : strGroupPath))
		{
			remove_line_from_filter_setting(strFileName,
				bSource ? FILTER_LOCATION_USER_FOLDER : FILTER_LOCATION_GROUP_FOLDER,
				FILTER_SETTING_DRAG_AND_DROG,
				bSource ? "" : strGroupPath);
		}

		if (!okutil_delete_file(strFileFullName, true))
			vsFileNames.RemoveAt(ii);
	}
	return vsFileNames.GetSize();
}

/************************************************************************/
/* ImpFilterTransfer
/************************************************************************/
ImpFilterTransfer::ImpFilterTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath)
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{
	if(!m_bSrcPathSpecified)
		m_strSrcPath += FILTERS_FOLDER_NAME;
	m_strDestPath += FILTERS_FOLDER_NAME;
}

//virtual 
int ImpFilterTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{ 
	vector<string> vsExt = {IMPORT_FILTER_EXTENSION};
	GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

/************************************************************************/
/* FDFPublish
/************************************************************************/
FDFPublish::FDFPublish()
{
	m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, NULL, TRUE) + STR_FDF_FILE_FOLDER_BACKSLASH;
	m_strDestPath = GetGroupFolderPath(STR_FDF_FILE_FOLDER_BACKSLASH);
}

//virtual 
int FDFPublish::GetFiles(bool bSource, vector<string>& vsFiles)
{ 
	vector<string> vsFunctions;
	FDFPaths fdfPaths;
	fdfPaths.strFilePath = bSource ? m_strSrcPath : m_strDestPath;
	fdfPaths.strIniPath = okutil_get_origin_path(bSource ? ORIGIN_PATH_USER : ORIGIN_PATH_SERVER_GROUP_FOLDER, NULL, TRUE);
	fdfPaths.strSysPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);
	m_gfo.GetFilesList(vsFunctions, vsFiles, fdfPaths);
	///------ Tony 07/12/2012 ORG-2840-P5 ADD_FITFUNC_XML
	_append_CustomizedBuiltInxml(vsFiles, fdfPaths.strFilePath);
	///------ End ADD_FITFUNC_XML
	return _append_file_ext(vsFiles, STR_FDF_FILE_EXT);
}

//virtual 
int FDFPublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{ 
	int nNum = 0;

	FDFPaths fdfSrcPaths, fdfDestPaths;
	fdfSrcPaths.strFilePath = m_strSrcPath;
	fdfSrcPaths.strIniPath = okutil_get_origin_path(ORIGIN_PATH_USER);
	fdfSrcPaths.strSysPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);
	fdfDestPaths.strFilePath = m_strDestPath;
	fdfDestPaths.strIniPath = GetGroupFolderPath();
	fdfDestPaths.strSysPath = fdfSrcPaths.strSysPath;

	for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
	{
		string strFile = vsFileNames[ii];
		strFile.Replace(STR_FDF_FILE_EXT, "");

		if ( m_gfo.AddFile(strFile, bSource ? fdfSrcPaths : fdfDestPaths, bSource ? fdfDestPaths : fdfSrcPaths) )
			nNum++;
		else
			vsFileNames.RemoveAt(ii--);
	}

	return nNum;
}

//virtual 
int FDFPublish::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	int nNum = 0;

	FDFPaths fdfPaths;
	fdfPaths.strFilePath = bSource ? m_strSrcPath : m_strDestPath;
	fdfPaths.strIniPath = bSource ? okutil_get_origin_path(ORIGIN_PATH_USER) : GetGroupFolderPath();
	fdfPaths.strSysPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);

	for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
	{
		string strFile = vsFileNames[ii];
		strFile.Replace(STR_FDF_FILE_EXT, "");
		if ( m_gfo.RemoveFile(strFile, fdfPaths, bSource) )
			nNum++;
		else
			vsFileNames.RemoveAt(ii--);
	}

	return nNum;
}

/************************************************************************/
/* FDFTransfer
/************************************************************************/
FDFTransfer::FDFTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{
	if(!m_bSrcPathSpecified)
		m_strSrcPath += STR_FDF_FILE_FOLDER_BACKSLASH;
	m_strDestPath += STR_FDF_FILE_FOLDER_BACKSLASH;
}

//virtual 
int FDFTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{ 
	if(bSource && m_bSrcPathSpecified)
	{
		vsFiles.SetSize(0);
		///------ Tony 08/01/2012 ORG-6330-S4 ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
		//FindFiles(vsFiles, m_strSrcPath, STR_FDF_FILE_EXT);
		FindFiles(vsFiles, m_strSrcPath, STR_FDF_FILE_EXT, m_nRecursive);
		///------ End ADD_RECURSIVE_CHECKBOX_TO_SPECIFIC_FOLDER
		///------ Tony 07/12/2012 ORG-2840-P5 ADD_FITFUNC_XML
		_append_CustomizedBuiltInxml(vsFiles, m_strSrcPath);
		///------ End ADD_FITFUNC_XML
		return vsFiles.GetSize();
	}

	vector<string> vsFullFileNames;

	FDFPaths fdfPaths;
	GetFDFPaths(bSource, fdfPaths);
	m_gfo.GetFilesList(vsFiles, vsFullFileNames, fdfPaths);
	///------ Tony 07/12/2012 ORG-2840-P5 ADD_FITFUNC_XML
	_append_CustomizedBuiltInxml(vsFiles, m_strSrcPath);
	///------ End ADD_FITFUNC_XML
	return _append_file_ext(vsFiles, STR_FDF_FILE_EXT);
}

//virtual 
int FDFTransfer::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{ 
	int nNum = 0;
	ASSERT(bSource);
	FDFPaths fdfSrcPaths, fdfDestPaths;
	GetFDFPaths(true, fdfSrcPaths);
	GetFDFPaths(false, fdfDestPaths);
	for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
	{
		string strFile = vsFileNames[ii];
		strFile.MakeLower();			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, Replace may fails
		strFile.Replace(STR_FDF_FILE_EXT, "");
		if ( m_gfo.AddFile(strFile, fdfSrcPaths, fdfDestPaths) )
			nNum++;
		else
			vsFileNames.RemoveAt(ii--);
	}

	return nNum;
}

//virtual 
int FDFTransfer::RemoveFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	ASSERT(!bSource);			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	int nNum = 0;
	FDFPaths fdfPaths;
	GetFDFPaths(bSource, fdfPaths);

	for (int ii = 0; ii < vsFileNames.GetSize(); ii++)
	{
		string strFile = vsFileNames[ii];
		strFile.Replace(STR_FDF_FILE_EXT, "");
		if ( m_gfo.RemoveFile(strFile, fdfPaths, true) )
			nNum++;
		else
			vsFileNames.RemoveAt(ii--);
	}

	return nNum;
}

void FDFTransfer::GetFDFPaths(bool bSource, FDFPaths& fdfPaths)
{
	if(bSource)
	{
		fdfPaths.strFilePath = m_strSrcPath;
		if(m_bSrcPathSpecified)
		{
			fdfPaths.strIniPath = "";
			fdfPaths.strSysPath = "";
		}
		else
		{
			string strSysPath, strUserPath;
			get_origin_user_path(strSysPath, m_strRegistryKey, false);
			get_origin_user_path(strUserPath, m_strRegistryKey, true);
			fdfPaths.strIniPath = strUserPath;
			fdfPaths.strSysPath = strSysPath;
		}
	}
	else
	{
		fdfPaths.strFilePath = m_strDestPath;
		fdfPaths.strIniPath = okutil_get_origin_path(ORIGIN_PATH_USER);
		fdfPaths.strSysPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);
	}
}

/************************************************************************/
/* OGSPublish
/************************************************************************/
//virtual 
int OGSPublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsExt = {".ogs"};
	GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

/************************************************************************/
/* OGSTransfer                                                                     
/************************************************************************/
OGSTransfer::OGSTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{
}

//virtual 
int OGSTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{ 
	vector<string> vsExt = {".ogs"};
	GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

/************************************************************************/
/* OriginCPublish
/************************************************************************/
OriginCPublish::OriginCPublish()
{
	m_strSrcPath += "OriginC\\";
	m_strDestPath += "OriginC\\";
}

//virtual 
int OriginCPublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsExt = {".h", ".c", ".cpp"};
	string strPath;
	if(bSource)
		strPath = m_strSrcPath;
	else
		strPath = m_strDestPath;
	GetFiles(strPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

//virtual 
int OriginCPublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	return FilePublishBase::PublishFiles(vsFileNames, bSource);
}

/************************************************************************/
/* OriginCTransfer
/************************************************************************/
OriginCTransfer::OriginCTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{
	if(m_bSrcPathSpecified == false)
		m_strSrcPath += "OriginC\\";
	m_strDestPath += "OriginC\\";
}

//virtual 
int OriginCTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsExt = {".h", ".c", ".cpp"};
	string strPath;
	if(bSource)
		strPath = m_strSrcPath;
	else
		strPath = m_strDestPath;
	GetFiles(strPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}


/************************************************************************/
/* DefaultSettingsPublish
/************************************************************************/
///-----Kit 10/08/2011 ORG-3938-P2 IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
static bool _default_settings_get_files(LPCSTR lpcszFilePath, vector<string> &vsFiles)
{
	string strPath = lpcszFilePath;
	if ( strPath[strPath.GetLength()-1] != '\\')
		strPath += '\\';

	vector<string> vsFileNames = 
	{
		"Defaults.xml", "CustomColors.ini",
		"ParamTab.ini", "ImportMenu.xml"
	};

	vector<string> vsSubFolders = 
	{
		"", "", "", "Themes\\Menus"
	};

	///-----Kit 10/13/2011 ORG-3938-P5 CUSTOM_SETTING_TYPE_GET_FILES_TOO_SLOW
	//char szTemp[MAX_PATH];
	//strcpy(szTemp, strPath);
	///-----End CUSTOM_SETTING_TYPE_GET_FILES_TOO_SLOW
	ASSERT(vsFileNames.GetSize() == vsSubFolders.GetSize());
	for ( size_t ii = 0; ii < vsFileNames.GetSize(); ++ii )
	{
		///-----Kit 10/13/2011 ORG-3938-P5 CUSTOM_SETTING_TYPE_GET_FILES_TOO_SLOW
		//if ( FindFile(vsFileNames[ii], szTemp, vsSubFolders[ii], FALSE) )
		vector<string> vsResult;
			if ( okutil_find_files_from_name_or_ext(&vsResult, strPath + vsSubFolders[ii], vsFileNames[ii], TRUE) )
			///-----End CUSTOM_SETTING_TYPE_GET_FILES_TOO_SLOW
			{
				///-----Kit 11/30/2011 ORG-4362-P7 CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE
				//vsFiles.Add(vsFileNames[ii]);
				///------ Tony 09/14/2012 ORG-6796-P1 DEFAULT_SETTING_GET_CORRECT_FILES
				//vsFiles.Add(vsSubFolders[ii] + "\\" + vsFileNames[ii]);
				if(vsSubFolders[ii].IsEmpty())
					vsFiles.Add(vsFileNames[ii]);
				else
					vsFiles.Add(FormFileName(vsSubFolders[ii], vsFileNames[ii]));
				///------ End DEFAULT_SETTING_GET_CORRECT_FILES
				///-----End CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE
			}
			
	}
	///-----End IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
	return true;
}

static int _get_default_settings_row_info(FilePublishBase *pFilePublish, LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	vsRowInfo.SetSize(FB_COL_NUMS);
	vsRowInfo[FB_COL_FILE]		= GetFileName(lpcszKey);
	vsRowInfo[FB_COL_FILE_SPECIFIED] 	= lpcszKey;		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	vsRowInfo[FB_COL_CATEGORY]	= GetFilePath(lpcszKey);
	vsRowInfo[FB_COL_FILETYPE]	= "";
	vsRowInfo[FB_COL_FILESIZE]	= pFilePublish->GetFileSize(lpcszKey, bSource);
	vsRowInfo[FB_COL_FILEDATE]	= pFilePublish->GetFileDate(lpcszKey, bSource);
	return vsRowInfo.GetSize();
}

///-----Kit 11/30/2011 ORG-4362-P7 CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE
//virtual 
int	DefaultSettingsPublish::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	return _get_default_settings_row_info(this, lpcszKey, vsRowInfo, bSource);
}
///-----End CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE

//virtual 
int DefaultSettingsPublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	///-----Kit 10/08/2011 ORG-3938-P2 IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
	//FindFiles(vsFiles, bSource ? m_strSrcPath : m_strDestPath, "Defaults.xml");
	_default_settings_get_files(bSource ? m_strSrcPath : m_strDestPath, vsFiles);
	///-----End IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
	return vsFiles.GetSize();
}

/************************************************************************/
/*  DefaultSettingsTransfer
/************************************************************************/
DefaultSettingsTransfer::DefaultSettingsTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{}

///-----Kit 11/30/2011 ORG-4362-P7 CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE
//virtual 
int	DefaultSettingsTransfer::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	return _get_default_settings_row_info(this, lpcszKey, vsRowInfo, bSource);
}
///-----End CAN_NOT_PUBLISH_IMPORTMENU_XML_FILE

//virtual 
int DefaultSettingsTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	///-----Kit 10/08/2011 ORG-3938-P2 IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
	//FindFiles(vsFiles, bSource ? m_strSrcPath : m_strDestPath, "Defaults.xml");
	_default_settings_get_files(bSource ? m_strSrcPath : m_strDestPath, vsFiles);
	///-----End IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
	return vsFiles.GetSize();
}

///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
#define   INI_USER_DEF_BUTTONS_GROUPS			"UserDefinedButtons"
static	int	_get_userdef_button_groups(vector<string>& vsGroupNames, vector<string>& vsIniFiles, LPCSTR lpcszOriginIni)
{
	INIFile ini(lpcszOriginIni);
	ini.GetKeyNames(vsGroupNames, INI_USER_DEF_BUTTONS_GROUPS);
	vsIniFiles.SetSize(vsGroupNames.GetSize());
	for ( int ii = 0; ii < vsGroupNames.GetSize(); ii++ )
		vsIniFiles[ii] = ini.ReadString(INI_USER_DEF_BUTTONS_GROUPS, vsGroupNames[ii]);
	return vsGroupNames.GetSize();
}
/************************************************************************/
/* UserButtonSettingsPublish
/************************************************************************/
//virtual 
int	UserButtonSettingsPublish::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	return 0;
}

//virtual 
int UserButtonSettingsPublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	return vsFiles.GetSize();
}
/************************************************************************/
/* UserButtonSettingsTransfer
/************************************************************************/
UserButtonSettingsTransfer::UserButtonSettingsTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{}

//virtual 
int	UserButtonSettingsTransfer::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	string strPath = bSource ? m_strSrcPath : m_strDestPath;
	string strIniFile = strPath + STR_ORIGIN_INI_FILE_NAME;
	INIFile ini(strIniFile);
	string strButtonINI = ini.ReadString(INI_USER_DEF_BUTTONS_GROUPS, lpcszKey);
	
	vsRowInfo.SetSize(FB_COL_NUMS);
	vsRowInfo[FB_COL_FILE]		= GetFileName(lpcszKey);
	vsRowInfo[FB_COL_FILE_SPECIFIED] 	= lpcszKey;		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	vsRowInfo[FB_COL_CATEGORY]	= GetFilePath(strButtonINI);
	vsRowInfo[FB_COL_FILETYPE]	= "";
	vsRowInfo[FB_COL_FILESIZE]	= GetFileSize(strButtonINI, bSource);
	vsRowInfo[FB_COL_FILEDATE]	= GetFileDate(strButtonINI, bSource);
	return vsRowInfo.GetSize();
}

//virtual 
int UserButtonSettingsTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	string strPath = bSource ? m_strSrcPath : m_strDestPath;
	string strIniFile = strPath + STR_ORIGIN_INI_FILE_NAME;
	vector<string> vsButtonINIs;
	_get_userdef_button_groups(vsFiles, vsButtonINIs, strIniFile);
	return vsFiles.GetSize();
}

//virtual
int		UserButtonSettingsTransfer::PublishFiles(vector<string> &vsFileNames, bool bSource)
{
	string strSrcPath = bSource ? m_strSrcPath : m_strDestPath;
	string strDstPath = bSource ? m_strDestPath : m_strSrcPath;
	string strSrcIniFile = strSrcPath + STR_ORIGIN_INI_FILE_NAME;
	string strDstIniFile = strDstPath + STR_ORIGIN_INI_FILE_NAME;
	INIFile ini(strSrcIniFile);
	INIFile iniDstOriginINI(strDstIniFile);
	
	for ( int iGroup = 0; iGroup < vsFileNames.GetSize(); iGroup++ )
	{
		string strGroupName = GetFileName(vsFileNames[iGroup] + ".ini", TRUE);
		string strSrcButtonINI = ini.ReadString(INI_USER_DEF_BUTTONS_GROUPS, strGroupName);
		if ( !IsFileFullPath(strSrcButtonINI) )
			strSrcButtonINI = strSrcPath + strSrcButtonINI;
		string strDstButtonINI = strDstPath + GetFileName(strSrcButtonINI);
		CopyFile(strSrcButtonINI, strDstButtonINI);
		
		INIFile iniDst(strDstButtonINI);
		string strSrcBitmapFile = iniDst.ReadString("Common", "BitmapFile");
		if ( !IsFileFullPath(strSrcBitmapFile) ) //not full path, need make it full path
			strSrcBitmapFile = strSrcPath + strSrcBitmapFile;
		string strDstBitmapFile = strDstPath + GetFileName(strSrcBitmapFile);
		CopyFile(strSrcBitmapFile, strDstBitmapFile);
		iniDst.WriteString("Common", "BitmapFile", GetFileName(strDstBitmapFile));
		
		int nButtonCount = iniDst.ReadInt("Common", "ButtonCount", 0);
		for ( int ii = 0; ii < nButtonCount; ii++ )
		{
			string strButtonSec;
			strButtonSec.Format("CustomButton%d", ii + 1);
			string strSrcOGSFile = iniDst.ReadString(strButtonSec, "FileName", "");
			if ( IsFileFullPath(strSrcOGSFile) )
				strSrcOGSFile = strSrcPath + strSrcOGSFile;
			string strDstOGSFile = strDstPath + GetFileName(strSrcOGSFile);
			CopyFile(strSrcOGSFile, strDstOGSFile);
			iniDst.WriteString(strButtonSec, "FileName", GetFileName(strDstOGSFile));
		}
		iniDstOriginINI.WriteString(INI_USER_DEF_BUTTONS_GROUPS, strGroupName, GetFileName(strDstButtonINI));
	}
	return 0;
}
//virtual
int		UserButtonSettingsTransfer::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	vector<string> vsINIFiles(vsFileNames.GetSize());
	string strSrcPath = bSource ? m_strSrcPath : m_strDestPath;
	string strDstPath = bSource ? m_strDestPath : m_strSrcPath;
	string strIniFile = strSrcPath + STR_ORIGIN_INI_FILE_NAME;
	INIFile ini(strIniFile);
	for ( int iGroup = 0; iGroup < vsFileNames.GetSize(); iGroup++ )
	{
		string strGroupName = GetFileName(vsFileNames[iGroup] + ".ini", TRUE);
		vsINIFiles[iGroup] = ini.ReadString(INI_USER_DEF_BUTTONS_GROUPS, strGroupName);
		if ( !IsFileFullPath(vsINIFiles[iGroup]) )
			vsINIFiles[iGroup] = strSrcPath + vsINIFiles[iGroup];
		ini.WriteString(INI_USER_DEF_BUTTONS_GROUPS, strGroupName, NULL); //remove the key
		okutil_delete_file(vsINIFiles[iGroup], TRUE);
	}
	
	return 0;
}

//virtual
bool	UserButtonSettingsTransfer::GetFileFullPath(string &strFile1, string &strFile2)
{
	bool bSource = true;
	string strSrcPath = bSource ? m_strSrcPath : m_strDestPath;
	string strDstPath = bSource ? m_strDestPath : m_strSrcPath;
	string strSrcIniFile = strSrcPath + STR_ORIGIN_INI_FILE_NAME;
	string strDstIniFile = strDstPath + STR_ORIGIN_INI_FILE_NAME;
	INIFile ini(strSrcIniFile);
	INIFile iniDstOriginINI(strDstIniFile);
	
	strFile1 = ini.ReadString(INI_USER_DEF_BUTTONS_GROUPS, strFile1);
	strFile2 = iniDstOriginINI.ReadString(INI_USER_DEF_BUTTONS_GROUPS, strFile2);
	if ( !IsFileFullPath(strFile1) )
		strFile1 = strSrcPath + strFile1;
	if ( !IsFileFullPath(strFile2) )
		strFile2 = strDstPath + strFile2;
	return true;
}

bool	UserButtonSettingsTransfer::IsFileFullPath(LPCSTR lpcszFileName)
{
	string strPath = GetFilePath(lpcszFileName);
	if ( strPath.IsPath() )
		return true;
	return false;
}
///end TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
/************************************************************************/
/* OMCPublish
/************************************************************************/
#define STR_OMC_FILE_EXT				"." MENU_CUSTOMIZATION_FILE_EXT

OMCPublish::OMCPublish() 
	: CommonFilePublish(STR_OMC_FILE_EXT)
{
}

int OMCPublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	vsFileNames.Add(MENU_CUSTOMIZATION_CONFIGURATION_FILE);
	return CommonFilePublish::PublishFiles(vsFileNames, bSource);
}

/************************************************************************/
/* OMCTransfer
/************************************************************************/
OMCTransfer::OMCTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{}

//virtual 
int OMCTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsExt = {".omc"};
	string strPath = bSource ? m_strSrcPath : m_strDestPath;
	GetFiles(strPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

/************************************************************************/
/* PatchPublish
/************************************************************************/
PatchPublish::PatchPublish()
{
	m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM, STR_UPDATE_FOLDER, TRUE);
	m_strDestPath = GetGroupFolderPath(STR_UPDATE_FOLDER);
}

//virtual 
int PatchPublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsExt = {".exe"};
	GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

//virtual 
int PatchPublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	const int nSize = vsFileNames.GetSize();
	const string &strCurSrcPath = bSource ? m_strSrcPath : m_strDestPath;
	const string &strCurDstPath = bSource ? m_strDestPath : m_strSrcPath;
	CheckMakePath(strCurDstPath);

	for (int ii=nSize-1; ii>=0; ii--)
	{
		//if (bSource)
		//{
		//	if (copyfile(m_strSrcPath + vsFileNames[ii], m_strDestPath + vsFileNames[ii], 0))
		//		vsFileNames.RemoveAt(ii);
		//}
		//else
		//{
		//	if (copyfile(m_strDestPath + vsFileNames[ii], m_strSrcPath + vsFileNames[ii], 0))
		//		vsFileNames.RemoveAt(ii);
		//}
		if (copyfile(strCurSrcPath + vsFileNames[ii], strCurDstPath + vsFileNames[ii], 0))
			vsFileNames.RemoveAt(ii);
	}

	if (bSource)
		checkSetUpdateINI();
	return vsFileNames.GetSize();
}

//virtual 
int PatchPublish::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	FilePublishBase::RemoveFiles(vsFileNames, bSource);
	if (!bSource)
		checkSetUpdateINI();
	return vsFileNames.GetSize();
}



bool PatchPublish::checkSetUpdateINI()
{
	vector<string> vsFiles;
	GetFiles(ORIGIN_PATH_SERVER_GROUP_FOLDER, vsFiles);
	int nSize = vsFiles.GetSize();

	int nNewBuildTo = 0;
	for (int ii=0; ii<nSize; ii++)
	{
		int nBuildFrom, nBuildTo;
		get_patch_build_version(vsFiles[ii], &nBuildTo, &nBuildFrom);
		if (nBuildTo > nNewBuildTo)
			nNewBuildTo = nBuildTo;
	}
	INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
	iniFile.WriteInt(STR_SECTION_PATCH, STR_KEY_BUILD, nNewBuildTo);

	return true;
}

/************************************************************************/
/* PatchTransfer
/************************************************************************/
PatchTransfer::PatchTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{
	if(m_bSrcPathSpecified == false)
		m_strSrcPath += STR_UPDATE_FOLDER;
	m_strDestPath += STR_UPDATE_FOLDER;
}

//virtual 
int PatchTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsExt = {".exe"};
	GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

/************************************************************************/
/* DialogThemePublish
/************************************************************************/
///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
//#define STR_DIALOG_THEME_FOLDER	"Themes\\AnalysisAndReportTable\\"
#define STR_ANLIYSIS_REPORT_DIALOG_THEME_FOLDER		"AnalysisAndReportTable"
#define STR_FUNC_DIALOG_THEME_FOLDER				"Dialog"

///------ Tony 08/15/2012 ORG-2840-S4 REMOVE_SAME_SYSTEM_THEME_DIALOG
static int _remove_system_theme_files(VecStr &vsFiles, string strSourcePath)
{
	vector<string> vsSysThemeFles =	
	{
		"AnalysisAndReportTable\\0-addtool_curve_stats-Mean + 1 standard deviation.ois",
		"AnalysisAndReportTable\\0-addtool_quickfit-@A Linear.ois",
		"AnalysisAndReportTable\\0-addtool_quickfit-@a Peak - Gauss.ois",
		"AnalysisAndReportTable\\0-addtool_quickfit-@a Peak - Lorentz.ois",
		"AnalysisAndReportTable\\0-addtool_quickfit-@B Quadratic.ois",
		"AnalysisAndReportTable\\0-addtool_quickfit-@b Sigmoidal - Boltzmann.ois",
		"AnalysisAndReportTable\\0-addtool_quickfit-@b Sigmoidal - Logistic.ois",
		"AnalysisAndReportTable\\0-addtool_quickfit-@C Cubic.ois",
		"AnalysisAndReportTable\\0-addtool_quickfit-@c ExpDecay with Offset.ois",
		"AnalysisAndReportTable\\0-discrim-Canonical Discriminant Analysis.ois"
	};		//10 files in total
	
	for (int ii = vsFiles.GetSize()-1; ii>=0; ii--)
	{
		for(int jj = 0; jj < vsSysThemeFles.GetSize(); jj++)
		{
			if(!vsFiles[ii].Compare(vsSysThemeFles[jj]))
			{
				string strSourceFullPath = strSourcePath + vsFiles[ii];
				string strAppThemePath = FormFileName(GetAppPath(true), "Themes");
				string strCurrentPath =  FormFileName(strAppThemePath, vsSysThemeFles[jj]);
				int n =file_compare(strSourceFullPath, strCurrentPath);
				if (0 == file_compare(strSourceFullPath, strCurrentPath))
					vsFiles.RemoveAt(ii);
				break;
			}
		}
	}
	return vsFiles.GetSize();
}
///------ End REMOVE_SAME_SYSTEM_THEME_DIALOG

static int _remove_dlg_last_used_theme_files(VecStr &vsFiles)
{
	for (int ii = vsFiles.GetSize()-1; ii>=0; ii--)
	{
		string strName, strTool, strScope, strCategory;
		theme_filename_to_options(vsFiles[ii], strName, strTool, strScope ,strCategory);
		if (is_theme_last_used(GetFileName(strName, true)))
			vsFiles.RemoveAt(ii);
	}
	return vsFiles.GetSize();
}
///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES

///-----Kit 10/19/2011 ORG-4121-S1 MAKE_TRANSFER_USER_FILE_SUPPORT_ODT_FILE
// odt is for dialog theme file. DialogThemePublish and DialogThemeTransfer are using it.
///-----End MAKE_TRANSFER_USER_FILE_SUPPORT_ODT_FILE

DialogThemePublish::DialogThemePublish()
	: ThemePublish("*.ois|*.odt")	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//m_strSrcPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_DIALOG_THEME_FOLDER, TRUE);
	//m_strDestPath = GetGroupFolderPath(STR_DIALOG_THEME_FOLDER);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES

	///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	VecStr &vsCategories = *(m_FileCateImpl.GetCategories());
	vsCategories.SetSize(2);	// hard code here, only 2 categories
	vsCategories[0] = STR_ANLIYSIS_REPORT_DIALOG_THEME_FOLDER;
	vsCategories[1] = STR_FUNC_DIALOG_THEME_FOLDER;
	///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
}

///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
//virtual 
int DialogThemePublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//vector<string> vsExt = {".ois"};
	//string strPath;
	//strPath = bSource ? m_strSrcPath : m_strDestPath;
	//GetFiles(strPath, vsExt, vsFiles);

	//int nSize = vsFiles.GetSize();
	//for (int ii=nSize-1; ii>=0; ii--)
	//{
	//	string strName, strTool, strScope, strCategory;
	//	theme_filename_to_options(vsFiles[ii], strName, strTool, strScope ,strCategory);
	//	if (is_theme_last_used(GetFileName(strName, true)))
	//		vsFiles.RemoveAt(ii);
	//}
	//return vsFiles.GetSize();

	const int nSize = ThemePublish::GetFiles(bSource, vsFiles);
	ASSERT(nSize == vsFiles.GetSize());
	_remove_system_theme_files(vsFiles, m_strSrcPath);			///------ Tony 08/15/2012 ORG-2840-S4 REMOVE_SAME_SYSTEM_THEME_DIALOG
	return _remove_dlg_last_used_theme_files(vsFiles);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}
///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES

///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
static string _get_dialog_theme_dest_category(const FileCategoryImpl &fileCateImpl, LPCSTR lpcszFile)
{
	string strExtPatterns;
	strExtPatterns.Format("%s|%s", ANALYSIS_THEME_FILE_EXT, DIALOG_THEME_FILE_EXT);
	return fileCateImpl.GetDestCategory(lpcszFile, strExtPatterns);
}
//virtual 
string	DialogThemePublish::GetDestCategory(LPCSTR lpcszFile)
{
	return _get_dialog_theme_dest_category(m_FileCateImpl, lpcszFile);
}
///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH

/************************************************************************/
/* DialogThemeTransfer
/************************************************************************/
DialogThemeTransfer::DialogThemeTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: ThemeTransfer("*.ois|*.odt", lpcszRegKey, lpcszSpecifiedPath)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	//m_vsCategories.SetSize(2);	// hard code here, only 2 categories
	//m_vsCategories[0] = STR_ANLIYSIS_REPORT_DIALOG_THEME_FOLDER;
	//m_vsCategories[1] = STR_FUNC_DIALOG_THEME_FOLDER;
	VecStr &vsCategories = *(m_FileCateImpl.GetCategories());
	vsCategories.SetSize(2);	// hard code here, only 2 categories
	vsCategories[0] = STR_ANLIYSIS_REPORT_DIALOG_THEME_FOLDER;
	vsCategories[1] = STR_FUNC_DIALOG_THEME_FOLDER;
	///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}

///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
//virtual 
int DialogThemeTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
	//vector<string> vsExt = {".ois"};
	//string strPath;
	//strPath = bSource ? m_strSrcPath : m_strDestPath;
	//GetFiles(strPath, vsExt, vsFiles);
	//int nSize = vsFiles.GetSize();
	//for (int ii=nSize-1; ii>=0; ii--)
	//{
	//	string strName, strTool, strScope, strCategory;
	//	theme_filename_to_options(vsFiles[ii], strName, strTool, strScope ,strCategory);
	//	if (is_theme_last_used(GetFileName(strName, true)))
	//		vsFiles.RemoveAt(ii);
	//}
	//return vsFiles.GetSize();
	const int nSize = ThemeTransfer::GetFiles(bSource, vsFiles);
	ASSERT(nSize == vsFiles.GetSize());
	_remove_system_theme_files(vsFiles, m_strSrcPath);			///------ Tony 08/15/2012 ORG-2840-S4 REMOVE_SAME_SYSTEM_THEME_DIALOG
	return _remove_dlg_last_used_theme_files(vsFiles);
	///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
}
///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES

///-----Kit 10/19/2011 ORG-4062-P2 DST_CATEGORY_NOT_GET_CORRECT
//virtual 
int DialogThemeTransfer::GetAvailableCates(vector<string>& vsCategories)
{
	// now, because we don't need the category
	return 0;
}

//virtual 
string DialogThemeTransfer::GetDestCategory(LPCSTR lpcszFile)
{
	///-----Kit 11/11/2011 ORG-4362-P1 GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
	//ASSERT(NULL != lpcszFile);
	//string strExt;
	//separate_file_name_ext(lpcszFile, NULL, &strExt);
	//ASSERT(!strExt.IsEmpty());

	//if ( strExt.Find(ANALYSIS_THEME_FILE_EXT) >= 0 )
	//	return m_vsCategories[0] + "\\";

	//ASSERT(strExt.Find(DIALOG_THEME_FILE_EXT) >= 0);
	//return m_vsCategories[1] + "\\";
	return _get_dialog_theme_dest_category(m_FileCateImpl, lpcszFile);
	///-----End GROUP_FOLDER_MGR_DIALOG_THEME_FILE_CAN_NOT_GET_FULL_FILE_PATH
}
///-----End DST_CATEGORY_NOT_GET_CORRECT
///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
//DialogTheme's copy
/************************************************************************/
/* FunctionThemePublish
/************************************************************************/
#define STR_FUNCTION_THEME_FOLDER					"Function"

static int _remove_func_last_used_theme_files(VecStr &vsFiles)
{
	for (int ii = vsFiles.GetSize()-1; ii>=0; ii--)
	{
		string strName, strTool, strScope, strCategory;
		theme_filename_to_options(vsFiles[ii], strName, strTool, strScope ,strCategory);
		if (is_theme_last_used(GetFileName(strName, true)))
			vsFiles.RemoveAt(ii);
	}
	return vsFiles.GetSize();
}

FunctionThemePublish::FunctionThemePublish()
	: ThemePublish("*.ofp")	
{
	VecStr &vsCategories = *(m_FileCateImpl.GetCategories());
	vsCategories.SetSize(1);
	vsCategories[0] = STR_FUNCTION_THEME_FOLDER;
}

int FunctionThemePublish::GetFiles(bool bSource, vector<string>& vsFiles)
{	
	const int nSize = ThemePublish::GetFiles(bSource, vsFiles);
	ASSERT(nSize == vsFiles.GetSize());
	return _remove_func_last_used_theme_files(vsFiles);
}

string	FunctionThemePublish::GetDestCategory(LPCSTR lpcszFile)
{
	return STR_FUNCTION_THEME_FOLDER + "\\";
}

/************************************************************************/
/* FunctionThemeTransfer
/************************************************************************/
FunctionThemeTransfer::FunctionThemeTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) 
	: ThemeTransfer("*.ofp", lpcszRegKey, lpcszSpecifiedPath)
{
	VecStr &vsCategories = *(m_FileCateImpl.GetCategories());
	vsCategories.SetSize(1);	
	//vsCategories[0] = STR_ANLIYSIS_REPORT_DIALOG_THEME_FOLDER;
	vsCategories[0] = STR_FUNCTION_THEME_FOLDER;
}

int FunctionThemeTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	const int nSize = ThemeTransfer::GetFiles(bSource, vsFiles);
	ASSERT(nSize == vsFiles.GetSize());
	return _remove_func_last_used_theme_files(vsFiles);
}

int FunctionThemeTransfer::GetAvailableCates(vector<string>& vsCategories)
{
	return 0;
}

string FunctionThemeTransfer::GetDestCategory(LPCSTR lpcszFile)
{
	return STR_FUNCTION_THEME_FOLDER + "\\";
}
///------ End ADD_OFP_FUNCTION_THEME_SUPPORT

/************************************************************************/
/* CommonFilePublish
/************************************************************************/
CommonFilePublish::CommonFilePublish(LPCSTR lpcszFileExt, LPCSTR lpcszSubPath /*= NULL*/)
{
	if( lpcszSubPath )
	{
		m_strSrcPath += lpcszSubPath;
		m_strDestPath += lpcszSubPath;
	}

	m_strFileExt = lpcszFileExt;
}

//virtual 
int CommonFilePublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsExt;
	m_strFileExt.GetTokens(vsExt, '|');
	GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}

//virtual 
int CommonFilePublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	return FilePublishBase::PublishFiles(vsFileNames, bSource);
}

/************************************************************************/
/*   CommonFileTransfer
/************************************************************************/
CommonFileTransfer::CommonFileTransfer(LPCSTR lpcszFileExt, LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath, LPCSTR lpcszSubPath /*= NULL*/) 
	: FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
{
	if(lpcszSubPath)
	{
		if(m_bSrcPathSpecified == false)
		{
			m_strSrcPath += lpcszSubPath;
			m_strSrcPath.TrimRight("\\");
			m_strSrcPath += "\\";
		}
		m_strDestPath += lpcszSubPath;
		m_strDestPath.TrimRight("\\");
		m_strDestPath += "\\";
	}

	m_strFileExt = lpcszFileExt;
}

//virtual 
int CommonFileTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	vector<string> vsExt;
	m_strFileExt.GetTokens(vsExt, '|');
	GetFiles(bSource ? m_strSrcPath : m_strDestPath, vsExt, vsFiles);
	return vsFiles.GetSize();
}


/************************************************************************/
/*   AllFileCtrlImpl
/************************************************************************/
static void _get_all_file_type(vector<int> &vnFileTypes)
{
	vector<int> vnAllFileType = {
		FILE_TYPE_OGW,
		FILE_TYPE_DIALOG_THEME,
		FILE_TYPE_FUNCTION_THEME,			///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
		FILE_TYPE_FDF,
		FILE_TYPE_IMPORT_FILTER,
		FILE_TYPE_OGS,
		FILE_TYPE_DATABASE,
		FILE_TYPE_ORIGINC,
		FILE_TYPE_PACKAGE,
		FILE_TYPE_TEMPLATE,
		FILE_TYPE_PATCH,
		FILE_TYPE_PROJECT,
		FILE_TYPE_THEME,
		FILE_TYPE_XF,
		FILE_TYPE_OMC,
		FILE_TYPE_DEFAULT_SETTINGS,
		FILE_TYPE_TEXT,						///-----Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES
		FILE_TYPE_PALETTE,					///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
		FILE_TYPE_USERBUTTONS,	///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
		FILE_TYPE_OTHER_FILE
	};

	vnFileTypes = vnAllFileType;
}

static void _get_all_file_ext(vector<string> &vsFileExt)
{
	vector<string> vsAllFileTypeExt = {
		"OGW",
		"OIS|ODT",	///-----Kit 10/19/2011 ORG-4121-S1 MAKE_TRANSFER_USER_FILE_SUPPORT_ODT_FILE, odt for dialog theme
		"OFP",			///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
		"FDF",
		"OIF",
		"OGS",
		"ODQ|ODS",
		"H|C|CPP",
		"OPX|OPK",
		"OTP|OTW|OTM",
		"EXE",
		"OPJ",
		"OTH",
		"OXF",
		MENU_CUSTOMIZATION_FILE_EXT,
		"XML|INI",
		"TXT",
		"PAL",				///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
		"",				///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
		///Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE
		//"DOC|PDF"
		"DOC|DOCX|PDF"
		///End TRANSFER_USER_FILES_HANDLE_DOCX_FILE
	};
	vsFileExt = vsAllFileTypeExt;
}

AllFileCtrlImpl::AllFileCtrlImpl()
{
	m_pWindowThemeFilePublish = NULL;
	m_pDialogThemeFilePublish = NULL;
	m_pFunctionThemeFilePublish = NULL;		///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
	m_pXFFilePublish = NULL;

	_get_all_file_type(m_vnValidFileType);
	_get_all_file_ext(m_vsAllFileTypeExt);

	ASSERT(m_vnValidFileType.GetSize() == m_vsAllFileTypeExt.GetSize());
}

AllFileCtrlImpl::~AllFileCtrlImpl()
{
	NICE_SAFE_REMOVAL(m_pWindowThemeFilePublish);
	NICE_SAFE_REMOVAL(m_pXFFilePublish);
	NICE_SAFE_REMOVAL(m_pDialogThemeFilePublish);
	NICE_SAFE_REMOVAL(m_pFunctionThemeFilePublish);		///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
}

///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
//void AllFileCtrlImpl::Init(bool bGroupMgr, LPCSTR lpcszRegKey, LPCSTR lpcszSpeciPath)
void AllFileCtrlImpl::Init(bool bGroupMgr, LPCSTR lpcszRegKey, LPCSTR lpcszSpeciPath, int nRecursive)
///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
{
	m_bGroupMgr = bGroupMgr;
	m_lpcszRegKey = lpcszRegKey;
	m_lpcszSpeciPath = lpcszSpeciPath;
	m_nRecursive = nRecursive;		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	
	if ( !m_bGroupMgr )
	{
		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		//m_pWindowThemeFilePublish = create_file_publish(FILE_TYPE_THEME, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath);
		//m_pXFFilePublish = create_file_publish(FILE_TYPE_XF, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath);
		//m_pDialogThemeFilePublish = create_file_publish(FILE_TYPE_DIALOG_THEME, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath);
		//m_pFunctionThemeFilePublish = create_file_publish(FILE_TYPE_FUNCTION_THEME, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath);
		m_pWindowThemeFilePublish = create_file_publish(FILE_TYPE_THEME, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath, m_nRecursive);
		m_pXFFilePublish = create_file_publish(FILE_TYPE_XF, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath, m_nRecursive);
		m_pDialogThemeFilePublish = create_file_publish(FILE_TYPE_DIALOG_THEME, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath, m_nRecursive);
		m_pFunctionThemeFilePublish = create_file_publish(FILE_TYPE_FUNCTION_THEME, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath, m_nRecursive);		///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
		///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	}
}

int	AllFileCtrlImpl::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource, int *pnFileType /*= NULL*/)
{
	FilePublishBase *pFilePublish = NULL;
	int nFileType = -1;
	if (createFilePublish(lpcszKey, pFilePublish, nFileType))
	{
		pFilePublish->GetRowInfo(lpcszKey, vsRowInfo, bSource);
		checkRemoveFilePublish(nFileType, pFilePublish);
	}

	if ( NULL != pnFileType )
	{
		*pnFileType = nFileType;
	}
		

	return vsRowInfo.GetSize();
}

int	AllFileCtrlImpl::GetShownInfo(vector<bool>& vbShow)
{
	vbShow.SetSize(FB_COL_NUMS);
	vbShow = false;
	vbShow[FB_COL_FILE]		=	vbShow[FB_COL_FILETYPE] =
	vbShow[FB_COL_FILESIZE] =	vbShow[FB_COL_FILEDATE] = true;

	return 4;			// shown cols
}

int	AllFileCtrlImpl::GetFiles(bool bSource, vector<string>& vsFiles)
{
	const int count = m_vnValidFileType.GetSize();
	for ( int ii = 0; ii < count; ii++ )
	{
		FilePublishBase *pFilePublish = NULL;
		const int fileType = m_vnValidFileType[ii];

		if (createFilePublish(fileType, pFilePublish))
		{
			vector<string> vsSubFiles;
			pFilePublish->GetFiles(bSource, vsSubFiles);
			vsFiles.Append(vsSubFiles);
			///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
			//if (m_vnValidFileType[ii] == FILE_TYPE_THEME)
			//	m_pThemeFilePublish = pFilePublish;
			//else if (m_vnValidFileType[ii] == FILE_TYPE_XF)
			//	m_pXFFilePublish = pFilePublish;
			//else
			//	delete pFilePublish;
			checkRemoveFilePublish(fileType, pFilePublish);
			///-----End SUPPORT_PLAETTE_FILES
		}
	}

	return vsFiles.GetSize();
}

int AllFileCtrlImpl::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	return fileOperation(vsFileNames, bSource, true);
}

int	AllFileCtrlImpl::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	return fileOperation(vsFileNames, bSource, false);
}

bool AllFileCtrlImpl::GetFileFullPath(string &strFile1, string &strFile2)
{
	FilePublishBase *pFilePublish = NULL;
	int nFileType = -1;
	if (createFilePublish(strFile1, pFilePublish, nFileType))
	{
		///-----Kit 1025/2011 ORG-4062-P2 GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
		//strFile1 = pFilePublish->GetSrcPath() + strFile1;
		//strFile2 = pFilePublish->GetDestPath() + strFile2;
		ASSERT(FILE_TYPE_ALL_FILE != nFileType); // must not be this type, or will cause dead loop
		pFilePublish->GetFileFullPath(strFile1, strFile2);
		///-----End GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG

		checkRemoveFilePublish(nFileType, pFilePublish);
	}
	return true;
}

int	AllFileCtrlImpl::GetAvailableCates(vector<string>& vsCategories)
{
	ASSERT(m_pWindowThemeFilePublish);
	return m_pWindowThemeFilePublish->GetAvailableCates(vsCategories);
}

void AllFileCtrlImpl::SetDestCategory(LPCSTR lpcszCategory)
{
	ASSERT(m_pWindowThemeFilePublish);
	m_pWindowThemeFilePublish->SetDestCategory(lpcszCategory);
}

bool AllFileCtrlImpl::GetDestCategory(string &strCategory, LPCSTR lpcszFile)
{
	FilePublishBase *pFilePublish = NULL;	
	int nFileType = -1;
	if (createFilePublish(lpcszFile, pFilePublish, nFileType))
	{
		strCategory = pFilePublish->GetDestCategory(lpcszFile);
		checkRemoveFilePublish(nFileType, pFilePublish);
		return true;
	}
	
	return false;
}

int	AllFileCtrlImpl::GetFileTypeFromFileExt(LPCSTR lpcszExt)
{
	for (int ii=0; ii<m_vsAllFileTypeExt.GetSize(); ii++)
	{
		vector<string> vsExts;
		m_vsAllFileTypeExt[ii].GetTokens(vsExts, '|');
		int nIndex;
		if ((nIndex = vsExts.Find(lpcszExt)) >= 0)
			return ii;
		///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
		else if ( m_vsAllFileTypeExt[ii] == lpcszExt )
			return ii;
		///end TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
	}
	return -1;
}

bool AllFileCtrlImpl::createFilePublish(LPCSTR lpcszExt, FilePublishBase* &pFilePublish, int &nFileType)
{
	string strExt;
	separate_file_name_ext(lpcszExt, NULL, &strExt);
	string strCategory;
	nFileType = GetFileTypeFromFileExt(strExt);
	///------ Tony 07/18/2012 ORG-5952-S1 FIX_FITTING_FUNCTIONS
	//".xml"'s nFileType is different from "CustomizedBuiltIn.xml"'s.
	string strFitFunc;
	strFitFunc = FITFUNCXML;
	if(FILE_TYPE_DEFAULT_SETTINGS == nFileType && !strFitFunc.Compare(lpcszExt))
		nFileType = FILE_TYPE_FDF;
	///------ End FIX_FITTING_FUNCTIONS
	return createFilePublish(nFileType, pFilePublish);
}

bool AllFileCtrlImpl::createFilePublish(int nFileType, FilePublishBase* &pFilePublish)
{
	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
	if ( FILE_TYPE_XF == nFileType && NULL != m_pXFFilePublish )
	{
		pFilePublish = m_pXFFilePublish;
	}
	else if ( FILE_TYPE_THEME == nFileType && NULL != m_pWindowThemeFilePublish )
	{
		pFilePublish = m_pWindowThemeFilePublish;
	}
	else if ( FILE_TYPE_DIALOG_THEME == nFileType && NULL != m_pDialogThemeFilePublish )
	{
		pFilePublish = m_pDialogThemeFilePublish;
	}
	///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
	else if ( FILE_TYPE_FUNCTION_THEME == nFileType && NULL != m_pFunctionThemeFilePublish )
	{
		pFilePublish = m_pFunctionThemeFilePublish;
	}
	///------ End ADD_OFP_FUNCTION_THEME_SUPPORT
	else
	{
		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
		//pFilePublish = create_file_publish(nFileType, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath);
		pFilePublish = create_file_publish(nFileType, m_bGroupMgr, m_lpcszRegKey, m_lpcszSpeciPath, m_nRecursive);
		///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	}

	return NULL != pFilePublish;
	///-----End SUPPORT_PLAETTE_FILES
}

void AllFileCtrlImpl::checkRemoveFilePublish(int nFileType, FilePublishBase* &pFilePublish)
{
	if ( FILE_TYPE_XF == nFileType )
	{
		m_pXFFilePublish = pFilePublish;
	}
	else if ( FILE_TYPE_THEME == nFileType )
	{
		m_pWindowThemeFilePublish = pFilePublish;
	}
	else if ( FILE_TYPE_DIALOG_THEME == nFileType )
	{
		m_pDialogThemeFilePublish = pFilePublish;
	}
	///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
	else if ( FILE_TYPE_FUNCTION_THEME == nFileType )
	{
		m_pFunctionThemeFilePublish = pFilePublish;
	}
	///------ End ADD_OFP_FUNCTION_THEME_SUPPORT
	else 
	{
		NICE_SAFE_REMOVAL(pFilePublish);
	}
}

int	AllFileCtrlImpl::fileOperation(vector<string> &vsFileNames, bool bSource /*= true*/, bool bPublish /*= true*/)
{
	int nSize = vsFileNames.GetSize();
	for (int ii=nSize-1; ii>=0; ii--)
	{
		FilePublishBase *pFilePublish = NULL;
		int nFileType = -1;
		if (createFilePublish(vsFileNames[ii], pFilePublish, nFileType))
		{
			vector<string> vsTmpFile;
			vsTmpFile.Add(vsFileNames[ii]);

			const bool bSuccess = (0 == (bPublish ? pFilePublish->PublishFiles(vsTmpFile, bSource) : pFilePublish->RemoveFiles(vsTmpFile, bSource)));
			if ( bSuccess )
				vsFileNames.RemoveAt(ii);

			checkRemoveFilePublish(nFileType, pFilePublish);
		}
	}
	return vsFileNames.GetSize();
}

/************************************************************************/
/* AllFilePublish
/************************************************************************/
AllFilePublish::AllFilePublish()
{
	//m_pThemeFilePublish = NULL;
	//m_pXFFilePublish = NULL;
	/////-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
	//_get_all_file_type(m_vnValidFileType);
	//_get_all_file_ext(m_vsAllFileTypeExt);
	/////-----End SUPPORT_PLAETTE_FILES

	//ASSERT(m_vnValidFileType.GetSize() == m_vsAllFileTypeExt.GetSize());
	m_AllFileImpl.Init(true, "", "");
	if (!okutil_is_group_files_update_feature_permitted())
	{
		vector<int> &vnAllTypes = m_AllFileImpl.GetAllValidFileType();
		vnAllTypes.SetSize(1);
		vnAllTypes[0] = FILE_TYPE_PATCH;
	}
}

//virtual 
int AllFilePublish::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{

	//string strExt;
	//separate_file_name_ext(lpcszKey, NULL, &strExt);
	//const int nFileType = getFileTypeFromFileExt(strExt);
	//FilePublishBase *pFilePublish = NULL;
	//if (getFilePublishDerivation(nFileType, pFilePublish))
	//{
	//	pFilePublish->GetRowInfo(lpcszKey, vsRowInfo, bSource);
	//	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
	//	//if (nFileType != FILE_TYPE_THEME && nFileType != FILE_TYPE_XF)
	//	//	delete pFilePublish;
	//	checkRemovePublishDerivation(nFileType, pFilePublish);
	//	///-----End SUPPORT_PLAETTE_FILES
	//}

	//return vsRowInfo.GetSize();
	return m_AllFileImpl.GetRowInfo(lpcszKey, vsRowInfo, bSource);
}

//virtual 
int AllFilePublish::GetShownInfo(vector<bool>& vbShow)
{
	//vbShow.SetSize(FB_COL_NUMS);
	//vbShow = false;
	//vbShow[FB_COL_FILE] =
	//	vbShow[FB_COL_FILETYPE] =
	//	vbShow[FB_COL_FILESIZE] =
	//	vbShow[FB_COL_FILEDATE] = true;

	//return 4;			// shown cols
	return m_AllFileImpl.GetShownInfo(vbShow);
}

//virtual 
int AllFilePublish::GetFiles(bool bSource, vector<string>& vsFiles)
{
	//for (int ii=0; ii<m_vnValidFileType.GetSize(); ii++)
	//{
	//	FilePublishBase *pFilePublish = NULL;
	//	if (getFilePublishDerivation(m_vnValidFileType[ii], pFilePublish))
	//	{
	//		vector<string> vsSubFiles;
	//		pFilePublish->GetFiles(bSource, vsSubFiles);
	//		vsFiles.Append(vsSubFiles);
	//		///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
	//		//if (m_vnValidFileType[ii] == FILE_TYPE_THEME)
	//		//	m_pThemeFilePublish = pFilePublish;
	//		//else if (m_vnValidFileType[ii] == FILE_TYPE_XF)
	//		//	m_pXFFilePublish = pFilePublish;
	//		//else
	//		//	delete pFilePublish;
	//		checkRemovePublishDerivation(m_vnValidFileType[ii], pFilePublish);
	//		///-----End SUPPORT_PLAETTE_FILES
	//	}
	//}

	//return vsFiles.GetSize();
	return m_AllFileImpl.GetFiles(bSource, vsFiles);
}

//virtual 
int AllFilePublish::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	//return fileOperation(vsFileNames, bSource, true);
	return m_AllFileImpl.PublishFiles(vsFileNames, bSource);
}

//virtual 
int AllFilePublish::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	//return fileOperation(vsFileNames, bSource, false);
	return m_AllFileImpl.RemoveFiles(vsFileNames, bSource);
}

//virtual 
bool AllFilePublish::GetFileFullPath(string &strFile1, string &strFile2)
{
	//string strExt;
	//separate_file_name_ext(strFile1, NULL, &strExt);
	//FilePublishBase *pFilePublish = NULL;
	//const int nFileType = getFileTypeFromFileExt(strExt);
	//if (getFilePublishDerivation(nFileType, pFilePublish))
	//{
	//	strFile1 = pFilePublish->GetSrcPath() + strFile1;
	//	strFile2 = pFilePublish->GetDestPath() + strFile2;

	//	checkRemovePublishDerivation(nFileType, pFilePublish);
	//}
	//return true;

	return m_AllFileImpl.GetFileFullPath(strFile1, strFile2);
}

//int AllFilePublish::getFileTypeFromFileExt(LPCSTR lpcszExt)
//{
//	for (int ii=0; ii<m_vsAllFileTypeExt.GetSize(); ii++)
//	{
//		vector<string> vsExts;
//		m_vsAllFileTypeExt[ii].GetTokens(vsExts, '|');
//		int nIndex;
//		if ((nIndex = vsExts.Find(lpcszExt)) >= 0)
//			return ii;
//	}
//	return -1;
//}
//
//bool AllFilePublish::getFilePublishDerivation(int nFileType, FilePublishBase* &pFilePublish)
//{	
//	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
//	if ( FILE_TYPE_XF == nFileType && NULL != m_pXFFilePublish )
//	{
//		pFilePublish = m_pXFFilePublish;
//	}
//	else if ( FILE_TYPE_THEME == nFileType && NULL != m_pThemeFilePublish )
//	{
//		pFilePublish = m_pThemeFilePublish;
//	}
//	else
//	{
//		pFilePublish = create_file_publish(nFileType);
//	}
//
//	return NULL != pFilePublish;
//	///-----End SUPPORT_PLAETTE_FILES
//}
//
/////-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
//void AllFilePublish::checkRemovePublishDerivation(int nFileType, FilePublishBase* &pFilePublish)
//{
//	if ( FILE_TYPE_XF == nFileType )
//	{
//		m_pXFFilePublish = pFilePublish;
//	}
//	else if ( FILE_TYPE_THEME == nFileType )
//	{
//		m_pThemeFilePublish = pFilePublish;
//		return ;
//	}
//	else 
//	{
//		NICE_SAFE_REMOVAL(pFilePublish);
//	}
//}
/////-----End SUPPORT_PLAETTE_FILES
//
//int AllFilePublish::fileOperation(vector<string> &vsFileNames, bool bSource /*= true*/, bool bPublish /*= true*/)
//{
//	int nSize = vsFileNames.GetSize();
//	for (int ii=nSize-1; ii>=0; ii--)
//	{
//		string strExt;
//		separate_file_name_ext(vsFileNames[ii], NULL, &strExt);
//		FilePublishBase *pFilePublish = NULL;
//		if (getFilePublishDerivation(getFileTypeFromFileExt(strExt), pFilePublish))
//		{
//			vector<string> vsTmpFile;
//			vsTmpFile.Add(vsFileNames[ii]);
//			if (bPublish)
//			{
//				if (pFilePublish->PublishFiles(vsTmpFile, bSource) == 0)
//					vsFileNames.RemoveAt(ii);
//			}
//			else
//			{
//				if (pFilePublish->RemoveFiles(vsTmpFile, bSource) == 0)
//					vsFileNames.RemoveAt(ii);
//			}
//		}
//	}
//	return vsFileNames.GetSize();
//}

/************************************************************************/
/* AllFileTransfer
/************************************************************************/
///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
//AllFileTransfer::AllFileTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
AllFileTransfer::AllFileTransfer(LPCSTR lpcszRegKey, LPCSTR lpcszSpecifiedPath, int Recursive) : FileTransferBase(lpcszRegKey, lpcszSpecifiedPath)
///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
{
	//m_pThemeFileTransfer = new ThemeTransfer(m_strRegistryKey, m_strSpecifiedPath);
	//m_pXFFileTransfer = new XFTransfer(m_strRegistryKey, m_strSpecifiedPath);

	/////-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
	//_get_all_file_type(m_vnValidFileType);
	//_get_all_file_ext(m_vsAllFileTypeExt);
	/////-----End SUPPORT_PLAETTE_FILES
	///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	//m_AllFileImpl.Init(false, m_strRegistryKey, m_strSpecifiedPath);
	m_AllFileImpl.Init(false, m_strRegistryKey, m_strSpecifiedPath, Recursive);
	///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	initAllFileTypeName();	///-----Kit 01/27/2011 ORG-2126-P1 SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX
}

//virtual 
int AllFileTransfer::GetRowInfo(LPCSTR lpcszKey, vector<string> &vsRowInfo, bool bSource)
{
	//string strExt;
	//separate_file_name_ext(lpcszKey, NULL, &strExt);
	//int nFileType = getFileTypeFromFileExt(strExt);
	//FilePublishBase *pFileTransfer = NULL;
	//if (getFileTransferDerivation(nFileType, pFileTransfer))
	//{
	//	pFileTransfer->GetRowInfo(lpcszKey, vsRowInfo, bSource);
	//	checkRemoveTransferDerivation(nFileType, pFileTransfer);
	//}

	int nFileType = 0;
	m_AllFileImpl.GetRowInfo(lpcszKey, vsRowInfo, bSource, &nFileType);

	ASSERT(0 <= nFileType && nFileType < m_vsAllFileTypeName.GetSize() );
	
	vsRowInfo[FB_COL_FILETYPE] = m_vsAllFileTypeName[nFileType];

	return vsRowInfo.GetSize();
}

//virtual 
int AllFileTransfer::GetShownInfo(vector<bool>& vbShow)
{
	//vbShow.SetSize(FB_COL_NUMS);
	//vbShow = false;
	//vbShow[FB_COL_FILE] =
	//	vbShow[FB_COL_FILETYPE] =
	//	vbShow[FB_COL_FILESIZE] =
	//	vbShow[FB_COL_FILEDATE] = true;

	//return 4;		// shown cols

	return m_AllFileImpl.GetShownInfo(vbShow);
}

//virtual 
int AllFileTransfer::GetFiles(bool bSource, vector<string>& vsFiles)
{
	//for (int ii=0; ii<m_vnValidFileType.GetSize(); ii++)
	//{
	//	FilePublishBase *pFilePublish = NULL;
	//	if (getFileTransferDerivation(m_vnValidFileType[ii], pFilePublish))
	//	{
	//		vector<string> vsSubFiles;
	//		pFilePublish->GetFiles(bSource, vsSubFiles);
	//		vsFiles.Append(vsSubFiles);
	//		checkRemoveTransferDerivation(m_vnValidFileType[ii], pFilePublish);
	//	}
	//}
	//return true;
	return m_AllFileImpl.GetFiles(bSource, vsFiles);
}

//virtual 
int AllFileTransfer::PublishFiles(vector<string> &vsFileNames, bool bSource /*= true*/)
{
	//return fileOperation(vsFileNames, bSource, true);
	return m_AllFileImpl.PublishFiles(vsFileNames, bSource);
}

//virtual 
int AllFileTransfer::RemoveFiles(vector<string> &vsFileNames, bool bSource)
{
	//return fileOperation(vsFileNames, bSource, false);
	return m_AllFileImpl.RemoveFiles(vsFileNames, bSource);
}

//virtual 
bool AllFileTransfer::GetFileFullPath(string &strFile1, string &strFile2)
{
	//string strExt;
	//separate_file_name_ext(strFile1, NULL, &strExt);
	//FilePublishBase *pFilePublish = NULL;
	//const int nFileType = getFileTypeFromFileExt(strExt);
	//if (getFileTransferDerivation(nFileType, pFilePublish))
	//{
	//	pFilePublish->GetFileFullPath(strFile1, strFile2);
	//	checkRemoveTransferDerivation(nFileType, pFilePublish);
	//}
	//return true;

	return m_AllFileImpl.GetFileFullPath(strFile1, strFile2);
}

// for theme transfer only
//virtual 
int	AllFileTransfer::GetAvailableCates(vector<string>& vsCategories)
{
// 	ASSERT(m_pThemeFileTransfer);
// 	return m_pThemeFileTransfer->GetAvailableCates(vsCategories);
	return m_AllFileImpl.GetAvailableCates(vsCategories);
}

//virtual 
void AllFileTransfer::SetDestCategory(LPCSTR lpcszCategory)
{
// 	ASSERT(m_pThemeFileTransfer);
// 	m_pThemeFileTransfer->SetDestCategory(lpcszCategory);
	m_AllFileImpl.SetDestCategory(lpcszCategory);
}

//virtual 
string AllFileTransfer::GetDestCategory(LPCSTR lpcszFile)
{
	//string strExt;
	//separate_file_name_ext(lpcszFile, NULL, &strExt);
	//FilePublishBase *pFilePublish = NULL;
	//string strCategory;
	//const int nFileType = m_AllFileImpl.getFileTypeFromFileExt(strExt);
	//if (getFileTransferDerivation(nFileType, pFilePublish))
	//{
	//	strCategory = pFilePublish->GetDestCategory();
	//	checkRemoveTransferDerivation(nFileType, pFilePublish);
	//}
	//return strCategory;
	string strCategory;
	///-----Kit 10/19/2011 ORG-4062-P2 DST_CATEGORY_NOT_GET_CORRECT
	//m_AllFileImpl.GetDestCategory(lpcszFile, strCategory);
	m_AllFileImpl.GetDestCategory(strCategory, lpcszFile);
	///-----End DST_CATEGORY_NOT_GET_CORRECT
	return strCategory;
}

//int AllFileTransfer::getFileTypeFromFileExt(LPCSTR lpcszExt)
//{
//	for (int ii=0; ii<m_vsAllFileTypeExt.GetSize(); ii++)
//	{
//		vector<string> vsExts;
//		m_vsAllFileTypeExt[ii].GetTokens(vsExts, '|');
//		int nIndex;
//		if ((nIndex = vsExts.Find(lpcszExt)) >= 0)
//			return ii;
//	}
//	return -1;
//}
//
//bool AllFileTransfer::getFileTransferDerivation(int nFileType, FilePublishBase* &pFileTransfer)
//{
//	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PLAETTE_FILES
//	if ( FILE_TYPE_XF == nFileType )
//	{
//		ASSERT(NULL != m_pXFFileTransfer);
//		pFileTransfer = m_pXFFileTransfer;
//	}
//	else if ( FILE_TYPE_THEME == nFileType )
//	{
//		ASSERT(NULL != m_pThemeFileTransfer);
//		pFileTransfer = m_pThemeFileTransfer;
//	}
//	else
//	{
//		pFileTransfer = create_file_publish(nFileType, false, m_strRegistryKey, m_strSpecifiedPath);
//	}
//
//	return NULL != pFileTransfer;
//	///-----End SUPPORT_PLAETTE_FILES
//}
//
//void AllFileTransfer::checkRemoveTransferDerivation(int nFileType, FileTransferBase* &pFileTransfer)
//{
//	if(pFileTransfer && pFileTransfer != m_pThemeFileTransfer && pFileTransfer != m_pXFFileTransfer)
//		delete pFileTransfer;
//}
//
//int AllFileTransfer::fileOperation(vector<string> &vsFileNames, bool bSource /*= true*/, bool bPublish /*= true*/)
//{
//	int nSize = vsFileNames.GetSize();
//	for (int ii=nSize-1; ii>=0; ii--)
//	{
//		string strExt;
//		separate_file_name_ext(vsFileNames[ii], NULL, &strExt);
//		FilePublishBase *pFileTransfer = NULL;
//		int nFileType = getFileTypeFromFileExt(strExt);
//		if (getFileTransferDerivation(nFileType, pFileTransfer))
//		{
//			vector<string> vsTmpFile;
//			vsTmpFile.Add(vsFileNames[ii]);
//
//			const bool bSuccess = 0 == (bPublish ? pFileTransfer->PublishFiles(vsTmpFile, bSource) : pFileTransfer->RemoveFiles(vsTmpFile, bSource));
//			if ( bSuccess )
//				vsFileNames.RemoveAt(ii);
//
//			checkRemoveTransferDerivation(nFileType, pFileTransfer);
//		}
//	}
//	return vsFileNames.GetSize();
//}

///-----Kit 01/27/2011 ORG-2126-P1 SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX
void AllFileTransfer::initAllFileTypeName()
{
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_OGW);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_DIALOG_THEME);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_FUNCTION_THEME);			///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_FDF);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_IMPORT_FILTER);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_OGS);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_DATABASE);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_ORIGINC);
	//#ifdef SUPPORT_PACKAGE_FILES			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_PACKAGE);
	//#endif								///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_TEMPLATE);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_PATCH);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_PROJECT);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_THEME);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_XF);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_OMC);					///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_DEFAULT_SETTINGS);
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_TEXT_FILE);			///-----Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_PAL_FILE);			///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_USERBUTTONS);			///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
	m_vsAllFileTypeName.Add(STR_FILE_TYPE_OTHER_FILE);
}
///-----End SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX

///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
//FilePublishBase* create_file_publish(int nFileType, bool bGroupMgr /*= true*/, LPCSTR lpcszRegKey /*= NULL*/, LPCSTR lpcszSpecPath /*= NULL*/)
FilePublishBase* create_file_publish(int nFileType, bool bGroupMgr /*= true*/, LPCSTR lpcszRegKey /*= NULL*/, LPCSTR lpcszSpecPath /*= NULL*/, int nRecursive /*= 0*/)
///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
{
	FilePublishBase *pFilePublish = NULL;  
	switch (nFileType)
	{
	case FILE_TYPE_TEMPLATE:
		if (bGroupMgr)
			pFilePublish = new TemplatePublish();
		else
			pFilePublish = new TemplateTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_IMPORT_FILTER:
		if (bGroupMgr)
			pFilePublish = new ImpFilterPublish();
		else
			pFilePublish = new ImpFilterTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_FDF:
		if (bGroupMgr)
			pFilePublish = new FDFPublish();
		else
			pFilePublish = new FDFTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_OGS:
		if (bGroupMgr)
			pFilePublish = new OGSPublish();
		else
			pFilePublish = new OGSTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_THEME:
		///-----Kit 10/09/2011 ORG-3938-P3 SUPPORT_TRANSFER_FUNC_PLOT_THEMES
		//if (bGroupMgr)
		//	pFilePublish = new ThemePublish();
		//else
		//	pFilePublish = new ThemeTransfer(lpcszRegKey, lpcszSpecPath);
		if (bGroupMgr)
			pFilePublish = new WindowThemePublish();
		else
			pFilePublish = new WindowThemeTransfer(lpcszRegKey, lpcszSpecPath);
		///-----End SUPPORT_TRANSFER_FUNC_PLOT_THEMES
		break;

	case FILE_TYPE_PROJECT:
		if(bGroupMgr)
			pFilePublish = new CommonFilePublish(STR_PROJECT_FILE_EXT);
		else
			pFilePublish = new CommonFileTransfer(STR_PROJECT_FILE_EXT, lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_ORIGINC:
		if(bGroupMgr)
			pFilePublish = new OriginCPublish();
		else
			pFilePublish = new OriginCTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_DATABASE:
		if(bGroupMgr)
			pFilePublish = new CommonFilePublish(STR_DATABASE_FILE_EXT);
		else
			pFilePublish = new CommonFileTransfer(STR_DATABASE_FILE_EXT, lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_XF:
		if(bGroupMgr)
			pFilePublish = new XFPublish();
		else
			pFilePublish = new XFTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_OMC:
		if(bGroupMgr)
			pFilePublish = new OMCPublish();
		else
			pFilePublish = new OMCTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_DEFAULT_SETTINGS:
		if(bGroupMgr)
			pFilePublish = new DefaultSettingsPublish();
		else
			pFilePublish = new DefaultSettingsTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
	case FILE_TYPE_USERBUTTONS:
		if ( bGroupMgr )
			pFilePublish = new UserButtonSettingsPublish();
		else
			pFilePublish = new UserButtonSettingsTransfer(lpcszRegKey, lpcszSpecPath);
		break;
	///end TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
	case FILE_TYPE_PATCH:
		if(bGroupMgr)
			pFilePublish = new PatchPublish();
		else
			pFilePublish = new PatchTransfer(lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_OGW:
		if(bGroupMgr)
			pFilePublish = new CommonFilePublish(STR_ANALYSIS_TEMPLATE_EXT);
		else
			pFilePublish = new CommonFileTransfer(STR_ANALYSIS_TEMPLATE_EXT, lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_DIALOG_THEME:
		if(bGroupMgr)
			pFilePublish = new DialogThemePublish();
		else
			pFilePublish = new DialogThemeTransfer(lpcszRegKey, lpcszSpecPath);
		break;
	///------ Tony 07/11/2012 ORG-5954-P1 ADD_OFP_FUNCTION_THEME_SUPPORT
	case FILE_TYPE_FUNCTION_THEME:
		if(bGroupMgr)
			pFilePublish = new FunctionThemePublish( );
		else
			pFilePublish = new FunctionThemeTransfer( lpcszRegKey, lpcszSpecPath);
		break;
	///------ End ADD_OFP_FUNCTION_THEME_SUPPORT
		///-----Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES
	case FILE_TYPE_TEXT:
		if( bGroupMgr )
			pFilePublish = new CommonFilePublish( STR_TEXT_FILE_EXT );
		else
			pFilePublish = new CommonFileTransfer( STR_TEXT_FILE_EXT, lpcszRegKey, lpcszSpecPath );
		break;
		///-----

		///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
	case FILE_TYPE_PALETTE:
		if ( bGroupMgr )
		{
			///-----Kit 12/21/2011 ORG-4609-P1 PAL_FILE_CANNOT_PUBLISH
			//pFilePublish = new CommonFilePublish(STR_PALETTE_FILE_EXT);
			pFilePublish = new CommonFilePublish(STR_PALETTE_FILE_EXT, STR_PAL_FILE_SUB_PATH);
			///-----End PAL_FILE_CANNOT_PUBLISH
		}
		else
		{
			pFilePublish = new CommonFileTransfer(STR_PALETTE_FILE_EXT, lpcszRegKey, lpcszSpecPath, STR_PAL_FILE_SUB_PATH);
		}
		break;
		///-----End SUPPORT_PALETTE_FILES

	case FILE_TYPE_OTHER_FILE:
		if(bGroupMgr)
			pFilePublish = new CommonFilePublish(STR_OTHER_FILE_EXT);
		else
			pFilePublish = new CommonFileTransfer(STR_OTHER_FILE_EXT, lpcszRegKey, lpcszSpecPath);
		break;

	case FILE_TYPE_ALL_FILE:
		if(bGroupMgr)
		{
			pFilePublish = new AllFilePublish();
		}
		else
		{
			///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
			//pFilePublish = new AllFileTransfer(lpcszRegKey, lpcszSpecPath);
			pFilePublish = new AllFileTransfer(lpcszRegKey, lpcszSpecPath, nRecursive);
			///------ End ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
			//bShowCateCombo = m_pFilePublish->IsSrcPathSpecified();
		}
		break;

	case FILE_TYPE_PACKAGE:
		if ( bGroupMgr )
		{
			//dwSpecialFileType |= SPECIAL_FILE_TYPE_PACKAGE;
			pFilePublish = new CommonFilePublish(STR_PACKAGE_75_EXT + "|" + STR_PACKAGE_80_EXT, STR_PACKAGE_SUB_FOLDER);
		}
		else
		{
			pFilePublish = new CommonFileTransfer(STR_PACKAGE_75_EXT + "|" + STR_PACKAGE_80_EXT, lpcszRegKey, lpcszSpecPath, STR_PACKAGE_SUB_FOLDER);
		}
		break;

	default:
		break;
	}
	
	pFilePublish->m_nRecursive = nRecursive;		///------ Tony 08/09/2012 ORG-6330-S4 ADD_SPECIFIED_SOURCE_FILE_LIST_TO_SUPPORT_STATE_COMPARISION
	
	return pFilePublish;
}
///-----End SUPPORT_PALETTE_FILES


#endif //!_OLD_GROUP_FOLDER_MANAGER_AND_TRANSFER_USER_FILES_
