/*------------------------------------------------------------------------------*
 * File Name: FactorialANOVA.c 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <Array.h>
#include <OC_nag.h>
#include <ReportTree.h> 
#include <..\Originlab\FactorialANOVA.h>

#include "XFunctionEx.h"
#include <event_utils.h> 
#include <..\Originlab\PlotProb.h>
#include <..\Originlab\PlotGroup.h>
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
FactorialANOVAReport::FactorialANOVAReport()
{
	m_arrUnstackInfo.SetAsOwner(TRUE);
}

bool FactorialANOVAReport::SortCheckData(const Range& factors, const Range& irng, const vector<string>& vsFactors, Worksheet& wksSort)
{
	//prepare data
	DWORD dwRules = DRR_NO_WEIGHTS;
	int nFactors 	= factors.GetNumData(dwRules);
	ASSERT(vsFactors.GetSize() == nFactors);
	int nNumData 	= irng.GetNumData(dwRules);
	
	if(!wksSort)
		wksSort.Create(NULL, CREATE_NACTIVE|CREATE_SET_MISSING_IN_MANAGER);
	wksSort.SetSize(-1, nFactors+nNumData+1);//index
		
	int nSize, c1, c2;		
	for(int ii = 0; ii < nFactors; ii++)
	{
		vector<string> vsFactorValues;
		DWORD uidAux = 0;
		int nRet = factors.GetData(dwRules, ii, &uidAux, NULL, &vsFactorValues);
		wksSort.Columns(ii+1).PutStringArray(vsFactorValues);		
		
		Worksheet wksSource;
		factors.GetRange(wksSource, c1, c2, 0);//assum in same worksheet
		if(wksSource)
		{
			string strName = get_column_name( wksSource.Columns(nRet) );
			wksSort.Columns(ii+1).SetLongName(strName);
		}
		
		if(ii == 0)
			nSize = vsFactorValues.GetSize();
	}
	 
	for(ii = 0; ii < nNumData; ii++)
	{
		vector vData;
		irng.GetData(vData, ii);
		Dataset dsData(wksSort,ii+nFactors+1);
		dsData = vData;
		
		Worksheet wksSource;
		irng.GetRange(wksSource, c1, c2, 0);//assum in same worksheet
		if(wksSource)
		{
			string strName = get_column_name( wksSource.Columns(c1) );
			wksSort.Columns(ii+nFactors+1).SetLongName(strName);
		}
	}
	
	Dataset dsIndex(wksSort, 0);
	vector<int> vIndex;
	vIndex.Data(1, nSize);
	dsIndex = vIndex;
	
	//sort
	vector<int> vSortByCols;
	vSortByCols.Data(1, nFactors);
	vector<BOOL> vOrder;
	vOrder.SetSize(vSortByCols.GetSize());
	vOrder = SORT_ASCENDING;
	wksSort.Sort(vSortByCols, vOrder);
	
	vIndex = dsIndex - vIndex;
	vIndex.Abs();
	int nSum = -1;
	vIndex.Sum(nSum);
	
	return (nSum > 0);
}

void FactorialANOVAReport::OutputSortData(	const Worksheet& wksSort, int nFactors,
											vector<int>& vnFactorColumnIDs, vector<int>& vnDataColumnIDs,
											ReportTable& rtOutput, int& id)
{
	Dataset dsIndex(wksSort, 0);
	rtOutput.AddColumn(dsIndex, "Index", id++, _L("Index"), OKDATAOBJ_DESIGNATION_X);
	
	int nCols = wksSort.GetNumCols();	
	vnFactorColumnIDs.SetSize(0);
	vnDataColumnIDs.SetSize(0);
	for(int ii = 1; ii < nCols; ii++)//1: index col
	{
		string strName = "Sort"+(string)ii;
		string strLabel = get_column_name( wksSort.Columns(ii) );
		int nID = id++;
		
		vector<string> vsValues;
		Dataset dsData;
		if(ii > nFactors)
		{
			dsData.Attach(wksSort,ii);
			rtOutput.AddColumn(dsData, strName, nID, strLabel, OKDATAOBJ_DESIGNATION_Y);
			vnDataColumnIDs.Add(nID);
		}
		else
		{			
			wksSort.Columns(ii).GetStringArray(vsValues);
			rtOutput.AddColumn(vsValues, strName, nID, strLabel, OKDATAOBJ_DESIGNATION_Y);
			vnFactorColumnIDs.Add(nID);
		}
	}
}

static bool _prepare_input_object(	const vector<string>& vsNames, const vector<uint>& vnColumnIDs, 
									const ReportData& rd, int nReportDataTableID,
									LPCSTR lpczName, bool bXYRange, 
									XYRange& xy = NULL, Column& col = NULL)
{
	int nFind = vsNames.Find(lpczName);
	if(nFind < 0)
		return false;
	
	int nXColumnID = bXYRange? vnColumnIDs[nFind] : 0;
	int nYColumnID = bXYRange? vnColumnIDs[ vnColumnIDs.GetSize()-1 ] : vnColumnIDs[nFind];
	
	DataRange drReportData;
	BOOL bRet = rd.GetDataRange(drReportData, nReportDataTableID, nXColumnID, &nYColumnID, 1, false, false, true);
	XYRange xyReportData(drReportData);
	if( xyReportData.IsEmpty() )
		return false;
	
	string strTemp;
	if(xy != NULL)
		xy = xyReportData;
		
	if(col != NULL)
	{
		xyReportData.GetYColumn(col);
		return col.IsValid();
	}
	
	return true;
}

bool FactorialANOVAReport::OutputMeansData(	const Range& irng, const vector& vMean,  
											LPCSTR lpczEffect, LPCSTR xfactor, LPCSTR dpfactor, LPCSTR lfactor,
											//plot
											vector<string>& vsNames, ReportTree& rt,  
											ReportData& rd, int& id)
{			
	int nReportDataTableID = id++;
	ReportTable rtOutput = rd.CreateTable("plotdata", _L("Means Plot"), nReportDataTableID);	

	vector<string> 	vsFactors, vsFactorValues;
	vector<int> vNpts;
	if( !countGroupSize(irng, lpczEffect, vsFactors, vsFactorValues, vNpts) )
		return false;

	int nFactors = vsFactors.GetSize();
	int nRet = vNpts.GetSize();
	
	Worksheet wksTemp;
	wksTemp.Create(NULL, CREATE_NACTIVE|CREATE_SET_MISSING_IN_MANAGER);
	wksTemp.SetSize(-1, nFactors+1);//means
	
	int nID;
	vector<uint> vnIndices;
	vnIndices.Data(0, nRet-1);
	vnIndices *= nFactors;
	for(int ii = 0; ii < nFactors; ii++)
	{
		vector<string> vsSub;
		vector<uint> vnSubIndices;
		vnSubIndices = vnIndices + ii;
		_get_sub_vector(vsFactorValues, vnSubIndices, vsSub);
		
		wksTemp.Columns(ii).PutStringArray(vsSub);
		
	}
	Dataset ds(wksTemp,ii);
	ds = vMean;
	 
	sortByPlotFactors(vsFactors, xfactor, dpfactor, lfactor, wksTemp);
	
	vector<uint> vnColumnIDs;
	for(ii = 0; ii < nFactors; ii++)
	{
		vector<string> vsValues;
		wksTemp.Columns(ii).GetStringArray(vsValues);
		
		nID = id++;
		rtOutput.AddColumn(vsValues, "Factor"+(string)(ii+1), nID, vsFactors[ii], OKDATAOBJ_DESIGNATION_Y);
		vnColumnIDs.Add(nID);
	}
	Dataset dsMeans(wksTemp,ii);
	nID = id++;
	rtOutput.AddColumn(dsMeans, "Means", nID, _L("Means"), OKDATAOBJ_DESIGNATION_Y);
	vnColumnIDs.Add(nID);
	
	wksTemp.Destroy();	
	
	//plotgroup
	XYRange	iy;
	Column 	dgrp, lgrp;
	if(	!_prepare_input_object(vsNames, vnColumnIDs, rd, nReportDataTableID, xfactor, true, iy) ||	
		!_prepare_input_object(vsNames, vnColumnIDs, rd, nReportDataTableID, dpfactor, false, NULL, dgrp) ||
		!_prepare_input_object(vsNames, vnColumnIDs, rd, nReportDataTableID, lfactor, false, NULL, lgrp) )
	{
		ASSERT(0);
		return false;
	}
	
	vector<string> vsOutputGraphs;
	plot_group_ex(	iy, NULL, lgrp, dgrp, 
					0,			//arrange
					"origin", 	//template
					2,			//type = type_linesymb
					0, 			//sort
					vsOutputGraphs);
	int nn = 0;
	for(ii = 0; ii < vsOutputGraphs.GetSize(); ii++)
	{
		GraphPage gp( vsOutputGraphs[ii] );
		if(!gp)
			continue;
		string strTag = "MeansPlot";
		string strLabel = _L("Means Plot");
		if(nn > 0)
		{
			strTag += (string)(nn+1);
			strLabel += (string)(nn+1);
		}
		ReportTable grt = rt.CreateTable(strTag, strLabel, id++);
		grt.SetCell(0, 0, gp, EMBEDGRAPH_MOVE_IF_ALREADY_EMBEDDED);
	}
	
	return true;
}

/*------------------------------------------*
*	utilities functions:					*
*-------------------------------------------*/
void	collapse_report_tree_branch(TreeNode& trReport)
{
	trReport.SetAttribute(TREE_Table, 	GETNBRANCH_HIDE_ROW_HEADINGS	|	GETNBRANCH_RESIZE		|
										GETNBRANCH_HIDE_CLIENT_EDGE 	| 	GETNBRANCH_SHOW_FRAME	|
										GETNBRANCH_FIT_COL_WIDTH		|	GETNBRANCH_FIT_ROW_HEIGHT);		
}
											
int 	count_factors_levels(const Range& drFactor, const Range& drData, vector<int>& vnLevels)
{
	DataRange drTemp;
	vnLevels.SetSize(0);

	int nR1, nR2, nC1, nC2;
	Worksheet wksTemp;
		
	int nNumRanges = drFactor.GetNumRanges();
	for( int nIndex = 0; nIndex < nNumRanges; nIndex++ )
	{	
		drFactor.GetRange(nIndex, nR1, nC1, nR2, nC2, wksTemp);
		for( int ii = nC1; ii <= nC2; ii++)
		{			
			drTemp.Add("F", wksTemp, nR1, ii, nR2, ii);
		}
    }
    
	drData.GetRange(0, nR1, nC1, nR2, nC2, wksTemp);
	drTemp.Add("X", wksTemp, nR1, nC1, nR2, nC2);			
	int nNumData = drTemp.GetNumData(DRR_NO_WEIGHTS, NULL, NULL, &vnLevels, NULL);	
	return vnLevels.GetSize();
}

static void _do_residual_plot(LPCSTR resplotx, const DataRange& drReportData, ReportTree& rt, int& id)
{	
	if(lstrcmpi(resplotx, STR_NONE_ITEM) != 0)
	{	
		GraphPage gpResidual;
		gpResidual.Create("origin");
		GraphLayer glResidual = gpResidual.Layers(0);
		
		int nPlot = glResidual.AddPlot(drReportData);
		if(nPlot > -1)
		{
			DataPlot dpResidual = glResidual.DataPlots(nPlot);
			dpResidual.SetColor(SYSCOLOR_RED); 
			
			legend_append_plot(glResidual, nPlot, "@LG");
	
			Tree trFmt;
			trFmt.Root.Axes.X.Additional.ZeroLine.nVal = 1;
			if( 0 == glResidual.UpdateThemeIDs(trFmt.Root) )
				glResidual.ApplyFormat(trFmt, true, true);
			
			glResidual.Rescale();
		}
		
		ReportTable grt = rt.CreateTable("ResidualPlot", _L("Residual Plot"), id++);
		grt.SetCell(0, 0, gpResidual, EMBEDGRAPH_MOVE_IF_ALREADY_EMBEDDED);
	}
	
	return;
}
static void _do_prob_plot(	const int& probplot, const DataRange& drReportData, 
							ReportTree& rt, ReportData& rd, int& id)
{		
	//must plot PP-plot first or fail
	if(!probplot || !rd)
		return;
	
	XYRange xy(drReportData);
	Column colY;
	xy.GetYColumn(colY);
	if(!colY)
		return;
	
	string strRange;
	colY.GetRangeString(strRange);
	
	DataRange irng;
	irng.Add("X", strRange);	
	int nErrCode = check_1_data(irng);
	if (CER_NO_ERROR != nErrCode)
	{
		return;
	}
	//string strLT;
	//strLT.Format("worksheet -px ? PPNormal plot_prob irng:=%s option:=0;;", strRange);
	//LT_execute(strLT);
	
	vector vIn;
	DWORD dwRules = DRR_NO_WEIGHTS|DRR_GET_MISSING;
	DWORD dwPlotID;
	if( irng.GetData(dwRules, 0, &dwPlotID, NULL, &vIn) < 0 )
		XF_THROW(XFERR_INVALID_RANGE);	
	
	int option = 0, distr = 0, estimate = 1, method = 0, exchange = 0;
	
	double	location, scale;
	double 	mean, std;
	int 	n;
	ocmath_basic_summary_stats(vIn.GetSize(), vIn, &n, &mean, &std);
	location 	= mean;
	scale 		= std;
	
	Tree trRoot;
	TreeNode trGetN;
	XFBase xf("plot_prob");
	xf.GetGUI(trRoot, trGetN);
	trGetN.irng.strVal 	= strRange;
	trGetN.option.nVal 	= option;
	trGetN.dist.nVal 	= distr;
	trGetN.estimate.nVal= estimate;
	trGetN.location.dVal= location;
	trGetN.scale.dVal 	= scale;
	trGetN.method.nVal 	= method;
	trGetN.exchange.nVal= exchange;
	trGetN.rd.strVal 	= "";
	
	string strLocationLabel, strScaleLabel;
	_get_label_on_distribution_type(distr, strLocationLabel, strScaleLabel);
	if( !strLocationLabel.IsEmpty() )
		trGetN.location.SetAttribute(STR_LABEL_ATTRIB, strLocationLabel);
	if( !strScaleLabel.IsEmpty() )
		trGetN.scale.SetAttribute(STR_LABEL_ATTRIB, strScaleLabel);
	
	plot_prob_ex(irng, option, distr, estimate, location, scale, method, exchange, rd, &id, /*bRenameWks*/false);
	
	GraphPage gp;
	gp.Create("PPNormal");
	GraphLayer gl = gp.Layers(0);	
	//plot_prob_CreatePlots(gl, rd, trGetN, false);	
	DataRange drPlot;
	drPlot.Add();
	
	Worksheet wks;
	if( rd.GetWorksheet(wks) )
	{
		foreach(TreeNode trTable in rd.Children)
		{	
			DataRange 	drTable;
			int 		nIDY = trTable.LastNode.ID;		
			rd.GetDataRange(drTable, trTable.ID, trTable.FirstNode.ID, &nIDY);
			
			XYRange	xy(drTable);
			Column 	colX, colY;
			int		r1, r2;
			xy.GetXColumn(colX, 0, &r1, &r2);
			xy.GetYColumn(colY);

			drPlot.Add(wks, colX.GetIndex(), NULL, colY.GetIndex(), r1, r2);
		}
		plot_prob_CreatePlots(gl, drPlot, trGetN, false);	
	}
	else
		ASSERT(0);
	
	ReportTable grt = rt.CreateTable("ProbabilityPlot", _L("Probability Plot"), id++);
	grt.SetCell(0, 0, gp, EMBEDGRAPH_MOVE_IF_ALREADY_EMBEDDED);
}
void 	output_residual_data_and_plot(	const DataRange& drInput, const DataRange& drFactors, const vector& vResidual,
										const vector<string>& vsNames, LPCSTR lpczLabel, LPCSTR resplotx, const int& probplot, 
										ReportTree& rt, ReportData& rd, ReportData& rdProb, int& id)
{
	int	nResDataTableID 		= id++;
	int nReportDataTableXColID 	= 0;
	int	nReportDataTableYColID 	= 0;
	
	ReportTable rtResData = rd.CreateTable("resdata", lpczLabel, nResDataTableID);		
	if(lstrcmpi(resplotx, STR_NONE_ITEM) != 0)
	{	
		vector vResidualXData;		
		string strResidualXData, strXDescriptive;
		
		if(lstrcmpi(resplotx, STR_PREDICTED_Y) == 0)
		{
			drInput.GetData(DRR_NO_WEIGHTS, 0, NULL, &strXDescriptive, &vResidualXData);
			vResidualXData -= vResidual;
			strResidualXData = STR_PREDICTED_Y;
		}
		else
		{
			int nIndex = vsNames.Find(resplotx);
			
			if(nIndex >= 0)
			{
				drFactors.GetData(DRR_NO_WEIGHTS, nIndex, NULL, &strXDescriptive, &vResidualXData);
				strResidualXData = vsNames[nIndex];
			}
		}	
		
		if(vResidualXData.GetSize() > 0)
		{
			nReportDataTableXColID = id++;
			rtResData.AddColumn(vResidualXData, "ResX", nReportDataTableXColID, strResidualXData, OKDATAOBJ_DESIGNATION_X);
		}
	}
	id += 2;
	nReportDataTableYColID = id++;
	rtResData.AddColumn(vResidual, "ResY", nReportDataTableYColID, _L("Residual"), OKDATAOBJ_DESIGNATION_Y);
	
	//plot	
	DataRange drReportData;
	BOOL bRet = rd.GetDataRange(drReportData, nResDataTableID, nReportDataTableXColID, &nReportDataTableYColID);
	_do_residual_plot(resplotx, drReportData, rt, id);	
	_do_prob_plot(probplot, drReportData, rt, rdProb, id);
}
/*------------------------------------------*
*	end utilities functions:				*
*-------------------------------------------*/
