/*------------------------------------------------------------------------------*
 * File Name: FFWFuncBodyPage.h		 											*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 06/21/10 ORG-343 QUICK_CHECK_FUNCTION_BODY							*
 *	Folger 06/24/10 ORG-390-S3 CHANGE_DO_IT_TO_EVALUATE							*
 *	Folger 06/24/10 ORG-390-P1 FUNCTION_BODY_GONE_WHEN_EDIT_FUNCTION_OF_EQUATION_TYPE
 *	Folger 06/24/10 ORG-390-P4 SHOW_CONSTANTS_IN_EVALUATION_PAGE				*
 *	Folger 06/25/10 ORG-390-P2 SAVE_USER_CHANGED_IN_FIT_FUNCTION_WIZARD_INTO_FDF*
 *	Folger 07/06/10 ORG-432-S13 CENTRALIZE_FUNCTION_BODY_PAGE_RESOURCES			*
 *	Bill 07/15/2010 ORG-576-S1 MOVE_TO_NEXT_ROW_IF_USER_PRESS_ENTER             *
 *	Jasmine 07/29/10 ORG-591-P7 FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
 *	Jasminie 07/30/10 ORG-591-P7 PRECOMPILE_FILE_MAKE_COMPILE_CHECKING_FAIL		*
 *	Jasmine 08/02/10 ORG-591-P7 DETECH_EXTERNAL_DLL_SOURCE						*
 *	Jasmine 08/10/10 ORG-745-P4 ALLOW_EXTERNAL_DLL_HAS_EMPTY_ANNOTATION			*
 *	Folger 08/11/10 ORG-756-P3 BETTER_CHECKING_FOR_VALID_EQUATIONS				*
 *	Folger 08/16/10 ORG-756-P1-P2 BETTER_ERROR_CHECKING_FOR_FITTING_FUNCTION_LT_EVALUATION
 *	Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
 *	Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
 *	Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL					*
 *	Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG							*
 *	Jasmine 08/16/2011 ORG-3484-S3-3 DIFF_TAB_HAS_DIFF_HINT						*
 *	Zech 09/02/2011 ORG-3610-P1 MAKE_TREAT_ALL_NUMBERS_AS_DOUBLES_EFFECTIVE_WITHOUT_CHECKBOX_MODIFIED
 *	Jasmine 09/20/2011 ORG-3484-P2 THERE_MAY_BE_PARENTHESE_INSIDE_ARG			*
 *	Jasmine 10/20/2011 ORG-3484-S7 IMPROVE_NO_INTEGRAL_IN_FUNC_BODY_ERR_MSG		*
 *	Jasmine 10/20/2011 ORG-3484-P3 OTHER_FUNC_TYPE_SHOULD_HIDE_INTEGRAL_CONTROLS*
 *	Jasmine 10/20/2011 ORG-3484 THERE_ARE_MANY_PARENTH_AND_HAVE_TO_FIND_THE_MACTH_TWO
 *	Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
 *  Iris 6/08/2012 ORG-5896-P1 DISABLE_EVALUATE_CONTROLS_FOR_IMPLICIT_FUNC		* 
 *  Iris 7/30/2012 ORG-5896-P1 DISABLE_EVALUATE_CONTROLS_FOR_IMPLICIT_FUNC_MORE	*
 *	Tony 09/05/2012 ORG-6725-P1 ADD_UPDATEPAGEGUITOTREE_FUNC					*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 this file contains six classes:
 	1. FFWEquationPageBase
 	|-2. FFWOCFunctionPage
 	|-3. FFWExternalDLLPage
 	|-4. FFWExpressionPage
 	|-5. FFWMultiEquationPage
 	|-6. FFWLabtalkPage
 *------------------------------------------------------------------------------*/ 
 
#ifndef _FFW_FUNC_BODY_PAGE_H
#define _FFW_FUNC_BODY_PAGE_H

#include "FunctionMgr.h"//for FFWOCFunctionPage
#include "FFWParamControls.h"

/*------------------------------------------------------------------------------*
 * FFWEquationPageBase	 														*
 *------------------------------------------------------------------------------*/
enum{ 	FFW_PARAM_TAB, FFW_CONST_TAB,
		FFW_INTEG_TAB};		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL

///Sophy 7/5/2010 ORG-432-S12 CHECK_EQUATION_PARAMS_SETTINGS
enum {
	FFW_EQUATION_OK = 0,
	FFW_EQUATION_INVALID_PARAMS,
	FFW_EQUATION_INVALID_CONTANT,
	FFW_EQUATION_INVALID_INDEPS,
	FFW_EQUATION_COMPILE_ERROR,
	FFW_EQUATION_PEAK_ATTRIB_ERROR,
	FFW_EQUATION_TOO_MANY_INDEPS,	///Sophy 7/7/2010 ORG-432-S14 WARNING_MSG_WHEN_EVALUATE_WITH_TOO_MANY_INDEPS
	FFW_EQUATION_EMPTY_FORMULA,		///Sophy 7/8/2010 ORG-518-P2 IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	FFW_EQUATION_EMPTY_DLL,			///Jasmine 08/02/10 ORG-591-P7 DETECH_EXTERNAL_DLL_SOURCE
	FFW_HAS_NO_INTEGLT,				///Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG
};
///end CHECK_EQUATION_PARAMS_SETTINGS

#define	TRIM_STR(_Str)	_Str.TrimLeft(), _Str.TrimRight();	///Sophy 7/8/2010 ORG-518-P3 TRIM_PARAM_VALUE_AND_CONSTANT_BEFORE_SAVE

class FFWEquationPageBase : public FFWPageBase
{
public:
	FFWEquationPageBase(int nID = 0) : FFWPageBase(nID){}

	virtual BOOL OnInitPage();

	BOOL 	OnEvaluateClick(Control ctrl);
	
	void  	OnAfterEditParaControl(Control flxControl, int nRow, int nCol);
	
	BOOL 	OnTabChange(Control ctrl);
	
	bool	InitGridConstant();
	bool	InitGridParam();
	bool	InitTabControls();
	
	//virtual
	BOOL	OnNext();///Sophy 7/5/2010 ORG-432-S12 CHECK_EQUATION_PARAMS_SETTINGS

protected:
	virtual bool 	UpdateTreeToPageGUI(const TreeNode& trFunction);
	virtual bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	virtual string	GetPageHintsName(bool bNextPage = false);///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
	
	bool 			evaluateDependentVar();
	
	/// Hong 07/01/10 ORG-432 FFW_NEW_GUI_DESIGN
	int				getIndepVarsVal(vector& vv);
	/// end FFW_NEW_GUI_DESIGN
	
	///Sophy 7/5/2010 ORG-432-S12 CHECK_EQUATION_PARAMS_SETTINGS
	int				CheckEquation(string& strErrMsg);
	///end CHECK_EQUATION_PARAMS_SETTINGS

	
protected:
	FFWParamSetting 		m_FFWParamGrid;
	FFWConstantSetting 		m_gridConstant;
	TabControl				m_tabParameter;
	
	Control					m_controlDependVar;
	//Control					m_controlIndependVar;
	//Control					m_controlParam;

	Edit					m_editEquation;

};

virtual BOOL FFWEquationPageBase::OnInitPage()
{	
	/// Hong 07/01/10 ORG-432 FFW_NEW_GUI_DESIGN
	m_controlDependVar = GetItem(IDC_FIT_FUNC_DEPEND_VAR);
	/// end FFW_NEW_GUI_DESIGN

	if ( !InitGridConstant() || !InitGridParam() || !InitTabControls() )
		return FALSE;
	                 
	m_editEquation	= GetItem(IDC_FIT_FUNC_FUNCTION_BODY_EDIT);

	BitmapRadioButton btnEvaluate = GetItem(FFW_EVALUATE_BTN);
	vector<string> vsTips(1);
	vsTips[0] = _LC("Evaluate", STR_LOCALIZD_CATEGORY);
	btnEvaluate.Init(1, IDB_APPLY_BTN, 16, vsTips);
	
	FFWPageBase::OnInitPage();
	
	return TRUE;
}

BOOL FFWEquationPageBase:: OnEvaluateClick(Control ctrl){return evaluateDependentVar();}

void  FFWEquationPageBase::OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
{
	if (NLPARAMGRIDCOLTYPE_NAME == nCol)
	{
		vector<string> vsNames;

		m_FFWParamGrid.GetColValues(NLPARAMGRIDCOLTYPE_NAME, vsNames);

		string strNew = vsNames[nRow];

		vsNames.RemoveAt(nRow);
		vsNames.RemoveAt(0);

		if ( vsNames.Find(strNew) != -1)
		{
			string strErrMsg;

			strErrMsg.Format(_L("The parameter %s already exists"), strNew);

			MessageBox(strErrMsg, STR_ERROR, MB_OK);

			string strDummy("");

			m_FFWParamGrid.SetCell(nRow, nCol, strDummy);			
		}
	}

	m_FFWParamGrid.OnAfterEdit(flxControl, nRow, nCol);
}

BOOL FFWEquationPageBase::OnTabChange(Control ctrl)
{
	bool bParamTab = FFW_PARAM_TAB == m_tabParameter.GetCurSel();
	m_FFWParamGrid.SetVisible(bParamTab);
	m_gridConstant.SetVisible(!bParamTab);
	return TRUE;
}

bool FFWEquationPageBase::InitGridParam()
{
	m_FFWParamGrid.Init(IDC_FIT_FUNC_PARAM_GRID, *this, "junk");
	
	m_FFWParamGrid.ShowGroup(0);
	
	return true;
}

bool FFWEquationPageBase::InitGridConstant()
{
	m_gridConstant.Init(IDC_FIT_FUNC_CONSTANT_GRID, *this);
	return true;
}

bool FFWEquationPageBase::InitTabControls()
{
	m_tabParameter = GetItem(IDC_FIT_FUNC_PARAM_TAB);
	if(!m_tabParameter)
		return false;
	
	m_tabParameter.InsertItem(FFW_PARAM_TAB, _L("Parameters"));
	m_tabParameter.InsertItem(FFW_CONST_TAB, _L("Constants"));
	
	RECT rTab;
	m_tabParameter.GetWindowRect(&rTab);
	ScreenToClient(&rTab);
	m_tabParameter.AdjustRect(FALSE, &rTab);
	
	m_FFWParamGrid.MoveWindow(rTab);
	m_gridConstant.MoveWindow(rTab);

	OnTabChange(m_tabParameter);
	
	return true;
}

virtual bool FFWEquationPageBase::UpdateTreeToPageGUI(const TreeNode& trFunction)
{
	//parameter
	/// Bill 07/02/2010 ORG-432-P2 HIDE_PEAK_ATTRIBUTES_IF_NOT_PEAK_FUNCTION
	bool bPeakFunction = FuncOrganizer().IsPeak(m_pHolder->m_trFunction);
	m_FFWParamGrid.HideCol(NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE, !bPeakFunction);
	/// End HIDE_PEAK_ATTRIBUTES_IF_NOT_PEAK_FUNCTION

	m_FFWParamGrid.SetTree(m_pHolder->m_trFunction);
	m_FFWParamGrid.ResizeCols();

	//constant
	vector<string> vsVariables;
	vector<string> vsValues;
 	int nCount = FuncOrganizer().GetConstants(m_pHolder->m_trFunction, vsVariables, vsValues);
	m_gridConstant.Update(vsVariables, vsValues);
	m_gridConstant.ResizeCols();
	
	//function body
	if(m_editEquation)
	{
		/// Bill 07/05/2010 ORG-478-P4 FIXED_LINE_BREAK_ISSUE
		//m_editEquation.Text = FuncOrganizer().GetFormula(trFunction);
		string strFuncBody = FuncOrganizer().GetFormula(trFunction);
		StringToEditText(strFuncBody, m_editEquation);
		/// End FIXED_LINE_BREAK_ISSUE
	}

	//evaluate controls
	char ch = ',';
	string strIndepNames = FuncOrganizer().GetIndependVars(trFunction, ch);
	vector<string> vsNames;
	int nNames = strIndepNames.GetTokens(vsNames, ch);
	
	ch = ';';
	string strIndepVars = FuncOrganizer().GetIndependVarsWithValue(trFunction, ch);	
	vector vValues;
	FuncOrganizer().ParseIndependVarsValue(vValues, trFunction, strIndepVars, ch);
	
	int nMaxNum = 4;
	vector<int> vnLabels = {IDC_FIT_FUNC_INDEPEND_VAR1, IDC_FIT_FUNC_INDEPEND_VAR2, IDC_FIT_FUNC_INDEPEND_VAR3, IDC_FIT_FUNC_INDEPEND_VAR4};
	vector<int> vnEdits = {IDC_FIT_FUNC_INDEPEND_VAR_VALUE1, IDC_FIT_FUNC_INDEPEND_VAR_VALUE2, IDC_FIT_FUNC_INDEPEND_VAR_VALUE3, IDC_FIT_FUNC_INDEPEND_VAR_VALUE4};
	ASSERT( nMaxNum == vnLabels.GetSize() && nMaxNum == vnEdits.GetSize() );
	for(int ii = 0; ii < nMaxNum; ii++)
	{
		Control label 	= GetItem( vnLabels[ii] );
		Control edit	= GetItem( vnEdits[ii] );
		if(ii < nNames)
		{
			label.Text = vsNames[ii] + " = ";
			if( ii < vValues.GetSize() )
				edit.Text = ftoa( vValues[ii] );
			label.Visible = edit.Visible = true;
		}
		else
		{
			label.Visible = edit.Visible = false;
		}
	}
	
	return true;
}

virtual bool FFWEquationPageBase::UpdatePageGUIToTree(TreeNode& trFunction)
{
	//parameter
	m_FFWParamGrid.GetTree(trFunction);
	
	//constant
	vector<string> vsVariables, vsValues;
	m_gridConstant.GetColValues(CONSTANT_VARIABLE_COLUMN, vsVariables);
	m_gridConstant.GetColValues(CONSTANT_VALUE_COLUMN, vsValues);

	vsVariables.RemoveAt(0);
	vsValues.RemoveAt(0);
	for (int ii = vsVariables.GetSize() - 1 ; ii >= 0 ; --ii)
		if ( vsVariables[ii] == "")
		{
			vsVariables.RemoveAt(ii);
			vsValues.RemoveAt(ii);
		}
	FuncOrganizer().SetConstants(vsVariables, vsValues, trFunction);
	
	//function body
	string strFormula = m_editEquation ? m_editEquation.Text : "";
	FuncOrganizer().SetFormula(strFormula, trFunction);
	
	//evaluate controls
	///------ Folger 06/25/10 ORG-390-P2 SAVE_USER_CHANGED_IN_FIT_FUNCTION_WIZARD_INTO_FDF
	FuncOrganizer().ClearQuickCheck(trFunction);
	/// Hong 07/01/10 ORG-432 FFW_NEW_GUI_DESIGN
	//FuncOrganizer().SetQuickCheck(trFunction, m_controlIndependVar ? m_controlIndependVar.Text : "");
	//FuncOrganizer().SetQuickCheck(trFunction, m_controlParam ? m_controlParam.Text : "");
	vector<string>	vstrNames, vstrVals, vstrTemp;
	vector			vVals, vTemp;
	nlf_get_independent_variables(trFunction, &vstrNames);
	char			chDelimiter = ',';
	string			strNames = FuncOrganizer().GetFittingPara(trFunction);
	strNames.GetTokens(vstrTemp, chDelimiter);
	vstrNames.Append(vstrTemp);
	
	getIndepVarsVal(vVals);
	m_FFWParamGrid.GetParamsVals(vTemp);
	vVals.Append(vTemp);
	convert_double_vector_to_string_vector(vVals, vstrVals, vVals.GetSize());
	ASSERT( vstrNames.GetSize() == vstrVals.GetSize() );
	FuncOrganizer().SetQuickCheckItems(trFunction, vstrNames, vstrVals);
	/// end FFW_NEW_GUI_DESIGN
	///------ End SAVE_USER_CHANGED_IN_FIT_FUNCTION_WIZARD_INTO_FDF

	return true;
}

///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
virtual string FFWEquationPageBase::GetPageHintsName(bool bNextPage/* = false*/)
{
	if ( !bNextPage )
		return "";
	else
		return "Function next page";
}
///End MOVE_FFW_HINTS_TO_TXT

///Jasmine 06/21/10 ORG-343 QUICK_CHECK_FUNCTION_BODY 
bool FFWEquationPageBase::evaluateDependentVar()
{
	TreeNode trFunction = m_pHolder->m_trFunction;
	if( !UpdatePageGUIToTree(trFunction) )
	{
		ASSERT(0);
		return false;
	}	
	
	///Sophy 7/5/2010 ORG-432-S12 CHECK_EQUATION_PARAMS_SETTINGS
	string strErrMsg;
	int nErr = CheckEquation(strErrMsg);
	if ( nErr != FFW_EQUATION_OK )
	{
		m_controlDependVar.Text = strErrMsg;
		return false;
	}
	///end CHECK_EQUATION_PARAMS_SETTINGS
	
	/// Hong 07/01/10 ORG-432 FFW_NEW_GUI_DESIGN
	//string strIndepVal = m_controlIndependVar.Text;
	//string strParamVal = m_controlParam.Text;
	
	//vector vIndepValue, vParamValue;
	//int nIndepNum = FuncOrganizer().ParseIndependVarsValue(vIndepValue, trFunction, strIndepVal, ',');
	//int nParamNum = FuncOrganizer().ParseFittingParamValue(vParamValue, trFunction, strParamVal, ',');
	vector 	vIndepValue, vParamValue;
	int 	nIndepNum = getIndepVarsVal(vIndepValue);
	int 	nParamNum = m_FFWParamGrid.GetParamsVals(vParamValue);
	/// end FFW_NEW_GUI_DESIGN
	int nDepNum = nlf_get_dependent_variables(trFunction);
	
	matrix mIndVars, mDepVars;
	mIndVars.SetSize(1, nIndepNum);
	mDepVars.SetSize(1, nDepNum);
	if(mIndVars.SetRow(vIndepValue, 0) != 0)
		ASSERT(0);
	
	NumericFunction	nf(m_pHolder->m_trFunction);
	///------ Folger 08/16/10 ORG-756-P1-P2 BETTER_ERROR_CHECKING_FOR_FITTING_FUNCTION_LT_EVALUATION
	//bool bRet = nf.Evaluate(vParamValue, 1, mDepVars, mIndVars);
	bool bRet = nf.Evaluate(vParamValue, 1, mDepVars, mIndVars, NLSFEVALUATE_CHECK_LT_VARS_FULLY_USED);
	///------ End BETTER_ERROR_CHECKING_FOR_FITTING_FUNCTION_LT_EVALUATION

	vector vDepValue;
	if( mDepVars.GetAsVector(vDepValue) )
	{
		string strDepVal = FuncOrganizer().CombineDependVarsWithValue(vDepValue, trFunction, ',');
		m_controlDependVar.Text = strDepVal;
	}
	
	return true;
}
///End QUICK_CHECK_FUNCTION_BODY

/// Hong 07/01/10 ORG-432 FFW_NEW_GUI_DESIGN
int	FFWEquationPageBase::getIndepVarsVal(vector& vv)
{
	int				nIndep = nlf_get_independent_variables(m_pHolder->m_trFunction);
	vv.SetSize(nIndep);
	vector<uint>	vIDs = {IDC_FIT_FUNC_INDEPEND_VAR_VALUE1, IDC_FIT_FUNC_INDEPEND_VAR_VALUE2, IDC_FIT_FUNC_INDEPEND_VAR_VALUE3, IDC_FIT_FUNC_INDEPEND_VAR_VALUE4};
	Control			ctrl;
	for ( int ii = 0; ii < nIndep && ii < vIDs.GetSize(); ii++ )
	{
		ctrl = GetItem(vIDs[ii]);
		vv[ii] = atof(ctrl.Text);
	}
	return nIndep;
}
/// end FFW_NEW_GUI_DESIGN

///Sophy 7/5/2010 ORG-432-S12 CHECK_EQUATION_PARAMS_SETTINGS
//virtual
BOOL FFWEquationPageBase::OnNext()
{
	string strErrMsg;
	int nErr = CheckEquation(strErrMsg);
	if ( nErr == FFW_EQUATION_INVALID_CONTANT || nErr == FFW_EQUATION_COMPILE_ERROR || nErr == FFW_EQUATION_PEAK_ATTRIB_ERROR )
	{
		MessageBox(strErrMsg, STR_ERROR, MB_OK);
		return FALSE;
	}
	return FFWPageBase::OnNext();
}

int FFWEquationPageBase::CheckEquation(string& strErrMsg)
{
	int ii, nSize;
	//constant checking
	vector<string> vsVariables, vsValues;
	m_gridConstant.GetColValues(CONSTANT_VARIABLE_COLUMN, vsVariables);
	m_gridConstant.GetColValues(CONSTANT_VALUE_COLUMN, vsValues);
	nSize = vsVariables.GetSize();
	for ( ii = m_gridConstant.GetRowOffset(); ii < nSize; ii++ )
	{
		if ( is_missing_value(atof(vsValues[ii])) )
		{
			strErrMsg.Format(_L("%s is not a valid value for constant parameter %s."), vsValues[ii].IsEmpty() ? ftoa(NANUM) : vsValues[ii], vsVariables[ii]);
			return FFW_EQUATION_INVALID_CONTANT;
		}
	}
	
	//compile function
	NumericFunction nf(m_pHolder->m_trFunction);
	if ( !nf.CheckCompileOC() )
	{
		ocu_load_msg_str(NLSF_ERR_COMPILE_NUMERIC_FUNCTION, &strErrMsg);			
		return FFW_EQUATION_COMPILE_ERROR;
	}
	
	//check peak attribs
	if ( FuncOrganizer().IsPeak(m_pHolder->m_trFunction) )
	{
		vector<string> vsVals;
		m_FFWParamGrid.GetColValues(NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE, vsVals, m_FFWParamGrid.GetRowOffset());
#define	MIN_PEAK_FUNCTION_PARAMS	4
		if ( vsVals.GetSize() < MIN_PEAK_FUNCTION_PARAMS ||
			 vsVals[0].CompareNoCase(STR_OFFSET_PEAK_INFO) != 0 ||
			 vsVals.Find(STR_X_CENTER_PEAK_INFO) < 0 ||
			 vsVals.Find(STR_X_WIDTH_PEAK_INFO) < 0 ||
			 vsVals.Find(STR_AMPLITUDE_PEAK_INFO) < 0 )
		{
			ocu_load_err_msg_str(MSG_FFW_PEAK_FUNCTION, &strErrMsg);///Jasmine 07/14/10 ORG-540-P3
			return FFW_EQUATION_PEAK_ATTRIB_ERROR;
		}
	}
	
	//parameter checking
	vector<string> vsParamNames, vsParamValues;
	m_FFWParamGrid.GetColValues(NLPARAMGRIDCOLTYPE_NAME, vsParamNames);
	m_FFWParamGrid.GetColValues(NLPARAMGRIDCOLTYPE_VALUE, vsParamValues);
	///Jasmine 12/27/10 ORG938-P5 GET_TRUE_VALUE_WITHOUT_FORMAT
	vector vParamValues;
	m_FFWParamGrid.GetParamsVals(vParamValues);
	nSize = vsParamNames.GetSize();
	for ( ii = m_gridConstant.GetRowOffset(); ii < nSize; ii++ )
	{
		//if ( is_missing_value(atof(vsParamValues[ii])) )
		int nParaIndex = ii - m_gridConstant.GetRowOffset();
		if ( is_missing_value( vParamValues[nParaIndex] ) )
		///End GET_TRUE_VALUE_WITHOUT_FORMAT
		{
			strErrMsg.Format(_L("%s is not a valid value for parameter %s."), vsParamValues[ii].IsEmpty() ? ftoa(NANUM) : vsParamValues[ii], vsParamNames[ii]);
			return FFW_EQUATION_INVALID_PARAMS;
		}
	}
	
	//check independents
	vector	vIndepValue;
	vector<string> vsIndepVars;
	int 	nIndepNum = getIndepVarsVal(vIndepValue);
	nlf_get_independent_variables(m_pHolder->m_trFunction, &vsIndepVars);
	for ( ii = 0; ii < nIndepNum; ii++ )
	{
		if ( is_missing_value(vIndepValue[ii]) )
		{
			strErrMsg.Format(_L("%s is not a valid value for independent variable %s."), ftoa(vIndepValue[ii]), vsIndepVars[ii]);
			return FFW_EQUATION_INVALID_INDEPS;
		}
	}
	
	///Sophy 7/7/2010 ORG-432-S14 WARNING_MSG_WHEN_EVALUATE_WITH_TOO_MANY_INDEPS
	const int nMaxIndeps = 4;
	if ( nIndepNum > nMaxIndeps )
	{
		strErrMsg = _L("Evaluation supports no more than 4 indenpedent variables");
		return FFW_EQUATION_TOO_MANY_INDEPS;
	}
	///end WARNING_MSG_WHEN_EVALUATE_WITH_TOO_MANY_INDEPS
	return FFW_EQUATION_OK;
}
///end CHECK_EQUATION_PARAMS_SETTINGS

/*------------------------------------------------------------------------------*
 * FFWEquationPageBase End	 													*
 *------------------------------------------------------------------------------*/
 
///------ Folger 07/06/10 ORG-432-S13 CENTRALIZE_FUNCTION_BODY_PAGE_RESOURCES
class FFWFitFuncBodyPage;
class FFWFuncBodyBase
{
public:
	FFWFuncBodyBase(FFWFitFuncBodyPage* pPage, FFWFunctionOrganizer& funcOrganizer, TreeNode& trFunction)
	{
		m_pPage = pPage;
		m_pFuncOrganizer = &funcOrganizer;
		m_trFunction = trFunction;
		m_ctrlBody = GetItem(IDC_FIT_FUNC_FUNCTION_BODY_EDIT);
		m_ctrlBodyLabel = GetItem(IDC_FIT_FUNC_FUNCTION_BODY_EDIT_TEXT);
	}

	virtual	string	GetName()														{ return "FFWFuncBodyBase"; }
	virtual	string	GetTitle()														{ return GetName(); }
	virtual string	GetPageHintsName(bool bNextPage = false)						{ return bNextPage ? "Function next page" : ""; }
	virtual	void	UpdateControls();//		{}
	virtual	bool	UpdateTreeToPageGUI()											{ return true; }
	virtual	bool 	UpdatePageGUIToTree()											{ return true; }

	virtual void	OnContentChange()												{} /// Bill 07/08/2010 ORG-478-P4 CONTENT_MISS_AFTER_RETURN_DIALOG
	virtual	void	OpenCodeBuilder(Window& wndParent)								{}
	virtual	void	DerivativesCheck()												{}
	virtual	int		Compile(string& strErrMsg)														{ return FFW_EQUATION_OK; }	///Sophy 7/12/2010 ORG-518-P2 IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	virtual void	TreatNumberAsDoubleCheck()										{} /// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
	///Sophy 8/10/2010 ORG-745-P3 IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
	virtual	bool	IsRuntimeCheckEnable()											{ return false; }
	virtual	void	RuntimeCheck(string& strErrMsg)
	{
		if ( IsRuntimeCheckEnable() )
		{
#define	MAX_ERR_MSG_LENGTH	256
			LPSTR lpBuff = strErrMsg.GetBuffer(MAX_ERR_MSG_LENGTH);
			LT_get_last_err(lpBuff, MAX_ERR_MSG_LENGTH);
			LT_get_last_err(NULL, 0); //clear error message after retrieve.
			strErrMsg.ReleaseBuffer();
			if ( !strErrMsg.IsEmpty() )
				strErrMsg = "(" + strErrMsg + ")";
		}
	}		
	///end IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
	
	///Jasmine 08/10/10 ORG-745-P4 ALLOW_EXTERNAL_DLL_HAS_EMPTY_ANNOTATION
	virtual bool 	IsFormulaEssential(){return true;}
	///End ALLOW_EXTERNAL_DLL_HAS_EMPTY_ANNOTATION
	
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	virtual bool	IsShowIntegSettings(){return false;}	
	void			InitIntegControlPosition();
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
protected:
	Control			GetItem(int nID)
	{
		return m_pPage->GetItem(nID);
	}

	BOOL			ScreenToClient(RECT* lpRect)
	{
		return m_pPage->ScreenToClient(lpRect);
	}

	BOOL			GetClientRect(RECT& rr, Control ctrl)
	{
		ctrl.GetWindowRect(&rr);
		return ScreenToClient(&rr);
	}

	void			StringToEditText(const string & str, Edit & edit)
	{
		m_pPage->StringToEditText(str, edit);
	}

	void			EditTextToString(Edit & edit, string & str)
	{
		m_pPage->EditTextToString(edit, str);
	}

	RECT			UpdateBodyControl(Control& ctrlBody, RECT& rrBodyLabel)
	{
		int		nGap = ControlGap();
		
		RECT	rr;
		GetClientRect(rr, ctrlBody);
		rr.top = rrBodyLabel.bottom + nGap;
		rr.left = rrBodyLabel.left;
		ctrlBody.MoveWindow(&rr);

		return rr;
	}

	RECT			UpdateBodyLabelControl(Control& ctrlBodyLabel)
	{
		RECT	rrBodyLabel;
		GetClientRect(rrBodyLabel, ctrlBodyLabel);
		OffsetRect(&rrBodyLabel, m_pPage->FuncBodyPoint().x - rrBodyLabel.left, m_pPage->FuncBodyPoint().y - rrBodyLabel.top);
		ctrlBodyLabel.MoveWindow(&rrBodyLabel);
		return rrBodyLabel;
	}

	int				ControlGap()												{ return 5; }
	
	string			GetBodyLabel()
	{
		string	strAdvLabel = GetAdvBodyLabel();
		string	str;
		if ( strAdvLabel.IsEmpty() )
			str = GetBasicBodyLabel();
		else
			str.Format("%s (%s)", GetBasicBodyLabel(), strAdvLabel);
		return str;
	}
	virtual	string	GetBasicBodyLabel()		{ return _L("Function Body"); }
	virtual	string	GetAdvBodyLabel()
	{
		return _L("Dependent Variables") + " : " + m_pFuncOrganizer->GetDependVars(m_trFunction, ',');
	}
	
protected:
	FFWFunctionOrganizer*	m_pFuncOrganizer;
	TreeNode				m_trFunction;
	Control					m_ctrlBody;
	Control					m_ctrlBodyLabel;

private:
	FFWFitFuncBodyPage*		m_pPage;
};

///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
virtual	void	FFWFuncBodyBase::UpdateControls()
{
	m_pPage->CheckUpdateIntegControls();	
}

void			FFWFuncBodyBase::InitIntegControlPosition()
{
	TabControl tab =  GetItem(IDC_FIT_FUNC_PARAM_TAB);	
	RECT rTab;
	tab.GetWindowRect(&rTab);
	ScreenToClient(&rTab);
	tab.AdjustRect(FALSE, &rTab);	
	
	bool 	bMoveDown = false;
	int		nGap = 5;
	int 	width, height;
	RECT 	rr1;
	Control	ctrl;
	
	ctrl = GetItem(IDC_FIT_FUNC_INTEG_TEXT);
	if(ctrl)
	{
		GetClientRect(rr1, ctrl);
		width 	= RECT_WIDTH(rr1);
		height	= RECT_HEIGHT(rr1);
		rr1.left 	= rTab.left	+ nGap;
		rr1.top 	= rTab.top	+ nGap;
		rr1.bottom	= rr1.top	+ height;
		rr1.right 	= rr1.left 	+ width;
		ctrl.MoveWindow(&rr1);
		
		bMoveDown = true;
	}
	
	ctrl = GetItem(IDC_FIT_FUNC_APPEND_INTEG_TEXT);
	if(ctrl)
	{
		GetClientRect(rr1, ctrl);
		width 	= RECT_WIDTH(rr1);
		height	= RECT_HEIGHT(rr1);
		rr1.right 	= rTab.right- nGap;
		rr1.top 	= rTab.top 	+ nGap;
		rr1.bottom	= rr1.top 	+ height;
		rr1.left 	= rr1.right	- width;
		ctrl.MoveWindow(&rr1);
		
		bMoveDown = true;
	}
	
	if(bMoveDown)
	{
		rTab.top = rr1.bottom + nGap;
	}
	
	ctrl = GetItem(IDC_FIT_FUNC_INTEG_GRID);
	if(ctrl)
		ctrl.MoveWindow(&rTab);
}
///End CREATE_FITFUNC_WITH_INTEGRAL

class FFWExpression : public FFWFuncBodyBase
{
public:
	FFWExpression(FFWFitFuncBodyPage* pPage, FFWFunctionOrganizer& funcOrganizer, TreeNode& trFunction) : FFWFuncBodyBase(pPage, funcOrganizer, trFunction)
	{
		m_ctrlDependVar = GetItem(IDC_FIT_FUNC_EQUATION_LEFT_TEXT);
	}
	~FFWExpression()
	{
	}

	virtual	string	GetName()									{ return "FFWExpressionPage"; }
	virtual	string	GetTitle()									{ return _L("Expression Function"); }

	virtual string	GetPageHintsName(bool bNextPage = false)
	{
		if ( bNextPage )
			return FFWFuncBodyBase::GetPageHintsName(bNextPage);
		
		return "Single Expression";
	}

	virtual	void	UpdateControls()
	{
		m_ctrlBodyLabel.Text =GetBodyLabel();

		int		nGap = ControlGap();
		RECT	rrBodyLabel;
		rrBodyLabel = UpdateBodyLabelControl(m_ctrlBodyLabel);
		
		m_ctrlDependVar.Visible = TRUE;
		
		RECT	rr;
		GetClientRect(rr, m_ctrlDependVar);
		
		OffsetRect(&rr, rrBodyLabel.left - rr.left, rrBodyLabel.bottom + nGap - rr.top);
		m_ctrlDependVar.MoveWindow(&rr);
		
		RECT	rr1;
		GetClientRect(rr1, m_ctrlBody);
		rr1.top = rr.top;
		rr1.left = rr.right + nGap;
		m_ctrlBody.MoveWindow(&rr1);
		
		FFWFuncBodyBase::UpdateControls();		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	}

	virtual	bool	UpdateTreeToPageGUI()
	{
		string strEquation = m_pFuncOrganizer->GetFormula(m_trFunction);
		int nFound = strEquation.Find('=', 0);
		if ( nFound >= 0 )
			strEquation.Delete(0, nFound + 1);
		
		m_ctrlBody.Text = strEquation;
		
		m_ctrlDependVar.Text = m_pFuncOrganizer->GetDependVars(m_trFunction, ',') + "=";
		return true;
	}
	///Sophy 8/10/2010 ORG-745-P3 IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
	//virtual
	bool	IsRuntimeCheckEnable()											{ return true; }
	///end IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
	virtual	string	GetAdvBodyLabel()		{ return ""; }
	
	virtual bool	IsShowIntegSettings(){return true;}			///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	
protected:
private:
	Control		m_ctrlDependVar;
};

class FFWEquations : public FFWFuncBodyBase
{
public:
	FFWEquations(FFWFitFuncBodyPage* pPage, FFWFunctionOrganizer& funcOrganizer, TreeNode& trFunction) : FFWFuncBodyBase(pPage, funcOrganizer, trFunction)
	{
	}
	~FFWEquations()
	{
	}

	virtual	string	GetName()									{ return "FFWMultiEquationPage"; }
	virtual	string	GetTitle()									{ return _L("Multiple Equations"); }

	virtual string	GetPageHintsName(bool bNextPage = false)
	{
		if ( bNextPage )
			return FFWFuncBodyBase::GetPageHintsName(bNextPage);
		
		return "Multiple Equations";
	}

	virtual	void	UpdateControls()
	{
		m_ctrlBodyLabel.Text =GetBodyLabel();

		RECT	rrBodyLabel;
		rrBodyLabel = UpdateBodyLabelControl(m_ctrlBodyLabel);

		UpdateBodyControl(m_ctrlBody, rrBodyLabel);
		
		FFWFuncBodyBase::UpdateControls();		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	}

	virtual	bool	UpdateTreeToPageGUI()
	{
		string strFuncBody =  m_pFuncOrganizer->GetFormula(m_trFunction);
		StringToEditText(strFuncBody, m_ctrlBody);
		return true;
	}
	///Sophy 8/10/2010 ORG-745-P3 IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
	//virtual
	bool	IsRuntimeCheckEnable()											{ return true; }
	///end IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE

	///------ Folger 08/11/10 ORG-756-P3 BETTER_CHECKING_FOR_VALID_EQUATIONS
	virtual	int		Compile(string& strErrMsg)
	{
		string	strFuncBody;
		EditTextToString(m_ctrlBody, strFuncBody);
		
		NumericFunction nf(m_trFunction);
		if ( !nf.CheckEquations(strFuncBody, &strErrMsg) )
			return FFW_EQUATION_COMPILE_ERROR;

		return 0;
	}
	///------ End BETTER_CHECKING_FOR_VALID_EQUATIONS
	
	virtual bool	IsShowIntegSettings(){return true;}		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	
protected:
private:
};

class FFWLTOCBase : public FFWFuncBodyBase
{
public:
	FFWLTOCBase(FFWFitFuncBodyPage* pPage, FFWFunctionOrganizer& funcOrganizer, TreeNode& trFunction) : FFWFuncBodyBase(pPage, funcOrganizer, trFunction)
	{
		m_btnCheckDeriv = GetItem(IDC_FIT_FUNC_DERIVATIVES_CHECK);
	}
	~FFWLTOCBase()
	{
	}

	virtual	void	DerivativesCheck()
	{
		m_pFuncOrganizer->SetDerivative(m_btnCheckDeriv.Check, m_trFunction);
	}
protected:
	virtual	bool	UpdateTreeToPageGUI()
	{
		m_btnCheckDeriv.Check = m_pFuncOrganizer->IsDerivative(m_trFunction);
		return true;
	}
	
	virtual	bool 	UpdatePageGUIToTree()
	{
		string	strFuncBody;
		EditTextToString(m_ctrlBody, strFuncBody);
		
		m_pFuncOrganizer->SetDerivative(m_btnCheckDeriv.Check, m_trFunction);
		return true;
	}

	Button		m_btnCheckDeriv;
private:
};

class FFWLabtalk : public FFWLTOCBase
{
public:
	FFWLabtalk(FFWFitFuncBodyPage* pPage, FFWFunctionOrganizer& funcOrganizer, TreeNode& trFunction) : FFWLTOCBase(pPage, funcOrganizer, trFunction)
	{
	}
	~FFWLabtalk()
	{
	}

	virtual	string	GetName()									{ return "FFWLabtalkPage"; }
	virtual	string	GetTitle()									{ return _L("LabTalk Script Function"); }

	virtual string	GetPageHintsName(bool bNextPage = false)
	{
		if ( bNextPage )
			return FFWFuncBodyBase::GetPageHintsName(bNextPage);
		
		return "LabTalk Script Function";
	}

	virtual	void	UpdateControls()
	{
		m_ctrlBodyLabel.Text =GetBodyLabel();

		int		nGap = ControlGap();
		RECT	rrBodyLabel;
		rrBodyLabel = UpdateBodyLabelControl(m_ctrlBodyLabel);
		
		m_btnCheckDeriv.Visible = TRUE;
		
		RECT	rr;
		rr = UpdateBodyControl(m_ctrlBody, rrBodyLabel);

		RECT	rr1;
		GetClientRect(rr1, m_btnCheckDeriv);
		
		OffsetRect(&rr1, rr.right - rr1.right, rrBodyLabel.top - rr1.top);
		m_btnCheckDeriv.MoveWindow(&rr1);
		
		FFWFuncBodyBase::UpdateControls();		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL

	}
	
	///Sophy 8/10/2010 ORG-745-P3 IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
	//virtual
	bool	IsRuntimeCheckEnable()											{ return true; }
	///end IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
	
	virtual bool	IsShowIntegSettings(){return true;}			///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	
protected:
private:
};

class FFWOriginC : public FFWLTOCBase
{
public:
	FFWOriginC(FFWFitFuncBodyPage* pPage, FFWFunctionOrganizer& funcOrganizer, TreeNode& trFunction) : FFWLTOCBase(pPage, funcOrganizer, trFunction)
	{
		m_btnOpenCB = GetItem(IDC_FIT_FUNC_OPEN_CODE_BUILDER);
		m_btnTreatNumber = GetItem(IDC_FIT_FUNC_TREAT_NUMBER_CHECK); /// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
	}
	~FFWOriginC()
	{
	}

	virtual	string	GetName()									{ return "FFWOCFunctionPage"; }
	virtual	string	GetTitle()									{ return _L("Origin C Fitting Function"); }

	virtual string	GetPageHintsName(bool bNextPage = false)
	{
		if ( bNextPage )
			return FFWFuncBodyBase::GetPageHintsName(bNextPage);
		
		return "Origin C Fitting Function";
	}

	/// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
	virtual	bool	UpdateTreeToPageGUI()
	{
		if (!FFWLTOCBase::UpdateTreeToPageGUI())
			return false;
		
		m_btnTreatNumber.Check = m_pFuncOrganizer->IsTreatNumberAsDouble(m_trFunction);
		return true;
	}
	
	virtual void	TreatNumberAsDoubleCheck()
	{
		m_pFuncOrganizer->SetTreatNumberAsDouble(m_btnTreatNumber.Check, m_trFunction);		
	}
	
	/// Zech 09/02/2011 ORG-3610-P1 MAKE_TREAT_ALL_NUMBERS_AS_DOUBLES_EFFECTIVE_WITHOUT_CHECKBOX_MODIFIED
	virtual bool 	UpdatePageGUIToTree()
	{
		TreatNumberAsDoubleCheck();
		return FFWLTOCBase::UpdatePageGUIToTree();
	}
	/// END MAKE_TREAT_ALL_NUMBERS_AS_DOUBLES_EFFECTIVE_WITHOUT_CHECKBOX_MODIFIED
	/// End TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION

	virtual	void	UpdateControls()
	{
		m_ctrlBodyLabel.Text =GetBodyLabel();
		
		int		nGap = ControlGap();
		RECT	rrBodyLabel;
		rrBodyLabel = UpdateBodyLabelControl(m_ctrlBodyLabel);
		
		m_btnCheckDeriv.Visible = TRUE;
		m_btnOpenCB.Visible = TRUE;
		m_btnTreatNumber.Visible = TRUE; /// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION

		RECT	rr;
		rr = UpdateBodyControl(m_ctrlBody, rrBodyLabel);
		
		RECT	rr1;
		GetClientRect(rr1, m_btnCheckDeriv);
		
		RECT	rr2;
		GetClientRect(rr2, m_btnOpenCB);

		OffsetRect(&rr2, rr.right - rr2.right, rrBodyLabel.top - rr2.top - nGap);
		m_btnOpenCB.MoveWindow(&rr2);		

		OffsetRect(&rr1, rr2.left - rr1.left - RECT_WIDTH(rr1), rrBodyLabel.top - rr1.top);
		m_btnCheckDeriv.MoveWindow(&rr1);

		/// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
		RECT	rr3;
		GetClientRect(rr3, m_btnTreatNumber);

		OffsetRect(&rr3, rr1.left - rr3.left - RECT_WIDTH(rr3), rrBodyLabel.top - rr3.top);
 		m_btnTreatNumber.MoveWindow(&rr3);
		/// End TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
	
		FFWLTOCBase::UpdateControls();		///Jasmine 10/20/2011 ORG-3484-P3 OTHER_FUNC_TYPE_SHOULD_HIDE_INTEGRAL_CONTROLS
	}

	virtual	void	OpenCodeBuilder(Window& wndParent)
	{
		string	strFuncBody;
		EditTextToString(m_ctrlBody, strFuncBody);		
		m_pFuncOrganizer->SetFormula(strFuncBody, m_trFunction);
		Functions.EditFunctionInCodeBuilder(m_trFunction, wndParent);
	}

	/// Bill 07/08/2010 ORG-478-P4 CONTENT_MISS_AFTER_RETURN_DIALOG
	virtual void	OnContentChange()
	{
		string strFuncBody = m_pFuncOrganizer->GetFormula(m_trFunction);
		StringToEditText(strFuncBody, m_ctrlBody);
	}
	/// End CONTENT_MISS_AFTER_RETURN_DIALOG
	///Sophy 7/12/2010 ORG-518-P2 IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	//virtual
	int		Compile(string& strErrMsg)
	{
		string	strFuncBody;
		EditTextToString(m_ctrlBody, strFuncBody);		
		m_pFuncOrganizer->SetFormula(strFuncBody, m_trFunction);
		
		NumericFunction nf(m_trFunction);
		if ( !nf.CheckCompileOC() )
		{
			///Sophy 7/8/2010 ORG-518-P7 IMPROVE_OC_COMPILE_ERR_MSG_ON_QUICK_CHECK
			//ocu_load_msg_str(NLSF_ERR_COMPILE_NUMERIC_FUNCTION, &strErrMsg);
			strErrMsg = _L("Compile error. Click the Open Code Builder button for details");
			///end IMPROVE_OC_COMPILE_ERR_MSG_ON_QUICK_CHECK
			return FFW_EQUATION_COMPILE_ERROR;
		}

	}
protected:
private:
	Button		m_btnOpenCB;
	Button		m_btnTreatNumber; /// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
};

class FFWExternalDLL : public FFWFuncBodyBase
{
public:
	FFWExternalDLL(FFWFitFuncBodyPage* pPage, FFWFunctionOrganizer& funcOrganizer, TreeNode& trFunction) : FFWFuncBodyBase(pPage, funcOrganizer, trFunction)
	{
		m_ctrlDLLFileLabel = GetItem(IDC_FIT_FUNC_DLL_FILE_EDIT_TEXT);
		m_ctrlDLLFuncLabel = GetItem(IDC_FIT_FUNC_DLL_FUNC_EDIT_TEXT);
		m_edDLLFile = GetItem(IDC_FIT_FUNC_DLL_FILE_EDIT);
		m_edDLLFunc = GetItem(IDC_FIT_FUNC_DLL_FUNC_EDIT);
	}
	~FFWExternalDLL()
	{
	}

	virtual	string	GetName()									{ return "FFWExternalDLLPage"; }
	virtual	string	GetTitle()									{ return _L("External DLL"); }

	virtual string	GetPageHintsName(bool bNextPage = false)
	{
		if ( bNextPage )
			return FFWFuncBodyBase::GetPageHintsName(bNextPage);
			
		return "External DLL";
	}

	virtual	void	UpdateControls()
	{
		m_ctrlBodyLabel.Text =GetBodyLabel();
		
		int		nGap = ControlGap();
		RECT	rrBodyLabel;
		rrBodyLabel = UpdateBodyLabelControl(m_ctrlBodyLabel);

		m_ctrlDLLFileLabel.Visible = TRUE;
		m_ctrlDLLFuncLabel.Visible = TRUE;
		m_edDLLFile.Visible = TRUE;
		m_edDLLFunc.Visible = TRUE;

		RECT	rrDLLFileLabel;
		GetClientRect(rrDLLFileLabel, m_ctrlDLLFileLabel);

		RECT	rrDLLFuncLabel;
		GetClientRect(rrDLLFuncLabel, m_ctrlDLLFuncLabel);

		RECT	rrDLLFile;
		GetClientRect(rrDLLFile, m_edDLLFile);

		RECT	rrDLLFunc;
		GetClientRect(rrDLLFunc, m_edDLLFunc);

		OffsetRect(&rrDLLFileLabel, rrBodyLabel.left - rrDLLFileLabel.left, rrBodyLabel.top - rrDLLFileLabel.top);
		m_ctrlDLLFileLabel.MoveWindow(&rrDLLFileLabel);

		OffsetRect(&rrDLLFile, rrDLLFileLabel.left - rrDLLFile.left + RECT_WIDTH(rrDLLFileLabel) + nGap, rrBodyLabel.top - rrDLLFile.top - nGap);
		m_edDLLFile.MoveWindow(&rrDLLFile);

		OffsetRect(&rrDLLFuncLabel, rrDLLFile.left - rrDLLFuncLabel.left + RECT_WIDTH(rrDLLFile) + nGap, rrBodyLabel.top - rrDLLFuncLabel.top);
		m_ctrlDLLFuncLabel.MoveWindow(&rrDLLFuncLabel);

		OffsetRect(&rrDLLFunc, rrDLLFuncLabel.left - rrDLLFunc.left + RECT_WIDTH(rrDLLFuncLabel) + nGap, rrBodyLabel.top - rrDLLFunc.top - nGap);
		m_edDLLFunc.MoveWindow(&rrDLLFunc);
		
		OffsetRect(&rrBodyLabel, 0, rrDLLFileLabel.bottom + nGap - rrBodyLabel.top);
		m_ctrlBodyLabel.MoveWindow(&rrBodyLabel);
		
		UpdateBodyControl(m_ctrlBody, rrBodyLabel);
		
		FFWFuncBodyBase::UpdateControls();		///Jasmine 10/20/2011 ORG-3484-P3 OTHER_FUNC_TYPE_SHOULD_HIDE_INTEGRAL_CONTROLS
	}

	///Jasmine 08/02/10 ORG-591-P7 DETECH_EXTERNAL_DLL_SOURCE
	virtual int		Compile(string& strErrMsg)
	{
		if( m_edDLLFile.Text.IsEmpty() || m_edDLLFunc.Text.IsEmpty() )
		{
			//strErrMsg.Format("%s or %s cannot be empty.", m_ctrlDLLFileLabel.Text, m_ctrlDLLFuncLabel.Text);
			ocu_load_msg_str(FFWERR_ST_CANNOT_BE_EMPTY_EX, &strErrMsg, m_ctrlDLLFileLabel.Text, NULL, m_ctrlDLLFuncLabel.Text);
			return FFW_EQUATION_EMPTY_DLL;
		}
		
		return FFWFuncBodyBase::Compile(strErrMsg);
	}
	///End DETECH_EXTERNAL_DLL_SOURCE
	
	virtual	bool	UpdateTreeToPageGUI()
	{
		string strSource = m_pFuncOrganizer->GetSource(m_trFunction);
		if ( strSource.Compare(STR_NO_DLL_SOURCE) == 0 )
			strSource = "";
		
		int nIndex = strSource.Find('.');
		string strDll = strSource.Left(nIndex);
		string strFunc = strSource.Right(strSource.GetLength() - 1 - nIndex);
		
		m_edDLLFile.Text  = strDll;
		m_edDLLFunc.Text = strFunc;
		return true;
	}

	virtual	bool 	UpdatePageGUIToTree()
	{
		string	strSource;
		if ( lstrlen(m_edDLLFile.Text) == 0 || lstrlen(m_edDLLFunc.Text) == 0 )
			strSource = STR_NO_DLL_SOURCE;
		else
			strSource = m_edDLLFile.Text + "." + m_edDLLFunc.Text;
		
		m_pFuncOrganizer->SetSource(strSource, m_trFunction);
		return true;
	}
	
	///Jasmine 08/10/10 ORG-745-P4 ALLOW_EXTERNAL_DLL_HAS_EMPTY_ANNOTATION
	virtual bool 	IsFormulaEssential(){return false;}
	///End ALLOW_EXTERNAL_DLL_HAS_EMPTY_ANNOTATION
	
protected:
	virtual	string	GetBasicBodyLabel()												{ return _L("Annotation"); }

private:
	Control		m_ctrlDLLFileLabel;
	Control		m_ctrlDLLFuncLabel;
	Edit		m_edDLLFile;
	Edit		m_edDLLFunc;
};

#define		ON_FFW_EVALUATE_PAGE_MSGS \
			PAGE_ON_INIT(OnInitPage) \
			PAGE_ON_ACTIVE(OnActivatePage) \
			PAGE_ON_KILLACTIVE(OnKillActiviePage) \
			PAGE_ON_NEXT(OnNext) \
			PAGE_ON_BACK(OnBack) \
			\
			ON_BN_CLICKED(FFW_EVALUATE_BTN, OnEvaluateClick)\
			\
			ON_GRID_AFTER_EDIT(IDC_FIT_FUNC_PARAM_GRID, OnAfterEditParaControl)\
			\
			ON_TAB_SEL_CHANGE(IDC_FIT_FUNC_PARAM_TAB, OnTabChange)

class FFWFitFuncBodyPage : public FFWPageBase
{
public:
	FFWFitFuncBodyPage(int nID = 0);
	~FFWFitFuncBodyPage();

	EVENTS_BEGIN
		ON_FFW_EVALUATE_PAGE_MSGS
		///Sophy 7/8/2010 ORG-518-P6 DISABLE_EDIT_PARAM_AND_CONSTANT_NAME
		ON_GRID_BEFORE_EDIT(IDC_FIT_FUNC_PARAM_GRID, OnBeforeEditParaControl)
		ON_GRID_BEFORE_EDIT(IDC_FIT_FUNC_CONSTANT_GRID, OnBeforeEditParaControl)
		ON_GRID_AFTER_EDIT(IDC_FIT_FUNC_CONSTANT_GRID, OnAfterEditParaControl)	///Sophy 7/12/2010 ORG-518-P3 TRIM_PARAM_VALUE_AND_CONSTANT_BEFORE_SAVE
		//end DISABLE_EDIT_PARAM_AND_CONSTANT_NAME
		ON_GRID_BEFORE_MOUSE_DOWN(IDC_FIT_FUNC_PARAM_GRID, OnBeforeMouseDownParaControl)			///Jasmine 12/16/10 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
		
		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
		ON_GRID_BEFORE_EDIT(IDC_FIT_FUNC_INTEG_GRID, OnBeforeEditParaControl)
		ON_GRID_AFTER_EDIT(IDC_FIT_FUNC_INTEG_GRID, OnAfterEditParaControl)
		ON_BN_CLICKED(IDC_FIT_FUNC_APPEND_INTEG_TEXT, OnAppendTextToFuncBody);
		///End CREATE_FITFUNC_WITH_INTEGRAL
		
		ON_BN_CLICKED(IDC_FIT_FUNC_OPEN_CODE_BUILDER, OnOpenCodeBuilder);
		///Jasmine 07/29/10 ORG-591-P7 FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
		ON_EN_KILLFOCUS(IDC_FIT_FUNC_FUNCTION_BODY_EDIT, OnFunctionBodyChange)
		ON_EN_KILLFOCUS(IDC_FIT_FUNC_DLL_FILE_EDIT, OnFunctionBodyChange)
		ON_EN_KILLFOCUS(IDC_FIT_FUNC_DLL_FUNC_EDIT, OnFunctionBodyChange)
		///End FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
		ON_BN_CLICKED(IDC_FIT_FUNC_DERIVATIVES_CHECK, OnDerivativesCheck);
		ON_BN_CLICKED(IDC_FIT_FUNC_TREAT_NUMBER_CHECK, OnTreatNumberAsDouble); /// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
		ON_CONTEXTMENU(OnContextMenu)	///Sophy 3/2/2012 ORG-4478-P7 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	EVENTS_END

	POINT&			FuncBodyPoint()		{ return m_ptFuncBody; }
	void			OnContentChange(); /// Bill 07/08/2010 ORG-478-P4 CONTENT_MISS_AFTER_RETURN_DIALOG
	BOOL 			OnTabChange(Control ctrl);
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	void 			InitIntegControls();
	void			ShowIntegControls(bool bShow);
	void			CheckUpdateIntegControls();
	void 			IntegTableToFormula();
	void 			FormulaToIntegTable();
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
protected:

	virtual BOOL	OnInitPage();
	virtual	BOOL	OnActivatePage();
	virtual	BOOL	OnNext();
	BOOL 			OnEvaluateClick(Control ctrl);
	void			OnBeforeEditParaControl(Control flxControl, int nRow, int nCol, BOOL* pCancel);	///Sophy 7/8/2010 ORG-518-P6 DISABLE_EDIT_PARAM_AND_CONSTANT_NAME
	void  			OnAfterEditParaControl(Control flxControl, int nRow, int nCol);
	void 			OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);	///Jasmine 12/16/10 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
	///Sophy 3/2/2012 ORG-4478-P7 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	BOOL			OnContextMenu(UINT nResIDCtrl, int nx, int ny);
	///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	void			OnOpenCodeBuilder(Control ctrl);
	BOOL			OnFunctionBodyChange(Control ctrl);	///Jasmine 07/29/10 ORG-591-P7 FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
	void			OnDerivativesCheck(Control ctrl);
	void			OnTreatNumberAsDouble(Control ctrl); /// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
	void			OnAppendTextToFuncBody(Control ctrl); 		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	bool			InitGridConstant();
	bool			InitGridParam();
	bool			InitTabControls();	

	virtual bool 	UpdateTreeToPageGUI(const TreeNode& trFunction);
	virtual bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	/// Bill 07/12/2010	ADD_PEAK_FUNC_AND_QUICK_CHECK_HINT
	virtual string	GetPageHints(bool bNextPage = false);
	/// End ADD_PEAK_FUNC_AND_QUICK_CHECK_HINT

	virtual string	GetPageHintsName(bool bNextPage = false);
	
	bool 			evaluateDependentVar();	
	int				getIndepVarsVal(vector& vv);	
	int				CheckEquation(string& strErrMsg);
	void			HideAllFuncBodyControls();

	void			UpdateTitle();
	void			UpdateControls();
private:
	void			UpdateFuncBody();
	
	void			checkEnableFinishBtn();	///Jasmine 07/29/10 ORG-591-P7 FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
	
protected:
	FFWParamSetting 		m_FFWParamGrid;
	FFWConstantSetting 		m_gridConstant;
	FFWIntegSetting			m_gridInteg;					///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	TabControl				m_tabParameter;
	
	Control					m_controlDependVar;
	Edit					m_editEquation;

	FFWFuncBodyBase*		m_pFuncBody;

	POINT					m_ptFuncBody;
};

FFWFitFuncBodyPage::FFWFitFuncBodyPage(int nID/* = 0*/) : FFWPageBase(nID)
{
	m_pFuncBody = NULL;
}
FFWFitFuncBodyPage::~FFWFitFuncBodyPage()
{
	NICE_SAFE_REMOVAL(m_pFuncBody);
}

/// virtual
BOOL FFWFitFuncBodyPage::OnInitPage()
{	
	m_controlDependVar = GetItem(IDC_FIT_FUNC_DEPEND_VAR);

	if ( !InitGridConstant() || !InitGridParam() || !InitTabControls() )
		return FALSE;
	                 
	m_editEquation = GetItem(IDC_FIT_FUNC_FUNCTION_BODY_EDIT);

	Control	ctrlEquationLabel = GetItem(IDC_FIT_FUNC_FUNCTION_BODY_EDIT_TEXT);
	RECT		rr;
	ctrlEquationLabel.GetWindowRect(&rr);
	ScreenToClient(&rr);
	m_ptFuncBody.x = rr.left;
	m_ptFuncBody.y = rr.top;	
	
	BitmapRadioButton btnEvaluate = GetItem(FFW_EVALUATE_BTN);
	vector<string> vsTips(1);
	vsTips[0] = _L("Evaluate");
	btnEvaluate.Init(1, IDB_APPLY_BTN, 16, vsTips);

	BitmapRadioButton btnOpenCB = GetItem(IDC_FIT_FUNC_OPEN_CODE_BUILDER);
	vsTips[0] = _L("Open Code Builder");
	btnOpenCB.Init(1, IDB_OPEN_CB, 16, vsTips);	
	
	FFWPageBase::OnInitPage();
	
	return TRUE;
}

/// virtual
BOOL	FFWFitFuncBodyPage::OnActivatePage()
{
	UpdateFuncBody();
	UpdateTitle();
	UpdateControls();
	BOOL bRet =  FFWPageBase::OnActivatePage();
	
	m_controlDependVar.Text = "";
	///Jasmine 07/29/10 ORG-591-P7 FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
	checkEnableFinishBtn();
	///End FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR

	/// Iris 6/08/2012 ORG-5896-P1 DISABLE_EVALUATE_CONTROLS_FOR_IMPLICIT_FUNC
	/// Iris 7/30/2012 ORG-5896-P1 DISABLE_EVALUATE_CONTROLS_FOR_IMPLICIT_FUNC_MORE
	/*
	bool bImplicit = nlsf_is_implicit_func(FuncOrganizer().GetFunctionModel(m_pHolder->m_trFunction));
	GetItem(IDC_FIT_FUNC_QUICK_CHECK_GROUP).Enable = 	
	GetItem(FFW_EVALUATE_BTN).Enable = 	
	GetItem(IDC_FIT_FUNC_INDEPEND_VAR1).Enable = 
	GetItem(IDC_FIT_FUNC_INDEPEND_VAR2).Enable = 
	GetItem(IDC_FIT_FUNC_INDEPEND_VAR3).Enable = 
	GetItem(IDC_FIT_FUNC_INDEPEND_VAR_VALUE1).Enable = 
	GetItem(IDC_FIT_FUNC_INDEPEND_VAR_VALUE2).Enable = 
	GetItem(IDC_FIT_FUNC_INDEPEND_VAR_VALUE3).Enable = 
	!bImplicit;	
	*/
	///End DISABLE_EVALUATE_CONTROLS_FOR_IMPLICIT_FUNC_MORE
	///End DISABLE_EVALUATE_CONTROLS_FOR_IMPLICIT_FUNC
	
	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	Window	wnd(m_pHolder->GetDlgHwnd());
	wnd.PostMessage(WM_FFW_USER_MSG_RESTORE_PAGE_SIZE);
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	return bRet;
}

#define		NEW_FUNCBODY_ARGUMENTS		this, FuncOrganizer(), m_pHolder->m_trFunction
void	FFWFitFuncBodyPage::UpdateFuncBody()
{
	NICE_SAFE_REMOVAL(m_pFuncBody);

	TreeNode	trFunction = m_pHolder->m_trFunction;

	string		strType = FuncOrganizer().GetType(trFunction);
	if ( strType.Compare(STR_FUNCTION_TYPE_EXTERN_DLL) == 0 )
	{
		m_pFuncBody = new FFWExternalDLL(NEW_FUNCBODY_ARGUMENTS);
	}
	else
	{
		string strForm = FuncOrganizer().GetForm(trFunction);
		
		if ( strForm.Compare(STR_FUNCTION_FORM_EXPRESSION) == 0 )
			m_pFuncBody = new FFWExpression(NEW_FUNCBODY_ARGUMENTS);
		else if ( strForm.Compare(STR_FUNCTION_FORM_EQUATIONS) == 0 )
			m_pFuncBody = new FFWEquations(NEW_FUNCBODY_ARGUMENTS);
		else if ( strForm.Compare(STR_FUNCTION_FORM_Y_SCRIPT) == 0 )
			m_pFuncBody = new FFWLabtalk(NEW_FUNCBODY_ARGUMENTS);
		else if ( strForm.Compare(STR_FUNCTION_FORM_ORIGIN_C) == 0 )
			m_pFuncBody = new FFWOriginC(NEW_FUNCBODY_ARGUMENTS);
		else
			m_pFuncBody = new FFWExpression(NEW_FUNCBODY_ARGUMENTS);
	}
}

BOOL FFWFitFuncBodyPage::OnEvaluateClick(Control ctrl)
{
	return evaluateDependentVar();
}

///Sophy 7/8/2010 ORG-518-P6 DISABLE_EDIT_PARAM_AND_CONSTANT_NAME
void FFWFitFuncBodyPage::OnBeforeEditParaControl(Control flxControl, int nRow, int nCol, BOOL* pCancel)
{

	if ( GetDlgCtrlID(flxControl.GetSafeHwnd()) == GetDlgCtrlID(m_FFWParamGrid.GetCtrnlSafeHwnd()) ) //param grid
	{
		if ( NLPARAMGRIDCOLTYPE_NAME == nCol && pCancel )
		{
			*pCancel = TRUE;
		}
		///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
		else
			m_FFWParamGrid.OnBeforeEditParaControl(flxControl, nRow, nCol, pCancel);
		///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
		
	}
	else if ( GetDlgCtrlID(flxControl.GetSafeHwnd()) == GetDlgCtrlID(m_gridConstant.GetCtrnlSafeHwnd()) ) //constant grid
	{
		if ( CONSTANT_VARIABLE_COLUMN == nCol && pCancel )
		{
			*pCancel = TRUE;
		}
	}
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	else if ( GetDlgCtrlID(flxControl.GetSafeHwnd()) == GetDlgCtrlID(m_gridInteg.GetCtrnlSafeHwnd()) ) //integrand grid
	{
		if ( INTEG_ELEMENT_COLUMN == nCol && pCancel )
		{
			*pCancel = TRUE;
		}
	}
	///End CREATE_FITFUNC_WITH_INTEGRAL
}
///end DISABLE_EDIT_PARAM_AND_CONSTANT_NAME

///Jasmine 07/29/10 ORG-591-P7 FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
void FFWFitFuncBodyPage::checkEnableFinishBtn()
{
	bool bEnable = true;
	
	///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	bEnable = !FuncOrganizer().HasDerivedParameters(m_pHolder->m_trFunction);
	if(bEnable)
	///End NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	{
		string strErrMsg;
		int nErr = CheckEquation(strErrMsg);
		if ( nErr == FFW_EQUATION_INVALID_CONTANT || nErr == FFW_EQUATION_COMPILE_ERROR || nErr == FFW_EQUATION_PEAK_ATTRIB_ERROR || nErr == FFW_EQUATION_EMPTY_FORMULA 
			 || nErr == FFW_EQUATION_EMPTY_DLL		///Jasmine 08/02/10 ORG-591-P7 DETECH_EXTERNAL_DLL_SOURCE
			 || nErr == FFW_HAS_NO_INTEGLT)		///Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG
			bEnable = false;
	}
	m_pHolder->EnableFinishButton(bEnable);
}

BOOL FFWFitFuncBodyPage::OnFunctionBodyChange(Control ctrl)
{
	checkEnableFinishBtn();
	
	return TRUE;
}
///End FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR

///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
#define TRIM_EDIT_CELL_VALUE(_COL, _GRID)				\
	if ( _COL == nCol )									\
	{													\
		string strValue = _GRID.GetCell(nRow, nCol);	\
		TRIM_STR(strValue);								\
		_GRID.SetCell(nRow, nCol, strValue);			\
	}
///End CREATE_FITFUNC_WITH_INTEGRAL

void  FFWFitFuncBodyPage::OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
{
	///Sophy 7/12/2010 ORG-518-P3 TRIM_PARAM_VALUE_AND_CONSTANT_BEFORE_SAVE
	//since we do NOT allow editing parameters and constants on the grids, this code is not needed any more.
	//if (NLPARAMGRIDCOLTYPE_NAME == nCol)
	//{
		//vector<string> vsNames;
//
		//m_FFWParamGrid.GetColValues(NLPARAMGRIDCOLTYPE_NAME, vsNames);
//
		//string strNew = vsNames[nRow];
//
		//vsNames.RemoveAt(nRow);
		//vsNames.RemoveAt(0);
//
		//if ( vsNames.Find(strNew) != -1)
		//{
			//string strErrMsg;
//
			//strErrMsg.Format(_L("The parameter %s already exists"), strNew);
//
			//MessageBox(strErrMsg, STR_ERROR, MB_OK);
//
			//string strDummy("");
//
			//m_FFWParamGrid.SetCell(nRow, nCol, strDummy);			
		//}
	//}
//
	//m_FFWParamGrid.OnAfterEdit(flxControl, nRow, nCol);
	if ( GetDlgCtrlID(flxControl.GetSafeHwnd()) == GetDlgCtrlID(m_FFWParamGrid.GetCtrnlSafeHwnd()) ) //param grid
	{
		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
		//if ( NLPARAMGRIDCOLTYPE_VALUE == nCol )
		//{
			//string strValue = m_FFWParamGrid.GetCell(nRow, nCol);
			//TRIM_STR(strValue);
			//m_FFWParamGrid.SetCell(nRow, nCol, strValue);
		//}
		TRIM_EDIT_CELL_VALUE(NLPARAMGRIDCOLTYPE_VALUE, m_FFWParamGrid)
		///End CREATE_FITFUNC_WITH_INTEGRAL

		/// Bill 07/15/2010 ORG-576-S1 MOVE_TO_NEXT_ROW_IF_USER_PRESS_ENTER
		m_FFWParamGrid.OnAfterEdit(nRow, nCol);
		/// MOVE_TO_NEXT_ROW_IF_USER_PRESS_ENTER
	}
	else if ( GetDlgCtrlID(flxControl.GetSafeHwnd()) == GetDlgCtrlID(m_gridConstant.GetCtrnlSafeHwnd()) ) //constant grid
	{
		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
		//if ( CONSTANT_VALUE_COLUMN == nCol )
		//{
			//string strValue = m_gridConstant.GetCell(nRow, nCol);
			//TRIM_STR(strValue);
			//m_gridConstant.SetCell(nRow, nCol, strValue);
		//}
		TRIM_EDIT_CELL_VALUE(CONSTANT_VALUE_COLUMN, m_gridConstant)
		///End CREATE_FITFUNC_WITH_INTEGRAL
		
		/// Bill 07/15/2010 ORG-576-S1 MOVE_TO_NEXT_ROW_IF_USER_PRESS_ENTER
		m_gridConstant.OnAfterEdit(nRow, nCol);
		/// End MOVE_TO_NEXT_ROW_IF_USER_PRESS_ENTER
	}
	///end TRIM_PARAM_VALUE_AND_CONSTANT_BEFORE_SAVE
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	else if ( GetDlgCtrlID(flxControl.GetSafeHwnd()) == GetDlgCtrlID(m_gridInteg.GetCtrnlSafeHwnd()) ) //integrand grid
	{
		TRIM_EDIT_CELL_VALUE(INTEG_VALUE_COLUMN, m_gridInteg)
		IntegTableToFormula();
		m_gridInteg.OnAfterEdit(nRow, nCol);
	}
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
	///------ Tony 09/05/2012 ORG-6725-P1 ADD_UPDATEPAGEGUITOTREE_FUNC
	TreeNode trFunction = m_pHolder->m_trFunction;
	UpdatePageGUIToTree(trFunction);
	///------ End ADD_UPDATEPAGEGUITOTREE_FUNC
	
	///Jasmine 07/29/10 ORG-591-P7 FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
	checkEnableFinishBtn();
	///End FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
}

///Jasmine 12/17/10 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
void FFWFitFuncBodyPage::OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
///Sophy 3/2/2012 ORG-4478-P7 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
{
	return;
	//make beforemousedown do nothing.
}
BOOL	FFWFitFuncBodyPage::OnContextMenu(UINT nResIDCtrl, int nx, int ny)
///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
{
	///Sophy 3/2/2012 ORG-4478-P7 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//if( nButton != MK_RBUTTON )
	//	return;
	if ( IDC_FIT_FUNC_PARAM_GRID != nResIDCtrl )
		return FALSE;
	///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	int nRow, nCol, nX, nY;
	///Sophy 3/2/2012 ORG-4478-P7 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//m_FFWParamGrid.GetMousePixel( X, Y, nRow, nCol, nX, nY );
	m_FFWParamGrid.GetMouseCell(nRow, nCol);
	nX = nx;
	nY = ny;
	///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	if ( NLPARAMGRIDCOLTYPE_VALUE == nCol
		|| NLPARAMGRIDCOLTYPE_UB == nCol
		|| NLPARAMGRIDCOLTYPE_LB == nCol)
	{
		vector<string>	vsItem;
		vector<byte>  	vbShow;
		vector<bool>	vbDisable;
		vector<int>		vnChoiceContextMenu;
		DWORD			dwCntrl = 0;
		dwCntrl |= CM_CNTRL_NO_APPLT_TO_ALL;
		m_FFWParamGrid.GetItemContextMenu(nRow, nCol, vsItem, vbShow, vbDisable, vnChoiceContextMenu, dwCntrl);
		if ( 0 == vsItem.GetSize() )
			return FALSE;
		
		//only Format Cells...
		if( lstrcmp(vsItem[0], STR_GRID_FORMAT_CELLS + STR_THREE_DOTS) != 0 )
			return FALSE;
		int nOnlyOneFormatCells = 1;
		vbShow.SetSize(nOnlyOneFormatCells);
		vsItem.SetSize(nOnlyOneFormatCells);
		vbDisable.SetSize(nOnlyOneFormatCells);
		
		
		CheckMenu 	MyMenu( vbShow, vsItem, vbDisable );				
		int nChoice = MyMenu.DoTrackPopup( nX, nY, m_FFWParamGrid.GetDlgSafeHwnd() );
		if(0 != nChoice)
			return FALSE;
		
		int nRet = m_FFWParamGrid.OnItemContextMenu(nRow, nCol, vnChoiceContextMenu[nChoice]);
		///------ Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
		//if(nRet & NLDLGPART_PARAMETERS_GRID)
		if ( O_QUERY_BOOL(nRet, NLDLGPART_PARAMETERS_GRID | NLDLGPART_PARAMETERS_DISPLAY) )
		///------ End PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
			m_FFWParamGrid.Update(false);
	}
	return TRUE;	///Sophy 3/2/2012 ORG-4478-P7 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
}
///End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS

BOOL FFWFitFuncBodyPage::OnTabChange(Control ctrl)
{
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	//bool bParamTab = FFW_PARAM_TAB == m_tabParameter.GetCurSel();
	//m_FFWParamGrid.SetVisible(bParamTab);
	//m_gridConstant.SetVisible(!bParamTab);
	int nCurSel = m_tabParameter.GetCurSel();
	m_FFWParamGrid.SetVisible(FFW_PARAM_TAB == nCurSel);
	m_gridConstant.SetVisible(FFW_CONST_TAB == nCurSel);	
	ShowIntegControls(FFW_INTEG_TAB == nCurSel);
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
	SetHints(GetPageHints());		///Jasmine 08/16/2011 ORG-3484-S3-3 DIFF_TAB_HAS_DIFF_HINT
	return TRUE;
}

///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
void 	FFWFitFuncBodyPage::InitIntegControls()
{
	//---Jasmine 09/19/2011 ORG-3484-P2 misspells 
	//m_tabParameter.InsertItem(FFW_INTEG_TAB, _L("Integand"));
	m_tabParameter.InsertItem(FFW_INTEG_TAB, _L("Integrand"));
	//---End
	m_gridInteg.Init(IDC_FIT_FUNC_INTEG_GRID, *this);	

	m_pFuncBody->InitIntegControlPosition();
}

void	FFWFitFuncBodyPage::ShowIntegControls(bool bShow)
{
	vector<int> vnIDs = {IDC_FIT_FUNC_INTEG_TEXT, IDC_FIT_FUNC_APPEND_INTEG_TEXT, IDC_FIT_FUNC_INTEG_GRID};
	for(int ii = 0; ii < vnIDs.GetSize(); ii++)
	{
		Control ctrl = GetItem( vnIDs[ii] );
		if(ctrl)
			ctrl.Visible = bShow;
	}
}

#define _IS_PAGE_HAS_INTEG_CONTROLS	\
	int nRet = FuncOrganizer().ReadTempWithIntegState(trFunction);	\
	if( m_pFuncBody->IsShowIntegSettings() && nRet == 1)
		
void	FFWFitFuncBodyPage::CheckUpdateIntegControls()
{		
	TreeNode trFunction = m_pHolder->m_trFunction;
	_IS_PAGE_HAS_INTEG_CONTROLS
	{int nJunk = 0; }
	else
	{
		if(m_tabParameter.GetItemCount() == FFW_INTEG_TAB+1)
		{
			int nCurSel = m_tabParameter.GetCurSel();
			m_tabParameter.DeleteItem(FFW_INTEG_TAB);
			if(nCurSel == FFW_INTEG_TAB)
			{
				m_tabParameter.SetCurSel(0);//first tab
				OnTabChange(m_tabParameter);
			}
		}
		return;
	}
	
	if(m_tabParameter.GetItemCount() != FFW_INTEG_TAB)
	{
		ASSERT(m_tabParameter.GetItemCount() == FFW_INTEG_TAB+1);
	}
	else
	{
		InitIntegControls();		
		m_tabParameter.SetCurSel(FFW_INTEG_TAB);	///Jasmine 08/10/2011 ORG-3484-S3-1 SET_INTEG_TAB_ACTIVE
	}

	int nCurSel = m_tabParameter.GetCurSel();
	if(nCurSel == FFW_INTEG_TAB)
		OnTabChange(m_tabParameter);
}	

void FFWFitFuncBodyPage::IntegTableToFormula()
{
	vector<string> vsVars;
	m_gridInteg.GetColValues(INTEG_VALUE_COLUMN, vsVars, m_gridInteg.GetRowOffset());		
	string strVars = str_combine(vsVars, " ,");
	
	string strIntegText;
	Control ctrlIntegText = GetItem(IDC_FIT_FUNC_INTEG_TEXT);
	if(ctrlIntegText)
		strIntegText = ctrlIntegText.Text;
	
	int nIntegralLTPos = FuncOrganizer().IntegralLTPos(strIntegText);
	if(nIntegralLTPos >= 0)		
	{
		int nLeftParenthese = strIntegText.Find('(', nIntegralLTPos);
		if(nLeftParenthese > 0)
		{
			int nFirstComma = strIntegText.Find(',', nLeftParenthese);
			if(nFirstComma > 0)
			{
				string strFuncName = strIntegText.Mid(nLeftParenthese+1, nFirstComma-nLeftParenthese-1);
				strFuncName.TrimLeft(); strFuncName.TrimRight();
				strIntegText.Format("%s(%s, %s)", STR_INTEGLT_FUNC, strFuncName, strVars);
			}
		}
	}
	
	if(ctrlIntegText)
		ctrlIntegText.Text = strIntegText;
	
	string strFormula = FuncOrganizer().GetFormula(m_pHolder->m_trFunction);
	FuncOrganizer().SetFormula(strFormula, m_pHolder->m_trFunction, strIntegText);
}

#define _GET_STR_VEC_VAL(_VAL)	\
	if(nRet > ii)				\
	{							\
		_VAL = vsTemp[ii]; 		\
		_VAL.TrimLeft();		\ 
		_VAL.TrimRight();		\
	}

///Jasmine 10/20/2011 ORG-3484 THERE_ARE_MANY_PARENTH_AND_HAVE_TO_FIND_THE_MACTH_TWO
static int _find_single_right_parenthese(const string& strText, int nStart)
{
	int nLeftParenth	= strText.Find('(', nStart);
	int nRightParenth	= strText.Find(')', nStart);
	if(nStart <= nLeftParenth && nLeftParenth < nRightParenth)
	{
		return _find_single_right_parenthese(strText, nRightParenth + 1);
	}
	return nRightParenth;
}
///End THERE_ARE_MANY_PARENTH_AND_HAVE_TO_FIND_THE_MACTH_TWO

void FFWFitFuncBodyPage::FormulaToIntegTable()
{	
	string strFormulaHintText;
	string strFormula = FuncOrganizer().GetFormula(m_pHolder->m_trFunction, &strFormulaHintText);
	if( !strFormulaHintText.IsEmpty() )
		strFormula = strFormulaHintText;	
	
	string strFuncName, strLLimit, strULimit, strVars;
	
	int nIntegralLTPos = FuncOrganizer().IntegralLTPos(strFormula);
	if(nIntegralLTPos >= 0)		
	{
		int nLeftParenthese = strFormula.Find('(', nIntegralLTPos);
		if(nLeftParenthese > 0)
		{
			///Jasmine 10/20/2011 ORG-3484 THERE_ARE_MANY_PARENTH_AND_HAVE_TO_FIND_THE_MACTH_TWO
			//int nRightParenthese = strFormula.ReverseFind(')');//int nRightParenthese = strFormula.Find(')', nLeftParenthese);	///Jasmine 09/20/2011 ORG-3484-P2 THERE_MAY_BE_PARENTHESE_INSIDE_ARG
			int nRightParenthese = _find_single_right_parenthese(strFormula, nLeftParenthese + 1);
			///End THERE_ARE_MANY_PARENTH_AND_HAVE_TO_FIND_THE_MACTH_TWO
			if(nRightParenthese < 0) nRightParenthese = strFormula.GetLength()-1;
			
			string strTemp = strFormula.Mid(nLeftParenthese+1, nRightParenthese-nLeftParenthese-1);
			vector<string> vsTemp;
			int nRet = strTemp.GetTokens(vsTemp, ',');
			
			int ii = 0;
			_GET_STR_VEC_VAL(strFuncName);
			
			ii++;
			_GET_STR_VEC_VAL(strLLimit);
			
			ii++;
			_GET_STR_VEC_VAL(strULimit);
			
			ii++;
			if(nRet > ii)
			{
				vsTemp.RemoveAt(0, ii);
				strVars = str_combine(vsTemp, " ,");
			}
		}
		
	}
		
	string strVar, strArg, strBody;
	FuncOrganizer().GetLTFuncInfo(m_pHolder->m_trFunction, strFuncName, strVar, strArg, strBody);
		
	string strVarDisplay;
	if( !strArg.IsEmpty() )
		strVarDisplay = ", " + strVars;
	
	string strIntegText;
	strIntegText.Format("%s(%s, %s, %s%s)", STR_INTEGLT_FUNC, strFuncName, strLLimit, strULimit, strVarDisplay);
	
	Control ctrlIntegText = GetItem(IDC_FIT_FUNC_INTEG_TEXT);
	if(ctrlIntegText)
		ctrlIntegText.Text = strIntegText;
	
	vector<string> vsElement, vsVars;
	int nSize	= strArg.GetTokens(vsElement, ',');
	strVars.GetTokens(vsVars, ',');
	vsVars.SetSize(nSize);
	vsElement.InsertAt(0, _L("Lower Limit"));
	vsVars.InsertAt(0, strLLimit);
	vsElement.InsertAt(1, _L("Upper Limit"));
	vsVars.InsertAt(1, strULimit);
	for(int ii = 0; ii < nSize; ii++)
	{
		string strTemp;
		strTemp = vsElement[ii];
		strTemp.TrimLeft(); strTemp.TrimRight();
		vsElement[ii] = strTemp;		
		
		strTemp = vsVars[ii];
		strTemp.TrimLeft(); strTemp.TrimRight();
		vsVars[ii] = strTemp;		
	}
	m_gridInteg.ClearAll();
	m_gridInteg.SetColValues(INTEG_ELEMENT_COLUMN, vsElement, 0, true);
	m_gridInteg.SetColValues(INTEG_VALUE_COLUMN, vsVars, 0, true);	
}
void FFWFitFuncBodyPage::OnAppendTextToFuncBody(Control ctrl)
{	
	Control ctrlIntegText = GetItem(IDC_FIT_FUNC_INTEG_TEXT);
	if(!ctrlIntegText)
		return;
	string strText	= ctrlIntegText.Text;
	
	m_editEquation.ReplaceSel(strText);
	
	SetFocus(m_editEquation.GetSafeHwnd());	
}
///End CREATE_FITFUNC_WITH_INTEGRAL

bool FFWFitFuncBodyPage::InitGridParam()
{
	m_FFWParamGrid.Init(IDC_FIT_FUNC_PARAM_GRID, *this, "junk");
	
	m_FFWParamGrid.ShowGroup(0);

	return true;
}

bool FFWFitFuncBodyPage::InitGridConstant()
{
	m_gridConstant.Init(IDC_FIT_FUNC_CONSTANT_GRID, *this);
	return true;
}

bool FFWFitFuncBodyPage::InitTabControls()
{
	m_tabParameter = GetItem(IDC_FIT_FUNC_PARAM_TAB);
	if(!m_tabParameter)
		return false;
	
	m_tabParameter.InsertItem(FFW_PARAM_TAB, _L("Parameters"));
	m_tabParameter.InsertItem(FFW_CONST_TAB, _L("Constants"));
	
	RECT rTab;
	m_tabParameter.GetWindowRect(&rTab);
	ScreenToClient(&rTab);
	m_tabParameter.AdjustRect(FALSE, &rTab);
	
	m_FFWParamGrid.MoveWindow(rTab);
	m_gridConstant.MoveWindow(rTab);

	OnTabChange(m_tabParameter);
	
	return true;
}

virtual bool FFWFitFuncBodyPage::UpdateTreeToPageGUI(const TreeNode& trFunction)
{
	bool bPeakFunction = FuncOrganizer().IsPeak(m_pHolder->m_trFunction);
	m_FFWParamGrid.HideCol(NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE, !bPeakFunction);

	m_FFWParamGrid.SetTree(m_pHolder->m_trFunction);
	m_FFWParamGrid.ResizeCols();

	//constant
	vector<string> vsVariables;
	vector<string> vsValues;
 	int nCount = FuncOrganizer().GetConstants(m_pHolder->m_trFunction, vsVariables, vsValues);
	m_gridConstant.Update(vsVariables, vsValues);
	m_gridConstant.ResizeCols();
	
	//function body
	if(m_editEquation)
	{
		string strFuncBody = FuncOrganizer().GetFormula(trFunction);
		StringToEditText(strFuncBody, m_editEquation);
	}

	//evaluate controls
	char ch = ',';
	string strIndepNames = FuncOrganizer().GetIndependVars(trFunction, ch);
	vector<string> vsNames;
	int nNames = strIndepNames.GetTokens(vsNames, ch);
	
	ch = ';';
	string strIndepVars = FuncOrganizer().GetIndependVarsWithValue(trFunction, ch);	
	vector vValues;
	FuncOrganizer().ParseIndependVarsValue(vValues, trFunction, strIndepVars, ch);
	///Sophy 7/8/2010 ORG-518-P8 LIMIT_NUM_INDEPS_TO_3_ON_QUICK_CHECK
	//int nMaxNum = 4;
	//vector<int> vnLabels = {IDC_FIT_FUNC_INDEPEND_VAR1, IDC_FIT_FUNC_INDEPEND_VAR2, IDC_FIT_FUNC_INDEPEND_VAR3, IDC_FIT_FUNC_INDEPEND_VAR4};
	//vector<int> vnEdits = {IDC_FIT_FUNC_INDEPEND_VAR_VALUE1, IDC_FIT_FUNC_INDEPEND_VAR_VALUE2, IDC_FIT_FUNC_INDEPEND_VAR_VALUE3, IDC_FIT_FUNC_INDEPEND_VAR_VALUE4};
	int nMaxNum = 3;
	vector<int> vnLabels = {IDC_FIT_FUNC_INDEPEND_VAR1, IDC_FIT_FUNC_INDEPEND_VAR2, IDC_FIT_FUNC_INDEPEND_VAR3};
	vector<int> vnEdits = {IDC_FIT_FUNC_INDEPEND_VAR_VALUE1, IDC_FIT_FUNC_INDEPEND_VAR_VALUE2, IDC_FIT_FUNC_INDEPEND_VAR_VALUE3};
	///end LIMIT_NUM_INDEPS_TO_3_ON_QUICK_CHECK
	ASSERT( nMaxNum == vnLabels.GetSize() && nMaxNum == vnEdits.GetSize() );
	for(int ii = 0; ii < nMaxNum; ii++)
	{
		Control label 	= GetItem( vnLabels[ii] );
		Control edit	= GetItem( vnEdits[ii] );
		if(ii < nNames)
		{
			label.Text = vsNames[ii] + " = ";
			if( ii < vValues.GetSize() )
				edit.Text = ftoa( vValues[ii] );
			label.Visible = edit.Visible = true;
		}
		else
		{
			label.Visible = edit.Visible = false;
		}
	}
	
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	_IS_PAGE_HAS_INTEG_CONTROLS
	{
		FormulaToIntegTable();
	}
	///End CREATE_FITFUNC_WITH_INTEGRAL
	return m_pFuncBody->UpdateTreeToPageGUI();
}

virtual bool FFWFitFuncBodyPage::UpdatePageGUIToTree(TreeNode& trFunction)
{
	//parameter
	m_FFWParamGrid.GetTree(trFunction);
	
	//constant
	vector<string> vsVariables, vsValues;
	m_gridConstant.GetColValues(CONSTANT_VARIABLE_COLUMN, vsVariables);
	m_gridConstant.GetColValues(CONSTANT_VALUE_COLUMN, vsValues);

	vsVariables.RemoveAt(0);
	vsValues.RemoveAt(0);
	for (int ii = vsVariables.GetSize() - 1 ; ii >= 0 ; --ii)
	{
		///Sophy 7/8/2010 ORG-518-P3 TRIM_PARAM_VALUE_AND_CONSTANT_BEFORE_SAVE
		TRIM_STR(vsVariables[ii])
		TRIM_STR(vsValues[ii])
		///end TRIM_PARAM_VALUE_AND_CONSTANT_BEFORE_SAVE
		if ( vsVariables[ii] == "")
		{
			vsVariables.RemoveAt(ii);
			vsValues.RemoveAt(ii);
		}
	}
	FuncOrganizer().SetConstants(vsVariables, vsValues, trFunction);
	
	//function body
	string strFormula = m_editEquation ? m_editEquation.Text : "";
	FuncOrganizer().SetFormula(strFormula, trFunction);
	
	//evaluate controls
	FuncOrganizer().ClearQuickCheck(trFunction);
	vector<string>	vstrNames, vstrVals, vstrTemp;
	vector			vVals, vTemp;
	nlf_get_independent_variables(trFunction, &vstrNames);
	char			chDelimiter = ',';
	string			strNames = FuncOrganizer().GetFittingPara(trFunction);
	strNames.GetTokens(vstrTemp, chDelimiter);
	vstrNames.Append(vstrTemp);
	
	getIndepVarsVal(vVals);
	m_FFWParamGrid.GetParamsVals(vTemp);
	vVals.Append(vTemp);
	convert_double_vector_to_string_vector(vVals, vstrVals, vVals.GetSize());
	ASSERT( vstrNames.GetSize() == vstrVals.GetSize() );
	FuncOrganizer().SetQuickCheckItems(trFunction, vstrNames, vstrVals);

	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	_IS_PAGE_HAS_INTEG_CONTROLS
	{
		IntegTableToFormula();
	}
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
	return m_pFuncBody->UpdatePageGUIToTree();
}

/// Bill 07/12/2010 ADD_PEAK_FUNC_AND_QUICK_CHECK_HINT
virtual string FFWFitFuncBodyPage::GetPageHints(bool bNextPage)
{
	if ( bNextPage )
		return FFWPageBase::GetPageHints(true);
	else
	{
		string strHint;

		if ( FuncOrganizer().IsPeak(m_pHolder->m_trFunction) )
		{
			string strPeakHint;
			strPeakHint = GetHintsBySection("Set Peak Attribute");
			strHint += strPeakHint + "\r\n\r\n";
		}
		///Jasmine 08/16/2011 ORG-3484-S3-3 DIFF_TAB_HAS_DIFF_HINT
		/////jasmine 07/15/10 ORG-2-P15 ADD_HINTS_FOR_PARAMTAB_AND_CONSTTAB
		//string strParamTabHints =  GetHintsBySection("Parameter Tab");
		//if( !strParamTabHints.IsEmpty() )
			//strHint += strParamTabHints + "\r\n\r\n";
		//
		//string strConstTabHints =  GetHintsBySection("Constant Tab");
		//if( !strConstTabHints.IsEmpty() )
			//strHint += strConstTabHints + "\r\n\r\n";
		/////End ADD_HINTS_FOR_PARAMTAB_AND_CONSTTAB
		string strParamTabHints;
		switch( m_tabParameter.GetCurSel() )
		{
		case FFW_PARAM_TAB:
			strParamTabHints =  GetHintsBySection("Parameter Tab");
			break;
		case FFW_CONST_TAB:
			strParamTabHints =  GetHintsBySection("Constant Tab");
			break;	
		case FFW_INTEG_TAB:
			strParamTabHints =  GetHintsBySection("Integrand Tab");
			break;
		}
		if( !strParamTabHints.IsEmpty() )
			strHint += strParamTabHints + "\r\n\r\n";		
		///End DIFF_TAB_HAS_DIFF_HINT
		
		strHint += FFWPageBase::GetPageHints(false);

		string strQuickCheckHint;
		strQuickCheckHint = GetHintsBySection("Quick Check");
		strHint += "\r\n\r\n" + strQuickCheckHint;

		return strHint;
	}
}
/// End ADD_PEAK_FUNC_AND_QUICK_CHECK_HINT

/// virtual
string FFWFitFuncBodyPage::GetPageHintsName(bool bNextPage/* = false*/)
{
	if(m_pFuncBody)
		return m_pFuncBody->GetPageHintsName(bNextPage);
	
	return "";
}
///End MOVE_FFW_HINTS_TO_TXT

bool FFWFitFuncBodyPage::evaluateDependentVar()
{
	TreeNode trFunction = m_pHolder->m_trFunction;
	if( !UpdatePageGUIToTree(trFunction) )
	{
		ASSERT(0);
		return false;
	}	
	
	string strErrMsg;
	int nErr = CheckEquation(strErrMsg);
	///Sophy 7/8/2010 ORG-518-P2 IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	//if ( nErr != FFW_EQUATION_OK )
	if ( nErr == FFW_EQUATION_COMPILE_ERROR 
		|| nErr == FFW_EQUATION_TOO_MANY_INDEPS  //as to Max's suggestion, when too many indeps, no need to do evaluate since it might be slow.
		|| nErr == FFW_EQUATION_EMPTY_FORMULA
		|| nErr == FFW_EQUATION_EMPTY_DLL	///Jasmine 08/02/10 ORG-591-P7 DETECH_EXTERNAL_DLL_SOURCE
		|| nErr == FFW_HAS_NO_INTEGLT)		///Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG
	///end IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	{
		m_controlDependVar.Text = strErrMsg;
		return false;
	}
	vector 	vIndepValue, vParamValue;
	int 	nIndepNum = getIndepVarsVal(vIndepValue);
	int 	nParamNum = m_FFWParamGrid.GetParamsVals(vParamValue);
	int nDepNum = nlf_get_dependent_variables(trFunction);
	
	matrix mIndVars, mDepVars;
	mIndVars.SetSize(1, nIndepNum);
	mDepVars.SetSize(1, nDepNum);
	if(mIndVars.SetRow(vIndepValue, 0) != 0)
		ASSERT(0);
	
	NumericFunction	nf(m_pHolder->m_trFunction);
	
	///------ Folger 08/16/10 ORG-756-P1-P2 BETTER_ERROR_CHECKING_FOR_FITTING_FUNCTION_LT_EVALUATION
	//bool bRet = nf.Evaluate(vParamValue, 1, mDepVars, mIndVars);
	bool bRet = nf.Evaluate(vParamValue, 1, mDepVars, mIndVars, NLSFEVALUATE_CHECK_LT_VARS_FULLY_USED);
	///------ End BETTER_ERROR_CHECKING_FOR_FITTING_FUNCTION_LT_EVALUATION
	
	vector vDepValue;
	if( mDepVars.GetAsVector(vDepValue) )
	{
		///Sophy 7/14/2010 ORG-518-P10 SHOW_ERROR_MSG_WHEN_EVALUATE_INVALID_EQUATION
		if ( strErrMsg.IsEmpty() )
		{
			///Sophy 8/10/2010 ORG-745-P3 IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
//#define	MAX_ERR_MSG_LENGTH	256
			//LPSTR lpBuff = strErrMsg.GetBuffer(MAX_ERR_MSG_LENGTH);
			//LT_get_last_err(lpBuff, MAX_ERR_MSG_LENGTH);
			//strErrMsg.ReleaseBuffer();
			//if ( !strErrMsg.IsEmpty() )
				//strErrMsg = "(" + strErrMsg + ")";
			m_pFuncBody->RuntimeCheck(strErrMsg);
			///end IMPROVE_ERR_MSG_IN_LABTALK_FUNCTION_TYPE
		}
		///end SHOW_ERROR_MSG_WHEN_EVALUATE_INVALID_EQUATION
		string strDepVal = FuncOrganizer().CombineDependVarsWithValue(vDepValue, trFunction, ',');
		///Sophy 7/8/2010 ORG-518-P2 IMPROVE_ERR_MSG_FOR_QUICK_CHECK
		//m_controlDependVar.Text = strDepVal;
		string strResult;
		strResult.Format("%s %s", strDepVal, strErrMsg);
		m_controlDependVar.Text = strResult;
		///end IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	}
	
	return true;
}

int	FFWFitFuncBodyPage::getIndepVarsVal(vector& vv)
{
	int				nIndep = nlf_get_independent_variables(m_pHolder->m_trFunction);
	vv.SetSize(nIndep);
	///Sophy 7/8/2010 ORG-518-P8 LIMIT_NUM_INDEPS_TO_3_ON_QUICK_CHECK
	//vector<uint>	vIDs = {IDC_FIT_FUNC_INDEPEND_VAR_VALUE1, IDC_FIT_FUNC_INDEPEND_VAR_VALUE2, IDC_FIT_FUNC_INDEPEND_VAR_VALUE3, IDC_FIT_FUNC_INDEPEND_VAR_VALUE4};
	vector<uint>	vIDs = {IDC_FIT_FUNC_INDEPEND_VAR_VALUE1, IDC_FIT_FUNC_INDEPEND_VAR_VALUE2, IDC_FIT_FUNC_INDEPEND_VAR_VALUE3};
	///end LIMIT_NUM_INDEPS_TO_3_ON_QUICK_CHECK
	Control			ctrl;
	for ( int ii = 0; ii < nIndep && ii < vIDs.GetSize(); ii++ )
	{
		ctrl = GetItem(vIDs[ii]);
		vv[ii] = atof(ctrl.Text);
	}
	return nIndep;
}

//virtual
BOOL FFWFitFuncBodyPage::OnNext()
{
	string strErrMsg;
	int nErr = CheckEquation(strErrMsg);
	if ( nErr == FFW_EQUATION_INVALID_CONTANT || nErr == FFW_EQUATION_COMPILE_ERROR || nErr == FFW_EQUATION_PEAK_ATTRIB_ERROR || nErr == FFW_EQUATION_EMPTY_FORMULA
		|| nErr == FFW_EQUATION_EMPTY_DLL	///Jasmine 08/02/10 ORG-591-P7 DETECH_EXTERNAL_DLL_SOURCE
		|| nErr == FFW_HAS_NO_INTEGLT)		///Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG
	{
		MessageBox(strErrMsg, STR_ERROR, MB_OK);
		return FALSE;
	}
	return FFWPageBase::OnNext();
}

int FFWFitFuncBodyPage::CheckEquation(string& strErrMsg)
{
	///Jasminie 07/30/10 ORG-591-P7 PRECOMPILE_FILE_MAKE_COMPILE_CHECKING_FAIL
	TreeNode trFunction = m_pHolder->m_trFunction;
	///Sophy 7/20/2010 ORG-591-P6 WRONG_EVALUE_RESULT_DUE_TO_OLD_PRECOMPILE_FILES
	string strFunctionName, strFileName;
	nlf_get_func_names(trFunction, strFunctionName, strFileName);
	nlf_delete_precompile_files(strFunctionName);
	///end WRONG_EVALUE_RESULT_DUE_TO_OLD_PRECOMPILE_FILES
	///End PRECOMPILE_FILE_MAKE_COMPILE_CHECKING_FAIL
	
	int ii, nSize;
	//constant checking
	vector<string> vsVariables, vsValues;
	m_gridConstant.GetColValues(CONSTANT_VARIABLE_COLUMN, vsVariables);
	m_gridConstant.GetColValues(CONSTANT_VALUE_COLUMN, vsValues);
	nSize = vsVariables.GetSize();
	for ( ii = m_gridConstant.GetRowOffset(); ii < nSize; ii++ )
	{
		TRIM_STR(vsValues[ii])
		if ( is_missing_value(atof(vsValues[ii])) )
		{
			strErrMsg.Format(_L("(%s = %s invalid)"), vsVariables[ii], vsValues[ii].IsEmpty() ? _L("<empty>") : vsValues[ii]);
			return FFW_EQUATION_INVALID_CONTANT;
		}
	}
	
	///Sophy 7/8/2010 ORG-518-P2 IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	//check function body
	string strFormula;
	EditTextToString(m_editEquation, strFormula);
	ocu_skip_C_comments(&strFormula);
	TRIM_STR(strFormula)
	if ( strFormula.IsEmpty() )
	{
		if( m_pFuncBody->IsFormulaEssential() )///Jasmine 08/10/10 ORG-745-P4 ALLOW_EXTERNAL_DLL_HAS_EMPTY_ANNOTATION
		{
			strErrMsg = _L("Function body is empty");
			return FFW_EQUATION_EMPTY_FORMULA;
		}
	}
	///end IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	
	//compile function
	///Sophy 7/12/2010 ORG-518-P2 IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	//NumericFunction nf(m_pHolder->m_trFunction);
	//if ( !nf.CheckCompileOC() )
	//{
		/////Sophy 7/8/2010 ORG-518-P7 IMPROVE_OC_COMPILE_ERR_MSG_ON_QUICK_CHECK
		////ocu_load_msg_str(NLSF_ERR_COMPILE_NUMERIC_FUNCTION, &strErrMsg);
		//strErrMsg = _L("Compile error. Click Open Code Builder button for details");
		/////end IMPROVE_OC_COMPILE_ERR_MSG_ON_QUICK_CHECK
		//return FFW_EQUATION_COMPILE_ERROR;
	//}
	int nErrCode = FFW_EQUATION_OK;
	if ( (nErrCode = m_pFuncBody->Compile(strErrMsg)) != FFW_EQUATION_OK )
	{
		return nErrCode;
	}
	///end IMPROVE_ERR_MSG_FOR_QUICK_CHECK
	
	//check peak attribs
	if ( FuncOrganizer().IsPeak(m_pHolder->m_trFunction) )
	{
		vector<string> vsVals;
		m_FFWParamGrid.GetColValues(NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE, vsVals, m_FFWParamGrid.GetRowOffset());
#define	MIN_PEAK_FUNCTION_PARAMS	4
		if ( vsVals.GetSize() < MIN_PEAK_FUNCTION_PARAMS ||
			 vsVals[0].CompareNoCase(STR_OFFSET_PEAK_INFO) != 0 ||
			 vsVals.Find(STR_X_CENTER_PEAK_INFO) < 0 ||
			 vsVals.Find(STR_X_WIDTH_PEAK_INFO) < 0 ||
			 vsVals.Find(STR_AMPLITUDE_PEAK_INFO) < 0 )
		{
			ocu_load_err_msg_str(MSG_FFW_PEAK_FUNCTION, &strErrMsg);///Jasmine 07/14/10 ORG-540-P3
			return FFW_EQUATION_PEAK_ATTRIB_ERROR;
		}
	}
	
	//parameter checking
	vector<string> vsParamNames, vsParamValues;
	m_FFWParamGrid.GetColValues(NLPARAMGRIDCOLTYPE_NAME, vsParamNames);
	m_FFWParamGrid.GetColValues(NLPARAMGRIDCOLTYPE_VALUE, vsParamValues);
	nSize = vsParamNames.GetSize();
	///Jasmine 12/27/10 ORG938-P5 GET_TRUE_VALUE_WITHOUT_FORMAT
	vector vParamValues;
	m_FFWParamGrid.GetParamsVals(vParamValues);
	for ( ii = m_FFWParamGrid.GetRowOffset(); ii < nSize; ii++ )
	{
		//if ( is_missing_value(atof(vsParamValues[ii])) )
		int nParamIndex = ii - m_FFWParamGrid.GetRowOffset();
		if ( is_missing_value( vParamValues[nParamIndex] ) )
		///End GET_TRUE_VALUE_WITHOUT_FORMAT
		{
			strErrMsg.Format(_L("(%s = %s invalid)"), vsParamNames[ii], vsParamValues[ii].IsEmpty() ? _L("<empty>") : vsParamValues[ii]);
			return FFW_EQUATION_INVALID_PARAMS;
		}
	}
	
	//check independents
	vector	vIndepValue;
	vector<string> vsIndepVars;
	int 	nIndepNum = getIndepVarsVal(vIndepValue);
	nlf_get_independent_variables(m_pHolder->m_trFunction, &vsIndepVars);
	for ( ii = 0; ii < nIndepNum; ii++ )
	{
		if ( is_missing_value(vIndepValue[ii]) )
		{
			strErrMsg.Format(_L("(%s = %s invalid)"), vsIndepVars[ii], ftoa(vIndepValue[ii]));
			return FFW_EQUATION_INVALID_INDEPS;
		}
	}
	
	///Sophy 7/7/2010 ORG-432-S14 WARNING_MSG_WHEN_EVALUATE_WITH_TOO_MANY_INDEPS
	const int nMaxIndeps = 3;
	if ( nIndepNum > nMaxIndeps )
	{
		//strErrMsg = _L("(Cannot evaluate function with more than 3 independent variables)");
		ocu_load_err_msg_str(FFWERR_INVALID_FUNCTION_INDEPS_NUMBER, &strErrMsg);
		return FFW_EQUATION_TOO_MANY_INDEPS;
	}
	///end WARNING_MSG_WHEN_EVALUATE_WITH_TOO_MANY_INDEPS
	
	///Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG
	_IS_PAGE_HAS_INTEG_CONTROLS
	{
		int nIntegralLTPos = FuncOrganizer().IntegralLTPos(strFormula);
		if(nIntegralLTPos < 0)
		{
			///Jasmine 10/20/2011 ORG-3484-S7 IMPROVE_NO_INTEGRAL_IN_FUNC_BODY_ERR_MSG
			//strErrMsg = _L("Cannot find integLT");
			string strText = STR_INTEGLT_FUNC + "()";
			Control ctrlIntegText = GetItem(IDC_FIT_FUNC_INTEG_TEXT);
			if(ctrlIntegText)
				strText = ctrlIntegText.Text;
	
			strErrMsg.Format(_L("Function %s should be present in function body for integration"), strText);
			///End IMPROVE_NO_INTEGRAL_IN_FUNC_BODY_ERR_MSG
			return FFW_HAS_NO_INTEGLT;
		}
	}
	///End ERR_CHECK_FOR_INTEG
	
	return FFW_EQUATION_OK;
}

void	FFWFitFuncBodyPage::HideAllFuncBodyControls()
{
	vector<int>		vnIDs = { IDC_FIT_FUNC_EQUATION_LEFT_TEXT
		, IDC_FIT_FUNC_DERIVATIVES_CHECK
		, IDC_FIT_FUNC_OPEN_CODE_BUILDER
		, IDC_FIT_FUNC_DLL_FILE_EDIT_TEXT
		, IDC_FIT_FUNC_DLL_FILE_EDIT
		, IDC_FIT_FUNC_DLL_FUNC_EDIT_TEXT
		, IDC_FIT_FUNC_DLL_FUNC_EDIT
		, IDC_FIT_FUNC_TREAT_NUMBER_CHECK /// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
		///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
		, IDC_FIT_FUNC_APPEND_INTEG_TEXT
		, IDC_FIT_FUNC_INTEG_TEXT
		, IDC_FIT_FUNC_INTEG_GRID
		///End CREATE_FITFUNC_WITH_INTEGRAL
	};

	for ( int ii=0; ii<vnIDs.GetSize(); ++ii )
		GetItem(vnIDs[ii]).Visible = FALSE;
}

void	FFWFitFuncBodyPage::UpdateTitle()
{
	vector<string>	vs;
	int		nTokens = str_separate(m_wndParent.Text, STR_DIALOG_TITLE_SEPARATOR, vs);
	if ( nTokens != 2 )
		return;
	vs[1] = m_pFuncBody->GetTitle();
	m_wndParent.Text = str_combine(vs, STR_DIALOG_TITLE_SEPARATOR);
}

void	FFWFitFuncBodyPage::UpdateControls()
{
	HideAllFuncBodyControls();	
	m_pFuncBody->UpdateControls();
}

void	FFWFitFuncBodyPage::OnOpenCodeBuilder(Control ctrl)
{
	m_pFuncBody->OpenCodeBuilder(m_wndParent);
}

/// Bill 07/08/2010 ORG-478-P4 CONTENT_MISS_AFTER_RETURN_DIALOG
void	FFWFitFuncBodyPage::OnContentChange()
{
	m_pFuncBody->OnContentChange();
}
/// End CONTENT_MISS_AFTER_RETURN_DIALOG

void	FFWFitFuncBodyPage::OnDerivativesCheck(Control ctrl)
{
	m_pFuncBody->DerivativesCheck();
	
	checkEnableFinishBtn();///Jasmine 08/02/10 ORG-591-P7 FINSH_EVENT_IS_TOO_LATE_SO_DISABLE_ONCE_FIND_ERROR
}

/// Bill 02/11/2011 ORG-2049-S1 TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION
void	FFWFitFuncBodyPage::OnTreatNumberAsDouble(Control ctrl)
{
	m_pFuncBody->TreatNumberAsDoubleCheck();
}
/// End TREAT_ALL_NUMBERS_AS_DOUBLE_FOR_OC_FITTING_FUNCTION

///------ End CENTRALIZE_FUNCTION_BODY_PAGE_RESOURCES

#endif//_FFW_FUNC_BODY_PAGE_H
