/*------------------------------------------------------------------------------*
 * File Name: FFTFilters.cpp	 												*
 * Creation: SDB 5/19/2003														*
 * Purpose: OriginC Source CPP file for auto update Filter routines.			*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <origin.h>
#include "FitCommon.h"
#include <fft_utils.h>

#ifdef _FOR_SMART_LOADING_ONLY
#include "analysis_utils.h"
#include <stats_utils.h>
#include "stats_guis.h"
#include "stats_operations.h"
#endif


////////////////////////////////////////////////////////////////////////////
// C - functions
////////////////////////////////////////////////////////////////////////////

static bool FFTFilters_dlg_event(TreeNode& tr, int nRow, int nOption, Dialog& dlgGetNBox)
{
	TreeNode trOptions=tr.Options;
	int nType = trOptions.Type.nVal;
	switch (nType)
	{
	case OFFTFILTER_LOW_PASS:
		{
			trOptions.Frequency1.Show=1;
			trOptions.Frequency2.Show=0;
		}
		break;
		
	case OFFTFILTER_HIGH_PASS:
		{
			trOptions.Frequency1.Show=1;
			trOptions.Frequency2.Show=0;
		}
		break;

	case OFFTFILTER_BAND_PASS:
		{
			trOptions.Frequency1.Show=1;
			trOptions.Frequency2.Show=1;
		}
		break;

	case OFFTFILTER_BAND_BLOCK:
		{
			trOptions.Frequency1.Show=1;
			trOptions.Frequency2.Show=1;
		}
		break;
		
	case OFFTFILTER_THRESHOLD:
		{
			trOptions.Frequency1.Show=0;
			trOptions.Frequency2.Show=0;
		}
		break;
	
	default:
		
		ASSERT(FALSE);
		return FALSE;
	}
	
	return TRUE;
}


#define		FFTFILTER_BASE_WKS_NAME		"FFTFilter"

//////////////////////////////////////////////////////////////////////////////////
// Class FFTFilter
//////////////////////////////////////////////////////////////////////////////////
// Possible values of nOption in Init() 
enum
{
	OFFTFILTER_LOW_PASS		= 0,
	OFFTFILTER_HIGH_PASS,
	OFFTFILTER_BAND_PASS,
	OFFTFILTER_BAND_BLOCK,
	OFFTFILTER_THRESHOLD,
};

class OC_REGISTERED FFTFilters : public WksReportOperation
{
protected:
	BOOL Construct(TreeNode& trOperation, int nOption = 0)
	{
		if( WksReportOperation::Construct(trOperation, nOption) )
		{
			/*
			TreeNode trOut = trOperation.Calculation; // Calculation node should have already been prepared in base class
			trOut.Statistics.ID = IDST_DESC_STATS_RESULTS;
			*/
			
			///Iris 01/20/05 CONSTRUCT_GUI_CLEANUP
			//TreeNode		trGUI = ConstructGUI();
			TreeNode	trGUI = ConstructAddGUI(trOperation);
			///end CONSTRUCT_GUI_CLEANUP

			ConstructFFTFilterGUITree(trGUI, nOption);
			
			///Iris 4/06/05 INIT_GRAPH_NUMBER
			///Iris 01/19/05 ADD_GRAPHNUM_OPTION_TO_CONSTRUCT_REPORT
			//ConstructAddReportCommon(trGUI, REPORT_GRAPHS, IDST_REPORT_OPTIONS_FFT_FILTERS);
			//ConstructAddReportCommon(trOperation, 0, IDST_REPORT_OPTIONS_FFT_FILTERS, true, 1);
			ConstructAddReportCommon(trOperation, 0, IDST_REPORT_OPTIONS_FFT_FILTERS, true);
			///---

			tree_output_branch_mode(trGUI);
			
			Operation::ConstructAddCommonBottom(trGUI);
			//trOperation.AddNode(trGUI.Clone());	///Iris 01/20/05 CONSTRUCT_GUI_CLEANUP	
			
			return TRUE;
		}

		return FALSE;
	}
	
	///Iris 4/06/05 INIT_GRAPH_NUMBER
	//virtual
	int ConstructGraphNumber()
	{
		return 1;
	}
		
	string	GetDlgTitle(int nKind = 0)
	{
		return "FFT Filters";
	}
	
	string	GetAnalysisName(int nKind = 0)
	{
		string str;
		switch (nKind)
		{
		case OFFTFILTER_LOW_PASS:
			str = "Low Pass";
			break;
			
		case OFFTFILTER_HIGH_PASS:
			str = "High Pass";
			break;
			
		case OFFTFILTER_BAND_PASS:
			str = "Band Pass";
			break;
		
		case OFFTFILTER_BAND_BLOCK:
			str = "Band Block";
			break;

		case OFFTFILTER_THRESHOLD:
			str = "Threshold";
			break;
		
		default:
			ASSERT(FALSE);
			return GetClassName();
		}
		return str;
	}
	
	BOOL	CalcOneData(TreeNode &trOp, int index, int nTotalNumData, const vector<int> &vFactorSizes,
					const vector<string> &vstrFactors, vector &vData, vector &vDummy, matrix &mDummy, vector &vWeights, DWORD dwPlotObjUID, int nRowColIndex, const vector<int>& vintRowsInSource = NULL)
	{
		TreeNode trGUI=trOp.GUI;
		TreeNode trOptions=trGUI.Options;
		double dFrequency1, dFrequency2;
		
		int nKind=trOptions.Type.nVal, nErr;
		switch (nKind)
		{
		case OFFTFILTER_LOW_PASS:
			{
				dFrequency1 = trOptions.Frequency1.dVal;
				nErr = lowpass(vData, dFrequency1);
			}
			break;

		case OFFTFILTER_HIGH_PASS:
			{
				dFrequency1 = trOptions.Frequency1.dVal;
				nErr = highpass(vData, dFrequency1);
			}
			break;
			
		case OFFTFILTER_BAND_PASS:
			{
				dFrequency1 = trOptions.Frequency1.dVal;
				dFrequency2 = trOptions.Frequency2.dVal;
				nErr = bandpass(vData, dFrequency1, dFrequency2);
			}
			break;
			
		case OFFTFILTER_BAND_BLOCK:
			{
				dFrequency1 = trOptions.Frequency1.dVal;
				nErr = bandblock(vData, dFrequency1, dFrequency2);
			}
			break;
		
		case OFFTFILTER_THRESHOLD:
			{
				//dFrequency1 = trOptions.Frequency1.dVal;
				nErr = threshold_filter(vData, dFrequency1);
			}
			break;

		default:
			ASSERT(FALSE);
			return FALSE;
		}

		return TRUE;
	}

	PEVENT_FUNC		GetEventFunction()
	{
		return FFTFilters_dlg_event;
	}

};
