/*------------------------------------------------------------------------------*
 * File Name: DynaDlg.h		 													*
 * Creation: CPY 2/21/2006														*
 * Purpose: Baseclass for all dialog with a DynaControl							*
 * Copyright (c) OriginLab Corp.	2006, 2007, 2008, 2009, 2010, 2011			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 5/20/06 THEME_COMBO_IN_BASE_CLASS										*
 *	CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS									*
 *  CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT						*
 *  Joe 7/25/06 THEME_LAST_USED_SHOW                                            *
 *	CPY 9/24/06 XF_PREVIEW_DLG_NEED_PREVIEW_ON_THE_SIDE							*
 *	Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG		*
 *  SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET						*
 *	Joseph 10/09/06	CHANGE_THEME_GROUP_SIZE										*
 *	CPY 10/24/06 XF_DLG_DESTROY_EVENT											*
 *	Jasmine 10/26/06 KEEP_DLG_MODEL												*
 *  Iris 10/24/06 ADD_ERR_MESSAGE_LINE											*
 *	CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS						*
 *	CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT			*
 *  Iris 11/02/06 FIX_NOT_SHOW_MSG_BOX_SOMETIME									*
 *	Jasmine 11/01/06 SHOULD_NOT_ONLY_GET_THE_FIRST_NODE							*
 *  Joseph 11/04/06 DESCRIPTION_REMOVE_XFNAME									*
 *  Iris 12/02/2006 SHOULD_NOT_INIT_AFTER_TREE_STRUCTURE_CHANGED				*
 *  SY 2006-12-18 QA70-9217 v8.0528 EDITABLE_PART_ON_NEXT_LINE_FROM_LABEL		*
 *	Sim 03-24-2007 FIX_CUSTOM_BUTTON											*
 *	Hong 03/26/07 v8/0589b ALLLOW_COMSTOMIZE_OK_BTN_LABEL						*
 *	Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK								*
 *	Jasmine 03/28/07 WIDEN_THE_LONG_TEXT_CUSTOM_BTN								*
 *	Sim 04-02-2007 CHANGE_APPLY_BUTTON_TEXT_ISSUE								*
 *	Sim 04-02-2007 CHANGE_CUSTOM_BUTTON_FORMAT									*
 *	Sim 04-09-2007 FIX_CUSTOM_BUTTON_ENABLE_ISSUE								*
 *	Joseph 04/16/07 SHOULD_NOT_ENABLE_DESCRIPTION								*
 *	CPY 04-20-2007 QA70-9659 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT					*
 *	CPY 04/20/07 QA80-9657 IMPROVE_EXPORT_GRAPH_BY_SKIP_HIDDEN					*
 *	CPY 4/23/07 NODE_HANDLER_NOT_GETTING_CALL_LEAD_TO_DISABLE_ENABLE_PROBLEM_ON_START
 *	CPY 4/23/07 ON_RECONSTRUCT_NOT_FOLLOWING_OLD_CODE_WITH_NODE_HANDLER_CALLING *
 *	CPY 4/23/07 QA70-9651 NLFIT_DATA_MODE_CHANGE_PROPER_EVENT					*
 *	CPY 4/27/07 DESCRIPTION_WITHOUT_THEME_NOT_RESIZE_PROPERLY					*
 *	Jake 04/29/07 RESIZE_CUSTOM_BUTTONS_SIZE									*
 *	Sim 05-09-2007 FIX_KEEP_ERR_MSG												*
 *	CPY 5/9/07 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT_NOT_WORKING_IN_PAGE_XF_BAR		*
 *	Sim 05-16-2007 FIX_CLEAR_ERR_MSG_FOR_XF_BAR									*
 *	Sim 05-17-2007 FIX_ERR_MSG_WITH_GETN_EVENT_TAGNAME							*
 *	AW 05/23/07 QA80-9821 v8.0622 SUPPORT_GETN_OC_EVENT							*
 *  Joseph 06/21/07 v8.0647 FIX_BUG_GET_BUTTON_DISABLE                          *
 *	Sim 06-22-2007 OPTION_TO_KEEP_BUTTON_STATUS_ON_EVENT						*
 *	Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW 					*
 *	Sim 07-10-2007 DYNA_DLG_DERIVED_CLASS_NEED_XFBITS							*
 *	Sim 07-24-2007 FIX_KEY_BUTTON_NAME_FOR_XF_WIZARD							*
 *	Sim 07-25-2007 FIX_FOR_EMPTY_KEY_STRING										*
 *	Sim 07-27-2007 FIX_REMOVE_REDUNDANT_SPACES									*
 *	Sim 07-27-2007 IMPROVE_BUTTON_ENABLE_ISSUE									*
 *	COMPILE_ERR_AFTER_SIM_IMPROVE_BUTTON_ENABLE_ISSUE							*
 *	Jasmine 08/03/07 #10143 RETRISTRY_EACH_TREENODE_BRANCH						*
 *	Sim 08-24-2007 CHANGE_CLOSE_BTN_NAME										*
 *	Sim 09-14-2007 MAKE_CONSISTENT_PAGE_ID_FOR_FIX_GETN_DIALOG_MESSAGE_ERROR	*
 *	YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP									*
 *	Sim 10-31-2007 FIX_RESET_BUTTON_NAME										*
 *	Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME	*
 *	Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM								*
 *	Sim 11-12-2007 SUPPORT_AUTO_MECHANISM_AFTER_GUI_CHANGE_VALUE				*
 *	Folger 11/14/07 ADD_HELP_ID_ATTRIBUTE										*
 *	Sim 12-03-2007 MORE_IMPROVE_UPDATE_DYNA_CONTROL_MECHANISM					*
 *	Sim 12-07-2007 MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED					*
 *	CPY 12/14/07 CUSTOM_BUTTON_CODE_CLEAN										*
 *	YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION				*
 *	Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON								*
 *	Sim 02-29-2008 QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG					*
 *	Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU						*
 *	Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
 *	Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM						*
 *	Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU			*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ						*
 *	Folger 04/21/08 FIX_THEME_RESET_NOT_WORK_IN_NLFIT							*
 *	Sim 04-22-2008 FIX_SCRIPT_MODE_ERROR_TO_SHOW_DIALOG							*
 *	Sim 05-17-2008 CLEAR_CODE_FOR_GET_GETN_TREE									*
 *	Sim 05-17-2008 SHIFT_GETN_TREE_STORAGE_ON_NEW_XF_WIZARD						*
 *	CPY 5/21/08 QA70-11576 XF_DLG_ERR_MSG_SHOULD_HAVE_MORE_OBVIOUS_SHOWING		*
 *	Jasmine 05/22/08 EXPORT_ERRMSGBOX_SETTING_TO_DEVIRATED_CLASS				*
 *	EJP 2008-05-30 v8.0875 FIX_MISSING_SHEET_INFO_NODES_IN_BOOK_ORGANIZER		*
 *	Folger 06/16/08 REPLACE_PRINTF_WITH_ERROR_REPORT_IN_DYNADLG					*
 *	Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
 *	Sim 07-03-2008 CLEAR_THEME_SAVE_METHOD										*
 *	Sim 07-04-2008 IMPROVE_DEFAULT_THEME_MECHANISM								*
 *  Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
 *	Folger 07/23/08 FIX_XF_ERROR_MESSAGE_SHOW_STATUS_IN_PA						*
 *	TD 08-05-2008 QA80-11949 TRY_TO_HOOKUP_WINDOWS_WM_SIZE_TO_INVALIDATE		*
 *	Folger 08/26/08 FIX_THEME_COMBO_NOT_UPDATED_AFTER_DELETE_THEME				*
 *	Folger 08/29/08 QA80-12120 CENTRALIZE_XF_ERROR_MSEEAGE_PARSING_CODE			*
 *	Sim 09-05-2008 CLEAN_DEFAULT_THEME											*
 *	Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE				*
 *	Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING								*
 *	Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE			*
 *	Sim 10-17-2008 QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE			*
 *	Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Sim 10-31-2008 INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE						*
 *	Sim 12-08-2008 FIX_RESET_DEFAULT_THEME_POPUP_ERR							*
 *	Folger 12/17/08 v8.0987d MOVE_BOOK_SHEET_THEME_RIGHT_BEFORE_DEFAULT_THEME	*
 *	Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
 *	Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
 *	Hong 12/24/08 QA80-12798 v8.0990c THEME_COMPARE_NEED_DISPLAY_REF_VAL_IN_ATTRIB
 *	Hong 01/07/09 QA80-12798-P2 FIX_MODAL_DLG_BECOME_MODALLESS_AFTER_POPUP_THEME_COMPARING_DLG
 *	Hong 01/09/09 QA80-12798 v8.995 THEME_COMPARE_DUMP_HIDDEN_NODE_LIKE_ANCHOR_IN_PA
 *	Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5				*
 *	Sim 02-05-2009 QA80-13072 FIX_DYNA_DLG_UPDATE_COMBO_STR_ON_TREE_NODE_EVENT	*
 *	Folger 02/09/09 QA80-12786 NODE_NUMBER_FORMAT_CHANGE_SHOULD_UPDATE_DYNACONTROL_BY_SET_TREE
 *	Folger 02/18/09 F1_HELP_ON_STATS_XFS_IN_JAPANESE_SHOULD_OPEN_XFUNCTION_CHM	*
 * Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG					*
 *	Folger 04/14/09 GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING	*
 *	Folger 06/15/09 QA80-13771 GRAPH_BROWSER_SUPPORT_GENERAL_CUSTOMIZATION_BY_SPECIFIC_FILTER_FUNCTION
 *	Kyle 07/14/2009 SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
 *	Jasmine 07/14/09 NANOSZIER_NEED_DESCRIPTION_TO_REMINDER_USER				*
 *	Sim 09-21-2009 FIX_NLFIT_THEME_SETTING_DISAPPEAR_ON_THEME_MENU				*
 *	Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
 *	Folger 09/23/09 Q8A0-14339-P6 NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
 *	Hong 11/09/09 QA80-12798 ALWAYS_ANABLE_COMPARE_TO_BEABLE_COMPARE_WITH_SYSTEM_DEFAULT
 *	Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG		*
 *	Folger 11/18/09 QA81-14676 GETN_PREVIEW_DIALOG_NOT_RESIZE_WELL_FOR_HINT_TEXT*
 *	Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED					*
 *	Folger 01/25/10 QA81-15036 SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER		*
 *	Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
 *	Folger 06/12/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS		*
 *	Sophy 8/23/2010 ORG-870-P1 NEW_DESIGN_FOR_BLINKING_ERR_MSG_ON_DYNDLG		*
 *	Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE				*
 *	Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING		*
 *	Hong 12/23/10 ORG-1750-P2 FIX_RUNTIME_TIME_IN_THEME_SETTING_DLG				*
 *	Hong 01/19/11 ORG-1750 OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
 *	Hong 01/30/11 ORG-2161 DELAY_X_RANGE_GUI_TO_NEXT_RELASE						*
 *	Folger 03/10/2011 NICE_UPDATE_GETN_AVOID_FLESHING							*
 *	Folger 05/25/2011 ORG-2954-P1 DYNACTRL_NO_REFRESH_IF_HIDDEN					*
 *  Zech 08/11/2011 ORG-3492-P1 LIST_THEME_FILES_IN_EXE_FOLDER					*
 *	Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
 *	Hong 01/19/11 ORG-1750 OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
 *	Folger 09/07/2011 ORG-3718-P1 DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
 *	Sophy 9/14/2011 ORG-3797-P1 GADGET_PREFERENCE_APPLY_BROKEN_AFTER_ADD_THEME_SUPPORT
 *	Sophy 9/14/2011 ORG-1931-S1 GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
 *	Folger 09/15/2011 ORG-3718-P3 PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
 *	Hong 11/02/11 ORG-1750-P5 MORE_THEME_SAVE_X_RANGE_ONLY_FOR_TOOLS_HAVE_INPUT_RANGE
 *	Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG	*
 *	Folger 01/19/2012 ORG-4841-P1 FAILED_TO_SELECT_WORKSHEET_IF_ALREADY_ACTIVE_FROM_INTERATIVE_CONTROL
 *	Kenny 03/05/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC	*
 *	Folger 03/23/2012 ORG-5342-P1 BETTER_RESIZE_XF_THEME_DESCRIPTION			*
 *	Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
 *	Folger 05/03/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS			*
 *	Kenny 05/23/2012 ORG-4042-P9 DYNA_DLG_RECONSTRUCT_GRID_FLICKER				*
 *  Iris 7/06/2012 ORG-6033-P2 TO_FIX_KEEP_DLG_SIZE_ON_BRANCH_EXPAND_COLLAPSE_NOT_WORK
 *------------------------------------------------------------------------------*/
 
#ifndef	_DYNA_DLG_H
#define	_DYNA_DLG_H
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#include <ocu.h>

/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
#include <xfbase.h>
/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION

/// Iris 7/11/2011 ORG-2629 CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS
#include "MenuBase.h"
#include "theme_utils.h"
/// end CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS

//#define THE_TREE_NODE	m_paramTree.FirstNode
#define THE_TREE_NODE GetTree()
#define THEMEGROUP_MINSIZE 100  ///Joseph 10/09/06	CHANGE_THEME_GROUP_SIZE
#define TREE_CTRL_VAR			m_DynaCntrl
///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
#define	DYNA_TAB_CNTRL			m_tab
#ifndef	DYNA_TAB_ID
#define	DYNA_TAB_ID				0
#endif	/// DYNA_TAB_ID
///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
//---- CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
#define DYNACONTROL_UPDATE_RECONSTRUCT (DYNACONTROL_UPDATE_CHOICES | DYNACONTROL_UPDATE_VALUE | DYNACONTROL_UPDATE_ENABLE)
//----
///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
#define STR_BRANCH_COLLAPSED "Branch Collapsed"
///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG

///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
#define STR_ADDITION_DLG_SETTING	"AdditionDialogSetting"
///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME

///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
#define STR_ERR_MSG_SHOW_TIME		"ErrMsgShowTime"
///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG

#define STR_NEW_APPLY_BUTTON_TEXT	"Button:"	///Joseph 01/28/07 CHANGE_XF_APPLY_BUTTON_TEXT

///---Sim 10-31-2007 FIX_RESET_BUTTON_NAME
#define STR_BTN_NAME_OK			_LE("OK")
#define STR_BTN_NAME_CANCEL		_LE("Cancel") //CPY 11/5/07 added _L for all these here, as we saw XF dialog Cancel button not localized
#define STR_BTN_NAME_APPLY		_LE("Apply")
#define STR_BTN_NAME_UNDO		_LE("Undo")
#define STR_BTN_NAME_CLOSE		_LE("Close")
///---END FIX_RESET_BUTTON_NAME


///Jasmine 03/28/07 WIDEN_THE_LONG_TEXT_CUSTOM_BTN
#define CUSTOM_BTN_MAX_WIDTH		9
#define CUSTOM_WIDTH_INCREMENT		30
///End WIDEN_THE_LONG_TEXT_CUSTOM_BTN

#define CUSTOM_BTN_EDGE             30 ///Jake 04/29/07 RESIZE_CUSTOM_BUTTONS_SIZE

//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#define THEME_CONTROL_POPUP_MENU

#ifdef THEME_CONTROL_POPUP_MENU

///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
/*
#define		WM_USER_DIALOG_ON_THEME_SAVE			(WM_USER + 10000)
#define		WM_USER_DIALOG_ON_THEME_SAVE_AS			(WM_USER + 10001)
#define		WM_USER_DIALOG_ON_THEME_COMBO_CHANGE	(WM_USER + 10002)
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
#define		WM_USER_DIALOG_ON_THEME_SETTING			(WM_USER + 10003)
#define		WM_USER_DIALOG_IS_THEME_SETTING			(WM_USER + 10004)
///---END QA80-11371 THEME_SAVING_OPTIONS
*/
///---Sim 10-16-2008 QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
//#define		WM_USER_DIALOG_ON_LOAD_THEME			(WM_USER + 10005)
///---END QA80-12375 FIX_THEME_SETTING_FAIL_SAVE_IN_THEME_FILE
///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

/// Iris 7/11/2011 ORG-2629 CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS
//---------moved to MenuBase.h file ---------
/*
enum
{
	THEME_MENU_INVALID = -1,
	THEME_MENU_SAVE_AS_DEFAULT,
	THEME_MENU_SAVE_TO_SHEET,
	THEME_MENU_SAVE_TO_BOOK,
	THEME_MENU_SAVE,
	THEME_MENU_SAVE_AS,
	THEME_MENU_RESET,
	//------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
	THEME_MENU_DELETE,
	//------
	/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	THEME_MENU_COMPARE,
	/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	THEME_MENU_DUMPING,
	///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	
	THEME_MENU_SETTING, ///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	//add more items before THEME_MENU_LOADING_START

	///------ Folger 06/12/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	THEME_MENU_SAVE_TO_GRAPH,
	THEME_MENU_SAVE_TO_LAYER,
	THEME_MENU_SAVE_TO_PLOT,
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
	
	THEME_MENU_LOADING_START,
};


//add new menu item steps:
//1. add new enumerator before THEME_MENU_LOADING_START
//2. do both (1) [add new menu item] and (2) [add emumerator defined in Step1 into m_vnIndecesMap] in order
//
//see THEME_MENU_SAVE_AS_DEFAULT for example


///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
#define		THEME_MENU_ADD_SEPARATOR \
			Add(NULL, OnMenuItem, MF_SEPARATOR); \
			m_vnIndecesMap.Add(THEME_MENU_INVALID)
///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG

///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
#define		AddThemeItems(_bLoad, _nSel) \
			int nSize = vsThemes.GetSize(); \
			if ( nSize > 0 ) \
			{ \
				m_nCount += nSize + 1; \
				THEME_MENU_ADD_SEPARATOR; \
				\
				vector<string>	vsThemesTmp; \
				vsThemesTmp = vsThemes; \
				vector<int>		vnCategories; \
				okutil_prepare_theme_display_names(&vsThemesTmp, &vnCategories); \
				int				nLastCategories = vnCategories[0]; \
				\
				for ( int ii=0; ii<nSize; ++ii ) \
				{ \
					int nFlag = _nSel == ii  ? MF_CHECKED : MF_UNCHECKED; \
					if ( !_bLoad ) \
						nFlag |= MF_GRAYED; \
					\
					if ( nLastCategories != vnCategories[ii] ) \
					{ \
						++m_nCount; \
						THEME_MENU_ADD_SEPARATOR; \
						nLastCategories = vnCategories[ii]; \
					} \
					Add(vsThemesTmp[ii], OnMenuItem, nFlag); \
					m_vnIndecesMap.Add(THEME_MENU_LOADING_START + ii); \
				} \
			}
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

///------ Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS
#define		STR_SAVE_AS_DEFAULT			_L("Save as <default>")
///------ End SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS

class ThemeControlMenu : public Menu
{
public:
    //------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
	/////---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	////ThemeControlMenu(bool bSave = true, bool bSheetTheme = false, bool bBookTheme = false, const vector<string> &vsThemes = NULL, int nSel = 0, bool bLoadEnable = true, bool bResetable = true)
	//ThemeControlMenu(bool bSave = true, bool bThemeSetting = false, bool bSheetTheme = false, bool bBookTheme = false, const vector<string> &vsThemes = NULL, int nSel = 0, bool bLoadEnable = true)
	/////---END QA80-11371 THEME_SAVING_OPTIONS
	/// Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
	//ThemeControlMenu(bool bSave = true, bool bThemeSetting = false, bool bSheetTheme = false, bool bBookTheme = false, const vector<string> &vsThemes = NULL, int nSel = 0, bool bLoadEnable = true, bool bDeletable = true)
	///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	//ThemeControlMenu(bool bSave = true, bool bThemeSetting = false, bool bSheetTheme = false, bool bBookTheme = false, const vector<string> &vsThemes = NULL, int nSel = 0, bool bLoadEnable = true, bool bDeletable = true, bool bComparable = true)
	ThemeControlMenu(bool bSave
		, bool bThemeSetting = false
		, bool bSheetTheme = false
		, bool bBookTheme = false
		, const vector<string> &vsThemes = NULL
		, int nSel = 0
		, bool bLoadEnable = true
		, bool bDeletable = true
		, bool bComparable = true
		, bool bLTCallable = true
	)
	///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	/// end PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
	//------ End SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
	{
		//m_nCount = 5;
		m_nChoice = -1;
		
		///------ Folger 12/17/08 v8.0987d MOVE_BOOK_SHEET_THEME_RIGHT_BEFORE_DEFAULT_THEME
		if ( bBookTheme )
		{
			//++m_nCount;
			Add(_L("Save to <Book>"), OnMenuItem);
			m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_BOOK);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		}		
		if ( bSheetTheme )
		{
			//++m_nCount;
			Add(_L("Save to <Sheet>"), OnMenuItem);
			m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_SHEET);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		}
		///------ End MOVE_BOOK_SHEET_THEME_RIGHT_BEFORE_DEFAULT_THEME
		
		Add(STR_SAVE_AS_DEFAULT, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_AS_DEFAULT);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		
		
		Add(_L("Save"), OnMenuItem, bSave ? MF_ENABLED : MF_GRAYED);
		m_vnIndecesMap.Add(THEME_MENU_SAVE);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		
		Add(_L("Save As") + STR_THREE_DOTS, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_AS);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
		
		///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
		if ( bThemeSetting )
		{
			Add(STR_LABEL_THEME_FILTER_SETTING + STR_THREE_DOTS, OnMenuItem);
			m_vnIndecesMap.Add(THEME_MENU_SETTING);
			
			//Add(NULL, OnMenuItem, MF_SEPARATOR);
			//m_vnIndecesMap.Add(THEME_MENU_INVALID);
		}
		///---END QA80-11371 THEME_SAVING_OPTIONS
		
		THEME_MENU_ADD_SEPARATOR;
		
		///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
		//Add(_L("Reset"), OnMenuItem, bLoadEnable ? MF_ENABLED : MF_GRAYED);
		Add(_L("System Default"), OnMenuItem, bLoadEnable ? MF_ENABLED : MF_GRAYED);
		///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
		m_vnIndecesMap.Add(THEME_MENU_RESET);		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU

        //------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
        Add(_L("Delete") + STR_THREE_DOTS, OnMenuItem, bDeletable? MF_ENABLED : MF_GRAYED);
		m_vnIndecesMap.Add(THEME_MENU_DELETE);
        //------

	#ifdef		_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5
        /// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES        
        if ( bComparable ) /// Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
        {
        	/// Hong 11/09/09 QA80-12798 ALWAYS_ANABLE_COMPARE_TO_BEABLE_COMPARE_WITH_SYSTEM_DEFAULT
        	// Hong, there will at least one item in combo of theme comparing dlg--empty for System Default
        	//Add(_L("Compare") + STR_THREE_DOTS, OnMenuItem, (vsThemes.GetSize() > 0) ? MF_ENABLED : MF_GRAYED);
        	Add(_L("Compare") + STR_THREE_DOTS, OnMenuItem, MF_ENABLED);
        	/// end ALWAYS_ANABLE_COMPARE_TO_BEABLE_COMPARE_WITH_SYSTEM_DEFAULT
			m_vnIndecesMap.Add(THEME_MENU_COMPARE);
        }
        /// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	#endif		//_CHANGE_PARAMS_SUPPORT_LAODING_THEME_AND_COMPARING_THEME /// Hong 02/01/09 HIDE_THEME_CONTROL_IN_CHANGE_PARAMS_DLG_IN_SR5

		///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
		if ( bLTCallable )
		{
			THEME_MENU_ADD_SEPARATOR;
			Add(_L("Generate Script"), OnMenuItem, MF_ENABLED);
			m_vnIndecesMap.Add(THEME_MENU_DUMPING);
		}
		///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
        
		m_nCount = m_vnIndecesMap.GetSize();
		
		if ( vsThemes )
		{
			///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT			
			//int nSize = vsThemes.GetSize();
			//if ( nSize > 0 )
			//{
				//m_nCount += nSize + 1;
				//THEME_MENU_ADD_SEPARATOR;
				//
				/////------ Folger 01/25/10 QA81-15036 SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
				//vector<string>	vsThemesTmp;
				//vsThemesTmp = vsThemes;
				//vector<int>		vnCategories;
				//okutil_prepare_theme_display_names(&vsThemesTmp, &vnCategories);
				//int				nLastCategories = vnCategories[0];
				/////------ End SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
				//
				//for ( int ii=0; ii<nSize; ++ii )
				//{
					//int nFlag = nSel == ii  ? MF_CHECKED : MF_UNCHECKED;
					//if ( !bLoadEnable )
						//nFlag |= MF_GRAYED;
					//
					/////------ Folger 01/25/10 QA81-15036 SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
					////Add(vsThemes[ii], OnMenuItem, nFlag);
					//if ( nLastCategories != vnCategories[ii] )
					//{
						//++m_nCount;
						//THEME_MENU_ADD_SEPARATOR;
						//nLastCategories = vnCategories[ii];
					//}
					//Add(vsThemesTmp[ii], OnMenuItem, nFlag);
					//m_vnIndecesMap.Add(THEME_MENU_LOADING_START + ii);
					/////------ End SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
				//}
			//}			
			AddThemeItems(bLoadEnable, nSel);
			///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
		}
		
	}	
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= 0 && m_nChoice < m_nCount)
		{
			//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
			//nChoice = m_nChoice;
			nChoice = m_nChoice < m_vnIndecesMap.GetSize() ? m_vnIndecesMap[m_nChoice] : m_nChoice - m_vnIndecesMap.GetSize() + THEME_MENU_LOADING_START;
			//------
			return true;
		}
		return false;
	}

protected:
	int	m_nChoice;
	int m_nCount;
	vector<int>		m_vnIndecesMap;		//------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
};
*/
///End CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS

#endif

//------ End ADD_THEME_CONTROL_POPUP_MENU

/// Iris 7/11/2011 ORG-2629 CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS
//---------moved to theme_utils.h file ---------
/*
///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
class	ThemeForceLoadFactoryHelper
{
public:
	ThemeForceLoadFactoryHelper(TreeNode& tr)
	{
		m_tr = tr;
		theme_force_load_factory_attribute_access(m_tr, THEMEFORCELOADFACTORY_SET);
	}
	~ThemeForceLoadFactoryHelper()
	{
		theme_force_load_factory_attribute_access(m_tr, THEMEFORCELOADFACTORY_RESET);
	}

private:
	TreeNode		m_tr;
};
///------ End QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
*/
///End CLEANUP_THEME_CONTROL_CODES_FOR_FILE_NEW_DLGS

class DynaDlg : public BASE_WINDOW
{
public: //CPY 9/24/06 XF_PREVIEW_DLG_NEED_PREVIEW_ON_THE_SIDE, added bPreviewOnRight
	DynaDlg()
	{
		Init();
	}
	DynaDlg(UINT nDlgID, TreeNode& tr, LPCSTR lpcszDLL, BOOL bPreviewOnRight = false) :  BASE_WINDOW(nDlgID, lpcszDLL, bPreviewOnRight)
	{
		Init();
		if(tr)
		{
			SetInputTree(tr);
			
			/// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
			int nDlgOptions;
			m_bAutoSaveBranchOpen = false;
			if( tr.GetAttribute(STR_DLG_DISPLAY_ATTRIB, nDlgOptions) )
			{
				m_bAutoSaveBranchOpen = O_QUERY_BOOL((DWORD)nDlgOptions, GETN_DISPLAY_AUTO_SAVE_BRANCH_OPEN);
			}
			///End TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		}
	}	
	
	virtual BOOL OnDestroy(void)
	{
		//m_treeEditCntrl.OnDestroy();
		///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
		/// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		if( m_bAutoSaveBranchOpen )
		///End TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		{
			SaveBranchSetting();		
		}
		///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
		TabsSaveSettings();
		InvokeHandlerOnDestroy();
		BASE_WINDOW::OnDestroy();
		return true;
	}
	
	///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	virtual string GetDlgTitle()
	{
		return "";
	}
	///Jasmine 08/03/07 #10143 RETRISTRY_EACH_TREENODE_BRANCH
	BOOL LoadBranchSetting(LPCSTR lpcszDlgTitle = NULL, LPCSTR lpcszBranch = NULL)
	{	
		string strTitle(lpcszDlgTitle); //this will support user defined dialog.
		if(strTitle.IsEmpty())
			strTitle = GetDlgTitle();  
		
		if(strTitle.IsEmpty()) 
			return true;
	
		string strBranchCollapsed;
		//if( dlg_load_registry(strTitle, STR_BRANCH_COLLAPSED, strBranchCollapsed))
		string strVal(lpcszBranch);
		if(!strVal.IsEmpty())
			strVal += "_";
		strVal += STR_BRANCH_COLLAPSED;
		if( dlg_load_registry(strTitle, strVal, strBranchCollapsed))
		{
			BitsHex bh;
			vector<byte> vbBranchCollapsed;
			if(!bh.HexStrToBits(strBranchCollapsed, vbBranchCollapsed))
				return false;
			
			if(!TREE_CTRL_VAR.SetCollapsed(vbBranchCollapsed, FALSE))
				return false;
		}
		
		return true;
	}
	
	BOOL SaveBranchSetting(LPCSTR lpcszDlgTitle = NULL, LPCSTR lpcszBranch = NULL)
	{
		string strTitle(lpcszDlgTitle); //this will support user defined dialog.
		if(strTitle.IsEmpty())
			strTitle = GetDlgTitle();  
		
		if(strTitle.IsEmpty()) 
			return true;
		
		vector<byte> vbBranchCollapsed;
		int nRet = TREE_CTRL_VAR.GetCollapsed(vbBranchCollapsed, FALSE);
		if(nRet < 0)
			return false;
		
		if(nRet > 0) //if dialog has no branch, need not to save
		{
			BitsHex bh;
			string	strBranchCollapsed;
			if(!bh.BitsToHexStr(vbBranchCollapsed, strBranchCollapsed))
				return false;
			
			//if(!dlg_save_to_registry(strTitle, STR_BRANCH_COLLAPSED, strBranchCollapsed))
			string strVal(lpcszBranch);
			if(!strVal.IsEmpty())
				strVal += "_";
			strVal += STR_BRANCH_COLLAPSED;
			if(!dlg_save_to_registry(strTitle, strVal, strBranchCollapsed))
				return false;
		}
		
		return true;
	}
	///End RETRISTRY_EACH_TREENODE_BRANCH
	///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	
	///Jasmine 11/01/06 SHOULD_NOT_ONLY_GET_THE_FIRST_NODE
	//TreeNode GetTree(bool bEditTree = true)
	///---Sim 05-17-2008 SHIFT_GETN_TREE_STORAGE_ON_NEW_XF_WIZARD
	//TreeNode GetTree(bool bEditTree = true, bool bSkipFirstNode = true)
	virtual TreeNode GetTree(bool bEditTree = true, bool bSkipFirstNode = true)
	///---END SHIFT_GETN_TREE_STORAGE_ON_NEW_XF_WIZARD
	{
		if(bEditTree && !m_bUseInputTree)
			//return m_paramTree.FirstNode;
			return bSkipFirstNode? m_paramTree.FirstNode : m_paramTree;
	///End SHOULD_NOT_ONLY_GET_THE_FIRST_NODE
		else
			return m_input_tr;
	}
	void UpdateEditTreeNode(TreeNode& tr) { tr = m_input_tr;}
	///Hong 8/01/06
	void SetbUseInputTree(bool bUse = false)
	{
		m_bUseInputTree = bUse;
	}
	///end
	//---- CPY 5/9/07 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT_NOT_WORKING_IN_PAGE_XF_BAR
	void OnSetGetN(TreeNode& tr)
	{
		if(tr)
		{
			int nXFBits;
			tr.GetAttribute(STR_XF_BITS, nXFBits);
			m_dwXFBits = nXFBits;
		}
	}
	//----
	void SetInputTree(TreeNode& tr, bool bMakeLocalCopy = true)
	{
		m_input_tr = tr;
		//---- CPY 5/9/07 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT_NOT_WORKING_IN_PAGE_XF_BAR
		/*
		//----- CPY 04-20-2007 QA70-9659 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT
		if(tr)
		{
			int nXFBits;
			tr.GetAttribute(STR_XF_BITS, nXFBits);
			m_dwXFBits = nXFBits;
		}
		//-----
		*/
		OnSetGetN(tr);
		//----
		m_bUseInputTree = bMakeLocalCopy? false:true;
		if(bMakeLocalCopy)
		{
			if(m_paramTree.FirstNode)
				m_paramTree.Reset();
			m_paramTree.AddNode(tr.Clone());
		}
	}
	void OnInputTreeModified()
	{
		if(m_bUseInputTree) return;
		
		if(m_paramTree.FirstNode)
			m_paramTree.Reset();
		m_paramTree.AddNode(m_input_tr.Clone());
		UpdateDynaControl(true, GETNEVENT_ON_INIT, true);
	}
	
	Tree* GetTreeRoot() {return &m_paramTree;} //----- CPY 5/7/2007 PAGE_XFBAR_SHOW_RECALCULATE_ALWAYS_NEED_GENERAL_XF_TO_GETN_CLEANUP
	
	TreeNode InitTree()
	{
		if(m_paramTree.FirstNode)
			m_paramTree.Reset();

		TreeNode tr = m_paramTree.AddNode();
		return tr;
	}
	TreeNode UpdateInputTree()
	{
		m_input_tr.Replace(m_paramTree.FirstNode);
		return m_input_tr;
	}
	void SetGrayBackground(bool bSet = true) {m_bGrayBackground = bSet;}
	/// SY 2006-12-18 QA70-9217 v8.0528 EDITABLE_PART_ON_NEXT_LINE_FROM_LABEL
	void Set1ColIndent(bool bSet = true) {m_b1ColIndent = bSet;}
	/// end EDITABLE_PART_ON_NEXT_LINE_FROM_LABEL

	///Kenny 04/10/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	void SetContainerTitle(LPCSTR lpcszContainerTitle) { m_strContainerTitle = lpcszContainerTitle; }
	string GetContainerTitle() { return m_strContainerTitle; }
	///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	
	///---Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
	DWORD GetXFBits() {return m_dwXFBits;}
	///---END QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED

	///------ Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
	void	CheckResizeTextControl(Control ctrlText, Control ctrlOnRight)
	{
		if ( !ctrlText || !ctrlOnRight )
			return;

		RECT	rr;
		GetClientRect(ctrlText, rr);
		
		int		nWidth;
		ctrlText.Measure(ctrlText.Text, &nWidth, TRUE);
		if ( nWidth > RECT_WIDTH(rr) )
		{
			int		nn = nWidth - RECT_WIDTH(rr);
			rr.right += nn;
			ctrlText.MoveWindow(&rr);
			
			GetClientRect(ctrlOnRight, rr);
			rr.left += nn;
			ctrlOnRight.MoveWindow(&rr);
		}
	}
	///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE

protected:
	virtual void InvokeHandlerOnDestroy() //---CPY 10/24/06 XF_DLG_DESTROY_EVENT
	{
		invokeBasicGlobalEvent(GETNE_ON_DESTORY);   ///Joseph 10/13/06 Add destory event
	}
	//---- CPY 8/28/06 IMPASCI_XF_SHOW_NEED_TO_UPDATE_DLG_SIZE_WHEN_TREE_CHANGED
	virtual void OnTreeReinit() { }
	//----

	///---Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW
	virtual DWORD OnExternalMessage(uint wParam, uint lParam)
	{
		TreeNode tr = GetTree();
		if(tr)
		{
			tr.SetAttribute(STR_GO_MSG_INFO_1_ATTRIB, (int)wParam);
			tr.SetAttribute(STR_GO_MSG_INFO_2_ATTRIB, (int)lParam);
		}	
		invokeBasicGlobalEvent(GETNE_ON_EXTERNAL_MSG);
		return 0;
	}
	///---END SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW
	
	///---Sim 06-22-2007 OPTION_TO_KEEP_BUTTON_STATUS_ON_EVENT
	DWORD OnGetButtonStatus(uint wParam, uint lParam)
	{
		DWORD dwEnable;
		
		if ( m_dwXFBits & DYNALAYOUT_KEEP_BTN_STATUS )
		{
			//if ( !GetEnableButtonStatus(dwEnable, (int)wParam) )
			if ( !GetEnableButtonStatus(dwEnable, GETNE_ON_VALUE_CHANGE) )
				dwEnable = 0; // failed to get button status
		}
		else
			dwEnable = GETNGEVT_ENABLE_ALL_BUTTONS;
		
		return dwEnable;		
	}
	///---END OPTION_TO_KEEP_BUTTON_STATUS_ON_EVENT
	BOOL OnReconstructGrid(uint wParam, uint lParam)
	{
		//if(m_treeEditCntrl.OnReconstructGrid(wParam, lParam))
		//	ResizeDlgToFit();
		
		// For now just set again the entire tree:
		TreeNode		tree = m_DynaCntrl.GetTreeNode(-1);
		if (!tree.IsValid())
		{
			ASSERT(FALSE);
			return FALSE;
		}
		
		/// Iris 12/02/2006 SHOULD_NOT_INIT_AFTER_TREE_STRUCTURE_CHANGED
		// if tree structure changed, for now will call event1 two times, one is called by node changed, one is called by init. So remove the call of the second time.
		/*
		/// YuI need to recontruct Dyna dialog if tree structure changes
		//	UpdateDynaControl(true, false, false);
		//BOOL bInit = (wParam & GRID_CHANGE_TREE_STRUCTURE) ? TRUE : FALSE;
		*/
		/// YuI 12/21/06 dyna control is not properly updated if event handler changes the tree structure
		// I reverted the code back to the original and e-mail Iris abot the problem
		//	BOOL 	bInit = false;
		BOOL bInit = (wParam & GRID_CHANGE_TREE_STRUCTURE) ? TRUE : FALSE;
		/// end YuI
		///END SHOULD_NOT_INIT_AFTER_TREE_STRUCTURE_CHANGED
		BOOL bFromGUIChanged = (lParam); ///---Sim 10-17-2008 QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		
		//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
		//UpdateDynaControl(true, bInit, false, true);
		if(wParam & GRID_CHANGE_DYNA_ANY_CHANGE)
		{
			DWORD dwUpdates = DYNACONTROL_UPDATE_CHOICES | DYNACONTROL_UPDATE_VALUE | DYNACONTROL_UPDATE_ENABLE;
			if(GRID_CHANGE_LABEL & wParam)
				dwUpdates |= DYNACONTROL_UPDATE_LABELS;
			///------ Folger 02/09/09 QA80-12786 NODE_NUMBER_FORMAT_CHANGE_SHOULD_UPDATE_DYNACONTROL_BY_SET_TREE
			if(GRID_CHANGE_NUM_FORMAT & wParam)
				dwUpdates |= DYNACONTROL_UPDATE_NUM_FORMAT;
			///------ End NODE_NUMBER_FORMAT_CHANGE_SHOULD_UPDATE_DYNACONTROL_BY_SET_TREE
			///------ Folger 04/14/09 GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING
			if ( GRID_CHANGE_GROUP_BRANCH & wParam )
				dwUpdates |= DYNACONTROL_UPDATE_GROUP_BRANCH;
			///------ End GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING
			///---Sim 02-05-2009 QA80-13072 FIX_DYNA_DLG_UPDATE_COMBO_STR_ON_TREE_NODE_EVENT
			if( GRID_CHANGE_COMBOSTR & wParam )
				dwUpdates |= DYNACONTROL_UPDATE_COMBOS;
			///---END QA80-13072 FIX_DYNA_DLG_UPDATE_COMBO_STR_ON_TREE_NODE_EVENT
			//--------------------- CPY 4/23/07 ON_RECONSTRUCT_NOT_FOLLOWING_OLD_CODE_WITH_NODE_HANDLER_CALLING
			//UpdateDynaControl(true, bInit?GETNEVENT_ON_INIT:0, false, dwUpdates);
			BOOL bCallNodeHandlers = (wParam & GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE)? false:true;
			///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			//UpdateDynaControl(true, bInit?GETNEVENT_ON_INIT:0, bCallNodeHandlers, dwUpdates);
			DWORD dwEventType = (bInit ? GETNEVENT_ON_INIT : 0);
			///---Sim 10-17-2008 QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			//dwEventType |= GETNEVENT_ON_RECONSTRUCT;
			dwEventType |= (bFromGUIChanged ? GETNEVENT_ON_GUI_CHANGED : 0);
			///---END QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			///------ Folger 03/10/2011 NICE_UPDATE_GETN_AVOID_FLESHING
			//UpdateDynaControl(true, dwEventType, bCallNodeHandlers, dwUpdates);
			NiceUpdateDynaControl(true, dwEventType, bCallNodeHandlers, dwUpdates);
			Invalidate();		/// Kenny 05/23/2012 ORG-4042-P9 DYNA_DLG_RECONSTRUCT_GRID_FLICKER
			///------ End NICE_UPDATE_GETN_AVOID_FLESHING
			///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			//---------------------
			//---- CPY 8/28/06 IMPASCI_XF_SHOW_NEED_TO_UPDATE_DLG_SIZE_WHEN_TREE_CHANGED
			if(bInit)
				OnTreeReinit();
			//----
		}
		//------
		/// end YuI
		///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
		/*
		//---- CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS		
		//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE, comment out it here, do it in OnMsgBox
		OnEableOKButtons((wParam & GRID_CHANGE_DISABLE_OK)? false:true);// OK and Apply buttons /// Iris 10/30/06 put this back since CP's new logic
		//---
		//----
		*/
		if( is_xf_gui_getn_tree(GetTree()) && (wParam & GETNGEVT_ENABLE_ALL_BUTTONS))
		{
			///Joseph 04/23/07 FIX_BUG_ENABLE_BUTTONS_ON_CHANGE_GUI
			//change gui, enable/disable buttons, event should be GETNE_ON_VALUE_CHANGE 
			/*
			//---- CPY 02/05/07 GETN_DLG_ADD_MORE_BUTTON_EVENT
			//OnEableButtons((wParam & GRID_CHANGE_DISABLE_OK)? false:true);// OK and Apply buttons /// Iris 10/30/06 put this back since CP's new logic
			OnEnableButtons(wParam);
			
			//----
			*/
			OnEnableButtons(wParam, GETNE_ON_VALUE_CHANGE);
			///End FIX_BUG_ENABLE_BUTTONS_ON_CHANGE_GUI
		}
		///End GETN_BOX_ADD_APPLY_BUTTON
		return TRUE;
	}
	BOOL	OnSelectionChange()
	{
		return m_DynaCntrl.OnSelectionChange();
	}
	
	/// YuI 07/19/06 PROPER_INTERACTIVE_DROP_DOWN_FOR_MATRIX_OBJECT
	BOOL	OnChangeLayer()
	{
		return m_DynaCntrl.OnChangeLayer();
	}
	
	virtual	BOOL	OnChangePage()
	{
		return m_DynaCntrl.OnChangePage();
	}
	
	BOOL	OnChangeDataset()
	{
		return m_DynaCntrl.OnChangeDataset();
	}
	/// end PROPER_INTERACTIVE_DROP_DOWN_FOR_MATRIX_OBJECT

	///------ Folger 01/19/2012 ORG-4841-P1 FAILED_TO_SELECT_WORKSHEET_IF_ALREADY_ACTIVE_FROM_INTERATIVE_CONTROL
	BOOL	OnPageNCLButtonDown(Page pg, LPVOID lp)
	{
		return m_DynaCntrl.OnPageNCLButtonDown();
	}
	///------ End FAILED_TO_SELECT_WORKSHEET_IF_ALREADY_ACTIVE_FROM_INTERATIVE_CONTROL
	
	///Joseph 02/25/06 DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS
	////---- CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
	//virtual void OnEnableButtons(DWORD dwEnable) { }// OK and Apply buttons
	virtual void OnEnableButtons(DWORD dwEnable, int nEvnetID = GETNE_ON_INIT) { }// OK and Apply buttons
	//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
	virtual BOOL OnClickCustomButton(int nID) {out_int("id = ", nID); return true;}
	BOOL OnClickCustomButtom(Control ctrl)
	{
		HWND hWnd = ctrl.GetSafeHwnd();
		int nID = GetDlgCtrlID(hWnd);
		return OnClickCustomButton(nID);
	}
	//--------
		///Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS
	void 	EnableCustomButtons(DWORD dwEnable)
	{
#ifndef	_SPLITTER_CONTORL_H
		//-------- CPY 2/26/2007 ADDING_CUSTOM_BUTTON4
		/*
		Control ctlOKButton;
		///Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY
		ctlOKButton = GetItem(IDC_GETN_CUSTOM_BTN1);
		if(ctlOKButton)
			ctlOKButton.Enable = (dwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON1)? true:false;
		ctlOKButton = GetItem(IDC_GETN_CUSTOM_BTN2);
		if(ctlOKButton)
			ctlOKButton.Enable = (dwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON2)? true:false;
		ctlOKButton = GetItem(IDC_GETN_CUSTOM_BTN3);
		if(ctlOKButton)
			ctlOKButton.Enable = (dwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON3)? true:false;
		ctlOKButton = GetItem(IDC_GETN_CUSTOM_BTN4);
		if(ctlOKButton)
			ctlOKButton.Enable = (dwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON4)? true:false;
		*/
		for(int ii = 1, jj = IDC_GETN_CUSTOM_BTN1; ii <= CUSTOM_BUTTONS_COUNT; ii++, jj++)
		{
			Control btn = GetItem(jj);
			///---Sim 04-09-2007 FIX_CUSTOM_BUTTON_ENABLE_ISSUE
			//DWORD dwBits = CUSTOM_BUTTON_TO_GETNEVENT(ii);
			DWORD dwBits = CUSTOM_BUTTON_TO_GETN_ENABLE(ii);
			///---END FIX_CUSTOM_BUTTON_ENABLE_ISSUE
			if(btn)
				btn.Enable = (dwEnable & dwBits)? true:false;
		}
		//--------
		///End ENABLE_CUSTOM_BUTTONS_SEPARATELY
#endif
	}
	
	///---Sim 10-31-2007 FIX_RESET_BUTTON_NAME
	void SetDefaultButtonName()
	{
		/// Hong 11/06/07 v8.0741 MORE_LOCALIZATION
		/*
		setBtnName(IDOK, STR_BTN_NAME_OK);
		setBtnName(IDCANCEL, STR_BTN_NAME_CANCEL);
		setBtnName(IDC_APPLY, STR_BTN_NAME_APPLY);
		setBtnName(IDC_UNDO_BTN, STR_BTN_NAME_UNDO);
		setBtnName(IDC_BTN_CLOSE, STR_BTN_NAME_CLOSE);
		*/
		setBtnName(IDOK, GetLocalized(STR_BTN_NAME_OK));
		setBtnName(IDCANCEL, GetLocalized(STR_BTN_NAME_CANCEL));
		setBtnName(IDC_APPLY, GetLocalized(STR_BTN_NAME_APPLY));
		setBtnName(IDC_UNDO_BTN, GetLocalized(STR_BTN_NAME_UNDO));
		setBtnName(IDC_BTN_CLOSE, GetLocalized(STR_BTN_NAME_CLOSE));
		/// end MORE_LOCALIZATION
	}
	///---END FIX_RESET_BUTTON_NAME

	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	/// Kenny 03/13/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
	//void	InitTabControl()
	virtual void	InitTabControl()
	/// End TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
	{
		if ( 0 != DYNA_TAB_ID )
		{
			#ifndef		_SPLITTER_CONTORL_H
			int			nn;
			TreeNode	tr = GetTree();
			if ( tr.GetAttribute(STR_MOVE_FIRST_SUBNODES_INTO_TABS_ATTRIB, nn) && nn )
			{
				m_tab = GetItem(DYNA_TAB_ID);
				m_tab.Visible = TRUE;

				m_nLeafCount = 0;
				m_nTabsOptimalWidth = 0;

				nn = 0;
				TreeNode	trParent = TabsDisplayNodeParent(tr);
				foreach ( TreeNode trNode in trParent.Children )
				{
					if ( 0 == trNode.Show )
						continue;
					
					if ( !trNode.FirstNode )
					{
						++m_nLeafCount;
						continue;
					}
					
					string		str;
					trNode.GetAttribute(STR_LABEL_ATTRIB, str);
					m_tab.InsertItem(nn++, str);
					m_vsTabBranches.Add(trNode.tagName);
				}
				if ( m_nLeafCount > 0 )
				{
					m_tab.InsertItem(0, _L("Settings"));
				}

				DWORD	nTab = 0;
				TabsLoadSettings(nTab);
				///Jasmine 03/31/2011 REGISTRY_VALUE_MAY_EXCEED_CURRENT_TAB_COUNT
				if(m_tab.GetItemCount() <= nTab) nTab = m_tab.GetItemCount()-1;
				///End REGISTRY_VALUE_MAY_EXCEED_CURRENT_TAB_COUNT
				TabsPrepareNode(nTab);
				m_tab.SetCurSel(nTab);
			}
			#else		// !_SPLITTER_CONTORL_H
			ASSERT(FALSE);
			#endif		// !_SPLITTER_CONTORL_H
		}
	}

	BOOL	OnTabChange(Control ctrl)
	{
		TabsPrepareNode(m_tab.GetCurSel());
		NiceUpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI, true, 0, true);
		return TRUE;
	}

	///------ Folger 03/10/2011 NICE_UPDATE_GETN_AVOID_FLESHING
	bool	NiceUpdateDynaControl(bool bResize = true, DWORD dwEventType = 0, bool bCallNodesHandlers = false, DWORD dwUpdateBits = 0, bool bSkipFirstNode = true)
	{
		/// Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
		//TREE_CTRL_VAR.SendMessage(WM_SETREDRAW, FALSE);
/// Kenny 05/23/2012 ORG-4042-P9 DYNA_DLG_RECONSTRUCT_GRID_FLICKER
//#ifndef __PA_FLICKER_FREE
/// End DYNA_DLG_RECONSTRUCT_GRID_FLICKER
		TREE_CTRL_VAR.SetRedraw(FALSE);
/// Kenny 05/23/2012 ORG-4042-P9 DYNA_DLG_RECONSTRUCT_GRID_FLICKER
//#endif // __PA_FLICKER_FREE
/// End DYNA_DLG_RECONSTRUCT_GRID_FLICKER
		/// End REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG

		bool	bReturn = UpdateDynaControl(bResize, dwEventType, bCallNodesHandlers, dwUpdateBits, bSkipFirstNode);

		/// Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
		//TREE_CTRL_VAR.SendMessage(WM_SETREDRAW, TRUE);
		//InvalidateRect(GetSafeHwnd(), NULL, TRUE);
/// Kenny 05/23/2012 ORG-4042-P9 DYNA_DLG_RECONSTRUCT_GRID_FLICKER
//#ifndef __PA_FLICKER_FREE
/// End DYNA_DLG_RECONSTRUCT_GRID_FLICKER
		TREE_CTRL_VAR.SetRedraw(TRUE);
		TREE_CTRL_VAR.RedrawWindow(NULL, NULL, (RDW_FRAME | RDW_ERASE | RDW_INVALIDATE | RDW_ALLCHILDREN));
/// Kenny 05/23/2012 ORG-4042-P9 DYNA_DLG_RECONSTRUCT_GRID_FLICKER
//#endif // __PA_FLICKER_FREE
/// End DYNA_DLG_RECONSTRUCT_GRID_FLICKER
		/// End REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG

		return bReturn;
	}
	///------ End NICE_UPDATE_GETN_AVOID_FLESHING

	BOOL	OnAfterExpandCollapse(uint wParam, uint lParam)
	{
		if ( wParam == OSC_ON_OTHER_CHANGES )
			return true;

		/// Iris 7/06/2012 ORG-6033-P2 TO_FIX_KEEP_DLG_SIZE_ON_BRANCH_EXPAND_COLLAPSE_NOT_WORK
		int nRow = -1;
		m_DynaCntrl.GetActiveTreeNode(nRow);
		TreeNode	trN = m_DynaCntrl.GetTreeNode(nRow);
		if( trN )
		{
			int nOptions;
			if( trN.GetAttribute(STR_ATTRIB_BRANCH, nOptions) )
			{
				if( wParam == OSC_ON_EXPAND_BRANCH && nOptions & GETNBRANCH_KEEP_SIZE_ON_EXPAND )
					return false;
				if( wParam == OSC_ON_COLLAPSE_BRANCH && nOptions & GETNBRANCH_KEEP_SIZE_ON_COLLAPSE )
					return false;
			}
		}
		///End TO_FIX_KEEP_DLG_SIZE_ON_BRANCH_EXPAND_COLLAPSE_NOT_WORK
		
		resizeDlgToFit();
		return TRUE;
	}
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	
/// Hong 03/26/07 v8/0589b ALLLOW_COMSTOMIZE_OK_BTN_LABEL
/// Last updated by Sim 04-02-07
/**$ temp comments for programmer, need clean later
	make string like "OK" to show OK button
	make string like "OK=Import" to rename label of OK button to "Import"
	make string like "OK=" to hide OK button
	make string like "OK=|Cancel=Close|Apply=Plot|Undo" to hide OK button, rename "Cancel" to "Close", show "Apply" and rename it to "Plot", show "Undo" button
	make string like "Import|Update" to add two customize buttom "Import" & "Update", in this case, OK & Cancel button will also shown
	make string like "OK=|Cancel=|Import|Update" to add two customize buttom and also hidden OK & Cancel button
*/
/// ALLLOW_COMSTOMIZE_OK_BTN_LABEL
//--- CPY 12/14/07 CUSTOM_BUTTON_CODE_CLEAN
private:
	int getStandardButtonType(LPCSTR lpcszButtonText)
	{
		if ( compare_string_localization(lpcszButtonText, STR_BTN_NAME_OK, true) )
			return IDOK;
		else if ( compare_string_localization(lpcszButtonText, STR_BTN_NAME_CANCEL, true) )
			return IDCANCEL;
		else if ( compare_string_localization(lpcszButtonText, STR_BTN_NAME_APPLY, true) )
			return IDC_APPLY;
		else if ( compare_string_localization(lpcszButtonText, STR_BTN_NAME_UNDO, true) )
			return IDC_UNDO_BTN;
		else if ( compare_string_localization(lpcszButtonText, STR_BTN_NAME_CLOSE, true) )
			return IDC_BTN_CLOSE;
		
		return 0;
	}
protected:
//--- end CUSTOM_BUTTON_CODE_CLEAN

	///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
	virtual bool IsDefaultShowApplyButton()
	{
		return false;
	}
	///---END QA80-11156 XF_PANEL_APPLY_BUTTON
	
	///Joseph 02/05/07 DYNABOX_DLG_NEED_MORE_BTNS
	void ShowCustomButton()
	{
#ifndef	_SPLITTER_CONTORL_H
		SetDefaultButtonName(); ///---Sim 10-31-2007 FIX_RESET_BUTTON_NAME
	
		/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
		//	vector<uint> vnButtons = {IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4};
		///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
		//vector<uint> vnButtons = {IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4, };
		vector<uint> vnButtons = {IDC_GETN_CUSTOM_BTN1, IDC_GETN_CUSTOM_BTN2, IDC_GETN_CUSTOM_BTN3, IDC_GETN_CUSTOM_BTN4};
		///---END QA80-11156 XF_PANEL_APPLY_BUTTON
		/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
		int nMaxCustomBtnNum = vnButtons.GetSize();
		//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
		for(int ii = 0; ii < vnButtons.GetSize(); ii++)
		{
			Button btn = GetItem(vnButtons[ii]);
			btn.Visible = false;
		}
		//-----------
		///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
		Button btnApply = GetItem(IDC_APPLY);
		if ( btnApply )
			btnApply.Visible = IsDefaultShowApplyButton();
		///---END QA80-11156 XF_PANEL_APPLY_BUTTON
		///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
		//If user add custom button, he must redefine OK Button
		TreeNode tr;
		tr = GetTree();
		string strCustomButtons;
		vector<string> vsBtns;
		tr.GetAttribute(STR_CUSTOM_BUTTONS_ATTRIB, strCustomButtons);
		int nNumBtns = strCustomButtons.GetTokens(vsBtns, '|');
		if(vsBtns.GetSize() == 0)
			return;
		///---Sim 04-02-2007 CHANGE_CUSTOM_BUTTON_FORMAT
		//int nKeyBtnIndex = 0;
		int nCustomBtnIndex = 0;
		for(int nBtnIndex=0; nBtnIndex < vsBtns.GetSize(); nBtnIndex++)
		{
			///---Sim 07-27-2007 FIX_REMOVE_REDUNDANT_SPACES
			vsBtns[nBtnIndex].TrimLeft();
			vsBtns[nBtnIndex].TrimRight();
			///---END FIX_REMOVE_REDUNDANT_SPACES
			
			vector<string> vsKeys;
		
			int nNumKeys = vsBtns[nBtnIndex].GetTokens(vsKeys, '=');
			///---Sim 07-25-2007 FIX_FOR_EMPTY_KEY_STRING
			if ( nNumKeys <= 0 )
				continue;
			///---END FIX_FOR_EMPTY_KEY_STRING

			///---Sim 07-27-2007 FIX_REMOVE_REDUNDANT_SPACES
			for ( int ii = 0; ii < vsKeys.GetSize(); ii++ )
			{
				vsKeys[ii].TrimLeft();
				vsKeys[ii].TrimRight();
			}
			///---END FIX_REMOVE_REDUNDANT_SPACES
			//--------------- CPY 12/14/07 CUSTOM_BUTTON_CODE_CLEAN
			//int nKeyBtnID = 0;
			//.... old codes removed 
			// format: buttonA|buttonB|buttonC, where each can be
			// ButtonType		button is shown, will be locqlized by oLocal
			// ButtonType=		button is not shown
			// ButtonType=Text  button is shown with provided text, vsKeys[0] = ButtonType, vsKeys[1]=Text
			int nKeyBtnID = getStandardButtonType(vsKeys[0]);
			//--------------- end CUSTOM_BUTTON_CODE_CLEAN
			/// end MORE_LOCALIZATION
			///---END FIX_RESET_BUTTON_NAME
			
			if ( nKeyBtnID ) // Standard button, Apply, OK, Cancel etc
			{
				Button btn = GetItem(nKeyBtnID);
				if ( btn )
				{
					btn.Visible = true; // Sim 07-27-2007 force show button
					if ( 1 == nNumKeys )
					{
						//--------------- CPY 12/14/07 CUSTOM_BUTTON_CODE_CLEAN
						//btn.Text = vsKeys[0]; // name of key button may has changed last time ///---Sim 07-24-2007 FIX_KEY_BUTTON_NAME_FOR_XF_WIZARD
						btn.Text = GetLocalized(vsKeys[0]);
						//---------------
					}
					else if ( 2 == nNumKeys )
					{
						if ( vsKeys[1].IsEmpty() ) // Sim 07-27-2007 force hide button
							btn.Visible = false;
						else
							btn.Text = vsKeys[1];
					}
					else
						error_report("Custom button string format error!");
					
					ResizeControlWidth(btn, CUSTOM_BTN_EDGE);///Joseph 05/10/07 SHOULD_ALSO_RESIZE_APPLY_OK_BUTTON
				}					
			}
			else // custom button
			{
				if ( nCustomBtnIndex >= nMaxCustomBtnNum )
					error_report("Error, number of custom button is more than maximum");
				else
				{
					Button btn = GetItem(vnButtons[nCustomBtnIndex]);
					btn.Visible = true;
					btn.Text = vsBtns[nBtnIndex];
					
					///Jake 04/29/07 RESIZE_CUSTOM_BUTTONS_SIZE
					
					/*
					///Jasmine 03/28/07 WIDEN_THE_LONG_TEXT_CUSTOM_BTN
					if(CUSTOM_BTN_MAX_WIDTH < lstrlen(btn.Text))
					{
						RECT rr;
						GetClientRect(btn, rr);
						rr.right += CUSTOM_WIDTH_INCREMENT;
						MoveControl(btn, rr);
					}
					///End WIDEN_THE_LONG_TEXT_CUSTOM_BTN
					*/
					
					ResizeControlWidth(btn, CUSTOM_BTN_EDGE);
					///end RESIZE_CUSTOM_BUTTONS_SIZE
					
					nCustomBtnIndex++;
				}
			}
		}
		///---END CHANGE_CUSTOM_BUTTON_FORMAT
		/// end ALLLOW_COMSTOMIZE_OK_BTN_LABEL
		
		///---Sim 04-02-2007 CHANGE_CUSTOM_BUTTON_FORMAT
		/*
		//int nBtnIndex = nButtonOKCancle;//---CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP, original code had hardcoded 2
		//for(int nIndex = 0; nIndex < nNumBtns - nButtonOKCancle; nIndex++, nBtnIndex++)   //2 OK, and Cancel button 
		int nBtnIndex = nKeyBtnIndex;
		for(int nIndex = 0; nIndex < nNumBtns - nKeyBtnIndex; nIndex++, nBtnIndex++) // skip key button string
		{
			Button btn = GetItem(vnButtons[nIndex]);
			btn.Visible = true;
			//btn.Text = vsBtns[nIndex + 2];//---CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
			btn.Text = vsBtns[nBtnIndex];
			///Jasmine 03/28/07 WIDEN_THE_LONG_TEXT_CUSTOM_BTN
			if(CUSTOM_BTN_MAX_WIDTH < lstrlen(btn.Text))
			{
				RECT rr;
				GetClientRect(btn, rr);
				rr.right += CUSTOM_WIDTH_INCREMENT;
				MoveControl(btn, rr);
			}
			///End WIDEN_THE_LONG_TEXT_CUSTOM_BTN
		}
		*/
		///---END CHANGE_CUSTOM_BUTTON_FORMAT
		
		//hide OK button if any custom button is used
		//if(GetItem(IDCANCEL))
			//GetItem(IDCANCEL).Text = "Close";
		///---END FIX_CUSTOM_BUTTON
		///End GETN_PREVIEW_DLG_NEED_MORE_BTNS
#endif
	}
	///End DYNABOX_DLG_NEED_MORE_BTNS
	//----

	BOOL	OnSelectionTrack()
	{
		return m_DynaCntrl.OnSelectionTrack();
	}
	
	/// YuI 04/26/06 FURTHER_IMPROVEMENT_TO_INTERACTIVE_CONTROL
	BOOL	OnDSSelectionOk()
	{
		return m_DynaCntrl.OnDSSelectionOk();
	}
	
	BOOL	OnDSSelectionCancel()
	{
		return m_DynaCntrl.OnDSSelectionCancel();
	}
	/// end FURTHER_IMPROVEMENT_TO_INTERACTIVE_CONTROL
	
	/// YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP
	BOOL	OnDSSelectionChangeEx(uint wParam, uint lParam)
	{
		return m_DynaCntrl.OnDSSelectionChangeEx(wParam, lParam);
	}
	
	BOOL	OnDSSelectionTrackEx(uint wParam, uint lParam)
	{
		return m_DynaCntrl.OnDSSelectionTrackEx(wParam, lParam);
	}
	
	BOOL	OnDSSelectionOkEx(uint wParam, uint lParam)
	{
		return m_DynaCntrl.OnDSSelectionOkEx(wParam, lParam);
	}
	
	BOOL	OnDSSelectionCancelEx(uint wParam, uint lParam)
	{
		return m_DynaCntrl.OnDSSelectionCancelEx(wParam, lParam);
	}
	
	BOOL	OnDSMarkerCreate(uint wParam, uint lParam)
	{
		return m_DynaCntrl.OnDSMarkerCreate(wParam, lParam);
	}
	
	BOOL	OnDSMarkerDestroy(uint wParam, uint lParam)
	{
		return m_DynaCntrl.OnDSMarkerDestroy(wParam, lParam);
	}
	/// end DATA_MARKERS_REVAMP
	////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////
	
	///------ Folger 02/18/09 F1_HELP_ON_STATS_XFS_IN_JAPANESE_SHOULD_OPEN_XFUNCTION_CHM
	static	bool	_is_stats_xf(LPCSTR lpcszName)
	{
		StringArray		saFileNames;
		LPCSTR			lpcszCategory = "X-Functions\\Statistics";
		LPCSTR			lpcszExt = "*.oxf";
		GetFileNames(saFileNames, okutil_get_origin_path(ORIGIN_PATH_SYSTEM, lpcszCategory), lpcszExt, GFIF_FILE_RECURSIVE);
		if ( 0 == saFileNames.GetSize() )
		{
			GetFileNames(saFileNames, okutil_get_origin_path(ORIGIN_PATH_USER, lpcszCategory), lpcszExt, GFIF_FILE_RECURSIVE);
		}
		for ( int ii=0; ii<saFileNames.GetSize(); ++ii )
		{
			if ( GetFileName(saFileNames[ii], TRUE).CompareNoCase(lpcszName) == 0 )
				return true;
		}
		return false;
	}
	
	static	bool	_is_stats_xf_in_japanese(LPCSTR lpcszName)
	{
		return  ORESLANG_JAPANESE == get_current_language() && _is_stats_xf(lpcszName);
	}
	///------ End F1_HELP_ON_STATS_XFS_IN_JAPANESE_SHOULD_OPEN_XFUNCTION_CHM
	
	//-------- CPY 9/15/06 F1_HELP_WORKS_ON_SIMPLE_GETN_BUT_NOT_ON_PREVIEW_GETN 
	BOOL 	OnHelp(int &nHelpID, int nIdCtrlFocus) //---- CPY 10/26/05 QA70-5496 GETN_BOX_F1_TO_OC_HANDLER
	{
		TreeNode tr = GetTree();
		string strClassOption;;
		theme_get_class_option(tr, strClassOption);
		int nDlgID;
		
		//------ Folger 11/14/07 ADD_HELP_ID_ATTRIBUTE
		//if(!strClassOption.IsEmpty())
		///------ Folger 02/18/09 F1_HELP_ON_STATS_XFS_IN_JAPANESE_SHOULD_OPEN_XFUNCTION_CHM
		//if ( tr.GetAttribute(STR_HELPID_ATTRIB, nHelpID) )
		//if ( tr.GetAttribute(STR_HELPID_ATTRIB, nHelpID) && !_is_stats_xf_in_japanese(strClassOption) )
		/// accoring to Shirley, Origin.chm in J should behave the same as E now
		if ( tr.GetAttribute(STR_HELPID_ATTRIB, nHelpID) )
		///------ End F1_HELP_ON_STATS_XFS_IN_JAPANESE_SHOULD_OPEN_XFUNCTION_CHM
		{
			return true;
		}
		else if (!strClassOption.IsEmpty())
		//------ End ADD_HELP_ID_ATTRIBUTE
		{
			string strLT;
			strLT.Format("help %s", strClassOption);
			LT_execute(strLT);
			return false;// will not call default help since we do not have help ID
			/// AW 09/15/06 QA80-8978 v8.0483 HELP_XF_NAME_LINK_TO_CHM
			/*
			string strFileName(GetOriginPath() + "XFHelpID.h");
			nHelpID = get_help_id(strFileName, strClassOption );
			return true;// // call default help since nHelpID is found
			*/
			/// END HELP_XF_NAME_LINK_TO_CHM
		}
		/// from EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX
		// some OC based GetN also wants help
		else if( tr.GetAttribute(STR_DATAID_ATTRIB, nDlgID) )
		{
			nHelpID = nDlgID;
			return true; // call default help since nHelpID is found
		}
		/// end UNIQUE_ID_FOR_HELP_WITH_GETN_BOX

		return false;// will not call default help since we do not have help ID
	}
	//-------- end
	
	////////////////////////////////////////////////////////
	//------ CPY 5/20/06 THEME_COMBO_IN_BASE_CLASS
private:
	void updateSaveButton(const string& strSelTheme)
	{
		/// Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
		//bool bEnable = true;
		//
		///// Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
		//int nPathType;
		//okutil_separate_composite_name(strSelTheme, &nPathType, NULL, ORIGIN_PATH_USER);				
		///// END DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
		//
		////------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
//#ifndef NEW_DEFAULT_THEME_MECHANISM
		///// Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
		////if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(strSelTheme) )
		//if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(strSelTheme) || ORIGIN_PATH_SYSTEM == nPathType)
		///// END DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
//#else
		///// Zech 08/11/2011 ORG-3492-P2 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
		///*
		////------ Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
		////if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || strSelTheme.IsEmpty() )
		//if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || theme_is_factory_default(strSelTheme) )
		////------
		//*/
		//if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || theme_is_factory_default(strSelTheme) || ORIGIN_PATH_SYSTEM == nPathType)
		///// END DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
//#endif
		////------
			//bEnable = false;	
			//
		//m_btnSaveTheme.Enable = bEnable;
		m_btnSaveTheme.Enable = theme_can_save(strSelTheme);
		/// END DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
		
		

		///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
		//don't need to update any more
		/*
		if(m_editThemeDescription)
			///Joseph 04/16/07 SHOULD_NOT_ENABLE_DESCRIPTION
			//m_editThemeDescription.Enable = bEnable;
			m_editThemeDescription.Enable = false;
			///End SHOULD_NOT_ENABLE_DESCRIPTION
		*/
		///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	}
	void trimThemeFileForDisplay(string& strFilename)
	{
		int n1 = strFilename.Find('-');
		int n2 = strFilename.ReverseFind('.');
		if(n1 > 0 && n2 > n1)
			strFilename = strFilename.Mid(n1+1, n2-n1-1);
	}
	
	///---Sim 12-07-2007 MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED
	/////Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	//int getMsgBoxHeight(Control ctrl, int nMsgBoxWidth)
	//{
		//if(!ctrl)
			//return 0;
		//string str = ctrl.Text;
		////---CPY 4/26/07 QA70-9608 TEXT_MEASURE_FOR_MULTI_LINE_TEXT
		///*
		//int nLength = ctrl.Text.GetLength();
		//if(nLength < 1)
			//return 0;
		//uint nn = GetDialogBaseUnits();
		//int nw1 = LOWORD(nn);nw1 = 0.5 + 0.8*nw1;
		//int nh1 = HIWORD(nn);nh1 = 0.5 + 0.95*nh1;
		//int nTextWidth = nLength * nw1;
		//return nh1 * (1 + nTextWidth/nMsgBoxWidth);
		//*/
		//int nW = nMsgBoxWidth;
		//int nHeight = ctrl.Measure(str, &nW);
		//if(nHeight > 0)
		//{
			////printf("%s\nHeight=%d\n", str, nHeight);
		//}
		//return nHeight;
		////----
	//}
	/////End DLG_DESCRIPTION_SUPPORT_MULTILINE
	///---END MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED
	
protected:

	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	//void CheckThemeDescriptionChange(TreeNode& trGUI)
	//{
		//updateThemeDescription(trGUI);
	//}	
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	///Joseph 02/07/07 FIX_BUG_ON_MORE_PAGES
	void PostMessageOnObjectChange(bool bCreate, PageBase& pg)
	{
		///---Sim 11-22-2007 FIX_RUNTIME_ERROR
		if ( !pg )
		{
			return;
		}
		///---END FIX_RUNTIME_ERROR
		
		int		nTemp;
		TreeNode trGUI = GetTree();
	
		if( trGUI && trGUI.GetAttribute(STR_ATTRIB_POST_USER_MESSAGE, nTemp) )
		{
	
			///---Sim 09-14-2007 MAKE_CONSISTENT_PAGE_ID_FOR_FIX_GETN_DIALOG_MESSAGE_ERROR
			HWND 	hwnd = GetSafeHwnd();
			uint nUID = pg.GetUID(true);
			///---END MAKE_CONSISTENT_PAGE_ID_FOR_FIX_GETN_DIALOG_MESSAGE_ERROR
			if(bCreate)
			{	
				///---Sim 09-14-2007 MAKE_CONSISTENT_PAGE_ID_FOR_FIX_GETN_DIALOG_MESSAGE_ERROR
				//HWND 	hwnd = GetSafeHwnd();
				//uint nUID = pg.GetUID(true);
				///---END MAKE_CONSISTENT_PAGE_ID_FOR_FIX_GETN_DIALOG_MESSAGE_ERROR
				///Joseph 02/25/07 ARGUMENTS_ORDER_NOT_RIGHT
				//post_getn_dialog_message(PGDM_SET_HDLG, (uint)hwnd, nUID);
				post_getn_dialog_message(PGDM_SET_HDLG, (WPARAM)hwnd,	0, nUID);
				///End ARGUMENTS_ORDER_NOT_RIGHT
			}
			else
				///Joseph 02/25/07 ARGUMENTS_ORDER_NOT_RIGHT
				//post_getn_dialog_message(PGDM_SET_HDLG, 0);
				///---Sim 09-14-2007 MAKE_CONSISTENT_PAGE_ID_FOR_FIX_GETN_DIALOG_MESSAGE_ERROR
				//post_getn_dialog_message(PGDM_SET_HDLG, 0, 0);
				post_getn_dialog_message(PGDM_SET_HDLG, 0, 0, nUID);
				///---END MAKE_CONSISTENT_PAGE_ID_FOR_FIX_GETN_DIALOG_MESSAGE_ERROR
				///End ARGUMENTS_ORDER_NOT_RIGHT
		}
	}
///End FIX_BUG_ON_MORE_PAGES
private:
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	/*
	string updateThemeDescription(TreeNode& trGUI, bool bEditToTree = true)
	{
		string str;
		if(m_editThemeDescription)
		{
			if(bEditToTree)
				trGUI.SetAttribute(STR_THEME_COMMENT_ATTRIB, m_editThemeDescription.Text);
			else
			{
				trGUI.GetAttribute(STR_THEME_COMMENT_ATTRIB, str);
				///Frank 1/28/05	GETN_DIALOG_NOT_UPDATE_THEME_DESCRIPTION_IF_EMPTY_STRING
				//m_editThemeDescription.Text = str;
				/// DSC 4/19/04 UPDATE_DISCRIPTION_ON_SEL_CHANGE also update if empty
				// if(!str.IsEmpty())
				// 	m_editThemeDescription.Text = str;
				m_editThemeDescription.Text = str;
				///end  UPDATE_DISCRIPTION_ON_SEL_CHANGE
				///End	GETN_DIALOG_NOT_UPDATE_THEME_DESCRIPTION_IF_EMPTY_STRING
			}
		}
		return str;
	}
	*/
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
protected:
	int ResizeThemeControls(int nEdge, int& cx, int ny)
	{
		int nGroupWidth, nGroupHeight;
		int nCaptionLabel = IDC_PARAMS_DESCRIPTION_LABEL;
		if(m_comboTheme)
		{
			m_pDlg->ShowControls(m_vnThemeCntrlIDs);
			m_pDlg->GetGroupTotalSize(m_vnThemeCntrlIDs, nGroupWidth, nGroupHeight);
			//---- CPY 9/24/06 XF_PREVIEW_DLG_NEED_PREVIEW_ON_THE_SIDE
			//if(nGroupWidth > cx)
			//	cx=nGroupWidth;
			//----
			///Joseph 10/09/06	CHANGE_THEME_GROUP_SIZE
			if( m_nInitThemeGroupWidth < THEMEGROUP_MINSIZE)
				m_nInitThemeGroupWidth = nGroupWidth;
			if(m_nInitThemeGroupWidth > cx)
				cx = m_nInitThemeGroupWidth;
			///End CHANGE_THEME_GROUP_SIZE
			int nThemeComboID = m_vnThemeCntrlIDs[1];//IDC_PARAMS_THEME
			///------ Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
			CheckResizeThemeLabel(m_vnThemeCntrlIDs[0]);
			///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
			int nynew = m_pDlg->ArrangeControlsLeftRight(m_vnThemeCntrlIDs, nEdge, ny, cx, nThemeComboID, nEdge);
			ny = nynew + nEdge;
		}
		else
			nCaptionLabel = 0;
		
		if(m_nIDThemeDescription && m_nIDThemeDescriptionLabel)
		{
			vector<uint> uThemeLabels;
			uThemeLabels.Add(m_nIDThemeDescriptionLabel);
			uThemeLabels.Add(m_nIDThemeDescription);
			uThemeLabels.Add(0);
			if(nCaptionLabel == 0)
			{
				uThemeLabels[1] = 0;
				m_pDlg->ShowControls(uThemeLabels, false);
				uThemeLabels[0] = m_nIDThemeDescription;
			}
			m_pDlg->ShowControls(uThemeLabels);
			
			//reset the Dlg Description height by the description length
			///Kyle 07/14/2009 SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
			//resizeDlgDescrip(cx);	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
			resizeDlgDescrip(cx, nEdge);	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
			///End SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
			ny = m_pDlg->ArrangeControlsLeftRight(uThemeLabels, nEdge, ny, cx, IDC_PARAMS_DESCRIPTION, nEdge) + nEdge;
		}
		return ny;	
	}

	///------ Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
	void	CheckResizeThemeLabel(int nID)
	{
		CheckResizeTextControl(nID, m_comboTheme);
	}

	void	CheckResizeDescriptionLabel(int nID)
	{
		CheckResizeTextControl(nID, m_editThemeDescription);
	}

	void	CheckResizeTextControl(int nIDText, Control ctrlOnRight)
	{
		#ifndef		_SPLITTER_CONTORL_H
		CheckResizeTextControl(GetItem(nIDText), ctrlOnRight);
		#endif		/// _SPLITTER_CONTORL_H
	}
	///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
	
	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	///Kyle 07/14/2009 SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
	//bool resizeDlgDescrip(int cx)
	bool resizeDlgDescrip(int cx, int nEdge)
	///End SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
	{
#ifndef	_SPLITTER_CONTORL_H
		Control ctrlDescripLabel;
		ctrlDescripLabel = GetItem(IDC_PARAMS_DESCRIPTION_LABEL);
		//------------ CPY 4/27/07 DESCRIPTION_WITHOUT_THEME_NOT_RESIZE_PROPERLY
		/*
		if(! m_editThemeDescription || ! ctrlDescripLabel)
			return false;
		
		RECT rtDesp, rtLabel;
		int nEdge = GetControlGap();
		GetClientRect(m_editThemeDescription, rtDesp);
		GetClientRect(ctrlDescripLabel, rtLabel);
		int nHeight = GetDlgDescripBoxHeight(cx - RECT_WIDTH(rtLabel));
		rtDesp.bottom = rtDesp.bottom - RECT_HEIGHT(rtDesp) + nHeight;
		
		m_editThemeDescription.MoveWindow(&rtDesp);
		*/
		if(! m_editThemeDescription )
			return false;
		///Kyle 07/14/2009 SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
		//int nDescLabelWidth = 0;
		int nWidth = cx;
		///End SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
		if(ctrlDescripLabel)
		{
			///------ Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
			CheckResizeDescriptionLabel(IDC_PARAMS_DESCRIPTION_LABEL);
			///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
			RECT rtLabel;
			GetClientRect(ctrlDescripLabel, rtLabel);
			///Kyle 07/14/2009 SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
			//nDescLabelWidth = RECT_WIDTH(rtLabel);
			///------ Folger 03/23/2012 ORG-5342-P1 BETTER_RESIZE_XF_THEME_DESCRIPTION
			//nWidth -= (RECT_WIDTH(rtLabel) + nEdge);
			nWidth -= (RECT_WIDTH(rtLabel) + 3 * nEdge);		/// consider gaps on left/right side
			///------ End BETTER_RESIZE_XF_THEME_DESCRIPTION
			///End SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
			
			///Sophy 9/14/2011 ORG-1931-S1 GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
			ctrlDescripLabel.Visible = !O_QUERY_BOOL(m_dwXFBits, DYNALAYOUT_NO_DESCRIPTION);
			///end GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION

		}
		RECT rtDesp;GetClientRect(m_editThemeDescription, rtDesp);
		///Kyle 07/14/2009 SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
		//int nHeight = GetDlgDescripBoxHeight(cx - nDescLabelWidth);
		//rtDesp.bottom = rtDesp.bottom - RECT_HEIGHT(rtDesp) + nHeight;
		int nHeight = GetDlgDescripBoxHeight(nWidth);
		rtDesp.bottom = rtDesp.top + nHeight;
		///End SHOULD_CONSIDER_THE_CONTROL_GAP_WHILE_RESIZING_DLG_DESCRIPTION
		m_editThemeDescription.MoveWindow(&rtDesp);	
		//------------ end DESCRIPTION_WITHOUT_THEME_NOT_RESIZE_PROPERLY
#endif
		return true;
	}
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	
	void InitThemeControls(ResizeDialog* pdlg, TreeNode& tr, int nIDThemeCombo, int nIDThemeLabel, int nIDThemeSave, int nIDThemeSaveAs, int nIDThemeEdit=0, int nIDThemeEditLabel=0)
	{
		m_pDlg = pdlg;
		m_vnThemeCntrlIDs.SetSize(0);
		m_vnThemeCntrlIDs.Add(nIDThemeLabel);
		m_vnThemeCntrlIDs.Add(nIDThemeCombo);
		//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifndef THEME_CONTROL_POPUP_MENU		
		m_vnThemeCntrlIDs.Add(nIDThemeSave);
#endif
		//------
		m_vnThemeCntrlIDs.Add(nIDThemeSaveAs);
		m_vnThemeCntrlIDs.Add(0);
		m_nIDThemeDescription = nIDThemeEdit;
		m_nIDThemeDescriptionLabel = nIDThemeEditLabel;
		
		m_comboTheme = m_pDlg->GetItem(nIDThemeCombo);//IDC_PARAMS_THEME); 
		m_btnSaveTheme = m_pDlg->GetItem(nIDThemeSave);//IDC_PARAMS_SAVE);
		
		//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifdef THEME_CONTROL_POPUP_MENU
		if ( m_comboTheme )
			m_comboTheme.Enable = false;
		if ( m_btnSaveTheme )
			m_btnSaveTheme.Visible = false;
#endif

		///---Joseph 04/04/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//we don't care whether there are theme control in the dialog, we should show the fun's description
		
		//if(m_comboTheme)
		//{
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		if(m_nIDThemeDescription)
		{
			
			m_editThemeDescription = m_pDlg->GetItem(m_nIDThemeDescription);//IDC_PARAMS_DESCRIPTION);
			m_editThemeDescription.InvalidateOnResize(); /// TD 08-05-2008 QA80-11949 TRY_TO_HOOKUP_WINDOWS_WM_SIZE_TO_INVALIDATE
			
			///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
			//use xf descrpition
			/*
			string strThemeDescription = updateThemeDescription(tr, false);
			///Joseph 11/04/06 DESCRIPTION_REMOVE_XFNAME
			updateDescription(strThemeDescription);
			//if(!strThemeDescription.IsEmpty())
				//m_strDescription = strThemeDescription;
			///End DESCRIPTION_REMOVE_XFNAME
			*/
			if(m_strDescription.IsEmpty())
			{
				string strDescription;
				tr.GetAttribute(STR_THEME_COMMENT_ATTRIB, strDescription);
				updateDescription(strDescription);
			}
			else
			{
				updateDescription(m_strDescription);
			}
			m_editThemeDescription.Text = m_strDescription;
			///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
			///Sophy 9/14/2011 ORG-1931-S1 GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
			m_editThemeDescription.Visible = !O_QUERY_BOOL(m_dwXFBits, DYNALAYOUT_NO_DESCRIPTION);
			///end GADGET_PREFERENCE_SHOULD_HIDE_MISLEADING_DESCRIPTION
		
		}
		
		///---Joseph 04/04/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		if(m_comboTheme)
		{
			LoadThemeFilesToCombo(tr);
		}
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	}
	virtual void OnChangeTheme(const string& strSel, TreeNode& tr) {}
	BOOL 	OnComboChangeTheme(Control ctrl)
	{
		string strSel;
		///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		//m_comboTheme.GetLBText(m_comboTheme.GetCurSel(),strSel);
		strSel = m_vsThemes[m_comboTheme.GetCurSel()];
		///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
#ifdef NEW_DEFAULT_THEME_MECHANISM
		//if ( theme_is_factory_default_for_new_mechanism(strSel) )
			//strSel = STR_DEFAULT;
#endif
		//------
		updateSaveButton(strSel);
		TreeNode tr = GetTree();
		///---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
		//if(theme_update_on_new_sel(tr, strSel))
		if ( LoadTheme(tr, strSel) )
		///---END IMPROVE_MULTI_THEME_FRAME_WORK
		{
			//UpdateDynaControl(true, GETNEVENT_ON_THEME, true);
			UpdateDynaControl(true, GETNEVENT_ON_THEME, true, DYNACONTROL_UPDATE_RECONSTRUCT);
			///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
			//updateThemeDescription(tr, false);
			///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
			OnChangeTheme(strSel, tr);
		}
		else
		//------ Folger 06/16/08 REPLACE_PRINTF_WITH_ERROR_REPORT_IN_DYNADLG
			//printf("failed to load theme = %s\n", strSel);
		{
			string strErr;
			strErr.Format("failed to load theme = %s\n", strSel);
			return error_report(strErr);
		}
		//------
		return	true;// event handler always returns true
	}

	///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	BOOL 	OnComboChangeTheme(TreeNode& tr)
	{
		string strSel;
		strSel = m_vsThemes[m_comboTheme.GetCurSel()];
		updateSaveButton(strSel);
		if ( !tr )
			tr = GetTree();
		if ( LoadTheme(tr, strSel) )
		{
			///------ Folger 05/25/2011 ORG-2954-P1 DYNACTRL_NO_REFRESH_IF_HIDDEN
			if ( TREE_CTRL_VAR && TREE_CTRL_VAR.Visible )
			///------ End DYNACTRL_NO_REFRESH_IF_HIDDEN
				UpdateDynaControl(true, GETNEVENT_ON_THEME, true, DYNACONTROL_UPDATE_RECONSTRUCT);
			OnChangeTheme(strSel, tr);
		}
		else
		{
			string strErr;
			strErr.Format("failed to load theme = %s\n", strSel);
			return error_report(strErr);
		}
		return	true;// event handler always returns true
	}
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

	bool LoadThemeFilesToCombo(const TreeNode& trGUI)
	{
		///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		/*
		m_comboTheme.ResetContent();
		vector<string> vsThemeList;
		
		int nSel = theme_get_list(trGUI, vsThemeList);
		for(int ii = 0; ii < vsThemeList.GetSize(); ii++)
			m_comboTheme.AddString(vsThemeList[ii]);

		if(vsThemeList.GetSize() == 0)
			return false;
		
		m_comboTheme.SetCurSel(nSel);
		if(vsThemeList.GetSize() > nSel)///Forest 03/09/05
			updateSaveButton(vsThemeList[nSel]);	
		return true;
		*/

		m_vsThemes.SetSize(0);
		///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
		//int nSel = theme_get_list(trGUI, m_vsThemes);
		int nSel = ThemeGetList(trGUI, m_vsThemes);
		///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
		///Sophy 10/10/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
		//if ( !UpdateThemeCommbo(m_vsThemes, false, nSel) )
		bool bModified = O_QUERY_BOOL(m_dwXFBits, DYNALAYOUT_THEME_MODIFIED_OUTSIDE) && nSel > 0? true : false;
		if ( !UpdateThemeCommbo(m_vsThemes, bModified, nSel) )		
		///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
			return false;
		
		updateSaveButton(m_vsThemes[nSel]);
		
		return true;
		///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	}

	///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
	bool UpdateThemeCommboAfterChange()
	{
		return UpdateThemeCommbo(m_vsThemes, true);
	}
	///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB

	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	bool UpdateThemeCommbo(const vector<string>& vsThemes, bool bModified = false, int nCurSel = -1)
	{
		if ( !m_comboTheme )
			return false;
		
		if ( nCurSel < 0 )
			nCurSel = m_comboTheme.GetCurSel();
		
		m_comboTheme.ResetContent();
		
		if( vsThemes.GetSize() == 0 )
			return false;
		
		///------ Folger 01/25/10 QA81-15036 SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
		//for(int ii = 0; ii < vsThemes.GetSize(); ii++)
		//{
			//string str = vsThemes[ii];
		vector<string>	vsThemesTmp;
		vsThemesTmp = vsThemes;
		///Sophy 3/2/2012 ORG-5161-P1 THEME_NAME_WITH_AMP_TRIMED_ON_DYNA_DLG_POPUPMENU
		//okutil_prepare_theme_display_names(&vsThemesTmp);
		okutil_prepare_theme_display_names(&vsThemesTmp, NULL, FALSE);
		///end THEME_NAME_WITH_AMP_TRIMED_ON_DYNA_DLG_POPUPMENU
		for(int ii = 0; ii < vsThemesTmp.GetSize(); ii++)
		{
			string str = vsThemesTmp[ii];
		///------ End SUPPORT_ARRANGE_THEME_NAMES_IN_MENU_BY_ORDER
			if ( ii == nCurSel && bModified )
			{
				//str += " ";
				//str += CHAR_UNSAVE_SIGN;
				str.Format("%s %c", str, CHAR_UNSAVE_SIGN)
			}
			///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
			ExtraInfoToThemeStr(str);
			///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
			m_comboTheme.AddString(str);
		}
		
		m_comboTheme.SetCurSel(nCurSel);
		
		return true;
	}
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	BOOL	OnSaveTheme(Control ctrl)
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//{
		//TreeNode tr = GetTree();
	{
		return OnSaveTheme();
	}
	
	bool	OnSaveTheme(TreeNode& trGetN = NULL)
	{
		TreeNode tr;
		if ( trGetN )
			tr = trGetN;
		else
			tr = GetTree();	
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		
		///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//updateThemeDescription(tr);
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		
		/// SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
		///	return theme_save_settings(tr);		
		string strSel;
		///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		//m_comboTheme.GetLBText(m_comboTheme.GetCurSel(),strSel);
		strSel = m_vsThemes[m_comboTheme.GetCurSel()];
		///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		int nType = cvt_str_to_predefined_type(strSel);
		
		//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
#ifdef NEW_DEFAULT_THEME_MECHANISM
		//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
		//if ( theme_is_factory_default_for_new_mechanism(strSel) )
		///---Sim 07-04-2008 IMPROVE_DEFAULT_THEME_MECHANISM
		//if ( is_theme_default(strSel) )
		////------
			//return DefaultThemeManagement(tr, THEME_DEFAULT_SET);
		///---END IMPROVE_DEFAULT_THEME_MECHANISM
#endif
		
		//------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
		//if( PDS_BOOK == nType || PDS_SHEET == nType )
		if( theme_get_save_type(nType) == THEME_TYPE_SVAE_TO_BOOK )
		//------ End IMPROVE_SAVE_THEME_MECHANISM
		{
			string strClassOption;
			theme_get_class_option(tr, strClassOption);
			return theme_active_book_sheet_storage(tr, strClassOption, nType, false);
		}
		//------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
		//else
			/////---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
			////return theme_save_settings(tr);	
			////------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
			////return SaveTheme(tr);
		///---Sim 07-04-2008 IMPROVE_DEFAULT_THEME_MECHANISM
		//else if (theme_get_save_type(nType) == THEME_TYPE_SVAE_TO_FILE)
		else
		///---END IMPROVE_DEFAULT_THEME_MECHANISM
		{
			///---Sim 07-03-2008 CLEAR_THEME_SAVE_METHOD
			//string strClassOption;
			//theme_get_class_option(tr, strClassOption);	
			//string strFileName = theme_get_settings_file(strSel, strClassOption);
			//return SaveTheme(tr, strFileName);
			///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			//return SaveTheme(tr, strSel);
			if ( SaveTheme(tr, strSel) )
			{
				UpdateThemeCommbo(m_vsThemes, false);			
				return true;
			}
			///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			///---END CLEAR_THEME_SAVE_METHOD
		}
		
		return false;
		//------ End IMPROVE_SAVE_THEME_MECHANISM
			///---END IMPROVE_MULTI_THEME_FRAME_WORK
		/// end XF_THEME_BOOK_AND_SHEET
	}
	BOOL	OnSaveThemeAs(Control ctrl)
	{
		//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifndef THEME_CONTROL_POPUP_MENU
		//------
		TreeNode tr = GetTree();
		string strDescription ;
		string strFullFileName = theme_ask_save_as_filename(tr, GetSafeHwnd());
		if(strFullFileName.IsEmpty())
			return	true;
		
		///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//updateThemeDescription(tr, false);
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		
		///---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
		//if(	theme_save_settings(tr, strFullFileName) )
		///---Sim 07-03-2008 CLEAR_THEME_SAVE_METHOD
		//if(	SaveTheme(tr, strFullFileName) )
		string strThemeName = okutil_theme_get_theme_name(strFullFileName);
		if(	SaveTheme(tr, strThemeName) )
		///---END CLEAR_THEME_SAVE_METHOD
		///---END IMPROVE_MULTI_THEME_FRAME_WORK
			LoadThemeFilesToCombo(tr);
		//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#else
		return OnShowThemeMenu(ctrl);
#endif
		//------ End ADD_THEME_CONTROL_POPUP_MENU
		
		return	true;// event handler always returns true
	}
	//------ end THEME_COMBO_IN_BASE_CLASS
	
	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifdef THEME_CONTROL_POPUP_MENU

	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//bool	OnThemeSaveAs()
	//{
		//TreeNode tr = GetTree();
	bool	OnThemeSaveAs(TreeNode& trGetN = NULL)
	{
		TreeNode tr;
		if ( trGetN )
			tr = trGetN;
		else
			tr = GetTree();	
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
		//string strFullFileName = theme_ask_save_as_filename(tr, GetSafeHwnd());
		///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
		//TreeNode trThemeFilter = NULL;
		Tree trThemeFilter;
		if ( IsShowThemeSetting() )
			GetThemeFilterTree(trThemeFilter, tr);
		///---END NEW_PA_81_THEME_FILTER_SETTING
		string strFullFileName = theme_ask_save_as_filename(tr, GetSafeHwnd(), trThemeFilter);
		///---END QA80-11371 THEME_SAVING_OPTIONS
		if(strFullFileName.IsEmpty())
			return false;
		
		///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
		if ( IsShowThemeSetting() && !trThemeFilter.IsEmpty() )
			SetThemeFilterTree(trThemeFilter, tr);
		///---END NEW_PA_81_THEME_FILTER_SETTING
		///---Sim 07-03-2008 CLEAR_THEME_SAVE_METHOD
		//if(	SaveTheme(tr, strFullFileName) )
		string strThemeName = okutil_theme_get_theme_name(strFullFileName);
		if(	SaveTheme(tr, strThemeName) )
		///---END CLEAR_THEME_SAVE_METHOD
			LoadThemeFilesToCombo(tr);
		return true;
	}
	
public:
	bool	OnShowThemeMenu(Control ctrl, Control *pCtrlCombo = NULL, Control *pCtrlSave = NULL, TreeNode &trGetN = NULL, Dialog *pDlg = NULL)
	{
		if ( !m_comboTheme && pCtrlCombo && *pCtrlCombo )
			m_comboTheme = *pCtrlCombo;
		
		if ( !m_btnSaveTheme && pCtrlSave && *pCtrlSave )
			m_btnSaveTheme = *pCtrlSave;
		
		TreeNode tr;
		if ( trGetN )
			tr = trGetN;
		else
			tr = GetTree();
					
		///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
		bool				bThemeSetting = false;
		///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		/*
		if ( pDlg )
		{
			bThemeSetting = pDlg->SendMessage(WM_USER_DIALOG_IS_THEME_SETTING);
		}
		///---END QA80-11371 THEME_SAVING_OPTIONS
		///---Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
		else
		*/
		///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		{
			bThemeSetting = IsShowThemeSetting();
			///Jasmine 07/14/09 NANOSZIER_NEED_DESCRIPTION_TO_REMINDER_USER
			if(bThemeSetting)
			{
				Tree trThemeFilter;
				///---Sim 09-21-2009 FIX_NLFIT_THEME_SETTING_DISAPPEAR_ON_THEME_MENU
				//GetThemeFilterTree(trThemeFilter, NULL);
				GetThemeFilterTree(trThemeFilter, tr);
				///---END FIX_NLFIT_THEME_SETTING_DISAPPEAR_ON_THEME_MENU
				bThemeSetting = !trThemeFilter.IsEmpty();
			}
			///End NANOSZIER_NEED_DESCRIPTION_TO_REMINDER_USER
		}
		///---END QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
		
		int					nThemeType;
		tr.GetAttribute(STR_DATA_ATTRIB, nThemeType);
		bool				bSheetTheme = nThemeType & THEME_SAVE_TO_SHEET;
		bool				bBookTheme = nThemeType & THEME_SAVE_TO_BOOK;

		vector<string>		vsThemes;
		///------ Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS
		/*
		///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
		//int 				nSel = theme_get_list(tr, vsThemes);

		//nSel = m_comboTheme.GetCurSel();		//sometime tr did not have enough info for nSel,
		int					nSel = m_comboTheme.GetCurSel();
		vsThemes = m_vsThemes;
		///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
		
		///------ Folger 09/23/09 Q8A0-14339-P6 NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
		vector<string>		vsThemesExcludeLastUsed;
		ThemeGetList(tr, vsThemesExcludeLastUsed, FALSE);
		///------ End NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
												//combo current selection is better
		//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
#ifdef NEW_DEFAULT_THEME_MECHANISM
		int nDefaultOffset = 0;
		//------ Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
		//if ( vsThemes.GetSize() > 0 && vsThemes[0].IsEmpty() )
		if ( vsThemes.GetSize() > 0 && theme_is_factory_default(vsThemes[0]) )
		//------
		{
			vsThemes.RemoveAt(0);
			///------ Folger 09/23/09 Q8A0-14339-P6 NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
			vsThemesExcludeLastUsed.RemoveAt(0);
			///------ End NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
			++nDefaultOffset;
			--nSel;
}
#endif
		*/
		vector<string>		vsThemesExcludeLastUsed;
		int					nDefaultOffset = 0;
		int					nSel = PrepareThemes(nDefaultOffset, vsThemes, vsThemesExcludeLastUsed, tr);
		///------ End SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS
												
		//Tree trTmp;
		//tree_node_copy_attribute(tr, trTmp, STR_CLASS_OPTION_NAME_ATTRIB);
		//------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
		/////---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
		////ThemeControlMenu	myMenu(m_btnSaveTheme.Enable, bSheetTheme, bBookTheme, vsThemes, nSel, IsThemeLoadEnable()/*, DefaultThemeManagement(trTmp)*/);
		//ThemeControlMenu	myMenu(m_btnSaveTheme.Enable, bThemeSetting, bSheetTheme, bBookTheme, vsThemes, nSel, IsThemeLoadEnable());
		/////---END QA80-11371 THEME_SAVING_OPTIONS
		/// Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
		//ThemeControlMenu	myMenu(m_btnSaveTheme.Enable, bThemeSetting, bSheetTheme, bBookTheme, vsThemes, nSel, IsThemeLoadEnable(), vsThemes.GetSize() > 0 ? true : false);
		///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
		//ThemeControlMenu	myMenu(m_btnSaveTheme.Enable, bThemeSetting, bSheetTheme, bBookTheme, vsThemes, nSel, IsThemeLoadEnable(), vsThemesExcludeLastUsed.GetSize() > 0 ? true : false, IsSupportThemeCompare());
		ThemeControlMenu	myMenu(m_btnSaveTheme.Enable
							, bThemeSetting
							, bSheetTheme
							, bBookTheme
							, vsThemes
							, nSel
							, IsThemeLoadEnable()
							, vsThemesExcludeLastUsed.GetSize() > 0 ? true : false
							, IsSupportThemeCompare()
							, isLabtalkCallable(tr)
							);
		///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
		/// end PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
		//------ End SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
		RECT 				rr;
		if ( !ctrl )
			return FALSE;
		ctrl.GetClientRect(&rr);
		ctrl.ClientToScreen(&rr);
		myMenu.TrackPopupMenu(0,  rr.right, rr.top, GetSafeHwnd());
		
		int					nCmd;
		if( myMenu.GetCommand(nCmd) )
		{
			///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
			////------ Folger 04/07/08 QA80-11192 CENTRALIZE_CODE_OF_THEME_CONTROL_MENU
			////if ( !bSheetTheme && nCmd >= THEME_MENU_SAVE_TO_SHEET )
				////++nCmd;
			////if ( !bBookTheme && nCmd >= THEME_MENU_SAVE_TO_BOOK )
				////++nCmd;
			////------
			//switch ( nCmd )
			//{
			//case THEME_MENU_SAVE_AS_DEFAULT:
				/////---Sim 07-04-2008 IMPROVE_DEFAULT_THEME_MECHANISM
				///*
				//DefaultThemeManagement(tr, THEME_DEFAULT_SET);
				////------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
//#ifdef NEW_DEFAULT_THEME_MECHANISM
				//loadThemeFilesToCombo(tr);
//#endif
				////------
				//*/
				/////---Sim 09-05-2008 CLEAN_DEFAULT_THEME
				////tree_set_theme_file_name(tr, STR_DEFAULT);
				/////---END CLEAN_DEFAULT_THEME
				//SaveTheme(tr, STR_DEFAULT);
//
				//loadThemeFilesToCombo(tr);
				/////---END IMPROVE_DEFAULT_THEME_MECHANISM
				//break;
				//
			//case THEME_MENU_SAVE:
				/////---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				///*
				//if ( pDlg )
					//pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_SAVE);
				//else
					//OnSaveTheme(m_btnSaveTheme);
				//*/
				//OnSaveTheme(tr);
				/////---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				//break;
				//
			//case THEME_MENU_SAVE_TO_SHEET:
			//case THEME_MENU_SAVE_TO_BOOK:
				////Sim, Folger, 09-10-2008 This is only for ASCII import, other else will not save to <sheet>, <book>
				//{
					//string strClassOption;
					//theme_get_class_option(tr, strClassOption);
					//if ( theme_active_book_sheet_storage(tr, strClassOption, THEME_MENU_SAVE_TO_SHEET ? PDS_SHEET : PDS_BOOK, false) )
					//{
						//tree_set_theme_file_name(tr, THEME_MENU_SAVE_TO_SHEET ? STR_SHEET : STR_BOOK);
						//loadThemeFilesToCombo(tr);
					//}
				//}
				//break;
				//
			//case THEME_MENU_RESET:
				//{
					/////------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
					//ThemeForceLoadFactoryHelper		clHelper(tr);
					/////------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
					//DefaultThemeManagement(tr, THEME_DEFAULT_RESET);
					////------ Folger 04/21/08 FIX_THEME_RESET_NOT_WORK_IN_NLFIT
					/////---Sim 09-05-2008 CLEAN_DEFAULT_THEME
					////tree_set_theme_file_name(tr, STR_THEME_DEFAULT_SHORT_FORM);
					/////---END CLEAN_DEFAULT_THEME
					//loadThemeFilesToCombo(tr);
					////------
					/////---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
					///*
					//if ( pDlg )
							//pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_COMBO_CHANGE);
					//else
					//*/
					/////---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
					//{
						/////---Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
						//OnComboChangeTheme(m_comboTheme);
						/////---END QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
					//}
				//}
				//break;
				//
			//case THEME_MENU_SAVE_AS:
				/////---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				///*
				//if ( pDlg )
					//pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_SAVE_AS);
				//else
					//OnThemeSaveAs();
				//*/
				//OnThemeSaveAs(tr);
				/////---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				//break;
				//
			/////---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
			//case THEME_MENU_SETTING:
				/////---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				///*
				//if ( pDlg )
				//{
					//pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_SETTING);
				//}
				/////---Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
				//else
				//*/
				/////---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				//{
					//ShowThemeSetting();
				//}
				/////---END QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
				//break;
			/////---END QA80-11371 THEME_SAVING_OPTIONS
//
            ////------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
            //case THEME_MENU_DELETE:
                //theme_delete_settings(tr, GetSafeHwnd());
                //loadThemeFilesToCombo(tr);		//------ Folger 08/26/08 FIX_THEME_COMBO_NOT_UPDATED_AFTER_DELETE_THEME
                //break;
            ////------
            //
            ///// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
			//case THEME_MENU_COMPARE:
				//string		strCombo;
				//strCombo.SetTokens(vsThemes, '|');
				//string		strFactoryDefaultThemeInCombo(" ");
				//strCombo = strFactoryDefaultThemeInCombo + '|' + strCombo;
				//string		strDefVal = m_vsThemes[m_comboTheme.GetCurSel()];
				//if ( -1 == vsThemes.Find(strDefVal) )				
					//strDefVal = strFactoryDefaultThemeInCombo;
				//
				//string		strThemeName;
				//if ( tr.GetAttribute(STR_THEME_NAME_ATTRIB, strThemeName) )						
				//{
					//if ( vsThemes.Find(strThemeName) )
						//strDefVal = strThemeName;
				//}
				//
				//GETN_TREE(trThemeName)
				//GETN_STR(Hint, _L("Empty theme name represents the System Default"), "") GETN_HINT
				//GETN_STRLIST(FileName, _L("Theme Name"), strDefVal, strCombo)
				///// Hong 01/07/09 QA80-12798-P2 FIX_MODAL_DLG_BECOME_MODALLESS_AFTER_POPUP_THEME_COMPARING_DLG
				////if ( 0 == GetNBox(trThemeName, _L("Compare"), _L("Select theme to compare")) )
				//if ( 0 == GetNBox(trThemeName, _L("Compare"), _L("Select theme to compare"), NULL, NULL, GetSafeHwnd()) )
				///// end FIX_MODAL_DLG_BECOME_MODALLESS_AFTER_POPUP_THEME_COMPARING_DLG
					//break;				
	//
				//string		strThemeSel = trThemeName.FileName.strVal;
				//if ( 0 == strThemeSel.Compare(strFactoryDefaultThemeInCombo) )
					//strThemeSel = "";
				//
				//string		strMsg(_L("No difference."));
				//Tree		trDiff;
				//if ( !CompareTheme(tr, strThemeSel, trDiff) )
				//{
					//ASSERT(FALSE);
					//strMsg = _L("Theme comparison fail!");
				//}
				//
				//LT_execute("type -a");				
				//if ( !trDiff.IsEmpty() )
				//{
					///// Hong 12/24/08 QA80-12798 v8.0990c THEME_COMPARE_NEED_DISPLAY_REF_VAL_IN_ATTRIB
					//vector<string>		vstrAttribs = {STR_TRDIFF_REF_VALUE_ATTRIB};
					///// Hong 01/09/09 QA80-12798 v8.995 THEME_COMPARE_DUMP_HIDDEN_NODE_LIKE_ANCHOR_IN_PA
					////octree_tree_to_str(&trDiff, &strMsg, NULL, TREE2STR_DEFAULT, NULL, &vstrAttribs);
					//octree_tree_to_str(&trDiff, &strMsg, NULL, TREE2STR_SIMPLE_TYPE_ONLY | TREE2STR_CHECK_USER_LABEL, NULL, &vstrAttribs);
					///// end THEME_COMPARE_DUMP_HIDDEN_NODE_LIKE_ANCHOR_IN_PA
					///// end THEME_COMPARE_NEED_DISPLAY_REF_VAL_IN_ATTRIB
					//out_str(_L("Compared theme values are in brackets."));
				//}				
				//out_str(strMsg);
				//
				//break;		
        	///// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
//
			/////------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
			//case THEME_MENU_DUMPING:
				//xf_settings_dumping(tr);
				//break;
			/////------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
			//
			//default:
				//if ( nCmd >= THEME_MENU_LOADING_START )
				//{
					////------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
//#ifdef NEW_DEFAULT_THEME_MECHANISM
					//nCmd += nDefaultOffset;
//#endif
					////------
					/////---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
					////m_comboTheme.SetCurSel(nCmd - THEME_MENU_LOADING_START);
					//UpdateThemeCommbo(m_vsThemes, false, nCmd - THEME_MENU_LOADING_START);
					/////---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
					/////---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
					///*
					//if ( pDlg )
						//pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_COMBO_CHANGE);
					//else
					//*/
					/////---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
						//OnComboChangeTheme(m_comboTheme);
				//}
				//break;
			//}
			HandleThemeCmd(nCmd, tr, vsThemes, nDefaultOffset);
			///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
		}
		
		return true;
	}

protected:
	///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	virtual	void	HandleThemeCmd(int nCmd, TreeNode& tr, vector<string>& vsThemes, int nDefaultOffset = 0)
	{
		switch ( nCmd )
		{
		case THEME_MENU_SAVE_AS_DEFAULT:
			///---Sim 07-04-2008 IMPROVE_DEFAULT_THEME_MECHANISM
			/*
			DefaultThemeManagement(tr, THEME_DEFAULT_SET);
			//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
			#ifdef NEW_DEFAULT_THEME_MECHANISM
			loadThemeFilesToCombo(tr);
			#endif
			//------
			*/
			///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
			//tree_set_theme_file_name(tr, STR_DEFAULT);
			///---END CLEAN_DEFAULT_THEME
			SaveTheme(tr, STR_DEFAULT);

			LoadThemeFilesToCombo(tr);
			///---END IMPROVE_DEFAULT_THEME_MECHANISM
			break;
			
		case THEME_MENU_SAVE:
			///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			/*
			if ( pDlg )
				pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_SAVE);
			else
				OnSaveTheme(m_btnSaveTheme);
			*/
			OnSaveTheme(tr);
			///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			break;
			
		case THEME_MENU_SAVE_TO_SHEET:
		case THEME_MENU_SAVE_TO_BOOK:
			//Sim, Folger, 09-10-2008 This is only for ASCII import, other else will not save to <sheet>, <book>
			{
				string strClassOption;
				theme_get_class_option(tr, strClassOption);
				if ( theme_active_book_sheet_storage(tr, strClassOption, THEME_MENU_SAVE_TO_SHEET ? PDS_SHEET : PDS_BOOK, false) )
				{
					tree_set_theme_file_name(tr, THEME_MENU_SAVE_TO_SHEET ? STR_SHEET : STR_BOOK);
					LoadThemeFilesToCombo(tr);
				}
			}
			break;
			
		case THEME_MENU_RESET:
			{
				///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
				ThemeForceLoadFactoryHelper		clHelper(tr);
				///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
				DefaultThemeManagement(tr, THEME_DEFAULT_RESET);
				//------ Folger 04/21/08 FIX_THEME_RESET_NOT_WORK_IN_NLFIT
				///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
				//tree_set_theme_file_name(tr, STR_THEME_DEFAULT_SHORT_FORM);
				///---END CLEAN_DEFAULT_THEME
				LoadThemeFilesToCombo(tr);
				//------
				///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				/*
				if ( pDlg )
						pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_COMBO_CHANGE);
				else
				*/
				///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				{
					///---Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
					//OnComboChangeTheme(m_comboTheme);
					OnComboChangeTheme(tr);
					///---END QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
				}
			}
			break;
			
		case THEME_MENU_SAVE_AS:
			///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			/*
			if ( pDlg )
				pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_SAVE_AS);
			else
				OnThemeSaveAs();
			*/
			OnThemeSaveAs(tr);
			///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			break;
			
		///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
		case THEME_MENU_SETTING:
			///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			/*
			if ( pDlg )
			{
				pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_SETTING);
			}
			///---Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
			else
			*/
			///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			{
				ShowThemeSetting();
			}
			///---END QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
			break;
		///---END QA80-11371 THEME_SAVING_OPTIONS

        //------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
        case THEME_MENU_DELETE:
	        {
	        	///------ Folger 09/15/2011 ORG-3718-P3 PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
	        	ThemeForceLoadFactoryHelper		clHelper(tr);
	        	///------ End PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
	            DeleteTheme(tr);
	            LoadThemeFilesToCombo(tr);		//------ Folger 08/26/08 FIX_THEME_COMBO_NOT_UPDATED_AFTER_DELETE_THEME
			}
            break;
        //------
        
        /// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
		case THEME_MENU_COMPARE:
			string		strCombo;
			strCombo.SetTokens(vsThemes, '|');
			string		strFactoryDefaultThemeInCombo(" ");
			strCombo = strFactoryDefaultThemeInCombo + '|' + strCombo;
			string		strDefVal = m_vsThemes[m_comboTheme.GetCurSel()];
			if ( -1 == vsThemes.Find(strDefVal) )				
				strDefVal = strFactoryDefaultThemeInCombo;
			
			string		strThemeName;
			if ( tr.GetAttribute(STR_THEME_NAME_ATTRIB, strThemeName) )						
			{
				if ( vsThemes.Find(strThemeName) )
					strDefVal = strThemeName;
			}
			
			GETN_TREE(trThemeName)
			GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
			GETN_STR(Hint, _L("Empty theme name represents the System Default"), "") GETN_HINT
			GETN_STRLIST(FileName, _L("Theme Name"), strDefVal, strCombo)
			/// Hong 01/07/09 QA80-12798-P2 FIX_MODAL_DLG_BECOME_MODALLESS_AFTER_POPUP_THEME_COMPARING_DLG
			//if ( 0 == GetNBox(trThemeName, _L("Compare"), _L("Select theme to compare")) )
			if ( 0 == GetNBox(trThemeName, _L("Compare"), _L("Select theme to compare"), NULL, NULL, GetSafeHwnd()) )
			/// end FIX_MODAL_DLG_BECOME_MODALLESS_AFTER_POPUP_THEME_COMPARING_DLG
				break;				

			string		strThemeSel = trThemeName.FileName.strVal;
			if ( 0 == strThemeSel.Compare(strFactoryDefaultThemeInCombo) )
				strThemeSel = "";
			
			string		strMsg(_L("No difference."));
			Tree		trDiff;
			if ( !CompareTheme(tr, strThemeSel, trDiff) )
			{
				ASSERT(FALSE);
				strMsg = _L("Theme comparison fail!");
			}
			
			LT_execute("type -a");				
			if ( !trDiff.IsEmpty() )
			{
				/// Hong 12/24/08 QA80-12798 v8.0990c THEME_COMPARE_NEED_DISPLAY_REF_VAL_IN_ATTRIB
				vector<string>		vstrAttribs = {STR_TRDIFF_REF_VALUE_ATTRIB};
				/// Hong 01/09/09 QA80-12798 v8.995 THEME_COMPARE_DUMP_HIDDEN_NODE_LIKE_ANCHOR_IN_PA
				//octree_tree_to_str(&trDiff, &strMsg, NULL, TREE2STR_DEFAULT, NULL, &vstrAttribs);
				octree_tree_to_str(&trDiff, &strMsg, NULL, TREE2STR_SIMPLE_TYPE_ONLY | TREE2STR_CHECK_USER_LABEL, NULL, &vstrAttribs);
				/// end THEME_COMPARE_DUMP_HIDDEN_NODE_LIKE_ANCHOR_IN_PA
				/// end THEME_COMPARE_NEED_DISPLAY_REF_VAL_IN_ATTRIB
				out_str(_L("Compared theme values are in brackets."));
			}				
			out_str(strMsg);
			
			break;		
        /// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES

		///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
		case THEME_MENU_DUMPING:
			xf_settings_dumping(tr);
			break;
		///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
		
		default:
			if ( nCmd >= THEME_MENU_LOADING_START )
			{
				//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
#ifdef NEW_DEFAULT_THEME_MECHANISM
				nCmd += nDefaultOffset;
#endif
				//------
				///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				//m_comboTheme.SetCurSel(nCmd - THEME_MENU_LOADING_START);
				UpdateThemeCommbo(m_vsThemes, false, nCmd - THEME_MENU_LOADING_START);
				///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
				/*
				if ( pDlg )
					pDlg->SendMessage(WM_USER_DIALOG_ON_THEME_COMBO_CHANGE);
				else
				*/
				///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
					//OnComboChangeTheme(m_comboTheme);
				OnComboChangeTheme(tr);
			}
			break;
		}
	}
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

	///------ Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS
	int		PrepareThemes(int& nDefaultOffset, vector<string>& vsThemes, vector<string>& vsThemesExcludeLastUsed, TreeNode& tr)
	{
		int		nSel = m_comboTheme.GetCurSel();
		vsThemes = m_vsThemes;

		ThemeGetList(tr, vsThemesExcludeLastUsed, TRUE, FALSE);

		nDefaultOffset = 0;
		if ( vsThemes.GetSize() > 0 && theme_is_factory_default(vsThemes[0]) )
		{
			vsThemes.RemoveAt(0);
			vsThemesExcludeLastUsed.RemoveAt(0);
			++nDefaultOffset;
			--nSel;
		}

		return nSel;
	}
	///------ End SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS

	//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
	/*
	enum
	{
		THEME_DEFAULT_GET,
		THEME_DEFAULT_SET,
		THEME_DEFAULT_RESET,
	};
	*/
	///---Sim 07-04-2008 IMPROVE_DEFAULT_THEME_MECHANISM
	//virtual	bool	DefaultThemeManagement(TreeNode &tr, int nOp = THEME_DEFAULT_GET)
	bool	DefaultThemeManagement(TreeNode &tr, int nOp = THEME_DEFAULT_GET)
	///---END IMPROVE_DEFAULT_THEME_MECHANISM
	{
		///---Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
		/*
		bool bRet = theme_default_setting_management(tr, nOp);
		if ( nOp == THEME_DEFAULT_RESET )
		{
			UpdateDynaControl(true, GETNEVENT_ON_THEME, true, DYNACONTROL_UPDATE_RECONSTRUCT);
			OnChangeTheme(NULL, tr);
			loadThemeFilesToCombo(tr);
		}
		return bRet;
		*/
		///Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE	
		//return theme_default_setting_management(tr, nOp);
		///---Sim 12-08-2008 FIX_RESET_DEFAULT_THEME_POPUP_ERR
		//bool	bDefaultThemeUpdated = theme_default_setting_management( tr, nOp );
		bool	bDefaultThemeUpdated = theme_default_setting_management(tr, nOp, NULL, m_bGroupTheme);
		///---END FIX_RESET_DEFAULT_THEME_POPUP_ERR
		if( !bDefaultThemeUpdated )
			popup_errmsg_save_readonly_file( STR_DEFAULT_SETTINGS_FILENAME, GetSafeHwnd() );
		return bDefaultThemeUpdated;
		///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
		///---END QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
	}
	
	virtual	bool	IsThemeLoadEnable()
	{
		return true;
	}
	//------ End LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
	
	/// Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
	virtual bool	IsSupportThemeCompare() 
	{
		return true;
	}	
	/// end PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
	
#endif
	//------ End ADD_THEME_CONTROL_POPUP_MENU
	
	///---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
	///---Sim 07-03-2008 CLEAR_THEME_SAVE_METHOD
	//virtual BOOL SaveTheme(TreeNode& trGetN, LPCSTR lpcszFilename = NULL)
	//{
		//return theme_save_settings(trGetN, lpcszFilename);
	//}
	//virtual BOOL LoadTheme(TreeNode& trGetN, string strTheme)
	//{
		//return theme_update_on_new_sel(trGetN, strTheme);
	//}
	virtual BOOL SaveTheme(TreeNode& trGetN, LPCSTR lpcszThemeName)
	{		
		///---Sim 07-04-2008 IMPROVE_DEFAULT_THEME_MECHANISM
		if ( is_theme_default(lpcszThemeName) )
			return DefaultThemeManagement(trGetN, THEME_DEFAULT_SET);
		///---END IMPROVE_DEFAULT_THEME_MECHANISM
		
		string strClassOption;
		theme_get_class_option(trGetN, strClassOption);	
		string strFileName = theme_get_settings_file(lpcszThemeName, strClassOption);
		///Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
		//return theme_save_settings(trGetN, strFileName);
		BOOL bSaved = theme_save_settings(trGetN, strFileName);
		if( !bSaved )
			popup_errmsg_save_readonly_file( strFileName, GetSafeHwnd() );
		
		return bSaved;
		///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	}
	virtual BOOL LoadTheme(TreeNode& trGetN, LPCSTR lpcszThemeName)
	{
		///---Sim 07-04-2008 IMPROVE_DEFAULT_THEME_MECHANISM
		//if ( is_theme_default(lpcszThemeName) )
			//return DefaultThemeManagement(tr, THEME_DEFAULT_GET);
		///---END IMPROVE_DEFAULT_THEME_MECHANISM		
		return theme_update_on_new_sel(trGetN, lpcszThemeName);		
	}
	///---END CLEAR_THEME_SAVE_METHOD
	///---END IMPROVE_MULTI_THEME_FRAME_WORK

	///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	virtual	BOOL DeleteTheme(TreeNode& tr)
	{
		/// Bill 07/15/2011 CENTRALIZED_CODE
		/*
		vector<string>      vsThemes;
		int                 nSel = ThemeGetList(tr, vsThemes, TRUE, FALSE);
		
		string              strClassOption;
		theme_get_class_option(tr, strClassOption);
		
		if ( vsThemes.GetSize() == 0 )
		{
			ASSERT(false);
			return FALSE;
		}
		
		if ( theme_is_factory_default(vsThemes[0]) )
		{
			vsThemes.RemoveAt(0);
			--nSel;
		}
		
		string      strThemeTagName = "Theme";
		GETN_TREE(trGUI)
		for ( int ii=0; ii<vsThemes.GetSize(); ++ii )
		{
			TreeNode trCheck = trGUI.AddNumericNode(0, strThemeTagName + ii, TRGP_CHECK);
			trCheck.SetAttribute(STR_LABEL_ATTRIB, vsThemes[ii]);
		}
		if ( GetNBox(trGUI, _L("Delete Theme"), _L("Check the checkboxes to delete the themes"), NULL, NULL, GetSafeHwnd()) )
		{
			bool	bDoDelete = false;
			
			string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, THTYPE_ANALYSIS);
			strPath += THEME_FILE_DELETED_FOLDER;
			CheckMakePath(strPath);
			
			for ( ii=0; ii<vsThemes.GetSize(); ++ii )
			{
				if ( trGUI.Children.Item(ii).nVal == 0 )
					continue;
				
				bDoDelete = true;
				if ( okutil_cvt_str_to_predefined_type(vsThemes[ii]) == PDS_SHEET )
				{
					string strStorage = "XFTHEME_" + strClassOption;
					strStorage.MakeUpper();
					Layer lay = Project.ActiveLayer();
					if ( !lay )
					{
						ASSERT(false);
						continue;
					}
					lay.SetMemory(strStorage, NULL);
				}
				else if ( is_theme_default(vsThemes[ii]) )
				{
					theme_reset_default_settings(strClassOption);
				}
				else if ( theme_is_folder_last_used(vsThemes[ii]) )
				{
					theme_remove_xf_folder_last_used(strClassOption);
				}
				else
				{
					DeleteOneTheme(vsThemes[ii], strClassOption, strPath);
				}
			}
			if ( bDoDelete )
			{
				OptionalMessage("ThemeFolderOfDelEx", MB_OK);
				UpdateThemesMenuItems(strClassOption);
			}
		}
		*/
		///------ Folger 09/07/2011 ORG-3718-P1 DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
		//theme_delete_settings(tr, GetSafeHwnd());
		THEMEDELETESETTINGS_CUSTOMIZED		customized;
		customized.nSel = ThemeGetList(tr, customized.vsThemes, TRUE, FALSE);
		if ( theme_delete_settings(tr, GetSafeHwnd(), &customized) && customized.vsThemesToDelete.GetSize() > 0 )
		{
			string              strClassOption;
			theme_get_class_option(tr, strClassOption);
			for ( int ii=0; ii<customized.vsThemesToDelete.GetSize(); ++ii )
			{
				DeleteOneTheme(customized.vsThemesToDelete[ii], strClassOption, customized.strBackupPath);
			}
			theme_show_delete_msg(strClassOption);
		}
		///------ End DATA_INFO_PREFERENCE_DLG_FAILED_TO_DELETE_GRAPH_THEME
		
		return TRUE;
	}

	virtual	void	DeleteOneTheme(LPCSTR lpcszTheme, LPCSTR lpcszClassOption, LPCSTR lpcszPath)
	{
		string strThemeFile = okutil_theme_get_settings_file(lpcszTheme, lpcszClassOption);
		if ( strThemeFile.IsFile() )
		{
			string		strPath = lpcszPath;
			copyfile(strThemeFile, strPath + GetFileName(strThemeFile));
			okutil_delete_file(strThemeFile);
		}
	}
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
	
	/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	// compare currect GUI settings with settings in theme file
	virtual BOOL CompareTheme(const TreeNode& trGetN, LPCSTR lpcszThemeName, TreeNode& trDiff)
	{	
		Tree			trGetNThemeApplied;
		if ( trGetN )
			trGetNThemeApplied = trGetN;
		else
			trGetNThemeApplied = GetTree();
		if ( !LoadTheme(trGetNThemeApplied, lpcszThemeName) )
			return FALSE;
		
		if ( CreateDiff(trGetN, trGetNThemeApplied, trDiff) < 0 )
			return FALSE;
		
		return TRUE;
	}
	
	int		CreateDiff(const TreeNode& trDest, const TreeNode& trSrc, TreeNode& trDiff)
	{
		/// Hong 11/20/09 QA80-12798-S3 COMPARE_AUTO_ATTRIB_INSTEAD_OF_VALUE_IF_PRESENT_IN_BOTH_TREENODE
		//return trDiff.CreateDiff(trDest, trSrc, TRDIFF_KEEP_INDIVI_TARGET | TRDIFF_KEEP_INDIVI_REF | TRDIFF_KEEP_REF_VALUES);
		return trDiff.CreateDiff(trDest, trSrc, TRDIFF_KEEP_INDIVI_TARGET | TRDIFF_KEEP_INDIVI_REF | TRDIFF_KEEP_REF_VALUES | TRDIFF_CHK_AUTO_ATTRIB_INSTEAD);
		/// end COMPARE_AUTO_ATTRIB_INSTEAD_OF_VALUE_IF_PRESENT_IN_BOTH_TREENODE
	}
	/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	
	///---Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
	/// Hong 12/21/10 ORG-1750 THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
	/// Hong 01/30/11 ORG-2161 DELAY_X_RANGE_GUI_TO_NEXT_RELASE, take back comment out code by ifndef
#ifndef	__X_RANGE_SUPPORT_GUI_ACCESS__
	/// end DELAY_X_RANGE_GUI_TO_NEXT_RELASE
	virtual BOOL IsShowThemeSetting() {	return false; }
	virtual void ShowThemeSetting() { ASSERT(FALSE); }
	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	//virtual TreeNode GetThemeFilterTree(TreeNode& trGetN) { return NULL; }
	virtual bool GetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN) { return false; }
	virtual bool SetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN) { return false; }

#else	//__X_RANGE_SUPPORT_GUI_ACCESS__ /// Hong 01/30/11 ORG-2161 DELAY_X_RANGE_GUI_TO_NEXT_RELASE
	
#define			STR_ROW_RANGE			"RowRange"

	virtual BOOL IsShowThemeSetting() {	return true; }
	virtual void ShowThemeSetting()
	{
		ASSERT(IsShowThemeSetting());
		/// Hong 12/23/10 ORG-1750-P2 FIX_RUNTIME_TIME_IN_THEME_SETTING_DLG
		// Hong, GetNBox do NOT accept Tree, see GETN_TREE
		//Tree 		trThemeFilter;
		Tree 		trJunk;
		TreeNode 	trThemeFilter = trJunk.AddNode("ThemeFilter");
		/// end FIX_RUNTIME_TIME_IN_THEME_SETTING_DLG
		TreeNode	trGetN = GetTree();
		if ( GetThemeFilterTree(trThemeFilter, trGetN) )
		{			
			tree_set_branch_open_status_auto_save(trThemeFilter); /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
					
			if ( GetNBox(trThemeFilter, _L("Theme Setting"), NULL, NULL, NULL, GetSafeHwnd()) )
			{
				SetThemeFilterTree(trThemeFilter, trGetN);
			}
		}
	}
	virtual bool GetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN)
	{
		///Jasmine 12/31/10 ORG-790 PA_THEME_SAVE_ROW_RANGE
		//if ( !trThemeFilter || !trGetN )
		if ( !trThemeFilter )
			return false;
		DWORD			dwParams = 0;
		bool			bCanShowXRange = false; /// Hong 11/02/11 ORG-1750-P5 MORE_THEME_SAVE_X_RANGE_ONLY_FOR_TOOLS_HAVE_INPUT_RANGE
		if(trGetN)
		{
			TreeNode 		trDS = get_external_settings_branch(trGetN);
			TreeNode		trParams = tree_get_node_by_id(trDS, IDE_XF_DS_PARAM1);
			if ( trParams )
			{
				dwParams = trParams.nVal;
				bCanShowXRange = !O_QUERY_BOOL(dwParams, DS_BIT_NOT_SUPPORT_SAVE_X_ROW_RANGE); /// Hong 11/02/11 ORG-1750-P5 MORE_THEME_SAVE_X_RANGE_ONLY_FOR_TOOLS_HAVE_INPUT_RANGE
			}
		}
		///End PA_THEME_SAVE_ROW_RANGE
		/// Hong 09/05/11 ORG-1750-P5 THEME_SAVE_X_RANGE_ONLY_FOR_TOOLS_HAVE_INPUT_RANGE
		/// Hong 11/02/11 ORG-1750-P5 MORE_THEME_SAVE_X_RANGE_ONLY_FOR_TOOLS_HAVE_INPUT_RANGE
		//bool			bCanShowXRange = true;
		/// end MORE_THEME_SAVE_X_RANGE_ONLY_FOR_TOOLS_HAVE_INPUT_RANGE
		string		strXFName;
		if ( trGetN )
			trGetN.GetAttribute(STR_XFUNCTION_NAME_ATTRIB, strXFName);
		if ( !strXFName.IsEmpty() )
		{
			XFBase		xf(strXFName);
			if ( xf && !xf.HasCompositeRange() )
				bCanShowXRange = false;
		}
		/// end THEME_SAVE_X_RANGE_ONLY_FOR_TOOLS_HAVE_INPUT_RANGE
		/// Hong 01/19/11 ORG-1750 OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
		//TreeNode		trRowRange = trThemeFilter.AddNumericNode(O_QUERY_BOOL(dwParams, DS_BIT_SAVE_ROW_RANGE), STR_ROW_RANGE, TRGP_CHECK);
		if ( bCanShowXRange ) /// Hong 09/05/11 ORG-1750-P5 THEME_SAVE_X_RANGE_ONLY_FOR_TOOLS_HAVE_INPUT_RANGE
		{
			TreeNode		trRowRange = trThemeFilter.GetNode(STR_ROW_RANGE);
			if ( !trRowRange )
				trRowRange = trThemeFilter.AddNumericNode(O_QUERY_BOOL(dwParams, DS_BIT_SAVE_ROW_RANGE), STR_ROW_RANGE, TRGP_CHECK);
			/// end OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
			trRowRange.SetAttribute(STR_LABEL_ATTRIB, _L("Save X/Row Range"));
			trRowRange.DataID = IDE_XF_THEME_FILTER_ROW_RANGE;
		}		
		return true;
	}
	virtual bool SetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN)
	{
		if ( !trThemeFilter || !trGetN )
			return false;
		/// Hong 01/19/11 ORG-1750 OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
//		TreeNode		trRowRange = trThemeFilter.GetNode(STR_ROW_RANGE);
//		if ( !trRowRange )
//			return false;
//
//		TreeNode 		trDS = get_external_settings_branch(trGetN);
//		TreeNode		trParams = tree_get_node_by_id(trDS, IDE_XF_DS_PARAM1);
//		if ( !trParams )
//			return false;
//		DWORD			dwParams = trParams.nVal;
//		O_SET_BIT(dwParams, DS_BIT_SAVE_ROW_RANGE, trRowRange.nVal);
//		trParams.nVal = dwParams;
		TreeNode		trRowRange = trThemeFilter.GetNode(STR_ROW_RANGE);
		if ( trRowRange )
		{
			TreeNode 		trDS = get_external_settings_branch(trGetN);
			TreeNode		trParams = tree_get_node_by_id(trDS, IDE_XF_DS_PARAM1);
			if ( !trParams )
				return false;
			DWORD			dwParams = trParams.nVal;
			O_SET_BIT(dwParams, DS_BIT_SAVE_ROW_RANGE, trRowRange.nVal);
			trParams.nVal = dwParams;
		}
		/// end OPERATION_TOOLSUPPORT_APPLY_ROW_RANGE_WHEN_APPLY_THEME
		
		return true;
	}
#endif	//__X_RANGE_SUPPORT_GUI_ACCESS__ /// Hong 01/30/11 ORG-2161 DELAY_X_RANGE_GUI_TO_NEXT_RELASE
	/// end THEME_SUPPORT_APPLY_ROW_RANGE_IN_RANGE_STRING
	///---END NEW_PA_81_THEME_FILTER_SETTING
	///---END QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ

protected:
	//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
	BOOL	OnDynamicMsg(WPARAM wParam, LPARAM lParam)
	{
		onUserMsg(false, wParam, lParam);
		return true;
	}
	//--- CPY 7/5/06 QA70-8798 ON_OK_EVENT_TO_ALLOW_XF_HANDLING
	BOOL	OnMsgBox(WPARAM wParam, LPARAM lParam)
	{
		onUserMsg(true, wParam, lParam);
		return true;
	}
	///Joseph 02/14/07 SUPPORT_MORE_SPECAIL_EVENT
	//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
//	virtual bool IsSpecialEvent(int nEventID){return false;}
	///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	//virtual void OnCustomButtonCloseDialog(int nEventID, int nReturnValue){}
	///End GETN_BOX_ADD_APPLY_BUTTON
	//virtual void OnSpecialButtons(int nEventID, const string& strAux) {}
	///---Sim 10-31-2008 INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE
	//virtual bool CheckCustomBottonEvents(int nEventID, int nEventRet, const string& strAux) {return false;}
	virtual	bool CheckCustomBottonEvents(int nEventID, int nEventRet, const string& strAux)
	{
		if ( is_aux_value(strAux, DLG_NEED_CHANGE_GRID) )
		{
			UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI);
		}
		
		if ( is_aux_value(strAux, DLG_NEED_INDICATE_THEME) )
		{
			UpdateThemeCommbo(m_vsThemes, true);
		}
		
		return true;
	}
	///---END INDICATE_THEME_ON_PA_FIT_PARAM_CHANGE
	//-----------
	///End SUPPORT_MORE_SPECAIL_EVENT
	/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
	/*
	virtual bool	CheckApplyButtonEvent(TreeNode& trGetN, int nEventID, int nEventReturn)
	{
		if( GETNE_ON_APPLY == nEventID && 0 == nEventReturn )
		{
			//	return okxf_XF_execute_apply(&trGetN, 0);
			string strXFName;
			if( is_xf_gui_getn_tree(trGetN, &strXFName) )
			{
				XFBase xf(strXFName);
				if( xf && xf.SetGUI(trGetN) )
				{
					int nErr;
					if( 0 == xf.ExecuteLabTalk(NULL, NULL, NULL, 0, &nErr, 0) )
					{
						OnAfterApply(trGetN);
						return true;
					}
				}
			}
		}
		
		return false;
	}
	*/
	virtual bool	CheckApplyButtonEvent(TreeNode& trGetN, int nEventID, int nEventReturn, LPCSTR lpcszAux, int* pnApplyReturn = NULL)
	{
		if( GETNE_ON_APPLY == nEventID && !is_aux_value(lpcszAux, APPLY_EVENT_NO_CAUSE_CALL_BODY) )
		{
			int nRet = DoApply(trGetN);
			if ( 0 == nRet )
				OnAfterApply(trGetN);
			
			if ( pnApplyReturn )
				*pnApplyReturn = nRet;
			return true;
		}
		
		return false;
	}
	///---END QA80-11156 XF_PANEL_APPLY_BUTTON
	///---Sim 02-29-2008 QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG
	virtual int ExecuteXF(XFBase& xf, TreeNode& trGetN)
	{
		if ( xf )
		{
			///---Sim 04-22-2008 FIX_SCRIPT_MODE_ERROR_TO_SHOW_DIALOG
			//xf.InvokeBeforeExecute(trGetN, m_dwExecute, m_nGetNType);
			int nRet = xf.InvokeBeforeExecute(trGetN, m_dwExecute, m_nGetNType);
			if ( 0 == nRet )
			{
			///---END FIX_SCRIPT_MODE_ERROR_TO_SHOW_DIALOG
				xf.SetGUI(trGetN);
				
				if ( !m_trExecuteGetN.IsEmpty() )
					xf.ApplyTheme(NULL, m_trExecuteGetN, true, true);
				
				bool bRet = xf.Evaluate(0, m_trExecuteGetN);
				
				if ( !bRet )
					m_trExecuteGetN.Reset();
				SetExecValsInfo2GetNTree(trGetN, m_trExecuteGetN);
				
				if ( bRet )
					return 0;
			} ///---Sim 04-22-2008 FIX_SCRIPT_MODE_ERROR_TO_SHOW_DIALOG
		}
		return -1;
	}
	///---END QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG
	///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
	virtual int	DoApply(TreeNode& trGetN)
	{
		string strXFName;
		if( is_xf_gui_getn_tree(trGetN, &strXFName) )
		{
			///Sophy 9/14/2011 ORG-3797-P1 GADGET_PREFERENCE_APPLY_BROKEN_AFTER_ADD_THEME_SUPPORT
			if ( O_QUERY_BOOL(m_dwXFBits, DYNALAYOUT_NO_EXECUTE_XF_ON_APPLY) )
				return 0;
			///end GADGET_PREFERENCE_APPLY_BROKEN_AFTER_ADD_THEME_SUPPORT
			XFBase xf(strXFName);
			///---Sim 02-29-2008 QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG
			//if( xf && xf.SetGUI(trGetN) )
			//{
				//int nErr;
				//if ( 0 == xf.ExecuteLabTalk(NULL, NULL, NULL, 0, &nErr, 0) )
				//{
					//return 0;
				//}
			//}
			return ExecuteXF(xf, trGetN);
			///---END QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG
		}
		
		return -1; // error
	}
	///---END QA80-11156 XF_PANEL_APPLY_BUTTON
	// after user clicked Apply we change caption of "Cancel" button to close
	// and also set attribute into GetN tree to suppress "Command Error" message
	// that is is usually dumped into script window
	///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
	//void		OnAfterApply(TreeNode& trGetN)
	virtual void		OnAfterApply(TreeNode& trGetN)
	///---END QA80-11156 XF_PANEL_APPLY_BUTTON
	{
#ifndef	_SPLITTER_CONTORL_H
		Button btnCancel = GetItem(IDCANCEL);
		if ( btnCancel && IDCANCEL == getStandardButtonType(btnCancel.Text) )
		{
			btnCancel.Text = GetLocalized(STR_BTN_NAME_CLOSE);
		}

		int nSuppress = 1;
		trGetN.SetAttribute(STR_ATTRIB_SUPPRESS_COMMAND_ERROR_MESSAGE, nSuppress);
#endif
	}
	/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	
	///---Sim 02-29-2008 QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG
	BOOL	SetExecValsInfo2GetNTree(TreeNode& trGetN, const TreeNode& trExecuteGetN)
	{
		//TreeNode trExecutionVals = trGetN.GetNode("ExecutionValues"); // hard code, because got troubles when searched treenode by small id
		TreeNode trExecutionVals = get_external_settings_branch(trGetN, EX_SETTING_EXEC_VALS, true);
		if ( !trExecutionVals )
			return false;
		
		trExecutionVals.Replace(trExecuteGetN, true, true, true);
		tree_remove_attribute(trExecutionVals, STR_DATAID_ATTRIB);
		return true;
	}
	///---END QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG
	
private:
	
	///Joseph 11/04/06 DESCRIPTION_REMOVE_XFNAME
	bool updateDescription(const string& strThemeDescription)
	{
		if(strThemeDescription.IsEmpty())
			return false;
		int nIndex = strThemeDescription.Find(":");
		int nLength = strThemeDescription.GetLength();
		
		///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//if(nIndex >= 0)
			//m_strDescription = strThemeDescription.Mid(nIndex + 1, nLength - 1);
		//else
			//m_strDescription = strThemeDescription;
		//m_strDescription.TrimLeft();
		//m_editThemeDescription.Text = m_strDescription;
		
		if(nIndex >= 0)
			m_strDescription = strThemeDescription.Mid(nIndex + 1, nLength - nIndex - 1);
		m_strDescription.TrimLeft();
		///End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		return true;
	}
	///End DESCRIPTION_REMOVE_XFNAME
	
	
	void onUserMsg(bool bMsgBox, WPARAM wParam, LPARAM lParam)
	{
		HWND hWndParent =  GetSafeHwnd();
		//------ Folger 08/29/08 QA80-12120 CENTRALIZE_XF_ERROR_MSEEAGE_PARSING_CODE
		//string strMsg;
		//LPCSTR lpcsz;
		//if(0 == wParam)
		//{
			//lpcsz = (LPCSTR)lParam;
		//}
		//else 
		//{
			//string str1;
			//if(ocu_load_err_msg_str(wParam, &str1))
			//{
				//// lParam is always in string form, strErrMsg is like "123:456" or "123:str"
				//LPCSTR lpcsz = (LPCSTR)lParam;
				////--------- CPY 11/24/06 SUPPORT_FOR_BOTH_STR_AND_NUM_ARG
				///*
				//if(str1.Find("%d") >= 0)
				//{
					//int nCode = atoi(lpcsz);
					//strMsg.Format(str1, nCode);
				//}
				//*/
				//int nNumPos;
				//if((nNumPos = str1.Find("%d")) >= 0)
				//{
					//int nStrPos = str1.Find("%s");
					//if(nStrPos >= 0)
					//{
						//vector<string> vs;
						//string strArgs = lpcsz;
						//if(strArgs.GetTokens(vs, '|') != 2)
							///// Hong 11/06/07 v8.0741 MORE_LOCALIZATION
							////strMsg.Format("Error! UserMsg str(%s) should be prepared with two values separated by |", lpcsz);
							//ocu_load_msg_str(CER_USERMSG_NOT_CORRECT_SEPARATED, &strMsg, lpcsz);
							///// end MORE_LOCALIZATION
						//else
						//{
							//if(nStrPos > nNumPos)
							//{
								//int nCode = atoi(vs[0]);
								//strMsg.Format(str1, nCode, vs[1]);
							//}
							//else
							//{
								//int nCode = atoi(vs[1]);
								//strMsg.Format(str1, vs[0], nCode);
							//}
						//}
					//}
					//else
					//{
						//int nCode = atoi(lpcsz);
						//strMsg.Format(str1, nCode);
					//}
				//}
				////---------- end SUPPORT_FOR_BOTH_STR_AND_NUM_ARG
				//else if(str1.Find("%s") >= 0)
					//strMsg.Format(str1, lpcsz);
				//else	
					//strMsg = str1;
			//}
			//else
				////strMsg.Format("Error Message %d was not found, please contact Originlab to fix this problem.", wParam);
				//ocu_load_msg_str(CER_ERR_MSG_NOT_FOUND, &strMsg, NULL, &wParam); /// Hong 11/06/07 v8.0741 MORE_LOCALIZATION
			//
			//lpcsz = strMsg;
		//}
		LPCSTR lpcsz = xf_load_err_msg(wParam, (LPCSTR)lParam);
		//------ End CENTRALIZE_XF_ERROR_MSEEAGE_PARSING_CODE
		if(bMsgBox && lpcsz)
			MessageBox(hWndParent, lpcsz, _L("Attention"), MB_OK);
		else if(m_btnErrMessage)
		{
			string strOldText = m_btnErrMessage.Text;
			int nOldLength = strOldText.GetLength();
			///Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
			//m_btnErrMessage.Text = lpcsz;
			CountSetErrMsg(lpcsz);
			///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
			int nLength = m_btnErrMessage.Text.GetLength();
			if(nOldLength == 0 && nLength!= 0 ||
			   nOldLength != 0 && nLength== 0 ||
				nLength > nOldLength + 30 || nLength + 30 < nOldLength
				|| !m_btnErrMessage.Visible && nLength > 0 )	//------ Folger 07/23/08 FIX_XF_ERROR_MESSAGE_SHOW_STATUS_IN_PA
				{
					//out_str("need to resize dlg to update status msg");	
					ResizeDlgControls();
				}
		}
	}
	//----
	
	///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
	void checkChangeApplyButtonText(int nEventID, LPCSTR lpcszAux)
	{
		string strAux(lpcszAux);
		//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
		//if(nEventID == GETNE_ON_INIT && strAux.Find(STR_NEW_APPLY_BUTTON_TEXT) >= 0)
		//{
			//strAux.TrimLeft(STR_NEW_APPLY_BUTTON_TEXT);
			//OnInitChangeButtonText(strAux);
		//}
		if(nEventID == GETNE_ON_INIT && strAux.Find(STR_NEW_APPLY_BUTTON_TEXT) == 0)
		{
			int nLength = lstrlen(STR_NEW_APPLY_BUTTON_TEXT);
			strAux = strAux.Mid(nLength);
			OnInitChangeButtonText(strAux);
		}
		//-----------
	}
	///End GETN_BOX_ADD_APPLY_BUTTON
	
	///---Sim 10-31-2007 FIX_RESET_BUTTON_NAME
	bool setBtnName(int nBtnID, LPCSTR lpcszName)
	{
#ifndef	_SPLITTER_CONTORL_H //---- CPY 7/30/2007 COMPILE_ERR_AFTER_SIM_IMPROVE_BUTTON_ENABLE_ISSUE
		Button btn = GetItem(nBtnID);
		if ( btn )
		{
			btn.Text = lpcszName;
			return true;
		}
#endif
		return false;
	}
	///---END FIX_RESET_BUTTON_NAME	

	///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	BOOL	isLabtalkCallable(TreeNode& tr)
	{
		if ( !tr )
			tr = GetTree();

		int		nVal = 0;
		return tr.GetAttribute(STR_LABTALK_USAGE_ATTRIB, nVal) && nVal;
	}
	///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG

	///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	virtual	void	ExtraInfoToThemeStr(string & str)		{}
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

protected:
	//---

	///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
	virtual	int		ThemeGetList(TreeNode& tr, vector<string>& vsThemes, BOOL bRetZeroIfNotInThemeList = TRUE, BOOL bIncludeLastUsed = TRUE)
	{
		if ( bIncludeLastUsed )
			/// Zech 08/11/2011 ORG-3492-P1 LIST_THEME_FILES_IN_EXE_FOLDER
			//return theme_get_list(tr, vsThemes, bRetZeroIfNotInThemeList);
			return theme_get_list(tr, vsThemes, bRetZeroIfNotInThemeList, true);
			/// END LIST_THEME_FILES_IN_EXE_FOLDER

		return theme_get_list_filter_last_used(tr, vsThemes, bRetZeroIfNotInThemeList);
	}
	///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT

	/// YuI 04/17/06 GLOBAL_EVENT_HANDLER_NEEDS_TO_BE_INVOKED
	// overriden in DynaBoxDlg
	virtual void InvokeGlobalEventOnInitDialog()	{}
	/// end GLOBAL_EVENT_HANDLER_NEEDS_TO_BE_INVOKED	
	
	/// CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
	virtual void InvokeGlobalEventOnThemeChange()	{}
	///End SEPRATE_INIT_AND_THEME_EVENT
	
	///Sandy 2007-4-2 MOVE_GRAPH_OBJECT_EVENT_TO_BASE_CLASS
	/// Iris 12/28/2006 v8.0533 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	//virtual void InvokeGlobalEventOnGraphObjectChange()		{}
	void InvokeGlobalEventOnGraphObjectChange(uint wParam, uint lParam)		
	{
		TreeNode tr = GetTree();
		if(tr)
		{
			tr.SetAttribute(STR_GO_MSG_INFO_1_ATTRIB, (int)wParam);
			tr.SetAttribute(STR_GO_MSG_INFO_2_ATTRIB, (int)lParam);
		}	
		invokeBasicGlobalEvent(GETNE_ON_GRAPH_OBJECT_CHANGE);
	}
	///end CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	///end MOVE_GRAPH_OBJECT_EVENT_TO_BASE_CLASS
	
	//----- CPY 4/20/07 QA70-9602 LABEL_CHANGE_SHOULD_NOT_TRIGGER_INIT_EVENT
	//CPY 4/20/07 I have to make a lot of changes, most old codes removed and actual changes not marked, need to go back to VSS to see old code
	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	//bool UpdateDynaControl(bool bResize = true, DWORD dwEventType = 0, bool bCallNodesHandlers = false, DWORD dwUpdateBits = 0, bool bSkipFirstNode = true)
	bool UpdateDynaControl(bool bResize = true, DWORD dwEventType = 0, bool bCallNodesHandlers = false, DWORD dwUpdateBits = 0, bool bSkipFirstNode = true)
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	{
		bool bRet = false;
		//----- CPY 4/21/2007 QA70-9659 XF_ERR_MSG_NEED_TO_ALLOW_KEEPING_OLD_MSG_ON_DLG
		//DWORD dwCntrl = 0;
		DWORD dwCntrl = m_dwXFBits;
		//-----	end XF_ERR_MSG_NEED_TO_ALLOW_KEEPING_OLD_MSG_ON_DLG

		if( m_bGrayBackground )
			dwCntrl |= DYNALAYOUT_BACKGROUND_GRAY;
		if( m_b1ColIndent )
			dwCntrl |= DYNALAYOUT_1COL_INDENT;
			
		///---Sim 05-17-2008 CLEAR_CODE_FOR_GET_GETN_TREE
		/*
		TreeNode trEdit;
		if(m_bUseInputTree)
			trEdit = m_input_tr;
		else
			trEdit = bSkipFirstNode? m_paramTree.FirstNode : m_paramTree;
		*/
		/// EJP 2008-05-30 v8.0875 FIX_MISSING_SHEET_INFO_NODES_IN_BOOK_ORGANIZER, need to pass bSkipFirstNode to GetTree
		///TreeNode trEdit = GetTree();
		TreeNode trEdit = GetTree(true, bSkipFirstNode); // first arg is true by default
		/// end FIX_MISSING_SHEET_INFO_NODES_IN_BOOK_ORGANIZER
		///---END CLEAR_CODE_FOR_GET_GETN_TREE
		int nEventType = (dwEventType & GETNEVENT_ON_ANY);
		BOOL bSetTree = false;			
		switch(nEventType)
		{
		case GETNEVENT_ON_INIT:
			bSetTree = true;
			InvokeGlobalEventOnInitDialog(); // must call regardless of bCallNodesHandlers
			//---- CPY 4/23/07 NODE_HANDLER_NOT_GETTING_CALL_LEAD_TO_DISABLE_ENABLE_PROBLEM_ON_START
			//bCallNodesHandlers = false;// already called
			//----
			break;
		case GETNEVENT_ON_THEME:
			bSetTree = true;
			InvokeGlobalEventOnThemeChange(); // must call regardless of bCallNodesHandlers
			//---- CPY 4/23/07 NODE_HANDLER_NOT_GETTING_CALL_LEAD_TO_DISABLE_ENABLE_PROBLEM_ON_START
			//bCallNodesHandlers = false;// already called
			//----
			break;
		case GETNEVENT_ON_CHANGE_UPDATE_GUI:
			bSetTree = true;
			// call event after tree is set if bCallNodesHandlers
			break;
		default:
			break;
		}
		dwCntrl |= dwUpdateBits;
		if(dwUpdateBits & DYNACONTROL_UPDATE_LABELS)
			bSetTree = true; // Sim 04-24-2007 have to call SetTree(), because the Update() function can't recalculate grid when label of node is changed
		///------ Folger 02/09/09 QA80-12786 NODE_NUMBER_FORMAT_CHANGE_SHOULD_UPDATE_DYNACONTROL_BY_SET_TREE
		if(dwUpdateBits & DYNACONTROL_UPDATE_NUM_FORMAT)
			bSetTree = true;
		///------ End NODE_NUMBER_FORMAT_CHANGE_SHOULD_UPDATE_DYNACONTROL_BY_SET_TREE
		///------ Folger 04/14/09 GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING
		if ( DYNACONTROL_UPDATE_GROUP_BRANCH & dwUpdateBits )
			bSetTree = true;
		///------ End GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING
		///---Sim 02-05-2009 QA80-13072 FIX_DYNA_DLG_UPDATE_COMBO_STR_ON_TREE_NODE_EVENT
		if( dwUpdateBits & DYNACONTROL_UPDATE_COMBOS )
			bSetTree = true;
		///---END QA80-13072 FIX_DYNA_DLG_UPDATE_COMBO_STR_ON_TREE_NODE_EVENT
		if(dwUpdateBits & DYNACONTROL_UPDATE_NO_SETTREE)//----- CPY 4/23/07 QA70-9651 NLFIT_DATA_MODE_CHANGE_PROPER_EVENT
			bSetTree = false;
	
		if(bSetTree)
		{
			///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
			//bRet = m_DynaCntrl.SetTree(trEdit, dwCntrl);
			bRet = m_DynaCntrl.SetTree(trEdit, dwCntrl, m_nCurrentTabDisplayIndex);
			CheckUpdateTabs();
			///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
		}
		else
			bRet = m_DynaCntrl.Update(dwCntrl);

		if(bRet)
		{
			if(bCallNodesHandlers)
				m_DynaCntrl.InvokeHandlers(dwEventType);
			
			resizeDlgToFit();  /// TD 1-26-07 QA70-9313 NEED_RESIZE_ON_UPDATE_DYNA
			//return true; 	///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME remove
		}
		///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
		///---Sim 11-12-2007 SUPPORT_AUTO_MECHANISM_AFTER_GUI_CHANGE_VALUE
		//OnAfterUpdateDynaControl();
		///---Sim 12-03-2007 MORE_IMPROVE_UPDATE_DYNA_CONTROL_MECHANISM
		//PostMessage(WM_USER_AFTER_UPDATE_DYNACONTROL, nEventType);
		///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		//AfterUpdateDynaControl(nEventType);
		AfterUpdateDynaControl(dwEventType);
		///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		///---END MORE_IMPROVE_UPDATE_DYNA_CONTROL_MECHANISM
		///---END SUPPORT_AUTO_MECHANISM_AFTER_GUI_CHANGE_VALUE
		
		//return false;
		return bRet;
		///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	}
	///---Sim 12-03-2007 MORE_IMPROVE_UPDATE_DYNA_CONTROL_MECHANISM
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//virtual void AfterUpdateDynaControl(int nEventType)
	virtual void AfterUpdateDynaControl(DWORD dwEventType)
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	{
		///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		///---Sim 10-17-2008 QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
		//if ( GETNEVENT_ON_RECONSTRUCT & dwEventType )
		if ( GETNEVENT_ON_GUI_CHANGED & dwEventType )
		///---END QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
			///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
			//UpdateThemeCommbo(m_vsThemes, true);
			UpdateThemeCommboAfterChange();
			///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//PostMessage(WM_USER_AFTER_UPDATE_DYNACONTROL, nEventType);
		PostMessage(WM_USER_AFTER_UPDATE_DYNACONTROL, dwEventType);
		///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	}
	///---END MORE_IMPROVE_UPDATE_DYNA_CONTROL_MECHANISM
	///---Sim 11-12-2007 SUPPORT_AUTO_MECHANISM_AFTER_GUI_CHANGE_VALUE
	//virtual void OnAfterUpdateDynaControl() {} ///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	virtual BOOL OnAfterUpdateDynaControl(uint wParam, uint lParam) {return true;}
	///---END SUPPORT_AUTO_MECHANISM_AFTER_GUI_CHANGE_VALUE
	virtual void  resizeDlgToFit(int cx = 0, int cy = 0){} /// TD 1-26-07 QA70-9313 NEED_RESIZE_ON_UPDATE_DYNA
	virtual void ConstructWithoutTree()
	{
		GETN_TREE(trTemp)
		//GETN_STR(empty, "", "") GETN_READ_ONLY
		GETN_STR(empty, "Empty", "")
		m_paramTree=trTemp;
		//m_treeEditCntrl.Init(GetTreeEditPaneID(), false, true, NULL, *this);	///DG INIT_ONE_TIME
		//m_treeEditCntrl.Update(m_paramTree, true, true);
		UpdateDynaControl();
	}

	bool InitDynaControl(int nID, WndContainer& dlg = NULL)
	{
		//------ CPY 5/21/08 QA70-11576 XF_DLG_ERR_MSG_SHOULD_HAVE_MORE_OBVIOUS_SHOWING
		/*
		//---------- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
#ifdef		_SPLITTER_CONTORL_H
		m_btnErrMessage = dlg.GetDlgItem(IDC_ERR_MESSAGE_BOX);
#else		// !_SPLITTER_CONTORL_H
		m_btnErrMessage = GetItem(IDC_ERR_MESSAGE_BOX);//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
#endif		// !_SPLITTER_CONTORL_H
		if(m_btnErrMessage)
			m_btnErrMessage.Text = "";
		//----
		*/
		CheckInitErrMsgBox(dlg, COLOR_RED, COLOR_BLACK, COLORTEXTBLINK_DEFAULT);	///Jasmine 05/22/08 EXPORT_ERRMSGBOX_SETTING_TO_DEVIRATED_CLASS
		//------ end XF_DLG_ERR_MSG_SHOULD_HAVE_MORE_OBVIOUS_SHOWING
		m_bGrayBackground = true;//false;
		m_b1ColIndent = false;	///	SY 2006-12-18 QA70-9217 v8.0528 EDITABLE_PART_ON_NEXT_LINE_FROM_LABEL
		Control			ctrl;
#ifdef		_SPLITTER_CONTORL_H
		ctrl = dlg.GetDlgItem(nID);
#else		// !_SPLITTER_CONTORL_H
		ctrl = GetItem(nID);
#endif		// !_SPLITTER_CONTORL_H
		return m_DynaCntrl.CreateControl(ctrl.GetSafeHwnd());			
	}
	///---Sim 12-07-2007 MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED
	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	//int getMsgBoxHeight(Control ctrl, int nMsgBoxWidth)
	int GetMsgBoxHeight(Control ctrl, int nMsgBoxWidth)
	{
		if(!ctrl)
			return 0;
		string str = ctrl.Text;
		//---CPY 4/26/07 QA70-9608 TEXT_MEASURE_FOR_MULTI_LINE_TEXT
		/*
		int nLength = ctrl.Text.GetLength();
		if(nLength < 1)
			return 0;
		uint nn = GetDialogBaseUnits();
		int nw1 = LOWORD(nn);nw1 = 0.5 + 0.8*nw1;
		int nh1 = HIWORD(nn);nh1 = 0.5 + 0.95*nh1;
		int nTextWidth = nLength * nw1;
		return nh1 * (1 + nTextWidth/nMsgBoxWidth);
		*/
		int nW = nMsgBoxWidth;
		int nHeight = ctrl.Measure(str, &nW);
		if(nHeight > 0)
		{
			//printf("%s\nHeight=%d\n", str, nHeight);
		}
		return nHeight;
		//----
	}
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE	
	///---END MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED
	//-------- CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT
	virtual void ResizeDlgControls() {}
	int GetDlgStatusMsgBoxHeight(int nStatusBoxWidth)
	{
		///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
		//use central function
		/*
		if(!m_btnErrMessage)
			return 0;
		int nLength = m_btnErrMessage.Text.GetLength();
		if(nLength < 1)
			return 0;
		uint nn = GetDialogBaseUnits();
		int nw1 = LOWORD(nn);nw1 = 0.5 + 0.8*nw1;
		int nh1 = HIWORD(nn);nh1 = 0.5 + 0.95*nh1;
		int nTextWidth = nLength * nw1;
		return nh1 * (1 + nTextWidth/nStatusBoxWidth);
		*/
		///---Sim 12-07-2007 MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED
		//return getMsgBoxHeight(m_btnErrMessage, nStatusBoxWidth);
		return GetMsgBoxHeight(m_btnErrMessage, nStatusBoxWidth);
		///---END MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED
		///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	}
	//--------
	
	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	int GetDlgDescripBoxHeight(int nDescripBoxWidth)
	{
		///---Sim 12-07-2007 MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED
		//return getMsgBoxHeight(m_editThemeDescription, nDescripBoxWidth);
		return GetMsgBoxHeight(m_editThemeDescription, nDescripBoxWidth);
		///---END MOVE_GET_BOX_FIT_HEIGHT_FUNC_TO_PROTECTED
	}
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	
	void SetEventCallback(PEVENT_FUNC evt, PEVENT_GETN pevtNew)
	{
		m_pEventNew = pevtNew;
		/// TD 5-2-06 MOVE_TO_BASE_CLASS
		m_pEventFunc = evt;
		///  end TD 5-2-06 MOVE_TO_BASE_CLASS
		m_DynaCntrl.SetEventCallback(evt, pevtNew);
	}
	/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
	EVENTS_BEGIN	
	ON_DC_GENERIC(OnGenericControlMsg)
	EVENTS_END
	/// end EDITBOX_WITH_BUTTON
	
protected:	
	/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
	///------ Folger 06/15/09 QA80-13771 GRAPH_BROWSER_SUPPORT_GENERAL_CUSTOMIZATION_BY_SPECIFIC_FILTER_FUNCTION
	//BOOL	OnGenericControlMsg(TreeNode &node, uint nCode)
	//{
		/////Jasmine 10/26/06 KEEP_DLG_MODEL
		////return DynaDlg_OnGenericControlMsg(node, nCode)
		//return DynaDlg_OnGenericControlMsg(node, nCode, GetSafeHwnd());
	//}
	BOOL	OnGenericControlMsg(TreeNode &node, ODWP dwCntrls)	/// TD ML 11-09-2010 NEW_TYPES
	{
		ODWP*	pdw = (ODWP*)dwCntrls;	/// TD ML 11-09-2010 NEW_TYPES
		LPCSTR	lpcsz = (LPCSTR)pdw[1];
		return DynaDlg_OnGenericControlMsg(node, pdw[0], GetSafeHwnd(), lpcsz);
	}
	///------ End GRAPH_BROWSER_SUPPORT_GENERAL_CUSTOMIZATION_BY_SPECIFIC_FILTER_FUNCTION
	/// end EDITBOX_WITH_BUTTON
	// TD 5-2-06
	//moved to base class
	PEVENT_FUNC 	GetOldEventHandler()
	{
		PEVENT_FUNC temp_pEventFunc = m_pEventFunc;// wait until we can call member function pointer directly
		TreeNode trNode = GetTree();
		if(trNode)
		{
			return temp_pEventFunc;
		}
		return NULL;
	}
	//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
	PEVENT_GETN GetNewEventHandler()
	{
		PEVENT_GETN temp_pEventFunc = m_pEventNew;
		TreeNode trNode = GetTree();
		if(trNode)
		{
			return temp_pEventFunc;
		}
		return NULL;
	}

	///---Sim 07-27-2007 IMPROVE_BUTTON_ENABLE_ISSUE
	void UpdateButtonEnableValue(DWORD& dwEnables, int nBtnID, DWORD dwBtnBit)
	{
#ifndef	_SPLITTER_CONTORL_H //---- CPY 7/30/2007 COMPILE_ERR_AFTER_SIM_IMPROVE_BUTTON_ENABLE_ISSUE
		Control btn = GetItem(nBtnID);
		if ( btn && btn.Enable )
			dwEnables |= dwBtnBit;
		else
			dwEnables &= ~dwBtnBit;
#endif //---- CPY 7/30/2007 COMPILE_ERR_AFTER_SIM_IMPROVE_BUTTON_ENABLE_ISSUE
	}
	///---END IMPROVE_BUTTON_ENABLE_ISSUE
	
	///Joseph 04/12/07 FIX_BUG_GET_BUTTON_STATUS_ON_MORE_EVENT_IN_EVENT1
	//must keep the previous status, when invoke event.
	bool GetEnableButtonStatus(DWORD& dwEnables, int nEventID)
	{
#ifndef	_SPLITTER_CONTORL_H	
		if(!GetDlgSpecialButtonStatus(dwEnables, nEventID))
			return false;
		
		///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
		UpdateButtonEnableValue(dwEnables, IDC_APPLY, GETNGEVT_APPLY_ENABLE);
		UpdateButtonEnableValue(dwEnables, IDC_UNDO_BTN, GETNGEVT_UNDO_ENABLE);
		///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	
		for(int ii = 1, jj = IDC_GETN_CUSTOM_BTN1; ii <= CUSTOM_BUTTONS_COUNT; ii++, jj++)
		{
			///---Sim 07-27-2007 IMPROVE_BUTTON_ENABLE_ISSUE
			/*
			Control btn = GetItem(jj);
			if(! btn)
				
				//in some dialogs, there is no custom buttons. Should support these dialogs.
				///Joseph 05/18/07	ADD_OPERATION_ERRMSG_LINE
				//return false;
				return true;
				///End ADD_OPERATION_ERRMSG_LINE
				
			if(btn.Enable)
				dwEnables |= CUSTOM_BUTTON_TO_GETN_ENABLE(ii);
			///Joseph 06/21/07 v8.0647 FIX_BUG_GET_BUTTON_DISABLE
			//shoud get button disable status
			else
				dwEnables &= (~CUSTOM_BUTTON_TO_GETN_ENABLE(ii));
			///End FIX_BUG_GET_BUTTON_DISABLE
			*/
			UpdateButtonEnableValue(dwEnables, jj, CUSTOM_BUTTON_TO_GETN_ENABLE(ii));
			///---END IMPROVE_BUTTON_ENABLE_ISSUE
		}
#endif
		return true;
	}
	
	virtual bool GetDlgSpecialButtonStatus(DWORD& dwEnables, int nEventID)
	{
#ifndef	_SPLITTER_CONTORL_H		
		///---Sim 07-27-2007 IMPROVE_BUTTON_ENABLE_ISSUE
		/*
		Control ctrlOK = GetItem(IDOK);
		///Joseph 06/21/07 v8.0647 FIX_BUG_GET_BUTTON_DISABLE
		if(ctrlOK && ctrlOK.Enable)
			//dwEnables &= GETNGEVT_OK_ENABLE;
			dwEnables |= GETNGEVT_OK_ENABLE;
		else
			dwEnables &= ~GETNGEVT_OK_ENABLE;
		///END v8.0647 FIX_BUG_GET_BUTTON_DISABLE
		*/
		UpdateButtonEnableValue(dwEnables, IDOK, GETNGEVT_OK_ENABLE);
		///---END IMPROVE_BUTTON_ENABLE_ISSUE
#endif
		return true;
	}
	///End FIX_BUG_GET_BUTTON_STATUS_ON_MORE_EVENT_IN_EVENT1
	
	//----- CPY 7/5/06 QA70-8798 ON_OK_EVENT_TO_ALLOW_XF_HANDLING
	// return false will prevent OnOK to close dialog
	BOOL OnOKEvent()
	{
		///------ Folger 11/29/2010 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
		TabsShowBranches(TRUE);
		///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS

		PEVENT_GETN pfnNew = GetNewEventHandler();
		if(pfnNew)
		{
			DWORD dwEnable = GETNGEVT_ENABLE_ALL_BUTTONS;
			bool bUpdateGrid;
			WndContainer *pDlg;
			pDlg = this;
			string strAux;//--- CPY 10/10/06 QA70-9039 XF_WIZARD_BAR
			string strErrMsg;//----- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
			bUpdateGrid = pfnNew(GetTree(), -1, GETNE_ON_OK, dwEnable, "", *pDlg, strAux, strErrMsg);
			return dwEnable & GETNGEVT_OK_ENABLE;
		}
		return true;
	}
	//------
	
	///Joseph 01/28/07 CHANGE_XF_APPLY_BUTTON_TEXT
	virtual void OnInitChangeButtonText(LPCSTR lpcszButtonText){}
	///End CHANGE_XF_APPLY_BUTTON_TEXT
	
	//------- CPY 5/16/07 QA70-9659 GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME
	string getGlobalEventAsTagName(int nEventID)
	{
		switch(nEventID)
		{
		case GETNE_ON_INIT:
			return STR_EVENT_TAG_INIT;
		//------ Folger 07/23/08 FIX_XF_ERROR_MESSAGE_SHOW_STATUS_IN_PA
		case GETNE_ON_GRAPH_OBJECT_CHANGE:
			return "<GrobjChg>";
		//------
		}
		string junk;
		return junk;
	}
	//-------
	
	/// CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
	//void 	invokeBasicGlobalEventOnInitDialog()
	///Joseph 03/05/07 XF_WIZ_CLEANUP
	//void 	invokeBasicGlobalEvent(int nEventID)
	///------ Folger 05/03/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
	//virtual void 	invokeBasicGlobalEvent(int nEventID, TreeNode& trGetN = NULL)
	virtual void 	invokeBasicGlobalEvent(int nEventID, TreeNode& trGetN = NULL, int nRow = -1)
	///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
	///End XF_WIZ_CLEANUP
	{
		// this code is taken from GetNBoxDlg::OnInitDialog
		PEVENT_GETN pfnNew = GetNewEventHandler();
#ifdef DC_IN_DLG
		PEVENT_FUNC pfn = GetOldEventHandler();
		if(pfn)
		{
			int nCntrlTypes[] = {
				ONODETYPE_CHECKBOX,
				ONODETYPE_DROPDOWN_NUMERIC_FLOAT,
				ONODETYPE_DROPLIST_STRINGS,
				ONODETYPE_DROPLIST_COLORS,
				0
			};
			int ii = 0;			
			while(nCntrlTypes[ii] > 0)
			{
				pfn(GetTree(), -1, nCntrlTypes[ii], *this);
				ii++;
			}
		}
#endif //
		//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
		///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
		//even if event1 handler is empty, it should do something necessary. like APPLY event cause call x-function body
		//if(pfnNew)
		///---END QA80-11156 XF_PANEL_APPLY_BUTTON
		{
			///---Sim 06-22-2007 OPTION_TO_KEEP_BUTTON_STATUS_ON_EVENT
			//DWORD dwEnables = GETNGEVT_ENABLE_ALL_BUTTONS;
			DWORD dwEnables;
			
			if ( m_dwXFBits & DYNALAYOUT_KEEP_BTN_STATUS )
			{
				///Joseph 04/12/07 FIX_BUG_GET_BUTTON_STATUS_ON_MORE_EVENT_IN_EVENT1
				if(! GetEnableButtonStatus(dwEnables, nEventID))
					return;
				///End FIX_BUG_GET_BUTTON_STATUS_ON_MORE_EVENT_IN_EVENT1
			}
			else
				dwEnables = GETNGEVT_ENABLE_ALL_BUTTONS;
			///---END OPTION_TO_KEEP_BUTTON_STATUS_ON_EVENT
			
			///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
			//bool bUpdateGrid;
			int nEventReturn;
			nEventReturn = 0; ///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
			///End GETN_BOX_ADD_APPLY_BUTTON
			WndContainer *pDlg;
			pDlg = this;
			/// CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
			//bUpdateGrid = pfnNew(GetTree(), -1, GETNE_ON_INIT, bOKEnable, "", *pDlg);
			//--------- CPY 10/10/06 QA70-9039 XF_WIZARD_BAR
			//bUpdateGrid = pfnNew(GetTree(), -1, nEventID, bOKEnable, "", *pDlg);
			string strAux;
			//strErrMsg = "";	 ///Joseph	12/07/06	ADD_MESSAGE_BOX
			///---END FIX_KEEP_ERR_MSG
			///Joseph 03/05/07 XF_WIZ_CLEANUP
			TreeNode trNode;
			if(!trGetN)
				trNode = GetTree();
			else
				trNode = trGetN;
			if ( !trNode )
				return;
			///End XF_WIZ_CLEANUP
			//----------------------------------------------------- CPY 5/16/07 QA70-9659 GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME
			//	///---Sim 05-09-2007 FIX_KEEP_ERR_MSG
			//	//---- Iris 11/02/06 FIX_NOT_SHOW_MSG_BOX_SOMETIME
			//	//string strErrMsg;//CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
			//	string strErrMsg = "";
			//	if ( m_dwXFBits & DYNALAYOUT_NO_AUTO_CLR_ERR_MSG )
			//	{
			//		if(m_btnErrMessage)
			//			strErrMsg = m_btnErrMessage.Text; 
			//	}
			//	//----
			//	///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
			//	//bUpdateGrid = pfnNew(GetTree(), -1, nEventID, bOKEnable, "", *pDlg, strAux, strErrMsg);
			//	nEventReturn = pfnNew(trNode, -1, nEventID, dwEnables, "", *pDlg, strAux, strErrMsg);
			//	///End GETN_BOX_ADD_APPLY_BUTTON
			//	///---Sim 05-16-2007 FIX_CLEAR_ERR_MSG_FOR_XF_BAR
			//	getn_dlg_check_show_msg(pDlg->GetSafeHwnd(), strErrMsg); //CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
			//	///---END FIX_CLEAR_ERR_MSG_FOR_XF_BAR
			string strTagName = getGlobalEventAsTagName(nEventID);
			string strErrMsg = m_DynaCntrl.m_strErrMsgSenderTagName;
			if(pfnNew) ///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
				///------ Folger 05/03/2012 ORG-5592-S1 ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
				//nEventReturn = pfnNew(trNode, -1, nEventID, dwEnables, strTagName, *pDlg, strAux, strErrMsg);
				nEventReturn = pfnNew(trNode, nRow, nEventID, dwEnables, strTagName, *pDlg, strAux, strErrMsg);
				///------ End ADD_DATA_IDENTIFIER_FOR_FITTING_TOOLS
			
			///---Sim 05-17-2007 FIX_ERR_MSG_WITH_GETN_EVENT_TAGNAME
			string strLastTagName;
			strLastTagName = m_DynaCntrl.m_strErrMsgSenderTagName;
			getn_dlg_check_show_msg(pDlg->GetSafeHwnd(), strErrMsg, strTagName, &strLastTagName, (m_dwXFBits & DYNALAYOUT_NO_AUTO_CLR_ERR_MSG)?false:true);
			m_DynaCntrl.m_strErrMsgSenderTagName = strLastTagName;
			///---END FIX_ERR_MSG_WITH_GETN_EVENT_TAGNAME
			
			//----------------------------------------------------- end GLOBAL_EVENTS_ALSO_NEED_ERR_MSG_TAG_NAME 
			//----------- CPY 2/19/07 CUSTOM_APPLY_BUTTONS_CLEANUP
			/*
			///Joseph 02/14/07 SUPPORT_MORE_SPECAIL_EVENT
			//if(nEventID >= GETNE_ON_PREVIOUS && nEventID <= GETNE_ON_FINISH)
			if(IsSpecialEvent(nEventID))
			///End SUPPORT_MORE_SPECAIL_EVENT
				OnSpecialButtons(nEventID, strAux);
			//---------
			////end SEPRATE_INIT_AND_THEME_EVENT
			///Joseph 01/28/07 CHANGE_XF_APPLY_BUTTON_TEXT
			changeApplyButtonText(nEventID, strAux);
			///End CHANGE_XF_APPLY_BUTTON_TEXT
			
			///Joseph 01/29/07 GETN_BOX_ADD_APPLY_BUTTON
			OnCustomButtonCloseDialog(nEventID, nEventReturn);
			///End GETN_BOX_ADD_APPLY_BUTTON
			*/
			m_DynaCntrl.InvokeHandlers(GETNEVENT_ON_OC_SPECIFY);   /// AW 05/23/07 QA80-9821 v8.0622 SUPPORT_GETN_OC_EVENT 
			CheckCustomBottonEvents(nEventID, nEventReturn, strAux);
			
			/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
			///---Sim 02-28-2008 QA80-11156 XF_PANEL_APPLY_BUTTON
			//CheckApplyButtonEvent(trNode, nEventID, nEventReturn);
			CheckApplyButtonEvent(trNode, nEventID, nEventReturn, strAux);
			///---END QA80-11156 XF_PANEL_APPLY_BUTTON
			/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
			///---Sim 04-02-2007 CHANGE_APPLY_BUTTON_TEXT_ISSUE
			//checkChangeApplyButtonText(nEventID, strAux);
			///---END CHANGE_APPLY_BUTTON_TEXT_ISSUE
			//----------- end CUSTOM_APPLY_BUTTONS_CLEANUP
			///---Sim 05-16-2007 FIX_CLEAR_ERR_MSG_FOR_XF_BAR
			//getn_dlg_check_show_msg(pDlg->GetSafeHwnd(), strErrMsg); //CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
			///---END FIX_CLEAR_ERR_MSG_FOR_XF_BAR
			
			///Joseph 02/25/06 DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS
			////--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE, comment out it here, do it in OnMsgBox
			//OnEnableButtons(dwEnables);//CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS, put this back, after Iris 10/24/06 ADD_ERR_MESSAGE_LINE
			////---
			OnEnableButtons(dwEnables, nEventID);
			///End DO_NOT_ENABLE_BUTTON_ON_SOME_EVENTS
		}
		//------
	}

	///------ Folger 11/25/2010 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	#define			CURRENT_SELECTED_TAB_INDEX			"CurrentSelTab"
	BOOL			TabsLoadSettings(DWORD& nTab)
	{
		return m_tab && dlg_load_registry(GetDlgTitle(), CURRENT_SELECTED_TAB_INDEX, nTab);
	}

	BOOL			TabsSaveSettings()
	{
		return m_tab && dlg_save_to_registry(GetDlgTitle(), CURRENT_SELECTED_TAB_INDEX, m_tab.GetCurSel());
	}

	int				TabsOffset()
	{
		return m_nLeafCount > 0 ? 1 : 0;
	}

	int				TabsSize()
	{
		return m_vsTabBranches.GetSize() + TabsOffset();
	}

	TreeNode		TabsDisplayNodeParent(TreeNode& tr)
	{
		if ( m_strTabParent.IsEmpty() )
			tr.GetAttribute(STR_PARENT_OF_SUBNODE_DISPLAY_AS_TAB_ATTRIB, m_strTabParent);

		if ( !m_strTabParent.IsEmpty() )
			return tr.GetNodeFromPath(m_strTabParent);

		return tr;
	}

	int				TabsPrepareNode(int nTab)
	{
		TreeNode	tr = GetTree();
		TreeNode	trParent = TabsDisplayNodeParent(tr);
		
		BOOL		bShowLeafs = m_nLeafCount > 0 && 0 == nTab;
		TabsShowBranches(!bShowLeafs);
		if ( bShowLeafs )
		{
			tr.RemoveAttribute(STR_PARENT_OF_SUBNODE_DISPLAY_AS_TAB_ATTRIB);
			return (m_nCurrentTabDisplayIndex = (m_strTabParent.IsEmpty() ? -1 : 0));		/// for now
		}

		tr.SetAttribute(STR_PARENT_OF_SUBNODE_DISPLAY_AS_TAB_ATTRIB, m_strTabParent);
		string		strName = m_vsTabBranches[nTab - TabsOffset()];

		m_nCurrentTabDisplayIndex = 0;
		foreach ( TreeNode trNode in trParent.Children )
		{
			if ( trNode.tagName == strName )
				return m_nCurrentTabDisplayIndex;

			++m_nCurrentTabDisplayIndex;
		}

		O_A_FAIL;
		return (m_nCurrentTabDisplayIndex = -1);
	}

	void			TabsShowBranches(BOOL bOn)
	{
		TreeNode	trParent = TabsDisplayNodeParent(GetTree());
		for ( int ii=0; ii<m_vsTabBranches.GetSize(); ++ii )
		{
			TreeNode	trNode = trParent.GetNode(m_vsTabBranches[ii]);
			trNode.Show = bOn;
		}
	}

	int				TabsGetOptimalWidth()
	{
		if ( !m_tab )
			return 0;

		if ( 0 == m_nTabsOptimalWidth )
		{
			for ( int ii=0; ii<TabsSize(); ++ii )
			{
				/// Kenny 03/05/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
				//RECT	rr;
				//m_tab.GetItemRect(ii, &rr);
				//m_nTabsOptimalWidth += RECT_WIDTH(rr);
				int nTabFullWidth	= m_tab.GetTabFullWidth(ii);
				m_nTabsOptimalWidth	+= nTabFullWidth;
				/// End TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
			}
			/// Kenny 03/05/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
			int nTabBorderSize	= m_tab.GetTabBorderSize();
			m_nTabsOptimalWidth	+= nTabBorderSize * 2;
			/// End TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
		}
		return m_nTabsOptimalWidth;
	}

	/// Kenny 03/13/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
	//BOOL			CheckUpdateTabs()
	virtual BOOL			CheckUpdateTabs()
	/// End TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
	{
		if ( !m_tab )
			return FALSE;

		TreeNode	trParent = TabsDisplayNodeParent(GetTree());
		for ( int ii=0; ii<m_vsTabBranches.GetSize(); ++ii )
		{
			TreeNode	trNode = trParent.GetNode(m_vsTabBranches[ii]);
			string		strText;
			trNode.GetAttribute(STR_LABEL_ATTRIB, strText);
			m_tab.SetItemText(ii + TabsOffset(), strText);
		}
		resizeDlgToFit();
		return TRUE;
	}
	
	void		Init()
	{
		m_dwXFBits = 0;
		
		m_pEventFunc = NULL;
		m_pEventNew = NULL;
		
		m_dwExecute = LTXF_SHOW_DIALOG;
		m_nGetNType = -1; // -1 to indicate the call is from OK or Apply button
		
		m_bGroupTheme = false;

		m_nMaxAppearTimesOfErrMsg = -1;
		m_dwErrMsgBlinkCtrl = COLORTEXTBLINK_DEFAULT;

		m_nCurrentTabDisplayIndex = -1;
	}
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
		
protected:
	DynaControl		m_DynaCntrl;
	Tree			m_paramTree;
	/// TD 5-2-06 MOVE_TO_BASE_CLASS
	PEVENT_FUNC 	m_pEventFunc;
	///  end TD 5-2-06 MOVE_TO_BASE_CLASS
	
	PEVENT_GETN		m_pEventNew; //------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS

	
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	ComboBox	m_comboTheme;
	vector<string>	m_vsThemes;
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	
private:
	TreeNode		m_input_tr;
	bool			m_bGrayBackground;
	bool			m_b1ColIndent;	///	SY 2006-12-18 QA70-9217 v8.0528 EDITABLE_PART_ON_NEXT_LINE_FROM_LABEL
	bool			m_bUseInputTree;
	///---Sim 07-10-2007 DYNA_DLG_DERIVED_CLASS_NEED_XFBITS
	//DWORD			m_dwXFBits;//----- CPY 04-20-2007 QA70-9659 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT
	///---END DYNA_DLG_DERIVED_CLASS_NEED_XFBITS
	
	//---- CPY 5/20/06 THEME_COMBO_IN_BASE_CLASS
	// all dialog that make use of this common base class handling of theme should
	// use the same resource ID for all related controls to make it simpler
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	// move to protected for use it at DynaSplitter.h
	//ComboBox	m_comboTheme; 
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	Control		m_btnSaveTheme;
	
	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	//Edit 		m_editThemeDescription
	Button		m_editThemeDescription;	
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	
	int			m_nIDThemeDescription;
	int			m_nIDThemeDescriptionLabel;
	ResizeDialog* m_pDlg;
	vector<uint> m_vnThemeCntrlIDs;
	int 		m_nInitThemeGroupWidth;   ///Joseph 10/09/06	CHANGE_THEME_GROUP_SIZE	
protected:		
	bool		m_bAutoSaveBranchOpen; /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	string		m_strDescription;
	//------ CPY 5/21/08 QA70-11576 XF_DLG_ERR_MSG_SHOULD_HAVE_MORE_OBVIOUS_SHOWING
	//Button		m_btnErrMessage;	//--- Iris 10/24/06 ADD_ERR_MESSAGE_LINE
	ColorText		m_btnErrMessage;
	//------ end XF_DLG_ERR_MSG_SHOULD_HAVE_MORE_OBVIOUS_SHOWING
	
	//---- end CPY 5/20/06 THEME_COMBO_IN_BASE_CLASS
	
	///---Sim 07-10-2007 DYNA_DLG_DERIVED_CLASS_NEED_XFBITS
	DWORD			m_dwXFBits;//----- CPY 04-20-2007 QA70-9659 OPTION_TO_CLEAR_ERR_MSG_ON_EVENT
	///---END DYNA_DLG_DERIVED_CLASS_NEED_XFBITS
	
	///---Sim 02-29-2008 QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG
	Tree		m_trExecuteGetN;
	
	// for XF BeforeExecute Function when click OK or Apply Button
	DWORD		m_dwExecute;
	int			m_nGetNType;
	///---END QA80-11156 SUPPORT_EXEC_VALUE_ON_DYNA_DLG
	
	///---Sim 12-08-2008 FIX_RESET_DEFAULT_THEME_POPUP_ERR
	bool		m_bGroupTheme;
	///---END FIX_RESET_DEFAULT_THEME_POPUP_ERR

	///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	int			m_nMaxAppearTimesOfErrMsg;	// -1 means unlimited/off, 0 means do not blink err msg.
	DWORD		m_dwErrMsgBlinkCtrl;
	string		m_strContainerTitle;
	///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG

	///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	/// Kenny 03/05/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
	//TabControl	m_tab;
	TabCtrlEx		m_tab;
	/// End TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
	int				m_nLeafCount;
	vector<string>	m_vsTabBranches;
	string			m_strTabParent;
	int				m_nTabsOptimalWidth;
	int				m_nCurrentTabDisplayIndex;
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	
///Jasmine 05/22/08 EXPORT_ERRMSGBOX_SETTING_TO_DEVIRATED_CLASS
//------ CPY 5/21/08 QA70-11576 XF_DLG_ERR_MSG_SHOULD_HAVE_MORE_OBVIOUS_SHOWING
protected:
	///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	//bool CheckInitErrMsgBox(WndContainer& dlg, COLORREF crText, COLORREF crBlink, DWORD dwCtrl, bool bBold = true)
	///Sophy 8/23/2010 ORG-870-P1 NEW_DESIGN_FOR_BLINKING_ERR_MSG_ON_DYNDLG
	//bool CheckInitErrMsgBox(WndContainer& dlg, COLORREF crText, COLORREF crBlink, DWORD dwCtrl, bool bBold = true, int nMaxAppearTimesOfErrMsg = 10)
	bool CheckInitErrMsgBox(WndContainer& dlg, COLORREF crText, COLORREF crBlink, DWORD dwCtrl, bool bBold = true, int nMaxAppearTimesOfErrMsg = 30)
	///end NEW_DESIGN_FOR_BLINKING_ERR_MSG_ON_DYNDLG
	///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	{
		///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		m_nMaxAppearTimesOfErrMsg	= nMaxAppearTimesOfErrMsg;
		m_dwErrMsgBlinkCtrl			= dwCtrl;
		///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		Control cn;
#ifdef		_SPLITTER_CONTORL_H
		cn = dlg.GetDlgItem(IDC_ERR_MESSAGE_BOX);
#else		// !_SPLITTER_CONTORL_H
		cn = GetItem(IDC_ERR_MESSAGE_BOX);
#endif		// !_SPLITTER_CONTORL_H
		if(cn)
		{	
			///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
			//m_btnErrMessage.CreateControl(cn.GetSafeHwnd());
			if ( !m_btnErrMessage && !m_btnErrMessage.CreateControl(cn.GetSafeHwnd()))
			{
				ERR_MSG("Failed to create error message control!")
				return false;
			}
			///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
			if(COLORTEXTBLINK_OFF == dwCtrl)
				m_btnErrMessage.SetTxtColor(crText);
			else
			{
				///Sophy 8/23/2010 ORG-870-P1 NEW_DESIGN_FOR_BLINKING_ERR_MSG_ON_DYNDLG
				//when not blinking, should make sure the text color is what we set from crText, but not system default.
				m_btnErrMessage.SetTxtColor(crText);
				///end NEW_DESIGN_FOR_BLINKING_ERR_MSG_ON_DYNDLG
				m_btnErrMessage.SetTxtBlink(crText, crBlink);
				//m_btnErrMessage.BlinkText(dwCtrl);	///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
			}
			m_btnErrMessage.BlinkText(dwCtrl);	///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
			m_btnErrMessage.SetBold(bBold);
			//m_btnErrMessage.Text = "";		///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
			
			return true;
		}
		return false;
	}
//------ end XF_DLG_ERR_MSG_SHOULD_HAVE_MORE_OBVIOUS_SHOWING
///End EXPORT_ERRMSGBOX_SETTING_TO_DEVIRATED_CLASS

	///Kenny 04/08/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	void CountSetErrMsg(LPCSTR lpcszErrMsg)
	{
		if ( !m_btnErrMessage )
			return;

		const bool bIsSameAsLastErr = ( lpcszErrMsg && 0 == m_btnErrMessage.Text.CompareNoCase(lpcszErrMsg) );

		m_btnErrMessage.Text = lpcszErrMsg;

		if ( m_nMaxAppearTimesOfErrMsg < 0 || COLORTEXTBLINK_OFF == m_dwErrMsgBlinkCtrl || m_btnErrMessage.Text.IsEmpty() )
			return;

		// We need the container(dialog) title for accessing the registry key, so just return if we can't get a proper title.
		// If called by an instance of class DynaSplitter, m_strContainerTitle should had been assigned by SetContainerTitle(...)
		// in DynaSplitter::Init(...)
		if ( m_strContainerTitle.IsEmpty() )
		{
			// The title can be retrieved if the member function GetDlgTitle() is overrided.
			m_strContainerTitle = GetDlgTitle();
			if ( m_strContainerTitle.IsEmpty() )
			{
				// GetDlgTitle() is not overrided, so try getting the title from data member Text.
				if ( Text.IsEmpty() )
					return;
				m_strContainerTitle = Text;
			}
		}

		if ( bIsSameAsLastErr )	// no need to count the same err msg
			return;

		DWORD dwCurrentCount;
		dlg_load_registry(m_strContainerTitle, STR_ERR_MSG_SHOW_TIME, dwCurrentCount, 0);
		if ( dwCurrentCount >= m_nMaxAppearTimesOfErrMsg )
		{
			// Turn off blinking if current appear times is greater than the the max times.
			m_dwErrMsgBlinkCtrl = COLORTEXTBLINK_OFF;
			m_btnErrMessage.BlinkText(COLORTEXTBLINK_OFF);
		}
		else
		{
			dlg_save_to_registry(m_strContainerTitle, STR_ERR_MSG_SHOW_TIME, ++dwCurrentCount);
		}
	}
	///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
};

/// YuI 10/12/07 QA70-10529 DATA_MARKERS_REVAMP
//	#define ON_GETNDLG_MSGS(_ID) \
	ON_USER_MSG(WM_USER_EXTERNAL_MSG, OnExternalMessage)\
	ON_USER_MSG(WM_USER_BUTTON_STATUS, OnGetButtonStatus)\
	ON_USER_MSG(WM_USER_RECONSTRUCT, OnReconstructGrid) \
	ON_CHANGE_SELECTION(OnSelectionChange) 				\
	ON_SELECTION_TRACK(OnSelectionTrack)				\
	ON_DS_SELECTION_CHANGE(OnSelectionChange)			\
	ON_DS_SELECTION_TRACK(OnSelectionTrack)				\
	ON_DS_SELECTION_OK(OnDSSelectionOk)					\
	ON_DS_SELECTION_CANCEL(OnDSSelectionCancel)			\
	ON_CHANGE_LAYER(OnChangeLayer)						\
	ON_CHANGE_PAGE(OnChangePage)						\					
	//ON_CHANGE_DATASET(OnChangeDataset)
	
#define ON_GETNDLG_MSGS(_ID) \
	/*///------ Folger 03/08/10 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS*/ \
	ON_TAB_SEL_CHANGE(DYNA_TAB_ID, OnTabChange) \
	/*///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS*/ \
	ON_USER_MSG(WM_USER_EXTERNAL_MSG, OnExternalMessage)\
	ON_USER_MSG(WM_USER_BUTTON_STATUS, OnGetButtonStatus)\
	ON_USER_MSG(WM_USER_RECONSTRUCT, OnReconstructGrid) \
	ON_USER_MSG(WM_USER_AFTER_UPDATE_DYNACONTROL, OnAfterUpdateDynaControl) \
	ON_CHANGE_SELECTION(OnSelectionChange) 				\
	ON_SELECTION_TRACK(OnSelectionTrack)				\
	ON_DS_MARKER_CREATE(OnDSMarkerCreate)				\
	ON_DS_MARKER_DESTROY(OnDSMarkerDestroy)				\
	ON_DS_SELECTION_CHANGE_EX(OnDSSelectionChangeEx)	\
	ON_DS_SELECTION_TRACK_EX(OnDSSelectionTrackEx)		\
	ON_DS_SELECTION_OK_EX(OnDSSelectionOkEx)			\
	ON_DS_SELECTION_CANCEL_EX(OnDSSelectionCancelEx)	\
	ON_CHANGE_LAYER(OnChangeLayer)						\
	ON_CHANGE_PAGE(OnChangePage)						\					
	ON_CHANGE_DATASET(OnChangeDataset)					\
	/*///------ Folger 01/19/2012 ORG-4841-P1 FAILED_TO_SELECT_WORKSHEET_IF_ALREADY_ACTIVE_FROM_INTERATIVE_CONTROL*/ \
	ON_PAGE_NCLBUTTONDOWN(OnPageNCLButtonDown) \
	/*///------ End FAILED_TO_SELECT_WORKSHEET_IF_ALREADY_ACTIVE_FROM_INTERATIVE_CONTROL*/
/// end DATA_MARKERS_REVAMP
	
///Jasmine 10/26/06 KEEP_DLG_MODEL
/// TD 5-26-06 QA70-8428 EDITBOX_WITH_BUTTON
//BOOL	DynaDlg_OnGenericControlMsg(TreeNode &node, uint nCode);
///------ Folger 06/15/09 QA80-13771 GRAPH_BROWSER_SUPPORT_GENERAL_CUSTOMIZATION_BY_SPECIFIC_FILTER_FUNCTION
//BOOL	DynaDlg_OnGenericControlMsg(TreeNode &node, uint nCode, HWND hWndParent = NULL);
BOOL	DynaDlg_OnGenericControlMsg(TreeNode &node, uint nCode, HWND hWndParent = NULL, LPCSTR lpcsFilterFuncName = NULL);
///------ End GRAPH_BROWSER_SUPPORT_GENERAL_CUSTOMIZATION_BY_SPECIFIC_FILTER_FUNCTION
/// end EDITBOX_WITH_BUTTON

///------ Folger 11/18/09 QA81-14676 GETN_PREVIEW_DIALOG_NOT_RESIZE_WELL_FOR_HINT_TEXT
class	DynaCntrlGetOptimalSizeHelper
{
public:
	DynaCntrlGetOptimalSizeHelper(DynaControl& DynaCntrl)
	{
		m_pDynaCntrl = &DynaCntrl;
		UpdateTreeNodeRows();
	}

	void	GetOptimalSize(SIZE& sz)
	{
		SetEditorWrapped(FALSE);
		m_pDynaCntrl->GetOptimalSize(sz);
		SetEditorWrapped(TRUE);
	}
	
private:
	void	UpdateTreeNodeRows()
	{
		TreeNode	trNode;
		int			nRow = 0;
		int			nDataID = 0;
		while ( (trNode = m_pDynaCntrl->GetTreeNode(nRow)) && (trNode.DataID != nDataID) )
		{
			if ( 0 == nDataID )
				nDataID = trNode.DataID;
			
			int		nDisplayFormat = 0;
			if ( trNode.GetAttribute(STR_ATTRIB_DISPFMT, nDisplayFormat) )
			{
				if ( O_QUERY_BOOL(nDisplayFormat, DISPLAY_EDITOR_USE_LABEL) && O_QUERY_BOOL(nDisplayFormat, DISPLAY_EDITOR_WRAPPED) )
				{
					vnTreeNodeRows.Add(nRow);
				}
			}
			
			++nRow;
		}
	}

	void	SetEditorWrapped(BOOL bOn)
	{
		for ( int ii=0; ii<vnTreeNodeRows.GetSize(); ++ii )
		{
			TreeNode	trNode = m_pDynaCntrl->GetTreeNode(vnTreeNodeRows[ii]);
			if ( trNode )
			{
				int		nDisplayFormat = 0;
				if ( trNode.GetAttribute(STR_ATTRIB_DISPFMT, nDisplayFormat) )
				{
					O_SET_BIT(nDisplayFormat, DISPLAY_EDITOR_WRAPPED, bOn);
					trNode.SetAttribute(STR_ATTRIB_DISPFMT, nDisplayFormat);
				}
			}
		}
	}

private:
	DynaControl*	m_pDynaCntrl;
	vector<int>		vnTreeNodeRows;
};
///------ End GETN_PREVIEW_DIALOG_NOT_RESIZE_WELL_FOR_HINT_TEXT

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#endif	// _DYNA_DLG_H

 
