/*------------------------------------------------------------------------------*
 * File Name:	Digitizer	 													*
 * Creation: 	Folger 10/26/2010												*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2010, 2011, 2012,2013						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH				*
 *	Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID	*
 *	Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION	*
 *	Folger 01/06/2011 ORG-1512-S6 DIGITIZER_ADD_LINE_END_SYMBOL_TO_INDICATE_SELECTION
 *	Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH	*
 *	Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT				*
 *	Folger 02/22/2011 ORG-2309-P1 NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
 *	Folger 04/19/2011 ORG-2684-P1 DIGITIZER_RUNTIME_ERRO_AFTER_DELETE_AXIS_SCALE_VALUE
 *	Folger 08/03/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
 *	Folger 08/24/2011 ORG-3608-P1 DIGITZER_FAILED_TO_LOAD_AXIS_SCALE_TYPE_FROM_THEME
 *	Folger 08/31/2011 ORG-3667-S1 ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS			*
 *	Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG	*
 *	Folger 05/04/2012 ORG-5616-P1 DIGITIZER_BETTER_PAGE_LAYER_SIZE				*
 *	Tony 06/11/2012 ORG-5466-P1 ROTATION_ANGLE_WHEN_-360DEGREE					*
 *  Iris 7/16/2012 ORG-6230-P1 FIX_TYPE_WITHOUT_SELECTION_WILL_UPDATE_COLUMN_LABEL
 *  Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
 *  Iris 7/25/2012 ORG-6324-S1 TO_IMPROVE_AXIS_VALIE_EDITING					*
 *  Iris 7/25/2012 ORG-6305 CHANGE_OPTIONS_DLG_BUTTON_TO_OK_AND_CANCEL 			*
 *  Iris 7/25/2012 ORG-6310 SET_DATA_PLOT_WITH_DIFFERENT_COLOR					*
 *	Tony 08/20/2012 ORG-6511-P1 IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME	*
 *	Folger 08/28/2012 ORG-3412-P1 SHOW_ACUTAL_IMAGE_PIXELS_IN_DIGITIZER_PIXEL_LIST
 *	Tony 08/28/2012 ORG-6305-P1 ADD_UPDATEOPTIONSFROM_COLOR_TO_AVOID_SETTING_COLOR*
 *	Sophy 10/18/2012 ORG-7220-P1 IGNORE_CELL_FORMAT_IN_DIGITIZER_FOR_90SR0		*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <image_utils.h>

#include "DialogEx.h"
#include "grobj_utils.h"
#include "graph_utils.h"
#include "WksColLabels.h"

#define		STR_IMAGE_NAME			"Digitize"
#define		STR_IMAGE_BACKUP_NAME	STR_IMAGE_NAME "Backup"
#define		STR_OBJ_NAME_PREFIX		STR_IMAGE_NAME
#define		STR_CLIPBOARD_IMAGE_NAME	"ClipboardImage"		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
#define		STR_IMAGE_OBJ_DEFAULT_NAME		"BMP"
//#define		MULTIPLE_CURVES

struct	DigitizerCoordinates
{
	double		value;
	int			nx;
	int			ny;
	int			color;
};

struct DigitizerAxisData
{
	int					nScaleType;
	int					nColor;

	int					nFormat;
	int					nSubFormat;
	string				strCustomDisplay;
};

enum IMPLDATA
{
	IMPLDATA_INVALID	= -1,

	IMPLDATA_X1			= 0,
	IMPLDATA_X2,
	IMPLDATA_Y1,
	IMPLDATA_Y2,
	IMPLDATA_XREF,
	IMPLDATA_YREF,
	
	IMPLDATA_TOTAL,
};

enum
{
	IMPLDATACNTRL_AXIS_EDITING					= 0x00000001,
	IMPLDATACNTRL_X1_FROM_YAXIS					= 0x00000002,
	IMPLDATACNTRL_Y1_FROM_XAXIS					= 0x00000004,
	IMPLDATACNTRL_DLG_OPEN						= 0x00000008,
	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	IMPLDATACNTRL_ROTATION_MODE					= 0x00000010,
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	IMPLDATACNTRL_LABEL_EDITING					= 0x00000020,
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	IMPLDATACNTRL_AXIS_EDITING_BY_ROTATE		= 0x00000040,
	IMPLDATACNTRL_AXIS_EDITING_BY_LABEL_EDITING	= 0x00000080,
};

#define		MAKE_DIGITIZER_DATA_PLOT(_plot)		DigitizerObjsHolder	objs; DigitizerDataPlot	_plot(this, &objs)

#define		GENERIC_UPDATE_EVENT		-1
#define		STR_DEFAULT_DATA_NAME				"[DigiData]Result!PickedY1"
#define		STR_DIGITIZER_DATA_PLOT_NAME		"DigiPlot"

#define		ID_DIGITIZER_MSG_UPDATE_INFO					0x1000
#define		ID_DIGITIZER_MSG_UPDATE_INFO_SELECTION			0x1001
#define		ID_DIGITIZER_MSG_ENABLE_DIGITIZE				0x1002
#define		ID_DIGITIZER_MSG_SET_AXIS_COLOR					0x1003
#define		ID_DIGITIZER_MSG_UPDATE_FROM_POINTS				0x1004
///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
#define		ID_DIGITIZER_MSG_UPDATE_DYNACTRL				0x1005
///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
#define		ID_DIGITIZER_MSG_SAVE_SETTINGS					0x1006
#define		ID_DIGITIZER_MSG_CHECK_ENABLE_DIGITIZE			0x1007

struct	DigitizerImplData
{
public:
	DigitizerImplData()
	{
		Init();
	}

	void	Init(BOOL bKeppGeneralSettings = FALSE)
	{
		x1.value = y1.value = 1;
		x2.value = y2.value = 10;

		x1.nx = x1.ny =
		x2.nx = x2.ny =
		y1.nx = y1.ny =
		y2.nx = y2.ny = -1;

		ClearAllData();

		SetDataName(STR_DEFAULT_DATA_NAME);

		nDataColor = SYSCOLOR_RED;

		strImageName.Empty();
		nImageWidth = nImageHeight = 0;

		rAngleRotated = 0;

		///------ Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		SetLabelEditing(FALSE);
		///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		if ( !bKeppGeneralSettings )
		{
			axisX.nScaleType = axisY.nScaleType = LINEAR_SPACE;
			axisX.nColor = SYSCOLOR_DKGRAY;
			axisY.nColor = SYSCOLOR_NAVY;

			axisX.nFormat = axisY.nFormat = OKCOLTYPE_NUMERIC;
			axisX.nSubFormat = axisY.nSubFormat = 0;

			x1.color = y1.color = SYSCOLOR_BLUE;
			x2.color = y2.color = SYSCOLOR_RED;

			rAngleInc = 0.5;

			dwCntrls = 0;
			SetAxisEditing(TRUE);
			SetX1FromYAxis(TRUE);
			SetY1FromXAxis(TRUE);
		}
	}

	BOOL	Size()
	{
		return PtsScrX.GetSize();
	}
	
	int		GetPointHalfSize()
	{
		///------ Folger 08/10/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
		//return 13;
		return max(nImageWidth, nImageHeight) / 150;
		///------ End DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
	}

	BOOL	IsReady()
	{
		return IsXReady() && IsYReady();
	}

	BOOL	IsXReady()
	{
		return IsCoornianteReady(x1) && IsCoornianteReady(x2);
	}

	BOOL	IsYReady()
	{
		return IsCoornianteReady(y1) && IsCoornianteReady(y2);
	}

	BOOL	IsCoornianteReady(DigitizerCoordinates& coor)
	{
		return !is_missing_value(coor.value) && -1 != coor.nx && -1 != coor.ny;
	}

	string	MakeObjName(LPCSTR lpcsz)
	{
		string		strName;
		strName.Format("%s%s", STR_OBJ_NAME_PREFIX, lpcsz);
		return strName;
	}

	BOOL	UpdateDataNameByImageFileName(LPCSTR lpcszFile)
	{
		string	strBook, strSheet, strCol;
		if ( !okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol) )
			return FALSE;
		
		strImageFile = lpcszFile;			///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		
		strImageName = GetFileName(lpcszFile);
		///------ Tony 08/20/2012 ORG-6511-P1 IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME
		for(int ii = 0; ii < MAXLINE; ii++)
		{
			bool bFlag = true;
			string strImageNewName;
			string strNameEnd;
			if(ii != 0)
			{
				strNameEnd.Format("-%d", ii);
				strImageNewName = strImageName + strNameEnd;
			}
			else
			{
				strImageNewName = strImageName;
			}
			foreach(GraphPage gp in Project.GraphPages)
			{
				
				string strName;
				strName = gp.GetLongName();
				if(!strImageNewName.CompareNoCase(strName))
				{
					bFlag = false;
					break;
				}
			}
			if(bFlag)
			{
				strImageName = strImageNewName;
				break;
			}
		}
		///------ End IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME
		string		strDataName;
		///------ Tony 08/20/2012 ORG-6511-P1 IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME
		//okutil_create_complete_range_string_obj(&strDataName, strBook, GetFileName(strImageName, TRUE), strCol);
		okutil_create_complete_range_string_obj(&strDataName, strBook, strImageName, strCol);
		///------ End IMPORT_SAME_NAME_GRAPH_USING_DIFFERENT_NAME
		SetDataName(strDataName);
		return TRUE;
	}

	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	UpdateDataNameForClipboardImage()
	{
		string	strBook, strSheet, strCol;
		if ( !okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol) )
			return FALSE;
		strImageName = STR_CLIPBOARD_IMAGE_NAME;
		char snBuffer[MAXLINE];
		int  nn = 0;
		// to name the Clipboard Image
		while(0 == nn)
		{
			nn = string_to_prefix_end_number( snBuffer, strImageName );
			strImageName.Format("%s%d",snBuffer,++nn);
			nn = 1;
			foreach(GraphPage gp in Project.GraphPages)
			{
				string strLN = gp.GetLongName();
				// to check if name is existed in current gp
				if( strImageName == strLN )
				{
					nn = 0;
					break;
				}
			}
		}

		string		strDataName;
		okutil_create_complete_range_string_obj(&strDataName, strBook, strImageName, strCol);
		SetDataName(strDataName);
		return TRUE;
	}
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	
	//Tony 8/29/2012 In case too long image name
	BOOL	UpdateDataNameByNewSheetName(string &strNewSheetName)
	{
		string	strBook, strSheet, strCol;
		if ( !okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol) )
			return FALSE;

		string strNewDataName;
		okutil_create_complete_range_string_obj(strNewDataName, strBook, strNewSheetName, strCol);
		SetDataName(strNewDataName);
		return TRUE;
	}
	//END
	
	BOOL	UpdateDataName(string& strName)
	{
		string	strBook, strSheet, strCol;
		if ( okutil_parse_complete_range_string(strName, &strBook, &strSheet, &strCol) && !strBook.IsEmpty() && !strSheet.IsEmpty() && !strCol.IsEmpty() )
			return TRUE;
		
		if ( !strBook.IsEmpty() && strSheet.IsEmpty() && strCol.IsEmpty() )
		{
			strCol = strBook;
			strBook.Empty();
		}
		
		string	strBook2, strSheet2, strCol2;
		okutil_parse_complete_range_string(GetDataName(), &strBook2, &strSheet2, &strCol2);
		if ( strBook.IsEmpty() )
			strBook = strBook2;		
		if ( strSheet.IsEmpty() )
			strSheet = strSheet2;
		
		okutil_create_complete_range_string_obj(strName, strBook, strSheet, strCol);
		return TRUE;
	}

	#define		STR_NUM_FORMAT			"*"
	string		GetValue(DigitizerCoordinates& coor, DigitizerAxisData* pAxisData = NULL)
	{
		return GetValue(coor.value, pAxisData);
	}

	string		GetValue(double rValue, DigitizerAxisData* pAxisData = NULL)
	{
		if ( NULL == pAxisData || OKCOLTYPE_NUMERIC == pAxisData->nFormat )
			return ftoa(rValue, STR_NUM_FORMAT);

		JulianDateTimeConverter			convert;
		string							str = ftoa(rValue);
		convert.DateTimeToStr(str, DataTimeStr(pAxisData), pAxisData->strCustomDisplay);
		return str;
	}

	double		GetValue(LPCSTR lpcsz, DigitizerAxisData* pAxisData = NULL)
	{
		if ( NULL == pAxisData || OKCOLTYPE_NUMERIC == pAxisData->nFormat )
			return atof(lpcsz);

		JulianDateTimeConverter			convert;
		string							str = lpcsz;
		convert.StrToDateTime(str, DataTimeStr(pAxisData), pAxisData->strCustomDisplay);
		return atof(str);
	}

	BOOL	UpdateX1X2FromY1()
	{
		//if ( IsY1FromXAxis() )
		//{
			//x1.ny = x2.ny = y1.ny;
		//}
		return TRUE;
	}
	
	BOOL	UpdateY1Y2FromX1()
	{
		//if ( IsX1FromYAxis() )
		//{
			//y1.nx = y2.nx = x1.nx;
		//}
		return TRUE;
	}

	DWORD	ConvertTabIndex(UINT nTabIndex)
	{
		return nTabIndex << 24;
	}

	#define		ID_DATA_XSCALE_TYPE		0x0001
	#define		ID_DATA_YSCALE_TYPE		0x0002

	#define		ID_DATA_X1_VALUE		0x0003
	#define		ID_DATA_X1_COLOR		0x0004
	#define		ID_DATA_X1_NX			0x0005
	#define		ID_DATA_X1_NY			0x0006
	#define		ID_DATA_X2_VALUE		0x0007
	#define		ID_DATA_X2_COLOR		0x0008
	#define		ID_DATA_X2_NX			0x0009
	#define		ID_DATA_X2_NY			0x000a
	#define		ID_DATA_Y1_VALUE		0x000b
	#define		ID_DATA_Y1_COLOR		0x000c
	#define		ID_DATA_Y1_NX			0x000d
	#define		ID_DATA_Y1_NY			0x000e
	#define		ID_DATA_Y2_VALUE		0x000f
	#define		ID_DATA_Y2_COLOR		0x0010
	#define		ID_DATA_Y2_NX			0x0011
	#define		ID_DATA_Y2_NY			0x0012

	#define		ID_DATA_XAXIS_COLOR		0x0013
	#define		ID_DATA_YAXIS_COLOR		0x0014

	#define		ID_DATA_ANGLE_ROTATED	0x0015
	#define		ID_DATA_ANGLE_INC		0x0016

	void	PrepareAxesTreeIDs(TreeNode& tr)
	{
		///------ Folger 08/24/2011 ORG-3608-P1 DIGITZER_FAILED_TO_LOAD_AXIS_SCALE_TYPE_FROM_THEME
		//tr.nXScaleType.DataID = ID_DATA_XSCALE_TYPE;
		//tr.nYScaleType.DataID = ID_DATA_YSCALE_TYPE;
		//tr.nXAxisColor.DataID = ID_DATA_XAXIS_COLOR;
		//tr.nYAxisColor.DataID = ID_DATA_YAXIS_COLOR;
		tr.axisX.nScaleType.DataID = ID_DATA_XSCALE_TYPE;
		tr.axisY.nScaleType.DataID = ID_DATA_YSCALE_TYPE;
		tr.axisX.nColor.DataID = ID_DATA_XAXIS_COLOR;
		tr.axisY.nColor.DataID = ID_DATA_YAXIS_COLOR;
		///------ End DIGITZER_FAILED_TO_LOAD_AXIS_SCALE_TYPE_FROM_THEME

		tr.x1.value.DataID = ID_DATA_X1_VALUE;
		tr.x1.color.DataID = ID_DATA_X1_COLOR;
		tr.x1.nx.DataID = ID_DATA_X1_NX;
		tr.x1.ny.DataID = ID_DATA_X1_NY;

		tr.x2.value.DataID = ID_DATA_X2_VALUE;
		tr.x2.color.DataID = ID_DATA_X2_COLOR;
		tr.x2.nx.DataID = ID_DATA_X2_NX;
		tr.x2.ny.DataID = ID_DATA_X2_NY;

		tr.y1.value.DataID = ID_DATA_Y1_VALUE;
		tr.y1.color.DataID = ID_DATA_Y1_COLOR;
		tr.y1.nx.DataID = ID_DATA_Y1_NX;
		tr.y1.ny.DataID = ID_DATA_Y1_NY;
		
		tr.y2.value.DataID = ID_DATA_Y2_VALUE;
		tr.y2.color.DataID = ID_DATA_Y2_COLOR;
		tr.y2.nx.DataID = ID_DATA_Y2_NX;
		tr.y2.ny.DataID = ID_DATA_Y2_NY;

		tr.rAngleRotated.DataID = ID_DATA_ANGLE_ROTATED;
		tr.rAngleInc.DataID = ID_DATA_ANGLE_INC;
	}
	
	DigitizerAxisData	axisX;
	DigitizerAxisData	axisY;

	DigitizerCoordinates	x1;
	DigitizerCoordinates	x2;
	DigitizerCoordinates	y1;
	DigitizerCoordinates	y2;

	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	bool				bDigitizing;
	bool 				OptimizePoint;	
	int					OptimizeError;
	
	string				strMatrixObj;
	string				strImageFile;			
	///End OPTIMIZE_PICKED_POINT
	string				strImageName;
	int					nImageWidth, nImageHeight;

	double				rAngleRotated;
	double				rAngleInc;

	vector				PtsScrX;
	vector				PtsScrY;
	vector				PtsX;
	vector				PtsY;
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	vector<string>		PtsLabel;
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	
private:
	vector<string>		vsDataPlots;
	vector<string>		vsDataNames;
	vector<OUID>		vsDataUIDs;

	int			nActiveData;
	int			nDataColor;

public:
	BOOL	NewData()
	{
		MAKE_DIGITIZER_DATA_PLOT(plot);
		#ifdef		MULTIPLE_CURVES
		plot.Show(FALSE);
		ClearData();
		
		int		nLast = GetNumData() - 1;
		string	strPlotName = vsDataPlots[nLast];
		string	strDataName = vsDataNames[nLast];
		
		vsDataPlots.Add(EnumName(strPlotName));
		vsDataNames.Add(EnumName(strDataName));
		vsDataUIDs.Add(0);
		nActiveData = nLast + 1;
		#else		/// MULTIPLE_CURVES
		SetDataName(EnumName(vsDataNames[nActiveData]));
		vsDataUIDs[nActiveData] = 0;
		plot.Clear();
		#endif		/// MULTIPLE_CURVES
		return TRUE;
	}
	
	void	ClearData()
	{
		PtsScrX.RemoveAll();
		PtsScrY.RemoveAll();
		PtsX.RemoveAll();
		PtsY.RemoveAll();
		///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		PtsLabel.RemoveAll();
		///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	}
	
	void	ClearAllData()
	{
		ClearData();
		
		MAKE_DIGITIZER_DATA_PLOT(plot);
		int					nData = GetNumData();
		for ( nActiveData=0; nActiveData<nData; ++nActiveData )
		{
			plot.Clear(TRUE);
		}
		
		vsDataPlots.SetSize(1);
		vsDataPlots[0] = STR_DIGITIZER_DATA_PLOT_NAME;
		vsDataNames.SetSize(1);
		vsDataUIDs.SetSize(1);
		nActiveData = 0;
	}
	
	void	PrepareDataForCalculate(BOOL bFromScreenToData = TRUE)
	{
		if ( bFromScreenToData )
		{
			PtsX = PtsScrX;
			PtsY = PtsScrY;
		}
		else
		{
			PtsScrX = PtsX;
			PtsScrY = PtsY;
		}
	}
	
	BOOL	AddOneScreenPoint(double x, double y)
	{
		PtsScrX.Add(x);
		PtsScrY.Add(y);
		///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		PtsLabel.Add("");
		///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		return TRUE;
	}
	
	int			GetActiveData()
	{
		return nActiveData;
	}

	BOOL		SetActiveData(int nData)
	{
		Selection.Reset();
		MAKE_DIGITIZER_DATA_PLOT(plot);
		plot.Show(FALSE);

		nActiveData = nData;
		return plot.Show(TRUE) && plot.Update(GENERIC_UPDATE_EVENT);
	}

	int			GetNumData()
	{
		return vsDataPlots.GetSize();
	}

	BOOL		RemoveActiveData()
	{
		if ( vsDataPlots.GetSize() == 1 )
		{
			ClearData();
			return FALSE;
		}

		vsDataPlots.RemoveAt(nActiveData);
		vsDataNames.RemoveAt(nActiveData);
		vsDataUIDs.RemoveAt(nActiveData);
		return TRUE;
	}
	
	string					GetPlotName()
	{
		return vsDataPlots[nActiveData];
	}
		
	string					GetDataName()
	{
		return vsDataNames[nActiveData];
	}
	void					SetDataName(LPCSTR lpcsz)
	{
		vsDataNames[nActiveData] = lpcsz;
	}
	void					SetDataName(LPCSTR lpcszBookSheet, LPCSTR lpcszCol)
	{
		vsDataNames[nActiveData].Format("%s%c%s", lpcszBookSheet, AREA_SHEETNAME_NAME_END_CHAR, lpcszCol);
	}

	OUID					GetDataUID()
	{
		return vsDataUIDs[nActiveData];
	}
	void					SetDataUID(OUID uid)
	{
		vsDataUIDs[nActiveData] = uid;
	}

	int						GetPlotColor()
	{
		MAKE_DIGITIZER_DATA_PLOT(plot);
		Tree	tr;
		plot.GetFormat(tr, FPB_STYLE_COLOR);
		
		TreeNode	trEdgeColor = tr.Root.Symbol.EdgeColor;
		if ( trEdgeColor )
			nDataColor = trEdgeColor.nVal;
		return nDataColor;
	}

	BOOL					SetPlotColor(int nColor)
	{
		if ( nColor >= 0 )
			nDataColor = nColor;

		Tree	tr;
		tr.Root.Color.nVal = tr.Root.Symbol.EdgeColor.nVal = nDataColor;
		tr.Root.Symbol.Shape.nVal = 1;
		
		MAKE_DIGITIZER_DATA_PLOT(plot);
		return plot.ApplyFormat(tr);
	}

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL					GetPlotData(TreeNode& tr)
	{
		tr.Root.Data.X.dVals = PtsScrX;
		tr.Root.Data.Y.dVals = PtsScrY;

		tr.Root.Label.Data.strVals = PtsLabel;
		tr.Root.Label.Cntrl.nVal = (IsLabelEditing() ? MLC_SHOW : MLC_TOOLTIP) | MLC_ALT_NONEMPTY;
		tr.Root.Label.Color.nVal = SYSCOLOR_BLUE;
		tr.Root.Label.Alt.Color.nVal = SYSCOLOR_GREEN;
		tr.Root.Label.Font.Size.nVal = 10;

		return TRUE;
	}

	BOOL					SetPlotData(TreeNode& tr)
	{
		PtsScrX = tr.Root.Data.X.dVals;
		PtsScrY = tr.Root.Data.Y.dVals;

		TreeNode	trLabel = tr.Root.Label.Data;
		if ( trLabel )
			PtsLabel = trLabel.strVals;
		else
			PtsLabel.SetSize(Size());

		return TRUE;
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

public:
	BOOL	IsAxisEditing()
	{
		return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_AXIS_EDITING);
	}
	void	SetAxisEditing(BOOL bOn)
	{
		O_SET_BIT(dwCntrls, IMPLDATACNTRL_AXIS_EDITING, bOn);
	}

	BOOL	IsX1FromYAxis()
	{
		return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_X1_FROM_YAXIS);
	}
	void	SetX1FromYAxis(BOOL bOn)
	{
		O_SET_BIT(dwCntrls, IMPLDATACNTRL_X1_FROM_YAXIS, bOn);
	}

	BOOL	IsY1FromXAxis()
	{
		return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_Y1_FROM_XAXIS);
	}
	void	SetY1FromXAxis(BOOL bOn)
	{
		O_SET_BIT(dwCntrls, IMPLDATACNTRL_Y1_FROM_XAXIS, bOn);
	}

	BOOL	IsDlgOpen()
	{
		return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_DLG_OPEN);
	}
	void	SetDlgOpen(BOOL bOn)
	{
		O_SET_BIT(dwCntrls, IMPLDATACNTRL_DLG_OPEN, bOn);
	}

	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	BOOL	IsRotationMode()
	{
		return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_ROTATION_MODE);
	}
	void	SetRotationMode(BOOL bOn)
	{
		O_SET_BIT(dwCntrls, IMPLDATACNTRL_ROTATION_MODE, bOn);
	}
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	IsLabelEditing()
	{
		return O_QUERY_BOOL(dwCntrls, IMPLDATACNTRL_LABEL_EDITING);
	}
	void	SetLabelEditing(BOOL bOn)
	{
		O_SET_BIT(dwCntrls, IMPLDATACNTRL_LABEL_EDITING, bOn);
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	BOOL	IsAxisEditingByOther(DWORD dwBit)
	{
		return O_QUERY_BOOL(dwCntrls, dwBit);
	}
	void	SetAxisEditingByOther(DWORD dwBit, BOOL bOn)
	{
		O_SET_BIT(dwCntrls, dwBit, bOn);
	}

private:
	DWORD					dwCntrls;

private:
	string	EnumName(LPCSTR lpcszName)
	{
		char	szBuffer[MAXLINE];
		string	strDataName	= lpcszName;
		int		nn = string_to_prefix_end_number(szBuffer, strDataName);
		if ( nn == 0 )
		{
			strDataName += "1";
		}
		else
		{
			strDataName.Format("%s%d", szBuffer, nn + 1);
			
		}
		return strDataName;
	}

	string	DataTimeStr(DigitizerAxisData* pAxisData)
	{
		if ( OKCOLTYPE_NUMERIC == pAxisData->nFormat )
			return "";

		CurrentDateTimeDisplayHelper	dtHelper;
		string	strFormat;
		dtHelper.MakeStringByFormat(strFormat, pAxisData->nFormat, pAxisData->nSubFormat);
		return strFormat;
	}
};

#define		DISABLE_LT_UNDO		LTVarTempChange		undoLT("@UL,", 0)

class DigitizerObjsHolder
{
public:
	GraphPage	GetDigitizePage()
	{
		return Project.Pages();
	}
	
	GraphLayer	GetDigitizeLayer()
	{
		if ( m_gl )
			return m_gl;

		return Project.ActiveLayer();
	}

	void		SetDigitizeLayer(GraphLayer& gl)
	{
		m_gl = gl;
	}
	
	GraphObject	GetDigitizeImage()
	{
		return GetDigitizeLayer().GraphObjects(STR_IMAGE_NAME);
	}

	GraphObject	GetDigitizeImageBackup()
	{
		return GetDigitizeLayer().GraphObjects(STR_IMAGE_BACKUP_NAME);
	}

	BOOL		Refresh()
	{
		GetDigitizePage().Refresh();
		return TRUE;
	}

	BOOL		SetupUndoEvent(GraphObject& go)
	{
		return go && SetObjProperty(go.GetName(), "UndoEvent", 1);
	}
	
	BOOL		SetupDeleteUndoable(GraphObject& go, BOOL bUndo)
	{
		return go && SetObjProperty(go.GetName(), "DelUndoable", bUndo);
	}

	BOOL		SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal, BOOL bDelay = FALSE)
	{
		DISABLE_LT_UNDO;
		string	strScript;
		strScript.Format("%s%s.%s=%g;", bDelay ? ";" : "", lpcszName, lpcszProp, rVal);
		return LT_execute(strScript);
	}

	BOOL		GetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double& rValue)
	{
		string	strScript;
		strScript.Format("%s.%s", lpcszName, lpcszProp);
		return LT_get_var(strScript, &rValue);
	}
	
	#define		STR_PAGE_NAME		STR_IMAGE_NAME "1"
	GraphPage	PrepareDigitizePage()
	{
		GraphPage	gp;
		string		strTempl = Template();
		gp.Create(strTempl);
		gp.SetName(STR_PAGE_NAME, OCD_ENUM_NEXT);
		LT_set_var("page.noClick", NOCLICK_DATA_PLOT | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON | NOCLICK_AXES);
		return gp;
	}
	
	BOOL	IsPageValidToDigitize(GraphPage& gp)
	{
		return GetFileName(page_get_template_name(gp)).CompareNoCase(Template()) == 0;
	}

	BOOL	SetObjText(LPCSTR lpcszName, LPCSTR lpcszText)
	{
		GraphObject		go = GetDigitizeLayer().GraphObjects(lpcszName);
		if ( !go )
			return FALSE;

		go.Text = lpcszText;
		return TRUE;
	}
	
private:
	string		Template()
	{
		return "Digitizer.otp";
	}

private:
	GraphLayer		m_gl;
};

class DigitizerLayerTempChange
{
public:
	DigitizerLayerTempChange(DigitizerObjsHolder* pObjsHolder, GraphLayer& gl)
	{
		m_pObjsHolder = pObjsHolder;
		m_pObjsHolder->SetDigitizeLayer(gl);
	}
	~DigitizerLayerTempChange()
	{
		GraphLayer	glJunk;
		m_pObjsHolder->SetDigitizeLayer(glJunk);
	}

private:
	DigitizerObjsHolder*	m_pObjsHolder;
};

enum
{
	OBJUPDATE_NONE				= 0,
	OBJUPDATE_RECREATE,
	OBJUPDATE_EXISTING,
};

static	BOOL	g_bDuringUpdate = FALSE;
class ObjsUpdateEventHelper
{
public:
	ObjsUpdateEventHelper()
	{
		m_bOldVal = g_bDuringUpdate;
		if ( !g_bDuringUpdate )
			g_bDuringUpdate = TRUE;
	}
	~ObjsUpdateEventHelper()
	{
		g_bDuringUpdate = m_bOldVal;
	}

	BOOL	IsDuringUpdate()
	{
		return m_bOldVal;
	}

private:
	BOOL	m_bOldVal;
};

#define			OBJ_INTERNAL_LABTALK_SCRIPT		"run.section(graph_controls.ogs, Digitizer, %1 this.name$);"
///Jasmine 03/11/11 ORG-2286 KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
//#define			OBJ_MAIN_LABTALK_SCRIPT			"run.section(graph_controls.ogs, DigitizerMain);"
#define			OBJ_MAIN_LABTALK_SCRIPT			"run.section(graph_controls.ogs, DigitizerMain, %1 this.attach$);"
///End KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
#define			OBJ_COMMON_STATE				GOC_NO_RESIZE | GOC_NO_ROTATE | GOC_NO_SKEW | GOC_NO_EDIT

enum
{
	UPDATEFROMEVENTS_NOT_HANDLE = -1,
	UPDATEFROMEVENTS_NONE		= 0,
	UPDATEFROMEVENTS_PLOT,
	UPDATEFROMEVENTS_AXIS,
};

class DigitizerDataPlot
{
public:
	DigitizerDataPlot(DigitizerImplData* pData, DigitizerObjsHolder* pObjsHolder)
	{
		m_pData = pData;
		m_pObjsHolder = pObjsHolder;
	}
	~DigitizerDataPlot()
	{
	}

	BOOL	NewData()
	{
		return m_pData->NewData();
	}

	BOOL	Clear(BOOL bGrOnly = FALSE)
	{
		GraphObject		plot = Plot();
		if ( !bGrOnly )
			m_pData->ClearData();
		if ( plot )
			plot.Destroy();
		return TRUE;
	}

	BOOL	Update(int nUpdate, BOOL bRefresh)
	{
		ERR_MSG("DigitizerDataPlot::Update");
		Plot(nUpdate);
		
		if ( bRefresh )
			Refresh();
		return TRUE;
	}

	BOOL	Show(BOOL bShow)
	{
		GraphObject		plot = Plot();
		if ( !plot )
			return FALSE;

		plot.Show = bShow;
		return UpdateStates();
	}

	BOOL	AddOnePoint(double x,  double y)
	{
		return m_pData->AddOneScreenPoint(x, y) && Update(OBJUPDATE_EXISTING, FALSE);
	}
	
	BOOL	HasDataPoint()
	{
		return m_pData->Size() > 0;
	}

	BOOL	UpdateStates()
	{
		GraphObject		plot = Plot();
		if ( plot )
		{
			update_go_states(plot, GetUpdateStates(), -1);
		}
		return TRUE;
	}

	int		UpdateFromEvents(int nEvent, LPCSTR lpcszName)
	{
		if ( !IsPlot(lpcszName) )
			return UPDATEFROMEVENTS_NOT_HANDLE;

		return IsLabelEditing() && OE_DELETE_PART != nEvent ? UPDATEFROMEVENTS_NONE : UPDATEFROMEVENTS_PLOT;
	}
	
	BOOL	Update(int nEvent)
	{
		///------ Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		if ( IsLabelEditing() && OE_DELETE_PART == nEvent )
		{
			int		nIndex = Selection.GetHandle() - 1;
			if ( nIndex >= 0 )
			{
				m_pData->PtsLabel[nIndex].Empty();					
				return UpdateData();
			}
			return TRUE;
		}
		///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

		GraphObject		plot = Plot();
		if ( !plot )
		{
			if ( GENERIC_UPDATE_EVENT == nEvent )
				return TRUE;

			if ( !m_pData->RemoveActiveData() )
				return TRUE;

			return Show(TRUE) && Update(GENERIC_UPDATE_EVENT);
		}

		Tree			tr;
		GetFormat(tr, FPB_DATA);
		return m_pData->SetPlotData(tr);
	}

	BOOL	GetFormat(TreeNode& tr, DWORD dwPropertiesFilter)
	{
		GraphObject		plot = Plot();
		if ( !plot )
			return FALSE;
		tr = plot.GetFormat(dwPropertiesFilter, FOB_ALL, true, true);
		return TRUE;
	}

	BOOL	ApplyFormat(TreeNode& tr)
	{
		GraphObject		plot = Plot();
		return plot && 0 == plot.UpdateThemeIDs(tr.Root) && plot.ApplyFormat(tr, TRUE, TRUE);
	}

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	Edit(int nIndex)
	{
		if ( !IsLabelEditing() )
			return FALSE;
		
		vector<string>&		vs =  m_pData->PtsLabel;
		if ( nIndex >= vs.GetSize() )
			return FALSE;
		
		GETN_TREE(tr)
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		GETN_STR(Label, "", vs[nIndex])
		
		if ( GetNBox(tr, _L("Set Label"), NULL, NULL, NULL, m_pObjsHolder->GetDigitizePage().GetWindow().GetSafeHwnd()) )
		{
			vs[nIndex] = tr.Label.strVal;
			UpdateData();
		}
		return Refresh();
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 01/12/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL		UpdateData()
	{
		Tree tr;
		m_pData->GetPlotData(tr);
		return ApplyFormat(tr);
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

private:
	GraphLayer	GetDigitizeLayer()
	{
		return m_pObjsHolder->GetDigitizeLayer();
	}

	BOOL		Refresh()
	{
		return m_pObjsHolder->Refresh();
	}

	GraphObject	Plot(int nUpdate = OBJUPDATE_NONE)
	{
		string			strName = m_pData->GetPlotName();
		GraphLayer		gl = GetDigitizeLayer();
		GraphObject		plot = gl.GraphObjects(strName);
		if ( OBJUPDATE_NONE != nUpdate )
		{
			if ( !plot )
			{
				plot = gl.CreateGraphObject(GROBJ_TN_MARKER, strName);
				plot.Attach = ATTACH_TO_SCALE;
				set_LT_script(plot, OBJ_INTERNAL_LABTALK_SCRIPT, GRCT_ANY_EVENT, 1);
				m_pObjsHolder->SetupUndoEvent(plot);
				m_pObjsHolder->SetupDeleteUndoable(plot, FALSE);
			}

			update_go_states(plot, GetUpdateStates(), -1);
			m_pData->SetPlotColor(-1);
			
			if ( m_pData->Size() > 0 )
			{
				UpdateData();
			}
			else
			{
				plot.Destroy();
			}
		}

		return plot;
	}

	BOOL		IsAxesEditing()
	{
		return m_pData->IsAxisEditing();
	}

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL		IsLabelEditing()
	{
		return m_pData->IsLabelEditing();
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	DWORD		GetUpdateStates()
	{
		return m_pData->IsDlgOpen() && !IsAxesEditing() ? (IsLabelEditing() ? GOC_LABEL_EDITING : GOC_REV_USER_DEL) : GOC_NO_SELECT;
	}

	BOOL		IsPlot(LPCSTR lpcszName)
	{
		GraphObject		plot = Plot();
		if ( !plot )
			return FALSE;

		return plot.GetName().Compare(lpcszName) == 0;
	}
	
private:
	DigitizerImplData*		m_pData;
	DigitizerObjsHolder*	m_pObjsHolder;
};

#define			STR_AXIS_XFROM		"X1"
#define			STR_AXIS_XTO		"X2"
#define			STR_AXIS_YFROM		"Y1"
#define			STR_AXIS_YTO		"Y2"

class DigitizerAxes
{
public:
	DigitizerAxes(DigitizerImplData* pData, DigitizerObjsHolder* pObjsHolder)
	{
		m_pData = pData;
		m_pObjsHolder = pObjsHolder;
	}
	~DigitizerAxes()
	{
	}

	BOOL	Update(int nUpdate, LPCSTR lpcszName = NULL, BOOL bRefresh = FALSE)
	{
		ERR_MSG("DigitizerAxes::Update");
		X(nUpdate), Y(nUpdate);
		XFrom(nUpdate, lpcszName), XTo(nUpdate, lpcszName), YFrom(nUpdate, lpcszName), YTo(nUpdate, lpcszName);

		if ( bRefresh )
			Refresh();
		return TRUE;
	}

	int		UpdateFromEvents(int nEvent, LPCSTR lpcszName)
	{
		if ( IsAxis(lpcszName) && UpdateFromAxis(nEvent, lpcszName) || UpdateFromAxesEnd(nEvent, lpcszName) )
			return UPDATEFROMEVENTS_AXIS;

		return UPDATEFROMEVENTS_NOT_HANDLE;
	}

	BOOL	SetPixel(IMPLDATA type, int nValue)
	{
		switch ( type )
		{
		case IMPLDATA_X1:
			m_pData->x1.nx = nValue;
			break;
			
		case IMPLDATA_X2:
			m_pData->x2.nx = nValue;
			break;
			
		case IMPLDATA_Y1:
			m_pData->y1.ny = nValue;
			break;
			
		case IMPLDATA_Y2:
			m_pData->y2.ny = nValue;
			break;
			
		case IMPLDATA_XREF:
			m_pData->y1.nx = m_pData->y2.nx = nValue;
			break;
			
		case IMPLDATA_YREF:
			m_pData->x1.ny = m_pData->x2.ny = nValue;
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}
		return TRUE;
	}

	void	GetNames(vector<string>& vs)
	{
		static	vector<string>	vsLocal = {STR_AXIS_XFROM, STR_AXIS_XTO, STR_AXIS_YFROM, STR_AXIS_YTO};
		vs = vsLocal;
		vs.Add(_L("X Reference Line"));
		vs.Add(_L("Y Reference Line"));
	}

	void	GetColors(vector<uint>& vn)
	{
		vn.SetSize(IMPLDATA_TOTAL);
		vn[IMPLDATA_X1] = color_index_to_rgb(m_pData->x1.color);
		vn[IMPLDATA_X2] = color_index_to_rgb(m_pData->x2.color);
		vn[IMPLDATA_Y1] = color_index_to_rgb(m_pData->y1.color);
		vn[IMPLDATA_Y2] = color_index_to_rgb(m_pData->y2.color);
		vn[IMPLDATA_XREF] = color_index_to_rgb(m_pData->axisY.nColor);
		vn[IMPLDATA_YREF] = color_index_to_rgb(m_pData->axisX.nColor);
	}

	void	GetPixels(vector<string>& vs)
	{
		vs.SetSize(IMPLDATA_TOTAL);
		vs[IMPLDATA_X1] = m_pData->GetValue(m_pData->x1.nx);
		vs[IMPLDATA_X2] = m_pData->GetValue(m_pData->x2.nx);
		vs[IMPLDATA_Y1] = m_pData->GetValue(m_pData->y1.ny);
		vs[IMPLDATA_Y2] = m_pData->GetValue(m_pData->y2.ny);
		vs[IMPLDATA_XREF] = m_pData->GetValue(m_pData->y1.nx);
		vs[IMPLDATA_YREF] = m_pData->GetValue(m_pData->x1.ny);
	}

	BOOL	GetX0Y0(double& x, double& y)
	{
		x = m_pData->y1.nx;
		y = m_pData->x1.ny;
		return TRUE;
	}

	BOOL	SetAxisSelection(IMPLDATA type)
	{
		GraphObject		go = GetAxisObj(type);

		Selection.Reset();
		if ( go )
			Selection.Add(go);
		return TRUE;
	}

	IMPLDATA	GetAxisSelection()
	{
		foreach ( OriginObject obj in Selection.Objects )
		{
			GraphObject		go;
			go = obj;
			if ( !go )
				continue;
			
			IMPLDATA	type = GetAxisType(go);
			if ( IMPLDATA_INVALID != type )
				return type;
		}
		return IMPLDATA_INVALID;
	}

	BOOL	ShowXRefLine(BOOL bShow)
	{
		m_pData->SetX1FromYAxis(!bShow);
		Y(OBJUPDATE_RECREATE);
		return TRUE;
	}
	
	BOOL	ShowYRefLine(BOOL bShow)
	{
		m_pData->SetY1FromXAxis(!bShow);
		X(OBJUPDATE_RECREATE);
		return TRUE;
	}

private:
	GraphLayer	GetDigitizeLayer()
	{
		return m_pObjsHolder->GetDigitizeLayer();
	}

	BOOL		Refresh()
	{
		return m_pObjsHolder->Refresh();
	}

	BOOL		SetupUndoEvent(GraphObject& go)
	{
		return m_pObjsHolder->SetupUndoEvent(go);
	}

	BOOL		SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal)
	{
		return m_pObjsHolder->SetObjProperty(lpcszName, lpcszProp, rVal);
	}

	BOOL		GetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double& rVal)
	{
		return m_pObjsHolder->GetObjProperty(lpcszName, lpcszProp, rVal);
	}

	string		MakeObjName(LPCSTR lpcsz)
	{
		return m_pData->MakeObjName(lpcsz);
	}

	BOOL		IsAxesEditing()
	{
		return m_pData->IsAxisEditing();
	}

	DWORD		GetUpdateStates(int nTabIndex = 0)
	{
		return m_pData->IsDlgOpen() && IsAxesEditing() ? OBJ_COMMON_STATE | m_pData->ConvertTabIndex(nTabIndex) : GOC_NO_SELECT;
	}

	BOOL	CreateCrossLine(GraphObject& line, DigitizerCoordinates& coor, int nColor, LPCSTR lpcszName, BOOL bVertical)
	{
		GraphLayer	gl = GetDigitizeLayer();
		int			nWidth = gl.X.To;
		int			nHeight = gl.Y.From;

		int		x0, y0, x1, y1;
		if ( bVertical )
		{
			x0 = x1 = coor.nx;
			y0 = 0, y1 = nHeight;
		}
		else
		{
			x0 = 0, x1 = nWidth;
			y0 = y1 = coor.ny;
		}
		
		return add_line(gl, line, x0, y0, ATTACH_TO_SCALE, LN_FREE, false, false, x1, y1, nColor, lpcszName)
			&& SetObjProperty(lpcszName, "ArrowEndShape", 1);
	}

	int		GetPointHalfSize()
	{
		return m_pData->GetPointHalfSize();
	}

	GraphObject		Axis(int nUpdate, LPCSTR lpcszName, DigitizerCoordinates& from, DigitizerCoordinates& to, int nColor, BOOL bVertical, BOOL bSuppress, UINT nTabIndex)
	{
		string		strName = MakeObjName(lpcszName);
		GraphObject	axis = GetDigitizeLayer().GraphObjects(strName);

		DWORD		dwStates = GetUpdateStates(nTabIndex) | (bVertical ? GOC_NO_VMOVE : GOC_NO_HMOVE);
		if ( OBJUPDATE_NONE != nUpdate )
		{
			if ( axis )
			{
				if ( OBJUPDATE_EXISTING == nUpdate )
				{
					if ( !IsAxesEditing() )
						Selection.Remove(axis);
					update_go_states(axis, dwStates, -1);
					return axis;
				}
			
				axis.Destroy();
			}

			if ( bSuppress )
				return axis;
			
			if ( !m_pData->IsCoornianteReady(from) || !m_pData->IsCoornianteReady(to) )
				return axis;
			
			if ( CreateCrossLine(axis, from, nColor, strName, bVertical) )
			{
				SetupUndoEvent(axis);
				update_go_states(axis, dwStates);
				set_LT_script(axis, OBJ_INTERNAL_LABTALK_SCRIPT, GRCT_ANY_EVENT);
			}
		}
		return axis;
	}

	GraphObject		X(int nUpdate = OBJUPDATE_NONE)
	{
		return Axis(nUpdate, "X", m_pData->x1, m_pData->x2, m_pData->axisX.nColor, FALSE, m_pData->IsY1FromXAxis(), 6);
	}
	
	GraphObject		Y(int nUpdate = OBJUPDATE_NONE)
	{
		return Axis(nUpdate, "Y", m_pData->y1, m_pData->y2, m_pData->axisY.nColor, TRUE, m_pData->IsX1FromYAxis(), 5);
	}

	BOOL	IsAxis(LPCSTR lpcszName)
	{
		GraphObject		axisX = X();
		GraphObject		axisY = Y();
		return axisX && axisX.GetName().Compare(lpcszName) == 0 || axisY && axisY.GetName().Compare(lpcszName) == 0;
	}

	BOOL	UpdateFromAxis(int nEvent, LPCSTR lpcszName)
	{
		return UpdateFromX(nEvent, lpcszName) || UpdateFromY(nEvent, lpcszName);
	}

	#define		UPDATE_FROM_AXIS(_AXIS, _DATA1, _DATA2, _FROM, _TO, _VERTICAL) \
				GraphObject		axis = _AXIS(); \
				if ( !axis || axis.GetName().Compare(lpcszName) != 0 ) \
					return FALSE; \
				if ( OE_SELECT == nEvent || OE_UNSELECT == nEvent ) \
					return UpdateAxisLineStyle(axis, OE_SELECT == nEvent); \
				GetCoorsFromAxis(m_pData->_DATA1, m_pData->_DATA2, axis, _VERTICAL); \
				_FROM(OBJUPDATE_RECREATE), _TO(OBJUPDATE_RECREATE); \
				return TRUE;

	BOOL	UpdateFromX(int nEvent, LPCSTR lpcszName)
	{
		UPDATE_FROM_AXIS(X, x1, x2, XFrom, XTo, FALSE);
	}

	BOOL	UpdateFromY(int nEvent, LPCSTR lpcszName)
	{
		UPDATE_FROM_AXIS(Y, y1, y2, YFrom, YTo, TRUE);
	}

	void	GetCoorsFromAxis(DigitizerCoordinates& from, DigitizerCoordinates& to, GraphObject& axis, BOOL bVertical)
	{
		double	x0, y0, x1, y1;
		GetEndPointsFromLine(x0, y0, x1, y1, axis);

		if ( bVertical )
		{
			from.nx = x0;
			to.nx = x1;
		}
		else
		{
			from.ny = y0;
			to.ny = y1;
		}
	}

	void	GetEndPointsFromLine(double& x0, double& y0, double& x1, double& y1, GraphObject& line)
	{
		vector		vx, vy;
		Tree		tr;
		tr = line.GetFormat(FPB_DATA, FOB_ALL, true, true);
		vx = tr.Root.Data.X.dVals;
		vy = tr.Root.Data.Y.dVals;

		x0 = vx[0], x1 = vx[1], y0 = vy[0], y1 = vy[1];
	}

	GraphObject		AxisEnd(int nUpdate, LPCSTR lpcszName, DigitizerCoordinates& coor, BOOL bVerticalCrossLine, GraphObject* pCrossLine, UINT nTabIndex)
	{
		string		strName = MakeObjName(lpcszName);
		string		strTextName = strName + "_Text";

		GraphLayer	gl = GetDigitizeLayer();
		GraphObject	end = gl.GraphObjects(strName);
		GraphObject	endText = gl.GraphObjects(strTextName);

		GraphObject	endCrossLine;
		endCrossLine = CreateAxisEndCrossLine(nUpdate, bVerticalCrossLine, strName, coor, nTabIndex);
		if ( pCrossLine )
			*pCrossLine = endCrossLine;

		if ( OBJUPDATE_NONE != nUpdate )
		{
			if ( end )
			{
				if ( OBJUPDATE_EXISTING == nUpdate )
				{
					CheckShowAxisEnd(end);
					ObjsUpdateEventHelper	clHelper;
					end.X = coor.nx;
					end.Y = coor.ny;
					return end;
				}
				end.Destroy();
				if  ( endText )
					endText.Destroy();
			}

			if ( !m_pData->IsCoornianteReady(coor) )
				return end;

			int		nHalfSize = GetPointHalfSize();
			add_rect(gl, end, coor.nx - nHalfSize, coor.ny - nHalfSize, coor.nx + nHalfSize, coor.ny + nHalfSize, coor.color, ATTACH_TO_SCALE, LN_FREE, false, false);
			end.SetName(strName);
			update_go_states(end, GOC_NO_SELECT);
			end.ConnectTo(endCrossLine, -1, -1, FALSE);
			CheckShowAxisEnd(end);
		}

		return end;
	}

	void	CheckShowAxisEnd(GraphObject& end)
	{
		end.Show = !IsAxesEditing();
	}

	#define	STR_CROSS_LINE_POSTFIX		"_Cross"
	BOOL	IsAxisEndCrossLine(LPCSTR lpcszName)
	{
		return strstr(lpcszName, STR_CROSS_LINE_POSTFIX) != NULL;
	}

	GraphObject		CreateAxisEndCrossLine(int nUpdate, BOOL bVertical, LPCSTR lpcszName, DigitizerCoordinates& coor, UINT nTabIndex)
	{
		string		strCrossLineName;
		strCrossLineName.Format("%s%s", lpcszName, STR_CROSS_LINE_POSTFIX);
		GraphObject	line = GetDigitizeLayer().GraphObjects(strCrossLineName);

		if ( OBJUPDATE_NONE != nUpdate )
		{
			if ( line )
			{
				line.Destroy();
			}

			if ( !m_pData->IsCoornianteReady(coor) )
				return line;
			
			if ( CreateCrossLine(line, coor, IsAxesEditing() ? coor.color : SYSCOLOR_BLACK, strCrossLineName, bVertical) )
			{
				update_go_states(line, GetUpdateStates(nTabIndex) | (bVertical ? GOC_NO_VMOVE : GOC_NO_HMOVE));
				SetupUndoEvent(line);
				set_LT_script(line, OBJ_INTERNAL_LABTALK_SCRIPT, GRCT_ANY_EVENT);
				
				if ( !IsAxesEditing() )
				{
					SetObjProperty(strCrossLineName, "LineType", 2);
				}
			}
			
		}
		return line;
	}

	BOOL	UpdateFromAxisEndCrossLine(int nEvent, LPCSTR lpcszName)
	{
		return UpdateFromXFromCrossLine(nEvent, lpcszName) || UpdateFromXToCrossLine(nEvent, lpcszName) || UpdateFromYFromCrossLine(nEvent, lpcszName) || UpdateFromYToCrossLine(nEvent, lpcszName);
	}

	#define		UPDATE_FROM_AXIS_END_CROSS_LINE(_ENDCROSSLINE, _COOR, _VERTICAL, _MORE) \
				GraphObject		crossLine = _ENDCROSSLINE(); \
				/*///------ Folger 04/19/2011 ORG-2684-P1 DIGITIZER_RUNTIME_ERRO_AFTER_DELETE_AXIS_SCALE_VALUE*/ \
				/*if ( crossLine.GetName().CompareNoCase(lpcszName) != 0 ) \*/ \
				if ( !crossLine || crossLine.GetName().CompareNoCase(lpcszName) != 0 ) \
				/*///------ End DIGITIZER_RUNTIME_ERRO_AFTER_DELETE_AXIS_SCALE_VALUE*/ \
					return FALSE; \
				if ( OE_SELECT == nEvent || OE_UNSELECT == nEvent ) \
					return UpdateAxisLineStyle(crossLine, OE_SELECT == nEvent); \
				return GetCoorsFromCrossLine(m_pData->_COOR, crossLine, _VERTICAL) && _MORE;

	BOOL	UpdateFromXFromCrossLine(int nEvent, LPCSTR lpcszName)
	{
		UPDATE_FROM_AXIS_END_CROSS_LINE(XFromCrossLine, x1, TRUE, m_pData->UpdateY1Y2FromX1());
	}

	BOOL	UpdateFromXToCrossLine(int nEvent, LPCSTR lpcszName)
	{
		UPDATE_FROM_AXIS_END_CROSS_LINE(XToCrossLine, x2, TRUE, TRUE);
	}

	BOOL	UpdateFromYFromCrossLine(int nEvent, LPCSTR lpcszName)
	{
		UPDATE_FROM_AXIS_END_CROSS_LINE(YFromCrossLine, y1, FALSE, m_pData->UpdateX1X2FromY1());
	}
	
	BOOL	UpdateFromYToCrossLine(int nEvent, LPCSTR lpcszName)
	{
		UPDATE_FROM_AXIS_END_CROSS_LINE(YToCrossLine, y2, FALSE, TRUE);
	}

	BOOL	GetCoorsFromCrossLine(DigitizerCoordinates& coor, GraphObject& line, BOOL bVertical)
	{
		double	x0, y0, x1, y1;
		GetEndPointsFromLine(x0, y0, x1, y1, line);
		
		if ( bVertical )
		{
			coor.nx = x0;
		}
		else
		{
			coor.ny = y0;
		}
		return TRUE;
	}

	#define			CHECK_OBJ_NAME_RETURN_DUMMY \
					if ( OBJUPDATE_NONE != nUpdate && lpcszNameToCheck && MakeObjName(lpcszName).CompareNoCase(lpcszNameToCheck) != 0 ) { GraphObject dummy; return dummy; }

	GraphObject		XFrom(int nUpdate = OBJUPDATE_NONE, LPCSTR lpcszNameToCheck = NULL, GraphObject* pCrossLine = NULL)
	{
		LPCSTR		lpcszName = STR_AXIS_XFROM;
		CHECK_OBJ_NAME_RETURN_DUMMY;

		return AxisEnd(nUpdate, lpcszName, m_pData->x1, TRUE, pCrossLine, 1);
	}

	GraphObject		XTo(int nUpdate = OBJUPDATE_NONE, LPCSTR lpcszNameToCheck = NULL, GraphObject* pCrossLine = NULL)
	{
		LPCSTR		lpcszName = STR_AXIS_XTO;
		CHECK_OBJ_NAME_RETURN_DUMMY;

		return AxisEnd(nUpdate, lpcszName, m_pData->x2, TRUE, pCrossLine, 2);
	}

	GraphObject		YFrom(int nUpdate = OBJUPDATE_NONE, LPCSTR lpcszNameToCheck = NULL, GraphObject* pCrossLine = NULL)
	{
		LPCSTR		lpcszName = STR_AXIS_YFROM;
		CHECK_OBJ_NAME_RETURN_DUMMY;

		return AxisEnd(nUpdate, lpcszName, m_pData->y1, FALSE, pCrossLine, 3);
	}
	
	GraphObject		YTo(int nUpdate = OBJUPDATE_NONE, LPCSTR lpcszNameToCheck = NULL, GraphObject* pCrossLine = NULL)
	{
		LPCSTR		lpcszName = STR_AXIS_YTO;
		CHECK_OBJ_NAME_RETURN_DUMMY;
		return AxisEnd(nUpdate, lpcszName, m_pData->y2, FALSE, pCrossLine, 4);
	}

	#define			END_CROSS_LINE(_END) \
					GraphObject		line; \
					_END(OBJUPDATE_NONE, NULL, &line); \
					return line;

	GraphObject		XFromCrossLine()
	{
		END_CROSS_LINE(XFrom);
	}

	GraphObject		XToCrossLine()
	{
		END_CROSS_LINE(XTo);
	}

	GraphObject		YFromCrossLine()
	{
		END_CROSS_LINE(YFrom);
	}
	
	GraphObject		YToCrossLine()
	{
		END_CROSS_LINE(YTo);
	}

	BOOL	UpdateFromAxisEnd(DigitizerCoordinates& coor, GraphObject& end)
	{
		if ( !end )
			return FALSE;

		coor.nx = end.X;
		coor.ny = end.Y;
		return TRUE;
	}

	BOOL	UpdateFromXFrom()
	{
		return UpdateFromAxisEnd(m_pData->x1, XFrom()) && m_pData->UpdateY1Y2FromX1();
	}

	BOOL	UpdateFromXTo()
	{
		return UpdateFromAxisEnd(m_pData->x2, XTo());
	}

	BOOL	UpdateFromYFrom()
	{
		return UpdateFromAxisEnd(m_pData->y1, YFrom()) && m_pData->UpdateX1X2FromY1();
	}
	
	BOOL	UpdateFromYTo()
	{
		return UpdateFromAxisEnd(m_pData->y2, YTo());
	}

	BOOL	UpdateFromAxesEnd(int nEvent, LPCSTR lpcszName)
	{
		if ( IsAxisEndCrossLine(lpcszName) )
			return UpdateFromAxisEndCrossLine(nEvent, lpcszName);

		O_A(nEvent == OE_MOVE);
		UpdateFromXFrom(), UpdateFromXTo(), UpdateFromYFrom(), UpdateFromYTo();
		return Update(OBJUPDATE_EXISTING, lpcszName, FALSE);
	}

	GraphObject		GetAxisObj(IMPLDATA type)
	{
		switch ( type )
		{
		case IMPLDATA_X1:
			return XFromCrossLine();

		case IMPLDATA_X2:
			return XToCrossLine()

		case IMPLDATA_Y1:
			return YFromCrossLine();

		case IMPLDATA_Y2:
			return YToCrossLine()

		case IMPLDATA_XREF:
			return Y();

		case IMPLDATA_YREF:
			return X();

		default:
			break;
		}

		GraphObject		dummy;
		return dummy;
	}

	IMPLDATA		GetAxisType(GraphObject& go)
	{
		string		strName = go.GetName();
		for ( IMPLDATA type = IMPLDATA_X1; type<IMPLDATA_TOTAL; ++type )
		{
			GraphObject		axis = GetAxisObj(type);
			if ( !axis )
				continue;
			if ( strName.Compare(axis.GetName()) == 0 )
				return type;
		}
		return IMPLDATA_INVALID;
	}

	///------ Folger 01/06/2011 ORG-1512-S6 DIGITIZER_ADD_LINE_END_SYMBOL_TO_INDICATE_SELECTION
	BOOL			UpdateAxisLineStyle(GraphObject& line, BOOL bSelect)
	{
		int		nStyle = bSelect ? 4 : 0;
		int		nWidth = 10;
		int		nHeight = 8.66;

		Tree	tr;
		tr.Root.Arrow.Begin.Style.nVal = nStyle;
		tr.Root.Arrow.Begin.Width.dVal = nWidth;
		tr.Root.Arrow.Begin.Length.dVal = nHeight;
		tr.Root.Arrow.End.Style.nVal = nStyle;
		tr.Root.Arrow.End.Width.dVal = nWidth;
		tr.Root.Arrow.End.Length.dVal = nHeight;
		return 0 == line.UpdateThemeIDs(tr.Root) && line.ApplyFormat(tr, TRUE, TRUE);
	}
	///------ End DIGITIZER_ADD_LINE_END_SYMBOL_TO_INDICATE_SELECTION

private:
	DigitizerImplData*		m_pData;
	DigitizerObjsHolder*	m_pObjsHolder;
};

class DigitizerVisualizer
{
public:
	DigitizerVisualizer(DigitizerImplData& data, DigitizerObjsHolder& objsHolder)
	{
		m_pData = &data;
		m_pObjsHolder = &objsHolder;
		m_pPlot = NULL;
		m_pAxes = NULL;
	}
	~DigitizerVisualizer()
	{
		NICE_SAFE_REMOVAL(m_pPlot);
		NICE_SAFE_REMOVAL(m_pAxes);
	}

	BOOL	IsReadyToDigitize()
	{
		return m_pData->IsReady();
	}

	BOOL	UpdateAxes(BOOL bRefresh = FALSE)
	{
		return Axes()->Update(OBJUPDATE_RECREATE, NULL, bRefresh);
	}

	BOOL	UpdateDataPlot(BOOL bRefresh = FALSE)
	{
		return Plot()->Update(OBJUPDATE_EXISTING, bRefresh);
	}

	BOOL	AddOnePoint(double x,  double y)
	{
		return Plot()->AddOnePoint(x, y);
	}

	BOOL	HasDataPoint()
	{
		return Plot()->HasDataPoint();
	}

	int		UpdateFromEvents(int nEvent, LPCSTR lpcszName)
	{
		int		nReturn = UPDATEFROMEVENTS_NOT_HANDLE;
		if ( UPDATEFROMEVENTS_NOT_HANDLE != (nReturn = Plot()->UpdateFromEvents(nEvent, lpcszName)) )
			return nReturn;

		if ( UPDATEFROMEVENTS_NOT_HANDLE != (nReturn = Axes()->UpdateFromEvents(nEvent, lpcszName)) )
			return nReturn;

		return UPDATEFROMEVENTS_NONE;
	}

	BOOL	UpdateFromPlot(int nEvent)
	{
		return Plot()->Update(nEvent);
	}

	BOOL	NewData()
	{
		return Plot()->NewData();
	}

	BOOL	ClearDataPlot()
	{
		return Plot()->Clear();
	}

	BOOL	SetAxesEditing(BOOL bOn)
	{
		Selection.Reset();
		m_pData->SetAxisEditing(bOn);
		return UpdateStates();
	}

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	SetLabelEditing(BOOL bOn)
	{
		m_pData->SetLabelEditing(bOn);
		return Plot()->UpdateStates() && Plot()->UpdateData();
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	BOOL	UpdateStates()
	{
		return Axes()->Update(OBJUPDATE_EXISTING) && Plot()->UpdateStates();
	}

	BOOL	SetAxisSelection(IMPLDATA type)
	{
		return Axes()->SetAxisSelection(type);
	}

	IMPLDATA	GetAxisSelection()
	{
		return Axes()->GetAxisSelection();
	}

	BOOL	SetAxisPixel(IMPLDATA type, int nValue)
	{
		return Axes()->SetPixel(type, nValue);
	}

	void	GetAxesNames(vector<string>& vs)
	{
		Axes()->GetNames(vs);
	}

	void	GetAxesColors(vector<uint>& vn)
	{
		Axes()->GetColors(vn);
	}

	void	GetAxesPixels(vector<string>& vs)
	{
		Axes()->GetPixels(vs);
	}

	BOOL	GetX0Y0(double& x, double& y)
	{
		return Axes()->GetX0Y0(x, y);
	}

	BOOL	ShowXRefLine(BOOL bShow)
	{
		return Axes()->ShowXRefLine(bShow);
	}
	
	BOOL	ShowYRefLine(BOOL bShow)
	{
		return Axes()->ShowYRefLine(bShow);
	}

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	DataPlotEdit(int nIndex)
	{
		return Plot()->Edit(nIndex);
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	UpdatePlotData()
	{
		return Plot()->UpdateData();
	}
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

private:
	DigitizerDataPlot*			Plot()
	{
		if ( NULL == m_pPlot )
			m_pPlot = new DigitizerDataPlot(m_pData, m_pObjsHolder);
		return m_pPlot;
	}

	DigitizerAxes*					Axes()
	{
		if ( NULL == m_pAxes )
			m_pAxes = new DigitizerAxes(m_pData, m_pObjsHolder);
		return m_pAxes;
	}

private:
	DigitizerImplData*				m_pData;
	DigitizerObjsHolder*			m_pObjsHolder;
	
	DigitizerDataPlot*			m_pPlot;
	DigitizerAxes*					m_pAxes;
};

class DigitizerImpl;

enum
{
	ROTATE_COUNTERCLOCKWISE		= 0,
	ROTATE_CLOCKWISE,
};
static bool _rotate_image(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	GetNOptionEventHelper	eventHelper(dwCntrl);
	if ( !eventHelper.IsInit() )
	{
		DigitizerImpl	digitizerImpl;
		if ( trNode.tagName.Compare("Direction") == 0 )
		{
			myTree.Angle.dVal += myTree.Inc.dVal * (ROTATE_CLOCKWISE == trNode.nVal ? 1 : -1);
		}
		else if ( trNode.tagName.Compare("Inc") == 0 )
		{
			if ( myTree.Inc.dVal <= 0 )
			{
				myTree.Inc.dVal = digitizerImpl.GetRotateInc();
				warning_msg_box(CER_MUST_LARGE_THAN_0, _L("Increment"), true);
			}
			myTree.Inc.dVal = rmod(myTree.Inc.dVal, 360.0);
			return true;
		}

		myTree.Angle.dVal = rmod(myTree.Angle.dVal, 360.0);
		///------ Tony 06/11/2012 ORG-5466-P1 ROTATION_ANGLE_WHEN_-360DEGREE
		if( myTree.Angle.dVal < 0.0000001 && myTree.Angle.dVal > -0.0000001)		//Change -0.0 to 0.0.	
			myTree.Angle.dVal = 0.0;
		///------ End ROTATION_ANGLE_WHEN_-360DEGREE
		double	rAngle = myTree.Angle.dVal;
		double	rAngleInc = myTree.Inc.dVal;
		return digitizerImpl.RotateImage(&rAngle, &rAngleInc);
	}	
	return true;
}

class DigitizerRotationHelper
{
public:
	DigitizerRotationHelper(DigitizerImplData& data, HWND hWnd)
	{
		m_pData = &data;
		m_hWnd = hWnd;
	}
	~DigitizerRotationHelper()
	{
	}

	BOOL	Update(BOOL bOn)
	{
		///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		m_pData->SetRotationMode(bOn);
		///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

		GETN_TREE(tr)
		GETN_STR(Hint, _L("Click Rotate button again to get out of Rotation mode"), "")		GETN_HINT_EX(FALSE, FALSE)
		GETN_NUM(Angle, _L("Rotation Angle from Source Image (degree)"), 0)		GETN_OPTION_EVENT_EX(_rotate_image)
		GETN_BUTTON_GROUP(Direction, _L(""), 0, "<<|>>")						GETN_OPTION_EVENT_EX(_rotate_image)		_tmpSubNode.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_EDITOR_HORZ);
		GETN_NUM(Inc, _L("<<    >> Increment (degree)"), 0)						GETN_OPTION_EVENT_EX(_rotate_image)
		return OpenDlg(tr);
	}

private:
	#define		STR_ROTATE_IMAGE		_L("Rotate Image")
	BOOL	OpenDlg(TreeNode& tr)
	{
		GetSettings(tr);
		
		Window		wnd(m_hWnd);
		///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		/*
		wnd.Visible = FALSE;
		GetNBox(tr, STR_ROTATE_IMAGE, NULL, NULL, NULL, hWnd);
		wnd.Visible = TRUE;

		SetSettings(tr);
		return TRUE;
		*/
		return wnd.SendMessage(ID_DIGITIZER_MSG_UPDATE_DYNACTRL, (WPARAM)(&tr), m_pData->IsRotationMode());
		///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	}

	void	GetSettings(TreeNode& tr)
	{
		tr.Angle.dVal = m_pData->rAngleRotated;
		tr.Inc.dVal = m_pData->rAngleInc;
	}

	void	SetSettings(TreeNode& tr)
	{
		m_pData->rAngleRotated = tr.Angle.dVal;
		m_pData->rAngleInc = tr.Inc.dVal;
	}

private:
	DigitizerImplData*		m_pData;
	HWND					m_hWnd;
};

#define		STR_SCREEN_X		"ScreenX"
#define		STR_SCREEN_Y		"ScreenY"

#define		STR_OPTION			_L("Options")
class DigitizerOptionsHelper
{
public:
	DigitizerOptionsHelper(DigitizerImplData& data, HWND hWnd)
	{
		m_pData = &data;
		m_hWnd = hWnd;
		///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
		GetDataName();
		///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	}
	~DigitizerOptionsHelper()
	{
	}
	
	BOOL	Update()
	{
		GETN_TREE(tr)
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		/// Iris 7/25/2012 ORG-6305 CHANGE_OPTIONS_DLG_BUTTON_TO_OK_AND_CANCEL
		/*
		string		strCustomButton;
		strCustomButton.Format("OK=%s|Cancel=", _L("Close"));
		GETN_CUSTOM_BUTTON(strCustomButton)
		*/
		///End CHANGE_OPTIONS_DLG_BUTTON_TO_OK_AND_CANCEL
		
		GETN_BEGIN_BRANCH(SelectData, _L("Curves"))					SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
		#ifdef		MULTIPLE_CURVES
		GETN_LIST(ActiveData, _L("Active Curve"), 0, DataList())	GETN_EDIT_DISPLAY_WIDTH_RANGE("20-20")		GETN_OPTION_EVENT_EX(_update_curves)
		#endif		/// MULTIPLE_CURVES
		GETN_STR(DataName, _L("Result Worksheet Name"), "")			GETN_EDIT_DISPLAY_WIDTH_RANGE("20-20")		GETN_OPTION_EVENT_EX(_update_curves)
		GETN_COLOR(Color, _L("Color"), 0)							GETN_OPTION_EVENT_EX(_update_curves)
		GETN_END_BRANCH(SelectData)

		GETN_BEGIN_BRANCH(XAxisType, _L("X Axis Tick Labels Type"))			SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
		getn_construct_display_format(_tmpSubNode, 0, 0, "");
		GETN_END_BRANCH(XAxisType)

		GETN_BEGIN_BRANCH(YAxisType, _L("Y Axis Tick Labels Type"))			SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
		getn_construct_display_format(_tmpSubNode, 0, 0, "");
		GETN_END_BRANCH(YAxisType)

		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		GETN_BEGIN_BRANCH(AutoFindType, _L("Optimize clicked points"))			SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
		GETN_LIST(AdjustType, _L("Type"), 0, _L("None|Solid Symbols"))
		GETN_END_BRANCH(AutoFindType)
		tr.AutoFindType.Show = false;	///Jasminie 03/11/11 ORG-2286 HIDE_FOR_851_RELEASE
		///End OPTIMIZE_PICKED_POINT
		
		GetSettings(tr);	
		/// Iris 7/25/2012 ORG-6305 CHANGE_OPTIONS_DLG_BUTTON_TO_OK_AND_CANCEL
		/*
		GetNBox(tr, STR_OPTION, NULL, NULL, NULL, m_hWnd);
		return Update(tr);
		*/
		if( GetNBox(tr, STR_OPTION, NULL, NULL, NULL, m_hWnd) )		
			return Update(tr);
		return FALSE;
		///End CHANGE_OPTIONS_DLG_BUTTON_TO_OK_AND_CANCEL
	}

	BOOL	Update(TreeNode& tr, DWORD dwCntrl = 0)
	{
		SetSettings(tr, dwCntrl);
		return TRUE; 
	}

private:
	void	SetSettings(TreeNode& tr, DWORD dwCntrl)
	{
		if ( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATANAME) )
		{
			string	str = tr.SelectData.DataName.strVal;
			m_pData->UpdateDataName(str);
			tr.SelectData.DataName.strVal = str;
		}

		#ifdef		MULTIPLE_CURVES
		m_pData->SetActiveData(tr.SelectData.ActiveData.nVal);
		#endif		/// MULTIPLE_CURVES

		if ( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATA) )
		{
			tr.SelectData.DataName.strVal = GetDataName();
			tr.SelectData.Color.nVal = m_pData->GetPlotColor();
		}
		///------ Tony 08/28/2012 ORG-6305-P1 ADD_UPDATEOPTIONSFROM_COLOR_TO_AVOID_SETTING_COLOR
		else if( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATANAME) )
		{
			m_pData->SetDataName(tr.SelectData.DataName.strVal, m_strCol);
		}
		else if( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_COLOR) )
		{}
		///------ End ADD_UPDATEOPTIONSFROM_COLOR_TO_AVOID_SETTING_COLOR
		else
		{
			m_pData->SetDataName(tr.SelectData.DataName.strVal, m_strCol);
			m_pData->SetPlotColor(tr.SelectData.Color.nVal);
		}

		m_pData->axisX.nFormat = tr.XAxisType.Format.nVal;
		m_pData->axisX.nSubFormat = tr.XAxisType.SubFormat.nVal;
		m_pData->axisX.strCustomDisplay = tr.XAxisType.CustomDisplay.strVal;

		m_pData->axisY.nFormat = tr.YAxisType.Format.nVal;
		m_pData->axisY.nSubFormat = tr.YAxisType.SubFormat.nVal;
		m_pData->axisY.strCustomDisplay = tr.YAxisType.CustomDisplay.strVal;
		
		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		m_pData->OptimizePoint = tr.AutoFindType.Show && tr.AutoFindType.AdjustType.nVal;
		///End OPTIMIZE_PICKED_POINT
	}
	
	void	GetSettings(TreeNode& tr)
	{
		#ifdef		MULTIPLE_CURVES
		tr.SelectData.ActiveData.nVal = m_pData->GetActiveData();
		#endif		/// MULTIPLE_CURVES
		tr.SelectData.DataName.strVal = GetDataName();
		tr.SelectData.Color.nVal = m_pData->GetPlotColor();

		tr.XAxisType.Format.nVal = m_pData->axisX.nFormat;
		tr.XAxisType.SubFormat.nVal = m_pData->axisX.nSubFormat;
		tr.XAxisType.CustomDisplay.strVal = m_pData->axisX.strCustomDisplay;
		
		tr.YAxisType.Format.nVal = m_pData->axisY.nFormat;
		tr.YAxisType.SubFormat.nVal = m_pData->axisY.nSubFormat;
		tr.YAxisType.CustomDisplay.strVal = m_pData->axisY.strCustomDisplay;
		
		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		tr.AutoFindType.AdjustType.nVal = m_pData->OptimizePoint;
		///End OPTIMIZE_PICKED_POINT
	}

	string	DataList()
	{
		int		nNumPlots = m_pData->GetNumData();
		vector<string>		vs(nNumPlots);
		for ( int ii=0; ii<nNumPlots; ++ii )
		{
			vs[ii].Format("Line #%d", ii + 1);
		}
		string	strCombo;
		strCombo.SetTokens(vs, '|');
		return strCombo;
	}

	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	string	GetDataName()
	{
		string	strBook, strSheet;
		okutil_parse_complete_range_string(m_pData->GetDataName(), &strBook, &strSheet, &m_strCol);
		return okutil_make_book_sheet_string(strBook, strSheet);
	}
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	
private:
	DigitizerImplData*		m_pData;
	HWND					m_hWnd;

	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	string					m_strCol;
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
};

#define		STR_HINT_DCLICK_TO_PICK_POINTS		_L("Double click or press Enter to pick points.")
#define		STR_HINT_ZOOM_AND_PAN				_L("Press A to zoom and pan.")
///------ Folger 08/31/2011 ORG-3667-S1 ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS
#define		STR_HINT_ESC_CANCEL_ALL_ENTRIES		_L("Press ESC to cancel all entries.")
///------ End ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS

class LocatePoints
{
public:
	LocatePoints(WndContainer& Dlg, BOOL bHideParent = FALSE)
	{
		m_pDRP = new LTVarTempChange("@DRP", 0);
		m_pDlg = &Dlg;
		if ( bHideParent )
			m_wndParent = m_pDlg->GetParent();

		Window	wndTemp(GetWindow());
		m_wnd.Attach(wndTemp);
		if( m_wnd )
		{
			m_pDlg->ShowWindow(SW_HIDE);
			if ( m_wndParent )
			{
				m_wndParent.ShowWindow(SW_HIDE);
			}
			m_bWndOldEnable = m_wnd.Enable;
			m_wnd.Enable = TRUE;
		}
		else
		{
			m_bWndOldEnable = FALSE;
		}
	}
	~LocatePoints()
	{
		NICE_SAFE_REMOVAL(m_pDRP);
		m_wnd.Enable = m_bWndOldEnable;
		if ( m_wndParent )
		{
			m_wndParent.ShowWindow(SW_SHOW);
			m_wndParent.Enable = FALSE;
		}
		m_pDlg->ShowWindow(SW_SHOW);
		m_pDlg->Enable = TRUE;
		
		Refresh();
	}

	BOOL	GetOne(TreeNode& trNode)
	{
		vector		vx, vy;
		if ( graph_get_points(vx, vy, NULL, NULL, NULL, NULL, 1, -1, NULL, false) != 1 )
			return FALSE;

		trNode.SetAttribute(STR_SCREEN_X, vx[0]);
		trNode.SetAttribute(STR_SCREEN_Y, vy[0]);
		return TRUE;
	}

	BOOL	GetMultiple(vector& vx, vector& vy)
	{
		string	strMsg;
		///------ Folger 08/31/2011 ORG-3667-S1 ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS
		//strMsg.Format("%s\n%s", STR_HINT_DCLICK_TO_PICK_POINTS, STR_HINT_ZOOM_AND_PAN);
		strMsg.Format("%s\n%s\n%s", STR_HINT_DCLICK_TO_PICK_POINTS, STR_HINT_ZOOM_AND_PAN, STR_HINT_ESC_CANCEL_ALL_ENTRIES);
		///------ End ADD_ESC_HINT_FOR_DIGITIZER_GET_POINTS
		return graph_get_points(vx, vy, strMsg, STR_GRAPH_ADD_PTS_MSG2, NULL, NULL, -1, CURSOR_NONE, NULL, true, NULL, digitizer_calculate_one_point, digitizer_add_one_point);
	}
	
private:
	BOOL	Refresh()
	{
		return LT_execute(";doc -uw;");
	}

private:
	Window			m_wnd;
	WndContainer*	m_pDlg;
	Window			m_wndParent;
	BOOL			m_bWndOldEnable;
	LTVarTempChange*	m_pDRP;
};

enum
{
	UPDATEOPTIONSFROM_DATA					= 0x00000001,
	UPDATEOPTIONSFROM_DATANAME				= 0x00000002,
	UPDATEOPTIONSFROM_COLOR					= 0x00000004,		///------ Tony 08/28/2012 ORG-6305-P1 ADD_UPDATEOPTIONSFROM_COLOR_TO_AVOID_SETTING_COLOR
};

static bool _update_curves(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	GetNOptionEventHelper	eventHelper(dwCntrl);
	if ( !eventHelper.IsInit() )
	{
		DigitizerImpl	digitizerImpl;
		DWORD			dwCntrl = 0;
		O_SET_BIT(dwCntrl, UPDATEOPTIONSFROM_DATA, trNode.tagName.Compare("ActiveData") == 0);
		O_SET_BIT(dwCntrl, UPDATEOPTIONSFROM_DATANAME, trNode.tagName.Compare("DataName") == 0);
		O_SET_BIT(dwCntrl, UPDATEOPTIONSFROM_COLOR, trNode.tagName.Compare("Color") == 0);		///------ Tony 08/28/2012 ORG-6305-P1 ADD_UPDATEOPTIONSFROM_COLOR_TO_AVOID_SETTING_COLOR
		return digitizerImpl.UpdateOptions(myTree, dwCntrl);
	}	
	return true;
}

class DigitizerImageHelper
{
public:
	DigitizerImageHelper(DigitizerImplData& data, DigitizerObjsHolder& objsHolder)
	{
		m_pData = &data;
		m_pObjsHolder = &objsHolder;
	}
	~DigitizerImageHelper()
	{
	}

	BOOL	Import()
	{
		return ImportImage(GetImageFile());
	}
	
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	ImportFromClipboard()
	{
		m_pObjsHolder->PrepareDigitizePage();
		GraphObject	image = GetDigitizeImage();
		if ( image )
		{
			image.Destroy();
		}
		
		GraphObject goImage = m_pObjsHolder->GetDigitizeLayer().PasteImage(0, 0, PASTEIMAGE_CONVERT_TO_DIB);
		if( !goImage )
           return false;
		goImage.SetName(STR_IMAGE_OBJ_DEFAULT_NAME);		///------change the name as same as STR_IMAGE_OBJ_DEFAULT_NAME
		
		m_pData->Init(TRUE);
		return UpdateDataNameForClipboardImage()
			&& UpdatePageLongName()
			&& FitLayerToPage()
			&& SetupImage()
			&& PrepareImageBackup()
			&& UpdateAxesDefault();
	}
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

private:
	string	GetImageFile()
	{
		string	strFileName;
		int		nFiles = get_open_box_by_file_group(strFileName, "ImageImp", "Images", false);
		return strFileName;
	}
	
	GraphPage	GetDigitizePage()
	{
		return m_pObjsHolder->GetDigitizePage();
	}

	GraphLayer	GetDigitizeLayer()
	{
		return m_pObjsHolder->GetDigitizeLayer();
	}

	GraphObject	GetDigitizeImage()
	{
		return m_pObjsHolder->GetDigitizeImage();
	}

	BOOL		SetObjProperty(LPCSTR lpcszName, LPCSTR lpcszProp, double rVal, BOOL bDelay = FALSE)
	{
		return m_pObjsHolder->SetObjProperty(lpcszName, lpcszProp, rVal, bDelay);
	}
	
	BOOL	ImportImage(LPCSTR lpcszFileName)
	{
		if ( NULL == lpcszFileName || '\0' == *lpcszFileName )
			return FALSE;
		
		m_pObjsHolder->PrepareDigitizePage();
		GraphObject	image = GetDigitizeImage();
		if ( image )
		{
			image.Destroy();
		}
		
		DISABLE_LT_UNDO;
		if ( !ImportImageIntoActiveLayer(lpcszFileName) )
			return FALSE;
		
		m_pData->Init(TRUE);
		return UpdateDataNameByImageFileName(lpcszFileName)
		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
		//	&& UpdatePageLongName(lpcszFileName)
			&& UpdatePageLongName()
		///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER	
			&& FitLayerToPage()
			&& SetupImage()
			&& PrepareImageBackup(lpcszFileName)
			&& UpdateAxesDefault();
	}
	
	BOOL	SetupImage()
	{
		GraphObject		image = GetDigitizeLayer().GraphObjects(STR_IMAGE_OBJ_DEFAULT_NAME);
		image.SetName(STR_IMAGE_NAME);
		
		image.Attach = ATTACH_TO_PAGE;
		return SetupImageExecScript()
			&& SetImageNoSelect()
			&& FitImageToPage();
	}

	BOOL	FitLayerToPage()
	{
		int			nWidth, nHeight;
		if ( !page_get_width_height(GetDigitizePage(), &nWidth, &nHeight) )
			return FALSE;
		
		string		strLT;
		strLT.Format("layer.width=%d;layer.Height=%d;", nWidth, nHeight);
		return GetDigitizeLayer().LT_execute(strLT);
	}
	
	BOOL	FitImageToPage()
	{
		///------ Folger 08/03/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
		if ( !UpdateImageSize() )
			return FALSE;
		///------ End DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO

		int			nWidth, nHeight;
		if ( !page_get_width_height(GetDigitizePage(), &nWidth, &nHeight) )
			return FALSE;
		
		double		rRatio = max((double)(m_pData->nImageWidth) / nWidth, (double)(m_pData->nImageHeight) / nHeight);

		///------ Folger 05/04/2012 ORG-5616-P1 DIGITIZER_BETTER_PAGE_LAYER_SIZE
		//GraphLayer		gl = GetDigitizeLayer();
		//gl.X.To = (int)(nWidth * rRatio);
		//gl.Y.From = (int)(nHeight * rRatio);
		///------ End DIGITIZER_BETTER_PAGE_LAYER_SIZE

		GraphObject	image = GetDigitizeImage();
		image.Width = m_pData->nImageWidth / rRatio;
		image.Height = m_pData->nImageHeight / rRatio;
		
		///------ Folger 05/04/2012 ORG-5616-P1 DIGITIZER_BETTER_PAGE_LAYER_SIZE
		GraphLayer		gl = GetDigitizeLayer();
		///------ Folger 08/28/2012 ORG-3412-P1 SHOW_ACUTAL_IMAGE_PIXELS_IN_DIGITIZER_PIXEL_LIST
		//gl.X.To = m_pData->nImageWidth / rRatio;
		//gl.Y.From = m_pData->nImageHeight / rRatio;
		gl.X.To = m_pData->nImageWidth;
		gl.Y.From = m_pData->nImageHeight;
		///------ End SHOW_ACUTAL_IMAGE_PIXELS_IN_DIGITIZER_PIXEL_LIST
		
		string		strLT;
		strLT.Format("layer.width=%d;page.width=%d;page.height=%d;layer.Height=%d;", image.Width, image.Width, image.Height, image.Height);
		gl.LT_execute(strLT);
		///------ End DIGITIZER_BETTER_PAGE_LAYER_SIZE
		
		return TRUE;
	}

	BOOL	SetImageNoSelect()
	{
		return SetObjProperty(STR_IMAGE_NAME, "states", GOC_NO_SELECT);
	}

	BOOL	UpdateDataNameByImageFileName(LPCSTR lpcszFile)
	{
		return m_pData->UpdateDataNameByImageFileName(lpcszFile);
	}
	
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	UpdateDataNameForClipboardImage()
	{
		return m_pData->UpdateDataNameForClipboardImage();
	}
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	//BOOL	UpdatePageLongName(LPCSTR lpcszFile)
	BOOL	UpdatePageLongName()
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	{
		///------ Folger 02/22/2011 ORG-2309-P1 NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
		//return GetDigitizePage().SetLongName(m_pData->strImageName);
		return GetDigitizePage().SetLongName(m_pData->strImageName, FALSE);
		///------ End NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
	}

	BOOL	UpdateAxesDefault()
	{
		GraphLayer	gl = GetDigitizeLayer();
		
		int		nWidth = gl.X.To;
		int		nHeight = gl.Y.From;
		double	rPercent1 = 0.1, rPercent2 = 0.2;
		m_pData->x1.ny = m_pData->x2.ny = (1 - rPercent1) * nHeight;
		m_pData->y1.nx = m_pData->y2.nx = rPercent1 * nWidth;
		m_pData->x1.nx = rPercent2 * nWidth;
		m_pData->x2.nx = (1 - rPercent2) * nWidth;
		m_pData->y1.ny = (1 - rPercent2) * nHeight;
		m_pData->y2.ny = rPercent2 * nHeight;

		return TRUE;
	}

	BOOL	PrepareImageBackup(LPCSTR lpcszFileName)
	{
		if ( !ImportImageIntoActiveLayer(lpcszFileName) )
			return FALSE;

		GraphObject		image = GetDigitizeLayer().GraphObjects(STR_IMAGE_OBJ_DEFAULT_NAME);
		image.Show = FALSE;
		return image.SetName(STR_IMAGE_BACKUP_NAME);
	}
	
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	PrepareImageBackup()
	{
		GraphObject goImage = m_pObjsHolder->GetDigitizeLayer().PasteImage(0, 0, PASTEIMAGE_CONVERT_TO_DIB);
		if( !goImage )
           return false;
		goImage.Show = FALSE;
		return goImage.SetName(STR_IMAGE_BACKUP_NAME);
	}
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER

	BOOL	ImportImageIntoActiveLayer(LPCSTR lpcszFileName)
	{
		return image_import_to_active_graph_layer(lpcszFileName, 0, 0);
	}

	BOOL	SetupImageExecScript()
	{
		return LT_execute(STR_IMAGE_NAME ".script$=" OBJ_MAIN_LABTALK_SCRIPT) && SetObjProperty(STR_IMAGE_NAME, "script", GRCT_ANY_EVENT);
	}
	
	///------ Folger 08/03/2011 ORG-3412-P1 DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO
	BOOL	UpdateImageSize()
	{
		matrix<BYTE>	mm;
		if ( !GetDigitizeLayer().GetImageData(STR_IMAGE_NAME, mm) )
			return FALSE;

		m_pData->nImageWidth = mm.GetNumCols();
		m_pData->nImageHeight = mm.GetNumRows();
		return TRUE;
	}
	///------ End DIGITIZER_FAILED_TO_GET_CORRECT_IMAGE_SIZE_INFO

private:
	DigitizerImplData*		m_pData;
	DigitizerObjsHolder*	m_pObjsHolder;
};

///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
typedef int (*FUNC_IMAGE_SPLIT_RGB)(const Image& imgSource, Image& imgRed, Image& imgGreen, Image& imgBlue);
typedef int (*FUNC_MATRIX_FIND_PEAK_CENTER)(const matrix& mi, int nCtrRow0, int nCtrCol0, int& nCtrRow, int& nCtrCol);
///End OPTIMIZE_PICKED_POINT
class DigitizerRunner
{
public:
	DigitizerRunner(DigitizerImplData& data)
	{
		m_pData = &data;
	}

	int		Run(Dialog& dlg)
	{
		LocatePoints	pts(dlg);
		vector			vx, vy;
		vx = m_pData->PtsScrX;
		vy = m_pData->PtsScrY;
		return pts.GetMultiple(vx, vy);
	}

	BOOL	Calculate()
	{
		m_pData->PrepareDataForCalculate();
		if ( m_pData->Size() <= 0 )
			return FALSE;

		return Calculate(m_pData->PtsX, m_pData->PtsY);
	}

	BOOL	CalculateOnePoint(double& x, double& y)
	{
		vector		vx(1), vy(1);
		vx[0] = x, vy[0] = y;

		Calculate(vx, vy);
		x = vx[0], y = vy[0];
		return TRUE;
	}

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	AntiCalculate()
	{
		m_pData->PrepareDataForCalculate(FALSE);
		if ( m_pData->Size() <= 0 )
			return FALSE;

		return Calculate(m_pData->PtsScrX, m_pData->PtsScrY, TRUE);
	}
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	bool PrepareImageMatrix()
	{		
		MatrixObject mobjExist;
		okxf_resolve_string_get_origin_object(m_pData->strMatrixObj, &mobjExist);
		if(mobjExist)
			return true;
		
		MatrixPage mp;
		mp.Create("origin", CREATE_HIDDEN|CREATE_SET_MISSING_IN_MANAGER);
		
		MatrixLayer ml = mp.Layers(0);
		MatrixObject moImage = ml.MatrixObjects(0);
		image_import_to_matrix(moImage, m_pData->strImageFile);
		int nRows 		= moImage.GetNumRows();
		int nCols 		= moImage.GetNumCols();		
		int nNewLayer 	= ml.GetPage().AddLayer();
		if(nNewLayer <= 0)
			return false;
		
		//split RGB
		MatrixLayer mlNew = ml.GetPage().Layers(nNewLayer);	
		mlNew.SetSize(3, nRows, nCols);
		MatrixObject mRed(mlNew, 0);
		MatrixObject mGreen(mlNew, 1);
		MatrixObject mBlue(mlNew, 2);
		Image imgRGB(moImage);
		Image imgR(mRed);
		Image imgG(mGreen);
		Image imgB(mBlue);
		FUNC_IMAGE_SPLIT_RGB pfn = Project.FindFunction("image_split_rgb", "Originlab\\matdata_utils.c", TRUE);
		if(!pfn)
			return false;		
		pfn(imgRGB, imgR, imgG, imgB);
		imgR.CopyTo(mRed, true);
		imgG.CopyTo(mGreen, true);
		imgB.CopyTo(mBlue, true);
		mRed.SetInternalData(FSI_DOUBLE);	
		mGreen.SetInternalData(FSI_DOUBLE);	
		mBlue.SetInternalData(FSI_DOUBLE);	
		
		//get the biggest contrast one
		bool 	bByRow 	= false;
		double 	dSDMax 	= 0;
		int		nMat 	= -1;
		foreach(MatrixObject mat in mlNew.MatrixObjects)
		{
			vector vv;
			mat.GetDataObject().GetAsVector(vv, bByRow);
			
			int nN;
			double dMean, dSD;
			ocmath_basic_summary_stats(vv.GetSize(), vv, &nN, &dMean, &dSD);
			if(dSDMax < dSD)
			{
				dSDMax = dSD;
				nMat = mat.GetIndex();
			}
		}
		if(dSDMax <= 0)
			return false;	
		MatrixObject mobj = mlNew.MatrixObjects(nMat);
		mobj.GetRangeString(m_pData->strMatrixObj, NTYPE_SHORT_NAME_ONLY);
		
		//normalize
		vector vZ;
		Matrix& Mat = mobj.GetDataObject();	
		Mat.GetAsVector(vZ, bByRow);
		vZ = 255 - vZ;//assumw the data points' value is samll and the background is big
		double dMin, dMax;
		vZ.GetMinMax(dMin, dMax);
		double dSub 		= dMin;
		double dNormalizeVal= dMax - dMin;		
		double dFactor 		= (is_equal(0.0, dNormalizeVal)) ? NANUM : 1.0 / dNormalizeVal;	
		vZ -= dSub;
		vZ *= dFactor;		
		Mat.SetByVector(vZ, bByRow);
		
		Mat.SetXMin(0);
		Mat.SetXMax(m_pData->nImageWidth);
		Mat.SetYMin(0);
		Mat.SetYMax(m_pData->nImageHeight);

		return true;
	}
	void DestroyImageMatrix()
	{
		MatrixObject mobj;
		okxf_resolve_string_get_origin_object(m_pData->strMatrixObj, &mobj);
		if(mobj)
		{
			MatrixLayer ml;
			mobj.GetParent(ml);
			ml.GetPage().Destroy();
		}
	}
	bool OptimizePoint(double& x,  double& y)
	{		
		int nCtrCol0, nCtrRow0;
		MatrixObject mobj;
		okxf_resolve_string_get_origin_object(m_pData->strMatrixObj, &mobj);
		if( !mobj || !convertXYToColRow(mobj, x, y, nCtrCol0, nCtrRow0) )
			return false;
		
	    MatrixLayer ml;
	    mobj.GetParent(ml);
	    Matrix MatSource( ml, mobj.GetIndex() );
	    int nCol, nRow;
	    FUNC_MATRIX_FIND_PEAK_CENTER pfn = Project.FindFunction("matrix_find_peak_center", "Originlab\\nlsf_utils.c", TRUE);
		if(!pfn)
			return false;		
		if( 0 != pfn(MatSource, nCtrRow0, nCtrCol0, nRow, nCol) )
			return false;
		x = MatSource.GetXValue(nCol);
		y = MatSource.GetYValue(nRow);
		
		return true;
	}
	///End OPTIMIZE_PICKED_POINT
private:
	BOOL	Calculate(vector& vx, vector& vy, BOOL bReverse = FALSE)
	{
		DigitizerCoordinates&		x1 = m_pData->x1;
		DigitizerCoordinates&		x2 = m_pData->x2;
		DigitizerCoordinates&		y1 = m_pData->y1;
		DigitizerCoordinates&		y2 = m_pData->y2;

		double		aa, bb;
		if ( LINEAR_SPACE == m_pData->axisX.nScaleType )
		{
			aa = (x1.value - x2.value) / (x1.nx - x2.nx);
			bb = x1.value - aa * x1.nx;
			if ( bReverse )
			{
				if ( aa != 0 )
					vx = (vx - bb) / aa;
			}
			else
			{
				vx = aa * vx + bb;
			}
		}
		else if ( LOG10_SPACE == m_pData->axisX.nScaleType )
		{
			aa = (log10(x1.value) - log10(x2.value)) / (x1.nx - x2.nx);
			bb = log10(x1.value) - aa * x1.nx;
			if ( bReverse )
			{
				if ( aa != 0 )
					vx = (log10(vx) - bb) / aa;
			}
			else
			{
				vx = 10 ^ (aa * vx + bb);
			}
		}

		if ( LINEAR_SPACE == m_pData->axisY.nScaleType )
		{
			aa = (y1.value - y2.value) / (y1.ny - y2.ny);
			bb = y1.value - aa * y1.ny;
			if ( bReverse )
			{
				if ( aa != 0 )
					vy = (vy - bb) / aa;
			}
			else
			{
				vy = aa * vy + bb;
			}
		}
		else if ( LOG10_SPACE == m_pData->axisY.nScaleType )
		{
			aa = (log10(y1.value) - log10(y2.value)) / (y1.ny - y2.ny);
			bb = log10(y1.value) - aa * y1.ny;
			if ( bReverse )
			{
				if ( aa != 0 )
					vy = (log10(vy) - bb) / aa;
			}
			else
			{
				vy = 10 ^ (aa * vy + bb);
			}
		}

		return TRUE;
	}
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT		
	bool convertXYToColRow(const MatrixObject& mobj, double x, double y, int& nCol, int& nRow)
	{
		double dXMin, dYMin, dXMax, dYMax;
		mobj.GetXY(dXMin, dYMin, dXMax, dYMax);
		vector vX, vY;
		vX.Data(dXMin, dXMax, (dXMax - dXMin)/(mobj.GetNumCols() - 1));
		vY.Data(dYMin, dYMax, (dYMax - dYMin)/(mobj.GetNumRows() - 1));
		vector<uint> vnX, vnY;
		if(	0 >= vX.Find(MATREPL_TEST_EQUAL|MATREPL_TEST_GREATER, x, vnX) ||
			0 >= vY.Find(MATREPL_TEST_EQUAL|MATREPL_TEST_GREATER, y, vnY) )
		{
			return error_report("x\y is out of range");
		}	
		
		nRow = vnY[0];
		nCol = vnX[0];
		return true;
	}
	///End OPTIMIZE_PICKED_POINT
	
private:
	DigitizerImplData*		m_pData;
};

class DigitizerDataDumpingHelper
{
public:
	DigitizerDataDumpingHelper(DigitizerImplData& data, HWND hWnd)
	{
		m_pData = &data;
		m_hWnd = hWnd;
	}
	~DigitizerDataDumpingHelper()
	{
	}

	BOOL	Dump(BOOL bPlot = FALSE)
	{
		return PrepareAll() && DumpImpl(bPlot);
	}

	BOOL	Go()
	{
		return PrepareAll() && m_wks.CheckShowActivate();
	}

	BOOL	GoToGraph()
	{
		if ( !PrepareAll(FALSE) )
			return FALSE;

		GraphLayer		gl = GetDigitizerPlotLayer(PlotRange(), FALSE);
		if ( !gl )
			return FALSE;
		return gl.CheckShowActivate();
	}

	BOOL	Clear()
	{
		if ( !PrepareAll(FALSE) )
			return FALSE;

		GraphLayer		gl = GetDigitizerPlotLayer(PlotRange(), FALSE);
		if ( gl )
			gl.Destroy();
		
		return m_wks.Destroy();
	}

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	CheckUpdateDataFromOutput(DatasetObject& dsObj)
	{
		if ( !PrepareAll(FALSE) )
			return FALSE;

		if ( !IsOutput(dsObj) )
			return FALSE;

		ERR_MSG(dsObj.GetName());
		m_pData->PtsX = m_colX.GetDataObject();
		m_pData->PtsY = m_colY.GetDataObject();
		m_colLabel.GetStringArray(m_pData->PtsLabel);
		return TRUE;
	}
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
private:
	BOOL	PrepareAll(BOOL bCreate = TRUE)
	{
		string	strBook, strSheet, strCol;
		return ParseRange(strBook, strSheet, strCol) && PrepareWorksheet(strBook, strSheet, bCreate) && PrepareColumns(strCol);
	}
	
	BOOL	ParseRange(string& strBook, string& strSheet, string& strCol)
	{
		return okutil_parse_complete_range_string(GetDataName(), &strBook, &strSheet, &strCol)
			&& !strBook.IsEmpty() 
			&& !strSheet.IsEmpty() 
			&& !strCol.IsEmpty();
	}

	BOOL	PrepareWorksheet(LPCSTR lpcszBook, LPCSTR lpcszSheet, BOOL bCreate = TRUE)
	{
		if ( !bCreate )
			return m_wks.Attach(okutil_make_book_sheet_string(lpcszBook, lpcszSheet));
		
		BOOL	bIsNewCreated = FALSE;
		attach_or_create_sheet(m_wks, okutil_make_book_sheet_string(lpcszBook, lpcszSheet), GetPageCreateOptions(), false, &bIsNewCreated);
		if ( m_wks && bIsNewCreated )
		{
			m_wks.SetSize(-1, 0);
			UpdateDataNameByNewSheetName(m_wks.GetName());		//Tony 8/29/2012 In case too long image name
		}
		return m_wks.IsValid();
	}

	BOOL	PrepareColumns(LPCSTR lpcszCol)
	{
		///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
		//m_colY = m_wks.FindCol(lpcszCol);
		GetYColumn(lpcszCol);
		///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

		if ( m_colY )
		{
			///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
			string		strLongName = m_colY.GetLongName();
			if ( strLongName.Compare(lpcszCol) != 0 )
			{
				m_pData->SetDataName(m_wks.m_strBookSheet, strLongName);
			}
			///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

			int		nXIndex = m_wks.FindColIndex(m_colY.GetIndex(), OKDATAOBJ_DESIGNATION_X, FCI_DEPENDENT);
			if ( nXIndex >= 0 )
			{
				m_colX = m_wks.Columns(nXIndex);
			}
			else
			{
				string	strX;
				m_wks.InsertCol(m_colY.GetIndex(), NULL, strX);
				m_colX = m_wks.Columns(strX);
			}
		}
		else
		{
			m_colX = m_wks.Columns(m_wks.AddCol());
			m_colX.SetType(OKDATAOBJ_DESIGNATION_X);
			m_colY = m_wks.Columns(m_wks.AddCol());
			m_colY.SetLongName(lpcszCol);
		}
		///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
		m_pData->SetDataUID(m_colY.GetUID(TRUE));
		///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

		if ( m_hWnd )
		{
			Window	wnd(m_hWnd);
			wnd.SendMessage(ID_DIGITIZER_MSG_SAVE_SETTINGS);
		}

		///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
		GetLabelColumn();
		///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

		PrepareColumnFormat(m_colX, &m_pData->axisX);
		PrepareColumnFormat(m_colY, &m_pData->axisY);
		return m_colX && m_colY;
	}

	void	PrepareColumnFormat(Column& col, DigitizerAxisData* pAxisData)
	{
		if ( OKCOLTYPE_NUMERIC != pAxisData->nFormat )
		{
			col.SetFormat(pAxisData->nFormat, pAxisData->nSubFormat);
			if ( OKCOLTYPE_DATE == pAxisData->nFormat && LDF_OBJ_CUSTOM == pAxisData->nSubFormat || OKCOLTYPE_TIME == pAxisData->nFormat && LTF_OBJ_CUSTOM == pAxisData->nSubFormat )
				col.SetCustomDisplay(pAxisData->strCustomDisplay);
		}
	}

	#define			STR_LINEAR_SCALE		_L("Linear Scale")
	#define			STR_LOG10_SCALE			_L("Log10 Scale")
	BOOL	DumpImpl(BOOL bPlot)
	{
		ERR_MSG("DigitizerDataDumpingHelper::DumpImpl");
		if ( !m_colX || !m_colY )
			return FALSE;

		string	strLinear = STR_LINEAR_SCALE;
		string	strLog10 = STR_LOG10_SCALE;

		int		nLabel = CheckGetLabelRow();
		m_colX.SetExtendedLabel(LINEAR_SPACE == m_pData->axisX.nScaleType ? strLinear : strLog10, nLabel);
		m_colY.SetExtendedLabel(LINEAR_SPACE == m_pData->axisY.nScaleType ? strLinear : strLog10, nLabel);

		vectorbase&	vx = m_colX.GetDataObject();
		vectorbase&	vy = m_colY.GetDataObject();
		vx = m_pData->PtsX;
		vy = m_pData->PtsY;
		///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		m_colLabel.SetUpperBound(-1);
		m_colLabel.PutStringArray(m_pData->PtsLabel);
		///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

		return bPlot ? MakePlot() : TRUE;
	}

	int		CheckGetLabelRow()
	{
		return check_get_user_defined_label(m_wks, _L("Scale Type"));
	}

	BOOL	MakePlot()
	{
		XYRange			xy = PlotRange();
		GraphLayer		gl = GetDigitizerPlotLayer(xy);
		/// Iris 7/25/2012 ORG-6310 SET_DATA_PLOT_WITH_DIFFERENT_COLOR
		//return plot_xyr_to_graph(xy, gl, IDM_PLOT_LINESYMB) && UpdateLayerScaleType(gl) && UpdateLabels() && Rescale(gl);
		DataPlot dp;
		if( !plot_xyr_to_graph(xy, gl, IDM_PLOT_LINESYMB, SYSCOLOR_BLACK, dp) )
			return FALSE;		
		// there are data plots for each picked points, one is picked data, another is the lable plot
		dp.SetColor( SYSCOLOR_RED + ( dp.GetIndex() / 2 ) ); 		
		
		return UpdateLayerScaleType(gl) && UpdateLabels() && Rescale(gl);		
		///End SET_DATA_PLOT_WITH_DIFFERENT_COLOR		
	}

	XYRange	PlotRange()
	{
		XYRange	xy;
		xy.Add(m_wks, m_colX.GetIndex(), "X");
		xy.Add(m_wks, m_colY.GetIndex(), "Y");
		///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
		xy.Add(m_wks, m_colLabel.GetIndex(), "L");
		///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
		xy.Add("S", NULL);
		return xy;
	}

	#define		STR_SOURCE_IMAGE			"sourceimage"
	#define		STR_DIGITIZER_PLOT_PAGE		STR_DIGITIZER_DATA_PLOT_NAME
	#define		STR_DIGITIZER_PLOT_PAGE_LN	STR_SOURCE_IMAGE " : %s"
	GraphLayer	GetDigitizerPlotLayer(XYRange& xy, BOOL bCreate = TRUE)
	{
		string		strLongName;
		strLongName.Format(STR_DIGITIZER_PLOT_PAGE_LN, m_pData->strImageName);
		foreach ( PageBase pg in Project.Pages )
		{
			GraphPage	gp(pg);
			if ( !gp )
				continue;

			if ( gp.GetName().Find(STR_DIGITIZER_PLOT_PAGE) == 0 )
			{
				if ( strLongName.Compare(gp.GetLongName()) == 0 )
					return gp.Layers();
			}
		}
		if ( !bCreate )
		{
			GraphLayer	glDummy;
			return glDummy;
		}
		
		GraphPage		gp;
		gp.Create("Origin", GetPageCreateOptions());
		gp.SetName(STR_DIGITIZER_PLOT_PAGE, OCD_ENUM_NEXT);
		///------ Folger 02/22/2011 ORG-2309-P1 NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
		//gp.SetLongName(strLongName);
		gp.SetLongName(strLongName, FALSE);
		///------ End NEVER_RENAME_PAGE_SHORT_NAME_BY_LONG_NAME_IN_DIGITIZER
		return gp.Layers();
	}
	
	//Tony 8/29/2012 In case too long image name
	BOOL	UpdateDataNameByNewSheetName(string &strNewSheetName)
	{
		return m_pData->UpdateDataNameByNewSheetName(strNewSheetName);
	}
	//end
	
	BOOL	UpdateLayerScaleType(GraphLayer& gl)
	{
		LT_execute("sec -p 0.05");
		
		string		strScaleType;
		strScaleType.Format("layer.X.Type=%d;layer.Y.Type=%d;", m_pData->axisX.nScaleType + 1, m_pData->axisY.nScaleType + 1);
		return gl.LT_execute(strScaleType);
	}
	
	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	BOOL	UpdateLabels()
	{
		GraphLayer		gl = GetDigitizerPlotLayer(PlotRange(), FALSE);
		if ( gl )
		{
			string		strScript;
			strScript.Format("set %s -tx 50;", m_colLabel.GetDatasetName());
			gl.LT_execute(strScript);
		}
		return TRUE;
	}
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	
	BOOL	Rescale(GraphLayer& gl)
	{
		BOOL	bReturn = gl.Rescale();
		if ( !bReturn )
			return FALSE;

		double	rTemp;
		if ( m_pData->x1.value > m_pData->x2.value && gl.X.From < gl.X.To )
		{
			SWAP(gl.X.From, gl.X.To, rTemp);
		}
		if ( m_pData->y1.value > m_pData->y2.value && gl.Y.From < gl.Y.To )
		{
			SWAP(gl.Y.From, gl.Y.To, rTemp);
		}
		return bReturn;
	}

	string		GetDataName()
	{
		return m_pData->GetDataName();
	}

	DWORD		GetPageCreateOptions()
	{
		return CREATE_NACTIVE | CREATE_LOAD_1ST_LAYER_ONLY;
	}

	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	void		GetLabelColumn()
	{
		int		nLabelcolIndex = m_colY.GetIndex() + 1;
		if ( !m_colLabel.Attach(m_wks, nLabelcolIndex) || !m_colLabel || OKDATAOBJ_DESIGNATION_L != m_colLabel.GetType() )
		{
			string		strName;
			m_wks.InsertCol(nLabelcolIndex, NULL, strName);
			m_colLabel.Attach(m_wks, nLabelcolIndex);
			m_colLabel.SetType(OKDATAOBJ_DESIGNATION_L);
		}
	}
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 12/29/2010 ORG-1881-P1 RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID
	void		GetYColumn(LPCSTR lpcszCol)
	{
		m_colY = m_wks.FindCol(lpcszCol);
		if ( m_colY )
			return;

		m_colY = Project.GetObject(m_pData->GetDataUID());
		if ( !m_colY )
			return;

		Worksheet	wks;
		m_colY.GetParent(wks);
		if ( !is_same_layer(wks, m_wks) )
		{
			Column	colJunk;
			m_colY = colJunk;
		}
	}
	///------ End RECOGNIZE_OUTPUT_COLUMNS_BY_BOTH_LN_AND_UID

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	IsOutput(DatasetObject& dsObj)
	{
		if ( !PrepareAll(FALSE) )
			return FALSE;
		
		string		str = dsObj.GetName();
		if ( m_colX.GetDatasetName().CompareNoCase(str) == 0 )
			return TRUE;
		
		if ( m_colY.GetDatasetName().CompareNoCase(str) == 0 )
			return TRUE;
		
		if ( m_colLabel.GetDatasetName().CompareNoCase(str) == 0 )
			return TRUE;
		
		return FALSE;
	}
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

private:
	DigitizerImplData*		m_pData;
	Worksheet				m_wks;
	Column					m_colX, m_colY;
	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	Column					m_colLabel;
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	HWND					m_hWnd;
};

#define		STR_SETTINGS_STORAGE_BACKUP		STR_IMAGE_NAME "Backup"
class DigitizerPickPointHelper
{
public:
	DigitizerPickPointHelper(DigitizerImplData& data)
	{
		m_pData = &data;
		m_glOriginal = Project.ActiveLayer();
	}
	~DigitizerPickPointHelper()
	{
	}

	BOOL	IsDataBackup(TreeNode* ptrSettings = NULL)
	{
		Tree	tr;
		BOOL	bReturn = m_glOriginal.GetBinaryStorage(STR_SETTINGS_STORAGE_BACKUP, tr);
		if ( ptrSettings )
			*ptrSettings = tr;
		return bReturn;
	}

	BOOL	HasPickedPoint()
	{
		Tree	tr;
		if ( !IsDataBackup(&tr) )
			return FALSE;

		DigitizerImplData	data;
		data = tr;
		return data.Size() != m_pData->Size();
	}

	BOOL	CheckRestore()
	{
		Tree	tr;
		if ( !IsDataBackup(&tr) )
			return FALSE;

		*m_pData = tr;
		return ClearBackup();
	}

	BOOL	ClearBackup()
	{
		return m_glOriginal.SetMemory(STR_SETTINGS_STORAGE_BACKUP, NULL);
	}

	BOOL	CheckBackupData()
	{
		Layer	lay = Project.ActiveLayer();
		if ( is_same_layer(m_glOriginal, lay) )
		{
			CheckRestore();
			return FALSE;
		}

		if ( IsDataBackup() )
			return TRUE;

		Tree	tr;
		tr = *m_pData;
		return m_glOriginal.PutBinaryStorage(STR_SETTINGS_STORAGE_BACKUP, tr);
	}

private:
	DigitizerImplData*		m_pData;
	Layer					m_glOriginal;
};

static bool _update_color(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	GetNOptionEventHelper	eventHelper(dwCntrl);
	if ( !eventHelper.IsInit() )
	{
		theDlg.PostMessage(WM_COMMAND, MAKELONG(IDOK, BN_CLICKED));
	}	
	return true;
}

#define		STR_DLG_NAME		"Digitizer"
#define		STR_DLG_NAME_L		_L("Digitizer")
#define		STR_DUMP_DATA_NAME	"DumpData"

class	Digitizer;
static	Digitizer*	g_pDigitizerOld = NULL;

class DigitizerImpl
{
public:
	DigitizerImpl()
	{
		m_hWnd = NULL;
		m_bDigitizing = FALSE;

		m_pVisualizer = NULL;
		m_pImage = NULL;
		m_pRotate = NULL;
		m_pOptions = NULL;
		m_pRunner = NULL;
		m_pDumping = NULL;
	}
	~DigitizerImpl()
	{
		NICE_SAFE_REMOVAL(m_pVisualizer);
		NICE_SAFE_REMOVAL(m_pImage);
		NICE_SAFE_REMOVAL(m_pRotate);
		NICE_SAFE_REMOVAL(m_pOptions);
		NICE_SAFE_REMOVAL(m_pRunner);
		NICE_SAFE_REMOVAL(m_pDumping);
	}

	void	SetHwnd(HWND hWnd)
	{
		m_hWnd = hWnd;
	}
	
	HWND	GetHwnd()
	{
		return m_hWnd;
	}

	/// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	BOOL	SetFocusOnGraph()
	{
		GraphLayer gl = GetDigitizeLayer();
		if( gl )
		{
			Page pg = gl.GetPage();
			Window wndPage = pg.GetWindow();
			HWND hwnd = wndPage.GetSafeHwnd();
			return NULL != SetFocus(hwnd);
		}
		return FALSE;
	}
	///End SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	
	BOOL	Save()
	{
		if ( !HasValidDigitizeImage() )
			return FALSE;

		return SaveSettings();
	}
	
	BOOL	Load()
	{
		if ( !HasValidDigitizeImage() )
			return FALSE;

		return LoadSettings();
	}
	
	GraphLayer	GetDigitizeLayer()
	{
		return m_objsHolder.GetDigitizeLayer();
	}

	BOOL	IsCoorReady(IMPLDATA type)
	{
		switch ( type )
		{
		case IMPLDATA_X1:
			return m_data.IsCoornianteReady(m_data.x1);
			
		case IMPLDATA_X2:
			return m_data.IsCoornianteReady(m_data.x2);
			
		case IMPLDATA_Y1:
			return m_data.IsCoornianteReady(m_data.y1);
			
		case IMPLDATA_Y2:
			return m_data.IsCoornianteReady(m_data.y2);
			
		case IMPLDATA_XREF:
			return m_data.IsCoornianteReady(m_data.x1) && m_data.IsCoornianteReady(m_data.x2);
			
		case IMPLDATA_YREF:
			return m_data.IsCoornianteReady(m_data.y1) && m_data.IsCoornianteReady(m_data.y2);
			
		default:
			O_A_FAIL;
			break;
		}

		return FALSE;
	}

	BOOL	SetData(IMPLDATA type, LPCSTR lpcsz)
	{
		LoadSettings();
		
		double*					prVal = NULL;
		DigitizerAxisData*		pAxisData = NULL;
		switch ( type )
		{
		case IMPLDATA_X1:
			prVal = &m_data.x1.value;
			pAxisData = &m_data.axisX;
			break;

		case IMPLDATA_X2:
			prVal = &m_data.x2.value;
			pAxisData = &m_data.axisX;
			break;

		case IMPLDATA_Y1:
			prVal = &m_data.y1.value;
			pAxisData = &m_data.axisY;
			break;

		case IMPLDATA_Y2:
			prVal = &m_data.y2.value;
			pAxisData = &m_data.axisY;
			break;

		default:
			O_A_FAIL;
			return FALSE;
		}

		*prVal = m_data.GetValue(lpcsz, pAxisData);
		return UpdateAxes() && RecalculateAndDump();
	}

	BOOL	SetScaleType(IMPLDATA type, int nValue)
	{
		LoadSettings();
		switch ( type )
		{
		case IMPLDATA_X1:
		case IMPLDATA_X2:
			m_data.axisX.nScaleType = nValue;
			break;
			
		case IMPLDATA_Y1:
		case IMPLDATA_Y2:
			m_data.axisY.nScaleType = nValue;
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}
		return RecalculateAndDump() && UpdateInfo();
	}

	BOOL	SetAxisPixel(IMPLDATA type, int nValue)
	{
		LoadSettings();
		return Visualizer()->SetAxisPixel(type, nValue) && OnAfterAxesChange();
	}

	BOOL	SetAxisColor(IMPLDATA type)
	{
		LoadSettings();
		int*	pnColor = NULL;
		switch ( type )
		{
		case IMPLDATA_X1:
			pnColor = &m_data.x1.color;
			break;
			
		case IMPLDATA_X2:
			pnColor = &m_data.x2.color;
			break;
			
		case IMPLDATA_Y1:
			pnColor = &m_data.y1.color;
			break;
			
		case IMPLDATA_Y2:
			pnColor = &m_data.y2.color;
			break;

		case IMPLDATA_XREF:
			pnColor = &m_data.axisY.nColor;
			break;

		case IMPLDATA_YREF:
			pnColor = &m_data.axisX.nColor;
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}

		GETN_TREE(tr)
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
		GETN_CUSTOM_BUTTON("OK=|Cancel=")
		GETN_COLOR(Color, "", *pnColor)						GETN_OPTION_EVENT_EX(_update_color)
		if ( !GetNBox(tr, _L("Color"), NULL, NULL, NULL, GetHwnd()) )
			return FALSE;

		*pnColor = tr.Color.nVal;
		return UpdateAxes() && SaveSettings();
	}

	BOOL	SetAxisSelection(IMPLDATA type)
	{
		return Visualizer()->SetAxisSelection(type);
	}

	IMPLDATA	GetAxisSelection()
	{
		return Visualizer()->GetAxisSelection();
	}

	void	GetInfoNames(vector<string>& vs)
	{
		Visualizer()->GetAxesNames(vs);
	}

	void	GetInfoColors(vector<uint>& vn)
	{
		LoadSettings();
		Visualizer()->GetAxesColors(vn);
	}

	void	GetInfoScales(vector<string>& vs)
	{
		LoadSettings();
		vs.SetSize(IMPLDATA_TOTAL);
		vs[IMPLDATA_X1] = m_data.GetValue(m_data.x1, &m_data.axisX);
		vs[IMPLDATA_X2] = m_data.GetValue(m_data.x2, &m_data.axisX);
		vs[IMPLDATA_Y1] = m_data.GetValue(m_data.y1, &m_data.axisY);
		vs[IMPLDATA_Y2] = m_data.GetValue(m_data.y2, &m_data.axisY);

		GetX0Y0(vs[IMPLDATA_XREF], vs[IMPLDATA_YREF]);
	}

	/// Iris 7/25/2012 /ORG-6324-S1 TO_IMPROVE_AXIS_VALIE_EDITING
	int		GetInfoDataType(bool bIsX)
	{
		LoadSettings();
		return bIsX ? m_data.axisX.nFormat : m_data.axisY.nFormat;		
	}
	///End TO_IMPROVE_AXIS_VALIE_EDITING
	
	void	GetInfoPixels(vector<string>& vs)
	{
		LoadSettings();
		Visualizer()->GetAxesPixels(vs);
	}

	void	GetInfoScaleTypes(vector<string>& vs)
	{
		LoadSettings();
		vs.SetSize(IMPLDATA_TOTAL);
		vs[IMPLDATA_X1] = m_data.axisX.nScaleType;
		vs[IMPLDATA_Y1] = m_data.axisY.nScaleType;
	}

	BOOL	GetX0Y0(string& x, string& y)
	{
		LoadSettings();
		double		xx, yy;
		GetX0Y0(xx, yy);
		x = m_data.GetValue(xx, &m_data.axisX);
		y = m_data.GetValue(yy, &m_data.axisY);
		return TRUE;
	}

	string	GetAxisScaleHint(IMPLDATA type)
	{
		LoadSettings();
		int		nSpace = 0;
		switch ( type )
		{
		case IMPLDATA_X1:
		case IMPLDATA_X2:
			nSpace = m_data.axisX.nScaleType;
			break;
			
		case IMPLDATA_Y1:
		case IMPLDATA_Y2:
			nSpace = m_data.axisY.nScaleType;
			break;
			
		default:
			O_A_FAIL;
			break;
		}

		switch ( nSpace )
		{
		case LINEAR_SPACE:
			return STR_LINEAR_SCALE;

		case LOG10_SPACE:
			return STR_LOG10_SCALE;

		default:
			break;
		}
		return "";
	}

	BOOL	SaveAxesSettings(TreeNode& tr)
	{
		Tree	trSettings;
		PrepareAxesSettings(trSettings);

		vector<int>		vnIDs;
		vector<string>	vsValues;
		vector<string>	vsLabels;
		return octree_get_values_with_ids(&trSettings, &vnIDs, &vsValues, &vsLabels) > 0 && octree_save_values_with_ids(&tr, &vnIDs, &vsValues, "", &vsLabels);
	}

	BOOL	LoadAxesSettings(TreeNode& tr)
	{
		Tree	trSettings;
		PrepareAxesSettings(trSettings);

		vector<int>		vnIDs;
		vector<string>	vsValues;
		string			str;
		if ( !octree_get_theme(&tr, &vnIDs, &vsValues, &str) || !tree_set_values_by_ids(trSettings, vnIDs, vsValues) )
			return FALSE;
		
		m_data = trSettings;
		return OnAfterAxesChange();
	}

	BOOL	IsX1FromYAxis()
	{
		return m_data.IsX1FromYAxis();
	}

	BOOL	IsY1FromXAxis()
	{
		return m_data.IsY1FromXAxis();
	}

	BOOL	ImportImage()
	{
		return ImageHelper()->Import()
			&& UpdateAxes()
			&& SaveSettings();
	}
	
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	ImportImageFromClipboard()
	{
		return ImageHelper()->ImportFromClipboard()
			&& UpdateAxes()
			&& SaveSettings();
	}
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	
	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	BOOL	Rotate(BOOL bOn)
	{
		LoadSettings();
		RotateHelper()->Update(bOn);
		if ( SetAxisEditingByOther(bOn, FALSE, IMPLDATACNTRL_AXIS_EDITING_BY_ROTATE, TRUE) )
			return TRUE;
		
		return SaveSettings();
	}

	BOOL	SetRotationMode(BOOL bOn)
	{
		LoadSettings();
		m_data.SetRotationMode(bOn);
		return SaveSettings();
	}

	BOOL	IsRotationMode()
	{
		LoadSettings();
		return m_data.IsRotationMode();
	}
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	SetLabelEditing(BOOL bOn)
	{
		LoadSettings();
		Visualizer()->SetLabelEditing(bOn);
		
		if ( SetAxisEditingByOther(bOn, TRUE, IMPLDATACNTRL_AXIS_EDITING_BY_LABEL_EDITING) )
			return TRUE;
		return SaveSettings();;
	}

	BOOL	IsLabelEditing()
	{
		LoadSettings();
		return m_data.IsLabelEditing();
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	BOOL	ChangeOptions()
	{
		LoadSettings();		
		return OptionsHelper()->Update() && RecalculateAndDump();
	}
	
	BOOL	Digitize()
	{
		if ( m_bDigitizing )
			return FALSE;

		m_bDigitizing = TRUE;
		
		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		m_data.bDigitizing = m_bDigitizing;
		SaveSettings();
		///End OPTIMIZE_PICKED_POINT
		
		BOOL	bReturn = Digitizing();
		m_bDigitizing = FALSE;
		
		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		m_data.bDigitizing = m_bDigitizing;
		if ( HasValidDigitizeImage() )
			SaveSettings();
		///End OPTIMIZE_PICKED_POINT
		
		return bReturn;
	}

	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	BOOL	IsImageDigitizing(){return m_data.bDigitizing;}
	///End OPTIMIZE_PICKED_POINT
	
	BOOL	NewData()
	{
		return Visualizer()->NewData() && SaveSettings();
	}

	BOOL	GotoData()
	{
		return  DumpingHelper()->Go();
	}

	BOOL	GotoGraph()
	{
		return  DumpingHelper()->GoToGraph();
	}

	BOOL	DelWksGraph()
	{
		if ( IDNO == MessageBox(GetHwnd(), _L("The digitized points, worksheet and graph will be deleted.\r\nAre you sure ?"), ERROR_TITLE, MB_YESNO | MB_ICONEXCLAMATION) )
			return FALSE;

		return DumpingHelper()->Clear() && Visualizer()->ClearDataPlot() && SaveSettings();
	}

	BOOL	HasValidDigitizeImage()
	{
		GraphPage	gp = GetDigitizePage();
		if ( !gp || !m_objsHolder.IsPageValidToDigitize(gp) )
			return FALSE;

		return GetDigitizeImage().IsValid();
	}

	BOOL	HasDataPoint()
	{
		return Visualizer()->HasDataPoint();
	}

	BOOL	Update(BOOL bLoadSettingsOnly = FALSE)
	{
		LoadSettings();
		if ( bLoadSettingsOnly )
			return TRUE;
		return UpdateAxes() && UpdateDataPlot();
	}

	BOOL	UpdateOptions(TreeNode& tr, DWORD dwCntrl)
	{
		LoadSettings();
		BOOL	bReturn = OptionsHelper()->Update(tr, dwCntrl);
		if ( !bReturn )
			return FALSE;
		
		if ( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATA) )
			;
		else if ( O_QUERY_BOOL(dwCntrl, UPDATEOPTIONSFROM_DATANAME) )
			;
		else
			UpdateAxes();
		///------ Tony 08/28/2012 ORG-6305-P1 ADD_UPDATEOPTIONSFROM_COLOR_TO_AVOID_SETTING_COLOR
		//return SaveSettings();
		return TRUE;
		///------ End ADD_UPDATEOPTIONSFROM_COLOR_TO_AVOID_SETTING_COLOR
	}

	double	GetRotateInc()
	{
		LoadSettings();
		return m_data.rAngleInc;
	}

	BOOL	RotateImage(LPDOUBLE prAngle = NULL, LPDOUBLE prAngleInc = NULL)
	{
		LoadSettings();

		GetDigitizeImage().SetDIBHandle(m_objsHolder.GetDigitizeImageBackup().GetDIBHandle());
		if ( prAngle )
			m_data.rAngleRotated = *prAngle;
		if ( prAngleInc )
			m_data.rAngleInc = *prAngleInc;
		
		ImageObjTransformHelper		clHelper(GetDigitizeImage());
		return clHelper.Rotate(m_data.rAngleRotated, COLOR_WHITE) == 1 && SaveSettings();
	}

	BOOL	IsReadyToDigitize()
	{
		return Visualizer()->IsReadyToDigitize();
	}

	BOOL	UpdateFromEvents(int nEvent, LPCSTR lpcszName)
	{
		ObjsUpdateEventHelper	clHelper;
		if ( clHelper.IsDuringUpdate() )
			return FALSE;

		ERR_MSG("DigitizerImpl::UpdateFromEvents");
		LoadSettings();
		int		nUpdate = Visualizer()->UpdateFromEvents(nEvent, lpcszName);
		if ( UPDATEFROMEVENTS_NONE == nUpdate )
			return FALSE;

		return OE_SELECT == nEvent || OE_UNSELECT == nEvent ?
			UpdateInfoSelection() : (UPDATEFROMEVENTS_AXIS == nUpdate ? RecalculateAndDump() && UpdateInfo() : UpdatePlotFromEvent(nEvent)) && EnableDigitize();
	}

	BOOL	UpdateFromPlot(int nEvent)
	{
		LoadSettings();
		return Visualizer()->UpdateFromPlot(nEvent) && RecalculateAndDump(OE_DELETE == nEvent);
	}

	string	GetDataName()
	{
		return m_data.GetDataName();
	}

	BOOL	SetAxesEditing(BOOL bOn)
	{
		LoadSettings();
		return Visualizer()->SetAxesEditing(bOn) && SaveSettings();
	}

	BOOL	ShowXRefLine(BOOL bShow)
	{
		LoadSettings();
		return Visualizer()->ShowXRefLine(bShow) && SaveSettings();
	}

	BOOL	ShowYRefLine(BOOL bShow)
	{
		LoadSettings();
		return Visualizer()->ShowYRefLine(bShow) && SaveSettings();
	}

	BOOL	IsAxesEditing()
	{
		return m_data.IsAxisEditing();
	}

	BOOL	GetOnePoint(string& str, double x, double y)
	{
		LoadSettings();
		Runner()->CalculateOnePoint(x, y);
		str.Format("X = %s, Y = %s", m_data.GetValue(x), m_data.GetValue(y));
		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		if(m_data.OptimizeError != 0)
		{
			str += "\n" + _L("Optimization fails!");
			return FALSE;
		}
		///End OPTIMIZE_PICKED_POINT
		return TRUE;
	}
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	//BOOL	AddOnePoint(double x,  double y)
	BOOL	AddOnePoint(double& x,  double& y)
	{
		LoadSettings();
		
		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		m_data.OptimizeError = 0;
		if( IsOptimizePoint() )
		{
			if( !OptimizePoint(x, y) )
			{
				m_data.OptimizeError = -1;
				SaveSettings();
				return false;
			}
		}
		///End OPTIMIZE_PICKED_POINT
		
		return Visualizer()->AddOnePoint(x, y) && SaveSettings();
	}

	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	bool IsOptimizePoint(){return m_data.OptimizePoint;}
	bool OptimizePoint(double& x,  double& y)
	{
		return Runner()->OptimizePoint(x, y);
	}
	void DestroyImageMatrix()
	{
		if( !IsImageDigitizing() )
		{
			Runner()->DestroyImageMatrix();
			//out_str("DestroyImageMatrix="+GetDataName());
		}
		else
			;//out_str("no DestroyImageMatrix="+GetDataName());
	}
	///End OPTIMIZE_PICKED_POINT
	
	string	GetHint()
	{
		string		str;
		if ( HasValidDigitizeImage() )
		{
			LoadSettings();
			if ( IsAxesEditing() )
			{
				str = _L("Click Rotate button to rotate Image.\r\n\
					Drag the lines to known coordinates on image.\r\n\
					Enter those values in Axis Scale column.\r\n\
					Press s to select the X1 line, press tab to switch the selected line.\r\n\
					Click Pick New Points.");
			}
			///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
			else if ( IsLabelEditing() )
			{
				str = _L("Click : Select a point\r\n\
						Arrow Keys : Move the selected point\r\n\
						Double Click / Enter Key: Set Label for the point.\r\n\
						Del Key: Delete the label of the point.\r\n\
						Esc Key: De-select.");
			}
			///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
			else
			{
				str = Visualizer()->HasDataPoint() ? _L("Click : Select a point\r\n\
													Arrow Keys : Move the selected point\r\n\
													Tab Key : Switch to Next point (Shift-Tab = Previous)\r\n\
													Del Key : Delete selected\r\n\
													Esc Key: De-select")
													: _L("Click \"Pick New Points\" button to start digitize.");
			}
		}
		else
		{
			str = _L("Click \"Import\" button to import an image.");
		}
		return str;
	}

	#define		STR_DIGITIZER_TITLE		"%s - %s(%dx%d)"
	string	GetTitle()
	{
		string	str;
		str.Format(STR_DIGITIZER_TITLE, STR_DLG_NAME_L, m_data.strImageName, m_data.nImageWidth, m_data.nImageHeight);
		return str;
	}

	BOOL	CheckUpdateOnDlgShow(BOOL bShow)
	{
		if ( !HasValidDigitizeImage() )
			return FALSE;

		LoadSettings();
		CheckRestorePickPoints(bShow);
		
		if ( bShow == IsDlgOpen() )
			return TRUE;		

		ERR_MSG("CheckUpdateOnDlgShow");		
		m_data.SetDlgOpen(bShow);
		return CheckShowOpenDlgObj()
			&& CheckUpdateObjsStates()
			&& SaveSettings();
	}

	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	BOOL	DataPlotEdit(int nIndex)
	{
		LoadSettings();
		return Visualizer()->DataPlotEdit(nIndex) && DumpAndSave();
	}
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	UpdatePlotFromOutput(DatasetObject& dsObj, GraphLayer& gl)
	{
		if ( HasValidDigitizeImage() || !gl )
			return FALSE;

		DigitizerLayerTempChange	tempChange(&m_objsHolder, gl);

		if ( !LoadSettings() )
			return FALSE;

		if ( !DumpingHelper()->CheckUpdateDataFromOutput(dsObj) )
			return FALSE;

		if ( !Runner()->AntiCalculate() )
			return FALSE;

		return Visualizer()->UpdatePlotData() && SaveSettings();
	}
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

private:
	DigitizerVisualizer*		Visualizer()
	{
		if ( NULL == m_pVisualizer )
			m_pVisualizer = new DigitizerVisualizer(m_data, m_objsHolder);
		return m_pVisualizer;
	}

	DigitizerImageHelper*		ImageHelper()
	{
		if ( NULL == m_pImage )
			m_pImage = new DigitizerImageHelper(m_data, m_objsHolder);
		return m_pImage;
	}

	DigitizerRotationHelper*	RotateHelper()
	{
		if ( NULL == m_pRotate )
			m_pRotate = new DigitizerRotationHelper(m_data, GetHwnd());
		return m_pRotate;
	}

	DigitizerOptionsHelper*		OptionsHelper()
	{
		if ( NULL == m_pOptions )
			m_pOptions = new DigitizerOptionsHelper(m_data, GetHwnd());
		return m_pOptions;
	}

	DigitizerRunner*			Runner()
	{
		if ( NULL == m_pRunner )
			m_pRunner = new DigitizerRunner(m_data);
		return m_pRunner;
	}

	DigitizerDataDumpingHelper*	DumpingHelper()
	{
		if ( NULL == m_pDumping )
			m_pDumping = new DigitizerDataDumpingHelper(m_data, GetHwnd());
		return m_pDumping;
	}

	GraphPage	GetDigitizePage()
	{
		return m_objsHolder.GetDigitizePage();
	}
	
	GraphObject	GetDigitizeImage()
	{
		return m_objsHolder.GetDigitizeImage();
	}

	void		InitData()
	{
		m_data.Init();
	}

	#define		STR_SETTINGS_STORAGE		STR_IMAGE_NAME
	BOOL	SaveSettings()
	{
		Tree			tr;
		tr = m_data;
		return GetDigitizeImage().PutBinaryStorage(STR_SETTINGS_STORAGE, tr);
	}

	BOOL	LoadSettings()
	{
		Tree			tr;
		if ( !GetDigitizeImage().GetBinaryStorage(STR_SETTINGS_STORAGE, tr) )
		{
			InitData();
			return FALSE;
		}

		m_data = tr;
		return Visualizer()->UpdateFromPlot(GENERIC_UPDATE_EVENT);
	}

	BOOL	UpdateAxes(BOOL bRefresh = FALSE)
	{
		return Visualizer()->UpdateAxes(bRefresh);
	}
	
	BOOL	UpdateDataPlot(BOOL bRefresh = FALSE)
	{
		return Visualizer()->UpdateDataPlot(bRefresh);
	}

	BOOL	UpdatePlotFromEvent(int nEvent)
	{
		return NotifyDigitizer(ID_DIGITIZER_MSG_UPDATE_FROM_POINTS, TRUE, nEvent);
	}
	
	BOOL	UpdateInfo()
	{
		return NotifyDigitizer(ID_DIGITIZER_MSG_UPDATE_INFO);
	}

	BOOL	UpdateInfoSelection()
	{
		return NotifyDigitizer(ID_DIGITIZER_MSG_UPDATE_INFO_SELECTION, TRUE);
	}

	BOOL	EnableDigitize()
	{
		return NotifyDigitizer(ID_DIGITIZER_MSG_ENABLE_DIGITIZE, TRUE);
	}

	BOOL	NotifyDigitizer(int nMsg, BOOL bPost = FALSE, UINT wParam = 0, UINT lParam = 0)
	{
		if ( g_pDigitizerOld )
		{
			if ( bPost )
				g_pDigitizerOld->PostMessage(nMsg, wParam, lParam);
			else
				g_pDigitizerOld->SendMessage(nMsg, wParam, lParam);
		}

		return TRUE;
	}

	BOOL	RecalculateAndDump(BOOL bDumpEvenNotCalculate = FALSE)
	{
		if ( IsReadyToDigitize() )
		{
			if ( Runner()->Calculate() || bDumpEvenNotCalculate )
				return DumpAndSave();
		}
		
		return SaveSettings();
	}

	BOOL	DumpAndSave(BOOL bPlot = FALSE)
	{
		return DumpingHelper()->Dump(bPlot) && SaveSettings();
	}

	BOOL	IsDlgOpen()
	{
		return m_data.IsDlgOpen();
	}

	BOOL	CheckShowOpenDlgObj()
	{
		LPCSTR		lpcszOpenDlg = "OpenDlg";
		return m_objsHolder.SetObjText(lpcszOpenDlg, STR_DLG_NAME_L + STR_THREE_DOTS) && m_objsHolder.SetObjProperty(lpcszOpenDlg, "Show", !IsDlgOpen());
	}

	BOOL	CheckUpdateObjsStates()
	{
		if ( !IsDlgOpen() )
			Selection.Reset();

		return Visualizer()->UpdateStates();
	}

	BOOL	CheckRestorePickPoints(BOOL bDlgShow)
	{
		DigitizerPickPointHelper	clHelper(m_data);
		if ( !clHelper.IsDataBackup() )
			return TRUE;

		if ( bDlgShow )
			return NotifyDigitizer(WM_COMMAND, TRUE, MAKELONG(IDC_DIGITIZER_GO, BN_CLICKED), 0);
		
		return clHelper.CheckRestore() && UpdateDataPlot() && SaveSettings();
	}

	void	PrepareAxesSettings(TreeNode& tr)
	{
		LoadSettings();
		tr = m_data;
		octree_remove_attribute(&tr, STR_DATAID_ATTRIB);
		m_data.PrepareAxesTreeIDs(tr);
	}

	BOOL	OnAfterAxesChange()
	{
		return UpdateAxes() && RecalculateAndDump() && UpdateInfo() && UpdateRotation() && RotateImage();
	}

	BOOL	Digitizing()
	{
		LoadSettings();

		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		if( IsOptimizePoint() )
		{
			Runner()->PrepareImageMatrix();
			SaveSettings();
		}
		///End OPTIMIZE_PICKED_POINT
		
		DigitizerPickPointHelper		clHelper(m_data);
		int			nReturn = Runner()->Run(*g_pDigitizerOld);
		
		/////Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		//if( IsOptimizePoint() )
			//Runner()->DestroyImageMatrix();
		/////End OPTIMIZE_PICKED_POINT
		
		if ( nReturn > 0 || (0 == nReturn && clHelper.HasPickedPoint()) )
		{
			clHelper.ClearBackup();
			LoadSettings();
			Runner()->Calculate();
			return DumpAndSave(TRUE);
		}
		
		if ( clHelper.CheckBackupData() )
			return TRUE;
		return UpdateDataPlot() && SaveSettings();
	}

	BOOL	GetX0Y0(double& x, double& y)
	{
		return Visualizer()->GetX0Y0(x, y) && Runner()->CalculateOnePoint(x, y);
	}

	BOOL	SetAxisEditingByOther(BOOL bOn, BOOL bNot, DWORD dwBit, BOOL bAlways = FALSE)
	{
		if ( bOn && (bAlways || !XOR(IsAxesEditing(), bNot)) )
		{
			SetAxisEditingByOther(dwBit, TRUE);
			return SetAxesEditing(!bNot);
		}
		
		if ( !bOn && m_data.IsAxisEditingByOther(dwBit) )
		{
			SetAxisEditingByOther(dwBit, FALSE);
			return SetAxesEditing(bNot);
		}
		return FALSE;
	}

	void	SetAxisEditingByOther(DWORD dwBit, BOOL bOn)
	{
		m_data.SetAxisEditingByOther(dwBit, bOn);
		SaveSettings();
	}

	BOOL	UpdateRotation()
	{
		if ( IsRotationMode() )
			return Rotate(TRUE);
		
		SetAxisEditingByOther(FALSE, FALSE, IMPLDATACNTRL_AXIS_EDITING_BY_ROTATE);
		return TRUE;
	}
	
public:	
	///Jasmine 03/11/11 ORG-2286 KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
	void CleanRelativeData(LPCSTR lpczAttachPage)
	{
		GraphPage gp(lpczAttachPage);
		if(!gp)
			return;
		GraphLayer gl	= gp.Layers();
		GraphObject go 	= gl.GraphObjects(STR_IMAGE_NAME);
		Tree tr;
		go.GetBinaryStorage(STR_SETTINGS_STORAGE, tr);
		m_data = tr;
		DestroyImageMatrix();
	}
	///End KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
	
private:
	HWND							m_hWnd;
	BOOL							m_bDigitizing;

	DigitizerImplData				m_data;
	DigitizerObjsHolder				m_objsHolder;

	DigitizerVisualizer*			m_pVisualizer;
	DigitizerImageHelper*			m_pImage;
	DigitizerRotationHelper*		m_pRotate;
	DigitizerOptionsHelper*			m_pOptions;
	DigitizerRunner*				m_pRunner;
	DigitizerDataDumpingHelper*		m_pDumping;
		
};

#define		STR_COL_HEADING			_L("Name|Color|Axis Value|Image Pixel|Scale Type")
enum
{
	INFOLISTCOL_NAME		= 0,
	INFOLISTCOL_COLOR,
	INFOLISTCOL_SCALE,
	INFOLISTCOL_PIXEL,
	INFOLISTCOL_SCALETYPE,
};

#define		INFOLISTROW_OFFSET		1

enum
{
	INFOLISTROW_X1			= INFOLISTROW_OFFSET + IMPLDATA_X1,
	INFOLISTROW_X2,
	INFOLISTROW_Y1,
	INFOLISTROW_Y2,
	INFOLISTROW_XREF,
	INFOLISTROW_YREF,

	INFOLISTROW_TOTAL
};

enum
{
	INFOLISTUPDATE_SELECTION_ONLY			= 0x00000001,
	INFOLISTUPDATE_RESET_ROWS				= 0x00000002,
};

class DigitizerInfoList : public GridListControl
{
public:
	DigitizerInfoList(DigitizerImpl* pImpl)
	{
		m_pImpl = pImpl;
		m_nDuringUpdate = 0;
	}
	~DigitizerInfoList()
	{
	}

	void Init(int nID, Dialog& dlg)
	{
		++m_nDuringUpdate;
		GridListControl::Init(nID, dlg);
			
		SetupRowsCols();
		
		SetExtendLastCol(false);
		SetEditable(flexEDKbdMouse);
		
		SetColHeader(STR_COL_HEADING);
		SetColAlignment(-1, flexAlignCenterCenter);
		
		SetColHighlight(INFOLISTCOL_COLOR, FALSE);

		InitScaleTypes();

		UpdateRows();

		--m_nDuringUpdate;
	}

	BOOL	Update(DWORD dwCntrls = 0)
	{
		UpdateSelection();
		if ( O_QUERY_BOOL(dwCntrls, INFOLISTUPDATE_SELECTION_ONLY) )
			return TRUE;

		int		nSelectedRow = GetSelectedRow();		
		BOOL	bValidToDigitize = m_pImpl->HasValidDigitizeImage();
		BOOL	bResetRows = O_QUERY_BOOL(dwCntrls, INFOLISTUPDATE_RESET_ROWS);

		CheckShowRows(bValidToDigitize);
		if ( bValidToDigitize )
		{
			UpdateNames();
			UpdateColors();
			/// Iris 7/25/2012 /ORG-6324-S1 TO_IMPROVE_AXIS_VALIE_EDITING
			///Sophy 10/18/2012 ORG-7220-P1 IGNORE_CELL_FORMAT_IN_DIGITIZER_FOR_90SR0
			//SetCellsFormat();
			///end IGNORE_CELL_FORMAT_IN_DIGITIZER_FOR_90SR0
			///End TO_IMPROVE_AXIS_VALIE_EDITING
			UpdateScales();
			UpdatePixels();
			UpdateScaleTypes();
		}
		
		if ( bResetRows )
		{
			ResizeCols();
		}
		SelectRow(nSelectedRow);		
		return UpdateCellsColor();
	}
	
	/// Iris 7/25/2012 /ORG-6324-S1 TO_IMPROVE_AXIS_VALIE_EDITING
	void	SetCellsFormat()
	{
		for(int nRow = GetRowOffset(); nRow < GetCols(); ++nRow)
		{
			if( nRow >= INFOLISTROW_X1 && nRow <= INFOLISTROW_Y2 )
			{
				bool bIsX = nRow < INFOLISTROW_Y1;
				bool bIsDataType  = OKCOLTYPE_NUMERIC == m_pImpl->GetInfoDataType(bIsX);
				SetCell(bIsDataType? CellDataType_Double : CellDataType_None, flexcpDataType, nRow, INFOLISTCOL_SCALE);				
			}
		}
	}
	///End TO_IMPROVE_AXIS_VALIE_EDITING
	
	BOOL	UpdateSelectable(BOOL bResetRowSelection = FALSE)
	{
		BOOL	bIsAxesEditing = IsAxesEditing();
		if ( bResetRowSelection)
			SelectRow(0, !bIsAxesEditing);

		if ( bIsAxesEditing)
		{
			SetSelection(flexSelectionByRow);
		}
		else
		{
			SetSelection(flexSelectionFree);
		}
		return UpdateCellsColor();
	}

	void	OnBeforeEdit(long nRow, long nCol, BOOL* pCancel)
	{
		/// Iris 7/16/2012 ORG-6230-P1 FIX_TYPE_WITHOUT_SELECTION_WILL_UPDATE_COLUMN_LABEL
		if( nRow < GetRowOffset() || nRow >= GetRows() 
			|| nCol < GetColOffset() || nCol >= GetCols() )
		{
			ERR_MSG("Before edit, nRow = " + nRow + ", nCol = " + nCol);
			*pCancel = TRUE;
			return;
		}
		///End FIX_TYPE_WITHOUT_SELECTION_WILL_UPDATE_COLUMN_LABEL
			
		*pCancel = FALSE;	
		switch ( nCol )
		{
		case INFOLISTCOL_NAME:
			*pCancel = TRUE;
			break;

		case INFOLISTCOL_COLOR:
			*pCancel = TRUE;
			SetAxisColor(nRow - INFOLISTROW_OFFSET);
			break;
			
		case INFOLISTCOL_SCALE:
			*pCancel = INFOLISTROW_XREF == nRow || INFOLISTROW_YREF == nRow;
			break;

		case INFOLISTCOL_SCALETYPE:
			*pCancel = !(INFOLISTROW_X1 == nRow || INFOLISTROW_Y1 == nRow);
			break;

		case INFOLISTCOL_PIXEL:
			*pCancel = !IsAxesEditing() || !m_pImpl->IsCoorReady(nRow - INFOLISTROW_OFFSET);
			break;
			
		default:
			break;
		}
	}
	
	void	OnAfterEdit(int nRow, int nCol)
	{			
		string		str = GetCell(nRow, nCol);
		int			nType = nRow - INFOLISTROW_OFFSET;
		switch ( nCol )
		{
		case INFOLISTCOL_SCALE:
			switch ( nRow )
			{
			case INFOLISTROW_X1:
			case INFOLISTROW_X2:
			case INFOLISTROW_Y1:
			case INFOLISTROW_Y2:
				m_pImpl->SetData(nType, str);
				break;

			default:
				break;
			}
			UpdateX0Y0();
			UpdateCellsColor();
			CheckEnableDigitize();
			break;

		case INFOLISTCOL_PIXEL:
			m_pImpl->SetAxisPixel(nType, atoi(str));
			break;

		case INFOLISTCOL_SCALETYPE:
			m_pImpl->SetScaleType(nType, atoi(str));
			break;
			
		default:
			break;
		}

		GridListControl::OnAfterEdit(nRow, nCol);
	}

	void 	OnAfterSelectionChange(int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
	{
		if ( IsDuringUpdate() || !IsAxesEditing() || nNewRowSel < INFOLISTROW_OFFSET || nOldRowSel == nNewRowSel )
			return;

		ERR_MSG("OnAfterSelectionChange");
		m_pImpl->SetAxisSelection(nNewRowSel - INFOLISTROW_OFFSET);
		UpdateAfterSelect(nNewRowSel, nOldRowSel);
	}

	void	OnMouseMove(short nButton, short nShift, float X, float Y)
	{
		int		nRow, nCol;
		if ( !GetMouseCell(nRow, nCol) || nRow < 0 || nCol < 0 )
			return;

		string		str;
		if ( INFOLISTCOL_SCALE == nCol && nRow >= INFOLISTROW_X1 && nRow <= INFOLISTROW_Y2 )
		{
			str = m_pImpl->GetAxisScaleHint(nRow - INFOLISTROW_OFFSET);
		}
		SetToolTipsText(str);
	}

	#define		ID_INFOLIST_MENU_SAVE_SETTINGS		0x0001
	#define		ID_INFOLIST_MENU_LOAD_SETTINGS		0x0002

	#define		STR_THEME_FILE_EXT					ANALYSIS_THEME_FILE_EXT
	BOOL	ShowMenu(int nx, int ny)
	{
		int		nRow, nCol;
		GetMouseCell(nRow, nCol);
		if ( nRow < 0 )
			return FALSE;

		Menu	myMenu;
		myMenu.Add(_L("Save Axes Settings..."), ID_INFOLIST_MENU_SAVE_SETTINGS);
		myMenu.Add(_L("Load Axes Settings..."), ID_INFOLIST_MENU_LOAD_SETTINGS);

		int		nCmd = 0;
		HWND	hWnd = m_pImpl->GetHwnd();
		myMenu.TrackPopupMenu(0, nx, ny, hWnd, &nCmd);
		switch ( nCmd )
		{
		case ID_INFOLIST_MENU_SAVE_SETTINGS:
		case ID_INFOLIST_MENU_LOAD_SETTINGS:
			{
				BOOL			bSave = ID_INFOLIST_MENU_SAVE_SETTINGS == nCmd;

				string			strFileName;
				vector<string>	vsFileTypes(1);
				vsFileTypes[0] = "[Axes Settings File(*." STR_THEME_FILE_EXT ")]*." STR_THEME_FILE_EXT;
				if ( !okutil_FileDialog(&strFileName, bSave, &vsFileTypes, okutil_get_origin_path(ORIGIN_PATH_USER), 0, hWnd) )
					return FALSE;

				Tree	tr;
				if ( bSave )
				{
					m_pImpl->SaveAxesSettings(tr);
					tr.Save(strFileName);
				}
				else
				{
					tr.Load(strFileName);
					m_pImpl->LoadAxesSettings(tr);
				}
			}
			break;
		}

		return TRUE;
	}

	BOOL	OnSetAxisColor(IMPLDATA type)
	{
		SelectRow(0, IsAxesEditing(), INFOLISTCOL_SCALETYPE);

		HWND	hWnd = GetFocus();
		if ( m_pImpl->SetAxisColor(type) )
			Update();
		
		return SetFocus(hWnd);
	}

	int		GetHeight()
	{
		return YTwipsToPixels(GetRowHeight(0) * 1.05 * (INFOLISTROW_TOTAL - m_pImpl->IsX1FromYAxis() - m_pImpl->IsY1FromXAxis() + 0.2));
	}
	
private:
	void	UpdateNames()
	{
		vector<string>	vs;
		m_pImpl->GetInfoNames(vs);
		SetCells(vs, INFOLISTCOL_NAME);
	}

	void	UpdateColors()
	{
		vector<uint>	vn;
		m_pImpl->GetInfoColors(vn);

		FillColumnBkColor(INFOLISTCOL_COLOR, vn);
		int		nSelectedRow = GetSelectedRow();
		if ( nSelectedRow >= INFOLISTROW_OFFSET )
			UpdateColorCol(nSelectedRow);
	}

	void	UpdateScales()
	{
		vector<string>	vs;
		m_pImpl->GetInfoScales(vs);
		SetCells(vs, INFOLISTCOL_SCALE);
	}

	void	UpdatePixels()
	{
		vector<string>	vs;
		m_pImpl->GetInfoPixels(vs);
		SetCells(vs, INFOLISTCOL_PIXEL);
	}

	void	InitScaleTypes()
	{
		vector<string>	vs;
		vs.Add(_L("Linear"));
		vs.Add(_L("Log10"));
		
		vector<string>	vsLists(vs.GetSize());
		for ( int ii=0; ii<vs.GetSize(); ++ii )
		{
			vsLists[ii].Format("#%d;%s", ii, vs[ii]);
		}

		string		strCombo;
		strCombo.SetTokens(vsLists, '|');
		SetColComboList(INFOLISTCOL_SCALETYPE, strCombo);
	}

	void	UpdateScaleTypes()
	{
		vector<string>	vs;
		m_pImpl->GetInfoScaleTypes(vs);
		SetCells(vs, INFOLISTCOL_SCALETYPE);
	}

	#define		EMPTY_CELL_COMBO(_row)		SetCellComboList(_row, INFOLISTCOL_SCALETYPE, "")
	void	SetupScaleTypeNoCombo()
	{
		++m_nDuringUpdate;

		EMPTY_CELL_COMBO(INFOLISTROW_X2);
		EMPTY_CELL_COMBO(INFOLISTROW_Y2);
		EMPTY_CELL_COMBO(INFOLISTROW_XREF);
		EMPTY_CELL_COMBO(INFOLISTROW_YREF);

		--m_nDuringUpdate;
	}

	void	SelectRow(int nRow, BOOL bUpdate = TRUE, int nCol = -1)
	{
		int		nRowSelected = GetSelectedRow();
		if ( nRow == nRowSelected )
			return;
		
		++m_nDuringUpdate;
		if ( nCol >= 0 )
			SelCell(nRow, nCol);
		else
			SelRow(nRow);
		if ( bUpdate )
			UpdateAfterSelect(nRow, nRowSelected);
		--m_nDuringUpdate;
	}

	void	UpdateX0Y0()
	{
		string		x, y;
		m_pImpl->GetX0Y0(x, y);
		SetCell(INFOLISTROW_XREF, INFOLISTCOL_SCALE, x);
		SetCell(INFOLISTROW_YREF, INFOLISTCOL_SCALE, y);
	}

	BOOL	UpdateSelection()
	{
		IMPLDATA	type = m_pImpl->GetAxisSelection();
		SelectRow(IMPLDATA_INVALID == type ? 0 : type + INFOLISTROW_OFFSET);
		return TRUE;
	}

	BOOL	CheckShowRows(BOOL bShow)
	{
		vector<bool>	vbShow(INFOLISTROW_TOTAL - INFOLISTROW_OFFSET);
		vbShow = bShow;

		BOOL	bValidToDigitize = m_pImpl->HasValidDigitizeImage();
		vbShow[INFOLISTROW_XREF - INFOLISTROW_OFFSET] = bValidToDigitize && !m_pImpl->IsX1FromYAxis();
		vbShow[INFOLISTROW_YREF - INFOLISTROW_OFFSET] = bValidToDigitize && !m_pImpl->IsY1FromXAxis();
		
		return ShowRows(vbShow);
	}

	BOOL	IsDuringUpdate()
	{
		return m_nDuringUpdate != 0;
	}

	BOOL	IsAxesEditing()
	{
		return m_pImpl->IsAxesEditing();
	}

	void	FillColumnBkColor(int nCol, vector<uint>& vnColors)
	{
		SetCellColor(INFOLISTROW_X1, nCol, 0, vnColors[IMPLDATA_X1]);
		SetCellColor(INFOLISTROW_X2, nCol, 0, vnColors[IMPLDATA_X2]);
		SetCellColor(INFOLISTROW_Y1, nCol, 0, vnColors[IMPLDATA_Y1]);
		SetCellColor(INFOLISTROW_Y2, nCol, 0, vnColors[IMPLDATA_Y2]);
		SetCellColor(INFOLISTROW_XREF, nCol, 0, vnColors[IMPLDATA_XREF]);
		SetCellColor(INFOLISTROW_YREF, nCol, 0, vnColors[IMPLDATA_YREF]);
	}

	void	SetColumnForeColor(int nCol, vector<uint>& vnColors)
	{
		SetCellColor(INFOLISTROW_X1, nCol, vnColors[IMPLDATA_X1]);
		SetCellColor(INFOLISTROW_X2, nCol, vnColors[IMPLDATA_X2]);
		SetCellColor(INFOLISTROW_Y1, nCol, vnColors[IMPLDATA_Y1]);
		SetCellColor(INFOLISTROW_Y2, nCol, vnColors[IMPLDATA_Y2]);
		SetCellColor(INFOLISTROW_XREF, nCol, vnColors[IMPLDATA_XREF]);
		SetCellColor(INFOLISTROW_YREF, nCol, vnColors[IMPLDATA_YREF]);
	}
	
	#define		CHECK_UPDATE_PIXEL_FORECOLOR(_TYPE) \
				if ( m_pImpl->IsCoorReady(_TYPE) ) \
					vnColors[_TYPE] = COLOR_BLACK

	BOOL	UpdateCellsColor()
	{
		vector<uint>	vnColors(IMPLDATA_TOTAL);
		uint			nGray = color_index_to_rgb(SYSCOLOR_GRAY);
		vnColors = nGray;

		SetColumnForeColor(INFOLISTCOL_NAME, vnColors);

		SetCellColor(INFOLISTROW_XREF, INFOLISTCOL_SCALE, nGray);
		SetCellColor(INFOLISTROW_YREF, INFOLISTCOL_SCALE, nGray);

		if ( IsAxesEditing() )
		{
			CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_X1);
			CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_X2);
			CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_Y1);
			CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_Y2);
			CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_XREF);
			CHECK_UPDATE_PIXEL_FORECOLOR(IMPLDATA_YREF);
		}
		SetColumnForeColor(INFOLISTCOL_PIXEL, vnColors);
		return TRUE;
	}

	void	UpdateAfterSelect(int nRowNew, int nRowOld)
	{
		if ( nRowOld >= INFOLISTROW_OFFSET )
		{
			UpdateColorCol(nRowOld);
		}
		if ( nRowNew >= INFOLISTROW_OFFSET )
		{
			UpdateColorCol(nRowNew);
		}
	}
	
	void	UpdateColorCol(int nRow)
	{
		uint	color;
		GetCellColor(nRow, INFOLISTCOL_COLOR, NULL, &color);
		SetCellColor(nRow, INFOLISTCOL_COLOR, 0, go_color_no_reverse_video(color));
	}

	void	UpdateRows()
	{
		SetRows(INFOLISTROW_TOTAL, false);
		SetupScaleTypeNoCombo();
		
		const	int		nRowHeight = 300;
		for ( int row=INFOLISTROW_OFFSET; row<INFOLISTROW_TOTAL; ++row )
		{
			SetRowHeight(row, nRowHeight);
		}
	}

	void	SetAxisColor(IMPLDATA type)
	{
		if ( g_pDigitizerOld )
			g_pDigitizerOld->PostMessage(ID_DIGITIZER_MSG_SET_AXIS_COLOR, (DWORD)type);
	}
	
	void	CheckEnableDigitize()
	{
		if ( g_pDigitizerOld )
			g_pDigitizerOld->SendMessage(ID_DIGITIZER_MSG_CHECK_ENABLE_DIGITIZE);
	}

private:
	DigitizerImpl*		m_pImpl;
	int					m_nDuringUpdate;
};

class	DynamicResizeHelper
{
public:
	DynamicResizeHelper(BOOL bResizeBefore, Digitizer& digitizer)
	{
		m_bResizeBefore = bResizeBefore;
		m_pDigitizer = &digitizer;
		if ( m_bResizeBefore )
			m_pDigitizer->Resize();
	}
	~DynamicResizeHelper()
	{
		if ( !m_bResizeBefore )
			m_pDigitizer->Resize();
	}
	
private:
	BOOL		m_bResizeBefore;
	Digitizer*	m_pDigitizer;
};

#define		BASE_WINDOW		MultiPaneDlg
#include "dynadlg.h"
class	Digitizer : public DynaDlg
{	
public:
	Digitizer() : DynaDlg(IDD_DIGITIZER, NULL, "ODlg8")
	{
		m_pInfo = new DigitizerInfoList(&m_Impl);
	}
	~Digitizer()
	{
		NICE_SAFE_REMOVAL(m_pInfo);
	}
	
	BOOL	Create(HWND hWndParent = NULL)
	{
		InitMsgMap();		
		BOOL	bReturn = DynaDlg::Create(hWndParent, 0);
		Visible = TRUE;
		return TRUE;
	}
	
	BOOL	Resize()
	{
		int		nGap = GetControlGap();

		RECT	rrShowBottom;
		GetControlClientRect(IDC_SHOW_BOTTOM, rrShowBottom);

		RECT	rrInfoHint;
		GetControlClientRect(IDC_DIGITIZER_INFO_HINT, rrInfoHint);

		RECT	rrInfoList;
		GetControlClientRect(IDC_DIGITIZER_INFO, rrInfoList);
		rrInfoList.bottom = rrInfoList.top + m_pInfo->GetHeight();
		m_pInfo->MoveWindow(rrInfoList);

		RECT	rrHint;
		GetClientRect(m_ctrlHint, rrHint);
		int		nHeight = GetHintHeight(RECT_WIDTH(rrHint));
		if ( nHeight > 0 )
			rrHint.bottom = rrHint.top + nHeight;
		
		nHeight = RECT_HEIGHT(rrHint);
		rrHint.top = rrInfoList.bottom + nGap;
		rrHint.bottom = rrHint.top + nHeight;
		MoveControl(m_ctrlHint, rrHint);
		MoveControl(TREE_CTRL_VAR, rrHint);
		
		nHeight = 0;
		if ( IsBottomPaneShown() )
		{
			nHeight = RECT_HEIGHT(rrInfoHint) + nGap + RECT_HEIGHT(rrInfoList) + nGap + RECT_HEIGHT(rrHint) + 3 * nGap;
		}
		
		RECT	rr;
		m_wndDlg.GetWindowRect(&rr);
		m_wndDlg.ClientToScreen(&rrShowBottom);
		rr.bottom = rrShowBottom.bottom + nGap + nHeight;

		m_wndDlg.MoveWindow(&rr);
		return TRUE;
	}

	int		GetHintHeight(int nWidth)
	{
		if ( !m_Impl.HasValidDigitizeImage() )
			return -1;
		
		if ( m_Impl.IsRotationMode() )
		{
			SIZE	sz;
			TREE_CTRL_VAR.GetOptimalSize(sz);
			return sz.cy;
		}

		string		str = m_Impl.GetHint();
		return m_ctrlHint.Measure(str, &nWidth) + GetControlGap();
	}

protected:

EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	
	ON_BN_CLICKED(IDC_DIGITIZER_IMPORT, OnImportImage)
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	ON_BN_CLICKED(IDC_DIGITIZER_IMPORT_FROM_CLIPBOARD, OnImportImageFromClipboard)
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	ON_BN_CLICKED(IDC_DIGITIZER_ROTATE, OnRotate)
	ON_BN_CLICKED(IDC_DIGITIZER_ADJUST_SCALE, OnOptionsChange)
	ON_BN_CLICKED(IDC_DIGITIZER_GO, OnDigitize)
	ON_BN_CLICKED(IDC_DIGITIZER_EDIT, OnToggleAxesEdit)
	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	ON_BN_CLICKED(IDC_DIGITIZER_SET_LABEL, OnToggleLabelEdit)
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	ON_BN_CLICKED(IDC_DIGITIZER_SHOW_XREF, OnShowXRefLine)
	ON_BN_CLICKED(IDC_DIGITIZER_SHOW_YREF, OnShowYRefLine)
	ON_BN_CLICKED(IDC_DIGITIZER_RESET, OnNewData)
	ON_BN_CLICKED(IDC_DIGITIZER_GO_TO_DATA, OnGotoData)
	ON_BN_CLICKED(IDC_DIGITIZER_GO_TO_GRAPH, OnGotoGraph)
	ON_BN_CLICKED(IDC_DIGITIZER_REMOVE_WKS_GRAPH, OnDelWksGraph)
	ON_BN_CLICKED(IDC_DIGITIZER_GO_TO_IMAGE, OnGotoImage)
	ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)

	ON_GRID_BEFORE_EDIT(IDC_DIGITIZER_INFO, OnBeforeEditInfo)
	ON_GRID_AFTER_EDIT(IDC_DIGITIZER_INFO, OnAfterEditInfo)	
	ON_GRID_KEY(IDC_DIGITIZER_INFO, OnKeyInfo) /// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	ON_GRID_AFTER_SEL_CHANGE(IDC_DIGITIZER_INFO, OnAfterInfoSelectionChange)
	ON_GRID_MOUSE_MOVE(IDC_DIGITIZER_INFO, OnMouseMoveOnInfo)

	ON_CONTEXTMENU(OnShowMenu)

	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	ON_MARKEROBJ_EDIT(OnDataPlotEdit)
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	ON_OBJECT_MODIFY(OnOriginModify)
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	ON_GETNDLG_MSGS(IDC_DIGITIZER_DYNA)
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

	ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_INFO, OnUpdateInfo)
	ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_INFO_SELECTION, OnUpdateInfoSelection)
	ON_USER_MSG(ID_DIGITIZER_MSG_ENABLE_DIGITIZE, OnEnableDigitize)
	ON_USER_MSG(ID_DIGITIZER_MSG_SET_AXIS_COLOR, OnSetAxisColor)
	ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_FROM_POINTS, OnUpdateFromPlot)
	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	ON_USER_MSG(ID_DIGITIZER_MSG_UPDATE_DYNACTRL, OnUpdateDynaCtrl)
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	ON_USER_MSG(ID_DIGITIZER_MSG_SAVE_SETTINGS, OnSaveSettings)
	ON_USER_MSG(ID_DIGITIZER_MSG_CHECK_ENABLE_DIGITIZE, OnCheckEnableDigitize)
EVENTS_END

	BOOL	OnInitDialog()
	{
		vector<string>  vsUpDownTips;
		GetUpDownTips(vsUpDownTips);
		if ( !DynaDlg::OnInitDialog(0, IDC_SHOW_BOTTOM, IDC_DIGITIZER_INFO, vsUpDownTips, STR_DLG_NAME) )
			return FALSE;
		
		///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		m_ctrlHint = GetItem(IDC_DIGITIZER_HINT);
		m_Impl.SetHwnd(GetSafeHwnd());
		
		InitDynaControl(IDC_DIGITIZER_DYNA);
		///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		CheckUpdateOnDlgShow(TRUE);
		m_pInfo->Init(IDC_DIGITIZER_INFO, *this);
		return InitRadioBitmapButtons()
			&& UpdateStates()
			&& Resize();
	}

	BOOL	OnDestroy()
	{
		DynaDlg::OnDestroy();

		CheckUpdateOnDlgShow(FALSE);
		NICE_SAFE_REMOVAL(g_pDigitizerOld);
		return TRUE;
	}

	BOOL	OnImportImage(Control ctrl)
	{
		return m_Impl.ImportImage() && UpdateStates();
	}
	
	///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	OnImportImageFromClipboard(Control ctrl)
	{
		if(is_image_availble_in_clipboard())
			return m_Impl.ImportImageFromClipboard() && UpdateStates();
		else
		{
			warning_msg_box(_L("No image in the clipboard."), TRUE);
			return false;
		}
	}
	///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
	BOOL	OnOptionsChange(Control ctrl)
	{
		return m_Impl.ChangeOptions() && CheckEnableDigitize() && CheckEnableGotoData() && UpdateInfo();
	}

	#define		ON_BUTTON_PRESSED(_bPressedDown) \
				BitmapRadioButton	btn = ctrl; \
				BOOL				_bPressedDown = btn.PressedDown; \
				btn.PressedDown = !_bPressedDown

	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	BOOL	OnRotate(Control ctrl)
	{
		ON_BUTTON_PRESSED(bPressedDown);
		if ( !bPressedDown && !IsBottomPaneShown() )
			ShowBottomPane(TRUE);
		return m_Impl.SetRotationMode(!bPressedDown) && UpdateStates();
	}
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

	BOOL	OnToggleAxesEdit(Control ctrl)
	{
		ON_BUTTON_PRESSED(bPressedDown);
		m_Impl.SetAxesEditing(!bPressedDown);
		return UpdateHint() && UpdateInfoSelectable(TRUE);
	}

	BOOL	OnShowXRefLine(Control ctrl)
	{
		ON_BUTTON_PRESSED(bPressedDown);
		m_Impl.ShowXRefLine(!bPressedDown);
		DynamicResizeHelper	clHelper(!bPressedDown, *this);
		return UpdateInfo();
	}

	BOOL	OnShowYRefLine(Control ctrl)
	{
		ON_BUTTON_PRESSED(bPressedDown);
		m_Impl.ShowYRefLine(!bPressedDown);
		DynamicResizeHelper	clHelper(!bPressedDown, *this);
		return UpdateInfo();
	}

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	OnToggleLabelEdit(Control ctrl)
	{
		ON_BUTTON_PRESSED(bPressedDown);
		return m_Impl.SetLabelEditing(!bPressedDown) && UpdateHint() && UpdateStates();
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	BOOL	OnDigitize(Control ctrl)
	{
		if ( m_Impl.IsAxesEditing() )
		{
			m_Impl.SetAxesEditing(FALSE);
			UpdateAxesEditing();
		}
		return m_Impl.Digitize() && CheckEnableDigitize() && UpdateHint();
	}

	BOOL	OnNewData(Control ctrl)
	{
		return m_Impl.NewData() && UpdateStates();
	}

	BOOL	OnGotoData(Control ctrl)
	{
		return m_Impl.GotoData();
	}

	BOOL	OnGotoGraph(Control ctrl)
	{
		return m_Impl.GotoGraph();
	}

	BOOL	OnDelWksGraph(Control ctrl)
	{
		return m_Impl.DelWksGraph() && UpdateStates();
	}

	BOOL	OnGotoImage(Control ctrl)
	{
		if ( m_glImage )
			return m_glImage.CheckShowActivate();

		return FALSE;
	}

	BOOL	OnShowBottomPane(Control ctrl)
	{
		DynaDlg::OnShowBottomPane(ctrl);
		return Resize();
	}

	virtual	BOOL	OnChangePage()
	{
		return UpdateStates() && DynaDlg::OnChangePage();
	}

	///------ Folger 12/23/2010 ORG-1836 SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH
	BOOL	OnDataPlotEdit(GraphObject go, int nIndex)
	{
		return m_Impl.DataPlotEdit(nIndex);
	}
	///------ End SUPPORT_ADD_LABEL_TO_DIGITIZE_GRAPH

	///------ Folger 01/21/2011 ORG-2088-S1 UPDATE_DIGITIZER_PLOT_FROM_OUTPUT
	BOOL	OnOriginModify(OriginObject obj, int nKind)
	{
		DatasetObject dsObj;
		dsObj = obj;
		if ( !dsObj )
			return FALSE;
		
		return m_Impl.UpdatePlotFromOutput(dsObj, m_glImage);
	}
	///------ End UPDATE_DIGITIZER_PLOT_FROM_OUTPUT

	BOOL	OnUpdateInfo(WPARAM wParam, LPARAM lParam)
	{
		return UpdateInfo();
	}

	BOOL	OnUpdateInfoSelection(WPARAM wParam, LPARAM lParam)
	{
		return UpdateInfo(INFOLISTUPDATE_SELECTION_ONLY);
	}

	BOOL	OnEnableDigitize(WPARAM wParam, LPARAM lParam)
	{
		return CheckEnableDigitize();
	}

	BOOL	OnSetAxisColor(WPARAM wParam, LPARAM lParam)
	{
		return m_pInfo->OnSetAxisColor(wParam);
	}

	BOOL	OnUpdateFromPlot(WPARAM wParam, LPARAM lParam)
	{
		return m_Impl.UpdateFromPlot(wParam);
	}

	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	BOOL	OnUpdateDynaCtrl(WPARAM wParam, LPARAM lParam)
	{
		BOOL	bOn = lParam;
		TREE_CTRL_VAR.Visible = bOn;
		m_ctrlHint.Visible = !bOn;

		if ( !bOn )
			return TRUE;
		
		TreeNode*	ptr = (TreeNode*)wParam;
		SetInputTree(*ptr);
		
		/// Kenny 11/23/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
		//TREE_CTRL_VAR.SendMessage(WM_SETREDRAW, FALSE);
		//return UpdateDynaControl(true, GETNEVENT_ON_INIT, true, 0, true) && TREE_CTRL_VAR.SendMessage(WM_SETREDRAW, TRUE);
#ifndef __PA_FLICKER_FREE
		TREE_CTRL_VAR.SetRedraw(FALSE);
#endif // __PA_FLICKER_FREE
		BOOL bRet = UpdateDynaControl(true, GETNEVENT_ON_INIT, true, 0, true);
#ifndef __PA_FLICKER_FREE
		TREE_CTRL_VAR.SetRedraw(TRUE);
		TREE_CTRL_VAR.RedrawWindow(NULL, NULL, (RDW_FRAME | RDW_ERASE | RDW_INVALIDATE | RDW_ALLCHILDREN));
#endif // __PA_FLICKER_FREE
		return bRet;
		/// End REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
	}
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

	BOOL	OnSaveSettings(WPARAM wParam, LPARAM lParam)
	{
		return m_Impl.Save();
	}
	
	BOOL	OnCheckEnableDigitize(WPARAM wParam, LPARAM lParam)
	{
		return CheckEnableDigitize();
	}

	void	OnBeforeEditInfo(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{		
		m_pInfo->OnBeforeEdit(nRow, nCol, pCancel);
	}
	
	void	OnAfterEditInfo(Control flxControl, int nRow, int nCol)
	{		
		m_pInfo->OnAfterEdit(nRow, nCol);		
	}
	
	/// Iris 7/16/2012 ORG-6216-S1 SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	BOOL OnKeyInfo(Control oCntrl, UINT msg, UINT wParam, UINT lParam)
	{
		if( WM_KEYDOWN == msg && ('a' == wParam || 'A' == wParam ) )		
		{
			m_Impl.SetFocusOnGraph();		
		}
		return TRUE;
	}
	///End SET_FOCUS_ON_GRAPH_WINDOW_WHEN_TYPE_A_TO_ZOOM_IN_OUT
	
	void 	OnAfterInfoSelectionChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
	{
		m_pInfo->OnAfterSelectionChange(nOldRowSel, nOldColSel, nNewRowSel, nNewColSel);
	}

	void	OnMouseMoveOnInfo(Control cntrl, short nButton, short nShift, float X, float Y)
	{
		m_pInfo->OnMouseMove(nButton, nShift, X, Y);
	}

	BOOL	OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		return m_pInfo->ShowMenu(nx, ny);
	}

private:
	BOOL	InitRadioBitmapButtons()
	{
		vector<int>		vnBtnIDs = { IDC_DIGITIZER_IMPORT
			///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
			, IDC_DIGITIZER_IMPORT_FROM_CLIPBOARD
			///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
			, IDC_DIGITIZER_ROTATE
			, IDC_DIGITIZER_ADJUST_SCALE
			, IDC_DIGITIZER_EDIT
			, IDC_DIGITIZER_SHOW_XREF
			, IDC_DIGITIZER_SHOW_YREF
			, IDC_DIGITIZER_GO
			, IDC_DIGITIZER_RESET
			, IDC_DIGITIZER_GO_TO_DATA
			, IDC_DIGITIZER_GO_TO_GRAPH
			, IDC_DIGITIZER_REMOVE_WKS_GRAPH
			, IDC_DIGITIZER_GO_TO_IMAGE
			///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
			, IDC_DIGITIZER_SET_LABEL
			///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		};

		vector<int>		vnBmpIDs = { IDB_IMPORT_IMAGE
			///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
			, IDB_IMPORT_IMAGE_FROM_CLIPBOARD
			///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
			, IDB_ROTATE
			, IDB_ADJUST_SCALE
			, IDB_AXES_EDIT
			, IDB_SHOW_XREF
			, IDB_SHOW_YREF
			, IDB_DIGITIZE
			, IDB_RESET_POINTS
			, IDB_GOTO_DATA
			, IDB_GOTO_GRAPH
			, IDB_DEL_WKS_GRAPH
			, IDB_GOTO_IMAGE
			///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
			, IDB_SET_LABEL
			///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		};

		vector<string>	vsTips;
		vsTips.Add(_L("Import"));
		///------ Tony 04/25/2012 ORG-2289-S1 SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
		vsTips.Add(_L("Import from Clipboard"));
		///------ End SUPPORT_IMPORT_IMAGE_FROM_CLIPBOARD_FOR_DIGITIZER
		vsTips.Add(STR_ROTATE_IMAGE);
		vsTips.Add(STR_OPTION);
		vsTips.Add(_L("Edit Axes"));
		vsTips.Add(_L("Show X Reference Line"));
		vsTips.Add(_L("Show Y Reference Line"));
		vsTips.Add(_L("Pick New Points"));
		vsTips.Add(_L("Start New Data"));
		vsTips.Add(_L("Go to Data"));
		vsTips.Add(_L("Go to Graph"));
		vsTips.Add(_L("Delete Worksheet/Graph"));
		vsTips.Add(_L("Go to Image"));
		///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		vsTips.Add(_L("Set Label"));
		///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

		int		nSize = vnBtnIDs.GetSize();
		O_A(nSize == vnBmpIDs.GetSize());
		O_A(nSize == vsTips.GetSize());
		for ( int ii=0; ii<nSize; ++ii )
		{
			vector<string>	vs;
			vs.Add(vsTips[ii]);
			InitRadioBitmapButton(vnBtnIDs[ii], vnBmpIDs[ii], 1, &vs);
		}
		return TRUE;
	}

	BOOL	UpdateAxesEditing()
	{
		BitmapRadioButton	btn = GetItem(IDC_DIGITIZER_EDIT);
		btn.PressedDown = m_Impl.IsAxesEditing();
		return UpdateInfoSelectable();
	}

	///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	BOOL	UpdateRotationMode()
	{
		BitmapRadioButton	btn = GetItem(IDC_DIGITIZER_ROTATE);
		btn.PressedDown = m_Impl.IsRotationMode();
		return m_Impl.Rotate(btn.PressedDown);
	}
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL	UpdateLabelEditing()
	{
		BitmapRadioButton	btn = GetItem(IDC_DIGITIZER_SET_LABEL);
		btn.PressedDown = m_Impl.IsLabelEditing();
		return TRUE;
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	BOOL	UpdateShowXYRefLine()
	{
		BitmapRadioButton	btnShowXRef = GetItem(IDC_DIGITIZER_SHOW_XREF);
		BitmapRadioButton	btnShowYRef = GetItem(IDC_DIGITIZER_SHOW_YREF);
		btnShowXRef.PressedDown = !m_Impl.IsX1FromYAxis();
		btnShowYRef.PressedDown = !m_Impl.IsY1FromXAxis();
		return TRUE;
	}

	BOOL	UpdateHint()
	{
		m_ctrlHint.Text = m_Impl.GetHint();
		return Resize();
	}

	BOOL	UpdateInfo(DWORD dwCntrls = 0)
	{
		return m_pInfo->Update(dwCntrls);
	}

	BOOL	UpdateInfoSelectable(BOOL bResetRowSelection = FALSE)
	{
		return m_pInfo->UpdateSelectable(bResetRowSelection);
	}
	
	BOOL	UpdateStates()
	{
		BOOL	bValid = m_Impl.HasValidDigitizeImage();
		///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
		TREE_CTRL_VAR.Visible = bValid;
		m_ctrlHint.Visible = TRUE;
		///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

		if ( bValid )
		{
			m_Impl.Update(TRUE);
			///------ Folger 12/29/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
			UpdateRotationMode();
			///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
			UpdateAxesEditing();
			UpdateShowXYRefLine();
			///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
			UpdateLabelEditing();
			///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

			m_glImage = m_Impl.GetDigitizeLayer();
		}

		UpdateHint();
		UpdateInfo(INFOLISTUPDATE_RESET_ROWS);

		vector<int>		vnCntrlIDs = { IDC_DIGITIZER_ADJUST_SCALE
			, IDC_DIGITIZER_EDIT
			, IDC_DIGITIZER_SHOW_XREF
			, IDC_DIGITIZER_SHOW_YREF
		};
		BOOL	bEnable = IsButtonsEnable();
		for ( int ii=0; ii<vnCntrlIDs.GetSize(); ++ii )
		{
			GetItem(vnCntrlIDs[ii]).Enable = bEnable;
		}

		return UpdateDlgTitle()
			&& CheckEnableDigitize()
			&& CheckEnableGotoImage()
			///------ Folger 12/30/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
			&& CheckEnableRotation()
			///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
			&& CheckEnableGotoData()
			;
	}

	BOOL	CheckEnableDigitize()
	{
		BOOL	bReadyToDigitize = m_Impl.HasValidDigitizeImage() && m_Impl.IsReadyToDigitize() && IsButtonsEnable();
		GetItem(IDC_DIGITIZER_GO).Enable = bReadyToDigitize;
		GetItem(IDC_DIGITIZER_RESET).Enable = bReadyToDigitize && m_Impl.HasDataPoint();
		
		///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		GetItem(IDC_DIGITIZER_SET_LABEL).Enable = m_Impl.HasValidDigitizeImage() && !m_Impl.IsRotationMode() && m_Impl.HasDataPoint();
		///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
		return TRUE;
	}

	BOOL	CheckEnableGotoImage()
	{
		GetItem(IDC_DIGITIZER_GO_TO_IMAGE).Enable = m_glImage && !m_Impl.HasValidDigitizeImage();
		return TRUE;
	}

	BOOL	CheckEnableGotoData()
	{
		GetItem(IDC_DIGITIZER_GO_TO_DATA).Enable = GetItem(IDC_DIGITIZER_GO_TO_GRAPH).Enable = GetItem(IDC_DIGITIZER_REMOVE_WKS_GRAPH).Enable = !m_Impl.GetDataName().IsEmpty() && IsButtonsEnable();
		return TRUE;
	}

	void	GetUpDownTips(vector<string>& vs)
	{
		vs.SetSize(2);
		vs[0] = _L("Show");
		vs[1] = _L("Hide");
	}

	BOOL	UpdateDlgTitle()
	{
		Text = m_Impl.HasValidDigitizeImage() ? m_Impl.GetTitle() : STR_DLG_NAME_L;
		return TRUE;
	}

	BOOL	CheckUpdateOnDlgShow(BOOL bShow)
	{
		return m_Impl.CheckUpdateOnDlgShow(bShow);
	}

	///------ Folger 12/30/2010 ORG-1544-S3 SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION
	BOOL	CheckEnableRotation()
	{
		GetItem(IDC_DIGITIZER_ROTATE).Enable = m_Impl.HasValidDigitizeImage() && !m_Impl.IsLabelEditing();
		return TRUE;
	}
	///------ End SHOULD_SUPPORT_AXES_EDITING_DURING_ROTATION

	///------ Folger 01/10/2011 ORG-1836-S2 MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH
	BOOL		IsButtonsEnable()
	{
		return m_Impl.HasValidDigitizeImage() && !m_Impl.IsRotationMode() && !m_Impl.IsLabelEditing();
	}
	///------ End MORE_WORK_ON_ADDING_LABEL_TO_DIGITIZE_GRAPH

	virtual void  resizeDlgToFit(int cx = 0, int cy = 0)
	{
		Resize();
	}

private:
	DigitizerImpl		m_Impl;
	DigitizerInfoList*	m_pInfo;

	GraphLayer			m_glImage;
	Control				m_ctrlHint;
};

BOOL	OpenDigitizer()
{
	if ( g_pDigitizerOld )
		return TRUE;
	
	g_pDigitizerOld = new Digitizer();	
	return g_pDigitizerOld->Create(GetWindow());
}

BOOL	import_image_and_open_digitizer()
{
	DigitizerImpl	digitizerImpl;
	return digitizerImpl.ImportImage() && OpenDigitizer();
}

void	digitizer_events(int nEvent, string strName)
{
	DigitizerImpl	digitizerImpl;
	digitizerImpl.UpdateFromEvents(nEvent, strName);
}
///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
//BOOL	digitizer_calculate_one_point(double x, double y, string* pstr = NULL)
BOOL	digitizer_calculate_one_point(double& x, double& y, string* pstr = NULL)
///End OPTIMIZE_PICKED_POINT
{
	if ( NULL == pstr )
		return FALSE;
	
	DigitizerImpl	digitizerImpl;
	return digitizerImpl.GetOnePoint(*pstr, x, y);
}
///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
//BOOL	digitizer_add_one_point(double x, double y, string* pstr = NULL)
BOOL	digitizer_add_one_point(double& x, double& y, string* pstr = NULL)
///End OPTIMIZE_PICKED_POINT
{
	DigitizerImpl	digitizerImpl;
	return digitizerImpl.AddOnePoint(x, y);
}

BOOL	digitizer_check_update_on_dlg_show()
{	
	DigitizerImpl	digitizerImpl;
	return digitizerImpl.CheckUpdateOnDlgShow(g_pDigitizerOld ? TRUE : FALSE);
}
///Jasmine 03/11/11 ORG-2286 KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
BOOL	digitizer_clean_page_relative_data(string strAttachPage)
{
	out_str("strActivePage="+strAttachPage);
	DigitizerImpl	digitizerImpl;
	digitizerImpl.CleanRelativeData(strAttachPage);	
	return TRUE;
}
///End KEEP_IMAGE_MATRIX_UNTIL_PAGE_DESTROY_TO_SPEED_UP
