/*------------------------------------------------------------------------------*
 * File Name: oQueryBuilder.h	   												*
 * Creation: Sophy 10/10/2010													*
 * Purpose: Used for ADO programming for Origin DB 								*
 * Copyright (c) OriginLab Corp.	2010										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * /// AW 10/15/2010 ORG-1179 GET_DB_INFO_FOR_NEW_TOOL							*
 *	Sophy 12/15/2010 ORG-1696-S1 MENU_ITEM_TO_SHOW_CONNECTION_STRING			*
 *  Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
 *------------------------------------------------------------------------------*/
#ifndef	_DATABASEIMPORTDLG_H_
#define	_DATABASEIMPORTDLG_H_

#define	WM_SQL_SCRIPT_CHANGE	(WM_USER + 2008)
///Sophy 1/7/2011 ORG-1937 BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
enum {
	SQLEDIT_FONT_SMALLEST	= 120,
	SQLEDIT_FONT_SMALLER	= 150,
	SQLEDIT_FONT_MEDIUM		= 180,
	SQLEDIT_FONT_LARGER		= 210,
	SQLEDIT_FONT_LARGEST	= 270,
};
///end BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
class SQLEdit : public	 CodeEdit
{
public:
	SQLEdit(){}
	///Sophy 1/13/2011 ORG-2018-S1 BETTER_SYNTAX_HIGHTLIGHT_SUPPORT_FOR_SQL_EDITOR
	void	InitSyntax()
	{
		//here list all frequently used keywords
		//vector<string> vsKeywords = {
			//"Select", "Insert", "Delete", "Update", "Drop", "Commit", "From", "Rollback", "Alter", "As", "Asc", "Desc", "Count", "By",
			//"Top", "Union", "Values", "Table", "View", "Distinct",
			//"Add", "And", "Or", "Any", "All", "Avg", "Sum", "Call", "Then", "Min", "Max", "Like", "Join", "Between", "For", "Exists",
			//"If", "Else", "Goto", "In", "Not", "NULL", "On", "Off", "Of", "Restrict", "Set", "To", "Unique", "When", "Where", "While",
			////not used frequently
			//"Group", "Full", "Grant", "Having", "Is", "Loop"
		//};
		vector<string> vsKeywords = {
			"ALL", "ASC", "AS", "ALTER", "AND", "ANY", "ADD", "AUTO_INCREMENT",
			"BETWEEN", "BOTH", "BY",
			"CALL", "CHANGE", "CHECK", "COLUMNS", "COLUMN", "CROSS", "CREATE", "COMMIT", "CHECK", "CASE", "CONSTRAINT", "CLOB",
			"DATABASES", "DATABASE", "DATA", "DELAYED", "DESCRIIBE", "DESC", "DISTINCT", "DELETE", "DROP", "DEFAULT", "DBTIMEZONE",
			"ENCLOSED", "ESCAPED", "EXISTS", "EXPLAIN", "ELSE", "EXIT", "ELSEIF",
			"FIELDS", "FIELD", "FLUSH", "FOR", "FOREIGN", "FUNCTION", "FROM", "FULL",
			"GROUP", "GRANT", "GOTO", "GO",
			"HAVING",
			"IGNORE", "INDEX", "INFILE", "INSERT", "INNER", "INTO", "INDENTIFIED", "IN", "IS", "IF",
			"JOIN",
			"KEYS", "KILL", "KEY",
			"LEADING", "LIKE", "LIMIT", "LINES", "LOAD", "LOCAL", "LOCK", "LOW_PRIORITY", "LEFT", "LANGUAGE", "LOOP", "LESS",
			"MODIFY",
			"NATURAL", "NOT", "NULL", "NEXTVAL",
			"OPTIMIZE", "OPTION", "OPTIONALLY", "ORDER", "OUTFILE", "OR", "ORDER", "OUTER", "ON", "OF", "OFF", "ON", "ONCE",
			"PROCEEDURE", "PROCEDURAL", "PRIMARY",
			"READ", "REFERENCES", "REGEXP", "RENAME", "REPLACE", "RETURN", "REVOKE", "RLIKE", "RIGHT", "ROLLBACK",
			"SHOW", "SONAME", "STATUS", "STRAIGHT_JOIN", "SELECT", "SETVAL", "SET", "SCHEMA", "STATISTICS",
			"TABLES", "TEMINATED", "TO", "TOP", "TRAILING", "TRUNCATE", "TABLE", "TEMPORARY", "TRIGGER", "TRUSTED", "THEN",
			"UNIQUE", "UNLOCK", "USE", "USING", "UPDATE", "UNSIGNED", "UNION",
			"VALUES", "VARIABLES", "VIEW",
			"WITH", "WRITE", "WHERE",
			"XOR",
			"ZEROFILL"
		};
		AddKeywords(vsKeywords);
		vector<string> vsDataTypes = {
			"sql_variant", "datetime", "date", "smalldatetime", "float", "real", "long", "double", "decimal", "money", "smallmoney", "bigint", "int",
			"smallint", "tinyint", "bit", "ntext", "text", "image", "integer", "timestamp", "uniqueindentifier", "nvarchar", "nchar",
			"varchar", "char", "character", "binary", "nvarchar2"
		};
		AddKeywords(vsDataTypes);
		vector<string> vsFunctions = {
			"AVG", "COUNT", "MIN", "MAX", "SUM", "MONTH", "MOD", "UPPER", "LOWER", "LTRIM", "RTRIM", "CAST", "SUBSTR", "SUBSTRING", "COALESCE"
		};
		AddKeywords(vsFunctions);
		ColorOptions(CODEEDIT_PARSE_NO_CPP_COMMENT | CODEEDIT_PARSE_NO_BUILTIN_KEY_WORDS | CODEEDIT_PARSE_NO_CASESENSITIVE);
	}
	///end BETTER_SYNTAX_HIGHTLIGHT_SUPPORT_FOR_SQL_EDITOR
	void	OnDelete()
	{
		ReplaceSel("");
	}
	void	OnCopy()
	{
		Copy();
	}
	void	OnPaste()
	{
		Paste();
	}
	void	OnCut()
	{
		Copy();
		OnDelete();
	}
	void	OnSelectAll()
	{
		SetSel(0, -1);
	}
	bool	IsOnSelMode()
	{
		int nBegin, nEnd;
		GetSel(nBegin, nEnd);
		if ( nBegin == nEnd )
			return false;
		return true;
	}
	///Sophy 11/19/2010 ORG-1179-P9 SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
	void	Insert(LPCSTR lpcszText)
	{
		ReplaceSel(lpcszText);
	}
	///end SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
};
enum {
	SCRIPT_MENU_INVALID	= -1,
	SCRIPT_MENU_CUT,
	SCRIPT_MENU_COPY,
	SCRIPT_MENU_PASTE,
	SCRIPT_MENU_DELETE,
	SCRIPT_MENU_SEPARATOR,
	SCRIPT_MENU_SELECT_ALL,
	SCRIPT_MENU_LAST_ITEM,
};
class SQLContextMenu : public Menu
{
public:
	SQLContextMenu(bool bSelMode)
	{
		m_nChoice = SCRIPT_MENU_INVALID;
		Add(_L("Cut"), OnMenuItem, MF_STRING | (bSelMode ? MF_ENABLED : MF_GRAYED));
		Add(_L("Copy"), OnMenuItem, MF_STRING | (bSelMode ? MF_ENABLED : MF_GRAYED));
		Add(_L("Paste"), OnMenuItem, MF_STRING | MF_ENABLED);
		Add(_L("Delete"), OnMenuItem, MF_STRING | (bSelMode ? MF_ENABLED : MF_GRAYED));
		Add(NULL, OnMenuItem, MF_SEPARATOR);
		Add(_L("Select All"), OnMenuItem, MF_STRING);
	}
	void	OnMenuItem(UINT nPos){ m_nChoice = nPos; }
	bool	GetCommand(int& nCmd)
	{
		if ( m_nChoice > SCRIPT_MENU_INVALID && m_nChoice < SCRIPT_MENU_LAST_ITEM )
		{
			nCmd = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};

enum {
	TABLE_MENU_INVALID	= -1,
	TABLE_MENU_COPY,
	TABLE_MENU_LAST_ITEM,
};
class TableContextMenu : public Menu
{
public:
	TableContextMenu()
	{
		m_nChoice = TABLE_MENU_INVALID;
		Add(_L("Copy Name"), OnMenuItem, MF_STRING);
	}
	void	OnMenuItem(UINT nPos){ m_nChoice = nPos; }
	bool	GetCommand(int& nCmd)
	{
		if ( m_nChoice > TABLE_MENU_INVALID && m_nChoice < TABLE_MENU_LAST_ITEM )
		{
			nCmd = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};

enum {
	TLC_DATABASE	= 0,
	TLC_TABLEVIEW,
	TLC_FIELD,
};
#define	STR_READY_ATTRIB	"TableReady"
class TableListControl : public GridTreeControl
{
public:
	BOOL	SetTableList(const TreeNode& trTableList, LPCSTR lpcszConn)
	{
		SetReady(false);
		ClearAll();
		AddTreeNodes(trTableList);
		
		long lStartRow = 0;
		foreach(TreeNode trTable in trTableList.FirstNode.Children)
		{
			string strTableName;
			trTable.SetAttribute(STR_DISPLAY_ATTRIB, IDR_WORKBOOKTYPE);
			if ( trTable.GetAttribute(STR_LABEL_ATTRIB, strTableName) )
			{
				lStartRow = FindRow(strTableName, 0, false, true, lStartRow);
				SetCollapsed(lStartRow, true);
			}
		}
	

		m_trTableTree=  trTableList.Clone(true);
		m_nProvType = (int)CPT_AUTO;
		m_strConnection = lpcszConn;
		SetReady(true);
		return TRUE;
	}
	BOOL	OnBeforeCollapse(long nRow, short nState, BOOL* pbCancel)
	{
		if ( !IsReady() )
			return FALSE;
		if ( flexOutlineCollapsed == nState )
			return FALSE;
		if ( TLC_TABLEVIEW != GetLevel(nRow) )
			return FALSE;
		
		string strTableLabel = GetCell(nRow, 0);
		TreeNode trTable = m_trTableTree.FindNodeByAttribute(STR_LABEL_ATTRIB, strTableLabel, TRUE, TRUE);
		int nReadyAttrib = 0;
		if ( !trTable || (trTable.GetAttribute(STR_READY_ATTRIB, nReadyAttrib) && nReadyAttrib == 1) )
			return FALSE;
		string strTableName;
		trTable.GetAttribute("TABLE_NAME", strTableName);
		trTable.RemoveChildrenWithPrefix(NULL);
		okutil_build_table_fields(m_strConnection, &m_nProvType, strTableName, &m_trTableTree);
		nReadyAttrib = 1;
		trTable.SetAttribute(STR_READY_ATTRIB, nReadyAttrib);
		
		SetReady(false);
		DeleteRow(nRow + 1); //remove junk node
		AddSubNodes(trTable, nRow);
		SetReady(true);
		return TRUE;
	}
	///Sophy 11/19/2010 ORG-1179-P9 SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
	BOOL	CheckSelItem(int nX, int nY)
	{
		long nRow, nCol;
		GetMouseCell(nRow, nCol);
		SelRow(nRow);
		return TRUE;
	}
	BOOL	GetSelName(string& strCopyStr)
	{
		long nRow = GetSelectedRow();
		TreeNode trNode = tree_get_node(m_trTableTree, nRow);
		if ( !trNode.IsValid() )
			return FALSE;
		int nLevel = GetLevel(nRow);
		if ( TLC_DATABASE == nLevel )
		{
			trNode.GetAttribute(STR_LABEL_ATTRIB, strCopyStr);
		}
		else if ( TLC_TABLEVIEW == nLevel )
		{
			trNode.GetAttribute(STR_LABEL_ATTRIB, strCopyStr);
			MakeTableName(strCopyStr);
		}
		else if ( TLC_FIELD == nLevel )
		{
			TreeNode trTable = trNode.Parent();
			string strTableName;
			trTable.GetAttribute(STR_LABEL_ATTRIB, strTableName);
			trNode.GetAttribute("COLUMN_NAME", strCopyStr);
			MakeFieldName(strTableName, strCopyStr);
		}
		return TRUE;
	}
	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	BOOL	Hide(BOOL bHide = FALSE)
	{
		GetControl()->Visible = !bHide;
		return TRUE;
	}
	///end OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE

private:
#define	STR_ADD_BRACKET(_Name)				("[" + _Name + "]")
#define	STR_MAKE_TABLENAME(_Schema, _Table)	(_Schema.IsEmpty() ? _Table : _Schema + '.' + _Table)
#define	STR_MAKE_FIELDNAME(_Table, _Field)	(_Table.IsEmpty() ? _Field : _Table + '.' + _Field)
	void	MakeTableName(string& strTable)
	{
		string strSchema = "";
		string strTableName = strTable;
		int nDotPos = strTable.Find('.');
		if ( nDotPos > 0 )
		{
			strSchema = strTable.Left(nDotPos);
			strTableName = strTable.Right(strTable.GetLength() - nDotPos - 1);
		}
		int nSpacePos = strTableName.Find(' ');
		if ( nSpacePos > 0 )
			strTableName = STR_ADD_BRACKET(strTableName);
		strTable = STR_MAKE_TABLENAME(strSchema, strTableName);
	}
	void	MakeFieldName(string& strTableName, string& strFieldName)
	{
		MakeTableName(strTableName);
		int nSpacePos = strFieldName.Find(' ');
		if ( nSpacePos > 0 )
			strFieldName = STR_ADD_BRACKET(strFieldName);
		strFieldName = STR_MAKE_FIELDNAME(strTableName, strFieldName);
	}
	///end SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
protected:
	TreeNode		m_trTableTree;
	string			m_strConnection;
	int				m_nProvType;
};

///Jasmine 07/20/2011 ORG-3106-S3-2-7 GENERAL_COPY_GRID_VALUE
////this is in theme_utils.c, I dont want to include theme_utils here, so just declare the prototype and link to it.
//bool copy_to_clipboard(const string& str, bool bEmptyFirst = true, bool bUseOriginFormat = true);
///End GENERAL_COPY_GRID_VALUE

class QueryEditSplitter : public SplitterControl
{
public:
	QueryEditSplitter()
	{
	}
	BOOL	Init(int nCtrlID, WndContainer& wnd, LPCSTR lpcszDlgName)
	{
		SetGridSize(1, 2);
		m_nTableListID = GetDlgCtrlID(0, 0);
		m_nSQLID = GetDlgCtrlID(0, 1);
		InitMsgMap();
		SplitterControl::Init(nCtrlID, wnd, 0, lpcszDlgName);
		return TRUE;
	}
	
	BOOL	UpdateTree(const TreeNode& trTableList, LPCSTR lpcszConn)
	{
		if ( !trTableList || !trTableList.FirstNode || NULL == lpcszConn )
			return FALSE;
		return m_trTableList.SetTableList(trTableList, lpcszConn);
	}

	///Sophy 1/7/2011 ORG-1937 BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
	BOOL	SetEditorFont(int nFontSize)
	{
		CHARFORMAT cf;
		m_editSQL.GetDefaultCharFormat(cf);
		cf.yHeight = nFontSize;
		cf.dwMask = cf.dwMask | CFM_SIZE;
		return m_editSQL.SetDefaultCharFormat(cf);
	}
	int		GetEditorFont()
	{
		CHARFORMAT cf;
		m_editSQL.GetDefaultCharFormat(cf);
		int nFontSize = cf.yHeight;
		return nFontSize;
	}
	///end BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
	BOOL	OnReady()
	{
		m_trTableList.SetReady();
		return SplitterControl::OnReady();
	}
	
	BOOL	OnDestroy()
	{
		return SplitterControl::OnDestroy();
	}
	
	BOOL	GetScript(string& strSQL)
	{
		strSQL = m_editSQL.Text;
		return TRUE;
	}
	
	BOOL	SetScript(LPCSTR lpcszSQL, BOOL bEnable = TRUE)
	{
		m_editSQL.Text = lpcszSQL;
		///Sophy 2/21/2011 ORG-2165-P1 MAKE_SQL_EDITOR_READONLY_TO_ALLOW_SCROLL_BAR_VISIBLE
		//m_editSQL.Enable = bEnable;
		m_editSQL.SetReadOnly(!bEnable);
		///end MAKE_SQL_EDITOR_READONLY_TO_ALLOW_SCROLL_BAR_VISIBLE
		return TRUE;
	}
	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	BOOL	HideTableList(BOOL bHide = FALSE)
	{
		///Sophy 2/14/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
		if ( bHide )
		{
			GetSplitterGap(m_nSplitterGap);
			GetColSize(0, m_nTableListWidth);
			SetSplitterGap(0);
			SetColSize(0, 0);
		}
		else
		{
			if ( m_nSplitterGap != 0 )
				SetSplitterGap(m_nSplitterGap);
			else
				GetSplitterGap(m_nSplitterGap);
			if ( m_nTableListWidth != 0 )
				SetColSize(0, m_nTableListWidth);
			else
			{
				GetColSize(0, m_nTableListWidth);
				if ( 0 == m_nTableListWidth )
				{
					m_nTableListWidth = 30;
					SetColSize(0, m_nTableListWidth);
				}
			}
		}
		///end OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
		return m_trTableList.Hide(bHide);
	}
	void	SetTableListWidth(int nWidth){ m_nTableListWidth = nWidth; }
	void	GetTableListWidth(int& nWidth) { nWidth = m_nTableListWidth; }
	///end OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	
protected:
	EVENTS_BEGIN
		ON_INIT(OnInitSplitter)
		ON_SIZE(OnResize)
		ON_READY(OnReady)
		ON_DESTROY(OnDestroy)
		ON_KEY(m_nSQLID, OnSQLChange)
		ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInitPaneSizs)
		ON_CONTEXTMENU(OnShowContextMenu)
		//GridTreeControl events
		ON_GRID_BEFORE_COLLAPSE(m_nTableListID, OnBeforeCollapse)
		///Sophy 11/19/2010 ORG-1179-P9 SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
		ON_GRID_DBLCLICK(m_nTableListID, OnDoubleClick)
		///end SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
	EVENTS_END
	BOOL	OnInitSplitter()
	{
		DWORD dwStyle = WS_CHILD | WS_VISIBLE | ES_MULTILINE| ES_AUTOVSCROLL | ES_AUTOHSCROLL | WS_VSCROLL | WS_HSCROLL | WS_EX_WINDOWEDGE | ES_WANTRETURN;
		CreatePane(m_editSQL, 0, 1, -1, -1, dwStyle);
		GUID clsID;
		CreateActiveXPane(clsID, 0, 0);
		m_trTableList.Init(m_nTableListID, *this, true, this);
		m_trTableList.SetAllowSelection(false);
		m_trTableList.SetSelection(flexSelectionByRow);
		///Sophy 1/7/2011 ORG-1937 BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
		//m_editSQL.SetFont(DEFAULT_GUI_FONT);
		m_editSQL.SetFont(ANSI_FIXED_FONT);
		CHARFORMAT cf;
		m_editSQL.GetDefaultCharFormat(cf);
		cf.yHeight = SQLEDIT_FONT_MEDIUM;
		strcpy(cf.szFaceName, "Courier New");
		m_editSQL.SetDefaultCharFormat(cf);		
		//double dd = m_editSQL.FontSize;
		//m_editSQL.FontSize = SQLEDIT_FONT_MEDIUM;
		///end BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
		m_editSQL.InitSyntax();	///Sophy 1/13/2011 ORG-2018-S1 BETTER_SYNTAX_HIGHTLIGHT_SUPPORT_FOR_SQL_EDITOR
		///Sophy 2/14/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
		m_nSplitterGap = m_nTableListWidth = 0;
		///end OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
		SetReady();
		return TRUE;
	}
	
	
	BOOL	OnSQLChange(Control ctrl, UINT uMsg, UINT wParam, UINT lParam)
	{
		///Sophy 2/21/2011 ORG-2165-P1 MAKE_SQL_EDITOR_READONLY_TO_ALLOW_SCROLL_BAR_VISIBLE
		if ( GetWindowLong(m_editSQL.GetSafeHwnd(), GWL_STYLE) & ES_READONLY ) //ignore any change if it is readonly
			return FALSE;
		///end MAKE_SQL_EDITOR_READONLY_TO_ALLOW_SCROLL_BAR_VISIBLE
		Window wndParent = GetParent();
		if ( wndParent )
 			wndParent.PostMessage(WM_SQL_SCRIPT_CHANGE, wParam, lParam);
		return FALSE;
	}
	
	BOOL	OnShowContextMenu(UINT nResID, int nX, int nY)
	{
		if ( nResID == m_nSQLID )
			return ShowScriptContextMenu(nX, nY);
		///Sophy 11/19/2010 ORG-1179-P9 SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
		else if ( nResID == m_nTableListID )
		{
			return ShowTableListContextMenu(nX, nY);
		}
		///end SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
		return FALSE;
	}
	
	BOOL	OnBeforeCollapse(Control ctrl, long nRow, short nState, BOOL* pbCancel)
	{
		return m_trTableList.OnBeforeCollapse(nRow, nState, pbCancel);
	}
	///Sophy 11/19/2010 ORG-1179-P9 SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
	void	OnDoubleClick(Control ctrl)
	{
		///Sophy 2/22/2011 ORG-2165-P2 MORE_WORK_ON_LABTALK_SUBSTITUTED_STRING_SUPPORT
		if ( GetWindowLong(m_editSQL.GetSafeHwnd(), GWL_STYLE) & ES_READONLY )
			return;
		///end MORE_WORK_ON_LABTALK_SUBSTITUTED_STRING_SUPPORT
		string strCopyStr;
		m_trTableList.GetSelName(strCopyStr);
		m_editSQL.Insert(" " + strCopyStr + " " ); //add extra white spaces
	}
	///end SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
	BOOL	ShowScriptContextMenu(int nX, int nY)
	{
		int nCmd;
		SQLContextMenu cxtMenu(m_editSQL.IsOnSelMode());
		cxtMenu.TrackPopupMenu(0, nX, nY, GetWindow());
		if ( cxtMenu.GetCommand(nCmd) )
		{
			switch(nCmd)
			{
			case SCRIPT_MENU_CUT:
				m_editSQL.OnCut();
				break;
			case SCRIPT_MENU_COPY:
				m_editSQL.OnCopy();
				break;
			case SCRIPT_MENU_PASTE:
				m_editSQL.OnPaste();
				break;
			case SCRIPT_MENU_DELETE:
				m_editSQL.OnDelete();
				break;
			case SCRIPT_MENU_SELECT_ALL:
				m_editSQL.OnSelectAll();
				break;
			default:
				ASSERT(false);
				break;
			}
			return TRUE;
		}
		return FALSE;
	}
	///Sophy 11/19/2010 ORG-1179-P9 SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
	BOOL	ShowTableListContextMenu(int nX, int nY)
	{
		string strName;
		if ( !m_trTableList.CheckSelItem(nX, nY) )
			return FALSE;
		if ( !m_trTableList.GetSelName(strName) ) //no valid row selected
			return FALSE;
		int nCmd;
		TableContextMenu ctxMenu();
		ctxMenu.TrackPopupMenu(0, nX, nY, GetWindow());
		if ( ctxMenu.GetCommand(nCmd) )
		{
			switch(nCmd)
			{
			case TABLE_MENU_COPY:
				copy_to_clipboard(strName, true, false);
				break;
			default:
				ASSERT(false);
				break;	
			}
			return TRUE;
		}
		return FALSE;
	}
	///end SUPPORT_DOUBLE_CLICK_TO_COPY_PASTE_NAME
		
private:
	int					m_nTableListID;
	int					m_nSQLID;
	///Sophy 2/14/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	int					m_nSplitterGap;
	int					m_nTableListWidth;
	///end OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	TableListControl	m_trTableList;
	SQLEdit				m_editSQL;
};

enum {
 	xsSQL92 = 0,
 	xsMSSQL7 = 10,
	xsMSSQL2000 = 11,
	xsMSSQL2005 = 12,
	xsJet3 = 70,	// (for MS Access 97 and lower)
	xsJet4 = 71, 	// (for MS Access 2000 and higher)
	xsAuto = 2,		// (the component will try to detect SQL server automatically; not recommended to use if you already know your database server)
					// Please note: their tech support replied: Autodetection works fine for most of supported servers, but not for all of them.
};
#define	STR_QUERY_BUILDER								_L("Query Builder")
#define ON_QUERYBUILDER_CHANGED(_idCntl, _ocFunc)		ON_ACTIVEX_EVENT(212, _idCntl, _ocFunc, VTS_CTRL VTS_NONE )
class QueryBuilder : public ResizeDialog
{
public:
	QueryBuilder(LPCSTR lpcszConnStr, LPCSTR lpcszSQL) : ResizeDialog(IDD_SQL_BUILDER, "oDlg8")
	{
		m_strConnection = lpcszConnStr;
		m_strSQL = lpcszSQL;	///Sophy 11/9/2010 ORG-1179-P2 REMEMBER_AUTO_GENERATED_SQL_STATEMENT_BY_QUERYBUILDER
	}
	int		DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		return DoModal(hWndParent);
	}
	BOOL	GetQueryString(string& strSQL);
protected:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_SIZE(OnDlgResize)
		ON_QUERYBUILDER_CHANGED(IDC_ACTIVEQUERYBUILDERX, OnSQLChanged)
		ON_MENU_CMD(ID_QUERYBUILDER_OPTIONS, OnOptions)
	EVENTS_END
	
	BOOL	OnInitDialog();
	BOOL	OnDlgResize(int nType, int cx, int cy);
	BOOL	OnSQLChanged(Control ctrl);
	BOOL	OnOptions();
	BOOL	UpdateMetaData();
private:
	bool	m_bLockActiveX;
	Object	m_ActiveQueryBuilderX;
	string	m_strConnection;
	string	m_strSQL;
};

#define	STR_INI_SECTION_RECENT_ODQ_FILE		"RecentODQFileList"
#define	STR_INI_SECTION_RECENT_ODS_FILE		"RecentODSFileList"
#define	ID_FIRST_ODS_SEP					40000
#define	ID_FIRST_ODS						40001
#define	ID_LAST_ODS							40020
#define	ID_FIRST_ODQ_SEP					40021
#define	ID_FIRST_ODQ						40031
#define	ID_LAST_ODQ							41050

class DatabaseImportDlg : public MultiPaneDlg //ResizeDialog
{
public:
	DatabaseImportDlg(Worksheet& wks) : MultiPaneDlg(IDD_SQL_EDITOR, "oDlg8")
	{
		m_bConnected = false;
		m_nPreviewLines = 50;
		m_wksActive = wks;
	}
	
	int	DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		DoModal(hWndParent, DLG_HAS_APPLY);
		int nRet = (O_QUERY_BOOL(m_dwDlgState, DS_WKS_MODIFIED) ? IDOK : IDCANCEL);
		return nRet;
	}
protected:
	
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_SIZE(OnDlgResize)
		ON_READY(OnReady)
		ON_DESTROY(OnDestroy)
		//
		ON_SYSCOMMAND(OnSystemCommand)
		ON_BN_CLICKED(IDC_BTN_CLOSE, OnClose)
		ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)	///Sophy 1/10/2011 ORG-1937-P1 MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT	
		ON_CANCEL(OnExit) //map to same handler
		//
		//menu begin
		ON_CMD_UI_UPDATE(ID_IMPORT_BY_ODBC, OnUiUpdateMenu)
		ON_CMD_UI_UPDATE(ID_OPEN_QUERY_BUILDER, OnUiUpdateMenuCheckConnStr)
		ON_CMD_UI_UPDATE(ID_CONNECTION_SAVE, OnUiUpdateMenu)
		ON_CMD_UI_UPDATE(ID_CONNECTION_SAVEAS, OnUiUpdateMenu)
		ON_CMD_UI_UPDATE(ID_SHOW_CONNECTION_STR, OnUiUpdateMenu)	///Sophy 12/15/2010 ORG-1696-S1 MENU_ITEM_TO_SHOW_CONNECTION_STRING
		ON_CMD_UI_UPDATE(ID_CONNECTION_QUERY_SAVE, OnUiUpdateMenu)
		ON_CMD_UI_UPDATE(ID_CONNECTION_QUERY_SAVEAS, OnUiUpdateMenu)
		ON_CMD_UI_UPDATE(ID_SAVE_TO_WORKSHEET, OnUiUpdateMenu)
		ON_CMD_UI_UPDATE(ID_PREVIEW_SUBSTITUTED, OnUiUpdatePreviewLabTalkSubstituted)
		///Sophy 1/7/2011 ORG-1937 BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
		ON_MENU_CMD(ID_FONT_SMALLEST, OnFontSmallest)
		ON_MENU_CMD(ID_FONT_SMALLER, OnFontSmaller)
		ON_MENU_CMD(ID_FONT_MEDIUM, OnFontMedium)
		ON_MENU_CMD(ID_FONT_LARGER, OnFontLarger)
		ON_MENU_CMD(ID_FONT_LARGEST, OnFontLargest)
		///end BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
		///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
		ON_MENU_CMD(ID_SHOW_TABLE_LIST, OnShowTableList)
		///end OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
		ON_MENU_CMD(ID_IMPORT_BY_ODBC, OnEnableODBC)
		ON_MENU_CMD(ID_IMPORT_BY_ADO, OnEnableADO)
		ON_MENU_CMD(ID_UPDATE_COLUMN_LONGNAME, OnForceUpdateLongName)	///Sophy 11/10/2010 ORG-1179-P5 NEW_ADO_DLG_OPTION_TO_FORCE_UPDATE_COLUMN_LONGNAME
		ON_MENU_CMD(ID_AUTORESIZE_WORKSHEET, OnAutoResizeWorksheet)	///Sophy 11/15/2010 ORG-1179-P6 OPTION_FOR_RESIZE_WORKSHEET_COLUMNS_WHEN_IMPORT
		ON_MENU_CMD(ID_IMPORT_FILE_OPEN, OnFileOpen)
		ON_MENU_CMD(ID_CONNECTION_SAVE, OnODSFileSave)
		ON_MENU_CMD(ID_CONNECTION_SAVEAS, OnODSFileSaveAs)
		ON_MENU_CMD(ID_SHOW_CONNECTION_STR, OnShowConnStr)	///Sophy 12/15/2010 ORG-1696-S1 MENU_ITEM_TO_SHOW_CONNECTION_STRING
		ON_MENU_CMD(ID_EDIT_CONNECTION_STR, OnEditConnStr)	///Sophy 1/14/2011 ORG-2032-S1 CREATE_CONNECTION_FROM_RAW_CONN_STR_SUPPORT
		ON_MENU_CMD(ID_CONNECTION_QUERY_SAVE, OnODQFileSave)
		ON_MENU_CMD(ID_CONNECTION_QUERY_SAVEAS, OnODQFileSaveAs)
		ON_MENU_CMD(ID_SAVE_TO_WORKSHEET, OnSaveToWorksheet)
		ON_MENU_CMD_RANGE(ID_FIRST_ODS, ID_LAST_ODS, OnSelConnection)
		ON_MENU_CMD_RANGE(ID_FIRST_ODQ, ID_LAST_ODQ, OnSelQuery)
		ON_MENU_CMD(ID_CLOSE_DATABASE_IMPORT_DLG, OnExit)
		ON_MENU_CMD(ID_CONNECTION_NEW, OnNewConnection)
		ON_MENU_CMD(ID_OPEN_QUERY_BUILDER, OnQueryBuilder)
		///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		ON_MENU_CMD(ID_LABTALK_SETTINGS, OnLabtalkSettings)
		ON_MENU_CMD(ID_PREVIEW_SUBSTITUTED, OnPreviewSubstituted)
		///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		ON_MENU_CMD(ID_QUERY_PREVIEW, OnPreview)
		ON_MENU_CMD(ID_QUERY_IMPORT, OnImport)
		ON_MENU_CMD(ID_QUERY_HELP, OnAbout)
		ON_HELPINFO(OnHelp)
		//menu end
		ON_GETMINMAXINFO(OnMinMaxInfo)	//dialog position
		//splitter event
		ON_USER_MSG(WM_SQL_SCRIPT_CHANGE, OnSQLUpdate)
		//----
		//tab begin
		//ON_TAB_SEL_CHANGE(IDC_TAB_PREVIEW_MESSAGE, OnTabChange);  //Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
		//tab end
	EVENTS_END
	
	BOOL	OnInitDialog();
	BOOL	OnReady();
	BOOL	OnDlgResize(int nType, int cx, int cy);
	BOOL	OnDestroy();
	int		OnSystemCommand(int nCmd);
	//button events
	BOOL	OnClose(Control ctrl);
	///Sophy 1/10/2011 ORG-1937-P1 MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
	BOOL	OnShowBottomPane(Control ctrl);	
	BOOL	OnResize();
	BOOL	SetAllowResizing(BOOL bEnable);
	///end MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
	//menu events
	BOOL	OnUiUpdateMenu(CmdUI cmdUI);
	BOOL	OnUiUpdatePreviewLabTalkSubstituted(CmdUI cmdUI);
	BOOL	OnUiUpdateMenuCheckConnStr(CmdUI cmdUI);
	BOOL	OnEnableODBC();
	BOOL	OnEnableADO();
	
	///Sophy 1/7/2011 ORG-1937 BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
	BOOL	OnFontSmallest() { return SetEditorFont(SQLEDIT_FONT_SMALLEST); }
	BOOL	OnFontSmaller(){ return SetEditorFont(SQLEDIT_FONT_SMALLER); }
	BOOL	OnFontMedium(){ return SetEditorFont(SQLEDIT_FONT_MEDIUM); }
	BOOL	OnFontLarger(){ return SetEditorFont(SQLEDIT_FONT_LARGER); }
	BOOL	OnFontLargest() { return SetEditorFont(SQLEDIT_FONT_LARGEST); }
	BOOL	SetEditorFont(int nFontSize);
	///end BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
	BOOL	OnShowTableList();	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	///Sophy 11/10/2010 ORG-1179-P5 NEW_ADO_DLG_OPTION_TO_FORCE_UPDATE_COLUMN_LONGNAME
	BOOL	EnableUpdateLongName(bool bEnable = true);
	BOOL	OnForceUpdateLongName();
	///end NEW_ADO_DLG_OPTION_TO_FORCE_UPDATE_COLUMN_LONGNAME
	///Sophy 11/15/2010 ORG-1179-P6 OPTION_FOR_RESIZE_WORKSHEET_COLUMNS_WHEN_IMPORT
	BOOL	CheckMenuItem(int nMenuItemID, bool bCheck = true);
	BOOL	EnableAutoResize(bool bEnable = true);
	BOOL	OnAutoResizeWorksheet();
	///end OPTION_FOR_RESIZE_WORKSHEET_COLUMNS_WHEN_IMPORT
	BOOL	OnFileOpen();
	BOOL	OnODSFileSave();
	BOOL	OnODSFileSaveAs();
	BOOL	OnShowConnStr();	///Sophy 12/15/2010 ORG-1696-S1 MENU_ITEM_TO_SHOW_CONNECTION_STRING
	BOOL	OnEditConnStr();	///Sophy 1/14/2011 ORG-2032-S1 CREATE_CONNECTION_FROM_RAW_CONN_STR_SUPPORT
	BOOL	OnODQFileSave();
	BOOL	OnODQFileSaveAs();
	BOOL	OnSaveToWorksheet();
	BOOL	OnNewConnection();
	BOOL	OnQueryBuilder();
	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	BOOL	OnLabtalkSettings();
	BOOL	OnPreviewSubstituted();
	BOOL	UpdateQueryString();
	///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	BOOL	OnPreview();
	BOOL	OnImport();
	BOOL	OnSelConnection(int nID);
	BOOL	OnSelQuery(int nID);
	BOOL	OnExit();
	BOOL	OnAbout();
	BOOL	OnHelp(int& nHelpID, int nCtrlID);
	BOOL	OnSQLUpdate(DWORD dwParam = 0, DWORD lParam = 0);
	BOOL	OnEditQueryChange(Control ctrl);
	//tab events
	enum {
		TAB_PREVIEW	= 0,
		TAB_MESSAGE,
	};
//	BOOL	OnTabChange(Control ctrl);//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	//language.
	enum {
		QB_LANG_E = 0,
		QB_LANG_G = 1,
		QB_LANG_J = 8,
		QB_LANG_C = 5,
	};
	
	//data exchange
	void	UpdateData(bool bToGUI);
	void	ShowMessage(LPCSTR lpcszMessage);
	void	CheckShowError(int nErrCode);

protected:
	//internal used utils
	BOOL LoadFromFileList(MRFList* pList, int nID);
	BOOL LoadFile(LPCSTR lpcszFileName);
	BOOL SaveFile(LPCSTR lpcszFileName );
	BOOL SaveFileAs(string &strFileName, const StringArray &saFileTypes);
	BOOL SaveToWorksheet(Worksheet& wks);	///Sophy 1/7/2011 ORG-1915-P1 MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	/// AW 10/15/2010 ORG-1179 GET_DB_INFO_FOR_NEW_TOOL
	BOOL 	Connect(bool bResetQueryStr = true); 		
	BOOL	BuildDBTree();
	/// END GET_DB_INFO_FOR_NEW_TOOL
	//----
	///Sophy 11/11/2010 ORG-1179-P5 SAVE_NEW_ADO_DIALOG_SETTINGS_TO_REGISTRY
	BOOL	LoadSettings();
	BOOL	SaveSettings();
	///end SAVE_NEW_ADO_DIALOG_SETTINGS_TO_REGISTRY
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int		GetTotalHeight(bool bMin = false);
	int		GetMinClientTrackHeight();
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
private:
	//
	//----
	BOOL	onFileSave(int nFileType);
	BOOL	updateDlgTitle(bool bEdit);
	BOOL	showConnectionStrOnMsgTab();
	//----
	BOOL	hidePassWord(LPCTSTR lpcszOldConn, string &strConn);
	BOOL	updateFileName(LPCTSTR lpcszFileName);
	//----
	BOOL	checkActiveWksLinkDB(Worksheet &wks);
	BOOL	checkConnectToDB();
	//----
	BOOL	checkEnableODBC();
	BOOL	setEnableODBC(BOOL bEnable = TRUE);
	BOOL	hideTableList(BOOL bHide = FALSE);	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	int		checkSaveFile(int nFileType, UINT uType = MB_YESNOCANCEL);
	
	void	smartTarget();	///Sophy 12/3/2010 ORG-1647-P1 SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
private:
	//splitter
	QueryEditSplitter	m_MainSplitter;
	//Preview Related
	WorksheetControl	m_wksControl;
	WorksheetPage		m_wpPreview;
	Worksheet			m_wksPreview;
	int					m_nPreviewLines;
	//----
	
	//Shutcuts Related
	MRFList		m_MRODQs;
	MRFList		m_MRODSs;
	//----
	
	//Query Related
	string		m_strConnection;
	string		m_strSQL;
	string		m_strODQFileName;
	string		m_strODSFileName;
	string		m_strWorksheetName;
	string		m_strAutomaticSQL;	///Sophy 11/9/2010 ORG-1179-P2 REMEMBER_AUTO_GENERATED_SQL_STATEMENT_BY_QUERYBUILDER

	int			m_nFileType;
	//----
	
	//
	Edit		m_edtMessage;
	Edit		m_edtPreviewRows;	///Sophy 3/4/2011 ORG-1782-P5 OC_EDIT_CONTROL_NEED_TO_PROVIDE_SIMPLE_CONTEXT_MENU
	//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	//TabControl	m_tabPrevMsg;
	TabCtrlEx	m_tabPrevMsg;
	//End DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	Worksheet	m_wksActive;
	//state
	bool		m_bLoginPrompt;
	bool		m_bConnected;
	DWORD		m_dwDlgState;

	enum DlgState{
		DS_CONN_MODIFIED	= 0x0001,
		DS_QUERY_MODIFIED	= 0x0002,
		DS_WKS_MODIFIED		= 0x0004,
		DS_QUERY_PREVIEW	= 0x0008,	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		DS_TABLELIST_READY	= 0x0010,	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	};
	string		m_strScriptBeforeImport;	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	DWORD		m_dwOptions;
};

int	OpenQueryBuilder(Worksheet& wks);

#endif	//_DATABASEIMPORTDLG_H_
