/*------------------------------------------------------------------------------*
 * File Name: oQueryBuilder.c	   												*
 * Creation: Sophy 10/10/2010													*
 * Purpose: Used for ADO programming for Origin DB 								*
 * Copyright (c) OriginLab Corp.	2010										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	/// AW 10/15/2010 ORG-1179 GET_DB_INFO_FOR_NEW_TOOL							*
 *	Sophy 12/15/2010 ORG-1696-S1 MENU_ITEM_TO_SHOW_CONNECTION_STRING			*
 *	Sophy 1/14/2011 ORG-2032-S1 CREATE_CONNECTION_FROM_RAW_CONN_STR_SUPPORT		*
 *	Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE			*
 *	CPY 3/15/2011 ORG-2032-P3 CONN_STR_EDIT_SHOULD_BE_SEPARATED_FROM_SQL		*
 *  Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\Originlab\DialogEx.h>
#include <..\Originlab\GridControl.h>  
#include <..\Originlab\SplitterControl.h>
#include <okocUtils.h>
#include <..\Originlab\FileList.h>
#include <..\Originlab\query_utils.h>
#include <..\Originlab\DatabaseImportDlg.h>

#define	STR_DLG_NAME	"SQL Editor"
#define STR_UNTITLED	"<Untitled>"
#define	STR_UNTITLED_FILENAME		"Untitled"
#define STR_WARNING					_L("Warning")
#define	STR_SAVE_FILE_MSG			_L("Contents in %s has changed, do you want to save the changes?")
#define	IS_QUERY_SETTING_MODIFIED				(O_QUERY_BOOL(m_dwDlgState, DS_CONN_MODIFIED) || O_QUERY_BOOL(m_dwDlgState, DS_QUERY_MODIFIED))
#define	RESET_QUERY_SETTING_MODIFIED			(O_REMOVE_BIT(m_dwDlgState, (DS_CONN_MODIFIED | DS_QUERY_MODIFIED)))
#define	RESET_TABLELIST_READY					(O_REMOVE_BIT(m_dwDlgState, DS_TABLELIST_READY))
#define	IS_TABLELIST_READY						(O_QUERY_BOOL(m_dwDlgState, DS_TABLELIST_READY))


///Sophy 3/11/2011 ORG-2000 CLEAN_CODE_FOR_DATABASEIMPORTDLG
//when dwInputOptns = 0, then to remove dwMask from dwOptions
static void	update_options(DWORD dwInputOptns, DWORD& dwOptions, DWORD dwMask = OPTION_UPDATE_MASK)
{
	dwOptions = (dwOptions & ~dwMask) | (dwInputOptns & dwMask);
}
///end CLEAN_CODE_FOR_DATABASEIMPORTDLG

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

BOOL	QueryBuilder::OnInitDialog()
{
	ResizeDialog::OnInitDialog(IDC_ACTIVEQUERYBUILDERX, STR_QUERY_BUILDER);
	try
	{
		Control ctrl = GetItem(IDC_ACTIVEQUERYBUILDERX);
		m_ActiveQueryBuilderX = ctrl.GetActiveXControl();
		Object Localizer = m_ActiveQueryBuilderX.Localizer;
		switch(get_current_language())
		{
		case ORESLANG_ENGLISH:
			Localizer.CurrentLanguage = QB_LANG_E;
			break;
		case ORESLANG_GERMAN:
			Localizer.CurrentLanguage = QB_LANG_G;
			break;
		case ORESLANG_JAPANESE:
			Localizer.CurrentLanguage = QB_LANG_J;
			break;
		case ORESLANG_CHINESE:
			Localizer.CurrentLanguage = QB_LANG_C;
			break;
		default:
			ASSERT(false);
			break;
		}	
	}
	catch(int nErrCode)
	{
		m_ActiveQueryBuilderX = NULL;
		return FALSE;
	}
	return UpdateMetaData();
}

BOOL	QueryBuilder::OnDlgResize(int nType, int cx, int cy)
{
	MoveControlsHelper mchelper(this); //improve dialog refresh
	RECT rCancel;
	GetControlClientRect(IDCANCEL, rCancel);
	PositionControl(IDCANCEL, cx - RECT_WIDTH(rCancel) - GetControlGap(), cy - RECT_HEIGHT(rCancel) - GetControlGap());
	GetControlClientRect(IDCANCEL, rCancel); //get new position
	
	RECT rOK;
	GetControlClientRect(IDOK, rOK);
	PositionControl(IDOK, rCancel.left - GetControlGap() - RECT_WIDTH(rOK), rCancel.top);
	
	SizeControl(IDC_ACTIVEQUERYBUILDERX, cx - GetControlGap() * 2, cy - RECT_HEIGHT(rCancel) - 3 * GetControlGap());
	return TRUE;
}

BOOL	QueryBuilder::OnSQLChanged(Control ctrl)
{
	if ( m_bLockActiveX )
		return FALSE;
	m_bLockActiveX = true;
	m_strSQL = m_ActiveQueryBuilderX.FormattedSQL;
	m_bLockActiveX = false;
	return TRUE;
}

BOOL	QueryBuilder::OnOptions()
{
	try
	{
		m_ActiveQueryBuilderX.EditProperties();
	}
	catch(int nErrCode)
	{
		return FALSE;
	}
	return TRUE;
}

BOOL	QueryBuilder::UpdateMetaData()
{
	m_bLockActiveX = true;
	try
	{
		m_ActiveQueryBuilderX.ConnectionString = m_strConnection;
		m_ActiveQueryBuilderX.Connect();
		m_ActiveQueryBuilderX.RefreshMetadata();
		m_ActiveQueryBuilderX.SQLSyntax = xsAuto;   
		m_ActiveQueryBuilderX.Sql = m_strSQL;	///Sophy 11/9/2010 ORG-1179-P2 REMEMBER_AUTO_GENERATED_SQL_STATEMENT_BY_QUERYBUILDER
	}
	catch(int nErrCode)
	{
		m_bLockActiveX = false;
		return FALSE;
	}
	m_bLockActiveX = false;
	return TRUE;
}

BOOL	QueryBuilder::GetQueryString(string& strSQL)
{
	if ( m_ActiveQueryBuilderX == NULL )
		return FALSE;
	strSQL = m_strSQL;
	return !strSQL.IsEmpty();
}

static BOOL _get_file_type_str_by_type( int nFileType, StringArray &saFileType )
{
	BOOL bRet = TRUE;
	switch( nFileType )
	{
	case ADO_ODQ_FILE:
		saFileType.Add(STR_QUERY_FILE_DIALOG);
		break;
	case ADO_ODS_FILE:
		saFileType.Add(STR_DS_FILE_DIALOG);
		break;
	case ADO_NEW_FILE:
		saFileType.Add(STR_QUERY_FILE_DIALOG);
		saFileType.Add(STR_DS_FILE_DIALOG);
		break;
	default:
		bRet = FALSE;
		break;
	}
	
	return bRet;
}

BOOL	DatabaseImportDlg::OnInitDialog()
{
	///Sophy 1/10/2011 ORG-1937-P1 MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
	//ResizeDialog::OnInitDialog(IDC_TREE_TABLE_LIST, STR_DLG_NAME);
	vector<string> vsTips(2);
	vsTips[0] = _L("Show Bottom Panel");
	vsTips[1] = _L("Hide Bottom Panel");
	MultiPaneDlg::OnInitDialog(0, IDC_SHOW_BOTTOM, IDC_TAB_PREVIEW_MESSAGE, vsTips, STR_DLG_NAME);
	///end MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
	m_MainSplitter.Init(IDC_MAIN_SPLITTER, *this, STR_DLG_NAME);
	//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	//m_tabPrevMsg = GetItem(IDC_TAB_PREVIEW_MESSAGE);
	//if ( m_tabPrevMsg )
	//{
	// 	vector<string> vsTabs;
	// 	vsTabs.Add(_L("Preview"));
	// 	vsTabs.Add(_L("Message"));
	// 	for ( int ii = 0; ii < vsTabs.GetSize(); ii++ )
	// 		m_tabPrevMsg.InsertItem(ii, vsTabs[ii]);
	//}
	Control ctrlBottomPre = GetItem(IDC_LIST_PREVIEW);		
	DWORD dwStyles_Pre = ctrlBottomPre.GetStyle();	
	DestroyWindow(ctrlBottomPre.GetSafeHwnd());

	Control ctrlBottomMsg = GetItem(IDC_EDIT_MESSAGE);		
	DWORD dwStyles_Msg = ctrlBottomMsg.GetStyle();	
	DestroyWindow(ctrlBottomMsg.GetSafeHwnd());

	m_tabPrevMsg = GetItem(IDC_TAB_PREVIEW_MESSAGE);
	RECT rrEdit; 
	//End DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING

	m_wpPreview.Create(NULL, CREATE_HIDDEN);
	if ( m_wpPreview )
	{
	 	m_wksPreview = m_wpPreview.Layers();
	 	if ( m_wksPreview ) 
	 	{
	 		m_wksPreview.SetSize(0, 0);
			//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	 		//Control ctrl = GetItem(IDC_LIST_PREVIEW);
	 		//m_wksControl.CreateControl(ctrl.GetSafeHwnd());
			m_wksControl.CreateControl(m_tabPrevMsg.GetSafeHwnd(), &rrEdit, IDC_LIST_PREVIEW, dwStyles_Pre);
			m_tabPrevMsg.AddTab(m_wksControl.GetSafeHwnd(), _L("Preview"));
			//End DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING
	 		HWND hWnd = m_wksControl.GetSafeHwnd();
	 		m_wksControl.Attach(m_wpPreview.GetName());
	 		m_wksControl.SetHeadingType(WDC_LN_OR_SN_ONLY);
	 		m_wksControl.SetFont(DEFAULT_GUI_FONT);
	 		m_wksControl.EnableHeaderContext(FALSE);	///Sophy 12/3/2010 ORG-1631-S1 SUPPORT_ENABLE_DISABLE_COL_HEADER_CONTEXT_MENU
	 	}
	}
	m_edtMessage.CreateControl(m_tabPrevMsg.GetSafeHwnd(), &rrEdit, IDC_EDIT_MESSAGE, dwStyles_Msg);   //Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	m_tabPrevMsg.AddTab(m_edtMessage.GetSafeHwnd(), _L("Message"));	   //Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	//OnTabChange(m_tabPrevMsg);   //Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	//m_edtMessage = GetItem(IDC_EDIT_MESSAGE);   //Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 

	///Sophy 3/4/2011 ORG-1782-P5 OC_EDIT_CONTROL_NEED_TO_PROVIDE_SIMPLE_CONTEXT_MENU
	//Control ctrl = GetItem(IDC_EDIT_PREVIEW_ROWS);
	//ctrl.Text = m_nPreviewLines;
	m_edtPreviewRows.SetSimpleContextMenu();
	m_edtPreviewRows = GetItem(IDC_EDIT_PREVIEW_ROWS);
	m_edtPreviewRows.Text = m_nPreviewLines;
	///end OC_EDIT_CONTROL_NEED_TO_PROVIDE_SIMPLE_CONTEXT_MENU
	
	InitToolBar(IDR_SQL_EDITOR_TOOLBAR); //add toolbar
	//default filename
	m_strODQFileName = "";
	m_strODSFileName = "";
	
	m_strODSFileName = GetAppPath(false) + STR_UNTITLED_FILENAME;
	m_strODQFileName = GetAppPath(false) + STR_UNTITLED_FILENAME;
	add_file_extension(m_strODSFileName, STR_ODS);
	add_file_extension(m_strODQFileName, STR_ODQ);

	m_nFileType		 = ADO_NEW_FILE;

	LoadSettings();
	
	EnableUpdateLongName(O_QUERY_BOOL(m_dwOptions, OPTION_OVERWRITE_LONGNAME));
	
	EnableAutoResize(O_QUERY_BOOL(m_dwOptions, OPTION_AUTORESIZE_WORKSHEET));
	
	setEnableODBC(O_QUERY_BOOL(m_dwOptions, OPTION_BY_ODBC));
	
	checkActiveWksLinkDB( m_wksActive );
	
	//init recent file lists
	m_MRODSs.Init(GetSafeHwnd(), ID_RECENT_ODS1, STR_INI_SECTION_RECENT_ODS_FILE, NULL, ID_FIRST_ODS, ID_FIRST_ODS_SEP, 0, 13); //when modify the "File" menu, remember to update this position!!!
	if ( m_MRODSs.GetSize() > 0 )
	{
		m_MRODSs.RemoveMenuItem(ID_RECENT_ODS1);
		m_MRODSs.RemoveMenuItem(ID_FIRST_ODS_SEP);
	}
	m_MRODQs.Init(GetSafeHwnd(), ID_RECENT_ODQ1, STR_INI_SECTION_RECENT_ODQ_FILE, NULL, ID_FIRST_ODQ, ID_FIRST_ODQ_SEP, 0, 14);
	if ( m_MRODQs.GetSize() > 0 )
	{
		m_MRODQs.RemoveMenuItem(ID_RECENT_ODQ1);
		m_MRODQs.RemoveMenuItem(ID_FIRST_ODQ_SEP);	
	}
	updateDlgTitle(false);
	return TRUE;
}

BOOL	DatabaseImportDlg::OnReady()
{
	///Sophy 2/15/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	//m_MainSplitter.OnReady();
	int nWidth = 0;
	m_MainSplitter.GetTableListWidth(nWidth);
	///end OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	hideTableList(O_QUERY_BOOL(m_dwOptions, OPTION_NO_TABLELIST));
	///end OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	///Sophy 2/15/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	if ( nWidth > 0 )
		m_MainSplitter.SetTableListWidth(nWidth);
	///end OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	UpdateDlgSize();
	return TRUE;
}

#define	HORIZONTAL_GAP_FACTOR	5
#define	VERTICAL_GAP_FACTOR		2
BOOL	DatabaseImportDlg::OnDlgResize(int nType, int cx, int cy)
{
	///Sophy 1/10/2011 ORG-1937-P1 MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
	BOOL bBottomVisible = IsBottomPaneShown();
	
	vector<uint> vnCtrlIDs = {
		IDC_BTN_CLOSE,
		IDC_TAB_PREVIEW_MESSAGE,
		//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
		//IDC_EDIT_MESSAGE,   
		//IDC_LIST_PREVIEW,  
		//End ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
		IDC_EDIT_PREVIEW_ROWS,
		IDC_PREVIEW_LABEL
	}

	for ( int iCtrl = 0; iCtrl < vnCtrlIDs.GetSize(); iCtrl++ )
	{
		Control ctrl = GetDlgItem(vnCtrlIDs[iCtrl]);
		if ( ctrl)
			ctrl.Visible = bBottomVisible;
	}


	MoveControlsHelper mchelper(this); //improve dialog refresh
	
	RECT rSplitter;
	GetControlClientRect(IDC_MAIN_SPLITTER, rSplitter);
	RECT rShowHideBottom;
	GetControlClientRect(IDC_SHOW_BOTTOM, rShowHideBottom);
	if ( !bBottomVisible )
	{
		RECT	rWin;
		m_wndDlg.GetWindowRect(&rWin);
		m_wndDlg.ScreenToClient(&rWin);
		rSplitter.bottom = rWin.bottom - (RECT_HEIGHT(rShowHideBottom) + GetControlGap() * 2);
	}
	///end MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
	SizeControl(IDC_MAIN_SPLITTER, cx - GetControlGap() * HORIZONTAL_GAP_FACTOR, RECT_HEIGHT(rSplitter));
	GetControlClientRect(IDC_MAIN_SPLITTER, rSplitter);
	
	PositionControl(IDC_SHOW_BOTTOM, cx - RECT_WIDTH(rShowHideBottom) - GetControlGap(), rSplitter.bottom + GetControlGap());
	GetControlClientRect(IDC_SHOW_BOTTOM, rShowHideBottom);
	//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	//tab
	//RECT rTabControl;
	//m_tabPrevMsg.GetWindowRect(&rTabControl);

	//SizeControl(IDC_TAB_PREVIEW_MESSAGE, RECT_WIDTH(rSplitter), RECT_HEIGHT(rTabControl));
	//PositionControl(IDC_TAB_PREVIEW_MESSAGE, rSplitter.left, rShowHideBottom.top + VERTICAL_GAP_FACTOR * GetControlGap());
	//GetControlClientRect(IDC_TAB_PREVIEW_MESSAGE, rTabControl);

	//position close button
	//RECT rCloseBtn;
	//GetControlClientRect(IDC_BTN_CLOSE, rCloseBtn);
	//PositionControl(IDC_BTN_CLOSE, cx - RECT_WIDTH(rCloseBtn) -  VERTICAL_GAP_FACTOR * GetControlGap(), cy - RECT_HEIGHT(rCloseBtn) - GetControlGap());
	//GetControlClientRect(IDC_BTN_CLOSE, rCloseBtn);
	
	//message control
	//SizeControl(IDC_EDIT_MESSAGE, RECT_WIDTH(rSplitter), rCloseBtn.top - rShowHideBottom.bottom - 2 * GetControlGap());
	//PositionControl(IDC_EDIT_MESSAGE, rTabControl.left, rTabControl.bottom); 
	//SizeControl(IDC_LIST_PREVIEW, RECT_WIDTH(rSplitter), rCloseBtn.top - rShowHideBottom.bottom - 2 * GetControlGap());
	//PositionControl(IDC_LIST_PREVIEW, rTabControl.left, rTabControl.bottom); 
	RECT rTabControl;
	GetControlClientRect(IDC_TAB_PREVIEW_MESSAGE, rTabControl);
	RECT rCloseBtn;
	GetControlClientRect(IDC_BTN_CLOSE, rCloseBtn);
	PositionControl(IDC_BTN_CLOSE, cx - RECT_WIDTH(rCloseBtn) -  VERTICAL_GAP_FACTOR * GetControlGap(), cy - RECT_HEIGHT(rCloseBtn) - GetControlGap());
	GetControlClientRect(IDC_BTN_CLOSE, rCloseBtn);

	SizeControl(IDC_TAB_PREVIEW_MESSAGE, RECT_WIDTH(rSplitter),rCloseBtn.top-rShowHideBottom.bottom);
	PositionControl(IDC_TAB_PREVIEW_MESSAGE, rSplitter.left, rShowHideBottom.top + VERTICAL_GAP_FACTOR * GetControlGap());
	//End DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING

	///Sophy 1/10/2011 ORG-1937-P1 MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
	///end MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
	//positon the preivewlines edit field
	RECT rPreviewLines;
	GetControlClientRect(IDC_EDIT_PREVIEW_ROWS, rPreviewLines);
	PositionControl(IDC_EDIT_PREVIEW_ROWS, cx - RECT_WIDTH(rShowHideBottom) - GetControlGap() - RECT_WIDTH(rPreviewLines) - GetControlGap(), rShowHideBottom.top);
	RECT rPreviewLabel;
	GetControlClientRect(IDC_EDIT_PREVIEW_ROWS, rPreviewLines);
	GetControlClientRect(IDC_PREVIEW_LABEL, rPreviewLabel);
	PositionControl(IDC_PREVIEW_LABEL, rPreviewLines.left - RECT_WIDTH(rPreviewLabel) - GetControlGap(), rShowHideBottom.top);
	//OnTabChange(m_edtMessage);//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 

	return TRUE;
}


int		DatabaseImportDlg::OnSystemCommand(int nCmd)
{
	if ( SC_MINIMIZE == nCmd )
	{
		if ( IsRolledup() )
		{
		}
	}
	return ResizeDialog::OnSystemCommand(nCmd);
}

///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
class	StringRestoreHelper
{
public:
	StringRestoreHelper(string* pstrObj, BOOL bRestore)
	{
		m_bNeedRestore = bRestore;
		if ( m_bNeedRestore && NULL != pstrObj )
		{
			m_pstrObj = pstrObj;
			m_strValue = *pstrObj;
		}
	}
	~StringRestoreHelper()
	{
		if ( m_bNeedRestore && NULL != m_pstrObj )
		{
			*m_pstrObj = m_strValue;
		}
	}
private:
	BOOL	m_bNeedRestore;
	string*	m_pstrObj;
	string	m_strValue;
};
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT

BOOL	DatabaseImportDlg::OnImport()
{
	///Sophy 12/3/2010 ORG-1647-P1 SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
	smartTarget();
	///end SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
	if ( m_wksActive && m_bConnected )
	{
		///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		BOOL bSQLPreview = 	O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW);
		///Sophy 2/21/2011 ORG-2000-P9 PROPER_UPDATE_QUERY_STRING_ON_IMPORT_WITH_PREIVEW_SQL_MODE
		if ( !bSQLPreview )
			UpdateData(false);
		///end PROPER_UPDATE_QUERY_STRING_ON_IMPORT_WITH_PREIVEW_SQL_MODE
		StringRestoreHelper srHelpr(&m_strSQL, bSQLPreview); //if on preview mode, need to restore	
		ADOQUERYOPTION extOptions;
		extOptions.strBeforeScript = m_strScriptBeforeImport;
		///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		///Sophy 2/21/2011 ORG-2000-P9 PROPER_UPDATE_QUERY_STRING_ON_IMPORT_WITH_PREIVEW_SQL_MODE
		//UpdateData(false); //save changes.
		///end PROPER_UPDATE_QUERY_STRING_ON_IMPORT_WITH_PREIVEW_SQL_MODE
		save_query_to_worksheet(m_wksActive, m_strConnection, m_strSQL, m_dwOptions, &extOptions);
		int nRet = import_to_worksheet(m_wksActive, 0, 0, m_bLoginPrompt);
		CheckShowError(nRet);
		O_ADD_BIT(m_dwDlgState, DS_WKS_MODIFIED);
		return TRUE;
	}
	ShowMessage(_L("Target worksheet not valid or database not connected."));
	
	return FALSE;
}

BOOL	DatabaseImportDlg::OnPreview()
{
	m_wksPreview.SetSize(0, 0); //reset preview grid
	if ( m_wksPreview && m_bConnected )
	{
		///Sophy 1/14/2011 ORG-2000-P2 FORCE_OPEN_PREVIEW_TAB_ON_PREVIEW_CLICKED
		ShowBottomPane(true);
		///end FORCE_OPEN_PREVIEW_TAB_ON_PREVIEW_CLICKED
		///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		BOOL bSQLPreview = 	O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW);
		///Sophy 2/21/2011 ORG-2000-P9 PROPER_UPDATE_QUERY_STRING_ON_IMPORT_WITH_PREIVEW_SQL_MODE
		if ( !bSQLPreview )
			UpdateData(false);
		///end PROPER_UPDATE_QUERY_STRING_ON_IMPORT_WITH_PREIVEW_SQL_MODE
		StringRestoreHelper srHelpr(&m_strSQL, bSQLPreview); //if on preview mode, need to restore	
		ADOQUERYOPTION extOptions;
		extOptions.strBeforeScript = m_strScriptBeforeImport;
		///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		///Sophy 2/21/2011 ORG-2000-P9 PROPER_UPDATE_QUERY_STRING_ON_IMPORT_WITH_PREIVEW_SQL_MODE
		//UpdateData(false); //save changes.
		///end PROPER_UPDATE_QUERY_STRING_ON_IMPORT_WITH_PREIVEW_SQL_MODE
		if ( m_nPreviewLines <= 0 )
		{
			ShowMessage(_L("Invalid number of preview rows, should be more than 0."));
			return FALSE;
		}
		save_query_to_worksheet(m_wksPreview, m_strConnection, m_strSQL, m_dwOptions, &extOptions);
		int nRet = import_to_worksheet(m_wksPreview, 1, m_nPreviewLines, m_bLoginPrompt);
		if ( ADO_ERROR_NONE == nRet )
		{
			ShowMessage(_L("Preview updated successfully."));
			int nR1, nR2;
			m_wksPreview.GetBounds(nR1, 0, nR2, -1);
			Column col(m_wksPreview, 0);
			col.SetLongName("No.");
			vectorbase& vb = col.GetDataObject();
			vb.Data(1, nR2 + 1);
		}
		m_tabPrevMsg.SetCurSel(TAB_PREVIEW);
		CheckShowError(nRet);
		//OnTabChange(m_tabPrevMsg);//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
		m_wksControl.Update();
		COLORREF cLtGray = RGB(228, 228, 228);
		m_wksControl.SetColumnColor(0, cLtGray);
		string strPreviewLines = m_nPreviewLines;
		m_wksControl.SetColumnWidth(0, strPreviewLines.GetLength() + 2);
		return TRUE;
	}

	ShowMessage(_L("Preview worksheet not valid or database not connected."));
	return FALSE;
}

BOOL	DatabaseImportDlg::OnExit()
{
	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	{
		BOOL bSQLPreview = 	O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW);
		StringRestoreHelper srHelpr(&m_strSQL, bSQLPreview); //if on preview mode, need to restore	
		UpdateData(false);
	}
	///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	if ( checkSaveFile(ADO_ODQ_FILE) == IDCANCEL )
		return FALSE;;
	RESET_QUERY_SETTING_MODIFIED;
	m_bConnected = false;
	return PostMessage(WM_CLOSE);
}

///Sophy 1/10/2011 ORG-1937-P1 MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT
BOOL	DatabaseImportDlg::OnShowBottomPane(Control ctrl)
{
	MultiPaneDlg::OnShowBottomPane(ctrl);
	return OnResize();
}

BOOL	DatabaseImportDlg::OnResize()
{
	Control ctrlShowHideBtn;
	RECT rBtn;
	GetControlClientRect(IDC_SHOW_BOTTOM, rBtn, &ctrlShowHideBtn);
	int nHeight;
	if ( IsBottomPaneShown() )
	{
		Control ctrlGrid;
		RECT rGrid;
		GetControlClientRect(IDC_LIST_PREVIEW, rGrid, &ctrlGrid);
		Control ctrlCloseBtn;
		RECT rCloseBtn;
		GetControlClientRect(IDC_BTN_CLOSE, rCloseBtn, &ctrlCloseBtn);
		nHeight = RECT_HEIGHT(rGrid) + RECT_HEIGHT(rCloseBtn) + GetControlGap() * 3;
	}
	else
	{
		//SetAllowResizing(FALSE);
	}
	RECT	rWin;
	m_wndDlg.GetWindowRect(&rWin);
	m_wndDlg.ClientToScreen(&rBtn);
	rWin.bottom = rBtn.bottom + GetControlGap() + nHeight;
	m_wndDlg.MoveWindow(&rWin);
	//SetAllowResizing(TRUE);

	return TRUE;
}

BOOL	DatabaseImportDlg::SetAllowResizing(BOOL bEnable)
{
	int nStyle = GetWindowLong(Window::GetSafeHwnd(), GWL_STYLE);
	O_SET_BIT(nStyle, WS_THICKFRAME, bEnable);
	SetWindowLong(Window::GetSafeHwnd(), GWL_STYLE, nStyle);
	UpdateWindow(TRUE);
	return TRUE;
}
///end MORE_WORK_IMPROVE_SQL_EDITOR_DLG_FONT_AND_ARRANGEMENT

BOOL	DatabaseImportDlg::OnClose(Control ctrl)
{
	return OnExit();
}

BOOL	DatabaseImportDlg::OnDestroy()
{
	SaveSettings();
	m_MRODQs.SaveList();
	m_MRODSs.SaveList();
	if ( m_wpPreview )
		m_wpPreview.Destroy();
	m_MainSplitter.OnDestroy();
	MultiPaneDlg::OnDestroy();
	return TRUE;
}

BOOL	DatabaseImportDlg::OnUiUpdateMenu(CmdUI cmdUI)
{
	CmdUIInfo cmdInfo;
	cmdUI.GetMenuInfo(cmdInfo);
	if ( ID_IMPORT_BY_ODBC == cmdInfo.m_nID )
	{
		cmdUI.Enable(checkEnableODBC());
	}
	if ( ID_SAVE_TO_WORKSHEET == cmdInfo.m_nID 
		|| ID_CONNECTION_SAVE == cmdInfo.m_nID
		|| ID_CONNECTION_SAVEAS == cmdInfo.m_nID
		|| ID_CONNECTION_QUERY_SAVE == cmdInfo.m_nID
		|| ID_CONNECTION_QUERY_SAVEAS == cmdInfo.m_nID
		|| ID_SHOW_CONNECTION_STR == cmdInfo.m_nID	///Sophy 12/15/2010 ORG-1696-S1 MENU_ITEM_TO_SHOW_CONNECTION_STRING
		)
	{
		cmdUI.Enable(m_bConnected);
	}
	if ( ID_PREVIEW_SUBSTITUTED == cmdInfo.m_nID )
	{
		cmdUI.Enable(O_QUERY_BOOL(m_dwOptions, OPTION_LABTALK_SUPPORT));
	}
	return TRUE;
}

BOOL	DatabaseImportDlg::OnUiUpdatePreviewLabTalkSubstituted(CmdUI cmdUI)
{
	cmdUI.Enable(O_QUERY_BOOL(m_dwOptions, OPTION_LABTALK_SUPPORT));
	cmdUI.SetCheck(O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW));
	return TRUE;
}

BOOL	DatabaseImportDlg::OnUiUpdateMenuCheckConnStr(CmdUI cmdUI)
{
	cmdUI.Enable(m_bConnected);
	///Sophy 10/27/2011 ORG-3865-P1 ACTIVEQUERYBUILDER_NOT_SUPPORTED_IN_ORIGIN9_64BIT
#ifdef	_OWIN64
	cmdUI.Enable(false);
#endif	//_OWIN64
	///end ACTIVEQUERYBUILDER_NOT_SUPPORTED_IN_ORIGIN9_64BIT
	return TRUE;
}

///Sophy 1/7/2011 ORG-1937 BETTER_FONT_SUPPORT_FOR_SQL_EDITOR
BOOL	DatabaseImportDlg::SetEditorFont(int nFontSize)
{
	CheckMenuItem(ID_FONT_SMALLEST, SQLEDIT_FONT_SMALLEST == nFontSize);
	CheckMenuItem(ID_FONT_SMALLER, SQLEDIT_FONT_SMALLER == nFontSize);
	CheckMenuItem(ID_FONT_MEDIUM, SQLEDIT_FONT_MEDIUM == nFontSize);
	CheckMenuItem(ID_FONT_LARGER, SQLEDIT_FONT_LARGER == nFontSize);
	CheckMenuItem(ID_FONT_LARGEST, SQLEDIT_FONT_LARGEST == nFontSize);
	m_MainSplitter.SetEditorFont(nFontSize);
	return TRUE;
}
///end BETTER_FONT_SUPPORT_FOR_SQL_EDITOR

BOOL	DatabaseImportDlg::OnEnableODBC()
{
	return setEnableODBC(true);
}

BOOL	DatabaseImportDlg::OnEnableADO()
{
	return setEnableODBC(false);
}

///Sophy 11/10/2010 ORG-1179-P5 NEW_ADO_DLG_OPTION_TO_FORCE_UPDATE_COLUMN_LONGNAME
BOOL	DatabaseImportDlg::EnableUpdateLongName(bool bEnable)
{
	O_SET_BIT(m_dwOptions, OPTION_OVERWRITE_LONGNAME, bEnable);
	return CheckMenuItem(ID_UPDATE_COLUMN_LONGNAME, bEnable);
}

BOOL	DatabaseImportDlg::OnForceUpdateLongName()
{
	O_TOGGLE_BIT(m_dwOptions, OPTION_OVERWRITE_LONGNAME);
	return EnableUpdateLongName(O_QUERY_BOOL(m_dwOptions, OPTION_OVERWRITE_LONGNAME));
}
///end NEW_ADO_DLG_OPTION_TO_FORCE_UPDATE_COLUMN_LONGNAME

///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
BOOL	DatabaseImportDlg::OnShowTableList()
{
	O_TOGGLE_BIT(m_dwOptions, OPTION_NO_TABLELIST);	
	if ( m_bConnected )
		BuildDBTree();
	return hideTableList(O_QUERY_BOOL(m_dwOptions, OPTION_NO_TABLELIST));
}
///end OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
///Sophy 11/15/2010 ORG-1179-P6 OPTION_FOR_RESIZE_WORKSHEET_COLUMNS_WHEN_IMPORT
BOOL	DatabaseImportDlg::CheckMenuItem(int nMenuItemID, bool bCheck)
{
	DWORD dwFlags = MF_BYCOMMAND;
	string strLabel;
	HWND	hWnd = GetSafeHwnd();
	HMENU	hMenu = GetMenu(hWnd);
	Menu	mn(hMenu);
	mn.GetMenuString(nMenuItemID, strLabel, dwFlags);
	dwFlags |= bCheck ? MF_CHECKED : 0;
	mn.ModifyMenu(nMenuItemID, dwFlags, nMenuItemID, strLabel);
	return TRUE;
}

BOOL	DatabaseImportDlg::EnableAutoResize(bool bEnable)
{
	O_SET_BIT(m_dwOptions, OPTION_AUTORESIZE_WORKSHEET, bEnable);
	return CheckMenuItem(ID_AUTORESIZE_WORKSHEET, bEnable);
}

BOOL	DatabaseImportDlg::OnAutoResizeWorksheet()
{
	O_TOGGLE_BIT(m_dwOptions, OPTION_AUTORESIZE_WORKSHEET);
	return EnableAutoResize(O_QUERY_BOOL(m_dwOptions, OPTION_AUTORESIZE_WORKSHEET));
}
///end OPTION_FOR_RESIZE_WORKSHEET_COLUMNS_WHEN_IMPORT


BOOL	DatabaseImportDlg::setEnableODBC(BOOL bEnable)
{
	bEnable &= checkEnableODBC();
	O_SET_BIT(m_dwOptions, OPTION_BY_ODBC, bEnable);
	//update menu state.
	///Sophy 3/15/2011 ORG-2000 MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
	//HWND 	hWnd = GetSafeHwnd();
	//HMENU 	hMenu = GetMenu(hWnd);
	//Menu	mn(hMenu);
	//
	//DWORD dwFlags = MF_BYCOMMAND;
	//string strODBCLabel, strADOLabel;
	//mn.GetMenuString(ID_IMPORT_BY_ODBC, strODBCLabel, MF_STRING);
	//mn.GetMenuString(ID_IMPORT_BY_ADO, strADOLabel, MF_STRING);
	//if ( bEnable )
	//{
	//}
	//mn.ModifyMenu(ID_IMPORT_BY_ODBC, dwFlags | (bEnable ? MF_CHECKED : 0), ID_IMPORT_BY_ODBC, strODBCLabel);
	//mn.ModifyMenu(ID_IMPORT_BY_ADO, dwFlags | (bEnable ? 0 : MF_CHECKED), ID_IMPORT_BY_ADO, strADOLabel);
	CheckMenuItem(ID_IMPORT_BY_ODBC, bEnable);
	CheckMenuItem(ID_IMPORT_BY_ADO, !bEnable);
	///end MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
	return TRUE;
}
///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
BOOL	DatabaseImportDlg::hideTableList(BOOL bHide)
{
	O_SET_BIT(m_dwOptions, OPTION_NO_TABLELIST, bHide);
	m_MainSplitter.HideTableList(bHide);
	return CheckMenuItem(ID_SHOW_TABLE_LIST, !bHide);
}
///end OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
BOOL	DatabaseImportDlg::OnFileOpen()
{
	checkSaveFile(m_nFileType);
	StringArray saFileTypes = { STR_QUERY_FILE_DIALOG, STR_DS_FILE_DIALOG };
	
	string strFileName;
	if( get_new_filename( strFileName, saFileTypes, false ) )
	{
		updateFileName(strFileName);
		
		if( !LoadFile(strFileName) )
			return FALSE;
		///Sophy 3/23/2011 ORG-2480 CONNECT_FAIL_SHOULD_KEEP_CONNECTION_STRING_INTACT_FOR_USER_EDIT
		//UpdateData(true); this will be done within checkConnectToDB
		///end CONNECT_FAIL_SHOULD_KEEP_CONNECTION_STRING_INTACT_FOR_USER_EDIT
		return checkConnectToDB();
	}
	
	return FALSE;
}

BOOL DatabaseImportDlg::updateFileName(LPCTSTR lpcszFileName)
{
	int nFileType = get_file_type(lpcszFileName );
	m_nFileType = nFileType;	
	if ( m_nFileType == ADO_ODQ_FILE )
		m_strODQFileName = lpcszFileName;
	else if ( m_nFileType == ADO_ODS_FILE )
		m_strODSFileName = lpcszFileName;
	return TRUE;
}

BOOL	DatabaseImportDlg::OnODQFileSave()
{
	///Sophy 1/7/2011 ORG-1915-P1 MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	///Sophy 3/22/2011 ORG-2481 NEW_CONNECTION_SHOULD_DEFAULT_SAVE_TO_ACTIVE_WORKSHEET
	//if ( ADO_WKS_FILE == m_nFileType )
	if ( ADO_WKS_FILE == m_nFileType || ADO_NEW_FILE == m_nFileType )
	///end NEW_CONNECTION_SHOULD_DEFAULT_SAVE_TO_ACTIVE_WORKSHEET
	{
		Worksheet wks(m_strWorksheetName);
		///Sophy 3/22/2011 ORG-2481 NEW_CONNECTION_SHOULD_DEFAULT_SAVE_TO_ACTIVE_WORKSHEET
		if ( !wks && m_wksActive )
		{
			wks = m_wksActive;
		}
		///end NEW_CONNECTION_SHOULD_DEFAULT_SAVE_TO_ACTIVE_WORKSHEET
		return SaveToWorksheet(wks);
	}
	///end MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	if( onFileSave(ADO_ODQ_FILE) )
	{
		m_nFileType = ADO_ODQ_FILE;
		return TRUE;
	}
	
	return FALSE;
}

BOOL	DatabaseImportDlg::OnODQFileSaveAs()
{
	StringArray saFileTypes = {STR_QUERY_FILE_DIALOG};
	string strFileName = (m_nFileType == ADO_ODS_FILE ? m_strODSFileName : m_strODQFileName);
	return SaveFileAs(strFileName, saFileTypes);
}

///Sophy 1/7/2011 ORG-1915-P1 MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
BOOL	DatabaseImportDlg::SaveToWorksheet(Worksheet& wks)
{
	if ( wks.IsValid() && m_bConnected )
	{
		///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		BOOL bSQLPreview = O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW);
		{
			StringRestoreHelper srHelpr(&m_strSQL, bSQLPreview); //if on preview mode, need to restore	
			UpdateData(false); //save changes.
		}
		ADOQUERYOPTION extOptions;
		extOptions.strBeforeScript = m_strScriptBeforeImport;
		///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
		save_query_to_worksheet(wks, m_strConnection, m_strSQL, m_dwOptions, &extOptions);
		O_ADD_BIT(m_dwDlgState, DS_WKS_MODIFIED);
		if ( wks.GetNumCols() == 0 )
			wks.SetSize(-1, 2);
		RESET_QUERY_SETTING_MODIFIED;
		if( updateDlgTitle(false) )
		{
			return TRUE; 
		}
	}
	return FALSE;

}
///end MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
BOOL	DatabaseImportDlg::OnSaveToWorksheet()
{
	///Sophy 12/3/2010 ORG-1647-P1 SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
	smartTarget();
	///end SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
	return SaveToWorksheet(m_wksActive);
}

BOOL	DatabaseImportDlg::OnODSFileSave()
{
	if ( onFileSave(ADO_ODS_FILE) )
	{
		m_nFileType = ADO_ODS_FILE;
		return TRUE;
	}

	return FALSE;
}

BOOL	DatabaseImportDlg::OnODSFileSaveAs()
{
	StringArray saFileTypes = {STR_DS_FILE_DIALOG};
	string strFileName = (m_nFileType == ADO_ODS_FILE ? m_strODSFileName : m_strODQFileName);
	return SaveFileAs(strFileName, saFileTypes);
}
///Sophy 12/15/2010 ORG-1696-S1 MENU_ITEM_TO_SHOW_CONNECTION_STRING
BOOL	DatabaseImportDlg::OnShowConnStr()
{
	///Sophy 1/19/2011 ORG-2000-P2 FORCE_OPEN_MESSAGE_TAB_ON_SHOW_CONNECTION_STRING
	ShowBottomPane(true);
	///end FORCE_OPEN_MESSAGE_TAB_ON_SHOW_CONNECTION_STRING
	return showConnectionStrOnMsgTab();
}
///end MENU_ITEM_TO_SHOW_CONNECTION_STRING

///Sophy 1/14/2011 ORG-2032-S1 CREATE_CONNECTION_FROM_RAW_CONN_STR_SUPPORT
static	bool	_on_test_connection(TreeNode& tr)
{
	string strConn = tr.ConnStr.strVal;
	Object orsconn;
	try
	{
		orsconn = CreateObject("ADODB.Connection");
		orsconn.ConnectionString = strConn;
		orsconn.Open();
	}
	catch(int nErr)
	{
		///Sophy 8/16/2012 ORG-6485-P3 TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
		//warning_msg_box(_L("Fail to create connection!"), true, 'I', MB_OK | MB_TASKMODAL);
		string strMsg = _L("Fail to create connection!");
		string strErrDetails;
		if ( check_get_last_error(orsconn, strErrDetails) )
		{
			strMsg += "\r\n" + strErrDetails;
		}
		warning_msg_box(strMsg, true, 'I', MB_OK | MB_TASKMODAL);
		///end TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
		return false;
	}
	warning_msg_box(_L("Connection successful."), true, 'I', MB_OK | MB_TASKMODAL);
	return true;
}
typedef int (*PFN_DYNABOX4)(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescript, LPCSTR lpcszTextOK, LPCSTR lpcszTextApply, PEVENT_FUNC pfnEvent, PAPPLY_FUNC pfnApply, HWND hWndParent);
static	int	_open_ConnStr_editor(TreeNode& tr, PAPPLY_FUNC pfnApply, HWND hWndParent = NULL)
{
	Function ff = Project.FindFunction("DynaBox4", "Originlab\\DynaBox");
	PFN_DYNABOX4 pfn = ff;
	if ( NULL == pfn )
		return IDCANCEL;
	return pfn(tr,  _L("Connection String Editor"), NULL, NULL, _L("Test"), NULL, pfnApply, hWndParent);
}
BOOL	DatabaseImportDlg::OnEditConnStr()
{
	GETN_TREE(tr);
	GETN_STR(hint, _L("Connection String"), "") GETN_HINT
	GETN_MULTILINE_TEXT(ConnStr, "", m_strConnection) GETN_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE("6-15") GETN_EDIT_DISPLAY_WIDTH_RANGE("120-190")
		GETN_MUTILINE_EDIT_ROLLUP_BUTTON
		GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_EDITOR_FIXED_FONT|DISPLAY_EDITOR_DEFAULT_FONT_SIZE);///Sophy 1/20/2011 ORG-2000-P4 GETN_MULTILINE_EDITOR_ALLOW_USE_DEFAULT_FONT_SIZE
	///Sophy 1/18/2011 ORG-2032-P1 PROPER_OPEN_DLG_FOR_CREATE_CONNECTION_FROM_RAW_CONN_STR
	tr.SetAttribute(STR_OPERATION_TRY, "Try");
	///end PROPER_OPEN_DLG_FOR_CREATE_CONNECTION_FROM_RAW_CONN_STR
	if ( IDOK == _open_ConnStr_editor(tr, _on_test_connection, GetSafeHwnd()) )
	{
		///Sophy 2/24/2011 ORG-2032-P2 PROPER_UPDATE_DLG_STATE_ON_EDIT_CONN_STR
		string strConn = m_strConnection;
		///end PROPER_UPDATE_DLG_STATE_ON_EDIT_CONN_STR
		m_strConnection = tr.ConnStr.strVal;
		///Sophy 2/24/2011 ORG-2032-P2 PROPER_UPDATE_DLG_STATE_ON_EDIT_CONN_STR
		if ( strConn.CompareNoCase(m_strConnection) != 0 )
		{
			O_ADD_BIT(m_dwDlgState, DS_CONN_MODIFIED);
			RESET_TABLELIST_READY;
			O_REMOVE_BIT(m_dwDlgState, DS_QUERY_PREVIEW);
			//---- CPY 3/15/2011 ORG-2032-P3 CONN_STR_EDIT_SHOULD_BE_SEPARATED_FROM_SQL
			/*
			///Sophy 3/11/2011 ORG-2000 CLEAN_CODE_FOR_DATABASEIMPORTDLG
			update_options(0, m_dwOptions, OPTION_LT_BITS);
			///end CLEAN_CODE_FOR_DATABASEIMPORTDLG
			m_strScriptBeforeImport = "";
			m_strSQL = "";
			*/
			//---- end CONN_STR_EDIT_SHOULD_BE_SEPARATED_FROM_SQL
		}
		///end PROPER_UPDATE_DLG_STATE_ON_EDIT_CONN_STR
		return checkConnectToDB();
	}
	return TRUE;

}
///end CREATE_CONNECTION_FROM_RAW_CONN_STR_SUPPORT

BOOL	DatabaseImportDlg::OnNewConnection()
{
	if ( checkSaveFile((m_nFileType != ADO_ODQ_FILE) ? ADO_ODS_FILE : ADO_ODQ_FILE, MB_YESNO) != IDNO )
	{
		RESET_QUERY_SETTING_MODIFIED;
	}
	///Sophy 11/11/2010 ORG-1179-P4 ALWAYS_RESET_QUERY_SETTINGS_ON_NEW_CONNECTION
	m_nFileType = ADO_NEW_FILE;
	m_strODQFileName = GetAppPath(false) + STR_UNTITLED_FILENAME;
	add_file_extension(m_strODQFileName, STR_ODQ);
	///end ALWAYS_RESET_QUERY_SETTINGS_ON_NEW_CONNECTION
	return Connect();
}

BOOL	DatabaseImportDlg::OnQueryBuilder()
{
	if ( !m_bConnected )
		return FALSE;
	///Sophy 10/27/2011 ORG-3865-P1 ACTIVEQUERYBUILDER_NOT_SUPPORTED_IN_ORIGIN9_64BIT
#ifdef	_OWIN64
	{
		///Sophy 12/2/2011 ORG-3935-S1 MSG_FOR_TOOLS_NOT_SUPPORTED_IN_ORIGIN_64BIT
		//warning_msg_box(_L("Query Builder is not supported in 64bit Origin."), true, 'E');
		string strMsg;
		strMsg.Format(STR_NOT_SUPPORT_MSG, _L("Query Builder"));
		warning_msg_box(strMsg, true, 'E');
		///end MSG_FOR_TOOLS_NOT_SUPPORTED_IN_ORIGIN_64BIT
		return FALSE;
	}
#endif	//_OWIN64
	///end ACTIVEQUERYBUILDER_NOT_SUPPORTED_IN_ORIGIN9_64BIT
	QueryBuilder qbd(m_strConnection, m_strAutomaticSQL);
	int nRet = qbd.DoModalEx(GetSafeHwnd());
	if ( IDOK == nRet )
	{
		if ( qbd.GetQueryString(m_strAutomaticSQL) )
		{
			if ( m_strSQL.CompareNoCase(m_strAutomaticSQL) != 0 )
			{
				OnSQLUpdate(0, 0);
			}
			m_strSQL = m_strAutomaticSQL;
			UpdateData(true); //to GUI
			return TRUE;
		}
	}
	return FALSE;
}

///Sophy 2/24/2011 ORG-2000-S2 OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
static	bool	_LT_Support_Change(TreeNode& tr, int nRow, int nCtrlType, Dialog& GetNDlg)
{
	tr.LTVarIgnoreQuote.Show = tr.AllowLTVar.nVal;
	return true;
}
///end OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES

///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
BOOL	DatabaseImportDlg::OnLabtalkSettings()
{
	if ( !O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW) )
		UpdateData(false);
	DWORD dwOptions = m_dwOptions;
	GETN_TREE(tr);
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_CHECK(AllowLTVar, _L("Enable LabTalk (%, $) Substitution"), O_QUERY_BOOL(m_dwOptions, OPTION_LABTALK_SUPPORT)) GETN_OPTION_EVENT(_LT_Support_Change)
	GETN_CHECK(LTVarIgnoreQuote, _L("Ignore Substitution Inside Single Quotes"), O_QUERY_BOOL(m_dwOptions, OPTION_LTPARSE_IGNORE_QUOTE)) 	///Sophy 2/24/2011 ORG-2000-S2 OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
	GETN_STR(hint, _L("Before Query Script"), "") GETN_HINT
	GETN_MULTILINE_TEXT(BeforeImportScript, "", m_strScriptBeforeImport) GETN_MULTILINE_EDIT_DISPLAY_ROW_HEIGHT_RANGE("5-20") GETN_EDIT_DISPLAY_WIDTH_RANGE("60-80")
		GETN_MUTILINE_EDIT_ROLLUP_BUTTON
		GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_EDITOR_FIXED_FONT|DISPLAY_EDITOR_DEFAULT_FONT_SIZE);///Sophy 1/20/2011 ORG-2000-P4 GETN_MULTILINE_EDITOR_ALLOW_USE_DEFAULT_FONT_SIZE
	if ( GetNBox(tr, _L("LabTalk Support Settings"), NULL, NULL, NULL, GetSafeHwnd()) )
	{
		O_SET_BIT(m_dwOptions, OPTION_LABTALK_SUPPORT, tr.AllowLTVar.nVal);
		O_SET_BIT(m_dwOptions, OPTION_LTPARSE_IGNORE_QUOTE, tr.LTVarIgnoreQuote.nVal);
		string strBeforeScript = tr.BeforeImportScript.strVal;
		if ( m_strScriptBeforeImport.CompareNoCase(strBeforeScript) != 0 || dwOptions != m_dwOptions )
		{
			m_strScriptBeforeImport = strBeforeScript;
			OnSQLUpdate(); //before script is part of query string
			///Sophy 2/18/2011 ORG-2000-P8 PROPER_UPDATE_LABTALK_SUBSTITUTED_STRING_AFTER_CHANGE_LT_VAR
			///Sophy 2/22/2011 ORG-2165-P2 MORE_WORK_ON_LABTALK_SUBSTITUTED_STRING_SUPPORT
			//if ( O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW) )
			//{
				//m_MainSplitter.SetScript(m_strSQL, false);
				//UpdateQueryString();
			//}
			if ( !O_QUERY_BOOL(m_dwOptions, OPTION_LABTALK_SUPPORT) )
				O_REMOVE_BIT(m_dwDlgState, DS_QUERY_PREVIEW);
			m_MainSplitter.SetScript(m_strSQL,  !O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW));
			UpdateQueryString();
			///end MORE_WORK_ON_LABTALK_SUBSTITUTED_STRING_SUPPORT
			///end PROPER_UPDATE_LABTALK_SUBSTITUTED_STRING_AFTER_CHANGE_LT_VAR
		}
	}
	return TRUE;
}
BOOL	DatabaseImportDlg::OnPreviewSubstituted()
{
	O_TOGGLE_BIT(m_dwDlgState, DS_QUERY_PREVIEW);
	CheckMenuItem(ID_PREVIEW_SUBSTITUTED, O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW));
	return UpdateQueryString();
}

BOOL	DatabaseImportDlg::UpdateQueryString()
{
	BOOL bSQLPreview = 	O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW);
	string strScript = "";
	m_MainSplitter.GetScript(strScript);
	if ( bSQLPreview )
	{
		m_strSQL = strScript;
		//----- CPY 3/14/2011 ORG-2000 MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
		/*
		LTStackHelper ltScope;
		if ( !m_strScriptBeforeImport.IsEmpty() )
		{
			LT_execute(m_strScriptBeforeImport);
		}
		///Sophy 2/17/2011 ORG-2000-P6 ARG_COPY_NEED_WAY_TO_SKIP_SUB_STRING_WITHIN_SINGLE_QUOTES
		//okutil_arg_copy(&strScript);
		///Sophy 2/24/2011 ORG-2000-S2 OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
		//okutil_arg_copy(&strScript, NULL, ARGC_NO_QUOTE_SUB);
		USHORT usCtrl = O_QUERY_BOOL(m_dwOptions, OPTION_LTPARSE_IGNORE_QUOTE) ? ARGC_NO_QUOTE_SUB : 0;
		okutil_arg_copy(&strScript, NULL, usCtrl);
		///end OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
		///end ARG_COPY_NEED_WAY_TO_SKIP_SUB_STRING_WITHIN_SINGLE_QUOTES
		*/
		process_before_query_script(m_strScriptBeforeImport, strScript, m_dwOptions);
		//----- end MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG

	}
	else
		strScript = m_strSQL;
	m_MainSplitter.SetScript(strScript, !bSQLPreview);
	return TRUE;
}
///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT

/// AW 10/15/2010 ORG-1179 GET_DB_INFO_FOR_NEW_TOOL
BOOL DatabaseImportDlg::Connect(bool bResetQueryStr)
{
	string strConn = m_strConnection;
	Tree myTree1;
	///Sophy 8/16/2012 ORG-6485-P3 TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
	Object		orsconn;
	Object		orsmsdac;
	///end TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
	try
	{
		///Sophy 8/16/2012 ORG-6485-P3 TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
		//Object		orsconn;
		//Object		orsmsdac;
		///end TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
		orsmsdac = CreateObject("DataLinks");
		if ( m_strConnection == "" )
		{
			orsconn = orsmsdac.PromptNew();
		}
		else
		{
			orsconn = CreateObject("ADODB.Connection");
			orsconn.ConnectionString = m_strConnection;
			if ( !orsmsdac.PromptEdit(orsconn) )
			{
				///Sophy 3/23/2011 ORG-2480 CONNECT_FAIL_SHOULD_KEEP_CONNECTION_STRING_INTACT_FOR_USER_EDIT
				//return FALSE; //cancel, not need to rebuild DB tree.
				throw 284; //force exception
				///end CONNECT_FAIL_SHOULD_KEEP_CONNECTION_STRING_INTACT_FOR_USER_EDIT
			}
		}
		///Sophy 11/18/2010 ORG-1493-P2 CHECK_GET_PASSWORD_WHEN_NOT_SAVE_IN_CONNECTION_STRING
		m_strConnection = orsconn.ConnectionString;
		string strUserID, strPassword;
		if ( check_is_need_login_prompt(m_strConnection, &strUserID, &strPassword) )
		{
			GETN_TREE(tr);
			GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
			GETN_STR(user,_L("User Name"), strUserID)
			GETN_PASSWORD(pwd, _L("Password"), "")
			if ( GetNBox(tr, _L("Login"), NULL, NULL, NULL, GetSafeHwnd()) )
			{
				add_password_to_connection_str(m_strConnection, tr.User.strVal, tr.Pwd.strVal, m_strConnection);
			}
			else
			{
				ShowMessage(_L("Fail to login!"));
				return FALSE;
			}
		}
		orsconn.ConnectionString = m_strConnection;
		orsconn.Open(); //check validate connection string.
		orsconn.Close();
		///end CHECK_GET_PASSWORD_WHEN_NOT_SAVE_IN_CONNECTION_STRING
	}
	catch(int nErr)
	{
		///Sophy 8/16/2012 ORG-6485-P3 TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
		//ShowMessage(_L("Fail to open connection."));
		string strMsg = _L("Fail to open connection.");
		string strErrDetails;
		if ( check_get_last_error(orsconn, strErrDetails) )
		{
			strMsg += "\r\n" + strErrDetails;
		}
		ShowMessage(strMsg);
		///end TRY_GET_MORE_DETAILS_INFO_WHEN_CONNECT_FAIL
		///Sophy 3/18/2011 ORG-2480 CONNECT_FAIL_SHOULD_KEEP_CONNECTION_STRING_INTACT_FOR_USER_EDIT
		//m_strConnection.Empty();
		m_bConnected = FALSE;
		UpdateData(true);
		return m_bConnected;
		///end CONNECT_FAIL_SHOULD_KEEP_CONNECTION_STRING_INTACT_FOR_USER_EDIT
	}

	if ( !m_strConnection.IsEmpty() )
	{
		BOOL bRebuild = FALSE;
		if ( strConn.CompareNoCase(m_strConnection) != 0 )
		{
			O_ADD_BIT(m_dwDlgState, DS_CONN_MODIFIED);
			RESET_TABLELIST_READY;
			bRebuild = TRUE;
		}
		
		m_bConnected = TRUE;
		if( bRebuild && BuildDBTree() )
		{
			showConnectionStrOnMsgTab();
		}
		///Sophy 11/9/2010 ORG-1179-P4 RESET_QUERY_STRING_WHEN_CHANGE_DATA_SOURCE
		if ( bResetQueryStr )
		{
			O_REMOVE_BIT(m_dwDlgState, DS_QUERY_PREVIEW);
			///Sophy 3/15/2011 ORG-2000 MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
			//O_REMOVE_BIT(m_dwOptions, OPTION_LABTALK_SUPPORT);
			/////Sophy 2/24/2011 ORG-2000-S2 OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
			//O_REMOVE_BIT(m_dwOptions, OPTION_LTPARSE_IGNORE_QUOTE);
			/////end OPTION_FOR_CTRL_PARSE_LTVAR_WITHIN_SINGLE_QUOTES
			update_options(0, m_dwOptions, OPTION_LT_BITS);
			///end MORE_CLEAN_CODE_FOR_DATABASEIMPORTDLG
			m_strScriptBeforeImport = "";
			m_strSQL = "";
		}
		UpdateData(true);
		setEnableODBC(O_QUERY_BOOL(m_dwOptions, OPTION_BY_ODBC));
		///end RESET_QUERY_STRING_WHEN_CHANGE_DATA_SOURCE
		updateDlgTitle(false);
	}
	else
	{
		m_bConnected = FALSE;
	}

	return m_bConnected;
}

BOOL	DatabaseImportDlg::BuildDBTree()
{
	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	if ( O_QUERY_BOOL(m_dwOptions, OPTION_NO_TABLELIST) || IS_TABLELIST_READY )
		return TRUE;
	///OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	Tree myTree1;
	waitCursor wc;
#ifdef	_DEBUG
	//int nStart = GetTickCount();
#endif	//_DEBUG
	if ( CER_NO_ERROR != okutil_build_tablelist_from_connection(m_strConnection, &myTree1) )
		return FALSE;
	
	O_ADD_BIT(m_dwDlgState, DS_TABLELIST_READY);	///Sophy 1/28/2011 ORG-2134 OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE

#ifdef	_DEBUG
	//int nEnd = GetTickCount();
	//printf("\nBuildDBTree causes %ld(ms)\n", nEnd - nStart);
#endif	//_DEBUG
	m_MainSplitter.UpdateTree(myTree1, m_strConnection);
	m_bConnected = true;
	m_strAutomaticSQL = "";	///Sophy 11/9/2010 ORG-1179-P2 REMEMBER_AUTO_GENERATED_SQL_STATEMENT_BY_QUERYBUILDER
	return TRUE;
}
/// END GET_DB_INFO_FOR_NEW_TOOL

///Sophy 11/11/2010 ORG-1179-P5 SAVE_NEW_ADO_DIALOG_SETTINGS_TO_REGISTRY
#define	STR_IMPORT_OPTIONS	"ImportOptions"
#define	STR_FONT_SIZE		"FontSize"
#define	STR_TABLELIST_WIDTH	"TableListWidth"	///Sophy 2/15/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
BOOL	DatabaseImportDlg::LoadSettings()
{
	BOOL bRet = TRUE;
	m_dwOptions = OPTION_OVERWRITE_LONGNAME | OPTION_AUTORESIZE_WORKSHEET; //init options
	bRet &= dlg_load_registry(STR_DLG_NAME, STR_IMPORT_OPTIONS, m_dwOptions, m_dwOptions);
	///Sophy 1/13/2011 ORG-1937-P2 SAVE_FONTSIZE_TO_REGISTRY
	DWORD dwFontSize = SQLEDIT_FONT_MEDIUM;
	bRet &= dlg_load_registry(STR_DLG_NAME, STR_FONT_SIZE, dwFontSize, SQLEDIT_FONT_MEDIUM);
	SetEditorFont(dwFontSize);
	///end SAVE_FONTSIZE_TO_REGISTRY
	///Sophy 2/15/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	DWORD	nWidth;
	bRet &= dlg_load_registry(STR_DLG_NAME, STR_TABLELIST_WIDTH, nWidth, 0);
	if ( nWidth > 0 )
		m_MainSplitter.SetTableListWidth(nWidth);
	///end OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	return bRet;
}

BOOL	DatabaseImportDlg::SaveSettings()
{
	BOOL bRet = TRUE;
	
	update_options(0, m_dwOptions, OPTION_LT_BITS);
	
	bRet &= dlg_save_to_registry(STR_DLG_NAME, STR_IMPORT_OPTIONS, m_dwOptions);
	///Sophy 1/13/2011 ORG-1937-P2 SAVE_FONTSIZE_TO_REGISTRY
	int nFontSize = m_MainSplitter.GetEditorFont();
	bRet &= dlg_save_to_registry(STR_DLG_NAME, STR_FONT_SIZE, nFontSize);
	///end SAVE_FONTSIZE_TO_REGISTRY
	///Sophy 2/15/2011 ORG-2134-S1 OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	int nWidth;
	m_MainSplitter.GetTableListWidth(nWidth);
	bRet &= dlg_save_to_registry(STR_DLG_NAME, STR_TABLELIST_WIDTH, nWidth);
	///end OC_SPLITTER_ALLOW_SHOW_ONE_PANE_REMOVE_SPLITTER_GAP
	return TRUE;
}
///end SAVE_NEW_ADO_DIALOG_SETTINGS_TO_REGISTRY

/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
// int		DatabaseImportDlg::GetTotalHeight(bool bMin)
// {
// 	if ( bMin && IsBottomPaneShown() )
int		DatabaseImportDlg::GetMinClientTrackHeight()
{
	if ( IsBottomPaneShown() )
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{
		int nGap = GetControlGap();
		RECT rSplitter;
		GetControlClientRect(IDC_MAIN_SPLITTER, rSplitter);
		RECT rShowHideBottom;
		GetControlClientRect(IDC_SHOW_BOTTOM, rShowHideBottom);
		int nHeight = RECT_HEIGHT(rSplitter) + RECT_HEIGHT(rShowHideBottom) + nGap * 2 + GetToolBarHeight() * 2;
        //Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
		//RECT rTabControl;
		//m_tabPrevMsg.GetWindowRect(&rTabControl);
		//nHeight += RECT_HEIGHT(rTabControl) + nGap;
		nHeight += m_tabPrevMsg.GetTabsHeight() + nGap;
		//End DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
		RECT rCloseBtn;
		GetControlClientRect(IDC_BTN_CLOSE, rCloseBtn);
		nHeight += RECT_HEIGHT(rCloseBtn) * 2 + nGap * 2;
		return nHeight;
	}
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//return MultiPaneDlg::GetTotalHeight(bMin);
	return MultiPaneDlg::GetMinClientTrackHeight();
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
}

BOOL DatabaseImportDlg::OnSelConnection(int nID)
{
	checkSaveFile(ADO_ODQ_FILE, MB_YESNO);
	return LoadFromFileList(&m_MRODSs, nID);
}

BOOL DatabaseImportDlg::OnSelQuery(int nID)
{
	if ( checkSaveFile(ADO_ODQ_FILE) == IDCANCEL )
		return FALSE;;
	return LoadFromFileList(&m_MRODQs, nID);
}

BOOL DatabaseImportDlg::LoadFromFileList(MRFList* pList, int nID)
{
	RESET_QUERY_SETTING_MODIFIED;
	O_REMOVE_BIT(m_dwDlgState, DS_QUERY_PREVIEW);
	string strFileName = pList->GetFromID(nID);
	if ( strFileName.IsFile() && LoadFile(strFileName) )
	{
		///Sophy 3/23/2011 ORG-2480 CONNECT_FAIL_SHOULD_KEEP_CONNECTION_STRING_INTACT_FOR_USER_EDIT
		//UpdateData(true); this will be done with in checkConnectToDB
		///end CONNECT_FAIL_SHOULD_KEEP_CONNECTION_STRING_INTACT_FOR_USER_EDIT
		return checkConnectToDB();
	}
	return FALSE;
}


BOOL DatabaseImportDlg::LoadFile(LPCSTR lpcszFileName)
{
	DWORD dwOptions;
	ADOQUERYOPTION extOptions;
	if ( !access_query_file(lpcszFileName, m_strConnection, m_strSQL, dwOptions, &extOptions, false) )
		return FALSE;
	m_strScriptBeforeImport = extOptions.strBeforeScript;
	///Sophy 3/11/2011 ORG-2000 CLEAN_CODE_FOR_DATABASEIMPORTDLG
	update_options(dwOptions, m_dwOptions);
	///end CLEAN_CODE_FOR_DATABASEIMPORTDLG
	hideTableList(O_QUERY_BOOL(m_dwOptions, OPTION_NO_TABLELIST));
	RESET_TABLELIST_READY;
	///end OPTOIN_FOR_SHOW_HIDE_DATABASE_TABLE_TREE
	string strLoadFile(lpcszFileName);
	m_nFileType = get_file_type(strLoadFile);
	if ( m_nFileType == ADO_ODQ_FILE )
	{
		m_strODQFileName = strLoadFile;
		m_MRODQs.AddUpdateRecentFileList(strLoadFile);
		if ( m_MRODQs.GetSize() > 0 )
		{
			m_MRODQs.RemoveMenuItem(ID_RECENT_ODQ1);
			m_MRODQs.RemoveMenuItem(ID_FIRST_ODQ_SEP);
		}
	}
	else if ( m_nFileType == ADO_ODS_FILE )
	{
		m_strODSFileName = strLoadFile;
		m_MRODSs.AddUpdateRecentFileList(strLoadFile);
		if ( m_MRODSs.GetSize() > 0 )
		{
			m_MRODSs.RemoveMenuItem(ID_RECENT_ODS1);
			m_MRODSs.RemoveMenuItem(ID_FIRST_ODS_SEP);
		}
	}
	updateDlgTitle(false);
	return TRUE;
}

BOOL DatabaseImportDlg::SaveFileAs(string &strFileName, const StringArray &saFileTypes)
{
	if ( !m_bConnected )
	{
		ShowMessage(_L("No connection available."));
		return FALSE;
	}
	
	if( get_new_filename(strFileName, saFileTypes, true) )
		return SaveFile( strFileName );
	
	return FALSE;	
}

BOOL DatabaseImportDlg::SaveFile(LPCSTR lpcszFileName)
{
	if ( !m_bConnected )
	{
		ShowMessage(_L("No connection available."));
		return FALSE;
	}

	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	{
		BOOL bSQLPreview = 	O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW);
		StringRestoreHelper srHelpr(&m_strSQL, bSQLPreview); //if on preview mode, need to restore	
		UpdateData(false); //save settings
	}
	ADOQUERYOPTION extOptions;
	extOptions.strBeforeScript = m_strScriptBeforeImport;
	///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT

	if ( !access_query_file(lpcszFileName, m_strConnection, m_strSQL, m_dwOptions, &extOptions, true) )
		return FALSE;
	
	m_nFileType = get_file_type(lpcszFileName);
	if ( m_nFileType == ADO_ODQ_FILE )
	{
		m_strODQFileName = lpcszFileName;
		m_MRODQs.AddUpdateRecentFileList(lpcszFileName);
		if ( m_MRODQs.GetSize() > 0 )
		{
			m_MRODQs.RemoveMenuItem(ID_RECENT_ODQ1);
			m_MRODQs.RemoveMenuItem(ID_FIRST_ODQ_SEP);
		}
		okoc_AddToRecentFileList(lpcszFileName);	///Sophy 11/16/2010 ORG-1179-P11 UPDATE_RECENT_FILELIST_ON_MAIN_MENU_IF_SAVE_ODQ
	}
	else if ( m_nFileType == ADO_ODS_FILE )
	{
		m_strODSFileName = lpcszFileName;
		m_MRODSs.AddUpdateRecentFileList(lpcszFileName);
		if ( m_MRODSs.GetSize() > 0 )
		{
			m_MRODSs.RemoveMenuItem(ID_RECENT_ODS1);
			m_MRODSs.RemoveMenuItem(ID_FIRST_ODS_SEP);
		}
	}
	RESET_QUERY_SETTING_MODIFIED;
	if( updateDlgTitle(false) )
	{
		return TRUE; 
	}
	return FALSE;
}

BOOL	DatabaseImportDlg::OnAbout()
{
	SendMessage(WM_HELP);
	return TRUE;
}

BOOL	DatabaseImportDlg::OnHelp(int& nHelpID, int nCtrlID)
{
	nHelpID = IDD_SQL_EDITOR;
	return TRUE;
}

BOOL	DatabaseImportDlg::OnSQLUpdate(DWORD dwParam, DWORD lParam)
{
	if( !O_QUERY_BOOL(m_dwDlgState, DS_QUERY_MODIFIED) )
	{
		if( updateDlgTitle(true) )
		{
 			O_ADD_BIT(m_dwDlgState, DS_QUERY_MODIFIED);
			return TRUE;
		}

		return FALSE;
	}
	return FALSE;
}
//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
//BOOL	DatabaseImportDlg::OnTabChange(Control ctrl)
//{
//	int nSelTab = m_tabPrevMsg.GetCurSel();
//	GetItem(IDC_LIST_PREVIEW).Visible = ((TAB_PREVIEW == nSelTab) && IsBottomPaneShown());
//	GetItem(IDC_EDIT_MESSAGE).Visible = ((TAB_MESSAGE == nSelTab) && IsBottomPaneShown());
//	return TRUE;
//}
//End DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
void	DatabaseImportDlg::UpdateData(bool bToGUI)
{
	if ( bToGUI )
	{
		GetItem(IDC_EDIT_PREVIEW_ROWS).Text = m_nPreviewLines;
		m_MainSplitter.SetScript(m_strSQL, !O_QUERY_BOOL(m_dwDlgState, DS_QUERY_PREVIEW));
	}
	else
	{
		m_MainSplitter.GetScript(m_strSQL);
		m_nPreviewLines = atol(GetItem(IDC_EDIT_PREVIEW_ROWS).Text);
	}
}

void	DatabaseImportDlg::ShowMessage(LPCSTR lpcszMessage)
{
	if ( m_edtMessage )
	{
		m_edtMessage.Text = lpcszMessage;
		m_tabPrevMsg.SetCurSel(TAB_MESSAGE);
		//OnTabChange(m_tabPrevMsg);//Junon 7/18/2012 ORG-5146-P1 DIALOG_WITH_TABS_LIKE_NLEIT_FLICKERS_FREQUENTLY_WHEN_RESIZING 
	}
}

void	DatabaseImportDlg::CheckShowError(int nErrCode)
{
	if ( ADO_ERROR_NONE == nErrCode )
		return; //no error
	string strErrMsg;
	switch(nErrCode)
	{
	case ADO_ERR_CREATE_OBJ:
		strErrMsg = _L("Fail to create COM object.");
		break;
	case ADO_ERR_GET_SQL_STR:
		strErrMsg = _L("Fail to execute SQL statement.");
		break;
	case ADO_ERROR_CLOSE_CONN:
		strErrMsg = _L("Fail to close connection.");
		break;
	case ADO_ERROR_CLOSE_RECORDSET:
		strErrMsg = _L("Fail to close recordset.");
		break;
	case ADO_ERROR_OPEN_CONN:
		strErrMsg = _L("Fail to open connection.");
		break;
	case ADO_ERROR_OPEN_RECORDSET:
		strErrMsg = _L("Fail to open recordset.");
		break;
	default:
		ASSERT(false);
		break;
	}
	if ( !strErrMsg.IsEmpty() )
	{
		m_wksPreview.SetSize(0, 0);
		ShowMessage(strErrMsg)
	}
}

BOOL	DatabaseImportDlg::updateDlgTitle(bool bEdit)
{	
	string strFileName = STR_DLG_NAME + " - ";
	
	if ( ADO_NEW_FILE == m_nFileType )
		strFileName += STR_UNTITLED;
	///Sophy 1/7/2011 ORG-1915-P1 MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	else if ( ADO_WKS_FILE == m_nFileType )
	{
		strFileName += m_strWorksheetName;
	}
	///end MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	else if ( UNKNOWN_FILE != m_nFileType )
		strFileName += GetFileName(m_strODQFileName);

	if( bEdit && m_bConnected )
		strFileName += "*";

	m_wndDlg.Text	= strFileName;
	
	return TRUE;
}

BOOL	DatabaseImportDlg::hidePassWord(LPCTSTR lpcszOldConn, string &strConn)
{
	///Sophy 12/21/2010 ORG-1696-P1 PROPER_HIDE_SECURITY_INFORMATION_ON_SHOW_CONNECTION_STR
	//if ( !hide_value_by_key(lpcszOldConn, STR_PASSWORD, strConn) )
	//{
		//if( !hide_value_by_key(lpcszOldConn, STR_PWD, strConn) )
			//return FALSE;
	//}
	BOOL bHidden = FALSE;
	bHidden |= hide_value_by_key(lpcszOldConn, STR_PASSWORD, strConn);
	bHidden |= hide_value_by_key(strConn, STR_PWD, strConn);
	///end PROPER_HIDE_SECURITY_INFORMATION_ON_SHOW_CONNECTION_STR
	return bHidden;
}

BOOL	DatabaseImportDlg::checkEnableODBC()
{
	return (m_strConnection.Find(STR_ODBC_TAG) >= 0) ? TRUE : FALSE;
}


BOOL	DatabaseImportDlg::checkSaveFile(int nFileType, UINT uType)
{
	if ( !IS_QUERY_SETTING_MODIFIED || !m_bConnected )
		return IDNO; //not modified
	string strMsg;
	string strFileName = (ADO_ODS_FILE == nFileType) ? m_strODSFileName : m_strODQFileName;
	///Sophy 1/7/2011 ORG-1915-P1 MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	if ( ADO_WKS_FILE == m_nFileType )
		strFileName = m_strWorksheetName;
	///end MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	strMsg.Format(STR_SAVE_FILE_MSG, GetFileName(strFileName));
	int nRet;
	if ( (nRet = MessageBox(GetSafeHwnd(), strMsg, STR_WARNING, uType)) == IDYES )
	{
		///Sophy 1/7/2011 ORG-1915-P1 MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
		if ( ADO_WKS_FILE == m_nFileType )
		{
			Worksheet wks(strFileName);
			return SaveToWorksheet(wks);
		}
		///end MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
		onFileSave(nFileType);
		return TRUE;
	}
	else if ( nRet == IDNO )
	{
		RESET_QUERY_SETTING_MODIFIED;
	}
	return nRet;
}

///Sophy 12/3/2010 ORG-1647-P1 SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT
void	DatabaseImportDlg::smartTarget()
{
	Worksheet wks = Project.ActiveLayer();
	if ( is_worksheet_good_for_database_import(wks) )
		m_wksActive = wks;
	if ( !is_worksheet_good_for_database_import(m_wksActive) )
		m_wksActive.Create(NULL);
}
///end SMART_DETECT_TARGET_WORKSHEET_FOR_DATABASE_IMPORT

BOOL	DatabaseImportDlg::OnEditQueryChange(Control ctrl)
{
	if( !IS_QUERY_SETTING_MODIFIED )
	{
		if( updateDlgTitle(true) )
		{
			O_ADD_BIT(m_dwDlgState, DS_QUERY_MODIFIED);
			return TRUE;
		}

		return FALSE;
	}

	return FALSE;
}

BOOL DatabaseImportDlg::onFileSave(int nFileType)
{
	if( m_nFileType == UNKNOWN_FILE )
		return FALSE;
	string strFileName = (m_nFileType == ADO_ODS_FILE ? m_strODSFileName : m_strODQFileName);
	if( m_nFileType == ADO_NEW_FILE || m_nFileType != nFileType )
	{
		StringArray saFileType;
		if( _get_file_type_str_by_type(nFileType, saFileType) )
		{
			if( SaveFileAs(strFileName, saFileType) )
			{
				return TRUE;
			}		
		}
	}
	else 
		return SaveFile(strFileName); // same file type, save direct

	return FALSE;
}

BOOL DatabaseImportDlg::checkActiveWksLinkDB(Worksheet &wks)
{
	if( !wks.IsValid() )
		return FALSE;
	
	DWORD dwOptions;
	///Sophy 12/21/2010 ORG-1179-P18 PROPER_LOAD_ODBC_SETTINGS_FROM_WORKSHEET
	//if( !load_query_from_worksheet(wks, m_strConnection, m_strSQL, m_dwOptions) ) 
	///Sophy 1/12/2011 ORG-2000 SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	//if( !load_query_from_worksheet(wks, m_strConnection, m_strSQL, dwOptions) ) 
	ADOQUERYOPTION extOptions;
	if( !load_query_from_worksheet(wks, m_strConnection, m_strSQL, dwOptions, &extOptions) ) 
	///end SQL_EDIT_ADO_QUERY_ALLOW_LABTALK_VARIABLE_SUPPORT
	///end PROPER_LOAD_ODBC_SETTINGS_FROM_WORKSHEET
		return FALSE;
	///Sophy 12/21/2010 ORG-1179-P18 PROPER_LOAD_ODBC_SETTINGS_FROM_WORKSHEET
	m_strScriptBeforeImport = extOptions.strBeforeScript;
	///Sophy 3/11/2011 ORG-2000 CLEAN_CODE_FOR_DATABASEIMPORTDLG
	update_options(dwOptions, m_dwOptions);
	///end CLEAN_CODE_FOR_DATABASEIMPORTDLG
	///Sophy 1/7/2011 ORG-1915-P1 MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	m_nFileType = ADO_WKS_FILE;
	m_strWorksheetName = wks_get_book_sheet_name(wks);
	///end MORE_WORK_SQL_EDITOR_OPEN_FROM_QUERY_OBJECT
	return checkConnectToDB();	
}

BOOL DatabaseImportDlg::checkConnectToDB()
{
	Object orsconn;
	try
	{
		orsconn = CreateObject("ADODB.Connection");
		orsconn.ConnectionString = m_strConnection;
		orsconn.Open();
		m_bConnected = TRUE;
	}
	catch(int nErr)
	{
		//m_strConnection.Empty();
		return Connect(m_strConnection.IsEmpty());	
	}
	
	orsconn.Close();
	
	if( BuildDBTree() )
	{
		///Sophy 2/24/2011 ORG-2032-P2 PROPER_UPDATE_DLG_STATE_ON_EDIT_CONN_STR
		//RESET_QUERY_SETTING_MODIFIED;
		///end PROPER_UPDATE_DLG_STATE_ON_EDIT_CONN_STR
		UpdateData(true);
		///Sophy 11/19/2010 ORG-1179-P12 GET_OPTIONS_FROM_WORKSHEET_AND_UPDATE_MENU_ITEMS
		EnableUpdateLongName(O_QUERY_BOOL(m_dwOptions, OPTION_OVERWRITE_LONGNAME));
		EnableAutoResize(O_QUERY_BOOL(m_dwOptions, OPTION_AUTORESIZE_WORKSHEET));
		setEnableODBC(O_QUERY_BOOL(m_dwOptions, OPTION_BY_ODBC));
		///end GET_OPTIONS_FROM_WORKSHEET_AND_UPDATE_MENU_ITEMS
		///Sophy 2/24/2011 ORG-2032-P2 PROPER_UPDATE_DLG_STATE_ON_EDIT_CONN_STR
		//updateDlgTitle(false);
		updateDlgTitle(IS_QUERY_SETTING_MODIFIED);
		///end PROPER_UPDATE_DLG_STATE_ON_EDIT_CONN_STR
		showConnectionStrOnMsgTab();
		return TRUE;
	}

	return FALSE;

}

BOOL DatabaseImportDlg::showConnectionStrOnMsgTab()
{
	string strNewConn = m_strConnection;
	hidePassWord(m_strConnection, strNewConn);
	ShowMessage(_L("Connection string:\r\n") + strNewConn);
	
	return TRUE;
}

int	OpenDatabaseImportDlg(Worksheet& wks)
{
	DatabaseImportDlg myQB(wks);
	return myQB.DoModalEx();
}


//test
void	test_OpenDatabaseImportDlg()
{
	Worksheet wks = Project.ActiveLayer();
	if ( wks )
	{
		OpenDatabaseImportDlg(wks);
	}
}
