/*------------------------------------------------------------------------------*
 * File Name: CustomColumnFilterDlg.h		 									*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG		*
 *	Zech 08/10/2012 ORG-6255-S4 SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER			*
 *	Zech 08/09/2012 ORG-6255-P2 LIST_SAVED_FORMULAS_IN_CUSTOM_FILTER_DLG_FIRST_TIME_OPEN
 *	Zech 08/20/2012 ORG-6589-S1 SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE	*
 *	Zech 08/28/2012 ORG-6255-P6 PROHIBIT_SOME_GUI_WHEN_CUSTOM_DLG_OPENED		*
 *------------------------------------------------------------------------------*/

#define IDC_LOAD_COLUMN_QUERY_FORMULA_SAMPLE			IDC_FILE_OPEN		// Using small IDs as what SCV does
#define MAX_SAMPLE_COLUMN_QUERY_FORMULA_IN_MENU			15
#define IS_SAMPLE_COLUMN_QUERY_FORMULA(_nID)			((_nID) >= IDC_LOAD_COLUMN_QUERY_FORMULA_SAMPLE && (_nID) < IDC_LOAD_COLUMN_QUERY_FORMULA_SAMPLE + MAX_SAMPLE_COLUMN_QUERY_FORMULA_IN_MENU)

#define IDC_LOAD_COLUMN_QUERY_FORMULA					(IDC_LOAD_COLUMN_QUERY_FORMULA_SAMPLE + MAX_SAMPLE_COLUMN_QUERY_FORMULA_IN_MENU)
#define	MAX_COLUMN_QUERY_FORMULA_IN_MENU				50
#define IDC_LOAD_COLUMN_QUERY_FORMULA_END				(IDC_LOAD_COLUMN_QUERY_FORMULA + MAX_COLUMN_QUERY_FORMULA_IN_MENU)
#define IDC_RECENT_COLUMN_QUERY_FORMULA					IDC_XFM_RECENT_FILE_LIST_BEGIN
#define	IDC_RECENT_COLUMN_QUERY_FORMULA_END				(IDC_RECENT_COLUMN_QUERY_FORMULA + MAX_COLUMN_QUERY_FORMULA_IN_MENU)

#define STR_TXT_FILENAME_FAVORITE_NUMERIC_FORMULA		"numFilterCondition.txt"
#define STR_TXT_FILENAME_FAVORITE_TEXT_FORMULA			"textFilterCondition.txt"
#define STR_TXT_FILENAME_FAVORITE_DATETIME_FORMULA		"dateFilterCondition.txt"

// Ensure that vsItems should not be directly edited, it stands for the items in the menu
// vsItems should be modified only by MRU Menu Functions, e.g. ClearMRUMenu, SetMRUMenu, AddItemToMRUMenu
struct MRUMenuInfo 
{
	UINT	nEmptyID;
	UINT	nBeginID;
	UINT	nMaxSize;
	vector<string>	vsItems;
};

class CustomColumnFilterMenu : public Menu
{
public:
	CustomColumnFilterMenu(HMENU& hMenu, int nFormat);
	~CustomColumnFilterMenu();
public:
	enum CustomColumnFilterMRUType
	{
		CCFMRUT_SAMPLE,
		CCFMRUT_FAVORITE,
		CCFMRUT_RECENT,
	};

	BOOL			SetColumnFormat(int nFormat);

	BOOL			AddItemToList(CustomColumnFilterMRUType nType, const string& strItem);
	BOOL			ClearList(CustomColumnFilterMRUType nType);
	BOOL			SetList(CustomColumnFilterMRUType nType, const vector<string>& vsItems);
	void			GetList(CustomColumnFilterMRUType nType, vector<string>& vsItems);

	void			GetRecentFormulaList(vector<string>& vsItems);
private:
	MRUMenuInfo*	GetInfoPtr(CustomColumnFilterMRUType nType);

	BOOL			ClearMRUMenu(MRUMenuInfo& infoMRU);
	BOOL			SetMRUMenu(MRUMenuInfo& infoMRU, vector<string>& vsItems);
	BOOL			AddItemToMRUMenu(const string& strItem, MRUMenuInfo& infoMRU);
	static void		UpdateMRUArray(const string& strNew, vector<string>& vsArr);

	void			SaveRecentFormuaList();
	void			LoadRecentFormulaList();
	void			ClearSavedRecentFormulaList();

	void			LoadSampleFormulaList();
private:
	MRUMenuInfo		m_infoFavorites, m_infoRecFormula, m_infoSample;
};

/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
//class CustomColumnFilterDlg : public ResizeDialog
class CustomColumnFilterDlg : public MultiPaneDlg
/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
{
public:
	CustomColumnFilterDlg(Column& col);
	~CustomColumnFilterDlg();
	
	int		DoModalEx(HWND hParent = NULL);
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_DESTROY(OnDestroy)		/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG

	ON_SIZE(OnDlgResize)
	ON_SYSCOMMAND(OnSystemCommand)
	/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	ON_GETMINMAXINFO(OnMinMaxInfo)	
	ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
	/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG

	ON_MENU_CMD_RANGE(IDC_LOAD_COLUMN_QUERY_FORMULA_SAMPLE, IDC_LOAD_COLUMN_QUERY_FORMULA - 1, OnLoadSample)
	ON_MENU_CMD_RANGE(IDC_LOAD_COLUMN_QUERY_FORMULA, IDC_LOAD_COLUMN_QUERY_FORMULA_END, OnLoadFavoritesFormula)
	ON_MENU_CMD_RANGE(IDC_RECENT_COLUMN_QUERY_FORMULA, IDC_RECENT_COLUMN_QUERY_FORMULA_END, OnLoadRecentFormula)
	ON_MENU_CMD(IDC_COL_FILTER_CUSTOM_SAVE,		OnSaveFormula)
	ON_MENU_CMD(IDC_COL_FILTER_CUSTOM_SAVEAS,	OnSaveFormulaAs)
	
	/// Zech 08/10/2012 ORG-6255-S4 SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER
	ON_BN_CLICKED(IDC_TEST_BTN,			OnTestButtonclick)
	/// END SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER
	ON_BN_CLICKED(IDC_BUTTON_FUNC, 		OnFuncButtonClick)
	ON_BN_CLICKED(IDC_BUTTON_FUNC2, 	OnFuncButtonClick)
	ON_OK(OnOK)				
	ON_BN_CLICKED(IDC_APPLY, OnApply)
EVENTS_END
	
	BOOL	OnInitDialog();
	BOOL	OnReady();
	BOOL 	OnDlgResize(int nType, int cx, int cy);
	/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	//virtual
	BOOL	OnShowBottomPane(Control cntrl);
	/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	BOOL	OnFuncButtonClick(Control ctrl);
	BOOL	OnTestButtonclick(Control ctrl);	/// Zech 08/10/2012 ORG-6255-S4 SUPPORT_SELECT_IF_TRUE_IN_COLUMN_FILTER
	BOOL	OnOK();
	BOOL	OnApply(Control ctrl);

	BOOL	OnLoadSample(int nID);
	BOOL	OnLoadFavoritesFormula(int nID);
	BOOL	OnLoadRecentFormula(int nID);
	BOOL	OnSaveFormula();
	BOOL	OnSaveFormulaAs();

	void	OnAfterRollup(BOOL bClose);			/// Zech 08/28/2012 ORG-6255-P6 PROHIBIT_SOME_GUI_WHEN_CUSTOM_DLG_OPENED
protected:
	string	PopupFunctionMenu(int x, int y);
	BOOL	ConstructMenu();
	// Should get different IDs according to the type of the dialog
	int		GetCheckMenuCategoryIDs(Menu& menu, vector<uint>& vncatagoryIDs);
	BOOL	LoadCurrent();
	BOOL	LoadFormula(int nID, bool bUser);

	void	InitHintCtrls();
	void	InitFilterXCtrls();
	void	InitFormulaData();

	void	InsertFunction(Edit& ed, string& strText);
	int		GetMinClientWidth();
	int		GetMinClientTrackWidth();
	/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	//virtual
	int		GetBottomPaneSubControls(vector<uint>& vnCntrls);
	int		GetMinTopPaneHeight() {return 200;} 
	int		GetMinBottomPaneHeight() {return 100;}
	int		GetMinClientTrackHeight();
	void	GetBoundaryPositionBetweenPanes(int &nx, int &ny, int cx, int cy);
	void	ResizeSubPaneControls(RECT rr);
	void	ResizeMainPaneControls(RECT rr, bool bRight);
	int		UpdateBottomPaneSubControls();
	/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG

	string	DlgToFormula();
	BOOL	FormulaToDlg(LPCSTR slpcsz);

	/// Zech 08/20/2012 ORG-6589-S1 SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE
	void	UpdateDialogTitle();
	/// END SHOW_FUNC_NAME_IN_CUSTOM_DATA_FILTER_DB_TITLE

	BOOL	SetColumnFormat(int nFormat);
	void	LoadFavoritesFormulaList();
	void	SaveRecentFormuaList();
	void	LoadRecentFormulaList();

	void	LoadSampleFormulaList();
protected:	
	CommandColumnFilterData		m_data;
	Column						m_col;
	int							m_nFormat;
	string						m_strFavFunc;
	string						m_strFile;
	string						m_strCurFormulaName;
	string						m_strSectionRecentFormula;

	Edit						m_edCommand;
	Edit						m_edPrecript;
	Edit						m_edThisCol;
	Button						m_btnApply;
	CustomColFilterFuncMenu*	m_pMenu;
	CustomColumnFilterMenu*		m_pDlgMenu;
	Menu						m_menu;
};
