/*------------------------------------------------------------------------------------*
 * File Name:  ConvertSparseXYZ.c				 								      *
 * Creation:   ER, 10/5/01 														      *
 * Purpose: OriginC Source C file												      *
 * Copyright (c) OriginLab Corp.	2001										      *
 * All Rights Reserved															      *
 * 																				      *
 * Modification Log: 															      *
 * ER, 1/28/02: Changed xb, xe... variables to type double						      *
 * LAS, 1/23/03:  Changed sparse_returnstep from type int to type double 		      *
 * and 'step=vSortedDATA[2]-vSortedDATA[1];' to 'step=vSortedDATA[1]-vSortedDATA[0];' *
 *																					  *
 *----------------------------------------------------------------------------------- */
 
////////////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <data.h>
#include <math.h>

////////////////////////////////////////////////////////////////////////////////////
//
// prototype of functions in this file:
//
int MakeMat(double dXb, double dXe, double dXs, double dYb, double dYe, double dYs, string wksData, int iColx, int iColy, int iColz, string wksCopy);
double sparse_returnstep(string sortdataset);	
//
////////////////////////////////////////////////////////////////////////////////////


int MakeMat(double dXb, double dXe, double dXs, double dYb, double dYe, double dYs, string wksData, int iColx, int iColy, int iColz, string wksCopy)
{
	
	Dataset dsXin(wksData, iColx);
	Dataset dsYin(wksData, iColy);
	Dataset dsZin(wksData, iColz);

	Dataset dsXout(wksCopy,0);
	Dataset dsYout(wksCopy,1);
	Dataset dsZout(wksCopy,2);

	int ii, jj, count;
	int ixlen = 1 + (dXe - dXb) / dXs;
	int iylen = 1 + (dYe - dYb) / dYs;

	// set size of outuput worksheet columns
	dsXout.SetSize(ixlen * iylen);
	dsYout.SetSize(ixlen * iylen);
	dsZout.SetSize(ixlen * iylen);

	// fill output worksheet y column
	for (ii = 0; ii < ixlen; ii++)
	{
		for (jj = 0; jj < iylen; jj++)
		{
			dsYout[ii * iylen + jj] = dYb + jj * dYs;
		}
	}
	// fill output worksheet x column
	for (ii = 0; ii < ixlen; ii++)
	{
		for (jj = 0; jj < iylen; jj++)
		{
			dsXout[ii * iylen + jj] = dXb + ii * dXs;
		}
	}

	// now read thru data in input worksheet and try filling output worksheet
	int ilen = dsXin.GetSize();
	for (ii=0, count=0; ii < ilen; ii++)
	{
		double dXin = dsXin[ii];
		double dYin = dsYin[ii];
		double zin = dsZin[ii];
		int irow = ( (dXin - dXb) / dXs ) * iylen + (dYin - dYb) / dYs;
		//printf("%f %f %f %d \n",dXin, dYin, zin, irow);
		if( (dXin != dsXout[irow]) | (dYin != dsYout[irow]) )
		{
			printf("This point was discarded: x, y, z = %f %f %f", dXin, dYin, zin);
			count++;
		}
		else dsZout[irow] = zin;
	}
	
	return count;
}


double sparse_returnstep(string sortdataset)
{
	
		int iSize;	
		double step;
		Dataset dsRawDATA(sortdataset);
		iSize=dsRawDATA.GetSize();
		Dataset dsSortedDATA(dsRawDATA);	// Create temporary copy of raw data
		Data_sort(&dsSortedDATA);			// Sort temporary dataset

		vector<double> vSortedDATA;			// Create dynamic structure to hold sorted data
		vSortedDATA.SetSize(iSize);			// Dynamically set size of vector
		vSortedDATA=dsSortedDATA;			// Assign sorted datset to vector
		
		step=vSortedDATA[1]-vSortedDATA[0];
		
		dsRawDATA.Detach();
		dsSortedDATA.Detach();

		return step;	

}

