/*------------------------------------------------------------------------------*
 * File Name: ColumnProperties.c				 								*
 * Creation: Danice																*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice 7/29/04 v80106 QA70-6599 ROW_NUM_ONE_BASE_SAME_AS_OLD_DIALOG			*
 * Danice 8/11/04 v8.0114 QA70-6599 PROMPT_CHANGE_BEFORE_SET_OTHERS				*
 * SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 * DG 6/9/05 QA70-6599 v8.0248 REDESIGN_COL_PROPERTIES							*
 * DG 8/1/05 QA70-7883 v8.0277 SAME_AS_75_ADD_SELECTION							*
 *	ML 9/11/2006 PROPER_RETURN_VALUE											*
 * Jasmine 10/08/06 USE_SAME_NAME_AS_VIRTUAL_FUNC_IN_DYNA_DLG					*
 * Jasmine 10/18/06 FORCE_TO_UPDATE_CHANGE										*
 * Jasmine 10/19/06 HIDE_DLG_IF_SEL_INVALID										*
 * Jasmine 11/10/06 APPLY_OPTION_TO_ALL_RIGHT_COL								*
 * Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT									*
 * Jasmine 01/29/07 BLOCK_REPORT_SHEET											*
 * Jasmine 01/29/07 QA70-9287 EDIT_USER_TREE									*
 * Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE									*
 * Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 * Jasmine 03/29/07 REMEMBER_BRANCH_SETTING										*
 * Jasmine 08/13/07 MAKE_APPLY_UNDOABLE											*
 * Folger 09/05/07 SHOW_ERROR_STATUS_BAR										*
 * AW 10/11/07 MAT_PROP_DLG_SEND_TAB_ID_TO_HELP									*
 * Sophy 6/30/2009 v8.1051 QA80-13804 FAIL_TO_SEL_MULTIPLE_COLUMNS_WITH_COLUMN_PROPERTIES_DIALOG_OPEN
 * Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER				*
 * Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE	*
 * Hong 11/13/09 QA80-14502 WBK_ORGANIZER_USER_TREE_EDIT_GUI_THE_SAME_AS_COL_PROPERTY
 * Hong 02/03/10 QA80-15063 COL_PROPS_DLG_ADD_FILE_INFO							*
 * Jasmine 06/06/2011 ORG-3034-P1 FORGET_TO_UPDATE_AFTER_DELETE					*
 * Kyle 10/08/2011 ORG-4029 OPEN_SET_VALUES_DIALOG_FROM_COLUMN_PROPERTIES		*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#pragma labtalk(0) //--- CPY 7/26/05 hide all functions in this file from LT access, as XF should be used instead
#include "DialogEx.h"

#define  _DMSG(_str) //out_str(_str);

#define BASE_WINDOW ResizeDialog
#include "DynaDlg.h"
#include "DataObjectManager.h"
#include "UserTreeGUI.h"

#include <Profiler.h>
#include <Time.h>

#define HOUR_GLASS			waitCursor junk;
#define _SHOW_TIME			Profiler junk;
#define PROFILE_HRGLASS		HOUR_GLASS

#define WM_USER_ADD_VALUE_BY_SELECTION 		(WM_USER + 1010)
#define WM_USER_RESET_GUI					(WM_USER + 1011)

#include "ColumnProperties.h"

static ColDlg* s_pColPropertiesDlg;//---- CPY 7/8/05 PROPER_MODLESS_DLG_HANDLING
//static ColValuesDlg* s_pColValuesDlg;

typedef string (*FUNCFB) (HWND hParent = NULL);

BOOL ColDlg::OnInitDialog()
{
	ShowWindow(SW_HIDE); //CPY, start out hidden to avoid flashing when moving into last used position
	PROFILE_HRGLASS
	///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	//DynaDlg::OnInitDialog(IDC_COL_FORMAT_GRID, STR_DLG_NAME);
	DynaDlg::OnInitDialog(IDC_COL_PROPERTY_TAB, STR_DLG_NAME);
	m_tab = GetItem(IDC_COL_PROPERTY_TAB);
	///End ADD_TAB_FOR_MORE_CONTENT
	//GetActiveLayer();
	//ConstructTree();
	//updateDialogTitle();
	m_btnPrevious = GetItem(IDC_PREVIOUS_BTN);
	m_btnNext = GetItem(IDC_NEXT_BTN);
	
	///Kyle 10/08/2011 ORG-4029 OPEN_SET_VALUES_DIALOG_FROM_COLUMN_PROPERTIES
	m_btnSetValues = GetItem(IDC_SET_VALUES_BTN);
	if( m_btnSetValues )
	{
		RECT rr;
		GetClientRect(m_btnNext, rr);
		int nHeight = RECT_HEIGHT(rr);
		rr.left = rr.right + GetControlGap();
		rr.right = rr.left + nHeight;
		MoveControl(m_btnSetValues, rr);

		vector<string> vsTips(1);
		vsTips[0] = _L("Open Set Values Dialog");
		m_btnSetValues.Init(1, IDB_COL_SET_VALUES, 16, vsTips);
		
		m_btnSetValues.Visible = true;
	}
	///End OPEN_SET_VALUES_DIALOG_FROM_COLUMN_PROPERTIES
	
	m_btnApply = GetItem(IDC_APPLY_BTN);
	m_btnOK = GetItem(IDOK);
	
	InitDynaControl(IDC_COL_FORMAT_GRID);
	//SetGrayBackground(true);
	m_btnApply.Enable = false;
	
	///Jasmine 05/22/08 m_btnErrMessage_IS_IN_BASIC_CLASS_DYNA_DLG
	//m_btnErrMessage = GetItem(IDC_ERR_MESSAGE_BOX);		//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
	m_btnErrMessage.Visible = false;
	///End m_btnErrMessage_IS_IN_BASIC_CLASS_DYNA_DLG
	return true;
}
///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
BOOL ColDlg::OnInitSize(int &left, int &top, int &right, int  &bottom)
{
	return FALSE;
}
/// CPY 2007-10-10 v8.0723 WKS_PROP_DLG_SEND_TAB_ID_TO_HELP
BOOL ColDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	//// AW 10/11/07 MAT_PROP_DLG_SEND_TAB_ID_TO_HELP
	//nHelpID = IDD_COL_PROPERTY_TAB;
	if(getPageType() == EXIST_MATRIX)
	{
		nHelpID = IDD_MAT_PROPERTY_TAB;
	}
	else
		nHelpID = IDD_COL_PROPERTY_TAB;
	/// END MAT_PROP_DLG_SEND_TAB_ID_TO_HELP
	// will check other tabs later, for now, only show for Prop tab
	return TRUE;
}
/// end WKS_PROP_DLG_SEND_TAB_ID_TO_HELP

bool ColDlg::SetInitSize()
{
	//---- CPY 2/15/2007 DLGSIZEINFO_CALL_NEED_PREV_SIZ
	//RECT rDlg;
	//rDlg.top = 0;
	//SIZE sz;
	//GetDlgOptimalSize(sz);
	//rDlg.bottom = sz.cy;
	//rDlg.left = 0;
	//rDlg.right = sz.cx;
	//MoveWindow(&rDlg);
	SIZE sz;
	GetDlgOptimalSize(sz);
	MoveDialogToCenter(sz);
	//-----
	return true;
}
BOOL ColDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
	if(0 == HasPreviousSize(pSz->szDialogName))
		pSz->bStartHidden = true;

	SIZE sz;
	GetDlgOptimalSize(sz);
	///Joseph 02/15/07 ROLL_BRAK_TO_TD_DESIGN
	//pSz->top = -50;
	//pSz->left = -100;
	pSz->top = -1;
	pSz->left = -1;
	pSz->width = 100;
	pSz->height = 200;
	///End ROLL_BRAK_TO_TD_DESIGN
	return TRUE;
}	

bool ColDlg::GetDlgOptimalSize(SIZE& sz)
{
	RECT rGrid, rTab;
	Control ccGrid = GetItem(IDC_COL_FORMAT_GRID);
	GetClientRect(ccGrid, rGrid);
	GetClientRect(m_tab, rTab);
	int nTabHeight = rTab.bottom - rGrid.bottom + rGrid.top - rTab.top;
	int nTabWidth = rTab.right - rGrid.right + rGrid.left - rTab.left;
	RECT rOKButton, rNextButton;
	GetClientRect(m_btnOK, rOKButton);
	int nOKButtonHeight = rOKButton.bottom - rOKButton.top;
	Control ctrl = GetItem(IDC_NEXT_BTN);
	GetClientRect(ctrl, rNextButton);
	int nNextButtonHeight = rNextButton.bottom - rNextButton.top;

	int nxGrid,nyGrid;
	TREE_CTRL_VAR.GetOptimalSize(sz);
	/*debug
	Tree tr;
	tr = TREE_CTRL_VAR.GetTreeNode(0,0);

	out_tree(tr);
	*/
	int nEdge = GetControlGap();
	sz.cx = sz.cx + nTabWidth + 2 * nEdge;
	sz.cy = sz.cy + nTabHeight + nOKButtonHeight + nNextButtonHeight + 4 * nEdge;
	return true;
}
///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
//---
BOOL ColDlg::OnReady()
{
	SetInitReady();
	m_bIsReady = true;
	OnChangeLayer();//OnActivePageChange();	///Jasmine 10/08/06 USE_SAME_NAME_AS_VIRTUAL_FUNC_IN_DYNA_DLG
	LoadBranchSetting(STR_DLG_NAME);	///Jasmine 03/29/07 REMEMBER_BRANCH_SETTING	
	///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	if(0 == HasPreviousSize())
	{
		SetInitSize();
	}
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	ShowWindow(SW_NORMAL);	
	return true;
}

BOOL ColDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;
	//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
	//uint nButtonIDs[] = {IDOK, IDCANCEL, IDC_APPLY_BTN, IDC_UNDO_BTN, 0};
	//
	//RECT rr;
	//GetClientRect(m_btnOK, rr);
	//int nEdge = GetControlGap(), ny=cy-RECT_HEIGHT(rr);
	////ArrangeControlsRightLeft(nButtonIDs, cx, ny);
	////ny-=nEdge;
	//Control ccGrid = GetItem(IDC_COL_FORMAT_GRID);
	/////Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	//GetClientRect(m_tab, rr);
	//rr.right = cx-nEdge;
	//rr.bottom = ny-nEdge;;
	//MoveControl(m_tab, rr);
	//
	//m_tab.GetWindowRect(&rr);
	//ScreenToClient(&rr);
	//m_tab.AdjustRect(FALSE, &rr);
	//ccGrid.MoveWindow(&rr);
	/////End ADD_TAB_FOR_MORE_CONTENT
	//
	//MoveControlsHelper	_temp(this);	///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
	//ArrangeControlsRightLeft(nButtonIDs, cx, ny);
	resizeDialog(cx, cy);
	//------ End SHOW_ERROR_STATUS_BAR
	
	return TRUE;
}

BOOL ColDlg::OnClickOK()
{
	PROFILE_HRGLASS
	SetFocus(GetItem(IDOK).GetSafeHwnd());///Jasmine 10/18/06 FORCE_TO_UPDATE_CHANGE
	if(isChanged())
	{
		Control cc;
		OnApply(cc);
	}
	return true;
}
//---- CPY 7/8/05 PROPER_MODLESS_DLG_HANDLING
BOOL ColDlg::OnDestroy(void)
{
	SaveBranchSetting(STR_DLG_NAME);	///Jasmine 03/29/07 REMEMBER_BRANCH_SETTING	
	//--- CPY 10/26/06 COL_PROP_DIALOG_MUST_CLEAN_OBJ
	if(m_pDataOB)
	{
		delete m_pDataOB;  
		m_pDataOB = NULL;
		//out_str("OnDestroy found obj still not deleted");
	}
	//---
		
	DynaDlg::OnDestroy();
	if(m_bDeleteOnDestroy)
	{
		delete this;
		s_pColPropertiesDlg = NULL;
	}
	return true;
}
//----
BOOL ColDlg::OnClickCancel()
{
	return true;
}
///Jasmine 10/08/06 USE_SAME_NAME_AS_VIRTUAL_FUNC_IN_DYNA_DLG
//fix bug : dialog doesn't update when layer changes
//BOOL ColDlg::OnActiveDataChange()
BOOL ColDlg::OnChangeDataset()
{
	_DMSG("Dataset Change");
	if(!m_bIsReady)
		return true;
	GetActiveLayer();
	if(getPageType() == EXIST_MATRIX)
	{
		OnChangeLayer();//OnActiveLayerChange();
	}
	DynaDlg::OnChangeDataset();
	return true;
}

//BOOL ColDlg::OnActiveLayerChange( void)
BOOL ColDlg::OnChangeLayer()
{
	_DMSG("Layer Change");
	
	PROFILE_HRGLASS
	
	if(!m_bIsReady)
		return true;
	
	OnClickOK();	//apply change first
	
	GetActiveLayer();
	update("OnChangeLayer");
	DynaDlg::OnChangeLayer();
	return true;
}

//BOOL ColDlg::OnActivePageChange( void )
BOOL ColDlg::OnChangePage()
{
	_DMSG("Page Change");
	
	PROFILE_HRGLASS
	
	if(!m_bIsReady)
		return true;
	
	OnChangeLayer();//OnActiveLayerChange();
	DynaDlg::OnChangePage();
	return true;
}
///End USE_SAME_NAME_AS_VIRTUAL_FUNC_IN_DYNA_DLG
BOOL ColDlg::OnSelectionChange( void )
{
	_DMSG("Selection Change");
	
	PROFILE_HRGLASS
	
	if(!m_bIsReady)
		return true;
	GetActiveLayer();	///Jasmine 10/19/06 HIDE_DLG_IF_SEL_INVALID, if change to another folder, it doesn't fire ON_CHANGE_PAGE but ON_CHANGE_SELECTION
	///---Jasmine 11/01/07 QA70-10635 testing GetSelectedRange, temp
	Worksheet wks = Project.ActiveLayer();
	if(wks)
	{
		int nBeginRow, nBeginCol, nEndRow, nEndCol;
		int nSelection = wks.GetSelectedRange(nBeginRow, nBeginCol, nEndRow, nEndCol);
		string strSel;
		strSel.Format("nSelection=%d, nBeginRow=%d, nBeginCol=%d, nEndRow=%d, nEndCol=%d", nSelection, nBeginRow, nBeginCol, nEndRow, nEndCol);
		OUT(strSel);
	}
	///---
	if(m_pDataOB) //---- CPY 10/25/06 SWITCH_WIN_BY_SEL_COL_EVENT_PROPER_HANDLE, added m_pDataOB test 
	{
		//--- CPY 2/20/06 MAT_DIALOG_SHOULD_HAVE_NO_SEL_CHANGE_HANLDING
		if(!m_pDataOB->IsProcessSelChange(m_layActive))
		{
			_DMSG("Selection Change not processed");
			return true;
		}
		//---
		///Sophy 6/30/2009 v8.1051 QA80-13804 FAIL_TO_SEL_MULTIPLE_COLUMNS_WITH_COLUMN_PROPERTIES_DIALOG_OPEN
		//OnClickOK will set focus on OK button, here we don't want to set focus on it.
		//OnClickOK();	//apply change first
		if(isChanged())
		{
			Control cc;
			OnApply(cc);
		}
		///end FAIL_TO_SEL_MULTIPLE_COLUMNS_WITH_COLUMN_PROPERTIES_DIALOG_OPEN
	}
	
	update("OnSelectionChange");
	DynaDlg::OnSelectionChange();
	return true;
}
///Jasmine 01/29/07 QA70-9287 EDIT_USER_TREE
BOOL ColDlg::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{
	if(IDC_COL_FORMAT_GRID != nResIDCtrl || COL_USER_INFO_TAB != m_tab.GetCurSel())
		return FALSE;
	///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
	if(COL_USER_INFO_TAB != m_tab.GetCurSel())
		return FALSE;
	///Jasmine 01/24/07 RIGHT_CLICK_TO_ACTIVE_TREENODE
	int	nCmd, nEditRow;
	TreeNode tnActive =	m_DynaCntrl.GetActiveTreeNode(nEditRow);
	if(!tnActive.IsValid())
	{
		TreeNode tr = GetTree();
		if(tr.IsValid())
			tnActive = tree_get_node_by_tagname(tr, "UserInfo", true);
		if(!tnActive.IsValid())
			return FALSE;
	}
	/*//temp
	string strDebug = "Row" + nEditRow + ":" + tnActive.tagName;
	OUT(strDebug);//output to ScriptWindow
	//end temp*/
	TreeNode trUserTree;
	int nLevel = getUserInfoLevel(tnActive, trUserTree);
	if(!trUserTree.IsValid())//tnActive is not under UserTree
		return FALSE;
	
	int nEditMode = EDIT_MODE_DELETE;
	//if(!tnActive.GetAttribute(STR_ENFORCE_READONLY, nEditMode))
		//nEditMode = EDIT_MODE_ADD;
	//if(EDIT_MODE_ADD == nEditMode && tnActive.tagName.CompareNoCase("UserInfo"))
		//nEditMode = EDIT_MODE_DELETE;
	if(!tnActive.Enable || tnActive.Enable == 2 || !nLevel)
		nEditMode = EDIT_MODE_NONE;
	
	bool bDelete = EDIT_MODE_ADD < nEditMode; 
	bool bTree = true;
	bool bNode = EDIT_MODE_NONE < nEditMode;		
	UserTreeMenu myMenu(bDelete, bTree, bNode);
	myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
	
	if(!myMenu.GetCommand(nCmd) || !tnActive.IsValid())
		return FALSE;	
		
	bool bRet = false;
	switch(nCmd)
	{
	///Jasmine 11/17/09 QA80-14502-S2 RENAME_TREE_NODE
	case USERTREEMENU_EDIT:
		TreeNode trParent = tnActive.Parent();
		
		string strName, strLabel;
		tnActive.GetAttribute(STR_LABEL_ATTRIB, strLabel);
		if( !usertree_edit_node_name(trParent, strName, strLabel, GetSafeHwnd(), 0, NULL, tnActive.tagName, strLabel) )
			break;
		
		bRet = usertree_replace_node(trParent, tnActive.tagName, strName, strLabel);
		break;
	///End RENAME_TREE_NODE
	case USERTREEMENU_DELETE:
		TreeNode trParent = tnActive.Parent();
		if(trParent.IsValid() && !trParent.tagName.CompareNoCase("UserInfo") && 1 == trParent.GetNodeCount())
		{
			TreeNode trNoInfo = trParent.AddTextNode(_L("No User Tree"), "NoInfo");
			trNoInfo.SetAttribute(STR_LABEL_ATTRIB, "");
			trNoInfo.Enable = 2;
		}
		///Jasmine 06/06/2011 ORG-3034-P1 FORGET_TO_UPDATE_AFTER_DELETE
		//tnActive.Remove();
		if( tnActive.Remove() )
			bRet = true;
		///End FORGET_TO_UPDATE_AFTER_DELETE
		break;
	case USERTREEMENU_TREE:
	case USERTREEMENU_NODE:
		
		if(USERTREEMENU_TREE == nCmd)
			tnActive = trUserTree;
		
		string strName, strLabel;
		int nNodeType;
		usertree_input_node_name(tnActive, strName, strLabel, nNodeType, GetSafeHwnd(), USERTREEMENU_TREE == nCmd? USERTREE_HIDE_TYPE_NODE : 0);
		if( strName.IsEmpty() )
			break;				
			
		///Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE		
		TreeNode trAdd;
		usertree_make_node(trAdd, tnActive, strName, strLabel, nNodeType);
		if(!trAdd)
			break;
		///End REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE
		
		bRet = true;
		if(tnActive.NoInfo.IsValid())
			tnActive.NoInfo.Remove();
		break;
	}

	if(bRet)
	{
		///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		UpdateDynaControl(false, GETNEVENT_ON_INIT, false, DYNALAYOUT_TOOLTIP_TAGNAMES);
		///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		onAfterChange();
		///End MODIFICATION_EDIT_USER_TREE
	}
	return TRUE;
}
int ColDlg::getUserInfoLevel(const TreeNode tr, TreeNode& trRoot)
{
	int nLevel = 0;
	for(TreeNode trParent = tr; trParent.IsValid(); trParent = trParent.Parent())
	{
		if(!trParent.tagName.CompareNoCase("UserInfo"))
		{
			trRoot = trParent;
			return nLevel;
		}
		nLevel++;
	}
	return -1;
}
///End EDIT_USER_TREE
void ColDlg::update(LPCSTR lpcszDebugFrom, bool bInit, bool bCallHandlers) //---- CPY 10/25/06 SWITCH_WIN_BY_SEL_COL_EVENT_PROPER_HANDLE, added lpcszDebugFrom 
{
	///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	int nPageType = getPageType(), nSel = m_tab.GetCurSel(); 
	m_tab.DeleteAllItems();
	m_tab.InsertItem(COL_PROPERTY_TAB, _L("Properties"));
	switch(nPageType)
	{
	case EXIST_WKS:
		///Jasmine 10/19/06 HIDE_DLG_IF_SEL_INVALID
		//check if selection is valid
		if(!is_wks_sel_valid(m_layActive, true, lpcszDebugFrom))
		{
			Visible = false;
			return;
		}
		m_tab.InsertItem(COL_ENUMERATE_TAB, _L("Enumerate Labels"));//only for column
		/// Hong 02/03/10 QA80-15063 COL_PROPS_DLG_ADD_FILE_INFO, // rollback, see sim's comment in tracker
		m_tab.InsertItem(COL_USER_INFO_TAB, _L("User Tree"));
		//m_tab.InsertItem(COL_USER_INFO_TAB, _L("Column Info"));
		/// end COL_PROPS_DLG_ADD_FILE_INFO
		m_tab.SetCurSel(nSel > -1? nSel : 0);
		///End HIDE_DLG_IF_SEL_INVALID
	///End ADD_TAB_FOR_MORE_CONTENT
	case EXIST_MATRIX:
		Visible = true;
		break;
	default:
		Visible = false;
		return;
	}
	///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	if(bInit)
	{
		ConstructTree();
		onTabChange();
		///Sophy 6/30/2009 v8.1051 QA80-13804 FAIL_TO_SEL_MULTIPLE_COLUMNS_WITH_COLUMN_PROPERTIES_DIALOG_OPEN
		//UpdateDynaControl(true, GETNEVENT_ON_INIT, bCallHandlers);
		///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		DWORD dwUpdate = COL_USER_INFO_TAB == m_tab.GetCurSel()? DYNALAYOUT_NO_SET_FOCUS|DYNALAYOUT_TOOLTIP_TAGNAMES : DYNALAYOUT_NO_SET_FOCUS;
		UpdateDynaControl(true, GETNEVENT_ON_INIT, bCallHandlers, dwUpdate);
		///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		///end FAIL_TO_SEL_MULTIPLE_COLUMNS_WITH_COLUMN_PROPERTIES_DIALOG_OPEN
	}
	else
	{		
		onTabChange();
		///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		DWORD dwUpdate = COL_USER_INFO_TAB == m_tab.GetCurSel()? DYNALAYOUT_TOOLTIP_TAGNAMES : 0;
		UpdateDynaControl(true, 0, bCallHandlers, dwUpdate);
		///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
	}
	///End ADD_TAB_FOR_MORE_CONTENT
	updateDialogTitle();
	m_btnPrevious.Enable = m_pDataOB->HasPreviousObject();
	m_btnNext.Enable = m_pDataOB->HasNextObject();
}

BOOL ColDlg::OnApply(Control ctrl)
{
	PROFILE_HRGLASS
	
	m_bIsReady = false;
	//if(createDataObject())	//strangly, if don't create object again, all table value lost	///DG 8/2/05 USE_GETFORMAT_APPLYFORMAT
	if(m_layActive)
	{
		///Jasmine 08/13/07 MAKE_APPLY_UNDOABLE
		//if(m_pDataOB->SetTree(GetTree()))
		bool bRet;
		BEFORE_UNDO_BLOCK
		bRet = m_pDataOB->SetTree(GetTree());
		AFTER_UNDO_BLOCK
		if(bRet)
		///End MAKE_APPLY_UNDOABLE
		{
			onTabChange();
			//UpdateDynaControl(false, 0, false);
			///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
			DWORD dwUpdate = COL_USER_INFO_TAB == m_tab.GetCurSel()? DYNALAYOUT_TOOLTIP_TAGNAMES : 0;
			UpdateDynaControl(false, GETNEVENT_ON_INIT, false, dwUpdate);///Jasmine 11/10/06 APPLY_OPTION_TO_ALL_RIGHT_COL
			///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		}
		m_layActive.GetPage().Refresh();
	}
	else	//layer has been deleted
	{
		//this event should be done after layer being deleted, but now it don't turn on, so call here
		//m_paramTree.Reset();
		InitTree();
		///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		DWORD dwUpdate = COL_USER_INFO_TAB == m_tab.GetCurSel()? DYNALAYOUT_TOOLTIP_TAGNAMES : 0;
		UpdateDynaControl(true, 0, false, dwUpdate);
		///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		Visible = false;
	}
	
	onAfterApply();
	updateDialogTitle();//
	m_bIsReady = true;
	return true;
}
BOOL ColDlg::OnClickPrevious(Control ctrl)
{
	m_pDataOB->ActivePreviousObject();
	return true;
}
BOOL ColDlg::OnClickNext(Control ctrl)
{
	m_pDataOB->ActiveNextObject();
	return true;
}

///Kyle 10/08/2011 ORG-4029 OPEN_SET_VALUES_DIALOG_FROM_COLUMN_PROPERTIES
BOOL ColDlg::OnClickSetValues(Control ctrl)
{
	if(isChanged())
	{
		Control cc;
		OnApply(cc);
	}

	m_pDataOB->ActiveCurrentObject();
	SendMessage(WM_CLOSE);
	LT_execute(";worksheet -e v");
	return true;
}
///End OPEN_SET_VALUES_DIALOG_FROM_COLUMN_PROPERTIES

///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
BOOL ColDlg::OnTabChange(Control ctrl)
{
	SetFocus(GetItem(IDOK).GetSafeHwnd());///Jasmine 10/18/06 FORCE_TO_UPDATE_CHANGE
	onTabChange();
	///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
	DWORD dwUpdate = COL_USER_INFO_TAB == m_tab.GetCurSel()? DYNALAYOUT_TOOLTIP_TAGNAMES : 0;
	UpdateDynaControl(false, GETNEVENT_ON_INIT, false, dwUpdate);
	///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
	return true;
}
void ColDlg::onTabChange()
{
	int nSelTab=m_tab.GetCurSel();
	bool bProperty = nSelTab == COL_PROPERTY_TAB;
	bool bEnumerate = nSelTab == COL_ENUMERATE_TAB;
	bool bUserInfo = nSelTab == COL_USER_INFO_TAB;
	TreeNode tr = GetTree();
	foreach(TreeNode cNode in tr.Children)
		cNode.Show = bProperty;
	tr.LabelOption.Show = bEnumerate && (getPageType() == EXIST_WKS);///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT, for column only
	tr.RightClickHint.Show = 		///Jasmine 02/02/10 SHOW_RIGHT_CLICK_HINT_IN_ONE_ROW_TO_SAVE_SPACE
	tr.UserInfo.Show = bUserInfo && (getPageType() == EXIST_WKS);
	/// Hong 02/03/10 QA80-15063 COL_PROPS_DLG_ADD_FILE_INFO
	if ( tr.FileInfo )
		tr.FileInfo.Show = tr.UserInfo.Show;
	/// end COL_PROPS_DLG_ADD_FILE_INFO
}
///End ADD_TAB_FOR_MORE_CONTENT
void ColDlg::OnAfterValueChange(int nRow, DWORD lParam)
{
	TreeNode trNode = m_DynaCntrl.GetTreeNode(nRow);
	if(!trNode)
		ASSERT(0);
	
	bool bUpdateGUI, bInit;
	bool bChanged = m_pDataOB->OnAfterValueChange(trNode, nRow, bUpdateGUI, bInit); //false to ingore change
	
	if(bUpdateGUI)
	{
		if(bInit)
			PostMessage(WM_USER_RESET_GUI);
		else
		{
			///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
			DWORD dwUpdate = COL_USER_INFO_TAB == m_tab.GetCurSel()? DYNALAYOUT_TOOLTIP_TAGNAMES : 0;
			UpdateDynaControl(true, bInit?GETNEVENT_ON_INIT:0, false, dwUpdate);
			///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
		}
	}
	//m_nEditStatus=COL_UPDATE_FINISHED;
	if(bChanged)
		onAfterChange();
}

//--- CPY 2/24/06 DO_NOT_SET_TREE_INSIDE_ON_AFTER_VAL_CHANGE
void ColDlg::OnResetTree(DWORD wParam, DWORD lParam)
{
	///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
	DWORD dwUpdate = COL_USER_INFO_TAB == m_tab.GetCurSel()? DYNALAYOUT_TOOLTIP_TAGNAMES : 0;
	UpdateDynaControl(true, GETNEVENT_ON_INIT, false, dwUpdate);
	///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
}
int ColDlg::getPageType()
{
	if(m_layActive)
		return m_layActive.GetPage().GetType();
	
	return -1;
}

//---

void ColDlg::GetActiveLayer()
{
	Layer lay = Project.ActiveLayer();
	m_layActive = lay;
	if(!lay)
	{
		error_report("Fail to get active layer");
		//m_paramTree.Reset();
		InitTree();
	}
	//---- CPY 10/25/06 SWITCH_WIN_BY_SEL_COL_EVENT_PROPER_HANDLE
	else if(m_pDataOB)
	{
		if(!m_pDataOB->IsLayerCompatible(lay))
		{
			delete m_pDataOB;
			m_pDataOB = NULL;
			_DMSG("Old m_pDataOB not compatible with new layer, deleted");
		}
	}
	//----
	m_layActive.GetPage().Refresh();
}

void ColDlg::ConstructTree()
{
	//m_paramTree.Reset();
	if(createDataObject())
	{
		TreeNode tr = InitTree();
		m_pDataOB->GetTree(tr);
	}
}

bool ColDlg::createDataObject()
{
	if(m_pDataOB)
		delete m_pDataOB;
	m_pDataOB = NULL;

	int nPageType = getPageType();
	/// ML 9/11/2006 PROPER_RETURN_VALUE
	bool		bRet = false;
	/// end PROPER_RETURN_VALUE
	if(EXIST_WKS == nPageType  || EXIST_MATRIX == nPageType)
	{
		switch(nPageType)
		{
		case EXIST_WKS:
			if(is_wks_sel_valid(m_layActive, true))///Jasmine 10/19/06 HIDE_DLG_IF_SEL_INVALID, update for label selection
			{
				Worksheet wks = m_layActive;/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
				m_pDataOB = new MulColsProperties(wks);
				/// ML 9/11/2006 PROPER_RETURN_VALUE
				bRet = true;
				/// end PROPER_RETURN_VALUE
			}
			break;
		case EXIST_MATRIX:
			{
				MatrixLayer mtx = m_layActive;/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
				m_pDataOB = new MatrixObjectProperties(mtx);
				/// ML 9/11/2006 PROPER_RETURN_VALUE
				bRet = true;
				/// end PROPER_RETURN_VALUE
			}
			break;
		/// ML 9/11/2006 PROPER_RETURN_VALUE
		//default:
		//	return false;
		/// end PROPER_RETURN_VALUE
		}
		/// ML 9/11/2006 PROPER_RETURN_VALUE
		//return true;
		/// end PROPER_RETURN_VALUE
	}
	/// ML 9/11/2006 PROPER_RETURN_VALUE
	//return false;
	return bRet;
	/// end PROPER_RETURN_VALUE
}
void ColDlg::onAfterChange()
{
	m_btnApply.Enable = true;
}
bool ColDlg::isChanged()
{
	return m_btnApply.Enable;
}
void ColDlg::onAfterApply()
{
	m_btnApply.Enable = false;
}
void ColDlg::updateDialogTitle()
{
	string strTitle = STR_DLG_NAME;
	if(getPageType() == EXIST_MATRIX)
		strTitle = _L("Matrix Properties");
	string strText = strTitle+" - ";
	
	if(m_layActive)
		strText += m_pDataOB->GetSelectionStr();
	else
		strText += _L("No Worksheet/Matrix Page active");
		
	Text = strText;
}

//------ Folger 09/05/07 SHOW_ERROR_STATUS_BAR
void ColDlg::resizeDialog(int cx, int cy)
{
	int nEdge = GetControlGap();
			
	RECT rrWnd;
	GetClientRect(&rrWnd);
	
	if (cx == 0)
		cx = rrWnd.right - rrWnd.left;
	if (cy == 0)
		cy = rrWnd.bottom - rrWnd.top;
	
	int nErrMessageHeight = GetDlgStatusMsgBoxHeight(cx - 2 * nEdge);
	int	nErrMessage = nErrMessageHeight > 0 ? nErrMessageHeight + nEdge : 0;		
		
	uint nButtonIDs[] = {IDOK, IDCANCEL, IDC_APPLY_BTN, IDC_UNDO_BTN, 0};
	
	RECT rr;
	GetClientRect(m_btnOK, rr);
	int ny=cy-RECT_HEIGHT(rr)-nErrMessage;
	//ArrangeControlsRightLeft(nButtonIDs, cx, ny);
	//ny-=nEdge;
	Control ccGrid = GetItem(IDC_COL_FORMAT_GRID);
	///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	GetClientRect(m_tab, rr);
	rr.right = cx-nEdge;
	rr.bottom = ny-nEdge;;
	MoveControl(m_tab, rr);
	
	m_tab.GetWindowRect(&rr);
	ScreenToClient(&rr);
	m_tab.AdjustRect(FALSE, &rr);
	ccGrid.MoveWindow(&rr);
	///End ADD_TAB_FOR_MORE_CONTENT
	
	MoveControlsHelper	_temp(this);	///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
	ArrangeControlsRightLeft(nButtonIDs, cx, ny + nErrMessage);
	
	if (nErrMessage)
	{
		RECT rrStatusBar;
		GetClientRect(m_btnErrMessage, rrStatusBar);
		rrStatusBar.top = ny;
		rrStatusBar.bottom = rrStatusBar.top + nErrMessageHeight;
		rrStatusBar.left = nEdge;
		rrStatusBar.right = cx - nEdge;
		MoveControl(m_btnErrMessage, rrStatusBar);
	}
	
}
	
void ColDlg::checkShowStatusBar()
{
	bool bShow = m_btnErrMessage.Visible = m_nErr != CER_NO_ERROR;
	if (bShow)
	{
		string str;
		ocu_load_err_msg_str(m_nErr, &str);
		m_btnErrMessage.Text = str;
	}
	else
		m_btnErrMessage.Text = "";
	resizeDialog();
}

bool ColDlg::setCheckErrorStatus(int nErr)
{
	m_nErr = nErr;
	checkShowStatusBar();
	return true;
}
//------ End SHOW_ERROR_STATUS_BAR

//---- CPY 7/8/05 PROPER_MODLESS_DLG_HANDLING
/*
static ColDlg myDlg;
bool Colopen(bool bOpenSetValue=false)
{
	int nRet = myDlg.Create(NULL, bOpenSetValue);
	return false;
}
*/

// generic func prototype for VC level calling
//int ColumnProperties(int nMsg=0, DWORD dwCntrl=0)
int ColumnProperties(int nMsg, DWORD dwCntrl = 0, LPVOID lpData = NULL)
{
	///Jasmine 01/29/07 BLOCK_REPORT_SHEET
	//ColumnProperties doesn't open if current sheet is worksheet and it's a reportsheet
	Worksheet wks = Project.ActiveLayer();
	if(wks.IsValid() && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY)) 
		return 0;
	///End BLOCK_REPORT_SHEET
	bool bClose = OMSG_CLOSE==nMsg? true:false;
	bool bUpdate = OMSG_UPDATE==nMsg? true:false;

	if(bClose)
	{
		if(s_pColPropertiesDlg)
		{
			Window winDlg = s_pColPropertiesDlg->GetWindow();
			if(winDlg)
				winDlg.SendMessage(WM_CLOSE);
			delete s_pColPropertiesDlg;
			s_pColPropertiesDlg = NULL;
		}
		return 0;
	}
	// open or update
	if(!s_pColPropertiesDlg)
	{
		if(bUpdate)
			return 1;// not possible to update, since dialog not opened

		s_pColPropertiesDlg = new ColDlg;
		s_pColPropertiesDlg->Create(GetWindow());
	}
	if(bUpdate)
		;//s_pColPropertiesDlg->Update();//"from global message");
	
	return 0;
}
//---- end CPY 7/8/05 PROPER_MODLESS_DLG_HANDLING

