/*
*	Jasmine 07/27/06 1ST_CHAR_SNAME_ALIAS								*
*   Joe 07/28/06 1ST_CHAR_LNAME_ALIAS                       			*
*	Jasmine 08/07/06 CHECK_ALIAS_IS_GOOD								*
*	Jasmine 08/08/06 ON_ACTIVE_LAYER_CHANGE								*
*	Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT							*
*	Jasmine 06/10/08 QA80-11668 WE_CANNOT_USE_NON_ASCII_ALPHA_LONGNAME	*
*	Kyle 08/01/08 GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
*	Jasmine 09/03/08 ACTIVE_LAYER_IS_NOT_CURRENT_LAYER_IF_SLECTION_NOT_GOOD
*	Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH*
*	Sim 05-05-2009 IMPROVE_EXT_WKS_DLG									*
*	Sim 06-02-2009 QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE			*
*	Kyle 07/20/2009 QA80-13746-P2 SCV_COL_COLUMN_BROWSER_AND_RANGE_BROWSER_SHOW_SN_LN_CLEANUP
*	Kyle 07/27/2009 QA80-13746-P5 CONSIDER_MAT_IN_COL_MAT_MENU			*
*	Jasmine 11/26/09 AUTO_CORRECT_INVALID_ALIAS_WHEN_ADD_FROM_COLUMN_LIST*
*	Folger 08/09/2011 ORG-3473-P1 WORKSHEET_QUERY_FAILED_TO_SHOW_OP_ESCAPED_STRING
*	Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
*-----------------------------------------------------------------------*/
/*
			GridListControl
				|
			ColMatListBase
				/	\
	ColumnListBase	MatObjListBase
		/	\
ColumnList	ColVarList
*/

enum {
	COL_PROPERTIES_INDEX		= 0,
	COL_PROPERTIES_SHORT_NAME,
	COL_PROPERTIES_LONG_NAME,		
	COL_PROPERTIES_UNIT,
	COL_PROPERTIES_COMMENT,
	COL_PROPERTIES_FORMULA,			
	COL_PROPERTIES_COLUMN_WIDTH,
	COL_PROPERTIES_PLOT_DESIGNATION,
	COL_PROPERTIES_FORMAT,			
	COL_PROPERTIES_DISPLAY,
	COL_PROPERTIES_NUMERIC,
	COL_PROPERTIES_DIGITS,
	COL_PROPERTIES_INTERNAL_DATA,
	COL_PROPERTIES_FIRST_VALUE,
	COL_PROPERTIES_SIZE,
	COL_PROPERTIES_MIN,
	COL_PROPERTIES_MAX, 
	COL_PROPERTIES_MEDIAN,
	
	COL_PROPERTIES_TOTAL
};

///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
enum{
	MO_PROPERTIES_INDEX	= 0,	//index, = COL_PROPERTIES_INDEX
	MO_PROPERTIES_SHORT_NAME, 	//short name
	MO_PROPERTIES_LONG_NAME, 	//long name
	MO_PROPERTIES_FORMULA,		//formula
	
	MO_PROPERTIES_TOTAL
};

class ColMatListBase : public GridListControl
{
public:
	ColMatListBase()
	{
	}
	
	virtual BOOL OnDestroy()
	{
		SaveHideCols();
		SaveColsWidthToReg();	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		return TRUE;
	}	
	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	//virtual void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName = NULL, LPCSTR lpcszName = NULL){ASSERT(false);}
	virtual void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName = NULL, LPCSTR lpcszName = NULL)
	{
		GridListControl::Init(nID, dlg);
		SetDlgName(lpcszDlgName);
	}
	///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	virtual void SetColHeading(){return;}	
	virtual bool AddRow(int nIndex){return false;}
	virtual void RemoveRows(vector<int> vnRows)
	{
		for(int ii = vnRows.GetSize() - 1; ii >= 0 ; ii--)
			DeleteRow(vnRows[ii]);
	}
	///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
	//virtual string GetName(int nRow){return "";}
	virtual string GetName(int nRow, BOOL bPreferLongName = TRUE)		{return "";}
	///------ End COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
	//--- CPY 9/25/06
	//virtual bool GetCurrentLayer(Layer& ml){return false;}
	virtual bool GetActiveSheet(Datasheet& ml){return false;}
	//---
	virtual bool SetDatasheet(LPCSTR lpcszName = NULL){ASSERT(false); return false;}
public:
	int GetSelection(vector<uint>& vnSelRows)
	{
		GetSelRows(vnSelRows);
		return vnSelRows.GetSize();
	}
	bool SetShowCols(const vector<uint>& vnColIndex)
	{
		HideCol(-1);
		for(int ii = 0; ii < vnColIndex.GetSize(); ii++)
			HideCol(vnColIndex[ii], false);
		return true;
	}
	int GetShowCols(vector<uint>& vnColIndex = NULL)
	{
		vector<byte> vbCols;
		GetHiddenCols(vbCols);//0: show, 1: hidden
		int nCol = 0;
		for(int ii = 0; ii < vbCols.GetSize(); ii++)
		{
			if(!vbCols[ii])
			{
				nCol++;
				if(vnColIndex != NULL)
					vnColIndex.Add(ii);
			}
		}
		return nCol;
	}
	
	int GetColumnIndex(int nRow)
	{
		string str = GetCell(nRow, COL_PROPERTIES_INDEX);
		return atoi(str);
	}
///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
protected:
	virtual string	GetClassName() { return "ColMatListBase"; }
///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	
protected:
	vector<uint>	m_vnIndex;//index of columns allowed to show
};

class OC_REGISTERED MatObjListBase : public ColMatListBase
{
public:
	MatObjListBase()
	{
	}
	
	virtual BOOL OnDestroy()
	{
		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		//SaveHideCols();
		//return TRUE;
		return ColMatListBase::OnDestroy();
		///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	}	
	virtual void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName = NULL, LPCSTR lpcszName = NULL)
	{
		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		//GridListControl::Init(nID, dlg);
		ColMatListBase::Init(nID, dlg, lpcszDlgName);
		///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		if(!SetDatasheet(lpcszName))
			return;		
		SetCols(MO_PROPERTIES_TOTAL);
		ClearAll();
		SetColHeading();		
		m_flx.Editable = flexEDKbdMouse;
		m_flx.ExplorerBar = flexExSortShow;
		m_flx.SelectionMode = flexSelectionListBox;			//Forces selections to span entire rows.
		m_flx.AllowSelection = true;	
		m_flx.AutoSizeMode = flexAutoSizeColWidth;		//Adjust column widths to accommodate the widest entry in each column
		m_flx.AutoSize(0, GetCols()-1, false);	
		InitColsWidthFromReg();		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	}
	virtual void SetColHeading()
	{
		//index: no heading		
		//short name
		SetColHeading(MO_PROPERTIES_SHORT_NAME, _L("Mat"));
		//long name
		SetColHeading(MO_PROPERTIES_LONG_NAME, _L("Name"));
		//formula
		SetColHeading(MO_PROPERTIES_FORMULA, _L("Formula"));
	}
	virtual bool AddRow(int nIndex)
	{
		if(!m_ml.IsValid())
			return false;
		MatrixObject mo(m_ml, nIndex);
		if(!mo.IsValid())
			return false;
		InsertRow();
		int nRow = GetRows() - GetRowOffset();		
		string str = mo.GetName();
		SetCell(nRow, MO_PROPERTIES_INDEX, nIndex + 1);
		SetCell(nRow, MO_PROPERTIES_SHORT_NAME, str);
		SetCell(nRow, MO_PROPERTIES_LONG_NAME, mo.GetLongName());
		SetCell(nRow, MO_PROPERTIES_FORMULA, mo.GetFormula());			
		return true;
	}
	///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
	//string GetName(int nRow)
	string GetName(int nRow, BOOL bPreferLongName = TRUE)
	///------ End COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
	{
		///Kyle 07/27/2009 QA80-13746-P5 CONSIDER_MAT_IN_COL_MAT_MENU
		//string strName = GetCell(nRow, MO_PROPERTIES_LONG_NAME);
		//if(strName.IsEmpty())
		//	strName = GetCell(nRow, MO_PROPERTIES_SHORT_NAME);
		string strName = GetCell(nRow, COL_PROPERTIES_SHORT_NAME);
		string strLName = GetCell(nRow, COL_PROPERTIES_LONG_NAME);
		///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
		//if(is_str_good_for_col_func(strLName))			// prefer LN unless if is in conflict with a SN or a LN of another Column or not a good str
		//{
			//bool bUseLN = true;
			//for(int nn = GetRowOffset(); nn < GetRowOffset()+GetNumRows(); nn++)
			//{
				//if(nn == nRow)
					//continue;
				//string strSN = GetCell(nn, COL_PROPERTIES_SHORT_NAME);
				//string strLN = GetCell(nn, COL_PROPERTIES_LONG_NAME);
				//if(strLN.CompareNoCase(strLName) == 0 || strSN.CompareNoCase(strLName) == 0)
				//{
					//bUseLN = false;
					//break;
				//}
			//}
			//if(bUseLN)
				//strName = strLName;
		//}
		if ( bPreferLongName && !strLName.IsEmpty() )
		{
			strName.Format("\"%s\"", strLName);
		}
		///------ End COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
		///End CONSIDER_MAT_IN_COL_MAT_MENU
		return strName;
	}
	///Jasmine 09/03/08 ACTIVE_LAYER_IS_NOT_CURRENT_LAYER_IF_SLECTION_NOT_GOOD
	bool SetDatasheet(LPCSTR lpcszName = NULL)
	{
		m_ml = Project.ActiveLayer();

		///---Sim 05-05-2009 IMPROVE_EXT_WKS_DLG
		//if(lpcszName)
		#ifdef CUSTOM_XF_DIALOG
		if ( lpcszName && strlen(lpcszName) > 0 )
		#else
		if(lpcszName)
		#endif
		///---END IMPROVE_EXT_WKS_DLG
			m_ml.Attach(lpcszName);
		
		if(!m_ml)
			return false;
		
		return true;
	}
	///End ACTIVE_LAYER_IS_NOT_CURRENT_LAYER_IF_SLECTION_NOT_GOOD
	bool GetActiveSheet(Datasheet& ml)//Layer& ml)
	{
		if(!m_ml.IsValid())
			return false;
		ml = m_ml;
		return true;
	}	
	bool Attach(MatrixLayer& ml)
	{
		if(!ml.IsValid())
			return false;
		m_ml = ml;
		return true;
	}	
///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
protected:
	virtual string	GetClassName() { return "MatObjListBase"; }
///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
protected:
	MatrixLayer 	m_ml;	
};
///End SHARE_COL_BROWSER_WITH_MAT	

class OC_REGISTERED ColumnListBase : public ColMatListBase//GridListControl ///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT	
{
public:
	ColumnListBase()
	{
	}
	
	virtual void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName = NULL, LPCSTR lpcszName = NULL);
	virtual void SetColHeading();	
	virtual bool AddRow(int nIndex);
	
	virtual BOOL OnDestroy() { return ColMatListBase::OnDestroy(); }	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	
	///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
	//string GetName(int nRow)
	string GetName(int nRow, BOOL bPreferLongName = TRUE)
	///------ End COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
	{
		///Kyle 07/20/2009 QA80-13746-P2 SCV_COL_COLUMN_BROWSER_AND_RANGE_BROWSER_SHOW_SN_LN_CLEANUP
		//string strName = GetCell(nRow, COL_PROPERTIES_LONG_NAME);
		//if(strName.IsEmpty())
			//strName = GetCell(nRow, COL_PROPERTIES_SHORT_NAME);
		string strName = GetCell(nRow, COL_PROPERTIES_SHORT_NAME);
		string strLName = GetCell(nRow, COL_PROPERTIES_LONG_NAME);
		///------ Folger 12/21/2011 ORG-4312-S2 COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
		//if(is_str_good_for_col_func(strLName))			// prefer LN unless if is in conflict with a SN or a LN of another Column or not a good str
		//{
			//Column cc = m_wks.Columns(strLName);
			//if(!cc)
			//{
				//bool bDuplicate = false;
				//for(int nn = GetRowOffset(); nn < GetRowOffset()+GetNumRows(); nn++)
				//{
					//if(nn == nRow)
						//continue;
					//
					//string strLN = GetCell(nn, COL_PROPERTIES_LONG_NAME);
					//if(strLN.CompareNoCase(strLName) == 0)
					//{
						//bDuplicate = true;
						//break;
					//}
				//}
				//if(!bDuplicate)
					//strName = strLName;
			//}
		//}
		if ( bPreferLongName && !strLName.IsEmpty() )
		{
			strName.Format("\"%s\"", strLName);
		}
		///------ End COLUMN_STR_FROM_BROWSER_SHOULD_CHECK_PREFER_LONG_NAME
		///End SCV_COL_COLUMN_BROWSER_AND_RANGE_BROWSER_SHOW_SN_LN_CLEANUP
		return strName;
	}
public:
	///Jasmine 09/03/08 ACTIVE_LAYER_IS_NOT_CURRENT_LAYER_IF_SLECTION_NOT_GOOD
	bool SetDatasheet(LPCSTR lpcszName = NULL)	///Jasmine 08/08/06 ON_ACTIVE_LAYER_CHANGE
	{
		m_wks = Project.ActiveLayer();
		
		///---Sim 05-05-2009 IMPROVE_EXT_WKS_DLG
		//if(lpcszName)
		#ifdef CUSTOM_XF_DIALOG
		if ( lpcszName && strlen(lpcszName) > 0 )
		#else
		if(lpcszName)
		#endif
		///---END IMPROVE_EXT_WKS_DLG
			m_wks.Attach(lpcszName);
		
		if(!m_wks)
			return false;
		
		return true;
	}
	//End ACTIVE_LAYER_IS_NOT_CURRENT_LAYER_IF_SLECTION_NOT_GOOD
	bool GetActiveSheet(Datasheet& wks)//Layer& wks)//GetWorksheet(Worksheet& wks)///Jasmine 09/25/06 SHARE_COL_BROWSER_WITH_MAT
	{
		if(!m_wks.IsValid())
			return false;
		wks = m_wks;
		return true;
	}	
	bool Attach(Worksheet& wks)
	{
		if(!wks.IsValid())
			return false;
		m_wks = wks;
		return true;
	}
	
protected:
	//get col properties
	string GetFormatStr(int nFormat)
	{
		switch(nFormat)
		{
		case OKCOLTYPE_NUMERIC:
			return "Numeric";
		case OKCOLTYPE_TEXT:
			return "Text";
		case OKCOLTYPE_TIME:
			return "Time";
		case OKCOLTYPE_DATE:
			return "Date";
		case OKCOLTYPE_MONTH:
			return "Month";
		case OKCOLTYPE_WEEKDAY:
			return "Day";
		case OKCOLTYPE_TEXT_NUMERIC:
			return "T&N"; //CPY 6/15/06, changed from Text & Numeric to make it shorter
		default:
			return "";
		}
		return "";
	}
	string GetDesignationStr(int nDesignation)
	{
		switch(nDesignation)
		{
		case OKDATAOBJ_DESIGNATION_X:
			return "X";
		case OKDATAOBJ_DESIGNATION_Y:
			return "Y";
		case OKDATAOBJ_DESIGNATION_Z:
			return "Z";
		case OKDATAOBJ_DESIGNATION_X_ERROR:
			return "XErr";
		case OKDATAOBJ_DESIGNATION_ERROR:
			return "YErr";
		case OKDATAOBJ_DESIGNATION_L:
			return "L";
		default :	//OKDATAOBJ_DESIGNATION_NONE
			return " "; //CPY 6/15/06 changed from Disregard to make it shorter
		}
		return "";
	}
	
	virtual string	GetClassName() { return "ColumnListBase"; }	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
protected:
	Worksheet 		m_wks;	
};

virtual void ColumnListBase::Init(int nID, Dialog& dlg,LPCSTR lpcszDlgName, LPCSTR lpcszName)
{
	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	//GridListControl::Init(nID, dlg);
	ColMatListBase::Init(nID, dlg, lpcszDlgName);
	///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	
	if(!SetDatasheet(lpcszName))
		return;
	
	SetCols(COL_PROPERTIES_TOTAL);
	ClearAll();
	SetColHeading();
	
	m_flx.Editable = flexEDKbdMouse;
	m_flx.ExplorerBar = flexExSortShow;
	m_flx.SelectionMode = flexSelectionListBox;			//Forces selections to span entire rows.
	m_flx.AllowSelection = true;	
	m_flx.AutoSizeMode = flexAutoSizeColWidth;		//Adjust column widths to accommodate the widest entry in each column
	m_flx.AutoSize(0, GetCols()-1, false);
	InitColsWidthFromReg();		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
}
virtual void ColumnListBase::SetColHeading()
{
	//column head
	//index: no heading		
	//short name
	SetColHeading(COL_PROPERTIES_SHORT_NAME, _L("Col"));
	//long name
	SetColHeading(COL_PROPERTIES_LONG_NAME, _L("Name"));
	//unit
	SetColHeading(COL_PROPERTIES_UNIT, _L("Unit"));
	//comment
	SetColHeading(COL_PROPERTIES_COMMENT, _L("Comment"));
	//formula
	SetColHeading(COL_PROPERTIES_FORMULA, _L("Formula"));
	//width
	SetColHeading(COL_PROPERTIES_COLUMN_WIDTH, _L("Width"));
	//designation
	SetColHeading(COL_PROPERTIES_PLOT_DESIGNATION, _L("Type"));
	//format
	SetColHeading(COL_PROPERTIES_FORMAT, _L("Format"));
	//display
	SetColHeading(COL_PROPERTIES_DISPLAY, _L("Display"));
	//numeric
	SetColHeading(COL_PROPERTIES_NUMERIC, _L("Numeric"));
	//digits
	SetColHeading(COL_PROPERTIES_DIGITS, _L("Digits"));
	//internal data
	SetColHeading(COL_PROPERTIES_INTERNAL_DATA, _L("Internal data"));
	//first value
	SetColHeading(COL_PROPERTIES_FIRST_VALUE, _L("1st Value"));
	//col size
	SetColHeading(COL_PROPERTIES_SIZE, _L("Size"));
	
	SetColHeading(COL_PROPERTIES_MIN, _L("Min"));
	
	SetColHeading(COL_PROPERTIES_MAX, _L("Max"));
	
	SetColHeading(COL_PROPERTIES_MEDIAN, _L("Median"));
}
virtual bool ColumnListBase::AddRow(int nIndex)
{
	if(!m_wks.IsValid())
		return false;
	Column col(m_wks, nIndex);
	if(!col.IsValid())
		return false;
	InsertRow();
	int nRow = GetRows() - GetRowOffset();
	
	//index
	SetCell(nRow, COL_PROPERTIES_INDEX, nIndex + 1);
	//short name
	string str;
	col.GetName(str); 
	SetCell(nRow, COL_PROPERTIES_SHORT_NAME, str);
	//long name
	SetCell(nRow, COL_PROPERTIES_LONG_NAME, col.GetLongName());
	//unit
	SetCell(nRow, COL_PROPERTIES_UNIT, col.GetUnits());
	//comment
	SetCell(nRow, COL_PROPERTIES_COMMENT, col.GetComments());
	//formula
	//str = col.GetFormula();
	SetCell(nRow, COL_PROPERTIES_FORMULA, col.GetFormula());
	//width, temp
	SetCell(nRow, COL_PROPERTIES_COLUMN_WIDTH, col.GetWidth());
	//designation
	SetCell(nRow, COL_PROPERTIES_PLOT_DESIGNATION, GetDesignationStr(col.GetType()));
	//format
	SetCell(nRow, COL_PROPERTIES_FORMAT, GetFormatStr(col.GetFormat()));
	//display
	SetCell(nRow, COL_PROPERTIES_DISPLAY, col.GetDigitMode());
	//numeric, temp
	str = "";
	SetCell(nRow, COL_PROPERTIES_NUMERIC, str);
	//digits
	SetCell(nRow, COL_PROPERTIES_DIGITS, col.GetDigits());
	//internal data
	SetCell(nRow, COL_PROPERTIES_INTERNAL_DATA, (int)col.GetInternalData());
	//first value
	m_wks.GetCell(col.GetLowerBound(), col.GetIndex(), str);
	SetCell(nRow, COL_PROPERTIES_FIRST_VALUE, str);
	//doing...
	//size
	
	//min
	
	//max
	
	//median
	
	return true;
}

////////////////////////////////////////////////////////////////////////////
#define COL_CHECK_BOX		COL_PROPERTIES_SHORT_NAME

class ColumnList : public ColumnListBase
{
public:
	ColumnList()
	{
		
	}
	
	void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName = NULL, LPCSTR lpcszName = NULL)//, const string& strRegForDlgInfo, int nMakePlotExVal, int nXErrID, int nPosNegErrID, int naddRowToParamterCntrNumForX, int nPageNames, int nShowAllCols)
	{
		ColumnListBase::Init(nID, dlg, lpcszDlgName, lpcszName);
		m_flx.ExtendLastCol = false;
		
		FillGrid();
				
	    vector<byte> vbDefaultShowCols(COL_PROPERTIES_TOTAL);
	    vbDefaultShowCols = 1;
	    vbDefaultShowCols[COL_CHECK_BOX] = vbDefaultShowCols[COL_PROPERTIES_LONG_NAME] = vbDefaultShowCols[COL_PROPERTIES_FIRST_VALUE] = 0;
		LoadHideCols(lpcszDlgName, "ColsHideShow", &vbDefaultShowCols);
		//force to Show Col: Checkbox and Long Name, Formula, Plot Designation and Format		
		vector<byte> vbCols;
		GetHiddenCols(vbCols);
		HideCol(-1);
		HideCol(COL_PROPERTIES_LONG_NAME, false);//force to show
		vector<uint> vnIndex = {COL_PROPERTIES_INDEX,
								COL_CHECK_BOX, 
								//COL_PROPERTIES_LONG_NAME, 
								COL_PROPERTIES_PLOT_DESIGNATION,
								COL_PROPERTIES_FORMAT,
								COL_PROPERTIES_FIRST_VALUE
								};
		m_vnIndex = vnIndex;
		for(int ii = 0; ii < m_vnIndex.GetSize(); ii++)
			HideCol(vnIndex[ii], vbCols[ vnIndex[ii] ]);

		InitColsWidthFromReg();		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	}

	virtual BOOL OnDestroy() { return ColumnListBase::OnDestroy(); }	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH

	void SetColHeading()
	{		
		ColumnListBase::SetColHeading();
		SetColDataType(COL_CHECK_BOX, flexDTBoolean);
		SetColHeading(COL_CHECK_BOX, _L("Extract")); //CPY 6/15/06 better show this so user know the reason for these check boxes
		SetColHeading(COL_PROPERTIES_LONG_NAME, _L("Name"));
	}
	
	void FillGrid()
	{	
		int nRow = GetRowOffset();		
		
		foreach(Column col in m_wks.Columns)
		{
			InsertRow();
			//index
			SetCell(nRow, COL_PROPERTIES_INDEX, col.GetIndex()+1);
			//check box
			SetCell(nRow, COL_CHECK_BOX, 1);
			string str;
			//name
			SetCell(nRow, COL_PROPERTIES_LONG_NAME, get_column_name(col));
			//unit
			SetCell(nRow, COL_PROPERTIES_UNIT, col.GetUnits());
			//comment
			SetCell(nRow, COL_PROPERTIES_COMMENT, col.GetComments());
			//formula
			//str = col.GetFormula();
			SetCell(nRow, COL_PROPERTIES_FORMULA, col.GetFormula());
			//width, temp
			SetCell(nRow, COL_PROPERTIES_COLUMN_WIDTH, col.GetWidth());
			//designation
			SetCell(nRow, COL_PROPERTIES_PLOT_DESIGNATION, GetDesignationStr(col.GetType()));
			//format
			SetCell(nRow, COL_PROPERTIES_FORMAT, GetFormatStr(col.GetFormat()));
			//display
			SetCell(nRow, COL_PROPERTIES_DISPLAY, col.GetDigitMode());
			//numeric, temp
			str = "";
			SetCell(nRow, COL_PROPERTIES_NUMERIC, str);
			//digits
			SetCell(nRow, COL_PROPERTIES_DIGITS, col.GetDigits());
			//internal data
			SetCell(nRow, COL_PROPERTIES_INTERNAL_DATA, (int)col.GetInternalData());
			//first value
			///------ Folger 08/09/2011 ORG-3473-P1 WORKSHEET_QUERY_FAILED_TO_SHOW_OP_ESCAPED_STRING
			//m_wks.GetCell(col.GetLowerBound(), col.GetIndex(), str);
			//SetCell(nRow, COL_PROPERTIES_FIRST_VALUE, str);
			SetCell(nRow, COL_PROPERTIES_FIRST_VALUE, m_wks.TCell(col.GetLowerBound(), col.GetIndex()));
			///------ End WORKSHEET_QUERY_FAILED_TO_SHOW_OP_ESCAPED_STRING
			
			nRow++;
		}				
		//name
		for(nRow = GetRowOffset(); nRow < GetRows(); nRow++)
		{
			if(GetCell(nRow, COL_PROPERTIES_LONG_NAME).IsEmpty())
			{
				string strName = GetCell(nRow, COL_PROPERTIES_SHORT_NAME);
				SetCell(nRow, COL_PROPERTIES_LONG_NAME, strName);
			}
		}
	}	
	void Update(LPCSTR lpcszName = NULL)	///Jasmine 08/08/06 ON_ACTIVE_LAYER_CHANGE
	{
		SetDatasheet(lpcszName);
		ClearAll();
		FillGrid();
	}

public:
	///---Sim 06-02-2009 QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE
#ifdef EXTRACT_WKS_SUPPORT_AUTO_UPDATE
	#define COLOR_GRAY		RGB(200,200,200) // Sim, need global define
#endif // EXTRACT_WKS_SUPPORT_AUTO_UPDATE	
	///---END QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE
	
	void BeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		*pCancel = nCol != COL_CHECK_BOX;
	///---Sim 06-02-2009 QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE
#ifdef EXTRACT_WKS_SUPPORT_AUTO_UPDATE
		if ( COL_CHECK_BOX == nCol )
		{
			int nColor;
			GetCellColor(nRow, nCol, NULL, &nColor);
			if ( COLOR_GRAY == nColor )
			{
				*pCancel = true;
			}
		}
#endif // EXTRACT_WKS_SUPPORT_AUTO_UPDATE	
	///---END QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE
	}
	void Check(int nRow = -1, bool bCheck = true)
	{
		if(nRow > -1)
		{
			SetCell(nRow, COL_CHECK_BOX, bCheck);
			return;
		}
		for(int ii = GetRowOffset(); ii < GetRows(); ii++)
			SetCell(ii, COL_CHECK_BOX, bCheck);
	}
	///---Sim 06-02-2009 QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE
#ifdef EXTRACT_WKS_SUPPORT_AUTO_UPDATE
	void EnableCheck(int nRow = -1, bool bEnable = true)
	{
		uint nColor = bEnable ? COLOR_BLACK : COLOR_GRAY;
		
		if(nRow > -1)
		{
			SetCellColor(nRow, COL_CHECK_BOX, COLOR_BLACK, nColor);
			return;
		}
		for(int ii = GetRowOffset(); ii < GetRows(); ii++)
			SetCellColor(ii, COL_CHECK_BOX, COLOR_BLACK, nColor);
	}
#endif // EXTRACT_WKS_SUPPORT_AUTO_UPDATE	
	///---END QA80-4584 EXTRACT_WKS_SUPPORT_AUTO_UPDATE
	
	int GetColsWidth()
	{
		int nTotal;
		for(int nCol = 0; nCol < GetCols(); nCol++)
		{
			if(!IsColHidden(nCol))
				nTotal += TwipsToPixels( GetColWidth(nCol) );
		}
		return nTotal;
	}
///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
protected:
	virtual string	GetClassName() { return "ColumnList"; }
///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
};

///////////////////////////////////////////////////////////////////////////
#define COL_PROPERTIES_ALIAS	COL_PROPERTIES_SHORT_NAME

class ColVarList : public ColumnListBase
{
public:
	ColVarList()
	{
	}
	
	void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName = NULL, LPCSTR lpcszName = NULL)//, const string& strRegForDlgInfo, int nMakePlotExVal, int nXErrID, int nPosNegErrID, int naddRowToParamterCntrNumForX, int nPageNames, int nShowAllCols)
	{
		ColumnListBase::Init(nID, dlg, lpcszDlgName, lpcszName);
		//Show Col: Alias(Short Name), Long Name, Size, Min, Man and Median		
		HideCol(-1);
		vector<uint> vnIndex = {COL_PROPERTIES_ALIAS, 
								COL_PROPERTIES_LONG_NAME//, 
								//COL_PROPERTIES_SIZE,
								//COL_PROPERTIES_MIN,
								//COL_PROPERTIES_MAX,
								//COL_PROPERTIES_MEDIAN
								};
		m_vnIndex = vnIndex;
		for(int ii = 0; ii < m_vnIndex.GetSize(); ii++)
			HideCol(vnIndex[ii], false);

		InitColsWidthFromReg();		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	}

	virtual BOOL OnDestroy() { return ColumnListBase::OnDestroy(); }	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	
	void SetColHeading()
	{	
		ColumnListBase::SetColHeading();
		SetColHeading(COL_PROPERTIES_ALIAS, _L("Alias"));
		SetColHeading(COL_PROPERTIES_LONG_NAME, _L("Column"));
	}
	///Jasmine 11/26/09 AUTO_CORRECT_INVALID_ALIAS_WHEN_ADD_FROM_COLUMN_LIST
	//int AddRow(int nCol, string& strAlias)
	int AddRow(int nCol, string& strAlias, bool bAutoCorrect = false)
	///End AUTO_CORRECT_INVALID_ALIAS_WHEN_ADD_FROM_COLUMN_LIST
	{
		if(!m_wks.IsValid())
			return -1;
		int nRow = IsInList(nCol+1);
		if(nRow> -1)//IsInList(nCol+1) > -1)//already in grid list
		{
			strAlias = GetCell(nRow, COL_PROPERTIES_ALIAS);
			return nRow;//IsInList(nCol+1)
		}
		Column col(m_wks, nCol);
		if(!col.IsValid())
			return -1;
		
		//string strAlias(lpcszAlias);
		
		int nNewRow = GetRows();
		SetRows(nNewRow);
		//index, hidden, 1 offset
		SetCell(nNewRow, COL_PROPERTIES_INDEX, nCol+1);
		//alias
		string strName = get_column_name(col);
		if(!lstrlen(strAlias))
		{
			//col.GetName(strAlias);  ///Joe 07/28/06 1ST_CHAR_LNAME_ALIAS
			///Jasmine 07/27/06 1ST_CHAR_SNAME_ALIAS
			///Joe 07/28/06 1ST_CHAR_LNAME_ALIAS
			//string strPrefix = strAlias.Left(1);
			string strPrefix = strName.Left(1);
			///End 1ST_CHAR_LNAME_ALIAS
			
			///Jasmine 06/10/08 QA80-11668 WE_CANNOT_USE_NON_ASCII_ALPHA_LONGNAME
			if( !is_good_C_identifier(strPrefix, 0) )
			{
				string strSName = get_column_name(col, false);
				strPrefix = strSName.Left(1);
			}
			///End WE_CANNOT_USE_NON_ASCII_ALPHA_LONGNAME
		
			///Jasmine 11/26/09 AUTO_CORRECT_INVALID_ALIAS_WHEN_ADD_FROM_COLUMN_LIST
			strAlias = strPrefix;
			bAutoCorrect = true;	
			///End AUTO_CORRECT_INVALID_ALIAS_WHEN_ADD_FROM_COLUMN_LIST
		}
		
		///Jasmine 11/26/09 AUTO_CORRECT_INVALID_ALIAS_WHEN_ADD_FROM_COLUMN_LIST
		if(bAutoCorrect)
		{
			okutil_check_add_mangle_to_numeric_short_name(&strAlias);
			
			if( !is_good_C_identifier(strAlias, 0) )
			{
				strAlias.MakeValidCName('C'); 
			}
			
			///Kyle 08/01/08 GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
			//int nNum = get_list_enum_number(m_vsAlias, strPrefix);
			vector<string> vstmp;
			GetReservedNamesList(vstmp);
			vstmp.Append(m_vsAlias);
			int nNum = get_list_enum_number(vstmp, strAlias);
			///End GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
			if(nNum)
				strAlias += (string)nNum;
		}
		///End AUTO_CORRECT_INVALID_ALIAS_WHEN_ADD_FROM_COLUMN_LIST
		
		SetCell(nNewRow, COL_PROPERTIES_ALIAS, strAlias);
		m_vsAlias.Add(strAlias);
		///End 1ST_CHAR_SNAME_ALIAS
		//name
		SetCell(nNewRow, COL_PROPERTIES_LONG_NAME, strName);	
		//size, min, max and median
		//get_min_max_median is not ready yet
		/*
		int nSize;
		string strMin, strMax, strMedian;
		nSize = col.GetUpperBound() + 1;
		get_min_max_median(m_wks, nCol + 1, strMin, strMax, strMedian);
		SetCell(nNewRow, COL_PROPERTIES_SIZE, nSize);
		SetCell(nNewRow, COL_PROPERTIES_MIN, strMin);
		SetCell(nNewRow, COL_PROPERTIES_MAX, strMax); 
		SetCell(nNewRow, COL_PROPERTIES_MEDIAN, strMedian); 
		*/
		return nNewRow;
	}
	///Jasmine 07/27/06 1ST_CHAR_SNAME_ALIAS
	void RemoveRows(vector<int> vnRows)
	{
		for(int ii = vnRows.GetSize() - 1; ii >= 0 ; ii--)
		{
			int nn = vnRows[ii]-1;
			m_vsAlias.RemoveAt(nn);
		}
		ColumnListBase::RemoveRows(vnRows);
	}
	void ClearAll()
	{
		GridControl::ClearAll();
		m_vsAlias.RemoveAll();
	}

public:
	void BeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		if(nCol != COL_PROPERTIES_ALIAS)
		{
			*pCancel = true;
			return;
		}
		m_strOldAlias = GetCell(nRow, nCol);
	}
	void AfterEdit(Control flxControl, int nRow, int nCol)
	{
		if(nCol != COL_PROPERTIES_ALIAS)
			return;
		string strNewAlias = GetCell(nRow, nCol);
		///Jasmine 08/07/06 CHECK_ALIAS_IS_GOOD
		Window Wnd = GetWindow();
		int nRowConflict = CheckAliasReused(strNewAlias, nRow);
		if(!is_good_C_identifier(strNewAlias, 0))
			MessageBox(Wnd.GetSafeHwnd(), strNewAlias + ": "+_L("invalid name!"), _L("Attention!"), MB_OK);
		///End CHECK_ALIAS_IS_GOOD
		///Kyle 08/01/08 GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
		//if(nRowConflict == -1)
		bool bInReservedList = IsInReservedNamesList(strNewAlias);
		if(nRowConflict == -1 && !bInReservedList)
		///End GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
		{
			m_vsAlias[nRow-1] = strNewAlias;///Jasmine 07/27/06 1ST_CHAR_SNAME_ALIAS
			return;
		}
		//if(!Wnd)
			//Wnd = GetWindow();
		///Kyle 08/01/08 GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
		//MessageBox(Wnd.GetSafeHwnd(), strNewAlias + " "+_L("is in use!"), _L("Attention!"), MB_OK);
		if(bInReservedList)
			MessageBox(Wnd.GetSafeHwnd(), strNewAlias + " "+_L("is reserved labtalk variable name!"), _L("Attention!"), MB_OK);
		else
			MessageBox(Wnd.GetSafeHwnd(), strNewAlias + " "+_L("is in use!"), _L("Attention!"), MB_OK);
		///End GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
		SetCell(nRow, nCol, m_strOldAlias);
		
	}	
	int IsInList(int nIndex)
	{
		for(int nRow = GetRowOffset(); nRow < GetRows(); nRow++)
		{
			if( nIndex == GetColumnIndex(nRow) )
				return nRow;
		}
		return -1;
	}
	//check the alias in each row except nCurRow
	//return row number if find, else return -1
	int CheckAliasReused(LPCSTR lpcszAlias, int nCurRow = -1)
	{
		string strAlias(lpcszAlias);
		for(int nRow = GetRowOffset(); nRow < GetRows(); nRow++)
		{
			if(nRow == nCurRow)
				continue;
			if(!strAlias.CompareNoCase( GetCell(nRow, COL_PROPERTIES_ALIAS) ))
				return nRow;
		}
		return -1;
	}
///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
protected:
	virtual string	GetClassName() { return "ColVarList"; }
///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
private:
	///Kyle 08/01/08 GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
	int GetReservedNamesList(vector<string>& vsName)
	{
		vsName.SetSize(0);
		vsName.Add("i");
		return vsName.GetSize();
	}
	bool IsInReservedNamesList(string strName)
	{
		vector<string> vsName;
		if(GetReservedNamesList(vsName)<=0)
			return false;
		if(vsName.Find(strName)>=0)
			return true;
		return false;
	}
	///End GET_RESERVED_NAMES_LIST_AND_CHECK_IF_STRING_IN_RESERVED_NAMES_LIST
	string			m_strOldAlias;
	vector<string>	m_vsAlias;	///Jasmine 07/27/06 1ST_CHAR_SNAME_ALIAS
};

//--- CPY 9/25/06, I see linking problem, global function should not be in header
/*
bool get_min_max_median(Worksheet wks, int iCol, string& strMin, string& strMax, string& strMedian)
{
	WorksheetPage wp;
	wp.Create("origin");//, CREATE_HIDDEN);
	
	string strLT, strSource, strTarget;
	Page pg = wks.GetPage() ;
	if(!pg.IsValid())
		return false;
	Column col;
	col.Attach(wks, iCol-1);
	if(!col.IsValid())
		return false;
	strSource = pg.GetName() + "_" + col.GetName();
	strTarget = wp.GetName() + "_A";
	strLT.Format("copy %s %s", strSource, strTarget);
	LT_execute(strLT);
	
	strLT.Format("sort -c 1 1 %s", strTarget);
	LT_execute(strLT);
	
	Worksheet wksCopy(wp.Layers(0));
	if(!wksCopy.IsValid())
		return false;
	col.Attach(wksCopy, 0);
	if(!col.IsValid())
		return false;
	int nLast = col.GetUpperBound();
	wksCopy.GetCell(0, 0, strMin);
	wksCopy.GetCell(nLast, 0, strMax); 
	wksCopy.GetCell(nLast/2, 0, strMedian); 	
	
	wp.Destroy();
	return true;
}

bool is_good_identifier(string str)
{
	BOOL bRet = is_good_C_identifier(str, 0);
	return bRet;
}
*/
